/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class SysexMessage
extends MidiMessage {
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;

    public SysexMessage() {
        this(new byte[2]);
        this.data[0] = -16;
        this.data[1] = -9;
    }

    public SysexMessage(byte[] data, int length) throws InvalidMidiDataException {
        super(null);
        this.setMessage(data, length);
    }

    public SysexMessage(int status, byte[] data, int length) throws InvalidMidiDataException {
        super(null);
        this.setMessage(status, data, length);
    }

    protected SysexMessage(byte[] data) {
        super(data);
    }

    @Override
    public void setMessage(byte[] data, int length) throws InvalidMidiDataException {
        int status = data[0] & 0xFF;
        if (status != 240 && status != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: 0x" + Integer.toHexString(status));
        }
        super.setMessage(data, length);
    }

    public void setMessage(int status, byte[] data, int length) throws InvalidMidiDataException {
        if (status != 240 && status != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: 0x" + Integer.toHexString(status));
        }
        if (length < 0 || length > data.length) {
            throw new IndexOutOfBoundsException("length out of bounds: " + length);
        }
        this.length = length + 1;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        this.data[0] = (byte)(status & 0xFF);
        if (length > 0) {
            System.arraycopy(data, 0, this.data, 1, length);
        }
    }

    public byte[] getData() {
        byte[] returnedArray = new byte[this.length - 1];
        System.arraycopy(this.data, 1, returnedArray, 0, this.length - 1);
        return returnedArray;
    }

    @Override
    public Object clone() {
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, 0, newData, 0, newData.length);
        return new SysexMessage(newData);
    }
}

