/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaBorder;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class AquaFocusHandler
implements FocusListener,
PropertyChangeListener {
    private boolean wasTemporary = false;
    private boolean repaintBorder = false;
    protected static final String FRAME_ACTIVE_PROPERTY = "Frame.active";
    static final PropertyChangeListener REPAINT_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JComponent) {
                ((JComponent)source).repaint();
            }
        }
    };

    @Override
    public void focusGained(FocusEvent ev) {
        if (!this.wasTemporary || this.repaintBorder) {
            AquaBorder.repaintBorder((JComponent)ev.getSource());
            this.repaintBorder = false;
        }
        this.wasTemporary = false;
    }

    @Override
    public void focusLost(FocusEvent ev) {
        this.wasTemporary = ev.isTemporary();
        if (!this.wasTemporary) {
            AquaBorder.repaintBorder((JComponent)ev.getSource());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (!FRAME_ACTIVE_PROPERTY.equals(ev.getPropertyName())) {
            return;
        }
        if (Boolean.TRUE.equals(ev.getNewValue())) {
            this.repaintBorder = true;
        } else if (this.wasTemporary) {
            AquaBorder.repaintBorder((JComponent)ev.getSource());
        }
    }

    protected static boolean isActive(JComponent c) {
        if (c == null) {
            return true;
        }
        Object activeObj = c.getClientProperty(FRAME_ACTIVE_PROPERTY);
        return !Boolean.FALSE.equals(activeObj);
    }

    protected static void install(JComponent c) {
        c.addPropertyChangeListener(FRAME_ACTIVE_PROPERTY, REPAINT_LISTENER);
    }

    protected static void uninstall(JComponent c) {
        c.removePropertyChangeListener(FRAME_ACTIVE_PROPERTY, REPAINT_LISTENER);
    }

    static void swapSelectionColors(String prefix, JTree c, Object value) {
    }

    static void swapSelectionColors(String prefix, JTable c, Object value) {
        if (!AquaFocusHandler.isComponentValid(c)) {
            return;
        }
        Color bg = c.getSelectionBackground();
        Color fg = c.getSelectionForeground();
        if (!(bg instanceof UIResource) || !(fg instanceof UIResource)) {
            return;
        }
        if (Boolean.FALSE.equals(value)) {
            AquaFocusHandler.setSelectionColors(c, "Table.selectionInactiveForeground", "Table.selectionInactiveBackground");
            return;
        }
        if (Boolean.TRUE.equals(value)) {
            AquaFocusHandler.setSelectionColors(c, "Table.selectionForeground", "Table.selectionBackground");
            return;
        }
    }

    static void setSelectionColors(JTable c, String fgName, String bgName) {
        c.setSelectionForeground(UIManager.getColor(fgName));
        c.setSelectionBackground(UIManager.getColor(bgName));
    }

    static void swapSelectionColors(String prefix, JList<?> c, Object value) {
        if (!AquaFocusHandler.isComponentValid(c)) {
            return;
        }
        Color bg = c.getSelectionBackground();
        Color fg = c.getSelectionForeground();
        if (!(bg instanceof UIResource) || !(fg instanceof UIResource)) {
            return;
        }
        if (Boolean.FALSE.equals(value)) {
            AquaFocusHandler.setSelectionColors(c, "List.selectionInactiveForeground", "List.selectionInactiveBackground");
            return;
        }
        if (Boolean.TRUE.equals(value)) {
            AquaFocusHandler.setSelectionColors(c, "List.selectionForeground", "List.selectionBackground");
            return;
        }
    }

    static void setSelectionColors(JList<?> c, String fgName, String bgName) {
        c.setSelectionForeground(UIManager.getColor(fgName));
        c.setSelectionBackground(UIManager.getColor(bgName));
    }

    static boolean isComponentValid(JComponent c) {
        if (c == null) {
            return false;
        }
        Window window = SwingUtilities.getWindowAncestor(c);
        return window != null;
    }
}

