/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaComboBoxUI;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

class AquaComboBoxButton
extends JButton {
    protected final JComboBox<Object> comboBox;
    protected final JList<?> list;
    protected final CellRendererPane rendererPane;
    protected final AquaComboBoxUI ui;
    protected final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());
    boolean isPopDown;
    boolean isSquare;

    protected AquaComboBoxButton(AquaComboBoxUI ui, JComboBox<Object> comboBox, CellRendererPane rendererPane, JList<?> list) {
        super("");
        this.putClientProperty("JButton.buttonType", "comboboxInternal");
        this.ui = ui;
        this.comboBox = comboBox;
        this.rendererPane = rendererPane;
        this.list = list;
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() ? true : armed);
            }
        });
        this.setEnabled(comboBox.isEnabled());
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox == null ? true : this.comboBox.isEnabled();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    protected void setIsPopDown(boolean isPopDown) {
        this.isPopDown = isPopDown;
        this.repaint();
    }

    protected void setIsSquare(boolean isSquare) {
        this.isSquare = isSquare;
        this.repaint();
    }

    protected JRSUIConstants.State getState(ButtonModel buttonModel) {
        if (!this.comboBox.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!AquaFocusHandler.isActive(this.comboBox)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (buttonModel.isArmed()) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean editable = this.comboBox.isEditable();
        int top = 0;
        int left = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.comboBox.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(this.comboBox);
        ((JRSUIState)this.painter.state).set(size == null ? JRSUIConstants.Size.REGULAR : size);
        ButtonModel buttonModel = this.getModel();
        ((JRSUIState)this.painter.state).set(this.getState(buttonModel));
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        if (AquaComboBoxUI.isTableCellEditor(this.comboBox)) {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.RIGHT);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_POP_UP);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.ArrowsOnly.YES);
            this.painter.paint(g, this, left, top, width, height);
            this.doRendererPaint(g, buttonModel, editable, this.getInsets(), left, top, width, height);
            return;
        }
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
        Insets insets = this.getInsets();
        if (!editable) {
            top += insets.top;
            left += insets.left;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (height <= 0 || width <= 0) {
            return;
        }
        boolean hasFocus = this.comboBox.hasFocus();
        if (editable) {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_COMBO_BOX);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.IndicatorOnly.YES);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.LEFT);
            hasFocus |= this.comboBox.getEditor().getEditorComponent().hasFocus();
        } else {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.IndicatorOnly.NO);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
            if (this.isPopDown) {
                ((JRSUIState)this.painter.state).set(this.isSquare ? JRSUIConstants.Widget.BUTTON_POP_DOWN_SQUARE : JRSUIConstants.Widget.BUTTON_POP_DOWN);
            } else {
                ((JRSUIState)this.painter.state).set(this.isSquare ? JRSUIConstants.Widget.BUTTON_POP_UP_SQUARE : JRSUIConstants.Widget.BUTTON_POP_UP);
            }
        }
        ((JRSUIState)this.painter.state).set(hasFocus ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        if (this.isSquare) {
            this.painter.paint(g, this.comboBox, left + 2, top - 1, width - 4, height);
        } else {
            this.painter.paint(g, this.comboBox, left, top, width, height);
        }
        if (!editable && this.comboBox != null) {
            this.doRendererPaint(g, buttonModel, editable, insets, left, top, width, height);
        }
    }

    protected void doRendererPaint(Graphics g, ButtonModel buttonModel, boolean editable, Insets insets, int left, int top, int width, int height) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.list, this.comboBox.getSelectedItem(), -1, false, false);
        if (!editable && !AquaComboBoxUI.isTableCellEditor(this.comboBox)) {
            int indentLeft = 10;
            int buttonWidth = 24;
            ++top;
            height -= 4;
            left += 10;
            width -= 34;
        }
        c.setFont(this.rendererPane.getFont());
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            if (this.isOpaque()) {
                c.setBackground(UIManager.getColor("Button.select"));
            }
            c.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        } else {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        boolean iconWidth = false;
        int cWidth = width - (insets.right + 0);
        top = height / 2 - 8;
        height = 19;
        Color bg = c.getBackground();
        boolean inhibitBackground = bg instanceof UIResource;
        if (inhibitBackground) {
            c.setBackground(new Color(0, 0, 0, 0));
        }
        this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height, shouldValidate);
        if (inhibitBackground) {
            c.setBackground(bg);
        }
    }
}

