/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public abstract class AquaButtonBorder
extends AquaBorder
implements Border,
UIResource {
    private static final AquaUtils.RecyclableSingleton<Dynamic> fDynamic = new AquaUtils.RecyclableSingletonFromDefaultConstructor<Dynamic>(Dynamic.class);
    private static final AquaUtils.RecyclableSingleton<Toggle> fToggle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<Toggle>(Toggle.class);
    private static final AquaUtils.RecyclableSingleton<Toolbar> fToolBar = new AquaUtils.RecyclableSingletonFromDefaultConstructor<Toolbar>(Toolbar.class);
    private static final AquaUtils.RecyclableSingleton<Named> fBevel = new AquaUtils.RecyclableSingleton<Named>(){

        @Override
        protected Named getInstance() {
            return new Named(JRSUIConstants.Widget.BUTTON_BEVEL, new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(2, 4, 2, 4)));
        }
    };

    public static AquaButtonBorder getDynamicButtonBorder() {
        return fDynamic.get();
    }

    public static AquaButtonBorder getToggleButtonBorder() {
        return fToggle.get();
    }

    public static Border getToolBarButtonBorder() {
        return fToolBar.get();
    }

    public static AquaButtonBorder getBevelButtonBorder() {
        return fBevel.get();
    }

    public AquaButtonBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
        super(sizeDescriptor);
    }

    public AquaButtonBorder(AquaButtonBorder other) {
        super(other);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public void paintButton(Component c, Graphics g, int x, int y, int width, int height) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        JRSUIConstants.State state = this.getButtonState(b, model);
        ((JRSUIState)this.painter.state).set(state);
        ((JRSUIState)this.painter.state).set(state != JRSUIConstants.State.DISABLED && state != JRSUIConstants.State.INACTIVE && b.isFocusPainted() && this.isFocused(b) ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        Insets subInsets = this.sizeVariant.insets;
        this.doButtonPaint(b, model, g, x += subInsets.left, y += subInsets.top, width -= subInsets.left + subInsets.right, height -= subInsets.top + subInsets.bottom);
    }

    protected void doButtonPaint(AbstractButton b, ButtonModel model, Graphics g, int x, int y, int width, int height) {
        this.painter.paint(g, b, x, y, width, height);
    }

    protected JRSUIConstants.State getButtonState(AbstractButton b, ButtonModel model) {
        if (!b.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!AquaFocusHandler.isActive(b)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (model.isArmed() && model.isPressed()) {
            return JRSUIConstants.State.PRESSED;
        }
        if (model.isSelected() && this.isSelectionPressing()) {
            return JRSUIConstants.State.PRESSED;
        }
        if (b instanceof JButton && ((JButton)b).isDefaultButton()) {
            return JRSUIConstants.State.PULSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected boolean isSelectionPressing() {
        return true;
    }

    public boolean hasSmallerInsets(JComponent c) {
        Insets margin = this.sizeVariant.margins;
        Insets inset = c.getInsets();
        if (margin.equals(inset)) {
            return false;
        }
        return inset.top < margin.top || inset.left < margin.left || inset.right < margin.right || inset.bottom < margin.bottom;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c == null || !(c instanceof AbstractButton)) {
            return new Insets(0, 0, 0, 0);
        }
        Insets margin = ((AbstractButton)c).getMargin();
        margin = margin == null ? new InsetsUIResource(0, 0, 0, 0) : (Insets)margin.clone();
        margin.top += this.sizeVariant.margins.top;
        margin.bottom += this.sizeVariant.margins.bottom;
        margin.left += this.sizeVariant.margins.left;
        margin.right += this.sizeVariant.margins.right;
        return margin;
    }

    public Insets getContentInsets(AbstractButton b, int w, int h) {
        return null;
    }

    public void alterPreferredSize(Dimension d) {
        if (this.sizeVariant.h > 0 && this.sizeVariant.h > d.height) {
            d.height = this.sizeVariant.h;
        }
        if (this.sizeVariant.w > 0 && this.sizeVariant.w > d.width) {
            d.width = this.sizeVariant.w;
        }
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static class Toolbar
    extends AquaButtonBorder {
        public Toolbar() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(5, 5, 5, 5)));
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.TOOLBAR_ITEM_WELL);
        }

        public Toolbar(Toolbar other) {
            super(other);
        }

        @Override
        protected void doButtonPaint(AbstractButton b, ButtonModel model, Graphics g, int x, int y, int w, int h) {
            if (!model.isSelected()) {
                return;
            }
            super.doButtonPaint(b, model, g, x, y, w, h);
        }
    }

    public static class Named
    extends AquaButtonBorder {
        public Named(JRSUIConstants.Widget widget, AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            super(sizeDescriptor);
            ((JRSUIState)this.painter.state).set(widget);
        }

        public Named(Named sizeDescriptor) {
            super(sizeDescriptor);
        }

        @Override
        protected void doButtonPaint(AbstractButton b, ButtonModel model, Graphics g, int x, int y, int width, int height) {
            ((JRSUIState)this.painter.state).set(model.isSelected() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
            super.doButtonPaint(b, model, g, x, y, width, height);
        }
    }

    public static class Toggle
    extends AquaButtonBorder {
        public Toggle() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(6, 6, 6, 6)));
        }

        public Toggle(Toggle other) {
            super(other);
        }

        @Override
        protected void doButtonPaint(AbstractButton b, ButtonModel model, Graphics g, int x, int y, int width, int height) {
            if (height < 23 || width < 16) {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_BEVEL);
                super.doButtonPaint(b, model, g, x, y, width, height);
                return;
            }
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_BEVEL_ROUND);
            super.doButtonPaint(b, model, g, x, y + 1, width, height - 1);
        }
    }

    public static class Dynamic
    extends AquaButtonBorder {
        final Insets ALTERNATE_PUSH_INSETS = new Insets(3, 12, 5, 12);
        final Insets ALTERNATE_BEVEL_INSETS = new Insets(0, 5, 0, 5);
        final Insets ALTERNATE_SQUARE_INSETS = new Insets(0, 2, 0, 2);

        public Dynamic() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(75, 29).alterMargins(3, 20, 5, 20)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant v) {
                    return super.deriveSmall(v.alterMinSize(0, -2).alterMargins(0, -3, 0, -3).alterInsets(-3, -3, -4, -3));
                }

                @Override
                public AquaUtilControlSize.SizeVariant deriveMini(AquaUtilControlSize.SizeVariant v) {
                    return super.deriveMini(v.alterMinSize(0, -2).alterMargins(0, -3, 0, -3).alterInsets(-3, -3, -1, -3));
                }
            });
        }

        public Dynamic(Dynamic other) {
            super(other);
        }

        @Override
        protected JRSUIConstants.State getButtonState(AbstractButton b, ButtonModel model) {
            JRSUIConstants.State state = super.getButtonState(b, model);
            ((JRSUIState)this.painter.state).set(state == JRSUIConstants.State.PULSED ? JRSUIConstants.Animating.YES : JRSUIConstants.Animating.NO);
            return state;
        }

        @Override
        public Insets getContentInsets(AbstractButton b, int width, int height) {
            JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(b);
            JRSUIConstants.Widget style = this.getStyleForSize(b, size, width, height);
            if (style == JRSUIConstants.Widget.BUTTON_PUSH) {
                return this.ALTERNATE_PUSH_INSETS;
            }
            if (style == JRSUIConstants.Widget.BUTTON_BEVEL_ROUND) {
                return this.ALTERNATE_BEVEL_INSETS;
            }
            if (style == JRSUIConstants.Widget.BUTTON_BEVEL) {
                return this.ALTERNATE_SQUARE_INSETS;
            }
            return null;
        }

        @Override
        protected void doButtonPaint(AbstractButton b, ButtonModel model, Graphics g, int x, int y, int width, int height) {
            JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(b);
            ((JRSUIState)this.painter.state).set(size);
            JRSUIConstants.Widget style = this.getStyleForSize(b, size, width, height);
            ((JRSUIState)this.painter.state).set(style);
            if (style == JRSUIConstants.Widget.BUTTON_PUSH && y % 2 == 0) {
                if (size == JRSUIConstants.Size.REGULAR) {
                    ++y;
                    --height;
                }
                if (size == JRSUIConstants.Size.MINI) {
                    --height;
                    x += 4;
                    width -= 8;
                }
            }
            super.doButtonPaint(b, model, g, x, y, width, height);
        }

        protected JRSUIConstants.Widget getStyleForSize(AbstractButton b, JRSUIConstants.Size size, int width, int height) {
            if (size != null && size != JRSUIConstants.Size.REGULAR) {
                return JRSUIConstants.Widget.BUTTON_PUSH;
            }
            if (height < 23 || width < 16) {
                return JRSUIConstants.Widget.BUTTON_BEVEL;
            }
            if (height <= 32 && width < 40) {
                return JRSUIConstants.Widget.BUTTON_BEVEL;
            }
            if (height > 32 || b.getIcon() != null || this.hasSmallerInsets(b)) {
                return JRSUIConstants.Widget.BUTTON_BEVEL_ROUND;
            }
            return JRSUIConstants.Widget.BUTTON_PUSH;
        }
    }

    static class SizeConstants {
        protected static final int fNormalButtonHeight = 29;
        protected static final int fNormalMinButtonWidth = 40;
        protected static final int fSquareButtonHeightThreshold = 23;
        protected static final int fSquareButtonWidthThreshold = 16;

        SizeConstants() {
        }
    }
}

