/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.paged_data;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.paged_data.FinishableStream;
import org.exbin.auxiliary.paged_data.PagedData;
import org.exbin.auxiliary.paged_data.SeekableStream;

@ParametersAreNonnullByDefault
public class PagedDataOutputStream
extends OutputStream
implements SeekableStream,
FinishableStream {
    @Nonnull
    private final PagedData data;
    private long position = 0L;

    public PagedDataOutputStream(PagedData data) {
        this.data = data;
    }

    @Override
    public void write(int value) throws IOException {
        long dataSize = this.data.getDataSize();
        if (this.position == dataSize) {
            this.data.setDataSize(++dataSize);
        }
        this.data.setByte(this.position++, (byte)value);
    }

    @Override
    public void write(byte[] input, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        long dataSize = this.data.getDataSize();
        if (this.position + (long)len > dataSize) {
            this.data.setDataSize(this.position + (long)len);
        }
        int length = len;
        int offset = off;
        while (length > 0) {
            int srcPos;
            byte[] page = this.data.getPage((int)(this.position / (long)this.data.getPageSize()));
            int copyLength = page.length - (srcPos = (int)(this.position % (long)this.data.getPageSize()));
            if (copyLength > length) {
                copyLength = length;
            }
            if (copyLength == 0) {
                return;
            }
            System.arraycopy(input, offset, page, srcPos, copyLength);
            length -= copyLength;
            this.position += (long)copyLength;
            offset += copyLength;
        }
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public long getStreamSize() {
        return this.data.getDataSize();
    }

    @Override
    public long getProcessedSize() {
        return this.position;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }
}

