/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.paged_data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.paged_data.BinaryData;
import org.exbin.auxiliary.paged_data.ByteArrayData;
import org.exbin.auxiliary.paged_data.DataOverflowException;
import org.exbin.auxiliary.paged_data.DataPage;
import org.exbin.auxiliary.paged_data.DataPageProvider;
import org.exbin.auxiliary.paged_data.EditableBinaryData;
import org.exbin.auxiliary.paged_data.OutOfBoundsException;
import org.exbin.auxiliary.paged_data.PagedDataInputStream;
import org.exbin.auxiliary.paged_data.PagedDataOutputStream;

@ParametersAreNonnullByDefault
public class PagedData
implements EditableBinaryData {
    public static final int DEFAULT_PAGE_SIZE = 4096;
    public static final long MAX_DATA_SIZE = Long.MAX_VALUE;
    private int pageSize = 4096;
    @Nonnull
    private final List<DataPage> data = new ArrayList<DataPage>();
    @Nullable
    private DataPageProvider dataPageProvider = null;

    public PagedData() {
    }

    public PagedData(DataPageProvider dataPageProvider) {
        this.dataPageProvider = dataPageProvider;
    }

    public PagedData(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public long getDataSize() {
        return (this.data.size() > 1 ? (this.data.size() - 1) * this.pageSize : 0) + (this.data.size() > 0 ? this.data.get(this.data.size() - 1).getDataLength() : 0);
    }

    @Override
    public void setDataSize(long size) {
        block6: {
            long dataSize;
            block5: {
                if (size < 0L) {
                    throw new InvalidParameterException("Size cannot be negative");
                }
                dataSize = this.getDataSize();
                if (size <= dataSize) break block5;
                int lastPage = (int)(dataSize / (long)this.pageSize);
                int lastPageSize = (int)(dataSize % (long)this.pageSize);
                long remaining = size - dataSize;
                if (lastPageSize > 0) {
                    byte[] page = this.getPage(lastPage);
                    int nextPageSize = remaining + (long)lastPageSize > (long)this.pageSize ? this.pageSize : (int)remaining + lastPageSize;
                    byte[] newPage = new byte[nextPageSize];
                    System.arraycopy(page, 0, newPage, 0, lastPageSize);
                    this.setPage(lastPage, this.createNewPage(newPage));
                    remaining -= (long)(nextPageSize - lastPageSize);
                    ++lastPage;
                }
                while (remaining > 0L) {
                    int nextPageSize = remaining > (long)this.pageSize ? this.pageSize : (int)remaining;
                    this.data.add(this.createNewPage(new byte[nextPageSize]));
                    remaining -= (long)nextPageSize;
                }
                break block6;
            }
            if (size >= dataSize) break block6;
            int lastPage = (int)(size / (long)this.pageSize);
            int lastPageSize = (int)(size % (long)this.pageSize);
            if (lastPageSize > 0) {
                byte[] page = this.getPage(lastPage);
                byte[] newPage = new byte[lastPageSize];
                System.arraycopy(page, 0, newPage, 0, lastPageSize);
                this.setPage(lastPage, this.createNewPage(newPage));
                ++lastPage;
            }
            for (int pageIndex = this.data.size() - 1; pageIndex >= lastPage; --pageIndex) {
                this.data.remove(pageIndex);
            }
        }
    }

    @Override
    public byte getByte(long position) {
        byte[] page = this.getPage((int)(position / (long)this.pageSize));
        try {
            return page[(int)(position % (long)this.pageSize)];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public void setByte(long position, byte value) {
        byte[] page = this.getPage((int)(position / (long)this.pageSize));
        try {
            page[(int)(position % (long)this.pageSize)] = value;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public void insertUninitialized(long startFrom, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length of inserted block must be nonnegative");
        }
        if (startFrom < 0L) {
            throw new IllegalArgumentException("Position of inserted block must be nonnegative");
        }
        long dataSize = this.getDataSize();
        if (startFrom > dataSize) {
            throw new OutOfBoundsException("Inserted block must be inside or directly after existing data");
        }
        if (length > Long.MAX_VALUE - this.getDataSize()) {
            throw new DataOverflowException("Maximum array size overflow");
        }
        if (startFrom >= dataSize) {
            this.setDataSize(startFrom + length);
        } else if (length > 0L) {
            long copyLength = dataSize - startFrom;
            this.setDataSize(dataSize += length);
            long sourceEnd = dataSize - length;
            long targetEnd = dataSize;
            while (copyLength > 0L) {
                int copySize;
                byte[] sourcePage = this.getPage((int)(sourceEnd / (long)this.pageSize));
                int sourceOffset = (int)(sourceEnd % (long)this.pageSize);
                if (sourceOffset == 0) {
                    sourcePage = this.getPage((int)((sourceEnd - 1L) / (long)this.pageSize));
                    sourceOffset = sourcePage.length;
                }
                byte[] targetPage = this.getPage((int)(targetEnd / (long)this.pageSize));
                int targetOffset = (int)(targetEnd % (long)this.pageSize);
                if (targetOffset == 0) {
                    targetPage = this.getPage((int)((targetEnd - 1L) / (long)this.pageSize));
                    targetOffset = targetPage.length;
                }
                int n = copySize = sourceOffset > targetOffset ? targetOffset : sourceOffset;
                if ((long)copySize > copyLength) {
                    copySize = (int)copyLength;
                }
                System.arraycopy(sourcePage, sourceOffset - copySize, targetPage, targetOffset - copySize, copySize);
                copyLength -= (long)copySize;
                sourceEnd -= (long)copySize;
                targetEnd -= (long)copySize;
            }
        }
    }

    @Override
    public void insert(long startFrom, long length) {
        this.insertUninitialized(startFrom, length);
        this.fillData(startFrom, length);
    }

    @Override
    public void insert(long startFrom, BinaryData insertedData) {
        long length = insertedData.getDataSize();
        this.insertUninitialized(startFrom, length);
        this.replace(startFrom, insertedData, 0L, length);
    }

    @Override
    public void insert(long startFrom, BinaryData insertedData, long insertedDataOffset, long insertedDataLength) {
        this.insertUninitialized(startFrom, insertedDataLength);
        this.replace(startFrom, insertedData, insertedDataOffset, insertedDataLength);
    }

    @Override
    public void insert(long startFrom, byte[] insertedData) {
        this.insert(startFrom, insertedData, 0, insertedData.length);
    }

    @Override
    public void insert(long startFrom, byte[] insertedData, int insertedDataOffset, int insertedDataLength) {
        if (insertedDataLength <= 0) {
            return;
        }
        this.insertUninitialized(startFrom, insertedDataLength);
        while (insertedDataLength > 0) {
            byte[] targetPage = this.getPage((int)(startFrom / (long)this.pageSize));
            int targetOffset = (int)(startFrom % (long)this.pageSize);
            int blockLength = this.pageSize - targetOffset;
            if (blockLength > insertedDataLength) {
                blockLength = insertedDataLength;
            }
            try {
                System.arraycopy(insertedData, insertedDataOffset, targetPage, targetOffset, blockLength);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new OutOfBoundsException(ex);
            }
            insertedDataOffset += blockLength;
            insertedDataLength -= blockLength;
            startFrom += (long)blockLength;
        }
    }

    @Override
    public long insert(long startFrom, InputStream inputStream, long dataSize) throws IOException {
        if (dataSize > Long.MAX_VALUE - this.getDataSize()) {
            throw new DataOverflowException("Maximum array size overflow");
        }
        if (startFrom > this.getDataSize()) {
            this.setDataSize(startFrom);
        }
        long loadedData = 0L;
        int pageOffset = (int)(startFrom % (long)this.pageSize);
        byte[] buffer = new byte[this.pageSize];
        while (dataSize == -1L || dataSize > 0L) {
            int red;
            int dataToRead = this.pageSize - pageOffset;
            if (dataSize >= 0L && dataSize < (long)dataToRead) {
                dataToRead = (int)dataSize;
            }
            if (pageOffset > 0 && dataToRead > pageOffset) {
                dataToRead = pageOffset;
            }
            int redLength = 0;
            while (dataToRead > 0 && (red = inputStream.read(buffer, redLength, dataToRead)) != -1) {
                redLength += red;
                dataToRead -= red;
            }
            this.insert(startFrom, buffer, 0, redLength);
            startFrom += (long)redLength;
            dataSize -= (long)redLength;
            loadedData += (long)redLength;
            pageOffset = 0;
        }
        return loadedData;
    }

    @Override
    public void fillData(long startFrom, long length) {
        this.fillData(startFrom, length, (byte)0);
    }

    @Override
    public void fillData(long startFrom, long length, byte fill) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length of filled block must be nonnegative");
        }
        if (startFrom < 0L) {
            throw new IllegalArgumentException("Position of filler block must be nonnegative");
        }
        if (startFrom + length > this.getDataSize()) {
            throw new OutOfBoundsException("Filled block must be inside existing data");
        }
        while (length > 0L) {
            int pageOffset;
            byte[] page = this.getPage((int)(startFrom / (long)this.pageSize));
            int fillSize = page.length - (pageOffset = (int)(startFrom % (long)this.pageSize));
            if ((long)fillSize > length) {
                fillSize = (int)length;
            }
            Arrays.fill(page, pageOffset, pageOffset + fillSize, fill);
            length -= (long)fillSize;
            startFrom += (long)fillSize;
        }
    }

    @Override
    @Nonnull
    public PagedData copy() {
        PagedData targetData = new PagedData();
        targetData.insert(0L, this);
        return targetData;
    }

    @Override
    @Nonnull
    public PagedData copy(long startFrom, long length) {
        PagedData targetData = new PagedData();
        targetData.insertUninitialized(0L, length);
        targetData.replace(0L, this, startFrom, length);
        return targetData;
    }

    @Override
    public void copyToArray(long startFrom, byte[] target, int offset, int length) {
        while (length > 0) {
            byte[] page = this.getPage((int)(startFrom / (long)this.pageSize));
            int pageOffset = (int)(startFrom % (long)this.pageSize);
            int copySize = this.pageSize - pageOffset;
            if (copySize > length) {
                copySize = length;
            }
            try {
                System.arraycopy(page, pageOffset, target, offset, copySize);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new OutOfBoundsException(ex);
            }
            length -= copySize;
            offset += copySize;
            startFrom += (long)copySize;
        }
    }

    @Override
    public void remove(long startFrom, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length of removed block must be nonnegative");
        }
        if (startFrom < 0L) {
            throw new IllegalArgumentException("Position of removed block must be nonnegative");
        }
        if (startFrom + length > this.getDataSize()) {
            throw new OutOfBoundsException("Removed block must be inside existing data");
        }
        if (length > 0L) {
            this.replace(startFrom, this, startFrom + length, this.getDataSize() - startFrom - length);
            this.setDataSize(this.getDataSize() - length);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public int getPagesCount() {
        return this.data.size();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Nonnull
    public byte[] getPage(int pageIndex) {
        try {
            return this.data.get(pageIndex).getData();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    public void setPage(int pageIndex, DataPage dataPage) {
        try {
            this.data.set(pageIndex, dataPage);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public void replace(long targetPosition, BinaryData replacingData) {
        this.replace(targetPosition, replacingData, 0L, replacingData.getDataSize());
    }

    @Override
    public void replace(long targetPosition, BinaryData replacingData, long startFrom, long length) {
        if (targetPosition + length > this.getDataSize()) {
            throw new OutOfBoundsException("Data can be replaced only inside or at the end");
        }
        if (replacingData instanceof PagedData) {
            if (replacingData != this || startFrom > targetPosition || startFrom + length < targetPosition) {
                while (length > 0L) {
                    byte[] page = this.getPage((int)(targetPosition / (long)this.pageSize));
                    int offset = (int)(targetPosition % (long)this.pageSize);
                    byte[] sourcePage = ((PagedData)replacingData).getPage((int)(startFrom / (long)((PagedData)replacingData).getPageSize()));
                    int sourceOffset = (int)(startFrom % (long)((PagedData)replacingData).getPageSize());
                    int copySize = this.pageSize - offset;
                    if (copySize > ((PagedData)replacingData).getPageSize() - sourceOffset) {
                        copySize = ((PagedData)replacingData).getPageSize() - sourceOffset;
                    }
                    if ((long)copySize > length) {
                        copySize = (int)length;
                    }
                    try {
                        System.arraycopy(sourcePage, sourceOffset, page, offset, copySize);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new OutOfBoundsException(ex);
                    }
                    length -= (long)copySize;
                    targetPosition += (long)copySize;
                    startFrom += (long)copySize;
                }
            } else {
                targetPosition += length - 1L;
                startFrom += length - 1L;
                while (length > 0L) {
                    byte[] page = this.getPage((int)(targetPosition / (long)this.pageSize));
                    int upTo = (int)(targetPosition % (long)this.pageSize) + 1;
                    byte[] sourcePage = ((PagedData)replacingData).getPage((int)(startFrom / (long)((PagedData)replacingData).getPageSize()));
                    int copySize = upTo;
                    int sourceUpTo = (int)(startFrom % (long)((PagedData)replacingData).getPageSize()) + 1;
                    if (copySize > sourceUpTo) {
                        copySize = sourceUpTo;
                    }
                    if ((long)copySize > length) {
                        copySize = (int)length;
                    }
                    int offset = upTo - copySize;
                    int sourceOffset = sourceUpTo - copySize;
                    System.arraycopy(sourcePage, sourceOffset, page, offset, copySize);
                    length -= (long)copySize;
                    targetPosition -= (long)copySize;
                    startFrom -= (long)copySize;
                }
            }
        } else {
            while (length > 0L) {
                byte[] page = this.getPage((int)(targetPosition / (long)this.pageSize));
                int offset = (int)(targetPosition % (long)this.pageSize);
                int copySize = this.pageSize - offset;
                if ((long)copySize > length) {
                    copySize = (int)length;
                }
                replacingData.copyToArray(startFrom, page, offset, copySize);
                length -= (long)copySize;
                targetPosition += (long)copySize;
                startFrom += (long)copySize;
            }
        }
    }

    @Override
    public void replace(long targetPosition, byte[] replacingData) {
        this.replace(targetPosition, replacingData, 0, replacingData.length);
    }

    @Override
    public void replace(long targetPosition, byte[] replacingData, int replacingDataOffset, int length) {
        if (targetPosition + (long)length > this.getDataSize()) {
            throw new OutOfBoundsException("Data can be replaced only inside or at the end");
        }
        while (length > 0) {
            byte[] page = this.getPage((int)(targetPosition / (long)this.pageSize));
            int offset = (int)(targetPosition % (long)this.pageSize);
            int copySize = this.pageSize - offset;
            if (copySize > length) {
                copySize = length;
            }
            try {
                System.arraycopy(replacingData, replacingDataOffset, page, offset, copySize);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new OutOfBoundsException(ex);
            }
            length -= copySize;
            targetPosition += (long)copySize;
            replacingDataOffset += copySize;
        }
    }

    @Override
    public void loadFromStream(InputStream inputStream) throws IOException {
        int cnt;
        this.data.clear();
        byte[] buffer = new byte[this.pageSize];
        int offset = 0;
        while ((cnt = inputStream.read(buffer, offset, buffer.length - offset)) > 0) {
            if (cnt + offset < this.pageSize) {
                offset += cnt;
                continue;
            }
            this.data.add(this.createNewPage(buffer));
            buffer = new byte[this.pageSize];
            offset = 0;
        }
        if (offset > 0) {
            byte[] tail = new byte[offset];
            System.arraycopy(buffer, 0, tail, 0, offset);
            this.data.add(this.createNewPage(tail));
        }
    }

    @Override
    public void saveToStream(OutputStream outputStream) throws IOException {
        for (DataPage dataPage : this.data) {
            outputStream.write(dataPage.getData());
        }
    }

    @Override
    @Nonnull
    public OutputStream getDataOutputStream() {
        return new PagedDataOutputStream(this);
    }

    @Override
    @Nonnull
    public InputStream getDataInputStream() {
        return new PagedDataInputStream(this);
    }

    @Nonnull
    private DataPage createNewPage(byte[] pageData) {
        if (this.dataPageProvider != null) {
            return this.dataPageProvider.createPage(pageData);
        }
        return new ByteArrayData(pageData);
    }

    @Nullable
    public DataPageProvider getDataPageProvider() {
        return this.dataPageProvider;
    }

    public void setDataPageProvider(@Nullable DataPageProvider dataPageProvider) {
        this.dataPageProvider = dataPageProvider;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            if (obj instanceof BinaryData) {
                BinaryData other = (BinaryData)obj;
                long dataSize = this.getDataSize();
                if (other.getDataSize() != dataSize) {
                    return false;
                }
                int pageIndex = 0;
                int bufferSize = dataSize > (long)this.pageSize ? this.pageSize : (int)dataSize;
                byte[] buffer = new byte[bufferSize];
                int offset = 0;
                int remain = (int)dataSize;
                while (remain > 0) {
                    int length = remain > bufferSize ? bufferSize : remain;
                    other.copyToArray(offset, buffer, 0, length);
                    if (!Arrays.equals(this.data.get(pageIndex).getData(), 0, length, buffer, 0, length)) {
                        return false;
                    }
                    offset += length;
                    remain -= length;
                    ++pageIndex;
                }
                return true;
            }
            return false;
        }
        PagedData other = (PagedData)obj;
        long dataSize = this.getDataSize();
        if (other.getDataSize() != dataSize) {
            return false;
        }
        int pageIndex = 0;
        int otherPageIndex = 0;
        long offset = 0L;
        long remain = dataSize;
        while (remain > 0L) {
            int length;
            int pageOffset = (int)(offset % (long)this.pageSize);
            int otherPageOffset = (int)(offset % (long)other.pageSize);
            int n = length = remain > (long)(this.pageSize - pageOffset) ? this.pageSize - pageOffset : (int)remain;
            if (length > other.pageSize - otherPageOffset) {
                length = other.pageSize - otherPageOffset;
            }
            if (!Arrays.equals(this.data.get(pageIndex).getData(), pageOffset, pageOffset + length, other.data.get(otherPageIndex).getData(), otherPageOffset, otherPageOffset + length)) {
                return false;
            }
            offset += (long)length;
            remain -= (long)length;
            ++pageIndex;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getDataSize());
    }

    @Override
    public void dispose() {
    }
}

