/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.StringTokenizer;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HTML;

class FrameSetView
extends BoxView {
    String[] children = null;
    int[] percentChildren;
    int[] absoluteChildren;
    int[] relativeChildren;
    int percentTotals;
    int absoluteTotals;
    int relativeTotals;

    public FrameSetView(Element elem, int axis) {
        super(elem, axis);
    }

    private String[] parseRowColSpec(HTML.Attribute key) {
        int i;
        AttributeSet attributes = this.getElement().getAttributes();
        String spec = "*";
        if (attributes != null && attributes.getAttribute(key) != null) {
            spec = (String)attributes.getAttribute(key);
        }
        StringTokenizer tokenizer = new StringTokenizer(spec, ",");
        int nTokens = tokenizer.countTokens();
        int n = this.getViewCount();
        String[] items = new String[Math.max(nTokens, n)];
        for (i = 0; i < nTokens; ++i) {
            items[i] = tokenizer.nextToken().trim();
            if (!items[i].equals("100%")) continue;
            items[i] = "*";
        }
        while (i < items.length) {
            items[i] = "*";
            ++i;
        }
        return items;
    }

    private void init() {
        int i;
        this.children = this.getAxis() == 1 ? this.parseRowColSpec(HTML.Attribute.ROWS) : this.parseRowColSpec(HTML.Attribute.COLS);
        this.percentChildren = new int[this.children.length];
        this.relativeChildren = new int[this.children.length];
        this.absoluteChildren = new int[this.children.length];
        for (i = 0; i < this.children.length; ++i) {
            this.percentChildren[i] = -1;
            this.relativeChildren[i] = -1;
            this.absoluteChildren[i] = -1;
            if (this.children[i].endsWith("*")) {
                if (this.children[i].length() > 1) {
                    this.relativeChildren[i] = Integer.parseInt(this.children[i].substring(0, this.children[i].length() - 1).trim());
                    this.relativeTotals += this.relativeChildren[i];
                    continue;
                }
                this.relativeChildren[i] = 1;
                ++this.relativeTotals;
                continue;
            }
            if (this.children[i].indexOf(37) != -1) {
                this.percentChildren[i] = this.parseDigits(this.children[i]);
                this.percentTotals += this.percentChildren[i];
                continue;
            }
            String value = this.children[i].toLowerCase();
            if (value.endsWith("px")) {
                value = value.substring(0, value.length() - 2).trim();
            }
            this.absoluteChildren[i] = Integer.parseInt(value);
        }
        if (this.percentTotals > 100) {
            for (i = 0; i < this.percentChildren.length; ++i) {
                if (this.percentChildren[i] <= 0) continue;
                this.percentChildren[i] = this.percentChildren[i] * 100 / this.percentTotals;
            }
            this.percentTotals = 100;
        }
    }

    @Override
    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        if (this.children == null) {
            this.init();
        }
        SizeRequirements.calculateTiledPositions(targetSpan, null, this.getChildRequests(targetSpan, axis), offsets, spans);
    }

    protected SizeRequirements[] getChildRequests(int targetSpan, int axis) {
        int[] span = new int[this.children.length];
        this.spread(targetSpan, span);
        int n = this.getViewCount();
        SizeRequirements[] reqs = new SizeRequirements[n];
        int sIndex = 0;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            if (v instanceof FrameView || v instanceof FrameSetView) {
                reqs[i] = new SizeRequirements((int)v.getMinimumSpan(axis), span[sIndex], (int)v.getMaximumSpan(axis), 0.5f);
                ++sIndex;
                continue;
            }
            int min = (int)v.getMinimumSpan(axis);
            int pref = (int)v.getPreferredSpan(axis);
            int max = (int)v.getMaximumSpan(axis);
            float a = v.getAlignment(axis);
            reqs[i] = new SizeRequirements(min, pref, max, a);
        }
        return reqs;
    }

    private void spread(int targetSpan, int[] span) {
        block10: {
            int i;
            int remainingSpace;
            block9: {
                int i2;
                if (targetSpan == 0) {
                    return;
                }
                int tempSpace = 0;
                remainingSpace = targetSpan;
                for (i2 = 0; i2 < span.length; ++i2) {
                    if (this.absoluteChildren[i2] <= 0) continue;
                    span[i2] = this.absoluteChildren[i2];
                    remainingSpace -= span[i2];
                }
                tempSpace = remainingSpace;
                for (i2 = 0; i2 < span.length; ++i2) {
                    if (this.percentChildren[i2] > 0 && tempSpace > 0) {
                        span[i2] = this.percentChildren[i2] * tempSpace / 100;
                        remainingSpace -= span[i2];
                        continue;
                    }
                    if (this.percentChildren[i2] <= 0 || tempSpace > 0) continue;
                    span[i2] = targetSpan / span.length;
                    remainingSpace -= span[i2];
                }
                if (remainingSpace <= 0 || this.relativeTotals <= 0) break block9;
                for (i2 = 0; i2 < span.length; ++i2) {
                    if (this.relativeChildren[i2] <= 0) continue;
                    span[i2] = remainingSpace * this.relativeChildren[i2] / this.relativeTotals;
                }
                break block10;
            }
            if (remainingSpace <= 0) break block10;
            float vTotal = targetSpan - remainingSpace;
            float[] tempPercents = new float[span.length];
            remainingSpace = targetSpan;
            for (i = 0; i < span.length; ++i) {
                tempPercents[i] = (float)span[i] / vTotal * 100.0f;
                span[i] = (int)((float)targetSpan * tempPercents[i] / 100.0f);
                remainingSpace -= span[i];
            }
            i = 0;
            while (remainingSpace != 0) {
                if (remainingSpace < 0) {
                    int n = i++;
                    span[n] = span[n] - 1;
                    ++remainingSpace;
                } else {
                    int n = i++;
                    span[n] = span[n] + 1;
                    --remainingSpace;
                }
                if (i != span.length) continue;
                i = 0;
            }
        }
    }

    private int parseDigits(String mixedStr) {
        int result = 0;
        for (int i = 0; i < mixedStr.length(); ++i) {
            char ch = mixedStr.charAt(i);
            if (!Character.isDigit(ch)) continue;
            result = result * 10 + Character.digit(ch, 10);
        }
        return result;
    }
}

