/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;

public class ProgressMonitor
implements Accessible {
    private ProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private Object[] cancelOption = null;
    private Object message;
    private long T0;
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int min;
    private int max;
    protected AccessibleContext accessibleContext = null;
    private AccessibleContext accessibleJOptionPane = null;

    public ProgressMonitor(Component parentComponent, Object message, String note, int min, int max) {
        this(parentComponent, message, note, min, max, null);
    }

    private ProgressMonitor(Component parentComponent, Object message, String note, int min, int max, ProgressMonitor group) {
        this.min = min;
        this.max = max;
        this.parentComponent = parentComponent;
        this.cancelOption = new Object[1];
        this.cancelOption[0] = UIManager.getString("OptionPane.cancelButtonText");
        this.message = message;
        this.note = note;
        if (group != null) {
            this.root = group.root != null ? group.root : group;
            this.T0 = this.root.T0;
            this.dialog = this.root.dialog;
        } else {
            this.T0 = System.currentTimeMillis();
        }
    }

    public void setProgress(int nv) {
        if (nv >= this.max) {
            this.close();
        } else if (this.myBar != null) {
            this.myBar.setValue(nv);
        } else {
            int predictedCompletionTime;
            long T = System.currentTimeMillis();
            long dT = (int)(T - this.T0);
            if (dT >= (long)this.millisToDecideToPopup && (predictedCompletionTime = nv > this.min ? (int)(dT * (long)(this.max - this.min) / (long)(nv - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                this.myBar = new JProgressBar();
                this.myBar.setMinimum(this.min);
                this.myBar.setMaximum(this.max);
                this.myBar.setValue(nv);
                if (this.note != null) {
                    this.noteLabel = new JLabel(this.note);
                }
                this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                this.dialog = this.pane.createDialog(this.parentComponent, UIManager.getString("ProgressMonitor.progressText"));
                this.dialog.show();
            }
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int m) {
        if (this.myBar != null) {
            this.myBar.setMinimum(m);
        }
        this.min = m;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int m) {
        if (this.myBar != null) {
            this.myBar.setMaximum(m);
        }
        this.max = m;
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object v = this.pane.getValue();
        if (v == null) {
            return false;
        }
        return this.cancelOption.length == 1 && v.equals(this.cancelOption[0]) || v.equals(-1);
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String note) {
        this.note = note;
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
        }
    }

    public String getNote() {
        return this.note;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleProgressMonitor();
        }
        if (this.pane != null && this.accessibleJOptionPane == null && this.accessibleContext instanceof AccessibleProgressMonitor) {
            ((AccessibleProgressMonitor)this.accessibleContext).optionPaneCreated();
        }
        return this.accessibleContext;
    }

    protected class AccessibleProgressMonitor
    extends AccessibleContext
    implements AccessibleText,
    ChangeListener,
    PropertyChangeListener {
        private Object oldModelValue;

        protected AccessibleProgressMonitor() {
        }

        private void optionPaneCreated() {
            ProgressMonitor.this.accessibleJOptionPane = ((ProgressOptionPane)ProgressMonitor.this.pane).getAccessibleJOptionPane();
            if (ProgressMonitor.this.myBar != null) {
                ProgressMonitor.this.myBar.addChangeListener(this);
            }
            if (ProgressMonitor.this.noteLabel != null) {
                ProgressMonitor.this.noteLabel.addPropertyChangeListener(this);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e == null) {
                return;
            }
            if (ProgressMonitor.this.myBar != null) {
                Integer newModelValue = ProgressMonitor.this.myBar.getValue();
                this.firePropertyChange("AccessibleValue", this.oldModelValue, newModelValue);
                this.oldModelValue = newModelValue;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == ProgressMonitor.this.noteLabel && e.getPropertyName() == "text") {
                this.firePropertyChange("AccessibleText", null, 0);
            }
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleName();
            }
            return null;
        }

        @Override
        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleDescription();
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_MONITOR;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleStateSet();
            }
            return null;
        }

        @Override
        public Accessible getAccessibleParent() {
            return ProgressMonitor.this.dialog;
        }

        private AccessibleContext getParentAccessibleContext() {
            if (ProgressMonitor.this.dialog != null) {
                return ProgressMonitor.this.dialog.getAccessibleContext();
            }
            return null;
        }

        @Override
        public int getAccessibleIndexInParent() {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleIndexInParent();
            }
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            AccessibleContext ac = this.getPanelAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleChildrenCount();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            AccessibleContext ac = this.getPanelAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleChild(i);
            }
            return null;
        }

        private AccessibleContext getPanelAccessibleContext() {
            Container c;
            if (ProgressMonitor.this.myBar != null && (c = ProgressMonitor.this.myBar.getParent()) instanceof Accessible) {
                return c.getAccessibleContext();
            }
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getLocale();
            }
            return null;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleComponent();
            }
            return null;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            if (ProgressMonitor.this.myBar != null) {
                return ProgressMonitor.this.myBar.getAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (this.getNoteLabelAccessibleText() != null) {
                return this;
            }
            return null;
        }

        private AccessibleText getNoteLabelAccessibleText() {
            if (ProgressMonitor.this.noteLabel != null) {
                return ProgressMonitor.this.noteLabel.getAccessibleContext().getAccessibleText();
            }
            return null;
        }

        @Override
        public int getIndexAtPoint(Point p) {
            Point noteLabelPoint;
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null && this.sameWindowAncestor(ProgressMonitor.this.pane, ProgressMonitor.this.noteLabel) && (noteLabelPoint = SwingUtilities.convertPoint(ProgressMonitor.this.pane, p, ProgressMonitor.this.noteLabel)) != null) {
                return at.getIndexAtPoint(noteLabelPoint);
            }
            return -1;
        }

        @Override
        public Rectangle getCharacterBounds(int i) {
            Rectangle noteLabelRect;
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null && this.sameWindowAncestor(ProgressMonitor.this.pane, ProgressMonitor.this.noteLabel) && (noteLabelRect = at.getCharacterBounds(i)) != null) {
                return SwingUtilities.convertRectangle(ProgressMonitor.this.noteLabel, noteLabelRect, ProgressMonitor.this.pane);
            }
            return null;
        }

        private boolean sameWindowAncestor(Component src, Component dest) {
            if (src == null || dest == null) {
                return false;
            }
            return SwingUtilities.getWindowAncestor(src) == SwingUtilities.getWindowAncestor(dest);
        }

        @Override
        public int getCharCount() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCharCount();
            }
            return -1;
        }

        @Override
        public int getCaretPosition() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCaretPosition();
            }
            return -1;
        }

        @Override
        public String getAtIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getAtIndex(part, index);
            }
            return null;
        }

        @Override
        public String getAfterIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getAfterIndex(part, index);
            }
            return null;
        }

        @Override
        public String getBeforeIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getBeforeIndex(part, index);
            }
            return null;
        }

        @Override
        public AttributeSet getCharacterAttribute(int i) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCharacterAttribute(i);
            }
            return null;
        }

        @Override
        public int getSelectionStart() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectionStart();
            }
            return -1;
        }

        @Override
        public int getSelectionEnd() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectionEnd();
            }
            return -1;
        }

        @Override
        public String getSelectedText() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectedText();
            }
            return null;
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object messageList) {
            super(messageList, 1, -1, null, ProgressMonitor.this.cancelOption, null);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        @Override
        public JDialog createDialog(Component parentComponent, String title) {
            Window window = JOptionPane.getWindowForComponent(parentComponent);
            final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, false) : new JDialog((Dialog)window, title, false);
            if (window instanceof SwingUtilities.SharedOwnerFrame) {
                WindowListener ownerShutdownListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
                dialog.addWindowListener(ownerShutdownListener);
            }
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parentComponent);
            dialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                @Override
                public void windowClosing(WindowEvent we) {
                    ProgressOptionPane.this.setValue(ProgressMonitor.this.cancelOption[0]);
                }

                @Override
                public void windowActivated(WindowEvent we) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (dialog.isVisible() && event.getSource() == ProgressOptionPane.this && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            return dialog;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return ProgressMonitor.this.getAccessibleContext();
        }

        private AccessibleContext getAccessibleJOptionPane() {
            return super.getAccessibleContext();
        }
    }
}

