/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.MultiResolutionImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.peer.RobotPeer;
import sun.awt.AWTPermissions;
import sun.awt.ComponentFactory;
import sun.awt.SunToolkit;
import sun.awt.image.SunWritableRaster;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.SunGraphicsEnvironment;

public class Robot {
    private static final int MAX_DELAY = 60000;
    private RobotPeer peer;
    private boolean isAutoWaitForIdle = false;
    private int autoDelay = 0;
    private static int LEGAL_BUTTON_MASK = 0;
    private DirectColorModel screenCapCM = null;
    private transient Object anchor = new Object();
    private transient RobotDisposer disposer;

    public Robot() throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new AWTException("headless environment");
        }
        this.init(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public Robot(GraphicsDevice screen) throws AWTException {
        this.checkIsScreenDevice(screen);
        this.init(screen);
    }

    private void init(GraphicsDevice screen) throws AWTException {
        this.checkRobotAllowed();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof ComponentFactory) {
            this.peer = ((ComponentFactory)((Object)toolkit)).createRobot(this, screen);
            this.disposer = new RobotDisposer(this.peer);
            Disposer.addRecord(this.anchor, this.disposer);
        }
        Robot.initLegalButtonMask();
    }

    private static synchronized void initLegalButtonMask() {
        if (LEGAL_BUTTON_MASK != 0) {
            return;
        }
        int tmpMask = 0;
        if (Toolkit.getDefaultToolkit().areExtraMouseButtonsEnabled() && Toolkit.getDefaultToolkit() instanceof SunToolkit) {
            int buttonsNumber = ((SunToolkit)Toolkit.getDefaultToolkit()).getNumberOfButtons();
            for (int i = 0; i < buttonsNumber; ++i) {
                tmpMask |= InputEvent.getMaskForButton(i + 1);
            }
        }
        LEGAL_BUTTON_MASK = tmpMask |= 0x1C1C;
    }

    private void checkRobotAllowed() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(AWTPermissions.CREATE_ROBOT_PERMISSION);
        }
    }

    private void checkIsScreenDevice(GraphicsDevice device) {
        if (device == null || device.getType() != 0) {
            throw new IllegalArgumentException("not a valid screen device");
        }
    }

    public synchronized void mouseMove(int x, int y) {
        this.peer.mouseMove(x, y);
        this.afterEvent();
    }

    public synchronized void mousePress(int buttons) {
        this.checkButtonsArgument(buttons);
        this.peer.mousePress(buttons);
        this.afterEvent();
    }

    public synchronized void mouseRelease(int buttons) {
        this.checkButtonsArgument(buttons);
        this.peer.mouseRelease(buttons);
        this.afterEvent();
    }

    private void checkButtonsArgument(int buttons) {
        if ((buttons | LEGAL_BUTTON_MASK) != LEGAL_BUTTON_MASK) {
            throw new IllegalArgumentException("Invalid combination of button flags");
        }
    }

    public synchronized void mouseWheel(int wheelAmt) {
        this.peer.mouseWheel(wheelAmt);
        this.afterEvent();
    }

    public synchronized void keyPress(int keycode) {
        this.checkKeycodeArgument(keycode);
        this.peer.keyPress(keycode);
        this.afterEvent();
    }

    public synchronized void keyRelease(int keycode) {
        this.checkKeycodeArgument(keycode);
        this.peer.keyRelease(keycode);
        this.afterEvent();
    }

    private void checkKeycodeArgument(int keycode) {
        if (keycode == 0) {
            throw new IllegalArgumentException("Invalid key code");
        }
    }

    public synchronized Color getPixelColor(int x, int y) {
        AffineTransform tx = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
        x = (int)((double)x * tx.getScaleX());
        y = (int)((double)y * tx.getScaleY());
        Color color = new Color(this.peer.getRGBPixel(x, y));
        return color;
    }

    public synchronized BufferedImage createScreenCapture(Rectangle screenRect) {
        return this.createCompatibleImage(screenRect, false)[0];
    }

    public synchronized MultiResolutionImage createMultiResolutionScreenCapture(Rectangle screenRect) {
        return new BaseMultiResolutionImage(this.createCompatibleImage(screenRect, true));
    }

    private synchronized BufferedImage[] createCompatibleImage(Rectangle screenRect, boolean isHiDPI) {
        BufferedImage[] imageArray;
        Robot.checkScreenCaptureAllowed();
        Robot.checkValidRect(screenRect);
        if (this.screenCapCM == null) {
            this.screenCapCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        int[] bandmasks = new int[]{this.screenCapCM.getRedMask(), this.screenCapCM.getGreenMask(), this.screenCapCM.getBlueMask()};
        Toolkit.getDefaultToolkit().sync();
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        gc = SunGraphicsEnvironment.getGraphicsConfigurationAtPoint(gc, screenRect.getCenterX(), screenRect.getCenterY());
        AffineTransform tx = gc.getDefaultTransform();
        double uiScaleX = tx.getScaleX();
        double uiScaleY = tx.getScaleY();
        if (uiScaleX == 1.0 && uiScaleY == 1.0) {
            int[] pixels = this.peer.getRGBPixels(screenRect);
            DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
            bandmasks[0] = this.screenCapCM.getRedMask();
            bandmasks[1] = this.screenCapCM.getGreenMask();
            bandmasks[2] = this.screenCapCM.getBlueMask();
            WritableRaster raster = Raster.createPackedRaster(buffer, screenRect.width, screenRect.height, screenRect.width, bandmasks, null);
            SunWritableRaster.makeTrackable(buffer);
            BufferedImage highResolutionImage = new BufferedImage(this.screenCapCM, raster, false, null);
            imageArray = new BufferedImage[]{highResolutionImage};
        } else {
            int[] temppixels;
            int sX = (int)Math.floor((double)screenRect.x * uiScaleX);
            int sY = (int)Math.floor((double)screenRect.y * uiScaleY);
            int sWidth = (int)Math.ceil((double)screenRect.width * uiScaleX);
            int sHeight = (int)Math.ceil((double)screenRect.height * uiScaleY);
            Rectangle scaledRect = new Rectangle(sX, sY, sWidth, sHeight);
            int[] pixels = temppixels = this.peer.getRGBPixels(scaledRect);
            DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
            WritableRaster raster = Raster.createPackedRaster(buffer, scaledRect.width, scaledRect.height, scaledRect.width, bandmasks, null);
            SunWritableRaster.makeTrackable(buffer);
            BufferedImage highResolutionImage = new BufferedImage(this.screenCapCM, raster, false, null);
            BufferedImage lowResolutionImage = new BufferedImage(screenRect.width, screenRect.height, highResolutionImage.getType());
            Graphics2D g = lowResolutionImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(highResolutionImage, 0, 0, screenRect.width, screenRect.height, 0, 0, scaledRect.width, scaledRect.height, null);
            g.dispose();
            imageArray = !isHiDPI ? new BufferedImage[]{lowResolutionImage} : new BufferedImage[]{lowResolutionImage, highResolutionImage};
        }
        return imageArray;
    }

    private static void checkValidRect(Rectangle rect) {
        if (rect.width <= 0 || rect.height <= 0) {
            throw new IllegalArgumentException("Rectangle width and height must be > 0");
        }
    }

    private static void checkScreenCaptureAllowed() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(AWTPermissions.READ_DISPLAY_PIXELS_PERMISSION);
        }
    }

    private void afterEvent() {
        this.autoWaitForIdle();
        this.autoDelay();
    }

    public synchronized boolean isAutoWaitForIdle() {
        return this.isAutoWaitForIdle;
    }

    public synchronized void setAutoWaitForIdle(boolean isOn) {
        this.isAutoWaitForIdle = isOn;
    }

    private void autoWaitForIdle() {
        if (this.isAutoWaitForIdle) {
            this.waitForIdle();
        }
    }

    public synchronized int getAutoDelay() {
        return this.autoDelay;
    }

    public synchronized void setAutoDelay(int ms) {
        this.checkDelayArgument(ms);
        this.autoDelay = ms;
    }

    private void autoDelay() {
        this.delay(this.autoDelay);
    }

    public synchronized void delay(int ms) {
        this.checkDelayArgument(ms);
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ite) {
            ite.printStackTrace();
        }
    }

    private void checkDelayArgument(int ms) {
        if (ms < 0 || ms > 60000) {
            throw new IllegalArgumentException("Delay must be to 0 to 60,000ms");
        }
    }

    public synchronized void waitForIdle() {
        this.checkNotDispatchThread();
        SunToolkit.flushPendingEvents();
        ((SunToolkit)Toolkit.getDefaultToolkit()).realSync();
    }

    private void checkNotDispatchThread() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
    }

    public synchronized String toString() {
        String params = "autoDelay = " + this.getAutoDelay() + ", autoWaitForIdle = " + this.isAutoWaitForIdle();
        return this.getClass().getName() + "[ " + params + " ]";
    }

    static class RobotDisposer
    implements DisposerRecord {
        private final RobotPeer peer;

        public RobotDisposer(RobotPeer peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            if (this.peer != null) {
                this.peer.dispose();
            }
        }
    }
}

