/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuBarUI;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class AquaRootPaneUI
extends BasicRootPaneUI
implements AncestorListener,
WindowListener,
ContainerListener {
    private static final AquaUtils.RecyclableSingleton<AquaRootPaneUI> sRootPaneUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaRootPaneUI>(AquaRootPaneUI.class);
    static final int kDefaultButtonPaintDelayBetweenFrames = 50;
    JButton fCurrentDefaultButton = null;
    Timer fTimer = null;
    static final boolean sUseScreenMenuBar = AquaMenuBarUI.getScreenMenuBarProperty();

    public static ComponentUI createUI(JComponent c) {
        return sRootPaneUI.get();
    }

    @Override
    public void installUI(JComponent c) {
        JFrame frameParent;
        Color bg;
        Container parent;
        super.installUI(c);
        c.addAncestorListener(this);
        if (c.isShowing() && c.isEnabled()) {
            this.updateDefaultButton((JRootPane)c);
        }
        if ((parent = c.getParent()) != null && parent instanceof JFrame && ((bg = (frameParent = (JFrame)parent).getBackground()) == null || bg instanceof UIResource)) {
            frameParent.setBackground(UIManager.getColor("Panel.background"));
        }
        if (sUseScreenMenuBar) {
            JRootPane root = (JRootPane)c;
            root.addContainerListener(this);
            root.getLayeredPane().addContainerListener(this);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.stopTimer();
        c.removeAncestorListener(this);
        if (sUseScreenMenuBar) {
            JRootPane root = (JRootPane)c;
            root.removeContainerListener(this);
            root.getLayeredPane().removeContainerListener(this);
        }
        super.uninstallUI(c);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Window owningWindow;
        JMenuBar jmb;
        MenuBarUI mbui;
        if (e.getContainer() instanceof JRootPane) {
            JRootPane root = (JRootPane)e.getContainer();
            if (e.getChild() == root.getLayeredPane()) {
                JLayeredPane layered = root.getLayeredPane();
                layered.addContainerListener(this);
            }
        } else if (e.getChild() instanceof JMenuBar && (mbui = (jmb = (JMenuBar)e.getChild()).getUI()) instanceof AquaMenuBarUI && (owningWindow = SwingUtilities.getWindowAncestor(jmb)) != null && owningWindow instanceof JFrame) {
            ((AquaMenuBarUI)mbui).setScreenMenuBar((JFrame)owningWindow);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Window owningWindow;
        JMenuBar jmb;
        MenuBarUI mbui;
        if (e.getContainer() instanceof JRootPane) {
            JRootPane root = (JRootPane)e.getContainer();
            if (e.getChild() == root.getLayeredPane()) {
                JLayeredPane layered = root.getLayeredPane();
                layered.removeContainerListener(this);
            }
        } else if (e.getChild() instanceof JMenuBar && (mbui = (jmb = (JMenuBar)e.getChild()).getUI()) instanceof AquaMenuBarUI && (owningWindow = SwingUtilities.getWindowAncestor(jmb)) != null && owningWindow instanceof JFrame) {
            ((AquaMenuBarUI)mbui).clearScreenMenuBar((JFrame)owningWindow);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JRootPane root;
        super.propertyChange(e);
        String prop = e.getPropertyName();
        if ("defaultButton".equals(prop) || "temporaryDefaultButton".equals(prop)) {
            JRootPane root2 = (JRootPane)e.getSource();
            if (root2.isShowing() && root2.isEnabled()) {
                this.updateDefaultButton(root2);
            }
        } else if (("enabled".equals(prop) || "Frame.active".equals(prop)) && (root = (JRootPane)e.getSource()).isShowing()) {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.updateDefaultButton((JRootPane)e.getSource());
            } else {
                this.stopTimer();
            }
        }
    }

    synchronized void stopTimer() {
        if (this.fTimer != null) {
            this.fTimer.stop();
            this.fTimer = null;
        }
    }

    synchronized void updateDefaultButton(JRootPane root) {
        JButton button;
        this.fCurrentDefaultButton = button = root.getDefaultButton();
        this.stopTimer();
        if (button != null) {
            this.fTimer = new Timer(50, new DefaultButtonPainter(root));
            this.fTimer.start();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        JRootPane rp;
        JComponent comp;
        JComponent ancestor = event.getComponent();
        Window owningWindow = SwingUtilities.getWindowAncestor(ancestor);
        if (owningWindow != null) {
            owningWindow.removeWindowListener(this);
            owningWindow.addWindowListener(this);
        }
        if ((comp = event.getComponent()) instanceof JRootPane && (rp = (JRootPane)comp).isEnabled() && rp.getDefaultButton() != null) {
            this.updateDefaultButton((JRootPane)comp);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        AquaRootPaneUI.updateComponentTreeUIActivation((Component)e.getSource(), Boolean.TRUE);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        AquaRootPaneUI.updateComponentTreeUIActivation((Component)e.getSource(), Boolean.FALSE);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        Window w = e.getWindow();
        w.removeWindowListener(this);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    private static void updateComponentTreeUIActivation(Component c, Object active) {
        if (c instanceof JInternalFrame) {
            Object object = active = ((JInternalFrame)c).isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (c instanceof JComponent) {
            ((JComponent)c).putClientProperty("Frame.active", active);
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children == null) {
            return;
        }
        for (Component element : children) {
            AquaRootPaneUI.updateComponentTreeUIActivation(element, active);
        }
    }

    @Override
    public final void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            AquaUtils.fillRect(g, c);
        }
        this.paint(g, c);
    }

    class DefaultButtonPainter
    implements ActionListener {
        JRootPane root;

        public DefaultButtonPainter(JRootPane root) {
            this.root = root;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton defaultButton = this.root.getDefaultButton();
            if (defaultButton != null && defaultButton.isShowing()) {
                if (defaultButton.isEnabled()) {
                    defaultButton.repaint();
                }
            } else {
                AquaRootPaneUI.this.stopTimer();
            }
        }
    }
}

