/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.plaf.UIResource;

public class AquaNativeResources {
    private static final AquaUtils.RecyclableSingleton<Color> sBackgroundColor;

    private static native long getWindowBackgroundColor();

    public static Color getWindowBackgroundColorUIResource() {
        return sBackgroundColor.get();
    }

    static BufferedImage getRadioButtonSizerImage() {
        BufferedImage img = new BufferedImage(20, 20, 3);
        Graphics g = img.getGraphics();
        g.setColor(Color.pink);
        g.fillRect(0, 0, 20, 20);
        g.dispose();
        return img;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osxui");
                return null;
            }
        });
        sBackgroundColor = new AquaUtils.RecyclableSingleton<Color>(){

            @Override
            protected Color getInstance() {
                long backgroundID = AquaNativeResources.getWindowBackgroundColor();
                return new CColorPaintUIResource(backgroundID, 238, 238, 238, 255);
            }
        };
    }

    static class CColorPaintUIResource
    extends Color
    implements UIResource {
        public CColorPaintUIResource(long color, int r, int g, int b, int a) {
            super(r, g, b, a);
        }
    }
}

