/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.ComponentModel;
import apple.awt.OSXSurfaceData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.peer.ContainerPeer;
import java.util.Vector;
import sun.awt.SunGraphicsCallback;
import sun.java2d.SurfaceData;

public abstract class ContainerModel
extends ComponentModel
implements ContainerPeer {
    private int isValidating = 0;
    Insets fInsets = new Insets(0, 0, 0, 0);

    ContainerModel(Component component) {
        super(component);
    }

    @Override
    protected void initPeer() {
        super.initPeer();
    }

    void initContainer() {
        this.fNSView = -1L;
    }

    @Override
    protected void disposeImpl() {
        super.disposeImpl();
    }

    @Override
    public Rectangle getBounds() {
        return ((Component)this.fTarget).getBounds();
    }

    @Override
    public void print(Graphics graphics) {
        if (this.fTarget instanceof Container) {
            super.print(graphics);
            SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.fTarget).getComponents(), graphics, 3);
        } else {
            ((Component)this.fTarget).print(graphics);
        }
    }

    public ContainerModel(Container container) {
        super(container);
    }

    @Override
    protected Rectangle getSurfaceBounds() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle(this.getInsets().left, this.getInsets().top, rectangle.width - this.getInsets().left, rectangle.height - this.getInsets().top);
    }

    @Override
    public Insets getInsets() {
        return this.fInsets;
    }

    @Override
    public void beginValidate() {
        if (this.isValidating == 0) {
            this._beginValidate(this.fModelPtr);
        }
        ++this.isValidating;
    }

    private native void _beginValidate(long var1);

    @Override
    public void endValidate() {
        --this.isValidating;
        if (this.isValidating == 0) {
            this._endValidate(this.fModelPtr);
        }
    }

    private native void _endValidate(long var1);

    public boolean isRestackSupported() {
        return true;
    }

    public void restack() {
        Vector vector = new Vector();
        Container container = (Container)this.fTarget;
        this.restack(container, vector);
        if (vector.size() > 0) {
            this._restack(this.fModelPtr, vector.toArray());
        }
    }

    private void restack(Container container, Vector vector) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isLightweight() && component.getPeer() != null) {
                vector.add(component.getPeer());
            }
            if (!component.isLightweight() || !(component instanceof Container)) continue;
            this.restack((Container)component, vector);
        }
    }

    private native void _restack(long var1, Object[] var3);

    public Insets insets() {
        return this.getInsets();
    }

    @Override
    public void setVisible(boolean bl) {
        SurfaceData surfaceData;
        if (!bl && (surfaceData = this.getSurfaceData()) instanceof OSXSurfaceData) {
            ((OSXSurfaceData)this.getSurfaceData()).clearLazyDrawing();
        }
        super.setVisible(bl);
    }
}

