<?php

namespace wcf\system\user\multifactor\email;

use wcf\system\form\builder\field\TDefaultIdFormField;
use wcf\system\form\builder\field\TextFormField;
use wcf\system\user\multifactor\EmailMultifactorMethod;
use wcf\system\user\multifactor\Helper;

/**
 * Handles the input of an email code.
 *
 * @author  Tim Duesterhus
 * @copyright   2001-2020 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @since   5.4
 */
final class CodeFormField extends TextFormField
{
    use TDefaultIdFormField;

    public function __construct()
    {
        $this->minimumLength(EmailMultifactorMethod::LENGTH);
        $this->maximumLength(EmailMultifactorMethod::LENGTH);
        $this->fieldAttribute('size', (string)EmailMultifactorMethod::LENGTH);
        $this->addFieldClass('multifactorEmailCode');
        $this->autoComplete('off');
        $this->inputMode('numeric');
        $this->pattern('[0-9]*');

        $placeholder = '';
        $gen = Helper::digitStream();
        for ($i = 0; $i < $this->getMinimumLength(); $i++) {
            $placeholder .= $gen->current();
            $gen->next();
        }
        $this->placeholder($placeholder);
    }

    /**
     * @inheritDoc
     */
    protected static function getDefaultId(): string
    {
        return 'code';
    }
}
