<?php

namespace wcf\system\database\table\column;

/**
 * Represents a `int` database table column with length `10` and whose values cannot be null.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @since   5.2
 */
final class NotNullInt10DatabaseTableColumn
{
    public static function create(string $name): IntDatabaseTableColumn
    {
        return IntDatabaseTableColumn::create($name)
            ->notNull()
            ->length(10);
    }

    private function __construct()
    {
    }
}
