<?php

namespace wcf\system\cache\builder;

use wcf\data\captcha\question\CaptchaQuestionList;

/**
 * Caches the enabled captcha questions.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */
class CaptchaQuestionCacheBuilder extends AbstractCacheBuilder
{
    /**
     * @inheritDoc
     */
    public function rebuild(array $parameters)
    {
        $questionList = new CaptchaQuestionList();
        $questionList->getConditionBuilder()->add('isDisabled = ?', [0]);
        $questionList->readObjects();

        return $questionList->getObjects();
    }
}
