<?php

namespace wcf\acp\page;

use wcf\page\AbstractGridViewPage;
use wcf\system\gridView\admin\TrophyGridView;

/**
 * Trophy list page.
 *
 * @author Olaf Braun, Joshua Ruesweg
 * @copyright 2001-2025 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @since 3.1
 *
 * @extends AbstractGridViewPage<TrophyGridView>
 */
final class TrophyListPage extends AbstractGridViewPage
{
    /**
     * @inheritDoc
     */
    public $activeMenuItem = 'wcf.acp.menu.link.trophy.list';

    /**
     * @inheritDoc
     */
    public $neededModules = ['MODULE_TROPHY'];

    /**
     * @inheritDoc
     */
    public $neededPermissions = ['admin.trophy.canManageTrophy'];

    #[\Override]
    protected function createGridView(): TrophyGridView
    {
        return new TrophyGridView();
    }
}
