/**
 * Data handler for an multiline item list form builder field in an Ajax form.
 *
 * @author      Olaf Braun
 * @copyright   2001-2024 WoltLab GmbH
 * @license     GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @since       6.0
 */

import Field from "WoltLabSuite/Core/Form/Builder/Field/Field";
import { FormBuilderData } from "WoltLabSuite/Core/Form/Builder/Data";
import { getValues } from "./Controller/MultilineItemList";

export class MultilineItemList extends Field {
  protected _getData(): FormBuilderData {
    return {
      [this._fieldId]: getValues(this._fieldId),
    };
  }
}
export default MultilineItemList;
