<?php

namespace wcf\system\form\builder\field;

/**
 * Implementation of a form field for an object description.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @since   5.2
 */
class DescriptionFormField extends MultilineTextFormField
{
    use TDefaultIdFormField;

    /**
     * Creates a new instance of `DescriptionFormField`.
     */
    public function __construct()
    {
        $this->label('wcf.global.description');
    }

    /**
     * @inheritDoc
     */
    protected static function getDefaultId()
    {
        return 'description';
    }
}
