/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.nio.ByteBuffer;
import sandbox.java.nio.CharBuffer;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.CharsetDecoder;
import sandbox.java.nio.charset.CharsetEncoder;
import sandbox.java.nio.charset.CoderResult;
import sandbox.java.nio.charset.CodingErrorAction;
import sandbox.java.nio.charset.StandardCharsets;
import sandbox.java.util.Arrays;
import sandbox.sun.nio.cs.ArrayDecoder;
import sandbox.sun.nio.cs.ArrayEncoder;

final class ZipCoder {
    private Charset cs;
    private CharsetDecoder dec;
    private CharsetEncoder enc;
    private boolean isUTF8;
    private ZipCoder utf8;

    String toString(byte[] byArray, int n) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.decoder:()Ljava/nio/charset/CharsetDecoder;");
        CharsetDecoder charsetDecoder = this.decoder();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetDecoder.reset:()Ljava/nio/charset/CharsetDecoder;");
        CharsetDecoder charsetDecoder2 = charsetDecoder.reset();
        float f = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetDecoder.maxCharsPerByte:()F");
        int n3 = n2 = (int)(f * charsetDecoder2.maxCharsPerByte());
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)2);
        char[] cArray = new char[n3];
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([C)V");
            return new String(cArray);
        }
        RuntimeCostAccounter.recordJump();
        if (this.isUTF8) {
            boolean bl = charsetDecoder2 instanceof ArrayDecoder;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                ArrayDecoder arrayDecoder = (ArrayDecoder)charsetDecoder2;
                RuntimeCostAccounter.recordMethodCall((String)"sun/nio/cs/ArrayDecoder.decode:([BII[C)I");
                int n4 = arrayDecoder.decode(byArray, 0, n, cArray);
                RuntimeCostAccounter.recordJump();
                if (n4 == -1) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MALFORMED");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([CII)V");
                return new String(cArray, 0, n4);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.wrap:([BII)Ljava/nio/ByteBuffer;");
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byArray, (int)0, (int)n);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.wrap:([C)Ljava/nio/CharBuffer;");
        CharBuffer charBuffer = CharBuffer.wrap((char[])cArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetDecoder.decode:(Ljava/nio/ByteBuffer;Ljava/nio/CharBuffer;Z)Ljava/nio/charset/CoderResult;");
        CoderResult coderResult = charsetDecoder2.decode(byteBuffer, charBuffer, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.isUnderflow:()Z");
        boolean bl = coderResult.isUnderflow();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.toString:()Ljava/lang/String;");
            String string = coderResult.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetDecoder.flush:(Ljava/nio/CharBuffer;)Ljava/nio/charset/CoderResult;");
        coderResult = charsetDecoder2.flush(charBuffer);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.isUnderflow:()Z");
        boolean bl2 = coderResult.isUnderflow();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.toString:()Ljava/lang/String;");
            String string = coderResult.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.position:()I");
        int n5 = charBuffer.position();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([CII)V");
        return new String(cArray, 0, n5);
    }

    String toString(byte[] byArray) {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toString:([BI)Ljava/lang/String;");
        return this.toString(byArray, n);
    }

    byte[] getBytes(String string) {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.encoder:()Ljava/nio/charset/CharsetEncoder;");
        CharsetEncoder charsetEncoder = this.encoder();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetEncoder.reset:()Ljava/nio/charset/CharsetEncoder;");
        CharsetEncoder charsetEncoder2 = charsetEncoder.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toCharArray:()[C");
        char[] cArray = string.toCharArray();
        float f = cArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetEncoder.maxBytesPerChar:()F");
        int n2 = n = (int)(f * charsetEncoder2.maxBytesPerChar());
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        byte[] byArray = new byte[n2];
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return byArray;
        }
        RuntimeCostAccounter.recordJump();
        if (this.isUTF8) {
            boolean bl = charsetEncoder2 instanceof ArrayEncoder;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                ArrayEncoder arrayEncoder = (ArrayEncoder)charsetEncoder2;
                int n3 = cArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"sun/nio/cs/ArrayEncoder.encode:([CII[B)I");
                int n4 = arrayEncoder.encode(cArray, 0, n3, byArray);
                RuntimeCostAccounter.recordJump();
                if (n4 == -1) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MALFORMED");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([BI)[B");
                return Arrays.copyOf(byArray, n4);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.wrap:([B)Ljava/nio/ByteBuffer;");
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.wrap:([C)Ljava/nio/CharBuffer;");
        CharBuffer charBuffer = CharBuffer.wrap((char[])cArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetEncoder.encode:(Ljava/nio/CharBuffer;Ljava/nio/ByteBuffer;Z)Ljava/nio/charset/CoderResult;");
        CoderResult coderResult = charsetEncoder2.encode(charBuffer, byteBuffer, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.isUnderflow:()Z");
        boolean bl = coderResult.isUnderflow();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.toString:()Ljava/lang/String;");
            String string2 = coderResult.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetEncoder.flush:(Ljava/nio/ByteBuffer;)Ljava/nio/charset/CoderResult;");
        coderResult = charsetEncoder2.flush(byteBuffer);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.isUnderflow:()Z");
        boolean bl2 = coderResult.isUnderflow();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CoderResult.toString:()Ljava/lang/String;");
            String string3 = coderResult.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:()I");
        int n5 = byteBuffer.position();
        int n6 = byArray.length;
        RuntimeCostAccounter.recordJump();
        if (n5 == n6) {
            return byArray;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:()I");
        int n7 = byteBuffer.position();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([BI)[B");
        return Arrays.copyOf(byArray, n7);
    }

    byte[] getBytesUTF8(String string) {
        RuntimeCostAccounter.recordJump();
        if (this.isUTF8) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
            return this.getBytes(string);
        }
        RuntimeCostAccounter.recordJump();
        if (this.utf8 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipCoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.<init>:(Ljava/nio/charset/Charset;)V");
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
        return this.utf8.getBytes(string);
    }

    String toStringUTF8(byte[] byArray, int n) {
        RuntimeCostAccounter.recordJump();
        if (this.isUTF8) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toString:([BI)Ljava/lang/String;");
            return this.toString(byArray, n);
        }
        RuntimeCostAccounter.recordJump();
        if (this.utf8 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipCoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.<init>:(Ljava/nio/charset/Charset;)V");
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toString:([BI)Ljava/lang/String;");
        return this.utf8.toString(byArray, n);
    }

    boolean isUTF8() {
        return this.isUTF8;
    }

    private ZipCoder(Charset charset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.cs = charset;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.name:()Ljava/lang/String;");
        String string = charset.name();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.name:()Ljava/lang/String;");
        String string2 = StandardCharsets.UTF_8.name();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        this.isUTF8 = string.equals(string2);
    }

    static ZipCoder get(Charset charset) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipCoder");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.<init>:(Ljava/nio/charset/Charset;)V");
        return new ZipCoder(charset);
    }

    private CharsetDecoder decoder() {
        RuntimeCostAccounter.recordJump();
        if (this.dec == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.newDecoder:()Ljava/nio/charset/CharsetDecoder;");
            CharsetDecoder charsetDecoder = this.cs.newDecoder();
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetDecoder.onMalformedInput:(Ljava/nio/charset/CodingErrorAction;)Ljava/nio/charset/CharsetDecoder;");
            CharsetDecoder charsetDecoder2 = charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetDecoder.onUnmappableCharacter:(Ljava/nio/charset/CodingErrorAction;)Ljava/nio/charset/CharsetDecoder;");
            this.dec = charsetDecoder2.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.dec;
    }

    private CharsetEncoder encoder() {
        RuntimeCostAccounter.recordJump();
        if (this.enc == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.newEncoder:()Ljava/nio/charset/CharsetEncoder;");
            CharsetEncoder charsetEncoder = this.cs.newEncoder();
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetEncoder.onMalformedInput:(Ljava/nio/charset/CodingErrorAction;)Ljava/nio/charset/CharsetEncoder;");
            CharsetEncoder charsetEncoder2 = charsetEncoder.onMalformedInput(CodingErrorAction.REPORT);
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/CharsetEncoder.onUnmappableCharacter:(Ljava/nio/charset/CodingErrorAction;)Ljava/nio/charset/CharsetEncoder;");
            this.enc = charsetEncoder2.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.enc;
    }
}

