/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Bits;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataInputStream;
import sandbox.java.io.EOFException;
import sandbox.java.io.Externalizable;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.InvalidClassException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.NotActiveException;
import sandbox.java.io.ObjectInput;
import sandbox.java.io.ObjectInputValidation;
import sandbox.java.io.ObjectStreamClass;
import sandbox.java.io.ObjectStreamConstants;
import sandbox.java.io.ObjectStreamField;
import sandbox.java.io.SerialCallbackContext;
import sandbox.java.io.StreamCorruptedException;
import sandbox.java.io.UTFDataFormatException;
import sandbox.java.security.AccessControlContext;
import sandbox.java.security.AccessController;
import sandbox.java.security.Permission;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.PrivilegedActionException;
import sandbox.java.security.PrivilegedExceptionAction;
import sandbox.java.util.Arrays;
import sandbox.java.util.HashMap;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.sun.misc.VM;
import sandbox.sun.reflect.misc.ReflectUtil;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker;
    private static final HashMap<String, Class<?>> primClasses;
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private int depth;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle;
    private boolean defaultDataEnd;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableResolve;
    private SerialCallbackContext curContext;

    public ObjectInputStream(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
        this.passHandle = -1;
        this.defaultDataEnd = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.verifySubclass:()V");
        this.verifySubclass();
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$BlockDataInputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.<init>:(Ljava/io/ObjectInputStream;Ljava/io/InputStream;)V");
        this.bin = new BlockDataInputStream(inputStream);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$HandleTable");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.<init>:(I)V");
        this.handles = new HandleTable(10);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$ValidationList");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList.<init>:()V");
        this.vlist = new ValidationList();
        this.enableOverride = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readStreamHeader:()V");
        this.readStreamHeader();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
        this.bin.setBlockDataMode(true);
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
        this.passHandle = -1;
        this.defaultDataEnd = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bin = null;
        this.handles = null;
        this.vlist = null;
        this.enableOverride = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        Object object;
        RuntimeCostAccounter.recordJump();
        if (this.enableOverride) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObjectOverride:()Ljava/lang/Object;");
            return this.readObjectOverride();
        }
        int n = this.passHandle;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
            Object object2 = this.readObject0(false);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markDependency:(II)V");
            this.handles.markDependency(n, this.passHandle);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            RuntimeCostAccounter.recordJump();
            if (classNotFoundException != null) {
                RuntimeCostAccounter.recordThrow();
                throw classNotFoundException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.depth == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList.doCallbacks:()V");
                this.vlist.doCallbacks();
            }
            object = object2;
            this.passHandle = n;
        }
        catch (Throwable throwable) {
            this.passHandle = n;
            RuntimeCostAccounter.recordJump();
            if (this.closed) {
                RuntimeCostAccounter.recordJump();
                if (this.depth == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.clear:()V");
                    this.clear();
                }
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordJump();
            if (this.depth == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.clear:()V");
                this.clear();
            }
        }
        return object;
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readUnshared() throws IOException, ClassNotFoundException {
        Object object;
        int n = this.passHandle;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
            Object object2 = this.readObject0(true);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markDependency:(II)V");
            this.handles.markDependency(n, this.passHandle);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            RuntimeCostAccounter.recordJump();
            if (classNotFoundException != null) {
                RuntimeCostAccounter.recordThrow();
                throw classNotFoundException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.depth == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList.doCallbacks:()V");
                this.vlist.doCallbacks();
            }
            object = object2;
            this.passHandle = n;
        }
        catch (Throwable throwable) {
            this.passHandle = n;
            RuntimeCostAccounter.recordJump();
            if (this.closed) {
                RuntimeCostAccounter.recordJump();
                if (this.depth == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.clear:()V");
                    this.clear();
                }
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordJump();
            if (this.depth == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.clear:()V");
                this.clear();
            }
        }
        return object;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        RuntimeCostAccounter.recordJump();
        if (serialCallbackContext == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/NotActiveException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/NotActiveException.<init>:(Ljava/lang/String;)V");
            NotActiveException notActiveException = new NotActiveException("not in call to readObject");
            RuntimeCostAccounter.recordThrow();
            throw notActiveException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getObj:()Ljava/lang/Object;");
        Object object = serialCallbackContext.getObj();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getDesc:()Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
        this.bin.setBlockDataMode(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadFields:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
        this.defaultReadFields(object, objectStreamClass);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
        this.bin.setBlockDataMode(true);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasWriteObjectData:()Z");
        boolean bl = objectStreamClass.hasWriteObjectData();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            this.defaultDataEnd = true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
        ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
        RuntimeCostAccounter.recordJump();
        if (classNotFoundException != null) {
            RuntimeCostAccounter.recordThrow();
            throw classNotFoundException;
        }
    }

    public GetField readFields() throws IOException, ClassNotFoundException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        RuntimeCostAccounter.recordJump();
        if (serialCallbackContext == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/NotActiveException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/NotActiveException.<init>:(Ljava/lang/String;)V");
            NotActiveException notActiveException = new NotActiveException("not in call to readObject");
            RuntimeCostAccounter.recordThrow();
            throw notActiveException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getObj:()Ljava/lang/Object;");
        Object object = serialCallbackContext.getObj();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getDesc:()Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
        this.bin.setBlockDataMode(false);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$GetFieldImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.<init>:(Ljava/io/ObjectInputStream;Ljava/io/ObjectStreamClass;)V");
        GetFieldImpl getFieldImpl = new GetFieldImpl(objectStreamClass);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.readFields:()V");
        getFieldImpl.readFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
        this.bin.setBlockDataMode(true);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasWriteObjectData:()Z");
        boolean bl = objectStreamClass.hasWriteObjectData();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            this.defaultDataEnd = true;
        }
        return getFieldImpl;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        RuntimeCostAccounter.recordJump();
        if (this.depth == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/NotActiveException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/NotActiveException.<init>:(Ljava/lang/String;)V");
            NotActiveException notActiveException = new NotActiveException("stream inactive");
            RuntimeCostAccounter.recordThrow();
            throw notActiveException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList.register:(Ljava/io/ObjectInputValidation;I)V");
        this.vlist.register(objectInputValidation, n);
    }

    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getName:()Ljava/lang/String;");
        String string = objectStreamClass.getName();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.latestUserDefinedLoader:()Ljava/lang/ClassLoader;");
            ClassLoader classLoader = ObjectInputStream.latestUserDefinedLoader();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            Class<?> clazz = primClasses.get(string);
            RuntimeCostAccounter.recordJump();
            if (clazz != null) {
                return clazz;
            }
            RuntimeCostAccounter.recordThrow();
            throw classNotFoundException;
        }
    }

    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.latestUserDefinedLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = ObjectInputStream.latestUserDefinedLoader();
        ClassLoader classLoader2 = null;
        boolean bl = false;
        int n = stringArray.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (true) {
            int n3 = stringArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            String string = stringArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
            Class<?> clazz = Class.forName(string, false, classLoader);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getModifiers:()I");
            int n4 = clazz.getModifiers() & 1;
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
                    ClassLoader classLoader3 = clazz.getClassLoader();
                    RuntimeCostAccounter.recordJump();
                    if (classLoader2 != classLoader3) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalAccessError");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalAccessError.<init>:(Ljava/lang/String;)V");
                        IllegalAccessError illegalAccessError = new IllegalAccessError("conflicting non-public interface class loaders");
                        RuntimeCostAccounter.recordThrow();
                        throw illegalAccessError;
                    }
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
                    classLoader2 = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[n2] = clazz;
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        try {
            ClassLoader classLoader4;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                classLoader4 = classLoader2;
                RuntimeCostAccounter.recordJump();
            } else {
                classLoader4 = classLoader;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Proxy.getProxyClass:(Ljava/lang/ClassLoader;[Ljava/lang/Class;)Ljava/lang/Class;");
            return Proxy.getProxyClass(classLoader4, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassNotFoundException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassNotFoundException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            ClassNotFoundException classNotFoundException = new ClassNotFoundException(null, illegalArgumentException);
            RuntimeCostAccounter.recordThrow();
            throw classNotFoundException;
        }
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        boolean bl2;
        RuntimeCostAccounter.recordJump();
        if (bl == this.enableResolve) {
            return bl;
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
            SecurityManager securityManager = System.getSecurityManager();
            RuntimeCostAccounter.recordJump();
            if (securityManager != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
                securityManager.checkPermission((Permission)SUBSTITUTION_PERMISSION);
            }
        }
        this.enableResolve = bl;
        RuntimeCostAccounter.recordJump();
        if (!this.enableResolve) {
            bl2 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl2 = false;
        }
        return bl2;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        block3: {
            short s;
            short s2;
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readShort:()S");
                s2 = this.bin.readShort();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readShort:()S");
                s = this.bin.readShort();
                RuntimeCostAccounter.recordJump();
                if (s2 != -21267) break block2;
                RuntimeCostAccounter.recordJump();
                if (s == 5) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Short.valueOf:(S)Ljava/lang/Short;");
            objectArray[0] = s2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Short.valueOf:(S)Ljava/lang/Short;");
            objectArray[1] = s;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            String string = String.format("invalid stream header: %04X%04X", objectArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamClass");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.<init>:()V");
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.readNonProxy:(Ljava/io/ObjectInputStream;)V");
        objectStreamClass.readNonProxy(this);
        return objectStreamClass;
    }

    @Override
    public int read() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.read:()I");
        return this.bin.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                int n3 = n + n2;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block4;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block4;
                int n4 = byArray.length;
                RuntimeCostAccounter.recordJump();
                if (n3 > n4) break block4;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.read:([BIIZ)I");
        return this.bin.read(byArray, n, n2, false);
    }

    @Override
    public int available() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.available:()I");
        return this.bin.available();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        RuntimeCostAccounter.recordJump();
        if (this.depth == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.clear:()V");
            this.clear();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.close:()V");
        this.bin.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readBoolean:()Z");
        return this.bin.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
        return this.bin.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUnsignedByte:()I");
        return this.bin.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readChar:()C");
        return this.bin.readChar();
    }

    @Override
    public short readShort() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readShort:()S");
        return this.bin.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUnsignedShort:()I");
        return this.bin.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readInt:()I");
        return this.bin.readInt();
    }

    @Override
    public long readLong() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readLong:()J");
        return this.bin.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFloat:()F");
        return this.bin.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readDouble:()D");
        return this.bin.readDouble();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFully:([BIIZ)V");
        this.bin.readFully(byArray, 0, n, false);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        block3: {
            block2: {
                int n3 = n + n2;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block2;
                int n4 = byArray.length;
                RuntimeCostAccounter.recordJump();
                if (n3 > n4) break block2;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFully:([BIIZ)V");
        this.bin.readFully(byArray, n, n2, false);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.skipBytes:(I)I");
        return this.bin.skipBytes(n);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readLine:()Ljava/lang/String;");
        return this.bin.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUTF:()Ljava/lang/String;");
        return this.bin.readUTF();
    }

    private void verifySubclass() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz == ObjectInputStream.class) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager == null) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.processQueue:(Ljava/lang/ref/ReferenceQueue;Ljava/util/concurrent/ConcurrentMap;)V");
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamClass$WeakClassKey");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass$WeakClassKey.<init>:(Ljava/lang/Class;Ljava/lang/ref/ReferenceQueue;)V");
        ObjectStreamClass.WeakClassKey weakClassKey = new ObjectStreamClass.WeakClassKey(clazz, Caches.subclassAuditsQueue);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Boolean bl = (Boolean)Caches.subclassAudits.get(weakClassKey);
        RuntimeCostAccounter.recordJump();
        if (bl == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.auditSubclass:(Ljava/lang/Class;)Z");
            boolean bl2 = ObjectInputStream.auditSubclass(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;");
            bl = bl2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            Caches.subclassAudits.putIfAbsent(weakClassKey, bl);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.booleanValue:()Z");
        boolean bl3 = bl;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
        securityManager.checkPermission((Permission)SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class<?> clazz) {
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$1.<init>:(Ljava/lang/Class;)V");
        PrivilegedAction<Boolean> privilegedAction = new PrivilegedAction<Boolean>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Boolean run() {
                Class clazz2 = clazz;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (clazz2 == ObjectInputStream.class) break;
                    try {
                        Class[] classArray = null;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredMethod:(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                        clazz2.getDeclaredMethod("readUnshared", classArray);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] classArray = null;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredMethod:(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                            clazz2.getDeclaredMethod("readFields", classArray);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSuperclass:()Ljava/lang/Class;");
                            clazz2 = clazz2.getSuperclass();
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                    }
                    break;
                }
                return Boolean.TRUE;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.booleanValue:()Z");
        return bl;
    }

    private void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.clear:()V");
        this.handles.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList.clear:()V");
        this.vlist.clear();
    }

    /*
     * Exception decompiling
     */
    private Object readObject0(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object checkResolve(Object object) throws IOException {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (!this.enableResolve) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
                ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
                RuntimeCostAccounter.recordJump();
                if (classNotFoundException == null) break block5;
            }
            return object;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.resolveObject:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object2 = this.resolveObject(object);
        RuntimeCostAccounter.recordJump();
        if (object2 != object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.setObject:(ILjava/lang/Object;)V");
            this.handles.setObject(this.passHandle, object2);
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readTypeString() throws IOException {
        byte by;
        int n = this.passHandle;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.peekByte:()B");
            by = this.bin.peekByte();
            switch (by) {
                case 112: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readNull:()Ljava/lang/Object;");
                    String string = (String)this.readNull();
                    this.passHandle = n;
                    return string;
                }
                case 113: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readHandle:(Z)Ljava/lang/Object;");
                    String string = (String)this.readHandle(false);
                    this.passHandle = n;
                    return string;
                }
                case 116: 
                case 124: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readString:(Z)Ljava/lang/String;");
                    String string = this.readString(false);
                    this.passHandle = n;
                    return string;
                }
            }
        }
        catch (Throwable throwable) {
            this.passHandle = n;
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        Object[] objectArray = new Object[1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.valueOf:(B)Ljava/lang/Byte;");
        objectArray[0] = by;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
        String string = String.format("invalid type code: %02X", objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
        StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
        RuntimeCostAccounter.recordThrow();
        throw streamCorruptedException;
    }

    private Object readNull() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
        byte by = this.bin.readByte();
        RuntimeCostAccounter.recordJump();
        if (by != 112) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
        this.passHandle = -1;
        return null;
    }

    private Object readHandle(boolean bl) throws IOException {
        block7: {
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                byte by = this.bin.readByte();
                RuntimeCostAccounter.recordJump();
                if (by != 113) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                    InternalError internalError = new InternalError();
                    RuntimeCostAccounter.recordThrow();
                    throw internalError;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readInt:()I");
                this.passHandle = this.bin.readInt() - 0x7E0000;
                RuntimeCostAccounter.recordJump();
                if (this.passHandle < 0) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.size:()I");
                int n = this.handles.size();
                RuntimeCostAccounter.recordJump();
                if (this.passHandle < n) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Object[] objectArray = new Object[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = this.passHandle + 0x7E0000;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            String string = String.format("invalid handle value: %08X", objectArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("cannot read back reference as unshared");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupObject:(I)Ljava/lang/Object;");
        Object object = this.handles.lookupObject(this.passHandle);
        RuntimeCostAccounter.recordJump();
        if (object == unsharedMarker) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("cannot read back reference to unshared object");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
        return object;
    }

    private Class<?> readClass(boolean bl) throws IOException {
        Class<?> clazz;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
        byte by = this.bin.readByte();
        RuntimeCostAccounter.recordJump();
        if (by != 118) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readClassDesc:(Z)Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
        Class<?> clazz2 = objectStreamClass.forClass();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            clazz = unsharedMarker;
            RuntimeCostAccounter.recordJump();
        } else {
            clazz = clazz2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.passHandle = this.handles.assign(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getResolveException:()Ljava/lang/ClassNotFoundException;");
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        RuntimeCostAccounter.recordJump();
        if (classNotFoundException != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.finish:(I)V");
        this.handles.finish(this.passHandle);
        return clazz2;
    }

    private ObjectStreamClass readClassDesc(boolean bl) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.peekByte:()B");
        byte by = this.bin.peekByte();
        switch (by) {
            case 112: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readNull:()Ljava/lang/Object;");
                return (ObjectStreamClass)this.readNull();
            }
            case 113: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readHandle:(Z)Ljava/lang/Object;");
                return (ObjectStreamClass)this.readHandle(bl);
            }
            case 125: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readProxyDesc:(Z)Ljava/io/ObjectStreamClass;");
                return this.readProxyDesc(bl);
            }
            case 114: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readNonProxyDesc:(Z)Ljava/io/ObjectStreamClass;");
                return this.readNonProxyDesc(bl);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        Object[] objectArray = new Object[1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.valueOf:(B)Ljava/lang/Byte;");
        objectArray[0] = by;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
        String string = String.format("invalid type code: %02X", objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
        StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
        RuntimeCostAccounter.recordThrow();
        throw streamCorruptedException;
    }

    private boolean isCustomSubclass() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = clazz.getClassLoader();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader2 = ObjectInputStream.class.getClassLoader();
        RuntimeCostAccounter.recordJump();
        if (classLoader != classLoader2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    private ObjectStreamClass readProxyDesc(boolean bl) throws IOException {
        ClassNotFoundException classNotFoundException;
        Class<?> clazz;
        int n;
        ObjectStreamClass objectStreamClass;
        block8: {
            int n2;
            Object object;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
            byte by = this.bin.readByte();
            RuntimeCostAccounter.recordJump();
            if (by != 125) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                InternalError internalError = new InternalError();
                RuntimeCostAccounter.recordThrow();
                throw internalError;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamClass");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.<init>:()V");
            objectStreamClass = new ObjectStreamClass();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                object = unsharedMarker;
                RuntimeCostAccounter.recordJump();
            } else {
                object = objectStreamClass;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.assign:(Ljava/lang/Object;)I");
            n = this.handles.assign(object);
            this.passHandle = -1;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readInt:()I");
            int n3 = n2 = this.bin.readInt();
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
            String[] stringArray = new String[n3];
            int n4 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUTF:()Ljava/lang/String;");
                stringArray[n4] = this.bin.readUTF();
                ++n4;
                RuntimeCostAccounter.recordJump();
            }
            clazz = null;
            classNotFoundException = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
            this.bin.setBlockDataMode(true);
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.resolveProxyClass:([Ljava/lang/String;)Ljava/lang/Class;");
                clazz = this.resolveProxyClass(stringArray);
                RuntimeCostAccounter.recordJump();
                if (clazz == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassNotFoundException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassNotFoundException.<init>:(Ljava/lang/String;)V");
                    classNotFoundException = new ClassNotFoundException("null class");
                    RuntimeCostAccounter.recordJump();
                    break block8;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Proxy.isProxyClass:(Ljava/lang/Class;)Z");
                boolean bl2 = Proxy.isProxyClass(clazz);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidClassException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.<init>:(Ljava/lang/String;)V");
                    InvalidClassException invalidClassException = new InvalidClassException("Not a proxy");
                    RuntimeCostAccounter.recordThrow();
                    throw invalidClassException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz2 = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = clazz2.getClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getInterfaces:()[Ljava/lang/Class;");
                Class[] classArray = clazz.getInterfaces();
                RuntimeCostAccounter.recordMethodCall((String)"sun/reflect/misc/ReflectUtil.checkProxyPackageAccess:(Ljava/lang/ClassLoader;[Ljava/lang/Class;)V");
                ReflectUtil.checkProxyPackageAccess((ClassLoader)classLoader, (Class[])classArray);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.skipCustomData:()V");
        this.skipCustomData();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readClassDesc:(Z)Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass2 = this.readClassDesc(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.initProxy:(Ljava/lang/Class;Ljava/lang/ClassNotFoundException;Ljava/io/ObjectStreamClass;)V");
        objectStreamClass.initProxy(clazz, classNotFoundException, objectStreamClass2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.finish:(I)V");
        this.handles.finish(n);
        this.passHandle = n;
        return objectStreamClass;
    }

    private ObjectStreamClass readNonProxyDesc(boolean bl) throws IOException {
        ClassNotFoundException classNotFoundException;
        Class<?> clazz;
        ObjectStreamClass objectStreamClass;
        int n;
        ObjectStreamClass objectStreamClass2;
        block8: {
            Object object;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
            byte by = this.bin.readByte();
            RuntimeCostAccounter.recordJump();
            if (by != 114) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                InternalError internalError = new InternalError();
                RuntimeCostAccounter.recordThrow();
                throw internalError;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamClass");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.<init>:()V");
            objectStreamClass2 = new ObjectStreamClass();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                object = unsharedMarker;
                RuntimeCostAccounter.recordJump();
            } else {
                object = objectStreamClass2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.assign:(Ljava/lang/Object;)I");
            n = this.handles.assign(object);
            this.passHandle = -1;
            objectStreamClass = null;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readClassDescriptor:()Ljava/io/ObjectStreamClass;");
                objectStreamClass = this.readClassDescriptor();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidClassException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.<init>:(Ljava/lang/String;)V");
                InvalidClassException invalidClassException = new InvalidClassException("failed to read class descriptor");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
                IOException iOException = (IOException)invalidClassException.initCause(classNotFoundException2);
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            RuntimeCostAccounter.recordJump();
            clazz = null;
            classNotFoundException = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
            this.bin.setBlockDataMode(true);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.isCustomSubclass:()Z");
            boolean bl2 = this.isCustomSubclass();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.resolveClass:(Ljava/io/ObjectStreamClass;)Ljava/lang/Class;");
                clazz = this.resolveClass(objectStreamClass);
                RuntimeCostAccounter.recordJump();
                if (clazz == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassNotFoundException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassNotFoundException.<init>:(Ljava/lang/String;)V");
                    classNotFoundException = new ClassNotFoundException("null class");
                    RuntimeCostAccounter.recordJump();
                    break block8;
                }
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"sun/reflect/misc/ReflectUtil.checkPackageAccess:(Ljava/lang/Class;)V");
                ReflectUtil.checkPackageAccess(clazz);
            }
            catch (ClassNotFoundException classNotFoundException3) {
                classNotFoundException = classNotFoundException3;
            }
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.skipCustomData:()V");
        this.skipCustomData();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readClassDesc:(Z)Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass3 = this.readClassDesc(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.initNonProxy:(Ljava/io/ObjectStreamClass;Ljava/lang/Class;Ljava/lang/ClassNotFoundException;Ljava/io/ObjectStreamClass;)V");
        objectStreamClass2.initNonProxy(objectStreamClass, clazz, classNotFoundException, objectStreamClass3);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.finish:(I)V");
        this.handles.finish(n);
        this.passHandle = n;
        return objectStreamClass2;
    }

    private String readString(boolean bl) throws IOException {
        Object object;
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
        byte by = this.bin.readByte();
        switch (by) {
            case 116: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUTF:()Ljava/lang/String;");
                string = this.bin.readUTF();
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 124: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readLongUTF:()Ljava/lang/String;");
                string = this.bin.readLongUTF();
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                Object[] objectArray = new Object[1];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.valueOf:(B)Ljava/lang/Byte;");
                objectArray[0] = by;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string2 = String.format("invalid type code: %02X", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
                StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string2);
                RuntimeCostAccounter.recordThrow();
                throw streamCorruptedException;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            object = unsharedMarker;
            RuntimeCostAccounter.recordJump();
        } else {
            object = string;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.passHandle = this.handles.assign(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.finish:(I)V");
        this.handles.finish(this.passHandle);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object readArray(boolean bl) throws IOException {
        int n;
        Object object;
        block12: {
            int n2;
            block14: {
                Class<?> clazz;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block13: {
                                        Object object2;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                                        byte by = this.bin.readByte();
                                        RuntimeCostAccounter.recordJump();
                                        if (by != 117) {
                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                                            InternalError internalError = new InternalError();
                                            RuntimeCostAccounter.recordThrow();
                                            throw internalError;
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readClassDesc:(Z)Ljava/io/ObjectStreamClass;");
                                        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readInt:()I");
                                        n2 = this.bin.readInt();
                                        object = null;
                                        clazz = null;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
                                        Class<?> clazz2 = objectStreamClass.forClass();
                                        RuntimeCostAccounter.recordJump();
                                        if (clazz2 != null) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
                                            clazz = clazz2.getComponentType();
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
                                            object = Array.newInstance(clazz, n2);
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        if (bl) {
                                            object2 = unsharedMarker;
                                            RuntimeCostAccounter.recordJump();
                                        } else {
                                            object2 = object;
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.assign:(Ljava/lang/Object;)I");
                                        n = this.handles.assign(object2);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getResolveException:()Ljava/lang/ClassNotFoundException;");
                                        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
                                        RuntimeCostAccounter.recordJump();
                                        if (classNotFoundException != null) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
                                            this.handles.markException(n, classNotFoundException);
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        if (clazz != null) break block13;
                                        int n3 = 0;
                                        while (true) {
                                            RuntimeCostAccounter.recordJump();
                                            if (n3 >= n2) break;
                                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
                                            this.readObject0(false);
                                            ++n3;
                                            RuntimeCostAccounter.recordJump();
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        break block12;
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isPrimitive:()Z");
                                    boolean bl2 = clazz.isPrimitive();
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl2) break block14;
                                    RuntimeCostAccounter.recordJump();
                                    if (clazz != Integer.TYPE) break block15;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readInts:([III)V");
                                    this.bin.readInts((int[])object, 0, n2);
                                    RuntimeCostAccounter.recordJump();
                                    break block12;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (clazz != Byte.TYPE) break block16;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFully:([BIIZ)V");
                                this.bin.readFully((byte[])object, 0, n2, true);
                                RuntimeCostAccounter.recordJump();
                                break block12;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (clazz != Long.TYPE) break block17;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readLongs:([JII)V");
                            this.bin.readLongs((long[])object, 0, n2);
                            RuntimeCostAccounter.recordJump();
                            break block12;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (clazz != Float.TYPE) break block18;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFloats:([FII)V");
                        this.bin.readFloats((float[])object, 0, n2);
                        RuntimeCostAccounter.recordJump();
                        break block12;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (clazz != Double.TYPE) break block19;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readDoubles:([DII)V");
                    this.bin.readDoubles((double[])object, 0, n2);
                    RuntimeCostAccounter.recordJump();
                    break block12;
                }
                RuntimeCostAccounter.recordJump();
                if (clazz == Short.TYPE) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readShorts:([SII)V");
                    this.bin.readShorts((short[])object, 0, n2);
                    RuntimeCostAccounter.recordJump();
                    break block12;
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (clazz == Character.TYPE) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readChars:([CII)V");
                        this.bin.readChars((char[])object, 0, n2);
                        RuntimeCostAccounter.recordJump();
                        break block12;
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (clazz != Boolean.TYPE) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                            InternalError internalError = new InternalError();
                            RuntimeCostAccounter.recordThrow();
                            throw internalError;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readBooleans:([ZII)V");
                        this.bin.readBooleans((boolean[])object, 0, n2);
                        RuntimeCostAccounter.recordJump();
                    }
                }
                break block12;
            }
            Object[] objectArray = (Object[])object;
            int n4 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
                objectArray[n4] = this.readObject0(false);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markDependency:(II)V");
                this.handles.markDependency(n, this.passHandle);
                ++n4;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.finish:(I)V");
        this.handles.finish(n);
        this.passHandle = n;
        return object;
    }

    private Enum<?> readEnum(boolean bl) throws IOException {
        Enum<?> enum_;
        int n;
        block8: {
            Object object;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
            byte by = this.bin.readByte();
            RuntimeCostAccounter.recordJump();
            if (by != 126) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                InternalError internalError = new InternalError();
                RuntimeCostAccounter.recordThrow();
                throw internalError;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readClassDesc:(Z)Ljava/io/ObjectStreamClass;");
            ObjectStreamClass objectStreamClass = this.readClassDesc(false);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.isEnum:()Z");
            boolean bl2 = objectStreamClass.isEnum();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidClassException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("non-enum class: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(objectStreamClass);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.<init>:(Ljava/lang/String;)V");
                InvalidClassException invalidClassException = new InvalidClassException(string);
                RuntimeCostAccounter.recordThrow();
                throw invalidClassException;
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                object = unsharedMarker;
                RuntimeCostAccounter.recordJump();
            } else {
                object = null;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.assign:(Ljava/lang/Object;)I");
            n = this.handles.assign(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getResolveException:()Ljava/lang/ClassNotFoundException;");
            ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
            RuntimeCostAccounter.recordJump();
            if (classNotFoundException != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
                this.handles.markException(n, classNotFoundException);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readString:(Z)Ljava/lang/String;");
            String string = this.readString(false);
            enum_ = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
            Class<?> clazz = objectStreamClass.forClass();
            RuntimeCostAccounter.recordJump();
            if (clazz == null) break block8;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.valueOf:(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
                Object obj = Enum.valueOf(clazz, string);
                enum_ = (Enum<?>)obj;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append("enum constant ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(" does not exist in ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(clazz);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
                InvalidObjectException invalidObjectException = new InvalidObjectException(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
                IOException iOException = (IOException)invalidObjectException.initCause(illegalArgumentException);
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.setObject:(ILjava/lang/Object;)V");
                this.handles.setObject(n, enum_);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.finish:(I)V");
        this.handles.finish(n);
        this.passHandle = n;
        return enum_;
    }

    private Object readOrdinaryObject(boolean bl) throws IOException {
        Object object;
        Object object2;
        ObjectStreamClass objectStreamClass;
        block20: {
            block19: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                byte by = this.bin.readByte();
                RuntimeCostAccounter.recordJump();
                if (by != 115) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                    InternalError internalError = new InternalError();
                    RuntimeCostAccounter.recordThrow();
                    throw internalError;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readClassDesc:(Z)Ljava/io/ObjectStreamClass;");
                objectStreamClass = this.readClassDesc(false);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.checkDeserialize:()V");
                objectStreamClass.checkDeserialize();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
                Class<?> clazz = objectStreamClass.forClass();
                RuntimeCostAccounter.recordJump();
                if (clazz == String.class) break block19;
                RuntimeCostAccounter.recordJump();
                if (clazz == Class.class) break block19;
                RuntimeCostAccounter.recordJump();
                if (clazz != ObjectStreamClass.class) break block20;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidClassException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.<init>:(Ljava/lang/String;)V");
            InvalidClassException invalidClassException = new InvalidClassException("invalid class descriptor");
            RuntimeCostAccounter.recordThrow();
            throw invalidClassException;
        }
        try {
            Object object3;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.isInstantiable:()Z");
            boolean bl2 = objectStreamClass.isInstantiable();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.newInstance:()Ljava/lang/Object;");
                object3 = objectStreamClass.newInstance();
                RuntimeCostAccounter.recordJump();
            } else {
                object3 = null;
            }
            object2 = object3;
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidClassException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
            Class<?> clazz = objectStreamClass.forClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
            InvalidClassException invalidClassException = new InvalidClassException(string, "unable to create instance");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
            IOException iOException = (IOException)invalidClassException.initCause(exception);
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            object = unsharedMarker;
            RuntimeCostAccounter.recordJump();
        } else {
            object = object2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.passHandle = this.handles.assign(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getResolveException:()Ljava/lang/ClassNotFoundException;");
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        RuntimeCostAccounter.recordJump();
        if (classNotFoundException != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.isExternalizable:()Z");
        boolean bl3 = objectStreamClass.isExternalizable();
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            Externalizable externalizable = (Externalizable)object2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readExternalData:(Ljava/io/Externalizable;Ljava/io/ObjectStreamClass;)V");
            this.readExternalData(externalizable, objectStreamClass);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readSerialData:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
            this.readSerialData(object2, objectStreamClass);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.finish:(I)V");
        this.handles.finish(this.passHandle);
        RuntimeCostAccounter.recordJump();
        if (object2 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
            ClassNotFoundException classNotFoundException2 = this.handles.lookupException(this.passHandle);
            RuntimeCostAccounter.recordJump();
            if (classNotFoundException2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasReadResolveMethod:()Z");
                boolean bl4 = objectStreamClass.hasReadResolveMethod();
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.invokeReadResolve:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Object object4 = objectStreamClass.invokeReadResolve(object2);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                        Class<?> clazz = object4.getClass();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isArray:()Z");
                        boolean bl5 = clazz.isArray();
                        RuntimeCostAccounter.recordJump();
                        if (bl5) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.cloneArray:(Ljava/lang/Object;)Ljava/lang/Object;");
                            object4 = ObjectInputStream.cloneArray(object4);
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object4 != object2) {
                        object2 = object4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.setObject:(ILjava/lang/Object;)V");
                        this.handles.setObject(this.passHandle, object2);
                    }
                }
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExternalData(Externalizable externalizable, ObjectStreamClass objectStreamClass) throws IOException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        this.curContext = null;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasBlockExternalData:()Z");
            boolean bl = objectStreamClass.hasBlockExternalData();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
                this.bin.setBlockDataMode(true);
            }
            RuntimeCostAccounter.recordJump();
            if (externalizable != null) {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Externalizable.readExternal:(Ljava/io/ObjectInput;)V");
                    externalizable.readExternal(this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
                    this.handles.markException(this.passHandle, classNotFoundException);
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.skipCustomData:()V");
                this.skipCustomData();
            }
            this.curContext = serialCallbackContext;
        }
        catch (Throwable throwable) {
            this.curContext = serialCallbackContext;
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getClassDataLayout:()[Ljava/io/ObjectStreamClass$ClassDataSlot;");
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        int n = 0;
        while (true) {
            block14: {
                ObjectStreamClass objectStreamClass2;
                block10: {
                    block13: {
                        block11: {
                            int n2 = classDataSlotArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n >= n2) break;
                            objectStreamClass2 = classDataSlotArray[n].desc;
                            boolean bl = classDataSlotArray[n].hasData;
                            RuntimeCostAccounter.recordJump();
                            if (!bl) break block10;
                            RuntimeCostAccounter.recordJump();
                            if (object == null) break block11;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasReadObjectMethod:()Z");
                            boolean bl2 = objectStreamClass2.hasReadObjectMethod();
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) break block11;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
                            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
                            RuntimeCostAccounter.recordJump();
                            if (classNotFoundException != null) break block11;
                            SerialCallbackContext serialCallbackContext = this.curContext;
                            try {
                                RuntimeCostAccounter.recordAllocation((String)"java/io/SerialCallbackContext");
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.<init>:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
                                this.curContext = new SerialCallbackContext(object, objectStreamClass2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
                                this.bin.setBlockDataMode(true);
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.invokeReadObject:(Ljava/lang/Object;Ljava/io/ObjectInputStream;)V");
                                objectStreamClass2.invokeReadObject(object, this);
                            }
                            catch (ClassNotFoundException classNotFoundException2) {
                                try {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
                                    this.handles.markException(this.passHandle, classNotFoundException2);
                                }
                                catch (Throwable throwable) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.setUsed:()V");
                                    this.curContext.setUsed();
                                    this.curContext = serialCallbackContext;
                                    RuntimeCostAccounter.recordThrow();
                                    throw throwable;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.setUsed:()V");
                                this.curContext.setUsed();
                                this.curContext = serialCallbackContext;
                                RuntimeCostAccounter.recordJump();
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.setUsed:()V");
                            this.curContext.setUsed();
                            this.curContext = serialCallbackContext;
                            RuntimeCostAccounter.recordJump();
                            this.defaultDataEnd = false;
                            RuntimeCostAccounter.recordJump();
                            break block13;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadFields:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
                        this.defaultReadFields(object, objectStreamClass2);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasWriteObjectData:()Z");
                    boolean bl = objectStreamClass2.hasWriteObjectData();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.skipCustomData:()V");
                        this.skipCustomData();
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
                        this.bin.setBlockDataMode(false);
                        RuntimeCostAccounter.recordJump();
                    }
                    break block14;
                }
                RuntimeCostAccounter.recordJump();
                if (object != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasReadObjectNoDataMethod:()Z");
                    boolean bl = objectStreamClass2.hasReadObjectNoDataMethod();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
                        ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
                        RuntimeCostAccounter.recordJump();
                        if (classNotFoundException == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.invokeReadObjectNoData:(Ljava/lang/Object;)V");
                            objectStreamClass2.invokeReadObjectNoData(object);
                        }
                    }
                }
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void skipCustomData() throws IOException {
        int n = this.passHandle;
        block4: while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.getBlockDataMode:()Z");
            boolean bl = this.bin.getBlockDataMode();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.skipBlockData:()V");
                this.bin.skipBlockData();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
                this.bin.setBlockDataMode(false);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.peekByte:()B");
            switch (this.bin.peekByte()) {
                case 119: 
                case 122: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.setBlockDataMode:(Z)Z");
                    this.bin.setBlockDataMode(true);
                    RuntimeCostAccounter.recordJump();
                    continue block4;
                }
                case 120: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                    this.bin.readByte();
                    this.passHandle = n;
                    return;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
            this.readObject0(false);
            RuntimeCostAccounter.recordJump();
        }
    }

    private void defaultReadFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        int n;
        block11: {
            block10: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
                Class<?> clazz = objectStreamClass.forClass();
                RuntimeCostAccounter.recordJump();
                if (clazz != null) {
                    RuntimeCostAccounter.recordJump();
                    if (object != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isInstance:(Ljava/lang/Object;)Z");
                        boolean bl = clazz.isInstance(object);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:()V");
                            ClassCastException classCastException = new ClassCastException();
                            RuntimeCostAccounter.recordThrow();
                            throw classCastException;
                        }
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getPrimDataSize:()I");
                n = objectStreamClass.getPrimDataSize();
                RuntimeCostAccounter.recordJump();
                if (this.primVals == null) break block10;
                int n2 = this.primVals.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break block11;
            }
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)1);
            this.primVals = new byte[n3];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFully:([BIIZ)V");
        this.bin.readFully(this.primVals, 0, n, false);
        RuntimeCostAccounter.recordJump();
        if (object != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.setPrimFieldValues:(Ljava/lang/Object;[B)V");
            objectStreamClass.setPrimFieldValues(object, this.primVals);
        }
        int n4 = this.passHandle;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getFields:(Z)[Ljava/io/ObjectStreamField;");
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getNumObjFields:()I");
        int n5 = objectStreamClass.getNumObjFields();
        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)8);
        Object[] objectArray = new Object[n5];
        int n6 = objectStreamFieldArray.length - objectArray.length;
        int n7 = 0;
        while (true) {
            int n8 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n7 >= n8) break;
            ObjectStreamField objectStreamField = objectStreamFieldArray[n6 + n7];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.isUnshared:()Z");
            boolean bl = objectStreamField.isUnshared();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
            objectArray[n7] = this.readObject0(bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.getField:()Ljava/lang/reflect/Field;");
            Field field = objectStreamField.getField();
            RuntimeCostAccounter.recordJump();
            if (field != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markDependency:(II)V");
                this.handles.markDependency(n4, this.passHandle);
            }
            ++n7;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (object != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.setObjFieldValues:(Ljava/lang/Object;[Ljava/lang/Object;)V");
            objectStreamClass.setObjFieldValues(object, objectArray);
        }
        this.passHandle = n4;
    }

    private IOException readFatalException() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
        byte by = this.bin.readByte();
        RuntimeCostAccounter.recordJump();
        if (by != 123) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.clear:()V");
        this.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
        return (IOException)this.readObject0(false);
    }

    private void handleReset() throws StreamCorruptedException {
        RuntimeCostAccounter.recordJump();
        if (this.depth > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("unexpected reset; recursion depth: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.depth);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.clear:()V");
        this.clear();
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static ClassLoader latestUserDefinedLoader() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/VM.latestUserDefinedLoader:()Ljava/lang/ClassLoader;");
        return VM.latestUserDefinedLoader();
    }

    private static Object cloneArray(Object object) {
        boolean bl = object instanceof Object[];
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"[Ljava/lang/Object;.clone:()Ljava/lang/Object;");
            return ((Object[])object).clone();
        }
        boolean bl2 = object instanceof boolean[];
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"[Z.clone:()Ljava/lang/Object;");
            return ((boolean[])object).clone();
        }
        boolean bl3 = object instanceof byte[];
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            RuntimeCostAccounter.recordMethodCall((String)"[B.clone:()Ljava/lang/Object;");
            return ((byte[])object).clone();
        }
        boolean bl4 = object instanceof char[];
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            RuntimeCostAccounter.recordMethodCall((String)"[C.clone:()Ljava/lang/Object;");
            return ((char[])object).clone();
        }
        boolean bl5 = object instanceof double[];
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            RuntimeCostAccounter.recordMethodCall((String)"[D.clone:()Ljava/lang/Object;");
            return ((double[])object).clone();
        }
        boolean bl6 = object instanceof float[];
        RuntimeCostAccounter.recordJump();
        if (bl6) {
            RuntimeCostAccounter.recordMethodCall((String)"[F.clone:()Ljava/lang/Object;");
            return ((float[])object).clone();
        }
        boolean bl7 = object instanceof int[];
        RuntimeCostAccounter.recordJump();
        if (bl7) {
            RuntimeCostAccounter.recordMethodCall((String)"[I.clone:()Ljava/lang/Object;");
            return ((int[])object).clone();
        }
        boolean bl8 = object instanceof long[];
        RuntimeCostAccounter.recordJump();
        if (bl8) {
            RuntimeCostAccounter.recordMethodCall((String)"[J.clone:()Ljava/lang/Object;");
            return ((long[])object).clone();
        }
        boolean bl9 = object instanceof short[];
        RuntimeCostAccounter.recordJump();
        if (bl9) {
            RuntimeCostAccounter.recordMethodCall((String)"[S.clone:()Ljava/lang/Object;");
            return ((short[])object).clone();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
        AssertionError assertionError = new AssertionError();
        RuntimeCostAccounter.recordThrow();
        throw assertionError;
    }

    static /* synthetic */ Object access$300(ObjectInputStream objectInputStream, boolean bl) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject0:(Z)Ljava/lang/Object;");
        return objectInputStream.readObject0(bl);
    }

    static /* synthetic */ void access$600(ObjectInputStream objectInputStream) throws StreamCorruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.handleReset:()V");
        objectInputStream.handleReset();
    }

    static /* synthetic */ void access$700(byte[] byArray, int n, float[] fArray, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.bytesToFloats:([BI[FII)V");
        ObjectInputStream.bytesToFloats(byArray, n, fArray, n2, n3);
    }

    static /* synthetic */ void access$800(byte[] byArray, int n, double[] dArray, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.bytesToDoubles:([BI[DII)V");
        ObjectInputStream.bytesToDoubles(byArray, n, dArray, n2, n3);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        unsharedMarker = new Object();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:(IF)V");
        primClasses = new HashMap(8, 1.0f);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("boolean", Boolean.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("byte", Byte.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("char", Character.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("short", Short.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("int", Integer.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("long", Long.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("float", Float.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("double", Double.TYPE);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        primClasses.put("void", Void.TYPE);
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep;
        int size;

        HandleTable(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.lowDep = -1;
            this.size = 0;
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
            this.status = new byte[n2];
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
            this.entries = new Object[n3];
            int n4 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
            this.deps = new HandleList[n4];
        }

        int assign(Object object) {
            int n = this.entries.length;
            RuntimeCostAccounter.recordJump();
            if (this.size >= n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.grow:()V");
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = object;
            return this.size++;
        }

        void markDependency(int n, int n2) {
            block15: {
                block14: {
                    RuntimeCostAccounter.recordJump();
                    if (n == -1) break block14;
                    RuntimeCostAccounter.recordJump();
                    if (n2 != -1) break block15;
                }
                return;
            }
            block0 : switch (this.status[n]) {
                case 2: {
                    switch (this.status[n2]) {
                        case 1: {
                            RuntimeCostAccounter.recordJump();
                            break block0;
                        }
                        case 3: {
                            ClassNotFoundException classNotFoundException = (ClassNotFoundException)this.entries[n2];
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
                            this.markException(n, classNotFoundException);
                            RuntimeCostAccounter.recordJump();
                            break block0;
                        }
                        case 2: {
                            HandleList handleList = this.deps[n2];
                            RuntimeCostAccounter.recordJump();
                            if (handleList == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$HandleTable$HandleList");
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable$HandleList.<init>:()V");
                                this.deps[n2] = new HandleList();
                            }
                            HandleList handleList2 = this.deps[n2];
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable$HandleList.add:(I)V");
                            handleList2.add(n);
                            RuntimeCostAccounter.recordJump();
                            if (this.lowDep >= 0) {
                                RuntimeCostAccounter.recordJump();
                                if (this.lowDep <= n2) break block0;
                            }
                            this.lowDep = n2;
                            RuntimeCostAccounter.recordJump();
                            break block0;
                        }
                        default: {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                            InternalError internalError = new InternalError();
                            RuntimeCostAccounter.recordThrow();
                            throw internalError;
                        }
                    }
                }
                case 3: {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                default: {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                    InternalError internalError = new InternalError();
                    RuntimeCostAccounter.recordThrow();
                    throw internalError;
                }
            }
        }

        void markException(int n, ClassNotFoundException classNotFoundException) {
            switch (this.status[n]) {
                case 2: {
                    this.status[n] = 3;
                    this.entries[n] = classNotFoundException;
                    HandleList handleList = this.deps[n];
                    RuntimeCostAccounter.recordJump();
                    if (handleList == null) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable$HandleList.size:()I");
                    int n2 = handleList.size();
                    int n3 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n3 >= n2) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable$HandleList.get:(I)I");
                        int n4 = handleList.get(n3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markException:(ILjava/lang/ClassNotFoundException;)V");
                        this.markException(n4, classNotFoundException);
                        ++n3;
                        RuntimeCostAccounter.recordJump();
                    }
                    this.deps[n] = null;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 3: {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                default: {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                    InternalError internalError = new InternalError();
                    RuntimeCostAccounter.recordThrow();
                    throw internalError;
                }
            }
        }

        void finish(int n) {
            int n2;
            RuntimeCostAccounter.recordJump();
            if (this.lowDep < 0) {
                n2 = n + 1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.lowDep >= n) {
                    n2 = this.size;
                    this.lowDep = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    return;
                }
            }
            int n3 = n;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                switch (this.status[n3]) {
                    case 2: {
                        this.status[n3] = 1;
                        this.deps[n3] = null;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 1: 
                    case 3: {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    default: {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                        InternalError internalError = new InternalError();
                        RuntimeCostAccounter.recordThrow();
                        throw internalError;
                    }
                }
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        void setObject(int n, Object object) {
            switch (this.status[n]) {
                case 1: 
                case 2: {
                    this.entries[n] = object;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 3: {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                default: {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
                    InternalError internalError = new InternalError();
                    RuntimeCostAccounter.recordThrow();
                    throw internalError;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object lookupObject(int n) {
            RuntimeCostAccounter.recordJump();
            if (n == -1) return null;
            byte by = this.status[n];
            RuntimeCostAccounter.recordJump();
            if (by == 3) return null;
            Object object = this.entries[n];
            RuntimeCostAccounter.recordJump();
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ClassNotFoundException lookupException(int n) {
            RuntimeCostAccounter.recordJump();
            if (n == -1) return null;
            byte by = this.status[n];
            RuntimeCostAccounter.recordJump();
            if (by != 3) return null;
            ClassNotFoundException classNotFoundException = (ClassNotFoundException)this.entries[n];
            RuntimeCostAccounter.recordJump();
            return classNotFoundException;
        }

        void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([BIIB)V");
            Arrays.fill(this.status, 0, this.size, (byte)0);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;IILjava/lang/Object;)V");
            Arrays.fill(this.entries, 0, this.size, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;IILjava/lang/Object;)V");
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void grow() {
            int n;
            int n2 = n = (this.entries.length << 1) + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
            byte[] byArray = new byte[n2];
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
            Object[] objectArray = new Object[n3];
            int n4 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
            HandleList[] handleListArray = new HandleList[n4];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.status, 0, byArray, 0, this.size);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.entries, 0, objectArray, 0, this.size);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.deps, 0, handleListArray, 0, this.size);
            this.status = byArray;
            this.entries = objectArray;
            this.deps = handleListArray;
        }

        private static class HandleList {
            private int[] list;
            private int size;

            public HandleList() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                RuntimeCostAccounter.recordArrayAllocation((int)4, (int)4);
                this.list = new int[4];
                this.size = 0;
            }

            public void add(int n) {
                int n2 = this.list.length;
                RuntimeCostAccounter.recordJump();
                if (this.size >= n2) {
                    int n3 = this.list.length << 1;
                    RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
                    int[] nArray = new int[n3];
                    int n4 = this.list.length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(this.list, 0, nArray, 0, n4);
                    this.list = nArray;
                }
                this.list[this.size++] = n;
            }

            public int get(int n) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:()V");
                    ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
                    RuntimeCostAccounter.recordThrow();
                    throw arrayIndexOutOfBoundsException;
                }
                return this.list[n];
            }

            public int size() {
                return this.size;
            }
        }
    }

    private class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf;
        private final byte[] hbuf;
        private final char[] cbuf;
        private boolean blkmode;
        private int pos;
        private int end;
        private int unread;
        private final PeekInputStream in;
        private final DataInputStream din;

        BlockDataInputStream(InputStream inputStream) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
            RuntimeCostAccounter.recordArrayAllocation((int)1024, (int)1);
            this.buf = new byte[1024];
            RuntimeCostAccounter.recordArrayAllocation((int)5, (int)1);
            this.hbuf = new byte[5];
            RuntimeCostAccounter.recordArrayAllocation((int)256, (int)2);
            this.cbuf = new char[256];
            this.blkmode = false;
            this.pos = 0;
            this.end = -1;
            this.unread = 0;
            RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$PeekInputStream");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.<init>:(Ljava/io/InputStream;)V");
            this.in = new PeekInputStream(inputStream);
            RuntimeCostAccounter.recordAllocation((String)"java/io/DataInputStream");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.<init>:(Ljava/io/InputStream;)V");
            this.din = new DataInputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (this.blkmode == bl) {
                return this.blkmode;
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                this.pos = 0;
                this.end = 0;
                this.unread = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.pos < this.end) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                    IllegalStateException illegalStateException = new IllegalStateException("unread block data");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
            }
            this.blkmode = bl;
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        void skipBlockData() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException("not in block data mode");
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (this.end < 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.refill:()V");
                this.refill();
                RuntimeCostAccounter.recordJump();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int readBlockHeader(boolean bl) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$500:(Ljava/io/ObjectInputStream;)Z");
            boolean bl2 = ObjectInputStream.this.defaultDataEnd;
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return -1;
            }
            try {
                while (true) {
                    int n;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        n = Integer.MAX_VALUE;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.available:()I");
                        n = this.in.available();
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 0) {
                        return -2;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.peek:()I");
                    int n3 = this.in.peek();
                    switch (n3) {
                        case 119: {
                            RuntimeCostAccounter.recordJump();
                            if (n2 < 2) {
                                return -2;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                            this.in.readFully(this.hbuf, 0, 2);
                            return this.hbuf[1] & 0xFF;
                        }
                        case 122: {
                            RuntimeCostAccounter.recordJump();
                            if (n2 < 5) {
                                return -2;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                            this.in.readFully(this.hbuf, 0, 5);
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getInt:([BI)I");
                            int n4 = Bits.getInt(this.hbuf, 1);
                            RuntimeCostAccounter.recordJump();
                            if (n4 >= 0) return n4;
                            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder2 = stringBuilder.append("illegal block data header length: ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder3 = stringBuilder2.append(n4);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string = stringBuilder3.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
                            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw streamCorruptedException;
                        }
                        case 121: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.read:()I");
                            this.in.read();
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$600:(Ljava/io/ObjectInputStream;)V");
                            ObjectInputStream.access$600(ObjectInputStream.this);
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        default: {
                            RuntimeCostAccounter.recordJump();
                            if (n3 < 0) return -1;
                            RuntimeCostAccounter.recordJump();
                            if (n3 >= 112) {
                                RuntimeCostAccounter.recordJump();
                                if (n3 <= 126) return -1;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
                            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                            Object[] objectArray = new Object[1];
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                            objectArray[0] = n3;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                            String string = String.format("invalid type code: %02X", objectArray);
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
                            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw streamCorruptedException;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
            }
            catch (EOFException eOFException) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
                StreamCorruptedException streamCorruptedException = new StreamCorruptedException("unexpected EOF while reading block data header");
                RuntimeCostAccounter.recordThrow();
                throw streamCorruptedException;
            }
        }

        private void refill() throws IOException {
            try {
                do {
                    int n;
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                    if (this.unread > 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                        int n2 = Math.min(this.unread, 1024);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.read:([BII)I");
                        n = this.in.read(this.buf, 0, n2);
                        RuntimeCostAccounter.recordJump();
                        if (n >= 0) {
                            this.end = n;
                            this.unread -= n;
                        } else {
                            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
                            StreamCorruptedException streamCorruptedException = new StreamCorruptedException("unexpected EOF in middle of data block");
                            RuntimeCostAccounter.recordThrow();
                            throw streamCorruptedException;
                        }
                        RuntimeCostAccounter.recordJump();
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readBlockHeader:(Z)I");
                        n = this.readBlockHeader(true);
                        RuntimeCostAccounter.recordJump();
                        if (n >= 0) {
                            this.end = 0;
                            this.unread = n;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            this.end = -1;
                            this.unread = 0;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                } while (this.pos == this.end);
            }
            catch (IOException iOException) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            RuntimeCostAccounter.recordJump();
        }

        int currentBlockRemaining() {
            RuntimeCostAccounter.recordJump();
            if (this.blkmode) {
                int n;
                RuntimeCostAccounter.recordJump();
                if (this.end >= 0) {
                    n = this.end - this.pos + this.unread;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 0;
                }
                return n;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }

        int peek() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.blkmode) {
                int n;
                RuntimeCostAccounter.recordJump();
                if (this.pos == this.end) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.refill:()V");
                    this.refill();
                }
                RuntimeCostAccounter.recordJump();
                if (this.end >= 0) {
                    n = this.buf[this.pos] & 0xFF;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = -1;
                }
                return n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.peek:()I");
            return this.in.peek();
        }

        byte peekByte() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.peek:()I");
            int n = this.peek();
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                EOFException eOFException = new EOFException();
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            return (byte)n;
        }

        @Override
        public int read() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.blkmode) {
                int n;
                RuntimeCostAccounter.recordJump();
                if (this.pos == this.end) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.refill:()V");
                    this.refill();
                }
                RuntimeCostAccounter.recordJump();
                if (this.end >= 0) {
                    n = this.buf[this.pos++] & 0xFF;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = -1;
                }
                return n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.read:()I");
            return this.in.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.read:([BIIZ)I");
            return this.read(byArray, n, n2, false);
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = l;
            while (true) {
                int n;
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0L) break;
                RuntimeCostAccounter.recordJump();
                if (this.blkmode) {
                    RuntimeCostAccounter.recordJump();
                    if (this.pos == this.end) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.refill:()V");
                        this.refill();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.end < 0) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    long l3 = this.end - this.pos;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
                    n = (int)Math.min(l2, l3);
                    l2 -= (long)n;
                    this.pos += n;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
                n = (int)Math.min(l2, 1024L);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.read:([BII)I");
                n = this.in.read(this.buf, 0, n);
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                l2 -= (long)n;
                RuntimeCostAccounter.recordJump();
            }
            return l - l2;
        }

        @Override
        public int available() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.blkmode) {
                int n;
                int n2;
                int n3;
                RuntimeCostAccounter.recordJump();
                if (this.pos == this.end) {
                    RuntimeCostAccounter.recordJump();
                    if (this.unread == 0) {
                        while (true) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readBlockHeader:(Z)I");
                            n3 = this.readBlockHeader(false);
                            RuntimeCostAccounter.recordJump();
                            if (n3 != 0) break;
                            RuntimeCostAccounter.recordJump();
                        }
                        switch (n3) {
                            case -2: {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            case -1: {
                                this.pos = 0;
                                this.end = -1;
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            default: {
                                this.pos = 0;
                                this.end = 0;
                                this.unread = n3;
                            }
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (this.unread > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.available:()I");
                    int n4 = this.in.available();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    n2 = Math.min(n4, this.unread);
                    RuntimeCostAccounter.recordJump();
                } else {
                    n2 = 0;
                }
                n3 = n2;
                RuntimeCostAccounter.recordJump();
                if (this.end >= 0) {
                    n = this.end - this.pos + n3;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 0;
                }
                return n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.available:()I");
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.blkmode) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.close:()V");
            this.in.close();
        }

        int read(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return 0;
            }
            RuntimeCostAccounter.recordJump();
            if (this.blkmode) {
                RuntimeCostAccounter.recordJump();
                if (this.pos == this.end) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.refill:()V");
                    this.refill();
                }
                RuntimeCostAccounter.recordJump();
                if (this.end < 0) {
                    return -1;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                int n3 = Math.min(n2, this.end - this.pos);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(this.buf, this.pos, byArray, n, n3);
                this.pos += n3;
                return n3;
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                int n4 = Math.min(n2, 1024);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.read:([BII)I");
                int n5 = this.in.read(this.buf, 0, n4);
                RuntimeCostAccounter.recordJump();
                if (n5 > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(this.buf, 0, byArray, n, n5);
                }
                return n5;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.read:([BII)I");
            return this.in.read(byArray, n, n2);
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFully:([BIIZ)V");
            this.readFully(byArray, 0, n, false);
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFully:([BIIZ)V");
            this.readFully(byArray, n, n2, false);
        }

        public void readFully(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 <= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.read:([BIIZ)I");
                int n3 = this.read(byArray, n, n2, bl);
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                    EOFException eOFException = new EOFException();
                    RuntimeCostAccounter.recordThrow();
                    throw eOFException;
                }
                n += n3;
                n2 -= n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public int skipBytes(int n) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.skipBytes:(I)I");
            return this.din.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.read:()I");
            int n = this.read();
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                EOFException eOFException = new EOFException();
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public byte readByte() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.read:()I");
            int n = this.read();
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                EOFException eOFException = new EOFException();
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            return (byte)n;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.read:()I");
            int n = this.read();
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                EOFException eOFException = new EOFException();
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            return n;
        }

        @Override
        public char readChar() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                this.in.readFully(this.buf, 0, 2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.end - this.pos < 2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readChar:()C");
                    return this.din.readChar();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getChar:([BI)C");
            char c = Bits.getChar(this.buf, this.pos);
            this.pos += 2;
            return c;
        }

        @Override
        public short readShort() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                this.in.readFully(this.buf, 0, 2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.end - this.pos < 2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
                    return this.din.readShort();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getShort:([BI)S");
            short s = Bits.getShort(this.buf, this.pos);
            this.pos += 2;
            return s;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                this.in.readFully(this.buf, 0, 2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.end - this.pos < 2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readUnsignedShort:()I");
                    return this.din.readUnsignedShort();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getShort:([BI)S");
            int n = Bits.getShort(this.buf, this.pos) & 0xFFFF;
            this.pos += 2;
            return n;
        }

        @Override
        public int readInt() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                this.in.readFully(this.buf, 0, 4);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.end - this.pos < 4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readInt:()I");
                    return this.din.readInt();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getInt:([BI)I");
            int n = Bits.getInt(this.buf, this.pos);
            this.pos += 4;
            return n;
        }

        @Override
        public float readFloat() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                this.in.readFully(this.buf, 0, 4);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.end - this.pos < 4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readFloat:()F");
                    return this.din.readFloat();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getFloat:([BI)F");
            float f = Bits.getFloat(this.buf, this.pos);
            this.pos += 4;
            return f;
        }

        @Override
        public long readLong() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                this.in.readFully(this.buf, 0, 8);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.end - this.pos < 8) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readLong:()J");
                    return this.din.readLong();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getLong:([BI)J");
            long l = Bits.getLong(this.buf, this.pos);
            this.pos += 8;
            return l;
        }

        @Override
        public double readDouble() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                this.in.readFully(this.buf, 0, 8);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.end - this.pos < 8) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readDouble:()D");
                    return this.din.readDouble();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getDouble:([BI)D");
            double d = Bits.getDouble(this.buf, this.pos);
            this.pos += 8;
            return d;
        }

        @Override
        public String readUTF() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUnsignedShort:()I");
            long l = this.readUnsignedShort();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUTFBody:(J)Ljava/lang/String;");
            return this.readUTFBody(l);
        }

        @Override
        public String readLine() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readLine:()Ljava/lang/String;");
            return this.din.readLine();
        }

        /*
         * Unable to fully structure code
         */
        void readBooleans(boolean[] var1_1, int var2_2, int var3_3) throws IOException {
            var4_4 = var2_2 + var3_3;
            block0: while (true) {
                RuntimeCostAccounter.recordJump();
                if (var2_2 >= var4_4) break;
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var5_5 = Math.min(var4_4 - var2_2, 1024);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                    this.in.readFully(this.buf, 0, var5_5);
                    var6_6 = var2_2 + var5_5;
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.end - this.pos < 1) {
                        v0 = var2_2++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readBoolean:()Z");
                        var1_1[v0] = this.din.readBoolean();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var6_6 = Math.min(var4_4, var2_2 + this.end - this.pos);
                }
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 < var6_6) ** break;
                    continue block0;
                    v1 = var2_2++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getBoolean:([BI)Z");
                    var1_1[v1] = Bits.getBoolean(this.buf, this.pos++);
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
        }

        /*
         * Unable to fully structure code
         */
        void readChars(char[] var1_1, int var2_2, int var3_3) throws IOException {
            var4_4 = var2_2 + var3_3;
            block0: while (true) {
                RuntimeCostAccounter.recordJump();
                if (var2_2 >= var4_4) break;
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var5_5 = Math.min(var4_4 - var2_2, 512);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                    this.in.readFully(this.buf, 0, var5_5 << 1);
                    var6_6 = var2_2 + var5_5;
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.end - this.pos < 2) {
                        v0 = var2_2++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readChar:()C");
                        var1_1[v0] = this.din.readChar();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var6_6 = Math.min(var4_4, var2_2 + (this.end - this.pos >> 1));
                }
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 < var6_6) ** break;
                    continue block0;
                    v1 = var2_2++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getChar:([BI)C");
                    var1_1[v1] = Bits.getChar(this.buf, this.pos);
                    this.pos += 2;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
        }

        /*
         * Unable to fully structure code
         */
        void readShorts(short[] var1_1, int var2_2, int var3_3) throws IOException {
            var4_4 = var2_2 + var3_3;
            block0: while (true) {
                RuntimeCostAccounter.recordJump();
                if (var2_2 >= var4_4) break;
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var5_5 = Math.min(var4_4 - var2_2, 512);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                    this.in.readFully(this.buf, 0, var5_5 << 1);
                    var6_6 = var2_2 + var5_5;
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.end - this.pos < 2) {
                        v0 = var2_2++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
                        var1_1[v0] = this.din.readShort();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var6_6 = Math.min(var4_4, var2_2 + (this.end - this.pos >> 1));
                }
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 < var6_6) ** break;
                    continue block0;
                    v1 = var2_2++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getShort:([BI)S");
                    var1_1[v1] = Bits.getShort(this.buf, this.pos);
                    this.pos += 2;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
        }

        /*
         * Unable to fully structure code
         */
        void readInts(int[] var1_1, int var2_2, int var3_3) throws IOException {
            var4_4 = var2_2 + var3_3;
            block0: while (true) {
                RuntimeCostAccounter.recordJump();
                if (var2_2 >= var4_4) break;
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var5_5 = Math.min(var4_4 - var2_2, 256);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                    this.in.readFully(this.buf, 0, var5_5 << 2);
                    var6_6 = var2_2 + var5_5;
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.end - this.pos < 4) {
                        v0 = var2_2++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readInt:()I");
                        var1_1[v0] = this.din.readInt();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var6_6 = Math.min(var4_4, var2_2 + (this.end - this.pos >> 2));
                }
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 < var6_6) ** break;
                    continue block0;
                    v1 = var2_2++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getInt:([BI)I");
                    var1_1[v1] = Bits.getInt(this.buf, this.pos);
                    this.pos += 4;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
        }

        void readFloats(float[] fArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (true) {
                int n4;
                RuntimeCostAccounter.recordJump();
                if (n >= n3) break;
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    n4 = Math.min(n3 - n, 256);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                    this.in.readFully(this.buf, 0, n4 << 2);
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.end - this.pos < 4) {
                        int n5 = n++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readFloat:()F");
                        fArray[n5] = this.din.readFloat();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    n4 = Math.min(n3 - n, this.end - this.pos >> 2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$700:([BI[FII)V");
                ObjectInputStream.access$700(this.buf, this.pos, fArray, n, n4);
                n += n4;
                this.pos += n4 << 2;
                RuntimeCostAccounter.recordJump();
            }
        }

        /*
         * Unable to fully structure code
         */
        void readLongs(long[] var1_1, int var2_2, int var3_3) throws IOException {
            var4_4 = var2_2 + var3_3;
            block0: while (true) {
                RuntimeCostAccounter.recordJump();
                if (var2_2 >= var4_4) break;
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var5_5 = Math.min(var4_4 - var2_2, 128);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                    this.in.readFully(this.buf, 0, var5_5 << 3);
                    var6_6 = var2_2 + var5_5;
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.end - this.pos < 8) {
                        v0 = var2_2++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readLong:()J");
                        var1_1[v0] = this.din.readLong();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var6_6 = Math.min(var4_4, var2_2 + (this.end - this.pos >> 3));
                }
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 < var6_6) ** break;
                    continue block0;
                    v1 = var2_2++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getLong:([BI)J");
                    var1_1[v1] = Bits.getLong(this.buf, this.pos);
                    this.pos += 8;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
        }

        void readDoubles(double[] dArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (true) {
                int n4;
                RuntimeCostAccounter.recordJump();
                if (n >= n3) break;
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    n4 = Math.min(n3 - n, 128);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                    this.in.readFully(this.buf, 0, n4 << 3);
                    this.pos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.end - this.pos < 8) {
                        int n5 = n++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readDouble:()D");
                        dArray[n5] = this.din.readDouble();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    n4 = Math.min(n3 - n, this.end - this.pos >> 3);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$800:([BI[DII)V");
                ObjectInputStream.access$800(this.buf, this.pos, dArray, n, n4);
                n += n4;
                this.pos += n4 << 3;
                RuntimeCostAccounter.recordJump();
            }
        }

        String readLongUTF() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readLong:()J");
            long l = this.readLong();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUTFBody:(J)Ljava/lang/String;");
            return this.readUTFBody(l);
        }

        /*
         * Unable to fully structure code
         */
        private String readUTFBody(long var1_1) throws IOException {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            var3_2 = new StringBuilder();
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var1_1 <= 0L) break;
                var4_3 = this.end - this.pos;
                RuntimeCostAccounter.recordJump();
                if (var4_3 >= 3) ** GOTO lbl-1000
                cfr_temp_0 = (long)var4_3 - var1_1;
                v0 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (v0 == false) lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUTFSpan:(Ljava/lang/StringBuilder;J)J");
                    var1_1 -= this.readUTFSpan(var3_2, var1_1);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.blkmode) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readUTFChar:(Ljava/lang/StringBuilder;J)I");
                        var1_1 -= (long)this.readUTFChar(var3_2, var1_1);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (var4_3 > 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                            System.arraycopy(this.buf, this.pos, this.buf, 0, var4_3);
                        }
                        this.pos = 0;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
                        this.end = (int)Math.min(1024L, var1_1);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.readFully:([BII)V");
                        this.in.readFully(this.buf, var4_3, this.end - var4_3);
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return var3_2.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private long readUTFSpan(StringBuilder var1_1, long var2_2) throws IOException {
            block22: {
                block21: {
                    var4_3 = 0;
                    var5_4 = this.pos;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var6_5 = Math.min(this.end - this.pos, 256);
                    cfr_temp_0 = var2_2 - (long)var6_5;
                    v0 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (v0 > 0) {
                        v1 = var6_5 - 2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        v1 = (int)var2_2;
                    }
                    var7_6 = this.pos + v1;
                    var8_7 = false;
                    try {
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (this.pos >= var7_6) break;
                            var9_8 = this.buf[this.pos++] & 255;
                            switch (var9_8 >> 4) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    this.cbuf[var4_3++] = (char)var9_8;
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    var10_10 = this.buf[this.pos++];
                                    RuntimeCostAccounter.recordJump();
                                    if ((var10_10 & 192) != 128) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                                        v2 = new UTFDataFormatException();
                                        RuntimeCostAccounter.recordThrow();
                                        throw v2;
                                    }
                                    this.cbuf[var4_3++] = (char)((var9_8 & 31) << 6 | (var10_10 & 63) << 0);
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                case 14: {
                                    var11_11 = this.buf[this.pos + 1];
                                    var10_10 = this.buf[this.pos + 0];
                                    this.pos += 2;
                                    RuntimeCostAccounter.recordJump();
                                    if ((var10_10 & 192) != 128) ** GOTO lbl45
                                    RuntimeCostAccounter.recordJump();
                                    if ((var11_11 & 192) == 128) ** GOTO lbl50
lbl45:
                                    // 2 sources

                                    RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                                    v3 = new UTFDataFormatException();
                                    RuntimeCostAccounter.recordThrow();
                                    throw v3;
lbl50:
                                    // 1 sources

                                    this.cbuf[var4_3++] = (char)((var9_8 & 15) << 12 | (var10_10 & 63) << 6 | (var11_11 & 63) << 0);
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                default: {
                                    RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                                    v4 = new UTFDataFormatException();
                                    RuntimeCostAccounter.recordThrow();
                                    throw v4;
                                }
                            }
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var8_7) break block21;
                    }
                    catch (ArrayIndexOutOfBoundsException var9_9) {
                        var8_7 = true;
                        return (long)var8_7;
                    }
                    finally {
                        RuntimeCostAccounter.recordJump();
                        if (!var8_7) {
                            cfr_temp_2 = (long)(this.pos - var5_4) - var2_2;
                            v7 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
                            RuntimeCostAccounter.recordJump();
                            if (v7 <= 0) break block22;
                        }
                        this.pos = var5_4 + (int)var2_2;
                        RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                        v8 = new UTFDataFormatException();
                        RuntimeCostAccounter.recordThrow();
                        throw v8;
                    }
                    cfr_temp_1 = (long)(this.pos - var5_4) - var2_2;
                    v5 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (v5 <= 0) break block22;
                }
                this.pos = var5_4 + (int)var2_2;
                RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                v6 = new UTFDataFormatException();
                RuntimeCostAccounter.recordThrow();
                throw v6;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:([CII)Ljava/lang/StringBuilder;");
            var1_1.append(this.cbuf, 0, var4_3);
            return this.pos - var5_4;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int readUTFChar(StringBuilder stringBuilder, long l) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
            int n = this.readByte() & 0xFF;
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    char c = (char)n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder.append(c);
                    return 1;
                }
                case 12: 
                case 13: {
                    RuntimeCostAccounter.recordJump();
                    if (l < 2L) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                        UTFDataFormatException uTFDataFormatException = new UTFDataFormatException();
                        RuntimeCostAccounter.recordThrow();
                        throw uTFDataFormatException;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                    byte by = this.readByte();
                    RuntimeCostAccounter.recordJump();
                    if ((by & 0xC0) != 128) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                        UTFDataFormatException uTFDataFormatException = new UTFDataFormatException();
                        RuntimeCostAccounter.recordThrow();
                        throw uTFDataFormatException;
                    }
                    char c = (char)((n & 0x1F) << 6 | (by & 0x3F) << 0);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder.append(c);
                    return 2;
                }
                case 14: {
                    RuntimeCostAccounter.recordJump();
                    if (l < 3L) {
                        RuntimeCostAccounter.recordJump();
                        if (l == 2L) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                            this.readByte();
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                        UTFDataFormatException uTFDataFormatException = new UTFDataFormatException();
                        RuntimeCostAccounter.recordThrow();
                        throw uTFDataFormatException;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                    byte by = this.readByte();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readByte:()B");
                    byte by2 = this.readByte();
                    RuntimeCostAccounter.recordJump();
                    if ((by & 0xC0) == 128) {
                        RuntimeCostAccounter.recordJump();
                        if ((by2 & 0xC0) == 128) {
                            char c = (char)((n & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                            stringBuilder.append(c);
                            return 3;
                        }
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                    UTFDataFormatException uTFDataFormatException = new UTFDataFormatException();
                    RuntimeCostAccounter.recordThrow();
                    throw uTFDataFormatException;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
            UTFDataFormatException uTFDataFormatException = new UTFDataFormatException();
            RuntimeCostAccounter.recordThrow();
            throw uTFDataFormatException;
        }
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb;

        PeekInputStream(InputStream inputStream) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
            this.peekb = -1;
            this.in = inputStream;
        }

        int peek() throws IOException {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.peekb >= 0) {
                n = this.peekb;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:()I");
                n = this.peekb = this.in.read();
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.peekb >= 0) {
                int n = this.peekb;
                this.peekb = -1;
                return n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:()I");
            return this.in.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return 0;
            }
            RuntimeCostAccounter.recordJump();
            if (this.peekb < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
                return this.in.read(byArray, n, n2);
            }
            byArray[n++] = (byte)this.peekb;
            this.peekb = -1;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
            int n4 = this.in.read(byArray, n, --n2);
            RuntimeCostAccounter.recordJump();
            if (n4 >= 0) {
                n3 = n4 + 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n3 = 1;
            }
            return n3;
        }

        void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.read:([BII)I");
                int n4 = this.read(byArray, n + n3, n2 - n3);
                RuntimeCostAccounter.recordJump();
                if (n4 < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                    EOFException eOFException = new EOFException();
                    RuntimeCostAccounter.recordThrow();
                    throw eOFException;
                }
                n3 += n4;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public long skip(long l) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (l <= 0L) {
                return 0L;
            }
            int n = 0;
            RuntimeCostAccounter.recordJump();
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++n;
                --l;
            }
            long l2 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$PeekInputStream.skip:(J)J");
            return l2 + this.skip(l);
        }

        @Override
        public int available() throws IOException {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.available:()I");
            int n2 = this.in.available();
            RuntimeCostAccounter.recordJump();
            if (this.peekb >= 0) {
                n = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            return n2 + n;
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
            this.in.close();
        }
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        void register(ObjectInputValidation objectInputValidation, int n) throws InvalidObjectException {
            RuntimeCostAccounter.recordJump();
            if (objectInputValidation == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
                InvalidObjectException invalidObjectException = new InvalidObjectException("null callback");
                RuntimeCostAccounter.recordThrow();
                throw invalidObjectException;
            }
            Callback callback = null;
            Callback callback2 = this.list;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (callback2 == null) break;
                int n2 = callback2.priority;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                callback = callback2;
                callback2 = callback2.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.getContext:()Ljava/security/AccessControlContext;");
            AccessControlContext accessControlContext = AccessController.getContext();
            RuntimeCostAccounter.recordJump();
            if (callback != null) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$ValidationList$Callback");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList$Callback.<init>:(Ljava/io/ObjectInputValidation;ILjava/io/ObjectInputStream$ValidationList$Callback;Ljava/security/AccessControlContext;)V");
                callback.next = new Callback(objectInputValidation, n, callback2, accessControlContext);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$ValidationList$Callback");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList$Callback.<init>:(Ljava/io/ObjectInputValidation;ILjava/io/ObjectInputStream$ValidationList$Callback;Ljava/security/AccessControlContext;)V");
                this.list = new Callback(objectInputValidation, n, this.list, accessControlContext);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doCallbacks() throws InvalidObjectException {
            try {
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (this.list != null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectInputStream$ValidationList$1");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList$1.<init>:(Ljava/io/ObjectInputStream$ValidationList;)V");
                        PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){
                            {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                            }

                            public Void run() throws InvalidObjectException {
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$ValidationList.access$400:(Ljava/io/ObjectInputStream$ValidationList;)Ljava/io/ObjectInputStream$ValidationList$Callback;");
                                ObjectInputValidation objectInputValidation = ((ValidationList)this).list.obj;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputValidation.validateObject:()V");
                                objectInputValidation.validateObject();
                                return null;
                            }
                        };
                        AccessControlContext accessControlContext = this.list.acc;
                        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;");
                        AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction, (AccessControlContext)accessControlContext);
                        this.list = this.list.next;
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    break;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.list = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
                InvalidObjectException invalidObjectException = (InvalidObjectException)privilegedActionException.getException();
                RuntimeCostAccounter.recordThrow();
                throw invalidObjectException;
            }
            RuntimeCostAccounter.recordJump();
        }

        public void clear() {
            this.list = null;
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;
            final AccessControlContext acc;

            Callback(ObjectInputValidation objectInputValidation, int n, Callback callback, AccessControlContext accessControlContext) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.obj = objectInputValidation;
                this.priority = n;
                this.next = callback;
                this.acc = accessControlContext;
            }
        }
    }

    private class GetFieldImpl
    extends GetField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;
        private final int[] objHandles;

        GetFieldImpl(ObjectStreamClass objectStreamClass) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.<init>:()V");
            this.desc = objectStreamClass;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getPrimDataSize:()I");
            int n = objectStreamClass.getPrimDataSize();
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)1);
            this.primVals = new byte[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getNumObjFields:()I");
            int n2 = objectStreamClass.getNumObjFields();
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            this.objVals = new Object[n2];
            int n3 = this.objVals.length;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            this.objHandles = new int[n3];
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        @Override
        public boolean defaulted(String string) throws IOException {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, null);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean get(String string, boolean bl) throws IOException {
            boolean bl2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Boolean.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getBoolean:([BI)Z");
                bl2 = Bits.getBoolean(this.primVals, n);
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = bl;
            }
            return bl2;
        }

        @Override
        public byte get(String string, byte by) throws IOException {
            byte by2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Byte.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                by2 = this.primVals[n];
                RuntimeCostAccounter.recordJump();
            } else {
                by2 = by;
            }
            return by2;
        }

        @Override
        public char get(String string, char c) throws IOException {
            char c2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Character.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getChar:([BI)C");
                c2 = Bits.getChar(this.primVals, n);
                RuntimeCostAccounter.recordJump();
            } else {
                c2 = c;
            }
            return c2;
        }

        @Override
        public short get(String string, short s) throws IOException {
            short s2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Short.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getShort:([BI)S");
                s2 = Bits.getShort(this.primVals, n);
                RuntimeCostAccounter.recordJump();
            } else {
                s2 = s;
            }
            return s2;
        }

        @Override
        public int get(String string, int n) throws IOException {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n3 = this.getFieldOffset(string, Integer.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getInt:([BI)I");
                n2 = Bits.getInt(this.primVals, n3);
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            return n2;
        }

        @Override
        public float get(String string, float f) throws IOException {
            float f2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Float.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getFloat:([BI)F");
                f2 = Bits.getFloat(this.primVals, n);
                RuntimeCostAccounter.recordJump();
            } else {
                f2 = f;
            }
            return f2;
        }

        @Override
        public long get(String string, long l) throws IOException {
            long l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Long.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getLong:([BI)J");
                l2 = Bits.getLong(this.primVals, n);
                RuntimeCostAccounter.recordJump();
            } else {
                l2 = l;
            }
            return l2;
        }

        @Override
        public double get(String string, double d) throws IOException {
            double d2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Double.TYPE);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getDouble:([BI)D");
                d2 = Bits.getDouble(this.primVals, n);
                RuntimeCostAccounter.recordJump();
            } else {
                d2 = d;
            }
            return d2;
        }

        @Override
        public Object get(String string, Object object) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Object.class);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                Object object2;
                int n2 = this.objHandles[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$100:(Ljava/io/ObjectInputStream;)Ljava/io/ObjectInputStream$HandleTable;");
                HandleTable handleTable = ObjectInputStream.this.handles;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$000:(Ljava/io/ObjectInputStream;)I");
                int n3 = ObjectInputStream.this.passHandle;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.markDependency:(II)V");
                handleTable.markDependency(n3, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$100:(Ljava/io/ObjectInputStream;)Ljava/io/ObjectInputStream$HandleTable;");
                HandleTable handleTable2 = ObjectInputStream.this.handles;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$HandleTable.lookupException:(I)Ljava/lang/ClassNotFoundException;");
                ClassNotFoundException classNotFoundException = handleTable2.lookupException(n2);
                RuntimeCostAccounter.recordJump();
                if (classNotFoundException == null) {
                    object2 = this.objVals[n];
                    RuntimeCostAccounter.recordJump();
                } else {
                    object2 = null;
                }
                return object2;
            }
            return object;
        }

        void readFields() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$200:(Ljava/io/ObjectInputStream;)Ljava/io/ObjectInputStream$BlockDataInputStream;");
            BlockDataInputStream blockDataInputStream = ObjectInputStream.this.bin;
            int n = this.primVals.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$BlockDataInputStream.readFully:([BIIZ)V");
            blockDataInputStream.readFully(this.primVals, 0, n, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$000:(Ljava/io/ObjectInputStream;)I");
            int n2 = ObjectInputStream.this.passHandle;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getFields:(Z)[Ljava/io/ObjectStreamField;");
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n3 = objectStreamFieldArray.length - this.objVals.length;
            int n4 = 0;
            while (true) {
                int n5 = this.objVals.length;
                RuntimeCostAccounter.recordJump();
                if (n4 >= n5) break;
                ObjectStreamField objectStreamField = objectStreamFieldArray[n3 + n4];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.isUnshared:()Z");
                boolean bl = objectStreamField.isUnshared();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$300:(Ljava/io/ObjectInputStream;Z)Ljava/lang/Object;");
                this.objVals[n4] = ObjectInputStream.access$300(ObjectInputStream.this, bl);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$000:(Ljava/io/ObjectInputStream;)I");
                this.objHandles[n4] = ObjectInputStream.this.passHandle;
                ++n4;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.access$002:(Ljava/io/ObjectInputStream;I)I");
            ObjectInputStream.this.passHandle = n2;
        }

        private int getFieldOffset(String string, Class<?> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getField:(Ljava/lang/String;Ljava/lang/Class;)Ljava/io/ObjectStreamField;");
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            RuntimeCostAccounter.recordJump();
            if (objectStreamField != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.getOffset:()I");
                return objectStreamField.getOffset();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getLocalDesc:()Ljava/io/ObjectStreamClass;");
            ObjectStreamClass objectStreamClass = this.desc.getLocalDesc();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getField:(Ljava/lang/String;Ljava/lang/Class;)Ljava/io/ObjectStreamField;");
            ObjectStreamField objectStreamField2 = objectStreamClass.getField(string, clazz);
            RuntimeCostAccounter.recordJump();
            if (objectStreamField2 != null) {
                return -1;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("no such field ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" with type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
    }

    public static abstract class GetField {
        public GetField() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException;

        public abstract boolean get(String var1, boolean var2) throws IOException;

        public abstract byte get(String var1, byte var2) throws IOException;

        public abstract char get(String var1, char var2) throws IOException;

        public abstract short get(String var1, short var2) throws IOException;

        public abstract int get(String var1, int var2) throws IOException;

        public abstract long get(String var1, long var2) throws IOException;

        public abstract float get(String var1, float var2) throws IOException;

        public abstract double get(String var1, double var2) throws IOException;

        public abstract Object get(String var1, Object var2) throws IOException;
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits;
        static final ReferenceQueue<Class<?>> subclassAuditsQueue;

        private Caches() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
            subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/ReferenceQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.<init>:()V");
            subclassAuditsQueue = new ReferenceQueue();
        }
    }
}

