package net.corda.core.identity

import net.corda.core.crypto.cert
import net.corda.core.crypto.entropyToKeyPair
import net.corda.core.internal.read
import net.corda.core.serialization.deserialize
import net.corda.core.serialization.serialize
import net.corda.node.utilities.KEYSTORE_TYPE
import net.corda.node.utilities.save
import net.corda.testing.getTestPartyAndCertificate
import net.corda.testing.withTestSerialization
import org.assertj.core.api.Assertions.assertThat
import org.bouncycastle.asn1.x500.X500Name
import org.junit.Test
import java.io.File
import java.math.BigInteger
import java.security.KeyStore

class PartyAndCertificateTest {
    @Test
    fun `kryo serialisation`() {
        withTestSerialization {
            val original = getTestPartyAndCertificate(Party(
                    X500Name("CN=Test Corp,O=Test Corp,L=Madrid,C=ES"),
                    entropyToKeyPair(BigInteger.valueOf(83)).public))
            val copy = original.serialize().deserialize()
            assertThat(copy).isEqualTo(original).isNotSameAs(original)
            assertThat(copy.certPath).isEqualTo(original.certPath)
            assertThat(copy.certificate).isEqualTo(original.certificate)
        }
    }

    @Test
    fun `jdk serialization`() {
        withTestSerialization {
            val identity = getTestPartyAndCertificate(Party(
                    X500Name("CN=Test Corp,O=Test Corp,L=Madrid,C=ES"),
                    entropyToKeyPair(BigInteger.valueOf(83)).public))
            val original = identity.certificate.cert
            val storePassword = "test"
            val keyStoreFilePath = File.createTempFile("serialization_test", "jks").toPath()
            var keyStore = KeyStore.getInstance(KEYSTORE_TYPE)
            keyStore.load(null, storePassword.toCharArray())
            keyStore.setCertificateEntry(identity.name.toString(), original)
            keyStore.save(keyStoreFilePath, storePassword)

            // Load the key store back in again
            keyStore = KeyStore.getInstance(KEYSTORE_TYPE)
            keyStoreFilePath.read { keyStore.load(it, storePassword.toCharArray()) }
            val copy = keyStore.getCertificate(identity.name.toString())
            assertThat(copy).isEqualTo(original) // .isNotSameAs(original)
        }
    }
}
