/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.security.AccessControlContext;
import sandbox.java.security.AccessController;
import sandbox.java.security.Permission;
import sandbox.java.security.PermissionCollection;
import sandbox.java.security.Permissions;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.ProtectionDomain;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Collections;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.concurrent.AbstractExecutorService;
import sandbox.java.util.concurrent.Callable;
import sandbox.java.util.concurrent.CountedCompleter;
import sandbox.java.util.concurrent.ForkJoinTask;
import sandbox.java.util.concurrent.ForkJoinWorkerThread;
import sandbox.java.util.concurrent.Future;
import sandbox.java.util.concurrent.RejectedExecutionException;
import sandbox.java.util.concurrent.RunnableFuture;
import sandbox.java.util.concurrent.ThreadLocalRandom;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.sun.misc.Contended;
import sandbox.sun.misc.Unsafe;

@Contended
public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int commonParallelism;
    private static int poolNumberSequence;
    private static final long IDLE_TIMEOUT = 2000000000L;
    private static final long FAST_IDLE_TIMEOUT = 200000000L;
    private static final long TIMEOUT_SLOP = 2000000L;
    private static final int MAX_HELP = 64;
    private static final int SEED_INCREMENT = -1640531527;
    private static final int AC_SHIFT = 48;
    private static final int TC_SHIFT = 32;
    private static final int ST_SHIFT = 31;
    private static final int EC_SHIFT = 16;
    private static final int SMASK = 65535;
    private static final int MAX_CAP = Short.MAX_VALUE;
    private static final int EVENMASK = 65534;
    private static final int SQMASK = 126;
    private static final int SHORT_SIGN = 32768;
    private static final int INT_SIGN = Integer.MIN_VALUE;
    private static final long STOP_BIT = 0x80000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long TC_UNIT = 0x100000000L;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final int UAC_SHIFT = 16;
    private static final int UTC_SHIFT = 0;
    private static final int UAC_MASK = -65536;
    private static final int UTC_MASK = 65535;
    private static final int UAC_UNIT = 65536;
    private static final int UTC_UNIT = 1;
    private static final int E_MASK = Integer.MAX_VALUE;
    private static final int E_SEQ = 65536;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    private static final int PL_LOCK = 2;
    private static final int PL_SIGNAL = 1;
    private static final int PL_SPINS = 256;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 1;
    static final int SHARED_QUEUE = -1;
    volatile long stealCount;
    volatile long ctl;
    volatile int plock;
    volatile int indexSeed;
    final short parallelism;
    final short mode;
    WorkQueue[] workQueues;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final String workerNamePrefix;
    private static final Unsafe U;
    private static final long CTL;
    private static final long PARKBLOCKER;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final long STEALCOUNT;
    private static final long PLOCK;
    private static final long INDEXSEED;
    private static final long QBASE;
    private static final long QLOCK;

    private static void checkPermission() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)modifyThreadPermission);
        }
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquirePlock() {
        int n = 256;
        while (true) {
            block10: {
                int n2 = this.plock;
                RuntimeCostAccounter.recordJump();
                if ((n2 & 2) == 0) {
                    int n3 = n2 + 2;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                    boolean bl = U.compareAndSwapInt((Object)this, PLOCK, n2, n3);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return n3;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (n >= 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSecondarySeed:()I");
                    int n4 = ThreadLocalRandom.nextSecondarySeed();
                    RuntimeCostAccounter.recordJump();
                    if (n4 < 0) continue;
                    --n;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                boolean bl = U.compareAndSwapInt((Object)this, PLOCK, n2, n2 | 1);
                RuntimeCostAccounter.recordJump();
                if (!bl) continue;
                try {
                    block11: {
                        RuntimeCostAccounter.recordJump();
                        if ((this.plock & 1) == 0) break block11;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:()V");
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                                Thread thread = Thread.currentThread();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                                thread.interrupt();
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                            RuntimeCostAccounter.recordJump();
                            RuntimeCostAccounter.recordJump();
                            break block10;
                        }
                        RuntimeCostAccounter.recordJump();
                        break block10;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
                    this.notifyAll();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releasePlock(int n) {
        this.plock = n;
        ForkJoinPool forkJoinPool = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
            this.notifyAll();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    private void tryAddWorker() {
        while (true) {
            block4: {
                ForkJoinWorkerThread forkJoinWorkerThread;
                Throwable throwable;
                block3: {
                    long l = this.ctl;
                    int n = (int)(l >>> 32);
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) break;
                    RuntimeCostAccounter.recordJump();
                    if ((n & 0x8000) == 0) break;
                    int n2 = (int)l;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break;
                    long l2 = (long)(n + 1 & 0xFFFF | n + 65536 & 0xFFFF0000) << 32 | (long)n2;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, CTL, l, l2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block4;
                    throwable = null;
                    forkJoinWorkerThread = null;
                    try {
                        ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = this.factory;
                        RuntimeCostAccounter.recordJump();
                        if (forkJoinWorkerThreadFactory == null) break block3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory.newThread:(Ljava/util/concurrent/ForkJoinPool;)Ljava/util/concurrent/ForkJoinWorkerThread;");
                        forkJoinWorkerThread = forkJoinWorkerThreadFactory.newThread(this);
                        RuntimeCostAccounter.recordJump();
                        if (forkJoinWorkerThread == null) break block3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread.start:()V");
                        forkJoinWorkerThread.start();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.deregisterWorker:(Ljava/util/concurrent/ForkJoinWorkerThread;Ljava/lang/Throwable;)V");
                this.deregisterWorker(forkJoinWorkerThread, throwable);
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread forkJoinWorkerThread) {
        int n;
        int n2;
        WorkQueue workQueue;
        block14: {
            int n3;
            block16: {
                block15: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread.setDaemon:(Z)V");
                    forkJoinWorkerThread.setDaemon(true);
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.ueh;
                    RuntimeCostAccounter.recordJump();
                    if (uncaughtExceptionHandler != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread.setUncaughtExceptionHandler:(Ljava/lang/Thread$UncaughtExceptionHandler;)V");
                        forkJoinWorkerThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                    }
                    while (true) {
                        n3 = this.indexSeed;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                        boolean bl = U.compareAndSwapInt((Object)this, INDEXSEED, n3, n3 -= 1640531527);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) continue;
                        RuntimeCostAccounter.recordJump();
                        if (n3 != 0) break;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool$WorkQueue");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.<init>:(Ljava/util/concurrent/ForkJoinPool;Ljava/util/concurrent/ForkJoinWorkerThread;II)V");
                    workQueue = new WorkQueue(this, forkJoinWorkerThread, this.mode, n3);
                    n2 = this.plock;
                    RuntimeCostAccounter.recordJump();
                    if ((n2 & 2) != 0) break block15;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                    boolean bl = U.compareAndSwapInt((Object)this, PLOCK, n2, n2 += 2);
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block16;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.acquirePlock:()I");
                n2 = this.acquirePlock();
            }
            n = n2 & Integer.MIN_VALUE | n2 + 2 & Integer.MAX_VALUE;
            try {
                WorkQueue[] workQueueArray = this.workQueues;
                RuntimeCostAccounter.recordJump();
                if (this.workQueues == null) break block14;
                int n4 = workQueueArray.length;
                int n5 = n4 - 1;
                int n6 = n3 << 1 | 1;
                WorkQueue workQueue2 = workQueueArray[n6 &= n5];
                RuntimeCostAccounter.recordJump();
                if (workQueue2 != null) {
                    int n7;
                    int n8 = 0;
                    RuntimeCostAccounter.recordJump();
                    if (n4 <= 4) {
                        n7 = 2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n7 = (n4 >>> 1 & 0xFFFE) + 2;
                    }
                    int n9 = n7;
                    while (true) {
                        n6 = n6 + n9 & n5;
                        WorkQueue workQueue3 = workQueueArray[n6];
                        RuntimeCostAccounter.recordJump();
                        if (workQueue3 == null) break;
                        RuntimeCostAccounter.recordJump();
                        if (++n8 < n4) continue;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                        this.workQueues = workQueueArray = Arrays.copyOf(workQueueArray, n4 <<= 1);
                        n5 = n4 - 1;
                        n8 = 0;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                workQueue.poolIndex = (short)n6;
                workQueue.eventCount = n6;
                workQueueArray[n6] = workQueue;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                boolean bl = U.compareAndSwapInt((Object)this, PLOCK, n2, n);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.releasePlock:(I)V");
                    this.releasePlock(n);
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        boolean bl = U.compareAndSwapInt((Object)this, PLOCK, n2, n);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.releasePlock:(I)V");
            this.releasePlock(n);
            RuntimeCostAccounter.recordJump();
        }
        int n10 = workQueue.poolIndex >>> 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
        String string = Integer.toString(n10);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.concat:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = this.workerNamePrefix.concat(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread.setName:(Ljava/lang/String;)V");
        forkJoinWorkerThread.setName(string2);
        return workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread forkJoinWorkerThread, Throwable throwable) {
        block22: {
            long l;
            boolean bl;
            Object object;
            WorkQueue workQueue;
            block23: {
                int n;
                int n2;
                block21: {
                    block25: {
                        block24: {
                            workQueue = null;
                            RuntimeCostAccounter.recordJump();
                            if (forkJoinWorkerThread == null) break block23;
                            workQueue = forkJoinWorkerThread.workQueue;
                            RuntimeCostAccounter.recordJump();
                            if (workQueue == null) break block23;
                            workQueue.qlock = -1;
                            long l2 = workQueue.nsteals;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddLong:(Ljava/lang/Object;JJ)J");
                            U.getAndAddLong((Object)this, STEALCOUNT, l2);
                            n2 = this.plock;
                            RuntimeCostAccounter.recordJump();
                            if ((n2 & 2) != 0) break block24;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                            boolean bl2 = U.compareAndSwapInt((Object)this, PLOCK, n2, n2 += 2);
                            RuntimeCostAccounter.recordJump();
                            if (bl2) break block25;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.acquirePlock:()I");
                        n2 = this.acquirePlock();
                    }
                    n = n2 & Integer.MIN_VALUE | n2 + 2 & Integer.MAX_VALUE;
                    try {
                        short s = workQueue.poolIndex;
                        object = this.workQueues;
                        RuntimeCostAccounter.recordJump();
                        if (object == null) break block21;
                        RuntimeCostAccounter.recordJump();
                        if (s < 0) break block21;
                        int n3 = ((WorkQueue[])object).length;
                        RuntimeCostAccounter.recordJump();
                        if (s >= n3) break block21;
                        WorkQueue workQueue2 = object[s];
                        RuntimeCostAccounter.recordJump();
                        if (workQueue2 != workQueue) break block21;
                        object[s] = null;
                    }
                    catch (Throwable throwable2) {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                        boolean bl3 = U.compareAndSwapInt((Object)this, PLOCK, n2, n);
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.releasePlock:(I)V");
                            this.releasePlock(n);
                        }
                        RuntimeCostAccounter.recordThrow();
                        throw throwable2;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                boolean bl4 = U.compareAndSwapInt((Object)this, PLOCK, n2, n);
                RuntimeCostAccounter.recordJump();
                if (!bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.releasePlock:(I)V");
                    this.releasePlock(n);
                    RuntimeCostAccounter.recordJump();
                }
            }
            do {
                l = this.ctl;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                bl = U.compareAndSwapLong((Object)this, CTL, l, l - 0x1000000000000L & 0xFFFF000000000000L | l - 0x100000000L & 0xFFFF00000000L | l & 0xFFFFFFFFL);
                RuntimeCostAccounter.recordJump();
            } while (!bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryTerminate:(ZZ)Z");
            boolean bl5 = this.tryTerminate(false, false);
            RuntimeCostAccounter.recordJump();
            if (!bl5) {
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTaskArray != null) {
                        int n;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.cancelAll:()V");
                        workQueue.cancelAll();
                        while (true) {
                            l = this.ctl;
                            n = (int)(l >>> 32);
                            RuntimeCostAccounter.recordJump();
                            if (n >= 0) break block22;
                            int n4 = (int)l;
                            RuntimeCostAccounter.recordJump();
                            if (n4 < 0) break block22;
                            RuntimeCostAccounter.recordJump();
                            if (n4 <= 0) break;
                            WorkQueue[] workQueueArray = this.workQueues;
                            RuntimeCostAccounter.recordJump();
                            if (this.workQueues == null) break block22;
                            int n5 = n4 & 0xFFFF;
                            int n6 = workQueueArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n5 >= n6) break block22;
                            object = workQueueArray[n5];
                            RuntimeCostAccounter.recordJump();
                            if (object == null) {
                                RuntimeCostAccounter.recordJump();
                                break block22;
                            }
                            long l3 = (long)(object.nextWait & Integer.MAX_VALUE) | (long)(n + 65536) << 32;
                            int n7 = object.eventCount;
                            RuntimeCostAccounter.recordJump();
                            if (n7 != (n4 | Integer.MIN_VALUE)) {
                                RuntimeCostAccounter.recordJump();
                                break block22;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                            boolean bl6 = U.compareAndSwapLong((Object)this, CTL, l, l3);
                            RuntimeCostAccounter.recordJump();
                            if (bl6) {
                                object.eventCount = n4 + 65536 & Integer.MAX_VALUE;
                                Thread thread = object.parker;
                                RuntimeCostAccounter.recordJump();
                                if (thread != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                    U.unpark((Object)thread);
                                    RuntimeCostAccounter.recordJump();
                                }
                                break block22;
                            }
                            RuntimeCostAccounter.recordJump();
                        }
                        short s = (short)n;
                        RuntimeCostAccounter.recordJump();
                        if (s < 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryAddWorker:()V");
                            this.tryAddWorker();
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        if (throwable == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.helpExpungeStaleExceptions:()V");
            ForkJoinTask.helpExpungeStaleExceptions();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.rethrow:(Ljava/lang/Throwable;)V");
            ForkJoinTask.rethrow(throwable);
        }
    }

    final void externalPush(ForkJoinTask<?> forkJoinTask) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.getProbe:()I");
        int n = ThreadLocalRandom.getProbe();
        int n2 = this.plock;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordJump();
            if (workQueueArray != null) {
                int n3 = workQueueArray.length - 1;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    WorkQueue workQueue = workQueueArray[n3 & n & 0x7E];
                    RuntimeCostAccounter.recordJump();
                    if (workQueue != null) {
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                            boolean bl = U.compareAndSwapInt((Object)workQueue, QLOCK, 0, 1);
                            RuntimeCostAccounter.recordJump();
                            if (bl) {
                                ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                                RuntimeCostAccounter.recordJump();
                                if (workQueue.array != null) {
                                    int n4 = forkJoinTaskArray.length - 1;
                                    int n5 = workQueue.top;
                                    int n6 = n5 - workQueue.base;
                                    RuntimeCostAccounter.recordJump();
                                    if (n4 > n6) {
                                        int n7 = ((n4 & n5) << ASHIFT) + ABASE;
                                        long l = n7;
                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                                        U.putOrderedObject(forkJoinTaskArray, l, forkJoinTask);
                                        workQueue.top = n5 + 1;
                                        workQueue.qlock = 0;
                                        RuntimeCostAccounter.recordJump();
                                        if (n6 <= 1) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.signalWork:([Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinPool$WorkQueue;)V");
                                            this.signalWork(workQueueArray, workQueue);
                                        }
                                        return;
                                    }
                                }
                                workQueue.qlock = 0;
                            }
                        }
                    }
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.fullExternalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.fullExternalPush(forkJoinTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fullExternalPush(ForkJoinTask<?> var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.getProbe:()I");
        var2_2 = ThreadLocalRandom.getProbe();
        RuntimeCostAccounter.recordJump();
        if (var2_2 == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.localInit:()V");
            ThreadLocalRandom.localInit();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.getProbe:()I");
            var2_2 = ThreadLocalRandom.getProbe();
        }
        while (true) {
            block35: {
                block41: {
                    block43: {
                        block42: {
                            block36: {
                                block37: {
                                    block30: {
                                        block34: {
                                            block33: {
                                                block32: {
                                                    block31: {
                                                        block29: {
                                                            var3_3 = false;
                                                            var4_4 = this.plock;
                                                            RuntimeCostAccounter.recordJump();
                                                            if (var4_4 < 0) {
                                                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/RejectedExecutionException");
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RejectedExecutionException.<init>:()V");
                                                                v0 = new RejectedExecutionException();
                                                                RuntimeCostAccounter.recordThrow();
                                                                throw v0;
                                                            }
                                                            RuntimeCostAccounter.recordJump();
                                                            if (var4_4 == 0) break block29;
                                                            var5_5 = this.workQueues;
                                                            RuntimeCostAccounter.recordJump();
                                                            if (this.workQueues == null) break block29;
                                                            var6_6 = var5_5.length - 1;
                                                            RuntimeCostAccounter.recordJump();
                                                            if (var6_6 >= 0) break block30;
                                                        }
                                                        var7_7 = this.parallelism;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (var7_7 > 1) {
                                                            v1 = var7_7 - 1;
                                                            RuntimeCostAccounter.recordJump();
                                                        } else {
                                                            v1 = 1;
                                                        }
                                                        var8_9 = v1;
                                                        var8_9 |= var8_9 >>> 1;
                                                        var8_9 |= var8_9 >>> 2;
                                                        var8_9 |= var8_9 >>> 4;
                                                        var8_9 |= var8_9 >>> 8;
                                                        var8_9 |= var8_9 >>> 16;
                                                        var8_9 = var8_9 + 1 << 1;
                                                        var5_5 = this.workQueues;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (this.workQueues == null) ** GOTO lbl-1000
                                                        v2 = var5_5.length;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (v2 == 0) lbl-1000:
                                                        // 2 sources

                                                        {
                                                            v3 = var8_9;
                                                            RuntimeCostAccounter.recordArrayAllocation((int)v3, (int)8);
                                                            v4 = new WorkQueue[v3];
                                                            RuntimeCostAccounter.recordJump();
                                                        } else {
                                                            v4 = null;
                                                        }
                                                        var9_10 = v4;
                                                        var4_4 = this.plock;
                                                        RuntimeCostAccounter.recordJump();
                                                        if ((var4_4 & 2) != 0) break block31;
                                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                                                        v5 = ForkJoinPool.U.compareAndSwapInt((Object)this, ForkJoinPool.PLOCK, var4_4, var4_4 += 2);
                                                        RuntimeCostAccounter.recordJump();
                                                        if (v5) break block32;
                                                    }
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.acquirePlock:()I");
                                                    var4_4 = this.acquirePlock();
                                                }
                                                var5_5 = this.workQueues;
                                                RuntimeCostAccounter.recordJump();
                                                if (this.workQueues == null) break block33;
                                                v6 = var5_5.length;
                                                RuntimeCostAccounter.recordJump();
                                                if (v6 != 0) break block34;
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            if (var9_10 != null) {
                                                this.workQueues = var9_10;
                                            }
                                        }
                                        var10_12 = var4_4 & -2147483648 | var4_4 + 2 & 0x7FFFFFFF;
                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                                        v7 = ForkJoinPool.U.compareAndSwapInt((Object)this, ForkJoinPool.PLOCK, var4_4, var10_12);
                                        RuntimeCostAccounter.recordJump();
                                        if (!v7) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.releasePlock:(I)V");
                                            this.releasePlock(var10_12);
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        break block35;
                                    }
                                    var11_13 = var2_2 & var6_6 & 126;
                                    var12_14 = var5_5[var11_13];
                                    RuntimeCostAccounter.recordJump();
                                    if (var12_14 == null) break block36;
                                    v8 = var12_14.qlock;
                                    RuntimeCostAccounter.recordJump();
                                    if (v8 != 0) break block37;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                                    v9 = ForkJoinPool.U.compareAndSwapInt((Object)var12_14, ForkJoinPool.QLOCK, 0, 1);
                                    RuntimeCostAccounter.recordJump();
                                    if (!v9) break block37;
                                    var7_8 = var12_14.array;
                                    var8_9 = var12_14.top;
                                    var9_11 = false;
                                    try {
                                        block40: {
                                            block39: {
                                                block38: {
                                                    RuntimeCostAccounter.recordJump();
                                                    if (var7_8 == null) break block38;
                                                    v10 = var7_8.length;
                                                    v11 = var8_9 + 1 - var12_14.base;
                                                    RuntimeCostAccounter.recordJump();
                                                    if (v10 > v11) break block39;
                                                }
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.growArray:()[Ljava/util/concurrent/ForkJoinTask;");
                                                var7_8 = var12_14.growArray();
                                                RuntimeCostAccounter.recordJump();
                                                if (var7_8 == null) break block40;
                                            }
                                            var10_12 = ((var7_8.length - 1 & var8_9) << ForkJoinPool.ASHIFT) + ForkJoinPool.ABASE;
                                            v12 = var10_12;
                                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                                            ForkJoinPool.U.putOrderedObject(var7_8, v12, var1_1);
                                            var12_14.top = var8_9 + 1;
                                            var9_11 = true;
                                        }
                                        var12_14.qlock = 0;
                                    }
                                    catch (Throwable var13_15) {
                                        var12_14.qlock = 0;
                                        RuntimeCostAccounter.recordThrow();
                                        throw var13_15;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    RuntimeCostAccounter.recordJump();
                                    if (var9_11) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.signalWork:([Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinPool$WorkQueue;)V");
                                        this.signalWork(var5_5, var12_14);
                                        return;
                                    }
                                }
                                var3_3 = true;
                                RuntimeCostAccounter.recordJump();
                                break block35;
                            }
                            var4_4 = this.plock;
                            RuntimeCostAccounter.recordJump();
                            if ((var4_4 & 2) != 0) break block41;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool$WorkQueue");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.<init>:(Ljava/util/concurrent/ForkJoinPool;Ljava/util/concurrent/ForkJoinWorkerThread;II)V");
                            var12_14 = new WorkQueue(this, null, -1, var2_2);
                            var12_14.poolIndex = (short)var11_13;
                            var4_4 = this.plock;
                            RuntimeCostAccounter.recordJump();
                            if ((var4_4 & 2) != 0) break block42;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                            v13 = ForkJoinPool.U.compareAndSwapInt((Object)this, ForkJoinPool.PLOCK, var4_4, var4_4 += 2);
                            RuntimeCostAccounter.recordJump();
                            if (v13) break block43;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.acquirePlock:()I");
                        var4_4 = this.acquirePlock();
                    }
                    var5_5 = this.workQueues;
                    RuntimeCostAccounter.recordJump();
                    if (this.workQueues != null) {
                        v14 = var5_5.length;
                        RuntimeCostAccounter.recordJump();
                        if (var11_13 < v14) {
                            v15 = var5_5[var11_13];
                            RuntimeCostAccounter.recordJump();
                            if (v15 == null) {
                                var5_5[var11_13] = var12_14;
                            }
                        }
                    }
                    var7_7 = var4_4 & -2147483648 | var4_4 + 2 & 0x7FFFFFFF;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                    v16 = ForkJoinPool.U.compareAndSwapInt((Object)this, ForkJoinPool.PLOCK, var4_4, var7_7);
                    RuntimeCostAccounter.recordJump();
                    if (!v16) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.releasePlock:(I)V");
                        this.releasePlock(var7_7);
                    }
                    RuntimeCostAccounter.recordJump();
                    break block35;
                }
                var3_3 = true;
            }
            RuntimeCostAccounter.recordJump();
            if (var3_3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.advanceProbe:(I)I");
                var2_2 = ThreadLocalRandom.advanceProbe(var2_2);
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    final void incrementActiveCount() {
        boolean bl;
        do {
            long l = this.ctl;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
            bl = U.compareAndSwapLong((Object)this, CTL, l, l & 0xFFFFFFFFFFFFL | (l & 0xFFFF000000000000L) + 0x1000000000000L);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
    }

    final void signalWork(WorkQueue[] workQueueArray, WorkQueue workQueue) {
        while (true) {
            long l = this.ctl;
            int n = (int)(l >>> 32);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            int n2 = (int)l;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) {
                short s = (short)n;
                RuntimeCostAccounter.recordJump();
                if (s >= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryAddWorker:()V");
                this.tryAddWorker();
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordJump();
            if (workQueueArray == null) break;
            int n3 = workQueueArray.length;
            int n4 = n2 & 0xFFFF;
            RuntimeCostAccounter.recordJump();
            if (n3 <= n4) break;
            WorkQueue workQueue2 = workQueueArray[n4];
            RuntimeCostAccounter.recordJump();
            if (workQueue2 == null) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            long l2 = (long)(workQueue2.nextWait & Integer.MAX_VALUE) | (long)(n + 65536) << 32;
            int n5 = n2 + 65536 & Integer.MAX_VALUE;
            int n6 = workQueue2.eventCount;
            RuntimeCostAccounter.recordJump();
            if (n6 == (n2 | Integer.MIN_VALUE)) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl = U.compareAndSwapLong((Object)this, CTL, l, l2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    workQueue2.eventCount = n5;
                    Thread thread = workQueue2.parker;
                    RuntimeCostAccounter.recordJump();
                    if (thread == null) break;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                    U.unpark((Object)thread);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (workQueue != null) {
                int n7 = workQueue.base;
                int n8 = workQueue.top;
                RuntimeCostAccounter.recordJump();
                if (n7 >= n8) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    final void runWorker(WorkQueue workQueue) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.growArray:()[Ljava/util/concurrent/ForkJoinTask;");
        workQueue.growArray();
        int n = workQueue.hint;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.scan:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;I)I");
            int n2 = this.scan(workQueue, n);
            RuntimeCostAccounter.recordJump();
            if (n2 != 0) break;
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
            RuntimeCostAccounter.recordJump();
        }
    }

    private final int scan(WorkQueue workQueue, int n) {
        long l = this.ctl;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n2 = workQueueArray.length - 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= 0) {
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    int n3 = n2 + n2 + 1;
                    int n4 = workQueue.eventCount;
                    while (true) {
                        WorkQueue workQueue2 = workQueueArray[n - n3 & n2];
                        RuntimeCostAccounter.recordJump();
                        if (workQueue2 != null) {
                            int n5 = workQueue2.base;
                            int n6 = n5 - workQueue2.top;
                            RuntimeCostAccounter.recordJump();
                            if (n6 < 0) {
                                ForkJoinTask<?>[] forkJoinTaskArray = workQueue2.array;
                                RuntimeCostAccounter.recordJump();
                                if (workQueue2.array != null) {
                                    long l2 = ((forkJoinTaskArray.length - 1 & n5) << ASHIFT) + ABASE;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
                                    ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, l2);
                                    RuntimeCostAccounter.recordJump();
                                    if (forkJoinTask == null) break;
                                    RuntimeCostAccounter.recordJump();
                                    if (n4 < 0) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.helpRelease:(J[Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinPool$WorkQueue;I)V");
                                        this.helpRelease(l, workQueueArray, workQueue, workQueue2, n5);
                                        RuntimeCostAccounter.recordJump();
                                        break;
                                    }
                                    int n7 = workQueue2.base;
                                    RuntimeCostAccounter.recordJump();
                                    if (n7 != n5) break;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    boolean bl = U.compareAndSwapObject(forkJoinTaskArray, l2, (Object)forkJoinTask, null);
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl) break;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
                                    U.putOrderedInt((Object)workQueue2, QBASE, n5 + 1);
                                    int n8 = n5 + 1 - workQueue2.top;
                                    RuntimeCostAccounter.recordJump();
                                    if (n8 < 0) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.signalWork:([Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinPool$WorkQueue;)V");
                                        this.signalWork(workQueueArray, workQueue2);
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.runTask:(Ljava/util/concurrent/ForkJoinTask;)V");
                                    workQueue.runTask(forkJoinTask);
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (--n3 < 0) {
                            int n9 = (int)l;
                            RuntimeCostAccounter.recordJump();
                            if ((n4 | n9) < 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.awaitWork:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;JI)I");
                                return this.awaitWork(workQueue, l, n4);
                            }
                            RuntimeCostAccounter.recordJump();
                            if (this.ctl != l) break;
                            long l3 = (long)n4 | l - 0x1000000000000L & 0xFFFFFFFF00000000L;
                            workQueue.nextWait = n9;
                            workQueue.eventCount = n4 | Integer.MIN_VALUE;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                            boolean bl = U.compareAndSwapLong((Object)this, CTL, l, l3);
                            RuntimeCostAccounter.recordJump();
                            if (!bl) {
                                workQueue.eventCount = n4;
                            }
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private final int awaitWork(WorkQueue var1_1, long var2_2, int var4_3) {
        block14: {
            block17: {
                block16: {
                    block15: {
                        var5_4 = var1_1.qlock;
                        RuntimeCostAccounter.recordJump();
                        if (var5_4 < 0) break block14;
                        v0 = var1_1.eventCount;
                        RuntimeCostAccounter.recordJump();
                        if (v0 != var4_3) break block14;
                        RuntimeCostAccounter.recordJump();
                        if (this.ctl != var2_2) break block14;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                        v1 = Thread.interrupted();
                        RuntimeCostAccounter.recordJump();
                        if (v1) break block14;
                        var6_5 = (int)var2_2;
                        var7_6 = (int)(var2_2 >>> 32);
                        var8_7 = (var7_6 >> 16) + this.parallelism;
                        RuntimeCostAccounter.recordJump();
                        if (var6_5 < 0) break block15;
                        RuntimeCostAccounter.recordJump();
                        if (var8_7 > 0) break block16;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryTerminate:(ZZ)Z");
                        v2 = this.tryTerminate(false, false);
                        RuntimeCostAccounter.recordJump();
                        if (!v2) break block16;
                    }
                    var1_1.qlock = -1;
                    var5_4 = -1;
                    RuntimeCostAccounter.recordJump();
                    break block14;
                }
                var9_8 = var1_1.nsteals;
                RuntimeCostAccounter.recordJump();
                if (var9_8 == 0) break block17;
                var1_1.nsteals = 0;
                v3 = var9_8;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddLong:(Ljava/lang/Object;JJ)J");
                ForkJoinPool.U.getAndAddLong((Object)this, ForkJoinPool.STEALCOUNT, v3);
                RuntimeCostAccounter.recordJump();
                break block14;
            }
            RuntimeCostAccounter.recordJump();
            if (var8_7 > 0) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var4_3 != (var6_5 | -2147483648)) lbl-1000:
            // 2 sources

            {
                v4 = 0L;
                RuntimeCostAccounter.recordJump();
            } else {
                v4 = (long)(var1_1.nextWait & 0x7FFFFFFF) | (long)(var7_6 + 65536) << 32;
            }
            var10_9 = v4;
            RuntimeCostAccounter.recordJump();
            if (var10_9 != 0L) {
                var12_10 = -((short)(var2_2 >>> 32));
                RuntimeCostAccounter.recordJump();
                if (var12_10 < 0) {
                    v5 = 200000000L;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v5 = (long)(var12_10 + 1) * 2000000000L;
                }
                var13_12 = v5;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                var15_13 = System.nanoTime() + var13_12 - 2000000L;
                RuntimeCostAccounter.recordJump();
            } else {
                var15_13 = 0L;
                var13_12 = 0L;
            }
            v6 = var1_1.eventCount;
            RuntimeCostAccounter.recordJump();
            if (v6 == var4_3) {
                RuntimeCostAccounter.recordJump();
                if (this.ctl == var2_2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                    var12_11 = Thread.currentThread();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                    ForkJoinPool.U.putObject((Object)var12_11, ForkJoinPool.PARKBLOCKER, (Object)this);
                    var1_1.parker = var12_11;
                    v7 = var1_1.eventCount;
                    RuntimeCostAccounter.recordJump();
                    if (v7 == var4_3) {
                        RuntimeCostAccounter.recordJump();
                        if (this.ctl == var2_2) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
                            ForkJoinPool.U.park(false, var13_12);
                        }
                    }
                    var1_1.parker = null;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                    ForkJoinPool.U.putObject((Object)var12_11, ForkJoinPool.PARKBLOCKER, null);
                    RuntimeCostAccounter.recordJump();
                    if (var13_12 != 0L) {
                        RuntimeCostAccounter.recordJump();
                        if (this.ctl == var2_2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                            cfr_temp_0 = var15_13 - System.nanoTime() - 0L;
                            v8 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                            RuntimeCostAccounter.recordJump();
                            if (v8 <= 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                                v9 = ForkJoinPool.U.compareAndSwapLong((Object)this, ForkJoinPool.CTL, var2_2, var10_9);
                                RuntimeCostAccounter.recordJump();
                                if (v9) {
                                    var1_1.qlock = -1;
                                    var5_4 = -1;
                                }
                            }
                        }
                    }
                }
            }
        }
        return var5_4;
    }

    private final void helpRelease(long l, WorkQueue[] workQueueArray, WorkQueue workQueue, WorkQueue workQueue2, int n) {
        RuntimeCostAccounter.recordJump();
        if (workQueue != null) {
            int n2 = workQueue.eventCount;
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                int n3 = (int)l;
                RuntimeCostAccounter.recordJump();
                if (n3 > 0) {
                    RuntimeCostAccounter.recordJump();
                    if (workQueueArray != null) {
                        int n4 = workQueueArray.length;
                        int n5 = n3 & 0xFFFF;
                        RuntimeCostAccounter.recordJump();
                        if (n4 > n5) {
                            WorkQueue workQueue3 = workQueueArray[n5];
                            RuntimeCostAccounter.recordJump();
                            if (workQueue3 != null) {
                                RuntimeCostAccounter.recordJump();
                                if (this.ctl == l) {
                                    long l2 = (long)(workQueue3.nextWait & Integer.MAX_VALUE) | (long)((int)(l >>> 32) + 65536) << 32;
                                    int n6 = n3 + 65536 & Integer.MAX_VALUE;
                                    RuntimeCostAccounter.recordJump();
                                    if (workQueue2 != null) {
                                        int n7 = workQueue2.base;
                                        RuntimeCostAccounter.recordJump();
                                        if (n7 == n) {
                                            int n8 = workQueue.eventCount;
                                            RuntimeCostAccounter.recordJump();
                                            if (n8 < 0) {
                                                int n9 = workQueue3.eventCount;
                                                RuntimeCostAccounter.recordJump();
                                                if (n9 == (n3 | Integer.MIN_VALUE)) {
                                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                                                    boolean bl = U.compareAndSwapLong((Object)this, CTL, l, l2);
                                                    RuntimeCostAccounter.recordJump();
                                                    if (bl) {
                                                        workQueue3.eventCount = n6;
                                                        Thread thread = workQueue3.parker;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (thread != null) {
                                                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                                            U.unpark((Object)thread);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int tryHelpStealer(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        int n = 0;
        int n2 = 0;
        RuntimeCostAccounter.recordJump();
        if (forkJoinTask == null) return n;
        RuntimeCostAccounter.recordJump();
        if (workQueue == null) return n;
        int n3 = workQueue.base - workQueue.top;
        RuntimeCostAccounter.recordJump();
        if (n3 < 0) return n;
        block0: while (true) {
            ForkJoinTask<?> forkJoinTask2 = forkJoinTask;
            WorkQueue workQueue2 = workQueue;
            while (true) {
                WorkQueue workQueue3;
                block20: {
                    int n4;
                    int n5;
                    WorkQueue[] workQueueArray;
                    block21: {
                        int n6 = forkJoinTask.status;
                        RuntimeCostAccounter.recordJump();
                        if (n6 < 0) {
                            n = n6;
                            RuntimeCostAccounter.recordJump();
                            return n;
                        }
                        workQueueArray = this.workQueues;
                        RuntimeCostAccounter.recordJump();
                        if (this.workQueues == null) return n;
                        n5 = workQueueArray.length - 1;
                        RuntimeCostAccounter.recordJump();
                        if (n5 <= 0) {
                            RuntimeCostAccounter.recordJump();
                            return n;
                        }
                        n4 = (workQueue2.hint | 1) & n5;
                        workQueue3 = workQueueArray[n4];
                        RuntimeCostAccounter.recordJump();
                        if (workQueue3 == null) break block21;
                        ForkJoinTask<?> forkJoinTask3 = workQueue3.currentSteal;
                        RuntimeCostAccounter.recordJump();
                        if (forkJoinTask3 == forkJoinTask2) break block20;
                    }
                    int n7 = n4;
                    do {
                        n4 = n4 + 2 & n5;
                        RuntimeCostAccounter.recordJump();
                        if ((n4 & 0xF) == 1) {
                            int n8 = forkJoinTask2.status;
                            RuntimeCostAccounter.recordJump();
                            if (n8 < 0) continue block0;
                            ForkJoinTask<?> forkJoinTask4 = workQueue2.currentJoin;
                            RuntimeCostAccounter.recordJump();
                            if (forkJoinTask4 != forkJoinTask2) {
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                        }
                        workQueue3 = workQueueArray[n4];
                        RuntimeCostAccounter.recordJump();
                        if (workQueue3 != null) {
                            ForkJoinTask<?> forkJoinTask5 = workQueue3.currentSteal;
                            RuntimeCostAccounter.recordJump();
                            if (forkJoinTask5 == forkJoinTask2) {
                                workQueue2.hint = n4;
                                RuntimeCostAccounter.recordJump();
                                break block20;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    } while (n4 != n7);
                    RuntimeCostAccounter.recordJump();
                    return n;
                }
                while (true) {
                    int n9 = forkJoinTask2.status;
                    RuntimeCostAccounter.recordJump();
                    if (n9 < 0) {
                        RuntimeCostAccounter.recordJump();
                        continue block0;
                    }
                    int n10 = workQueue3.base;
                    int n11 = n10 - workQueue3.top;
                    RuntimeCostAccounter.recordJump();
                    if (n11 >= 0) break;
                    ForkJoinTask<?>[] forkJoinTaskArray = workQueue3.array;
                    RuntimeCostAccounter.recordJump();
                    if (workQueue3.array == null) break;
                    int n12 = ((forkJoinTaskArray.length - 1 & n10) << ASHIFT) + ABASE;
                    long l = n12;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
                    ForkJoinTask<?> forkJoinTask6 = (ForkJoinTask<?>)U.getObjectVolatile(forkJoinTaskArray, l);
                    int n13 = forkJoinTask2.status;
                    RuntimeCostAccounter.recordJump();
                    if (n13 < 0) continue block0;
                    ForkJoinTask<?> forkJoinTask7 = workQueue2.currentJoin;
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTask7 != forkJoinTask2) continue block0;
                    ForkJoinTask<?> forkJoinTask8 = workQueue3.currentSteal;
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTask8 != forkJoinTask2) {
                        RuntimeCostAccounter.recordJump();
                        continue block0;
                    }
                    n = 1;
                    int n14 = workQueue3.base;
                    RuntimeCostAccounter.recordJump();
                    if (n14 == n10) {
                        RuntimeCostAccounter.recordJump();
                        if (forkJoinTask6 == null) {
                            RuntimeCostAccounter.recordJump();
                            return n;
                        }
                        long l2 = n12;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl = U.compareAndSwapObject(forkJoinTaskArray, l2, (Object)forkJoinTask6, null);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
                            U.putOrderedInt((Object)workQueue3, QBASE, n10 + 1);
                            ForkJoinTask<?> forkJoinTask9 = workQueue.currentSteal;
                            int n15 = workQueue.top;
                            do {
                                workQueue.currentSteal = forkJoinTask6;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                                forkJoinTask6.doExec();
                                int n16 = forkJoinTask.status;
                                RuntimeCostAccounter.recordJump();
                                if (n16 < 0) break;
                                int n17 = workQueue.top;
                                RuntimeCostAccounter.recordJump();
                                if (n17 == n15) break;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pop:()Ljava/util/concurrent/ForkJoinTask;");
                                forkJoinTask6 = workQueue.pop();
                                RuntimeCostAccounter.recordJump();
                            } while (forkJoinTask6 != null);
                            workQueue.currentSteal = forkJoinTask9;
                            RuntimeCostAccounter.recordJump();
                            return n;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordJump();
                }
                ForkJoinTask<?> forkJoinTask10 = workQueue3.currentJoin;
                int n18 = forkJoinTask2.status;
                RuntimeCostAccounter.recordJump();
                if (n18 < 0) continue block0;
                ForkJoinTask<?> forkJoinTask11 = workQueue2.currentJoin;
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask11 != forkJoinTask2) continue block0;
                ForkJoinTask<?> forkJoinTask12 = workQueue3.currentSteal;
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask12 != forkJoinTask2) {
                    RuntimeCostAccounter.recordJump();
                    continue block0;
                }
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask10 == null) return n;
                RuntimeCostAccounter.recordJump();
                if (++n2 == 64) {
                    RuntimeCostAccounter.recordJump();
                    return n;
                }
                forkJoinTask2 = forkJoinTask10;
                workQueue2 = workQueue3;
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    final int helpComplete(WorkQueue var1_1, CountedCompleter<?> var2_2, int var3_3) {
        block9: {
            var4_4 = 0;
            var5_5 = this.workQueues;
            RuntimeCostAccounter.recordJump();
            if (this.workQueues == null) break block9;
            var6_6 = var5_5.length - 1;
            RuntimeCostAccounter.recordJump();
            if (var6_6 < 0) break block9;
            RuntimeCostAccounter.recordJump();
            if (var1_1 == null) break block9;
            RuntimeCostAccounter.recordJump();
            if (var2_2 == null) break block9;
            var7_7 = var1_1.poolIndex;
            var8_8 = var6_6 + var6_6 + 1;
            var9_9 = 0L;
            var11_10 = var8_8;
            while (true) {
                block11: {
                    block10: {
                        var4_4 = var2_2.status;
                        RuntimeCostAccounter.recordJump();
                        if (var4_4 < 0) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.internalPopAndExecCC:(Ljava/util/concurrent/CountedCompleter;)Z");
                        v0 = var1_1.internalPopAndExecCC(var2_2);
                        RuntimeCostAccounter.recordJump();
                        if (!v0) break block10;
                        RuntimeCostAccounter.recordJump();
                        if (--var3_3 <= 0) {
                            var4_4 = var2_2.status;
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        var11_10 = var8_8;
                        RuntimeCostAccounter.recordJump();
                        break block11;
                    }
                    var4_4 = var2_2.status;
                    RuntimeCostAccounter.recordJump();
                    if (var4_4 < 0) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    var12_11 = var5_5[var7_7 & var6_6];
                    RuntimeCostAccounter.recordJump();
                    if (var12_11 == null) ** GOTO lbl-1000
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pollAndExecCC:(Ljava/util/concurrent/CountedCompleter;)Z");
                    v1 = var12_11.pollAndExecCC(var2_2);
                    RuntimeCostAccounter.recordJump();
                    if (v1) {
                        RuntimeCostAccounter.recordJump();
                        if (--var3_3 <= 0) {
                            var4_4 = var2_2.status;
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        var11_10 = var8_8;
                        RuntimeCostAccounter.recordJump();
                    } else lbl-1000:
                    // 2 sources

                    {
                        RuntimeCostAccounter.recordJump();
                        if (--var11_10 < 0) {
                            v2 = var9_9;
                            var9_9 = this.ctl;
                            cfr_temp_0 = v2 - var9_9;
                            v3 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                            RuntimeCostAccounter.recordJump();
                            if (v3 == false) {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            var11_10 = var8_8;
                        }
                    }
                }
                var7_7 += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return var4_4;
    }

    final boolean tryCompensate(long l) {
        block7: {
            ForkJoinWorkerThread forkJoinWorkerThread;
            Throwable throwable;
            block6: {
                short s;
                short s2;
                block9: {
                    block8: {
                        WorkQueue[] workQueueArray = this.workQueues;
                        s2 = this.parallelism;
                        int n = (int)l;
                        RuntimeCostAccounter.recordJump();
                        if (workQueueArray == null) break block7;
                        int n2 = workQueueArray.length - 1;
                        RuntimeCostAccounter.recordJump();
                        if (n2 < 0) break block7;
                        RuntimeCostAccounter.recordJump();
                        if (n < 0) break block7;
                        RuntimeCostAccounter.recordJump();
                        if (this.ctl != l) break block7;
                        WorkQueue workQueue = workQueueArray[n & n2];
                        RuntimeCostAccounter.recordJump();
                        if (n == 0) break block8;
                        RuntimeCostAccounter.recordJump();
                        if (workQueue == null) break block8;
                        long l2 = (long)(workQueue.nextWait & Integer.MAX_VALUE) | l & 0xFFFFFFFF00000000L;
                        int n3 = n + 65536 & Integer.MAX_VALUE;
                        int n4 = workQueue.eventCount;
                        RuntimeCostAccounter.recordJump();
                        if (n4 == (n | Integer.MIN_VALUE)) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                            boolean bl = U.compareAndSwapLong((Object)this, CTL, l, l2);
                            RuntimeCostAccounter.recordJump();
                            if (bl) {
                                workQueue.eventCount = n3;
                                Thread thread = workQueue.parker;
                                RuntimeCostAccounter.recordJump();
                                if (thread != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                    U.unpark((Object)thread);
                                }
                                return true;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        break block7;
                    }
                    s = (short)(l >>> 32);
                    RuntimeCostAccounter.recordJump();
                    if (s < 0) break block9;
                    int n = (int)(l >> 48) + s2;
                    RuntimeCostAccounter.recordJump();
                    if (n <= 1) break block9;
                    long l3 = l - 0x1000000000000L & 0xFFFF000000000000L | l & 0xFFFFFFFFFFFFL;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, CTL, l, l3);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return true;
                    }
                    RuntimeCostAccounter.recordJump();
                    break block7;
                }
                RuntimeCostAccounter.recordJump();
                if (s + s2 >= Short.MAX_VALUE) break block7;
                long l4 = l + 0x100000000L & 0xFFFF00000000L | l & 0xFFFF0000FFFFFFFFL;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl = U.compareAndSwapLong((Object)this, CTL, l, l4);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block7;
                throwable = null;
                forkJoinWorkerThread = null;
                try {
                    ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = this.factory;
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinWorkerThreadFactory == null) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory.newThread:(Ljava/util/concurrent/ForkJoinPool;)Ljava/util/concurrent/ForkJoinWorkerThread;");
                    forkJoinWorkerThread = forkJoinWorkerThreadFactory.newThread(this);
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinWorkerThread == null) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread.start:()V");
                    forkJoinWorkerThread.start();
                    return true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.deregisterWorker:(Ljava/util/concurrent/ForkJoinWorkerThread;Ljava/lang/Throwable;)V");
            this.deregisterWorker(forkJoinWorkerThread, throwable);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int awaitJoin(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        int n;
        block14: {
            n = 0;
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask == null) break block14;
            n = forkJoinTask.status;
            RuntimeCostAccounter.recordJump();
            if (n < 0) break block14;
            RuntimeCostAccounter.recordJump();
            if (workQueue == null) break block14;
            ForkJoinTask<?> forkJoinTask2 = workQueue.currentJoin;
            workQueue.currentJoin = forkJoinTask;
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.tryRemoveAndExec:(Ljava/util/concurrent/ForkJoinTask;)Z");
                boolean bl = workQueue.tryRemoveAndExec(forkJoinTask);
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                n = forkJoinTask.status;
                RuntimeCostAccounter.recordJump();
            } while (n >= 0);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                boolean bl = forkJoinTask instanceof CountedCompleter;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    CountedCompleter countedCompleter = (CountedCompleter)forkJoinTask;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.helpComplete:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/CountedCompleter;I)I");
                    n = this.helpComplete(workQueue, countedCompleter, Integer.MAX_VALUE);
                }
            }
            long l = 0L;
            while (true) {
                boolean bl;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break;
                n = forkJoinTask.status;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryHelpStealer:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinTask;)I");
                n = this.tryHelpStealer(workQueue, forkJoinTask);
                RuntimeCostAccounter.recordJump();
                if (n != 0) continue;
                n = forkJoinTask.status;
                RuntimeCostAccounter.recordJump();
                if (n < 0) continue;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryCompensate:(J)Z");
                boolean bl2 = this.tryCompensate(l);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    l = this.ctl;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.trySetSignal:()Z");
                boolean bl3 = forkJoinTask.trySetSignal();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    n = forkJoinTask.status;
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) {
                        block13: {
                            try {
                                int n2 = forkJoinTask.status;
                                RuntimeCostAccounter.recordJump();
                                if (n2 >= 0) {
                                    try {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:()V");
                                        forkJoinTask.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        RuntimeCostAccounter.recordJump();
                                        break block13;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    break block13;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
                                forkJoinTask.notifyAll();
                            }
                            catch (Throwable throwable) {
                                RuntimeCostAccounter.recordThrow();
                                throw throwable;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
                do {
                    long l2 = this.ctl;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    bl = U.compareAndSwapLong((Object)this, CTL, l2, l2 & 0xFFFFFFFFFFFFL | (l2 & 0xFFFF000000000000L) + 0x1000000000000L);
                    RuntimeCostAccounter.recordJump();
                } while (!bl);
                RuntimeCostAccounter.recordJump();
            }
            workQueue.currentJoin = forkJoinTask2;
        }
        return n;
    }

    final void helpJoinOnce(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        RuntimeCostAccounter.recordJump();
        if (workQueue != null) {
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask != null) {
                int n = forkJoinTask.status;
                RuntimeCostAccounter.recordJump();
                if (n >= 0) {
                    ForkJoinTask<?> forkJoinTask2 = workQueue.currentJoin;
                    workQueue.currentJoin = forkJoinTask;
                    do {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.tryRemoveAndExec:(Ljava/util/concurrent/ForkJoinTask;)Z");
                        boolean bl = workQueue.tryRemoveAndExec(forkJoinTask);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        n = forkJoinTask.status;
                        RuntimeCostAccounter.recordJump();
                    } while (n >= 0);
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) {
                        int n2;
                        boolean bl = forkJoinTask instanceof CountedCompleter;
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            CountedCompleter countedCompleter = (CountedCompleter)forkJoinTask;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.helpComplete:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/CountedCompleter;I)I");
                            this.helpComplete(workQueue, countedCompleter, Integer.MAX_VALUE);
                        }
                        do {
                            int n3 = forkJoinTask.status;
                            RuntimeCostAccounter.recordJump();
                            if (n3 < 0) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryHelpStealer:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinTask;)I");
                            n2 = this.tryHelpStealer(workQueue, forkJoinTask);
                            RuntimeCostAccounter.recordJump();
                        } while (n2 > 0);
                    }
                    workQueue.currentJoin = forkJoinTask2;
                }
            }
        }
    }

    private WorkQueue findNonEmptyStealQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSecondarySeed:()I");
        int n = ThreadLocalRandom.nextSecondarySeed();
        while (true) {
            int n2 = this.plock;
            WorkQueue[] workQueueArray = this.workQueues;
            RuntimeCostAccounter.recordJump();
            if (this.workQueues != null) {
                int n3 = workQueueArray.length - 1;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    int n4 = n3 + 1 << 2;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n4 < 0) break;
                        WorkQueue workQueue = workQueueArray[(n - n4 << 1 | 1) & n3];
                        RuntimeCostAccounter.recordJump();
                        if (workQueue != null) {
                            int n5 = workQueue.base - workQueue.top;
                            RuntimeCostAccounter.recordJump();
                            if (n5 < 0) {
                                return workQueue;
                            }
                        }
                        --n4;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (this.plock == n2) {
                return null;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    final void helpQuiescePool(WorkQueue workQueue) {
        ForkJoinTask<?> forkJoinTask = workQueue.currentSteal;
        boolean bl = true;
        while (true) {
            block11: {
                long l;
                block10: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.nextLocalTask:()Ljava/util/concurrent/ForkJoinTask;");
                    ForkJoinTask<?> forkJoinTask2 = workQueue.nextLocalTask();
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTask2 != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                        forkJoinTask2.doExec();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.findNonEmptyStealQueue:()Ljava/util/concurrent/ForkJoinPool$WorkQueue;");
                    WorkQueue workQueue2 = this.findNonEmptyStealQueue();
                    RuntimeCostAccounter.recordJump();
                    if (workQueue2 == null) break block10;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        boolean bl2;
                        bl = true;
                        do {
                            l = this.ctl;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                            bl2 = U.compareAndSwapLong((Object)this, CTL, l, l & 0xFFFFFFFFFFFFL | (l & 0xFFFF000000000000L) + 0x1000000000000L);
                            RuntimeCostAccounter.recordJump();
                        } while (!bl2);
                    }
                    int n = workQueue2.base;
                    int n2 = n - workQueue2.top;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= 0) break block11;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pollAt:(I)Ljava/util/concurrent/ForkJoinTask;");
                    forkJoinTask2 = workQueue2.pollAt(n);
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTask2 == null) break block11;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.runTask:(Ljava/util/concurrent/ForkJoinTask;)V");
                    workQueue.runTask(forkJoinTask2);
                    RuntimeCostAccounter.recordJump();
                    break block11;
                }
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    l = this.ctl;
                    long l2 = l & 0xFFFFFFFFFFFFL | (l & 0xFFFF000000000000L) - 0x1000000000000L;
                    int n = (int)(l2 >> 48) + this.parallelism;
                    RuntimeCostAccounter.recordJump();
                    if (n == 0) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl3 = U.compareAndSwapLong((Object)this, CTL, l, l2);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        bl = false;
                    }
                    RuntimeCostAccounter.recordJump();
                } else {
                    l = this.ctl;
                    int n = (int)(l >> 48) + this.parallelism;
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                        boolean bl4 = U.compareAndSwapLong((Object)this, CTL, l, l & 0xFFFFFFFFFFFFL | (l & 0xFFFF000000000000L) + 0x1000000000000L);
                        RuntimeCostAccounter.recordJump();
                        if (bl4) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue workQueue) {
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.nextLocalTask:()Ljava/util/concurrent/ForkJoinTask;");
            ForkJoinTask<?> forkJoinTask = workQueue.nextLocalTask();
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask != null) {
                return forkJoinTask;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.findNonEmptyStealQueue:()Ljava/util/concurrent/ForkJoinPool$WorkQueue;");
            WorkQueue workQueue2 = this.findNonEmptyStealQueue();
            RuntimeCostAccounter.recordJump();
            if (workQueue2 == null) {
                return null;
            }
            int n = workQueue2.base;
            int n2 = n - workQueue2.top;
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pollAt:(I)Ljava/util/concurrent/ForkJoinTask;");
                forkJoinTask = workQueue2.pollAt(n);
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask != null) {
                    return forkJoinTask;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    static int getSurplusQueuedTaskCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            int n;
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
            int n2 = forkJoinPool.parallelism;
            WorkQueue workQueue = forkJoinWorkerThread.workQueue;
            int n3 = workQueue.top - workQueue.base;
            int n4 = (int)(forkJoinPool.ctl >> 48) + n2;
            RuntimeCostAccounter.recordJump();
            if (n4 > (n2 >>>= 1)) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 > (n2 >>>= 1)) {
                    n = 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n4 > (n2 >>>= 1)) {
                        n = 2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (n4 > (n2 >>>= 1)) {
                            n = 4;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            n = 8;
                        }
                    }
                }
            }
            return n3 - n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryTerminate(boolean bl, boolean bl2) {
        block34: {
            int n;
            block36: {
                block35: {
                    RuntimeCostAccounter.recordJump();
                    if (this == common) {
                        return false;
                    }
                    n = this.plock;
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block34;
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) {
                        return false;
                    }
                    RuntimeCostAccounter.recordJump();
                    if ((n & 2) != 0) break block35;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                    boolean bl3 = U.compareAndSwapInt((Object)this, PLOCK, n, n += 2);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) break block36;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.acquirePlock:()I");
                n = this.acquirePlock();
            }
            int n2 = n + 2 & Integer.MAX_VALUE | Integer.MIN_VALUE;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            boolean bl4 = U.compareAndSwapInt((Object)this, PLOCK, n, n2);
            RuntimeCostAccounter.recordJump();
            if (!bl4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.releasePlock:(I)V");
                this.releasePlock(n2);
            }
        }
        while (true) {
            Object object;
            long l;
            block37: {
                l = this.ctl;
                RuntimeCostAccounter.recordJump();
                if ((l & 0x80000000L) != 0L) {
                    int n = (short)(l >>> 32) + this.parallelism;
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) {
                        ForkJoinPool forkJoinPool = this;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
                            this.notifyAll();
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    return true;
                }
                RuntimeCostAccounter.recordJump();
                if (bl) break block37;
                int n = (int)(l >> 48) + this.parallelism;
                RuntimeCostAccounter.recordJump();
                if (n > 0) {
                    return false;
                }
                WorkQueue[] workQueueArray = this.workQueues;
                RuntimeCostAccounter.recordJump();
                if (this.workQueues == null) break block37;
                int n3 = 0;
                while (true) {
                    block38: {
                        block39: {
                            int n4 = workQueueArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n3 >= n4) break;
                            object = workQueueArray[n3];
                            RuntimeCostAccounter.recordJump();
                            if (object == null) break block38;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.isEmpty:()Z");
                            boolean bl5 = ((WorkQueue)object).isEmpty();
                            RuntimeCostAccounter.recordJump();
                            if (!bl5) break block39;
                            RuntimeCostAccounter.recordJump();
                            if ((n3 & 1) == 0) break block38;
                            int n5 = ((WorkQueue)object).eventCount;
                            RuntimeCostAccounter.recordJump();
                            if (n5 < 0) break block38;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.signalWork:([Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinPool$WorkQueue;)V");
                        this.signalWork(workQueueArray, (WorkQueue)object);
                        return false;
                    }
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
            boolean bl6 = U.compareAndSwapLong((Object)this, CTL, l, l | 0x80000000L);
            RuntimeCostAccounter.recordJump();
            if (!bl6) continue;
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= 3) break;
                object = this.workQueues;
                RuntimeCostAccounter.recordJump();
                if (this.workQueues != null) {
                    int n6 = ((WorkQueue[])object).length;
                    int n7 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n7 >= n6) break;
                        Object object2 = object[n7];
                        RuntimeCostAccounter.recordJump();
                        if (object2 != null) {
                            ((WorkQueue)object2).qlock = -1;
                            RuntimeCostAccounter.recordJump();
                            if (n > 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.cancelAll:()V");
                                ((WorkQueue)object2).cancelAll();
                                RuntimeCostAccounter.recordJump();
                                if (n > 1) {
                                    ForkJoinWorkerThread forkJoinWorkerThread = ((WorkQueue)object2).owner;
                                    RuntimeCostAccounter.recordJump();
                                    if (forkJoinWorkerThread != null) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isInterrupted:()Z");
                                        boolean bl7 = forkJoinWorkerThread.isInterrupted();
                                        RuntimeCostAccounter.recordJump();
                                        if (!bl7) {
                                            try {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                                                forkJoinWorkerThread.interrupt();
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            RuntimeCostAccounter.recordJump();
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                        U.unpark((Object)forkJoinWorkerThread);
                                    }
                                }
                            }
                        }
                        ++n7;
                        RuntimeCostAccounter.recordJump();
                    }
                    while (true) {
                        long l2 = this.ctl;
                        int n8 = (int)l2 & Integer.MAX_VALUE;
                        RuntimeCostAccounter.recordJump();
                        if (n8 == 0) break;
                        n7 = n8 & 0xFFFF;
                        RuntimeCostAccounter.recordJump();
                        if (n7 >= n6) break;
                        RuntimeCostAccounter.recordJump();
                        if (n7 < 0) break;
                        Object object3 = object[n7];
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break;
                        long l3 = (long)(((WorkQueue)object3).nextWait & Integer.MAX_VALUE) | l2 + 0x1000000000000L & 0xFFFF000000000000L | l2 & 0xFFFF80000000L;
                        int n9 = ((WorkQueue)object3).eventCount;
                        RuntimeCostAccounter.recordJump();
                        if (n9 == (n8 | Integer.MIN_VALUE)) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                            boolean bl8 = U.compareAndSwapLong((Object)this, CTL, l2, l3);
                            RuntimeCostAccounter.recordJump();
                            if (bl8) {
                                ((WorkQueue)object3).eventCount = n8 + 65536 & Integer.MAX_VALUE;
                                ((WorkQueue)object3).qlock = -1;
                                Thread thread = ((WorkQueue)object3).parker;
                                RuntimeCostAccounter.recordJump();
                                if (thread != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                    U.unpark((Object)thread);
                                }
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonSubmitterQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.getProbe:()I");
        int n = ThreadLocalRandom.getProbe();
        RuntimeCostAccounter.recordJump();
        if (n == 0) return null;
        ForkJoinPool forkJoinPool = common;
        RuntimeCostAccounter.recordJump();
        if (forkJoinPool == null) return null;
        WorkQueue[] workQueueArray = forkJoinPool.workQueues;
        RuntimeCostAccounter.recordJump();
        if (forkJoinPool.workQueues == null) return null;
        int n2 = workQueueArray.length - 1;
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) return null;
        WorkQueue workQueue = workQueueArray[n2 & n & 0x7E];
        RuntimeCostAccounter.recordJump();
        return workQueue;
    }

    final boolean tryExternalUnpush(ForkJoinTask<?> forkJoinTask) {
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.getProbe:()I");
        int n = ThreadLocalRandom.getProbe();
        boolean bl = false;
        RuntimeCostAccounter.recordJump();
        if (workQueueArray != null) {
            int n2 = workQueueArray.length - 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= 0) {
                WorkQueue workQueue = workQueueArray[n & n2 & 0x7E];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    int n3 = workQueue.base;
                    int n4 = workQueue.top;
                    RuntimeCostAccounter.recordJump();
                    if (n3 != n4) {
                        ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                        RuntimeCostAccounter.recordJump();
                        if (workQueue.array != null) {
                            long l = ((forkJoinTaskArray.length - 1 & n4 - 1) << ASHIFT) + ABASE;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObject:(Ljava/lang/Object;J)Ljava/lang/Object;");
                            Object object = U.getObject(forkJoinTaskArray, l);
                            RuntimeCostAccounter.recordJump();
                            if (object == forkJoinTask) {
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                                boolean bl2 = U.compareAndSwapInt((Object)workQueue, QLOCK, 0, 1);
                                RuntimeCostAccounter.recordJump();
                                if (bl2) {
                                    int n5 = workQueue.top;
                                    RuntimeCostAccounter.recordJump();
                                    if (n5 == n4) {
                                        ForkJoinTask<?>[] forkJoinTaskArray2 = workQueue.array;
                                        RuntimeCostAccounter.recordJump();
                                        if (forkJoinTaskArray2 == forkJoinTaskArray) {
                                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                            boolean bl3 = U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null);
                                            RuntimeCostAccounter.recordJump();
                                            if (bl3) {
                                                workQueue.top = n4 - 1;
                                                bl = true;
                                            }
                                        }
                                    }
                                    workQueue.qlock = 0;
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    final int externalHelpComplete(CountedCompleter<?> var1_1, int var2_2) {
        block9: {
            var3_3 = this.workQueues;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.getProbe:()I");
            var4_4 = ThreadLocalRandom.getProbe();
            var5_5 = 0;
            RuntimeCostAccounter.recordJump();
            if (var3_3 == null) break block9;
            var6_6 = var3_3.length - 1;
            RuntimeCostAccounter.recordJump();
            if (var6_6 < 0) break block9;
            var7_7 = var3_3[var4_4 & var6_6 & 126];
            RuntimeCostAccounter.recordJump();
            if (var7_7 == null) break block9;
            RuntimeCostAccounter.recordJump();
            if (var1_1 == null) break block9;
            var8_8 = var6_6 + var6_6 + 1;
            var9_9 = 0L;
            var4_4 |= 1;
            var11_10 = var8_8;
            while (true) {
                block11: {
                    block10: {
                        var5_5 = var1_1.status;
                        RuntimeCostAccounter.recordJump();
                        if (var5_5 < 0) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.externalPopAndExecCC:(Ljava/util/concurrent/CountedCompleter;)Z");
                        v0 = var7_7.externalPopAndExecCC(var1_1);
                        RuntimeCostAccounter.recordJump();
                        if (!v0) break block10;
                        RuntimeCostAccounter.recordJump();
                        if (--var2_2 <= 0) {
                            var5_5 = var1_1.status;
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        var11_10 = var8_8;
                        RuntimeCostAccounter.recordJump();
                        break block11;
                    }
                    var5_5 = var1_1.status;
                    RuntimeCostAccounter.recordJump();
                    if (var5_5 < 0) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    var12_11 = var3_3[var4_4 & var6_6];
                    RuntimeCostAccounter.recordJump();
                    if (var12_11 == null) ** GOTO lbl-1000
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pollAndExecCC:(Ljava/util/concurrent/CountedCompleter;)Z");
                    v1 = var12_11.pollAndExecCC(var1_1);
                    RuntimeCostAccounter.recordJump();
                    if (v1) {
                        RuntimeCostAccounter.recordJump();
                        if (--var2_2 <= 0) {
                            var5_5 = var1_1.status;
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        var11_10 = var8_8;
                        RuntimeCostAccounter.recordJump();
                    } else lbl-1000:
                    // 2 sources

                    {
                        RuntimeCostAccounter.recordJump();
                        if (--var11_10 < 0) {
                            v2 = var9_9;
                            var9_9 = this.ctl;
                            cfr_temp_0 = v2 - var9_9;
                            v3 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                            RuntimeCostAccounter.recordJump();
                            if (v3 == false) {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            var11_10 = var8_8;
                        }
                    }
                }
                var4_4 += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return var5_5;
    }

    public ForkJoinPool() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
        Runtime runtime = Runtime.getRuntime();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.availableProcessors:()I");
        int n = runtime.availableProcessors();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n2 = Math.min(Short.MAX_VALUE, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.<init>:(ILjava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;Ljava/lang/Thread$UncaughtExceptionHandler;Z)V");
        this(n2, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.<init>:(ILjava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;Ljava/lang/Thread$UncaughtExceptionHandler;Z)V");
        this(n, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.checkParallelism:(I)I");
        int n3 = ForkJoinPool.checkParallelism(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.checkFactory:(Ljava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;)Ljava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;");
        ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory2 = ForkJoinPool.checkFactory(forkJoinWorkerThreadFactory);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n2 = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("ForkJoinPool-");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.nextPoolId:()I");
        int n4 = ForkJoinPool.nextPoolId();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append("-worker-");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder4.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.<init>:(ILjava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;Ljava/lang/Thread$UncaughtExceptionHandler;ILjava/lang/String;)V");
        this(n3, forkJoinWorkerThreadFactory2, uncaughtExceptionHandler, n2, string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.checkPermission:()V");
        ForkJoinPool.checkPermission();
    }

    private static int checkParallelism(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n <= 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n <= Short.MAX_VALUE) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        return n;
    }

    private static ForkJoinWorkerThreadFactory checkFactory(ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory) {
        RuntimeCostAccounter.recordJump();
        if (forkJoinWorkerThreadFactory == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        return forkJoinWorkerThreadFactory;
    }

    private ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int n2, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/AbstractExecutorService.<init>:()V");
        this.workerNamePrefix = string;
        this.factory = forkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.mode = (short)n2;
        this.parallelism = (short)n;
        long l = -n;
        this.ctl = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        RuntimeCostAccounter.recordJump();
        if (forkJoinTask == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.externalPush(forkJoinTask);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.join:()Ljava/lang/Object;");
        return forkJoinTask.join();
    }

    public void execute(ForkJoinTask<?> forkJoinTask) {
        RuntimeCostAccounter.recordJump();
        if (forkJoinTask == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.externalPush(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        ForkJoinTask forkJoinTask;
        RuntimeCostAccounter.recordJump();
        if (runnable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = runnable instanceof ForkJoinTask;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            forkJoinTask = (ForkJoinTask)((Object)runnable);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$RunnableExecuteAction");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$RunnableExecuteAction.<init>:(Ljava/lang/Runnable;)V");
            forkJoinTask = new ForkJoinTask.RunnableExecuteAction(runnable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.externalPush(forkJoinTask);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> forkJoinTask) {
        RuntimeCostAccounter.recordJump();
        if (forkJoinTask == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.externalPush(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable.<init>:(Ljava/util/concurrent/Callable;)V");
        ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.externalPush(adaptedCallable);
        return adaptedCallable;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnable.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
        ForkJoinTask.AdaptedRunnable<T> adaptedRunnable = new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.externalPush(adaptedRunnable);
        return adaptedRunnable;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        ForkJoinTask forkJoinTask;
        RuntimeCostAccounter.recordJump();
        if (runnable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = runnable instanceof ForkJoinTask;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            forkJoinTask = (ForkJoinTask)((Object)runnable);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnableAction");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnableAction.<init>:(Ljava/lang/Runnable;)V");
            forkJoinTask = new ForkJoinTask.AdaptedRunnableAction(runnable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
        this.externalPush(forkJoinTask);
        return forkJoinTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        ArrayList<Future<T>> arrayList;
        int n;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
        int n2 = collection.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
        ArrayList<Future<T>> arrayList2 = new ArrayList<Future<T>>(n2);
        boolean bl = false;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<Callable<T>> iterator = collection.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl2 = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Callable<T> callable = iterator.next();
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable.<init>:(Ljava/util/concurrent/Callable;)V");
                ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                arrayList2.add(adaptedCallable);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
                this.externalPush(adaptedCallable);
                RuntimeCostAccounter.recordJump();
            }
            int n3 = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
            n = arrayList2.size();
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.get:(I)Ljava/lang/Object;");
                ForkJoinTask forkJoinTask = (ForkJoinTask)arrayList2.get(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.quietlyJoin:()V");
                forkJoinTask.quietlyJoin();
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            bl = true;
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                int n4 = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
                int n5 = arrayList2.size();
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= n5) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.get:(I)Ljava/lang/Object;");
                    Future future = (Future)arrayList2.get(n4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Future.cancel:(Z)Z");
                    future.cancel(false);
                    ++n4;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            n = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
            int n6 = arrayList2.size();
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n6) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.get:(I)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Future.cancel:(Z)Z");
                arrayList2.get(n).cancel(false);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return arrayList;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        short s;
        short s2 = this.parallelism;
        RuntimeCostAccounter.recordJump();
        if (s2 > 0) {
            s = s2;
            RuntimeCostAccounter.recordJump();
        } else {
            s = 1;
        }
        return s;
    }

    public static int getCommonPoolParallelism() {
        return commonParallelism;
    }

    public int getPoolSize() {
        return this.parallelism + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.mode == 1) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public int getRunningThreadCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n2 = 1;
            while (true) {
                int n3 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                WorkQueue workQueue = workQueueArray[n2];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.isApparentlyUnblocked:()Z");
                    boolean bl = workQueue.isApparentlyUnblocked();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        ++n;
                    }
                }
                n2 += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return n;
    }

    public int getActiveThreadCount() {
        int n;
        int n2 = this.parallelism + (int)(this.ctl >> 48);
        RuntimeCostAccounter.recordJump();
        if (n2 <= 0) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = n2;
        }
        return n;
    }

    public boolean isQuiescent() {
        boolean bl;
        int n = this.parallelism + (int)(this.ctl >> 48);
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public long getStealCount() {
        long l = this.stealCount;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n = 1;
            while (true) {
                int n2 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                WorkQueue workQueue = workQueueArray[n];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    l += (long)workQueue.nsteals;
                }
                n += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return l;
    }

    public long getQueuedTaskCount() {
        long l = 0L;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n = 1;
            while (true) {
                int n2 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                WorkQueue workQueue = workQueueArray[n];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.queueSize:()I");
                    l += (long)workQueue.queueSize();
                }
                n += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return l;
    }

    public int getQueuedSubmissionCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n2 = 0;
            while (true) {
                int n3 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                WorkQueue workQueue = workQueueArray[n2];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.queueSize:()I");
                    n += workQueue.queueSize();
                }
                n2 += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return n;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n = 0;
            while (true) {
                int n2 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                WorkQueue workQueue = workQueueArray[n];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.isEmpty:()Z");
                    boolean bl = workQueue.isEmpty();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        return true;
                    }
                }
                n += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n = 0;
            while (true) {
                int n2 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                WorkQueue workQueue = workQueueArray[n];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.poll:()Ljava/util/concurrent/ForkJoinTask;");
                    ForkJoinTask<?> forkJoinTask = workQueue.poll();
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTask != null) {
                        return forkJoinTask;
                    }
                }
                n += 2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            int n2 = 0;
            while (true) {
                int n3 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                WorkQueue workQueue = workQueueArray[n2];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.poll:()Ljava/util/concurrent/ForkJoinTask;");
                        ForkJoinTask<?> forkJoinTask = workQueue.poll();
                        RuntimeCostAccounter.recordJump();
                        if (forkJoinTask == null) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                        collection.add(forkJoinTask);
                        ++n;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return n;
    }

    public String toString() {
        String string;
        int n;
        int n2;
        long l = 0L;
        long l2 = 0L;
        int n3 = 0;
        long l3 = this.stealCount;
        long l4 = this.ctl;
        WorkQueue[] workQueueArray = this.workQueues;
        RuntimeCostAccounter.recordJump();
        if (this.workQueues != null) {
            n2 = 0;
            while (true) {
                int n4 = workQueueArray.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n4) break;
                WorkQueue workQueue = workQueueArray[n2];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.queueSize:()I");
                    n = workQueue.queueSize();
                    RuntimeCostAccounter.recordJump();
                    if ((n2 & 1) == 0) {
                        l2 += (long)n;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l += (long)n;
                        l3 += (long)workQueue.nsteals;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.isApparentlyUnblocked:()Z");
                        boolean bl = workQueue.isApparentlyUnblocked();
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            ++n3;
                        }
                    }
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
        n2 = this.parallelism;
        n = n2 + (short)(l4 >>> 32);
        int n5 = n2 + (int)(l4 >> 48);
        RuntimeCostAccounter.recordJump();
        if (n5 < 0) {
            n5 = 0;
        }
        RuntimeCostAccounter.recordJump();
        if ((l4 & 0x80000000L) != 0L) {
            String string2;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                string2 = "Terminated";
                RuntimeCostAccounter.recordJump();
            } else {
                string2 = "Terminating";
            }
            string = string2;
            RuntimeCostAccounter.recordJump();
        } else {
            String string3;
            RuntimeCostAccounter.recordJump();
            if (this.plock < 0) {
                string3 = "Shutting down";
                RuntimeCostAccounter.recordJump();
            } else {
                string3 = "Running";
            }
            string = string3;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string4 = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(", parallelism = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(", size = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(", active = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder10 = stringBuilder9.append(n5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append(", running = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder13 = stringBuilder12.append(", steals = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder14 = stringBuilder13.append(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder15 = stringBuilder14.append(", tasks = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder16 = stringBuilder15.append(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder17 = stringBuilder16.append(", submissions = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder18 = stringBuilder17.append(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder19 = stringBuilder18.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder19.toString();
    }

    @Override
    public void shutdown() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.checkPermission:()V");
        ForkJoinPool.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryTerminate:(ZZ)Z");
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.checkPermission:()V");
        ForkJoinPool.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryTerminate:(ZZ)Z");
        this.tryTerminate(true, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyList:()Ljava/util/List;");
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTerminated() {
        long l = this.ctl;
        RuntimeCostAccounter.recordJump();
        if ((l & 0x80000000L) == 0L) return false;
        int n = (short)(l >>> 32) + this.parallelism;
        RuntimeCostAccounter.recordJump();
        if (n > 0) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminating() {
        long l = this.ctl;
        RuntimeCostAccounter.recordJump();
        if ((l & 0x80000000L) == 0L) return false;
        int n = (short)(l >>> 32) + this.parallelism;
        RuntimeCostAccounter.recordJump();
        if (n <= 0) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    @Override
    public boolean isShutdown() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.plock < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
        RuntimeCostAccounter.recordJump();
        if (this == common) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.awaitQuiescence:(JLjava/util/concurrent/TimeUnit;)Z");
            this.awaitQuiescence(l, timeUnit);
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.isTerminated:()Z");
        boolean bl2 = this.isTerminated();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            return true;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 <= 0L) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l3 = System.nanoTime() + l2;
        ForkJoinPool forkJoinPool = this;
        try {
            while (true) {
                long l4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.isTerminated:()Z");
                boolean bl3 = this.isTerminated();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    return true;
                }
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0L) {
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toMillis:(J)J");
                long l5 = TimeUnit.NANOSECONDS.toMillis(l2);
                RuntimeCostAccounter.recordJump();
                if (l5 > 0L) {
                    l4 = l5;
                    RuntimeCostAccounter.recordJump();
                } else {
                    l4 = 1L;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:(J)V");
                this.wait(l4);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l2 = l3 - System.nanoTime();
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    public boolean awaitQuiescence(long l, TimeUnit timeUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
            RuntimeCostAccounter.recordJump();
            if (forkJoinPool == this) {
                WorkQueue workQueue = forkJoinWorkerThread.workQueue;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.helpQuiescePool:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;)V");
                this.helpQuiescePool(workQueue);
                return true;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l3 = System.nanoTime();
        int n = 0;
        boolean bl2 = true;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.isQuiescent:()Z");
            boolean bl3 = this.isQuiescent();
            RuntimeCostAccounter.recordJump();
            if (bl3) break;
            WorkQueue[] workQueueArray = this.workQueues;
            RuntimeCostAccounter.recordJump();
            if (this.workQueues == null) break;
            int n2 = workQueueArray.length - 1;
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) break;
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                long l4 = System.nanoTime() - l3 - l2;
                long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l5 > 0) {
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
                Thread.yield();
            }
            bl2 = false;
            int n3 = n2 + 1 << 2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) break;
                WorkQueue workQueue = workQueueArray[n++ & n2];
                RuntimeCostAccounter.recordJump();
                if (workQueue != null) {
                    int n4 = workQueue.base;
                    int n5 = n4 - workQueue.top;
                    RuntimeCostAccounter.recordJump();
                    if (n5 < 0) {
                        bl2 = true;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pollAt:(I)Ljava/util/concurrent/ForkJoinTask;");
                        ForkJoinTask<?> forkJoinTask = workQueue.pollAt(n4);
                        RuntimeCostAccounter.recordJump();
                        if (forkJoinTask == null) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                        forkJoinTask.doExec();
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                }
                --n3;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    static void quiesceCommonPool() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.awaitQuiescence:(JLjava/util/concurrent/TimeUnit;)Z");
        common.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * Unable to fully structure code
     */
    public static void managedBlock(ManagedBlocker var0) throws InterruptedException {
        block7: {
            block6: {
                block5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                    var1_1 = Thread.currentThread();
                    v0 = var1_1 instanceof ForkJoinWorkerThread;
                    RuntimeCostAccounter.recordJump();
                    if (!v0) break block6;
                    var2_2 = ((ForkJoinWorkerThread)var1_1).pool;
                    do {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$ManagedBlocker.isReleasable:()Z");
                        v1 = var0.isReleasable();
                        RuntimeCostAccounter.recordJump();
                        if (v1) break block5;
                        v2 = var2_2.ctl;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryCompensate:(J)Z");
                        v3 = var2_2.tryCompensate(v2);
                        RuntimeCostAccounter.recordJump();
                    } while (!v3);
                    try {
                        do {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$ManagedBlocker.isReleasable:()Z");
                            v4 = var0.isReleasable();
                            RuntimeCostAccounter.recordJump();
                            if (v4) ** break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$ManagedBlocker.block:()Z");
                            v5 = var0.block();
                            RuntimeCostAccounter.recordJump();
                        } while (!v5);
                    }
                    catch (Throwable var3_3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.incrementActiveCount:()V");
                        var2_2.incrementActiveCount();
                        RuntimeCostAccounter.recordThrow();
                        throw var3_3;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.incrementActiveCount:()V");
                    var2_2.incrementActiveCount();
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                break block7;
            }
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$ManagedBlocker.isReleasable:()Z");
                v6 = var0.isReleasable();
                RuntimeCostAccounter.recordJump();
                if (v6) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$ManagedBlocker.block:()Z");
                v7 = var0.block();
                RuntimeCostAccounter.recordJump();
            } while (!v7);
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnable.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable.<init>:(Ljava/util/concurrent/Callable;)V");
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    private static ForkJoinPool makeCommonPool() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory;
        int n;
        block10: {
            n = -1;
            forkJoinWorkerThreadFactory = null;
            uncaughtExceptionHandler = null;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                String string = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                String string2 = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                String string3 = System.getProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
                RuntimeCostAccounter.recordJump();
                if (string != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
                    n = Integer.parseInt(string);
                }
                RuntimeCostAccounter.recordJump();
                if (string2 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                    Class<?> clazz = classLoader.loadClass(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                    forkJoinWorkerThreadFactory = (ForkJoinWorkerThreadFactory)clazz.newInstance();
                }
                RuntimeCostAccounter.recordJump();
                if (string3 == null) break block10;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                Class<?> clazz = classLoader.loadClass(string3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (forkJoinWorkerThreadFactory == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
            SecurityManager securityManager = System.getSecurityManager();
            RuntimeCostAccounter.recordJump();
            if (securityManager == null) {
                forkJoinWorkerThreadFactory = defaultForkJoinWorkerThreadFactory;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool$InnocuousForkJoinWorkerThreadFactory");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$InnocuousForkJoinWorkerThreadFactory.<init>:()V");
                forkJoinWorkerThreadFactory = new InnocuousForkJoinWorkerThreadFactory();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
            Runtime runtime = Runtime.getRuntime();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.availableProcessors:()I");
            n = runtime.availableProcessors() - 1;
            RuntimeCostAccounter.recordJump();
            if (n <= 0) {
                n = 1;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.<init>:(ILjava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;Ljava/lang/Thread$UncaughtExceptionHandler;ILjava/lang/String;)V");
        return new ForkJoinPool(n, forkJoinWorkerThreadFactory, uncaughtExceptionHandler, 0, "ForkJoinPool.commonPool-worker-");
    }

    static /* synthetic */ ForkJoinPool access$000() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.makeCommonPool:()Ljava/util/concurrent/ForkJoinPool;");
        return ForkJoinPool.makeCommonPool();
    }

    static {
        short s;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            U = Unsafe.getUnsafe();
            Class<ForkJoinPool> clazz = ForkJoinPool.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("ctl");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            CTL = U.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = clazz.getDeclaredField("stealCount");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            STEALCOUNT = U.objectFieldOffset(field2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field3 = clazz.getDeclaredField("plock");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PLOCK = U.objectFieldOffset(field3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field4 = clazz.getDeclaredField("indexSeed");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            INDEXSEED = U.objectFieldOffset(field4);
            Class<Thread> clazz2 = Thread.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field5 = clazz2.getDeclaredField("parkBlocker");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PARKBLOCKER = U.objectFieldOffset(field5);
            Class<WorkQueue> clazz3 = WorkQueue.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field6 = clazz3.getDeclaredField("base");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            QBASE = U.objectFieldOffset(field6);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field7 = clazz3.getDeclaredField("qlock");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            QLOCK = U.objectFieldOffset(field7);
            Class<ForkJoinTask[]> clazz4 = ForkJoinTask[].class;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.arrayBaseOffset:(Ljava/lang/Class;)I");
            ABASE = U.arrayBaseOffset(clazz4);
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.arrayIndexScale:(Ljava/lang/Class;)I");
            int n = U.arrayIndexScale(clazz4);
            RuntimeCostAccounter.recordJump();
            if ((n & n - 1) != 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                Error error = new Error("data type scale not a power of two");
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
            ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool$DefaultForkJoinWorkerThreadFactory");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$DefaultForkJoinWorkerThreadFactory.<init>:()V");
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
        modifyThreadPermission = new RuntimePermission("modifyThread");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$1.<init>:()V");
        PrivilegedAction<ForkJoinPool> privilegedAction = new PrivilegedAction<ForkJoinPool>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public ForkJoinPool run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.access$000:()Ljava/util/concurrent/ForkJoinPool;");
                return ForkJoinPool.access$000();
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        common = (ForkJoinPool)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        short s2 = ForkJoinPool.common.parallelism;
        RuntimeCostAccounter.recordJump();
        if (s2 > 0) {
            s = s2;
            RuntimeCostAccounter.recordJump();
        } else {
            s = 1;
        }
        commonParallelism = s;
    }

    static final class InnocuousForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext innocuousAcc;

        InnocuousForkJoinWorkerThreadFactory() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool forkJoinPool) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool$InnocuousForkJoinWorkerThreadFactory$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$InnocuousForkJoinWorkerThreadFactory$1.<init>:(Ljava/util/concurrent/ForkJoinPool$InnocuousForkJoinWorkerThreadFactory;Ljava/util/concurrent/ForkJoinPool;)V");
            PrivilegedAction<ForkJoinWorkerThread> privilegedAction = new PrivilegedAction<ForkJoinWorkerThread>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public ForkJoinWorkerThread run() {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinWorkerThread$InnocuousForkJoinWorkerThread");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread$InnocuousForkJoinWorkerThread.<init>:(Ljava/util/concurrent/ForkJoinPool;)V");
                    return new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(forkJoinPool);
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;");
            return (ForkJoinWorkerThread.InnocuousForkJoinWorkerThread)AccessController.doPrivileged((PrivilegedAction)privilegedAction, (AccessControlContext)innocuousAcc);
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/security/Permissions");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/Permissions.<init>:()V");
            Permissions permissions = new Permissions();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.access$100:()Ljava/lang/RuntimePermission;");
            RuntimePermission runtimePermission = modifyThreadPermission;
            RuntimeCostAccounter.recordMethodCall((String)"java/security/Permissions.add:(Ljava/security/Permission;)V");
            permissions.add((Permission)runtimePermission);
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
            RuntimePermission runtimePermission2 = new RuntimePermission("enableContextClassLoaderOverride");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/Permissions.add:(Ljava/security/Permission;)V");
            permissions.add((Permission)runtimePermission2);
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
            RuntimePermission runtimePermission3 = new RuntimePermission("modifyThreadGroup");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/Permissions.add:(Ljava/security/Permission;)V");
            permissions.add((Permission)runtimePermission3);
            RuntimeCostAccounter.recordAllocation((String)"java/security/AccessControlContext");
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[1];
            RuntimeCostAccounter.recordAllocation((String)"java/security/ProtectionDomain");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/ProtectionDomain.<init>:(Ljava/security/CodeSource;Ljava/security/PermissionCollection;)V");
            protectionDomainArray[0] = new ProtectionDomain(null, (PermissionCollection)permissions);
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessControlContext.<init>:([Ljava/security/ProtectionDomain;)V");
            innocuousAcc = new AccessControlContext(protectionDomainArray);
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    @Contended
    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile int eventCount;
        int nextWait;
        int nsteals;
        int hint;
        short poolIndex;
        final short mode;
        volatile int qlock;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        ForkJoinTask<?> currentSteal;
        private static final Unsafe U;
        private static final long QBASE;
        private static final long QLOCK;
        private static final int ABASE;
        private static final int ASHIFT;

        WorkQueue(ForkJoinPool forkJoinPool, ForkJoinWorkerThread forkJoinWorkerThread, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.pool = forkJoinPool;
            this.owner = forkJoinWorkerThread;
            this.mode = (short)n;
            this.hint = n2;
            this.top = 4096;
            this.base = 4096;
        }

        final int queueSize() {
            int n;
            int n2 = this.base - this.top;
            RuntimeCostAccounter.recordJump();
            if (n2 >= 0) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n = -n2;
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int n = this.top;
            int n2 = this.base - n;
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                RuntimeCostAccounter.recordJump();
                if (n2 != -1) return false;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                RuntimeCostAccounter.recordJump();
                if (this.array != null) {
                    int n3 = forkJoinTaskArray.length - 1;
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= 0) {
                        long l = (long)((n3 & n - 1) << ASHIFT) + (long)ABASE;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObject:(Ljava/lang/Object;J)Ljava/lang/Object;");
                        Object object = U.getObject(forkJoinTaskArray, l);
                        RuntimeCostAccounter.recordJump();
                        if (object != null) return false;
                    }
                }
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        final void push(ForkJoinTask<?> forkJoinTask) {
            int n = this.top;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (this.array != null) {
                int n2 = forkJoinTaskArray.length - 1;
                long l = ((n2 & n) << ASHIFT) + ABASE;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                U.putOrderedObject(forkJoinTaskArray, l, forkJoinTask);
                this.top = n + 1;
                int n3 = this.top - this.base;
                RuntimeCostAccounter.recordJump();
                if (n3 <= 2) {
                    ForkJoinPool forkJoinPool = this.pool;
                    WorkQueue[] workQueueArray = forkJoinPool.workQueues;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.signalWork:([Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinPool$WorkQueue;)V");
                    forkJoinPool.signalWork(workQueueArray, this);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= n2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.growArray:()[Ljava/util/concurrent/ForkJoinTask;");
                        this.growArray();
                    }
                }
            }
        }

        final ForkJoinTask<?>[] growArray() {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (forkJoinTaskArray != null) {
                n = forkJoinTaskArray.length << 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 8192;
            }
            int n2 = n;
            RuntimeCostAccounter.recordJump();
            if (n2 > 0x4000000) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/RejectedExecutionException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RejectedExecutionException.<init>:(Ljava/lang/String;)V");
                RejectedExecutionException rejectedExecutionException = new RejectedExecutionException("Queue capacity exceeded");
                RuntimeCostAccounter.recordThrow();
                throw rejectedExecutionException;
            }
            int n3 = n2;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
            this.array = new ForkJoinTask[n3];
            ForkJoinTask[] forkJoinTaskArray2 = this.array;
            RuntimeCostAccounter.recordJump();
            if (forkJoinTaskArray != null) {
                int n4 = forkJoinTaskArray.length - 1;
                RuntimeCostAccounter.recordJump();
                if (n4 >= 0) {
                    int n5 = this.top;
                    int n6 = this.base;
                    RuntimeCostAccounter.recordJump();
                    if (n5 - n6 > 0) {
                        int n7 = n2 - 1;
                        do {
                            int n8 = ((n6 & n4) << ASHIFT) + ABASE;
                            int n9 = ((n6 & n7) << ASHIFT) + ABASE;
                            long l = n8;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
                            ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, l);
                            RuntimeCostAccounter.recordJump();
                            if (forkJoinTask != null) {
                                long l2 = n8;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = U.compareAndSwapObject(forkJoinTaskArray, l2, (Object)forkJoinTask, null);
                                RuntimeCostAccounter.recordJump();
                                if (bl) {
                                    long l3 = n9;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObjectVolatile:(Ljava/lang/Object;JLjava/lang/Object;)V");
                                    U.putObjectVolatile((Object)forkJoinTaskArray2, l3, (Object)forkJoinTask);
                                }
                            }
                            RuntimeCostAccounter.recordJump();
                        } while (++n6 != n5);
                    }
                }
            }
            return forkJoinTaskArray2;
        }

        final ForkJoinTask<?> pop() {
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (this.array != null) {
                int n = forkJoinTaskArray.length - 1;
                RuntimeCostAccounter.recordJump();
                if (n >= 0) {
                    while (true) {
                        int n2 = this.top - 1;
                        RuntimeCostAccounter.recordJump();
                        if (n2 - this.base < 0) break;
                        long l = ((n & n2) << ASHIFT) + ABASE;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObject:(Ljava/lang/Object;J)Ljava/lang/Object;");
                        ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObject(forkJoinTaskArray, l);
                        RuntimeCostAccounter.recordJump();
                        if (forkJoinTask == null) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl = U.compareAndSwapObject(forkJoinTaskArray, l, (Object)forkJoinTask, null);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            this.top = n2;
                            return forkJoinTask;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int n) {
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (this.array != null) {
                int n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
                long l = n2;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
                ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, l);
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask != null) {
                    RuntimeCostAccounter.recordJump();
                    if (this.base == n) {
                        long l2 = n2;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl = U.compareAndSwapObject(forkJoinTaskArray, l2, (Object)forkJoinTask, null);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
                            U.putOrderedInt((Object)this, QBASE, n + 1);
                            return forkJoinTask;
                        }
                    }
                }
            }
            return null;
        }

        final ForkJoinTask<?> poll() {
            while (true) {
                int n = this.base;
                RuntimeCostAccounter.recordJump();
                if (n - this.top >= 0) break;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                RuntimeCostAccounter.recordJump();
                if (this.array == null) break;
                int n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
                long l = n2;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
                ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, l);
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask != null) {
                    long l2 = n2;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl = U.compareAndSwapObject(forkJoinTaskArray, l2, (Object)forkJoinTask, null);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
                        U.putOrderedInt((Object)this, QBASE, n + 1);
                        return forkJoinTask;
                    }
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.base == n) {
                        RuntimeCostAccounter.recordJump();
                        if (n + 1 == this.top) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
                        Thread.yield();
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            ForkJoinTask<?> forkJoinTask;
            RuntimeCostAccounter.recordJump();
            if (this.mode == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pop:()Ljava/util/concurrent/ForkJoinTask;");
                forkJoinTask = this.pop();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.poll:()Ljava/util/concurrent/ForkJoinTask;");
                forkJoinTask = this.poll();
            }
            return forkJoinTask;
        }

        final ForkJoinTask<?> peek() {
            int n;
            int n2;
            ForkJoinTask<?>[] forkJoinTaskArray;
            block6: {
                block5: {
                    forkJoinTaskArray = this.array;
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTaskArray == null) break block5;
                    n2 = forkJoinTaskArray.length - 1;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= 0) break block6;
                }
                return null;
            }
            RuntimeCostAccounter.recordJump();
            if (this.mode == 0) {
                n = this.top - 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n = this.base;
            }
            int n3 = n;
            int n4 = ((n3 & n2) << ASHIFT) + ABASE;
            long l = n4;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
            return (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, l);
        }

        final boolean tryUnpush(ForkJoinTask<?> forkJoinTask) {
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (this.array != null) {
                int n = this.top;
                RuntimeCostAccounter.recordJump();
                if (n != this.base) {
                    long l = ((forkJoinTaskArray.length - 1 & --n) << ASHIFT) + ABASE;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl = U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        this.top = n;
                        return true;
                    }
                }
            }
            return false;
        }

        final void cancelAll() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.cancelIgnoringExceptions:(Ljava/util/concurrent/ForkJoinTask;)V");
            ForkJoinTask.cancelIgnoringExceptions(this.currentJoin);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.cancelIgnoringExceptions:(Ljava/util/concurrent/ForkJoinTask;)V");
            ForkJoinTask.cancelIgnoringExceptions(this.currentSteal);
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.poll:()Ljava/util/concurrent/ForkJoinTask;");
                ForkJoinTask<?> forkJoinTask = this.poll();
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.cancelIgnoringExceptions:(Ljava/util/concurrent/ForkJoinTask;)V");
                ForkJoinTask.cancelIgnoringExceptions(forkJoinTask);
                RuntimeCostAccounter.recordJump();
            }
        }

        final void pollAndExecAll() {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.poll:()Ljava/util/concurrent/ForkJoinTask;");
                ForkJoinTask<?> forkJoinTask = this.poll();
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                forkJoinTask.doExec();
                RuntimeCostAccounter.recordJump();
            }
        }

        final void runTask(ForkJoinTask<?> forkJoinTask) {
            this.currentSteal = forkJoinTask;
            RuntimeCostAccounter.recordJump();
            if (this.currentSteal != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                forkJoinTask.doExec();
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                short s = this.mode;
                ++this.nsteals;
                this.currentSteal = null;
                RuntimeCostAccounter.recordJump();
                if (s != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.pollAndExecAll:()V");
                    this.pollAndExecAll();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinTaskArray != null) {
                        int n = forkJoinTaskArray.length - 1;
                        while (true) {
                            int n2 = this.top - 1;
                            RuntimeCostAccounter.recordJump();
                            if (n2 - this.base < 0) break;
                            long l = ((n & n2) << ASHIFT) + ABASE;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndSetObject:(Ljava/lang/Object;JLjava/lang/Object;)Ljava/lang/Object;");
                            ForkJoinTask forkJoinTask2 = (ForkJoinTask)U.getAndSetObject(forkJoinTaskArray, l, null);
                            RuntimeCostAccounter.recordJump();
                            if (forkJoinTask2 == null) break;
                            this.top = n2;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                            forkJoinTask2.doExec();
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                }
                ForkJoinWorkerThread forkJoinWorkerThread = this.owner;
                RuntimeCostAccounter.recordJump();
                if (forkJoinWorkerThread != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread.afterTopLevelExec:()V");
                    forkJoinWorkerThread.afterTopLevelExec();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean tryRemoveAndExec(ForkJoinTask<?> forkJoinTask) {
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask == null) return false;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (this.array == null) return false;
            int n = forkJoinTaskArray.length - 1;
            RuntimeCostAccounter.recordJump();
            if (n < 0) return false;
            int n2 = this.top;
            int n3 = this.base;
            int n4 = n2 - n3;
            RuntimeCostAccounter.recordJump();
            if (n4 <= 0) return false;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            while (true) {
                long l = ((--n2 & n) << ASHIFT) + ABASE;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObject:(Ljava/lang/Object;J)Ljava/lang/Object;");
                ForkJoinTask forkJoinTask2 = (ForkJoinTask)U.getObject(forkJoinTaskArray, l);
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask2 == null) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (forkJoinTask2 == forkJoinTask) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 + 1 == this.top) {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl4 = U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null);
                        RuntimeCostAccounter.recordJump();
                        if (!bl4) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        this.top = n2;
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.base != n3) break;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool$EmptyTask");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$EmptyTask.<init>:()V");
                    EmptyTask emptyTask = new EmptyTask();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                    bl = U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, (Object)emptyTask);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                int n5 = forkJoinTask2.status;
                RuntimeCostAccounter.recordJump();
                if (n5 >= 0) {
                    bl2 = false;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n2 + 1 == this.top) {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl5 = U.compareAndSwapObject(forkJoinTaskArray, l, (Object)forkJoinTask2, null);
                        RuntimeCostAccounter.recordJump();
                        if (!bl5) break;
                        this.top = n2;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (--n4 == 0) {
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break;
                    RuntimeCostAccounter.recordJump();
                    if (this.base != n3) break;
                    bl3 = false;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                forkJoinTask.doExec();
            }
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        final boolean pollAndExecCC(CountedCompleter<?> countedCompleter) {
            block7: {
                int n = this.base;
                RuntimeCostAccounter.recordJump();
                if (n - this.top >= 0) break block7;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                RuntimeCostAccounter.recordJump();
                if (this.array != null) {
                    long l = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
                    Object object = U.getObjectVolatile(forkJoinTaskArray, l);
                    RuntimeCostAccounter.recordJump();
                    if (object == null) {
                        return true;
                    }
                    boolean bl = object instanceof CountedCompleter;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        CountedCompleter<?> countedCompleter2;
                        CountedCompleter<?> countedCompleter3 = countedCompleter2 = (CountedCompleter<?>)object;
                        do {
                            RuntimeCostAccounter.recordJump();
                            if (countedCompleter3 == countedCompleter) {
                                RuntimeCostAccounter.recordJump();
                                if (this.base == n) {
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    boolean bl2 = U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter2, null);
                                    RuntimeCostAccounter.recordJump();
                                    if (bl2) {
                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
                                        U.putOrderedInt((Object)this, QBASE, n + 1);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.doExec:()I");
                                        countedCompleter2.doExec();
                                    }
                                }
                                return true;
                            }
                            countedCompleter3 = countedCompleter3.completer;
                            RuntimeCostAccounter.recordJump();
                        } while (countedCompleter3 != null);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        final boolean externalPopAndExecCC(CountedCompleter<?> countedCompleter) {
            CountedCompleter<?> countedCompleter2;
            int n = this.top;
            RuntimeCostAccounter.recordJump();
            if (this.base - n >= 0) return false;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (this.array == null) return false;
            long l = ((forkJoinTaskArray.length - 1 & n - 1) << ASHIFT) + ABASE;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObject:(Ljava/lang/Object;J)Ljava/lang/Object;");
            Object object = U.getObject(forkJoinTaskArray, l);
            boolean bl = object instanceof CountedCompleter;
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            CountedCompleter<?> countedCompleter3 = countedCompleter2 = (CountedCompleter<?>)object;
            do {
                RuntimeCostAccounter.recordJump();
                if (countedCompleter3 == countedCompleter) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                    boolean bl2 = U.compareAndSwapInt((Object)this, QLOCK, 0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) return true;
                    RuntimeCostAccounter.recordJump();
                    if (this.top == n) {
                        RuntimeCostAccounter.recordJump();
                        if (this.array == forkJoinTaskArray) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl3 = U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter2, null);
                            RuntimeCostAccounter.recordJump();
                            if (bl3) {
                                this.top = n - 1;
                                this.qlock = 0;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.doExec:()I");
                                countedCompleter2.doExec();
                                RuntimeCostAccounter.recordJump();
                                return true;
                            }
                        }
                    }
                    this.qlock = 0;
                    return true;
                }
                countedCompleter3 = countedCompleter3.completer;
                RuntimeCostAccounter.recordJump();
            } while (countedCompleter3 != null);
            RuntimeCostAccounter.recordJump();
            return false;
        }

        final boolean internalPopAndExecCC(CountedCompleter<?> countedCompleter) {
            block5: {
                int n = this.top;
                RuntimeCostAccounter.recordJump();
                if (this.base - n >= 0) break block5;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                RuntimeCostAccounter.recordJump();
                if (this.array != null) {
                    long l = ((forkJoinTaskArray.length - 1 & n - 1) << ASHIFT) + ABASE;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObject:(Ljava/lang/Object;J)Ljava/lang/Object;");
                    Object object = U.getObject(forkJoinTaskArray, l);
                    boolean bl = object instanceof CountedCompleter;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        CountedCompleter<?> countedCompleter2;
                        CountedCompleter<?> countedCompleter3 = countedCompleter2 = (CountedCompleter<?>)object;
                        do {
                            RuntimeCostAccounter.recordJump();
                            if (countedCompleter3 == countedCompleter) {
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl2 = U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter2, null);
                                RuntimeCostAccounter.recordJump();
                                if (bl2) {
                                    this.top = n - 1;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.doExec:()I");
                                    countedCompleter2.doExec();
                                }
                                return true;
                            }
                            countedCompleter3 = countedCompleter3.completer;
                            RuntimeCostAccounter.recordJump();
                        } while (countedCompleter3 != null);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isApparentlyUnblocked() {
            RuntimeCostAccounter.recordJump();
            if (this.eventCount < 0) return false;
            ForkJoinWorkerThread forkJoinWorkerThread = this.owner;
            RuntimeCostAccounter.recordJump();
            if (forkJoinWorkerThread == null) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getState:()Ljava/lang/Thread$State;");
            Thread.State state = forkJoinWorkerThread.getState();
            RuntimeCostAccounter.recordJump();
            if (state == Thread.State.BLOCKED) return false;
            RuntimeCostAccounter.recordJump();
            if (state == Thread.State.WAITING) return false;
            RuntimeCostAccounter.recordJump();
            if (state == Thread.State.TIMED_WAITING) return false;
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        static {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
                U = Unsafe.getUnsafe();
                Class<WorkQueue> clazz = WorkQueue.class;
                Class<ForkJoinTask[]> clazz2 = ForkJoinTask[].class;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field = clazz.getDeclaredField("base");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                QBASE = U.objectFieldOffset(field);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field2 = clazz.getDeclaredField("qlock");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                QLOCK = U.objectFieldOffset(field2);
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.arrayBaseOffset:(Ljava/lang/Class;)I");
                ABASE = U.arrayBaseOffset(clazz2);
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.arrayIndexScale:(Ljava/lang/Class;)I");
                int n = U.arrayIndexScale(clazz2);
                RuntimeCostAccounter.recordJump();
                if ((n & n - 1) != 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                    Error error = new Error("data type scale not a power of two");
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
                ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
                Error error = new Error(exception);
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        private static final long serialVersionUID = -7721805057305804111L;

        EmptyTask() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public final ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinWorkerThread");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinWorkerThread.<init>:(Ljava/util/concurrent/ForkJoinPool;)V");
            return new ForkJoinWorkerThread(forkJoinPool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

