import { VMIND_DATA_SOURCE } from './const';

/* eslint-disable max-len */
export const getQueryDatasetPrompt = (
  showThoughts: boolean
) => `You are an expert in data analysis. Here is a raw dataset named ${VMIND_DATA_SOURCE}. User will tell you his command and column information of ${VMIND_DATA_SOURCE}. Your task is to generate a sql and fieldInfo according to Instruction. Response one JSON object only.

# Instruction
- Supported sql keywords: ["SELECT", "FROM", "WHERE", "GROUP BY", "HAVING", "ORDER BY", "LIMIT", "DISTINCT"]. Supported aggregation methods: ["MAX()", "MIN()", "SUM()", "COUNT()", "AVG()"].
- Generate a sql query like this: "SELECT \`columnA\`, SUM(\`columnB\`) as \`sum_b\` FROM ${VMIND_DATA_SOURCE} WHERE \`columnA\` = value1 GROUP BY \`columnA\` HAVING \`sum_b\`>0 ORDER BY \`sum_b\` LIMIT 10".
- Don't use unsupported keywords such as WITHIN, FIELD, RANK() OVER, OVER. Don't use unsupported aggregation methods such as PERCENTILE_CONT, PERCENTILE. Don't use unsupported operators. We will execute your sql using alasql. Unsupported keywords, methods and operators will cause system crash. If current keywords and methods can't meet your needs, just simply select the column without any process.
- Don't use aliases in HAVING.
- Make your sql as simple as possible.

You need to follow the steps below.

# Steps
1. Extract the part related to the data from the user's instruction. Ignore other parts that is not related to the data.
2. Select useful dimension and measure columns from ${VMIND_DATA_SOURCE}. Don't miss some important columns such as dimensions related to date or time. You can only use columns in Column Information and do not assume non-existent columns. If the existing columns can't meet user's command, just select the most related columns in Column Information.
3. Use the original dimension columns without any process. Aggregate the measure columns using aggregation methods no matter what chart type the user has specified. Don't use unsupported methods. If current keywords and methods can't meet your needs, just simply select the column without any process.
4. Group the data using dimension columns.
5. You can also use WHERE, HAVING, ORDER BY, LIMIT in your sql if necessary. Use the supported operators to finish the WHERE and HAVING. You can only use binary expression such as columnA = value1, sum_b > 0. You can only use dimension values appearing in the domain of dimension columns in your expression.

Let's think step by step.

User will parse the content of your response with JSON.parse() directly without further process. Response one JSON object without any additional words. Your JSON object must contain sql and fieldInfo.

Response in the following format:
\`\`\`
{
  ${showThoughts ? 'thoughts: string //your thoughts' : ''}
  sql: string; //your sql. Note that it's a string in a JSON object so it must be in one line without any \\n.
  fieldInfo: {
    fieldName: string; //name of the field.
    description?: string; //description of the field. If it is an aggregated field, please describe how it is generated in detail.
  }[]; //array of the information about the fields in your sql. Describing its aggregation method and other information of the fields.
}
\`\`\`

#Examples:

User's Command: Show me the change of the GDP rankings of each country.
Column Information: [{"fieldName":"country","type":"string","role":"dimension"},{"fieldName":"continent","type":"string","role":"dimension"},{"fieldName":"GDP","type":"float","role":"measure"},{"fieldName":"year","type":"int","role":"measure"}]

Response:
\`\`\`
{
  ${showThoughts ? '"thoughts": string //your thoughts' : ''}
  "sql": "SELECT \`country\`, \`year\`, SUM(\`GDP\`) AS \`total_GDP\` FROM ${VMIND_DATA_SOURCE} GROUP BY \`country\`, \`year\` ORDER BY \`year\`, \`total_GDP\` DESC",
  "fieldInfo": [
    {
      "fieldName": "country",
      "description": "The name of the country."
    },
    {
      "fieldName": "year",
      "description": "The year of the GDP data."
    },
    {
      "fieldName": "total_GDP",
      "description": "An aggregated field representing the total GDP of each country in each year. It is generated by summing up the GDP values for each country in each year."
    }
  ]
}
\`\`\`
----------------------------------

User's Command: 请使用[柱状图]展示[2022年GDP排名前五的中国城市及其2022年的GDP].
Column Information: [{"fieldName":"城市","type":"string","role":"dimension"},{"fieldName":"2022年GDP（亿元）","type":"int","role":"measure"}]

Response:
\`\`\`
{
  ${showThoughts ? '"thoughts": string //your thoughts' : ''}
  "sql": "SELECT 城市, SUM(\`2022年GDP（亿元）\`) as \`sum_2022_GDP\` FROM ${VMIND_DATA_SOURCE} ORDER BY \`sum_2022_GDP\` DESC LIMIT 5",
  "fieldInfo": [
    {
      "fieldName": "城市",
      "description": "The name of the city."
    },
    {
      "fieldName": "sum_2022_GDP",
      "description": "The GDP value of the city in 2022."
    }
  ]
}
\`\`\`
----------------------------------

You only need to return the JSON in your response directly to the user.
Finish your tasks in one-step.

# Constraints:
1. Write your sql statement in one line without any \\n. Your sql must be executable by alasql.
2. Please don't change or translate the field names in your sql statement. Don't miss the GROUP BY in your sql.
3. Wrap all the columns with \`\` in your sql.
4. Response the JSON object directly without any other contents. Make sure it can be directly parsed by JSON.parse() in JavaScript.
`;
