import { SpecInsightAtom } from '../../../src/atom/specInsight';

const spec = {
  type: 'line',
  xField: ['年份'],
  yField: ['高考录取率'],
  data: [
    {
      id: 'data',
      values: [
        {
          年份: 1977,
          高考人数: 570,
          高考录取人数: 27.3,
          高考录取率: 0.05,
          招生高校数: 404
        },
        {
          年份: 1978,
          高考人数: 610,
          高考录取人数: 40.2,
          高考录取率: 0.07,
          招生高校数: 598
        },
        {
          年份: 1979,
          高考人数: 468,
          高考录取人数: 28,
          高考录取率: 0.06,
          招生高校数: 633
        },
        {
          年份: 1980,
          高考人数: 333,
          高考录取人数: 28,
          高考录取率: 0.08,
          招生高校数: 675
        },
        {
          年份: 1981,
          高考人数: 259,
          高考录取人数: 28,
          高考录取率: 0.11,
          招生高校数: 704
        },
        {
          年份: 1982,
          高考人数: 187,
          高考录取人数: 32,
          高考录取率: 0.17,
          招生高校数: 715
        },
        {
          年份: 1983,
          高考人数: 167,
          高考录取人数: 39,
          高考录取率: 0.23,
          招生高校数: 805
        },
        {
          年份: 1984,
          高考人数: 164,
          高考录取人数: 48,
          高考录取率: 0.29,
          招生高校数: 902
        },
        {
          年份: 1985,
          高考人数: 176,
          高考录取人数: 62,
          高考录取率: 0.96,
          招生高校数: 1016
        },
        {
          年份: 1986,
          高考人数: 191,
          高考录取人数: 57,
          高考录取率: 0.3,
          招生高校数: 1054
        },
        {
          年份: 1987,
          高考人数: 228,
          高考录取人数: 62,
          高考录取率: 0.27,
          招生高校数: 1063
        },
        {
          年份: 1988,
          高考人数: 272,
          高考录取人数: 67,
          高考录取率: 0.25,
          招生高校数: 1075
        },
        {
          年份: 1989,
          高考人数: 266,
          高考录取人数: 60,
          高考录取率: 0.23,
          招生高校数: 1079
        },
        {
          年份: 1990,
          高考人数: 283,
          高考录取人数: 61,
          高考录取率: 0.22,
          招生高校数: 1075
        },
        {
          年份: 1991,
          高考人数: 296,
          高考录取人数: 62,
          高考录取率: 0.21,
          招生高校数: 1075
        },
        {
          年份: 1992,
          高考人数: 303,
          高考录取人数: 75,
          高考录取率: 0.25,
          招生高校数: 1053
        },
        {
          年份: 1993,
          高考人数: 286,
          高考录取人数: 98,
          高考录取率: 0.34,
          招生高校数: 1065
        },
        {
          年份: 1994,
          高考人数: 251,
          高考录取人数: 90,
          高考录取率: 0.36,
          招生高校数: 1080
        },
        {
          年份: 1995,
          高考人数: 253,
          高考录取人数: 93,
          高考录取率: 0.37,
          招生高校数: 1054
        },
        {
          年份: 1996,
          高考人数: 241,
          高考录取人数: 97,
          高考录取率: 0.4,
          招生高校数: 1032
        },
        {
          年份: 1997,
          高考人数: 278,
          高考录取人数: 100,
          高考录取率: 0.36,
          招生高校数: 1020
        },
        {
          年份: 1998,
          高考人数: 320,
          高考录取人数: 108,
          高考录取率: 0.34,
          招生高校数: 1022
        },
        {
          年份: 1999,
          高考人数: 288,
          高考录取人数: 160,
          高考录取率: 0.56,
          招生高校数: 1071
        },
        {
          年份: 2000,
          高考人数: 375,
          高考录取人数: 221,
          高考录取率: 0.59,
          招生高校数: 1041
        },
        {
          年份: 2001,
          高考人数: 454,
          高考录取人数: 268,
          高考录取率: 0.59,
          招生高校数: 1225
        },
        {
          年份: 2002,
          高考人数: 510,
          高考录取人数: 320,
          高考录取率: 0.63,
          招生高校数: 1396
        },
        {
          年份: 2003,
          高考人数: 613,
          高考录取人数: 382,
          高考录取率: 0.62,
          招生高校数: 1552
        },
        {
          年份: 2004,
          高考人数: 729,
          高考录取人数: 447,
          高考录取率: 0.61,
          招生高校数: 1731
        },
        {
          年份: 2005,
          高考人数: 877,
          高考录取人数: 504,
          高考录取率: 0.57,
          招生高校数: 1792
        },
        {
          年份: 2006,
          高考人数: 950,
          高考录取人数: 546,
          高考录取率: 0.57,
          招生高校数: 1867
        },
        {
          年份: 2007,
          高考人数: 1010,
          高考录取人数: 566,
          高考录取率: 0.56,
          招生高校数: 1908
        },
        {
          年份: 2008,
          高考人数: 1050,
          高考录取人数: 599,
          高考录取率: 0.57,
          招生高校数: 2263
        },
        {
          年份: 2009,
          高考人数: 1020,
          高考录取人数: 629,
          高考录取率: 0.62,
          招生高校数: 2305
        },
        {
          年份: 2010,
          高考人数: 946,
          高考录取人数: 657,
          高考录取率: 0.69,
          招生高校数: 2385
        },
        {
          年份: 2011,
          高考人数: 933,
          高考录取人数: 675,
          高考录取率: 0.72,
          招生高校数: 2487
        },
        {
          年份: 2012,
          高考人数: 915,
          高考录取人数: 685,
          高考录取率: 0.75,
          招生高校数: 2442
        },
        {
          年份: 2013,
          高考人数: 912,
          高考录取人数: 684,
          高考录取率: 0.75,
          招生高校数: 2622
        },
        {
          年份: 2014,
          高考人数: 939,
          高考录取人数: 697,
          高考录取率: 0.74,
          招生高校数: 2529
        },
        {
          年份: 2015,
          高考人数: 942,
          高考录取人数: 700,
          高考录取率: 0.74,
          招生高校数: 2553
        },
        {
          年份: 2016,
          高考人数: 940,
          高考录取人数: 705,
          高考录取率: 0.75,
          招生高校数: 2595
        },
        {
          年份: 2017,
          高考人数: 940,
          高考录取人数: 700,
          高考录取率: 0.74,
          招生高校数: 2631
        },
        {
          年份: 2018,
          高考人数: 975,
          高考录取人数: 790.99,
          高考录取率: 0.81,
          招生高校数: 2663
        },
        {
          年份: 2019,
          高考人数: 1031,
          高考录取人数: 820,
          高考录取率: 0.8,
          招生高校数: 2688
        },
        {
          年份: 2020,
          高考人数: 1071,
          高考录取人数: 856,
          高考录取率: 0.8,
          招生高校数: 2956
        },
        {
          年份: 2021,
          高考人数: 1078,
          高考录取人数: 1001.32,
          高考录取率: 0.93,
          招生高校数: 2956
        },
        {
          年份: 2022,
          高考人数: 1193,
          高考录取人数: 1145.28,
          高考录取率: 0.96,
          招生高校数: 2956
        }
      ]
    }
  ],
  axes: [
    {
      type: 'band',
      orient: 'bottom',
      visible: true
    },
    {
      type: 'linear',
      orient: 'left',
      visible: true
    }
  ],
  legends: [
    {
      type: 'discrete',
      visible: true
    }
  ]
};

const insights: any[] = [
  {
    type: 'overall_trend',
    fieldId: '高考录取率',
    value: 'increasing',
    significant: 0.9999999999999836,
    info: {
      length: 7,
      overall: {
        coordinates: [
          {
            年份: 1977,
            高考录取率: 0.05
          },
          {
            年份: 2022,
            高考录取率: 0.96
          }
        ],
        start: 0,
        end: 45,
        change: 18.2,
        startValue: 0.05,
        endValue: 0.96,
        startDimValue: 1977,
        endDimValue: 2022
      },
      start: 2,
      end: 8,
      maxTrend: 1,
      change: 15,
      startDimValue: 1979,
      endDimValue: 1985,
      startValue: 0.06,
      endValue: 0.96
    },
    name: 'overallTrending',
    textContent: {
      content: '数据整体呈${a}趋势，整体增长了${d}。其中在${b}至${c}间连续${a}。',
      variables: {
        a: {
          value: '上升',
          icon: 'ascendTrend'
        },
        b: {
          isDimValue: true,
          value: 1979,
          fieldName: '年份'
        },
        c: {
          isDimValue: true,
          value: 1985,
          fieldName: '年份'
        },
        d: {
          formatValue: '1820.0%',
          value: 18.2,
          valueType: 'ascendTrend'
        }
      },
      plainText: '数据整体呈上升趋势，整体增长了1820.0%。其中在1979至1985间连续上升。'
    }
  }
];

describe('updateSpecByInsights of overall_trend', () => {
  it('add markline of growth overall trend', async () => {
    const specInishgtAtom = new SpecInsightAtom({ spec, insights }, {});
    const { newSpec } = await specInishgtAtom.run();
    expect(newSpec.markLine[0].coordinates).toEqual([
      {
        年份: 1977,
        高考录取率: 0.05
      },
      {
        年份: 2022,
        高考录取率: 0.96
      }
    ]);
  });
});
