import { error, log } from 'console';
import VMind, { Model } from '../../src/index';

import {
  mockUserInput10,
  mockUserInput2,
  mockUserInput3,
  mockUserInput3Eng,
  mockUserInput6,
  mockUserInput6Eng,
  mockUserInput8,
  carSaleMockData,
  mockUserInput15,
  acceptRatioData,
  mallSalesData,
  hotWordsData,
  mockUserInput4,
  mockUserInput5,
  mockUserInput9,
  mockUserInput11,
  mockUserInput12,
  mockUserInput13,
  mockUserInput14,
  mockUserInput16,
  mockUserInput17
} from '../browser/src/constants/mockData';

import * as dotenv from 'dotenv';
import * as path from 'path';

// 读取 .env.local 文件
dotenv.config({ path: path.resolve(__dirname, '../../.env.local') });

const TEST_GPT = true;
const ShowThoughts = false;
const EnableDataQuery = true;

const demoDataList: { [key: string]: any } = {
  pie: mockUserInput2,
  'dynamic bar zh_cn': mockUserInput6,
  line: mockUserInput8,
  column: mockUserInput3,
  column2: mockUserInput10,
  wordcloud: hotWordsData,
  wordcloud2: mockUserInput5,
  'scatter plot': mockUserInput4,
  funnel: mockUserInput9,
  'dual-axis': mockUserInput11,
  waterfall: mockUserInput12,
  rose: mockUserInput13,
  radar: mockUserInput14,
  sankey: mockUserInput15,
  'box-plot': mockUserInput16,
  'Electric vehicle sales': carSaleMockData,
  'College entrance examination': acceptRatioData,
  'Shopping Mall Sales Performance': mallSalesData,
  'Global GDP': mockUserInput6Eng,
  'Sales of different drinkings': mockUserInput3Eng,
  'Multi measure': mockUserInput17
};
const CHART_GENERATION_AVERAGE_TIME = 10000;
const QPM_LIMIT = 10; //qpm limit of your llm service
const TOKEN_LIMIT = 20000; //token limit of your llm service
const START_INDEX = 0;

const modelResultMap = {
  [Model.GPT3_5]: { totalCount: 0, successCount: 0, totalTime: 0 }
};

const testPerformance = (model: Model, vmind: VMind) => {
  dataList.some((dataName, index) => {
    if (index >= START_INDEX) {
      it(dataName, async done => {
        log(dataName + '......');
        const { csv, input } = demoDataList[dataName];
        const { fieldInfo, dataset } = vmind.parseCSVData(csv);
        //const { fieldInfo, dataset } = await vmind.parseCSVDataWithLLM(csv, describe);
        const startTime = new Date().getTime();
        const { spec, time, chartSource, chartType } = await vmind.generateChart(input, fieldInfo, dataset, {
          enableDataQuery: EnableDataQuery
        });
        const endTime = new Date().getTime();
        log('generated chart type: ' + chartType);
        if (chartSource !== 'chartAdvisor') {
          const costTime = endTime - startTime;
          log('time cost: ' + costTime / 1000 + 's');
          (modelResultMap as any)[model].totalTime += costTime;
          (modelResultMap as any)[model].successCount += 1;
        } else {
          error('fail to generate with LLM!');
        }
        // done();
      });
    }
    (modelResultMap as any)[model].totalCount += 1;
  });
};
const dataList = Object.keys(demoDataList);

const gptKey = process.env.VITE_GPT_KEY;
const gptURL = process.env.VITE_GPT_JEST_URL;
if (gptKey && gptURL && TEST_GPT) {
  const vmind = new VMind({
    url: gptURL,
    model: Model.GPT3_5,
    showThoughts: ShowThoughts,
    headers: {
      'api-key': gptKey
    }
  });
  testPerformance(Model.GPT3_5, vmind);
}

test('always passes', () => {
  expect(1).toBe(1);
});

afterAll(() => {
  log('---------------VMind performance test---------------');
  Object.keys(modelResultMap).forEach(model => {
    log(`---------------${model}---------------`);

    const { successCount, totalCount, totalTime } = (modelResultMap as any)[model];
    log('success count: ' + successCount);
    log('total count: ' + totalCount);
    log('success ratio: ' + (successCount / totalCount) * 100 + '%');

    log('chart generation average time: ' + totalTime / successCount / 1000 + 's');

    log('------------------------------');
  });
});
