const markerStyle = {
  startSymbol: {
    visible: true,
    style: {
      symbolType: 'circle',
      size: 8
    }
  },
  label: {
    formatMethod: (...p) => {
      return p[0][0].y;
    },
    position: 'insideEndBottom',
    refY: -5,
    labelBackground: {
      visible: false
    }
  }
};
const spec = {
  type: 'line',
  xField: 'x',
  yField: 'y',
  point: {
    visible: false
  },
  markLine: [
    {
      y: 50,
      ...markerStyle
    },
    {
      y: 100,
      ...markerStyle
    },
    {
      y: 150,
      ...markerStyle
    },
    {
      y: 200,
      ...markerStyle
    },
    {
      y: 250,
      ...markerStyle
    },
    {
      y: 300,
      ...markerStyle
    }
  ],
  dataZoom: [
    {
      orient: 'bottom',
      start: 0.8,
      end: 1
    }
  ],
  line: {
    style: {
      stroke: {
        gradient: 'linear',
        x0: 0.5,
        y0: 0,
        x1: 0.5,
        y1: 1,
        stops: [
          {
            offset: 0,
            color: '#AC3B2A'
          },
          {
            offset: 0.28,
            color: '#AC3B2A'
          },
          {
            offset: 0.28,
            color: '#AA069F'
          },
          {
            offset: 0.42,
            color: '#AA069F'
          },
          {
            offset: 0.42,
            color: '#FD0100'
          },
          {
            offset: 0.56,
            color: '#FD0100'
          },
          {
            offset: 0.56,
            color: '#FC7D02'
          },
          {
            offset: 0.72,
            color: '#FC7D02'
          },
          {
            offset: 0.72,
            color: '#FBDB0F'
          },
          {
            offset: 0.85,
            color: '#FBDB0F'
          },
          {
            offset: 0.85,
            color: '#93CE07'
          },
          {
            offset: 1,
            color: '#93CE07'
          }
        ]
      }
    }
  },
  data: [
    {
      id: 'id0',
      values: [
        {
          x: '2012-01-01',
          y: 81
        },
        {
          x: '2012-01-02',
          y: 74
        },
        {
          x: '2012-01-03',
          y: 35
        },
        {
          x: '2012-01-04',
          y: 30
        },
        {
          x: '2012-01-05',
          y: 63
        },
        {
          x: '2012-01-06',
          y: 95
        },
        {
          x: '2012-01-07',
          y: 65
        },
        {
          x: '2012-01-08',
          y: 89
        },
        {
          x: '2012-01-09',
          y: 102
        },
        {
          x: '2012-01-10',
          y: 161
        },
        {
          x: '2012-01-11',
          y: 25
        },
        {
          x: '2012-01-12',
          y: 86
        },
        {
          x: '2012-01-13',
          y: 79
        },
        {
          x: '2012-01-14',
          y: 60
        },
        {
          x: '2012-01-15',
          y: 70
        },
        {
          x: '2012-01-16',
          y: 106
        },
        {
          x: '2012-01-17',
          y: 111
        },
        {
          x: '2012-01-18',
          y: 193
        },
        {
          x: '2012-01-19',
          y: 269
        },
        {
          x: '2012-01-20',
          y: 131
        },
        {
          x: '2012-01-21',
          y: 21
        },
        {
          x: '2012-01-22',
          y: 23
        },
        {
          x: '2012-01-23',
          y: 149
        },
        {
          x: '2012-01-24',
          y: 49
        },
        {
          x: '2012-01-25',
          y: 45
        },
        {
          x: '2012-01-26',
          y: 78
        },
        {
          x: '2012-01-27',
          y: 67
        },
        {
          x: '2012-01-28',
          y: 74
        },
        {
          x: '2012-01-29',
          y: 62
        },
        {
          x: '2012-01-30',
          y: 66
        },
        {
          x: '2012-01-31',
          y: 92
        },
        {
          x: '2012-02-01',
          y: 30
        },
        {
          x: '2012-02-02',
          y: 26
        },
        {
          x: '2012-02-03',
          y: 60
        },
        {
          x: '2012-02-04',
          y: 52
        },
        {
          x: '2012-02-05',
          y: 84
        },
        {
          x: '2012-02-06',
          y: 112
        },
        {
          x: '2012-02-07',
          y: 64
        },
        {
          x: '2012-02-08',
          y: 34
        },
        {
          x: '2012-02-09',
          y: 58
        },
        {
          x: '2012-02-10',
          y: 49
        },
        {
          x: '2012-02-11',
          y: 73
        },
        {
          x: '2012-02-12',
          y: 75
        },
        {
          x: '2012-02-13',
          y: 100
        },
        {
          x: '2012-02-14',
          y: 125
        },
        {
          x: '2012-02-15',
          y: 62
        },
        {
          x: '2012-02-16',
          y: 61
        },
        {
          x: '2012-02-17',
          y: 34
        },
        {
          x: '2012-02-18',
          y: 29
        },
        {
          x: '2012-02-19',
          y: 68
        },
        {
          x: '2012-02-20',
          y: 73
        },
        {
          x: '2012-02-21',
          y: 118
        },
        {
          x: '2012-02-22',
          y: 118
        },
        {
          x: '2012-02-23',
          y: 73
        },
        {
          x: '2012-02-24',
          y: 73
        },
        {
          x: '2012-02-25',
          y: 57
        },
        {
          x: '2012-02-26',
          y: 57
        },
        {
          x: '2012-02-27',
          y: 95
        },
        {
          x: '2012-02-28',
          y: 152
        },
        {
          x: '2012-02-29',
          y: 118
        },
        {
          x: '2012-03-01',
          y: 142
        },
        {
          x: '2012-03-02',
          y: 111
        },
        {
          x: '2012-03-03',
          y: 68
        },
        {
          x: '2012-03-04',
          y: 90
        },
        {
          x: '2012-03-05',
          y: 97
        },
        {
          x: '2012-03-06',
          y: 63
        },
        {
          x: '2012-03-07',
          y: 38
        },
        {
          x: '2012-03-08',
          y: 31
        },
        {
          x: '2012-03-09',
          y: 65
        },
        {
          x: '2012-03-10',
          y: 78
        },
        {
          x: '2012-03-11',
          y: 36
        },
        {
          x: '2012-03-12',
          y: 62
        },
        {
          x: '2012-03-13',
          y: 104
        },
        {
          x: '2012-03-14',
          y: 57
        },
        {
          x: '2012-03-15',
          y: 64
        },
        {
          x: '2012-03-16',
          y: 109
        },
        {
          x: '2012-03-17',
          y: 144
        },
        {
          x: '2012-03-18',
          y: 61
        },
        {
          x: '2012-03-19',
          y: 57
        },
        {
          x: '2012-03-20',
          y: 81
        },
        {
          x: '2012-03-21',
          y: 105
        },
        {
          x: '2012-03-22',
          y: 146
        },
        {
          x: '2012-03-23',
          y: 55
        },
        {
          x: '2012-03-24',
          y: 56
        },
        {
          x: '2012-03-25',
          y: 30
        },
        {
          x: '2012-03-26',
          y: 90
        },
        {
          x: '2012-03-27',
          y: 112
        },
        {
          x: '2012-03-28',
          y: 65
        },
        {
          x: '2012-03-29',
          y: 90
        },
        {
          x: '2012-03-30',
          y: 76
        },
        {
          x: '2012-03-31',
          y: 159
        },
        {
          x: '2012-04-01',
          y: 78
        },
        {
          x: '2012-04-02',
          y: 103
        },
        {
          x: '2012-04-03',
          y: 73
        },
        {
          x: '2012-04-03',
          y: 73
        },
        {
          x: '2012-04-04',
          y: 73
        },
        {
          x: '2012-04-05',
          y: 64
        },
        {
          x: '2012-04-06',
          y: 70
        },
        {
          x: '2012-04-07',
          y: 71
        },
        {
          x: '2012-04-08',
          y: 119
        },
        {
          x: '2012-04-09',
          y: 118
        },
        {
          x: '2012-04-10',
          y: 138
        },
        {
          x: '2012-04-11',
          y: 41
        },
        {
          x: '2012-04-12',
          y: 69
        },
        {
          x: '2012-04-13',
          y: 81
        },
        {
          x: '2012-04-14',
          y: 100
        },
        {
          x: '2012-04-15',
          y: 109
        },
        {
          x: '2012-04-16',
          y: 84
        },
        {
          x: '2012-04-17',
          y: 100
        },
        {
          x: '2012-04-18',
          y: 140
        },
        {
          x: '2012-04-19',
          y: 98
        },
        {
          x: '2012-04-20',
          y: 133
        },
        {
          x: '2012-04-21',
          y: 81
        },
        {
          x: '2012-04-22',
          y: 102
        },
        {
          x: '2012-04-23',
          y: 140
        },
        {
          x: '2012-04-24',
          y: 133
        },
        {
          x: '2012-04-25',
          y: 32
        },
        {
          x: '2012-04-26',
          y: 60
        },
        {
          x: '2012-04-27',
          y: 147
        },
        {
          x: '2012-04-28',
          y: 164
        },
        {
          x: '2012-04-29',
          y: 473
        },
        {
          x: '2012-04-30',
          y: 268
        },
        {
          x: '2012-05-01',
          y: 208
        },
        {
          x: '2012-05-02',
          y: 111
        },
        {
          x: '2012-05-03',
          y: 106
        },
        {
          x: '2012-05-04',
          y: 100
        },
        {
          x: '2012-05-05',
          y: 99
        },
        {
          x: '2012-05-06',
          y: 100
        },
        {
          x: '2012-05-07',
          y: 100
        },
        {
          x: '2012-05-08',
          y: 111
        },
        {
          x: '2012-05-09',
          y: 107
        },
        {
          x: '2012-05-10',
          y: 129
        },
        {
          x: '2012-05-11',
          y: 133
        },
        {
          x: '2012-05-12',
          y: 90
        },
        {
          x: '2012-05-13',
          y: 96
        },
        {
          x: '2012-05-14',
          y: 64
        },
        {
          x: '2012-05-15',
          y: 58
        },
        {
          x: '2012-05-16',
          y: 58
        },
        {
          x: '2012-05-17',
          y: 78
        },
        {
          x: '2012-05-18',
          y: 84
        },
        {
          x: '2012-05-19',
          y: 143
        },
        {
          x: '2012-05-20',
          y: 85
        },
        {
          x: '2012-05-21',
          y: 97
        },
        {
          x: '2012-05-22',
          y: 109
        },
        {
          x: '2012-05-23',
          y: 64
        },
        {
          x: '2012-05-24',
          y: 69
        },
        {
          x: '2012-05-25',
          y: 63
        },
        {
          x: '2012-05-26',
          y: 90
        },
        {
          x: '2012-05-27',
          y: 88
        },
        {
          x: '2012-05-28',
          y: 133
        },
        {
          x: '2012-05-29',
          y: 116
        },
        {
          x: '2012-05-30',
          y: 29
        },
        {
          x: '2012-05-31',
          y: 64
        },
        {
          x: '2012-06-01',
          y: 54
        },
        {
          x: '2012-06-02',
          y: 90
        },
        {
          x: '2012-06-03',
          y: 112
        },
        {
          x: '2012-06-04',
          y: 80
        },
        {
          x: '2012-06-05',
          y: 65
        },
        {
          x: '2012-06-06',
          y: 98
        },
        {
          x: '2012-06-07',
          y: 71
        },
        {
          x: '2012-06-08',
          y: 77
        },
        {
          x: '2012-06-09',
          y: 91
        },
        {
          x: '2012-06-10',
          y: 32
        },
        {
          x: '2012-06-11',
          y: 50
        },
        {
          x: '2012-06-12',
          y: 58
        },
        {
          x: '2012-06-13',
          y: 62
        },
        {
          x: '2012-06-14',
          y: 50
        },
        {
          x: '2012-06-15',
          y: 22
        },
        {
          x: '2012-06-16',
          y: 33
        },
        {
          x: '2012-06-17',
          y: 69
        },
        {
          x: '2012-06-18',
          y: 137
        },
        {
          x: '2012-06-19',
          y: 132
        },
        {
          x: '2012-06-20',
          y: 105
        },
        {
          x: '2012-06-21',
          y: 112
        },
        {
          x: '2012-06-22',
          y: 84
        },
        {
          x: '2012-06-23',
          y: 81
        },
        {
          x: '2012-06-24',
          y: 95
        },
        {
          x: '2012-06-25',
          y: 49
        },
        {
          x: '2012-06-26',
          y: 65
        },
        {
          x: '2012-06-27',
          y: 55
        },
        {
          x: '2012-06-28',
          y: 54
        },
        {
          x: '2012-06-29',
          y: 60
        },
        {
          x: '2012-06-30',
          y: 46
        },
        {
          x: '2012-07-01',
          y: 70
        },
        {
          x: '2012-07-02',
          y: 69
        },
        {
          x: '2012-07-03',
          y: 59
        },
        {
          x: '2012-07-04',
          y: 71
        },
        {
          x: '2012-07-05',
          y: 70
        },
        {
          x: '2012-07-06',
          y: 59
        },
        {
          x: '2012-07-07',
          y: 86
        },
        {
          x: '2012-07-08',
          y: 84
        },
        {
          x: '2012-07-09',
          y: 64
        },
        {
          x: '2012-07-10',
          y: 50
        },
        {
          x: '2012-07-11',
          y: 44
        },
        {
          x: '2012-07-12',
          y: 46
        },
        {
          x: '2012-07-13',
          y: 31
        },
        {
          x: '2012-07-14',
          y: 48
        },
        {
          x: '2012-07-15',
          y: 53
        },
        {
          x: '2012-07-16',
          y: 70
        },
        {
          x: '2012-07-17',
          y: 78
        },
        {
          x: '2012-07-18',
          y: 71
        },
        {
          x: '2012-07-19',
          y: 82
        },
        {
          x: '2012-07-20',
          y: 111
        },
        {
          x: '2012-07-21',
          y: 131
        },
        {
          x: '2012-07-22',
          y: 15
        },
        {
          x: '2012-07-24',
          y: 60
        },
        {
          x: '2012-07-25',
          y: 72
        },
        {
          x: '2012-07-26',
          y: 55
        },
        {
          x: '2012-07-26',
          y: 55
        },
        {
          x: '2012-07-27',
          y: 50
        },
        {
          x: '2012-07-28',
          y: 56
        },
        {
          x: '2012-07-29',
          y: 57
        },
        {
          x: '2012-07-30',
          y: 30
        },
        {
          x: '2012-07-31',
          y: 28
        },
        {
          x: '2012-08-01',
          y: 20
        },
        {
          x: '2012-08-02',
          y: 17
        },
        {
          x: '2012-08-03',
          y: 53
        },
        {
          x: '2012-08-04',
          y: 40
        },
        {
          x: '2012-08-05',
          y: 48
        },
        {
          x: '2012-08-06',
          y: 60
        },
        {
          x: '2012-08-07',
          y: 59
        },
        {
          x: '2012-08-08',
          y: 68
        },
        {
          x: '2012-08-09',
          y: 43
        },
        {
          x: '2012-08-10',
          y: 72
        },
        {
          x: '2012-08-11',
          y: 80
        },
        {
          x: '2012-08-12',
          y: 41
        },
        {
          x: '2012-08-13',
          y: 36
        },
        {
          x: '2012-08-14',
          y: 62
        },
        {
          x: '2012-08-15',
          y: 60
        },
        {
          x: '2012-08-16',
          y: 68
        },
        {
          x: '2012-08-17',
          y: 83
        },
        {
          x: '2012-08-18',
          y: 110
        },
        {
          x: '2012-08-19',
          y: 84
        },
        {
          x: '2012-08-20',
          y: 92
        },
        {
          x: '2012-08-21',
          y: 25
        },
        {
          x: '2012-08-22',
          y: 40
        },
        {
          x: '2012-08-23',
          y: 74
        },
        {
          x: '2012-08-24',
          y: 94
        },
        {
          x: '2012-08-25',
          y: 92
        },
        {
          x: '2012-08-26',
          y: 117
        },
        {
          x: '2012-08-27',
          y: 100
        },
        {
          x: '2012-08-28',
          y: 59
        },
        {
          x: '2012-08-29',
          y: 84
        },
        {
          x: '2012-08-30',
          y: 135
        },
        {
          x: '2012-08-31',
          y: 150
        },
        {
          x: '2012-09-01',
          y: 128
        },
        {
          x: '2012-09-02',
          y: 52
        },
        {
          x: '2012-09-03',
          y: 15
        },
        {
          x: '2012-09-04',
          y: 22
        },
        {
          x: '2012-09-05',
          y: 50
        },
        {
          x: '2012-09-06',
          y: 70
        },
        {
          x: '2012-09-07',
          y: 77
        },
        {
          x: '2012-09-08',
          y: 40
        },
        {
          x: '2012-09-09',
          y: 79
        },
        {
          x: '2012-09-10',
          y: 96
        },
        {
          x: '2012-09-11',
          y: 93
        },
        {
          x: '2012-09-12',
          y: 44
        },
        {
          x: '2012-09-13',
          y: 28
        },
        {
          x: '2012-09-14',
          y: 31
        },
        {
          x: '2012-09-15',
          y: 50
        },
        {
          x: '2012-09-16',
          y: 65
        },
        {
          x: '2012-09-17',
          y: 63
        },
        {
          x: '2012-09-18',
          y: 61
        },
        {
          x: '2012-09-19',
          y: 56
        },
        {
          x: '2012-09-21',
          y: 128
        },
        {
          x: '2012-09-22',
          y: 93
        },
        {
          x: '2012-09-23',
          y: 85
        },
        {
          x: '2012-09-24',
          y: 74
        },
        {
          x: '2012-09-25',
          y: 78
        },
        {
          x: '2012-09-26',
          y: 26
        },
        {
          x: '2012-09-27',
          y: 65
        },
        {
          x: '2012-09-28',
          y: 15
        },
        {
          x: '2012-09-29',
          y: 24
        },
        {
          x: '2012-09-30',
          y: 38
        },
        {
          x: '2012-10-01',
          y: 52
        },
        {
          x: '2012-10-02',
          y: 78
        },
        {
          x: '2012-10-03',
          y: 108
        },
        {
          x: '2012-10-04',
          y: 28
        },
        {
          x: '2012-10-05',
          y: 41
        },
        {
          x: '2012-10-06',
          y: 74
        },
        {
          x: '2012-10-07',
          y: 83
        },
        {
          x: '2012-10-08',
          y: 123
        },
        {
          x: '2012-10-09',
          y: 140
        },
        {
          x: '2012-10-10',
          y: 18
        },
        {
          x: '2012-10-11',
          y: 73
        },
        {
          x: '2012-10-12',
          y: 121
        },
        {
          x: '2012-10-13',
          y: 97
        },
        {
          x: '2012-10-14',
          y: 40
        },
        {
          x: '2012-10-15',
          y: 83
        },
        {
          x: '2012-10-16',
          y: 78
        },
        {
          x: '2012-10-17',
          y: 23
        },
        {
          x: '2012-10-18',
          y: 65
        },
        {
          x: '2012-10-19',
          y: 79
        },
        {
          x: '2012-10-20',
          y: 139
        },
        {
          x: '2012-10-21',
          y: 81
        },
        {
          x: '2012-10-22',
          y: 26
        },
        {
          x: '2012-10-23',
          y: 54
        },
        {
          x: '2012-10-24',
          y: 89
        },
        {
          x: '2012-10-25',
          y: 90
        },
        {
          x: '2012-10-26',
          y: 163
        },
        {
          x: '2012-10-27',
          y: 154
        },
        {
          x: '2012-10-28',
          y: 22
        },
        {
          x: '2012-10-29',
          y: 59
        },
        {
          x: '2012-10-30',
          y: 36
        },
        {
          x: '2012-10-31',
          y: 51
        },
        {
          x: '2012-11-01',
          y: 67
        },
        {
          x: '2012-11-02',
          y: 103
        },
        {
          x: '2012-11-03',
          y: 135
        },
        {
          x: '2012-11-04',
          y: 20
        },
        {
          x: '2012-11-05',
          y: 16
        },
        {
          x: '2012-11-06',
          y: 48
        },
        {
          x: '2012-11-07',
          y: 80
        },
        {
          x: '2012-11-08',
          y: 62
        },
        {
          x: '2012-11-09',
          y: 93
        },
        {
          x: '2012-11-10',
          y: 82
        },
        {
          x: '2012-11-11',
          y: 17
        },
        {
          x: '2012-11-12',
          y: 27
        },
        {
          x: '2012-11-13',
          y: 30
        },
        {
          x: '2012-11-14',
          y: 26
        },
        {
          x: '2012-11-15',
          y: 71
        },
        {
          x: '2012-11-16',
          y: 92
        },
        {
          x: '2012-11-17',
          y: 47
        },
        {
          x: '2012-11-18',
          y: 96
        },
        {
          x: '2012-11-19',
          y: 55
        },
        {
          x: '2012-11-20',
          y: 74
        },
        {
          x: '2012-11-21',
          y: 123
        },
        {
          x: '2012-11-22',
          y: 156
        },
        {
          x: '2012-11-23',
          y: 22
        },
        {
          x: '2012-11-24',
          y: 80
        },
        {
          x: '2012-11-25',
          y: 133
        },
        {
          x: '2012-11-26',
          y: 44
        },
        {
          x: '2012-11-27',
          y: 105
        },
        {
          x: '2012-11-28',
          y: 151
        },
        {
          x: '2012-11-29',
          y: 54
        },
        {
          x: '2012-12-01',
          y: 50
        },
        {
          x: '2012-12-02',
          y: 96
        },
        {
          x: '2012-12-03',
          y: 123
        },
        {
          x: '2012-12-04',
          y: 50
        },
        {
          x: '2012-12-05',
          y: 64
        },
        {
          x: '2012-12-06',
          y: 50
        },
        {
          x: '2012-12-07',
          y: 73
        },
        {
          x: '2012-12-08',
          y: 53
        },
        {
          x: '2012-12-09',
          y: 38
        },
        {
          x: '2012-12-10',
          y: 53
        },
        {
          x: '2012-12-11',
          y: 86
        },
        {
          x: '2012-12-12',
          y: 103
        },
        {
          x: '2012-12-13',
          y: 130
        },
        {
          x: '2012-12-14',
          y: 107
        },
        {
          x: '2012-12-15',
          y: 114
        },
        {
          x: '2012-12-16',
          y: 108
        },
        {
          x: '2012-12-17',
          y: 45
        },
        {
          x: '2012-12-18',
          y: 22
        },
        {
          x: '2012-12-19',
          y: 72
        },
        {
          x: '2012-12-20',
          y: 121
        },
        {
          x: '2012-12-21',
          y: 120
        },
        {
          x: '2012-12-22',
          y: 24
        },
        {
          x: '2012-12-23',
          y: 36
        },
        {
          x: '2012-12-24',
          y: 53
        },
        {
          x: '2012-12-25',
          y: 58
        },
        {
          x: '2012-12-26',
          y: 67
        },
        {
          x: '2012-12-28',
          y: 137
        },
        {
          x: '2012-12-29',
          y: 94
        },
        {
          x: '2012-12-30',
          y: 38
        },
        {
          x: '2012-12-31',
          y: 57
        },
        {
          x: '2013-01-01',
          y: 71
        },
        {
          x: '2013-01-02',
          y: 27
        },
        {
          x: '2013-01-03',
          y: 35
        },
        {
          x: '2013-01-04',
          y: 57
        },
        {
          x: '2013-01-05',
          y: 79
        },
        {
          x: '2013-01-06',
          y: 58
        },
        {
          x: '2013-01-07',
          y: 105
        },
        {
          x: '2013-01-08',
          y: 124
        },
        {
          x: '2013-01-09',
          y: 32
        },
        {
          x: '2013-01-10',
          y: 87
        },
        {
          x: '2013-01-11',
          y: 232
        },
        {
          x: '2013-01-12',
          y: 174
        },
        {
          x: '2013-01-13',
          y: 498
        },
        {
          x: '2013-01-14',
          y: 184
        },
        {
          x: '2014-01-01',
          y: 85
        },
        {
          x: '2014-01-02',
          y: 158
        },
        {
          x: '2014-01-03',
          y: 74
        },
        {
          x: '2014-01-04',
          y: 165
        },
        {
          x: '2014-01-05',
          y: 113
        },
        {
          x: '2014-01-06',
          y: 190
        },
        {
          x: '2014-01-07',
          y: 122
        },
        {
          x: '2014-01-10',
          y: 95
        },
        {
          x: '2014-01-11',
          y: 159
        },
        {
          x: '2014-01-12',
          y: 52
        },
        {
          x: '2014-01-13',
          y: 117
        },
        {
          x: '2014-01-14',
          y: 113
        },
        {
          x: '2014-01-15',
          y: 180
        },
        {
          x: '2014-01-16',
          y: 403
        },
        {
          x: '2014-01-17',
          y: 209
        },
        {
          x: '2014-01-18',
          y: 113
        },
        {
          x: '2014-01-19',
          y: 149
        },
        {
          x: '2014-01-21',
          y: 68
        },
        {
          x: '2014-01-22',
          y: 162
        },
        {
          x: '2014-01-23',
          y: 276
        },
        {
          x: '2014-01-24',
          y: 195
        },
        {
          x: '2014-01-26',
          y: 77
        },
        {
          x: '2014-01-27',
          y: 114
        },
        {
          x: '2014-01-28',
          y: 67
        },
        {
          x: '2014-01-29',
          y: 165
        },
        {
          x: '2014-01-30',
          y: 93
        },
        {
          x: '2014-01-31',
          y: 188
        },
        {
          x: '2014-02-01',
          y: 178
        },
        {
          x: '2014-02-02',
          y: 85
        },
        {
          x: '2014-02-05',
          y: 119
        },
        {
          x: '2014-02-06',
          y: 158
        },
        {
          x: '2014-02-07',
          y: 124
        },
        {
          x: '2014-02-08',
          y: 84
        },
        {
          x: '2014-02-10',
          y: 53
        },
        {
          x: '2014-02-11',
          y: 142
        },
        {
          x: '2014-02-12',
          y: 150
        },
        {
          x: '2014-02-13',
          y: 242
        },
        {
          x: '2014-02-14',
          y: 329
        },
        {
          x: '2014-02-15',
          y: 429
        },
        {
          x: '2014-02-16',
          y: 348
        },
        {
          x: '2014-02-17',
          y: 118
        },
        {
          x: '2014-02-18',
          y: 98
        },
        {
          x: '2014-02-19',
          y: 92
        },
        {
          x: '2014-02-20',
          y: 270
        },
        {
          x: '2014-02-21',
          y: 311
        },
        {
          x: '2014-02-22',
          y: 311
        },
        {
          x: '2014-02-23',
          y: 255
        },
        {
          x: '2014-02-24',
          y: 313
        },
        {
          x: '2014-02-25',
          y: 404
        },
        {
          x: '2014-02-28',
          y: 113
        },
        {
          x: '2014-03-01',
          y: 68
        },
        {
          x: '2014-03-02',
          y: 189
        },
        {
          x: '2014-03-03',
          y: 268
        },
        {
          x: '2014-03-04',
          y: 67
        },
        {
          x: '2014-03-07',
          y: 70
        },
        {
          x: '2014-03-08',
          y: 179
        },
        {
          x: '2014-03-09',
          y: 127
        },
        {
          x: '2014-03-10',
          y: 110
        },
        {
          x: '2014-03-11',
          y: 195
        },
        {
          x: '2014-03-13',
          y: 69
        },
        {
          x: '2014-03-14',
          y: 64
        },
        {
          x: '2014-03-15',
          y: 133
        },
        {
          x: '2014-03-16',
          y: 145
        },
        {
          x: '2014-03-17',
          y: 142
        },
        {
          x: '2014-03-18',
          y: 85
        },
        {
          x: '2014-03-19',
          y: 73
        },
        {
          x: '2014-03-21',
          y: 62
        },
        {
          x: '2014-03-22',
          y: 86
        },
        {
          x: '2014-03-23',
          y: 186
        },
        {
          x: '2014-03-24',
          y: 271
        },
        {
          x: '2014-03-25',
          y: 255
        },
        {
          x: '2014-03-26',
          y: 331
        },
        {
          x: '2014-03-27',
          y: 285
        },
        {
          x: '2014-03-28',
          y: 169
        },
        {
          x: '2014-03-29',
          y: 63
        },
        {
          x: '2014-03-30',
          y: 77
        },
        {
          x: '2014-03-31',
          y: 183
        },
        {
          x: '2014-04-01',
          y: 147
        },
        {
          x: '2014-04-02',
          y: 133
        },
        {
          x: '2014-04-03',
          y: 66
        },
        {
          x: '2014-04-04',
          y: 91
        },
        {
          x: '2014-04-05',
          y: 68
        },
        {
          x: '2014-04-06',
          y: 98
        },
        {
          x: '2014-04-07',
          y: 135
        },
        {
          x: '2014-04-08',
          y: 223
        },
        {
          x: '2014-04-09',
          y: 156
        },
        {
          x: '2014-04-10',
          y: 246
        },
        {
          x: '2014-04-11',
          y: 83
        },
        {
          x: '2014-04-12',
          y: 133
        },
        {
          x: '2014-04-13',
          y: 212
        },
        {
          x: '2014-04-14',
          y: 270
        },
        {
          x: '2014-04-15',
          y: 109
        },
        {
          x: '2014-04-16',
          y: 90
        },
        {
          x: '2014-04-17',
          y: 124
        },
        {
          x: '2014-04-18',
          y: 182
        },
        {
          x: '2014-04-19',
          y: 84
        },
        {
          x: '2014-04-20',
          y: 84
        },
        {
          x: '2014-04-21',
          y: 73
        },
        {
          x: '2014-04-22',
          y: 85
        },
        {
          x: '2014-04-23',
          y: 156
        },
        {
          x: '2014-04-24',
          y: 156
        },
        {
          x: '2014-04-25',
          y: 163
        },
        {
          x: '2014-04-26',
          y: 69
        },
        {
          x: '2014-04-27',
          y: 74
        },
        {
          x: '2014-04-28',
          y: 83
        },
        {
          x: '2014-04-29',
          y: 122
        },
        {
          x: '2014-04-30',
          y: 139
        },
        {
          x: '2014-05-01',
          y: 156
        },
        {
          x: '2014-05-03',
          y: 93
        },
        {
          x: '2014-05-04',
          y: 57
        },
        {
          x: '2014-05-05',
          y: 54
        },
        {
          x: '2014-05-06',
          y: 105
        },
        {
          x: '2014-05-07',
          y: 82
        },
        {
          x: '2014-05-08',
          y: 104
        },
        {
          x: '2014-05-09',
          y: 84
        },
        {
          x: '2014-05-10',
          y: 69
        },
        {
          x: '2014-05-12',
          y: 74
        },
        {
          x: '2014-05-13',
          y: 86
        },
        {
          x: '2014-05-14',
          y: 59
        },
        {
          x: '2014-05-15',
          y: 122
        },
        {
          x: '2014-05-16',
          y: 92
        },
        {
          x: '2014-05-17',
          y: 124
        },
        {
          x: '2014-05-18',
          y: 171
        },
        {
          x: '2014-05-19',
          y: 146
        },
        {
          x: '2014-05-20',
          y: 113
        },
        {
          x: '2014-05-21',
          y: 170
        },
        {
          x: '2014-05-22',
          y: 183
        },
        {
          x: '2014-05-23',
          y: 140
        },
        {
          x: '2014-05-24',
          y: 104
        },
        {
          x: '2014-05-25',
          y: 91
        },
        {
          x: '2014-05-26',
          y: 77
        },
        {
          x: '2014-05-27',
          y: 107
        },
        {
          x: '2014-05-28',
          y: 121
        },
        {
          x: '2014-05-29',
          y: 120
        },
        {
          x: '2014-05-30',
          y: 192
        },
        {
          x: '2014-05-31',
          y: 177
        },
        {
          x: '2014-06-01',
          y: 130
        },
        {
          x: '2014-06-02',
          y: 90
        },
        {
          x: '2014-06-03',
          y: 117
        },
        {
          x: '2014-06-04',
          y: 124
        },
        {
          x: '2014-06-05',
          y: 157
        },
        {
          x: '2014-06-06',
          y: 103
        },
        {
          x: '2014-06-07',
          y: 51
        },
        {
          x: '2014-06-08',
          y: 70
        },
        {
          x: '2014-06-09',
          y: 87
        },
        {
          x: '2014-06-10',
          y: 95
        },
        {
          x: '2014-06-11',
          y: 74
        },
        {
          x: '2014-06-12',
          y: 90
        },
        {
          x: '2014-06-13',
          y: 116
        },
        {
          x: '2014-06-14',
          y: 165
        },
        {
          x: '2014-06-15',
          y: 178
        },
        {
          x: '2014-06-16',
          y: 178
        },
        {
          x: '2014-06-17',
          y: 104
        },
        {
          x: '2014-06-18',
          y: 116
        },
        {
          x: '2014-06-19',
          y: 116
        },
        {
          x: '2014-06-20',
          y: 84
        },
        {
          x: '2014-06-21',
          y: 96
        },
        {
          x: '2014-06-22',
          y: 91
        },
        {
          x: '2014-06-23',
          y: 115
        },
        {
          x: '2014-06-24',
          y: 161
        },
        {
          x: '2014-06-25',
          y: 138
        },
        {
          x: '2014-06-26',
          y: 163
        },
        {
          x: '2014-06-27',
          y: 68
        },
        {
          x: '2014-06-28',
          y: 77
        },
        {
          x: '2014-06-29',
          y: 161
        },
        {
          x: '2014-06-30',
          y: 185
        },
        {
          x: '2014-07-01',
          y: 172
        },
        {
          x: '2014-07-02',
          y: 80
        },
        {
          x: '2014-07-03',
          y: 248
        },
        {
          x: '2014-07-04',
          y: 237
        },
        {
          x: '2014-07-05',
          y: 165
        },
        {
          x: '2014-07-06',
          y: 256
        },
        {
          x: '2014-07-07',
          y: 216
        },
        {
          x: '2014-07-08',
          y: 134
        },
        {
          x: '2014-07-09',
          y: 63
        },
        {
          x: '2014-07-10',
          y: 114
        },
        {
          x: '2014-07-11',
          y: 77
        },
        {
          x: '2014-07-12',
          y: 80
        },
        {
          x: '2014-07-13',
          y: 64
        },
        {
          x: '2014-07-14',
          y: 156
        },
        {
          x: '2014-07-15',
          y: 140
        },
        {
          x: '2014-07-16',
          y: 133
        },
        {
          x: '2014-07-17',
          y: 186
        },
        {
          x: '2014-07-18',
          y: 182
        },
        {
          x: '2014-07-19',
          y: 106
        },
        {
          x: '2014-07-20',
          y: 119
        },
        {
          x: '2014-07-21',
          y: 68
        },
        {
          x: '2014-07-22',
          y: 54
        },
        {
          x: '2014-07-23',
          y: 82
        },
        {
          x: '2014-07-24',
          y: 90
        },
        {
          x: '2014-07-25',
          y: 134
        },
        {
          x: '2014-07-26',
          y: 188
        },
        {
          x: '2014-07-27',
          y: 194
        },
        {
          x: '2014-07-28',
          y: 159
        },
        {
          x: '2014-07-29',
          y: 159
        },
        {
          x: '2014-07-30',
          y: 169
        },
        {
          x: '2014-07-31',
          y: 244
        },
        {
          x: '2014-08-01',
          y: 199
        },
        {
          x: '2014-08-02',
          y: 163
        },
        {
          x: '2014-08-03',
          y: 149
        },
        {
          x: '2014-08-05',
          y: 80
        },
        {
          x: '2014-08-06',
          y: 67
        },
        {
          x: '2014-08-07',
          y: 162
        },
        {
          x: '2014-08-08',
          y: 140
        },
        {
          x: '2014-08-09',
          y: 143
        },
        {
          x: '2014-08-10',
          y: 125
        },
        {
          x: '2014-08-11',
          y: 76
        },
        {
          x: '2014-08-12',
          y: 119
        },
        {
          x: '2014-08-13',
          y: 70
        },
        {
          x: '2014-08-14',
          y: 104
        },
        {
          x: '2014-08-15',
          y: 109
        },
        {
          x: '2014-08-16',
          y: 159
        },
        {
          x: '2014-08-17',
          y: 124
        },
        {
          x: '2014-08-18',
          y: 135
        },
        {
          x: '2014-08-19',
          y: 150
        },
        {
          x: '2014-08-20',
          y: 164
        },
        {
          x: '2014-08-21',
          y: 169
        },
        {
          x: '2014-08-22',
          y: 83
        },
        {
          x: '2014-08-23',
          y: 155
        },
        {
          x: '2014-08-24',
          y: 75
        },
        {
          x: '2014-08-25',
          y: 59
        },
        {
          x: '2014-08-26',
          y: 78
        },
        {
          x: '2014-08-27',
          y: 136
        },
        {
          x: '2014-08-28',
          y: 103
        },
        {
          x: '2014-08-29',
          y: 104
        },
        {
          x: '2014-08-30',
          y: 176
        },
        {
          x: '2014-08-31',
          y: 89
        },
        {
          x: '2014-09-01',
          y: 127
        },
        {
          x: '2014-09-03',
          y: 54
        },
        {
          x: '2014-09-04',
          y: 100
        },
        {
          x: '2014-09-05',
          y: 140
        },
        {
          x: '2014-09-06',
          y: 186
        },
        {
          x: '2014-09-07',
          y: 200
        },
        {
          x: '2014-09-08',
          y: 61
        },
        {
          x: '2014-09-09',
          y: 109
        },
        {
          x: '2014-09-10',
          y: 111
        },
        {
          x: '2014-09-11',
          y: 114
        },
        {
          x: '2014-09-12',
          y: 97
        },
        {
          x: '2014-09-13',
          y: 94
        },
        {
          x: '2014-09-14',
          y: 66
        },
        {
          x: '2014-09-15',
          y: 54
        },
        {
          x: '2014-09-16',
          y: 87
        },
        {
          x: '2014-09-17',
          y: 80
        },
        {
          x: '2014-09-18',
          y: 84
        },
        {
          x: '2014-09-19',
          y: 117
        },
        {
          x: '2014-09-20',
          y: 168
        },
        {
          x: '2014-09-21',
          y: 129
        },
        {
          x: '2014-09-22',
          y: 127
        },
        {
          x: '2014-09-23',
          y: 64
        },
        {
          x: '2014-09-24',
          y: 60
        },
        {
          x: '2014-09-25',
          y: 144
        },
        {
          x: '2014-09-26',
          y: 170
        },
        {
          x: '2014-09-27',
          y: 58
        },
        {
          x: '2014-09-28',
          y: 87
        },
        {
          x: '2014-09-29',
          y: 70
        },
        {
          x: '2014-09-30',
          y: 53
        },
        {
          x: '2014-10-01',
          y: 92
        },
        {
          x: '2014-10-02',
          y: 78
        },
        {
          x: '2014-10-03',
          y: 123
        },
        {
          x: '2014-10-04',
          y: 95
        },
        {
          x: '2014-10-05',
          y: 54
        },
        {
          x: '2014-10-06',
          y: 68
        },
        {
          x: '2014-10-07',
          y: 200
        },
        {
          x: '2014-10-08',
          y: 314
        },
        {
          x: '2014-10-09',
          y: 379
        },
        {
          x: '2014-10-10',
          y: 346
        },
        {
          x: '2014-10-11',
          y: 233
        },
        {
          x: '2014-10-14',
          y: 80
        },
        {
          x: '2014-10-15',
          y: 73
        },
        {
          x: '2014-10-16',
          y: 76
        },
        {
          x: '2014-10-17',
          y: 132
        },
        {
          x: '2014-10-18',
          y: 211
        },
        {
          x: '2014-10-19',
          y: 289
        },
        {
          x: '2014-10-20',
          y: 250
        },
        {
          x: '2014-10-21',
          y: 82
        },
        {
          x: '2014-10-22',
          y: 99
        },
        {
          x: '2014-10-23',
          y: 163
        },
        {
          x: '2014-10-24',
          y: 267
        },
        {
          x: '2014-10-25',
          y: 353
        },
        {
          x: '2014-10-26',
          y: 78
        },
        {
          x: '2014-10-27',
          y: 72
        },
        {
          x: '2014-10-28',
          y: 88
        },
        {
          x: '2014-10-29',
          y: 140
        },
        {
          x: '2014-10-30',
          y: 206
        },
        {
          x: '2014-10-31',
          y: 204
        },
        {
          x: '2014-11-01',
          y: 65
        },
        {
          x: '2014-11-03',
          y: 59
        },
        {
          x: '2014-11-04',
          y: 150
        },
        {
          x: '2014-11-05',
          y: 79
        },
        {
          x: '2014-11-07',
          y: 63
        },
        {
          x: '2014-11-08',
          y: 93
        },
        {
          x: '2014-11-09',
          y: 80
        },
        {
          x: '2014-11-10',
          y: 95
        },
        {
          x: '2014-11-11',
          y: 59
        },
        {
          x: '2014-11-13',
          y: 65
        },
        {
          x: '2014-11-14',
          y: 77
        },
        {
          x: '2014-11-15',
          y: 143
        },
        {
          x: '2014-11-16',
          y: 98
        },
        {
          x: '2014-11-17',
          y: 64
        },
        {
          x: '2014-11-18',
          y: 93
        },
        {
          x: '2014-11-19',
          y: 282
        },
        {
          x: '2014-11-23',
          y: 155
        },
        {
          x: '2014-11-24',
          y: 94
        },
        {
          x: '2014-11-25',
          y: 196
        },
        {
          x: '2014-11-26',
          y: 293
        },
        {
          x: '2014-11-27',
          y: 83
        },
        {
          x: '2014-11-28',
          y: 114
        },
        {
          x: '2014-11-29',
          y: 276
        },
        {
          x: '2014-12-01',
          y: 54
        },
        {
          x: '2014-12-02',
          y: 65
        },
        {
          x: '2014-12-03',
          y: 51
        },
        {
          x: '2014-12-05',
          y: 62
        },
        {
          x: '2014-12-06',
          y: 89
        },
        {
          x: '2014-12-07',
          y: 65
        },
        {
          x: '2014-12-08',
          y: 82
        },
        {
          x: '2014-12-09',
          y: 276
        },
        {
          x: '2014-12-10',
          y: 153
        },
        {
          x: '2014-12-11',
          y: 52
        },
        {
          x: '2014-12-13',
          y: 69
        },
        {
          x: '2014-12-14',
          y: 113
        },
        {
          x: '2014-12-15',
          y: 82
        },
        {
          x: '2014-12-17',
          y: 99
        },
        {
          x: '2014-12-19',
          y: 53
        },
        {
          x: '2014-12-22',
          y: 103
        },
        {
          x: '2014-12-23',
          y: 100
        },
        {
          x: '2014-12-25',
          y: 73
        },
        {
          x: '2014-12-26',
          y: 155
        },
        {
          x: '2014-12-27',
          y: 243
        },
        {
          x: '2014-12-28',
          y: 155
        },
        {
          x: '2014-12-29',
          y: 125
        },
        {
          x: '2014-12-30',
          y: 65
        },
        {
          x: '2015-01-01',
          y: 65
        },
        {
          x: '2015-01-02',
          y: 79
        },
        {
          x: '2015-01-03',
          y: 200
        },
        {
          x: '2015-01-04',
          y: 226
        },
        {
          x: '2015-01-05',
          y: 122
        },
        {
          x: '2015-01-06',
          y: 60
        },
        {
          x: '2015-01-07',
          y: 85
        },
        {
          x: '2015-01-08',
          y: 190
        },
        {
          x: '2015-01-09',
          y: 105
        },
        {
          x: '2015-01-10',
          y: 208
        },
        {
          x: '2015-01-11',
          y: 59
        },
        {
          x: '2015-01-12',
          y: 160
        },
        {
          x: '2015-01-13',
          y: 211
        },
        {
          x: '2015-01-14',
          y: 265
        },
        {
          x: '2015-01-15',
          y: 386
        },
        {
          x: '2015-01-16',
          y: 118
        },
        {
          x: '2015-01-17',
          y: 89
        },
        {
          x: '2015-01-18',
          y: 94
        },
        {
          x: '2015-01-19',
          y: 77
        },
        {
          x: '2015-01-20',
          y: 113
        },
        {
          x: '2015-01-22',
          y: 143
        },
        {
          x: '2015-01-23',
          y: 257
        },
        {
          x: '2015-01-24',
          y: 117
        },
        {
          x: '2015-01-25',
          y: 185
        },
        {
          x: '2015-01-26',
          y: 119
        },
        {
          x: '2015-01-28',
          y: 65
        },
        {
          x: '2015-01-29',
          y: 87
        },
        {
          x: '2015-01-31',
          y: 60
        },
        {
          x: '2015-02-01',
          y: 108
        },
        {
          x: '2015-02-02',
          y: 188
        },
        {
          x: '2015-02-03',
          y: 143
        },
        {
          x: '2015-02-05',
          y: 62
        },
        {
          x: '2015-02-06',
          y: 100
        },
        {
          x: '2015-02-09',
          y: 152
        },
        {
          x: '2015-02-10',
          y: 166
        },
        {
          x: '2015-02-11',
          y: 55
        },
        {
          x: '2015-02-12',
          y: 59
        },
        {
          x: '2015-02-13',
          y: 175
        },
        {
          x: '2015-02-14',
          y: 293
        },
        {
          x: '2015-02-15',
          y: 326
        },
        {
          x: '2015-02-16',
          y: 153
        },
        {
          x: '2015-02-18',
          y: 73
        },
        {
          x: '2015-02-19',
          y: 267
        },
        {
          x: '2015-02-20',
          y: 183
        },
        {
          x: '2015-02-21',
          y: 394
        },
        {
          x: '2015-02-22',
          y: 158
        },
        {
          x: '2015-02-23',
          y: 86
        },
        {
          x: '2015-02-24',
          y: 207
        }
      ]
    }
  ]
};

export { spec };
