/* eslint-disable max-len */
export const capcutEnData: any[] = [
  {
    text: 'Because Japan is one of the most import dependent countries in the world, importing over 90% of its energy and over 60% of its food, a weak yen means inflation has returned to Japan for the first time in decades. ',
    fieldInfo: ['import ratio', 'import type']
  },
  {
    text: ' For context, in the post war years, Japan experienced many decades of rapid economic growth in a period dubbed the Japanese Miracle. From 1955 to 1990, Japanese growth averaged 6.8% per year, and GDP multiplied eight times, with growth falling below 3% only once during the 1974 oil shock.',
    fieldInfo: ['year', 'gdp growth rate']
  },
  {
    text: `Anyway, this anxiety subsided in the 90s when Japan experienced an enormous financial crisis after a rapid appreciation in Japanese stock and real estate prices during the 80s. In 1990, the bubble burst and continue to burst for a while. In the decade after 1990, residential house prices fell by more than 50%, commercial property prices fell by something like 85%. And Japan's main stock index, the Nike 2,2,5 fell by about 75%. Japan's economy never really recovered and growth and inflation both remained close to zero until very recently.`,
    fieldInfo: ['rate value', 'rate type']
  },
  {
    text: `From 2016 until late last year. The Bank of Japan even began what's called yield curve control, which essentially involved buying up enough debt to guarantee that government borrowing costs wouldn't go above a certain level. Japan's ultra loose monetary policy came under pressure in 2022 when inflation started rising across the world. Usually, central banks raise interest rates, but the bank of Japan decided not to, both because inflation was relatively low in Japan, but also because thanks to its enormous debt burden, even a slight raise in interest rates would translate to a massive increase in debt servicing costs, especially for the Japanese government. Unfortunately, things have become more difficult as other central banks have raised rates, making their currencies relatively more attractive and sparking a decline in the yen. In the last year, the yen has fallen from about 130 to the dollar to a 34 year low of 160 to the dollar on Monday. Now the speed and severity of this decline presents a difficult dilemma for the bank of Japan because thanks to Japan's reliance on imports, it sparked significant inflation in essential items like food and energy. But they still don't want to raise rates for the reasons we've just mentioned earlier. This is why on Monday evening, instead of raising rates, the bank of Japan used billions of dollars worth of Japan's foreign exchange reserves to buy up the yen on the international market, artificially inflating its value. While this seems to have worked in the short term, as of Tuesday morning, the yen is now trading at nearer 155 to the dollar. It's both expensive and fundamentally unsustainable. Even if the bank of Japan has some of the largest foreign exchange reserves in the world. All in all, assuming the bank of Japan won't engage in significant rate hikes, this means that the yen is very much dependent on what goes on in the rest of the world. If inflation comes down and other central banks start cutting rates, then this will reduce some of the pressure on the yen. But if inflation turns out to be stickier than we'd like, which seems to be the case, then the divergence between the bank of Japan and other central banks will persist, which means more downward pressure on the yen. If this happens, then the bank of Japan won't be able to stave off the yen's decline with exchange reserves forever. And eventually, they'll have to choose a horn of their uncomfortable dilemma, either to just accept the yen's decline and all the inflation related political turmoil that comes with it all, raise rates and just hope that the world's most debt burdened economy can somehow deal with it.`,
    fieldInfo: ['date', 'yen to dollar']
  },
  {
    text: `Blanket is all over the news. Linkage is now more valuable than Zomato. Linkage reported over 2,300 for rupees and revenue. And then now speak about Zomato, they speak about blinking bigger than tomato right now with the valuation of roughly $13 million and a market share of 46%, it has disrupted India's 23,000 crore quick commerce industry, a company that Zomato acquired in 2022 to enter into quick commerce, but now has become more valuable, the Zomato's own food delivery business. In fact, the company 3 x its revenue from 800 crores to 23 crores and is expected to break even in the first quarter of Fi 2025.`,
    fieldInfo: ['company', 'marker share', 'valuation']
  },
  {
    text: `By the way, this is going to be detailed, so feel free to pause the video wherever you feel confused. First of all, let's take a realistic average order value of 600 rupees, which is very close to what most people usually order on blink it. If you look at the revenue side, which is the money that bind it earns here for themselves from each order is divided into three sources. The first one is warehousing services and marketplace commissions. This is basically the amount that suppliers are paying to blanket for showing and selling their products. And see on every order of 600 rupees, 11 to 13% is coming from suppliers, which is roughly 72 rupees.`,
    fieldInfo: ['revenue source', 'revenue value', 'revenue ratio']
  },
  {
    text: `Now the second part of the income of this order is the ads that come companies show on blanket. This is the price that brands pay to show their products above other products as you scroll the app. For example, brew might pay to show its coffee first when someone searches for a keyword like coffee, it's roughly 2.3 to 3.5%. In our case, let's take 3.5% and it will come down to 21 rupees.`,
    fieldInfo: ['keyword', 'ad rate', 'cost']
  },
  {
    text: `The next is customer fees, which includes your delivery fees, handling fees for packaging and delivering the food to your doorstep, and even additional fees like fees they charge you for having a small cut. This percentage comes at around three portion of the average order value and is roughly 18 rupees in our case. By the way, there are also other levers like membership plans or free delivery plans that these plan platforms try to sell you often like Zepto does it with their offering of zeptopass. But if we don't over complicate and dive much deeper into this, we see that in a nutshell, on an average order of 600 rupees, blanket owns roughly 110 rupees. This 110 rupees is known as a take rate, the share that blanket keeps for itself from an order.`,
    fieldInfo: ['take rate', 'customer fees ratio']
  },
  {
    text: `Now let's come down to the cost side. Even here you have four elements. The first one is the biggest one, which is the last mile delivery cost, which is the last step when the riders deliver the orders to you and cost about roughly 7% to blanket. And in our case, it would come down to 42 rupees. The next one is dark store mid mile and warehousing cost. This entire combination of cost comes down to about 6.5%. And in our case, it would be 39 rupees. The other variable cost, which includes packaging, washes, support, communication and payment charges are roughly 2%, which comes down to 12 rupees. And now the fourth and the last one is customer acquisition cost, which is the discount, the incentives and the offers they try to give you to make tempting these for you. This comes at about 0.2 to 0.3% at about 1.8 rupees. So if you subtract these two amounts, blink it on roughly 15 rupees from entire transaction. This 15 rupees is not the net profit, by the way, but the contributing profit. Now what is that? See, contributing profit is the profit that the company is earning by serving each order. And company considers only the variable expenses in this case, which is the expense that we have already discussed. And it does not mean net profit because there are so many fixed expenses that are not considered like expensive salary of tech folks, rent, insurance, depreciation, and all similar big sums of money.`,
    fieldInfo: ['cost element', 'cost ratio', 'cost value']
  },
  {
    text: `The answer to this is the dark stores, the 2,500 to 4,000 square feet big stores that are located in 1.5 to 3 kilometer radius near your homes to ensure super quick delivery. And by the way, these stores are super big. For example, if your nearest kirana shop has about 1,500 SKUs, these stores can have 4 x a number of excuse. In fact, a highly efficient dark store can do a better gross merchandise value per square foot than a highly organized supermarket like Dmart. So while a dark store or blanket can do a GMV of 90,000 rupees per square fit, Mart can only do a GMV of 47,000 rupees per square fit. But how does this work? See, these stores are like supermarkets, but have no Hawkins, which means that only rider can go and collect stuff from there. These stores have a lot of inventory that comes from Mother Warehouse store, which is located in the outskirts. So to give you context, for every 40 dark stores located in the city, there is always a mother warehouse, which is located at the outskirts or city. And that is more than 10 times big as a dark store, which is about 20,000 to 1 lax, 75,000 square feet big. It is super huge. And companies don't set dark stores everywhere, by the way. They are smartly set based on multiple parameters like average household income of the area, peak time traffic of the area, infrastructure structure of the area, and also the population density. Also, there's usually about a staff of 25 to 30 people who are working in three shifts in these dark stores who would take care of the packaging. And as we've discussed earlier as well in the video, that the operating cost for a dark store comes at about rupees 22 for each order. And if you want to understand this calculation better, we have put it here. So you can pause the video and look at this table.`,
    fieldInfo: ['store type', 'store size', 'SKU', 'GMV', 'staff count']
  },
  {
    text: `Now blanket has done a really solid job here as they have, right now, the highest number of dark stores with 451 stores in 27 cities compared to 450 stores of Insta margin, 25 cities, 30 of Zepto intensities and 350 stores of Big Basket in 35 cities. By the way, this is not something they built in a day because it was the first grocery app in the country, which started in 2014 as growers. So their team and their execution is way more experienced if you compare them with other competitors, and now they're just building on this and increasing their penetration throughout the country. By the way, they're mostly penetrated in north and east India, and 90% of the GMV comes from top paid cities. But as they enter south and other cities, this can be a huge opportunity for them as they already have an experience DNA running in the organization.`,
    fieldInfo: ['company', 'stores number', 'cities number']
  },
  {
    text: `Now coming down to the second insight, which is cracking high average order value. But why are we talking about AOVs? Average order value plays a big role in quick commerce because bigger the average order value, bigger is the contribution margin for the company, which means that delivering just a set of bananas or apples is less profitable for blanket. Then delivering a set of bananas, apples, onions, tomatoes and a packet of bread together. And blanket has the highest average order value if you compare it with all the comparators. And just look at the stark difference by yourself. For big Basket, the AOV is about 400 to 500 rupees. For Zepto and Instamar, it is around 450+. And for blanket Au UV is about staggering 6,35 rupees. This is something that is definitely giving them an edge in pulling one of the most important levers in the ecosystem. In fact, in the last quarter, this number was 523 rupees at the start of Q1 fi 23. It just shows the speed at which they are growing really fast, and they have done this really well through their amazing SKU strategy.`,
    fieldInfo: ['company', 'AOV']
  },
  {
    text: `Not talking about the third insight, new customer acquisition. See, blinkits market share has not been the highest forever. It was 32%2082. And in the same period, Instama's market share has fallen from 52%, while Zeptos has increased from 15 to 28%. And we had to talk about the elephant in the room, the Zomato Effect. See, Zomato is the biggest food delivery app that has more than hundred million active users every month on its app and a market share of more than 56%. When it comes to food delivery, these users are more than three ties what blanket has at the moment. So even getting 5% of Zomato's monthly active users as new customers could bring more than 33% rise to their current Mau base.`,
    fieldInfo: ['company', 'marker share']
  },
  {
    text: `Want to show you something cute little condo in Toronto's Harbor Front neighborhood, bustling part of the city. It goes on the market in the summer of 2022. The sellers put it up for $480,000. It didn't sell early. 2023, it's back on the market for 460 k. No luck later that year, posted again at 4,50 k. Still nothing. And a few months ago, the sellers tried again. At $430,000, no takers. This condo was sitting on the market for more than 400 days without a sale. Right now in Canada's biggest cities, there's a ton of condos like this struggling to sell. A condo sales in Toronto, for example, haven't been this low since the financial crisis in 2009.`,
    fieldInfo: ['year', 'price']
  },
  {
    text: `Let's compare what a condo investment in Toronto looked like in 2016 to today. So according to the Toronto Real Estate Board, the average price of a one bedroom condo back then in 2016 was about three hundred thousand dollars and with 2016 interest rates about 2.7%, that worked out to a mortgage payment of about eleven hundred dollars a month. Rent for the average one bedroom apartment at that time was about sixteen hundred and sixty dollars. Not bad from an investor point of view, even with, you know, maintenance fees, property taxes, that condo is essentially paying for itself while you build equity.`,
    fieldInfo: ['average price', 'inerset rate', 'mortgage_payment', 'rent']
  },
  {
    text: `Now what if you were to buy a one bedroom condo today in Toronto? That could cost you about 550 grand. So prices have very clearly gone up, but so have interest rates. The carrying costs on a property are far higher than they ever used to be. Well, not ever, but in recent memory. At current rates, 6.8%, maybe now you're paying more than $3,000 a month for your mortgage payment alone. Then you've got, you know, property taxes, maintenance fees and the average rent per unit like that, about 24 hundred dollars a month you're now paying out of.`,
    fieldInfo: ['price', 'inerset rate', 'mortgage_payment', 'average rent']
  },
  {
    text: `Now the renewals come in and you're losing a lot of money, but you've actually come to realize in the last 12 months the price of that condo has probably dropped about $40,000. So you're starting to enter into a state of actual fear.`,
    fieldInfo: ['time period', 'price change']
  },
  {
    text: `According to stats Cam, the average size of a new condo in Toronto has shrunk significantly over time. From 1981 to 1990, new condos were on average about 1,000 square feet. From 2016 to 2020, they were around 650 square feet or about 40% smaller. And if you ask anyone who lives in the downtown core right now, 650 square feet actually feels pretty big.`,
    fieldInfo: ['time period', 'average size']
  },
  {
    text: `Right now, for example, in Toronto and Vancouver, three quarters of larger condos, the ones, you know, maybe more suitable for a family built decades ago, those are being lived in by the people who own them. But for those much smaller condos built after 2016 with investors in mind, only about half are being lived in by owners. Remember that cute little studio that we showed you at the start that took 400 some days to sell. It was 330 square feet. Here's a two bedroom, 700 square foot unit in that same building. It's sold earlier this month on the first try in just 13 days. If we.`,
    fieldInfo: ['days to cell', 'unit size', '']
  },
  {
    text: `Back then in 2020,2021, even into the beginning of 2022, we saw these historic low interest rates and people were taking out loans then and taking out bigger loans, right? They go and buy a house that they wouldn't have been able to afford. 3% or 4%, but they could afford at 1.25%. They called.`,
    fieldInfo: ['year', 'interest rate']
  },
  {
    text: `No. So let's say there's a young couple in Ontario that bought an average priced house in 2019,$631,990. They put pretty standard down payments, down 20 percents, which leaves you with a mortgage size of about $500,000. Amortize the loan over 25 years, they take a five year fixed rate of 2.9%, which was also kind of standard at the time. That means they've been paying about, and I'm rounding to the nearest dollar here, 2,367 bucks for the past few years. But now that mortgage is up for renewal. Welcome to 2024. And the couple signs on to another fixed rate mortgage, but they have to do it at the bank's current rate, which is around 6%. That means their new monthly payment is, again, I'm rounding here, $3,075 a month or an extra 700 bucks a month. Right.`,
    fieldInfo: ['year', 'fixed rate', 'monthly payment']
  },
  {
    text: `Think of it this way. This circle is your $2,200 a month mortgage payment at a relatively low interest rate pending on the overall size of your mortgage, that might mean $900 of that payment is just servicing interest with the other 13 actually paying your loan back as the interest rate rises. Maybe now instead of 900 dollars a month, it's 20. One hundred dollars a month in interest. But your contract says your total payments stay the same, so you're still paying 22 dollars a month, meaning only 100 of those 22 hundred dollars are actually paying down your loan at that point. I have news for you. You're very close to being underwater, stuck in a perpetual state of paying down a loan where you're only barely paying down that loan. Welcome to lifelong debt, the time it will take to pay off his mortgage nearly doubled from.`,
    fieldInfo: ['monthly payment', 'interset payment', 'principal payment']
  },
  {
    text: `Collectively, we're just starting to approach the edge of this cliff. RBC estimates about $186 billion worth of mortgages are up for renewal in 2024. Next year, it'll be 350,15 billion. That's a ton of mortgage debt that was taken on at historically low interest rates by people who may or may not have been able to afford getting into the housing market otherwise.`,
    fieldInfo: ['year', 'mortgage_debt']
  },
  {
    text: `What would you do if one day your neighbor, who you've known for years, you see him building a bomb shelter? Would you think that guy's crazy or would you wonder what does he know that I don't? Turns out banks right now are building a bombshelter. Just this quarter, Canada's big six banks have set $4.3 billion aside to cover bad loans. That's almost double what they set aside in the first quarter of last year and more than 11 times what they set aside in the first quarter before that.`,
    fieldInfo: ['quater', 'year', 'amount_set_aside']
  },
  {
    text: `This is important. About 65% of them, 70% of them have not noticed any radical increase in their payment because their mortgage company sold a product where the payment did not go up when prime went up. Their payment did not go up when prime went up. That's the important part to understand, because it means you might have people ultimately paying more without even realizing it.`,
    fieldInfo: ['percentage']
  },
  {
    text: `Now, luckily, most economists do expect rates to keep dropping. According to that same RBC report, it still might not be enough to, quote, save this cohort to get them down to a more manageable monthly increase like 20%. They argue the bank of Canada would have to lower its prime rate way down to around point two five % by July 2026, something they admit is an unreasonable expectation.`,
    fieldInfo: ['date', 'rate change', 'monthly_increase']
  },
  {
    text: `The old rule of thumb in my day was you spend about a third of your income on housing. Now you'll hear anecdotal evidence, particularly in places like Vancouver, Toronto, where you'll hear 70 to 75% of income is being spent on housing. So in those cases, then if they have to reset at a higher interest rate, it's the house that's gonna go down first. So.`,
    fieldInfo: ['location', 'income_spent_on_housing']
  },
  {
    text: `In order to get the most accurate reading on the US housing market inventory situation, we need to consider both supply and demand. Supply in this case is the level of inventory for sale and demand is the current case of sales volume. If we start with sales volume, we can see the existing home market has a sales pace of roughly 3.7 million homes per year, while the new home market has a sales pace of 619,000 homes per year. Right off the bat, we can see how the existing home market is almost six times larger than the new construction market in terms of sales volume. Both of these markets, existing and new, have seen a huge reduction in sales volume or buyer demand since interest rates have increased, as affordability is out of reach for most people. If we take this annual sales pace and divided by 12, we can get an idea of the average sales pace per month. Of course, there are seasonal patterns, but if we normalize for those effects, we can see that the current monthly sales pace in the existing home market is roughly 309,000, and the new construction market is selling about 51,000 homes per month. At the peak of the housing boom during the pandemic, the existing hallmark had a sales pace of 500,000 units per month and the new construction market was selling nearly 90,000 units per month. Now that we have an idea of the current level of demand, we have to look at supply or the level of inventory for sale in the existing home market. There are currently 1.1 million homes for sale, one of the lowest on record. If we just look at inventory alone. In the new construction market, there are 479,000 units for sale, one of the highest levels on record, only surpassed by the housing bubble of 2007.`,
    fieldInfo: ['market type', 'sale pace annual', 'sale pace monthly', 'sales_pace_peak_monthly', 'inventory']
  },
  {
    text: `You can clearly see how there is nuance to the situation of US housing inventory, the best measure of US housing inventory takes into account both supply and demand and is called the month supply. In other words, how many months of inventory are available for the current pace of sales value. If we take the current level of inventory for both the existing hall market and the new hall market, and we divide it by the current monthly pace of sales. We can see how many months it would take to sell all the inventory at the current pace of sales in the existing home market, that month's supply figure or the inventory level divided by the sales volume, 3.7. In the new construction market, it is 9.3.`,
    fieldInfo: ['market_type', 'month supply']
  },
  {
    text: `Generally speaking, the 5.5 to 6.0 level is considered a balanced market where there is no significant upward or downward pressure on prices. When the month's supply level is below 5.5, that means there is very little inventory available for today's market conditions and prices generally rise. On the flip side, a high level of month's supply means there's too much inventory and prices must fall. The existing home market has a month supply of 3.7, which is very low, but it's been increasing since the absolute historic level of one point six in January 2022. Never in the history of the US housing market has the month's supply of existing homes been that low. This created a very unhealthy situation in the existing home market. The inventory situation in the existing hall market is still very tight, but it's now at the highest level since before for the pandemic. The new construction market is a completely different ballgame with a month supply at 9.3, super high and way above the balanced 6.0 level. There is way more detail to the situation in the new construction market that we'll uncover in just a moment. If we look at the total US housing market situation, both existing and new construction, the aggregate month supply figure has increased to 4.5. So yes, the total inventory situation is still very tight on a national level, but the level is rising and at the highest point since 2,015. The monthly numbers are volatile, so let's look at a yearly average to make things more clear. This shows the month's supply for the total US housing market by year. 2024 is a partial year, and the current level as of May 2024 is also noted in the chart. As of May 2024, the total month supply situation is 4.5, which it hasn't been since 2015. You can also see the four years where the total month supply was below 4.0, which is extremely tight. And you can also see the 2021 situation at 2.6, which was crazy unhealthy. One major point is that this current 4.5 level is the national average. But as we know, real estate is very regional. So this means that there are some markets that are near a month supply of 6 and feeling downward price pressure, while some markets are still down at 3 and seeing prices rise with multiple offers. The new home market with a month supply of 9.3 is way above the balance level of six point zero, and there are price cuts and discounts in that market.`,
    fieldInfo: ['date', 'markey type', 'month supply']
  },
  {
    text: `In June, the National Association of homebuilders reported that 29% of builders cut home prices with an average price reduction of 6%. And 61% of builders use sales incentives like mortgage rate ByteDance to boost sales. But we need to talk about the new hall market and the 9.3 month supply level in a bit more detail, because there is more than what meets BI in the new construction market. Currently, there are 479,000 units for sale in the new construction market and a current pace of sales of about 50 thousand per month. In the new home market, a home could be listed for sale when it's completed, under construction or not yet started. If we look at the percentage of inventory that is completed, we can see that of those 479,000 new home units for sale, Only 20% are completed, which means 80% are either under construction or not yet started.`,
    fieldInfo: [
      'builders cut prices percentage',
      'average price reduction',
      'builders use incentives percentage',
      'units for sale',
      'completed inventory percentage'
    ]
  },
  {
    text: `The level of completed new home inventory for sale fell below 10% during the most acute part of the US housing shortage. Normally, in between 20% and 30% of new construction inventory is completed. During really bad downturns like 2008, builders were sitting on almost 50% completed inventory, which is what led to dramatic price cuts and big layoffs of construction crews. The level of completed inventory is now back into the normal range at 20%, and it's rising, which means that if we move towards 30%, price cuts will get more intense and construction crews will be at high risk of job losses. If we take the current 50,000 new home sales pace and divide that by the amount of completed new home inventory for sale. We can see that there's currently about 1.9 months of completed inventory for sale, which is getting past the average level and into the range consistent with recessions and job losses for construction crews. If the home builders have a lot of completed new home inventory for sale, they aren't going to apply for new building permits and build even more homes. And that's exactly what we're starting to see.`,
    fieldInfo: ['period', 'completed_inventory_ratio']
  },
  {
    text: `Homelessness has been rare since the reemergence of homelessness in the mid 1980s. Usually it's been people in their 20s and 30s and 40s, but now we're approaching close to 30% of the adult homeless population are people 55 and over.`,
    fieldInfo: ['age group', 'percentage']
  },
  {
    text: `Exports from China are rising fast and US officials are nervous about this gap. We're not gonna let China flood our market. Sound familiar? There has to be a level playing field for American companies competing in China. In the early 2 Chinese factories like this one pumped out clothes and flags and cars. The sticker prices were cheap. But there was another price to be paid, American jobs. Every single employee of this plant, we'll be out of work by January. 15 years and almost 6 million jobs later, economists are debating what price another wave of imports could exact from American workers. But two key differences between then and now may have a new effect on the US economy. Look at this line. Before 2001, American manufacturing employed over 17 million people, making toys, furniture, paper goods and much more. Then word began to circulate that China was joining the World Trade Organization. And here's what it did. Joining the WTO meant China faced fewer tariffs and restrictions from its trading partners, and the result was dubbed the China.`,
    fieldInfo: ['year', 'jobs number']
  },
  {
    text: `2.5 million Americans lost their jobs from 2000 to 2007. They're represented by the blue on this map. Look at this dark blue area here. That's Silicon Valley, where companies like Apple, HP and Cisco used to manufacture goods. After 2001, they moved most of their production to China, causing a 50+ percent drop in manufacturing jobs in the county, this other dark blue county, Cedar Rapids, Iowa, lost 46% of their manufacturing jobs, primarily in furniture and machinery. But this lighter blue region here was largely spared. It's called Auto Alley. The main reason it succeeded where, say, Silicon Valley's manufacturing failed, is due to investment from competitors like Japan.`,
    fieldInfo: ['region', 'job_loss_percentage']
  }
];
