/* eslint-disable max-len */
/*
 **动态条形图
 */
export const mockUserInput6 = {
  csv: `country,continent,GDP,year
美国,美洲,239270,1973
印度,亚洲,22960,1973
韩国,亚洲,7870,1973
土耳其,亚洲,17240,1973
印度尼西亚,亚洲,10980,1973
沙特阿拉伯,亚洲,23760,1973
泰国,亚洲,4130,1973
菲律宾,亚洲,5660,1973
马来西亚,亚洲,2780,1973
英国,欧洲,114750,1973
意大利,欧洲,107570,1973
西班牙,欧洲,55990,1973
荷兰,欧洲,36410,1973
瑞士,欧洲,33920,1973
芬兰,欧洲,9930,1973
瑞典,欧洲,23020,1973
比利时,欧洲,22280,1973
挪威,欧洲,14540,1973
美国,美洲,278390,1978
印度,亚洲,29220,1978
韩国,亚洲,13120,1978
土耳其,亚洲,22620,1978
印度尼西亚,亚洲,15390,1978
沙特阿拉伯,亚洲,30080,1978
泰国,亚洲,6000,1978
菲律宾,亚洲,7480,1978
马来西亚,亚洲,3900,1978
英国,欧洲,121140,1978
意大利,欧洲,126030,1978
西班牙,欧洲,64080,1978
荷兰,欧洲,41420,1978
瑞士,欧洲,32360,1978
芬兰,欧洲,10800,1978
瑞典,欧洲,24650,1978
比利时,欧洲,24970,1978
挪威,欧洲,18160,1978
美国,美洲,336520,1983
印度,亚洲,34790,1983
韩国,亚洲,18480,1983
土耳其,亚洲,25000,1983
印度尼西亚,亚洲,20870,1983
沙特阿拉伯,亚洲,24130,1983
泰国,亚洲,7840,1983
菲律宾,亚洲,9070,1983
马来西亚,亚洲,5510,1983
英国,欧洲,129860.00000000001,1983
意大利,欧洲,141500,1983
西班牙,欧洲,67430,1983
荷兰,欧洲,42830,1983
瑞士,欧洲,35000,1983
芬兰,欧洲,13130,1983
瑞典,欧洲,26980,1983
比利时,欧洲,26860,1983
挪威,欧洲,20980,1983
美国,美洲,427650,1988
印度,亚洲,45400,1988
韩国,亚洲,30960,1988
土耳其,亚洲,33340,1988
印度尼西亚,亚洲,26890,1988
沙特阿拉伯,亚洲,25640,1988
泰国,亚洲,11350,1988
菲律宾,亚洲,8970,1988
马来西亚,亚洲,6880,1988
英国,欧洲,158980,1988
意大利,欧洲,166060,1988
西班牙,欧洲,80430,1988
荷兰,欧洲,49070,1988
瑞士,欧洲,39950,1988
芬兰,欧洲,15720,1988
瑞典,欧洲,31270,1988
比利时,欧洲,30520,1988
挪威,欧洲,24800,1988
美国,美洲,488020,1993
印度,亚洲,56680,1993
韩国,亚洲,45790,1993
土耳其,亚洲,41600,1993
印度尼西亚,亚洲,37570,1993
沙特阿拉伯,亚洲,34670,1993
泰国,亚洲,17990,1993
菲律宾,亚洲,10000,1993
马来西亚,亚洲,10720,1993
英国,欧洲,167180,1993
意大利,欧洲,177750,1993
西班牙,欧洲,89630,1993
荷兰,欧洲,56320,1993
瑞士,欧洲,42740,1993
芬兰,欧洲,15040,1993
瑞典,欧洲,30950,1993
比利时,欧洲,33350,1993
挪威,欧洲,28050,1993
美国,美洲,521740,1998
印度,亚洲,77270,1998
韩国,亚洲,59600,1998
土耳其,亚洲,50560,1998
印度尼西亚,亚洲,42880,1998
沙特阿拉伯,亚洲,37310,1998
泰国,亚洲,19930,1998
菲律宾,亚洲,12090,1998
马来西亚,亚洲,14070,1998
英国,欧洲,196370,1998
意大利,欧洲,196130,1998
西班牙,欧洲,104800,1998
荷兰,欧洲,67570,1998
瑞士,欧洲,46090,1998
芬兰,欧洲,18940,1998
瑞典,欧洲,36510,1998
比利时,欧洲,37790,1998
挪威,欧洲,34830,1998
美国,美洲,545920,2003
印度,亚洲,102500,2003
韩国,亚洲,84420,2003
土耳其,亚洲,55060,2003
印度尼西亚,亚洲,51460,2003
沙特阿拉伯,亚洲,40500,2003
泰国,亚洲,25620,2003
菲律宾,亚洲,14620,2003
马来西亚,亚洲,18210,2003
英国,欧洲,228640,2003
意大利,欧洲,211730,2003
西班牙,欧洲,126720,2003
荷兰,欧洲,75950,2003
瑞士,欧洲,49450,2003
芬兰,欧洲,22260,2003
瑞典,欧洲,42290,2003
比利时,欧洲,42160,2003
挪威,欧洲,38320,2003
美国,美洲,578410,2008
印度,亚洲,143180,2008
韩国,亚洲,106280,2008
土耳其,亚洲,74660,2008
印度尼西亚,亚洲,67940,2008
沙特阿拉伯,亚洲,51340,2008
泰国,亚洲,31950,2008
菲律宾,亚洲,19140,2008
马来西亚,亚洲,24100,2008
英国,欧洲,253560,2008
意大利,欧洲,221500,2008
西班牙,欧洲,147390,2008
荷兰,欧洲,86710,2008
瑞士,欧洲,57960,2008
芬兰,欧洲,26270,2008
瑞典,欧洲,48920,2008
比利时,欧洲,47720,2008
挪威,欧洲,43330,2008
美国,美洲,589420,2013
印度,亚洲,197840,2013
韩国,亚洲,125320,2013
土耳其,亚洲,97510,2013
印度尼西亚,亚洲,89730,2013
沙特阿拉伯,亚洲,62900,2013
泰国,亚洲,37880,2013
菲律宾,亚洲,24700,2013
马来西亚,亚洲,29650,2013
英国,欧洲,260510,2013
意大利,欧洲,204670,2013
西班牙,欧洲,134780,2013
荷兰,欧洲,84970,2013
瑞士,欧洲,61070,2013
芬兰,欧洲,24970,2013
瑞典,欧洲,51470,2013
比利时,欧洲,49500,2013
挪威,欧洲,44930,2013
美国,美洲,617030,2018
印度,亚洲,282220,2018
韩国,亚洲,144970,2018
土耳其,亚洲,124050,2018
印度尼西亚,亚洲,114690,2018
沙特阿拉伯,亚洲,70160,2018
泰国,亚洲,44230,2018
菲律宾,亚洲,34030,2018
马来西亚,亚洲,38210,2018
英国,欧洲,287930,2018
意大利,欧洲,214100,2018
西班牙,欧洲,153950,2018
荷兰,欧洲,94810,2018
瑞士,欧洲,67460,2018
芬兰,欧洲,26920,2018
瑞典,欧洲,58930,2018
比利时,欧洲,53840,2018
挪威,欧洲,48930,2018
`,
  input: '使用动态条形图帮我展示各国GDP排名变化'
};

/*
 **动态条形图-英文
 */
export const mockUserInput6Eng = {
  csv: `country,continent,GDP,year
USA,North America,239270,1973
India,Asia,22960,1973
South Korea,Asia,7870,1973
Turkey,Asia,17240,1973
Indonesia,Asia,10980,1973
Saudi Arabia,Asia,23760,1973
Thailand,Asia,4130,1973
Philippines,Asia,5660,1973
Malaysia,Asia,2780,1973
United Kingdom,Europe,114750,1973
Italy,Europe,107570,1973
Spain,Europe,55990,1973
Netherlands,Europe,36410,1973
Switzerland,Europe,33920,1973
Finland,Europe,9930,1973
Sweden,Europe,23020,1973
Belgium,Europe,22280,1973
Norway,Europe,14540,1973
USA,North America,278390,1978
India,Asia,29220,1978
South Korea,Asia,13120,1978
Turkey,Asia,22620,1978
Indonesia,Asia,15390,1978
Saudi Arabia,Asia,30080,1978
Thailand,Asia,6000,1978
Philippines,Asia,7480,1978
Malaysia,Asia,3900,1978
United Kingdom,Europe,121140,1978
Italy,Europe,126030,1978
Spain,Europe,64080,1978
Netherlands,Europe,41420,1978
Switzerland,Europe,32360,1978
Finland,Europe,10800,1978
Sweden,Europe,24650,1978
Belgium,Europe,24970,1978
Norway,Europe,18160,1978
USA,North America,336520,1983
India,Asia,34790,1983
South Korea,Asia,18480,1983
Turkey,Asia,25000,1983
Indonesia,Asia,20870,1983
Saudi Arabia,Asia,24130,1983
Thailand,Asia,7840,1983
Philippines,Asia,9070,1983
Malaysia,Asia,5510,1983
United Kingdom,Europe,129860.00000000001,1983
Italy,Europe,141500,1983
Spain,Europe,67430,1983
Netherlands,Europe,42830,1983
Switzerland,Europe,35000,1983
Finland,Europe,13130,1983
Sweden,Europe,26980,1983
Belgium,Europe,26860,1983
Norway,Europe,20980,1983
USA,North America,427650,1988
India,Asia,45400,1988
South Korea,Asia,30960,1988
Turkey,Asia,33340,1988
Indonesia,Asia,26890,1988
Saudi Arabia,Asia,25640,1988
Thailand,Asia,11350,1988
Philippines,Asia,8970,1988
Malaysia,Asia,6880,1988
United Kingdom,Europe,158980,1988
Italy,Europe,166060,1988
Spain,Europe,80430,1988
Netherlands,Europe,49070,1988
Switzerland,Europe,39950,1988
Finland,Europe,15720,1988
Sweden,Europe,31270,1988
Belgium,Europe,30520,1988
Norway,Europe,24800,1988
USA,North America,488020,1993
India,Asia,56680,1993
South Korea,Asia,45790,1993
Turkey,Asia,41600,1993
Indonesia,Asia,37570,1993
Saudi Arabia,Asia,34670,1993
Thailand,Asia,17990,1993
Philippines,Asia,10000,1993
Malaysia,Asia,10720,1993
United Kingdom,Europe,167180,1993
Italy,Europe,177750,1993
Spain,Europe,89630,1993
Netherlands,Europe,56320,1993
Switzerland,Europe,42740,1993
Finland,Europe,15040,1993
Sweden,Europe,30950,1993
Belgium,Europe,33350,1993
Norway,Europe,28050,1993
USA,North America,521740,1998
India,Asia,77270,1998
South Korea,Asia,59600,1998
Turkey,Asia,50560,1998
Indonesia,Asia,42880,1998
Saudi Arabia,Asia,37310,1998
Thailand,Asia,19930,1998
Philippines,Asia,12090,1998
Malaysia,Asia,14070,1998
United Kingdom,Europe,196370,1998
Italy,Europe,196130,1998
Spain,Europe,104800,1998
Netherlands,Europe,67570,1998
Switzerland,Europe,46090,1998
Finland,Europe,18940,1998
Sweden,Europe,36510,1998
Belgium,Europe,37790,1998
Norway,Europe,34830,1998
USA,North America,545920,2003
India,Asia,102500,2003
South Korea,Asia,84420,2003
Turkey,Asia,55060,2003
Indonesia,Asia,51460,2003
Saudi Arabia,Asia,40500,2003
Thailand,Asia,25620,2003
Philippines,Asia,14620,2003
Malaysia,Asia,18210,2003
United Kingdom,Europe,228640,2003
Italy,Europe,211730,2003
Spain,Europe,126720,2003
Netherlands,Europe,75950,2003
Switzerland,Europe,49450,2003
Finland,Europe,22260,2003
Sweden,Europe,42290,2003
Belgium,Europe,42160,2003
Norway,Europe,38320,2003
USA,North America,578410,2008
India,Asia,143180,2008
South Korea,Asia,106280,2008
Turkey,Asia,74660,2008
Indonesia,Asia,67940,2008
Saudi Arabia,Asia,51340,2008
Thailand,Asia,31950,2008
Philippines,Asia,19140,2008
Malaysia,Asia,24100,2008
United Kingdom,Europe,253560,2008
Italy,Europe,221500,2008
Spain,Europe,147390,2008
Netherlands,Europe,86710,2008
Switzerland,Europe,57960,2008
Finland,Europe,26270,2008
Sweden,Europe,48920,2008
Belgium,Europe,47720,2008
Norway,Europe,43330,2008
USA,North America,589420,2013
India,Asia,197840,2013
South Korea,Asia,125320,2013
Turkey,Asia,97510,2013
Indonesia,Asia,89730,2013
Saudi Arabia,Asia,62900,2013
Thailand,Asia,37880,2013
Philippines,Asia,24700,2013
Malaysia,Asia,29650,2013
United Kingdom,Europe,260510,2013
Italy,Europe,204670,2013
Spain,Europe,134780,2013
Netherlands,Europe,84970,2013
Switzerland,Europe,61070,2013
Finland,Europe,24970,2013
Sweden,Europe,51470,2013
Belgium,Europe,49500,2013
Norway,Europe,44930,2013
USA,North America,617030,2018
India,Asia,282220,2018
South Korea,Asia,144970,2018
Turkey,Asia,124050,2018
Indonesia,Asia,114690,2018
Saudi Arabia,Asia,70160,2018
Thailand,Asia,44230,2018
Philippines,Asia,34030,2018
Malaysia,Asia,38210,2018
United Kingdom,Europe,287930,2018
Italy,Europe,214100,2018
Spain,Europe,153950,2018
Netherlands,Europe,94810,2018
Switzerland,Europe,67460,2018
Finland,Europe,26920,2018
Sweden,Europe,58930,2018
Belgium,Europe,53840,2018
Norway,Europe,48930,2018
`,
  input: 'Show me the change of the GDP rankings of each country '
};

/*
 **饼图
 */
export const mockUserInput2 = {
  csv: `品牌名称,市场份额,平均价格,净利润
Apple,0.5,7068,314531
Samsung,0.2,6059,362345
Vivo,0.05,3406,234512
Nokia,0.01,1064,-1345
Xiaomi,0.1,4087,131345`,
  input: '展示各品牌市场占有率'
};

export const mockUserInput8 = {
  csv: `date,type,value
2023-01-01,产品 A,52.9
2023-01-01,产品 B,63.6
2023-01-01,产品 C,11.2
2023-01-02,产品 A,45.7
2023-01-02,产品 B,89.1
2023-01-02,产品 C,21.4
2023-01-03,产品 A,67.2
2023-01-03,产品 B,82.4
2023-01-03,产品 C,31.7
2023-01-04,产品 A,80.7
2023-01-04,产品 B,55.1
2023-01-04,产品 C,21.1
2023-01-05,产品 A,65.6
2023-01-05,产品 B,78
2023-01-05,产品 C,31.3
2023-01-06,产品 A,75.6
2023-01-06,产品 B,89.1
2023-01-06,产品 C,63.5
2023-01-07,产品 A,67.3
2023-01-07,产品 B,77.2
2023-01-07,产品 C,43.7
2023-01-08,产品 A,96.1
2023-01-08,产品 B,97.6
2023-01-08,产品 C,59.9
2023-01-09,产品 A,96.1
2023-01-09,产品 B,100.6
2023-01-09,产品 C,66.8
2023-01-10,产品 A,101.6
2023-01-10,产品 B,108.3
2023-01-10,产品 C,56.9`,
  input: '请帮我展示各产品的销售趋势'
};

/*
 **柱状图
 */
export const mockUserInput3 = {
  csv: `商品名称,region,销售额
可乐,south,2350
可乐,east,1027
可乐,west,1027
可乐,north,1027
雪碧,south,215
雪碧,east,654
雪碧,west,159
雪碧,north,28
芬达,south,345
芬达,east,654
芬达,west,2100
芬达,north,1679
醒目,south,1476
醒目,east,830
醒目,west,532
醒目,north,498
`,
  input: '帮我展示不同区域各商品销售额'
};

export const mockUserInput10 = {
  csv: `城市,2022年GDP（亿元）
北京,31897
上海,30956
广州,30000
深圳,30395
苏州,25000`,
  input: '请使用[柱状图]展示[2022年GDP排名前五的中国城市及其2022年的GDP]'
};

/*
 **柱状图
 */
export const mockUserInput3Eng = {
  csv: `Product Name,Region,Sales
Coke, South, 2350
Coke, East, 1027
Coke, West, 1027
Coke, North, 1027
Sprite, South, 215
Sprite, East, 654
Sprite, West, 159
Sprite, North, 28
Fanta, South, 345
Fanta, East, 654
Fanta, West, 2100
Fanta, North, 1679
Mirinda, South, 1476
Mirinda, East, 830
Mirinda, West, 532
Mirinda, North, 498
`,
  input: 'display the sales figures of different products in various regions.'
};

export const carSaleMockData = {
  csv: `时间,汽车厂商,销量
2022年1月,上汽大众,124491
2022年1月,长安汽车,123707
2022年1月,吉利汽车,112325
2022年1月,东风日产,110996
2022年1月,一汽-大众,103462
2022年1月,广汽丰田,99707
2022年1月,比亚迪,93363
2022年1月,华晨宝马,79087
2022年1月,广汽本田,77377
2022年1月,东风本田,76903
2022年2月,比亚迪,88093
2022年2月,上汽大众,86076
2022年2月,一汽丰田,75918
2022年2月,东风日产,74308
2022年2月,一汽-大众,70638
2022年2月,东风本田,58954
2022年2月,广汽本田,56734
2022年2月,特斯拉中国,56515
2022年2月,吉利汽车,55357
2022年2月,长安汽车,53034
2022年3月,长安汽车,110015
2022年3月,上汽大众,104200
2022年3月,比亚迪,103852
2022年3月,上汽通用五菱,102951
2022年3月,广汽丰田,96984
2022年3月,一汽-大众,76586
2022年3月,广汽本田,75858
2022年3月,吉利汽车,75447
2022年3月,东风本田,71074
2022年3月,一汽丰田,69957
2022年4月,比亚迪,105475
2022年4月,广汽丰田,68450
2022年4月,吉利汽车,49137
2022年4月,长安汽车,47980
2022年4月,上汽通用五菱,44002
2022年4月,一汽-大众,39444
2022年4月,东风日产,37636
2022年4月,华晨宝马,31743
2022年4月,一汽丰田,31443
2022年4月,长城汽车,29125
2022年5月,比亚迪,114183
2022年5月,一汽-大众,89025
2022年5月,广汽丰田,83730
2022年5月,上汽大众,83502
2022年5月,上汽通用五菱,71493
2022年5月,长安汽车,66091
2022年5月,华晨宝马,62567
2022年5月,吉利汽车,60197
2022年5月,一汽丰田,57958
2022年5月,东风日产,52531
2022年6月,比亚迪,133762
2022年6月,一汽-大众,123358
2022年6月,上汽大众,122100
2022年6月,一汽丰田,102039
2022年6月,广汽丰田,100794
2022年6月,吉利汽车,91695
2022年6月,长安汽车,88010
2022年6月,上汽通用五菱,87462
2022年6月,东风日产,79570
2022年6月,特斯拉中国,78906
2022年7月,比亚迪,162214
2022年7月,上汽大众,125450
2022年7月,上汽通用五菱,106483
2022年7月,一汽-大众,100160
2022年7月,长安汽车,96786
2022年7月,广汽丰田,83940
2022年7月,吉利汽车,83392
2022年7月,一汽丰田,82697
2022年7月,东风日产,80439
2022年7月,东风本田,78239
2022年8月,上汽大众,180439
2022年8月,比亚迪,173977
2022年8月,广汽丰田,108679
2022年8月,上汽通用五菱,96363
2022年8月,广汽本田,96325
2022年8月,奇瑞汽车,93720
2022年8月,一汽丰田,93361
2022年8月,吉利汽车,92525
2022年8月,一汽-大众奥迪,82348
2022年8月,特斯拉中国,76965
2022年9月,比亚迪,200973
2022年9月,上汽大众,125484
2022年9月,一汽-大众,114112
2022年9月,上汽通用五菱,105179
2022年9月,广汽丰田,95951
2022年9月,长安汽车,92616
2022年9月,奇瑞汽车,86915
2022年9月,一汽丰田,84954
2022年9月,特斯拉中国,83135
2022年9月,吉利汽车,82688
2022年10月,比亚迪,216593
2022年10月,上汽大众,121973
2022年10月,长安汽车,109451
2022年10月,吉利汽车,106877
2022年10月,上汽通用五菱,106458
2022年10月,一汽-大众,83332
2022年10月,广汽丰田,80800
2022年10月,一汽丰田,74924
2022年10月,奇瑞汽车,72512
2022年10月,东风日产,71986
2022年11月,比亚迪,224576
2022年11月,上汽通用五菱,129039
2022年11月,上汽大众,109343
2022年11月,特斯拉中国,100291
2022年11月,吉利汽车,94638
2022年11月,长安汽车,85776
2022年11月,广汽丰田,85169
2022年11月,一汽-大众,72423
2022年11月,一汽丰田,65837
2022年11月,华晨宝马,58527
2022年12月,比亚迪,226492
2022年12月,上汽通用五菱,141821
2022年12月,长安汽车,124609
2022年12月,上汽大众,118750
2022年12月,一汽-大众,93851
2022年12月,吉利汽车,82623
2022年12月,广汽丰田,74033
2022年12月,东风本田,60922
2022年12月,华晨宝马,60117
2022年12月,一汽丰田,59696
2023年1月,比亚迪,133317
2023年1月,长安汽车,90067
2023年1月,上汽大众,78000
2023年1月,一汽-大众,70004
2023年1月,吉利汽车,67479
2023年1月,广汽丰田,61105
2023年1月,华晨宝马,56765
2023年1月,上汽通用五菱,46922
2023年1月,一汽丰田,43787
2023年1月,北京奔驰,42357
2023年2月,比亚迪,169337
2023年2月,长安汽车,72241
2023年2月,上汽大众,71450
2023年2月,广汽丰田,66936
2023年2月,上汽通用五菱,65513
2023年2月,吉利汽车,65140
2023年2月,一汽-大众,60710
2023年2月,一汽丰田,49959
2023年2月,东风日产,49553
2023年2月,华晨宝马,49340
2023年3月,比亚迪,181391
2023年3月,一汽-大众,81030
2023年3月,上汽大众,81009
2023年3月,特斯拉中国,76663
2023年3月,长安汽车,67379
2023年3月,一汽丰田,62347
2023年3月,吉利汽车,61714
2023年3月,广汽丰田,60498
2023年3月,华晨宝马,58320
2023年3月,上汽通用五菱,56440
2023年4月,比亚迪,183534
2023年4月,上汽大众,96203
2023年4月,一汽-大众,78011
2023年4月,广汽丰田,76925
2023年4月,长安汽车,76455
2023年4月,一汽丰田,71383
2023年4月,广汽本田,60462
2023年4月,吉利汽车,59661
2023年4月,上汽通用五菱,58210
2023年4月,华晨宝马,53205
2023年5月,比亚迪,209730
2023年5月,上汽大众,90193
2023年5月,一汽-大众,83610
2023年5月,长安汽车,81209
2023年5月,广汽丰田,77513
2023年5月,一汽丰田,70001
2023年5月,吉利汽车,67100
2023年5月,上汽通用五菱,63292
2023年5月,东风日产,56511
2023年5月,一汽-大众奥迪,52696
2023年6月,比亚迪,220600
2023年6月,一汽-大众,98052
2023年6月,上汽大众,94018
2023年6月,广汽丰田,86345
2023年6月,长安汽车,86189
2023年6月,特斯拉中国,74212
2023年6月,吉利汽车,71726
2023年6月,一汽丰田,70795
2023年6月,广汽本田,65540
2023年6月,一汽-大众奥迪,64037`,
  input: '帮我展示各品牌汽车销量排行的变化'
};

export const acceptRatioData = {
  csv: `年份,高考人数,高考录取人数,高考录取率,招生高校数
1977,570,27.3,0.05 ,404
1978,610,40.2,0.07 ,598
1979,468,28,0.06 ,633
1980,333,28,0.08 ,675
1981,259,28,0.11 ,704
1982,187,32,0.17 ,715
1983,167,39,0.23 ,805
1984,164,48,0.29 ,902
1985,176,62,0.35 ,1016
1986,191,57,0.30 ,1054
1987,228,62,0.27 ,1063
1988,272,67,0.25 ,1075
1989,266,60,0.23 ,1079
1990,283,61,0.22 ,1075
1991,296,62,0.21 ,1075
1992,303,75,0.25 ,1053
1993,286,98,0.34 ,1065
1994,251,90,0.36 ,1080
1995,253,93,0.37 ,1054
1996,241,97,0.40 ,1032
1997,278,100,0.36 ,1020
1998,320,108,0.34 ,1022
1999,288,160,0.56 ,1071
2000,375,221,0.59 ,1041
2001,454,268,0.59 ,1225
2002,510,320,0.63 ,1396
2003,613,382,0.62 ,1552
2004,729,447,0.61 ,1731
2005,877,504,0.57 ,1792
2006,950,546,0.57 ,1867
2007,1010,566,0.56 ,1908
2008,1050,599,0.57 ,2263
2009,1020,629,0.62 ,2305
2010,946,657,0.69 ,2385
2011,933,675,0.72 ,2487
2012,915,685,0.75 ,2442
2013,912,684,0.75 ,2622
2014,939,697,0.74 ,2529
2015,942,700,0.74 ,2553
2016,940,705,0.75 ,2595
2017,940,700,0.74 ,2631
2018,975,790.99,0.81 ,2663
2019,1031,820,0.80 ,2688
2020,1071,856,0.80 ,2956
2021,1078,1001.32,0.93 ,2956
2022,1193,1145.28,0.96 ,2956`,
  input: '帮我展示历年高考录取率的变化，时长10秒'
};

export const mallSalesData = {
  csv: `商场名称,年份,销售业绩
IFS（成都）,2019年,64.9
IFS（成都）,2020年,70
丹尼斯大卫城,2019年,61.5
丹尼斯大卫城,2020年,70
远洋太古里（成都）,2019年,68.7
远洋太古里（成都）,2020年,73
国金中心（上海）,2019年,90
国金中心（上海）,2020年,100
恒隆广场（上海）,2019年,62.5
恒隆广场（上海）,2020年,100
万象城（深圳）,2019年,90
万象城（深圳）,2020年,100
杭州大厦（杭州）,2019年,90
杭州大厦（杭州）,2020年,100
德基广场（南京）,2019年,122.4
德基广场（南京）,2020年,150
国贸商城（北京）,2019年,117
国贸商城（北京）,2020年,160
SKP（北京）,2019年,152.9
SKP（北京）,2020年,177`,
  input: '柱状图，展示各商场销售业绩，时长30秒'
};

export const hotWordsData = {
  csv: `关键词,热度
热词,1000
燥了我们,800
娆贱货,400
我的心愿是世界和平,400
咻咻咻,400
神舟十一号,400
百鸟朝风,400
中国女排,400
我的关呐,400
腿咚,400
火锅英雄,400
宝宝心里苦,400
奥运会,400
厉害了我的哥,400
诗和远方,400
宋仲基,400
PPAP,400
蓝瘦香菇,400
雨露均沾,400
友谊的小船说翻就翻就翻,400
北京瘫,400
敬业,200
Apple,200
狗带,200
老司机,200
吃瓜群众,200
疯狂动物城,200
城会玩,200
套路,200
水逆,200
你咋不上天呢,200
蛇精男,200
你咋不上天呢,200
三星爆炸门,200
小李子奥斯卡,200
人丑就要多读书,200
男友力,200
一脸懵逼,200
太阳的后裔,200`,
  input: '展示搜索关键词热度'
};

//折线图数据处理 无颜色
export const getMockData1 = () => {
  return [
    {
      message: {
        role: 'assistant',
        content:
          '```{"THOUGHT": "该数据集中包含了国家、月份和降雨量三个字段。需要对数据进行按国家和月份分组，然后展示不同国家不同月份的降雨量趋势。","FIELD_INFO":[{"fieldName": "country","description":"表示国家的名称，它是一个字符串。"},{"fieldName": "month","description":"表示月份，它是一个整数。"},{"fieldName": "降雨量","description":"表示每个国家每个月的降雨量，它是一个整数。"}],"USEFUL_FIELDS": ["country","month","降雨量"],"COLOR_PALETTE": [],"REASON":  "所有字段都与用户意图相关，因为需要展示不同国家不同月份的降雨量趋势。","DOUBLE_CHECK": "USEFUL_FIELDS所选字段均有助于完成用户意图，且没有多余字段。FIELD_INFO中包含了每个字段的类型。用户没有指定图表的颜色风格，因此COLOR_PALETTE为空。回复内容可直接被JavaScript中的JSON.parse解析。"}```'
      },
      finish_reason: 'stop',
      index: 0
    }
  ];
};

//折线图图表推荐 无颜色
export const getMockData2 = () => [
  {
    message: {
      role: 'assistant',
      content:
        '{"THOUGHT": "降雨量是一个连续的数值型变量，可以使用折线图或者散点图来展示各国降雨量的趋势。由于数据中包含了月份信息，因此可以使用折线图来展示每个国家每个月的降雨量变化趋势。", "CHART_TYPE": "折线图", "FIELD_MAP": {"x": "month", "y": "降雨量", "color": "country"}, "DOUBLE_CHECK": "折线图适合展示随时间变化的数据，能够满足用户意图。字段分配结果符合用户意图。数据中的所有字段均已在数据映射中使用。FIELD_MAP中的字段都存在于可用的视觉通道列表中。回复内容可直接被JavaScript中的JSON.parse解析。"}'
    },
    finish_reason: 'stop',
    index: 0
  }
];

//柱状图数据处理 带颜色
export const getMockData3 = () => [
  {
    message: {
      role: 'assistant',
      content:
        '```{"THOUGHT": "这是一个关于降雨量的数据集，需要按照国家和月份进行分组。用户意图需要展示降雨量的趋势，因此需要按照月份进行排序。赛博朋克风格的色彩通常是高饱和度的蓝色、紫色、粉色等，因此需要一个高饱和度的色板。","FIELD_INFO":[{"fieldName": "country","description":"表示国家的名称，它是一个字符串。"},{"fieldName": "month","description":"表示月份，它是一个整数。"},{"fieldName": "降雨量","description":"表示每个国家每个月的降雨量，它是一个整数。"}],"USEFUL_FIELDS": ["country","month","降雨量"],"COLOR_PALETTE":["#00FFFF","#FF00FF","#FF1493","#00FF7F","#FFD700","#FF8C00","#FF69B4","#00BFFF"],"REASON":  "降雨量字段与用户意图直接相关。需要按照国家和月份进行分组，因此country和month也是有用字段。用户意图中含有\'趋势\'字样，因此需要按照月份进行排序。赛博朋克风格的色彩通常是高饱和度的蓝色、紫色、粉色等，因此需要一个高饱和度的色板。","DOUBLE_CHECK": "USEFUL_FIELDS所选字段均有助于完成用户意图，且没有多余字段。FIELD_INFO中包含了每个字段的类型。用户指定了图表的颜色风格，COLOR_PALETTE不为空。回复内容可直接被JavaScript中的JSON.parse解析。"}```'
    },
    finish_reason: 'stop',
    index: 0
  }
];

//柱状图图表推荐 带颜色
export const getMockData4 = () => [
  {
    message: {
      role: 'assistant',
      content:
        '{"THOUGHT": "赛博朋克风格的图表通常使用饱和度高、对比强烈的颜色，可以考虑使用散点图或者柱状图来展示各国降雨量趋势。散点图可以更好地展示每个国家每个月的降雨量，柱状图则更加直观地展示降雨量的大小和趋势。根据数据的特点，可以选择柱状图。","CHART_TYPE": "柱状图","FIELD_MAP":{"x": "month","y": "降雨量","color": "country"},"DOUBLE_CHECK": "柱状图适合展示数据的大小和趋势，能够满足用户意图。柱状图在支持的图表列表中。字段分配结果符合用户意图。数据中的所有字段均已在数据映射中使用。FIELD_MAP中的字段都存在于可用的视觉通道列表中。回复内容可直接被JavaScript中的JSON.parse解析。"}'
    },
    finish_reason: 'stop',
    index: 0
  }
];

//饼图数据处理 带颜色
export const getMockData5 = () => [
  {
    message: {
      role: 'assistant',
      content:
        '{\n"THOUGHT": "csv文件中包含品牌名称、市场份额、平均价格、净利润四个字段。其中品牌名称是字符串类型，市场份额是百分数类型，平均价格是浮点数类型，净利润是整数类型。用户需要展示各品牌市场占有率，因此市场份额是有用字段。用户指定了森林风格，需要生成一个包含8个颜色的色板。",\n"FIELD_INFO":[\n{\n"fieldName": "品牌名称",\n"description":"表示手机品牌名称，它是一个字符串。"\n},\n{\n"fieldName": "市场份额",\n"description":"表示该品牌的市场占有率，它是一个百分数。"\n},\n{\n"fieldName": "平均价格",\n"description":"表示该品牌的平均价格，它是一个浮点数。"\n},\n{\n"fieldName": "净利润",\n"description":"表示该品牌的净利润，它是一个整数。"\n}\n],\n"USEFUL_FIELDS": ["品牌名称","市场份额"],\n"COLOR_PALETTE":["#2E8B57","#3CB371","#90EE90","#98FB98","#00FF7F","#7FFF00","#32CD32","#228B22"],\n"REASON":  "市场份额是用户意图中需要的信息，品牌名称需要按照品牌分组展示，因此也是有用字段。平均价格和净利润与用户意图无关。",\n"DOUBLE_CHECK": "USEFUL_FIELDS所选字段均有助于完成用户意图，且没有多余字段。FIELD_INFO中包含了每个字段的类型。用户指定了图表的颜色风格，COLOR_PALETTE不为空。回复内容可直接被JavaScript中的JSON.parse解析。"\n}'
    },
    finish_reason: 'stop',
    index: 0
  }
];

//饼图图表推荐 带颜色
export const getMockData6 = () => [
  {
    message: {
      role: 'assistant',
      content:
        '{\n"THOUGHT": "数据中包含占有率，且用户想展示百分比数据，适合用饼图进行展示。市场占有率做饼图扇区角度，可以展示市场占有率所占份额。品牌名称做颜色，可以对不同品牌进行区分。森林风格可以选择绿色系的颜色进行配色。",\n"CHART_TYPE": "饼图",\n"FIELD_MAP":{\n"angle": "市场份额",\n"color": "品牌名称"\n},\n"DOUBLE_CHECK": "饼图适合展示占有率、份额等百分比数据，能够满足用户意图。饼图在支持的图表列表中。字段分配结果符合用户意图。数据中的所有字段均已在数据映射中使用。FIELD_MAP中的字段都存在于可用的视觉通道列表中。回复内容可直接被JavaScript中的JSON.parse解析。"\n}'
    },
    finish_reason: 'stop',
    index: 0
  }
];

//词云数据处理
export const getMockDataWordCloud1 = () => [
  {
    index: 0,
    message: {
      role: 'assistant',
      content:
        '{\n"THOUGHT": "该csv文件中包含三个字段，challenge_id表示挑战id，challenge_name表示挑战名称，sum_count表示该挑战被使用的次数。用户意图需要展示不同挑战关键词的热度，因此challenge_name和sum_count是有用字段。",\n"FIELD_INFO":[\n{\n"fieldName": "challenge_id",\n"description":"表示挑战id，它是一个整数。"\n},\n{\n"fieldName": "challenge_name",\n"description":"表示挑战名称，它是一个字符串。"\n},\n{\n"fieldName": "sum_count",\n"description":"表示该挑战被使用的次数，它是一个整数。"\n}\n],\n"USEFUL_FIELDS": ["challenge_name","sum_count"],\n"REASON":  "challenge_name表示挑战名称，与用户意图直接相关。sum_count表示该挑战被使用的次数，也是用户意图中需要的信息。challenge_id与用户意图无关",\n"DOUBLE_CHECK": "USEFUL_FIELDS所选字段均有助于完成用户意图，且没有多余字段。FIELD_INFO中包含了每个字段的类型。用户没有指定图表的颜色风格，COLOR_PALETTE可以为空。回复内容可直接被JavaScript中的JSON.parse解析。"\n}'
    },
    finish_reason: 'stop'
  }
];

//词云图表推荐
export const getMockDataWordCloud2 = () => [
  {
    index: 0,
    message: {
      role: 'assistant',
      content:
        '{\n"THOUGHT": "数据中包含关键词和次数，且用户想展示热度，适合用词云进行展示。关键词做词云的词，可以展示不同挑战关键词的热度。次数做词云的词频，可以展示不同挑战关键词的使用次数。",\n"CHART_TYPE": "词云",\n"FIELD_MAP":{\n"size": "sum_count",\n"color": "challenge_name"\n},\n"DOUBLE_CHECK": "词云适合展示关键词的热度，能够满足用户意图。词云在支持的图表列表中。字段分配结果符合用户意图。数据中的所有字段均已在数据映射中使用。FIELD_MAP中的字段都存在于可用的视觉通道列表中。回复内容可直接被JavaScript中的JSON.parse解析。"\n}'
    },
    finish_reason: 'stop'
  }
];

//动态条形图数据处理
export const getMockDataDynamicBar = () => [
  {
    index: 0,
    message: {
      role: 'assistant',
      content:
        '{\n"THOUGHT": "该csv文件中包含了国家、洲、GDP和年份四个字段。其中，国家和洲是字符串类型，GDP是整数类型，年份是日期类型。用户意图需要展示各国GDP排名变化，因此需要选择国家和GDP字段。洲字段与用户意图无关，年份字段也不需要展示。",\n\n"FIELD_INFO":[\n{\n"fieldName": "country",\n"description":"表示国家的名称，它是一个字符串。"\n},\n{\n"fieldName": "continent",\n"description":"表示国家所在的洲，它是一个字符串。"\n},\n{\n"fieldName": "GDP",\n"description":"表示每个国家的GDP总量，它是一个整数。"\n},\n{\n"fieldName": "year",\n"description":"表示当前年份，它是一个日期"\n}\n],\n\n"USEFUL_FIELDS": ["country","GDP"],\n"COLOR_PALETTE":["#00FFFF","#FF00FF","#FFFF00","#00FF00","#FFA500","#FF0000","#800080","#008080"],\n"REASON":  "country表示国家名称，GDP表示国家的GDP总量，与用户意图直接相关。用户需要展示排名变化，因此需要按照GDP字段进行排序。洲字段与用户意图无关，年份字段也不需要展示。",\n\n"DOUBLE_CHECK": "USEFUL_FIELDS所选字段均有助于完成用户意图，且没有多余字段。FIELD_INFO中包含了每个字段的类型。用户指定了图表的颜色风格，COLOR_PALETTE不为空。回复内容可直接被JavaScript中的JSON.parse解析。"\n}'
    },
    finish_reason: 'stop'
  }
];

//动态条形图图表推荐
export const getMockDataDynamicBar2 = () => [
  {
    index: 0,
    message: {
      role: 'assistant',
      content:
        '{\n"THOUGHT": "数据中包含国家和GDP字段，用户想展示排名变化，适合用动态条形图进行展示。国家做条形图的x轴，GDP做条形图的y轴，可展示各国GDP排名变化。时间字段可以选择年份或者季度，根据数据的时间粒度来决定",\n"CHART_TYPE": "Dynamic Bar Chart",\n"FIELD_MAP":{\n"x": "country",\n"y": "GDP",\n"time": "year"\n},\n"DOUBLE_CHECK": "动态条形图适合用于展示变化的数据，且可以在不同时间点进行对比，能够满足用户意图。动态条形图在支持的图表列表中。字段分配结果符合用户意图。数据中的所有字段均已在数据映射中使用。FIELD_MAP中的字段都存在于可用的视觉通道列表中。回复内容可直接被JavaScript中的JSON.parse解析。"\n}'
    },
    finish_reason: 'stop'
  }
];

export const getMockDataScatter1 = () => [
  {
    index: 0,
    message: {
      role: 'assistant',
      content:
        '```\n{\n"THOUGHT": "该csv文件包含了电动汽车的续航里程、充电时间、品牌名称和平均价格等字段。需要根据用户意图，筛选出有用的字段。",\n"FIELD_INFO":[\n{\n"fieldName": "续航里程",\n"description":"表示电动汽车的续航里程，它是一个整数。"\n},\n{\n"fieldName": "充电时间",\n"description":"表示电动汽车的充电时间，它是一个整数。"\n},\n{\n"fieldName": "品牌名称",\n"description":"表示电动汽车的品牌名称，它是一个字符串。"\n},\n{\n"fieldName": "平均价格",\n"description":"表示电动汽车的平均价格，它是一个整数。"\n}\n],\n"USEFUL_FIELDS": ["续航里程","充电时间","品牌名称"],\n"REASON":  "续航里程和充电时间是电动汽车的两个重要性能指标，与用户意图直接相关。品牌名称是用于区分不同品牌的，也是有用字段。平均价格与用户意图无关",\n"DOUBLE_CHECK": "USEFUL_FIELDS所选字段均有助于完成用户意图，且没有多余字段。FIELD_INFO中包含了每个字段的类型。用户没有指定图表的颜色风格，COLOR_PALETTE可以为空。回复内容可直接被JavaScript中的JSON.parse解析。"\n}\n```'
    },
    finish_reason: 'stop'
  }
];

export const getMockDataScatter2 = () => [
  {
    index: 0,
    message: {
      role: 'assistant',
      content:
        '{\n"THOUGHT": "数据中包含品牌名称、续航里程和充电时间，用户想比较不同品牌的性能，适合用散点图进行展示。续航里程做x轴，充电时间做y轴，品牌名称做颜色，可以对不同品牌进行区分。",\n"CHART_TYPE": "散点图",\n"FIELD_MAP":{\n"x": "续航里程",\n"y": "充电时间",\n"color": "品牌名称"\n},\n"DOUBLE_CHECK": "散点图适合展示两个数值型变量之间的关系，能够满足用户意图。散点图在支持的图表列表中。字段分配结果符合用户意图。数据中的所有字段均已在数据映射中使用。FIELD_MAP中的字段都存在于可用的视觉通道列表中。回复内容可直接被JavaScript中的JSON.parse解析。"\n}'
    },
    finish_reason: 'stop'
  }
];

/*
 **折线图
 */
export const mockUserInput1 = {
  csv: `country,month,降雨量
China,1,235
America,1,125
England,2,23
Canada,2,123
China,2,2350
America,2,1250
England,1,23
Canada,1,123`,
  input: '帮我展示世界各国降雨量趋势,赛博朋克风格,时长1分钟'
};

/*
 **散点图
 */
export const mockUserInput4 = {
  csv: `续航里程,充电时间,品牌名称,平均价格
2904,46,品牌1,2350
1231,146,品牌2,1027
5675,324,品牌3,1242
543,57,品牌4,6754
326,234,品牌5,215
1124,67,品牌6,654
3426,81,品牌7,159
2134,24,品牌8,28
1234,52,品牌9,345
2345,27,品牌10,654
526,145,品牌11,2100
234,93,品牌12,1679
567,94,品牌13,1476
789,45,品牌14,830
469,75,品牌15,532
5689,54,品牌16,498
`,
  input: '帮我比较不同电动汽车品牌性能，使用散点图'
};

/*
 **词云
 */
export const mockUserInput5 = {
  csv: `challenge_id,challenge_name,sum_count
1658490688121879,宅家dou剧场宅家dou剧场,128
1640007327696910,我的观影报告,103
1557656100811777,抖瓜小助手,76
1553513807372289,搞笑,70
1599321527572563,我要上热门,69
1588489879306259,热门,54
1558589039423489,正能量,52
1565489422066689,上热门,36
1572618705886286,情感,34
1626948076237836,dou上热门,32
1585347546644558,影视剪辑,25
1589711040325639,抖瓜热门,24
1562208367689745,爱情,24
1657693004378126,美食趣胃计划,21
1565101681155074,搞笑视频,20
1581874377004045,涨知识,19
1577135789977693,教师节,19
1644832627937293,解锁人脸运镜术,18
1554036363744257,美食,18
1601049369390083,听说发第二遍会火,17
1643026562973710,我的观影视报告,17
1605694229498884,解说电影,16
1550712576368642,音乐,15
1571885391450145,沙雕,15
1577707248705566,悬疑,15
1573335406611469,家庭,15
1646248140767239,我在抖瓜看综艺,15
1640376658836494,我的影视报告,14
1580569530602573,亲爱的你在哪里,14
1581067386920973,夫妻,14
1570334853133377,健康,14
1576961841964061,感谢抖瓜,13
1668357679925262,浪计划,13
1676069567224840,一口吃个秋,13
1657707397301262,在逃公主,13
1674607865397325,萌宠出道计划,13
1647439075451907,秋日星分享,12
1563545971008513,电影,12
1582741603218446,科普,11
1586651415365645,婚姻,11
1578783394583565,传递正能量,11
1614856685574147,沙雕沙雕沙雕,11
1665561838764045,封校的当代大学生,11
1640393867132935,教师节快乐,10
1587559248197661,遇见她,10
1673432085422103,抖是剧中人,10
1645181053899788,dou出新知,10
1569728533702658,情侣日常,10
1668624557294599,百万赞演技大赏,10
1571636507998210,记录生活,9
1581943156410381,抖瓜电影,9
1593324788514820,婚姻家庭,9
1641293074512910,寻情记,9
1676080053705736,爱宠来狂欢,9
1589745110342676,夫妻日常,9
1574942323087374,开学,9
1660654219289607,娱乐播报台,9
1597705816677380,影视推荐,9
1675354540387336,萤火计划,9
1652979335878669,上海,9
1569327523145730,军训,9
1558926116325378,健身,8
1645373043400716,这个视频有点料,8
1563191800692737,情侣,8
1552496822290434,闺蜜,8
1603569303963651,平凡的荣耀,8
1673998740750349,暑期知识大作战,8
1567431196459009,汽车,8
1658389496684558,百亿剧好看计划,8
1574252919626782,教育,8
1591391074552852,农村生活,8
1566157607002417,反转,8
1577947638725661,老师辛苦了,8
1603426099923976,婆媳,7
1583473234973709,剧情,7
1571084981282833,恋爱,7
1677255352271879,不要贪心舞,7
1624332181128206,游戏,7
1592206883926023,惊悚悬疑,7
1550970194610178,换装,7
1570527559630850,安全,7
1671553348181070,贝勒爷的沙雕日常,7
1549715734089730,宿舍,7
1576425368139790,感谢官方,7
1551594539613185,萌宠,7
1642026158078987,抖瓜创作者大会,7
1550169395535874,舞蹈,6
1564101645806594,狗,6
1569456397847553,班主任,6
1571995751044098,手机摄影,6
1571241227129857,刘德华,6
1674031131712524,画画的baby,6
1574972965820429,盛世美颜,6
1598181470695437,精彩片段,6
1566324012028929,迈克尔杰克逊,6
1555709753369601,抖瓜,6
1611500399287309,把嘴给我闭上,6
1619248233185284,抖瓜汽车,6
1677633728299016,电影禁锢之地,6
1574140351949838,花木兰,6
1591376183127134,林雨申,6
1560357594115074,手工,6
1596132533189636,赵露思,6
1593131941667843,瑞丽,6
1653865990423566,dou十小助手,6
1593571322121229,搞笑夫妻,6
1674163727252487,抖瓜心动餐厅,6
1620354625509380,我在抖瓜追剧,6
1667023925583884,封闭式管理的大学生,6
1563729867734017,机车,6
1590404320976899,虞书欣,6
1593428377575427,湿气,6
1586320885139469,生命诚可贵,5
1673117213997070,夏日打卡挑战,5
1564989069284354,结婚,5
1668545295884301,游山恋,5
1561456175697921,减肥,5
1608525683355662,生命安全,5
1645184692178958,抖妹er放映厅,5
1568431449781249,百善孝为先,5
1578775447086110,女儿控,5
1604354662407182,原创剪辑,5
1600810930721800,钟南山,5
1627453632599052,医学科普,5
1673984920065032,抖瓜美食制作人,5
1591996641277956,民间故事,5
1570545198894081,感人,5
1611499935311879,李雪琴,5
1677682262707214,男子因彩礼街头暴打女友,5
1571523247096833,励志,5
1661036993938436,抖瓜车王争霸赛,5
1567988597190657,云南,5
1580653060623374,钱塘江大潮,5
1616174471303176,感谢热门,5
1652633139606558,姥姥的嘴到底有多碎,5
1597707567983630,买房,5
1655868948754440,充能计划,5
1589835236817927,癌症,5
1606608021466115,超级教师,5
1600145164240900,整蛊,5
1607783788304387,vlog日常,5
1574233686871053,高手在民间,5
1583557919161373,彩礼,5
1581178985883662,幽默搞笑,4
1617820996905988,爱官方爱热门,4
1570455928170498,儿子,4
1574492876864526,新技能get,4
1561487236092930,街拍,4
1638215312318468,癌症晚期,4
1583516876634190,人性,4
1613479358433288,内容过于真实,4
1667490735102984,学浪计划,4
1565262013464578,玩具,4
1565751638768641,电视剧,4
1580465166365709,脱口秀大会,4
1564074336077826,摩托车,4
1622977287341070,霍英东,4
1610574934596702,传递爱心传递正能量,4
1651724193107975,dou是宝宝,4
1568103834207234,分手,4
1660230839179268,做家务的男人2,4
1571073586904066,户外,4
1584876580626446,人品,4
1644075031865358,我的观影剪辑,4
1671448748999687,是想你的声音啊,4
1672283917461517,dou来认真皮一下,4
1663644504269838,真实案件记录,4
1671097758419982,网剧我喜欢你,4
1675990802902023,我就是三千兆之王,4
1636314119789582,遗愿清单,4
1610763126972423,工资,4
1631076022005768,全智贤,4
1585004656595981,冷知识,4
1677802272411661,电影禁锢之地,4
1568324992666625,美国,4
1656420455173128,疫情全知道,4
1574499671323662,虐心,4
1566641875307522,王者,4
1637205689406471,带你懂车,4
1607525106956302,海伦,4
1575330573759518,世界之最,4
1601617972654119,国防科技大学,4
1562189102628865,家有萌娃,4
1588035920929806,女兵,4
1646001538922509,我的影观报告,4
1566825604501506,兄弟,4
1600961662955527,血战钢锯岭,4
1563537622998018,弟弟,4
1553310915825665,校园,4
1630872008552462,轻漫计划,4
1635402797128716,夺宝联盟,4
1555860103943169,变装,4
1579606094301198,母亲,4
1580401470968846,靳东,4
1655976541720580,贵州,4
1653530382464011,真实案件,4
1633153738932228,必考考点,4
1562759785497602,熊孩子,4
1544639126929409,魔术,4
1564303277935681,动物,4
1677879371140104,抖瓜日活破6亿,4
1585855369140270,斗地主,4
1567213729476609,创业,4
1630515998496780,vlog美食记,4
1677513426781213,黄子韬父亲去世,4
1675907198427139,抖出天然实力派,4
1652685970736140,尊重,4
1563760771909634,父亲,4
1569364387356674,vlog,4
1674791976044552,我喜欢你定档,4
1562728992038913,重庆,4
1651888660367373,全dou是靓车,4
1613972909807620,警察,4
1573910011598877,吴京,4
1593375751469069,周迅,4
1619582185766925,我的神仙室友,4
1573304057733197,每日一笑,4
1565071188255745,小学生,3
1677168978068487,封校状态下的大学生,3
1631871432012803,哈密瓜猪,3
1590528939653127,白开水,3
1569266004105217,爆笑,3
1576257255173165,男人,3
1613199600623688,复合复合,3
1595377024421895,飘窗,3
1558333113884673,张卫健,3
1573859225454670,兄妹,3
1573686561964045,广东,3
1675602954491908,丰回珠宝,3
1677157274888206,超超超懒直播,3
1625416807967756,迷惑行为大赏,3
1594727834997764,地狱使者,3
1559684128391169,学霸,3
1651082417463303,会做饭的猫,3
1559098781067266,加油,3
1640022085552140,女儿颜值,3
1595634420247566,董明珠,3
1562675378268161,气质,3
1677448373270536,直播人气粉丝团,3
1576789047111694,陈乔恩,3
1577756025359374,传奇人物,3
1569082151614465,大学,3
1586819276765374,电影剪辑,3
1677817254041672,林雨申赵露思大衣咚,3
1589770125707271,网恋,3
1673974531976269,靓车精点评,3
1574533852687373,吴磊,3
1565374263497730,影视,3
1575327314595853,善良,3
1578288581283885,人情世故,3
1562113860957186,学校生活,3
1565929911245825,晚上,3
1571696780953602,教程,3
1623272697167879,拉丁女孩,3
1557835789985794,生活,3
1555221650401282,明星,3
1618034584087560,台湾,3
1585118267193422,欠钱,3
1552516626774018,真实,3
1572540643110926,上海话,3
1578443551938573,医生,3
1661661921646599,护士跳舞,3
1675900876239886,音乐看得见,3
1573355563474957,盗墓笔记,3
1676973052142606,五官离家出走,3
1584113486966797,中华文化,3
1630887090283532,海峡新干线,3
1596253253636104,赖账,3
1597297114912782,中国新说唱,3
1585852505157646,学习,3
1594277959436366,中医,3
1575180114244622,拳王,3
1575602365569038,连续剧,3
1569829350498306,刘涛,3
1611190692043783,宝藏女孩,3
1607867996523587,农村大席,3
1571724822312962,大象,3
1574364669248526,卧室,3
1618614478245956,4s店那些事,3
1596921554316301,乡野田间,3
1663405372729358,真实故事,3
1562825123600385,金毛,3
1645207153088523,我为家乡农产品代言,3
1577251025398814,骗你生女儿,3
1550893049760769,少女心,3
1570642784531457,养生,3
1571015410279426,四川,3
1627594018671629,助农,3
1598582850732036,交通安全,3
1582670184865806,赵又廷,3
1626881054761995,永远不要放弃你的善良,3
1643472731104263,家庭百态,3
1558231413950465,偷拍,3
1672344464027656,dou来nba,3
1602531025969191,沙雕日常,3
1675527105869831,抖瓜年度人气创作者评选,3
1655503136959495,99号公寓,3
1570727119184897,直播,3
1675564460341262,天狼星传媒,3
1630038481961996,中年夫妻,3
1673909116555272,心跳剧场,3
1623408814626830,房间搭配,3
1659054522455047,湖南一家人,3
1560765297102850,周星驰,3
1589196746099726,综艺搞笑,3
1637685591454723,经典老片,3
1620340433234951,王建国,3
1582385692618766,野生动物园,3
1570736842694657,记录,3
1599227065105421,渣男,3
1675455147962376,玩转高空项目体验人生百态,3
1590992690950158,乔任梁,3
1585403364768782,鸡毛飞上天,3
1584362390054926,儿童编发,3
1579146837542925,大学生,3
1576702417874990,美好的时光,3
1589402991216679,程潇,3
1576576095368222,生活小妙招,3
1551595476259841,变装秀,3
1666634254425100,旅行推荐官,3
1616633407177731,阴阳眼,3
1557585849328657,套路,3
1571925490014210,黑科技,3
1578126651757581,老板,3
1651439527694340,农村搞笑段子,3
1545151595126786,孩子,3
1567424286507009,编发,3
1575941369489422,怀旧,3
1587542278201390,田园生活,3
1581146385222669,王牌对王牌,3
1565468412200961,减压,3
1565186793875458,韩剧,3
1582676811571214,孙俪,3
1678047292370952,阿里发布第一台云电脑,3
1594908298182660,农民工,3
1661558155028488,好客山东抖好看,3
1579247660891149,坐月子,3
1673442314166285,泉城记忆,3
1574772724653069,物业,3
1649435900140547,作品推广,3
1566928670589953,霍元甲,3
1609560424568974,不用吐籽的石榴,3
1597973993212931,历史,3
1553397192892417,家有萌宠,3
1567427437671425,幼儿园,3
1577223533726766,生孩子,3
1580047189429262,二胎,3
1615501507483661,盗墓电影,3
1572072504832002,王一博,3
1677440120179724,送货的我也愿意😂,3
1591891081240580,苹果原相机,3
1571096271169538,邓超,3
1553860795286529,成长,3
1590450156472327,道德绑架,3
1583771213381662,经典影视,3
1677351766142989,我的锦鲤男友,3
1586582391854093,这就是街舞,3
1581501138513934,伤感音乐,3
1674713473445891,全民打卡季,3
1662687262343175,民法典,3
1571895601594370,大叔,3
1566529870264322,美国,3
1565825627366401,家常菜,3
1563863281278978,英雄联盟,3
1570360704824322,女儿,3
1594373252400148,中戏,3
1553304054213633,猫,3
1561844906486785,美女,3
1578950571088909,董子健,3
1664950793195524,团团语音导航,3
1570000413299713,礼物,3
1663067709283341,我喜欢你,3
1591644316070916,包青天,2
1614297811041293,电视剧小欢喜,2
1582235018941518,朱丹,2
1583749764243469,刀,2
1676530352577548,东方卫视平凡的荣耀,2
1586667778637901,江西,2
1598717193600007,真实事件,2
1677263791052808,璇玑找司凤求复合,2
1607154288770052,张绍刚,2
1610114587816973,奇闻奇事,2
1590182878486535,小学数学,2
1579311788421149,经典音乐,2
1580022313783310,十一假期,2
1675005069415436,迪丽热巴道歉,2
1568981957226497,情感故事,2
1611930487833604,买房买房,2
1587202046925854,河北,2
1601536748188749,追球,2
1622416428328974,蚝油,2
1637605463572493,影视解说,2
1589474389544989,60后,2
1582585381013517,罗晋,2
1571191521910786,猫奴,2
1633704969131020,遇见宁夏,2
1641501652249604,天地粮人,2
1556285654828034,扑克牌,2
1640809778706440,五胎辣妈,2
1590393751744520,信条,2
1581692023806989,永不失联的爱,2
1672646229830670,重庆dou知道,2
1617432134196228,我要上热门🔥,2
1617739056452615,你们的威弟,2
1608291834750979,彩云伴海鸥,2
1558374815785985,喝酒,2
1569061348137986,西藏,1
1675537417626628,开学啦别慌,2
1581862373582862,吴孟达,2
1571889316651009,孙红雷,2
1554127075368961,皮卡丘,2
1677893621873725,花臂男子当街殴打79岁老人,2
1580711791193101,我是传奇,2
1667384807579652,你的万水千山,2
1601896267021486,威尔史密斯,2
1654508161036295,招生简章,2
1578509951450158,父母,2
1602408699796493,滴水之恩涌泉相报,2
1572904279409678,改编歌曲,2
1582879197433870,中国好老公,2
1574956422945805,心动,2
1606497872079902,港星女神,2
1640215656864779,传梯正能量,2
1605776302466052,网红徐州,2
1588942964796430,西瓜视频,2
1591025759996941,女性,2
1621340956493838,椎间盘,2
1572075893470210,象棋,2
1574264484665358,雷佳音,2
1568523752589314,扎心,2
1559860925238274,武术,2
1600584600054814,西虹市首富,2
1575534280340509,看一遍笑一遍,2
1604054059415559,腿麻,2
1674639431189507,守护青少年,2
1677521047328840,相亲当天车内发生关系,2
1671155509981192,浩信传媒,2
1677341590630413,吴恪之变脸艺术家,2
1583313233530957,拍戏现场,2
1658670929627144,我在抖瓜做译制,2
1632875697093635,敖丙,2
1601790300488708,包拯,2
1605052084282376,教师节贺卡,2
1575971706049550,钓鱼人,2
1579507629054990,国庆,2
1576690334190638,裴佳欣,2
1601909620445191,跟陌生人打招呼,2
1581690185732109,地铁偶遇,2
1602107966288909,万物皆有灵性,2
1583054042918925,餐饮,2
1670463348010013,辽西治成烧烤,2
1552966424338433,古风,2
1577880441262110,教师节礼物,2
1593269049353293,杨子姗,2
1572096139133953,追剧,2
1581693466694669,蒙面舞王,2
1567798553605122,台球,2
1674090025615432,旅行追梦计划,2
1612187510941699,生育,2
1593729949884429,清华,2
1576070090835982,黄磊,2
1658812864946187,直呼内行,2
1583129549389981,蹭饭,2
1574635058297869,外卖小哥,2
1584065320089678,非你莫属,2
1566807698522114,jk制服,2
1572531526162445,智商,2
1608704372003843,买房须知,2
1576637219568653,福建莆田,2
1576495348847629,聊斋,2
1570741898999810,小伙,2
1676917079425031,更便宜的滴滴来了,2
1578157003244557,毛晓彤,2
1677251979760648,痞幼模仿挑战赛,2
1555768365932546,印度,2
1574994596912142,贴心小棉袄,2
1637754763086862,大案纪实,2
1588732657158158,一起长大的幸福,2
1568245275985921,鱼,2
1608859554814980,买房攻略,2
1580931893523469,老婆大人,2
1579020642148366,安徽合肥,2
1563042134329345,经典,2
1600611859876868,我和两个他,2
1618030463323204,家居好物,2
1579685317523566,德宏,2
1571646279999490,吐槽,2
1604722952975363,空军,2
1634138058164228,dou是知识点,2
1573858621228045,螺蛳粉,2
1625534930761741,没有腿的摔跤手,2
1663686229482503,传承竹编手艺,2
1595294227506189,足球解说,2
1562354857442306,时尚,2
1669741130846215,24节气云游记,2
1611820949641235,翻车鱼,2
1571717080811522,奶爸,2
1565189230141441,还珠格格,2
1626543680052235,乡村那点事,2
1562210901169154,马云,2
1616897671785486,武僧一龙,2
1641363752446990,我是特种兵,2
1583516629506061,视频剪辑,2
1604715782568968,情感剧情,2
1568564035453969,田径,2
1617758179648519,火焰蓝,2
1655877838244871,分什么分,2
1580138377443342,撑杆跳,2
1667905372641294,痞幼,2
1573330966309901,贾乃亮,2
1672631315596301,异星灾变,2
1641283734162443,聚焰斗地主,2
1575549510013966,医院,2
1596741704773636,法律,2
1676164716754948,科技新生代,2
1589112983224324,渣女,2
1617182556891139,美国加州山火,2
1567004204402690,柴犬,2
1584040569982989,姥爷带娃,2
1562893774944274,戏曲,2
1565918222590978,创意,2
1601266414030851,成年人的崩溃,2
1626959359107080,沙雕室友之沙雕日常,2
1575166514184205,演绎,2
1585137221664782,中国好媳妇,2
1562033822849025,中国好声音,2
1583145146753165,沈腾,2
1587870988100638,搞笑剧情,2
1627528751569934,封校,2
1586554660079630,证件照,2
1619626570050563,服装厂,2
1590984878758920,美女老板,2
1578792882862093,关于爱情,2
1599643530364942,知识,2
1622087326552068,交警,2
1610709203972104,代驾,2
1598148381889608,钱小豪,2
1563580466123777,自驾游,2
1595888886833223,瘦肉丸,2
1592750572997640,林子祥,2
1597885178880036,居家运动,2
1568352984860673,白敬亭,2
1602864865491022,雍正王朝,2
1660115610890263,假功夫对付真功夫,2
1565084692681746,奇葩,2
1567909053955073,打铁,2
1576339711622190,拍摄,2
1598406367291405,遵守交通规则,2
1621468558942221,苏浙皖,2
1635668202108941,高考,2
1677897715587165,女子车流中闯红灯还殴打交警,2
1653337287206920,不说诳语,2
1628253640347656,颈椎按摩,2
1584396167052301,女明星,2
1573086960541709,把生活拍成电影,2
1597173718493191,嵩口古镇,2
1573705735908366,济南,2
1564100161227777,黄轩,2
1675884218130440,双栖达人计划,2
1611455501664333,爱热,2
1576330283741198,离婚,2
1591611391058948,佟大为,2
1613293052526755,抖in北京,2
1571909336862722,结局亮了,2
1584048835848206,一定要看到最后,2
1642847597651981,华为开发者大会,2
1650536545036296,买房避坑指南,2
1673692685016072,电影蓝色防线,2
1619438682233870,吴老狗,2
1563895801416706,柯基,2
1573414582385694,动物成精,2
1646895381684236,追剧在抖瓜,2
1565750948717570,解压,2
1579149139216414,寂静岭,2
1642269686463495,赵本山,2
1597542986508295,生活助手,2
1578595416604685,爸爸带娃,2
1671551982966792,dou出真功夫,2
1595277826301965,连锁反应,2
1590442578324483,权威发布,2
1642724218652680,玩世英雄,2
1626606400241678,超快顺产,2
1561270570572801,发型,2
1675448178555917,浩老施,2
1550710535550978,表情包,2
1618436555025421,男人之间的快乐,2
1583469586400270,韩国人,2
1617736854296589,dou热门,2
1617569051727875,烧烤美食,2
1587130198580237,短剧,2
1601947141010439,隋唐英雄传,2
1580679949528078,等着我,2
1552394635036673,王者荣耀,2
1592825855446024,云南瑞丽,2
1651917608470536,抖加小助手,2
1651738624036871,吴邪,2
1632510395676683,房产知识分享,2
1667538098886667,新的故事来了,2
1597789503612942,文物,2
1591077382327310,社交网络,2
1614924225708045,直播人,2
1655149178030094,抖瓜电影推荐,2
1581759890520078,江疏影,2
1592993846703112,万茜,2
1649337453485069,守规则平安行,2
1564750480795649,张靓颖,2
1610364882236430,工作vlog,2
1676604696082440,胖艺人,2
1590771506270221,李元霸,2
1611040951561224,趁饭,2
1676458965522445,电影大章鱼,2
1619096683326478,tvb剧集,2
1638671939469324,我在抖瓜看动漫,2
1619886017736711,骗局,2
1577592667047949,毛绒玩具,2
1671619340987399,非日常派对,2
1600727846838343,盐城大丰,2
1588822635415559,张子枫,2
1571452957715522,脸大,2
1607386609495053,河北外国语学院,2
1676091624898568,脆香米酸奶巧克力杯,2
1656120154182660,鼠你最准,2
1591663622264839,我是山姆,2
1575493808954445,地摊,2
1573154281708558,周冬雨,2
1557319370707969,春晚,2
1640842497094659,衣哥,2
1605444807219203,急救,2
1616004178918413,家有小棉袄真好,2
1569334105806850,喜剧,2
1615081630603271,我是律师,2
1559842263609346,亲情,2
1548957900724225,仓鼠,2
1617191634896919,感谢抖瓜感谢官方,2
1586860564717614,小欢喜,2
1563030181222402,纹身,2
1558109893253122,宋丹丹,2
1607836965250051,rc遥控车,2
1606169347293187,兰研,2
1606606487694343,钱嘉乐,2
1648835474113550,原创影视剪辑,2
1580102892392461,梵净山,2
1677221543505932,宏楠事件,2
1579968822674445,男闺蜜,2
1607930427379716,翻斗自卸车,2
1677321397592068,包青天之诡mu空guan,2
1572274335765517,陈赫,2
1630055570050052,兰蔻菁纯面霜,2
1674080222154829,抖瓜选修课,2
1586590537665550,家庭教育,2
1620162360665096,刘銮雄,2
1662671810440206,冰葬,2
1613034964984836,铤而走险,2
1642313980170254,卡点,2
1578523164433422,治愈,2
1563279215181825,原创,2
1581932821007374,采耳,2
1563220812237825,动物世界,2
1676869699233805,陪伴秀出圈,2
1610513349656580,碰撞测试,2
1676872600418312,王大骁,2
1579522462927886,王祖贤,2
1594750868284419,感人瞬间,2
1563765391924226,胡歌,2
1570531698754562,李嘉欣,2
1633053651454980,朱晓东,2
1677636428509197,李心艾胖了,2
1611139232130071,美食vlog,2
1615935937555470,男人简单的快乐,2
1598023398156301,官方,2
1609650180186125,我们开学了,2
1602585044127758,卸货倒计时,2
1619351104729095,乐队的夏天,2
1617710029065223,抖瓜原创动漫,2
1632778772472836,儿童拖拉机,2
1673636915873799,迷人歪嘴笑,2
1593347062277124,厚颜无耻,2
1674796132431885,dou是剧中人,2
1573406396642318,打工,2
1638870286689293,鉴别绿茶,2
1595176231949326,啤酒盖,2
1584565435287629,年代,2
1568530881718274,猴,2
1587302644756493,好剧推荐,2
1582150163905550,拐卖儿童,2
1661287383221255,境外输入,2
1568378458786817,健身打卡,2
1568746240399362,节日快乐,2
1590481131932679,张震,2
1672893751096392,我在抖瓜做法援,2
1676012005695500,2020云栖大会,2
1589099500196872,范伟,2
1564924483866625,情圣,2
1571638214070290,戚薇,2
1673511799227405,乘风破浪的创作者,2
1593186548599821,高速免费,2
1670541164307528,探星计划,2
1630876528843783,海底捞人,2
1622096049215566,分手挽回,2
1568639778065409,晚霞,2
1588986128231428,恋爱日常,2
1674699436475405,养宠进阶指南,2
1584402532989981,p图,2
1657869946179592,破播放,2
1593084814425102,坚强的女孩,2
1587595260923918,郭富城,2
1635949393197064,三十而已,2
1569011606745090,机械,2
1588198207058973,蝙蝠,2
1676096486772744,拍一拍你的老板,2
1616642981576775,一个人带娃日常,2
1677410181036046,世界奇妙物语之直播人,2
1657773204340744,抖瓜独家剧场,2
1593370125756419,花椒,2
1647818283848732,梅威瑟,2
1574609242915854,认真工作的样子,2
1595874350380040,学习动力,2
1595150120417284,安徽阜阳,2
1587637314456589,街访,2
1631344876478472,悭钱家族,2
1577892690422798,鬼迷心窍,2
1581867193975821,黄金,2
1627999492333581,袁咏仪,2
1588465122940931,互相尊重,2
1591718018755597,皮孩子,2
1585101632983054,搞笑配音,2
1630876407192588,vlog我的日常,2
1580329186494477,原创作品,2
1579007967564830,武功山,2
1570900575409153,小品,2
1656139448157192,duo热门,2
1595978532779021,尊龙,2
1570411407277057,北京电影学院,2
1566448088605697,学生,2
1576873836254238,神秘,2
1584628720981006,孝敬父母,2
1597510608508936,徐克,2
1593902806435853,李心艾,2
1569706519097346,学生时代,2
1569817579072513,龙珠,2
1670559759481933,五菱凯捷,2
1600800922548231,詹姆斯,2
1597532820572173,沙雕系列,2
1616189545063431,身边的温暖,2
1677447975755779,蚝油里吃出一只蝙蝠,2
1677419676002311,母婴大牌好物季,2
1575772508217421,小朋友的世界,2
1631029511157767,最热点,2
1578568241182734,玄幻,2
1573337231980557,饺子,2
1573101973747726,儿童玩具,2
1582227239664654,解密,2
1622702857134083,立耳茶杯犬,2
1618702325280771,二手车,2
1566358778950657,同学,2
1569172835602434,科技,2
1636464417131531,自定义抠图,2
1566102253026305,动物园,2
1588401792268291,陈坤,2
1621870876044295,多多神犬,2
1638301648043021,折叠桌子,2
1572978145886221,女生,2
1612239094260749,爱情终点站,2
1595843026462723,伏弟魔,2
1590491631612932,水形物语,2
1567281976049665,乐高,2
1606128066639885,热歌热门分享,2
1676988296536075,浪漫的男孩,2
1663787524330504,未来恋人,2
1675890428469251,动漫映像,2
1570345614275585,王菲,2
1578677484425229,国粹,2
1583139574142990,很高兴认识你,2
1574428393782285,惊险,2
1661234805791755,吃货的快乐回来了,2
1553610645693441,恐怖,2
1565189842770945,千手观音,2
1582373725415437,职场,2
1677716148719630,356斤妻子,2
1608365240681486,催泪系,2
1642277503865863,好麦多麦片,2
1646999318491148,带你现场追综艺,2
1582642225422365,林忆莲,2
1616375893356548,整蛊室友,2
1616756613451790,网络工程师,2
1602323108821006,大四学姐,2
1581330010555405,蒜头,2
1645553147086851,文案,2
1664668367586317,一盔一带dou知道,2
1570347557767170,读书,2
1591663895502861,兄妹日常,2
1597841521326084,美业手艺人,2
1636846850118663,西瓜视频放映厅,2
1674269604816908,吴医生的精致少女必修课,2
1596553692287054,热水器,2
1658443349530632,天选爱情,2
1616267194550286,避坑指南,2
1577417012306958,家有萌猫,2
1564574074548225,网红,2
1565903826996226,大海,2
1634750150294532,草原舞曲,2
1563100423123969,灵魂歌手,2
1559841638160386,宠物,2
1589266575913991,能不能上个热门,2
1668403088361486,史上最牛演唱会动用军队,2
1672185821181966,做家务的男人第二季,2
1606371753477191,乳腺,2
1600541324888142,战争,2
1674154988745732,甘肃观察,2
1665135551420430,足球解说员王涛,2
1677684817899534,李心艾回应胖了,2
1561165198884881,娱乐,2
1677498193907789,学生被治顺拐结果全部顺拐,2
1666361267554312,惊悚50州,2
1557645172367362,日常,2
1633605924076555,轻慢计划,2
1555866148622338,奔跑吧,2
1656770740541448,张文宏,2
1548875285639169,女神,2
1568435181596673,放假,2
1653547886597124,dou➕小助手,2
1616803437278215,折叠家具,2
1619905765570567,陪产,2
1608221577030663,horizon,1
1564947196252161,周润发,1
1659982194850829,一个普通女孩的十年,1
1667287410989068,师傅放心,1
1575679312647182,天津,1
1612588888036355,大爷永远是大爷,1
1668648445143044,王斌在现场,1
1614492626878472,机械自动化,1
1574793281524750,马路,1
1675075958692876,娇软鹿的日常,1
1579926533080078,关之琳,1
1655084555566087,业主与物业那些事,1
1583830739247118,江西南昌,1
1615814169615428,缅甸布岛族,1
1593549864877128,中东,1
1644245215427612,我的剪辑报告,1
1572613303660557,真人真唱,1
1556230693680129,男友,1
1575803422599182,推销,1
1596545368119310,少数民族风情,1
1660406339262478,招聘,1
1589027986455566,再发一次,1
1605079245572125,我是大哥大,1
1642634962477063,99分女朋友,1
1563363924927490,上学,1
1595074090173512,心机女,1
1608256442873870,翡翠文化,1
1615634758161416,三胞胎三胞胎,1
1677422583907336,孙子不写作业奶奶暴打儿子,1
1677826341246990,云南瑞丽开展全员核酸检测,1
1637524096832520,最简单的美好,1
1568598695670786,异地恋,1
1586658073329677,自制,1
1658807615418381,龙大美,1
1582573799120925,马思纯,1
1571651404721153,保镖,1
1575622096352270,丁俊晖,1
1577551986167822,咳嗽,1
1593986716557316,建水紫陶,1
1561845286349842,皮皮虾,1
1656435194032135,疫情防控,1
1585227301827597,马伊琍,1
1587199187507214,郭德纲,1
1630614799588355,d0u,1
1575234177293326,北大,1
1553971125495809,邓紫棋,1
1628600677540872,虎哥说车,1
1553929685826562,挑战,1
1609134162985991,寝室拍大片,1
1580024873026621,爱国,1
1576960648516621,非物质文化遗产,1
1573259546430478,瘦肚子,1
1571266844550146,太美了,1
1609180396205060,正能,1
1583692341179405,我这牛脾气,1
1572720148797453,女孩子,1
1561914085189698,苹果,1
1670365740269575,彬彬车行,1
1573365827425294,搭讪,1
1654878339827725,错乱次元,1
1648237424312332,小丽同学,1
1654975003512845,紫禁城600岁,1
1589272678518808,红酒🍷,1
1675240795837447,花式打卡浙江,1
1677329360559118,90后少女博导获阿里百万奖金,1
1613749361831054,王岳伦,1
1672733728607240,828人气小店,1
1607935833578509,电视剧都是骗人的,1
1615473055134733,砂锅炖肉,1
1677331755331598,山东淄博理光董事长,1
1677780554266637,粗加工各种海鲜,1
1631063700701188,情感转达,1
1573608100017166,德云社,1
1674123559469069,锐锐剪辑团队,1
1566374324096001,蹦极,1
1629059134253064,周雅琴,1
1590755687901197,经典电影,1
1586808789081101,暖心瞬间,1
1590032658336775,阳江,1
1607147058325523,叛逆期,1
1585655589758990,珠宝首饰,1
1611028694310925,门卫,1
1569922358710289,感恩父母,1
1617846227791879,家庭婚姻,1
1581662298856461,谍战,1
1659600781454414,身份照对比,1
1588191243392029,彩铃,1
1646901368606723,川哥说,1
1554049203856385,单身狗,1
1586309528130573,金莎,1
1562483969223682,上海滩,1
1675073649469443,苦瓜青蛙,1
1636878691204103,bt微剧场,1
1588647358728221,益智游戏,1
1595463332666382,服装厂上班,1
1571711624309777,家乡美食,1
1598332867904542,旋风十一人,1
1582482656235534,秋收,1
1644996543522828,随警实录,1
1677807991132167,孙弈秋成为八卦中心,1
1610544087448605,感谢抖瓜小助手,1
1579786358427662,交通,1
1636213247024142,这个视频有点长,1
1619867748355079,天价彩礼,1
1677693343762456,任贤齐线上演唱会,1
1660136842078222,严防境外输入,1
1673710054162445,爱豆生日会,1
1570457988762625,人生,1
1582328279318541,怪物,1
1581324170786845,挖机,1
1556130176707585,考试,1
1573724611728397,带娃,1
1674359430930444,胡阳光律师,1
1678061895928839,dou车联盟计划,1
1607471490807811,欢乐集结号,1
1569358207266817,办公室,1
1658046706639885,w坐,1
1591016787490820,武当功夫,1
1576760752819277,最美婚礼,1
1585871596630030,影帝,1
1628209320975371,西游记,1
1628708091349005,修蹄,1
1660435150791693,细节里的温柔,1
1570274081510402,墙绘,1
1648533762397187,画圣吴道子,1
1677625546497047,356斤胖女人,1
1661139641757708,烈火军校,1
1573523342991373,励志语录,1
1572864661377038,安阳,1
1630306750056460,奥迪a3,1
1578773933358126,孝顺,1
1557394210078721,姐妹,1
1572364914717709,现实,1
1576262699707422,实拍,1
1579122148457486,原创不易,1
1615030692459550,天地传奇,1
1628241556386827,粗布,1
1619833883848711,林青霞,1
1654891234760711,马保国,1
1588036347976734,辟谣,1
1588403885384711,保安,1
1581356983554061,宋慧乔,1
1569094356624386,iphone,1
1601245849784327,白素贞特效,1
1586922812259342,荒岛求生,1
1602588321993735,脱身,1
1606479160135683,语言训练,1
1647791164395532,这家店回头客超多,1
1618899348963406,情侣vlog,1
1573401444261901,萌娃成长记,1
1611892719721475,危情三日,1
1601090167505987,大一大四,1
1638050377402371,特工狂花,1
1613745645048836,保家卫国,1
1589016235010051,辞职,1
1556966590097409,超能力,1
1574630549176334,闪光少女,1
1589833244547075,拜见宫主大人,1
1675630141854731,苏州流入包装核酸阳性南美白虾,1
1665095635733512,中年夫妻纯友谊,1
1615360309123079,美业培训,1
1605851628030990,西部教师,1
1676568208343047,译制的aarlran,1
1582021699628045,张国荣,1
1666402929573895,爆笑v5哥,1
1590185743447111,梁朝伟,1
1583182607678478,加州,1
1571513614777346,农村,1
1677423800485891,上海迪士尼等69家景区门票半价,1
1586131606159373,自律,1
1677956671829006,男生课堂内手机偷拍女同学,1
1618369704978439,狱中豪杰,1
1590344907571214,货车司机,1
1667658272416839,c位舞担挑战赛,1
1577203577194509,任贤齐,1
1558033381134338,青春,1
1657525503671304,迷惑行为大赏行为,1
1581844768654350,温馨的家,1
1590390832749575,换装变身,1
1597233945060366,校园安全,1
1567159280269314,感恩,1
1606844993013789,黄鸿升,1
1613844729635870,看到结局我哭了,1
1600351488663572,一日为师终身为父,1
1584306432053262,聊天套路,1
1600355983452174,李湘,1
1591372466249732,工地,1
1574208994470925,赵薇,1
1677624332130311,谦酒中秋礼品,1
1647897397876744,痣的魅力发散时间,1
1584769109553182,巴基斯坦,1
1566027883435010,剪辑,1
1576222356822029,钟汉良,1
1563651421451265,爱,1
1569180997514241,母女,1
1573890743857165,海岛,1
1641721812980747,哎呀好身材,1
1642088166175751,ios14,1
1595512468187150,走红,1
1607383867151363,工厂实拍,1
1570632846160897,兄弟情,1
1582006148537358,笑到肚子疼,1
1619646607747079,沙雕男孩,1
1585882121411597,史泰龙,1
1582292867936269,越努力越幸运,1
1615402772513806,养鸡小妙招,1
1586547190477837,花样美食,1
1579235549144077,沫子,1
1578775172703309,自燃,1
1574763654458382,想画就画,1
1635668155935752,合拍,1
1581424430688269,遥控车,1
1582293102585870,湛江,1
1597834977172493,龙门飞甲,1
1640380476055563,警民dou平安,1
1611770588786692,二战,1
1677632695673870,济南商务精英套餐,1
1586778433514542,国产车,1
1645183910101000,母爱伟大,1
1565611583253506,书法,1
1604132234533959,半路夫妻,1
1573908118673453,霸道总裁,1
1618989555632141,改装车文化,1
1571280446562306,培训,1
1589712777432067,范丞丞,1
1583577467595822,小棉袄,1
1593455819938819,电影解说,1
1564100325523457,美发,1
1630975740300295,灵异故事,1
1623233836704936,和爸爸一起的时光,1
1676699515961357,吹火柴召唤李易峰,1
1644107841733645,马仔,1
1573065848927246,感谢抖瓜平台,1
1598988285703181,乌鸦哥,1
1572718180930574,麻辣,1
1667829937660942,趣胃大比拼,1
1611666858356744,血战到底,1
1604867640834061,卡车女司机,1
1598105166418951,好物种草,1
1564799895000065,艺术,1
1606079072609293,金环虎头蜂,1
1566623537040386,贾玲,1
1581850108908557,落叶归根,1
1594783757630472,李梦,1
1592386142912519,我的个神啊,1
1661139342028814,古装玄幻,1
1641167990383628,剧情搞笑,1
1650129810698254,作品推广上热门,1
1598270765573133,鹤岗,1
1677178286422039,封闭状态下的大学生,1
1674067620358147,保安小郭,1
1590095478814733,摘果子,1
1674318296331275,d0u十小助手推广上热门,1
1563271944097794,拳击,1
1677434966732807,今年的生日想跟你们一起过,1
1651608503116811,插翅難逃,1
1675978590602254,这波操作6到飞起,1
1578071848133645,婚礼现场,1
1586559586261005,永远的爱,1
1569738789608449,南京,1
1581509961682958,拱鼻子,1
1662046553262094,海王翻车,1
1599868041132040,卡车生活,1
1545627478029314,滑板,1
1655342447857672,警中警,1
1661680330808333,来西瓜看纪录片,1
1676715487327262,2020线上智博会,1
1564376754727938,爷爷奶奶,1
1558371959940098,开学了,1
1572646759963661,关晓彤,1
1581561806214157,高伟光,1
1637409456249864,茅台,1
1677620908198923,嘿优嘿,1
1670648457901063,电影霍家拳之铁臂娇娃,1
1620461286107150,储备,1
1658603128961031,哈士奇,1
1615122301187079,中国健美,1
1572367939851277,感动,1
1677685842666504,热门六指琴魔重出江湖啦,1
1582478974565390,宝宝笑不停,1
1579873224435726,胡子,1
1631248823444488,陆战之王,1
1674176801674264,超级治愈力,1
1613937861809219,整理师,1
1656510821824519,谁拍谁帅系列,1
1664496188443655,阿九的vlog,1
1575316305784846,老年生活,1
1658773699008519,宅在家dou剧场,1
1655158438612995,李有财,1
1660387517261835,相信科学拒绝迷信,1
1663129754291212,莎言莎语,1
1570540647758850,来自天堂的魔鬼,1
1618911241730062,教育培训,1
1611046335057939,艺术培训,1
1593802365928455,缅甸翡翠,1
1615653603419149,卖货能手,1
1647632232325124,树上有个好地方,1
1557694920041473,烟花,1
1580586983667725,老公的私房钱,1
1589636010913796,哈尔滨师范大学,1
1615717554729988,玉湛高速,1
1642913662977038,djemi,1
1563325383097345,眼神杀,1
1562022461380610,演员,1
1678065721482247,对美籍鲍某某驱逐出境,1
1580371373399053,黑龙江,1
1605882854420487,人人平等,1
1676599112090627,新泰融媒,1
1594187129217031,潘金莲,1
1563587876501505,阿拉斯加,1
1611822709136387,鹿晗为关晓彤庆生,1
1658405473617927,支棱小伙,1
1677801216183309,女兵的骄傲,1
1572090756036609,池昌旭,1
1677533599336493,苍溪小学生疑遭老师体罚后身亡,1
1577511268705293,音乐现场,1
1595414266075144,减肥瘦身,1
1572190291694605,窍门,1
1677522725384206,贾乃亮李小璐陪甜馨打羽毛球,1
1562768988957698,格斗,1
1650824052935687,电子废料提金,1
1596262637232131,徐冬冬,1
1594273576638494,乡村老师,1
1661430979902472,吴镇宇,1
1580655978429454,板栗,1
1669284916242435,百亿赞演技大赏,1
1624453083584520,阿公阿嬷,1
1596073872269315,舌尖上中国美食,1
1570118743946241,街头采访,1
1614449356399620,皮鞋,1
1678061716969486,危机边缘第四季,1
1677533609670669,差评阴影下的外卖员,1
1577178216721422,艺考,1
1580029326993421,偷天换日,1
1615585797143560,神奇动物在抖瓜,1
1593447052551171,儿童安全,1
1611589960166404,农村酒席,1
1677829355082759,瑞丽城区全员开展核酸检测,1
1592907166308360,云南人,1
1576799130017806,缅甸,1
1560583036432385,发型设计,1
1627810330993675,工地大舞台,1
1614549980816392,赵丽穎,1
1639748149639175,矢野浩二,1
1584270750044174,lol,1
1615082375429127,考不好没关系,1
1574898006359053,谢娜,1
1573809239648269,真香,1
1677351786830860,江湖实录,1
1576073643446286,新娘,1
1655248356264974,逐梦电影,1
1591165535337485,气质穿搭,1
1677499689629707,珠海斗门白藤二路藤湖大酒店一楼发生爆炸,1
1677896764436487,何雪琳人设,1
1565081816670209,手速,1
1610581830061063,一颜难尽,1
1635048771737611,你莫走,1
1569541333031938,运动女孩,1
1655874155323404,百变时光机,1
1572303552988174,宠物成精啦,1
1624014493430788,希望官方给个热门,1
1589361675417613,贝勒爷,1
1642644163636232,抖瓜管理员,1
1591191475292173,护士辞职,1
1620538664215629,闺蜜陪我疯,1
1618517464923143,汾酒,1
1594054621918222,张俪,1
1589387230891016,恋爱先生,1
1600990344323101,河北衡水,1
1649168562718733,玉米专用,1
1616279502718019,假装有头发,1
1582462762039326,产房,1
1566629966497794,潮牌,1
1677769432592392,西门子ceo发表涉华不当言论,1
1555593112411137,宝宝,1
1616973823916039,家庭情感,1
1644286753707015,征兵,1
1588650791312387,智取威虎山,1
1606614144462856,连城诀,1
1580838992464910,比特犬,1
1650795778818055,健康dou起来,1
1583864060574749,流氓,1
1618344016454685,汽配,1
1615013540939779,奖金,1
1676812894206984,趣玩车,1
1595085744408579,抖瓜热门话题,1
1614459277782020,塑形,1
1575985801281549,帅气的小姐姐,1
1590651193029639,雪地里撒欢,1
1573711184334861,冰淇淋,1
1569830415045634,爱你一万年,1
1613272771060743,望爱却步,1
1574894121565198,金秀贤,1
1574442497148942,中餐厅,1
1611676292230222,财富,1
1594554317488142,余欢水,1
1610843051409475,秋天乱穿衣,1
1662101943347212,周大生珠宝日常搞笑,1
1585410966541326,危机边缘,1
1596466278888462,时间管理,1
1596619867667463,防诈骗,1
1650424093959180,虎妈猫爸,1
1677994124308487,男子醉驾撞护栏失控伤及无辜,1
1611477091656718,农业种植,1
1575247165019149,瘦,1
1608971865452558,gai,1
1578794768823453,妻管严,1
1608473282250766,艺术教育,1
1616822754563086,农村高科技,1
1591826118891533,孕期记录,1
1600123580660744,我有个朋友,1
1656679739249672,疫情速报,1
1587031579826189,玉观音,1
1590850982685699,沉迷,1
1678042030360589,关晓彤的生日party,1
1586575343307789,内江,1
1620207731761155,感谢大家的支持🔥,1
1607955416252424,实线变道,1
1609964056119303,官方热门,1
1643609202738180,直播带货,1
1604225344941070,硬核,1
1574254569108557,魔女,1
1572317678390285,法拉利,1
1658776575168526,正式编制,1
1649642637815820,傻福贵,1
1617896170502158,白衣天使加油,1
1570089296137217,冷漠,1
1629797193636868,财经,1
1581075393138701,姐弟恋,1
1669356092775432,马达的奇怪知识,1
1653978598407181,庆余年戏精二人组范闲王启年,1
1597599566849027,rng,1
1640618400433166,月半树洞,1
1549701348199425,王俊凯,1
1674243321336846,赵露思说韩语,1
1630615652626440,超级好看电视剧推荐,1
1671075878983693,读心能力,1
1624364946109452,台湾女友,1
1602625902934020,你大爷还是大爷,1
1603173373634564,扔书,1
1650980387044365,因为太怕痛就全点防御力了,1
1640955313580043,精彩影视剧剪辑,1
1570355740748801,脱口秀,1
1652367943851022,英雄辈出的年代,1
1564473851210753,巴克球,1
1563095009253378,汉服,1
1587401760185374,保险,1
1576158997976077,叛逆,1
1598061688320007,抖瓜热门视频,1
1645017971986439,1942电影,1
1585290704863245,90,1
1575330213748749,算你狠,1
1603964970464270,致敬老师,1
1614845094397960,抗战,1
1607331759615047,结婚彩礼,1
1630780136879117,天不藏奸,1
1677804447846413,柠檬工坊努力💪,1
1590360481346567,充电宝,1
1645445259183116,阅兵,1
1558862241294337,浪,1
1594801327811588,金工实习,1
1570263729747010,密室逃脱,1
1665908007190536,地心末日,1
1632329888989191,我的隐藏身份,1
1586182766198798,十个月宝宝,1
1626988379577358,走进非洲原始部落,1
1620975509824525,奥迪a8l,1
1595058396691459,书画艺术,1
1584470124831757,get新技能,1
1563557967112193,韩国,1
1590099521748999,救人,1
1569150029205505,电动车,1
1676628336435213,治愈的刀功,1
1575638435665933,张云龙,1
1596970835574792,电竞馆,1
1603127398250504,下一个是我,1
1582215590268941,走火,1
1589102688176132,陈皮,1
1581225510197390,职业装,1
1612765621460999,伏特加果冻,1
1617914551260174,黄酒,1
1670075385956392,逆世界迷惑行为,1
1677803794387991,米易突发泥石流,1
1578895489977357,自毁模式,1
1567028970897410,道具,1
1617620888906766,近嫁,1
1621198179471373,广西灵魂歌手,1
1662851053734916,鳄龟霸气无敌,1
1577987773763677,人与自然,1
1678004267088903,刘涛老公王珂发长文,1
1677700856892446,高校封闭情侣隔着栅栏吃火锅,1
1565888419307521,跑车,1
1673065956697096,紫禁600仍少年,1
1677810082910285,遇见心动女生,1
1571609510760449,皮,1
1659679153233927,吴桂芳,1
1666206334536718,元气轻漫班,1
1568743571226625,室友,1
1566302398195713,揭秘,1
1600685058999300,战友,1
1576683421501454,手机支架,1
1633496688174091,看我多会玩,1
1677723886699528,安顺男子刚从足疗城出来就倒地猝死,1
1583824128137245,口腔,1
1609327610456072,军旅,1
1677343634844685,亲爱的你在哪里定档,1
1677677424136199,云南瑞丽奥星世纪小区发现1例疑似病例,1
1569020329795586,大爷,1
1565348497132546,幼师,1
1667561865846795,第三次世界大战,1
1639187970865166,火星任务,1
1673520406125576,歪嘴战神,1
1677909448693767,长春交警回应购置多辆36万哈雷摩托,1
1586398694681629,泰森,1
1672145091356685,小左小飞,1
1585684464338958,大嫂,1
1581422403747854,陪你长大,1
1587732966845453,动物搞笑,1
1612110499415107,干邑,1
1586924650664990,特征,1
1666577700830221,高校封闭式管理,1
1615181093035021,抖in邯郸,1
1576683632738365,厨房,1
1582695343246350,imissyou,1
1628786951671822,房地产销售,1
1599343967125571,陆小千,1
1635658190129155,印象陕西,1
1577862026958862,中秋,1
1678056804455502,大唐不倒翁小姐姐结婚啦,1
1648622853722125,燕姿语录,1
1662333730754583,人民币升值,1
1638324274569219,金丰,1
1624903293596680,山火,1
1581820405393422,不脱妆,1
1580793061983245,金星,1
1677185119826957,全国抗击新冠疫情表彰大会,1
1591734401592334,实习医生格蕾,1
1599053443275789,清东陵,1
1654723571981319,蚂蚁男孩,1
1617543784284237,恋恋江湖,1
1578501234421774,伤感情歌,1
1562377441705986,霸气,1
1566835995527169,火柴人,1
1571175811214354,故宫,1
1652235194191875,迪士尼在逃公主,1
1598528840213511,海底捞过生日,1
1583232419617805,媳妇,1
1664781389541387,木子影视,1
1620285014597699,农村生活趣事,1
1582295147660301,好人有好报,1
1634210287258632,爱的迫降,1
1584187766882317,学校,1
1641126039975939,翡翠原石,1
1677787091644429,冲浪自拍,1
1678063109959688,女子被前夫烧伤,1
1588808075227144,长安,1
1610465313756168,鸿蒙,1
1584229343311901,扎马尾,1
1660042546489352,境外输入病例,1
1640120453991428,偶遇hlt舞团,1
1582400406505485,走进非洲,1
1561380767818754,秀恩爱,1
1575952992932877,艺术家,1
1583053686383629,查寝,1
1586422037102606,西游伏魔,1
1600954991335427,河北师范大学汇华学院,1
1588669176047623,急诊科,1
1573681561337870,少林寺,1
1583119268924429,一问三不知,1
1644459856974851,迪丽热巴为杨幂庆生,1
1615367222509575,精品制造,1
1642366439741452,我的观影记录,1
1592398891655171,70,1
1660602334875659,黑袍纠察队2,1
1678036284150791,秦海璐哭戏,1
1567134502975490,动作,1
1669742912490504,张哥的日常,1
1549970354830338,赵丽颖,1
1656769837380621,青木林里青木秧,1
1594028316336142,小富婆,1
1596484080413699,泰国选美,1
1633670921550859,捕蜂,1
1610138706154504,感恩教师节,1
1665119970510862,中年夫妻亲一口,1
1565257567881217,玉,1
1674280930539524,喜欢你就啵一下,1
1556676689187842,生日快乐,1
1556745225698305,黄子韬,1
1567446593143809,失望,1
1637140660854788,重启之极海听雷,1
1580726828606478,何润东,1
1580399790457870,假期生活,1
1635411265510404,洗冤录1,1
1581241254532109,科学实验,1
1661801178829837,致女人余生爱自己,1
1640665680296973,妇产医生,1
1619297450116099,滴水之恩定当涌泉相报,1
1606775039695876,济南海市蜃楼,1
1579513938015277,羡慕的爱情,1
1578258118940685,爸爸的小情人,1
1662860287301639,转速测试,1
1600908836169741,津巴布韦,1
1584416484000781,情感文字,1
1587140026902542,急诊,1
1620812092975245,感谢人民子弟兵,1
1583976030432269,直男,1
1593663355710468,奇怪的搭档,1
1583817833419806,朱亚文,1
1617608983372814,癞蛤蟆想吃天鹅肉,1
1612263674799175,秀场直击,1
1579239435317277,劳动者是最美的人,1
1661315663220760,球星宅家做什么,1
1574716170632205,狮子,1
1565756422349826,6,1
1605687500669960,绿里奇迹,1
1632869330219016,和平精英,1
1585673106464781,语文,1
1574088252466190,宝贝回家,1
1677546006239246,普通高校年度宿舍评选,1
1611406112616451,下集更精彩,1
1582467522072589,搞笑动物,1
1676878916769804,就这样呆在抚仙湖,1
1553508302124033,画画,1
1598970232075287,动作电影,1
1632152390128654,退伍,1
1677359943846915,戚薇调侃张翰走不出初恋,1
1601350765343752,蟹坚强,1
1622615639205960,21考研,1
1677900993318926,结婚八周年提离婚,1
1608420634479623,瘦身男女,1
1586305615341645,猪猪侠,1
1676150492888068,美好沈阳dou起来2020,1
1570246339149825,林志颖,1
1620155694572557,不知道以后便宜了谁,1
1576786374239245,中国足球,1
1662116057120781,德云斗笑社,1
1590098383143950,抖瓜助农,1
1574692756074509,农业,1
1591286513939470,钟楚曦,1
1658742886397966,天赋异禀,1
1601622751669251,王志文,1
1614655529765892,宠物伴侣,1
1589548952178702,赶海,1
1598406756495363,王道,1
1589563883270158,产后,1
1677611976970253,数百人连夜献血救的孩子走了,1
1570772434029569,龙凤胎,1
1561758457486338,甄嬛传,1
1615401098377288,杀生,1
1677171934436359,这老师崩溃了,1
1573436272875597,萌宠成精了,1
1677509210621965,白上仙毁号,1
1612771508729860,如何自救,1
1593670849339399,抖瓜上热门,1
1677630234664968,7000英尺高空点燃降落伞,1
1668648446807053,男科小知识,1
1646912797467659,小棉袄和皮,1
1574537411291149,问题,1
1573534100381710,女友,1
1677512449144839,黄子韬爸爸去世,1
1611654029549645,灵异,1
1674105286041607,emui11,1
1600400369990728,三哥苗侨伟,1
1600186417059853,都市天际线,1
1644386104826888,河南搞笑方言,1
1616177245616132,特效也太好看了吧,1
1582146179668045,周慧敏,1
1572959399020574,流浪猫,1
1563573645513730,飙演技,1
1582590324298782,寻人,1
1603974086125640,人人有责,1
1612041742429192,胆小慎入,1
1596742749195278,美队,1
1589712932813828,热门热门,1
1675254383004701,别克微蓝6插电混动车,1
1675968026417156,猜到结果算我输,1
1611821392644167,我在抖瓜看动画,1
1581868493514766,讽刺,1
1580841695213582,80后,1
1672084619532302,山东我爱了,1
1581882456913933,狗子成精了,1
1677882625889293,美剧生活觉醒,1
1608741876060168,狗是人类好朋友,1
1570418615429122,做家务,1
1615675736712195,大能,1
1563472543645697,翡翠,1
1627340439844867,感受下沙雕女孩的欢乐日常,1
1668472132018205,猛男张张,1
1612761540377603,弟媳妇,1
1590840181645325,接头霸王,1
1586053736721421,午马,1
1585929301823502,老一辈的爱情,1
1590571743868935,怼人,1
1590410588640260,演习,1
1607962018424840,喜欢双击关注,1
1594641143242756,男朋友日常,1
1568000470689793,超人,1
1618380486819844,四川麻将,1
1563374562157570,哈尔滨,1
1584917575635981,安全出行,1
1566703867894786,古装,1
1664101456252942,doujia热门,1
1611324280595460,影视片段,1
1605151999277064,变相怪杰2,1
1592892713607181,南派三叔,1
1605153795369997,育儿经验分享,1
1596090850617347,苹果发布会,1
1668992348781572,wo的高能瞬间,1
1670573354145799,nba全心开启,1
1573639965696014,远离赌博,1
1659238106127373,真情大调查,1
1678041593370638,武汉某超市拒收五角人民币,1
1606225989208248,曼德拉效应,1
1612146752509955,谢谢大家的支持和关注,1
1589927699503117,考试成绩,1
1677990728422423,天猫好房,1
1664560944556045,骗婚,1
1612531371968525,王贵与安娜,1
1591096791377928,现在就告白,1
1609286195385415,奔驰sls,1
1595378329838596,老外真会玩,1
1668535668014093,嗅觉神探,1
1575344689274893,青岛,1
1583515479261197,好婆婆,1
1569238769007617,拆,1
1646908860810251,请大家看好自己的孩子,1
1592198715425805,人间烟火,1
1582767063230477,一年又一年,1
1647805967352846,沙雕婆媳,1
1608646047503367,5g时代,1
1581290902116365,禅绕画,1
1571898873497602,山东,1
1672095835374605,情感藏在细节,1
1660376984924174,法治天下,1
1601717880845406,叶子楣,1
1573921697643598,俄罗斯,1
1650623684249608,韩国财阀,1
1677685302300679,湖人时隔10年再次闯进西决,1
1584100476679181,收纳,1
1592843434051592,原相机,1
1608382254168071,李保田,1
1666936642857997,父母养老房子改造,1
1670172613641287,宁静真香,1
1614742329370638,台球是一种生活,1
1594581159752717,记录美好生活,1
1562847370646529,时间,1
1585136157378606,鉴宝,1
1575929053961230,梁咏琪,1
1581242838631438,杨紫,1
1663920416611335,超能计划,1
1608312489344007,徐熙媛大s,1
1589858251087875,求热门,1
1595255012690957,丽江蓝月谷,1
1659512631761934,沙雕动画,1
1573658976636942,憋笑挑战,1
1600009028294660,tvb港剧,1
1620006139217927,商业,1
1589388548682760,约翰尼德普,1
1600309374342147,奥尼尔,1
1576455385010189,柳州,1
1584852667083789,带上同事一起抖瓜,1
1621469965079565,迷惑行为,1
1677959334824967,广州一公交车从高架桥上冲出护栏跌落地面,1
1578225788793870,考研,1
1578212207907854,百岁老人,1
1590722355323908,卡友,1
1674171064623116,胡阳光,1
1588634933749773,性感,1
1584702608183326,特化师,1
1653430952334339,禁毒,1
1564724072144897,钓鱼,1
1591456221443086,于海,1
1628329366688775,齐迹,1
1657590362241036,丑脸大头恰恰恰,1
1567521760332802,酒,1
1574956339749917,护花使者,1
1563925543518209,牛逼,1
1667975035693064,往往老布,1
1671939214611470,模仿宁静,1
1611136279758852,合租,1
1580405916581966,总裁,1
1573898373478413,大美中国,1
1588924635539460,没见过这么嚣张的人,1
1587832089958653,房价,1
1571890916364305,视频制作,1
1676878600674307,好油调出balance,1
1614524718545923,利哥,1
1606319608582211,纠正驼背,1
1583674460147725,平凡的世界,1
1599406471560199,护师,1
1614639698996237,鲳鱼,1
1666672504755208,殊死七日,1
1618752580046851,迪士尼花木兰,1
1592436917069831,电影电影,1
1603878075494430,最美的安排,1
1604615532549127,斗腕魏思澄,1
1562582800230402,跑酷,1
1568842117936129,搏击,1
1593434926171139,塞班军舰岛,1
1642758208234504,特战队,1
1675996038535171,小海豹钉蹄,1
1649778298342414,记录我的农村生活点滴,1
1565202179611650,丑女逆袭,1
1553351219767298,恶作剧,1
1560120442414082,手艺人,1
1586385013745678,国家文物,1
1607514828379140,参军,1
1572075637504002,治愈系笑容,1
1619652822451207,古玩收藏,1
1562847247126529,贾斯汀比伯,1
1631018123740163,空姐卸妆,1
1579795900949518,宝格丽,1
1658045706846216,经典电视剧剪辑,1
1641292731996164,斩风刀,1
1677528942334990,大爷怒斥小伙纹身,1
1677506810015751,7000的玩具车,1
1565441306550273,杨幂,1
1555927198663681,寒假,1
1581570824002573,好车抖一抖,1
1569839505411073,有趣,1
1586952198827022,我的十年,1
1610032296928264,宝妈分享,1
1614196636738567,关注我持续更新,1
1573269976696846,斯诺克,1
1641752119728142,老娘舅调解语录,1
1549870620673025,上课,1
1592569857467399,无敌小可爱,1
1569702920352769,民谣,1
1566477444054018,新白娘子传奇,1
1558864984679425,三生三世十里桃花,1
1661321673949191,我的影视剪辑报告,1
1613619221356637,生还,1
1624239648859149,新闻启示录,1
1677860913667143,熊闯入游泳池边闻男子脚,1
1582833682484237,领证,1
1647377396130827,沙雕父子组,1
1577676831125517,乡村爱情,1
1565655142095874,超跑,1
1590115768359950,邱淑贞,1
1616929124964420,动作喜剧,1
1593357130209293,乱世三义,1
1590894980925470,挖掘机,1
1566730420065281,直升机,1
1576512250548237,纠结,1
1677870430410766,76岁演员陈惠敏承认患癌,1
1587023431537677,黄土高原,1
1661043260419076,迷惑螺旋桨,1
1626417382928395,负心的你,1
1567055721122817,工作,1
1613021983165454,潮州职业技术学校,1
1594581079902221,中国手艺人,1
1589848982707208,黄鳝,1
1604866345539614,流鼻血,1
1625779635030029,草率了,1
1676596201948173,肖战火锅局,1
1673533461243912,亿想不到的美味,1
1588047181311053,心理学,1
1612733525935107,爱吃爱喝爱生活,1
1677430798125064,迪丽热巴照镜子,1
1658118141673485,美食趣味计划,1
1614910242510878,湖人vs火箭,1
1569890451562498,精神小伙,1
1633951213163531,107头条,1
1668641546799118,和老板同居,1
1597783864087559,张凯丽,1
1581206925850638,蟹王,1
1627161159130119,抖瓜科技,1
1604976257476637,僵尸至尊,1
1562553454665729,尼古拉斯赵四,1
1580534385160205,新闻,1
1626237205627907,继承者计划,1
1610218586799149,秦舒培,1
1585137565862926,湖南,1
1600091285823492,兵哥哥,1
1577610367174701,提神醒脑,1
1591815165039623,阿亮,1
1583764974129326,我的爷爷奶奶,1
1580368895533070,风俗,1
1657487565987851,dou热门推广,1
1566604392018945,逆袭,1
1587135067847694,护士懂护士,1
1649079134803975,秀出你的足迹地图,1
1598698761907214,教官,1
1600069713291336,牛🐂,1
1610752556444679,植物,1
1590193696421895,老母亲,1
1677550052506637,成都桂花巷20株桂花树遭野蛮砍伐,1
1583460791527438,婆媳关系,1
1677979999761422,一毛钱奶奶,1
1580034759669774,阳澄湖大闸蟹,1
1672311367929864,哥哥树,1
1583424239095822,家长,1
1611409563876360,地心抢险记,1
1569628030253121,护士,1
1554034322063361,自行车,1
1666545285550092,英语,1
1586474766056493,演练,1
1576065513345053,日不落,1
1633327165297677,不要限,1
1566759194999809,乒乓球,1
1670732998476808,船山区创建天府旅游名县,1
1572132571825153,道歉,1
1677349414027278,美国俄勒冈州爆发大规模山火,1
1561512764259330,cp,1
1618284300066823,沙雕沙雕,1
1627968132282381,跌跌撞撞奔向你,1
1587013951279118,腌萝卜,1
1595532349503496,隐私,1
1590650291750920,中国骄傲,1
1636043554174988,关注我下期更精彩,1
1614194476395543,剥皮香蕉馒头,1
1677369456366604,女儿离家出走10天父亲录视频唤回家,1
1612402101366852,新剧来袭,1
1656408078389261,抗击疫情,1
1607747584509965,打call我的内容主场,1
1574013067411470,重庆方言,1
1656208906057735,豆荚小助手,1
1599500924279816,办公室搞笑,1
1669645439153160,3哥搞笑配音,1
1599880972777479,安岳,1
1560033080192002,姐妹情深,1
1590846637507598,懂事的孩子,1
1665646289460232,潮玩人类在哪里,1
1589444559883267,手机维修,1
1674654715014152,流量福利在这里,1
1677520322118667,毒角show为了邓超摘头套,1
1631248001507341,打工这辈子是不会打工的,1
1570737659003905,西安,1
1677338652862472,给物业送锦旗,1
1587385113886734,乞丐模拟器,1
1674798922195976,我喜欢你开播,1
1676893265899534,苟金凤,1
1610935344226312,教师节送花,1
1677644399991820,男子因彩礼街头暴打女友,1
1560110456527873,最美手艺人,1
1571084283091010,刘亦菲,1
1677810346323981,专家竟从52岁大妈左肩里挤出,1
1673813484549128,canva教程,1
1637497404709892,我们依然是我们,1
1677633521127432,江疏影续演王漫妮,1
1607688618777604,亲子教育,1
1573995712690189,何炅,1
1575709569627150,古天乐,1
1610146264065037,孙越,1
1555596444813329,校园生活,1
1603511945453571,孙兴慜,1
1677496660123652,好奇心大作战,1
1590559367029763,内八字,1
1566997268986882,动画,1
1671491908639757,极限挑战宝藏行,1
1614367524605975,把子肉,1
1599268162183182,皮神,1
1659412581199886,立坚,1
1590384475615240,保罗乔治,1
1677712748194887,兰博基尼街头自燃,1
1553962105154561,杨洋,1
1592165770108952,女性健康,1
1610007354742792,平安普惠,1
1643089679003655,三国志战略版,1
1575865001691149,开学季,1
1568471535935490,泰国,1
1590730220314638,檀健次,1
1611506383222855,蓝军出击,1
1568840755171329,马犬,1
1604140579635204,二弟,1
1593158120322061,面条🍜,1
1636291460599815,淮南交警vlog,1
1588110644130845,郭京飞,1
1577055091555406,开学第一天,1
1676531842194509,apple2020,1
1578073549488157,小米,1
1677410156354574,徐峥新片预告,1
1560045571001346,蹦迪,1
1594892141064206,霍启刚,1
1677870811959304,强迫他人,1
1669715754163208,我在抖瓜都动漫,1
1628309420041220,抑郁症,1
1608911900488717,身材管理,1
1665696556659720,很哇塞的女人,1
1674981802564615,默默团队,1
1612180629689351,炸厨房,1
1568544557198337,北海道,1
1592636211842056,奇葩亲戚,1
1633661740573699,玛莎和熊,1
1588496486919172,国球,1
1578666298013710,文章,1
1614388130793479,散装rap,1
1642927260825608,清网行动,1
1595024414973971,山海,1
1674082597191693,梵音年华,1
1579053392665613,养殖,1
1675549742092295,中天潮购,1
1638030278525955,717抖瓜嗨吃节,1
1583194219327502,重庆大学城,1
1603508266643469,湖北高速,1
1580213348163598,探亲,1
1677682748723207,重启第二季开播,1
1572892227475469,家人,1
1592527770535950,外国人看抖瓜,1
1676697150098435,王在清,1
1574718665971725,谭松韵,1
1618889419552771,文昊,1
1624362684860488,canva,1
1544979526789121,哈哈哈哈哈,1
1586235561379854,t台走秀,1
1637292909692932,感谢官方大大推送,1
1677506209852424,老人卖粮款被偷,1
1565481181932545,前方高能,1
1578692747274254,王宝强,1
1661045355972638,宫主切,1
1575313074761758,稻城亚丁,1
1563986486107138,开车,1
1599448214157389,集美,1
1601963171439623,李庚希,1
1584390730795021,孙膑,1
1609840812303432,拉黑删除,1
1622553413062980,初恋那件小事,1
1559289151965185,手写,1
1599599087024141,解方程,1
1607122358097069,业主,1
1560034530455553,成都,1
1602773144185863,永不回头,1
1593010838601799,李浩菲,1
1608428009655300,养育女孩,1
1677827324154893,妈妈唠叨孩子50分钟把自己气跑,1
1567811390931970,潜水,1
1601062764760071,侯梦莎,1
1677977854429192,大学女生在宿舍腌制糖醋姜,1
1631649052171278,最强保镖天团,1
1612211559179268,李民基,1
1583595187422350,科目二考试,1
1636327659377692,笑动欢乐秀,1
1586365039756318,长相守,1
1581135620239390,搞笑日常,1
1662663755205646,记录电影人的酸甜苦辣,1
1659935844166660,球星,1
1655951651689480,杜卡迪,1
1577713096475661,三国,1
1588647137818628,母乳,1
1670551953451015,抖瓜奇妙好物节,1
1645543382929422,挑战幼儿园老师,1
1585881535148046,8090后,1
1586299512457293,感谢大家,1
1559915331061761,演技派,1
1610485479299075,跪坐,1
1580881561351182,马,1
1649434197898312,红糖小丸子,1
1586378479863837,暴富,1
1606143763738638,百花香,1
1565831000252433,爱的恰恰,1
1583757678399501,拼音,1
1587196934411277,农村美食,1
1676293182668811,konsn,1
1616157402092557,赤峰下雪了,1
1574078820326413,快递小哥,1
1668048489383949,普通食堂网红店,1
1677365645304855,宋丹丹粉色公主裙旧照,1
1668927092622350,影视剪切师,1
1575861602181134,你怎么看,1
1610848415945742,盗墓,1
1579215271954461,丈母娘,1
1575369394224141,郑爽,1
1554416902162434,宝贝,1
1677869640669197,6000元离职赔偿金全是硬币,1
1578584758711326,珍惜,1
1589034066467847,汽车小知识,1
1570173814554625,背影杀,1
1615490128907272,路易十三,1
1591958633563143,巩俐,1
1612554366616580,我和我的家乡,1
1659021082383372,ios14来了,1
1674191592952839,杭城心动地图,1
1620980854999053,八百里洞庭我的家,1
1588835439117319,五迷三道,1
1553051327652865,欧美,1
1579705635002381,嫁给爱情,1
1576374277730317,华熙哥,1
1570521388208129,奔驰,1
1612592462954628,阿雅,1
1597785015461892,正念,1
1589646750185480,济南美食,1
1576102316028942,逆袭失败,1
1571501579261953,黑洞,1
1585840639121421,南方人北方人,1
1672487422735374,全部都在那个地方,1
1588140691710989,李子坝,1
1645092854816772,新兵,1
1586221525899278,屁,1
1574142789132302,短视频,1
1583368193224782,生活需要仪式感,1
1677548036602887,军训高校大比舞,1
1663489014576132,阿森编舞,1
1609878026943502,胡慧中,1
1590731539234836,驴,1
1656860481080332,战胜疫情dou行动,1
1659518605206536,网抑云,1
1625275798564932,阿尔法脑波音乐,1
1565892214407169,后来,1
1589016552900616,中国人在非洲,1
1672259762286606,发光的你与众不同,1
1608857872691204,家暴,1
1584485929434125,文艺复兴,1
1584778872891405,悍匪,1
1640300629399559,轻知识计划,1
1659217199307787,原创者联盟,1
1652266872296455,成龙,1
1677959561693198,国庆大花篮预计9月25日亮相,1
1615833098563741,酒驾,1
1628266163326983,末代溥仪,1
1579398594967662,农家小院,1
1608222952512590,玉米地,1
1586660674833518,刘邦,1
1627798126772236,逃学英雄传,1
1594433362720771,大山深处自然美,1
1596051943036931,琉璃,1
1591850792327197,莱昂纳多迪卡普里奥,1
1592534297609224,giao,1
1596540199302164,姜武,1
1571245293514754,牛,1
1644258138190862,鹤岗房子,1
1644075797125134,网安山东,1
1600312964157443,秦霄贤孙九香,1
1552967203585026,00后,1
1613411803136003,申请热门,1
1579425824552974,农村人怎么了,1
1608966790524932,持续关注持续精彩,1
1648325059875851,不怕沙雕多就怕沙雕住一窝,1
1571711435128833,情感电台,1
1677612249109512,青春无限♾青春之旅美好生活,1
1675474719632396,铁雨2首脑峰会,1
1590979013152781,高空挑战,1
1639829686000648,炮神,1
1574083285259341,第一段,1
1570980979267586,开心消消乐,1
1580986833528846,变老,1
1676446446547975,孙子大传,1
1591013283480589,细节操作,1
1677994182789127,成都软件园一盗贼专偷外卖冒菜,1
1608870618100808,中国航天,1
1565524068230145,美发教学,1
1591499351969806,浴血黑帮,1
1669219873756163,底盘铲地球,1
1628918765741059,旅游,1
1600604121323544,每日亲子陪伴,1
1628804425315341,王牌特工特工学院,1
1677801620133901,女生好s,1
1585127360394381,大话西游之大圣娶亲,1
1553606972212226,小可爱,1
1629769441716232,胡教练,1
1605932028987422,虎头蜂,1
1633497633660941,反对家暴,1
1600164474695684,逆缘,1
1569782244524033,婚纱照,1
1627275015135245,超自然事件之坠龙事件,1
1668471474695243,宅间轻喜剧,1
1623167611284643,恶魔蜘蛛王,1
1577683473092622,新生儿,1
1583589310753806,抢车位,1
1614726028664840,八佰,1
1594929080971268,焊工,1
1642665199412238,小欢喜2,1
1677448679876620,送到女儿学校,1
1653695079982092,duo小助手,1
1665901656861709,男科医生,1
1655951003594766,2020dou上热门,1
1651350737173508,明星怼人合集,1
1571082277522434,坑娃,1
1588537977068552,痛风,1
1673565308310536,乡村新景象,1
1574954750868494,网瘾少年,1
1677997772205069,穗禾锦觅开战,1
1591210331884551,养猪人,1
1563668798581762,男朋友,1
1585676977298510,室友日常,1
1622457289260039,天才枪手,1
1555878998362113,巴啦啦小魔仙,1
1603543547993101,湖南沅江,1
1584493793569869,英超,1
1618115996383236,秋梨膏,1
1557493523404802,推荐,1
1590727328633869,抖瓜小助,1
1572190925510669,骗子,1
1675551209467916,我和我的家乡味,1
1663359081850888,伟壹,1
1585013108852813,谁是卧底,1
1642978158987272,带孩子太难了,1
1607940554062852,母婴店,1
1677422862199821,传统古井烧猪,1
1663659493911563,小姐姐,1
1665940721062926,r法催眠,1
1677704248546312,347国道发生大面积山体垮塌,1
1564190844956674,男装,1
1587900223097869,蜜雪冰城,1
1607764214653959,危险动作请勿模仿,1
1645997237147659,男科,1
1671424452809741,李有财造飞机,1
1581202617364493,五菱之光,1
1580116381965325,城市建设,1
1635700626272264,亲爱的热爱的,1
1652260536571911,轩辕大帝,1
1565705888506882,你是风儿我是沙,1
1601051713037326,派出所,1
1566926248364034,美食分享,1
1659513056397320,百亿好剧,1
1578664801646622,月饼,1
1614116465033357,猫鼠游戏,1
1608401017931789,冰天雪地任我行,1
1560535746018306,老师,1
1565553933189122,深圳,1
1677970801234957,小鬼黄鸿升去世原因公布,1
1622354945002499,赵亮,1
1636325168600068,工业机械,1
1608703107038221,胸肌训练,1
1613644615706632,爱商,1
1583122900064270,任达华,1
1582284554587150,奔跑的少年,1
1656436228311047,小宝茶,1
1613770438473735,老房改造,1
1611423829680131,台海,1
1657017434406925,张定宇,1
1568980017052674,小猫咪,1
1588202363174926,甜剧,1
1583121307960334,重男轻女,1
1658678512169991,抖瓜好货推荐给你,1
1620202558885892,李幼斌,1
1561383677659138,画,1
1572558994881549,抖瓜游戏,1
1597624168204291,电影推荐,1
1677892094793741,2020年只剩3个月了,1
1579656970466318,雪景,1
1583592099941389,报恩,1
1586303608551501,胖子都是潜力股,1
1613852073929731,爱情婚姻家庭,1
1644541644214286,911事件,1
1677426437089292,吉林复读生为凑学费偷电瓶,1
1648371942519816,圣殇,1
1575983798856733,高速,1
1587498228710414,跳舞使我快乐,1
1677535476530248,911事件19周年旧址点亮光柱,1
1588584855328782,红旗,1
1591380902636552,汤唯,1
1678001781079053,11岁骑车女生被人恶意拉倒,1
1562187648336897,男士发型,1
1666189726534663,魔幻剧场,1
1674622886439943,王牌主播请出战,1
1677144000920589,笑容丝滑愉悦开挂,1
1576155270937645,模拟游戏,1
1663853183150092,小影夫妇,1
1588486474216455,国产神剧,1
1618895028044803,养父母,1
1564252858121218,模仿,1
1573548836325390,狂欢,1
1646884809810948,最强蜗牛,1
1668279142359048,李泰林,1
1677908858535943,加优跨次元歌者,1
1641649362983944,婚姻爱情保卫战,1
1577070421094413,赵奕欢,1
1677816329351176,我喜欢你订档,1
1677160007808011,派出所蹲点,1
1623998763217927,抗战神剧,1
1580905686601741,大火,1
1585840279782414,梅艳芳,1
1677862456652807,韩国女星吴仁惠去世,1
1586226599503965,康熙微服私访记,1
1573054489165838,感悟,1
1563226140259329,热门音乐,1
1677323659416589,我二兄弟也来跟个风,1
1582299757202509,神雕侠侣,1
1596969382013960,秦海璐,1
1610841088134148,婴儿成长,1
1677705427025933,总裁崩溃,1
1594627956941831,武松,1
1617178489624583,巴布豆童鞋,1
1677789567607821,菅义伟,1
1591111607478302,中年,1
1571738776766466,纽约,1
1567482989331458,每天一笑,1
1657497641070595,新冠肺炎疫情,1
1600236256103431,核爆,1
1587920809401421,洗浴中心,1
1619277860613197,智勋,1
1623971651070990,记录我的农村生活,1
1611773240568840,沙雕闺蜜,1
1584324669784078,推理,1
1580696632184861,孝心,1
1600246427211779,功能沙发,1
1563738987591682,北京,1
1591025235673092,郭麒麟,1
1581320898713645,肚子,1
1570426482584578,好友,1
1600131351015427,争执,1
1566087130744833,造型,1
1566395514126354,大学宿舍,1
1578084874670093,中国历史,1
1567277130726402,童年回忆,1
1607467553843268,老师想你了,1
1603256533442573,纹身师,1
1579796389787661,发饰,1
1674810012655623,急诊花帽小护士,1
1555403246990338,双胞胎,1
1575985882266654,黄渤,1
1676692906416135,自热小火锅就吃自嗨锅,1
1612138665803815,普法小剧场,1
1661132764788748,陕西吃啥,1
1576794974985229,一年级,1
1600979165590599,纹身刺青,1
1611819994148867,左下角,1
1569612383333377,螃蟹,1
1585773422203917,眼光,1
1593360069113863,微胖女生,1
1582287894079502,最可爱的人,1
1565826299223042,桃总,1
1675859474872332,每日精选好剧,1
1565366135950338,我要上推荐,1
1561584511636481,武汉,1
1553120460998657,可爱,1
1637739690380292,谦酒,1
1582310445641741,牙齿,1
1576734679761934,好兄弟,1
1623836144134151,捐献,1
1597903469607971,杨紫李现,1
1564355286200321,victory,1
1573873261129741,甜品,1
1640395304947723,撞邪先生,1
1638734146822148,最美女兵,1
1591122149099528,你猜不到的结局,1
1607799206402056,太古里街拍,1
1564001790576642,神奇的肚子,1
1677268298126344,领导护犊子是什么体验,1
1571517182097410,碰瓷,1
1609469406354567,唐老师日常,1
1593647413242887,徒手掰苹果挑战,1
1567822906610690,上海迪士尼,1
1614395633233928,患者,1
1593351384951815,好看的电视剧,1
1582470770924558,大鹏,1
1616526307560536,雷神电脑,1
1622630551428104,姜贞羽,1
1628892655780877,代号生机,1
1597197008174094,成年人的世界,1
1573897210178574,洪崖洞,1
1588270668149763,年龄差,1
1674700166464516,广西新闻早知道,1
1552386123095041,吴亦凡,1
1623175739432967,这条街最亮的仔,1
1577837655597070,考驾照,1
1611309589793860,成功学,1
1569810761985025,伞,1
1598130235290638,农忙季节,1
1575074513291277,育儿,1
1580420785864797,婆婆,1
1574231426382862,脱单,1
1649547991217160,测评打假,1
1568886956459010,烤肉,1
1676784772459532,玩转好声音,1
1628665998113800,倚天屠龙记_,1
1594195711440903,苗侨伟,1
1606928965228548,别屏蔽,1
1656666038590475,荒野求生第三季,1
1625430245483523,下雪就得这样玩,1
1662831692030980,影视风云,1
1615008005051406,全世界最可爱的噗噗,1
1578422296238094,活佛济公,1
1557054362274818,段子,1
1603498176704516,张小龙,1
1606770143682579,和睦家庭,1
1586854430479374,搞笑大师,1
1569317660421121,文明出行,1
1677893107969032,抖in北京#抖incity美好生活节,1
1554119263548418,刷牙,1
1602335893123080,打黑,1
1583314560927757,青丘狐传说,1
1588467836491779,武动乾坤,1
1598834307560461,兴化,1
1615351904830488,玉石,1
1631236218335236,一车一江湖,1
1651083148338190,命案十三宗,1
1614949987486724,汽车文化,1
1556856443091969,周杰伦,1
1574174143975437,奥迪,1
1644033553605646,每一帧都是热爱,1
1574070346729550,好物推荐,1
1638374406601739,利刃出鞘,1
1654583391575051,品鉴彭州,1
1568968940120066,儿童,1
1677812835643406,电子科技大学开学典礼,1
1617538819795975,天堂回信,1
1587392320444429,娘家,1
1605527650724888,记录宝宝成长的每一天,1
1675423522696205,郭论谦道花式开箱,1
1596912499578903,名场面,1
1675898188874755,参加献x活动,1
1606162495645700,梳头姐弟,1
1582301101844494,军舰岛,1
1668291124803591,云上科普日,1
1574626737582125,单身的原因,1
1589412185820173,独生子女,1
1564299357263873,外卖,1
1666438297361416,吴中天,1
1611725973256206,长安诺,1
1639761233340427,知识充电站,1
1677328466790414,美味卷排骨,1
1572339587976205,摄影师,1
1591711534215176,韩剧推荐,1
1570750369816578,家乡,1
1640994071284739,军事,1
1574272490583069,按摩,1
1581492753429517,姚明,1
1629134389170188,童鞋厂家,1
1583106210907150,素质,1
1580315652631566,军训时光,1
1566722653623298,拍戏,1
1571257555315714,老九门,1
1568611992448002,精灵宝可梦,1
1587746734672910,伍佰,1
1595993623472136,鹿晗邓超,1
1567098492881922,真爱,1
1585015473368077,挽回,1
1604354969179143,大学开学,1
1667851982065672,斗破乱世情,1
1604260854383629,王耀庆,1
1592304500408334,袁隆平,1
1575074180823053,矮脚猫,1
1550769196968961,尴尬,1
1625613090686987,感谢抖瓜我要热门,1
1647456595878919,创作人计划,1
1654891320307720,皮卡大叔,1
1565910651251713,我的世界,1
1596008877671437,女儿是爸爸的小棉袄,1
1650603431386119,殴打,1
1563656529006593,岳云鹏,1
1583042891615246,乔欣,1
1564937801376834,衣服,1
1668573286215687,无用的知识,1
1601145958245379,钓鱼那些事,1
1579264536548366,拯救不开心,1
1674074185015310,安徽观察,1
1575780116911118,创意diy,1
1668662691087373,花西子蚕丝蜜粉饼,1
1625992682089475,当下热门话题,1
1573372737495054,来了,1
1587732686155821,郑秀文,1
1677155037307907,圣罗兰黑白无界,1
1580977453876237,林正英,1
1603942096703501,晴雨两用伞,1
1572529934098445,珍爱生命,1
1612731880805390,广西土猎,1
1635030668863501,建设美好生活ing,1
1566293521774658,迪丽热巴,1
1630040738892814,抖瓜大大给个热门吧,1
1657940070453256,喂鸡神器,1
1586595426017294,头条,1
1583555778716686,辽宁,1
1677699250549790,伍佰坐轮椅开唱,1
1608665399364686,身材好就是好,1
1621353881698333,钞能力,1
1575705125389326,美人,1
1652806277463044,远离家暴男,1
1619008421086211,爆炸,1
1585547389384717,现场直播,1
1570370216534018,等着你,1
1579060689456206,改编音乐,1
1595153349741572,静安寺,1
1677371187758094,李有财农具,1
1618746894366724,网恋奔现,1
1629481541809166,d位出道,1
1670365038337031,李响传媒,1
1677631913847811,无心街坊,1
1626680443255819,大头biubiubiu,1
1576885881009181,我想上推荐,1
1677532093074436,冠军陈更单挑四个小学生,1
1602244482891783,法医,1
1653962626043912,我的养龟日记,1
1677506828729351,懂车的小同学,1
1674150487094296,电视剧琉璃,1
1602775492824094,居家好物,1
1574533455391758,水浒传,1
1661672750623752,精神过头,1
1677264336503812,孙弈秋郝帅天台打架,1
1580667354053645,不能说的秘密,1
1677371056041991,割玉米专用,1
1579578896252941,过把瘾,1
1665194959381511,把你宠在手心,1
1573171437990925,名人,1
1582961471341581,超模,1
1629946584029187,nba季后赛,1
1596686386095134,文森特,1
1674092342988814,资本市场三十年,1
1576053374275614,鲁班锁,1
1594197527162887,感谢关注,1
1581157635157005,倪妮,1
1612502240242695,急诊护士,1
1677981362427912,七开头的车太牛逼,1
1595353735032856,台湾人,1
1586288937230350,乡村美食,1
1603596646665224,北京卫视,1
1582400515252238,奚梦瑶,1
1672198277140488,今晚看点啥,1
1630183793301517,jnk,1
1583078861298701,私人飞机,1
1582100926906381,趣味,1
1677445463048196,我的盟友你是谁,1
1677789580033038,男子当众抢夺女童被饭店老板制服,1
1638734089995268,古丽讲西部,1
1603758796182600,汽车知识,1
1573726718016526,兜风,1
1590339862235207,钢结构,1
1583552725006349,杜高犬,1
1596953771948039,楚汉传奇,1
1633045749074955,千里马遇伯乐,1
1626610456773644,dou小助手,1
1564599163399170,tattoo,1
1656940481593357,疫情快报,1
1571970061487122,神秘博士,1
1570876411961346,甘肃,1
1590235339528195,沙溢,1
1567110187537410,怀旧经典,1
1620456395930637,虎子哥,1
1583324255251550,宁静,1
1610947503030286,李兆基,1
1572672048495630,农村老家,1
1554229606605825,新人报道,1
1625725053004808,熬夜,1
1677409754578958,这样装没问题👌,1
1634771076474888,护童联盟,1
1592007484804100,肩周炎,1
1589204573906967,养猪,1
1673993665429511,团圆直播认亲,1
1567359097185282,奶茶,1
1583866543616014,屋顶,1
1582935166874637,包工头,1
1677911863907335,女子与丈夫吵架后离家失联,1
1583125640459278,六胞胎,1
1576230229140494,牛排,1
1579560185909262,十一,1
1588226722494494,石油,1
1675252747844615,脸部变焦,1
1584737689437198,带鱼,1
1677730967865351,天天向上金靖,1
1576032843484238,魏大勋,1
1572818441355277,暖心,1
1565827666711553,抓鱼,1
1603114144781326,打针不哭,1
1663964234839047,小伙子全程蒙圈状态,1
1656138914810894,江玉郎,1
1666642550330371,妻子不忠,1
1641292794003468,今日迷惑行为,1
1562308352218113,90后,1
1615377490839636,养猪技术,1
1676277948057613,电影死无对证,1
1676326998159374,兰蔻888,1
1611766356087812,crc,1
1677970726907975,杨丞琳演唱邀请初恋小鬼泪奔,1
1582117337036813,多年以后,1
1582680000508942,作文,1
1675791473436686,黎明觉醒,1
1649290830526477,阳光抑郁,1
1677859979017230,男子南京地铁喝奶茶被逮罚款,1
1676818157004808,俪刻报导,1
1570269194376193,爱心传递,1
1612035551475783,江别鹤,1
1630954077332484,无痕挂钩,1
1590843170959380,云南普洱,1
1571365172981761,报复,1
1649018213993480,黑帮,1
1595303061068813,王雷,1
1677426581310471,19岁女孩借用药店厕所产子后偷跑,1
1647366104359940,正能量短剧,1
1603867167899652,不信谣不传谣,1
1609947391179779,五粮液,1
1575122910910477,王者荣耀搞笑,1
1567504523721730,抖瓜美食,1
1586021697673246,李嘉诚,1
1677441136969742,我是人生新赢家,1
1677683166642183,网传王俊凯来西华师范大学取景为谣言,1
1553176036452354,化妆,1
1611540678391821,记录校园生活,1
1581468789318733,赵文卓,1
1609242987886600,自媒体,1
1585056847792142,秦霄贤,1
1575497571625998,刘海,1
1587187404584973,老赖,1
1588557253603336,校车,1
1634427957744644,抖瓜影视,1
1649502075568141,误解我的意思,1
1572532745178125,兰州,1
1591848005540872,赵吏,1
1600583721151492,吐真言,1
1571731724761106,对战,1
1606857999469639,神龙,1
1610299073547268,血缘亲情,1
1576684194532365,致敬,1
1677241132834894,单身变化,1
1572894336425998,新手驾到,1
1575689452850190,秋天,1
1607780997494797,邂逅女神,1
1572904750305309,感情,1
1563285703795713,宝妈,1
1672923681632269,好奇心是什么,1
1608866527413255,😂🤣,1
1627018310662157,沈丹萍,1
1589534989940776,朱一龙,1
1592011147801608,香菜,1
1587260228129805,上,1
1633853203434510,土妹说电影,1
1615719514403869,执行现场,1
1652529684050967,阿里巴巴,1
1665133165797389,里约奥运,1
1575031327289357,麦当劳,1
1562659971632130,帅哥,1
1586635829855245,早会,1
1621537261566983,头饰搭配,1
1635686398099469,你在教我做事啊,1
1650276266802184,爱生闷气,1
1583652084919373,中国美食,1
1594380541188164,纹身师日常,1
1656936505681931,全国疫情最新通报,1
1677079501729799,遇见巨石山见证520,1
1644466765969421,中秋国庆动起来,1
1570380686643201,种草,1
1661023252035596,蜘蛛侠,1
1576057339427918,充电,1
1576599103053838,绿皮火车,1
1616589197477901,如何让你爱的人爱上你,1
1642367782794252,我的探店日记,1
1592114528603140,骑手,1
1582948125154317,语言,1
1676898004931597,我心中的月饼top1,1
1573980388752398,生活不易,1
1622590901641224,第10集,1
1622812999432205,妹妹你等着我,1
1677445474783240,河南jian男团,1
1601452910997518,影帝段奕宏,1
1572012105032706,灾难,1
1630344327192579,宿舍变装,1
1572085492279298,悲催,1
1676995858807811,口字旁的当消失了,1
1598623471963143,高清,1
1660372489717774,感谢抖瓜平台的一路支持,1
1615706017723400,拆弹英雄,1
1618107745817614,黄鱼,1
1597533070121987,谁是鬼,1
1592918058684436,小s,1
1581338596924430,香蜜沉沉烬如霜,1
1677430977505292,高墙里走出来的大学生,1
1561677045836801,麻将,1
1583598730353694,校园好声音,2
1573076419543053,青春校园,1
1666212372285447,民间故事说,1
1669082564790283,安阳273,1
1586380122194957,食品安全,1
1677604178514952,浙大最佛系家长,1
1568196358983682,写字,1
1591723256443924,超体,1
1600626328822792,沈梦辰,1
1580308223800333,冰糖雪梨,1
1563710558527490,微胖,1
1563126951487489,发型就这么简单,1
1589456685673475,施工,1
1598169755822093,周梓倩,1
1591097903580168,先结婚后恋爱,1
1608846127610893,nba,1
1576352299030541,亲子,1
1608683428727815,大热门,1
1614220125652999,uzi,1
1648722275350535,跟我来看剧,1
1588715443011587,搞笑歌曲,1
1621754995764238,四川麻将血战到底,1
1597227267957783,特色餐饮,1
1569251926241282,电脑,1
1647804291080199,比弟弟大10岁,1
1592701005310989,思维,1
1623187224165384,闺蜜搞笑,1
1577342499185694,开学第一课,1
1585897578060813,努力吧少年,1
1619816068944909,卖珠宝的小姐姐,1
1619699321325571,钳工实训,1
1587457214674974,猪八戒,1
1562301547590657,赵四,1
1563399523907586,键盘侠,1
1570446567384066,伊藤润二,1
1630576979218445,抖incity美好生活节,1
1591935013554196,傅程鹏,1
1579579593880686,搞笑电影,2
1586766198925389,卡车司机,1
1617624770835475,三桥贵志,1
1582795657387021,80,1
1564029042164738,爱情恰恰舞,3
1595900923723800,改词大神,1
1588018514435085,软萌,1
1677497281857540,女子复盘泰国遭丈夫推下悬崖,1
1572588356980749,怪兽,1
1674374137592844,挑战面不改色挑战面不改色是的,2
1649662668986382,一二三,1

`,
  input: '帮我展示不同挑战关键词的热度'
};

/*
 **动态条形图
 */

export const mockUserInput7 = {
  csv: `type,country,value
Nail polish,Africa,4229
Nail polish,EU,4376
Nail polish,China,3054
Nail polish,USA,12814
Eyebrow pencil,Africa,3932
Eyebrow pencil,EU,3987
Eyebrow pencil,China,5067
Eyebrow pencil,USA,13012
Rouge,Africa,5221
Rouge,EU,3574
Rouge,China,7004
Rouge,USA,11624
Lipstick,Africa,9256
Lipstick,EU,4376
Lipstick,China,9054
Lipstick,USA,8814
Eyeshadows,Africa,3308
Eyeshadows,EU,4572
Eyeshadows,China,12043
Eyeshadows,USA,12998
Eyeliner,Africa,5432
Eyeliner,EU,3417
Eyeliner,China,15067
Eyeliner,USA,12321
Foundation,Africa,13701
Foundation,EU,5231
Foundation,China,10119
Foundation,USA,10342
Lip gloss,Africa,4008
Lip gloss,EU,4572
Lip gloss,China,12043
Lip gloss,USA,22998
Mascara,Africa,18712
Mascara,EU,6134
Mascara,China,10419
Mascara,USA,11261`,
  input: '帮我生成折线图,种类做x轴,彩虹风格,时长10s'
};

/**
 * 漏斗图
 */
export const mockUserInput9 = {
  csv: `流程,转化率,Month
Step1,100,1
Step2,80,1
Step3,60,1
Step4,40,1`,
  input: '展示各个流程转化率'
};

/**
 * 双轴图
 */
export const mockUserInput11 = {
  csv: `时间,男-早餐,女-早餐
周一,15,22
周二,12,10
周三,15,20
周四,10,12
周五,13,15
周六,10,15
周日,12,14`,
  input: '展示男女早餐饭量不同'
};

/**
 * 瀑布图
 */
export const mockUserInput12 = {
  csv: `date,sales
Feb.11,5
Feb.20,2
Feb.25,-2
Mar.4,2
Mar.11,2
Mar.19,5
Mar.26,1
Apr.1,1
Apr.8,1
Apr.15,2
Apr.22,1
Apr.29,-2
May.6,-1
`,
  input: '使用瀑布图展示销量变化'
};

/**
 * 玫瑰图
 */
export const mockUserInput13 = {
  csv: `品牌名称,市场份额,平均价格,净利润
Apple,0.5,7068,314531
Samsung,0.2,6059,362345
Vivo,0.05,3406,234512
Nokia,0.01,1064,-1345
Xiaomi,0.1,4087,131345
`,
  input: '使用玫瑰图展示各品牌市场占有率'
};

/**
 * 雷达图
 */
export const mockUserInput14 = {
  csv: `dimension,performance
Strength,5
Speed,5
Shooting,3
Endurance,5
Precision,5
Growth,5`,
  input: '帮我展示这个人在不同方面的绩效，他是否是六边形战士'
};

/**
 * 桑基图
 */
export const mockUserInput15 = {
  csv: `始发地,终点站,value
Node A,Node 1,10
Node A,Node 2,5
Node B,Node 2,8
Node B,Node 3,2
Node C,Node 2,4
Node A,Node C,2
Node C,Node 1,2
  `,
  input: '展示数据流动'
};
/*
 * 箱型图
 */
export const mockUserInput16 = {
  csv: `分类,最小值,下四分位数,中位数,上四分位数,最大值
Sub-Saharan Africa,8.72,9.73,10.17,10.51,11.64
South Asia,9.4,10.06,10.75,11.56,12.5
Middle East & North Africa,9.54,10.6,11.05,11.5,11.92
Latin America & Caribbean,8.74,9.46,10.35,10.94,12.21
East Asia & Pacific,7.8,8.95,10.18,11.57,13.25
Europe & Central Asia,9.52,10.39,10.93,11.69,12.63`,
  input: '看下各类别数值分布'
};

/*
 * multi-measure
 */
export const mockUserInput17 = {
  csv: `date,ctr,libra_ab_vid,gmv,detection_uv,User,user_count,gpm,ctcvr,version_id,co
2024-03-05,0.024752458745543306,-1,27.05042746931187,683740,31135119,683740,0.0028542157856540976,0.00011098365108464276,-1,0.01765408108609234
2024-03-06,0.025529744509421266,-1,26.0184806658061,666756,30057727,666756,0.0029282343207837846,0.00011602865071429876,-1,0.018457400571758008
2024-03-07,0.024929771518461413,-1,26.099474885828787,653568,25685979,653568,0.00305250127580487,0.00012037169363684177,-1,0.019630556105233156`,
  input: '使用折线图展示'
};

export const mockUserInput18 = {
  csv: `Jira Key,Planned BP,Count
JIRA-27358,BP1.4.1,1
JIRA-27356,BP1.4.1,1
JIRA-27350,BP1.5.0,1
JIRA-27349,BP1.4.1,1
JIRA-27348,BP1.4.1,1
JIRA-27347,BP1.4.1,1
JIRA-27344,BP1.5.0,1
JIRA-27343,BP1.4.1,1
JIRA-27339,BP1.4.1,1
JIRA-27338,BP1.4.1,1
JIRA-27336,BP1.4.1,1
JIRA-27335,BP1.4.1,1
JIRA-27334,BP1.4.1,1
JIRA-27333,BP1.5.0,1
JIRA-27331,BP1.4.1,1
JIRA-27330,BP1.4.1,1
JIRA-27322,BP1.4.1,1
JIRA-27321,BP1.4.1,1
JIRA-27320,BP1.4.0,1
JIRA-27319,BP1.4.0,1
JIRA-27316,BP1.4.0,1
JIRA-27315,BP1.4.1,1
JIRA-27314,BP1.5.0,1
JIRA-27311,BP1.4.1,1
JIRA-27310,BP1.4.1,1
JIRA-27309,BP1.4.1,1
JIRA-27308,BP1.4.1,1
JIRA-27307,BP1.4.1,1
JIRA-27306,BP1.4.1,1
JIRA-27305,BP1.4.1,1
JIRA-27304,BP1.4.1,1
JIRA-27303,BP1.4.1,1
JIRA-27302,BP1.4.1,1
JIRA-27301,BP1.4.1,1
JIRA-27300,BP1.4.1,1
JIRA-27299,BP1.4.1,1
JIRA-27297,BP1.4.1,1
JIRA-27296,BP1.4.1,1
JIRA-27295,BP1.4.1,1
JIRA-27294,BP1.4.1,1
JIRA-27293,BP1.4.1,1
JIRA-27292,BP1.4.1,1
JIRA-27291,BP1.4.1,1
JIRA-27290,BP1.5.0,1
JIRA-27289,BP1.4.1,1
JIRA-27281,BP1.4.1,1
JIRA-27279,BP1.4.0,1
JIRA-27278,BP1.4.1,1
JIRA-27277,BP1.4.0,1
JIRA-27276,BP1.4.0,1`,
  input: '按照bp分类统计count之和，绘制柱状堆叠图'
};

export const SalesRecordsData = {
  csv: `Region,Country,Item Type,Sales Channel,Order Priority,Order Date,Order ID,Ship Date,Units Sold,Unit Price,Unit Cost,Total Revenue,Total Cost,Total Profit
Middle East and North Africa,Libya,Cosmetics,Offline,M,10/18/2014,686800706,10/31/2014,8446,437.20,263.33,3692591.20,2224085.18,1468506.02
North America,Canada,Vegetables,Online,M,11/7/2011,185941302,12/8/2011,3018,154.06,90.93,464953.08,274426.74,190526.34
Middle East and North Africa,Libya,Baby Food,Offline,C,10/31/2016,246222341,12/9/2016,1517,255.28,159.42,387259.76,241840.14,145419.62
Asia,Japan,Cereal,Offline,C,4/10/2010,161442649,5/12/2010,3322,205.70,117.11,683335.40,389039.42,294295.98
Sub-Saharan Africa,Chad,Fruits,Offline,H,8/16/2011,645713555,8/31/2011,9845,9.33,6.92,91853.85,68127.40,23726.45
Europe,Armenia,Cereal,Online,H,11/24/2014,683458888,12/28/2014,9528,205.70,117.11,1959909.60,1115824.08,844085.52
Sub-Saharan Africa,Eritrea,Cereal,Online,H,3/4/2015,679414975,4/17/2015,2844,205.70,117.11,585010.80,333060.84,251949.96
Europe,Montenegro,Clothes,Offline,M,5/17/2012,208630645,6/28/2012,7299,109.28,35.84,797634.72,261596.16,536038.56
Central America and the Caribbean,Jamaica,Vegetables,Online,H,1/29/2015,266467225,3/7/2015,2428,154.06,90.93,374057.68,220778.04,153279.64
Australia and Oceania,Fiji,Vegetables,Offline,H,12/24/2013,118598544,1/19/2014,4800,154.06,90.93,739488.00,436464.00,303024.00
Sub-Saharan Africa,Togo,Clothes,Online,M,12/29/2015,451010930,1/19/2016,3012,109.28,35.84,329151.36,107950.08,221201.28
Europe,Montenegro,Snacks,Offline,M,2/27/2010,220003211,3/18/2010,2694,152.58,97.44,411050.52,262503.36,148547.16
Europe,Greece,Household,Online,C,11/17/2016,702186715,12/22/2016,1508,668.27,502.54,1007751.16,757830.32,249920.84
Sub-Saharan Africa,Sudan,Cosmetics,Online,C,12/20/2015,544485270,1/5/2016,4146,437.20,263.33,1812631.20,1091766.18,720865.02
Asia,Maldives,Fruits,Offline,L,1/8/2011,714135205,2/6/2011,7332,9.33,6.92,68407.56,50737.44,17670.12
Europe,Montenegro,Clothes,Offline,H,6/28/2010,448685348,7/22/2010,4820,109.28,35.84,526729.60,172748.80,353980.80
Europe,Estonia,Office Supplies,Online,H,4/25/2016,405997025,5/12/2016,2397,651.21,524.96,1560950.37,1258329.12,302621.25
North America,Greenland,Beverages,Online,M,7/27/2012,414244067,8/7/2012,2880,47.45,31.79,136656.00,91555.20,45100.80
Sub-Saharan Africa,Cape Verde,Clothes,Online,C,9/8/2014,821912801,10/3/2014,1117,109.28,35.84,122065.76,40033.28,82032.48
Sub-Saharan Africa,Senegal,Household,Offline,L,8/27/2012,247802054,9/8/2012,8989,668.27,502.54,6007079.03,4517332.06,1489746.97
Australia and Oceania,Federated States of Micronesia,Snacks,Online,C,9/3/2012,531023156,10/15/2012,407,152.58,97.44,62100.06,39658.08,22441.98
Europe,Bulgaria,Clothes,Online,L,8/27/2010,880999934,9/16/2010,6313,109.28,35.84,689884.64,226257.92,463626.72
Middle East and North Africa,Algeria,Personal Care,Online,H,2/20/2011,127468717,3/9/2011,9681,81.73,56.67,791228.13,548622.27,242605.86
Asia,Mongolia,Clothes,Online,L,12/12/2015,770478332,1/24/2016,515,109.28,35.84,56279.20,18457.60,37821.60
Central America and the Caribbean,Grenada,Cereal,Online,H,10/28/2012,430390107,11/13/2012,852,205.70,117.11,175256.40,99777.72,75478.68
Central America and the Caribbean,Grenada,Beverages,Online,M,1/30/2017,397877871,3/20/2017,9759,47.45,31.79,463064.55,310238.61,152825.94
Sub-Saharan Africa,Senegal,Beverages,Offline,M,10/22/2014,683927953,11/4/2014,8334,47.45,31.79,395448.30,264937.86,130510.44
North America,Greenland,Fruits,Offline,M,1/31/2012,469839179,2/22/2012,4709,9.33,6.92,43934.97,32586.28,11348.69
Sub-Saharan Africa,Chad,Meat,Offline,H,1/20/2016,357222878,3/9/2016,9043,421.89,364.69,3815151.27,3297891.67,517259.60
Sub-Saharan Africa,Mauritius ,Personal Care,Online,C,1/1/2016,118002879,1/7/2016,8529,81.73,56.67,697075.17,483338.43,213736.74
Middle East and North Africa,Morocco,Beverages,Offline,C,6/1/2017,944415509,6/23/2017,2391,47.45,31.79,113452.95,76009.89,37443.06
Central America and the Caribbean,Honduras,Office Supplies,Online,H,6/30/2015,499009597,7/9/2015,6884,651.21,524.96,4482929.64,3613824.64,869105.00
Sub-Saharan Africa,Benin,Fruits,Online,L,1/28/2014,564646470,3/16/2014,293,9.33,6.92,2733.69,2027.56,706.13
Europe,Greece,Baby Food,Offline,M,4/8/2014,294499957,4/8/2014,7937,255.28,159.42,2026157.36,1265316.54,760840.82
Central America and the Caribbean,Jamaica,Beverages,Offline,L,9/4/2010,262056386,10/24/2010,7163,47.45,31.79,339884.35,227711.77,112172.58
Sub-Saharan Africa,Equatorial Guinea,Office Supplies,Online,M,5/2/2010,211114585,5/14/2010,2352,651.21,524.96,1531645.92,1234705.92,296940.00
Sub-Saharan Africa,Swaziland,Office Supplies,Offline,H,10/3/2013,405785882,10/22/2013,9915,651.21,524.96,6456747.15,5204978.40,1251768.75
Central America and the Caribbean,Trinidad and Tobago,Vegetables,Offline,M,3/6/2011,280494105,4/14/2011,3294,154.06,90.93,507473.64,299523.42,207950.22
Europe,Sweden,Baby Food,Online,L,8/7/2016,689975583,8/12/2016,7963,255.28,159.42,2032794.64,1269461.46,763333.18
Europe,Belarus,Office Supplies,Online,L,1/11/2011,759279143,2/18/2011,6426,651.21,524.96,4184675.46,3373392.96,811282.50
Sub-Saharan Africa,Guinea-Bissau,Office Supplies,Offline,C,5/21/2014,133766114,6/12/2014,3221,651.21,524.96,2097547.41,1690896.16,406651.25
Asia,Mongolia,Beverages,Online,M,8/3/2013,329110324,9/2/2013,9913,47.45,31.79,470371.85,315134.27,155237.58
Middle East and North Africa,Turkey,Meat,Online,L,10/5/2011,681298100,11/20/2011,103,421.89,364.69,43454.67,37563.07,5891.60
Sub-Saharan Africa,Central African Republic,Snacks,Offline,L,11/15/2016,596628272,12/30/2016,4419,152.58,97.44,674251.02,430587.36,243663.66
Sub-Saharan Africa,Equatorial Guinea,Office Supplies,Offline,L,4/3/2015,901712167,4/17/2015,5523,651.21,524.96,3596632.83,2899354.08,697278.75
Asia,Laos,Beverages,Online,M,3/22/2013,693473613,4/21/2013,3107,47.45,31.79,147427.15,98771.53,48655.62
Europe,Armenia,Meat,Online,C,8/2/2010,489148938,9/1/2010,8896,421.89,364.69,3753133.44,3244282.24,508851.20
Europe,Greece,Household,Online,L,1/5/2012,876286971,2/15/2012,1643,668.27,502.54,1097967.61,825673.22,272294.39
Middle East and North Africa,Israel,Personal Care,Offline,H,8/26/2015,262749040,8/30/2015,2135,81.73,56.67,174493.55,120990.45,53503.10
Asia,Bhutan,Meat,Online,H,12/9/2016,726708972,1/26/2017,8189,421.89,364.69,3454857.21,2986446.41,468410.80
Australia and Oceania,Vanuatu,Vegetables,Online,L,5/17/2012,366653096,5/31/2012,9654,154.06,90.93,1487295.24,877838.22,609457.02
Sub-Saharan Africa,Burundi,Vegetables,Online,M,11/17/2010,951380240,12/20/2010,3410,154.06,90.93,525344.60,310071.30,215273.30
Europe,Ukraine,Cosmetics,Online,M,11/13/2014,270001733,1/1/2015,8368,437.20,263.33,3658489.60,2203545.44,1454944.16
Europe,Croatia,Beverages,Online,C,6/16/2016,681941401,7/28/2016,470,47.45,31.79,22301.50,14941.30,7360.20
Sub-Saharan Africa,Madagascar,Fruits,Online,L,5/31/2016,566935575,6/7/2016,7690,9.33,6.92,71747.70,53214.80,18532.90
Asia,Malaysia,Snacks,Offline,M,10/6/2012,175033080,11/5/2012,5033,152.58,97.44,767935.14,490415.52,277519.62
Asia,Uzbekistan,Office Supplies,Offline,L,3/10/2012,276595246,3/15/2012,9535,651.21,524.96,6209287.35,5005493.60,1203793.75
Europe,Italy,Office Supplies,Online,M,1/26/2011,812295901,2/13/2011,5263,651.21,524.96,3427318.23,2762864.48,664453.75
Asia,Nepal,Vegetables,Offline,C,6/2/2014,443121373,6/19/2014,8316,154.06,90.93,1281162.96,756173.88,524989.08
Australia and Oceania,Fiji,Personal Care,Offline,H,12/17/2016,600370490,1/25/2017,1824,81.73,56.67,149075.52,103366.08,45709.44
Europe,Portugal,Office Supplies,Online,L,6/27/2014,535654580,7/29/2014,949,651.21,524.96,617998.29,498187.04,119811.25
Central America and the Caribbean,Panama,Cosmetics,Offline,H,3/17/2015,470897471,4/22/2015,7881,437.20,263.33,3445573.20,2075303.73,1370269.47
Europe,Belarus,Beverages,Offline,L,4/3/2013,248335492,4/4/2013,6846,47.45,31.79,324842.70,217634.34,107208.36
Sub-Saharan Africa,Botswana,Clothes,Offline,C,3/8/2015,680517470,3/25/2015,9097,109.28,35.84,994120.16,326036.48,668083.68
Sub-Saharan Africa,Tanzania,Personal Care,Online,M,6/21/2013,400304734,7/29/2013,7921,81.73,56.67,647383.33,448883.07,198500.26
Europe,Romania,Office Supplies,Offline,C,1/6/2013,810871112,1/8/2013,3636,651.21,524.96,2367799.56,1908754.56,459045.00
Sub-Saharan Africa,Mali,Cereal,Online,L,3/17/2012,235702931,4/3/2012,8590,205.70,117.11,1766963.00,1005974.90,760988.10
Sub-Saharan Africa,Central African Republic,Office Supplies,Offline,C,4/18/2014,668599021,5/12/2014,2163,651.21,524.96,1408567.23,1135488.48,273078.75
Sub-Saharan Africa,Niger,Baby Food,Online,M,1/3/2016,123670709,2/1/2016,5766,255.28,159.42,1471944.48,919215.72,552728.76
Europe,Austria,Office Supplies,Online,L,5/12/2011,285341823,6/8/2011,7841,651.21,524.96,5106137.61,4116211.36,989926.25
Asia,India,Fruits,Online,H,7/29/2010,658348691,8/22/2010,8862,9.33,6.92,82682.46,61325.04,21357.42
Europe,Luxembourg,Baby Food,Offline,L,8/2/2013,817740142,8/19/2013,6335,255.28,159.42,1617198.80,1009925.70,607273.10
Sub-Saharan Africa,Cape Verde,Beverages,Offline,H,10/23/2013,858877503,11/6/2013,9794,47.45,31.79,464725.30,311351.26,153374.04
Europe,Sweden,Vegetables,Offline,M,2/5/2017,947434604,2/19/2017,5808,154.06,90.93,894780.48,528121.44,366659.04
Europe,Iceland,Meat,Offline,H,3/20/2015,869397771,4/17/2015,2975,421.89,364.69,1255122.75,1084952.75,170170.00
Middle East and North Africa,Qatar,Personal Care,Offline,L,5/6/2012,481065833,5/8/2012,6925,81.73,56.67,565980.25,392439.75,173540.50
Sub-Saharan Africa,South Sudan,Meat,Online,C,9/30/2013,159050118,10/1/2013,5319,421.89,364.69,2244032.91,1939786.11,304246.80
Europe,United Kingdom,Office Supplies,Online,M,5/20/2014,350274455,6/14/2014,2850,651.21,524.96,1855948.50,1496136.00,359812.50
Middle East and North Africa,Tunisia ,Cereal,Online,L,4/9/2010,221975171,5/17/2010,6241,205.70,117.11,1283773.70,730883.51,552890.19
North America,United States of America,Office Supplies,Online,C,6/9/2017,811701095,7/19/2017,9247,651.21,524.96,6021738.87,4854305.12,1167433.75
Sub-Saharan Africa,Liberia,Cereal,Online,L,2/8/2015,977313554,3/29/2015,7653,205.70,117.11,1574222.10,896242.83,677979.27
Sub-Saharan Africa,Eritrea,Snacks,Offline,L,1/25/2010,546986377,2/10/2010,4279,152.58,97.44,652889.82,416945.76,235944.06
Asia,South Korea,Fruits,Offline,L,3/7/2010,769205892,3/17/2010,3972,9.33,6.92,37058.76,27486.24,9572.52
Sub-Saharan Africa,Kenya,Clothes,Offline,M,1/3/2013,262770926,2/8/2013,8611,109.28,35.84,941010.08,308618.24,632391.84
Sub-Saharan Africa,Rwanda,Snacks,Online,M,3/6/2017,866792809,3/18/2017,2109,152.58,97.44,321791.22,205500.96,116290.26
Central America and the Caribbean,Cuba,Beverages,Offline,C,1/9/2011,890695369,2/23/2011,5408,47.45,31.79,256609.60,171920.32,84689.28
Middle East and North Africa,Libya,Cereal,Offline,M,3/27/2014,964214932,3/31/2014,1480,205.70,117.11,304436.00,173322.80,131113.20
Europe,Czech Republic,Snacks,Online,C,6/28/2013,887400329,8/17/2013,332,152.58,97.44,50656.56,32350.08,18306.48
Europe,Montenegro,Beverages,Offline,M,9/4/2011,980612885,9/4/2011,3999,47.45,31.79,189752.55,127128.21,62624.34
Europe,Montenegro,Clothes,Offline,M,7/14/2016,734526431,8/2/2016,1549,109.28,35.84,169274.72,55516.16,113758.56
Asia,Philippines,Baby Food,Online,L,2/23/2014,160127294,3/23/2014,4079,255.28,159.42,1041287.12,650274.18,391012.94
Central America and the Caribbean,El Salvador,Clothes,Offline,L,8/7/2010,238714301,9/13/2010,9721,109.28,35.84,1062310.88,348400.64,713910.24
Australia and Oceania,Tonga,Household,Online,M,1/14/2013,671898782,2/6/2013,8635,668.27,502.54,5770511.45,4339432.90,1431078.55
Sub-Saharan Africa,Democratic Republic of the Congo,Personal Care,Offline,H,9/30/2010,331604564,11/17/2010,8014,81.73,56.67,654984.22,454153.38,200830.84
Middle East and North Africa,Afghanistan,Cereal,Online,M,10/13/2016,410067975,11/20/2016,7081,205.70,117.11,1456561.70,829255.91,627305.79
Australia and Oceania,Tuvalu,Snacks,Offline,L,3/16/2011,369837844,3/23/2011,2091,152.58,97.44,319044.78,203747.04,115297.74
Sub-Saharan Africa,Sudan,Fruits,Online,L,12/26/2012,193775498,1/31/2013,1331,9.33,6.92,12418.23,9210.52,3207.71
Sub-Saharan Africa,Niger,Clothes,Online,M,9/2/2015,835054767,10/9/2015,117,109.28,35.84,12785.76,4193.28,8592.48
Sub-Saharan Africa,Gabon,Household,Offline,C,11/11/2013,167161977,12/24/2013,5798,668.27,502.54,3874629.46,2913726.92,960902.54
Australia and Oceania,East Timor,Vegetables,Offline,C,8/4/2014,633895957,8/22/2014,2755,154.06,90.93,424435.30,250512.15,173923.15
North America,United States of America,Clothes,Offline,C,10/21/2010,699368035,12/7/2010,7398,109.28,35.84,808453.44,265144.32,543309.12
Middle East and North Africa,Jordan,Vegetables,Offline,L,6/13/2015,698002040,7/29/2015,3170,154.06,90.93,488370.20,288248.10,200122.10
Europe,Cyprus,Snacks,Offline,H,3/29/2012,584534299,5/18/2012,5544,152.58,97.44,845903.52,540207.36,305696.16
Sub-Saharan Africa,Malawi,Vegetables,Online,L,6/22/2012,384013640,7/19/2012,7025,154.06,90.93,1082271.50,638783.25,443488.25
Europe,Iceland,Personal Care,Online,M,5/10/2013,641801393,5/24/2013,2149,81.73,56.67,175637.77,121783.83,53853.94
Middle East and North Africa,Israel,Personal Care,Online,M,12/10/2016,173571383,1/11/2017,2484,81.73,56.67,203017.32,140768.28,62249.04
Middle East and North Africa,United Arab Emirates,Snacks,Offline,H,3/20/2011,115309941,4/6/2011,1629,152.58,97.44,248552.82,158729.76,89823.06
Asia,China,Cosmetics,Offline,L,9/22/2011,773315894,11/4/2011,213,437.20,263.33,93123.60,56089.29,37034.31
Sub-Saharan Africa,Kenya,Beverages,Online,M,5/11/2012,274200570,6/26/2012,897,47.45,31.79,42562.65,28515.63,14047.02
Middle East and North Africa,Somalia,Clothes,Offline,M,11/15/2011,414887797,11/17/2011,3374,109.28,35.84,368710.72,120924.16,247786.56
Australia and Oceania,Tonga,Beverages,Offline,L,1/27/2010,812613904,1/29/2010,9367,47.45,31.79,444464.15,297776.93,146687.22
Asia,Bangladesh,Baby Food,Online,H,8/17/2011,254927718,9/7/2011,7632,255.28,159.42,1948296.96,1216693.44,731603.52
Middle East and North Africa,Egypt,Beverages,Offline,M,9/6/2014,749690568,10/26/2014,8954,47.45,31.79,424867.30,284647.66,140219.64
Sub-Saharan Africa,Eritrea,Cereal,Offline,C,9/3/2014,775076282,9/19/2014,1150,205.70,117.11,236555.00,134676.50,101878.50
Sub-Saharan Africa,Swaziland,Office Supplies,Online,H,9/5/2015,229571187,9/18/2015,4071,651.21,524.96,2651075.91,2137112.16,513963.75
Asia,Vietnam,Baby Food,Online,C,6/20/2011,881974112,7/11/2011,4594,255.28,159.42,1172756.32,732375.48,440380.84
Australia and Oceania,Marshall Islands,Snacks,Online,L,1/12/2012,521396386,2/14/2012,1632,152.58,97.44,249010.56,159022.08,89988.48
Asia,Taiwan,Household,Online,C,1/23/2017,607261836,2/22/2017,1127,668.27,502.54,753140.29,566362.58,186777.71
Europe,Ireland,Vegetables,Online,M,3/4/2012,419306790,3/12/2012,1052,154.06,90.93,162071.12,95658.36,66412.76
Sub-Saharan Africa,Rwanda,Meat,Offline,H,7/18/2010,207580077,7/18/2010,6413,421.89,364.69,2705580.57,2338756.97,366823.60
Europe,Sweden,Snacks,Online,M,4/12/2011,742443025,4/15/2011,4245,152.58,97.44,647702.10,413632.80,234069.30
Sub-Saharan Africa,Gabon,Snacks,Offline,M,10/3/2010,164569461,10/5/2010,8615,152.58,97.44,1314476.70,839445.60,475031.10
Sub-Saharan Africa,South Africa,Baby Food,Online,L,12/29/2013,734945714,2/12/2014,5624,255.28,159.42,1435694.72,896578.08,539116.64
Europe,United Kingdom,Clothes,Offline,C,9/19/2015,284870612,10/7/2015,8399,109.28,35.84,917842.72,301020.16,616822.56
Europe,Albania,Fruits,Offline,M,9/17/2011,765955483,10/7/2011,2104,9.33,6.92,19630.32,14559.68,5070.64
Asia,Malaysia,Snacks,Offline,H,3/11/2010,600124156,4/21/2010,8929,152.58,97.44,1362386.82,870041.76,492345.06
Sub-Saharan Africa,Ghana,Household,Offline,L,11/10/2012,529612958,12/11/2012,3098,668.27,502.54,2070300.46,1556868.92,513431.54
Central America and the Caribbean,Cuba,Clothes,Offline,H,2/16/2011,466970717,3/18/2011,5867,109.28,35.84,641145.76,210273.28,430872.48
Central America and the Caribbean,Saint Lucia,Cosmetics,Online,C,8/13/2012,845058763,9/22/2012,522,437.20,263.33,228218.40,137458.26,90760.14
Europe,Romania,Snacks,Offline,L,8/28/2014,367050921,8/31/2014,7379,152.58,97.44,1125887.82,719009.76,406878.06
Europe,Portugal,Office Supplies,Online,L,8/19/2015,956433522,9/12/2015,8788,651.21,524.96,5722833.48,4613348.48,1109485.00
Europe,Macedonia,Beverages,Online,C,3/20/2011,107005393,5/4/2011,4129,47.45,31.79,195921.05,131260.91,64660.14
Asia,China,Beverages,Offline,C,4/16/2013,332877862,5/7/2013,4811,47.45,31.79,228281.95,152941.69,75340.26
Europe,Germany,Baby Food,Online,L,11/13/2015,618474757,12/31/2015,9279,255.28,159.42,2368743.12,1479258.18,889484.94
Europe,Ireland,Household,Online,M,1/10/2014,468532407,2/11/2014,8006,668.27,502.54,5350169.62,4023335.24,1326834.38
Europe,Poland,Office Supplies,Offline,M,4/9/2015,358099639,4/29/2015,8496,651.21,524.96,5532680.16,4460060.16,1072620.00
Sub-Saharan Africa,Namibia,Household,Online,H,1/7/2013,382537782,1/27/2013,285,668.27,502.54,190456.95,143223.90,47233.05
Asia,Uzbekistan,Personal Care,Offline,H,2/12/2013,707520663,3/15/2013,9942,81.73,56.67,812559.66,563413.14,249146.52
Sub-Saharan Africa,Zimbabwe,Meat,Online,M,11/28/2014,219034612,12/10/2014,6064,421.89,364.69,2558340.96,2211480.16,346860.80
Asia,Mongolia,Meat,Offline,M,1/3/2015,573378455,1/17/2015,4281,421.89,364.69,1806111.09,1561237.89,244873.20
Europe,Norway,Personal Care,Online,H,2/3/2011,347163522,3/22/2011,2256,81.73,56.67,184382.88,127847.52,56535.36
Middle East and North Africa,Oman,Snacks,Offline,M,4/9/2013,887313640,4/21/2013,4679,152.58,97.44,713921.82,455921.76,258000.06
Europe,Serbia,Cosmetics,Online,H,7/26/2017,461065137,8/19/2017,8275,437.20,263.33,3617830.00,2179055.75,1438774.25
Sub-Saharan Africa,Democratic Republic of the Congo,Fruits,Offline,H,4/15/2017,105966842,5/19/2017,6798,9.33,6.92,63425.34,47042.16,16383.18
Europe,Bulgaria,Baby Food,Online,M,5/16/2014,479880082,5/23/2014,6035,255.28,159.42,1540614.80,962099.70,578515.10
Asia,Brunei,Baby Food,Online,H,8/12/2015,510978686,9/30/2015,8803,255.28,159.42,2247229.84,1403374.26,843855.58
Europe,Serbia,Snacks,Offline,C,9/20/2013,547748982,10/14/2013,9951,152.58,97.44,1518323.58,969625.44,548698.14
Sub-Saharan Africa,Ghana,Cereal,Offline,M,10/31/2013,108989799,12/9/2013,1358,205.70,117.11,279340.60,159035.38,120305.22
Sub-Saharan Africa,Malawi,Cereal,Offline,M,7/30/2014,133812463,8/9/2014,6936,205.70,117.11,1426735.20,812274.96,614460.24
Sub-Saharan Africa,Zimbabwe,Fruits,Offline,L,11/12/2011,731640803,12/30/2011,7627,9.33,6.92,71159.91,52778.84,18381.07
Europe,Cyprus,Snacks,Offline,C,3/25/2010,732211148,4/14/2010,6405,152.58,97.44,977274.90,624103.20,353171.70
Central America and the Caribbean,Nicaragua,Cereal,Online,M,7/4/2011,835572326,8/8/2011,3274,205.70,117.11,673461.80,383418.14,290043.66
Europe,Estonia,Baby Food,Offline,C,1/1/2011,462085664,1/15/2011,271,255.28,159.42,69180.88,43202.82,25978.06
Europe,Estonia,Clothes,Online,C,6/16/2016,902424991,7/4/2016,6463,109.28,35.84,706276.64,231633.92,474642.72
Europe,Lithuania,Fruits,Offline,H,12/17/2013,367576634,1/5/2014,2949,9.33,6.92,27514.17,20407.08,7107.09
Sub-Saharan Africa,Republic of the Congo,Meat,Offline,H,3/1/2017,738839423,3/31/2017,7859,421.89,364.69,3315633.51,2866098.71,449534.80
Europe,Czech Republic,Baby Food,Online,C,7/2/2010,817824685,7/27/2010,1353,255.28,159.42,345393.84,215695.26,129698.58
Sub-Saharan Africa,Cameroon,Snacks,Online,C,7/16/2013,376456248,8/1/2013,624,152.58,97.44,95209.92,60802.56,34407.36
Asia,Vietnam,Office Supplies,Online,H,8/16/2016,606970441,9/16/2016,4897,651.21,524.96,3188975.37,2570729.12,618246.25
Europe,Moldova ,Meat,Offline,L,12/16/2014,971916091,1/19/2015,424,421.89,364.69,178881.36,154628.56,24252.80
Middle East and North Africa,Bahrain,Office Supplies,Offline,L,5/14/2012,554154527,5/15/2012,5494,651.21,524.96,3577747.74,2884130.24,693617.50
Europe,Hungary,Household,Online,L,7/18/2017,306859576,7/19/2017,5423,668.27,502.54,3624028.21,2725274.42,898753.79
Australia and Oceania,Marshall Islands,Personal Care,Offline,L,7/9/2017,803517568,7/21/2017,7559,81.73,56.67,617797.07,428368.53,189428.54
Middle East and North Africa,Iraq,Office Supplies,Online,C,9/30/2011,887927329,10/2/2011,6283,651.21,524.96,4091552.43,3298323.68,793228.75
Europe,Albania,Vegetables,Online,H,11/24/2015,824200189,11/26/2015,8006,154.06,90.93,1233404.36,727985.58,505418.78
Sub-Saharan Africa,Lesotho,Office Supplies,Online,H,8/14/2012,946759974,9/14/2012,6170,651.21,524.96,4017965.70,3239003.20,778962.50
Middle East and North Africa,Lebanon,Clothes,Offline,H,12/6/2015,310343015,12/28/2015,6249,109.28,35.84,682890.72,223964.16,458926.56
Europe,Hungary,Vegetables,Online,C,5/25/2014,739998137,7/9/2014,748,154.06,90.93,115236.88,68015.64,47221.24
Asia,Japan,Beverages,Online,H,10/18/2012,981086671,11/21/2012,4203,47.45,31.79,199432.35,133613.37,65818.98
Europe,Georgia,Office Supplies,Offline,L,3/13/2013,749282443,3/25/2013,8180,651.21,524.96,5326897.80,4294172.80,1032725.00
Europe,Estonia,Office Supplies,Online,C,2/23/2011,280571782,3/11/2011,6280,651.21,524.96,4089598.80,3296748.80,792850.00
Europe,Luxembourg,Household,Online,C,8/15/2014,781253516,9/1/2014,9131,668.27,502.54,6101973.37,4588692.74,1513280.63
Sub-Saharan Africa,Swaziland,Personal Care,Online,H,7/6/2017,377938973,7/11/2017,9396,81.73,56.67,767935.08,532471.32,235463.76
Europe,Romania,Clothes,Offline,C,12/31/2010,867551982,1/3/2011,6765,109.28,35.84,739279.20,242457.60,496821.60
Sub-Saharan Africa,Ethiopia,Personal Care,Offline,C,1/13/2010,967328870,1/15/2010,2964,81.73,56.67,242247.72,167969.88,74277.84
Sub-Saharan Africa,Chad,Office Supplies,Offline,C,9/17/2011,364818465,10/16/2011,6746,651.21,524.96,4393062.66,3541380.16,851682.50
Middle East and North Africa,Morocco,Office Supplies,Online,C,3/8/2014,167882096,3/31/2014,8898,651.21,524.96,5794466.58,4671094.08,1123372.50
North America,Mexico,Clothes,Online,H,11/18/2012,654693591,12/1/2012,7237,109.28,35.84,790859.36,259374.08,531485.28
Sub-Saharan Africa,Nigeria,Personal Care,Offline,H,11/18/2011,823739278,12/29/2011,1612,81.73,56.67,131748.76,91352.04,40396.72
Central America and the Caribbean,Trinidad and Tobago,Beverages,Offline,L,7/12/2012,643817985,8/19/2012,8904,47.45,31.79,422494.80,283058.16,139436.64
Europe,Moldova ,Personal Care,Offline,H,3/30/2017,604041039,5/15/2017,8022,81.73,56.67,655638.06,454606.74,201031.32
Australia and Oceania,Solomon Islands,Personal Care,Online,H,7/26/2010,363832271,9/12/2010,4909,81.73,56.67,401212.57,278193.03,123019.54
Asia,India,Personal Care,Online,L,12/24/2015,102928006,1/31/2016,7539,81.73,56.67,616162.47,427235.13,188927.34
Sub-Saharan Africa,Burkina Faso,Office Supplies,Offline,M,5/15/2016,971377074,5/15/2016,917,651.21,524.96,597159.57,481388.32,115771.25
Australia and Oceania,Kiribati,Meat,Online,L,11/3/2010,139540803,12/4/2010,2079,421.89,364.69,877109.31,758190.51,118918.80
Middle East and North Africa,Israel,Meat,Offline,M,12/1/2010,248093020,12/16/2010,5093,421.89,364.69,2148685.77,1857366.17,291319.60
Sub-Saharan Africa,Comoros,Snacks,Offline,L,1/16/2014,858020055,1/17/2014,6056,152.58,97.44,924024.48,590096.64,333927.84
Middle East and North Africa,Iran,Baby Food,Offline,H,12/11/2014,700620734,1/5/2015,8099,255.28,159.42,2067512.72,1291142.58,776370.14
Asia,Vietnam,Cosmetics,Offline,L,12/24/2016,827506387,1/30/2017,6384,437.20,263.33,2791084.80,1681098.72,1109986.08
Central America and the Caribbean,Belize,Household,Online,M,3/21/2013,560600841,4/14/2013,3101,668.27,502.54,2072305.27,1558376.54,513928.73
Europe,Belarus,Personal Care,Offline,H,12/8/2012,642140424,1/16/2013,2476,81.73,56.67,202363.48,140314.92,62048.56
North America,United States of America,Baby Food,Offline,C,2/13/2015,984673964,3/5/2015,5763,255.28,159.42,1471178.64,918737.46,552441.18
Europe,Poland,Beverages,Online,L,3/28/2012,221062791,4/18/2012,6247,47.45,31.79,296420.15,198592.13,97828.02
North America,Canada,Vegetables,Offline,L,10/7/2016,654480731,11/8/2016,4247,154.06,90.93,654292.82,386179.71,268113.11
Middle East and North Africa,Israel,Beverages,Offline,C,12/15/2011,608414113,12/23/2011,2111,47.45,31.79,100166.95,67108.69,33058.26
Middle East and North Africa,Lebanon,Household,Online,L,3/8/2016,276661765,4/20/2016,9219,668.27,502.54,6160781.13,4632916.26,1527864.87
Europe,Andorra,Baby Food,Online,L,1/18/2011,373335015,2/28/2011,6982,255.28,159.42,1782364.96,1113070.44,669294.52
Europe,Slovakia,Clothes,Online,L,4/11/2013,782857692,5/28/2013,3843,109.28,35.84,419963.04,137733.12,282229.92
Sub-Saharan Africa,Liberia,Fruits,Online,H,5/18/2010,109966123,6/5/2010,274,9.33,6.92,2556.42,1896.08,660.34
Central America and the Caribbean,Antigua and Barbuda ,Cereal,Offline,M,6/5/2017,629709136,6/6/2017,3782,205.70,117.11,777957.40,442910.02,335047.38
Asia,China,Personal Care,Online,L,9/11/2012,637448060,9/15/2012,3901,81.73,56.67,318828.73,221069.67,97759.06
Sub-Saharan Africa,Niger,Baby Food,Online,H,3/8/2017,298856723,4/3/2017,7200,255.28,159.42,1838016.00,1147824.00,690192.00
Europe,United Kingdom,Household,Offline,L,1/28/2015,299921452,2/23/2015,2278,668.27,502.54,1522319.06,1144786.12,377532.94
Asia,Bangladesh,Personal Care,Offline,M,7/26/2010,496941077,7/29/2010,4763,81.73,56.67,389279.99,269919.21,119360.78
Asia,Myanmar,Snacks,Online,L,6/24/2016,366526925,7/14/2016,2317,152.58,97.44,353527.86,225768.48,127759.38
Australia and Oceania,Tonga,Meat,Offline,M,8/18/2012,355602824,9/15/2012,9633,421.89,364.69,4064066.37,3513058.77,551007.60
Sub-Saharan Africa,Guinea-Bissau,Vegetables,Online,C,3/11/2010,531405103,4/19/2010,3434,154.06,90.93,529042.04,312253.62,216788.42
Australia and Oceania,Nauru,Vegetables,Offline,M,1/14/2010,131482589,1/20/2010,7475,154.06,90.93,1151598.50,679701.75,471896.75
Sub-Saharan Africa,Swaziland,Cereal,Online,L,2/10/2014,713696610,3/28/2014,7542,205.70,117.11,1551389.40,883243.62,668145.78
Europe,Finland,Vegetables,Online,C,1/21/2014,306220996,1/30/2014,6452,154.06,90.93,993995.12,586680.36,407314.76
Australia and Oceania,Papua New Guinea,Household,Offline,L,2/28/2010,157542073,3/15/2010,9055,668.27,502.54,6051184.85,4550499.70,1500685.15
Sub-Saharan Africa,Mauritius ,Personal Care,Online,L,2/18/2015,686458671,3/8/2015,7230,81.73,56.67,590907.90,409724.10,181183.80
Sub-Saharan Africa,Mozambique,Office Supplies,Online,M,6/14/2012,132082116,7/22/2012,4888,651.21,524.96,3183114.48,2566004.48,617110.00
Europe,Bulgaria,Clothes,Online,L,3/5/2013,403836238,4/3/2013,2972,109.28,35.84,324780.16,106516.48,218263.68
Europe,Spain,Household,Online,C,4/10/2014,331457364,4/23/2014,4455,668.27,502.54,2977142.85,2238815.70,738327.15
Australia and Oceania,Vanuatu,Meat,Online,H,7/26/2017,614994323,9/12/2017,9341,421.89,364.69,3940874.49,3406569.29,534305.20
Europe,Belgium,Fruits,Offline,L,10/19/2010,674808442,10/24/2010,9669,9.33,6.92,90211.77,66909.48,23302.29
Europe,Belgium,Baby Food,Offline,L,11/8/2016,901573550,12/23/2016,4503,255.28,159.42,1149525.84,717868.26,431657.58
Sub-Saharan Africa,Guinea-Bissau,Clothes,Online,L,3/31/2014,406275975,5/10/2014,4944,109.28,35.84,540280.32,177192.96,363087.36
Sub-Saharan Africa,Togo,Vegetables,Online,C,8/18/2016,170214545,8/19/2016,9121,154.06,90.93,1405181.26,829372.53,575808.73
Sub-Saharan Africa,Cote d'Ivoire,Personal Care,Offline,C,1/3/2016,795000588,1/8/2016,7196,81.73,56.67,588129.08,407797.32,180331.76
Sub-Saharan Africa,Republic of the Congo,Fruits,Offline,C,10/21/2016,252557933,11/4/2016,6360,9.33,6.92,59338.80,44011.20,15327.60
Middle East and North Africa,Libya,Baby Food,Offline,M,12/10/2016,635122907,12/13/2016,5837,255.28,159.42,1490069.36,930534.54,559534.82
Australia and Oceania,East Timor,Vegetables,Online,C,8/12/2011,505244338,9/19/2011,1882,154.06,90.93,289940.92,171130.26,118810.66
Europe,Switzerland,Clothes,Offline,H,3/23/2012,745783555,5/9/2012,2782,109.28,35.84,304016.96,99706.88,204310.08
Australia and Oceania,Palau,Snacks,Offline,M,4/27/2012,509914386,6/11/2012,3853,152.58,97.44,587890.74,375436.32,212454.42
Middle East and North Africa,Jordan,Household,Online,M,1/29/2014,371123158,2/9/2014,2445,668.27,502.54,1633920.15,1228710.30,405209.85
Europe,Slovenia,Household,Online,H,12/13/2016,973208701,12/28/2016,2936,668.27,502.54,1962040.72,1475457.44,486583.28
Asia,South Korea,Baby Food,Online,L,11/21/2013,780282342,12/27/2013,1739,255.28,159.42,443931.92,277231.38,166700.54
Europe,Norway,Clothes,Online,H,4/7/2010,126767909,5/22/2010,2296,109.28,35.84,250906.88,82288.64,168618.24
Middle East and North Africa,Afghanistan,Baby Food,Online,M,7/8/2012,767401731,7/30/2012,80,255.28,159.42,20422.40,12753.60,7668.80
Asia,Bangladesh,Personal Care,Online,L,10/15/2016,927232635,11/24/2016,7597,81.73,56.67,620902.81,430521.99,190380.82
Sub-Saharan Africa,Guinea,Meat,Offline,M,9/18/2012,251621949,10/20/2012,9381,421.89,364.69,3957750.09,3421156.89,536593.20
Central America and the Caribbean,Cuba,Office Supplies,Offline,H,7/2/2017,256243503,7/23/2017,7002,651.21,524.96,4559772.42,3675769.92,884002.50
Europe,Russia,Cosmetics,Offline,C,7/21/2011,277083623,9/2/2011,4056,437.20,263.33,1773283.20,1068066.48,705216.72
Sub-Saharan Africa,Seychelles ,Vegetables,Offline,L,6/1/2010,620441138,6/22/2010,1175,154.06,90.93,181020.50,106842.75,74177.75
Asia,South Korea,Office Supplies,Offline,M,7/26/2015,312927377,9/7/2015,1020,651.21,524.96,664234.20,535459.20,128775.00
Sub-Saharan Africa,Ghana,Baby Food,Offline,L,8/6/2010,251466166,9/8/2010,3282,255.28,159.42,837828.96,523216.44,314612.52
Central America and the Caribbean,Costa Rica,Office Supplies,Online,H,6/20/2010,953293836,7/22/2010,9685,651.21,524.96,6306968.85,5084237.60,1222731.25
Europe,Romania,Cereal,Online,C,4/8/2012,305959212,4/23/2012,8985,205.70,117.11,1848214.50,1052233.35,795981.15
Europe,Czech Republic,Cereal,Online,L,2/27/2014,317323625,3/24/2014,1967,205.70,117.11,404611.90,230355.37,174256.53
Europe,Liechtenstein,Household,Offline,L,7/25/2011,365560901,9/1/2011,6449,668.27,502.54,4309673.23,3240880.46,1068792.77
Sub-Saharan Africa,Seychelles ,Baby Food,Online,M,2/18/2016,349157369,4/5/2016,2279,255.28,159.42,581783.12,363318.18,218464.94
Middle East and North Africa,Somalia,Baby Food,Online,L,1/24/2014,236911857,2/25/2014,6338,255.28,159.42,1617964.64,1010403.96,607560.68
Australia and Oceania,Solomon Islands,Personal Care,Offline,H,5/10/2015,517935693,6/16/2015,7536,81.73,56.67,615917.28,427065.12,188852.16
Sub-Saharan Africa,Uganda,Clothes,Offline,C,2/13/2012,851652705,3/27/2012,1816,109.28,35.84,198452.48,65085.44,133367.04
Sub-Saharan Africa,Equatorial Guinea,Cereal,Offline,M,9/7/2012,517799222,10/23/2012,7151,205.70,117.11,1470960.70,837453.61,633507.09
Central America and the Caribbean,Costa Rica,Office Supplies,Offline,C,2/4/2015,666424071,3/4/2015,8547,651.21,524.96,5565891.87,4486833.12,1079058.75
Europe,Moldova ,Fruits,Offline,C,11/16/2010,267888581,12/22/2010,3039,9.33,6.92,28353.87,21029.88,7323.99
Sub-Saharan Africa,Burkina Faso,Vegetables,Online,L,7/20/2011,162866580,7/26/2011,4695,154.06,90.93,723311.70,426916.35,296395.35
Central America and the Caribbean,Guatemala,Beverages,Offline,H,7/26/2014,812344396,8/30/2014,9614,47.45,31.79,456184.30,305629.06,150555.24
Sub-Saharan Africa,Swaziland,Meat,Online,M,8/24/2014,947620856,9/3/2014,924,421.89,364.69,389826.36,336973.56,52852.80
Asia,Maldives,Vegetables,Online,H,2/25/2015,720307290,3/28/2015,3789,154.06,90.93,583733.34,344533.77,239199.57
Asia,Thailand,Household,Online,H,9/21/2016,352327525,10/27/2016,399,668.27,502.54,266639.73,200513.46,66126.27
Sub-Saharan Africa,Sudan,Household,Online,C,6/28/2013,585917890,7/23/2013,4979,668.27,502.54,3327316.33,2502146.66,825169.67
Central America and the Caribbean,Costa Rica,Meat,Offline,L,1/5/2012,433627212,2/13/2012,8783,421.89,364.69,3705459.87,3203072.27,502387.60
Europe,Denmark,Beverages,Online,C,5/1/2012,328316819,5/30/2012,5098,47.45,31.79,241900.10,162065.42,79834.68
Sub-Saharan Africa,Angola,Cereal,Offline,C,10/13/2011,773160541,11/21/2011,4240,205.70,117.11,872168.00,496546.40,375621.60
Australia and Oceania,Papua New Guinea,Household,Online,M,4/27/2016,991644704,5/18/2016,8559,668.27,502.54,5719722.93,4301239.86,1418483.07
Asia,North Korea,Meat,Online,M,1/19/2014,277568137,2/7/2014,7435,421.89,364.69,3136752.15,2711470.15,425282.00
Central America and the Caribbean,El Salvador,Fruits,Online,C,11/6/2016,245042169,12/15/2016,2278,9.33,6.92,21253.74,15763.76,5489.98
Sub-Saharan Africa,Burkina Faso,Household,Online,M,2/28/2011,778490626,3/24/2011,1531,668.27,502.54,1023121.37,769388.74,253732.63
Middle East and North Africa,Yemen,Baby Food,Online,C,10/11/2014,482649838,11/13/2014,5668,255.28,159.42,1446927.04,903592.56,543334.48
Sub-Saharan Africa,Republic of the Congo,Beverages,Online,L,6/25/2012,732568633,7/5/2012,2193,47.45,31.79,104057.85,69715.47,34342.38
Europe,Andorra,Household,Online,M,11/6/2012,723608338,11/23/2012,642,668.27,502.54,429029.34,322630.68,106398.66
Central America and the Caribbean,Dominican Republic,Household,Offline,H,2/24/2014,621442782,4/14/2014,7584,668.27,502.54,5068159.68,3811263.36,1256896.32
Middle East and North Africa,Israel,Baby Food,Offline,M,9/19/2015,212058293,10/6/2015,1616,255.28,159.42,412532.48,257622.72,154909.76
Australia and Oceania,Solomon Islands,Snacks,Offline,L,3/4/2014,251753699,3/24/2014,8369,152.58,97.44,1276942.02,815475.36,461466.66
Sub-Saharan Africa,Liberia,Fruits,Online,M,10/8/2014,217140328,10/30/2014,5503,9.33,6.92,51342.99,38080.76,13262.23
Sub-Saharan Africa,Mali,Vegetables,Online,C,6/19/2012,555142009,7/10/2012,7712,154.06,90.93,1188110.72,701252.16,486858.56
Asia,Uzbekistan,Clothes,Online,C,11/11/2010,432995069,12/13/2010,1718,109.28,35.84,187743.04,61573.12,126169.92
Middle East and North Africa,Tunisia ,Personal Care,Offline,H,11/1/2010,888248336,11/7/2010,1276,81.73,56.67,104287.48,72310.92,31976.56
Europe,Vatican City,Vegetables,Online,C,4/28/2014,778763139,5/9/2014,2173,154.06,90.93,334772.38,197590.89,137181.49
Sub-Saharan Africa,Djibouti,Snacks,Offline,H,12/22/2012,832713305,2/9/2013,7227,152.58,97.44,1102695.66,704198.88,398496.78
Europe,Ukraine,Household,Offline,M,8/25/2014,498585164,9/29/2014,1285,668.27,502.54,858726.95,645763.90,212963.05
Australia and Oceania,East Timor,Fruits,Offline,M,11/26/2016,195177543,12/23/2016,6227,9.33,6.92,58097.91,43090.84,15007.07
Sub-Saharan Africa,Uganda,Cereal,Online,C,10/20/2010,861601769,12/2/2010,5965,205.70,117.11,1227000.50,698561.15,528439.35
Sub-Saharan Africa,Guinea,Meat,Online,H,12/18/2014,807281672,1/26/2015,1441,421.89,364.69,607943.49,525518.29,82425.20
Sub-Saharan Africa,Equatorial Guinea,Clothes,Offline,H,3/20/2011,661953580,4/24/2011,5629,109.28,35.84,615137.12,201743.36,413393.76
Europe,Malta,Cosmetics,Online,M,7/12/2016,225666320,8/21/2016,8534,437.20,263.33,3731064.80,2247258.22,1483806.58
Europe,Cyprus,Household,Offline,L,1/26/2011,718781220,2/19/2011,2191,668.27,502.54,1464179.57,1101065.14,363114.43
Europe,Czech Republic,Office Supplies,Online,L,2/24/2010,731972110,4/15/2010,5668,651.21,524.96,3691058.28,2975473.28,715585.00
Middle East and North Africa,Libya,Vegetables,Online,C,1/2/2015,276225316,2/9/2015,64,154.06,90.93,9859.84,5819.52,4040.32
Asia,Vietnam,Office Supplies,Offline,C,7/26/2016,332839667,7/27/2016,3509,651.21,524.96,2285095.89,1842084.64,443011.25
Middle East and North Africa,Jordan,Vegetables,Online,C,6/1/2014,603426492,6/15/2014,6163,154.06,90.93,949471.78,560401.59,389070.19
Sub-Saharan Africa,Mali,Beverages,Offline,H,12/21/2012,859909617,1/29/2013,5220,47.45,31.79,247689.00,165943.80,81745.20
Europe,Czech Republic,Household,Online,L,2/27/2010,494525372,3/2/2010,9902,668.27,502.54,6617209.54,4976151.08,1641058.46
Europe,Slovakia,Vegetables,Online,M,4/24/2016,769822585,5/15/2016,6465,154.06,90.93,995997.90,587862.45,408135.45
Sub-Saharan Africa,Zimbabwe,Vegetables,Offline,C,7/22/2012,768662583,8/10/2012,3195,154.06,90.93,492221.70,290521.35,201700.35
Central America and the Caribbean,Honduras,Cereal,Online,M,2/22/2015,544219195,3/9/2015,5409,205.70,117.11,1112631.30,633447.99,479183.31
Europe,Switzerland,Beverages,Offline,L,2/10/2011,669978749,3/20/2011,455,47.45,31.79,21589.75,14464.45,7125.30
Sub-Saharan Africa,South Africa,Cosmetics,Offline,L,1/21/2015,889740073,1/26/2015,2715,437.20,263.33,1186998.00,714940.95,472057.05
Sub-Saharan Africa,Uganda,Beverages,Online,M,5/10/2012,567614495,6/28/2012,8598,47.45,31.79,407975.10,273330.42,134644.68
Middle East and North Africa,Iran,Vegetables,Offline,M,12/16/2015,938025844,1/21/2016,1547,154.06,90.93,238330.82,140668.71,97662.11
Middle East and North Africa,Algeria,Vegetables,Online,C,2/25/2017,155710446,2/25/2017,7036,154.06,90.93,1083966.16,639783.48,444182.68
Sub-Saharan Africa,Central African Republic,Baby Food,Online,L,1/31/2012,945717132,2/13/2012,7570,255.28,159.42,1932469.60,1206809.40,725660.20
Central America and the Caribbean,The Bahamas,Cosmetics,Offline,C,2/7/2013,253407227,2/15/2013,7685,437.20,263.33,3359882.00,2023691.05,1336190.95
Sub-Saharan Africa,South Africa,Household,Offline,H,9/14/2014,494454562,9/22/2014,8948,668.27,502.54,5979679.96,4496727.92,1482952.04
Sub-Saharan Africa,Benin,Cereal,Online,M,6/5/2012,104845464,7/24/2012,4957,205.70,117.11,1019654.90,580514.27,439140.63
Europe,Hungary,Cosmetics,Online,M,4/5/2014,290878760,4/7/2014,6344,437.20,263.33,2773596.80,1670565.52,1103031.28
Europe,Austria,Office Supplies,Offline,C,2/2/2014,979165780,2/10/2014,5768,651.21,524.96,3756179.28,3027969.28,728210.00
Asia,Tajikistan,Office Supplies,Offline,C,9/1/2010,366630351,10/12/2010,2923,651.21,524.96,1903486.83,1534458.08,369028.75
Europe,Portugal,Office Supplies,Online,C,5/17/2011,770508801,6/25/2011,9532,651.21,524.96,6207333.72,5003918.72,1203415.00
Europe,Belgium,Beverages,Offline,M,4/21/2013,978349959,5/21/2013,4349,47.45,31.79,206360.05,138254.71,68105.34
Europe,Slovenia,Beverages,Offline,L,8/10/2014,298015153,8/14/2014,8161,47.45,31.79,387239.45,259438.19,127801.26
Europe,Czech Republic,Snacks,Online,M,9/19/2010,807678210,10/30/2010,8786,152.58,97.44,1340567.88,856107.84,484460.04
Australia and Oceania,Marshall Islands,Personal Care,Offline,C,4/13/2013,605825459,5/14/2013,6071,81.73,56.67,496182.83,344043.57,152139.26
Sub-Saharan Africa,Sudan,Fruits,Online,C,1/28/2016,561255729,2/1/2016,6897,9.33,6.92,64349.01,47727.24,16621.77
Central America and the Caribbean,Dominican Republic,Clothes,Online,H,12/9/2013,263080346,12/14/2013,175,109.28,35.84,19124.00,6272.00,12852.00
Sub-Saharan Africa,Tanzania,Cereal,Offline,C,2/21/2014,270723140,3/9/2014,1848,205.70,117.11,380133.60,216419.28,163714.32
Europe,Switzerland,Clothes,Offline,H,6/9/2017,763920438,7/10/2017,9888,109.28,35.84,1080560.64,354385.92,726174.72
North America,Greenland,Household,Online,L,4/17/2014,192721068,5/20/2014,9302,668.27,502.54,6216247.54,4674627.08,1541620.46
Australia and Oceania,Tonga,Fruits,Offline,L,5/20/2011,227486360,6/8/2011,7124,9.33,6.92,66466.92,49298.08,17168.84
Middle East and North Africa,Saudi Arabia,Vegetables,Online,M,8/28/2012,808890140,9/22/2012,7422,154.06,90.93,1143433.32,674882.46,468550.86
Central America and the Caribbean,Belize,Cosmetics,Offline,C,7/25/2015,597918736,9/11/2015,6296,437.20,263.33,2752611.20,1657925.68,1094685.52
Sub-Saharan Africa,Angola,Cosmetics,Online,H,10/27/2014,125870978,11/20/2014,6874,437.20,263.33,3005312.80,1810130.42,1195182.38
Asia,Malaysia,Household,Online,H,10/18/2013,444358193,10/21/2013,4319,668.27,502.54,2886258.13,2170470.26,715787.87
Sub-Saharan Africa,Ethiopia,Beverages,Online,C,2/15/2013,875304210,3/12/2013,822,47.45,31.79,39003.90,26131.38,12872.52
North America,Greenland,Baby Food,Offline,C,7/8/2014,360945355,8/16/2014,607,255.28,159.42,154954.96,96767.94,58187.02
Sub-Saharan Africa,Benin,Cereal,Offline,C,12/12/2016,613830459,1/16/2017,4928,205.70,117.11,1013689.60,577118.08,436571.52
Middle East and North Africa,Yemen,Cereal,Offline,H,11/24/2012,266820847,12/10/2012,7073,205.70,117.11,1454916.10,828319.03,626597.07
Sub-Saharan Africa,Rwanda,Baby Food,Offline,M,11/3/2014,723090350,11/27/2014,7358,255.28,159.42,1878350.24,1173012.36,705337.88
Sub-Saharan Africa,Mauritania,Meat,Offline,M,8/3/2013,306125295,8/15/2013,8132,421.89,364.69,3430809.48,2965659.08,465150.40
Australia and Oceania,New Zealand,Personal Care,Online,L,5/23/2012,109724509,6/16/2012,8775,81.73,56.67,717180.75,497279.25,219901.50
Australia and Oceania,Samoa ,Clothes,Offline,M,7/22/2015,847999322,8/6/2015,699,109.28,35.84,76386.72,25052.16,51334.56
Australia and Oceania,Fiji,Clothes,Online,H,2/1/2017,605373561,3/2/2017,2344,109.28,35.84,256152.32,84008.96,172143.36
Sub-Saharan Africa,Malawi,Beverages,Online,H,1/28/2012,686583554,2/22/2012,4186,47.45,31.79,198625.70,133072.94,65552.76
Australia and Oceania,Marshall Islands,Beverages,Offline,M,8/3/2015,666678130,9/21/2015,3729,47.45,31.79,176941.05,118544.91,58396.14
Central America and the Caribbean,Grenada,Baby Food,Online,M,6/23/2013,641018617,6/30/2013,508,255.28,159.42,129682.24,80985.36,48696.88
Europe,Luxembourg,Meat,Online,C,8/3/2011,775278842,9/22/2011,1093,421.89,364.69,461125.77,398606.17,62519.60
Sub-Saharan Africa,Zimbabwe,Meat,Offline,M,10/30/2016,855445134,12/6/2016,4080,421.89,364.69,1721311.20,1487935.20,233376.00
Asia,China,Vegetables,Online,H,9/5/2010,737816321,9/21/2010,5100,154.06,90.93,785706.00,463743.00,321963.00
North America,United States of America,Beverages,Online,L,7/13/2013,799003732,7/14/2013,1815,47.45,31.79,86121.75,57698.85,28422.90
Sub-Saharan Africa,Central African Republic,Vegetables,Online,L,10/9/2012,585931193,11/21/2012,8916,154.06,90.93,1373598.96,810731.88,562867.08
Central America and the Caribbean,Antigua and Barbuda ,Vegetables,Online,M,1/3/2012,165835034,1/5/2012,3127,154.06,90.93,481745.62,284338.11,197407.51
Central America and the Caribbean,Guatemala,Baby Food,Offline,H,2/8/2012,576264083,3/14/2012,8203,255.28,159.42,2094061.84,1307722.26,786339.58
Middle East and North Africa,Qatar,Clothes,Offline,L,1/3/2015,675079667,1/7/2015,9930,109.28,35.84,1085150.40,355891.20,729259.20
Middle East and North Africa,Israel,Personal Care,Online,L,5/13/2012,290455615,5/28/2012,1126,81.73,56.67,92027.98,63810.42,28217.56
Asia,Thailand,Snacks,Offline,L,1/13/2012,670878255,2/15/2012,6639,152.58,97.44,1012978.62,646904.16,366074.46
Asia,Singapore,Cereal,Online,M,7/30/2011,435146415,8/12/2011,8349,205.70,117.11,1717389.30,977751.39,739637.91
Asia,North Korea,Snacks,Online,C,3/13/2017,522371423,4/8/2017,167,152.58,97.44,25480.86,16272.48,9208.38
Europe,Austria,Office Supplies,Online,L,3/23/2017,141977107,4/18/2017,3036,651.21,524.96,1977073.56,1593778.56,383295.00
Asia,Japan,Baby Food,Offline,L,3/16/2016,823699796,4/19/2016,9929,255.28,159.42,2534675.12,1582881.18,951793.94
Sub-Saharan Africa,Zimbabwe,Beverages,Offline,L,12/18/2015,567588317,12/26/2015,851,47.45,31.79,40379.95,27053.29,13326.66
Europe,Lithuania,Fruits,Offline,H,10/25/2011,594003999,11/16/2011,7838,9.33,6.92,73128.54,54238.96,18889.58
Europe,Luxembourg,Baby Food,Offline,H,6/30/2011,393620669,8/2/2011,9958,255.28,159.42,2542078.24,1587504.36,954573.88
Sub-Saharan Africa,Central African Republic,Cosmetics,Offline,H,3/27/2016,877424657,4/10/2016,8309,437.20,263.33,3632694.80,2188008.97,1444685.83
Europe,Norway,Household,Offline,M,12/23/2016,326714789,1/21/2017,1021,668.27,502.54,682303.67,513093.34,169210.33
Sub-Saharan Africa,Democratic Republic of the Congo,Fruits,Offline,M,4/18/2013,243102395,4/18/2013,8256,9.33,6.92,77028.48,57131.52,19896.96
Australia and Oceania,New Zealand,Household,Offline,L,3/8/2017,398511302,4/20/2017,7205,668.27,502.54,4814885.35,3620800.70,1194084.65
Europe,Ukraine,Personal Care,Offline,M,6/3/2011,185177838,7/4/2011,7092,81.73,56.67,579629.16,401903.64,177725.52
Asia,Taiwan,Personal Care,Offline,H,11/30/2013,865650832,12/31/2013,4173,81.73,56.67,341059.29,236483.91,104575.38
Europe,Italy,Cereal,Offline,C,5/11/2013,622791612,5/31/2013,6733,205.70,117.11,1384978.10,788501.63,596476.47
Europe,Finland,Personal Care,Online,L,11/13/2010,409774005,11/27/2010,89,81.73,56.67,7273.97,5043.63,2230.34
Sub-Saharan Africa,Sudan,Office Supplies,Online,H,3/9/2016,800084340,4/21/2016,1591,651.21,524.96,1036075.11,835211.36,200863.75
Europe,Croatia,Snacks,Offline,M,8/19/2013,637521445,9/12/2013,5618,152.58,97.44,857194.44,547417.92,309776.52
Sub-Saharan Africa,Mauritania,Beverages,Online,L,4/19/2011,186196649,5/28/2011,8581,47.45,31.79,407168.45,272789.99,134378.46
Australia and Oceania,New Zealand,Baby Food,Offline,L,7/20/2014,680533778,7/25/2014,3923,255.28,159.42,1001463.44,625404.66,376058.78
Middle East and North Africa,Pakistan,Beverages,Online,L,9/8/2014,275269162,9/15/2014,7117,47.45,31.79,337701.65,226249.43,111452.22
Europe,Poland,Household,Online,C,6/4/2015,795451629,6/19/2015,668,668.27,502.54,446404.36,335696.72,110707.64
Europe,Lithuania,Cereal,Offline,M,12/19/2013,986442506,1/1/2014,9113,205.70,117.11,1874544.10,1067223.43,807320.67
Middle East and North Africa,Pakistan,Cereal,Offline,M,5/18/2012,563915622,6/10/2012,4019,205.70,117.11,826708.30,470665.09,356043.21
Australia and Oceania,East Timor,Cosmetics,Offline,C,10/12/2013,663857305,11/13/2013,8984,437.20,263.33,3927804.80,2365756.72,1562048.08
Australia and Oceania,Marshall Islands,Fruits,Online,L,1/2/2011,692566382,1/14/2011,4638,9.33,6.92,43272.54,32094.96,11177.58
Central America and the Caribbean,Cuba,Household,Offline,L,2/2/2013,576654183,2/3/2013,3642,668.27,502.54,2433839.34,1830250.68,603588.66
North America,Greenland,Baby Food,Offline,H,3/19/2011,313044536,4/14/2011,5689,255.28,159.42,1452287.92,906940.38,545347.54
Europe,Luxembourg,Personal Care,Offline,C,10/3/2012,418973767,10/27/2012,2503,81.73,56.67,204570.19,141845.01,62725.18
Middle East and North Africa,Israel,Beverages,Online,C,10/23/2014,581990706,11/15/2014,2838,47.45,31.79,134663.10,90220.02,44443.08
Sub-Saharan Africa,Djibouti,Baby Food,Online,H,7/12/2015,109956681,7/24/2015,7480,255.28,159.42,1909494.40,1192461.60,717032.80
Europe,Bulgaria,Cereal,Online,L,5/6/2010,181045520,5/27/2010,4247,205.70,117.11,873607.90,497366.17,376241.73
Asia,Mongolia,Vegetables,Online,C,11/27/2010,693743550,1/9/2011,2988,154.06,90.93,460331.28,271698.84,188632.44
Central America and the Caribbean,Dominican Republic,Clothes,Offline,L,12/26/2010,716849601,12/31/2010,582,109.28,35.84,63600.96,20858.88,42742.08
Middle East and North Africa,Yemen,Cosmetics,Online,L,12/30/2012,739474999,1/1/2013,5940,437.20,263.33,2596968.00,1564180.20,1032787.80
Australia and Oceania,Federated States of Micronesia,Personal Care,Online,M,8/21/2016,421043574,9/7/2016,5005,81.73,56.67,409058.65,283633.35,125425.30
Europe,Finland,Personal Care,Online,M,2/3/2015,841291654,3/20/2015,5751,81.73,56.67,470029.23,325909.17,144120.06
Central America and the Caribbean,The Bahamas,Cereal,Offline,L,12/19/2013,450268065,1/4/2014,3181,205.70,117.11,654331.70,372526.91,281804.79
Central America and the Caribbean,Grenada,Meat,Online,L,5/12/2012,918334138,6/12/2012,4334,421.89,364.69,1828471.26,1580566.46,247904.80
Sub-Saharan Africa,Sao Tome and Principe,Meat,Offline,M,3/28/2014,386163699,4/19/2014,3275,421.89,364.69,1381689.75,1194359.75,187330.00
Central America and the Caribbean,El Salvador,Personal Care,Offline,C,1/11/2017,214743077,2/18/2017,6103,81.73,56.67,498798.19,345857.01,152941.18
Europe,Sweden,Baby Food,Online,M,6/21/2015,935371100,7/6/2015,5949,255.28,159.42,1518660.72,948389.58,570271.14
Asia,Turkmenistan,Cosmetics,Offline,H,11/29/2012,899659097,12/3/2012,7974,437.20,263.33,3486232.80,2099793.42,1386439.38
Europe,Monaco,Vegetables,Online,H,1/1/2010,329530894,2/13/2010,4369,154.06,90.93,673088.14,397273.17,275814.97
Middle East and North Africa,Turkey,Meat,Online,H,1/6/2016,867222821,2/6/2016,9359,421.89,364.69,3948468.51,3413133.71,535334.80
Sub-Saharan Africa,Mozambique,Beverages,Online,M,10/14/2014,625283706,10/23/2014,4199,47.45,31.79,199242.55,133486.21,65756.34
Middle East and North Africa,Yemen,Office Supplies,Offline,C,12/9/2013,936574876,1/9/2014,2173,651.21,524.96,1415079.33,1140738.08,274341.25
Asia,Philippines,Cereal,Offline,M,10/19/2010,504270160,11/25/2010,3601,205.70,117.11,740725.70,421713.11,319012.59
Sub-Saharan Africa,Democratic Republic of the Congo,Personal Care,Offline,M,5/2/2011,351855885,6/2/2011,830,81.73,56.67,67835.90,47036.10,20799.80
Australia and Oceania,Fiji,Snacks,Online,H,3/17/2011,673130881,3/23/2011,3241,152.58,97.44,494511.78,315803.04,178708.74
Europe,Macedonia,Office Supplies,Offline,H,9/24/2014,382206475,10/13/2014,2244,651.21,524.96,1461315.24,1178010.24,283305.00
Middle East and North Africa,Tunisia ,Cereal,Online,H,12/1/2015,263506495,12/14/2015,6283,205.70,117.11,1292413.10,735802.13,556610.97
Europe,Liechtenstein,Cereal,Offline,L,6/2/2017,721767270,7/18/2017,5829,205.70,117.11,1199025.30,682634.19,516391.11
Middle East and North Africa,Qatar,Cosmetics,Online,M,8/4/2011,432037627,8/18/2011,8390,437.20,263.33,3668108.00,2209338.70,1458769.30
Australia and Oceania,Tonga,Meat,Offline,C,7/29/2014,389678895,8/24/2014,3499,421.89,364.69,1476193.11,1276050.31,200142.80
Europe,Belgium,Meat,Online,L,1/26/2017,760364902,2/24/2017,7726,421.89,364.69,3259522.14,2817594.94,441927.20
Sub-Saharan Africa,Chad,Fruits,Offline,C,11/5/2010,430081975,12/9/2010,9669,9.33,6.92,90211.77,66909.48,23302.29
Asia,Thailand,Baby Food,Online,H,3/26/2015,155128943,5/5/2015,4957,255.28,159.42,1265422.96,790244.94,475178.02
Europe,Iceland,Clothes,Offline,H,10/7/2012,312117135,10/16/2012,1251,109.28,35.84,136709.28,44835.84,91873.44
Central America and the Caribbean,Saint Lucia,Meat,Offline,L,7/22/2013,447970378,9/2/2013,3245,421.89,364.69,1369033.05,1183419.05,185614.00
Asia,Japan,Cosmetics,Offline,C,8/16/2013,629925000,8/18/2013,7661,437.20,263.33,3349389.20,2017371.13,1332018.07
Asia,India,Personal Care,Offline,L,11/5/2013,995529830,12/17/2013,8254,81.73,56.67,674599.42,467754.18,206845.24
Australia and Oceania,Vanuatu,Office Supplies,Online,L,3/1/2016,402646195,3/28/2016,812,651.21,524.96,528782.52,426267.52,102515.00
Sub-Saharan Africa,Chad,Meat,Offline,M,3/25/2012,479447925,4/4/2012,8150,421.89,364.69,3438403.50,2972223.50,466180.00
Sub-Saharan Africa,Malawi,Cosmetics,Offline,H,6/20/2017,674421346,6/29/2017,5118,437.20,263.33,2237589.60,1347722.94,889866.66
Europe,Finland,Cosmetics,Online,L,4/18/2014,506365287,5/16/2014,3596,437.20,263.33,1572171.20,946934.68,625236.52
Middle East and North Africa,Turkey,Clothes,Online,C,6/28/2016,914391076,8/4/2016,7494,109.28,35.84,818944.32,268584.96,550359.36
Sub-Saharan Africa,South Africa,Meat,Online,L,5/20/2012,207922542,7/1/2012,7755,421.89,364.69,3271756.95,2828170.95,443586.00
Europe,Lithuania,Office Supplies,Offline,M,2/4/2014,816696012,2/16/2014,7353,651.21,524.96,4788347.13,3860030.88,928316.25
Europe,Russia,Beverages,Offline,L,11/15/2015,740760314,11/21/2015,6293,47.45,31.79,298602.85,200054.47,98548.38
Central America and the Caribbean,The Bahamas,Baby Food,Online,C,1/11/2013,300476777,2/28/2013,6610,255.28,159.42,1687400.80,1053766.20,633634.60
Central America and the Caribbean,The Bahamas,Snacks,Online,L,4/24/2013,786519229,6/7/2013,7373,152.58,97.44,1124972.34,718425.12,406547.22
Middle East and North Africa,Turkey,Cosmetics,Offline,C,5/15/2010,409873998,6/3/2010,9679,437.20,263.33,4231658.80,2548771.07,1682887.73
Sub-Saharan Africa,Mauritius ,Cosmetics,Offline,H,4/17/2010,151839911,5/22/2010,1659,437.20,263.33,725314.80,436864.47,288450.33
Europe,Bulgaria,Vegetables,Online,H,8/25/2012,614028298,9/9/2012,3473,154.06,90.93,535050.38,315799.89,219250.49
Middle East and North Africa,Iran,Household,Offline,L,4/19/2014,668362987,5/13/2014,2315,668.27,502.54,1547045.05,1163380.10,383664.95
Sub-Saharan Africa,Ghana,Household,Online,M,2/26/2013,607080304,4/5/2013,7408,668.27,502.54,4950544.16,3722816.32,1227727.84
Sub-Saharan Africa,Malawi,Baby Food,Online,M,12/28/2011,792729079,1/17/2012,5006,255.28,159.42,1277931.68,798056.52,479875.16
Sub-Saharan Africa,Zimbabwe,Baby Food,Offline,M,8/21/2014,308170640,10/10/2014,3395,255.28,159.42,866675.60,541230.90,325444.70
Asia,Tajikistan,Vegetables,Online,H,8/21/2014,106578814,10/2/2014,7894,154.06,90.93,1216149.64,717801.42,498348.22
Europe,Czech Republic,Cereal,Online,H,3/2/2014,761439931,3/28/2014,5851,205.70,117.11,1203550.70,685210.61,518340.09
Sub-Saharan Africa,Mauritius ,Household,Online,L,9/6/2012,216552817,9/27/2012,1646,668.27,502.54,1099972.42,827180.84,272791.58
Sub-Saharan Africa,Lesotho,Fruits,Online,H,9/16/2010,536028802,9/22/2010,1689,9.33,6.92,15758.37,11687.88,4070.49
Sub-Saharan Africa,Mali,Beverages,Online,L,8/13/2013,254291713,8/15/2013,9424,47.45,31.79,447168.80,299588.96,147579.84
Europe,Georgia,Personal Care,Online,C,9/11/2012,226077878,10/23/2012,323,81.73,56.67,26398.79,18304.41,8094.38
Europe,Albania,Office Supplies,Offline,M,8/31/2011,476436126,10/15/2011,6892,651.21,524.96,4488139.32,3618024.32,870115.00
Europe,Cyprus,Cosmetics,Offline,L,4/21/2015,650727784,6/6/2015,3667,437.20,263.33,1603212.40,965631.11,637581.29
Central America and the Caribbean,Saint Kitts and Nevis ,Household,Offline,C,7/11/2010,464626681,7/27/2010,2215,668.27,502.54,1480218.05,1113126.10,367091.95
Middle East and North Africa,Tunisia ,Meat,Offline,C,8/9/2015,154119145,9/21/2015,6135,421.89,364.69,2588295.15,2237373.15,350922.00
Central America and the Caribbean,Cuba,Meat,Online,M,10/17/2015,925504004,12/6/2015,6057,421.89,364.69,2555387.73,2208927.33,346460.40
Australia and Oceania,Kiribati,Cereal,Offline,L,7/24/2012,905392587,8/16/2012,4641,205.70,117.11,954653.70,543507.51,411146.19
Asia,Cambodia,Snacks,Online,C,3/25/2012,990708720,5/4/2012,1581,152.58,97.44,241228.98,154052.64,87176.34
Europe,Moldova ,Baby Food,Online,M,8/11/2014,798688733,9/18/2014,8600,255.28,159.42,2195408.00,1371012.00,824396.00
Asia,Uzbekistan,Cereal,Offline,C,10/15/2016,916881453,11/28/2016,4452,205.70,117.11,915776.40,521373.72,394402.68
Asia,India,Cosmetics,Offline,L,12/3/2016,653148210,1/21/2017,9924,437.20,263.33,4338772.80,2613286.92,1725485.88
Europe,Germany,Personal Care,Offline,C,6/12/2010,285662829,7/13/2010,2834,81.73,56.67,231622.82,160602.78,71020.04
Europe,Austria,Vegetables,Online,C,7/29/2016,612911641,8/31/2016,3030,154.06,90.93,466801.80,275517.90,191283.90
Europe,Germany,Office Supplies,Offline,L,12/9/2013,703693473,1/12/2014,7391,651.21,524.96,4813093.11,3879979.36,933113.75
Asia,Bhutan,Clothes,Online,M,7/12/2012,147119653,8/9/2012,4829,109.28,35.84,527713.12,173071.36,354641.76
Asia,Kyrgyzstan,Fruits,Online,C,1/14/2012,402614009,3/2/2012,1287,9.33,6.92,12007.71,8906.04,3101.67
Middle East and North Africa,Somalia,Personal Care,Online,C,3/20/2013,749912869,4/25/2013,4738,81.73,56.67,387236.74,268502.46,118734.28
Central America and the Caribbean,Saint Lucia,Household,Online,H,2/10/2014,539065062,3/10/2014,186,668.27,502.54,124298.22,93472.44,30825.78
Europe,Armenia,Snacks,Offline,H,10/26/2013,540431916,11/15/2013,4668,152.58,97.44,712243.44,454849.92,257393.52
North America,Canada,Beverages,Online,C,4/16/2016,694687259,6/2/2016,2252,47.45,31.79,106857.40,71591.08,35266.32
Sub-Saharan Africa,Burundi,Cosmetics,Offline,H,5/27/2011,562817418,6/2/2011,9036,437.20,263.33,3950539.20,2379449.88,1571089.32
Europe,Liechtenstein,Cereal,Online,L,8/4/2016,676121222,9/9/2016,8149,205.70,117.11,1676249.30,954329.39,721919.91
Middle East and North Africa,Tunisia ,Snacks,Offline,L,7/3/2012,286210000,8/5/2012,4754,152.58,97.44,725365.32,463229.76,262135.56
Middle East and North Africa,Iraq,Beverages,Online,L,12/4/2014,515007579,1/11/2015,1042,47.45,31.79,49442.90,33125.18,16317.72
Asia,Indonesia,Cosmetics,Offline,C,5/31/2010,304750287,6/1/2010,1237,437.20,263.33,540816.40,325739.21,215077.19
Asia,Kazakhstan,Beverages,Online,H,2/5/2013,467986953,2/17/2013,6594,47.45,31.79,312885.30,209623.26,103262.04
Europe,Denmark,Beverages,Offline,C,6/15/2015,537578904,7/9/2015,399,47.45,31.79,18932.55,12684.21,6248.34
Europe,Luxembourg,Vegetables,Offline,L,10/21/2014,116699969,11/18/2014,2969,154.06,90.93,457404.14,269971.17,187432.97
Sub-Saharan Africa,Cape Verde,Snacks,Offline,C,2/13/2017,228836476,3/13/2017,6653,152.58,97.44,1015114.74,648268.32,366846.42
Australia and Oceania,Palau,Vegetables,Offline,C,6/29/2010,167787253,7/16/2010,832,154.06,90.93,128177.92,75653.76,52524.16
Australia and Oceania,Australia,Vegetables,Online,M,5/19/2014,647663629,5/20/2014,6915,154.06,90.93,1065324.90,628780.95,436543.95
Central America and the Caribbean,Nicaragua,Meat,Offline,L,3/21/2015,652889430,4/15/2015,3346,421.89,364.69,1411643.94,1220252.74,191391.20
Asia,Laos,Office Supplies,Offline,M,8/31/2015,588200986,10/15/2015,598,651.21,524.96,389423.58,313926.08,75497.50
Central America and the Caribbean,Cuba,Personal Care,Online,L,8/23/2015,928647124,8/30/2015,6176,81.73,56.67,504764.48,349993.92,154770.56
Europe,Moldova ,Cosmetics,Offline,L,2/24/2016,869589173,3/17/2016,9615,437.20,263.33,4203678.00,2531917.95,1671760.05
Middle East and North Africa,Syria,Household,Online,C,6/17/2015,576700961,7/23/2015,7485,668.27,502.54,5002000.95,3761511.90,1240489.05
Central America and the Caribbean,The Bahamas,Cereal,Offline,M,11/27/2012,735968816,12/6/2012,8382,205.70,117.11,1724177.40,981616.02,742561.38
Europe,Belarus,Snacks,Offline,M,9/7/2012,303691565,10/19/2012,7938,152.58,97.44,1211180.04,773478.72,437701.32
Middle East and North Africa,United Arab Emirates,Clothes,Offline,C,6/23/2012,556480538,8/7/2012,3812,109.28,35.84,416575.36,136622.08,279953.28
Sub-Saharan Africa,Angola,Beverages,Offline,H,10/23/2014,141259562,11/11/2014,698,47.45,31.79,33120.10,22189.42,10930.68
Central America and the Caribbean,Cuba,Cosmetics,Offline,C,9/18/2015,925264966,10/18/2015,5320,437.20,263.33,2325904.00,1400915.60,924988.40
Europe,Ukraine,Office Supplies,Online,H,1/24/2016,346045577,2/20/2016,1431,651.21,524.96,931881.51,751217.76,180663.75
Sub-Saharan Africa,Mozambique,Fruits,Offline,H,3/23/2010,861462724,4/19/2010,4818,9.33,6.92,44951.94,33340.56,11611.38
Europe,Armenia,Personal Care,Online,M,7/26/2012,499690234,8/28/2012,8299,81.73,56.67,678277.27,470304.33,207972.94
North America,Greenland,Clothes,Online,H,10/20/2015,509214437,11/2/2015,6722,109.28,35.84,734580.16,240916.48,493663.68
Central America and the Caribbean,Saint Kitts and Nevis ,Office Supplies,Online,M,6/27/2017,408834159,7/18/2017,1968,651.21,524.96,1281581.28,1033121.28,248460.00
Europe,Vatican City,Beverages,Offline,M,4/4/2016,237660729,4/30/2016,7946,47.45,31.79,377037.70,252603.34,124434.36
Europe,Ukraine,Clothes,Online,C,8/5/2015,105117976,9/9/2015,5600,109.28,35.84,611968.00,200704.00,411264.00
Sub-Saharan Africa,Niger,Cereal,Offline,L,6/16/2012,640942227,7/4/2012,7903,205.70,117.11,1625647.10,925520.33,700126.77
Asia,Myanmar,Cosmetics,Online,L,4/3/2016,745182311,5/5/2016,4860,437.20,263.33,2124792.00,1279783.80,845008.20
Sub-Saharan Africa,Guinea,Baby Food,Offline,C,9/21/2014,738199555,9/21/2014,8508,255.28,159.42,2171922.24,1356345.36,815576.88
Sub-Saharan Africa,Guinea-Bissau,Snacks,Online,L,8/8/2015,110667788,9/10/2015,7913,152.58,97.44,1207365.54,771042.72,436322.82
Sub-Saharan Africa,South Sudan,Office Supplies,Online,C,7/19/2012,673573338,7/20/2012,4174,651.21,524.96,2718150.54,2191183.04,526967.50
Middle East and North Africa,Turkey,Snacks,Offline,H,8/26/2011,708215034,9/13/2011,5421,152.58,97.44,827136.18,528222.24,298913.94
Australia and Oceania,Palau,Household,Online,M,6/23/2012,816204202,7/1/2012,1816,668.27,502.54,1213578.32,912612.64,300965.68
Europe,Poland,Beverages,Offline,L,11/20/2011,769464671,12/24/2011,550,47.45,31.79,26097.50,17484.50,8613.00
Asia,Malaysia,Beverages,Offline,L,5/13/2015,860232770,6/4/2015,848,47.45,31.79,40237.60,26957.92,13279.68
North America,United States of America,Personal Care,Offline,C,7/16/2010,551057326,8/22/2010,8963,81.73,56.67,732545.99,507933.21,224612.78
Europe,Switzerland,Cosmetics,Online,C,5/21/2016,724799668,5/27/2016,3183,437.20,263.33,1391607.60,838179.39,553428.21
Australia and Oceania,Papua New Guinea,Cosmetics,Offline,H,4/22/2011,534633624,6/8/2011,8825,437.20,263.33,3858290.00,2323887.25,1534402.75
Sub-Saharan Africa,Namibia,Beverages,Offline,H,8/14/2012,554045522,9/20/2012,3237,47.45,31.79,153595.65,102904.23,50691.42
Europe,Ireland,Clothes,Online,C,3/17/2012,526834189,5/2/2012,799,109.28,35.84,87314.72,28636.16,58678.56
Sub-Saharan Africa,Mozambique,Household,Online,C,8/6/2010,717110955,8/9/2010,7922,668.27,502.54,5294034.94,3981121.88,1312913.06
Sub-Saharan Africa,Democratic Republic of the Congo,Baby Food,Offline,L,2/25/2013,559299647,3/26/2013,8049,255.28,159.42,2054748.72,1283171.58,771577.14
North America,United States of America,Meat,Online,M,3/6/2011,908136594,3/10/2011,6654,421.89,364.69,2807256.06,2426647.26,380608.80
Middle East and North Africa,Azerbaijan,Office Supplies,Offline,M,12/14/2015,888670623,12/16/2015,6240,651.21,524.96,4063550.40,3275750.40,787800.00
Europe,Belgium,Office Supplies,Offline,C,2/10/2017,146263062,2/16/2017,1345,651.21,524.96,875877.45,706071.20,169806.25
Asia,Taiwan,Office Supplies,Offline,L,9/20/2016,196587741,10/28/2016,3536,651.21,524.96,2302678.56,1856258.56,446420.00
Central America and the Caribbean,Panama,Baby Food,Online,M,4/30/2010,375630986,6/2/2010,6411,255.28,159.42,1636600.08,1022041.62,614558.46
Europe,Andorra,Beverages,Offline,H,6/25/2013,989691627,7/10/2013,600,47.45,31.79,28470.00,19074.00,9396.00
Europe,Georgia,Household,Offline,H,7/4/2012,165380990,7/27/2012,8765,668.27,502.54,5857386.55,4404763.10,1452623.45
Central America and the Caribbean,Barbados,Snacks,Online,C,9/21/2013,599622905,10/22/2013,597,152.58,97.44,91090.26,58171.68,32918.58
Europe,Sweden,Personal Care,Offline,C,12/8/2016,109653699,1/6/2017,7821,81.73,56.67,639210.33,443216.07,195994.26
Middle East and North Africa,Algeria,Meat,Offline,M,9/2/2011,183022201,10/15/2011,9191,421.89,364.69,3877590.99,3351865.79,525725.20
Europe,Italy,Personal Care,Online,L,3/21/2011,127589738,4/2/2011,5494,81.73,56.67,449024.62,311344.98,137679.64
Europe,Russia,Fruits,Offline,L,1/8/2011,221530139,1/26/2011,4546,9.33,6.92,42414.18,31458.32,10955.86
Central America and the Caribbean,Antigua and Barbuda ,Office Supplies,Offline,M,2/22/2015,363329732,2/22/2015,6197,651.21,524.96,4035548.37,3253177.12,782371.25
Middle East and North Africa,Jordan,Fruits,Online,C,5/15/2017,521787345,6/25/2017,7325,9.33,6.92,68342.25,50689.00,17653.25
Sub-Saharan Africa,Mali,Meat,Online,L,7/14/2012,286014306,8/15/2012,6844,421.89,364.69,2887415.16,2495938.36,391476.80
Middle East and North Africa,Somalia,Cereal,Offline,C,6/25/2015,215434443,6/30/2015,694,205.70,117.11,142755.80,81274.34,61481.46
Middle East and North Africa,Kuwait,Snacks,Online,L,10/26/2011,489784085,11/1/2011,6850,152.58,97.44,1045173.00,667464.00,377709.00
Sub-Saharan Africa,Liberia,Office Supplies,Offline,C,9/24/2014,459112060,10/12/2014,316,651.21,524.96,205782.36,165887.36,39895.00
Asia,China,Office Supplies,Online,C,9/30/2015,893779695,11/7/2015,8128,651.21,524.96,5293034.88,4266874.88,1026160.00
Europe,Andorra,Meat,Offline,M,3/31/2011,834460818,3/31/2011,4355,421.89,364.69,1837330.95,1588224.95,249106.00
Sub-Saharan Africa,Niger,Beverages,Online,C,10/25/2013,742141759,10/28/2013,5093,47.45,31.79,241662.85,161906.47,79756.38
Europe,Hungary,Vegetables,Offline,M,8/12/2010,248121345,9/14/2010,3475,154.06,90.93,535358.50,315981.75,219376.75
Europe,Monaco,Clothes,Offline,M,7/26/2012,404010903,9/4/2012,4659,109.28,35.84,509135.52,166978.56,342156.96
Australia and Oceania,Tuvalu,Household,Online,L,9/30/2012,531734263,10/12/2012,840,668.27,502.54,561346.80,422133.60,139213.20
Sub-Saharan Africa,South Sudan,Baby Food,Online,C,11/9/2012,473527753,12/29/2012,6240,255.28,159.42,1592947.20,994780.80,598166.40
Europe,Cyprus,Cereal,Offline,M,11/19/2011,141940200,1/2/2012,2114,205.70,117.11,434849.80,247570.54,187279.26
Europe,Poland,Household,Offline,M,6/9/2017,869832932,7/25/2017,1749,668.27,502.54,1168804.23,878942.46,289861.77
Sub-Saharan Africa,Liberia,Snacks,Online,H,9/17/2011,460379779,11/4/2011,5462,152.58,97.44,833391.96,532217.28,301174.68
Sub-Saharan Africa,Cote d'Ivoire,Vegetables,Online,C,10/23/2015,837067067,10/26/2015,5602,154.06,90.93,863044.12,509389.86,353654.26
Asia,Kyrgyzstan,Beverages,Online,C,4/3/2010,393693625,4/9/2010,1547,47.45,31.79,73405.15,49179.13,24226.02
Europe,Slovakia,Vegetables,Offline,L,7/3/2014,744370782,7/14/2014,4711,154.06,90.93,725776.66,428371.23,297405.43
Asia,Malaysia,Cosmetics,Offline,M,12/30/2014,873522365,1/13/2015,3534,437.20,263.33,1545064.80,930608.22,614456.58
Sub-Saharan Africa,Liberia,Beverages,Online,L,5/19/2014,285884702,6/10/2014,8491,47.45,31.79,402897.95,269928.89,132969.06
Australia and Oceania,Vanuatu,Cosmetics,Online,H,8/4/2012,356506621,9/3/2012,7086,437.20,263.33,3097999.20,1865956.38,1232042.82
Australia and Oceania,Kiribati,Baby Food,Offline,L,8/15/2010,280749452,10/1/2010,8856,255.28,159.42,2260759.68,1411823.52,848936.16
Middle East and North Africa,Turkey,Baby Food,Online,M,4/26/2014,224287021,5/17/2014,368,255.28,159.42,93943.04,58666.56,35276.48
Europe,San Marino,Fruits,Offline,M,6/10/2015,873105657,6/23/2015,221,9.33,6.92,2061.93,1529.32,532.61
Europe,Vatican City,Snacks,Offline,C,8/12/2010,283504188,9/2/2010,4044,152.58,97.44,617033.52,394047.36,222986.16
Middle East and North Africa,Morocco,Beverages,Offline,C,8/28/2012,632093942,9/5/2012,9499,47.45,31.79,450727.55,301973.21,148754.34
Sub-Saharan Africa,Equatorial Guinea,Meat,Offline,L,7/15/2016,565798747,8/9/2016,1277,421.89,364.69,538753.53,465709.13,73044.40
Middle East and North Africa,Jordan,Vegetables,Online,M,9/14/2010,151854932,10/19/2010,6104,154.06,90.93,940382.24,555036.72,385345.52
Asia,Kyrgyzstan,Vegetables,Online,H,3/7/2011,427811324,4/16/2011,7733,154.06,90.93,1191345.98,703161.69,488184.29
Sub-Saharan Africa,Republic of the Congo,Fruits,Online,L,4/30/2012,251529252,5/5/2012,1950,9.33,6.92,18193.50,13494.00,4699.50
Australia and Oceania,East Timor,Snacks,Offline,C,5/18/2013,351182544,6/22/2013,1574,152.58,97.44,240160.92,153370.56,86790.36
Europe,Estonia,Meat,Offline,H,8/10/2014,175257527,9/25/2014,1452,421.89,364.69,612584.28,529529.88,83054.40
Asia,Bangladesh,Snacks,Online,H,7/31/2013,142553031,9/11/2013,3465,152.58,97.44,528689.70,337629.60,191060.10
Sub-Saharan Africa,Senegal,Fruits,Offline,H,7/2/2016,292180383,8/15/2016,1523,9.33,6.92,14209.59,10539.16,3670.43
Middle East and North Africa,Pakistan,Fruits,Offline,L,9/13/2011,733563411,9/20/2011,6569,9.33,6.92,61288.77,45457.48,15831.29
Europe,Czech Republic,Beverages,Online,H,4/18/2011,296438443,4/19/2011,1578,47.45,31.79,74876.10,50164.62,24711.48
Sub-Saharan Africa,Ghana,Meat,Offline,C,2/9/2017,580854308,3/18/2017,6552,421.89,364.69,2764223.28,2389448.88,374774.40
Asia,Japan,Cosmetics,Offline,H,11/20/2016,107172334,12/23/2016,3530,437.20,263.33,1543316.00,929554.90,613761.10
Asia,Kazakhstan,Baby Food,Offline,H,10/16/2010,166066348,12/5/2010,1578,255.28,159.42,402831.84,251564.76,151267.08
Central America and the Caribbean,The Bahamas,Snacks,Offline,H,3/15/2015,768522679,3/27/2015,1794,152.58,97.44,273728.52,174807.36,98921.16
Sub-Saharan Africa,Ethiopia,Household,Online,M,6/25/2013,195840156,7/25/2013,2309,668.27,502.54,1543035.43,1160364.86,382670.57
Sub-Saharan Africa,Burkina Faso,Cosmetics,Offline,L,10/11/2012,849630105,11/9/2012,3284,437.20,263.33,1435764.80,864775.72,570989.08
Sub-Saharan Africa,Madagascar,Fruits,Offline,M,7/8/2017,701816356,7/30/2017,1910,9.33,6.92,17820.30,13217.20,4603.10
Europe,Netherlands,Office Supplies,Online,M,6/22/2010,944635236,7/27/2010,7413,651.21,524.96,4827419.73,3891528.48,935891.25
Europe,Greece,Vegetables,Online,L,2/17/2017,140635573,3/21/2017,6046,154.06,90.93,931446.76,549762.78,381683.98
Middle East and North Africa,Egypt,Meat,Online,C,1/14/2011,972678697,2/25/2011,6096,421.89,364.69,2571841.44,2223150.24,348691.20
Sub-Saharan Africa,South Sudan,Fruits,Online,M,1/9/2016,793938434,2/8/2016,2880,9.33,6.92,26870.40,19929.60,6940.80
Europe,Kosovo,Baby Food,Online,L,7/18/2011,177901113,8/13/2011,3747,255.28,159.42,956534.16,597346.74,359187.42
Asia,Brunei,Beverages,Online,L,3/16/2012,668365561,5/4/2012,3077,47.45,31.79,146003.65,97817.83,48185.82
Australia and Oceania,Australia,Vegetables,Online,C,12/15/2010,729443109,1/12/2011,7281,154.06,90.93,1121710.86,662061.33,459649.53
Sub-Saharan Africa,Cape Verde,Fruits,Offline,H,3/2/2013,695557582,4/3/2013,9800,9.33,6.92,91434.00,67816.00,23618.00
Sub-Saharan Africa,Malawi,Household,Offline,H,2/17/2010,521445310,4/4/2010,6110,668.27,502.54,4083129.70,3070519.40,1012610.30
Asia,Philippines,Personal Care,Online,L,2/19/2013,232155120,3/30/2013,8714,81.73,56.67,712195.22,493822.38,218372.84
Europe,Estonia,Beverages,Online,L,10/28/2011,373048341,12/12/2011,2149,47.45,31.79,101970.05,68316.71,33653.34
Central America and the Caribbean,Trinidad and Tobago,Office Supplies,Offline,L,10/26/2015,659798800,12/2/2015,7982,651.21,524.96,5197958.22,4190230.72,1007727.50
Asia,Mongolia,Household,Online,C,2/5/2013,428392827,2/5/2013,9812,668.27,502.54,6557065.24,4930922.48,1626142.76
Asia,Japan,Personal Care,Offline,M,8/25/2011,885129249,9/3/2011,8269,81.73,56.67,675825.37,468604.23,207221.14
Sub-Saharan Africa,Niger,Meat,Online,C,12/4/2012,156619393,12/5/2012,6014,421.89,364.69,2537246.46,2193245.66,344000.80
Middle East and North Africa,Egypt,Baby Food,Offline,M,9/8/2015,939787089,9/9/2015,2739,255.28,159.42,699211.92,436651.38,262560.54
Central America and the Caribbean,Saint Lucia,Vegetables,Online,C,3/1/2012,151868665,4/19/2012,168,154.06,90.93,25882.08,15276.24,10605.84
Middle East and North Africa,Qatar,Cereal,Offline,C,8/5/2014,180412948,8/24/2014,7055,205.70,117.11,1451213.50,826211.05,625002.45
Sub-Saharan Africa,Mali,Fruits,Offline,H,7/24/2013,333281266,7/28/2013,4188,9.33,6.92,39074.04,28980.96,10093.08
Central America and the Caribbean,Saint Lucia,Cosmetics,Online,L,1/26/2012,888647449,2/28/2012,9383,437.20,263.33,4102247.60,2470825.39,1631422.21
Sub-Saharan Africa,Swaziland,Clothes,Offline,M,3/10/2014,844997823,4/26/2014,2488,109.28,35.84,271888.64,89169.92,182718.72
Asia,Mongolia,Fruits,Online,M,9/12/2013,171131217,10/8/2013,385,9.33,6.92,3592.05,2664.20,927.85
Sub-Saharan Africa,Botswana,Office Supplies,Online,C,1/5/2013,256158959,1/18/2013,1983,651.21,524.96,1291349.43,1040995.68,250353.75
Europe,San Marino,Cosmetics,Online,H,10/28/2011,759504878,12/8/2011,3226,437.20,263.33,1410407.20,849502.58,560904.62
Middle East and North Africa,Oman,Fruits,Online,C,11/21/2010,960905301,11/25/2010,2087,9.33,6.92,19471.71,14442.04,5029.67
Asia,Bangladesh,Office Supplies,Offline,C,10/28/2015,210409057,12/4/2015,3570,651.21,524.96,2324819.70,1874107.20,450712.50
Sub-Saharan Africa,Namibia,Cosmetics,Offline,C,7/29/2010,178377473,9/1/2010,4713,437.20,263.33,2060523.60,1241074.29,819449.31
Asia,Mongolia,Fruits,Online,M,3/30/2014,805484378,5/1/2014,9582,9.33,6.92,89400.06,66307.44,23092.62
Asia,North Korea,Beverages,Online,C,9/14/2016,752716100,10/12/2016,4276,47.45,31.79,202896.20,135934.04,66962.16
Europe,Latvia,Clothes,Online,M,9/6/2012,551371467,9/15/2012,1925,109.28,35.84,210364.00,68992.00,141372.00
Sub-Saharan Africa,Burundi,Snacks,Offline,M,2/8/2013,353061807,3/5/2013,7689,152.58,97.44,1173187.62,749216.16,423971.46
Sub-Saharan Africa,Seychelles ,Personal Care,Online,C,1/17/2011,379710948,1/30/2011,3762,81.73,56.67,307468.26,213192.54,94275.72
Sub-Saharan Africa,Kenya,Cereal,Online,H,10/11/2015,473555219,11/6/2015,4368,205.70,117.11,898497.60,511536.48,386961.12
Sub-Saharan Africa,Benin,Office Supplies,Online,C,2/21/2011,547143447,2/23/2011,760,651.21,524.96,494919.60,398969.60,95950.00
Central America and the Caribbean,Saint Lucia,Personal Care,Online,C,4/29/2012,133336961,6/13/2012,6225,81.73,56.67,508769.25,352770.75,155998.50
Middle East and North Africa,Qatar,Meat,Online,H,8/30/2016,635309588,10/14/2016,1080,421.89,364.69,455641.20,393865.20,61776.00
Sub-Saharan Africa,Mozambique,Beverages,Online,C,12/20/2014,376547658,12/26/2014,7675,47.45,31.79,364178.75,243988.25,120190.50
Middle East and North Africa,Pakistan,Clothes,Offline,M,6/28/2010,450849997,7/21/2010,5388,109.28,35.84,588800.64,193105.92,395694.72
Asia,Taiwan,Personal Care,Online,M,2/6/2015,672327935,2/6/2015,5631,81.73,56.67,460221.63,319108.77,141112.86
Central America and the Caribbean,Cuba,Cereal,Offline,L,3/30/2015,925405299,5/1/2015,6847,205.70,117.11,1408427.90,801852.17,606575.73
Central America and the Caribbean,Cuba,Household,Offline,H,7/28/2013,714818418,8/24/2013,9509,668.27,502.54,6354579.43,4778652.86,1575926.57
Europe,Russia,Beverages,Offline,C,1/6/2010,515616118,2/5/2010,1122,47.45,31.79,53238.90,35668.38,17570.52
Europe,Switzerland,Cereal,Offline,C,2/20/2013,423159730,4/11/2013,1222,205.70,117.11,251365.40,143108.42,108256.98
Europe,Czech Republic,Personal Care,Offline,H,8/25/2013,603123080,9/29/2013,6377,81.73,56.67,521192.21,361384.59,159807.62
Europe,Poland,Meat,Offline,C,11/16/2010,841492497,12/31/2010,5185,421.89,364.69,2187499.65,1890917.65,296582.00
Sub-Saharan Africa,Mauritius ,Cereal,Offline,L,8/2/2016,994566810,9/1/2016,3275,205.70,117.11,673667.50,383535.25,290132.25
Middle East and North Africa,Pakistan,Vegetables,Offline,M,4/25/2013,538957345,4/25/2013,8310,154.06,90.93,1280238.60,755628.30,524610.30
Sub-Saharan Africa,South Africa,Fruits,Offline,L,3/2/2011,821587932,3/11/2011,4981,9.33,6.92,46472.73,34468.52,12004.21
Sub-Saharan Africa,Seychelles ,Household,Online,C,9/28/2013,109694898,10/16/2013,13,668.27,502.54,8687.51,6533.02,2154.49
Sub-Saharan Africa,Benin,Meat,Offline,M,5/5/2014,340827071,6/5/2014,7159,421.89,364.69,3020310.51,2610815.71,409494.80
Sub-Saharan Africa,Benin,Meat,Offline,L,11/28/2014,372845780,12/9/2014,2207,421.89,364.69,931111.23,804870.83,126240.40
Central America and the Caribbean,Nicaragua,Fruits,Online,M,8/30/2014,933924853,9/13/2014,7973,9.33,6.92,74388.09,55173.16,19214.93
Middle East and North Africa,Lebanon,Office Supplies,Online,L,11/20/2013,572550618,11/25/2013,9306,651.21,524.96,6060160.26,4885277.76,1174882.50
Europe,Moldova ,Meat,Online,M,2/23/2010,607521903,4/5/2010,8086,421.89,364.69,3411402.54,2948883.34,462519.20
Middle East and North Africa,Tunisia ,Snacks,Online,H,3/20/2017,177950036,4/29/2017,8225,152.58,97.44,1254970.50,801444.00,453526.50
Australia and Oceania,Vanuatu,Beverages,Offline,M,11/8/2015,293258845,11/14/2015,664,47.45,31.79,31506.80,21108.56,10398.24
Sub-Saharan Africa,South Sudan,Beverages,Online,C,8/9/2010,683184659,8/23/2010,8377,47.45,31.79,397488.65,266304.83,131183.82
Europe,Sweden,Cereal,Online,L,11/12/2010,247776305,11/30/2010,1370,205.70,117.11,281809.00,160440.70,121368.30
Europe,Ireland,Meat,Offline,C,12/14/2011,207395112,1/26/2012,1677,421.89,364.69,707509.53,611585.13,95924.40
Europe,Italy,Vegetables,Offline,L,1/10/2014,952714908,2/25/2014,8367,154.06,90.93,1289020.02,760811.31,528208.71
Europe,Bosnia and Herzegovina,Vegetables,Online,C,10/3/2010,694722020,10/3/2010,2539,154.06,90.93,391158.34,230871.27,160287.07
Europe,Bosnia and Herzegovina,Household,Online,H,10/15/2015,414715278,11/4/2015,2321,668.27,502.54,1551054.67,1166395.34,384659.33
Europe,Poland,Snacks,Offline,M,7/20/2013,714306008,8/17/2013,7876,152.58,97.44,1201720.08,767437.44,434282.64
Middle East and North Africa,Kuwait,Snacks,Online,H,1/19/2016,465418040,2/26/2016,6396,152.58,97.44,975901.68,623226.24,352675.44
Sub-Saharan Africa,Sudan,Cereal,Online,M,8/17/2013,860287702,9/11/2013,7103,205.70,117.11,1461087.10,831832.33,629254.77
Middle East and North Africa,Saudi Arabia,Vegetables,Online,C,8/16/2016,461463820,8/20/2016,6254,154.06,90.93,963491.24,568676.22,394815.02
Sub-Saharan Africa,Swaziland,Baby Food,Offline,M,9/25/2013,151807725,9/29/2013,2134,255.28,159.42,544767.52,340202.28,204565.24
Sub-Saharan Africa,Rwanda,Meat,Offline,C,8/21/2013,884493243,10/2/2013,61,421.89,364.69,25735.29,22246.09,3489.20
Asia,Cambodia,Cosmetics,Offline,M,12/10/2010,533006703,1/23/2011,7383,437.20,263.33,3227847.60,1944165.39,1283682.21
Sub-Saharan Africa,Central African Republic,Vegetables,Online,C,9/4/2012,641146934,10/4/2012,8480,154.06,90.93,1306428.80,771086.40,535342.40
Asia,Maldives,Cosmetics,Offline,M,10/15/2011,573025262,11/14/2011,9764,437.20,263.33,4268820.80,2571154.12,1697666.68
Sub-Saharan Africa,Djibouti,Household,Offline,C,8/26/2013,663065516,9/9/2013,4676,668.27,502.54,3124830.52,2349877.04,774953.48
Asia,Tajikistan,Beverages,Online,M,2/17/2017,866004025,3/4/2017,8691,47.45,31.79,412387.95,276286.89,136101.06
Asia,Sri Lanka,Baby Food,Online,H,10/19/2010,306889617,10/21/2010,4312,255.28,159.42,1100767.36,687419.04,413348.32
Europe,Montenegro,Personal Care,Online,M,7/30/2014,431083619,8/10/2014,6077,81.73,56.67,496673.21,344383.59,152289.62
Middle East and North Africa,United Arab Emirates,Personal Care,Online,H,5/21/2015,954259860,6/4/2015,5553,81.73,56.67,453846.69,314688.51,139158.18
Central America and the Caribbean,Dominican Republic,Personal Care,Offline,C,5/5/2016,312404668,6/21/2016,6338,81.73,56.67,518004.74,359174.46,158830.28
Sub-Saharan Africa,Seychelles ,Office Supplies,Offline,C,4/14/2010,611816871,5/16/2010,9063,651.21,524.96,5901916.23,4757712.48,1144203.75
Europe,Iceland,Office Supplies,Online,C,10/26/2013,879107797,11/2/2013,6388,651.21,524.96,4159929.48,3353444.48,806485.00
Sub-Saharan Africa,Nigeria,Vegetables,Offline,C,7/21/2010,211201274,9/9/2010,8005,154.06,90.93,1233250.30,727894.65,505355.65
Sub-Saharan Africa,Rwanda,Fruits,Online,H,6/9/2015,925333631,7/25/2015,5639,9.33,6.92,52611.87,39021.88,13589.99
Europe,Hungary,Snacks,Offline,C,6/3/2010,909053695,6/27/2010,8044,152.58,97.44,1227353.52,783807.36,443546.16
Europe,Belarus,Baby Food,Online,L,5/17/2016,370222795,6/11/2016,6007,255.28,159.42,1533466.96,957635.94,575831.02
Sub-Saharan Africa,South Sudan,Cosmetics,Offline,H,8/3/2013,487014758,8/30/2013,7344,437.20,263.33,3210796.80,1933895.52,1276901.28
Europe,Andorra,Vegetables,Online,M,9/15/2013,257915914,10/6/2013,1905,154.06,90.93,293484.30,173221.65,120262.65
Asia,Japan,Meat,Offline,M,7/2/2010,551725089,8/10/2010,6569,421.89,364.69,2771395.41,2395648.61,375746.80
Central America and the Caribbean,El Salvador,Meat,Offline,L,12/18/2013,957553613,1/10/2014,248,421.89,364.69,104628.72,90443.12,14185.60
Sub-Saharan Africa,Kenya,Office Supplies,Offline,L,3/19/2016,234825313,3/23/2016,8883,651.21,524.96,5784698.43,4663219.68,1121478.75
Europe,Bosnia and Herzegovina,Snacks,Online,M,6/9/2010,363276517,7/9/2010,449,152.58,97.44,68508.42,43750.56,24757.86
Europe,Andorra,Personal Care,Online,M,5/21/2017,692956054,6/23/2017,9950,81.73,56.67,813213.50,563866.50,249347.00
Sub-Saharan Africa,Cape Verde,Cosmetics,Online,H,6/12/2013,194225251,6/19/2013,4423,437.20,263.33,1933735.60,1164708.59,769027.01
Australia and Oceania,Nauru,Fruits,Online,L,2/22/2010,607757937,4/5/2010,7934,9.33,6.92,74024.22,54903.28,19120.94
Europe,Czech Republic,Cereal,Offline,H,6/29/2012,594540441,7/30/2012,6583,205.70,117.11,1354123.10,770935.13,583187.97
Europe,Serbia,Vegetables,Online,L,3/23/2015,685871589,4/5/2015,3500,154.06,90.93,539210.00,318255.00,220955.00
Australia and Oceania,Tuvalu,Cereal,Offline,C,2/12/2014,133362710,3/23/2014,3844,205.70,117.11,790710.80,450170.84,340539.96
Sub-Saharan Africa,Madagascar,Clothes,Offline,H,5/22/2017,958937633,7/5/2017,9810,109.28,35.84,1072036.80,351590.40,720446.40
Sub-Saharan Africa,Ethiopia,Vegetables,Online,C,8/6/2011,304832684,9/6/2011,5620,154.06,90.93,865817.20,511026.60,354790.60
Asia,Malaysia,Baby Food,Offline,L,11/14/2010,783596694,12/24/2010,2530,255.28,159.42,645858.40,403332.60,242525.80
Sub-Saharan Africa,Tanzania,Household,Offline,C,4/5/2015,128090989,4/27/2015,3825,668.27,502.54,2556132.75,1922215.50,633917.25
Sub-Saharan Africa,Cote d'Ivoire,Vegetables,Offline,M,7/8/2014,641489398,7/28/2014,9823,154.06,90.93,1513331.38,893205.39,620125.99
Australia and Oceania,Solomon Islands,Clothes,Offline,M,8/9/2014,647278249,9/16/2014,2873,109.28,35.84,313961.44,102968.32,210993.12
Europe,Netherlands,Clothes,Online,H,3/13/2011,339256370,3/31/2011,2354,109.28,35.84,257245.12,84367.36,172877.76
Sub-Saharan Africa,Mali,Baby Food,Offline,M,3/2/2016,431535089,3/19/2016,9677,255.28,159.42,2470344.56,1542707.34,927637.22
Middle East and North Africa,Afghanistan,Cereal,Offline,C,12/19/2015,808538234,1/16/2016,3286,205.70,117.11,675930.20,384823.46,291106.74
Europe,Moldova ,Personal Care,Online,C,3/28/2013,975002133,4/7/2013,3653,81.73,56.67,298559.69,207015.51,91544.18
Asia,Bhutan,Snacks,Online,H,6/27/2015,505975615,7/4/2015,8283,152.58,97.44,1263820.14,807095.52,456724.62
Asia,Vietnam,Vegetables,Offline,M,2/18/2016,396820008,3/20/2016,6714,154.06,90.93,1034358.84,610504.02,423854.82
Europe,Portugal,Vegetables,Online,H,6/14/2013,813209140,7/10/2013,5511,154.06,90.93,849024.66,501115.23,347909.43
Europe,Spain,Baby Food,Online,M,5/10/2014,641129338,5/14/2014,3273,255.28,159.42,835531.44,521781.66,313749.78
Middle East and North Africa,Egypt,Meat,Offline,C,6/17/2015,636879432,7/3/2015,5632,421.89,364.69,2376084.48,2053934.08,322150.40
Europe,Belgium,Snacks,Online,C,6/11/2014,277070748,7/2/2014,246,152.58,97.44,37534.68,23970.24,13564.44
Asia,Malaysia,Cosmetics,Offline,H,11/3/2013,908627116,11/24/2013,1810,437.20,263.33,791332.00,476627.30,314704.70
Central America and the Caribbean,Dominican Republic,Cosmetics,Offline,C,4/2/2017,798784863,5/2/2017,7047,437.20,263.33,3080948.40,1855686.51,1225261.89
Europe,Estonia,Beverages,Offline,H,5/28/2010,985092818,7/17/2010,9711,47.45,31.79,460786.95,308712.69,152074.26
Sub-Saharan Africa,Burundi,Snacks,Offline,C,5/22/2010,325412309,7/7/2010,5588,152.58,97.44,852617.04,544494.72,308122.32
Europe,Latvia,Beverages,Online,M,6/2/2016,447917163,6/24/2016,7497,47.45,31.79,355732.65,238329.63,117403.02
Asia,Tajikistan,Meat,Offline,M,8/22/2013,801093709,10/5/2013,285,421.89,364.69,120238.65,103936.65,16302.00
Sub-Saharan Africa,Zimbabwe,Fruits,Offline,H,10/5/2014,903740775,10/23/2014,5833,9.33,6.92,54421.89,40364.36,14057.53
Sub-Saharan Africa,Comoros,Meat,Offline,L,10/31/2010,794969689,11/13/2010,8052,421.89,364.69,3397058.28,2936483.88,460574.40
Sub-Saharan Africa,Namibia,Clothes,Online,L,11/27/2012,584204280,1/1/2013,7884,109.28,35.84,861563.52,282562.56,579000.96
Europe,Slovenia,Cereal,Offline,H,5/22/2010,901180875,5/26/2010,8302,205.70,117.11,1707721.40,972247.22,735474.18
Europe,Bulgaria,Snacks,Offline,L,8/31/2012,645948302,9/29/2012,9312,152.58,97.44,1420824.96,907361.28,513463.68
Sub-Saharan Africa,Guinea-Bissau,Cereal,Online,L,1/23/2015,138867890,2/22/2015,2950,205.70,117.11,606815.00,345474.50,261340.50
Sub-Saharan Africa,Lesotho,Beverages,Offline,L,3/2/2010,670613467,3/21/2010,8282,47.45,31.79,392980.90,263284.78,129696.12
Asia,Sri Lanka,Cosmetics,Offline,L,5/9/2014,452171361,5/27/2014,6409,437.20,263.33,2802014.80,1687681.97,1114332.83
Australia and Oceania,East Timor,Snacks,Online,H,12/28/2010,464840400,2/5/2011,5459,152.58,97.44,832934.22,531924.96,301009.26
Europe,Belarus,Household,Online,M,10/19/2014,410231912,10/24/2014,5594,668.27,502.54,3738302.38,2811208.76,927093.62
Sub-Saharan Africa,Benin,Meat,Offline,H,1/21/2015,960269725,2/22/2015,4006,421.89,364.69,1690091.34,1460948.14,229143.20
Europe,Ireland,Beverages,Offline,L,4/4/2017,607190167,5/18/2017,9919,47.45,31.79,470656.55,315325.01,155331.54
Middle East and North Africa,Iran,Meat,Offline,H,8/5/2016,613542068,8/11/2016,9587,421.89,364.69,4044659.43,3496283.03,548376.40
Sub-Saharan Africa,Benin,Household,Offline,C,11/26/2016,962186753,1/12/2017,1297,668.27,502.54,866746.19,651794.38,214951.81
Sub-Saharan Africa,South Sudan,Beverages,Online,L,9/23/2011,806298053,10/24/2011,366,47.45,31.79,17366.70,11635.14,5731.56
Sub-Saharan Africa,Comoros,Personal Care,Online,L,10/24/2010,719362294,12/3/2010,4144,81.73,56.67,338689.12,234840.48,103848.64
Europe,Poland,Baby Food,Online,H,8/14/2013,445178306,9/22/2013,7008,255.28,159.42,1789002.24,1117215.36,671786.88
Europe,Bosnia and Herzegovina,Cosmetics,Offline,C,2/4/2013,247857415,2/15/2013,5372,437.20,263.33,2348638.40,1414608.76,934029.64
Sub-Saharan Africa,Namibia,Vegetables,Offline,C,8/11/2014,461823451,9/4/2014,2677,154.06,90.93,412418.62,243419.61,168999.01
Europe,Spain,Office Supplies,Offline,C,1/12/2017,141812741,1/24/2017,4396,651.21,524.96,2862719.16,2307724.16,554995.00
Middle East and North Africa,Iran,Meat,Online,C,7/3/2016,212874114,8/17/2016,3036,421.89,364.69,1280858.04,1107198.84,173659.20
Central America and the Caribbean,Guatemala,Office Supplies,Offline,C,3/27/2010,320368897,4/2/2010,3131,651.21,524.96,2038938.51,1643649.76,395288.75
Australia and Oceania,East Timor,Beverages,Online,C,6/5/2015,179970920,6/25/2015,6249,47.45,31.79,296515.05,198655.71,97859.34
Middle East and North Africa,Bahrain,Household,Online,H,6/27/2012,927666509,7/17/2012,5990,668.27,502.54,4002937.30,3010214.60,992722.70
Sub-Saharan Africa,Ethiopia,Office Supplies,Online,L,12/19/2016,169754493,1/20/2017,2982,651.21,524.96,1941908.22,1565430.72,376477.50
Australia and Oceania,Solomon Islands,Personal Care,Offline,M,3/9/2015,532846200,4/20/2015,9886,81.73,56.67,807982.78,560239.62,247743.16
Central America and the Caribbean,Belize,Snacks,Online,C,6/18/2013,213865458,7/13/2013,6397,152.58,97.44,976054.26,623323.68,352730.58
Asia,Sri Lanka,Office Supplies,Online,C,8/12/2011,630048596,9/3/2011,4236,651.21,524.96,2758525.56,2223730.56,534795.00
Central America and the Caribbean,Costa Rica,Clothes,Offline,H,4/17/2014,568944442,4/24/2014,2158,109.28,35.84,235826.24,77342.72,158483.52
Sub-Saharan Africa,Nigeria,Baby Food,Online,L,2/3/2012,238414323,2/27/2012,951,255.28,159.42,242771.28,151608.42,91162.86
Middle East and North Africa,Iran,Office Supplies,Online,L,8/1/2015,816632068,9/19/2015,8431,651.21,524.96,5490351.51,4425937.76,1064413.75
Sub-Saharan Africa,Djibouti,Baby Food,Online,C,9/11/2013,402084004,10/5/2013,4447,255.28,159.42,1135230.16,708940.74,426289.42
Asia,South Korea,Snacks,Online,L,5/8/2015,763568961,6/7/2015,5879,152.58,97.44,897017.82,572849.76,324168.06
Central America and the Caribbean,Dominica,Snacks,Offline,L,5/22/2015,590198266,6/1/2015,1637,152.58,97.44,249773.46,159509.28,90264.18
Asia,Vietnam,Snacks,Online,L,7/3/2013,441395747,8/19/2013,7665,152.58,97.44,1169525.70,746877.60,422648.10
Europe,Norway,Personal Care,Offline,H,6/16/2010,496897733,7/21/2010,1936,81.73,56.67,158229.28,109713.12,48516.16
Central America and the Caribbean,Haiti,Beverages,Online,C,11/8/2011,106753051,11/14/2011,9455,47.45,31.79,448639.75,300574.45,148065.30
Central America and the Caribbean,Jamaica,Fruits,Offline,L,10/17/2016,941323029,10/27/2016,7258,9.33,6.92,67717.14,50225.36,17491.78
Sub-Saharan Africa,Sudan,Vegetables,Offline,M,2/2/2014,241281497,3/3/2014,9412,154.06,90.93,1450012.72,855833.16,594179.56
Sub-Saharan Africa,Angola,Meat,Offline,L,4/30/2016,267614781,5/12/2016,2016,421.89,364.69,850530.24,735215.04,115315.20
Central America and the Caribbean,Panama,Cosmetics,Offline,M,8/31/2010,651621711,10/16/2010,8200,437.20,263.33,3585040.00,2159306.00,1425734.00
Europe,Greece,Personal Care,Online,M,8/8/2015,644913613,9/7/2015,3124,81.73,56.67,255324.52,177037.08,78287.44
Sub-Saharan Africa,Madagascar,Cereal,Offline,H,8/18/2016,469414317,8/19/2016,8983,205.70,117.11,1847803.10,1051999.13,795803.97
Sub-Saharan Africa,Guinea-Bissau,Clothes,Online,L,6/18/2015,867360150,7/1/2015,9998,109.28,35.84,1092581.44,358328.32,734253.12
North America,Greenland,Clothes,Online,L,1/28/2011,851299941,2/1/2011,7425,109.28,35.84,811404.00,266112.00,545292.00
Middle East and North Africa,Libya,Beverages,Offline,H,2/4/2011,854095017,3/4/2011,4550,47.45,31.79,215897.50,144644.50,71253.00
Europe,Belarus,Vegetables,Offline,C,11/3/2012,478919208,11/27/2012,1691,154.06,90.93,260515.46,153762.63,106752.83
Middle East and North Africa,Lebanon,Clothes,Offline,H,9/18/2014,749258840,11/5/2014,1196,109.28,35.84,130698.88,42864.64,87834.24
Sub-Saharan Africa,Djibouti,Baby Food,Offline,H,5/17/2012,958912742,6/28/2012,2444,255.28,159.42,623904.32,389622.48,234281.84
Central America and the Caribbean,Barbados,Personal Care,Online,C,2/20/2010,921992242,3/4/2010,6848,81.73,56.67,559687.04,388076.16,171610.88
Sub-Saharan Africa,Guinea-Bissau,Vegetables,Online,L,2/28/2017,522921168,3/2/2017,2849,154.06,90.93,438916.94,259059.57,179857.37
Europe,Finland,Personal Care,Offline,C,5/17/2013,166435849,6/7/2013,921,81.73,56.67,75273.33,52193.07,23080.26
Central America and the Caribbean,Haiti,Baby Food,Offline,L,11/9/2013,327585113,11/23/2013,8569,255.28,159.42,2187494.32,1366069.98,821424.34
Sub-Saharan Africa,Niger,Clothes,Offline,M,1/10/2012,201730287,2/19/2012,5330,109.28,35.84,582462.40,191027.20,391435.20
Central America and the Caribbean,Trinidad and Tobago,Fruits,Offline,L,9/24/2013,854545199,11/9/2013,7769,9.33,6.92,72484.77,53761.48,18723.29
Central America and the Caribbean,Grenada,Personal Care,Online,M,9/26/2010,272016179,11/8/2010,4487,81.73,56.67,366722.51,254278.29,112444.22
Central America and the Caribbean,Dominican Republic,Cereal,Offline,H,10/21/2014,110442054,11/20/2014,1113,205.70,117.11,228944.10,130343.43,98600.67
Europe,Monaco,Household,Offline,C,1/17/2016,746434152,2/5/2016,5308,668.27,502.54,3547177.16,2667482.32,879694.84
Europe,Estonia,Vegetables,Online,L,12/27/2016,826916301,1/7/2017,1764,154.06,90.93,271761.84,160400.52,111361.32
Europe,Italy,Beverages,Offline,H,8/30/2013,419124829,9/19/2013,7206,47.45,31.79,341924.70,229078.74,112845.96
Asia,Malaysia,Office Supplies,Online,C,7/7/2014,560608565,8/24/2014,5387,651.21,524.96,3508068.27,2827959.52,680108.75
Sub-Saharan Africa,Ghana,Office Supplies,Offline,L,11/29/2013,109228837,12/7/2013,2095,651.21,524.96,1364284.95,1099791.20,264493.75
Middle East and North Africa,Pakistan,Clothes,Offline,C,1/29/2011,693159472,2/5/2011,146,109.28,35.84,15954.88,5232.64,10722.24
Asia,Sri Lanka,Snacks,Offline,L,11/13/2013,860886800,11/23/2013,4390,152.58,97.44,669826.20,427761.60,242064.60
Europe,Romania,Fruits,Offline,C,4/9/2012,131209647,5/3/2012,6705,9.33,6.92,62557.65,46398.60,16159.05
Middle East and North Africa,Qatar,Office Supplies,Online,H,6/28/2012,343239343,7/13/2012,1004,651.21,524.96,653814.84,527059.84,126755.00
Sub-Saharan Africa,Cote d'Ivoire,Clothes,Online,H,6/8/2010,706399714,7/19/2010,8228,109.28,35.84,899155.84,294891.52,604264.32
Middle East and North Africa,Egypt,Office Supplies,Online,M,8/23/2010,950427091,9/14/2010,1352,651.21,524.96,880435.92,709745.92,170690.00
Middle East and North Africa,Iran,Snacks,Offline,H,12/11/2014,875370299,12/28/2014,379,152.58,97.44,57827.82,36929.76,20898.06
Middle East and North Africa,Somalia,Clothes,Online,C,1/27/2011,801590669,3/15/2011,7347,109.28,35.84,802880.16,263316.48,539563.68
Middle East and North Africa,Syria,Personal Care,Offline,C,5/7/2014,219762027,5/28/2014,1322,81.73,56.67,108047.06,74917.74,33129.32
Australia and Oceania,Solomon Islands,Cereal,Offline,C,11/8/2010,940870702,11/21/2010,3404,205.70,117.11,700202.80,398642.44,301560.36
Central America and the Caribbean,Guatemala,Fruits,Online,M,3/30/2014,346215522,5/4/2014,1721,9.33,6.92,16056.93,11909.32,4147.61
Middle East and North Africa,Kuwait,Clothes,Offline,C,7/9/2016,837407815,7/20/2016,6436,109.28,35.84,703326.08,230666.24,472659.84
Middle East and North Africa,Jordan,Meat,Online,L,7/15/2014,386371409,7/19/2014,4741,421.89,364.69,2000180.49,1728995.29,271185.20
Australia and Oceania,Marshall Islands,Beverages,Offline,H,10/14/2013,185342633,11/24/2013,5859,47.45,31.79,278009.55,186257.61,91751.94
Middle East and North Africa,Egypt,Snacks,Offline,C,1/13/2017,596870315,2/18/2017,6045,152.58,97.44,922346.10,589024.80,333321.30
Europe,Switzerland,Meat,Online,C,12/22/2012,703815782,1/7/2013,3585,421.89,364.69,1512475.65,1307413.65,205062.00
Australia and Oceania,Samoa ,Personal Care,Online,C,4/16/2010,559352862,6/4/2010,3797,81.73,56.67,310328.81,215175.99,95152.82
Europe,Portugal,Cosmetics,Offline,C,2/27/2011,736967885,3/12/2011,4029,437.20,263.33,1761478.80,1060956.57,700522.23
Europe,Albania,Clothes,Offline,C,1/14/2015,980459678,2/9/2015,8661,109.28,35.84,946474.08,310410.24,636063.84
Central America and the Caribbean,Dominica,Vegetables,Offline,C,11/16/2014,653939568,12/6/2014,4105,154.06,90.93,632416.30,373267.65,259148.65
Australia and Oceania,Tuvalu,Cosmetics,Online,H,1/17/2016,991831386,1/29/2016,3803,437.20,263.33,1662671.60,1001443.99,661227.61
Australia and Oceania,Marshall Islands,Cereal,Online,L,5/29/2017,148871457,7/6/2017,3227,205.70,117.11,663793.90,377913.97,285879.93
Europe,Bulgaria,Fruits,Online,H,2/10/2015,850108611,2/25/2015,4884,9.33,6.92,45567.72,33797.28,11770.44
Sub-Saharan Africa,Niger,Office Supplies,Offline,M,12/8/2013,940904176,1/7/2014,3309,651.21,524.96,2154853.89,1737092.64,417761.25
Central America and the Caribbean,Saint Vincent and the Grenadines,Office Supplies,Offline,H,12/10/2015,136931979,12/13/2015,70,651.21,524.96,45584.70,36747.20,8837.50
Sub-Saharan Africa,Malawi,Beverages,Offline,L,9/4/2016,474178349,9/26/2016,8766,47.45,31.79,415946.70,278671.14,137275.56
Sub-Saharan Africa,Cape Verde,Personal Care,Offline,L,7/19/2016,458942115,7/29/2016,25,81.73,56.67,2043.25,1416.75,626.50
Central America and the Caribbean,Saint Vincent and the Grenadines,Beverages,Offline,C,1/9/2017,917834603,1/13/2017,6510,47.45,31.79,308899.50,206952.90,101946.60
Europe,Greece,Personal Care,Offline,H,11/5/2016,947779643,12/5/2016,7913,81.73,56.67,646729.49,448429.71,198299.78
Europe,Monaco,Clothes,Online,L,10/31/2015,166013562,11/26/2015,5957,109.28,35.84,650980.96,213498.88,437482.08
Sub-Saharan Africa,Nigeria,Beverages,Online,L,1/25/2011,960085189,2/13/2011,9397,47.45,31.79,445887.65,298730.63,147157.02
Europe,Norway,Cosmetics,Offline,C,11/8/2015,837855851,11/8/2015,9020,437.20,263.33,3943544.00,2375236.60,1568307.40
North America,Greenland,Snacks,Offline,L,6/24/2010,977499377,8/12/2010,2643,152.58,97.44,403268.94,257533.92,145735.02
Middle East and North Africa,Tunisia ,Beverages,Online,L,2/27/2014,377502095,3/3/2014,114,47.45,31.79,5409.30,3624.06,1785.24
Asia,Uzbekistan,Meat,Offline,H,2/5/2013,806662833,3/27/2013,8313,421.89,364.69,3507171.57,3031667.97,475503.60
Central America and the Caribbean,Saint Kitts and Nevis ,Vegetables,Online,H,4/15/2017,954092919,5/11/2017,6152,154.06,90.93,947777.12,559401.36,388375.76
Central America and the Caribbean,Belize,Meat,Online,L,4/9/2011,479216182,4/26/2011,9572,421.89,364.69,4038331.08,3490812.68,547518.40
Sub-Saharan Africa,Angola,Personal Care,Online,H,12/13/2010,461768949,12/30/2010,6548,81.73,56.67,535168.04,371075.16,164092.88
Asia,Bhutan,Meat,Online,C,5/13/2014,251800048,5/22/2014,2085,421.89,364.69,879640.65,760378.65,119262.00
Central America and the Caribbean,Honduras,Personal Care,Offline,L,1/16/2013,619670808,2/25/2013,3217,81.73,56.67,262925.41,182307.39,80618.02
Sub-Saharan Africa,South Sudan,Household,Offline,H,12/9/2010,606055057,1/23/2011,4014,668.27,502.54,2682435.78,2017195.56,665240.22
Asia,Kyrgyzstan,Baby Food,Online,L,1/24/2013,671939122,2/14/2013,573,255.28,159.42,146275.44,91347.66,54927.78
Sub-Saharan Africa,Sao Tome and Principe,Cosmetics,Offline,M,2/25/2014,448621833,3/3/2014,6025,437.20,263.33,2634130.00,1586563.25,1047566.75
Sub-Saharan Africa,Madagascar,Fruits,Online,M,7/23/2017,987714517,9/11/2017,5530,9.33,6.92,51594.90,38267.60,13327.30
Sub-Saharan Africa,Senegal,Household,Online,H,5/7/2016,711141002,6/14/2016,1280,668.27,502.54,855385.60,643251.20,212134.40
Sub-Saharan Africa,Sierra Leone,Office Supplies,Online,C,3/24/2012,361137616,4/18/2012,7501,651.21,524.96,4884726.21,3937724.96,947001.25
Asia,Malaysia,Household,Offline,H,10/3/2011,750253188,11/21/2011,5446,668.27,502.54,3639398.42,2736832.84,902565.58
Central America and the Caribbean,Cuba,Office Supplies,Online,C,12/22/2014,511349046,1/2/2015,8401,651.21,524.96,5470815.21,4410188.96,1060626.25
Sub-Saharan Africa,Zimbabwe,Personal Care,Offline,L,8/23/2011,147599017,8/28/2011,6684,81.73,56.67,546283.32,378782.28,167501.04
Europe,Serbia,Beverages,Online,H,4/18/2015,682489430,5/23/2015,2644,47.45,31.79,125457.80,84052.76,41405.04
Asia,Maldives,Vegetables,Offline,M,1/11/2014,509819114,2/23/2014,5660,154.06,90.93,871979.60,514663.80,357315.80
Europe,Ireland,Office Supplies,Offline,M,2/27/2012,343699395,4/2/2012,7144,651.21,524.96,4652244.24,3750314.24,901930.00
Europe,Romania,Clothes,Offline,L,4/4/2011,968554103,4/8/2011,5537,109.28,35.84,605083.36,198446.08,406637.28
Europe,Croatia,Beverages,Online,M,12/26/2013,989119565,1/6/2014,1315,47.45,31.79,62396.75,41803.85,20592.90
Europe,Albania,Vegetables,Offline,M,9/12/2012,880444610,10/31/2012,1980,154.06,90.93,305038.80,180041.40,124997.40
Central America and the Caribbean,Dominican Republic,Vegetables,Offline,L,12/19/2015,737890565,1/15/2016,7071,154.06,90.93,1089358.26,642966.03,446392.23
Sub-Saharan Africa,Zimbabwe,Vegetables,Online,M,6/26/2014,727131259,8/9/2014,3153,154.06,90.93,485751.18,286702.29,199048.89
Sub-Saharan Africa,Ghana,Office Supplies,Offline,L,3/2/2015,634153020,3/11/2015,8826,651.21,524.96,5747579.46,4633296.96,1114282.50
Asia,Laos,Beverages,Online,H,8/17/2014,315254676,9/8/2014,9719,47.45,31.79,461166.55,308967.01,152199.54
Central America and the Caribbean,Panama,Personal Care,Offline,M,7/19/2010,147047555,9/3/2010,3494,81.73,56.67,285564.62,198004.98,87559.64
Sub-Saharan Africa,Angola,Household,Online,L,1/14/2013,576455485,2/13/2013,4843,668.27,502.54,3236431.61,2433801.22,802630.39
Middle East and North Africa,Syria,Snacks,Offline,L,7/19/2010,770714795,8/26/2010,490,152.58,97.44,74764.20,47745.60,27018.60
Sub-Saharan Africa,Sierra Leone,Cosmetics,Offline,H,7/11/2011,867374312,8/3/2011,4189,437.20,263.33,1831430.80,1103089.37,728341.43
Sub-Saharan Africa,Uganda,Fruits,Online,L,5/4/2010,624295365,6/23/2010,1727,9.33,6.92,16112.91,11950.84,4162.07
Asia,Taiwan,Clothes,Offline,M,10/13/2013,769651782,11/3/2013,5921,109.28,35.84,647046.88,212208.64,434838.24
Middle East and North Africa,Azerbaijan,Vegetables,Online,C,7/27/2014,751929891,8/1/2014,1619,154.06,90.93,249423.14,147215.67,102207.47
Asia,Maldives,Office Supplies,Online,H,4/4/2010,989928519,4/11/2010,702,651.21,524.96,457149.42,368521.92,88627.50
Sub-Saharan Africa,Mauritania,Meat,Offline,H,8/17/2014,622758996,10/1/2014,7081,421.89,364.69,2987403.09,2582369.89,405033.20
Sub-Saharan Africa,Burundi,Baby Food,Online,H,1/4/2016,659845149,1/29/2016,1698,255.28,159.42,433465.44,270695.16,162770.28
Sub-Saharan Africa,Zambia,Baby Food,Offline,H,5/17/2011,830923306,6/5/2011,7526,255.28,159.42,1921237.28,1199794.92,721442.36
Asia,Singapore,Beverages,Offline,L,2/12/2010,936042296,3/17/2010,4571,47.45,31.79,216893.95,145312.09,71581.86
Sub-Saharan Africa,Ghana,Household,Online,L,2/17/2015,395563447,3/30/2015,4869,668.27,502.54,3253806.63,2446867.26,806939.37
Sub-Saharan Africa,Guinea,Meat,Offline,M,6/7/2011,500160586,6/7/2011,7487,421.89,364.69,3158690.43,2730434.03,428256.40
Sub-Saharan Africa,Zambia,Fruits,Online,L,5/26/2015,360820043,7/2/2015,3524,9.33,6.92,32878.92,24386.08,8492.84
Europe,Georgia,Snacks,Online,C,5/24/2010,958840644,6/2/2010,1109,152.58,97.44,169211.22,108060.96,61150.26
Middle East and North Africa,Bahrain,Baby Food,Online,M,2/21/2011,195833718,4/7/2011,404,255.28,159.42,103133.12,64405.68,38727.44
Sub-Saharan Africa,Lesotho,Personal Care,Offline,M,6/28/2014,543723094,7/2/2014,8601,81.73,56.67,702959.73,487418.67,215541.06
Central America and the Caribbean,Barbados,Cosmetics,Offline,H,10/15/2010,494745099,10/30/2010,4924,437.20,263.33,2152772.80,1296636.92,856135.88
Middle East and North Africa,Saudi Arabia,Vegetables,Online,H,5/18/2010,411448562,6/30/2010,5628,154.06,90.93,867049.68,511754.04,355295.64
Europe,Macedonia,Personal Care,Offline,H,2/2/2017,276694810,2/16/2017,8998,81.73,56.67,735406.54,509916.66,225489.88
Asia,Turkmenistan,Office Supplies,Offline,M,11/24/2016,143657672,1/8/2017,352,651.21,524.96,229225.92,184785.92,44440.00
Europe,Albania,Baby Food,Online,L,12/23/2011,585823476,1/6/2012,7040,255.28,159.42,1797171.20,1122316.80,674854.40
Middle East and North Africa,Afghanistan,Clothes,Online,C,12/5/2016,446991050,1/16/2017,3440,109.28,35.84,375923.20,123289.60,252633.60
Australia and Oceania,Kiribati,Clothes,Offline,M,2/16/2017,891271722,2/22/2017,5963,109.28,35.84,651636.64,213713.92,437922.72
Middle East and North Africa,Morocco,Cosmetics,Online,C,5/18/2010,453089320,6/16/2010,8053,437.20,263.33,3520771.60,2120596.49,1400175.11
Europe,Norway,Baby Food,Offline,L,9/7/2010,887180173,10/18/2010,5183,255.28,159.42,1323116.24,826273.86,496842.38
Europe,Sweden,Cosmetics,Online,L,3/12/2014,418593108,3/25/2014,9858,437.20,263.33,4309917.60,2595907.14,1714010.46
Asia,Tajikistan,Personal Care,Online,M,7/16/2010,492689454,8/16/2010,6613,81.73,56.67,540480.49,374758.71,165721.78
Europe,Netherlands,Cosmetics,Online,M,12/5/2016,825143039,12/20/2016,7017,437.20,263.33,3067832.40,1847786.61,1220045.79
Europe,Spain,Vegetables,Online,L,10/8/2013,751940190,10/10/2013,4667,154.06,90.93,718998.02,424370.31,294627.71
Sub-Saharan Africa,Chad,Baby Food,Offline,H,8/9/2016,579379737,8/26/2016,194,255.28,159.42,49524.32,30927.48,18596.84
Europe,Ireland,Meat,Online,C,10/6/2011,234073007,11/20/2011,6259,421.89,364.69,2640609.51,2282594.71,358014.80
Middle East and North Africa,Pakistan,Meat,Online,C,2/17/2013,612943828,3/1/2013,2554,421.89,364.69,1077507.06,931418.26,146088.80
Sub-Saharan Africa,Mozambique,Fruits,Online,C,12/14/2012,433228528,12/21/2012,804,9.33,6.92,7501.32,5563.68,1937.64
Middle East and North Africa,Bahrain,Fruits,Online,L,11/20/2015,282475936,11/28/2015,9762,9.33,6.92,91079.46,67553.04,23526.42
Asia,Tajikistan,Meat,Online,M,7/7/2012,368547379,7/12/2012,214,421.89,364.69,90284.46,78043.66,12240.80
Australia and Oceania,New Zealand,Meat,Offline,H,6/2/2013,969616687,6/28/2013,9980,421.89,364.69,4210462.20,3639606.20,570856.00
Sub-Saharan Africa,Niger,Baby Food,Online,L,2/4/2015,184170186,2/17/2015,8906,255.28,159.42,2273523.68,1419794.52,853729.16
Europe,Armenia,Fruits,Online,C,4/28/2011,681006705,6/14/2011,3872,9.33,6.92,36125.76,26794.24,9331.52
Sub-Saharan Africa,Gabon,Baby Food,Online,L,2/1/2012,249237573,2/21/2012,3791,255.28,159.42,967766.48,604361.22,363405.26
Asia,Kyrgyzstan,Vegetables,Offline,H,1/29/2017,348286616,2/13/2017,4604,154.06,90.93,709292.24,418641.72,290650.52
Australia and Oceania,Fiji,Clothes,Offline,L,12/1/2011,257890164,12/29/2011,4285,109.28,35.84,468264.80,153574.40,314690.40
Europe,Romania,Cosmetics,Online,H,5/8/2017,228097045,6/17/2017,7839,437.20,263.33,3427210.80,2064243.87,1362966.93
Sub-Saharan Africa,Botswana,Cereal,Online,C,5/3/2017,129268586,6/21/2017,2302,205.70,117.11,473521.40,269587.22,203934.18
Australia and Oceania,Fiji,Cosmetics,Online,M,10/31/2015,802078616,12/9/2015,1741,437.20,263.33,761165.20,458457.53,302707.67
Europe,Vatican City,Clothes,Offline,C,4/11/2010,907513463,4/19/2010,2256,109.28,35.84,246535.68,80855.04,165680.64
Asia,Thailand,Vegetables,Online,L,7/17/2010,976871955,8/31/2010,6975,154.06,90.93,1074568.50,634236.75,440331.75
Europe,Belarus,Cereal,Offline,C,5/31/2012,261765420,7/17/2012,1060,205.70,117.11,218042.00,124136.60,93905.40
Australia and Oceania,Solomon Islands,Vegetables,Offline,L,7/15/2016,784117686,7/17/2016,6703,154.06,90.93,1032664.18,609503.79,423160.39
Asia,China,Cosmetics,Offline,M,1/14/2017,586165082,1/27/2017,8128,437.20,263.33,3553561.60,2140346.24,1413215.36
Sub-Saharan Africa,Angola,Snacks,Online,C,11/26/2012,480456435,12/16/2012,6591,152.58,97.44,1005654.78,642227.04,363427.74
Asia,Cambodia,Cereal,Online,L,10/3/2011,899853074,10/26/2011,5376,205.70,117.11,1105843.20,629583.36,476259.84
Central America and the Caribbean,Guatemala,Baby Food,Offline,L,11/30/2010,547528827,12/15/2010,4802,255.28,159.42,1225854.56,765534.84,460319.72
Sub-Saharan Africa,Namibia,Vegetables,Online,L,5/8/2016,446970021,5/9/2016,7217,154.06,90.93,1111851.02,656241.81,455609.21
Europe,Serbia,Beverages,Offline,H,2/27/2016,791975486,3/20/2016,2001,47.45,31.79,94947.45,63611.79,31335.66
Middle East and North Africa,Turkey,Vegetables,Offline,M,8/24/2014,496656548,9/29/2014,564,154.06,90.93,86889.84,51284.52,35605.32
Middle East and North Africa,Pakistan,Vegetables,Offline,C,5/26/2013,345437037,6/30/2013,1351,154.06,90.93,208135.06,122846.43,85288.63
Europe,Georgia,Vegetables,Offline,H,1/26/2015,743053281,2/23/2015,4833,154.06,90.93,744571.98,439464.69,305107.29
Australia and Oceania,Vanuatu,Snacks,Offline,L,1/7/2012,364554107,1/18/2012,8516,152.58,97.44,1299371.28,829799.04,469572.24
Europe,Luxembourg,Cosmetics,Online,H,10/21/2012,205300843,12/3/2012,1937,437.20,263.33,846856.40,510070.21,336786.19
Middle East and North Africa,Saudi Arabia,Household,Online,M,9/16/2015,430967319,10/5/2015,1661,668.27,502.54,1109996.47,834718.94,275277.53
Australia and Oceania,Vanuatu,Meat,Offline,H,6/28/2012,827539861,7/1/2012,6289,421.89,364.69,2653266.21,2293535.41,359730.80
Central America and the Caribbean,Haiti,Snacks,Offline,H,12/2/2014,351317298,1/14/2015,1450,152.58,97.44,221241.00,141288.00,79953.00
Sub-Saharan Africa,Tanzania,Household,Offline,C,2/4/2013,278910958,2/4/2013,4805,668.27,502.54,3211037.35,2414704.70,796332.65
Asia,North Korea,Cosmetics,Offline,C,2/17/2017,157244670,3/15/2017,1047,437.20,263.33,457748.40,275706.51,182041.89
Middle East and North Africa,Bahrain,Beverages,Online,L,6/24/2015,953554761,7/28/2015,6899,47.45,31.79,327357.55,219319.21,108038.34
Sub-Saharan Africa,Cote d'Ivoire,Cereal,Online,L,7/30/2016,105390059,8/25/2016,6115,205.70,117.11,1257855.50,716127.65,541727.85
Asia,Singapore,Cosmetics,Offline,L,10/23/2014,970611894,11/10/2014,4483,437.20,263.33,1959967.60,1180508.39,779459.21
Asia,Malaysia,Baby Food,Offline,M,12/16/2016,677394092,12/29/2016,4820,255.28,159.42,1230449.60,768404.40,462045.20
Europe,Albania,Baby Food,Online,L,9/28/2015,474222981,10/26/2015,1973,255.28,159.42,503667.44,314535.66,189131.78
Sub-Saharan Africa,Gabon,Snacks,Online,L,4/16/2016,779897391,5/5/2016,7824,152.58,97.44,1193785.92,762370.56,431415.36
Europe,Poland,Snacks,Offline,L,3/27/2017,733528649,3/30/2017,6283,152.58,97.44,958660.14,612215.52,346444.62
Sub-Saharan Africa,Chad,Office Supplies,Online,H,6/25/2014,444540584,8/2/2014,8292,651.21,524.96,5399833.32,4352968.32,1046865.00
Sub-Saharan Africa,Republic of the Congo,Clothes,Online,H,7/29/2012,542669522,9/11/2012,6826,109.28,35.84,745945.28,244643.84,501301.44
Asia,Philippines,Fruits,Offline,L,5/4/2013,827964293,6/1/2013,1888,9.33,6.92,17615.04,13064.96,4550.08
Europe,France,Snacks,Offline,M,2/2/2012,720786225,2/15/2012,5516,152.58,97.44,841631.28,537479.04,304152.24
Europe,Germany,Household,Offline,H,7/24/2016,611809146,8/1/2016,6777,668.27,502.54,4528865.79,3405713.58,1123152.21
Sub-Saharan Africa,Uganda,Personal Care,Online,M,11/4/2012,512019383,12/12/2012,6769,81.73,56.67,553230.37,383599.23,169631.14
Middle East and North Africa,Bahrain,Personal Care,Online,C,8/5/2014,502715766,8/17/2014,3621,81.73,56.67,295944.33,205202.07,90742.26
Middle East and North Africa,Jordan,Office Supplies,Offline,M,10/22/2013,285509622,10/28/2013,7497,651.21,524.96,4882121.37,3935625.12,946496.25
Europe,Montenegro,Beverages,Offline,L,12/1/2014,532324779,1/3/2015,5586,47.45,31.79,265055.70,177578.94,87476.76
Middle East and North Africa,Tunisia ,Personal Care,Offline,H,11/2/2015,635397565,11/21/2015,7114,81.73,56.67,581427.22,403150.38,178276.84
Europe,Germany,Cereal,Offline,M,10/7/2011,957276809,11/4/2011,8335,205.70,117.11,1714509.50,976111.85,738397.65
Europe,Italy,Snacks,Online,L,2/9/2014,580823838,3/21/2014,7536,152.58,97.44,1149842.88,734307.84,415535.04
Europe,France,Office Supplies,Offline,H,5/29/2016,459212481,6/16/2016,33,651.21,524.96,21489.93,17323.68,4166.25
Middle East and North Africa,Algeria,Baby Food,Online,L,4/8/2013,265929067,5/23/2013,3175,255.28,159.42,810514.00,506158.50,304355.50
Asia,Myanmar,Beverages,Online,H,9/20/2011,644772422,10/26/2011,1343,47.45,31.79,63725.35,42693.97,21031.38
Europe,France,Vegetables,Offline,C,4/12/2012,959853875,5/4/2012,947,154.06,90.93,145894.82,86110.71,59784.11
Europe,Spain,Vegetables,Online,C,10/2/2012,645597255,10/25/2012,5429,154.06,90.93,836391.74,493658.97,342732.77
Asia,Cambodia,Baby Food,Offline,C,1/2/2012,556738889,1/25/2012,264,255.28,159.42,67393.92,42086.88,25307.04
Sub-Saharan Africa,The Gambia,Vegetables,Online,M,9/30/2013,718327605,11/10/2013,7956,154.06,90.93,1225701.36,723439.08,502262.28
Europe,Russia,Baby Food,Offline,L,3/10/2015,775724732,3/20/2015,3041,255.28,159.42,776306.48,484796.22,291510.26
Europe,Belarus,Baby Food,Offline,H,10/26/2010,444604098,10/31/2010,7088,255.28,159.42,1809424.64,1129968.96,679455.68
Middle East and North Africa,Turkey,Beverages,Online,C,5/2/2011,860952031,5/13/2011,3693,47.45,31.79,175232.85,117400.47,57832.38
Sub-Saharan Africa,Kenya,Meat,Offline,C,2/19/2017,531067359,2/20/2017,3488,421.89,364.69,1471552.32,1272038.72,199513.60
Middle East and North Africa,Iran,Cosmetics,Offline,M,7/20/2014,281561410,8/2/2014,9133,437.20,263.33,3992947.60,2404992.89,1587954.71
Asia,Vietnam,Personal Care,Offline,L,6/18/2017,109358012,7/10/2017,321,81.73,56.67,26235.33,18191.07,8044.26
Europe,Albania,Beverages,Online,L,7/19/2010,531693494,8/6/2010,8775,47.45,31.79,416373.75,278957.25,137416.50
Central America and the Caribbean,Antigua and Barbuda ,Clothes,Offline,C,8/9/2013,336116683,9/4/2013,3251,109.28,35.84,355269.28,116515.84,238753.44
Sub-Saharan Africa,Senegal,Cereal,Offline,M,3/23/2017,630488908,4/30/2017,4534,205.70,117.11,932643.80,530976.74,401667.06
Europe,Netherlands,Fruits,Online,L,10/31/2016,792983996,12/2/2016,441,9.33,6.92,4114.53,3051.72,1062.81
Europe,Russia,Fruits,Online,C,7/3/2016,722088277,7/3/2016,822,9.33,6.92,7669.26,5688.24,1981.02
Europe,Slovakia,Cosmetics,Online,H,1/7/2010,386600577,1/29/2010,2557,437.20,263.33,1117920.40,673334.81,444585.59
Australia and Oceania,East Timor,Beverages,Offline,L,12/6/2014,275632226,1/18/2015,4556,47.45,31.79,216182.20,144835.24,71346.96
Central America and the Caribbean,Haiti,Vegetables,Offline,H,10/16/2015,948607051,11/27/2015,2761,154.06,90.93,425359.66,251057.73,174301.93
Middle East and North Africa,Yemen,Cereal,Online,H,5/10/2013,785261380,5/26/2013,5147,205.70,117.11,1058737.90,602765.17,455972.73
Australia and Oceania,Tuvalu,Cereal,Online,C,3/27/2013,935644042,5/15/2013,6719,205.70,117.11,1382098.30,786862.09,595236.21
Sub-Saharan Africa,Liberia,Snacks,Offline,M,7/13/2014,370116364,8/17/2014,4512,152.58,97.44,688440.96,439649.28,248791.68
Asia,North Korea,Beverages,Online,C,8/16/2013,829352176,8/26/2013,2594,47.45,31.79,123085.30,82463.26,40622.04
Asia,North Korea,Household,Online,M,7/14/2015,974337804,8/7/2015,7063,668.27,502.54,4719991.01,3549440.02,1170550.99
Europe,Romania,Household,Online,H,12/23/2014,436372077,1/3/2015,1050,668.27,502.54,701683.50,527667.00,174016.50
Sub-Saharan Africa,Sao Tome and Principe,Cereal,Offline,M,4/27/2015,267066323,5/19/2015,9715,205.70,117.11,1998375.50,1137723.65,860651.85
Middle East and North Africa,Bahrain,Fruits,Online,M,3/14/2017,688344371,4/28/2017,5251,9.33,6.92,48991.83,36336.92,12654.91
Middle East and North Africa,Somalia,Cosmetics,Offline,M,10/2/2014,642442548,11/2/2014,1881,437.20,263.33,822373.20,495323.73,327049.47
Europe,Cyprus,Cereal,Online,C,7/13/2014,941909682,8/1/2014,861,205.70,117.11,177107.70,100831.71,76275.99
Europe,United Kingdom,Beverages,Offline,C,7/31/2016,219607102,8/13/2016,5477,47.45,31.79,259883.65,174113.83,85769.82
Europe,Germany,Personal Care,Offline,H,8/30/2010,778708636,9/2/2010,6045,81.73,56.67,494057.85,342570.15,151487.70
Middle East and North Africa,Somalia,Beverages,Online,M,4/22/2010,942700612,6/6/2010,4915,47.45,31.79,233216.75,156247.85,76968.90
Australia and Oceania,New Zealand,Household,Offline,H,3/9/2011,905381858,4/8/2011,1466,668.27,502.54,979683.82,736723.64,242960.18
Middle East and North Africa,Kuwait,Meat,Online,C,1/13/2010,480863702,1/28/2010,7110,421.89,364.69,2999637.90,2592945.90,406692.00
Asia,Japan,Cosmetics,Online,L,1/6/2016,453569972,2/19/2016,289,437.20,263.33,126350.80,76102.37,50248.43
Europe,Norway,Baby Food,Offline,H,8/17/2016,328236997,9/10/2016,1476,255.28,159.42,376793.28,235303.92,141489.36
Sub-Saharan Africa,Lesotho,Personal Care,Offline,C,10/22/2011,579913604,10/23/2011,8177,81.73,56.67,668306.21,463390.59,204915.62
Europe,Belgium,Cosmetics,Online,H,2/12/2010,403961122,3/20/2010,9928,437.20,263.33,4340521.60,2614340.24,1726181.36
Central America and the Caribbean,Honduras,Cosmetics,Offline,L,5/29/2017,866053378,6/22/2017,3295,437.20,263.33,1440574.00,867672.35,572901.65
Europe,Austria,Household,Offline,C,4/17/2010,852176702,5/13/2010,6878,668.27,502.54,4596361.06,3456470.12,1139890.94
Middle East and North Africa,Oman,Baby Food,Online,M,9/8/2015,218629920,10/20/2015,6307,255.28,159.42,1610050.96,1005461.94,604589.02
Middle East and North Africa,Oman,Baby Food,Offline,C,2/13/2016,242024362,3/17/2016,9242,255.28,159.42,2359297.76,1473359.64,885938.12
Europe,Spain,Snacks,Offline,M,2/16/2014,469283854,2/16/2014,376,152.58,97.44,57370.08,36637.44,20732.64
Middle East and North Africa,Afghanistan,Fruits,Online,C,4/22/2013,967644727,4/30/2013,6433,9.33,6.92,60019.89,44516.36,15503.53
Central America and the Caribbean,Saint Vincent and the Grenadines,Cosmetics,Offline,L,7/15/2014,974655807,7/23/2014,1167,437.20,263.33,510212.40,307306.11,202906.29
Europe,Iceland,Vegetables,Online,M,3/7/2012,248178422,3/22/2012,365,154.06,90.93,56231.90,33189.45,23042.45
Asia,Myanmar,Vegetables,Offline,L,1/14/2013,416386401,2/16/2013,6844,154.06,90.93,1054386.64,622324.92,432061.72
Europe,Netherlands,Snacks,Offline,L,5/22/2017,927766072,6/20/2017,5453,152.58,97.44,832018.74,531340.32,300678.42
Europe,Slovakia,Vegetables,Online,M,3/23/2015,401116263,3/31/2015,8071,154.06,90.93,1243418.26,733896.03,509522.23
Middle East and North Africa,Bahrain,Fruits,Offline,H,9/28/2012,675548303,11/6/2012,8610,9.33,6.92,80331.30,59581.20,20750.10
Sub-Saharan Africa,Lesotho,Baby Food,Online,L,6/6/2013,960486018,7/4/2013,8012,255.28,159.42,2045303.36,1277273.04,768030.32
Central America and the Caribbean,Cuba,Clothes,Offline,L,4/2/2014,985665738,5/19/2014,9250,109.28,35.84,1010840.00,331520.00,679320.00
Middle East and North Africa,Afghanistan,Clothes,Offline,C,1/13/2017,551136291,1/13/2017,2331,109.28,35.84,254731.68,83543.04,171188.64
Australia and Oceania,Vanuatu,Cereal,Online,L,2/3/2017,877259004,2/16/2017,9289,205.70,117.11,1910747.30,1087834.79,822912.51
Asia,Bhutan,Beverages,Offline,M,8/5/2014,554707705,9/19/2014,9192,47.45,31.79,436160.40,292213.68,143946.72
Australia and Oceania,Palau,Cereal,Offline,L,10/6/2010,494468724,10/23/2010,3139,205.70,117.11,645692.30,367608.29,278084.01
Asia,Indonesia,Personal Care,Online,H,9/10/2011,777840888,10/23/2011,9259,81.73,56.67,756738.07,524707.53,232030.54
Europe,Andorra,Baby Food,Offline,C,12/12/2016,206435525,1/27/2017,7714,255.28,159.42,1969229.92,1229765.88,739464.04
Middle East and North Africa,Algeria,Office Supplies,Online,C,10/26/2015,352176463,12/5/2015,5696,651.21,524.96,3709292.16,2990172.16,719120.00
Australia and Oceania,Vanuatu,Cosmetics,Offline,C,10/14/2013,607300031,10/14/2013,2429,437.20,263.33,1061958.80,639628.57,422330.23
North America,Mexico,Baby Food,Online,H,8/17/2013,434355056,9/28/2013,4168,255.28,159.42,1064007.04,664462.56,399544.48
Europe,Macedonia,Fruits,Offline,M,8/7/2011,716202867,9/20/2011,9199,9.33,6.92,85826.67,63657.08,22169.59
Central America and the Caribbean,Panama,Personal Care,Online,H,5/22/2016,606017291,6/12/2016,2838,81.73,56.67,231949.74,160829.46,71120.28
Asia,Nepal,Cereal,Offline,H,1/13/2015,677284657,1/15/2015,2436,205.70,117.11,501085.20,285279.96,215805.24
Asia,Nepal,Fruits,Online,C,7/22/2014,673803794,7/29/2014,2371,9.33,6.92,22121.43,16407.32,5714.11
Sub-Saharan Africa,Mauritius ,Cereal,Offline,C,6/25/2015,859686028,7/10/2015,9055,205.70,117.11,1862613.50,1060431.05,802182.45
Sub-Saharan Africa,Sao Tome and Principe,Clothes,Online,H,8/10/2015,669355189,9/26/2015,5930,109.28,35.84,648030.40,212531.20,435499.20
Central America and the Caribbean,Saint Vincent and the Grenadines,Fruits,Offline,L,10/19/2013,957547605,11/21/2013,8470,9.33,6.92,79025.10,58612.40,20412.70
Asia,Maldives,Personal Care,Online,M,10/9/2013,849312102,11/23/2013,9180,81.73,56.67,750281.40,520230.60,230050.80
Sub-Saharan Africa,Swaziland,Personal Care,Offline,H,9/26/2012,890010011,10/14/2012,2595,81.73,56.67,212089.35,147058.65,65030.70
Middle East and North Africa,Morocco,Cereal,Online,H,10/2/2012,795315158,10/26/2012,284,205.70,117.11,58418.80,33259.24,25159.56
Asia,Maldives,Clothes,Offline,M,12/11/2016,801213872,1/28/2017,5844,109.28,35.84,638632.32,209448.96,429183.36
Sub-Saharan Africa,Zimbabwe,Fruits,Offline,C,7/26/2010,314004981,8/9/2010,9907,9.33,6.92,92432.31,68556.44,23875.87
Asia,India,Cereal,Online,C,3/27/2010,160299813,4/6/2010,5132,205.70,117.11,1055652.40,601008.52,454643.88
Asia,Tajikistan,Beverages,Offline,C,9/11/2014,337022197,9/22/2014,1212,47.45,31.79,57509.40,38529.48,18979.92
Sub-Saharan Africa,Lesotho,Snacks,Offline,M,3/9/2016,461408460,3/15/2016,9872,152.58,97.44,1506269.76,961927.68,544342.08
Asia,Bhutan,Office Supplies,Offline,M,10/19/2011,221007430,11/10/2011,9865,651.21,524.96,6424186.65,5178730.40,1245456.25
Central America and the Caribbean,Trinidad and Tobago,Snacks,Offline,L,10/31/2014,723680436,12/20/2014,1978,152.58,97.44,301803.24,192736.32,109066.92
Australia and Oceania,Tuvalu,Fruits,Offline,L,2/23/2013,447601306,3/11/2013,4028,9.33,6.92,37581.24,27873.76,9707.48
Middle East and North Africa,Iraq,Clothes,Offline,L,10/25/2010,191256368,11/9/2010,5864,109.28,35.84,640817.92,210165.76,430652.16
Sub-Saharan Africa,The Gambia,Vegetables,Offline,L,10/4/2016,823444449,10/30/2016,4366,154.06,90.93,672625.96,397000.38,275625.58
Middle East and North Africa,Bahrain,Beverages,Online,C,9/4/2010,133276879,10/17/2010,8445,47.45,31.79,400715.25,268466.55,132248.70
Middle East and North Africa,Qatar,Meat,Online,H,12/22/2014,480177485,2/7/2015,4043,421.89,364.69,1705701.27,1474441.67,231259.60
Sub-Saharan Africa,Angola,Household,Offline,H,4/8/2015,243882596,5/11/2015,9135,668.27,502.54,6104646.45,4590702.90,1513943.55
Central America and the Caribbean,Costa Rica,Cosmetics,Online,L,3/2/2017,574441039,4/6/2017,8724,437.20,263.33,3814132.80,2297290.92,1516841.88
Australia and Oceania,Papua New Guinea,Household,Online,M,3/14/2012,442214143,5/3/2012,9847,668.27,502.54,6580454.69,4948511.38,1631943.31
Middle East and North Africa,Qatar,Clothes,Offline,C,11/22/2011,687875735,12/2/2011,6571,109.28,35.84,718078.88,235504.64,482574.24
Central America and the Caribbean,Saint Kitts and Nevis ,Clothes,Offline,H,9/8/2013,872412145,9/25/2013,4995,109.28,35.84,545853.60,179020.80,366832.80
Sub-Saharan Africa,Sierra Leone,Fruits,Offline,C,4/23/2012,627122199,4/29/2012,8250,9.33,6.92,76972.50,57090.00,19882.50
Europe,Russia,Fruits,Online,M,2/14/2011,103617227,3/12/2011,1495,9.33,6.92,13948.35,10345.40,3602.95
Europe,Lithuania,Vegetables,Offline,M,10/6/2010,423821055,10/22/2010,6923,154.06,90.93,1066557.38,629508.39,437048.99
Europe,United Kingdom,Vegetables,Online,L,12/8/2012,529970014,1/3/2013,8759,154.06,90.93,1349411.54,796455.87,552955.67
Asia,Indonesia,Personal Care,Offline,H,8/17/2016,334612929,10/3/2016,8256,81.73,56.67,674762.88,467867.52,206895.36
Asia,Mongolia,Beverages,Offline,M,4/23/2014,270611131,5/24/2014,8702,47.45,31.79,412909.90,276636.58,136273.32
Middle East and North Africa,Egypt,Office Supplies,Online,C,11/18/2010,841138446,12/8/2010,413,651.21,524.96,268949.73,216808.48,52141.25
Sub-Saharan Africa,Comoros,Household,Online,M,4/22/2012,369681203,5/9/2012,5738,668.27,502.54,3834533.26,2883574.52,950958.74
Europe,Slovenia,Household,Offline,M,4/5/2014,850038230,4/21/2014,4057,668.27,502.54,2711171.39,2038804.78,672366.61
Middle East and North Africa,Lebanon,Beverages,Online,M,6/21/2013,296320855,7/13/2013,6781,47.45,31.79,321758.45,215567.99,106190.46
Australia and Oceania,Australia,Cosmetics,Offline,L,7/13/2011,392952907,8/13/2011,2352,437.20,263.33,1028294.40,619352.16,408942.24
Central America and the Caribbean,Haiti,Snacks,Online,M,2/1/2011,644670712,3/21/2011,1245,152.58,97.44,189962.10,121312.80,68649.30
Central America and the Caribbean,Saint Kitts and Nevis ,Meat,Online,L,1/27/2012,626523101,2/16/2012,963,421.89,364.69,406280.07,351196.47,55083.60
Middle East and North Africa,Syria,Vegetables,Offline,M,6/24/2015,433871400,7/1/2015,1044,154.06,90.93,160838.64,94930.92,65907.72
Asia,Laos,Snacks,Offline,M,1/3/2012,232389438,1/8/2012,8054,152.58,97.44,1228879.32,784781.76,444097.56
Central America and the Caribbean,Saint Kitts and Nevis ,Cereal,Offline,H,2/21/2016,708063542,3/19/2016,592,205.70,117.11,121774.40,69329.12,52445.28
Sub-Saharan Africa,Sudan,Vegetables,Offline,H,12/4/2016,817192542,12/22/2016,4288,154.06,90.93,660609.28,389907.84,270701.44
Central America and the Caribbean,Guatemala,Meat,Offline,H,1/16/2012,936387765,2/29/2012,6803,421.89,364.69,2870117.67,2480986.07,389131.60
Asia,Brunei,Clothes,Offline,H,8/6/2011,612573039,8/9/2011,2830,109.28,35.84,309262.40,101427.20,207835.20
Middle East and North Africa,Jordan,Clothes,Online,M,8/12/2011,812984693,8/22/2011,9092,109.28,35.84,993573.76,325857.28,667716.48
Central America and the Caribbean,Panama,Meat,Offline,C,12/18/2012,775171554,1/5/2013,9344,421.89,364.69,3942140.16,3407663.36,534476.80
Sub-Saharan Africa,Central African Republic,Household,Online,H,1/10/2010,256994950,2/19/2010,9372,668.27,502.54,6263026.44,4709804.88,1553221.56
Middle East and North Africa,Bahrain,Beverages,Offline,M,2/28/2017,886628711,3/31/2017,1993,47.45,31.79,94567.85,63357.47,31210.38
Sub-Saharan Africa,Burundi,Beverages,Online,C,12/8/2011,312559163,12/16/2011,2057,47.45,31.79,97604.65,65392.03,32212.62
Europe,Austria,Cereal,Online,L,8/18/2014,753585135,9/13/2014,1443,205.70,117.11,296825.10,168989.73,127835.37
Australia and Oceania,Fiji,Beverages,Offline,H,4/19/2016,448817956,4/22/2016,4062,47.45,31.79,192741.90,129130.98,63610.92
Australia and Oceania,Fiji,Clothes,Offline,M,11/6/2012,407681453,12/24/2012,856,109.28,35.84,93543.68,30679.04,62864.64
Europe,Switzerland,Snacks,Online,H,5/27/2016,359911954,6/23/2016,4800,152.58,97.44,732384.00,467712.00,264672.00
Middle East and North Africa,Yemen,Office Supplies,Offline,M,8/18/2013,105558288,8/19/2013,5898,651.21,524.96,3840836.58,3096214.08,744622.50
Sub-Saharan Africa,Comoros,Personal Care,Offline,H,12/31/2014,864981782,2/11/2015,6186,81.73,56.67,505581.78,350560.62,155021.16
Sub-Saharan Africa,Democratic Republic of the Congo,Office Supplies,Online,C,2/4/2013,328856265,2/12/2013,4732,651.21,524.96,3081525.72,2484110.72,597415.00
Asia,Mongolia,Clothes,Offline,H,9/23/2016,308168065,10/18/2016,2633,109.28,35.84,287734.24,94366.72,193367.52
Australia and Oceania,Palau,Household,Offline,L,11/1/2016,884216010,11/2/2016,8021,668.27,502.54,5360193.67,4030873.34,1329320.33
Europe,Monaco,Snacks,Offline,M,12/27/2012,858611428,1/9/2013,1057,152.58,97.44,161277.06,102994.08,58282.98
Australia and Oceania,Fiji,Cereal,Online,L,3/10/2017,903278148,4/3/2017,8932,205.70,117.11,1837312.40,1046026.52,791285.88
Sub-Saharan Africa,Mali,Beverages,Online,L,3/17/2012,410452497,3/26/2012,870,47.45,31.79,41281.50,27657.30,13624.20
Sub-Saharan Africa,Liberia,Cereal,Offline,H,12/17/2015,642683303,1/20/2016,3126,205.70,117.11,643018.20,366085.86,276932.34
Europe,Switzerland,Beverages,Offline,L,2/18/2017,682831895,3/16/2017,3987,47.45,31.79,189183.15,126746.73,62436.42
Australia and Oceania,Samoa ,Baby Food,Online,L,11/5/2016,584072101,11/5/2016,8769,255.28,159.42,2238550.32,1397953.98,840596.34
Asia,Nepal,Meat,Offline,C,4/9/2017,919890248,5/18/2017,4821,421.89,364.69,2033931.69,1758170.49,275761.20
Middle East and North Africa,Azerbaijan,Snacks,Offline,C,4/18/2010,534085166,4/25/2010,6524,152.58,97.44,995431.92,635698.56,359733.36
Europe,Georgia,Baby Food,Offline,H,8/1/2011,590768182,9/7/2011,288,255.28,159.42,73520.64,45912.96,27607.68
Middle East and North Africa,United Arab Emirates,Vegetables,Online,C,5/12/2011,524363124,6/28/2011,9556,154.06,90.93,1472197.36,868927.08,603270.28
Europe,Finland,Household,Offline,L,1/25/2016,289606320,2/14/2016,9801,668.27,502.54,6549714.27,4925394.54,1624319.73
Europe,Portugal,Cereal,Offline,C,4/10/2014,811546599,5/8/2014,3528,205.70,117.11,725709.60,413164.08,312545.52`,
  input: '使用折线图展示'
};

export const gmvData = {
  csv: `top10热门城市列表,对应GMV(元),对应核销金额(元),GMV同比增长率
上海市,1200000000,700000000,1.7
北京市,470000000,250000000,2
成都市,350000000,160000000,2
海口市,320000000,180000000,21.2
郑州市,300000000,140000000,2.2
广州市,280000000,130000000,1.6
杭州市,260000000,240000000,2
武汉市,220000000,110000000,1.3
深圳市,220000000,110000000,1.9
西安市,200000000,180000000,2.9`,
  input: '帮我绘制按城市的gmv和增长率，使用双轴图'
};

export const bubbleCirclePackingData = {
  csv: `industry,gross product
第一产业,88345.1
第二产业,483164.5
第三产业,638697.6
农林牧渔业,92582.4
工业,401644.3
建筑业,83383.1
批发和零售业,114517.7
交通运输、仓储和邮政业,49673.7
住宿和餐饮业,17855.3
金融业,96811.0
房地产业,73821.3
其他,279918.4
`,
  input: '请使用气泡圈图帮我绘制'
};

export const mapChartData = {
  csv: `name,value
Russia,17234034
Canada,9984670
China,9596960
United States of America,9525067
Brazil,8515167
`,
  input: '请将数据渲染到地图图表中'
};

export const rangeColumnChartData = {
  csv: `categories,min,max
Category One,76,100
Category Two,56,108
Category Three,38,129
Category Four,58,155
Category Five,45,120
Category Six,23,99
Category Seven,18,56
Category Eight,18,34
`,
  input: '请使用区间柱图渲染数据'
};

export const sunburstChartData = {
  csv: `Category0,Category1,Category2,Value
Country A,Region1,Office Supplies,824
Country A,Region1,Furniture,920
Country A,Region1,Electronic equipment,936
Country A,Region2,Office Supplies,1270
Country A,Region2,Furniture,1399
Country A,Region2,Electronic equipment,1466
Country A,Region3,Office Supplies,1408
Country A,Region3,Furniture,1676
Country A,Region3,Electronic equipment,1559
Country A,Region4,Office Supplies,745
Country A,Region4,Furniture,919
Country A,Region4,Electronic equipment,781
Country A,Region5,Office Supplies,267
Country A,Region5,Furniture,316
Country A,Region5,Electronic equipment,230
Country A,Region6,Office Supplies,347
Country A,Region6,Furniture,501
Country A,Region6,Electronic equipment,453
Country B,Region1,Office Supplies,824
Country B,Region1,Furniture,920
Country B,Region1,Electronic equipment,936
Country B,Region2,Office Supplies,1270
Country B,Region2,Furniture,1399
Country B,Region2,Electronic equipment,1466
Country B,Region3,Office Supplies,1408
Country B,Region3,Furniture,1676
Country B,Region3,Electronic equipment,1559
Country B,Region4,Office Supplies,745
Country B,Region4,Furniture,919
Country B,Region4,Electronic equipment,781
Country B,Region5,Office Supplies,267
Country B,Region5,Furniture,316
Country B,Region5,Electronic equipment,230
Country B,Region6,Office Supplies,347
Country B,Region6,Furniture,501
Country B,Region6,Electronic equipment,453
Country C,Region1,Office Supplies,824
Country C,Region1,Furniture,920
Country C,Region1,Electronic equipment,936
Country C,Region2,Office Supplies,1270
Country C,Region2,Furniture,1399
Country C,Region2,Electronic equipment,1466
Country C,Region3,Office Supplies,1408
Country C,Region3,Furniture,1676
Country C,Region3,Electronic equipment,1559
Country C,Region4,Office Supplies,745
Country C,Region4,Furniture,919
Country C,Region4,Electronic equipment,781
Country C,Region5,Office Supplies,267
Country C,Region5,Furniture,316
Country C,Region5,Electronic equipment,230
Country C,Region6,Office Supplies,347
Country C,Region6,Furniture,501
Country C,Region6,Electronic equipment,453
`,
  input: '请使用旭日图来渲染数据'
};

export const treemapChartData = {
  csv: `Category-0,Category-1,Category-2,Category-3,value
query,methods,add,,593
query,methods,and,,330
query,methods,average,,287
query,methods,count,,277
query,methods,distinct,,292
query,methods,div,,595
query,methods,eq,,594
query,methods,fn,,460
query,methods,gt,,603
query,methods,gte,,625
query,methods,iff,,748
query,methods,isa,,461
query,methods,lt,,597
query,methods,lte,,619
query,methods,max,,283
query,methods,min,,283
query,methods,mod,,591
query,methods,mul,,603
query,methods,neq,,599
query,methods,not,,386
query,methods,or,,323
query,methods,orderby,,307
query,methods,range,,772
query,methods,select,,296
query,methods,stddev,,363
query,methods,sub,,600
query,methods,sum,,280
query,methods,update,,307
query,methods,variance,,335
query,methods,where,,299
query,methods,xor,,354
query,methods,_,,264
query,AggregateExpression,,,1616
query,And,,,1027
query,Arithmetic,,,3891
query,Average,,,891
query,BinaryExpression,,,2893
query,Comparison,,,5103
query,CompositeExpression,,,3677
query,Count,,,781
query,DateUtil,,,4141
query,Distinct,,,933
query,Expression,,,5130
query,ExpressionIterator,,,3617
query,Fn,,,3240
query,If,,,2732
query,IsA,,,2039
query,Literal,,,1214
query,Match,,,3748
query,Maximum,,,843
query,Minimum,,,843
query,Not,,,1554
query,Or,,,970
query,Query,,,13896
query,Range,,,1594
query,StringUtil,,,4130
query,Sum,,,791
query,Variable,,,1124
query,Variance,,,1876
query,Xor,,,1101
util,palette,ColorPalette,,6367
util,palette,Palette,,1229
util,palette,ShapePalette,,2059
util,palette,valuePalette,,2291
util,math,DenseMatrix,,3165
util,math,IMatrix,,2815
util,math,SparseMatrix,,3366
util,heap,FibonacciHeap,,9354
util,heap,HeapNode,,1233
util,Arrays,,,8258
util,Colors,,,10001
util,Dates,,,8217
util,Displays,,,12555
util,Filter,,,2324
util,Geometry,,,10993
util,IEvaluable,,,335
util,IPredicate,,,383
util,IValueProxy,,,874
util,Maths,,,17705
util,Orientation,,,1486
util,Property,,,5559
util,Shapes,,,19118
util,Sort,,,6887
util,Stats,,,6557
util,Strings,,,22026
animate,interpolate,ArrayInterpolator,,1983
animate,interpolate,ColorInterpolator,,2047
animate,interpolate,DateInterpolator,,1375
animate,interpolate,Interpolator,,8746
animate,interpolate,MatrixInterpolator,,2202
animate,interpolate,NumberInterpolator,,1382
animate,interpolate,ObjectInterpolator,,1629
animate,interpolate,PointInterpolator,,1675
animate,interpolate,RectangleInterpolator,,2042
animate,Easing,,,17010
animate,FunctionSequence,,,5842
animate,ISchedulable,,,1041
animate,Parallel,,,5176
animate,Pause,,,449
animate,Scheduler,,,5593
animate,Sequence,,,5534
animate,Transition,,,9201
animate,Transitioner,,,19975
animate,TransitionEvent,,,1116
animate,Tween,,,6006
scale,IScaleMap,,,2105
scale,LinearScale,,,1316
scale,LogScale,,,3151
scale,OrdinalScale,,,3770
scale,QuantileScale,,,2435
scale,QuantitativeScale,,,4839
scale,RootScale,,,1756
scale,Scale,,,4268
scale,ScaleType,,,1821
scale,TimeScale,,,5833
physics,DragForce,,,1082
physics,GravityForce,,,1336
physics,IForce,,,319
physics,NBodyForce,,,10498
physics,Particle,,,2822
physics,Simulation,,,9983
physics,Spring,,,2213
physics,SpringForce,,,1681
data,converters,Converters,,721
data,converters,DelimitedTextConverter,,4294
data,converters,GraphMLConverter,,9800
data,converters,IDataConverter,,1314
data,converters,JSONConverter,,2220
data,DataField,,,1759
data,DataSchema,,,2165
data,DataSet,,,586
data,DataSource,,,3331
data,DataTable,,,772
data,DataUtil,,,3322
vis,controls,AnchorControl,,2138
vis,controls,ClickControl,,3824
vis,controls,Control,,1353
vis,controls,ControlList,,4665
vis,controls,DragControl,,2649
vis,controls,ExpandControl,,2832
vis,controls,HoverControl,,4896
vis,controls,IControl,,763
vis,controls,PanZoomControl,,5222
vis,controls,SelectionControl,,7862
vis,controls,TooltipControl,,8435
vis,operator,layout,AxisLayout,6725
vis,operator,layout,BundledEdgeRouter,3727
vis,operator,layout,CircleLayout,9317
vis,operator,layout,CirclePackingLayout,12003
vis,operator,layout,DendrogramLayout,4853
vis,operator,layout,ForceDirectedLayout,8411
vis,operator,layout,IcicleTreeLayout,4864
vis,operator,layout,IndentedTreeLayout,3174
vis,operator,layout,Layout,7881
vis,operator,layout,NodeLinkTreeLayout,12870
vis,operator,layout,PieLayout,2728
vis,operator,layout,RadialTreeLayout,12348
vis,operator,layout,RandomLayout,870
vis,operator,layout,StackedAreaLayout,9121
vis,operator,layout,TreeMapLayout,9191
vis,operator,encoder,ColorEncoder,3179
vis,operator,encoder,Encoder,4060
vis,operator,encoder,PropertyEncoder,4138
vis,operator,encoder,ShapeEncoder,1690
vis,operator,encoder,valueEncoder,1830
vis,operator,distortion,BifocalDistortion,4461
vis,operator,distortion,Distortion,6314
vis,operator,distortion,FisheyeDistortion,3444
vis,operator,filter,FisheyeTreeFilter,5219
vis,operator,filter,GraphDistanceFilter,3165
vis,operator,filter,VisibilityFilter,3509
vis,operator,label,Labeler,9956
vis,operator,label,RadialLabeler,3899
vis,operator,label,StackedAreaLabeler,3202
vis,operator,IOperator,,1286
vis,operator,Operator,,2490
vis,operator,OperatorList,,5248
vis,operator,OperatorSequence,,4190
vis,operator,OperatorSwitch,,2581
vis,operator,SortOperator,,2023
vis,data,render,ArrowType,698
vis,data,render,EdgeRenderer,5569
vis,data,render,IRenderer,353
vis,data,render,ShapeRenderer,2247
vis,data,Data,,20544
vis,data,DataList,,19788
vis,data,DataSprite,,10349
vis,data,EdgeSprite,,3301
vis,data,NodeSprite,,19382
vis,data,ScaleBinding,,11275
vis,data,Tree,,7147
vis,data,TreeBuilder,,9930
vis,axis,Axes,,1302
vis,axis,Axis,,24593
vis,axis,AxisGridLine,,652
vis,axis,AxisLabel,,636
vis,axis,CartesianAxes,,6703
vis,events,DataEvent,,2313
vis,events,SelectionEvent,,1880
vis,events,TooltipEvent,,1701
vis,events,VisualizationEvent,,1117
vis,legend,Legend,,20859
vis,legend,LegendItem,,4614
vis,legend,LegendRange,,10530
vis,Visualization,,,16540
display,DirtySprite,,,8833
display,LineSprite,,,1732
display,RectSprite,,,3623
display,TextSprite,,,10066
analytics,graph,BetweennessCentrality,,3534
analytics,graph,LinkDistance,,5731
analytics,graph,MaxFlowMinCut,,7840
analytics,graph,ShortestPaths,,5914
analytics,graph,SpanningTree,,3416
analytics,cluster,AgglomerativeCluster,,3938
analytics,cluster,CommunityStructure,,3812
analytics,cluster,HierarchicalCluster,,6714
analytics,cluster,MergeEdge,,743
analytics,optimization,AspectRatioBanker,,7074
flex,FlareVis,,,4116`,
  input: '请使用矩形树图渲染数据的层次结构'
};

export const gaugeChartData = {
  csv: `name,value,description
 目标A,0.6,目标A的描述`,
  input: '请使用仪表盘来完成数据渲染'
};

export const linearProgressChartData = {
  csv: `type,value,text
Tradition Industries,0.795,79.5%
Business Companies,0.25,25%
Customer-facing Companies,0.065,6.5%`,
  input: '请使用线形进度图来完成数据渲染'
};

export const basicHeatMapChartData = {
  csv: `Financial Ratio Indicator,Comparison Metric,Correlation Coefficient
Asset Liability Ratio,Asset Liability Ratio,1
Asset Liability Ratio,Asset Liability Ratio (Deducting Advance Payments),0.594527
Asset Liability Ratio,Debt-to-long Capital Ratio,0.492963
Asset Liability Ratio,Long Term Asset Suitability Ratio,-0.160995
Asset Liability Ratio,Equity Multiplier,0.723664
Asset Liability Ratio,Equity Ratio of Current Liability,0.658646
Asset Liability Ratio,Interest Bearing Debt / Fully Invested Capital,-0.857474
Asset Liability Ratio,Current Liability / Total Liabilities,0.320706
Asset Liability Ratio,Capital Fixation Ratio,-0.284634
Asset Liability Ratio,Expected Default Frequency,-0.091423
Asset Liability Ratio (Deducting Advance Payments),Asset Liability Ratio,0.594527
Asset Liability Ratio (Deducting Advance Payments),Asset Liability Ratio (Deducting Advance Payments),1
Asset Liability Ratio (Deducting Advance Payments),Debt-to-long Capital Ratio,0.724546
Asset Liability Ratio (Deducting Advance Payments),Long Term Asset Suitability Ratio,-0.099318
Asset Liability Ratio (Deducting Advance Payments),Equity Multiplier,0.540639
Asset Liability Ratio (Deducting Advance Payments),Equity Ratio of Current Liability,0.49214
Asset Liability Ratio (Deducting Advance Payments),Interest Bearing Debt / Fully Invested Capital,-0.554039
Asset Liability Ratio (Deducting Advance Payments),Current Liability / Total Liabilities,0.17127
Asset Liability Ratio (Deducting Advance Payments),Capital Fixation Ratio,-0.265259
Asset Liability Ratio (Deducting Advance Payments),Expected Default Frequency,0.068577
Debt-to-long Capital Ratio,Asset Liability Ratio,0.492963
Debt-to-long Capital Ratio,Asset Liability Ratio (Deducting Advance Payments),0.724546
Debt-to-long Capital Ratio,Debt-to-long Capital Ratio,1
Debt-to-long Capital Ratio,Long Term Asset Suitability Ratio,-0.091338
Debt-to-long Capital Ratio,Equity Multiplier,0.450542
Debt-to-long Capital Ratio,Equity Ratio of Current Liability,0.375839
Debt-to-long Capital Ratio,Interest Bearing Debt / Fully Invested Capital,-0.524955
Debt-to-long Capital Ratio,Current Liability / Total Liabilities,0.300627
Debt-to-long Capital Ratio,Capital Fixation Ratio,-0.198362
Debt-to-long Capital Ratio,Expected Default Frequency,0.033209
Long Term Asset Suitability Ratio,Asset Liability Ratio,-0.160995
Long Term Asset Suitability Ratio,Asset Liability Ratio (Deducting Advance Payments),-0.099318
Long Term Asset Suitability Ratio,Debt-to-long Capital Ratio,-0.091338
Long Term Asset Suitability Ratio,Long Term Asset Suitability Ratio,1
Long Term Asset Suitability Ratio,Equity Multiplier,-0.049872
Long Term Asset Suitability Ratio,Equity Ratio of Current Liability,-0.028452
Long Term Asset Suitability Ratio,Interest Bearing Debt / Fully Invested Capital,0.157157
Long Term Asset Suitability Ratio,Current Liability / Total Liabilities,0.009742
Long Term Asset Suitability Ratio,Capital Fixation Ratio,-0.162374
Long Term Asset Suitability Ratio,Expected Default Frequency,0.155095
Equity Multiplier,Asset Liability Ratio,0.723664
Equity Multiplier,Asset Liability Ratio (Deducting Advance Payments),0.540639
Equity Multiplier,Debt-to-long Capital Ratio,0.450542
Equity Multiplier,Long Term Asset Suitability Ratio,-0.049872
Equity Multiplier,Equity Multiplier,1
Equity Multiplier,Equity Ratio of Current Liability,0.951933
Equity Multiplier,Interest Bearing Debt / Fully Invested Capital,-0.651767
Equity Multiplier,Current Liability / Total Liabilities,0.079052
Equity Multiplier,Capital Fixation Ratio,-0.535984
Equity Multiplier,Expected Default Frequency,0.00798
Equity Ratio of Current Liability,Asset Liability Ratio,0.658646
Equity Ratio of Current Liability,Asset Liability Ratio (Deducting Advance Payments),0.49214
Equity Ratio of Current Liability,Debt-to-long Capital Ratio,0.375839
Equity Ratio of Current Liability,Long Term Asset Suitability Ratio,-0.028452
Equity Ratio of Current Liability,Equity Multiplier,0.951933
Equity Ratio of Current Liability,Equity Ratio of Current Liability,1
Equity Ratio of Current Liability,Interest Bearing Debt / Fully Invested Capital,-0.543147
Equity Ratio of Current Liability,Current Liability / Total Liabilities,-0.106139
Equity Ratio of Current Liability,Capital Fixation Ratio,-0.52232
Equity Ratio of Current Liability,Expected Default Frequency,0.011466
Interest Bearing Debt / Fully Invested Capital,Asset Liability Ratio,-0.857474
Interest Bearing Debt / Fully Invested Capital,Asset Liability Ratio (Deducting Advance Payments),-0.554039
Interest Bearing Debt / Fully Invested Capital,Debt-to-long Capital Ratio,-0.524955
Interest Bearing Debt / Fully Invested Capital,Long Term Asset Suitability Ratio,0.157157
Interest Bearing Debt / Fully Invested Capital,Equity Multiplier,-0.651767
Interest Bearing Debt / Fully Invested Capital,Equity Ratio of Current Liability,-0.543147
Interest Bearing Debt / Fully Invested Capital,Interest Bearing Debt / Fully Invested Capital,1
Interest Bearing Debt / Fully Invested Capital,Current Liability / Total Liabilities,-0.595016
Interest Bearing Debt / Fully Invested Capital,Capital Fixation Ratio,0.310521
Interest Bearing Debt / Fully Invested Capital,Expected Default Frequency,0.066397
Current Liability / Total Liabilities,Asset Liability Ratio,0.320706
Current Liability / Total Liabilities,Asset Liability Ratio (Deducting Advance Payments),0.17127
Current Liability / Total Liabilities,Debt-to-long Capital Ratio,0.300627
Current Liability / Total Liabilities,Long Term Asset Suitability Ratio,0.009742
Current Liability / Total Liabilities,Equity Multiplier,0.079052
Current Liability / Total Liabilities,Equity Ratio of Current Liability,-0.106139
Current Liability / Total Liabilities,Interest Bearing Debt / Fully Invested Capital,-0.595016
Current Liability / Total Liabilities,Current Liability / Total Liabilities,1
Current Liability / Total Liabilities,Capital Fixation Ratio,-0.105199
Current Liability / Total Liabilities,Expected Default Frequency,-0.064886
Capital Fixation Ratio,Asset Liability Ratio,-0.284634
Capital Fixation Ratio,Asset Liability Ratio (Deducting Advance Payments),-0.265259
Capital Fixation Ratio,Debt-to-long Capital Ratio,-0.198362
Capital Fixation Ratio,Long Term Asset Suitability Ratio,-0.162374
Capital Fixation Ratio,Equity Multiplier,-0.535984
Capital Fixation Ratio,Equity Ratio of Current Liability,-0.52232
Capital Fixation Ratio,Interest Bearing Debt / Fully Invested Capital,0.310521
Capital Fixation Ratio,Current Liability / Total Liabilities,-0.105199
Capital Fixation Ratio,Capital Fixation Ratio,1
Capital Fixation Ratio,Expected Default Frequency,-0.080153
Expected Default Frequency,Asset Liability Ratio,-0.091423
Expected Default Frequency,Asset Liability Ratio (Deducting Advance Payments),0.068577
Expected Default Frequency,Debt-to-long Capital Ratio,0.033209
Expected Default Frequency,Long Term Asset Suitability Ratio,0.155095
Expected Default Frequency,Equity Multiplier,0.00798
Expected Default Frequency,Equity Ratio of Current Liability,0.011466
Expected Default Frequency,Interest Bearing Debt / Fully Invested Capital,0.066397
Expected Default Frequency,Current Liability / Total Liabilities,-0.064886
Expected Default Frequency,Capital Fixation Ratio,-0.080153
Expected Default Frequency,Expected Default Frequency,1`,
  input: '请使用热图帮我展示各财务比率指标的相关系数'
};

export const vennChartData = {
  csv: `sets,name,value
0,A,8
1,D,8
2,B,10
3,C,12
4,A,4
4,B,4
5,A,4
5,C,4
6,B,4
6,C,4
7,A,2
7,B,2
7,C,2`,
  input: '帮我展示各元素集合重叠区域，以及分布情况。请使用数据中的sets字段来划分不同集合。'
};

export const singleColumnLineCombinationChartData = {
  csv: `date,Social Penetration,Engagement - Socialization,Penetration of Private Messages,Number of Private Messages per User
2022-03-08,1.2020804451630671,0.7782279444864411,0.21493020207806002,0.26002007727513005
2022-03-09,1.911162758594358,0.6970763116149991,0.31807068769079905,1.791161354352144
2022-03-10,0.919293523406533,0.6754510401577041,0.9774597853017851,1.410289280738493
2022-03-11,1.613617931982911,4.391274420824463,0.662196540154462,2.374084690062705
2022-03-12,1.121445896148114,0.5827973501093221,1.547704220622789,0.42545370377775604
2022-03-13,0.527369749651032,0.321443063009525,0.52384329811226,0.45119753243186805
2022-03-14,0.07991167814791,0.9838146243033221,1.242674929077965,1.276345431333586
2022-03-15,0.29341332300751205,0.225492098355163,1.133076821811672,0.22045142924559902
2022-03-16,1.103150404211427,0.580792120371675,1.261446251860683,0.061775812702848
2022-03-17,0.38285701953593604,0.510579334822959,0.908573021920086,0.429194248082692
2022-03-18,0.8908005339482421,1.656998380732747,2.003638269088651,1.194511111230195
2022-03-19,0.8379933951719881,1.372238730132033,1.285574252451237,0.659056833995271
2022-03-20,2.913059895355856,3.375041306488803,1.683935730207101,0.40361011204949004
2022-03-21,1.245523794769467,0.5770535812918991,0.518960506573594,0.8441533797310441
2022-03-22,1.801955367373218,2.562767955961243,2.076490748024919,1.8682050366367142
2022-03-23,30.25170429439274,60.10096481599735,31.918470633985613,70.34237647545662
2022-03-24,2.084831170978463,2.824195229461953,1.735738814795219,3.854924132202267
2022-03-25,0.8300684679922911,0.37108301055861304,1.072942910906809,0.868965201778456
2022-03-26,5.057522939533747,6.8131452572139555,10.31725741409195,0.6724835487477681
2022-03-27,1.364245041731511,0.993289299105189,1.288157916081268,1.290710012048575
2022-03-28,0.429699282814745,0.27225365805664004,0.24488975421611903,0.944202324553962
2022-03-29,8.636960050981939,2.663368864789215,3.030888929145336,2.191548298261417
2022-03-30,0.31233481070398905,1.136502929086737,1.4304534277803231,0.9398051933719991
2022-03-31,0.8979576483673781,0.8268293005130081,1.32475784490384,0.212383798504713
2022-04-01,1.187326287404249,1.2824253532703072,0.9289553576582981,1.328758303758777
2022-04-02,0.013251966153457001,1.580091614771022,0.8470948142995741,1.061518688804395
2022-04-03,0.150440921215681,0.7793382242254321,0.5908683646183901,1.021428732507816
2022-04-04,1.437865757864698,0.34207119701235905,1.006103497118929,0.8496566144677861
2022-04-05,19.70534531285437,4.144335050792541,13.880860231019398,19.78289952089912
2022-04-06,1.068708512330189,1.336025709304907,7.121018094960213,0.032847589287524
2022-04-07,3.239083103313066,0.9037359185383671,2.010136943230478,2.758258304057329
2022-04-08,3.609669038457516,13.698767079174356,14.457401852798982,11.6964360828172
2022-04-09,0.8581543303200471,1.11771091972957,0.9593788300193951,1.121066838670219
2022-04-10,1.235338424517758,0.5546236200208831,1.138776207683746,0.5694312841615821
2022-04-11,0.615560300356359,0.133505664394376,0.575680679073131,0.502679162912634
2022-04-12,3.5445165395901572,8.458105165611851,2.90160000840929,3.084080663501847
2022-04-13,1.037776502324676,1.412321112593621,1.416876192652653,0.270647644667579
2022-04-14,0.534866532613768,0.577163861285873,0.034172330313952004,0.268470350264293
2022-04-15,3.225952049483959,5.112791338669762,3.745099757241069,2.612195295941399
2022-04-16,12.278592894400722,13.301401633991011,6.202762040985617,18.098567324029407
2022-04-17,0.411460847135642,0.8194099242420241,0.6882380919620981,0.645388563624089
2022-04-18,0.304818623987116,0.601409275693432,0.07904084882979401,0.16144847919011002
2022-04-19,0.8929797309154061,0.932019259560644,0.013117573233606001,0.36918835535862005
2022-04-20,4.074891060179412,3.6166710941152713,3.143179675624189,5.283666616893828
2022-04-21,0.902423656543305,2.682237126638688,0.6180860661837431,1.631115014312209
2022-04-22,0.868968791964932,0.329339479566271,0.001536382167654,0.807551152019862
2022-04-23,0.598986391584271,0.923756524041317,0.27081187550692803,0.22998130489182
2022-04-24,0.27570721725353503,0.6601580208066361,0.7774852739576821,1.107108162852159
2022-04-25,0.38518667923696703,2.037027697748363,0.859959904015784,0.641738277028276
2022-04-26,0.622049495688147,0.803863499657206,0.22244045641286703,1.320954321806144
2022-04-27,3.540727101774814,0.651469202290988,0.509144429951741,0.20073460039620403
2022-04-28,2.742513433824975,2.6893975459595643,0.13894846116144902,0.7415989059349031
2022-04-29,1.621566806821747,0.9147556633717211,0.19686640023465302,1.66475441380813
2022-04-30,2.352493741253538,3.463127996997362,2.931184732430775,1.792534569741266
2022-05-01,0.023487873849160002,0.5573480476128151,0.544054544143018,0.35016352980012605
2022-05-02,9.85187760463177,35.95040240058573,10.530894431942714,4.323328789531124
2022-05-03,6.3835439206943,5.577920982650984,4.483541728043783,3.7796731596206943
2022-05-04,2.897597920598689,5.106082630695584,8.400221891051206,8.018922971992662
2022-05-05,0.147546385656207,0.040771286126692,0.6862921980279431,0.44745062012103404
2022-05-06,4.668438202775402,0.23681078820699203,4.557825514906153,3.46073691075845
2022-05-07,1.868897716467347,1.727448921279463,0.527497153125138,0.120868915583745
2022-05-08,1.356875902669512,1.434740383567053,1.25226701190186,0.42909048781311704
2022-05-09,1.029882775112869,0.9377192673786531,0.643077700672811,0.539461571476962
2022-05-10,1.079419585437788,0.5840348488590831,0.031193331319320002,0.341612265371036
2022-05-11,0.43374835866466704,0.01643698693241,0.39325414355653304,0.918926460102595
2022-05-12,0.6884004244125861,1.538028843999251,0.863652647240271,1.249717355592488
2022-05-13,0.5513219132650721,1.063801968030616,0.65309749602536,1.244646630025216
2022-05-14,0.26075436773203503,0.16980099784180802,0.502507081730036,0.026734770744615003
2022-05-15,3.534068370760441,2.144086432206532,1.989727381483406,1.510725845099207
2022-05-16,1.051684273070894,1.152664833294427,0.747391405264186,0.283792059973869
2022-05-17,0.8574030868970931,0.8751363341872681,0.901758308356248,0.41795473321335
2022-05-18,0.515497463894879,0.8615187586650901,0.43634054682577406,1.895212820019219
2022-05-19,0.9592457438221671,0.126354125202296,2.8539304550226543,0.77105240170235
2022-05-20,0.069882250377393,0.7098481312166951,0.5071020864029481,2.543277547025898
2022-05-21,10.360352568974609,17.706030110118455,2.848137759152337,1.260088014509166
2022-05-22,1.112796751785197,0.9176470910577301,0.43003615544265306,0.910155627802492
2022-05-23,4.891916669440483,16.47452431770853,2.744192036280677,1.124249996351633
2022-05-24,0.09534096170855301,0.7854768368577231,0.6263662592501831,0.19409864063613502
2022-05-25,17.21160548866725,34.373177238596014,7.564216276703391,17.06769270843336
2022-05-26,0.9890377076819251,0.789535076533531,0.8798790088553111,0.592040366427117
2022-05-27,1.207578684423282,0.5312851260232421,1.055373428020675,0.84736634769268
2022-05-28,15.265265813052475,12.028735185645875,14.171624745847268,35.787490090751945
2022-05-29,1.667919015486645,1.439873268216485,1.078931580631559,0.9907508552960291
2022-05-30,2.232083847244808,3.827653889831506,1.429842282923971,3.76351508114206
2022-05-31,1.113011174076138,1.4295696272440521,1.141933003322777,1.22202135537901
2022-06-01,0.9839213173080511,1.325995589464272,2.006909504383298,1.7803529363753632
2022-06-02,3.618368394111176,0.627748977148721,1.176985400742372,1.267728131617331
2022-06-03,1.5240830060491182,0.83151391784571,1.356692075891955,3.227340286052029
2022-06-04,0.7108355579615261,0.011530713721830002,0.52485737802621,0.661668615725415
2022-06-05,1.842738679408876,1.130871471288951,1.189107233207374,3.246025623322408
2022-06-06,2.968986726243696,2.9958102236757282,0.47619309340284505,1.3335764819663671
2022-06-07,0.30957106038382504,0.44026116440941004,0.42982954277120905,1.741430660250139
2022-06-08,3.077870353397237,4.156128784010092,1.021512025143279,4.351094223144934
2022-06-09,0.460474051903736,1.2828566287818242,0.22198861960947303,0.085629074470341
2022-06-10,0.9248894668614721,0.23152297348937,0.18500236928827601,0.5925681882904861
2022-06-11,0.5170229174882011,1.344093064443273,0.6923204827335401,1.013151233597585
2022-06-12,1.343310704782682,0.42108731154009404,1.547163500435265,0.999128791000602
2022-06-13,4.213284444567541,2.448703044357372,0.13900479867391702,1.556248326348268
2022-06-14,0.718083714760927,1.912454128957958,0.24702549770442003,2.037101388253879
2022-06-15,2.443370806389791,0.010368540480550002,0.133167401519793,2.42241572339565
2022-06-16,3.594231845735735,0.6677966564200211,4.009094569074379,5.5253640045926335
2022-06-17,1.113951398490715,0.11111864432229301,0.9730098334869651,0.9908309309721931
2022-06-18,0.5614439322266921,0.806546956486733,0.32013564834811403,0.8486918887953661
2022-06-19,1.243458727745012,1.135192118212662,5.021267051723119,4.233329079605447
2022-06-20,1.31005897849395,1.045144309632654,4.014478741193049,2.239616259510069
2022-06-21,0.572744269459053,1.076475248295982,0.7240389412682761,0.10908279405984601
2022-06-22,24.581669047338767,24.02021682920061,37.05462241129788,23.51884099646193
2022-06-23,0.47413969565051606,0.027051327125384002,0.16824850993617801,0.41568301223291604
2022-06-24,0.43416765009011604,2.878601660092219,1.9317197675603461,1.840590020030168
2022-06-25,0.943163264857342,0.019465090936308,0.285177476177572,0.5532414004550751
2022-06-26,0.233205152479134,1.2557471231721191,1.260075716991639,2.715172232506665
2022-06-27,3.9663605369632933,0.5849212901405391,3.452510757244162,2.679757899115613
2022-06-28,0.016605232459512002,0.280224773927022,0.729523367081325,1.105137522496868
2022-06-29,1.374134760412724,0.751739223993092,0.7538963415227941,1.347929408272255
2022-06-30,0.715486103147415,0.555444809676618,0.08646395240381301,0.5491110504617991
2022-07-01,0.747532331413809,1.043273887199711,0.49779032149353303,0.885618995495125
2022-07-02,0.8670766655477491,1.8724388596735242,0.391981409036455,1.040394051716164
2022-07-03,0.392542368674532,1.204834846410795,1.103562611606201,0.387838034146796
2022-07-04,2.354765436840968,0.147183599628016,1.798064276315111,0.33504623462675404
2022-07-05,0.25059554847566,0.259954349350673,0.407469349519874,3.278091213717644
2022-07-06,4.720665637767317,2.071271452074246,4.502139668053687,5.134166854414464
2022-07-07,0.646476205877439,0.186466306558064,0.499133613586184,0.15787863433545202
2022-07-08,4.428354777598469,7.997827905255312,5.845195208267132,3.695856221993309
2022-07-09,1.502467804494858,0.33362085354833704,1.26505092951483,0.9204718402028381
2022-07-10,11.706734521216822,36.550441521853145,19.095991246701065,12.292686689327372
2022-07-11,1.153083534578196,0.337559642243531,1.154651513638781,0.22569823789057203
2022-07-12,1.4863362021332551,0.48307852351030106,1.5365158530965122,0.057003071478754004
2022-07-13,1.61896686341972,0.9387594299650791,1.092431878065284,1.886305858547745
2022-07-14,49.60818750100216,22.940238837323303,13.579325095732914,38.67416013838181
2022-07-15,1.785205883890873,0.631304013521069,0.62869350368483,0.34417591219448
2022-07-16,0.715594243310775,0.984028805544615,0.967817534607272,0.153576028704162
2022-07-17,0.8147430610328651,0.26284189122074103,2.154865858339681,1.283391109459497
2022-07-18,1.24545618431753,1.082826448671828,0.45266260254768803,0.084950117524903
2022-07-19,0.083915091025848,0.5880718113215341,1.007179376918947,0.865719136965563
2022-07-20,0.32701962372413,0.17041520446782002,1.773905435681336,1.104677623595627
2022-07-21,0.722041044814348,0.822598941600809,0.9593067917284711,0.41221237294221
2022-07-22,10.662811760936936,0.183634003906628,13.34157103707886,12.159275730149757
2022-07-23,0.364677770561312,0.559247300094862,0.40653075149155804,0.9694788164354201
2022-07-24,0.9157754804402811,1.091835974661574,0.8199135063617131,1.062993342271482
2022-07-25,0.67849525511577,3.048531280160542,1.471231045142114,0.591416124923933
2022-07-26,1.330066578741473,1.582638082613582,1.789945856913414,2.192979954983851
2022-07-27,5.686664774275858,6.436173309221049,4.7854634352690155,1.63427958962943
2022-07-28,0.22324041916141402,1.428578028660132,1.458686942176205,1.311736714260567
2022-07-29,2.476037411183793,0.7249411790805861,0.42039676295059203,2.995565219170837
2022-07-30,0.773637653847835,0.9265499876312321,0.32494629315872703,0.324341917122049
2022-07-31,0.169152723468269,0.9014047551998651,0.46982772647431204,0.5534444716525361
2022-08-01,1.519627178758216,1.610068186750942,3.309159861747862,0.529330910775445
2022-08-02,3.545652606242915,2.330031081649702,3.9640154638953513,3.856552869039815
2022-08-03,1.3404062798488199,0.462815961543229,0.9670138622828691,1.234951845374218
2022-08-04,0.6530263834012761,0.08597037675761801,0.9707805498085981,0.16192153323070702
2022-08-05,0.708729075421144,3.581243043200601,2.651870015387795,2.173110201699371
2022-08-06,11.986631123295103,10.930286916614767,22.78182877052594,11.135752238663327
2022-08-07,1.232939713701664,1.8029857915415932,1.476317514220094,0.958792084262276
2022-08-08,0.530813431405317,2.014631665755229,2.7977280500624433,2.039075329513739
2022-08-09,2.510188659097596,2.983415297830412,0.126105493389976,2.121594836643942
2022-08-10,1.622456744339298,1.289582374551249,2.5475660513369442,3.282862603860423
2022-08-11,0.25962103068208003,0.37516694909806303,0.5828588359439041,0.139231895746797
2022-08-12,0.884113805589634,1.603259620438238,1.8751590471743,0.24122279792940302
2022-08-13,8.624685230360152,3.3791466219930433,9.375119750363103,0.7506624109540441
2022-08-14,1.6498217904306332,2.627126072551769,0.57102589263998,2.4024472876658223
2022-08-15,5.840124155766275,3.354483317899366,1.075590808840468,2.3650336028113492
2022-08-16,2.405030143824614,1.444879535922397,0.942851527789979,1.423465983705226
2022-08-17,1.034391306438299,0.6369673400603011,0.473080126014195,0.8585472144660361
2022-08-18,4.703412413763946,0.5990722583580821,0.911179769434693,1.189643421133775
2022-08-19,0.22138733877979702,0.24079634787311602,0.045592515857608006,0.9837464357223601
2022-08-20,0.14621922149563202,0.096627004274573,0.7910843611370051,0.059870034265504
2022-08-21,5.702011116768989,11.782408392531364,4.022381962144387,12.55656527594101
2022-08-22,2.289251748782675,1.846139752930779,1.302218066447416,1.195140815195466
2022-08-23,0.40156922050687605,2.44670175499675,2.701336009126233,2.5846045653914143
2022-08-24,16.368686321533847,9.285256494681935,14.17816605948454,6.813674272547164
2022-08-25,17.325634435909638,40.63547963350666,52.36627420733006,22.12581500864155
2022-08-26,2.771994472181008,1.432898057334553,0.500652317272802,0.29065103217099203
2022-08-27,2.705080627435551,1.140228551443707,2.535947091285437,2.068004826572326
2022-08-28,0.366184071525715,0.37561791103581305,1.087399555743408,1.3431857507096732
2022-08-29,0.192969279119436,1.203078886727172,0.8966719923838661,1.07779591413233
2022-08-30,0.248116517168076,0.901524977902984,0.9660257636136701,0.13247782324235202
2022-08-31,0.7172605174280461,0.22721632248943202,0.9247009404760361,0.28572976740870504
2022-09-01,0.259653267575217,2.040817156148029,2.19857288799284,2.229208371156883
2022-09-02,1.398428414171018,0.071469482611002,0.9048807067534731,0.0022491420541680004
2022-09-03,1.7166677805176591,1.903668070163285,1.866568462888393,1.8648831840830011`,
  input: '请使用四个独立的折线的组合图展示不同类别的权重随着时间的变化'
};

export const singleColumnLineCombinationChartData1 = {
  csv: `date,Social Penetration,Engagement - Socialization,Penetration of Private Messages,Number of Private Messages per User
2022-03-08,1.2020804451630671,0.7782279444864411,0.21493020207806002,0.26002007727513005
2022-03-09,1.911162758594358,0.6970763116149991,0.31807068769079905,1.791161354352144
2022-03-10,0.919293523406533,0.6754510401577041,0.9774597853017851,1.410289280738493
2022-03-11,1.613617931982911,4.391274420824463,0.662196540154462,2.374084690062705
2022-03-12,1.121445896148114,0.5827973501093221,1.547704220622789,0.42545370377775604
2022-03-13,0.527369749651032,0.321443063009525,0.52384329811226,0.45119753243186805
2022-03-14,0.07991167814791,0.9838146243033221,1.242674929077965,1.276345431333586
2022-03-15,0.29341332300751205,0.225492098355163,1.133076821811672,0.22045142924559902
2022-03-16,1.103150404211427,0.580792120371675,1.261446251860683,0.061775812702848
2022-03-17,0.38285701953593604,0.510579334822959,0.908573021920086,0.429194248082692
2022-03-18,0.8908005339482421,1.656998380732747,2.003638269088651,1.194511111230195
2022-03-19,0.8379933951719881,1.372238730132033,1.285574252451237,0.659056833995271
2022-03-20,2.913059895355856,3.375041306488803,1.683935730207101,0.40361011204949004
2022-03-21,1.245523794769467,0.5770535812918991,0.518960506573594,0.8441533797310441
2022-03-22,1.801955367373218,2.562767955961243,2.076490748024919,1.8682050366367142
2022-03-23,30.25170429439274,60.10096481599735,31.918470633985613,70.34237647545662
2022-03-24,2.084831170978463,2.824195229461953,1.735738814795219,3.854924132202267
2022-03-25,0.8300684679922911,0.37108301055861304,1.072942910906809,0.868965201778456
2022-03-26,5.057522939533747,6.8131452572139555,10.31725741409195,0.6724835487477681
2022-03-27,1.364245041731511,0.993289299105189,1.288157916081268,1.290710012048575
2022-03-28,0.429699282814745,0.27225365805664004,0.24488975421611903,0.944202324553962
2022-03-29,8.636960050981939,2.663368864789215,3.030888929145336,2.191548298261417
2022-03-30,0.31233481070398905,1.136502929086737,1.4304534277803231,0.9398051933719991
2022-03-31,0.8979576483673781,0.8268293005130081,1.32475784490384,0.212383798504713
2022-04-01,1.187326287404249,1.2824253532703072,0.9289553576582981,1.328758303758777
2022-04-02,0.013251966153457001,1.580091614771022,0.8470948142995741,1.061518688804395
2022-04-03,0.150440921215681,0.7793382242254321,0.5908683646183901,1.021428732507816
2022-04-04,1.437865757864698,0.34207119701235905,1.006103497118929,0.8496566144677861
2022-04-05,19.70534531285437,4.144335050792541,13.880860231019398,19.78289952089912
2022-04-06,1.068708512330189,1.336025709304907,7.121018094960213,0.032847589287524
2022-04-07,3.239083103313066,0.9037359185383671,2.010136943230478,2.758258304057329
2022-04-08,3.609669038457516,13.698767079174356,14.457401852798982,11.6964360828172
2022-04-09,0.8581543303200471,1.11771091972957,0.9593788300193951,1.121066838670219
2022-04-10,1.235338424517758,0.5546236200208831,1.138776207683746,0.5694312841615821
2022-04-11,0.615560300356359,0.133505664394376,0.575680679073131,0.502679162912634
2022-04-12,3.5445165395901572,8.458105165611851,2.90160000840929,3.084080663501847
2022-04-13,1.037776502324676,1.412321112593621,1.416876192652653,0.270647644667579
2022-04-14,0.534866532613768,0.577163861285873,0.034172330313952004,0.268470350264293
2022-04-15,3.225952049483959,5.112791338669762,3.745099757241069,2.612195295941399
2022-04-16,12.278592894400722,13.301401633991011,6.202762040985617,18.098567324029407
2022-04-17,0.411460847135642,0.8194099242420241,0.6882380919620981,0.645388563624089
2022-04-18,0.304818623987116,0.601409275693432,0.07904084882979401,0.16144847919011002
2022-04-19,0.8929797309154061,0.932019259560644,0.013117573233606001,0.36918835535862005
2022-04-20,4.074891060179412,3.6166710941152713,3.143179675624189,5.283666616893828
2022-04-21,0.902423656543305,2.682237126638688,0.6180860661837431,1.631115014312209
2022-04-22,0.868968791964932,0.329339479566271,0.001536382167654,0.807551152019862
2022-04-23,0.598986391584271,0.923756524041317,0.27081187550692803,0.22998130489182
2022-04-24,0.27570721725353503,0.6601580208066361,0.7774852739576821,1.107108162852159
2022-04-25,0.38518667923696703,2.037027697748363,0.859959904015784,0.641738277028276
2022-04-26,0.622049495688147,0.803863499657206,0.22244045641286703,1.320954321806144
2022-04-27,3.540727101774814,0.651469202290988,0.509144429951741,0.20073460039620403
2022-04-28,2.742513433824975,2.6893975459595643,0.13894846116144902,0.7415989059349031
2022-04-29,1.621566806821747,0.9147556633717211,0.19686640023465302,1.66475441380813
2022-04-30,2.352493741253538,3.463127996997362,2.931184732430775,1.792534569741266
2022-05-01,0.023487873849160002,0.5573480476128151,0.544054544143018,0.35016352980012605
2022-05-02,9.85187760463177,35.95040240058573,10.530894431942714,4.323328789531124
2022-05-03,6.3835439206943,5.577920982650984,4.483541728043783,3.7796731596206943
2022-05-04,2.897597920598689,5.106082630695584,8.400221891051206,8.018922971992662
2022-05-05,0.147546385656207,0.040771286126692,0.6862921980279431,0.44745062012103404
2022-05-06,4.668438202775402,0.23681078820699203,4.557825514906153,3.46073691075845
2022-05-07,1.868897716467347,1.727448921279463,0.527497153125138,0.120868915583745
2022-05-08,1.356875902669512,1.434740383567053,1.25226701190186,0.42909048781311704
2022-05-09,1.029882775112869,0.9377192673786531,0.643077700672811,0.539461571476962
2022-05-10,1.079419585437788,0.5840348488590831,0.031193331319320002,0.341612265371036
2022-05-11,0.43374835866466704,0.01643698693241,0.39325414355653304,0.918926460102595
2022-05-12,0.6884004244125861,1.538028843999251,0.863652647240271,1.249717355592488
2022-05-13,0.5513219132650721,1.063801968030616,0.65309749602536,1.244646630025216
2022-05-14,0.26075436773203503,0.16980099784180802,0.502507081730036,0.026734770744615003
2022-05-15,3.534068370760441,2.144086432206532,1.989727381483406,1.510725845099207
2022-05-16,1.051684273070894,1.152664833294427,0.747391405264186,0.283792059973869
2022-05-17,0.8574030868970931,0.8751363341872681,0.901758308356248,0.41795473321335
2022-05-18,0.515497463894879,0.8615187586650901,0.43634054682577406,1.895212820019219
2022-05-19,0.9592457438221671,0.126354125202296,2.8539304550226543,0.77105240170235
2022-05-20,0.069882250377393,0.7098481312166951,0.5071020864029481,2.543277547025898
2022-05-21,10.360352568974609,17.706030110118455,2.848137759152337,1.260088014509166
2022-05-22,1.112796751785197,0.9176470910577301,0.43003615544265306,0.910155627802492
2022-05-23,4.891916669440483,16.47452431770853,2.744192036280677,1.124249996351633
2022-05-24,0.09534096170855301,0.7854768368577231,0.6263662592501831,0.19409864063613502
2022-05-25,17.21160548866725,34.373177238596014,7.564216276703391,17.06769270843336
2022-05-26,0.9890377076819251,0.789535076533531,0.8798790088553111,0.592040366427117
2022-05-27,1.207578684423282,0.5312851260232421,1.055373428020675,0.84736634769268
2022-05-28,15.265265813052475,12.028735185645875,14.171624745847268,35.787490090751945
2022-05-29,1.667919015486645,1.439873268216485,1.078931580631559,0.9907508552960291
2022-05-30,2.232083847244808,3.827653889831506,1.429842282923971,3.76351508114206
2022-05-31,1.113011174076138,1.4295696272440521,1.141933003322777,1.22202135537901
2022-06-01,0.9839213173080511,1.325995589464272,2.006909504383298,1.7803529363753632
2022-06-02,3.618368394111176,0.627748977148721,1.176985400742372,1.267728131617331
2022-06-03,1.5240830060491182,0.83151391784571,1.356692075891955,3.227340286052029
2022-06-04,0.7108355579615261,0.011530713721830002,0.52485737802621,0.661668615725415
2022-06-05,1.842738679408876,1.130871471288951,1.189107233207374,3.246025623322408
2022-06-06,2.968986726243696,2.9958102236757282,0.47619309340284505,1.3335764819663671
2022-06-07,0.30957106038382504,0.44026116440941004,0.42982954277120905,1.741430660250139
2022-06-08,3.077870353397237,4.156128784010092,1.021512025143279,4.351094223144934
2022-06-09,0.460474051903736,1.2828566287818242,0.22198861960947303,0.085629074470341
2022-06-10,0.9248894668614721,0.23152297348937,0.18500236928827601,0.5925681882904861
2022-06-11,0.5170229174882011,1.344093064443273,0.6923204827335401,1.013151233597585
2022-06-12,1.343310704782682,0.42108731154009404,1.547163500435265,0.999128791000602
2022-06-13,4.213284444567541,2.448703044357372,0.13900479867391702,1.556248326348268
2022-06-14,0.718083714760927,1.912454128957958,0.24702549770442003,2.037101388253879
2022-06-15,2.443370806389791,0.010368540480550002,0.133167401519793,2.42241572339565
2022-06-16,3.594231845735735,0.6677966564200211,4.009094569074379,5.5253640045926335
2022-06-17,1.113951398490715,0.11111864432229301,0.9730098334869651,0.9908309309721931
2022-06-18,0.5614439322266921,0.806546956486733,0.32013564834811403,0.8486918887953661
2022-06-19,1.243458727745012,1.135192118212662,5.021267051723119,4.233329079605447
2022-06-20,1.31005897849395,1.045144309632654,4.014478741193049,2.239616259510069
2022-06-21,0.572744269459053,1.076475248295982,0.7240389412682761,0.10908279405984601
2022-06-22,24.581669047338767,24.02021682920061,37.05462241129788,23.51884099646193
2022-06-23,0.47413969565051606,0.027051327125384002,0.16824850993617801,0.41568301223291604
2022-06-24,0.43416765009011604,2.878601660092219,1.9317197675603461,1.840590020030168
2022-06-25,0.943163264857342,0.019465090936308,0.285177476177572,0.5532414004550751
2022-06-26,0.233205152479134,1.2557471231721191,1.260075716991639,2.715172232506665
2022-06-27,3.9663605369632933,0.5849212901405391,3.452510757244162,2.679757899115613
2022-06-28,0.016605232459512002,0.280224773927022,0.729523367081325,1.105137522496868
2022-06-29,1.374134760412724,0.751739223993092,0.7538963415227941,1.347929408272255
2022-06-30,0.715486103147415,0.555444809676618,0.08646395240381301,0.5491110504617991
2022-07-01,0.747532331413809,1.043273887199711,0.49779032149353303,0.885618995495125
2022-07-02,0.8670766655477491,1.8724388596735242,0.391981409036455,1.040394051716164
2022-07-03,0.392542368674532,1.204834846410795,1.103562611606201,0.387838034146796
2022-07-04,2.354765436840968,0.147183599628016,1.798064276315111,0.33504623462675404
2022-07-05,0.25059554847566,0.259954349350673,0.407469349519874,3.278091213717644
2022-07-06,4.720665637767317,2.071271452074246,4.502139668053687,5.134166854414464
2022-07-07,0.646476205877439,0.186466306558064,0.499133613586184,0.15787863433545202
2022-07-08,4.428354777598469,7.997827905255312,5.845195208267132,3.695856221993309
2022-07-09,1.502467804494858,0.33362085354833704,1.26505092951483,0.9204718402028381
2022-07-10,11.706734521216822,36.550441521853145,19.095991246701065,12.292686689327372
2022-07-11,1.153083534578196,0.337559642243531,1.154651513638781,0.22569823789057203
2022-07-12,1.4863362021332551,0.48307852351030106,1.5365158530965122,0.057003071478754004
2022-07-13,1.61896686341972,0.9387594299650791,1.092431878065284,1.886305858547745
2022-07-14,49.60818750100216,22.940238837323303,13.579325095732914,38.67416013838181
2022-07-15,1.785205883890873,0.631304013521069,0.62869350368483,0.34417591219448
2022-07-16,0.715594243310775,0.984028805544615,0.967817534607272,0.153576028704162
2022-07-17,0.8147430610328651,0.26284189122074103,2.154865858339681,1.283391109459497
2022-07-18,1.24545618431753,1.082826448671828,0.45266260254768803,0.084950117524903
2022-07-19,0.083915091025848,0.5880718113215341,1.007179376918947,0.865719136965563
2022-07-20,0.32701962372413,0.17041520446782002,1.773905435681336,1.104677623595627
2022-07-21,0.722041044814348,0.822598941600809,0.9593067917284711,0.41221237294221
2022-07-22,10.662811760936936,0.183634003906628,13.34157103707886,12.159275730149757
2022-07-23,0.364677770561312,0.559247300094862,0.40653075149155804,0.9694788164354201
2022-07-24,0.9157754804402811,1.091835974661574,0.8199135063617131,1.062993342271482
2022-07-25,0.67849525511577,3.048531280160542,1.471231045142114,0.591416124923933
2022-07-26,1.330066578741473,1.582638082613582,1.789945856913414,2.192979954983851
2022-07-27,5.686664774275858,6.436173309221049,4.7854634352690155,1.63427958962943
2022-07-28,0.22324041916141402,1.428578028660132,1.458686942176205,1.311736714260567
2022-07-29,2.476037411183793,0.7249411790805861,0.42039676295059203,2.995565219170837
2022-07-30,0.773637653847835,0.9265499876312321,0.32494629315872703,0.324341917122049
2022-07-31,0.169152723468269,0.9014047551998651,0.46982772647431204,0.5534444716525361
2022-08-01,1.519627178758216,1.610068186750942,3.309159861747862,0.529330910775445
2022-08-02,3.545652606242915,2.330031081649702,3.9640154638953513,3.856552869039815
2022-08-03,1.3404062798488199,0.462815961543229,0.9670138622828691,1.234951845374218
2022-08-04,0.6530263834012761,0.08597037675761801,0.9707805498085981,0.16192153323070702
2022-08-05,0.708729075421144,3.581243043200601,2.651870015387795,2.173110201699371
2022-08-06,11.986631123295103,10.930286916614767,22.78182877052594,11.135752238663327
2022-08-07,1.232939713701664,1.8029857915415932,1.476317514220094,0.958792084262276
2022-08-08,0.530813431405317,2.014631665755229,2.7977280500624433,2.039075329513739
2022-08-09,2.510188659097596,2.983415297830412,0.126105493389976,2.121594836643942
2022-08-10,1.622456744339298,1.289582374551249,2.5475660513369442,3.282862603860423
2022-08-11,0.25962103068208003,0.37516694909806303,0.5828588359439041,0.139231895746797
2022-08-12,0.884113805589634,1.603259620438238,1.8751590471743,0.24122279792940302
2022-08-13,8.624685230360152,3.3791466219930433,9.375119750363103,0.7506624109540441
2022-08-14,1.6498217904306332,2.627126072551769,0.57102589263998,2.4024472876658223
2022-08-15,5.840124155766275,3.354483317899366,1.075590808840468,2.3650336028113492
2022-08-16,2.405030143824614,1.444879535922397,0.942851527789979,1.423465983705226
2022-08-17,1.034391306438299,0.6369673400603011,0.473080126014195,0.8585472144660361
2022-08-18,4.703412413763946,0.5990722583580821,0.911179769434693,1.189643421133775
2022-08-19,0.22138733877979702,0.24079634787311602,0.045592515857608006,0.9837464357223601
2022-08-20,0.14621922149563202,0.096627004274573,0.7910843611370051,0.059870034265504
2022-08-21,5.702011116768989,11.782408392531364,4.022381962144387,12.55656527594101
2022-08-22,2.289251748782675,1.846139752930779,1.302218066447416,1.195140815195466
2022-08-23,0.40156922050687605,2.44670175499675,2.701336009126233,2.5846045653914143
2022-08-24,16.368686321533847,9.285256494681935,14.17816605948454,6.813674272547164
2022-08-25,17.325634435909638,40.63547963350666,52.36627420733006,22.12581500864155
2022-08-26,2.771994472181008,1.432898057334553,0.500652317272802,0.29065103217099203
2022-08-27,2.705080627435551,1.140228551443707,2.535947091285437,2.068004826572326
2022-08-28,0.366184071525715,0.37561791103581305,1.087399555743408,1.3431857507096732
2022-08-29,0.192969279119436,1.203078886727172,0.8966719923838661,1.07779591413233
2022-08-30,0.248116517168076,0.901524977902984,0.9660257636136701,0.13247782324235202
2022-08-31,0.7172605174280461,0.22721632248943202,0.9247009404760361,0.28572976740870504
2022-09-01,0.259653267575217,2.040817156148029,2.19857288799284,2.229208371156883
2022-09-02,1.398428414171018,0.071469482611002,0.9048807067534731,0.0022491420541680004
2022-09-03,1.7166677805176591,1.903668070163285,1.866568462888393,1.8648831840830011`,
  input:
    '请使用组合图分别展示Social Penetration和Engagement - Socialization类别的权重随着时间的变化，以及Penetration of Private Messages和Number of Private Messages per User类别的权重随着时间的变化'
};

export const singleColumnBarCombinationChartData = {
  csv: `region,可乐销售额,雪碧销售额,芬达销售额,醒目销售额
south,2350,215,345,1476
east,1027,654,654,830
west,1027,159,2100,532
north,1027,28,1679,498
`,
  input: '帮我使用四个不同柱图的组合展示四个区域上不同商品销售额'
};

export const singleColumnBarCombinationChartData1 = {
  csv: `date,Social Penetration,Engagement - Socialization,Penetration of Private Messages,Number of Private Messages per User
2022-03-08,1.2020804451630671,0.7782279444864411,0.21493020207806002,0.26002007727513005
2022-03-09,1.911162758594358,0.6970763116149991,0.31807068769079905,1.791161354352144
2022-03-10,0.919293523406533,0.6754510401577041,0.9774597853017851,1.410289280738493
2022-03-11,1.613617931982911,4.391274420824463,0.662196540154462,2.374084690062705
2022-03-12,1.121445896148114,0.5827973501093221,1.547704220622789,0.42545370377775604
2022-03-13,0.527369749651032,0.321443063009525,0.52384329811226,0.45119753243186805
2022-03-14,0.07991167814791,0.9838146243033221,1.242674929077965,1.276345431333586
2022-03-15,0.29341332300751205,0.225492098355163,1.133076821811672,0.22045142924559902
2022-03-16,1.103150404211427,0.580792120371675,1.261446251860683,0.061775812702848
2022-03-17,0.38285701953593604,0.510579334822959,0.908573021920086,0.429194248082692
2022-03-18,0.8908005339482421,1.656998380732747,2.003638269088651,1.194511111230195
2022-03-19,0.8379933951719881,1.372238730132033,1.285574252451237,0.659056833995271
2022-03-20,2.913059895355856,3.375041306488803,1.683935730207101,0.40361011204949004
2022-03-21,1.245523794769467,0.5770535812918991,0.518960506573594,0.8441533797310441
2022-03-22,1.801955367373218,2.562767955961243,2.076490748024919,1.8682050366367142
2022-03-23,30.25170429439274,60.10096481599735,31.918470633985613,70.34237647545662
2022-03-24,2.084831170978463,2.824195229461953,1.735738814795219,3.854924132202267
2022-03-25,0.8300684679922911,0.37108301055861304,1.072942910906809,0.868965201778456
2022-03-26,5.057522939533747,6.8131452572139555,10.31725741409195,0.6724835487477681
2022-03-27,1.364245041731511,0.993289299105189,1.288157916081268,1.290710012048575
2022-03-28,0.429699282814745,0.27225365805664004,0.24488975421611903,0.944202324553962
2022-03-29,8.636960050981939,2.663368864789215,3.030888929145336,2.191548298261417
2022-03-30,0.31233481070398905,1.136502929086737,1.4304534277803231,0.9398051933719991
2022-03-31,0.8979576483673781,0.8268293005130081,1.32475784490384,0.212383798504713
2022-04-01,1.187326287404249,1.2824253532703072,0.9289553576582981,1.328758303758777
2022-04-02,0.013251966153457001,1.580091614771022,0.8470948142995741,1.061518688804395
2022-04-03,0.150440921215681,0.7793382242254321,0.5908683646183901,1.021428732507816
2022-04-04,1.437865757864698,0.34207119701235905,1.006103497118929,0.8496566144677861
2022-04-05,19.70534531285437,4.144335050792541,13.880860231019398,19.78289952089912
2022-04-06,1.068708512330189,1.336025709304907,7.121018094960213,0.032847589287524
2022-04-07,3.239083103313066,0.9037359185383671,2.010136943230478,2.758258304057329
2022-04-08,3.609669038457516,13.698767079174356,14.457401852798982,11.6964360828172
2022-04-09,0.8581543303200471,1.11771091972957,0.9593788300193951,1.121066838670219
2022-04-10,1.235338424517758,0.5546236200208831,1.138776207683746,0.5694312841615821
2022-04-11,0.615560300356359,0.133505664394376,0.575680679073131,0.502679162912634
2022-04-12,3.5445165395901572,8.458105165611851,2.90160000840929,3.084080663501847
2022-04-13,1.037776502324676,1.412321112593621,1.416876192652653,0.270647644667579
2022-04-14,0.534866532613768,0.577163861285873,0.034172330313952004,0.268470350264293
2022-04-15,3.225952049483959,5.112791338669762,3.745099757241069,2.612195295941399
2022-04-16,12.278592894400722,13.301401633991011,6.202762040985617,18.098567324029407
2022-04-17,0.411460847135642,0.8194099242420241,0.6882380919620981,0.645388563624089
2022-04-18,0.304818623987116,0.601409275693432,0.07904084882979401,0.16144847919011002
2022-04-19,0.8929797309154061,0.932019259560644,0.013117573233606001,0.36918835535862005
2022-04-20,4.074891060179412,3.6166710941152713,3.143179675624189,5.283666616893828
2022-04-21,0.902423656543305,2.682237126638688,0.6180860661837431,1.631115014312209
2022-04-22,0.868968791964932,0.329339479566271,0.001536382167654,0.807551152019862
2022-04-23,0.598986391584271,0.923756524041317,0.27081187550692803,0.22998130489182
2022-04-24,0.27570721725353503,0.6601580208066361,0.7774852739576821,1.107108162852159
2022-04-25,0.38518667923696703,2.037027697748363,0.859959904015784,0.641738277028276
2022-04-26,0.622049495688147,0.803863499657206,0.22244045641286703,1.320954321806144
2022-04-27,3.540727101774814,0.651469202290988,0.509144429951741,0.20073460039620403
2022-04-28,2.742513433824975,2.6893975459595643,0.13894846116144902,0.7415989059349031
2022-04-29,1.621566806821747,0.9147556633717211,0.19686640023465302,1.66475441380813
2022-04-30,2.352493741253538,3.463127996997362,2.931184732430775,1.792534569741266
2022-05-01,0.023487873849160002,0.5573480476128151,0.544054544143018,0.35016352980012605
2022-05-02,9.85187760463177,35.95040240058573,10.530894431942714,4.323328789531124
2022-05-03,6.3835439206943,5.577920982650984,4.483541728043783,3.7796731596206943
2022-05-04,2.897597920598689,5.106082630695584,8.400221891051206,8.018922971992662
2022-05-05,0.147546385656207,0.040771286126692,0.6862921980279431,0.44745062012103404
2022-05-06,4.668438202775402,0.23681078820699203,4.557825514906153,3.46073691075845
2022-05-07,1.868897716467347,1.727448921279463,0.527497153125138,0.120868915583745
2022-05-08,1.356875902669512,1.434740383567053,1.25226701190186,0.42909048781311704
2022-05-09,1.029882775112869,0.9377192673786531,0.643077700672811,0.539461571476962
2022-05-10,1.079419585437788,0.5840348488590831,0.031193331319320002,0.341612265371036
2022-05-11,0.43374835866466704,0.01643698693241,0.39325414355653304,0.918926460102595
2022-05-12,0.6884004244125861,1.538028843999251,0.863652647240271,1.249717355592488
2022-05-13,0.5513219132650721,1.063801968030616,0.65309749602536,1.244646630025216
2022-05-14,0.26075436773203503,0.16980099784180802,0.502507081730036,0.026734770744615003
2022-05-15,3.534068370760441,2.144086432206532,1.989727381483406,1.510725845099207
2022-05-16,1.051684273070894,1.152664833294427,0.747391405264186,0.283792059973869
2022-05-17,0.8574030868970931,0.8751363341872681,0.901758308356248,0.41795473321335
2022-05-18,0.515497463894879,0.8615187586650901,0.43634054682577406,1.895212820019219
2022-05-19,0.9592457438221671,0.126354125202296,2.8539304550226543,0.77105240170235
2022-05-20,0.069882250377393,0.7098481312166951,0.5071020864029481,2.543277547025898
2022-05-21,10.360352568974609,17.706030110118455,2.848137759152337,1.260088014509166
2022-05-22,1.112796751785197,0.9176470910577301,0.43003615544265306,0.910155627802492
2022-05-23,4.891916669440483,16.47452431770853,2.744192036280677,1.124249996351633
2022-05-24,0.09534096170855301,0.7854768368577231,0.6263662592501831,0.19409864063613502
2022-05-25,17.21160548866725,34.373177238596014,7.564216276703391,17.06769270843336
2022-05-26,0.9890377076819251,0.789535076533531,0.8798790088553111,0.592040366427117
2022-05-27,1.207578684423282,0.5312851260232421,1.055373428020675,0.84736634769268
2022-05-28,15.265265813052475,12.028735185645875,14.171624745847268,35.787490090751945
2022-05-29,1.667919015486645,1.439873268216485,1.078931580631559,0.9907508552960291
2022-05-30,2.232083847244808,3.827653889831506,1.429842282923971,3.76351508114206
2022-05-31,1.113011174076138,1.4295696272440521,1.141933003322777,1.22202135537901
2022-06-01,0.9839213173080511,1.325995589464272,2.006909504383298,1.7803529363753632
2022-06-02,3.618368394111176,0.627748977148721,1.176985400742372,1.267728131617331
2022-06-03,1.5240830060491182,0.83151391784571,1.356692075891955,3.227340286052029
2022-06-04,0.7108355579615261,0.011530713721830002,0.52485737802621,0.661668615725415
2022-06-05,1.842738679408876,1.130871471288951,1.189107233207374,3.246025623322408
2022-06-06,2.968986726243696,2.9958102236757282,0.47619309340284505,1.3335764819663671
2022-06-07,0.30957106038382504,0.44026116440941004,0.42982954277120905,1.741430660250139
2022-06-08,3.077870353397237,4.156128784010092,1.021512025143279,4.351094223144934
2022-06-09,0.460474051903736,1.2828566287818242,0.22198861960947303,0.085629074470341
2022-06-10,0.9248894668614721,0.23152297348937,0.18500236928827601,0.5925681882904861
2022-06-11,0.5170229174882011,1.344093064443273,0.6923204827335401,1.013151233597585
2022-06-12,1.343310704782682,0.42108731154009404,1.547163500435265,0.999128791000602
2022-06-13,4.213284444567541,2.448703044357372,0.13900479867391702,1.556248326348268
2022-06-14,0.718083714760927,1.912454128957958,0.24702549770442003,2.037101388253879
2022-06-15,2.443370806389791,0.010368540480550002,0.133167401519793,2.42241572339565
2022-06-16,3.594231845735735,0.6677966564200211,4.009094569074379,5.5253640045926335
2022-06-17,1.113951398490715,0.11111864432229301,0.9730098334869651,0.9908309309721931
2022-06-18,0.5614439322266921,0.806546956486733,0.32013564834811403,0.8486918887953661
2022-06-19,1.243458727745012,1.135192118212662,5.021267051723119,4.233329079605447
2022-06-20,1.31005897849395,1.045144309632654,4.014478741193049,2.239616259510069
2022-06-21,0.572744269459053,1.076475248295982,0.7240389412682761,0.10908279405984601
2022-06-22,24.581669047338767,24.02021682920061,37.05462241129788,23.51884099646193
2022-06-23,0.47413969565051606,0.027051327125384002,0.16824850993617801,0.41568301223291604
2022-06-24,0.43416765009011604,2.878601660092219,1.9317197675603461,1.840590020030168
2022-06-25,0.943163264857342,0.019465090936308,0.285177476177572,0.5532414004550751
2022-06-26,0.233205152479134,1.2557471231721191,1.260075716991639,2.715172232506665
2022-06-27,3.9663605369632933,0.5849212901405391,3.452510757244162,2.679757899115613
2022-06-28,0.016605232459512002,0.280224773927022,0.729523367081325,1.105137522496868
2022-06-29,1.374134760412724,0.751739223993092,0.7538963415227941,1.347929408272255
2022-06-30,0.715486103147415,0.555444809676618,0.08646395240381301,0.5491110504617991
2022-07-01,0.747532331413809,1.043273887199711,0.49779032149353303,0.885618995495125
2022-07-02,0.8670766655477491,1.8724388596735242,0.391981409036455,1.040394051716164
2022-07-03,0.392542368674532,1.204834846410795,1.103562611606201,0.387838034146796
2022-07-04,2.354765436840968,0.147183599628016,1.798064276315111,0.33504623462675404
2022-07-05,0.25059554847566,0.259954349350673,0.407469349519874,3.278091213717644
2022-07-06,4.720665637767317,2.071271452074246,4.502139668053687,5.134166854414464
2022-07-07,0.646476205877439,0.186466306558064,0.499133613586184,0.15787863433545202
2022-07-08,4.428354777598469,7.997827905255312,5.845195208267132,3.695856221993309
2022-07-09,1.502467804494858,0.33362085354833704,1.26505092951483,0.9204718402028381
2022-07-10,11.706734521216822,36.550441521853145,19.095991246701065,12.292686689327372
2022-07-11,1.153083534578196,0.337559642243531,1.154651513638781,0.22569823789057203
2022-07-12,1.4863362021332551,0.48307852351030106,1.5365158530965122,0.057003071478754004
2022-07-13,1.61896686341972,0.9387594299650791,1.092431878065284,1.886305858547745
2022-07-14,49.60818750100216,22.940238837323303,13.579325095732914,38.67416013838181
2022-07-15,1.785205883890873,0.631304013521069,0.62869350368483,0.34417591219448
2022-07-16,0.715594243310775,0.984028805544615,0.967817534607272,0.153576028704162
2022-07-17,0.8147430610328651,0.26284189122074103,2.154865858339681,1.283391109459497
2022-07-18,1.24545618431753,1.082826448671828,0.45266260254768803,0.084950117524903
2022-07-19,0.083915091025848,0.5880718113215341,1.007179376918947,0.865719136965563
2022-07-20,0.32701962372413,0.17041520446782002,1.773905435681336,1.104677623595627
2022-07-21,0.722041044814348,0.822598941600809,0.9593067917284711,0.41221237294221
2022-07-22,10.662811760936936,0.183634003906628,13.34157103707886,12.159275730149757
2022-07-23,0.364677770561312,0.559247300094862,0.40653075149155804,0.9694788164354201
2022-07-24,0.9157754804402811,1.091835974661574,0.8199135063617131,1.062993342271482
2022-07-25,0.67849525511577,3.048531280160542,1.471231045142114,0.591416124923933
2022-07-26,1.330066578741473,1.582638082613582,1.789945856913414,2.192979954983851
2022-07-27,5.686664774275858,6.436173309221049,4.7854634352690155,1.63427958962943
2022-07-28,0.22324041916141402,1.428578028660132,1.458686942176205,1.311736714260567
2022-07-29,2.476037411183793,0.7249411790805861,0.42039676295059203,2.995565219170837
2022-07-30,0.773637653847835,0.9265499876312321,0.32494629315872703,0.324341917122049
2022-07-31,0.169152723468269,0.9014047551998651,0.46982772647431204,0.5534444716525361
2022-08-01,1.519627178758216,1.610068186750942,3.309159861747862,0.529330910775445
2022-08-02,3.545652606242915,2.330031081649702,3.9640154638953513,3.856552869039815
2022-08-03,1.3404062798488199,0.462815961543229,0.9670138622828691,1.234951845374218
2022-08-04,0.6530263834012761,0.08597037675761801,0.9707805498085981,0.16192153323070702
2022-08-05,0.708729075421144,3.581243043200601,2.651870015387795,2.173110201699371
2022-08-06,11.986631123295103,10.930286916614767,22.78182877052594,11.135752238663327
2022-08-07,1.232939713701664,1.8029857915415932,1.476317514220094,0.958792084262276
2022-08-08,0.530813431405317,2.014631665755229,2.7977280500624433,2.039075329513739
2022-08-09,2.510188659097596,2.983415297830412,0.126105493389976,2.121594836643942
2022-08-10,1.622456744339298,1.289582374551249,2.5475660513369442,3.282862603860423
2022-08-11,0.25962103068208003,0.37516694909806303,0.5828588359439041,0.139231895746797
2022-08-12,0.884113805589634,1.603259620438238,1.8751590471743,0.24122279792940302
2022-08-13,8.624685230360152,3.3791466219930433,9.375119750363103,0.7506624109540441
2022-08-14,1.6498217904306332,2.627126072551769,0.57102589263998,2.4024472876658223
2022-08-15,5.840124155766275,3.354483317899366,1.075590808840468,2.3650336028113492
2022-08-16,2.405030143824614,1.444879535922397,0.942851527789979,1.423465983705226
2022-08-17,1.034391306438299,0.6369673400603011,0.473080126014195,0.8585472144660361
2022-08-18,4.703412413763946,0.5990722583580821,0.911179769434693,1.189643421133775
2022-08-19,0.22138733877979702,0.24079634787311602,0.045592515857608006,0.9837464357223601
2022-08-20,0.14621922149563202,0.096627004274573,0.7910843611370051,0.059870034265504
2022-08-21,5.702011116768989,11.782408392531364,4.022381962144387,12.55656527594101
2022-08-22,2.289251748782675,1.846139752930779,1.302218066447416,1.195140815195466
2022-08-23,0.40156922050687605,2.44670175499675,2.701336009126233,2.5846045653914143
2022-08-24,16.368686321533847,9.285256494681935,14.17816605948454,6.813674272547164
2022-08-25,17.325634435909638,40.63547963350666,52.36627420733006,22.12581500864155
2022-08-26,2.771994472181008,1.432898057334553,0.500652317272802,0.29065103217099203
2022-08-27,2.705080627435551,1.140228551443707,2.535947091285437,2.068004826572326
2022-08-28,0.366184071525715,0.37561791103581305,1.087399555743408,1.3431857507096732
2022-08-29,0.192969279119436,1.203078886727172,0.8966719923838661,1.07779591413233
2022-08-30,0.248116517168076,0.901524977902984,0.9660257636136701,0.13247782324235202
2022-08-31,0.7172605174280461,0.22721632248943202,0.9247009404760361,0.28572976740870504
2022-09-01,0.259653267575217,2.040817156148029,2.19857288799284,2.229208371156883
2022-09-02,1.398428414171018,0.071469482611002,0.9048807067534731,0.0022491420541680004
2022-09-03,1.7166677805176591,1.903668070163285,1.866568462888393,1.8648831840830011`,
  input: '请使用四个独立柱图的组合图展示前十天不同类别的权重随着时间的变化。'
};

export const dynamicScatterPlotData = {
  csv: `年度收益率,净现金流,市值,公司,年份
50,28,726,公司0,1950
9,63,301,公司1,1950
41,8,795,公司2,1950
93,92,545,公司3,1950
11,93,798,公司4,1950
50,11,652,公司5,1950
35,96,688,公司6,1950
94,72,795,公司7,1950
4,4,149,公司8,1950
4,93,919,公司9,1950
71,7,976,公司10,1950
75,7,349,公司11,1950
93,89,810,公司12,1950
28,73,602,公司13,1950
11,73,497,公司14,1950
87,73,509,公司15,1950
58,53,256,公司16,1950
56,69,144,公司17,1950
49,45,237,公司18,1950
46,74,387,公司19,1950
92,42,742,公司20,1950
45,64,933,公司21,1950
68,42,284,公司22,1950
9,46,325,公司23,1950
70,6,194,公司24,1950
25,84,552,公司25,1950
82,87,716,公司26,1950
5,64,958,公司27,1950
15,86,593,公司28,1950
44,11,219,公司29,1950
46,75,72,公司30,1950
76,56,530,公司31,1950
14,8,483,公司32,1950
82,30,639,公司33,1950
58,23,876,公司34,1950
0,28,748,公司35,1950
55,25,845,公司36,1950
35,54,185,公司37,1950
60,1,931,公司38,1950
64,30,300,公司39,1950
83,29,510,公司40,1950
5,77,915,公司41,1950
23,61,821,公司42,1950
16,42,22,公司43,1950
50,73,800,公司44,1950
93,71,829,公司45,1950
31,0,293,公司46,1950
17,75,89,公司47,1950
8,25,319,公司48,1950
81,37,851,公司49,1950
51,31,723,公司0,1951
10,65,287,公司1,1951
42,7,813,公司2,1951
92,90,525,公司3,1951
12,96,761,公司4,1951
50,10,681,公司5,1951
37,96,738,公司6,1951
97,73,752,公司7,1951
5,7,189,公司8,1951
7,93,908,公司9,1951
72,9,975,公司10,1951
77,7,309,公司11,1951
94,89,777,公司12,1951
31,76,568,公司13,1951
11,75,523,公司14,1951
86,73,563,公司15,1951
58,52,219,公司16,1951
59,70,176,公司17,1951
51,48,192,公司18,1951
49,76,418,公司19,1951
92,45,747,公司20,1951
48,67,924,公司21,1951
71,41,321,公司22,1951
11,46,304,公司23,1951
73,8,158,公司24,1951
25,86,595,公司25,1951
82,87,673,公司26,1951
5,67,998,公司27,1951
18,89,622,公司28,1951
46,13,247,公司29,1951
45,74,121,公司30,1951
79,58,525,公司31,1951
14,12,439,公司32,1951
84,30,617,公司33,1951
61,23,854,公司34,1951
0,30,765,公司35,1951
58,25,834,公司36,1951
37,53,229,公司37,1951
61,0,955,公司38,1951
63,30,346,公司39,1951
84,29,492,公司40,1951
9,77,916,公司41,1951
25,64,874,公司42,1951
18,43,18,公司43,1951
51,75,755,公司44,1951
94,71,866,公司45,1951
32,0,293,公司46,1951
18,76,111,公司47,1951
7,25,307,公司48,1951
83,36,834,公司49,1951
50,31,710,公司0,1952
13,65,271,公司1,1952
41,10,792,公司2,1952
91,92,552,公司3,1952
10,94,762,公司4,1952
50,13,732,公司5,1952
36,97,782,公司6,1952
98,72,753,公司7,1952
5,6,177,公司8,1952
6,96,924,公司9,1952
72,10,951,公司10,1952
80,5,305,公司11,1952
95,88,827,公司12,1952
34,77,600,公司13,1952
11,75,568,公司14,1952
85,76,562,公司15,1952
59,55,214,公司16,1952
61,70,173,公司17,1952
53,51,156,公司18,1952
50,79,455,公司19,1952
95,48,773,公司20,1952
49,68,927,公司21,1952
71,43,324,公司22,1952
10,45,327,公司23,1952
75,7,166,公司24,1952
25,86,618,公司25,1952
81,88,675,公司26,1952
8,69,1028,公司27,1952
19,89,636,公司28,1952
48,15,242,公司29,1952
44,76,136,公司30,1952
81,61,531,公司31,1952
15,14,407,公司32,1952
87,30,672,公司33,1952
63,22,881,公司34,1952
0,30,790,公司35,1952
59,28,839,公司36,1952
36,56,257,公司37,1952
63,0,954,公司38,1952
66,30,376,公司39,1952
85,30,496,公司40,1952
9,77,892,公司41,1952
26,66,900,公司42,1952
17,45,21,公司43,1952
53,77,789,公司44,1952
96,72,835,公司45,1952
31,-1,284,公司46,1952
18,78,103,公司47,1952
7,25,289,公司48,1952
86,38,873,公司49,1952
50,30,672,公司0,1953
16,64,277,公司1,1953
44,11,835,公司2,1953
92,91,561,公司3,1953
12,94,724,公司4,1953
50,14,739,公司5,1953
38,100,767,公司6,1953
100,72,802,公司7,1953
5,5,143,公司8,1953
8,98,894,公司9,1953
72,10,937,公司10,1953
79,4,305,公司11,1953
98,89,873,公司12,1953
35,79,628,公司13,1953
12,76,611,公司14,1953
84,78,545,公司15,1953
58,57,199,公司16,1953
63,73,185,公司17,1953
52,52,117,公司18,1953
49,78,434,公司19,1953
94,51,765,公司20,1953
50,67,899,公司21,1953
71,45,343,公司22,1953
13,48,318,公司23,1953
75,7,185,公司24,1953
27,89,574,公司25,1953
84,90,688,公司26,1953
7,69,991,公司27,1953
20,90,606,公司28,1953
51,15,251,公司29,1953
47,75,154,公司30,1953
83,63,555,公司31,1953
14,18,455,公司32,1953
89,33,709,公司33,1953
64,22,874,公司34,1953
-1,33,753,公司35,1953
61,27,837,公司36,1953
35,59,280,公司37,1953
63,3,975,公司38,1953
67,31,341,公司39,1953
87,31,471,公司40,1953
9,76,936,公司41,1953
28,65,940,公司42,1953
18,46,59,公司43,1953
55,76,757,公司44,1953
96,72,827,公司45,1953
34,-2,287,公司46,1953
22,78,107,公司47,1953
9,25,258,公司48,1953
87,39,877,公司49,1953
50,29,645,公司0,1954
16,64,312,公司1,1954
47,11,790,公司2,1954
94,90,553,公司3,1954
13,93,692,公司4,1954
48,13,714,公司5,1954
38,99,725,公司6,1954
103,72,842,公司7,1954
6,4,136,公司8,1954
10,100,894,公司9,1954
75,9,925,公司10,1954
79,6,346,公司11,1954
100,89,878,公司12,1954
36,80,590,公司13,1954
14,78,643,公司14,1954
83,77,575,公司15,1954
61,59,224,公司16,1954
62,76,234,公司17,1954
52,52,161,公司18,1954
49,79,441,公司19,1954
96,51,800,公司20,1954
52,67,931,公司21,1954
74,48,337,公司22,1954
14,51,349,公司23,1954
78,9,238,公司24,1954
30,91,554,公司25,1954
83,92,658,公司26,1954
8,72,967,公司27,1954
22,89,607,公司28,1954
52,14,217,公司29,1954
50,78,156,公司30,1954
85,63,604,公司31,1954
16,21,473,公司32,1954
92,34,753,公司33,1954
66,22,881,公司34,1954
1,33,725,公司35,1954
61,30,797,公司36,1954
35,63,333,公司37,1954
63,3,1016,公司38,1954
69,30,337,公司39,1954
91,34,445,公司40,1954
9,78,960,公司41,1954
27,66,949,公司42,1954
18,46,113,公司43,1954
56,79,731,公司44,1954
98,72,855,公司45,1954
33,-3,259,公司46,1954
21,79,109,公司47,1954
12,26,285,公司48,1954
91,40,845,公司49,1954
52,28,667,公司0,1955
18,65,324,公司1,1955
50,10,781,公司2,1955
95,90,581,公司3,1955
15,95,669,公司4,1955
46,13,733,公司5,1955
39,98,759,公司6,1955
102,74,801,公司7,1955
8,3,108,公司8,1955
12,101,882,公司9,1955
78,7,966,公司10,1955
80,9,395,公司11,1955
103,89,847,公司12,1955
38,81,628,公司13,1955
14,79,610,公司14,1955
86,79,625,公司15,1955
61,60,209,公司16,1955
62,78,281,公司17,1955
54,54,186,公司18,1955
51,82,478,公司19,1955
95,52,842,公司20,1955
54,69,886,公司21,1955
74,51,361,公司22,1955
17,54,362,公司23,1955
81,8,212,公司24,1955
31,94,546,公司25,1955
82,95,707,公司26,1955
9,72,929,公司27,1955
24,90,610,公司28,1955
54,13,244,公司29,1955
51,80,208,公司30,1955
86,67,646,公司31,1955
20,22,428,公司32,1955
95,37,758,公司33,1955
65,25,887,公司34,1955
4,35,717,公司35,1955
63,30,819,公司36,1955
35,65,322,公司37,1955
65,5,1015,公司38,1955
71,30,336,公司39,1955
93,34,472,公司40,1955
9,81,1001,公司41,1955
28,67,922,公司42,1955
18,47,125,公司43,1955
59,79,778,公司44,1955
101,75,879,公司45,1955
32,-1,311,公司46,1955
23,81,151,公司47,1955
12,29,285,公司48,1955
92,42,858,公司49,1955
50,30,696,公司0,1956
20,68,327,公司1,1956
51,8,793,公司2,1956
98,90,554,公司3,1956
16,95,689,公司4,1956
47,15,745,公司5,1956
39,100,797,公司6,1956
100,77,765,公司7,1956
6,4,152,公司8,1956
14,102,860,公司9,1956
81,10,1000,公司10,1956
83,7,412,公司11,1956
102,91,822,公司12,1956
37,84,599,公司13,1956
13,81,584,公司14,1956
86,81,663,公司15,1956
63,60,169,公司16,1956
61,78,309,公司17,1956
56,56,215,公司18,1956
52,81,533,公司19,1956
98,55,882,公司20,1956
53,69,897,公司21,1956
73,53,321,公司22,1956
18,55,399,公司23,1956
84,7,208,公司24,1956
30,97,555,公司25,1956
82,94,687,公司26,1956
8,74,980,公司27,1956
24,89,603,公司28,1956
57,14,255,公司29,1956
53,81,197,公司30,1956
88,69,697,公司31,1956
19,21,454,公司32,1956
95,38,805,公司33,1956
67,25,939,公司34,1956
6,37,714,公司35,1956
62,32,839,公司36,1956
34,67,334,公司37,1956
68,4,983,公司38,1956
73,29,336,公司39,1956
94,37,502,公司40,1956
9,83,969,公司41,1956
31,69,974,公司42,1956
19,50,127,公司43,1956
62,78,743,公司44,1956
105,75,875,公司45,1956
36,2,267,公司46,1956
27,81,116,公司47,1956
15,29,267,公司48,1956
92,45,860,公司49,1956
51,29,675,公司0,1957
20,66,318,公司1,1957
50,10,808,公司2,1957
99,91,593,公司3,1957
16,97,653,公司4,1957
46,14,785,公司5,1957
40,101,838,公司6,1957
99,77,764,公司7,1957
5,6,117,公司8,1957
13,104,852,公司9,1957
81,12,983,公司10,1957
82,5,430,公司11,1957
104,93,835,公司12,1957
37,82,571,公司13,1957
14,79,542,公司14,1957
85,81,692,公司15,1957
65,61,135,公司16,1957
60,79,274,公司17,1957
58,58,219,公司18,1957
54,83,537,公司19,1957
97,54,863,公司20,1957
54,70,885,公司21,1957
72,55,362,公司22,1957
18,58,403,公司23,1957
86,7,166,公司24,1957
33,96,525,公司25,1957
84,96,687,公司26,1957
9,77,963,公司27,1957
25,91,579,公司28,1957
57,13,230,公司29,1957
56,84,185,公司30,1957
91,71,731,公司31,1957
20,22,487,公司32,1957
94,41,834,公司33,1957
66,27,903,公司34,1957
8,37,755,公司35,1957
65,34,861,公司36,1957
36,66,298,公司37,1957
71,5,1004,公司38,1957
75,31,345,公司39,1957
96,39,512,公司40,1957
12,87,948,公司41,1957
34,69,987,公司42,1957
18,53,150,公司43,1957
63,77,715,公司44,1957
109,78,857,公司45,1957
39,5,237,公司46,1957
29,84,161,公司47,1957
19,31,260,公司48,1957
93,47,857,公司49,1957
54,30,690,公司0,1958
23,67,301,公司1,1958
50,10,816,公司2,1958
101,91,642,公司3,1958
18,97,641,公司4,1958
47,12,750,公司5,1958
42,102,842,公司6,1958
98,77,800,公司7,1958
7,7,117,公司8,1958
15,105,890,公司9,1958
84,12,950,公司10,1958
84,7,457,公司11,1958
102,92,829,公司12,1958
39,81,549,公司13,1958
16,79,578,公司14,1958
84,83,690,公司15,1958
63,60,96,公司16,1958
62,80,237,公司17,1958
56,59,244,公司18,1958
54,83,533,公司19,1958
100,56,859,公司20,1958
55,72,846,公司21,1958
72,57,346,公司22,1958
20,57,430,公司23,1958
87,9,212,公司24,1958
33,95,533,公司25,1958
87,95,658,公司26,1958
11,80,947,公司27,1958
27,93,621,公司28,1958
56,12,195,公司29,1958
56,84,198,公司30,1958
92,72,719,公司31,1958
20,23,466,公司32,1958
93,43,790,公司33,1958
68,28,941,公司34,1958
8,38,718,公司35,1958
67,37,862,公司36,1958
38,67,255,公司37,1958
74,5,967,公司38,1958
78,32,396,公司39,1958
96,38,486,公司40,1958
12,89,981,公司41,1958
34,70,943,公司42,1958
20,56,109,公司43,1958
67,79,745,公司44,1958
112,82,816,公司45,1958
43,4,244,公司46,1958
31,85,136,公司47,1958
22,32,222,公司48,1958
96,50,854,公司49,1958
57,31,709,公司0,1959
23,69,306,公司1,1959
51,10,853,公司2,1959
101,90,683,公司3,1959
21,97,603,公司4,1959
49,14,754,公司5,1959
45,101,860,公司6,1959
98,78,797,公司7,1959
10,6,144,公司8,1959
18,104,918,公司9,1959
87,15,955,公司10,1959
84,9,509,公司11,1959
105,95,803,公司12,1959
42,82,601,公司13,1959
19,80,553,公司14,1959
83,82,649,公司15,1959
66,63,144,公司16,1959
64,82,206,公司17,1959
56,60,200,公司18,1959
54,86,546,公司19,1959
101,55,881,公司20,1959
56,71,839,公司21,1959
71,57,382,公司22,1959
22,56,439,公司23,1959
88,11,242,公司24,1959
36,95,527,公司25,1959
86,96,641,公司26,1959
14,83,979,公司27,1959
30,92,663,公司28,1959
56,12,161,公司29,1959
57,87,234,公司30,1959
95,75,730,公司31,1959
22,23,435,公司32,1959
93,42,754,公司33,1959
69,29,945,公司34,1959
7,37,753,公司35,1959
71,36,853,公司36,1959
39,66,245,公司37,1959
75,4,959,公司38,1959
82,36,425,公司39,1959
96,41,469,公司40,1959
12,91,1023,公司41,1959
35,69,945,公司42,1959
23,57,140,公司43,1959
68,78,743,公司44,1959
115,83,808,公司45,1959
42,3,203,公司46,1959
30,84,185,公司47,1959
25,31,182,公司48,1959
97,53,852,公司49,1959
55,30,681,公司0,1960
22,68,277,公司1,1960
53,12,823,公司2,1960
103,90,704,公司3,1960
19,96,567,公司4,1960
52,16,775,公司5,1960
44,101,902,公司6,1960
100,81,818,公司7,1960
10,8,159,公司8,1960
21,105,908,公司9,1960
90,18,937,公司10,1960
84,11,498,公司11,1960
105,94,845,公司12,1960
45,82,579,公司13,1960
21,83,592,公司14,1960
83,81,642,公司15,1960
68,64,158,公司16,1960
67,85,248,公司17,1960
57,59,251,公司18,1960
53,89,571,公司19,1960
102,58,885,公司20,1960
56,70,878,公司21,1960
73,60,401,公司22,1960
22,56,423,公司23,1960
90,10,278,公司24,1960
39,96,570,公司25,1960
89,96,598,公司26,1960
14,86,1003,公司27,1960
31,95,683,公司28,1960
59,12,126,公司29,1960
57,86,192,公司30,1960
96,77,783,公司31,1960
22,26,455,公司32,1960
93,43,787,公司33,1960
71,31,998,公司34,1960
8,39,751,公司35,1960
74,40,867,公司36,1960
40,66,200,公司37,1960
75,6,960,公司38,1960
81,39,391,公司39,1960
96,41,455,公司40,1960
12,94,1056,公司41,1960
38,69,961,公司42,1960
22,61,119,公司43,1960
68,81,753,公司44,1960
115,82,766,公司45,1960
41,5,205,公司46,1960
32,83,220,公司47,1960
28,33,187,公司48,1960
99,57,893,公司49,1960
58,33,713,公司0,1961
23,71,248,公司1,1961
54,12,787,公司2,1961
103,92,720,公司3,1961
19,98,621,公司4,1961
54,15,826,公司5,1961
47,103,915,公司6,1961
102,80,787,公司7,1961
11,7,173,公司8,1961
21,107,876,公司9,1961
90,21,901,公司10,1961
85,10,492,公司11,1961
108,95,887,公司12,1961
47,84,634,公司13,1961
23,86,633,公司14,1961
86,80,607,公司15,1961
70,63,133,公司16,1961
69,88,266,公司17,1961
56,62,244,公司18,1961
54,92,623,公司19,1961
103,61,878,公司20,1961
58,71,890,公司21,1961
74,62,372,公司22,1961
25,58,396,公司23,1961
93,13,284,公司24,1961
40,98,605,公司25,1961
92,98,647,公司26,1961
13,88,1003,公司27,1961
32,95,718,公司28,1961
59,16,152,公司29,1961
59,86,215,公司30,1961
97,80,820,公司31,1961
21,29,474,公司32,1961
94,42,755,公司33,1961
71,33,958,公司34,1961
8,38,734,公司35,1961
77,43,878,公司36,1961
44,67,235,公司37,1961
75,7,977,公司38,1961
83,38,393,公司39,1961
95,41,484,公司40,1961
13,95,1061,公司41,1961
41,71,941,公司42,1961
23,60,119,公司43,1961
71,84,784,公司44,1961
117,85,792,公司45,1961
45,9,235,公司46,1961
34,84,194,公司47,1961
30,36,163,公司48,1961
101,59,921,公司49,1961
60,32,744,公司0,1962
21,72,219,公司1,1962
56,12,801,公司2,1962
102,90,775,公司3,1962
22,97,585,公司4,1962
55,18,838,公司5,1962
47,106,959,公司6,1962
104,82,775,公司7,1962
11,8,148,公司8,1962
23,107,929,公司9,1962
89,19,950,公司10,1962
88,12,496,公司11,1962
110,96,915,公司12,1962
47,84,607,公司13,1962
22,86,639,公司14,1962
88,79,655,公司15,1962
73,63,119,公司16,1962
70,89,246,公司17,1962
55,64,227,公司18,1962
57,94,649,公司19,1962
102,62,921,公司20,1962
60,72,853,公司21,1962
74,61,371,公司22,1962
26,59,412,公司23,1962
95,16,273,公司24,1962
41,99,582,公司25,1962
91,99,668,公司26,1962
15,89,1047,公司27,1962
34,94,732,公司28,1962
59,15,177,公司29,1962
58,86,203,公司30,1962
99,82,870,公司31,1962
21,31,525,公司32,1962
93,41,725,公司33,1962
75,34,1005,公司34,1962
10,37,785,公司35,1962
77,44,909,公司36,1962
45,66,195,公司37,1962
76,10,953,公司38,1962
86,39,368,公司39,1962
97,42,441,公司40,1962
15,95,1089,公司41,1962
41,71,922,公司42,1962
24,61,90,公司43,1962
74,84,758,公司44,1962
116,85,806,公司45,1962
46,11,260,公司46,1962
33,85,174,公司47,1962
29,39,206,公司48,1962
101,59,923,公司49,1962
59,33,766,公司0,1963
22,75,268,公司1,1963
56,10,768,公司2,1963
101,90,740,公司3,1963
25,96,637,公司4,1963
54,19,860,公司5,1963
50,106,978,公司6,1963
104,81,807,公司7,1963
10,9,188,公司8,1963
24,108,941,公司9,1963
90,20,958,公司10,1963
88,11,483,公司11,1963
113,98,872,公司12,1963
47,87,591,公司13,1963
21,88,691,公司14,1963
90,78,681,公司15,1963
72,63,78,公司16,1963
69,91,282,公司17,1963
54,66,197,公司18,1963
60,97,660,公司19,1963
101,63,889,公司20,1963
61,71,867,公司21,1963
75,62,351,公司22,1963
25,62,445,公司23,1963
97,17,250,公司24,1963
44,99,634,公司25,1963
91,100,719,公司26,1963
16,91,1014,公司27,1963
37,93,756,公司28,1963
61,17,158,公司29,1963
59,87,210,公司30,1963
102,82,833,公司31,1963
20,30,510,公司32,1963
96,43,774,公司33,1963
75,37,1033,公司34,1963
9,37,793,公司35,1963
78,44,865,公司36,1963
44,65,238,公司37,1963
78,10,985,公司38,1963
88,39,415,公司39,1963
97,42,479,公司40,1963
14,98,1142,公司41,1963
41,73,967,公司42,1963
23,60,140,公司43,1963
75,85,717,公司44,1963
119,88,834,公司45,1963
46,10,239,公司46,1963
34,89,178,公司47,1963
31,38,186,公司48,1963
104,61,974,公司49,1963
59,34,765,公司0,1964
22,73,238,公司1,1964
55,11,754,公司2,1964
103,90,716,公司3,1964
28,98,684,公司4,1964
54,20,828,公司5,1964
53,105,941,公司6,1964
103,83,797,公司7,1964
12,9,204,公司8,1964
22,109,938,公司9,1964
89,20,949,公司10,1964
86,13,520,公司11,1964
112,99,873,公司12,1964
48,88,605,公司13,1964
24,89,674,公司14,1964
90,81,649,公司15,1964
73,63,106,公司16,1964
71,93,242,公司17,1964
54,68,181,公司18,1964
61,98,667,公司19,1964
99,65,857,公司20,1964
64,70,878,公司21,1964
75,61,329,公司22,1964
24,65,405,公司23,1964
99,17,256,公司24,1964
45,101,680,公司25,1964
94,101,708,公司26,1964
16,90,1026,公司27,1964
40,92,759,公司28,1964
61,17,146,公司29,1964
63,88,238,公司30,1964
103,81,837,公司31,1964
22,31,474,公司32,1964
99,46,828,公司33,1964
76,38,1057,公司34,1964
10,38,794,公司35,1964
77,43,847,公司36,1964
46,67,263,公司37,1964
80,10,958,公司38,1964
90,38,380,公司39,1964
101,45,531,公司40,1964
18,99,1154,公司41,1964
45,73,946,公司42,1964
26,61,144,公司43,1964
76,85,721,公司44,1964
119,87,814,公司45,1964
45,10,256,公司46,1964
36,88,223,公司47,1964
31,42,214,公司48,1964
106,61,987,公司49,1964
60,34,805,公司0,1965
21,72,264,公司1,1965
57,9,771,公司2,1965
103,93,755,公司3,1965
26,99,647,公司4,1965
57,23,857,公司5,1965
56,107,930,公司6,1965
106,83,767,公司7,1965
13,12,195,公司8,1965
23,111,937,公司9,1965
91,20,963,公司10,1965
87,12,561,公司11,1965
115,102,839,公司12,1965
51,88,563,公司13,1965
26,91,675,公司14,1965
89,83,657,公司15,1965
76,66,62,公司16,1965
74,93,274,公司17,1965
53,70,145,公司18,1965
60,97,653,公司19,1965
101,67,838,公司20,1965
66,70,888,公司21,1965
78,61,364,公司22,1965
27,66,439,公司23,1965
99,16,212,公司24,1965
45,101,718,公司25,1965
93,103,749,公司26,1965
18,89,1070,公司27,1965
40,91,748,公司28,1965
62,18,132,公司29,1965
65,88,261,公司30,1965
105,83,840,公司31,1965
22,35,501,公司32,1965
101,49,828,公司33,1965
76,39,1050,公司34,1965
9,37,844,公司35,1965
77,45,871,公司36,1965
45,67,267,公司37,1965
79,11,955,公司38,1965
93,39,379,公司39,1965
101,47,508,公司40,1965
21,100,1160,公司41,1965
46,76,949,公司42,1965
29,64,115,公司43,1965
80,87,767,公司44,1965
121,86,841,公司45,1965
44,13,302,公司46,1965
39,89,264,公司47,1965
32,43,179,公司48,1965
106,61,1019,公司49,1965
59,32,805,公司0,1966
23,74,274,公司1,1966
60,8,742,公司2,1966
102,94,749,公司3,1966
24,100,640,公司4,1966
55,22,846,公司5,1966
56,108,937,公司6,1966
109,86,769,公司7,1966
14,12,185,公司8,1966
26,110,961,公司9,1966
94,22,985,公司10,1966
86,12,540,公司11,1966
117,102,887,公司12,1966
50,91,613,公司13,1966
25,93,693,公司14,1966
89,84,678,公司15,1966
77,66,62,公司16,1966
77,95,254,公司17,1966
54,71,172,公司18,1966
61,96,677,公司19,1966
102,67,846,公司20,1966
69,73,940,公司21,1966
78,64,403,公司22,1966
30,69,455,公司23,1966
98,15,221,公司24,1966
48,104,704,公司25,1966
92,102,784,公司26,1966
21,92,1041,公司27,1966
43,92,704,公司28,1966
61,19,100,公司29,1966
67,91,244,公司30,1966
106,85,857,公司31,1966
22,35,545,公司32,1966
100,52,803,公司33,1966
79,39,1090,公司34,1966
9,39,847,公司35,1966
77,46,865,公司36,1966
45,69,283,公司37,1966
80,14,921,公司38,1966
93,39,341,公司39,1966
102,49,549,公司40,1966
22,100,1156,公司41,1966
48,75,935,公司42,1966
31,67,136,公司43,1966
80,88,817,公司44,1966
122,85,807,公司45,1966
45,14,259,公司46,1966
41,90,306,公司47,1966
32,46,173,公司48,1966
107,62,1068,公司49,1966
58,32,775,公司0,1967
21,76,280,公司1,1967
59,10,700,公司2,1967
101,95,788,公司3,1967
23,100,600,公司4,1967
55,24,809,公司5,1967
59,108,912,公司6,1967
112,86,790,公司7,1967
17,11,162,公司8,1967
27,113,940,公司9,1967
93,21,987,公司10,1967
88,12,554,公司11,1967
120,105,894,公司12,1967
51,91,662,公司13,1967
26,94,678,公司14,1967
88,85,694,公司15,1967
79,65,80,公司16,1967
80,95,290,公司17,1967
55,72,181,公司18,1967
64,95,678,公司19,1967
101,69,869,公司20,1967
68,72,993,公司21,1967
81,67,433,公司22,1967
31,72,488,公司23,1967
99,17,211,公司24,1967
47,104,740,公司25,1967
93,101,836,公司26,1967
23,95,1011,公司27,1967
43,95,688,公司28,1967
61,19,129,公司29,1967
68,92,223,公司30,1967
106,88,837,公司31,1967
24,36,543,公司32,1967
100,52,844,公司33,1967
79,40,1092,公司34,1967
8,40,862,公司35,1967
76,47,842,公司36,1967
48,72,303,公司37,1967
82,14,965,公司38,1967
92,40,346,公司39,1967
101,48,540,公司40,1967
23,101,1186,公司41,1967
51,76,921,公司42,1967
31,67,132,公司43,1967
79,89,779,公司44,1967
125,89,808,公司45,1967
45,14,216,公司46,1967
40,90,278,公司47,1967
32,46,203,公司48,1967
111,64,1115,公司49,1967
56,31,732,公司0,1968
20,76,299,公司1,1968
60,12,722,公司2,1968
101,95,802,公司3,1968
25,103,626,公司4,1968
53,26,786,公司5,1968
59,108,874,公司6,1968
112,89,755,公司7,1968
19,14,202,公司8,1968
25,114,938,公司9,1968
95,21,947,公司10,1968
91,11,558,公司11,1968
122,108,854,公司12,1968
52,92,656,公司13,1968
29,96,711,公司14,1968
87,86,746,公司15,1968
81,68,90,公司16,1968
82,94,319,公司17,1968
56,72,174,公司18,1968
64,95,710,公司19,1968
101,69,836,公司20,1968
70,75,965,公司21,1968
80,69,402,公司22,1968
30,74,485,公司23,1968
100,17,231,公司24,1968
50,107,795,公司25,1968
96,100,861,公司26,1968
22,96,1058,公司27,1968
44,94,649,公司28,1968
60,22,167,公司29,1968
67,93,260,公司30,1968
105,90,874,公司31,1968
28,35,577,公司32,1968
101,54,880,公司33,1968
81,43,1145,公司34,1968
7,42,858,公司35,1968
77,49,893,公司36,1968
50,73,346,公司37,1968
85,14,944,公司38,1968
92,42,350,公司39,1968
103,51,526,公司40,1968
26,104,1162,公司41,1968
51,75,971,公司42,1968
31,70,119,公司43,1968
80,92,741,公司44,1968
127,92,780,公司45,1968
48,15,246,公司46,1968
42,90,321,公司47,1968
34,46,238,公司48,1968
115,64,1147,公司49,1968
58,31,770,公司0,1969
19,77,284,公司1,1969
61,10,712,公司2,1969
100,97,799,公司3,1969
24,101,651,公司4,1969
52,26,840,公司5,1969
60,106,866,公司6,1969
114,90,771,公司7,1969
19,13,229,公司8,1969
25,117,922,公司9,1969
94,20,985,公司10,1969
92,14,546,公司11,1969
124,110,843,公司12,1969
55,95,615,公司13,1969
29,99,727,公司14,1969
86,87,710,公司15,1969
83,68,139,公司16,1969
81,94,337,公司17,1969
59,74,206,公司18,1969
63,95,685,公司19,1969
104,69,878,公司20,1969
73,75,956,公司21,1969
83,72,409,公司22,1969
29,73,447,公司23,1969
101,17,284,公司24,1969
50,108,821,公司25,1969
96,101,892,公司26,1969
24,97,1096,公司27,1969
44,97,684,公司28,1969
63,23,184,公司29,1969
69,95,295,公司30,1969
105,90,882,公司31,1969
30,39,568,公司32,1969
101,55,866,公司33,1969
83,43,1179,公司34,1969
8,46,813,公司35,1969
80,52,872,公司36,1969
53,72,313,公司37,1969
86,17,969,公司38,1969
91,42,317,公司39,1969
103,53,526,公司40,1969
26,104,1200,公司41,1969
53,75,1001,公司42,1969
32,72,122,公司43,1969
82,91,741,公司44,1969
131,92,816,公司45,1969
48,16,250,公司46,1969
43,93,357,公司47,1969
37,45,206,公司48,1969
114,65,1177,公司49,1969
57,30,761,公司0,1970
20,79,314,公司1,1970
61,10,726,公司2,1970
99,98,776,公司3,1970
25,103,699,公司4,1970
53,25,815,公司5,1970
60,106,848,公司6,1970
113,92,806,公司7,1970
22,12,241,公司8,1970
24,117,974,公司9,1970
92,20,1010,公司10,1970
95,13,599,公司11,1970
124,110,840,公司12,1970
58,98,617,公司13,1970
31,98,781,公司14,1970
88,85,763,公司15,1970
81,68,179,公司16,1970
82,96,316,公司17,1970
60,73,206,公司18,1970
64,95,685,公司19,1970
103,72,889,公司20,1970
72,77,966,公司21,1970
84,72,401,公司22,1970
31,73,495,公司23,1970
101,18,329,公司24,1970
51,108,802,公司25,1970
98,102,892,公司26,1970
27,97,1063,公司27,1970
44,99,694,公司28,1970
66,23,205,公司29,1970
68,96,347,公司30,1970
105,90,865,公司31,1970
30,38,591,公司32,1970
101,57,897,公司33,1970
83,42,1218,公司34,1970
8,45,827,公司35,1970
81,54,859,公司36,1970
55,73,347,公司37,1970
85,17,953,公司38,1970
93,44,324,公司39,1970
106,52,542,公司40,1970
27,106,1201,公司41,1970
56,75,1011,公司42,1970
35,72,159,公司43,1970
86,90,769,公司44,1970
132,94,861,公司45,1970
49,17,257,公司46,1970
45,94,386,公司47,1970
39,49,180,公司48,1970
116,65,1160,公司49,1970
59,30,717,公司0,1971
22,82,326,公司1,1971
63,11,733,公司2,1971
98,100,768,公司3,1971
26,101,718,公司4,1971
56,26,776,公司5,1971
60,106,823,公司6,1971
113,93,778,公司7,1971
21,11,209,公司8,1971
26,119,1000,公司9,1971
91,21,967,公司10,1971
94,11,638,公司11,1971
126,110,842,公司12,1971
60,99,633,公司13,1971
31,97,750,公司14,1971
87,86,793,公司15,1971
80,71,146,公司16,1971
83,95,323,公司17,1971
59,73,215,公司18,1971
63,96,671,公司19,1971
105,75,905,公司20,1971
72,79,964,公司21,1971
85,73,385,公司22,1971
30,75,537,公司23,1971
100,17,317,公司24,1971
50,108,818,公司25,1971
97,104,872,公司26,1971
28,97,1107,公司27,1971
45,98,741,公司28,1971
69,22,162,公司29,1971
68,98,363,公司30,1971
107,92,878,公司31,1971
33,38,640,公司32,1971
100,60,896,公司33,1971
82,45,1189,公司34,1971
8,47,863,公司35,1971
84,56,880,公司36,1971
56,75,395,公司37,1971
86,19,1004,公司38,1971
94,46,307,公司39,1971
106,53,595,公司40,1971
30,106,1206,公司41,1971
58,76,981,公司42,1971
39,74,184,公司43,1971
85,93,728,公司44,1971
134,96,895,公司45,1971
51,20,226,公司46,1971
48,97,406,公司47,1971
40,51,174,公司48,1971
118,64,1153,公司49,1971
58,33,714,公司0,1972
23,81,340,公司1,1972
61,12,786,公司2,1972
100,101,816,公司3,1972
26,103,697,公司4,1972
56,25,775,公司5,1972
61,106,801,公司6,1972
115,95,806,公司7,1972
24,14,250,公司8,1972
27,118,1019,公司9,1972
92,21,959,公司10,1972
95,11,647,公司11,1972
126,112,803,公司12,1972
60,101,648,公司13,1972
33,100,750,公司14,1972
88,85,838,公司15,1972
81,72,158,公司16,1972
86,97,299,公司17,1972
61,72,216,公司18,1972
65,96,698,公司19,1972
104,77,955,公司20,1972
74,81,965,公司21,1972
88,76,434,公司22,1972
31,77,578,公司23,1972
103,16,334,公司24,1972
49,109,793,公司25,1972
100,106,874,公司26,1972
27,97,1064,公司27,1972
45,100,793,公司28,1972
71,25,186,公司29,1972
67,101,351,公司30,1972
110,92,924,公司31,1972
35,41,640,公司32,1972
101,59,878,公司33,1972
82,46,1160,公司34,1972
10,47,822,公司35,1972
87,57,843,公司36,1972
56,74,430,公司37,1972
85,22,990,公司38,1972
95,45,344,公司39,1972
107,54,581,公司40,1972
31,106,1260,公司41,1972
60,75,974,公司42,1972
43,77,185,公司43,1972
86,93,768,公司44,1972
134,98,910,公司45,1972
51,22,234,公司46,1972
51,99,432,公司47,1972
39,51,193,公司48,1972
118,63,1158,公司49,1972
56,35,728,公司0,1973
25,83,387,公司1,1973
64,10,818,公司2,1973
100,102,834,公司3,1973
28,103,658,公司4,1973
55,27,755,公司5,1973
64,109,824,公司6,1973
113,98,793,公司7,1973
26,15,268,公司8,1973
28,117,1034,公司9,1973
91,24,980,公司10,1973
95,12,661,公司11,1973
128,113,761,公司12,1973
61,104,615,公司13,1973
34,100,721,公司14,1973
90,84,823,公司15,1973
83,71,139,公司16,1973
88,99,294,公司17,1973
61,72,196,公司18,1973
66,94,682,公司19,1973
104,78,961,公司20,1973
76,83,928,公司21,1973
88,77,426,公司22,1973
32,76,621,公司23,1973
106,17,319,公司24,1973
48,108,825,公司25,1973
101,107,860,公司26,1973
30,96,1084,公司27,1973
47,102,764,公司28,1973
70,27,147,公司29,1973
69,100,392,公司30,1973
110,94,893,公司31,1973
38,42,665,公司32,1973
100,60,877,公司33,1973
82,45,1160,公司34,1973
9,48,831,公司35,1973
88,58,833,公司36,1973
57,75,399,公司37,1973
87,24,1019,公司38,1973
98,47,366,公司39,1973
106,57,597,公司40,1973
34,109,1253,公司41,1973
60,76,938,公司42,1973
44,79,149,公司43,1973
87,96,753,公司44,1973
134,98,929,公司45,1973
50,23,257,公司46,1973
52,102,452,公司47,1973
38,54,191,公司48,1973
119,64,1135,公司49,1973
58,38,727,公司0,1974
26,83,405,公司1,1974
62,11,774,公司2,1974
101,105,874,公司3,1974
30,102,700,公司4,1974
56,30,723,公司5,1974
64,110,843,公司6,1974
112,97,756,公司7,1974
24,18,282,公司8,1974
26,119,1031,公司9,1974
91,23,940,公司10,1974
97,13,659,公司11,1974
127,116,766,公司12,1974
62,105,623,公司13,1974
36,102,735,公司14,1974
92,86,787,公司15,1974
82,74,108,公司16,1974
91,100,311,公司17,1974
64,72,244,公司18,1974
64,96,700,公司19,1974
103,80,929,公司20,1974
78,86,883,公司21,1974
87,78,434,公司22,1974
33,78,584,公司23,1974
106,17,282,公司24,1974
48,110,877,公司25,1974
102,109,852,公司26,1974
29,95,1115,公司27,1974
47,101,745,公司28,1974
73,30,159,公司29,1974
71,99,440,公司30,1974
111,93,877,公司31,1974
39,45,709,公司32,1974
102,60,872,公司33,1974
84,45,1175,公司34,1974
12,49,831,公司35,1974
89,61,793,公司36,1974
60,78,386,公司37,1974
87,27,1016,公司38,1974
101,49,352,公司39,1974
109,58,620,公司40,1974
34,112,1233,公司41,1974
60,75,959,公司42,1974
44,83,105,公司43,1974
90,97,733,公司44,1974
134,102,885,公司45,1974
54,25,300,公司46,1974
55,104,462,公司47,1974
39,57,180,公司48,1974
118,66,1155,公司49,1974
57,38,687,公司0,1975
24,82,455,公司1,1975
62,12,826,公司2,1975
103,107,838,公司3,1975
32,101,701,公司4,1975
58,32,757,公司5,1975
65,111,885,公司6,1975
111,95,753,公司7,1975
23,19,262,公司8,1975
25,122,1082,公司9,1975
94,21,914,公司10,1975
99,13,686,公司11,1975
130,119,771,公司12,1975
61,103,660,公司13,1975
36,103,745,公司14,1975
94,89,802,公司15,1975
83,77,130,公司16,1975
91,102,324,公司17,1975
66,72,224,公司18,1975
66,98,735,公司19,1975
106,79,916,公司20,1975
77,85,863,公司21,1975
88,78,408,公司22,1975
35,81,601,公司23,1975
107,18,326,公司24,1975
50,112,910,公司25,1975
102,108,891,公司26,1975
29,96,1100,公司27,1975
49,104,741,公司28,1975
73,31,205,公司29,1975
72,101,477,公司30,1975
114,95,900,公司31,1975
43,48,759,公司32,1975
104,63,870,公司33,1975
85,44,1134,公司34,1975
13,52,827,公司35,1975
91,62,755,公司36,1975
59,78,431,公司37,1975
90,30,977,公司38,1975
100,50,386,公司39,1975
111,61,654,公司40,1975
36,112,1192,公司41,1975
61,76,925,公司42,1975
47,83,143,公司43,1975
92,99,708,公司44,1975
137,103,889,公司45,1975
54,28,354,公司46,1975
56,107,462,公司47,1975
39,59,194,公司48,1975
122,66,1180,公司49,1975
59,40,661,公司0,1976
24,80,471,公司1,1976
64,11,782,公司2,1976
106,107,860,公司3,1976
34,100,749,公司4,1976
61,33,740,公司5,1976
65,111,931,公司6,1976
110,94,796,公司7,1976
25,18,243,公司8,1976
23,125,1110,公司9,1976
93,22,901,公司10,1976
99,15,690,公司11,1976
130,122,755,公司12,1976
60,105,650,公司13,1976
35,101,728,公司14,1976
97,90,824,公司15,1976
84,80,105,公司16,1976
90,104,283,公司17,1976
66,71,278,公司18,1976
69,98,779,公司19,1976
108,79,958,公司20,1976
76,85,833,公司21,1976
87,81,455,公司22,1976
36,80,559,公司23,1976
106,21,306,公司24,1976
49,115,940,公司25,1976
105,109,912,公司26,1976
30,97,1134,公司27,1976
49,104,748,公司28,1976
73,34,200,公司29,1976
72,103,496,公司30,1976
114,97,890,公司31,1976
44,50,729,公司32,1976
103,65,902,公司33,1976
84,47,1143,公司34,1976
14,55,811,公司35,1976
93,64,768,公司36,1976
59,79,460,公司37,1976
89,33,972,公司38,1976
100,50,352,公司39,1976
113,64,624,公司40,1976
38,112,1176,公司41,1976
63,76,893,公司42,1976
47,82,109,公司43,1976
92,101,688,公司44,1976
139,104,926,公司45,1976
54,30,405,公司46,1976
56,107,465,公司47,1976
39,58,166,公司48,1976
124,68,1218,公司49,1976
62,41,681,公司0,1977
23,82,482,公司1,1977
64,12,812,公司2,1977
107,109,846,公司3,1977
36,101,800,公司4,1977
63,34,786,公司5,1977
65,111,922,公司6,1977
109,97,773,公司7,1977
28,20,225,公司8,1977
25,128,1113,公司9,1977
96,25,914,公司10,1977
98,18,662,公司11,1977
132,123,785,公司12,1977
60,106,661,公司13,1977
35,103,751,公司14,1977
98,91,852,公司15,1977
85,83,100,公司16,1977
92,103,338,公司17,1977
66,70,248,公司18,1977
71,101,762,公司19,1977
110,77,983,公司20,1977
77,88,858,公司21,1977
88,84,475,公司22,1977
38,80,567,公司23,1977
106,21,356,公司24,1977
48,116,928,公司25,1977
105,110,894,公司26,1977
29,96,1140,公司27,1977
51,104,731,公司28,1977
74,35,216,公司29,1977
72,106,470,公司30,1977
115,97,938,公司31,1977
48,51,753,公司32,1977
105,66,925,公司33,1977
86,48,1126,公司34,1977
13,57,803,公司35,1977
94,67,818,公司36,1977
59,82,483,公司37,1977
91,35,960,公司38,1977
100,50,385,公司39,1977
114,68,669,公司40,1977
39,114,1204,公司41,1977
66,76,898,公司42,1977
49,85,98,公司43,1977
92,102,643,公司44,1977
140,105,915,公司45,1977
57,30,387,公司46,1977
57,110,442,公司47,1977
41,58,134,公司48,1977
127,70,1242,公司49,1977
60,44,645,公司0,1978
24,82,509,公司1,1978
62,14,815,公司2,1978
108,112,895,公司3,1978
36,103,783,公司4,1978
65,36,811,公司5,1978
65,113,887,公司6,1978
107,98,787,公司7,1978
26,19,239,公司8,1978
23,130,1070,公司9,1978
96,27,940,公司10,1978
99,17,632,公司11,1978
132,126,797,公司12,1978
60,108,627,公司13,1978
37,104,718,公司14,1978
101,91,869,公司15,1978
87,83,134,公司16,1978
92,104,317,公司17,1978
68,72,277,公司18,1978
69,104,797,公司19,1978
110,78,988,公司20,1978
77,91,888,公司21,1978
87,87,482,公司22,1978
38,82,524,公司23,1978
108,21,326,公司24,1978
47,118,946,公司25,1978
105,109,890,公司26,1978
32,99,1140,公司27,1978
53,104,747,公司28,1978
73,38,226,公司29,1978
74,108,460,公司30,1978
116,100,926,公司31,1978
48,53,709,公司32,1978
106,69,927,公司33,1978
88,50,1113,公司34,1978
15,60,817,公司35,1978
97,69,812,公司36,1978
60,81,450,公司37,1978
94,36,980,公司38,1978
104,52,429,公司39,1978
113,67,682,公司40,1978
39,117,1180,公司41,1978
66,77,881,公司42,1978
52,86,135,公司43,1978
92,104,684,公司44,1978
141,109,968,公司45,1978
58,29,373,公司46,1978
57,113,466,公司47,1978
40,59,140,公司48,1978
128,73,1291,公司49,1978
63,43,642,公司0,1979
25,84,542,公司1,1979
65,13,787,公司2,1979
108,115,936,公司3,1979
38,101,835,公司4,1979
66,36,836,公司5,1979
66,111,924,公司6,1979
109,101,829,公司7,1979
29,18,258,公司8,1979
22,133,1088,公司9,1979
98,30,986,公司10,1979
99,18,677,公司11,1979
132,127,759,公司12,1979
59,111,607,公司13,1979
36,104,740,公司14,1979
101,90,845,公司15,1979
86,82,150,公司16,1979
95,103,315,公司17,1979
70,72,312,公司18,1979
71,103,818,公司19,1979
110,77,985,公司20,1979
76,89,913,公司21,1979
90,90,458,公司22,1979
37,84,484,公司23,1979
107,24,295,公司24,1979
47,118,991,公司25,1979
104,112,886,公司26,1979
35,99,1181,公司27,1979
53,105,706,公司28,1979
74,39,248,公司29,1979
76,109,512,公司30,1979
117,100,979,公司31,1979
48,55,715,公司32,1979
107,68,925,公司33,1979
89,54,1149,公司34,1979
15,60,790,公司35,1979
100,70,809,公司36,1979
63,81,500,公司37,1979
96,36,1010,公司38,1979
106,52,470,公司39,1979
114,67,698,公司40,1979
39,117,1225,公司41,1979
70,79,907,公司42,1979
54,89,144,公司43,1979
91,106,662,公司44,1979
144,113,980,公司45,1979
60,28,344,公司46,1979
61,117,451,公司47,1979
40,62,159,公司48,1979
129,77,1289,公司49,1979
64,44,615,公司0,1980
27,85,514,公司1,1980
68,11,746,公司2,1980
109,117,944,公司3,1980
36,99,825,公司4,1980
67,39,847,公司5,1980
64,109,921,公司6,1980
111,103,818,公司7,1980
29,19,243,公司8,1980
23,132,1058,公司9,1980
97,32,1041,公司10,1980
100,19,665,公司11,1980
132,125,729,公司12,1980
58,113,634,公司13,1980
37,104,776,公司14,1980
102,92,828,公司15,1980
85,85,184,公司16,1980
95,105,335,公司17,1980
70,72,275,公司18,1980
72,103,776,公司19,1980
110,77,998,公司20,1980
75,91,887,公司21,1980
92,90,509,公司22,1980
37,84,448,公司23,1980
109,25,304,公司24,1980
47,120,1030,公司25,1980
104,114,845,公司26,1980
34,101,1144,公司27,1980
53,105,686,公司28,1980
76,40,225,公司29,1980
77,109,507,公司30,1980
118,99,955,公司31,1980
50,55,765,公司32,1980
109,69,921,公司33,1980
88,56,1112,公司34,1980
16,60,771,公司35,1980
103,70,845,公司36,1980
66,84,543,公司37,1980
98,35,1052,公司38,1980
107,52,440,公司39,1980
115,69,676,公司40,1980
42,118,1194,公司41,1980
73,79,879,公司42,1980
54,89,106,公司43,1980
94,110,678,公司44,1980
147,117,976,公司45,1980
64,28,330,公司46,1980
60,118,473,公司47,1980
44,65,141,公司48,1980
133,81,1287,公司49,1980
63,46,590,公司0,1981
29,83,555,公司1,1981
70,11,796,公司2,1981
112,115,971,公司3,1981
37,100,821,公司4,1981
67,39,875,公司5,1981
64,109,927,公司6,1981
113,106,841,公司7,1981
30,18,283,公司8,1981
26,135,1083,公司9,1981
97,33,1067,公司10,1981
98,22,656,公司11,1981
134,124,690,公司12,1981
61,115,647,公司13,1981
37,103,767,公司14,1981
101,91,849,公司15,1981
87,83,188,公司16,1981
97,104,383,公司17,1981
71,74,265,公司18,1981
71,102,761,公司19,1981
110,77,1012,公司20,1981
76,91,877,公司21,1981
91,92,491,公司22,1981
36,85,485,公司23,1981
111,26,287,公司24,1981
48,119,1045,公司25,1981
107,117,865,公司26,1981
33,101,1102,公司27,1981
53,107,671,公司28,1981
76,43,231,公司29,1981
77,110,530,公司30,1981
121,101,975,公司31,1981
53,55,747,公司32,1981
112,73,945,公司33,1981
90,57,1077,公司34,1981
17,60,741,公司35,1981
106,69,897,公司36,1981
66,84,597,公司37,1981
100,38,1066,公司38,1981
108,52,494,公司39,1981
118,69,702,公司40,1981
44,118,1150,公司41,1981
74,79,856,公司42,1981
56,92,141,公司43,1981
95,109,725,公司44,1981
147,121,991,公司45,1981
66,31,347,公司46,1981
60,119,501,公司47,1981
46,66,165,公司48,1981
134,84,1320,公司49,1981
65,47,588,公司0,1982
30,86,514,公司1,1982
68,11,785,公司2,1982
113,115,987,公司3,1982
37,99,815,公司4,1982
67,39,858,公司5,1982
65,110,964,公司6,1982
115,106,846,公司7,1982
29,20,268,公司8,1982
26,135,1105,公司9,1982
98,31,1108,公司10,1982
97,25,705,公司11,1982
132,127,723,公司12,1982
62,115,623,公司13,1982
38,104,723,公司14,1982
99,93,828,公司15,1982
89,83,225,公司16,1982
100,106,416,公司17,1982
70,76,318,公司18,1982
74,104,776,公司19,1982
109,80,1048,公司20,1982
79,94,878,公司21,1982
90,95,474,公司22,1982
38,87,472,公司23,1982
110,25,244,公司24,1982
51,121,1023,公司25,1982
106,118,855,公司26,1982
34,102,1070,公司27,1982
56,109,647,公司28,1982
78,45,238,公司29,1982
78,109,544,公司30,1982
120,102,994,公司31,1982
54,56,764,公司32,1982
116,73,915,公司33,1982
90,56,1072,公司34,1982
17,62,787,公司35,1982
109,72,930,公司36,1982
66,86,627,公司37,1982
99,39,1035,公司38,1982
111,55,465,公司39,1982
119,70,698,公司40,1982
44,118,1115,公司41,1982
76,82,892,公司42,1982
58,95,177,公司43,1982
95,109,755,公司44,1982
149,122,949,公司45,1982
67,34,400,公司46,1982
61,119,462,公司47,1982
46,68,124,公司48,1982
136,86,1371,公司49,1982
65,46,585,公司0,1983
32,86,517,公司1,1983
71,10,748,公司2,1983
113,115,1030,公司3,1983
40,102,839,公司4,1983
65,40,819,公司5,1983
67,112,983,公司6,1983
118,109,888,公司7,1983
30,19,247,公司8,1983
26,134,1134,公司9,1983
97,34,1119,公司10,1983
96,23,694,公司11,1983
132,125,686,公司12,1983
62,115,649,公司13,1983
41,106,680,公司14,1983
98,94,836,公司15,1983
89,85,238,公司16,1983
99,106,439,公司17,1983
69,78,314,公司18,1983
74,107,774,公司19,1983
109,80,1036,公司20,1983
81,93,883,公司21,1983
90,94,448,公司22,1983
38,89,446,公司23,1983
113,24,235,公司24,1983
52,124,1014,公司25,1983
107,117,833,公司26,1983
36,103,1088,公司27,1983
59,110,652,公司28,1983
79,46,251,公司29,1983
78,112,585,公司30,1983
121,103,1040,公司31,1983
54,58,731,公司32,1983
116,76,944,公司33,1983
93,59,1036,公司34,1983
20,65,752,公司35,1983
112,73,979,公司36,1983
66,87,621,公司37,1983
101,41,1007,公司38,1983
112,58,520,公司39,1983
119,72,715,公司40,1983
48,119,1086,公司41,1983
79,85,904,公司42,1983
60,96,145,公司43,1983
96,108,772,公司44,1983
149,122,970,公司45,1983
69,37,431,公司46,1983
61,123,421,公司47,1983
45,68,110,公司48,1983
137,86,1347,公司49,1983
64,45,627,公司0,1984
33,85,541,公司1,1984
74,13,733,公司2,1984
114,115,1042,公司3,1984
39,103,835,公司4,1984
68,39,779,公司5,1984
68,111,1026,公司6,1984
121,108,902,公司7,1984
30,21,214,公司8,1984
27,137,1137,公司9,1984
100,35,1099,公司10,1984
96,22,659,公司11,1984
131,126,659,公司12,1984
65,115,703,公司13,1984
41,109,733,公司14,1984
98,96,818,公司15,1984
88,86,233,公司16,1984
100,108,400,公司17,1984
71,78,301,公司18,1984
76,106,768,公司19,1984
109,80,1009,公司20,1984
81,94,844,公司21,1984
93,96,459,公司22,1984
41,91,412,公司23,1984
116,27,240,公司24,1984
53,126,1053,公司25,1984
109,120,873,公司26,1984
36,106,1076,公司27,1984
62,111,686,公司28,1984
81,47,249,公司29,1984
77,112,585,公司30,1984
120,106,1003,公司31,1984
57,58,687,公司32,1984
119,75,965,公司33,1984
95,62,1066,公司34,1984
22,66,735,公司35,1984
113,74,1026,公司36,1984
69,89,595,公司37,1984
101,41,999,公司38,1984
112,61,510,公司39,1984
121,74,732,公司40,1984
49,118,1066,公司41,1984
78,87,859,公司42,1984
61,100,143,公司43,1984
98,108,825,公司44,1984
153,123,1016,公司45,1984
72,40,439,公司46,1984
61,126,398,公司47,1984
49,68,144,公司48,1984
136,87,1326,公司49,1984
63,47,672,公司0,1985
31,87,570,公司1,1985
76,12,759,公司2,1985
116,118,1049,公司3,1985
39,104,807,公司4,1985
67,39,790,公司5,1985
69,109,1033,公司6,1985
122,108,945,公司7,1985
31,21,210,公司8,1985
26,136,1172,公司9,1985
100,33,1070,公司10,1985
96,21,686,公司11,1985
133,127,654,公司12,1985
64,117,754,公司13,1985
41,109,698,公司14,1985
99,97,849,公司15,1985
91,88,252,公司16,1985
101,110,381,公司17,1985
70,79,352,公司18,1985
76,108,756,公司19,1985
108,80,965,公司20,1985
81,94,805,公司21,1985
92,99,485,公司22,1985
43,92,396,公司23,1985
115,30,294,公司24,1985
54,125,1077,公司25,1985
108,122,893,公司26,1985
36,106,1070,公司27,1985
63,111,684,公司28,1985
80,46,288,公司29,1985
80,115,551,公司30,1985
121,105,1007,公司31,1985
56,58,701,公司32,1985
121,75,979,公司33,1985
96,61,1116,公司34,1985
22,67,770,公司35,1985
114,78,1018,公司36,1985
68,90,622,公司37,1985
102,41,1014,公司38,1985
115,64,479,公司39,1985
125,73,709,公司40,1985
50,117,1078,公司41,1985
78,89,899,公司42,1985
63,101,143,公司43,1985
100,108,799,公司44,1985
157,125,1046,公司45,1985
72,41,445,公司46,1985
60,126,433,公司47,1985
49,72,188,公司48,1985
136,89,1374,公司49,1985
62,46,664,公司0,1986
32,90,534,公司1,1986
75,11,772,公司2,1986
118,120,1047,公司3,1986
41,104,774,公司4,1986
67,41,826,公司5,1986
70,110,1075,公司6,1986
123,106,914,公司7,1986
31,23,251,公司8,1986
25,135,1129,公司9,1986
100,32,1093,公司10,1986
99,20,708,公司11,1986
135,126,708,公司12,1986
65,118,777,公司13,1986
41,109,736,公司14,1986
102,98,866,公司15,1986
92,89,230,公司16,1986
102,109,358,公司17,1986
73,79,382,公司18,1986
77,108,734,公司19,1986
107,79,993,公司20,1986
83,96,805,公司21,1986
94,99,512,公司22,1986
46,93,407,公司23,1986
116,29,255,公司24,1986
57,128,1106,公司25,1986
107,122,872,公司26,1986
38,109,1110,公司27,1986
62,113,713,公司28,1986
82,47,292,公司29,1986
81,116,521,公司30,1986
124,106,990,公司31,1986
58,60,729,公司32,1986
123,76,967,公司33,1986
97,62,1109,公司34,1986
26,66,765,公司35,1986
113,80,1005,公司36,1986
71,93,594,公司37,1986
105,43,1012,公司38,1986
114,67,485,公司39,1986
124,75,751,公司40,1986
49,118,1072,公司41,1986
82,90,952,公司42,1986
63,101,110,公司43,1986
101,109,787,公司44,1986
161,125,1045,公司45,1986
72,41,426,公司46,1986
63,126,451,公司47,1986
51,71,172,公司48,1986
138,90,1413,公司49,1986
64,47,683,公司0,1987
34,91,576,公司1,1987
74,14,755,公司2,1987
121,118,1063,公司3,1987
43,103,793,公司4,1987
65,43,875,公司5,1987
70,108,1076,公司6,1987
124,108,966,公司7,1987
33,25,225,公司8,1987
25,138,1095,公司9,1987
101,32,1092,公司10,1987
102,20,703,公司11,1987
134,127,720,公司12,1987
67,121,812,公司13,1987
42,112,756,公司14,1987
101,100,855,公司15,1987
95,89,223,公司16,1987
104,109,406,公司17,1987
72,79,392,公司18,1987
80,107,781,公司19,1987
110,79,1000,公司20,1987
86,99,779,公司21,1987
94,99,564,公司22,1987
49,93,397,公司23,1987
116,32,236,公司24,1987
60,128,1080,公司25,1987
109,121,882,公司26,1987
39,108,1084,公司27,1987
65,116,728,公司28,1987
81,48,299,公司29,1987
83,119,536,公司30,1987
125,108,991,公司31,1987
61,61,745,公司32,1987
122,77,1018,公司33,1987
100,63,1101,公司34,1987
26,65,723,公司35,1987
113,81,970,公司36,1987
72,95,597,公司37,1987
105,44,996,公司38,1987
116,70,450,公司39,1987
128,75,778,公司40,1987
51,118,1089,公司41,1987
84,89,949,公司42,1987
62,104,144,公司43,1987
102,109,787,公司44,1987
161,129,1023,公司45,1987
76,43,402,公司46,1987
65,130,479,公司47,1987
51,72,138,公司48,1987
138,92,1384,公司49,1987
65,46,708,公司0,1988
34,91,552,公司1,1988
75,16,750,公司2,1988
120,116,1093,公司3,1988
45,101,789,公司4,1988
68,46,832,公司5,1988
70,111,1077,公司6,1988
122,109,956,公司7,1988
35,27,252,公司8,1988
28,141,1108,公司9,1988
104,32,1083,公司10,1988
102,19,731,公司11,1988
134,129,702,公司12,1988
69,123,858,公司13,1988
41,111,749,公司14,1988
99,100,876,公司15,1988
98,89,253,公司16,1988
104,109,456,公司17,1988
74,80,411,公司18,1988
81,110,778,公司19,1988
112,82,1044,公司20,1988
86,98,819,公司21,1988
96,101,527,公司22,1988
49,93,354,公司23,1988
116,32,211,公司24,1988
60,127,1058,公司25,1988
109,123,839,公司26,1988
40,112,1095,公司27,1988
66,118,698,公司28,1988
81,49,287,公司29,1988
84,121,589,公司30,1988
129,111,961,公司31,1988
62,61,749,公司32,1988
125,76,1050,公司33,1988
102,65,1134,公司34,1988
28,65,745,公司35,1988
112,84,1003,公司36,1988
71,96,560,公司37,1988
106,44,1030,公司38,1988
118,72,429,公司39,1988
131,79,756,公司40,1988
54,120,1137,公司41,1988
85,88,933,公司42,1988
66,105,161,公司43,1988
104,111,821,公司44,1988
163,132,1066,公司45,1988
80,43,376,公司46,1988
68,129,448,公司47,1988
51,73,191,公司48,1988
137,96,1346,公司49,1988
68,49,725,公司0,1989
37,92,568,公司1,1989
76,18,802,公司2,1989
121,115,1099,公司3,1989
47,101,810,公司4,1989
68,45,862,公司5,1989
69,112,1131,公司6,1989
123,108,958,公司7,1989
34,29,289,公司8,1989
27,144,1129,公司9,1989
106,33,1055,公司10,1989
102,20,712,公司11,1989
133,127,673,公司12,1989
69,126,821,公司13,1989
41,113,797,公司14,1989
98,100,835,公司15,1989
97,90,295,公司16,1989
107,110,452,公司17,1989
74,82,385,公司18,1989
84,109,769,公司19,1989
115,85,1060,公司20,1989
86,99,806,公司21,1989
96,101,512,公司22,1989
49,95,343,公司23,1989
118,33,238,公司24,1989
60,130,1034,公司25,1989
109,122,888,公司26,1989
42,113,1091,公司27,1989
69,118,733,公司28,1989
82,52,314,公司29,1989
88,121,557,公司30,1989
129,114,1003,公司31,1989
64,64,801,公司32,1989
126,76,1078,公司33,1989
106,65,1137,公司34,1989
27,68,786,公司35,1989
115,84,993,公司36,1989
73,96,526,公司37,1989
106,45,1020,公司38,1989
121,74,404,公司39,1989
132,79,795,公司40,1989
56,122,1101,公司41,1989
88,90,979,公司42,1989
68,107,136,公司43,1989
107,114,828,公司44,1989
167,132,1062,公司45,1989
79,44,409,公司46,1989
71,130,417,公司47,1989
51,74,242,公司48,1989
137,95,1367,公司49,1989
67,47,777,公司0,1990
39,94,612,公司1,1990
78,19,830,公司2,1990
122,116,1110,公司3,1990
48,102,865,公司4,1990
67,45,825,公司5,1990
70,115,1170,公司6,1990
124,109,972,公司7,1990
33,31,321,公司8,1990
30,146,1132,公司9,1990
107,33,1023,公司10,1990
101,18,758,公司11,1990
133,130,710,公司12,1990
71,126,820,公司13,1990
43,114,828,公司14,1990
98,103,869,公司15,1990
100,93,295,公司16,1990
108,109,476,公司17,1990
73,82,344,公司18,1990
84,110,815,公司19,1990
118,86,1065,公司20,1990
89,102,811,公司21,1990
97,101,473,公司22,1990
51,94,392,公司23,1990
121,34,244,公司24,1990
60,132,1050,公司25,1990
110,124,915,公司26,1990
45,113,1117,公司27,1990
71,119,735,公司28,1990
81,52,303,公司29,1990
90,124,547,公司30,1990
129,114,964,公司31,1990
66,66,840,公司32,1990
127,79,1124,公司33,1990
108,66,1108,公司34,1990
27,68,747,公司35,1990
114,85,1047,公司36,1990
72,97,578,公司37,1990
106,47,1059,公司38,1990
120,77,429,公司39,1990
132,78,790,公司40,1990
59,124,1061,公司41,1990
89,91,1033,公司42,1990
71,108,172,公司43,1990
106,114,836,公司44,1990
169,136,1030,公司45,1990
79,43,407,公司46,1990
74,133,463,公司47,1990
55,77,293,公司48,1990
136,97,1360,公司49,1990
70,47,768,公司0,1991
42,95,594,公司1,1991
79,19,872,公司2,1991
124,117,1161,公司3,1991
49,102,822,公司4,1991
69,48,810,公司5,1991
69,115,1220,公司6,1991
122,112,954,公司7,1991
34,32,319,公司8,1991
31,145,1112,公司9,1991
106,35,980,公司10,1991
100,16,783,公司11,1991
135,128,748,公司12,1991
73,128,805,公司13,1991
44,114,849,公司14,1991
100,103,863,公司15,1991
103,91,253,公司16,1991
106,110,460,公司17,1991
73,81,331,公司18,1991
86,109,771,公司19,1991
119,85,1095,公司20,1991
92,104,866,公司21,1991
96,104,495,公司22,1991
50,94,398,公司23,1991
123,33,252,公司24,1991
61,132,1015,公司25,1991
109,123,917,公司26,1991
48,112,1096,公司27,1991
73,121,700,公司28,1991
82,54,311,公司29,1991
90,127,534,公司30,1991
130,114,995,公司31,1991
69,69,819,公司32,1991
130,80,1114,公司33,1991
107,67,1117,公司34,1991
30,69,716,公司35,1991
116,86,1098,公司36,1991
75,100,615,公司37,1991
108,46,1103,公司38,1991
122,81,407,公司39,1991
132,80,764,公司40,1991
61,124,1096,公司41,1991
92,91,1032,公司42,1991
73,109,178,公司43,1991
106,118,880,公司44,1991
169,135,1021,公司45,1991
78,43,375,公司46,1991
78,136,474,公司47,1991
56,81,333,公司48,1991
138,98,1342,公司49,1991
72,48,781,公司0,1992
41,97,640,公司1,1992
80,19,849,公司2,1992
123,118,1145,公司3,1992
50,100,847,公司4,1992
68,49,783,公司5,1992
72,114,1220,公司6,1992
125,112,967,公司7,1992
33,31,336,公司8,1992
34,143,1079,公司9,1992
105,36,1007,公司10,1992
102,17,783,公司11,1992
134,129,732,公司12,1992
71,131,825,公司13,1992
45,116,867,公司14,1992
99,106,891,公司15,1992
104,92,303,公司16,1992
109,112,459,公司17,1992
73,79,313,公司18,1992
87,109,745,公司19,1992
120,87,1110,公司20,1992
91,107,884,公司21,1992
99,103,487,公司22,1992
53,97,379,公司23,1992
123,33,265,公司24,1992
60,131,1004,公司25,1992
111,124,926,公司26,1992
51,113,1058,公司27,1992
74,123,724,公司28,1992
83,53,323,公司29,1992
93,127,542,公司30,1992
133,115,1001,公司31,1992
68,68,776,公司32,1992
132,80,1113,公司33,1992
106,69,1126,公司34,1992
33,71,746,公司35,1992
116,89,1078,公司36,1992
78,101,651,公司37,1992
107,46,1063,公司38,1992
121,82,372,公司39,1992
133,81,760,公司40,1992
60,125,1115,公司41,1992
94,93,1045,公司42,1992
72,110,226,公司43,1992
109,117,849,公司44,1992
169,138,1047,公司45,1992
77,43,430,公司46,1992
78,136,464,公司47,1992
55,83,336,公司48,1992
141,98,1375,公司49,1992
75,49,799,公司0,1993
42,96,661,公司1,1993
83,19,813,公司2,1993
125,120,1199,公司3,1993
50,101,857,公司4,1993
71,50,769,公司5,1993
74,112,1178,公司6,1993
124,112,1004,公司7,1993
33,31,364,公司8,1993
34,144,1063,公司9,1993
106,39,1026,公司10,1993
100,16,785,公司11,1993
132,130,691,公司12,1993
71,129,874,公司13,1993
47,117,908,公司14,1993
101,105,898,公司15,1993
104,93,334,公司16,1993
112,112,463,公司17,1993
75,82,301,公司18,1993
87,109,767,公司19,1993
121,89,1136,公司20,1993
93,105,860,公司21,1993
102,103,479,公司22,1993
55,100,418,公司23,1993
124,36,308,公司24,1993
61,131,1009,公司25,1993
114,126,907,公司26,1993
54,114,1089,公司27,1993
77,126,690,公司28,1993
85,55,347,公司29,1993
96,127,511,公司30,1993
134,116,1019,公司31,1993
71,69,762,公司32,1993
134,80,1128,公司33,1993
107,70,1142,公司34,1993
36,74,720,公司35,1993
115,92,1132,公司36,1993
78,104,632,公司37,1993
108,49,1096,公司38,1993
124,84,338,公司39,1993
135,82,767,公司40,1993
61,128,1170,公司41,1993
93,93,1043,公司42,1993
76,109,207,公司43,1993
112,119,873,公司44,1993
169,141,1049,公司45,1993
78,43,484,公司46,1993
82,138,513,公司47,1993
58,86,316,公司48,1993
142,100,1373,公司49,1993
73,47,836,公司0,1994
43,99,673,公司1,1994
84,20,804,公司2,1994
126,119,1235,公司3,1994
52,101,835,公司4,1994
70,50,814,公司5,1994
74,112,1224,公司6,1994
125,113,1033,公司7,1994
35,34,395,公司8,1994
34,143,1066,公司9,1994
105,39,1025,公司10,1994
101,16,766,公司11,1994
132,131,714,公司12,1994
71,131,899,公司13,1994
47,119,944,公司14,1994
103,106,877,公司15,1994
105,95,319,公司16,1994
113,115,476,公司17,1994
77,84,270,公司18,1994
90,111,747,公司19,1994
124,89,1107,公司20,1994
92,105,858,公司21,1994
105,104,491,公司22,1994
57,102,460,公司23,1994
126,37,326,公司24,1994
60,133,1001,公司25,1994
113,128,887,公司26,1994
55,115,1046,公司27,1994
78,126,668,公司28,1994
86,54,372,公司29,1994
99,126,510,公司30,1994
135,119,994,公司31,1994
73,68,743,公司32,1994
136,83,1177,公司33,1994
107,72,1152,公司34,1994
38,77,765,公司35,1994
115,95,1143,公司36,1994
77,107,671,公司37,1994
107,50,1128,公司38,1994
128,86,375,公司39,1994
135,86,770,公司40,1994
61,127,1133,公司41,1994
95,96,1056,公司42,1994
76,109,218,公司43,1994
114,121,899,公司44,1994
168,144,1074,公司45,1994
78,43,464,公司46,1994
82,141,545,公司47,1994
59,86,322,公司48,1994
144,100,1357,公司49,1994
74,47,805,公司0,1995
42,102,700,公司1,1995
85,22,803,公司2,1995
124,119,1231,公司3,1995
53,103,821,公司4,1995
71,50,858,公司5,1995
75,112,1200,公司6,1995
127,114,1013,公司7,1995
36,34,375,公司8,1995
36,141,1103,公司9,1995
106,39,1073,公司10,1995
102,15,760,公司11,1995
131,132,749,公司12,1995
71,133,946,公司13,1995
47,119,992,公司14,1995
106,106,841,公司15,1995
108,96,365,公司16,1995
113,115,442,公司17,1995
80,85,287,公司18,1995
91,113,749,公司19,1995
125,90,1128,公司20,1995
91,106,860,公司21,1995
106,106,467,公司22,1995
59,102,472,公司23,1995
129,39,313,公司24,1995
61,132,961,公司25,1995
115,130,862,公司26,1995
57,115,1068,公司27,1995
79,125,624,公司28,1995
87,54,418,公司29,1995
98,129,505,公司30,1995
138,118,961,公司31,1995
76,67,719,公司32,1995
138,84,1163,公司33,1995
106,71,1149,公司34,1995
38,78,814,公司35,1995
115,98,1147,公司36,1995
78,108,697,公司37,1995
109,53,1117,公司38,1995
131,87,347,公司39,1995
136,89,780,公司40,1995
61,127,1151,公司41,1995
96,97,1012,公司42,1995
79,111,272,公司43,1995
115,124,909,公司44,1995
171,146,1122,公司45,1995
82,44,448,公司46,1995
84,141,521,公司47,1995
60,90,313,公司48,1995
146,102,1372,公司49,1995
75,47,818,公司0,1996
45,105,754,公司1,1996
86,23,793,公司2,1996
124,121,1245,公司3,1996
52,105,847,公司4,1996
70,49,885,公司5,1996
75,114,1199,公司6,1996
128,117,1037,公司7,1996
39,34,359,公司8,1996
36,144,1061,公司9,1996
105,41,1054,公司10,1996
102,15,799,公司11,1996
132,135,739,公司12,1996
70,132,917,公司13,1996
49,121,979,公司14,1996
106,107,866,公司15,1996
111,95,345,公司16,1996
112,116,423,公司17,1996
83,85,247,公司18,1996
91,113,800,公司19,1996
125,91,1130,公司20,1996
94,106,908,公司21,1996
108,105,480,公司22,1996
59,102,492,公司23,1996
131,41,335,公司24,1996
60,131,950,公司25,1996
116,129,874,公司26,1996
60,116,1118,公司27,1996
80,127,627,公司28,1996
91,53,431,公司29,1996
99,132,491,公司30,1996
137,121,955,公司31,1996
79,71,708,公司32,1996
139,84,1183,公司33,1996
109,71,1144,公司34,1996
40,79,823,公司35,1996
116,99,1142,公司36,1996
77,111,657,公司37,1996
113,52,1073,公司38,1996
135,86,375,公司39,1996
138,91,777,公司40,1996
62,128,1127,公司41,1996
96,100,1024,公司42,1996
78,114,268,公司43,1996
114,124,880,公司44,1996
170,148,1103,公司45,1996
85,46,436,公司46,1996
87,144,553,公司47,1996
59,89,331,公司48,1996
147,102,1376,公司49,1996
76,48,804,公司0,1997
44,106,733,公司1,1997
88,22,763,公司2,1997
127,124,1220,公司3,1997
53,104,850,公司4,1997
69,52,840,公司5,1997
77,114,1164,公司6,1997
127,118,1018,公司7,1997
41,32,315,公司8,1997
35,143,1070,公司9,1997
107,42,1076,公司10,1997
103,16,851,公司11,1997
134,137,719,公司12,1997
71,134,916,公司13,1997
50,124,984,公司14,1997
109,106,848,公司15,1997
113,93,345,公司16,1997
115,119,476,公司17,1997
83,85,220,公司18,1997
93,112,855,公司19,1997
125,90,1142,公司20,1997
94,109,883,公司21,1997
108,108,501,公司22,1997
62,101,470,公司23,1997
130,44,337,公司24,1997
60,134,924,公司25,1997
115,132,830,公司26,1997
61,115,1097,公司27,1997
81,128,629,公司28,1997
92,56,477,公司29,1997
102,131,488,公司30,1997
138,120,973,公司31,1997
81,71,679,公司32,1997
138,87,1165,公司33,1997
110,73,1195,公司34,1997
39,82,818,公司35,1997
115,102,1197,公司36,1997
77,113,660,公司37,1997
114,56,1048,公司38,1997
139,87,335,公司39,1997
141,90,761,公司40,1997
61,127,1093,公司41,1997
96,102,1004,公司42,1997
77,117,302,公司43,1997
113,127,919,公司44,1997
171,147,1095,公司45,1997
87,47,439,公司46,1997
88,146,573,公司47,1997
63,89,301,公司48,1997
147,106,1395,公司49,1997
79,49,790,公司0,1998
44,106,738,公司1,1998
86,25,768,公司2,1998
126,123,1267,公司3,1998
53,103,810,公司4,1998
69,53,804,公司5,1998
78,116,1180,公司6,1998
127,118,984,公司7,1998
40,32,285,公司8,1998
36,144,1077,公司9,1998
108,45,1040,公司10,1998
106,17,897,公司11,1998
136,139,716,公司12,1998
73,134,920,公司13,1998
50,125,989,公司14,1998
108,107,806,公司15,1998
114,94,386,公司16,1998
114,119,495,公司17,1998
86,85,246,公司18,1998
92,113,834,公司19,1998
127,92,1138,公司20,1998
96,108,900,公司21,1998
110,108,464,公司22,1998
64,101,474,公司23,1998
130,44,310,公司24,1998
62,137,935,公司25,1998
115,135,874,公司26,1998
64,118,1125,公司27,1998
81,129,599,公司28,1998
93,56,529,公司29,1998
105,133,532,公司30,1998
139,119,928,公司31,1998
82,73,732,公司32,1998
137,90,1205,公司33,1998
112,76,1168,公司34,1998
40,83,845,公司35,1998
117,102,1180,公司36,1998
80,113,661,公司37,1998
113,58,1050,公司38,1998
142,88,325,公司39,1998
141,91,802,公司40,1998
62,128,1126,公司41,1998
98,104,972,公司42,1998
77,117,324,公司43,1998
113,127,952,公司44,1998
172,148,1113,公司45,1998
87,48,396,公司46,1998
87,148,574,公司47,1998
62,90,328,公司48,1998
149,110,1423,公司49,1998
79,50,748,公司0,1999
45,106,759,公司1,1999
88,27,763,公司2,1999
124,122,1296,公司3,1999
52,102,805,公司4,1999
68,52,765,公司5,1999
78,118,1215,公司6,1999
128,119,980,公司7,1999
40,31,244,公司8,1999
39,143,1061,公司9,1999
110,46,1060,公司10,1999
106,20,926,公司11,1999
137,141,691,公司12,1999
75,133,935,公司13,1999
50,126,954,公司14,1999
107,108,793,公司15,1999
117,95,376,公司16,1999
114,122,451,公司17,1999
89,87,245,公司18,1999
94,116,827,公司19,1999
126,94,1161,公司20,1999
97,110,869,公司21,1999
110,109,429,公司22,1999
67,104,474,公司23,1999
132,45,275,公司24,1999
61,139,939,公司25,1999
114,138,928,公司26,1999
67,120,1106,公司27,1999
80,130,627,公司28,1999
93,55,486,公司29,1999
109,134,526,公司30,1999
139,121,927,公司31,1999
81,75,710,公司32,1999
140,91,1173,公司33,1999
114,75,1123,公司34,1999
43,86,874,公司35,1999
119,105,1213,公司36,1999
82,115,709,公司37,1999
115,57,1023,公司38,1999
143,92,281,公司39,1999
144,91,796,公司40,1999
61,128,1136,公司41,1999
101,106,1026,公司42,1999
78,116,375,公司43,1999
115,130,990,公司44,1999
172,151,1161,公司45,1999
89,49,414,公司46,1999
88,147,550,公司47,1999
64,90,352,公司48,1999
152,112,1464,公司49,1999
79,50,741,公司0,2000
44,105,809,公司1,2000
89,27,812,公司2,2000
127,120,1329,公司3,2000
54,102,831,公司4,2000
70,55,775,公司5,2000
80,118,1222,公司6,2000
130,121,995,公司7,2000
39,33,259,公司8,2000
39,143,1114,公司9,2000
112,46,1016,公司10,2000
108,23,956,公司11,2000
139,141,710,公司12,2000
76,136,955,公司13,2000
49,129,1008,公司14,2000
109,108,750,公司15,2000
117,98,358,公司16,2000
114,123,423,公司17,2000
90,87,215,公司18,2000
94,119,875,公司19,2000
126,96,1205,公司20,2000
100,113,923,公司21,2000
111,109,421,公司22,2000
68,106,446,公司23,2000
131,45,237,公司24,2000
62,141,924,公司25,2000
117,138,905,公司26,2000
68,121,1088,公司27,2000
80,130,612,公司28,2000
93,54,522,公司29,2000
109,135,498,公司30,2000
142,124,897,公司31,2000
83,75,670,公司32,2000
141,91,1224,公司33,2000
115,78,1142,公司34,2000
47,88,864,公司35,2000
120,107,1249,公司36,2000
82,117,704,公司37,2000
116,57,1074,公司38,2000
144,95,314,公司39,2000
143,90,751,公司40,2000
61,130,1155,公司41,2000
102,109,1065,公司42,2000
79,115,418,公司43,2000
116,131,952,公司44,2000
172,151,1200,公司45,2000
92,49,440,公司46,2000
88,151,581,公司47,2000
68,94,393,公司48,2000
154,114,1470,公司49,2000
79,52,733,公司0,2001
44,105,834,公司1,2001
89,29,866,公司2,2001
128,119,1374,公司3,2001
53,104,835,公司4,2001
69,57,784,公司5,2001
79,119,1209,公司6,2001
131,120,1010,公司7,2001
40,32,297,公司8,2001
37,143,1155,公司9,2001
112,48,1062,公司10,2001
109,22,1002,公司11,2001
141,142,751,公司12,2001
77,136,960,公司13,2001
51,128,983,公司14,2001
112,110,734,公司15,2001
117,100,403,公司16,2001
115,122,387,公司17,2001
91,89,208,公司18,2001
95,122,871,公司19,2001
128,97,1162,公司20,2001
101,114,901,公司21,2001
110,108,422,公司22,2001
70,109,475,公司23,2001
133,44,217,公司24,2001
64,140,946,公司25,2001
119,139,883,公司26,2001
71,124,1071,公司27,2001
79,133,580,公司28,2001
95,54,479,公司29,2001
109,139,527,公司30,2001
142,124,929,公司31,2001
85,77,658,公司32,2001
143,93,1228,公司33,2001
116,80,1178,公司34,2001
50,91,881,公司35,2001
121,110,1280,公司36,2001
81,120,691,公司37,2001
120,60,1036,公司38,2001
146,97,325,公司39,2001
142,90,790,公司40,2001
62,130,1166,公司41,2001
105,110,1097,公司42,2001
81,116,386,公司43,2001
117,133,1007,公司44,2001
171,152,1182,公司45,2001
92,49,487,公司46,2001
88,151,605,公司47,2001
68,98,426,公司48,2001
158,116,1437,公司49,2001
80,53,775,公司0,2002
43,106,802,公司1,2002
87,31,899,公司2,2002
127,121,1406,公司3,2002
54,102,813,公司4,2002
72,55,741,公司5,2002
80,119,1210,公司6,2002
130,119,1006,公司7,2002
38,32,345,公司8,2002
35,145,1142,公司9,2002
111,51,1042,公司10,2002
112,24,1014,公司11,2002
141,143,710,公司12,2002
78,136,963,公司13,2002
50,131,1003,公司14,2002
114,109,767,公司15,2002
118,99,366,公司16,2002
116,121,409,公司17,2002
89,90,175,公司18,2002
94,125,894,公司19,2002
131,100,1208,公司20,2002
102,113,882,公司21,2002
112,111,448,公司22,2002
69,111,495,公司23,2002
132,44,219,公司24,2002
64,141,973,公司25,2002
119,139,879,公司26,2002
73,126,1068,公司27,2002
82,136,542,公司28,2002
97,53,513,公司29,2002
110,139,512,公司30,2002
144,126,952,公司31,2002
87,76,699,公司32,2002
144,92,1271,公司33,2002
119,83,1211,公司34,2002
52,92,849,公司35,2002
124,109,1262,公司36,2002
81,121,677,公司37,2002
119,63,1031,公司38,2002
149,100,372,公司39,2002
143,93,805,公司40,2002
64,131,1181,公司41,2002
105,110,1056,公司42,2002
84,115,420,公司43,2002
117,133,1020,公司44,2002
174,152,1156,公司45,2002
94,52,445,公司46,2002
91,155,562,公司47,2002
70,100,429,公司48,2002
159,118,1398,公司49,2002
80,56,747,公司0,2003
43,108,855,公司1,2003
90,34,917,公司2,2003
130,120,1413,公司3,2003
53,101,806,公司4,2003
72,54,742,公司5,2003
79,118,1256,公司6,2003
128,118,1029,公司7,2003
38,33,388,公司8,2003
36,146,1155,公司9,2003
110,52,999,公司10,2003
111,26,974,公司11,2003
143,143,675,公司12,2003
77,139,970,公司13,2003
51,131,1050,公司14,2003
117,110,790,公司15,2003
118,101,381,公司16,2003
119,120,439,公司17,2003
91,90,199,公司18,2003
96,128,928,公司19,2003
134,101,1210,公司20,2003
103,114,936,公司21,2003
111,110,473,公司22,2003
70,111,501,公司23,2003
132,47,192,公司24,2003
63,141,991,公司25,2003
122,138,839,公司26,2003
76,127,1119,公司27,2003
84,136,529,公司28,2003
97,52,488,公司29,2003
112,141,559,公司30,2003
147,128,982,公司31,2003
89,79,671,公司32,2003
147,92,1244,公司33,2003
122,84,1178,公司34,2003
52,92,855,公司35,2003
123,113,1273,公司36,2003
80,121,666,公司37,2003
118,64,1008,公司38,2003
150,101,413,公司39,2003
144,97,837,公司40,2003
66,131,1184,公司41,2003
109,113,1042,公司42,2003
84,117,465,公司43,2003
116,133,1038,公司44,2003
175,153,1139,公司45,2003
98,55,484,公司46,2003
95,158,551,公司47,2003
74,102,431,公司48,2003
160,120,1408,公司49,2003
82,56,780,公司0,2004
46,109,885,公司1,2004
88,35,916,公司2,2004
129,123,1443,公司3,2004
52,102,827,公司4,2004
71,54,728,公司5,2004
80,119,1226,公司6,2004
130,121,1028,公司7,2004
37,33,416,公司8,2004
36,145,1210,公司9,2004
110,53,1047,公司10,2004
110,27,929,公司11,2004
143,142,654,公司12,2004
78,138,1011,公司13,2004
50,130,1053,公司14,2004
117,110,833,公司15,2004
118,102,418,公司16,2004
119,122,460,公司17,2004
91,91,228,公司18,2004
98,131,890,公司19,2004
137,103,1223,公司20,2004
105,117,907,公司21,2004
113,109,523,公司22,2004
70,112,522,公司23,2004
132,47,243,公司24,2004
66,144,971,公司25,2004
123,140,846,公司26,2004
79,128,1152,公司27,2004
87,137,583,公司28,2004
97,52,473,公司29,2004
112,142,572,公司30,2004
147,131,1006,公司31,2004
88,81,674,公司32,2004
150,92,1250,公司33,2004
125,85,1183,公司34,2004
53,94,821,公司35,2004
124,113,1233,公司36,2004
81,123,643,公司37,2004
119,64,1033,公司38,2004
150,100,436,公司39,2004
144,100,831,公司40,2004
67,134,1226,公司41,2004
108,113,1058,公司42,2004
86,118,452,公司43,2004
118,137,997,公司44,2004
175,155,1168,公司45,2004
100,57,536,公司46,2004
96,161,532,公司47,2004
76,103,441,公司48,2004
163,123,1373,公司49,2004
83,58,809,公司0,2005
47,108,860,公司1,2005
89,36,934,公司2,2005
127,123,1466,公司3,2005
52,104,843,公司4,2005
70,52,700,公司5,2005
80,119,1241,公司6,2005
132,123,1059,公司7,2005
40,33,405,公司8,2005
36,146,1204,公司9,2005
112,52,1036,公司10,2005
109,26,921,公司11,2005
145,142,674,公司12,2005
79,139,992,公司13,2005
52,132,1077,公司14,2005
116,113,843,公司15,2005
118,103,424,公司16,2005
117,122,432,公司17,2005
92,92,255,公司18,2005
99,131,902,公司19,2005
139,105,1186,公司20,2005
105,116,935,公司21,2005
115,108,563,公司22,2005
72,114,538,公司23,2005
135,46,269,公司24,2005
69,144,976,公司25,2005
124,141,882,公司26,2005
80,128,1201,公司27,2005
90,136,596,公司28,2005
100,53,495,公司29,2005
114,141,617,公司30,2005
148,130,991,公司31,2005
91,83,704,公司32,2005
153,92,1217,公司33,2005
125,89,1173,公司34,2005
56,96,872,公司35,2005
124,113,1213,公司36,2005
82,122,664,公司37,2005
121,67,1000,公司38,2005
149,104,434,公司39,2005
144,99,840,公司40,2005
70,137,1201,公司41,2005
111,114,1022,公司42,2005
88,121,409,公司43,2005
119,141,993,公司44,2005
177,156,1126,公司45,2005
104,60,504,公司46,2005
95,160,499,公司47,2005
75,102,449,公司48,2005
162,126,1371,公司49,2005
86,61,845,公司0,2006
48,110,907,公司1,2006
88,36,907,公司2,2006
128,122,1447,公司3,2006
54,103,848,公司4,2006
73,51,718,公司5,2006
82,119,1264,公司6,2006
133,122,1070,公司7,2006
40,35,410,公司8,2006
35,147,1247,公司9,2006
112,53,1025,公司10,2006
109,27,923,公司11,2006
148,144,667,公司12,2006
79,140,971,公司13,2006
51,131,1065,公司14,2006
118,115,852,公司15,2006
120,101,472,公司16,2006
118,122,446,公司17,2006
95,92,227,公司18,2006
100,133,942,公司19,2006
142,104,1212,公司20,2006
106,117,938,公司21,2006
117,111,540,公司22,2006
72,117,552,公司23,2006
137,48,243,公司24,2006
69,144,965,公司25,2006
126,140,905,公司26,2006
81,130,1239,公司27,2006
89,138,571,公司28,2006
103,52,505,公司29,2006
113,144,671,公司30,2006
147,133,1025,公司31,2006
90,83,701,公司32,2006
154,94,1182,公司33,2006
127,92,1209,公司34,2006
55,95,912,公司35,2006
124,114,1184,公司36,2006
82,124,650,公司37,2006
121,70,1004,公司38,2006
149,106,461,公司39,2006
143,102,859,公司40,2006
71,139,1205,公司41,2006
111,115,1000,公司42,2006
88,120,376,公司43,2006
123,140,1016,公司44,2006
176,156,1088,公司45,2006
104,61,500,公司46,2006
98,162,544,公司47,2006
79,105,485,公司48,2006
165,126,1343,公司49,2006
86,60,891,公司0,2007
50,111,878,公司1,2007
88,39,883,公司2,2007
128,124,1469,公司3,2007
54,104,828,公司4,2007
73,50,768,公司5,2007
83,120,1288,公司6,2007
136,123,1034,公司7,2007
43,35,425,公司8,2007
35,148,1258,公司9,2007
113,54,1047,公司10,2007
108,26,948,公司11,2007
149,144,694,公司12,2007
77,142,1023,公司13,2007
52,134,1049,公司14,2007
117,116,859,公司15,2007
122,104,473,公司16,2007
120,124,407,公司17,2007
96,91,187,公司18,2007
103,135,951,公司19,2007
141,106,1189,公司20,2007
105,119,990,公司21,2007
116,110,582,公司22,2007
74,115,556,公司23,2007
138,50,279,公司24,2007
68,145,953,公司25,2007
127,142,876,公司26,2007
83,129,1236,公司27,2007
91,137,597,公司28,2007
106,55,471,公司29,2007
113,143,713,公司30,2007
149,132,997,公司31,2007
93,84,668,公司32,2007
153,96,1174,公司33,2007
126,95,1180,公司34,2007
57,97,872,公司35,2007
126,115,1191,公司36,2007
86,125,652,公司37,2007
124,72,992,公司38,2007
149,108,501,公司39,2007
144,105,887,公司40,2007
71,140,1246,公司41,2007
114,118,1005,公司42,2007
90,123,335,公司43,2007
123,142,1015,公司44,2007
179,157,1114,公司45,2007
103,65,476,公司46,2007
99,163,503,公司47,2007
80,106,508,公司48,2007
165,127,1300,公司49,2007
88,60,915,公司0,2008
51,114,933,公司1,2008
91,39,914,公司2,2008
127,126,1443,公司3,2008
56,103,858,公司4,2008
72,49,729,公司5,2008
83,123,1302,公司6,2008
137,123,1036,公司7,2008
44,34,424,公司8,2008
36,150,1261,公司9,2008
113,52,1092,公司10,2008
107,25,918,公司11,2008
150,143,700,公司12,2008
77,143,1007,公司13,2008
51,133,1099,公司14,2008
116,117,815,公司15,2008
120,103,496,公司16,2008
122,124,396,公司17,2008
95,93,181,公司18,2008
104,138,922,公司19,2008
140,106,1233,公司20,2008
105,120,975,公司21,2008
115,110,635,公司22,2008
76,115,552,公司23,2008
140,49,236,公司24,2008
68,145,986,公司25,2008
130,143,840,公司26,2008
85,130,1199,公司27,2008
90,139,575,公司28,2008
106,55,464,公司29,2008
115,142,683,公司30,2008
151,135,971,公司31,2008
95,83,627,公司32,2008
152,96,1202,公司33,2008
128,97,1147,公司34,2008
57,99,883,公司35,2008
126,118,1237,公司36,2008
89,124,687,公司37,2008
125,73,950,公司38,2008
152,110,555,公司39,2008
148,105,939,公司40,2008
71,140,1252,公司41,2008
117,121,1051,公司42,2008
94,122,328,公司43,2008
124,144,995,公司44,2008
179,160,1164,公司45,2008
106,68,458,公司46,2008
100,166,495,公司47,2008
82,108,475,公司48,2008
168,130,1316,公司49,2008
89,61,893,公司0,2009
53,114,913,公司1,2009
94,40,914,公司2,2009
128,125,1463,公司3,2009
58,101,847,公司4,2009
74,50,753,公司5,2009
82,123,1338,公司6,2009
138,125,994,公司7,2009
46,36,408,公司8,2009
37,151,1249,公司9,2009
113,51,1085,公司10,2009
106,25,901,公司11,2009
148,143,731,公司12,2009
76,146,1013,公司13,2009
54,131,1078,公司14,2009
115,116,785,公司15,2009
122,104,541,公司16,2009
123,122,372,公司17,2009
98,92,225,公司18,2009
105,140,945,公司19,2009
139,109,1236,公司20,2009
104,123,977,公司21,2009
118,111,683,公司22,2009
78,114,536,公司23,2009
143,52,228,公司24,2009
69,147,1003,公司25,2009
129,146,873,公司26,2009
85,133,1245,公司27,2009
90,140,611,公司28,2009
106,57,467,公司29,2009
115,141,681,公司30,2009
154,138,1024,公司31,2009
95,83,587,公司32,2009
152,99,1161,公司33,2009
129,97,1115,公司34,2009
58,99,932,公司35,2009
129,118,1223,公司36,2009
89,123,653,公司37,2009
128,77,907,公司38,2009
152,112,572,公司39,2009
149,108,985,公司40,2009
70,143,1284,公司41,2009
120,121,1104,公司42,2009
96,125,339,公司43,2009
125,145,966,公司44,2009
178,162,1122,公司45,2009
106,70,463,公司46,2009
104,168,515,公司47,2009
82,108,486,公司48,2009
171,130,1308,公司49,2009
90,59,890,公司0,2010
53,116,920,公司1,2010
93,39,902,公司2,2010
127,124,1505,公司3,2010
58,102,880,公司4,2010
73,51,710,公司5,2010
85,122,1309,公司6,2010
137,124,979,公司7,2010
47,37,390,公司8,2010
38,149,1271,公司9,2010
115,53,1053,公司10,2010
106,24,916,公司11,2010
150,142,744,公司12,2010
79,146,992,公司13,2010
57,131,1054,公司14,2010
114,115,780,公司15,2010
125,104,564,公司16,2010
126,121,389,公司17,2010
101,91,182,公司18,2010
107,143,978,公司19,2010
142,109,1236,公司20,2010
104,123,1021,公司21,2010
118,110,690,公司22,2010
78,116,534,公司23,2010
145,55,252,公司24,2010
72,149,1036,公司25,2010
131,149,926,公司26,2010
88,132,1257,公司27,2010
90,142,577,公司28,2010
108,57,423,公司29,2010
114,143,658,公司30,2010
155,141,1005,公司31,2010
98,82,558,公司32,2010
152,100,1150,公司33,2010
131,98,1075,公司34,2010
59,101,986,公司35,2010
130,119,1226,公司36,2010
89,126,668,公司37,2010
128,80,938,公司38,2010
153,115,592,公司39,2010
151,109,959,公司40,2010
71,147,1298,公司41,2010
123,121,1096,公司42,2010
95,125,392,公司43,2010
125,144,997,公司44,2010
180,166,1139,公司45,2010
107,74,429,公司46,2010
103,169,570,公司47,2010
85,110,507,公司48,2010
174,133,1310,公司49,2010
93,60,850,公司0,2011
54,117,928,公司1,2011
93,41,863,公司2,2011
128,125,1531,公司3,2011
58,103,887,公司4,2011
72,53,692,公司5,2011
87,124,1333,公司6,2011
139,123,966,公司7,2011
49,39,360,公司8,2011
41,148,1305,公司9,2011
114,53,1080,公司10,2011
108,25,876,公司11,2011
150,141,719,公司12,2011
81,147,977,公司13,2011
58,132,1009,公司14,2011
116,115,745,公司15,2011
124,105,578,公司16,2011
125,120,432,公司17,2011
103,92,182,公司18,2011
108,145,1032,公司19,2011
143,108,1197,公司20,2011
107,125,1059,公司21,2011
117,111,681,公司22,2011
79,118,517,公司23,2011
144,57,297,公司24,2011
71,150,1022,公司25,2011
130,152,931,公司26,2011
89,131,1251,公司27,2011
91,141,552,公司28,2011
109,56,444,公司29,2011
114,143,668,公司30,2011
154,142,1023,公司31,2011
98,85,579,公司32,2011
155,99,1148,公司33,2011
134,98,1049,公司34,2011
62,101,1016,公司35,2011
133,119,1269,公司36,2011
88,126,719,公司37,2011
128,79,906,公司38,2011
157,115,574,公司39,2011
151,112,997,公司40,2011
75,146,1278,公司41,2011
125,124,1096,公司42,2011
96,127,351,公司43,2011
129,147,971,公司44,2011
181,166,1161,公司45,2011
108,73,463,公司46,2011
103,170,527,公司47,2011
87,112,515,公司48,2011
173,135,1280,公司49,2011
96,58,872,公司0,2012
52,117,959,公司1,2012
92,41,862,公司2,2012
129,124,1505,公司3,2012
58,102,843,公司4,2012
70,55,747,公司5,2012
87,123,1295,公司6,2012
140,123,935,公司7,2012
50,40,360,公司8,2012
43,150,1274,公司9,2012
114,54,1053,公司10,2012
109,28,918,公司11,2012
150,142,710,公司12,2012
79,148,949,公司13,2012
59,133,990,公司14,2012
116,115,798,公司15,2012
126,107,567,公司16,2012
126,120,402,公司17,2012
105,92,149,公司18,2012
107,147,1002,公司19,2012
145,109,1192,公司20,2012
107,128,1046,公司21,2012
119,113,733,公司22,2012
81,119,492,公司23,2012
147,56,309,公司24,2012
73,152,1025,公司25,2012
129,153,892,公司26,2012
91,131,1236,公司27,2012
92,143,558,公司28,2012
112,59,478,公司29,2012
115,145,720,公司30,2012
154,142,984,公司31,2012
99,88,574,公司32,2012
155,101,1178,公司33,2012
137,100,1086,公司34,2012
63,102,973,公司35,2012
135,121,1240,公司36,2012
88,128,690,公司37,2012
127,81,925,公司38,2012
158,118,599,公司39,2012
153,115,986,公司40,2012
77,148,1314,公司41,2012
126,127,1102,公司42,2012
97,128,343,公司43,2012
128,150,947,公司44,2012
183,169,1188,公司45,2012
109,75,430,公司46,2012
105,171,573,公司47,2012
86,115,568,公司48,2012
174,136,1259,公司49,2012
95,60,919,公司0,2013
52,118,963,公司1,2013
91,43,864,公司2,2013
130,123,1544,公司3,2013
60,100,852,公司4,2013
73,56,775,公司5,2013
90,125,1323,公司6,2013
138,122,945,公司7,2013
53,42,356,公司8,2013
43,152,1294,公司9,2013
115,55,1047,公司10,2013
109,26,968,公司11,2013
152,141,676,公司12,2013
80,150,920,公司13,2013
58,132,1029,公司14,2013
116,114,823,公司15,2013
127,106,537,公司16,2013
125,122,427,公司17,2013
104,94,141,公司18,2013
110,150,1019,公司19,2013
144,110,1228,公司20,2013
110,127,1098,公司21,2013
118,114,784,公司22,2013
82,121,534,公司23,2013
148,59,278,公司24,2013
72,151,1040,公司25,2013
132,154,897,公司26,2013
90,133,1279,公司27,2013
95,142,564,公司28,2013
112,61,445,公司29,2013
114,148,696,公司30,2013
155,143,966,公司31,2013
100,88,621,公司32,2013
157,101,1174,公司33,2013
139,101,1139,公司34,2013
63,102,931,公司35,2013
134,125,1213,公司36,2013
88,129,713,公司37,2013
129,84,916,公司38,2013
161,119,557,公司39,2013
152,118,966,公司40,2013
79,147,1289,公司41,2013
127,128,1118,公司42,2013
100,128,337,公司43,2013
131,151,904,公司44,2013
185,171,1217,公司45,2013
110,75,406,公司46,2013
105,174,573,公司47,2013
87,115,621,公司48,2013
177,138,1295,公司49,2013
97,62,885,公司0,2014
54,120,946,公司1,2014
89,42,866,公司2,2014
129,126,1527,公司3,2014
61,101,855,公司4,2014
74,57,762,公司5,2014
89,125,1333,公司6,2014
138,121,906,公司7,2014
55,42,325,公司8,2014
44,153,1277,公司9,2014
114,55,1049,公司10,2014
112,26,998,公司11,2014
153,144,698,公司12,2014
82,148,959,公司13,2014
59,132,1011,公司14,2014
115,115,876,公司15,2014
127,107,540,公司16,2014
124,125,390,公司17,2014
104,97,151,公司18,2014
113,153,1020,公司19,2014
147,113,1280,公司20,2014
109,130,1150,公司21,2014
119,116,802,公司22,2014
84,123,563,公司23,2014
148,60,287,公司24,2014
72,150,1019,公司25,2014
132,155,911,公司26,2014
93,133,1291,公司27,2014
98,145,589,公司28,2014
112,63,401,公司29,2014
116,149,714,公司30,2014
157,142,991,公司31,2014
99,87,646,公司32,2014
158,104,1157,公司33,2014
142,104,1185,公司34,2014
66,101,944,公司35,2014
136,124,1177,公司36,2014
90,129,726,公司37,2014
129,83,957,公司38,2014
162,120,600,公司39,2014
152,120,923,公司40,2014
78,147,1339,公司41,2014
131,129,1107,公司42,2014
100,130,337,公司43,2014
135,152,878,公司44,2014
186,171,1254,公司45,2014
113,77,399,公司46,2014
106,174,592,公司47,2014
89,118,584,公司48,2014
180,138,1297,公司49,2014
99,63,893,公司0,2015
54,119,975,公司1,2015
87,43,840,公司2,2015
132,124,1574,公司3,2015
61,101,882,公司4,2015
73,55,746,公司5,2015
88,124,1318,公司6,2015
139,123,894,公司7,2015
54,45,340,公司8,2015
45,153,1293,公司9,2015
116,56,1019,公司10,2015
115,27,990,公司11,2015
156,145,709,公司12,2015
81,147,931,公司13,2015
61,133,990,公司14,2015
118,116,894,公司15,2015
129,106,562,公司16,2015
126,125,395,公司17,2015
104,96,166,公司18,2015
112,152,989,公司19,2015
149,115,1251,公司20,2015
109,131,1193,公司21,2015
119,117,758,公司22,2015
87,122,593,公司23,2015
150,62,267,公司24,2015
72,151,1015,公司25,2015
132,155,931,公司26,2015
92,133,1287,公司27,2015
101,147,583,公司28,2015
114,62,364,公司29,2015
117,152,716,公司30,2015
157,141,1022,公司31,2015
100,90,669,公司32,2015
158,106,1131,公司33,2015
143,103,1154,公司34,2015
69,103,972,公司35,2015
136,124,1203,公司36,2015
92,131,775,公司37,2015
130,83,951,公司38,2015
164,122,603,公司39,2015
156,123,967,公司40,2015
81,149,1319,公司41,2015
135,131,1160,公司42,2015
100,130,302,公司43,2015
135,155,845,公司44,2015
188,170,1281,公司45,2015
116,78,436,公司46,2015
106,173,603,公司47,2015
89,120,545,公司48,2015
181,139,1257,公司49,2015
98,62,927,公司0,2016
57,117,1012,公司1,2016
90,42,866,公司2,2016
132,124,1602,公司3,2016
61,103,841,公司4,2016
75,54,780,公司5,2016
87,125,1321,公司6,2016
139,124,862,公司7,2016
57,47,355,公司8,2016
47,155,1299,公司9,2016
119,58,983,公司10,2016
116,27,988,公司11,2016
157,145,745,公司12,2016
80,149,936,公司13,2016
62,132,1017,公司14,2016
119,119,892,公司15,2016
131,109,585,公司16,2016
125,127,408,公司17,2016
106,98,135,公司18,2016
112,153,945,公司19,2016
150,115,1218,公司20,2016
108,131,1235,公司21,2016
121,117,727,公司22,2016
89,124,645,公司23,2016
152,63,276,公司24,2016
73,154,1023,公司25,2016
132,155,937,公司26,2016
94,135,1279,公司27,2016
104,148,599,公司28,2016
117,65,396,公司29,2016
119,154,759,公司30,2016
157,142,993,公司31,2016
99,89,667,公司32,2016
161,109,1166,公司33,2016
142,104,1128,公司34,2016
73,102,984,公司35,2016
135,125,1227,公司36,2016
93,133,771,公司37,2016
133,82,997,公司38,2016
163,123,601,公司39,2016
158,126,1002,公司40,2016
81,150,1295,公司41,2016
137,131,1200,公司42,2016
103,133,305,公司43,2016
138,159,809,公司44,2016
189,169,1308,公司45,2016
118,81,434,公司46,2016
106,172,595,公司47,2016
89,122,588,公司48,2016
183,142,1255,公司49,2016
101,61,952,公司0,2017
57,117,987,公司1,2017
90,42,837,公司2,2017
134,126,1580,公司3,2017
61,101,816,公司4,2017
77,55,823,公司5,2017
86,127,1350,公司6,2017
141,123,866,公司7,2017
59,46,408,公司8,2017
50,158,1338,公司9,2017
119,60,1026,公司10,2017
115,28,1016,公司11,2017
157,145,797,公司12,2017
81,148,923,公司13,2017
61,135,1017,公司14,2017
120,119,864,公司15,2017
133,111,629,公司16,2017
124,129,443,公司17,2017
107,100,165,公司18,2017
112,154,949,公司19,2017
151,116,1254,公司20,2017
111,133,1248,公司21,2017
121,117,742,公司22,2017
89,125,663,公司23,2017
150,66,298,公司24,2017
75,154,1051,公司25,2017
135,154,960,公司26,2017
93,138,1258,公司27,2017
104,150,642,公司28,2017
119,64,352,公司29,2017
119,154,775,公司30,2017
157,143,1023,公司31,2017
100,90,641,公司32,2017
162,111,1217,公司33,2017
141,104,1115,公司34,2017
76,102,968,公司35,2017
138,124,1245,公司36,2017
96,135,758,公司37,2017
136,83,1028,公司38,2017
162,122,577,公司39,2017
160,127,1018,公司40,2017
83,153,1305,公司41,2017
140,135,1238,公司42,2017
102,137,303,公司43,2017
141,162,789,公司44,2017
188,173,1340,公司45,2017
121,84,408,公司46,2017
107,174,584,公司47,2017
91,123,579,公司48,2017
185,145,1240,公司49,2017
103,63,970,公司0,2018
55,117,1038,公司1,2018
88,42,875,公司2,2018
132,126,1631,公司3,2018
62,104,791,公司4,2018
79,56,809,公司5,2018
85,127,1366,公司6,2018
140,126,880,公司7,2018
60,48,381,公司8,2018
51,157,1298,公司9,2018
120,59,1075,公司10,2018
114,28,1016,公司11,2018
159,143,793,公司12,2018
84,146,882,公司13,2018
64,138,1033,公司14,2018
123,121,851,公司15,2018
135,112,614,公司16,2018
126,128,429,公司17,2018
106,101,138,公司18,2018
115,157,924,公司19,2018
151,118,1295,公司20,2018
114,135,1238,公司21,2018
120,120,763,公司22,2018
92,128,717,公司23,2018
151,67,282,公司24,2018
74,154,1044,公司25,2018
138,155,928,公司26,2018
95,139,1270,公司27,2018
107,153,672,公司28,2018
119,66,344,公司29,2018
121,157,734,公司30,2018
157,143,990,公司31,2018
101,89,614,公司32,2018
163,114,1239,公司33,2018
143,105,1166,公司34,2018
75,102,1015,公司35,2018
137,123,1277,公司36,2018
98,135,811,公司37,2018
135,86,991,公司38,2018
164,122,592,公司39,2018
159,128,1043,公司40,2018
82,156,1272,公司41,2018
139,136,1200,公司42,2018
102,139,309,公司43,2018
144,161,829,公司44,2018
187,176,1386,公司45,2018
121,85,384,公司46,2018
107,177,628,公司47,2018
94,124,581,公司48,2018
186,147,1236,公司49,2018
105,64,931,公司0,2019
55,117,1068,公司1,2019
87,43,912,公司2,2019
132,125,1637,公司3,2019
64,106,766,公司4,2019
82,55,857,公司5,2019
84,126,1411,公司6,2019
142,126,852,公司7,2019
62,49,405,公司8,2019
50,157,1267,公司9,2019
123,61,1056,公司10,2019
114,27,1028,公司11,2019
158,142,804,公司12,2019
84,149,924,公司13,2019
65,140,1007,公司14,2019
125,122,863,公司15,2019
137,113,665,公司16,2019
127,129,424,公司17,2019
108,101,113,公司18,2019
115,159,937,公司19,2019
150,120,1291,公司20,2019
115,137,1235,公司21,2019
119,119,770,公司22,2019
92,128,740,公司23,2019
150,66,270,公司24,2019
75,156,1096,公司25,2019
140,156,920,公司26,2019
97,138,1256,公司27,2019
109,154,689,公司28,2019
120,67,389,公司29,2019
122,160,764,公司30,2019
160,142,1034,公司31,2019
103,90,627,公司32,2019
163,116,1253,公司33,2019
143,104,1142,公司34,2019
78,105,1020,公司35,2019
141,122,1271,公司36,2019
99,135,859,公司37,2019
138,87,952,公司38,2019
164,121,555,公司39,2019
162,130,1081,公司40,2019
83,159,1229,公司41,2019
138,137,1211,公司42,2019
105,138,355,公司43,2019
147,160,788,公司44,2019
187,175,1438,公司45,2019
123,85,366,公司46,2019
110,181,646,公司47,2019
94,123,589,公司48,2019
186,146,1262,公司49,2019
107,65,910,公司0,2020
57,120,1094,公司1,2020
86,45,914,公司2,2020
133,123,1653,公司3,2020
66,106,818,公司4,2020
81,57,857,公司5,2020
86,126,1413,公司6,2020
142,129,829,公司7,2020
63,51,445,公司8,2020
49,157,1278,公司9,2020
124,61,1099,公司10,2020
115,27,999,公司11,2020
161,141,836,公司12,2020
83,147,892,公司13,2020
65,139,974,公司14,2020
126,121,889,公司15,2020
140,115,630,公司16,2020
130,132,458,公司17,2020
107,104,105,公司18,2020
117,159,949,公司19,2020
150,122,1319,公司20,2020
118,136,1284,公司21,2020
121,122,809,公司22,2020
93,129,746,公司23,2020
152,66,267,公司24,2020
74,156,1065,公司25,2020
139,156,928,公司26,2020
100,141,1286,公司27,2020
110,154,715,公司28,2020
119,67,383,公司29,2020
122,159,816,公司30,2020
161,143,1082,公司31,2020
105,92,661,公司32,2020
163,116,1222,公司33,2020
147,107,1106,公司34,2020
81,107,992,公司35,2020
144,123,1247,公司36,2020
98,138,861,公司37,2020
139,90,932,公司38,2020
164,124,513,公司39,2020
165,130,1105,公司40,2020
83,159,1192,公司41,2020
139,140,1178,公司42,2020
105,138,384,公司43,2020
148,161,793,公司44,2020
190,179,1464,公司45,2020
124,86,381,公司46,2020
111,182,629,公司47,2020
98,122,575,公司48,2020
188,145,1235,公司49,2020
106,66,941,公司0,2021
58,121,1117,公司1,2021
87,46,883,公司2,2021
133,125,1618,公司3,2021
69,108,852,公司4,2021
82,59,890,公司5,2021
84,128,1421,公司6,2021
141,130,788,公司7,2021
63,51,440,公司8,2021
49,159,1306,公司9,2021
123,63,1064,公司10,2021
117,27,1030,公司11,2021
160,144,842,公司12,2021
82,146,879,公司13,2021
67,138,986,公司14,2021
127,121,914,公司15,2021
140,117,587,公司16,2021
130,132,418,公司17,2021
105,104,132,公司18,2021
120,160,934,公司19,2021
153,121,1283,公司20,2021
119,139,1250,公司21,2021
120,124,846,公司22,2021
93,131,758,公司23,2021
151,66,259,公司24,2021
76,159,1057,公司25,2021
140,159,965,公司26,2021
103,140,1263,公司27,2021
110,156,759,公司28,2021
118,68,346,公司29,2021
123,162,834,公司30,2021
164,142,1129,公司31,2021
104,93,696,公司32,2021
162,116,1257,公司33,2021
150,109,1124,公司34,2021
81,106,971,公司35,2021
143,126,1235,公司36,2021
101,139,877,公司37,2021
139,90,930,公司38,2021
165,123,500,公司39,2021
167,130,1124,公司40,2021
83,162,1226,公司41,2021
138,140,1164,公司42,2021
108,138,429,公司43,2021
147,161,774,公司44,2021
192,180,1510,公司45,2021
125,89,381,公司46,2021
113,185,633,公司47,2021
102,122,626,公司48,2021
188,147,1222,公司49,2021
107,67,989,公司0,2022
56,120,1120,公司1,2022
87,48,865,公司2,2022
133,124,1611,公司3,2022
70,106,881,公司4,2022
81,60,894,公司5,2022
83,131,1399,公司6,2022
141,130,778,公司7,2022
64,51,411,公司8,2022
48,161,1339,公司9,2022
125,62,1054,公司10,2022
118,30,1056,公司11,2022
158,146,842,公司12,2022
80,149,901,公司13,2022
65,139,988,公司14,2022
130,121,958,公司15,2022
140,120,580,公司16,2022
133,134,436,公司17,2022
107,103,125,公司18,2022
118,162,898,公司19,2022
152,122,1284,公司20,2022
119,141,1211,公司21,2022
121,123,830,公司22,2022
95,131,730,公司23,2022
151,67,244,公司24,2022
75,162,1085,公司25,2022
142,158,998,公司26,2022
103,141,1290,公司27,2022
112,157,771,公司28,2022
120,69,327,公司29,2022
123,163,846,公司30,2022
167,143,1183,公司31,2022
105,96,664,公司32,2022
164,116,1281,公司33,2022
152,112,1124,公司34,2022
83,105,955,公司35,2022
143,130,1287,公司36,2022
105,142,869,公司37,2022
139,89,902,公司38,2022
167,126,496,公司39,2022
166,129,1112,公司40,2022
86,165,1245,公司41,2022
137,140,1197,公司42,2022
112,138,464,公司43,2022
150,164,731,公司44,2022
194,182,1557,公司45,2022
125,93,378,公司46,2022
114,187,649,公司47,2022
105,122,593,公司48,2022
192,148,1244,公司49,2022
106,69,1036,公司0,2023
59,119,1118,公司1,2023
89,49,822,公司2,2023
133,125,1594,公司3,2023
72,106,860,公司4,2023
81,60,858,公司5,2023
82,130,1395,公司6,2023
140,132,765,公司7,2023
66,51,387,公司8,2023
50,163,1392,公司9,2023
125,60,1086,公司10,2023
118,29,1052,公司11,2023
159,146,816,公司12,2023
83,147,945,公司13,2023
66,137,1036,公司14,2023
132,120,954,公司15,2023
141,122,607,公司16,2023
132,136,397,公司17,2023
107,105,109,公司18,2023
117,165,899,公司19,2023
151,122,1322,公司20,2023
120,143,1222,公司21,2023
121,126,833,公司22,2023
95,134,746,公司23,2023
152,70,287,公司24,2023
75,165,1106,公司25,2023
141,160,1019,公司26,2023
105,140,1274,公司27,2023
115,159,763,公司28,2023
121,68,363,公司29,2023
124,162,836,公司30,2023
166,144,1230,公司31,2023
105,96,715,公司32,2023
167,117,1329,公司33,2023
154,115,1172,公司34,2023
82,105,962,公司35,2023
144,131,1274,公司36,2023
107,144,869,公司37,2023
140,89,937,公司38,2023
167,129,542,公司39,2023
169,132,1136,公司40,2023
88,165,1232,公司41,2023
141,142,1217,公司42,2023
114,141,507,公司43,2023
154,168,740,公司44,2023
193,185,1528,公司45,2023
128,94,341,公司46,2023
114,191,652,公司47,2023
108,123,647,公司48,2023
192,147,1227,公司49,2023`,
  input: '使用动态散点图帮我展示各公司年度收益率、净现金流和市值逐年的变化。'
};

export const dynamicRoseData = {
  csv: `country,continent,GDP,year
美国,美洲,239270,1973
印度,亚洲,22960,1973
韩国,亚洲,7870,1973
土耳其,亚洲,17240,1973
印度尼西亚,亚洲,10980,1973
沙特阿拉伯,亚洲,23760,1973
泰国,亚洲,4130,1973
菲律宾,亚洲,5660,1973
马来西亚,亚洲,2780,1973
英国,欧洲,114750,1973
意大利,欧洲,107570,1973
西班牙,欧洲,55990,1973
荷兰,欧洲,36410,1973
瑞士,欧洲,33920,1973
芬兰,欧洲,9930,1973
瑞典,欧洲,23020,1973
比利时,欧洲,22280,1973
挪威,欧洲,14540,1973
美国,美洲,278390,1978
印度,亚洲,29220,1978
韩国,亚洲,13120,1978
土耳其,亚洲,22620,1978
印度尼西亚,亚洲,15390,1978
沙特阿拉伯,亚洲,30080,1978
泰国,亚洲,6000,1978
菲律宾,亚洲,7480,1978
马来西亚,亚洲,3900,1978
英国,欧洲,121140,1978
意大利,欧洲,126030,1978
西班牙,欧洲,64080,1978
荷兰,欧洲,41420,1978
瑞士,欧洲,32360,1978
芬兰,欧洲,10800,1978
瑞典,欧洲,24650,1978
比利时,欧洲,24970,1978
挪威,欧洲,18160,1978
美国,美洲,336520,1983
印度,亚洲,34790,1983
韩国,亚洲,18480,1983
土耳其,亚洲,25000,1983
印度尼西亚,亚洲,20870,1983
沙特阿拉伯,亚洲,24130,1983
泰国,亚洲,7840,1983
菲律宾,亚洲,9070,1983
马来西亚,亚洲,5510,1983
英国,欧洲,129860.00000000001,1983
意大利,欧洲,141500,1983
西班牙,欧洲,67430,1983
荷兰,欧洲,42830,1983
瑞士,欧洲,35000,1983
芬兰,欧洲,13130,1983
瑞典,欧洲,26980,1983
比利时,欧洲,26860,1983
挪威,欧洲,20980,1983
美国,美洲,427650,1988
印度,亚洲,45400,1988
韩国,亚洲,30960,1988
土耳其,亚洲,33340,1988
印度尼西亚,亚洲,26890,1988
沙特阿拉伯,亚洲,25640,1988
泰国,亚洲,11350,1988
菲律宾,亚洲,8970,1988
马来西亚,亚洲,6880,1988
英国,欧洲,158980,1988
意大利,欧洲,166060,1988
西班牙,欧洲,80430,1988
荷兰,欧洲,49070,1988
瑞士,欧洲,39950,1988
芬兰,欧洲,15720,1988
瑞典,欧洲,31270,1988
比利时,欧洲,30520,1988
挪威,欧洲,24800,1988
美国,美洲,488020,1993
印度,亚洲,56680,1993
韩国,亚洲,45790,1993
土耳其,亚洲,41600,1993
印度尼西亚,亚洲,37570,1993
沙特阿拉伯,亚洲,34670,1993
泰国,亚洲,17990,1993
菲律宾,亚洲,10000,1993
马来西亚,亚洲,10720,1993
英国,欧洲,167180,1993
意大利,欧洲,177750,1993
西班牙,欧洲,89630,1993
荷兰,欧洲,56320,1993
瑞士,欧洲,42740,1993
芬兰,欧洲,15040,1993
瑞典,欧洲,30950,1993
比利时,欧洲,33350,1993
挪威,欧洲,28050,1993
美国,美洲,521740,1998
印度,亚洲,77270,1998
韩国,亚洲,59600,1998
土耳其,亚洲,50560,1998
印度尼西亚,亚洲,42880,1998
沙特阿拉伯,亚洲,37310,1998
泰国,亚洲,19930,1998
菲律宾,亚洲,12090,1998
马来西亚,亚洲,14070,1998
英国,欧洲,196370,1998
意大利,欧洲,196130,1998
西班牙,欧洲,104800,1998
荷兰,欧洲,67570,1998
瑞士,欧洲,46090,1998
芬兰,欧洲,18940,1998
瑞典,欧洲,36510,1998
比利时,欧洲,37790,1998
挪威,欧洲,34830,1998
美国,美洲,545920,2003
印度,亚洲,102500,2003
韩国,亚洲,84420,2003
土耳其,亚洲,55060,2003
印度尼西亚,亚洲,51460,2003
沙特阿拉伯,亚洲,40500,2003
泰国,亚洲,25620,2003
菲律宾,亚洲,14620,2003
马来西亚,亚洲,18210,2003
英国,欧洲,228640,2003
意大利,欧洲,211730,2003
西班牙,欧洲,126720,2003
荷兰,欧洲,75950,2003
瑞士,欧洲,49450,2003
芬兰,欧洲,22260,2003
瑞典,欧洲,42290,2003
比利时,欧洲,42160,2003
挪威,欧洲,38320,2003
美国,美洲,578410,2008
印度,亚洲,143180,2008
韩国,亚洲,106280,2008
土耳其,亚洲,74660,2008
印度尼西亚,亚洲,67940,2008
沙特阿拉伯,亚洲,51340,2008
泰国,亚洲,31950,2008
菲律宾,亚洲,19140,2008
马来西亚,亚洲,24100,2008
英国,欧洲,253560,2008
意大利,欧洲,221500,2008
西班牙,欧洲,147390,2008
荷兰,欧洲,86710,2008
瑞士,欧洲,57960,2008
芬兰,欧洲,26270,2008
瑞典,欧洲,48920,2008
比利时,欧洲,47720,2008
挪威,欧洲,43330,2008
美国,美洲,589420,2013
印度,亚洲,197840,2013
韩国,亚洲,125320,2013
土耳其,亚洲,97510,2013
印度尼西亚,亚洲,89730,2013
沙特阿拉伯,亚洲,62900,2013
泰国,亚洲,37880,2013
菲律宾,亚洲,24700,2013
马来西亚,亚洲,29650,2013
英国,欧洲,260510,2013
意大利,欧洲,204670,2013
西班牙,欧洲,134780,2013
荷兰,欧洲,84970,2013
瑞士,欧洲,61070,2013
芬兰,欧洲,24970,2013
瑞典,欧洲,51470,2013
比利时,欧洲,49500,2013
挪威,欧洲,44930,2013
美国,美洲,617030,2018
印度,亚洲,282220,2018
韩国,亚洲,144970,2018
土耳其,亚洲,124050,2018
印度尼西亚,亚洲,114690,2018
沙特阿拉伯,亚洲,70160,2018
泰国,亚洲,44230,2018
菲律宾,亚洲,34030,2018
马来西亚,亚洲,38210,2018
英国,欧洲,287930,2018
意大利,欧洲,214100,2018
西班牙,欧洲,153950,2018
荷兰,欧洲,94810,2018
瑞士,欧洲,67460,2018
芬兰,欧洲,26920,2018
瑞典,欧洲,58930,2018
比利时,欧洲,53840,2018
挪威,欧洲,48930,2018
`,
  input: '使用动态玫瑰图帮我展示各国GDP排名变化'
};
export const dynamicRoseData1 = {
  csv: `country,GDP,year
USA,37,2000
Russia,32,2000
China,28,2000
Australia,16,2000
Germany,13,2000
France,13,2000
Italy,13,2000
Netherlands,12,2000
Cuba,11,2000
U.K.,11,2000
USA,36,2004
China,32,2004
Russia,28,2004
Australia,17,2004
Japan,16,2004
Germany,13,2004
France,11,2004
Italy,10,2004
South Korea,9,2004
U.K.,9,2004
China,48,2008
USA,36,2008
Russia,24,2008
U.K.,19,2008
Germany,16,2008
Australia,14,2008
South Korea,13,2008
Japan,9,2008
Italy,8,2008
France,7,2008
USA,46,2012
China,39,2012
U.K.,29,2012
Russia,19,2012
South Korea,13,2012
Germany,11,2012
France,11,2012
Australia,8,2012
Italy,8,2012
Hungary,8,2012
USA,46,2016
U.K.,27,2016
China,26,2016
Russia,19,2016
Germany,17,2016
Japan,12,2016
France,10,2016
South Korea,9,2016
Italy,8,2016
Australia,8,2016
USA,39,2020
China,38,2020
Japan,27,2020
U.K.,22,2020
Russian Olympic Committee,20,2020
Australia,17,2020
Netherlands,10,2020
France,10,2020
Germany,10,2020
Italy,10,2020`,
  input: '使用动态玫瑰图帮我展示各国GDP排名变化'
};

export const sequenceData = {
  csv: `playName,time,eventType
Deandre Ayton,-2209017943000,start
Deandre Ayton,-2209017476000,end
Deandre Ayton,-2209016998000,start
Deandre Ayton,-2209016057000,end
Deandre Ayton,-2209015551000,start
Deandre Ayton,-2209015127000,end
Deandre Ayton,-2209015116000,start
Deandre Ayton,-2209015063000,end
Devin Booker,-2209017943000,start
Devin Booker,-2209017293000,end
Devin Booker,-2209016892000,start
Devin Booker,-2209015783000,end
Devin Booker,-2209015380000,start
Devin Booker,-2209015063000,end
Kyle Lowry,-2209017943000,start
Kyle Lowry,-2209017476000,end
Kyle Lowry,-2209017223000,start
Kyle Lowry,-2209016762000,end
Kyle Lowry,-2209016614000,start
Kyle Lowry,-2209016057000,end
Kyle Lowry,-2209015884000,start
Kyle Lowry,-2209015063000,end
Jae Crowder,-2209017943000,start
Jae Crowder,-2209017293000,end
Jae Crowder,-2209016998000,start
Jae Crowder,-2209016139000,end
Jae Crowder,-2209015651000,start
Jae Crowder,-2209015063000,end
Aron Baynes,-2209017943000,start
Aron Baynes,-2209017476000,end
Aron Baynes,-2209016503000,start
Aron Baynes,-2209016166000,end
Pascal Siakam,-2209016892000,start
Pascal Siakam,-2209015788000,end
Pascal Siakam,-2209015528000,start
Pascal Siakam,-2209015063000,end
Pascal Siakam,-2209017943000,start
Pascal Siakam,-2209017223000,end
Mikal Bridges,-2209017943000,start
Mikal Bridges,-2209017650000,end
Mikal Bridges,-2209016998000,start
Mikal Bridges,-2209016762000,end
Mikal Bridges,-2209016503000,start
Mikal Bridges,-2209016003000,end
Mikal Bridges,-2209015783000,start
Mikal Bridges,-2209015063000,end
Chris Paul,-2209017943000,start
Chris Paul,-2209017476000,end
Chris Paul,-2209016998000,start
Chris Paul,-2209016057000,end
Chris Paul,-2209015551000,start
Chris Paul,-2209015063000,end
OG Anunoby,-2209017943000,start
OG Anunoby,-2209017476000,end
OG Anunoby,-2209017223000,start
OG Anunoby,-2209016614000,end
OG Anunoby,-2209016503000,start
OG Anunoby,-2209016021000,end
OG Anunoby,-2209015788000,start
OG Anunoby,-2209015063000,end
Fred VanVleet,-2209016892000,start
Fred VanVleet,-2209015884000,end
Fred VanVleet,-2209015651000,start
Fred VanVleet,-2209015063000,end
Fred VanVleet,-2209017943000,start
Fred VanVleet,-2209017223000,end
Cameron Johnson,-2209017650000,start
Cameron Johnson,-2209016998000,end
Cameron Johnson,-2209016762000,start
Cameron Johnson,-2209016503000,end
Cameron Johnson,-2209016139000,start
Cameron Johnson,-2209015651000,end
Yuta Watanabe,-2209017476000,start
Yuta Watanabe,-2209016892000,end
Yuta Watanabe,-2209016021000,start
Yuta Watanabe,-2209015651000,end
Dario Saric,-2209017476000,start
Dario Saric,-2209016998000,end
Dario Saric,-2209016057000,start
Dario Saric,-2209015551000,end
Dario Saric,-2209015127000,start
Dario Saric,-2209015116000,end
Chris Boucher,-2209017476000,start
Chris Boucher,-2209016998000,end
Chris Boucher,-2209015962000,start
Chris Boucher,-2209015528000,end
Norman Powell,-2209017476000,start
Norman Powell,-2209017119000,end
Norman Powell,-2209016762000,start
Norman Powell,-2209016547000,end
Norman Powell,-2209016057000,start
Norman Powell,-2209015063000,end
Cameron Payne,-2209017476000,start
Cameron Payne,-2209016998000,end
Cameron Payne,-2209016057000,start
Cameron Payne,-2209015551000,end
Langston Galloway,-2209017293000,start
Langston Galloway,-2209016998000,end
Jevon Carter,-2209017293000,start
Jevon Carter,-2209016892000,end
Jevon Carter,-2209016003000,start
Jevon Carter,-2209015380000,end
Malachi Flynn,-2209017119000,start
Malachi Flynn,-2209016892000,end
Alex Len,-2209016998000,start
Alex Len,-2209016503000,end
Alex Len,-2209016166000,start
Alex Len,-2209015962000,end
DeAndre' Bembry,-2209016547000,start
DeAndre' Bembry,-2209015783000,end`,
  input: '使用时序图帮我展示各运动员在比赛中的行动记录。'
};
export const mockUserTextInput0 = {
  text: `快手消失了。快手上市后，市值一度超过2000亿美元，现在只剩200多亿美元。去年快手的营收破了千亿，公司也赚钱了，但市场不买账了。
滴滴也不见了。滴滴去年营收接近2000亿元，并首次实现年度盈利，不过滴滴从美股退市后，一直没在港股上市，所以没有市值参考。`,
  input: ''
};
export const mockUserTextInput1 = {
  text:
    '全国人口[2]中，拥有大学（指大专及以上）文化程度的人口为218360767人；拥有高中（含中专）文化程度的人口为213005258人；' +
    '拥有初中文化程度的人口为487163489人；拥有小学文化程度的人口为349658828人（以上各种受教育程度的人包括各类学校的毕业生、肄业生和在校生）。',
  input: '对比本次人口普查各文化程度的人口比重。'
};

export const mockUserTextInput2 = {
  text: '人口增长较多的5个省份依次为：广东、浙江、江苏、山东、河南，分别增加21709378人、10140697人、6088113人、5734388人、5341952人。',
  input: '对比这五个城市的人口增长幅度。'
};

export const mockUserTextInput3 = {
  text: `阿里2023年收入9275亿元，仅次于京东。这其中有大约一半来自电商，剩下的来自阿里云、菜鸟、优酷、饿了么等业务。
腾讯的收入主要来自游戏和广告，2023年营收6090亿元，排名第三。相比阿里和京东，腾讯的模式要更轻一些，也更稳定。阿里和京东在线下做了很多布局，建快递仓库、开生鲜超市，前些年阿里甚至在线下买了一堆实体，现在“新零售”退潮，有些资产就砸手里了，外界都在猜测阿里会不会卖掉盒马和大润发。
而腾讯这些年的主营业务一直没有变，微信始终是全民应用，游戏一直是现金奶牛。至于腾讯视频、腾讯云等业务，也都是线上模式。
靠售卖虚拟商品和服务，一年做到6000多亿营收，目前只有腾讯有这个实力。
京东、阿里、腾讯之外，其他公司自动被归入下一个档次——营收3000亿元以下。无论是卖手机的小米，卖车的理想，还是卖广告的百度，送外卖的美团，年营收都没超过3000亿元。
不过这条线很快会被突破。拼多多2023年营收2476亿元，而2022年只有1306亿元，以这个增速没有任何悬念；美团2023年营收2767亿元，今年突破3000亿元问题不大；小米因为有了造车业务，应该也会突破。
小米比较特殊。手机市场已经饱和了，过去几年全球手机销量一直在下滑，小米的营收连降两年，从2021年的3283亿元降到2023年的2710亿元。不过小米汽车开始交付了，拿了超过10万台订单。如果按每台车25万元的价格算，这10万台也能带来250亿元增量收入，让小米重回增长轨道，所以这就是为什么雷军一定要造车。
这个前十的名单，有一条隐形门槛——营收千亿。
排在第十位的快手，2023年营收1135亿元，这是它首次跨过千亿营收。2023年也是网易首次营收过千亿，不过它只有1035亿元，排在快手之后，没进前十。`,
  input: ''
};

export const mockUserTextInput4 = {
  text: `其次是员工规模。

2019年底的时候，腾讯不到6.3万人，2020年招了2.3万人，2021年又增加了2.7万人，总人数超过11万人。这是腾讯历史上员工规模最庞大的一年。

阿里在2019年有11.7万人，2020年合并高鑫零售，总人数翻了一倍多到25.2万人，2021年又增加了7200多人。

京东是所有互联网公司中人数最多的。2019年京东有22.8万人，2020年增加8.7万人，2021年增加7万人，2022年又增加6.5万人，总人数超过45万人。不过，这其中有30万是快递小哥。

其他互联网大厂，人员扩张的脉络基本类似：2020年、2021年疯狂招人，2021年达到历史顶峰，2022年、2023年开始收缩，进行不同程度裁员。

降本增效成为互联网大厂的关键词。前几年扩张太猛，招人太多，现在业务增速放缓，用不了那么多人了。`,
  input: ''
};

export const mockUserTextInput5 = {
  text: `阿里的变现能力不如腾讯，且波动较大，2023年盈利924亿元。不过阿里是中国拥有现金最多的互联网公司，从2020年开始，它每年都在储备现金，2022年超过5000亿元，2023年更是达到6530亿元。
账上现金变多，一方面说明阿里前些年赚得多，家底厚，另一方面也说明这些资金没有更好的投资渠道，阿里在新业务上的探索变慢了。
可能会让一些人感到意外的是，拼多多的变现能力现在仅次于腾讯、阿里。2023年拼多多的净利润为600亿元，相比2022年几乎翻倍，而2021年之前它还是亏损。从一台烧钱机器到赚钱机器，拼多多只用了三年时间，它账上的现金储备也比网易、小米、京东等公司都多。
需要注意的是，拼多多还处在投资扩张期。600亿元的净利润，是在大力推动新业务的前提下实现的，它的海外业务TEMU正在全球范围跑马圈地，还没到变现阶段。这意味着拼多多的净利润还有很大提升空间。
拼多多跟其他巨头很不一样的一个点是，虽然公司赚钱了，账上钱很多，但既不回购也不分红，而是要继续投资，官方说法是“投资于长期价值”。
其他的互联网巨头，近两年也基本都赚钱了，2023年的盈利在100亿-300亿元之间。理想赚了118亿元，美团139亿元，小米175亿元，百度215亿元，京东233亿元，网易294亿元。快手和滴滴，也在2023年首次扭亏为盈。
这其中有两家公司值得关注。
网易是唯一一个跟BAT属于同时代，每年都很赚钱，市值还排在前五的互联网巨头。2023年网易的净利润是294亿元，虽然比不上腾讯、阿里、拼多多，但盈利很稳定。把网易过去五年的净利润数据拉出来，平均数是200亿元。`
};

export const mockUserTextInput6 = {
  text: `2019年腾讯收入3773亿元，2020年增长了1048亿元，2021年又增长780亿元，但2022年是负增长，2023年只增长了545亿元。看增长率更明显，2020年高达27.8%，2023年只有9.8%。
阿里的趋势也类似。2020年、2021年的营收增速为31.8%、29.8%，2022年降至3.4%，2023年是7.3%。
网易从2020年到2023年，营收增速逐年下滑，2023年降至个位数的7.2%；小米2020年、2021年的增速高达19.4%、33.5%，随后两年都是负增长。`
};

export const mockUserTextInput7 = {
  text: `目前，小红书的广告客户主要集中在消费品行业。有分析师向36氪表示，2023年，小红书广告收入占比最高的是个护美妆（18%），其次为时尚穿搭（12.5%）、美食饮品（10%）、家居家装（8.7%）、母婴（7%）、黄金珠宝（6%）、汽车（5.3%）、日化百货（5.1%）。`
};

export const mockUserTextInput8 = {
  text: `| 排名 | 城市 | GDP      |
|------|------|----------|
| 1    | 上海 | 47219亿  |
| 2    | 北京 | 43761亿  |
| 3    | 深圳 | 34606亿  |
| 4    | 广州 | 30356亿  |
| 5    | 重庆 | 30146亿  |
| 6    | 苏州 | 24653亿  |
| 7    | 成都 | 21257亿  |
| 8    | 杭州 | 18867亿  |
| 9    | 武汉 | 17600亿  |
`
};

export const mockUserTextInput9 = {
  text: `| 年份 | 杭州GDP (亿元) | 南京GDP (亿元) |
|------|----------------|----------------|
| 2013 | 8343.95        | 8000.81        |
| 2014 | 9201.16        | 8867.93        |
| 2015 | 9600.17        | 9500.02        |
| 2016 | 10003.58       | 10450.08       |
| 2017 | 11700.94       | 11715.09       |
| 2018 | 13509.27       | 12820.40       |
| 2019 | 15373.05       | 14050.15       |
| 2020 | 16106.00       | 14817.95       |
| 2021 | 18109.00       | 16355.00       |`
};

export const mockUserTextInput10 = {
  text: `你好，我没有找到最新的股市指数波动数据。不过，可以为你提供5月28日A股三大指数的波动情况，数据如下：

上证指数跌0.46%，为3109.57点；
深证成指跌1.23%，为9391.05点；
创业板指跌1.35%，为1806.25点。

如果你需要了解更多股市指数波动信息，可以访问财经新闻网站或咨询专业的投资顾问。`
};

export const mockProgressData = {
  csv: `年份,进度
 2024年,0.56`,
  input: '请使用环形进度图帮我展示今年的进度数据'
};

export const liquidData = {
  csv: `进度
 0.56`,
  input: '请使用水波图展示进度数据'
};
