/* eslint-disable max-len */
export const capcutMockData: any[] = [
  {
    text: '地图带你看懂法国大选。 2024 年法国议会选举结果揭示了法国社会的撕裂，没有任何党派能获得 577 个议题中的绝对多数。左翼联盟、新人民战线执政党中间派联盟和极右翼国民联盟分别占据 182 席、 168 席、 143 席。除了这三家以外，其余党派席位最多的也只有右翼共和党的 48 席，因此左翼联盟、执政党和极右翼算是形成了三分天下的格局。今天我们便结合地图和数据，聊一聊法国大选。本期视频的所有分析均为个人观点，仅供参考。在开始之前，我先快速的放一下各党派在几个主要政治议题上的立场，有需要的朋友可以截图保存一下。',
    fieldInfo: ['党派', '席位数']
  },
  {
    text: '现在我们进入正题，首先需要说明法国的选区制度，全国共有 577 个选区，每个选区包括 10- 12 万的人口密集的地方选区就小，人口稀少的区域选区域就大。因此地图上各个政党所占的面积并不能与其票数划等号，而是要看具体的选区分布在人口密集的大城市，譬如巴黎、里昂、马赛，虽然看起来面积小，实际上选区数量很多，占的比重很大。',
    fieldInfo: ['选区数量', '选区人口范围', '城市']
  },
  {
    text: '尽管如此，马克龙强调市场自由化，支持创新和创业，对欧盟一体化和国际合作的开放还是得到了许多大城市选民的支持。大城市仍然是马克龙的重要支持来源。除了大城市外，我们刚才提到过法国东北地区工业的衰落，其实在法国的西北地区又是另一番景象。之前那张关于中小工业城市分布的途中，我们可以清晰的看到西北地区的工业对于当代法国的重要性，当然工业只是一个缩影。我们再来看失业率地图，黄色代表 2022 年失业率最低的 20 个省，橙色是 21- 40 低的省份，可以看出西北部地区的失业率明显低于东北部。再看移民分布地图，西北部地区因为大城市少，而且离地中海更远，接受的移民也比较少。综上，西北地区的经济较为稳定，而且不受移民带来的社会问题困扰，日子过得比较舒服，这些选民对于未来持乐观态度，也成为了马克龙的另一主要票仓。除了以上三大势力外，浅蓝色代表的右翼共和党也获得了 48 个席位。他们的支持者主要位于经济同样比较富足，但是政治观点更为保守的地区。这里我就不展开讲总结。本期视频我们从法国官方的报告与数据出发，从经济与人口地理的角度分析了法国的大选结果。左翼联盟新人民战线以大城市为根基拿下最多的 182 席，马克龙的执政党中间派联盟则凭借大城市和西北地区的支持者取得了 168 席。乐旁的极右翼国民联盟则主要扎根于东北与东南地区，以 143 起居于第三这样的三分割据局面使得法国议会缺乏绝对多数，并且三方势力相差不大。可以预见在未来法案的通过上会面临极大的阻碍。举例来说，左翼和极右翼甚至存在联手撤回延迟退休法案的理论可能。虽然实际操作起来也面临很多困难，双方都不太愿意和对方合作，但即便是理论，可能也已经能表明未来的不确定性。',
    fieldInfo: ['政党', '席位数', '地区']
  },
  {
    text: '住手，你们住手，不要再砸了，你们不要再砸了。万万没想到，瑞幸和库迪的九块九大战，快把星巴克给卷死了。前段时间，星巴克公布了第二季度财报，营业收入 85.6 亿美元，同比下降了2%，净利润大跌15%，股票市值一天内蒸发了 1, 150 亿人民币。另一方面，星巴克的咖啡也在悄悄降价。如果你手机上有星巴克的APP，几乎每天都会收到 5 张以上的优惠券，比如满60.10、满75.15、任意新冰乐 7 折等等，部分单品的团购价优惠下来低至 9 元。终于， 9.9 的风还是卷到了星巴克。在过去很长一段时间里，星巴克是小资生活的代表，一杯咖啡动辄几十块钱，也只有电视剧里那些白领们和云淡风轻的走进去，熟练地点一杯拿铁，找个位置坐下，悠闲地打开电脑喝咖啡。岁月静好人间，值得有人点一杯星巴克，朋友圈能发十几条动态，有人为了抢星巴克限量版的猫爪杯，能通宵排队，甚至大打出手。',
    fieldInfo: ['营业收入', '营业收入同比', '净利润变化']
  },
  {
    text: '星巴克在中国国内的定位一直都是高端咖啡品牌，但是很多人不知道的是，它在国外的定位其实是平民咖啡，在美国一杯星巴克大杯美式咖啡大概是 2.95 美元，而根据美国劳工部的统计，美国平均月工资是 6, 228 美元，最低时薪是 7.25 美元，这是啥意思呢？ 1002.65 美元的星巴克还不到美国人平均月收入的 2, 000 份之一，也就是平常坐一趟地铁的价格吧。而在中国市场，星巴克的饮品价格普遍要超过 30 元一杯。如果按照美国的对应消费力，它的主力消费人群应该是月薪至少6万元的人。',
    fieldInfo: ['咖啡价格', '平均工资', '最低时薪']
  },
  {
    text: '2019 年2月，星巴克就发售了一款粉爪杯，那它长这样？售价 199 元，但是在网上最高炒到了 1, 800 元。有人寒冬腊月在星巴克门口通宵排队，就是为了买到这么一个杯子。还有人因为排队顺序大打出手，最后喜提免费食宿。靠着这些营销方法，在很长一段时间里，普通人对于星巴克是仰望的，觉得去星巴克消费是很有品的，再往前推十年，你甚至可以看到有人去星巴克点一杯咖啡就可以发十几条朋友圈的各种角度各种场景，还要配文低调有实力，天天喝都喝腻了好像呢？甚至有人专门发帖认真的提问，第一次去星巴克主要注意什么？怎么装的像老手呢？我一开始还以为是来搞笑和反讽的，没想到点开帖子此还真的是教大家怎么去星巴克抓老手的，包括但不限于怎么下载APP，问店员这周用的是啥肚子萃取时间是多少？张度和烘焙度怎么样？要不要加糖和加奶？这唬得我一愣一愣的，但是时过境迁，如今星巴克已经支棱不起来了，一边是疯狂降价买三送一搞促销，一边是继续下沉到四五线城市。',
    fieldInfo: ['商品', '售价', '最高价']
  },
  {
    text: '星巴克近期发布的 2025 中国战略愿景当中，中国总部直言不讳地表示，星巴克看中的不仅仅是全国 300 多个 d 级市场，也包括近 3, 000 个县域市场。星巴克的愿景也体现在它的选址变化上，它在中国的门店已经突破了 7, 000 家，但是这开店位置却让人越来越看不懂了。',
    fieldInfo: ['市场级别', '市场数量']
  },
  {
    text: '一家卖咖啡的店。星巴克没落的第二个原因是当代年轻人更偏向实用消费主义。坦白讲，大部分人喝咖啡其实就是为了遮住那点咖啡因，好让自己在一天的工作中保持清醒。你跟不懂咖啡的人聊什么豆子产地、风味，他只会回你一句，冰美式和中药有什么区别啊？如果你面前有三杯咖啡，第一杯是星巴克的 30 元美式，后面两杯是瑞幸库里的 9 块 9 咖啡也让你买单，大部分人都会选择后面两个，当然也有人会吹星巴克的豆子有多么多么的好，所以它买的这么贵也是值得的。',
    fieldInfo: ['品牌', '价格']
  },
  {
    text: '咱聊一下最新的重磅数据，反正挺复杂的，国内6月 M2 同比增长6.2%，预期6.8%。 M1 同比下滑5%，预期下滑5.4%。 M M 一剪刀差走扩至 11.2% 再创新高。6月人民币存款增加 2.46 万亿，其中居民存款增加 2.14 万亿，增量几乎全都是老百姓存的。与 M1 的下滑相对，上半年人民币存款总共增加了 11.46 万亿，其中居民存款增加 9.27 万亿。大头也是老百姓，但增速逐月放缓。',
    fieldInfo: ['指标', '同比增长', '预期增长']
  },
  {
    text: '7月 11 日晚上，由于美国公布的 CPI 数据超预期回落，让市场对美联储降息预期大幅升温。从这场所的美联储观察工具看，虽然7月 30 一日的美联储议息会议，市场预期不降息的概率仍然是达到93%，但9月 18 日的美联储议息会议，市场预期降息一次的概率是达到90%，这比起上个月概率是上升很多。不过我还是得强调一下，这个美联储观察工具将来只能反映市场当前的预期态度，不能拿来预测美联储货币政策，因为这个概率是会不断随着最新经济数据变化而变化。比如要是下个月美国 CPI 出现较大反弹，那9月降息的概率就会大幅下降。而这次市场预期美联储9月降息的概率大幅上升，主要有两个原因，一、美联储鲍威尔在7月 10 日的国会听证会上整体态度偏戈。鲍威尔称，劳动力市场降温意味着持续高通胀的潜在源头已经减弱。他还表示，就业市场的进一步疲软可能是不必要的，也是不受欢迎的。鲍威尔说，通胀方面的工作还没有完成，我们还有更多工作要做，但与此同时，我们需要注意劳动力市场现况，我们已经观察到劳动力市场出现相当明显的疲软，有着新美联储通讯社之称的知名记者尼奇默尔斯认为，鲍威尔本周其实已暗示美联储的利率政策即将开始改变方向。',
    fieldInfo: ['时间', '预计降息概率']
  },
  {
    text: '第二个原因是7月 11 日晚上 8 点半美国劳工部公布的通胀数据，6月 CPI 是同比上涨3%，市场预期值3.1%，前值3.3%。这次美联储 CPI 回落，更关键是 CPI 环比是负增长0.1%，这是美国 2020 年5月以来 CPI 环比首次出现下降，而且美国 2020 年5月还是因为疫情导致的 CPI 骤降，是比较特殊时期，所以美国 CPI 环比负增长确实不太常见。但仔细看美国 VI 月 CPI 的具体构成，感觉猫腻还是不少的。',
    fieldInfo: ['经济指标', '同比', '环比', '市场预期值', '前值']
  },
  {
    text: '美国 VI 月 CPI 下降的主要贡献是汽油价格下跌。美国 VI 月汽油价格下跌了3.8%，抑制了当月通胀，抵消了食品和住房价格 0.2% 的上涨。比较诡异的是，美国原油期货价格6月是明明出现大幅上涨，这是因为原油期货价格传导到汽油价格有一些迟滞效应，但那样的话，下个月公布的 CPI 数据，汽油价格可能就得反弹了。要是下个月公布的 CPI 数据，汽油价格还继续下降，那就实在说不过去了。美国刨除能源和食品价格的核心通胀率6月是3.3%，但整体降幅还是低于CPI。',
    fieldInfo: ['价格类别', '价格变动比例']
  },
  {
    text: '美国通胀目前最顽固的就是服务业通胀，美国 VI 月服务业通胀仍然是同比上涨5%。美国毕竟是服务业为主的国家，服务业通胀还高居5%，美国要说自己已经控制住通胀，完全就是忽悠人。不过虽然美国大选临近，美国现在经济数据基本是为选型服务，比如已经假的不能再假的美国非农就业数据，美国 VI 月非农就业人口增加20.6万人，高于市场预期的 19 万人。然而美国同时把5月数据从 27.2 万人大幅下修至 21.8 万人，4月从 16.5 万人修正至10.8万人，修正后两个月合计较修正前减少 11.1 万人。',
    fieldInfo: ['月份', '修正前就业人口增加', '修正后就业人口增加']
  },
  {
    text: '我注意到虽然这次市场大幅提高了美联储9月降息概率，但美股和日股反而不涨反跌，纳斯达克在7月 11 日是下跌了2%，日股在7月 12 日也跟随下跌了2.45%。这是市场反身性效应的某种预演，股市炒的是预期，之前美股和日股是基于美联储降息预期，已经提前涨了一年多了，那么当美联储真正降息之后，市场是可能出现反身性效应，也就是所谓利好落地势利空的说法。当然股市走势千变万化，这也只是其中一种可能性。历史的参考例子，比如 2004 年美联储降息， 2006 年停止加息， 2007 年开始降息，但股市是一直涨到 2007 年底，随后自带危机爆发，股市开始大跌。我之前也梳理过，从 1980 年以来，美联储每次加息超过 5% 的幅度，首次加息后的 2- 4 年内都会爆发金融危机，这次美联储是 2022 年开始加息，所以按照历史路径， 2024 年到 2026 年是有可能爆发世界金融危机，这个结合当前国际局势和地缘形势，还是有挺大的可能性。',
    fieldInfo: ['股市', '时间', '涨跌幅度']
  },
  {
    text: '以前的小学空荡荡的，老年人养起了鸡鸭鹅狗，彻底荒废了整个黑龙江省， 10 年时间荒废了近六成，小学加起来有 1, 900 余所，整个东北十年荒废了 6, 800 余所小学，少了一半。',
    fieldInfo: ['地区', '荒废比例', '荒废数量']
  },
  {
    text: '而小学缺孩子这个趋势早已经蔓延至全国各地了。东部的兹西县，有的小学一个班只有一个学生。华南的徐文县，去年某小学开学，一年级也只有一个学生。中部人口大省河南，据测算， 2023- 2027 年小学学龄人口预计下降 200 多万人，缩水超两成，出现了基数的坍塌。从全国来看，基于学龄人口的预测显示，全国超 1, 400 个县域中，近九成县域小学学龄人口预计下滑，小学鹤岗化以谁也没想到的方式在扩散，从东北开始到大江南北，下一步可能是上海最新的总和生育率只有 0.6 了，该来的总是要来，从民政局冷冷清清到妇产科缺孩子，再到幼儿园关停潮，现在轮到了小学关停潮，这个传播链条还在扩散。',
    fieldInfo: ['地区', '时间', '小学学龄人口变化']
  },
  {
    text: '实际上，如果鹤岗化只是局限于教育领域，那还好说，但不是实际情况复杂的多楼市，像鹤岗那样房子白菜价的城市越来越多了，据不完全统计，至少有 10 个省 24 个城市陷入几万元买房的讨论。不是每平方米单价几万，而是一套房总价几万。网传广东惠州6万，广西南宁5万，山东东营4万，江苏南京3万，黑龙江大靶1万，这个传播势头在这轮楼市调整的加持下，现在已经来到了北京的外围，在京津两市的交界处，抹楼盘从 160 万元降到了 39 万，而且打了骨折还卖不出去。',
    fieldInfo: ['城市', '房价']
  },
  {
    text: '地方财力，之前鹤岗是全国第一个财政重整的地级市，甚至传出来停招公务员，现在过紧日子的城市也越来越多了。秦岭深处某县人口只有3万，编制人员却有 2, 194 名，一年的行政管理支出 1, 800 万，排在支出的首位。乌蒙山区某县一般公共预算收入 7 个亿，但工资预算总支出 26.3 亿，其中在职人员 20 亿，离退休人员 1.7 亿，零聘人员 4.6 亿。注意一个细节，在职人员数量 1.5 万，临聘人员数量 2.8 万。',
    fieldInfo: ['地区', '人员数量', '人员类别', '公共预算收入', '工资预算支出']
  },
  {
    text: '中国房价一度被视为坚不可摧的资产堡垒，更一度有京沪永远涨的口号。然而，自 2021 年以来，包括一线城市在内，房价持续低迷，深圳全市二手房均价距离 2021 年初的最高点跌幅已接近40%，而且还没有停下来的意思。各热点城市二手房每成交一套就要多出好几套，新增的房源和房价表现几乎完全正相关的是飞天茅台的价格， 53 度。',
    fieldInfo: ['城市', '年份', '房价变化']
  },
  {
    text: '飞天茅台在 2021 年巅峰时期，一瓶售价超过 3, 500 元，如今已经快跌破 2, 000 元，是巧合吗？过去一线城市房价和飞天茅台价格可以说是最硬的人民币计价资产了，甚至比现金还要优质。一线房产和飞天茅台在相当长的一段时间内有两个相同属性，一他们可以长期增值。二他们易于套现。然而现在情况出现了前所未有的变化，房价和飞天茅台两者双双在 2012 一年见顶。',
    fieldInfo: ['年份', '价格']
  },
  {
    text: '这不是巧合，其他很多数据也都在 2021 年见顶，比如另一个在 2021 年见顶并开始走下神坛的保时捷。保时捷销量的恶化还在加速，过去一年多，中国市场上保时捷的落地价可以说是惨不忍睹。近期，保时捷只卖 44 万的话题也引发了热议，其华南区域一家终端门店称， Macan 正在进行优惠促销，最高优惠 16 万，该车优惠后最低售价为 44.8 万。另外，在山东、湖北、江西、福建、浙江、江苏等多省份，该车均出现了 50 万元以下的裸车价，而报价达到 103.8 万的泰肯，现在 70 多万就可以拿下。目前，保时捷几乎所有的车型都可以打 7- 8 折。',
    fieldInfo: ['车型', '落地价', '优惠金额', '报价']
  },
  {
    text: '不只是保时捷，包括奔驰、宝马、奥迪在内的豪华汽车品牌今年以来都在大幅降价，但仍然止不住销量断崖式下降。 2024 年一季度，保时捷中国卖出 16, 340 辆，同比大幅下降24%。保时捷在今年 5 月份仅卖出 4, 633 辆，同比去年5月下滑高达40.61%。这说明保时捷在中国的销量正在加速减少。',
    fieldInfo: ['时间范围', '销量', '同比']
  },
  {
    text: '从两年前开始，特斯拉的 3 和 y 中国售价就是世界最低的， 7.98 万可以买到原本指导价 13.18 万的油电混动的卡罗拉。做一个对比，美国的油电混动卡罗拉的起售价是 2.35 万美元，有时甚至还要加价。按照美元人民币汇率计算，这款车的中国售价居然只有美国的一半水平，尽管配置存在差异，但不影响价格差异巨大的这个结论。除了卡罗拉外，汉兰达和凯美瑞也都大幅降价，即使是两年前，我们也很难想象只要 14.98 万人民币就可以买到最新款的混动版凯美瑞。',
    fieldInfo: ['车型', '售价', '指导价', '美元起售价']
  },
  {
    text: '中国物价的下降不仅仅体现在商品上，服务价格也是类似的趋势。举个例子，十多年前我常驻北京，当时经常在晚上十一二点从首都机场打车到西直门这样一段单程大约需要 110- 120 元，而现在滴滴大概只要 60- 70 元。如果是现在的出租车，价格和十多年前还是一样的。',
    fieldInfo: ['交通方式', '时间', '价格区间']
  },
  {
    text: '以工行、农行、建行发布的数据来看，其 2023 年个人住房贷款不良率分别由 2022 年的0.39%、0.51%、 0.37% 增长至了0.44%、 0.55% 和0.42%，基本都实现了两位数的增幅。大家别觉得这些小数字没啥大不了的，要知道这三家银行每一家的个人住房贷款余额都超过了5万亿，而且按揭贷款往年基本上都是银行稳赚不赔的买卖。供建农三家银行之所以每年能够包揽中国最赚钱企业的前三名，按揭贷款所带来的收益贡献巨大。现在这个优质资产的不良率正在以每年两位数的增幅增加。',
    fieldInfo: ['银行', '年份', '不良率']
  },
  {
    text: '你是银行，你慌不慌？而另一项作为佐证的数据则是法拍房，大家知道现在法拍房的数据有多夸张吗？根据瀚海研究院发布的数据显示， 2022 年全国共挂牌法拍房 98 万套，去年这个数字变成了 141 万套，增长了43.9%。而今年光是一季度的挂牌数量就已飙升至 60.44 万套通，同比上涨192%。这种局势下，银行要是再不改变断供处置策略，那今年的法拍数量估计有望达到 200 万。',
    fieldInfo: ['对应时间', '法拍房数量', '同比']
  },
  {
    text: '事实上，对银行来说，现在的行情即使他收了房也难以处置。我们以北京为例， 2023 年北京挂牌法拍房 8, 153 套，最终成交仅 2, 771 套，处置率为33%，这还是房价波动相对较小的北京，换到其他已经跌穿首付的地区，处置率恐怕只会更低。而在法拍流程里，流拍和拍品二次上拍都会在此前的价格上更进一步降低，这也导致了银行回款难度的进一步提高。虽然按照现在的规则，这部分差价是由贷款人承担的，但对方既然已经到了选择断供的地步，可想而知最终也执行不了多少。',
    fieldInfo: ['地区', '法拍房数量', '成交量', '处置率']
  },
  {
    text: '另一项推动银行改变策略的原因，则是今年4月 30 号的一场会议，这场会议确定了房地产行业未来一年的发展方向，统筹消化存量房产和优化增量住房，用大家都熟悉的话来说就是去库存。根据国家统计局的官方数据显示，截至 2024 年5月，我国未出售商品房为 7.46 亿平米，远超 5.9 亿平米的正常库存水平。而整个上半年，根据 CRS 的统计，全国 222 个城市总计出台了 341 项宽松政策，但带来的效果均不理想，无论是销售面积还是投资金额，仍然在持续走低。',
    fieldInfo: ['时间', '商品房面积', '面积类别']
  },
  {
    text: '大家好，我拍拍一名做过财经记者，大学老师和滴滴司届 up 主。 2023 年，我国汽车出口量达到了 491 万辆，超越日本成为世界第一汽车出口国。要知道，日本在这个位置坐了 8 年之久，而中国仅在过去三年时间里接连赶超韩国、德国、日本。中国汽车出口， 2021 年 202 万辆， 2022 年 311 万辆， 2023 年 491 万辆。',
    fieldInfo: ['年份', '国家', '出口量']
  },
  {
    text: '中国汽车转眼间为何变得这么受欢迎呢？又到底是哪些国家在购买中国汽车？中国卖给老外汽车又是些什么品牌和价位车型？本期视频就为大家打开中国汽车出口全球第一背后的真实数据。首先，中国出口的 491 万辆汽车都是些什么车呢？根据乘联会统计，中国乘用车出口量前十车型分别为名爵ZS、特斯拉 model y、奇瑞瑞虎7、特斯拉 model 3、名爵 4 EV、奇瑞虎5X、欧盟达名爵5、缤越元plus。除了特斯拉的 model y 和 model 3，其他车型国内指导价基本都在 10 万元左右，比如排名第一的名爵ZS，指导价 8- 9万元，最便宜的名爵 5 和缤越低到6万元就能拿下，可见中国汽车出海主打的还是一个性价比。',
    fieldInfo: ['车型', '指导价']
  },
  {
    text: '如果按燃油车、新能源车的分类来看， 2013 年中国出口燃油车 371 万辆，出口新能源汽车 120 万辆，新能源车占到出口总量的25%，虽然这个占比目前只有 1/ 4，但去年新能源出口增速是77.6%，势头不可谓不猛。',
    fieldInfo: ['车辆类型', '年份', '出口量', '出口占比', '出口增速']
  },
  {
    text: '那中国汽车出口都卖到了哪些国家呢？ 2013 年中国汽车出口量前十的国家分别是，俄罗斯90.9万辆，墨西哥 41.5 万辆，比利时 21.7 万辆，澳大利亚 21.4 万辆，英国 21.4 万辆，沙特阿拉伯 21.3 万辆，菲律宾 17.2 万辆，泰国 16.9 万辆，阿联酋 15.9 万辆，西班牙 13.9 万辆。按地区来看的话，欧洲市场占中国汽车对外出口的38%，远超其他任何单一大洲，可见中国汽车正在得到全世界更多人的认可。',
    fieldInfo: ['出口国家', '出口量']
  },
  {
    text: '当然了，中国汽车出口世界第一，又不得不提议俄罗斯和墨西哥这两个国家可以说去年是把中国车买爆了。 203 年，中国对俄罗斯的汽车出口量从上一年度的 16 万辆暴增到了90.9万辆，增加了468%。在俄罗斯的新车市场中，第一名是俄罗斯品牌拉达，第二至第七名则全都是中国品牌，比如第二名是奇瑞金车，市场占有率11.2%。第三名是哈弗，新车，市场占有率10.6%。俄罗斯卖最好的新能源车也是来自中国的极客。目前中国汽车已经占据俄罗斯新车市场的51%，可以说是拿下了半壁江山。而对于中国而言，仅俄罗斯一个国家 203 年就贡献了中国汽车出口增量的42%，甚至有俄罗斯本土汽车经销商预测， 2024 年中国汽车可能占据俄罗斯新车份额的80%。',
    fieldInfo: ['年份', '出口量', '占有率']
  },
  {
    text: '有人说俄罗斯满爆中国汽车是因为欧美的贸易封锁，这也步无道理。 2013 年在俄罗斯的新车市场中，欧洲的市场份额从 18% 降到了4%，韩国从 16% 降到了6%，日本从 12% 降到了5%，和欧日韩都是对俄罗斯实行了限制出口国家，其中就包括了部分汽车，可以说中国汽车吃下的正是欧日韩在俄罗斯丢掉市场。',
    fieldInfo: ['国家', '新市场份额', '旧市场份额']
  },
  {
    text: '当然了，除了俄罗斯之外，其他国家也在买中国汽车，比如墨西哥。 2013 年，墨西哥所有销售汽车中有 25% 来自中国，而在 6 年前这个数字为0。澳大利亚也在不断买中国汽车，最受澳大利亚欢迎的中国汽车品牌是名爵，去年卖了 5.8 万辆。在新能源车市场，比亚迪则占据了澳大利亚的新能源汽车 14% 份额，位于第二名。',
    fieldInfo: ['国家', '年份', '中国汽车占比']
  },
  {
    text: '当然，这里也不得不提一下第一名，那就是特斯拉市场份额高达53%，在东南亚市场，中国车企业销量在 2013 年同样实现小幅上升，最典型的就是泰国，在泰国的新能源车市场，中国品牌占据了 80% 的份额，比如比亚迪的原 plus 就是泰国的新能源车爆款，那到底是什么原因让中国汽车爆卖呢？基本还可以总结为三方面原因，首先是全球疫情爆发，由于中国汽车的供应链完善，疫情期间仍能维持稳定生产，而日韩这些过去的出口大户受疫情影响，芯片、钢材、橡胶等关键原材料短缺，不仅汽车产能下降，而且成本升高，这就让中国汽车更具性价比。而随着中国国内新能源汽车市场越来越卷出海，成为不少中国车企的选择，比如比亚迪 2023 年进入全球 58 个国家和地区，出口汽车 24 万辆，是上一年度的 3.34 倍。在泰国新能源车市场，比亚迪单独占到了 40% 的市场份额，是名副其实的泰国新能源汽车销冠。而且中国新能源汽车并非只是具备成本优势，汽车与 AI 互联网融合的智能化更是中国车企的拿手好戏。从豪华配置到智能大屏，从外观设计到内饰比拼，这让中国新能源汽车的溢价能力明显变高。2019 年中国新能源汽车平均出口价格每量只有 5, 000 美元， 2022 年涨到了 2.2 万美元。比如比亚迪汉在欧洲发布时价格接近 50 万人民币，是国内售价的两倍多。在泰国、以色列、新西兰等多个国家，比亚迪也已经是新能源汽车的销售冠军。不过，中国汽车征服海外虽然是一部励志爽门，但其实有不少挑战。',
    fieldInfo: ['品牌', '市场份额']
  },
  {
    text: '其实中国汽车出海不禁让人想起曾经的中国摩托车出海。 2000 年前后，中国摩托车进军越南，一度占据了 80% 的越南市场份额，但不到三四年时间，却被日本摩托车打得片甲不留。如今日本摩托车在越南占据 95% 的份额，而中国摩托车百分之一都不到。曾经也有大量中国摩托车车企在越南建厂，但却形成了恶性竞争的关系，疯狂打价格战，导致服务和质量越来越差，越南的中国摩托车车企仿佛是飘在越南的。',
    fieldInfo: ['时间', '摩托车品牌', '市场份额']
  },
  {
    text: '每个中国制造品牌的背后都有一批优秀的零部件供应商，像汇川技术、恒力液压、先导智能、顺域光学、军胜电子这样的零部件企业也是中国制造的骄傲，只不过知名度无法媲美消费者直接接触的终端品牌。按照官方的口径，中国规模以上也就是年销售收入 2, 000 万以上的制造企业有 44.5 万家。至于中国一共有多少家制造业企业存在各种口径，从 300 多万家到近千万家不等。万德资讯给我的数据是，中国大约有 622 万家存续的制造业企业。海之在线是一家总部在上海，聚焦中间品贸易的数字化平台，连接着 70 万家工厂，他们给我的数据是，中国规模以下的中小微工厂大致有 400 万家。这期节目标题中的 400 万家沉默工厂处处记载于此。海志在线的创始人、 CEO 佘莹对我说，从平台看， 40% 的工厂规模不到 50 人，近 90% 的工厂不到 500 人，大部分工厂的年产值在数百万元到数千万元。如果和大企业比，你可以说他们就是一个个的小做法。如果走进去可能会看到老旧的机器上油漆斑驳，可以看到生产计划就用记号笔写在车间墙上挂着的白板上，甚至会发现用破洞的木板随意围搭起来的厕所，待客的茶水里则混杂着浓浓的机油味。但他们就是中国制造业毛细血管层面的供应链小节点，勤勤恳恳的维护设备、搞生产，他们最在意的是生存，是接到订单以及在满足客户之后能够完整的收到货款。',
    fieldInfo: ['企业类型', '企业规模', '企业数量']
  },
  {
    text: '有报道称，一些地方政府面临收入短缺，要求企业缴纳可追溯到 1990 年代的税单。这种紧缩政策在房地产市场寻找几步的时刻，会损害上信心和经济。高盛认为，中国中央政府可以通过加大对西方政府的财政支持来切断机房政府无紧缩所出现的负面溢出效应，那如同美国监管机构在次贷危机期间通过成为最后贷款人来切断金融危机的传播一样。关于出口和机产之间的分化，可以同中国的金属生产中得到证实啊。铝和其他废且金属的产量相比疫情之前上升了 20% 以上，而钢铁的产量下降了 5% 到10%。在房产方面，开发商越来越依赖银行融资， 5 月份对开发商的银行贷款同比增长了19%。而随着房地产销售的下滑，房贷和存款跟预付款的比例同比下降了 30% 到40%。高盛银行股票团队预计从 2024 年到 2026 年，房地产贷款将增加 4.5 万亿人民币，以完全期待收缩的房地产债券和设防的影子银行贷款。',
    fieldInfo: ['时间', '金属种类', '产量变化']
  },
  {
    text: '中国经济分化并不止于出口和房地产基础设施的固定资产投资。细分项显示，建立燃气和水的生产投资已同疫情前水平翻倍，远远超过了整体的基建的投资增长。因为中国政府首先优先考虑农源供用安全和脱碳。在零售销售当中， 5 月份代线销售商品同比增长13%，而餐饮销售仅增长5%，线下商品的销售保持在去年同期的水平。',
    fieldInfo: ['经济领域', '同比增长']
  },
  {
    text: '7月中旬将举行两场重要的政策会议，前者将专注于评估当前的经济状况，并为今年剩余时间制定周期性的政策安排。后者将专注于至少未来五年解决经济结构当中的重大改革议程。鉴于一季度的实际， g GPT 同比增长5.3%，而且去年基数较低，那么 G2 季度增长可能高于5%，政府的全年增长目标仍然在轨道上。',
    fieldInfo: ['季度', '同比']
  },
  {
    text: '高盛认为，政策执行者不会在 7 月份的首场会议上释放任何重大的刺激措施，宏观政策的证件可能大于维持当前立场和执行现有的政策。另一方面，鉴于 5 月份宣布的最后一批措施不及预期，可能存在引入更多期产宽松政策的可能性。在货币政策方面，资本外流的担忧和银行利润率的下降限制了央行降息的能力。高盛预计三季度将降息 25 个基减，以适应大量政府债券发行，并预计季四季度9月首次降息后会再降息 10 个期减。在财政政策方面，高盛预计政府债券的发行将在下半年显著增加，以完成年初发行缓慢的全年配额。除非增长急剧放缓，否则基建的投资不会加速太多。对于政府 3 月份公布的预算计划，高盛虽然预测中国的增强型的弹盛赤字从去年的 gdp 11.2% 会适度扩大到今年的11.9%，但由于今年出口强计可能会存在财政扩张不及预期的风险。信贷政策方面，正如央行行长6月 19 号陆家嘴论坛上所说，由于金融套利的虚假贷款和监管机构随后对金融系统中这种资金空转的打击，信贷增长与 GDP 增长之间的联系已经减弱。预计摄容总量的增长将同去年的 9.5% 放缓到今年的9%。在住房政策方面，4月的政治局会议表明，决策者希望严防房地产市场的尾部风险。由于地产价格和活动的持续下行，以及机房国企通过央行的贷款计划购买空池公寓的速度缓慢，高盛预计进一步削减房贷利率以刺激需求，同时为去库存提供更多的资金和效率的支持。在外汇政策方面，鉴于美元持续强势和资本外流的压力，高盛认为央行将在短期内保持美元对人民币汇率的稳定，三个月的高盛预测是7.3，因为外汇市决策者可以迎来抵消关税对出口负面影响的工具。 2018- 19 年的经验表明，如果特朗普赢得美国大选，而且正如他最近几个月所宣称的，会对中国实施正大的关税，那美元兑人民币可能会显著贬值。',
    fieldInfo: ['降息时间', '降息基点', '原因']
  },
  {
    text: 'Because Japan is one of the most import dependent countries in the world, importing over 90% of its energy and over 60% of its food, a weak yen means inflation has returned to Japan for the first time in decades. ',
    fieldInfo: ['import ratio', 'import type']
  },
  {
    text: ' For context, in the post war years, Japan experienced many decades of rapid economic growth in a period dubbed the Japanese Miracle. From 1955 to 1990, Japanese growth averaged 6.8% per year, and GDP multiplied eight times, with growth falling below 3% only once during the 1974 oil shock.',
    fieldInfo: ['year', 'gdp growth rate']
  },
  {
    text: `Anyway, this anxiety subsided in the 90s when Japan experienced an enormous financial crisis after a rapid appreciation in Japanese stock and real estate prices during the 80s. In 1990, the bubble burst and continue to burst for a while. In the decade after 1990, residential house prices fell by more than 50%, commercial property prices fell by something like 85%. And Japan's main stock index, the Nike 2,2,5 fell by about 75%. Japan's economy never really recovered and growth and inflation both remained close to zero until very recently.`,
    fieldInfo: ['rate value', 'rate type']
  },
  {
    text: `From 2016 until late last year. The Bank of Japan even began what's called yield curve control, which essentially involved buying up enough debt to guarantee that government borrowing costs wouldn't go above a certain level. Japan's ultra loose monetary policy came under pressure in 2022 when inflation started rising across the world. Usually, central banks raise interest rates, but the bank of Japan decided not to, both because inflation was relatively low in Japan, but also because thanks to its enormous debt burden, even a slight raise in interest rates would translate to a massive increase in debt servicing costs, especially for the Japanese government. Unfortunately, things have become more difficult as other central banks have raised rates, making their currencies relatively more attractive and sparking a decline in the yen. In the last year, the yen has fallen from about 130 to the dollar to a 34 year low of 160 to the dollar on Monday. Now the speed and severity of this decline presents a difficult dilemma for the bank of Japan because thanks to Japan's reliance on imports, it sparked significant inflation in essential items like food and energy. But they still don't want to raise rates for the reasons we've just mentioned earlier. This is why on Monday evening, instead of raising rates, the bank of Japan used billions of dollars worth of Japan's foreign exchange reserves to buy up the yen on the international market, artificially inflating its value. While this seems to have worked in the short term, as of Tuesday morning, the yen is now trading at nearer 155 to the dollar. It's both expensive and fundamentally unsustainable. Even if the bank of Japan has some of the largest foreign exchange reserves in the world. All in all, assuming the bank of Japan won't engage in significant rate hikes, this means that the yen is very much dependent on what goes on in the rest of the world. If inflation comes down and other central banks start cutting rates, then this will reduce some of the pressure on the yen. But if inflation turns out to be stickier than we'd like, which seems to be the case, then the divergence between the bank of Japan and other central banks will persist, which means more downward pressure on the yen. If this happens, then the bank of Japan won't be able to stave off the yen's decline with exchange reserves forever. And eventually, they'll have to choose a horn of their uncomfortable dilemma, either to just accept the yen's decline and all the inflation related political turmoil that comes with it all, raise rates and just hope that the world's most debt burdened economy can somehow deal with it.`,
    fieldInfo: ['date', 'yen to dollar']
  },
  {
    text: `Blanket is all over the news. Linkage is now more valuable than Zomato. Linkage reported over 2,300 for rupees and revenue. And then now speak about Zomato, they speak about blinking bigger than tomato right now with the valuation of roughly $13 million and a market share of 46%, it has disrupted India's 23,000 crore quick commerce industry, a company that Zomato acquired in 2022 to enter into quick commerce, but now has become more valuable, the Zomato's own food delivery business. In fact, the company 3 x its revenue from 800 crores to 23 crores and is expected to break even in the first quarter of Fi 2025.`,
    fieldInfo: ['company', 'marker share', 'valuation']
  },
  {
    text: `By the way, this is going to be detailed, so feel free to pause the video wherever you feel confused. First of all, let's take a realistic average order value of 600 rupees, which is very close to what most people usually order on blink it. If you look at the revenue side, which is the money that bind it earns here for themselves from each order is divided into three sources. The first one is warehousing services and marketplace commissions. This is basically the amount that suppliers are paying to blanket for showing and selling their products. And see on every order of 600 rupees, 11 to 13% is coming from suppliers, which is roughly 72 rupees.`,
    fieldInfo: ['revenue source', 'revenue value', 'revenue ratio']
  },
  {
    text: `Now the second part of the income of this order is the ads that come companies show on blanket. This is the price that brands pay to show their products above other products as you scroll the app. For example, brew might pay to show its coffee first when someone searches for a keyword like coffee, it's roughly 2.3 to 3.5%. In our case, let's take 3.5% and it will come down to 21 rupees.`,
    fieldInfo: ['keyword', 'ad rate', 'cost']
  },
  {
    text: `The next is customer fees, which includes your delivery fees, handling fees for packaging and delivering the food to your doorstep, and even additional fees like fees they charge you for having a small cut. This percentage comes at around three portion of the average order value and is roughly 18 rupees in our case. By the way, there are also other levers like membership plans or free delivery plans that these plan platforms try to sell you often like Zepto does it with their offering of zeptopass. But if we don't over complicate and dive much deeper into this, we see that in a nutshell, on an average order of 600 rupees, blanket owns roughly 110 rupees. This 110 rupees is known as a take rate, the share that blanket keeps for itself from an order.`,
    fieldInfo: ['take rate', 'customer fees ratio']
  },
  {
    text: `Now let's come down to the cost side. Even here you have four elements. The first one is the biggest one, which is the last mile delivery cost, which is the last step when the riders deliver the orders to you and cost about roughly 7% to blanket. And in our case, it would come down to 42 rupees. The next one is dark store mid mile and warehousing cost. This entire combination of cost comes down to about 6.5%. And in our case, it would be 39 rupees. The other variable cost, which includes packaging, washes, support, communication and payment charges are roughly 2%, which comes down to 12 rupees. And now the fourth and the last one is customer acquisition cost, which is the discount, the incentives and the offers they try to give you to make tempting these for you. This comes at about 0.2 to 0.3% at about 1.8 rupees. So if you subtract these two amounts, blink it on roughly 15 rupees from entire transaction. This 15 rupees is not the net profit, by the way, but the contributing profit. Now what is that? See, contributing profit is the profit that the company is earning by serving each order. And company considers only the variable expenses in this case, which is the expense that we have already discussed. And it does not mean net profit because there are so many fixed expenses that are not considered like expensive salary of tech folks, rent, insurance, depreciation, and all similar big sums of money.`,
    fieldInfo: ['cost element', 'cost ratio', 'cost value']
  },
  {
    text: `The answer to this is the dark stores, the 2,500 to 4,000 square feet big stores that are located in 1.5 to 3 kilometer radius near your homes to ensure super quick delivery. And by the way, these stores are super big. For example, if your nearest kirana shop has about 1,500 SKUs, these stores can have 4 x a number of excuse. In fact, a highly efficient dark store can do a better gross merchandise value per square foot than a highly organized supermarket like Dmart. So while a dark store or blanket can do a GMV of 90,000 rupees per square fit, Mart can only do a GMV of 47,000 rupees per square fit. But how does this work? See, these stores are like supermarkets, but have no Hawkins, which means that only rider can go and collect stuff from there. These stores have a lot of inventory that comes from Mother Warehouse store, which is located in the outskirts. So to give you context, for every 40 dark stores located in the city, there is always a mother warehouse, which is located at the outskirts or city. And that is more than 10 times big as a dark store, which is about 20,000 to 1 lax, 75,000 square feet big. It is super huge. And companies don't set dark stores everywhere, by the way. They are smartly set based on multiple parameters like average household income of the area, peak time traffic of the area, infrastructure structure of the area, and also the population density. Also, there's usually about a staff of 25 to 30 people who are working in three shifts in these dark stores who would take care of the packaging. And as we've discussed earlier as well in the video, that the operating cost for a dark store comes at about rupees 22 for each order. And if you want to understand this calculation better, we have put it here. So you can pause the video and look at this table.`,
    fieldInfo: ['store type', 'store size', 'SKU', 'GMV', 'staff count']
  },
  {
    text: `Now blanket has done a really solid job here as they have, right now, the highest number of dark stores with 451 stores in 27 cities compared to 450 stores of Insta margin, 25 cities, 30 of Zepto intensities and 350 stores of Big Basket in 35 cities. By the way, this is not something they built in a day because it was the first grocery app in the country, which started in 2014 as growers. So their team and their execution is way more experienced if you compare them with other competitors, and now they're just building on this and increasing their penetration throughout the country. By the way, they're mostly penetrated in north and east India, and 90% of the GMV comes from top paid cities. But as they enter south and other cities, this can be a huge opportunity for them as they already have an experience DNA running in the organization.`,
    fieldInfo: ['company', 'stores number', 'cities number']
  },
  {
    text: `Now coming down to the second insight, which is cracking high average order value. But why are we talking about AOVs? Average order value plays a big role in quick commerce because bigger the average order value, bigger is the contribution margin for the company, which means that delivering just a set of bananas or apples is less profitable for blanket. Then delivering a set of bananas, apples, onions, tomatoes and a packet of bread together. And blanket has the highest average order value if you compare it with all the comparators. And just look at the stark difference by yourself. For big Basket, the AOV is about 400 to 500 rupees. For Zepto and Instamar, it is around 450+. And for blanket Au UV is about staggering 6,35 rupees. This is something that is definitely giving them an edge in pulling one of the most important levers in the ecosystem. In fact, in the last quarter, this number was 523 rupees at the start of Q1 fi 23. It just shows the speed at which they are growing really fast, and they have done this really well through their amazing SKU strategy.`,
    fieldInfo: ['company', 'AOV']
  },
  {
    text: `Not talking about the third insight, new customer acquisition. See, blinkits market share has not been the highest forever. It was 32%2082. And in the same period, Instama's market share has fallen from 52%, while Zeptos has increased from 15 to 28%. And we had to talk about the elephant in the room, the Zomato Effect. See, Zomato is the biggest food delivery app that has more than hundred million active users every month on its app and a market share of more than 56%. When it comes to food delivery, these users are more than three ties what blanket has at the moment. So even getting 5% of Zomato's monthly active users as new customers could bring more than 33% rise to their current Mau base.`,
    fieldInfo: ['company', 'marker share']
  },
  {
    text: `Want to show you something cute little condo in Toronto's Harbor Front neighborhood, bustling part of the city. It goes on the market in the summer of 2022. The sellers put it up for $480,000. It didn't sell early. 2023, it's back on the market for 460 k. No luck later that year, posted again at 4,50 k. Still nothing. And a few months ago, the sellers tried again. At $430,000, no takers. This condo was sitting on the market for more than 400 days without a sale. Right now in Canada's biggest cities, there's a ton of condos like this struggling to sell. A condo sales in Toronto, for example, haven't been this low since the financial crisis in 2009.`,
    fieldInfo: ['year', 'price']
  },
  {
    text: `Let's compare what a condo investment in Toronto looked like in 2016 to today. So according to the Toronto Real Estate Board, the average price of a one bedroom condo back then in 2016 was about three hundred thousand dollars and with 2016 interest rates about 2.7%, that worked out to a mortgage payment of about eleven hundred dollars a month. Rent for the average one bedroom apartment at that time was about sixteen hundred and sixty dollars. Not bad from an investor point of view, even with, you know, maintenance fees, property taxes, that condo is essentially paying for itself while you build equity.`,
    fieldInfo: ['average price', 'inerset rate', 'mortgage_payment', 'rent']
  },
  {
    text: `Now what if you were to buy a one bedroom condo today in Toronto? That could cost you about 550 grand. So prices have very clearly gone up, but so have interest rates. The carrying costs on a property are far higher than they ever used to be. Well, not ever, but in recent memory. At current rates, 6.8%, maybe now you're paying more than $3,000 a month for your mortgage payment alone. Then you've got, you know, property taxes, maintenance fees and the average rent per unit like that, about 24 hundred dollars a month you're now paying out of.`,
    fieldInfo: ['price', 'inerset rate', 'mortgage_payment', 'average rent']
  },
  {
    text: `Now the renewals come in and you're losing a lot of money, but you've actually come to realize in the last 12 months the price of that condo has probably dropped about $40,000. So you're starting to enter into a state of actual fear.`,
    fieldInfo: ['time period', 'price change']
  },
  {
    text: `According to stats Cam, the average size of a new condo in Toronto has shrunk significantly over time. From 1981 to 1990, new condos were on average about 1,000 square feet. From 2016 to 2020, they were around 650 square feet or about 40% smaller. And if you ask anyone who lives in the downtown core right now, 650 square feet actually feels pretty big.`,
    fieldInfo: ['time period', 'average size']
  },
  {
    text: `Right now, for example, in Toronto and Vancouver, three quarters of larger condos, the ones, you know, maybe more suitable for a family built decades ago, those are being lived in by the people who own them. But for those much smaller condos built after 2016 with investors in mind, only about half are being lived in by owners. Remember that cute little studio that we showed you at the start that took 400 some days to sell. It was 330 square feet. Here's a two bedroom, 700 square foot unit in that same building. It's sold earlier this month on the first try in just 13 days. If we.`,
    fieldInfo: ['days to cell', 'unit size', '']
  },
  {
    text: `Back then in 2020,2021, even into the beginning of 2022, we saw these historic low interest rates and people were taking out loans then and taking out bigger loans, right? They go and buy a house that they wouldn't have been able to afford. 3% or 4%, but they could afford at 1.25%. They called.`,
    fieldInfo: ['year', 'interest rate']
  },
  {
    text: `No. So let's say there's a young couple in Ontario that bought an average priced house in 2019,$631,990. They put pretty standard down payments, down 20 percents, which leaves you with a mortgage size of about $500,000. Amortize the loan over 25 years, they take a five year fixed rate of 2.9%, which was also kind of standard at the time. That means they've been paying about, and I'm rounding to the nearest dollar here, 2,367 bucks for the past few years. But now that mortgage is up for renewal. Welcome to 2024. And the couple signs on to another fixed rate mortgage, but they have to do it at the bank's current rate, which is around 6%. That means their new monthly payment is, again, I'm rounding here, $3,075 a month or an extra 700 bucks a month. Right.`,
    fieldInfo: ['year', 'fixed rate', 'monthly payment']
  },
  {
    text: `Think of it this way. This circle is your $2,200 a month mortgage payment at a relatively low interest rate pending on the overall size of your mortgage, that might mean $900 of that payment is just servicing interest with the other 13 actually paying your loan back as the interest rate rises. Maybe now instead of 900 dollars a month, it's 20. One hundred dollars a month in interest. But your contract says your total payments stay the same, so you're still paying 22 dollars a month, meaning only 100 of those 22 hundred dollars are actually paying down your loan at that point. I have news for you. You're very close to being underwater, stuck in a perpetual state of paying down a loan where you're only barely paying down that loan. Welcome to lifelong debt, the time it will take to pay off his mortgage nearly doubled from.`,
    fieldInfo: ['monthly payment', 'interset payment', 'principal payment']
  },
  {
    text: `Collectively, we're just starting to approach the edge of this cliff. RBC estimates about $186 billion worth of mortgages are up for renewal in 2024. Next year, it'll be 350,15 billion. That's a ton of mortgage debt that was taken on at historically low interest rates by people who may or may not have been able to afford getting into the housing market otherwise.`,
    fieldInfo: ['year', 'mortgage_debt']
  },
  {
    text: `What would you do if one day your neighbor, who you've known for years, you see him building a bomb shelter? Would you think that guy's crazy or would you wonder what does he know that I don't? Turns out banks right now are building a bombshelter. Just this quarter, Canada's big six banks have set $4.3 billion aside to cover bad loans. That's almost double what they set aside in the first quarter of last year and more than 11 times what they set aside in the first quarter before that.`,
    fieldInfo: ['quater', 'year', 'amount_set_aside']
  },
  {
    text: `This is important. About 65% of them, 70% of them have not noticed any radical increase in their payment because their mortgage company sold a product where the payment did not go up when prime went up. Their payment did not go up when prime went up. That's the important part to understand, because it means you might have people ultimately paying more without even realizing it.`,
    fieldInfo: ['percentage']
  },
  {
    text: `Now, luckily, most economists do expect rates to keep dropping. According to that same RBC report, it still might not be enough to, quote, save this cohort to get them down to a more manageable monthly increase like 20%. They argue the bank of Canada would have to lower its prime rate way down to around point two five % by July 2026, something they admit is an unreasonable expectation.`,
    fieldInfo: ['date', 'rate change', 'monthly_increase']
  },
  {
    text: `The old rule of thumb in my day was you spend about a third of your income on housing. Now you'll hear anecdotal evidence, particularly in places like Vancouver, Toronto, where you'll hear 70 to 75% of income is being spent on housing. So in those cases, then if they have to reset at a higher interest rate, it's the house that's gonna go down first. So.`,
    fieldInfo: ['location', 'income_spent_on_housing']
  },
  {
    text: `In order to get the most accurate reading on the US housing market inventory situation, we need to consider both supply and demand. Supply in this case is the level of inventory for sale and demand is the current case of sales volume. If we start with sales volume, we can see the existing home market has a sales pace of roughly 3.7 million homes per year, while the new home market has a sales pace of 619,000 homes per year. Right off the bat, we can see how the existing home market is almost six times larger than the new construction market in terms of sales volume. Both of these markets, existing and new, have seen a huge reduction in sales volume or buyer demand since interest rates have increased, as affordability is out of reach for most people. If we take this annual sales pace and divided by 12, we can get an idea of the average sales pace per month. Of course, there are seasonal patterns, but if we normalize for those effects, we can see that the current monthly sales pace in the existing home market is roughly 309,000, and the new construction market is selling about 51,000 homes per month. At the peak of the housing boom during the pandemic, the existing hallmark had a sales pace of 500,000 units per month and the new construction market was selling nearly 90,000 units per month. Now that we have an idea of the current level of demand, we have to look at supply or the level of inventory for sale in the existing home market. There are currently 1.1 million homes for sale, one of the lowest on record. If we just look at inventory alone. In the new construction market, there are 479,000 units for sale, one of the highest levels on record, only surpassed by the housing bubble of 2007.`,
    fieldInfo: ['market type', 'sale pace annual', 'sale pace monthly', 'sales_pace_peak_monthly', 'inventory']
  },
  {
    text: `You can clearly see how there is nuance to the situation of US housing inventory, the best measure of US housing inventory takes into account both supply and demand and is called the month supply. In other words, how many months of inventory are available for the current pace of sales value. If we take the current level of inventory for both the existing hall market and the new hall market, and we divide it by the current monthly pace of sales. We can see how many months it would take to sell all the inventory at the current pace of sales in the existing home market, that month's supply figure or the inventory level divided by the sales volume, 3.7. In the new construction market, it is 9.3.`,
    fieldInfo: ['market_type', 'month supply']
  },
  {
    text: `Generally speaking, the 5.5 to 6.0 level is considered a balanced market where there is no significant upward or downward pressure on prices. When the month's supply level is below 5.5, that means there is very little inventory available for today's market conditions and prices generally rise. On the flip side, a high level of month's supply means there's too much inventory and prices must fall. The existing home market has a month supply of 3.7, which is very low, but it's been increasing since the absolute historic level of one point six in January 2022. Never in the history of the US housing market has the month's supply of existing homes been that low. This created a very unhealthy situation in the existing home market. The inventory situation in the existing hall market is still very tight, but it's now at the highest level since before for the pandemic. The new construction market is a completely different ballgame with a month supply at 9.3, super high and way above the balanced 6.0 level. There is way more detail to the situation in the new construction market that we'll uncover in just a moment. If we look at the total US housing market situation, both existing and new construction, the aggregate month supply figure has increased to 4.5. So yes, the total inventory situation is still very tight on a national level, but the level is rising and at the highest point since 2,015. The monthly numbers are volatile, so let's look at a yearly average to make things more clear. This shows the month's supply for the total US housing market by year. 2024 is a partial year, and the current level as of May 2024 is also noted in the chart. As of May 2024, the total month supply situation is 4.5, which it hasn't been since 2015. You can also see the four years where the total month supply was below 4.0, which is extremely tight. And you can also see the 2021 situation at 2.6, which was crazy unhealthy. One major point is that this current 4.5 level is the national average. But as we know, real estate is very regional. So this means that there are some markets that are near a month supply of 6 and feeling downward price pressure, while some markets are still down at 3 and seeing prices rise with multiple offers. The new home market with a month supply of 9.3 is way above the balance level of six point zero, and there are price cuts and discounts in that market.`,
    fieldInfo: ['date', 'markey type', 'month supply']
  },
  {
    text: `In June, the National Association of homebuilders reported that 29% of builders cut home prices with an average price reduction of 6%. And 61% of builders use sales incentives like mortgage rate ByteDance to boost sales. But we need to talk about the new hall market and the 9.3 month supply level in a bit more detail, because there is more than what meets BI in the new construction market. Currently, there are 479,000 units for sale in the new construction market and a current pace of sales of about 50 thousand per month. In the new home market, a home could be listed for sale when it's completed, under construction or not yet started. If we look at the percentage of inventory that is completed, we can see that of those 479,000 new home units for sale, Only 20% are completed, which means 80% are either under construction or not yet started.`,
    fieldInfo: [
      'builders cut prices percentage',
      'average price reduction',
      'builders use incentives percentage',
      'units for sale',
      'completed inventory percentage'
    ]
  },
  {
    text: `The level of completed new home inventory for sale fell below 10% during the most acute part of the US housing shortage. Normally, in between 20% and 30% of new construction inventory is completed. During really bad downturns like 2008, builders were sitting on almost 50% completed inventory, which is what led to dramatic price cuts and big layoffs of construction crews. The level of completed inventory is now back into the normal range at 20%, and it's rising, which means that if we move towards 30%, price cuts will get more intense and construction crews will be at high risk of job losses. If we take the current 50,000 new home sales pace and divide that by the amount of completed new home inventory for sale. We can see that there's currently about 1.9 months of completed inventory for sale, which is getting past the average level and into the range consistent with recessions and job losses for construction crews. If the home builders have a lot of completed new home inventory for sale, they aren't going to apply for new building permits and build even more homes. And that's exactly what we're starting to see.`,
    fieldInfo: ['period', 'completed_inventory_ratio']
  },
  {
    text: `Homelessness has been rare since the reemergence of homelessness in the mid 1980s. Usually it's been people in their 20s and 30s and 40s, but now we're approaching close to 30% of the adult homeless population are people 55 and over.`,
    fieldInfo: ['age group', 'percentage']
  },
  {
    text: `Exports from China are rising fast and US officials are nervous about this gap. We're not gonna let China flood our market. Sound familiar? There has to be a level playing field for American companies competing in China. In the early 2 Chinese factories like this one pumped out clothes and flags and cars. The sticker prices were cheap. But there was another price to be paid, American jobs. Every single employee of this plant, we'll be out of work by January. 15 years and almost 6 million jobs later, economists are debating what price another wave of imports could exact from American workers. But two key differences between then and now may have a new effect on the US economy. Look at this line. Before 2001, American manufacturing employed over 17 million people, making toys, furniture, paper goods and much more. Then word began to circulate that China was joining the World Trade Organization. And here's what it did. Joining the WTO meant China faced fewer tariffs and restrictions from its trading partners, and the result was dubbed the China.`,
    fieldInfo: ['year', 'jobs number']
  },
  {
    text: `2.5 million Americans lost their jobs from 2000 to 2007. They're represented by the blue on this map. Look at this dark blue area here. That's Silicon Valley, where companies like Apple, HP and Cisco used to manufacture goods. After 2001, they moved most of their production to China, causing a 50+ percent drop in manufacturing jobs in the county, this other dark blue county, Cedar Rapids, Iowa, lost 46% of their manufacturing jobs, primarily in furniture and machinery. But this lighter blue region here was largely spared. It's called Auto Alley. The main reason it succeeded where, say, Silicon Valley's manufacturing failed, is due to investment from competitors like Japan.`,
    fieldInfo: ['region', 'job_loss_percentage']
  },
  {
    isEnglish: true,
    text: 'Snap’s latest AR glasses aren’t its first hardware product. The company has a history of experimenting with hardware and has launched smart glasses under the brand name Spectacles. However, the company has struggled to make money from selling hardware. It first debuted a pair of smart glasses in 2016; the $130 device made it easy for users to capture short, first-person videos that they could post on Snapchat. However, the product failed, and the company had to write down $40 million due to losses from unsold Spectacles. Snap once again tried to sell new Spectacles smart glasses in 2019—this time a more premium version for $380—but that too didn’t take off. In 2021, it unveiled new glasses with advanced AR capabilities, but instead of selling them to consumers, the company sold the device to developers, hinting that the glasses were more of a prototype than an actual consumer product. Beyond glasses, Snap also tried to sell a flying drone for $230, but that device was abruptly discontinued after just a few months',
    dataTable: [
      {
        year: 2016,
        product: 'Spectacles',
        price: 130
      },
      {
        year: 2019,
        product: 'Spectacles (premium version)',
        price: 380
      },
      {
        year: 2021,
        product: 'new glasses with AR',
        price: null
      },
      {
        year: null,
        product: 'flying drone',
        price: 230
      }
    ],
    fieldInfo: [
      {
        fieldName: 'year',
        description: 'The year when the product was launched',
        type: 'date',
        dateGranularity: 'year'
      },
      {
        fieldName: 'product',
        description: 'the name of product',
        type: 'string'
      },
      {
        fieldName: 'price',
        description: 'The price of the product',
        type: 'numerical'
      }
    ]
  }
];

export const capcutMockV2Data: any[] = [
  {
    text: `富士康为什么突然被查？这对全国120万的富士康员工 有何影响？最近， 富士康在广东、江苏等地被税务稽查。与此同时呢， 自然资源部门 对富士康在河南、湖北等省市的用地 进行现场勘查。别小看这短短的一句话啊， 释放了两个信息， 一、是税务部门调查有没有偷税漏税。二是自然资源部门 调查土地的使用情况。要知道， 当年全国各地为了吸引富士康 使出浑身解数， 不仅帮富士康招人， 还有各种减免税， 甚至有些地方啊， 还给富士康 不能多说了啊， 按理说， 咱们给了富士康这么多优惠政策， 富士康应该感激才是啊！
可谁能想到， 老郭这是吃尽红利 翻脸不认人呐！他居然说这是在给大陆赏饭吃！富士康为啥敢如此傲慢呢？
先来看一组数据， 富士康位居财富世界500强第20位， 在中国企业中 仅次于国家电网、中石油、中石化 以及中国建筑集团。
就连咱们熟知的宇宙第一大行 工商银行啊， 都排在富士康后面。
富士康不仅财大气粗， 还跟全国各地啊深度绑定。
目前 富士康在全国的工厂达到40多个， 总员工数超过了100万。
所以很多人说 不能碰富士康啊， 万一富士康跑了该咋办？
富士康真的是大到不能碰了吗？
并不是。过去40年 我们之所以给富士康各种政策优惠， 不是因为富士康有多强， 而是因为富士康背后的苹果公司呀， 太过强大。
没有苹果的订单， 富士康啊 连一毛钱都不值。
过去我们扶持富士康， 那是希望打入苹果供应 链，希望苹果的零部件啊， 可以在中国生产， 在中国组装， 最后出口到全世界， 构建起一条啊 完整的电子信息产业链。
可谁能想到， 从2019年开始， 苹果供应链开始大规模的去中国化， 中国大陆的供应占比 从巅峰时期的26%下降到如今的2.5%。
按照苹果的如意算盘， 要想完成去中国化， 第一步呀， 就是先在越南和印度 建设一两座富士康工厂。
第二步呢， 就是把中国供应商一点点踢出去， 换成海外的供应商。
第三步，逐渐增加越南、 印度这些海外供应商的订单。
第四步，也是最后的一步， 就是把中国大陆的富士康啊， 全部迁出去， 彻底完成去中国化。
如今的苹果已经走完第二步了， 马上就要进行第三步了。
可让他万万没想到的是， 华为啊，居然在今年9月起死回生了。
华为的崛起 彻底打乱了苹果去中国化的节奏。
还记得今年国庆黄金周吗？
华为上市仅仅一个月啊， 就把苹果在中国的市场份额 干到只剩17.4%。
吓得哭客呀， 赶紧来中国亲自下场带货！
顾客为啥荒凉？
如今的中国是苹果全球第一大市场， 也是苹果全球最大的食物来源。
吃着中国人的饭， 砸着中国人的碗， 只想在中国赚钱， 不想为中国做贡献。
不仅不做贡献啊， 还一门心思向外转移产链， 这样的企业以及背后的代工厂， 你说凭啥还要给他特殊优待呢？
现在你明白 国家为啥要坚定支持华为了吗？
支持华为，就是在支持中国产业链， 只有华为链才能对抗苹果链。
华为链呀， 就是中国链。关注4G实务分析，收。
`
  },
  {
    text: `俄罗斯这个国家 真的是个非常神奇的存在啊， 说到政治军事， 没有人敢小瞧他， 他拥有全世界最大的国土面积 和最多的核弹头。
但是同时呢， 一提到经济啊， 那似乎就没有俄罗斯什么事了。
你看这俄罗斯哈， 在短短的半个世纪里面 就经历了什么政治动荡啊、 恶性通胀、 寡头黑帮、 高速发展、 战争、政府违约、 经济危机、 激进的改革等等等等。
所以今天呢， 小林就来给大家一起梳理一下啊 这个错综复杂而又独一无二的 俄罗斯的经济。
它到底是怎么回事？
我先声明一下啊， 一个国家的经济 确实是太错综复杂了， 所以呢，我只能挑我觉得比较重要 又有意思的地方来跟大家分享一下， 但是我觉得 重点应该基本上也都是重点。
大家如果有什么自己的观点 或者想法， 也欢迎在评论区留言讨论。
但是哈，咱话说好了， 留言区我们好好说话， 别动不动就打起来。
还有就是最后啊， 我会有一个对俄罗斯经济的 一个简要 橄榄， 你要是也不感兴趣，都发生了什么， 就想看那个最经典的橄榄， 你可以直接划到最后， 但是我还是非常建议哈， 把前面这些东西都看一看， 毕竟能像小林这种 把这些复杂的东西又讲的清楚直白 又很有意思的人， 在这个世界上也不多了啊！
你也可以点个赞表示一下。
说到俄罗斯经济啊， 咱必须得从前苏联说起。
所以这块呢， 我就一丢丢带到历史， 帮大家刷新一下记忆。
沙俄爆发民主革命， 迫使沙皇退位。
之后，以 列宁为首的社会民主工党 推翻了临时政府。
经过了5年的内战， 1922年苏联诞生。
两年之后， 1924年这个人上台， 成为了前苏联的最高领导人， 他就是约瑟夫维萨里亚的诺维奇 斯大林。从此啊， 苏联就真正的开始 全面推行计划经济。
计划经济哈， 就是说所有的经济资源 从分配、生产 甚至到一部分的消费 都是按照计划走。
就比如说哈， 这点物资急缺了， 上面只要一指命令，哗， 所有的物资就都调过来。
再比如说哈， 我们现在要开始发展重工业， 需要大家一起来建工厂， 然后上面一指命令， 这工人全就都过去， 他也不需要时间 等市场经济进行自我调节。
其实这种模式哈， 在你方向非常明确 或者 要进行整体的大规模改革的情况下 是非常高效的。
而当时的苏联呢， 就处于工业化和现代化 都严重不足的情况， 他就非常适合计划经济。
于是1928年之后， 斯大林的前三个五年计划， 那可谓是效果拔群， 前苏联就迅速摇身一变， 从一个落后的农业国家 变成了一个工业大国。
你看啊， 这使前苏联的人均GDP从20年到40年 翻了三倍多。
而你想啊， 那时候1929年的美国 正在经历着大萧条， 整个西方哈都跟着遭殃。
所以说啊， 这20年真的是在斯大林的带领下， 把前苏联的经济带上了一个新高度。
虽然说哈，也有各种什么政治迫害、 大清洗，但是呢， 光从经济的角度上来说， 还是效果罢群的。
这边呢，尝到了计划经济的甜头。
另一边呢， 二战啊，苏联的国际地位又 得到了极大的提升， 可谓形势是一片大好， 又经历了一段时期的高速增长。
不过慢慢的啊， 从60年代开始， 这个前苏联的经济结构 也越来越复杂， 经济发展也逐渐稳定， 那计划就不是那么好计划的了。
你说 要没有市场这个无形的手在那调控 他，再厉害的政府 也不可能说 哪哪的经济 都给你计划的那么井井有条， 更何况啊高度集权的这种计划经济。
他还有一个问题， 就他一般情况下都是领导指哪打哪， 这就导致了前苏联政府的贪腐呀 也日益严重， 企业的创新就会严重受损。
前苏联就陷入了停滞时期。
`
  },
  {
    text: `除非是一场巨大的危机， 不然的话 你根本没有办法去解释 此刻的股神巴菲特， 他到底在等待些什么。
美国银行， 这是一家在西方世界， 甚至说全球金融行业里 都非常有声望、 位高权重的超级巨头。
巴菲特则是从2011年开始 对这家公司进行了大手笔的投资。
13年时间过去， 他一路买入， 从不卖出， 甚至说一口气把自己1/10的仓位 都压在了美国银行的身上。
几乎所有人都觉得 美国的标志性金融大佬 买入美国标志性的金融巨头 这笔买卖天作之合。
但是94岁的巴菲特 却把所有人都打了一个措手不及， 此时此刻， 他在狂卖美银。
根据美国SEC官方披露啊， 光是在9月的4号、5号 还有6号这三天， 他就卖出了1870 是4万股的美国银行。
而如果要把时间拉得更长一些的话， 那么从今年的7月份开始， 巴菲特就已经从美银的身上 套现了将近70亿的美元。
什么概念？
500亿的人民币。
这笔钱对于巴菲特巴老爷子来说 也许不算太多， 但你要知道， 上个月 他不计成本的抛售苹果公司， 就已经把全球金融市场吓死 魂飞魄散。
当时啊，他在毫无征兆 没有任何预告的情况下， 直接把苹果的仓位砍掉了50%。
说真的，在我们金融行业当中啊， 甭管你干了多久， 也没有人见过这样的场。
甚至就连美国的华尔街 现在也纷纷开始了议论， 说抛售苹果 还有美英这样的常见股票， 根本就不是巴菲特的风格。
看到这你肯定会以为啊， 这是他年事已高退出江湖的 前兆。就像是曾经的地主一样， 每到过年就要颗粒归仓， 清算一波自己的家底。
但你知道吗？
在过去的2023年， 巴菲特依靠投资定数了6900个亿， 而且还在年初正式的宣布了接班人， 规划之清晰， 战略之稳定， 看不见任何散场的。
而同时呢， 全世界的金融机构、 各大投行的交易员 又眼睁睁的啊 看着他手里的现金累的跟山一样高。
截止到目前 已经有差不多3000亿的。
哪怕你再不关心经济， 也应该思考了， 巴菲特现在到底在等待什么？
上一次 他手里持有如此高比例的现金， 还得回忆到2005年。
而在之后的没多久， 美国就爆发了次贷危机， 他顺势抄了一波大底。
夕阳之所以耀眼， 是因为牺牲了整个白天 所有的光芒。
而94岁的巴菲特， 此刻完全有可能啊， 正在屏息等待， 准备挥出他光荣山崖里最后一棒！
`
  },
  {
    text: `这个菲律宾怎么回事啊？
双倍差战，五渣， 回回碰瓷， 次次灰头土脸， 这有完没完啊， 这人啊，那么好了， 这货到底是个什么样的国家？
这么做图什么？
谁在背后给他撑腰？
今天我们从经济的角度 来给大家讲讲菲律宾， 三个词来概括一下菲律宾， 那就是美国舔狗、 寡头经济和菲佣帝国 对美国爱的深沉。
一度甘当美国殖民地， 不想独立， 甚至想加入美国成为人家一个州， 奈何美上百个门阀家族轮流坐庄， 把持政权， 断经济， 把曾经的亚洲第二富国祸祸 成了亚洲最穷的国家之一。
而另外支棱起菲律宾经济的 不是什么高科技、工业、 金融业， 而是遍布全球的雇佣和劳工。
总之横看竖看就是有点挫呀， 人是怎么变成今天这个样子呢？
简单来说呢， 就是先天条件一般， 还总想走捷径 哈哈哈。这个国家，从地图上来看啊， 挺有意思的， 由7000多个岛来组成 七零八落， 很难大规模连成片的发展， 于是很长时间呢， 人家都没有建成统一的国家， 而是各个岛上的家族部落啊， 各管各的。
直到16世纪啊，迈之伦转悠到这了， 带着西班牙殖民者 征服了这，菲律宾呢， 才正式建了国。
接着人又相继被美国殖民 日本占领， 再被美国收回， 而那些岛上的大家族啊， 也成了殖民代理人。
那这个过程啊， 美国的影响是最大的。
人，一边在这搞建设、 搞教育，让菲律宾 成了亚洲最早 走上工业化道路的国家之一。
一边呢， 又残酷的镇压菲律宾的民族主义， 扶持清美势力。
那结果 就是，菲律宾的经济是发展起来了， 可是完全依赖美国。
而看似有了国家政权， 其实硬骨头几乎都被打没了。
那情况有多夸张啊？
1929年美国经济大萧条， 没精力管菲律宾了， 想甩手啊， 让人独立得了， 这菲律宾人反而不干了， 说怎么的， 霍霍够我了， 翻脸不认人了是吧？
想分手啊， 没那么容易。
于是两边各种谈条件 扯皮，直到1934年才谈妥了。
美国接着扶持菲律宾， 10年之后再让菲律宾独立。
后来呢， 人民意义上确实也是独立了， 但是加入美国的心啊， 他一直没死。
上世纪60年代， 就有菲律宾的国会议员呢， 就发起入美运动， 要让菲律宾加入美国， 甚至呢，还说可以靠人多优势啊， 选菲律宾人当美国总统。
而这类运动啊， 断断续续到现在都还有， 那场面 大概就是美国，我叫你一声爸爸， 你敢应吗？
可美国呢？
大家看到了啊， 看到了是他主动啊， 跟我没关系啊。
其实1946年独立之后的菲律宾啊， 经济情况一度非常好， 工业基础 是完全继承美国殖民时期的遗产， 经济贸易呢 也几乎完全适合美国的单边贸易。
而50年代之后， 朝鲜战争和越南战争先后爆发， 菲律宾凭借地理优势啊， 拿下了大量的美军订单， 这生意红火呀， 这也让菲律宾的经济坐上了火箭。
1960年，菲律宾GDP啊，是排全球第20。
>而放眼亚洲， 除了日本几乎没有对手， 而人均GDP 甚至一度都是我们的3倍之多。
人家首都马尼拉 人送外号是亚洲小纽约， 甚至一度有机构预测说， 50年之后， 菲律宾将会成为世界第十大强国。
换句话来说， 人能跟法国、 意大利这种老牌资本主义国家 坐在一张桌子上吃饭， 好家伙呀！
啊！那现在我们听起来 感觉跟科幻故事一样， 因为不用50年， 你看看现在 人已经凉透了。
全亚洲最穷的国家之一， 泰国、马来西亚都能甩他几条街。
为什么会变成这样呢？
就是因为菲律宾大家族门阀遍地， 菲律宾从被殖民到老大 不乐意的独立， 这就相当于什么呀， 殖民的走了， 世家大族们呢， 继续接力统治。
比如在1987年的菲律宾国会， 总共200个众议员， 其中有130个是来自于大家族的， 另外还有39个呢， 跟大家族还是沾亲带故的。
这些家族门阀呀， 各种资源在手， 那还不利用特许经营权、 垄断权、 免税权等等这种各种特权大捞特捞， 奉旨发财呀。
而一马当先呢， 就是菲律宾现任总统 小马克斯的老爸 老马克斯， 这也是菲律宾的前总统。
这位老马的形式风格 就是从政界到商界 都塞满了自己人。
在菲律宾的任何生意 都要先给老马家族10%的好， 而所以人送外号10%先生。
最终 这个老马因为做的实在太过分的， 吃相太难堪了， 把其他大家族都得罪光了， 不得不带着上百亿美元资产 逃到了美国。
而留下的菲律宾呢， 已经成了 外债高达265亿美元的穷光蛋国家。
为什么会这样？
因为相比贪腐家族门法，垄断经济 最要命的问题是让菲律宾走上了趣 工业化的， 把美国留的家底都给败光了。
毕竟啊，你想啊， 只要垄断必需品 他就能躺着赚， 干嘛还要搞什么苦哈哈的 什么制造业高科技啊。
所以你就会发现， 菲律宾的工业化进程 在上世纪60年代之后就卡死不动了。
同样是和美国经济关系密切的日韩， 累死累活先从做衣服、做鞋子干起， 积累资本， 然后产业升级 发展高精尖的时候， 菲律宾反而从亚洲第二大工业国， 慢慢 先是被新马泰这样的邻居给超越， 接着又倒退成了农业国。
然后呢，又随着全球贸易自由化， 叠加了拉美危机、 亚洲金融危机 等等几波全球经济动荡的冲击， 菲律宾那是全面溃败啊。
低端制造业丧失竞争力， 高端制造完全没升级。
看来看去， 最后 人家只能搞搞轻松好赚钱的服务业。
2015年的菲律宾的农业和工业 占GDP的份额 分别从1980年代超过20%和40， 掉到了只有10%和33%。
而由于去工业化太早了， 就算是人家搞服务业， 也搞不出什么高附加值的服务业， 基本上只能搞搞旅游啊、 休闲等等低端服务。
这就是今天我们看到菲律宾的样子。
2022年菲律宾的GDP总量是4000亿美元出头， 什么概念呢？
还没咱们中国的一个零头高， 而人均收入是在1200-1800人民币左右， 这是亚洲最穷的国家之一， 同时呢，贫富差距特别巨大。
如果说你站在今天的菲律宾首都 马尼拉的市中心里面， 就会觉得，哎， 跟咱们北上广好像没什么两样， 高楼林立， 车水马龙， 房价也得四五万一平往上走， 而一街之隔的是一座座垃圾山 以及上百万人居住的贫民窟。
这贫民窟啊， 几千块钱 就可以买走一个女孩做老婆。
大家把从垃圾堆里面 捡来的吃的东西 洗一洗，重新加热 就成了。菲律宾的特产 叫派派。这叫什么呀？
富者田连阡陌， 贫者无立锥之地。
而因为工业、农业拉垮人， 服务业又没有办法提供大量的就业， 大量普通菲律宾人呢， 想混口饭吃就只能出国打工。
这又诞生了菲律宾的另一个奇观。
因为早年美国人的介入管理啊， 菲律宾人的英语都不错啊， 服务意识也很强， 直接就把菲佣 干成了菲律宾的支柱产业之一。
光去年菲律宾的海外劳工 就赚了372亿美元的外汇， 这占到了人家经济总量的8.5%， 这个比例什么概念？
去年中国汽车超越了房地产， 成了中国经济第一支柱， 占的比例也就差不多10%啊， 这就是目前菲律宾的经济现状。
所以你就能够理解， 为什么每当全球经济环境下，行 人不会去努力奋斗扭转国运， 而是习惯性靠走捷径来解决问题。
比如频频碰瓷东方大国， 试图向自己精神上的父亲那投名状。
那为什么 人连像样的大船都造不出来， 每次碰瓷还都是小破渔船出卖。
用今天的话说， 这纯纯的又菜又爱闹。
可用2000年前的韩非的总结 则是，国小而不储卑， 利少而不畏强， 无礼而武大林， 贪鄙而拙骄。`
  },
  {
    text: `娃哈哈又一次站上风口浪尖了。
这次是接班人发生变化了。
刚刚去世没多久， 也就是娃哈哈创始人钟老的女儿 宋富丽 突然公开提交了一份辞职信。
信的内容。大概我们总结一下啊， 就是我爸去世以后， 娃哈哈部分股东就质疑， 由我来接班掌管娃哈哈是不合理的， 这活我干不下去了， 所以 我要辞去副董事长和总经理的职。
这事一出， 问题很多的小明就表示说，哎呦， 有那味了， 先帝驾崩， 老臣和新王 有些能相辅相成， 有些却是有你陪我呀。
哈哈哈，假人呐。
不光是这样， 娃哈哈 远远没有女神副业这么简单呢。
你得知道这公司的真正老板是谁？
股东都是谁啊？
娃哈哈 它并不是一家纯粹的民营企业， 它是一家国企改制而来的 混合所有制企业。
简单来讲， 那就是既是有国有股东 也有民营股。
怎么回事呢？
这公司 不是宗老个人直接创立的企业， 当年前身 是 浙江杭州上城区的一家校办企业 的经销部， 算是地方国资企业吧。
宗老当时是那公司里面的员工啊。
在1987年，42岁的宗庆后呢， 是以职工的身份 承包了这家校办企业， 获得了完全独立的经营权。
后来呢，给这企业再取名为娃哈哈。
接着，大家都知道了， 做大做强， 再创辉煌， 一步一步 把这家曾经经营困难的校办企业 办成了全国V百强。
对娃哈哈有再造之功的宗老啊， 他的身份既不是娃哈哈的老板， 其当年手上也没有一丁点的股份， 毕竟啊，只是承包嘛， 说白了这公司又不是你的。
而这个转变呢， 就是在2000年， 在那一年， 娃哈哈完成了改制， 也就是这家国资企业决定啊， 让出一部分股东给员工， 大家伙，哥几个量力掏钱买股份， 为的就是什么， 大家都当股东， 那可不就更能激发干劲了吗？
宗庆后自然是首当其冲。
而之后 哇哈哈的股权就一分为三了， 国资占一部分， 中金后自己占一部分， 然后员工又占一部分。
那现在最新的股东结构是什么呀？
杭州国资委占股百分之46， 宗亲后占股29.4%， 员工占股24.6%。
这看上去好像这终老股份不多 还不到30%， 可是员工们跟他几乎是一条心啊啊， 几十年风雨同舟， 那是一致行动人， 这两边加一块 占股有54%。
所以说 当年宗庆后虽然不是大股东， 但却始终是哇哈的实际控制， 看上去一切是不是都挺完美的呀？
啊，但实际上也有隐患， 创一代的强人治理跟人格魅力 在去世之后往往会留下真空。
说白了，对于那老员工来说， 当年我认你， 宗庆后，我跟你， 我服你，但是你走了， 你家孩子那就另错了。
一方面呢， 是啊，宗老去世之后， 这宗复利 还没有正式继承 宗老在娃哈哈的股份， 他的身份也一直是副董事长、总经理。
接管娃哈哈 暂时从法律上来讲 还没有依据， 而且哪怕他后面继承了， 还得获得员工持股会的认可 以及国资股东的批准， 但这不重要啊。
另一方面， 东富力进入到这， 哇哈哈，仿佛感觉跟这家公司啊， 他有代沟啊， 而且在处理跟老员工的关系上呢， 似乎也一直是他的短板。
你看这小 宗什么学历啊， 海外留学归来， 性格跟作风呢， 相对来讲更加直接。
而宗老是什么？
为人更加传统， 更加讲究人情。
我举几个例子啊， 比如宗老曾经就表态说， 咱们娃哈哈呀， 不缺钱，没有上市的必要。
而宗富利呢， 却公开唱反调 说娃哈哈要上市很正常， 只有跟资本市场结合才能走的更远。
再比如啊， 宗富利对内是铁腕管理啊， 如果说你没有完成任务， 可以直接开除， 丝毫不讲情面， 我管你是不是老员工， 而宗老呢， 讲究的是用人质、 聚人心，甚至呢， 还会再偷偷的把这些老员工啊 再请回来。
但是你要是从商业 或者说管理层面单独来讲， 你很难就说 这小宗做的就一定有问题， 老宗就做的一定没毛病， 而这问题的核心其实是什么呀？
娃哈哈，如果说是你宗馥利创立的， 那就是你宗馥利做的对。
而更重要的一点， 那就是在经营的业绩层。
这小宗早年呢， 做了一系列的尝试， 效果只能说是一般般。
21年底，这小宗宗富力 升任娃哈哈的副董事长兼总经理， 同时宣布推出了20多款新品。
可结果呢？
整个22年呢， 娃哈哈的总营收是512亿， 比21年还下跌了7个亿。
这是什么呀？
一顿操作猛于虎， 一看还在原地杵啊！
你不能说综合力不努力， 抬头看看全球这几年大环境， 你说他真的是有点生不逢时吧？
虽然不算准确， 但也有点影响， 但只不过出了问题 就一定需要有人去负责。
老宗在的时候， 也许可以给小宗不断试错的机会， 而那些开朝老臣们呢， 就算有点想法，也不方便明着撕破脸， 而现在 谁还能站在小宗身后来给他善后？
>当然了，无论如何啊， 都希望娃哈哈这个民族品牌 能够好好的， 毕竟啊，那是包括我在内 几代人童年的回忆啊！`
  },
  {
    text: `你敢信吗？
特朗普给国货来了一波实力带货。
上个月啊， 特朗普跟马斯克 可以说是俩全球顶流的男人 连线直播， 结果有眼见的网友就发现说，哎， 特朗普手机下面垫的这个充电宝 好像是中国品牌安克的， 你看看，工作归工作， 这个MADE in China才是生活。
就这么个小小的细节啊， 让安克的股价在被发现的一瞬间 就跳涨了3%。
安克的客服都说了， 好多人都来咨询这个充电宝， 安克也非常机智的 在这个产品描述里 加上了一个懂王同款。
>不得不说啊， 特朗普这个带货实力确实不一般。
安克这个品牌啊， 可以说是一个隐藏的巨头， 别看它就是卖卖充电宝啊、 充电线这些小配件， 但它 在中国全球化品牌50强的榜单里边 能排到第16， 仅次于亚迪， 绝对属于那种低调的行业隐形冠军。
安克是2011年 由一个前谷歌工程师杨萌成立的， 那时候 深圳华强北正好有一波出海潮， 国内市场太卷， 加上阳萌又有海外背景， 所以他第一步就另辟蹊径， 选择跳过国内市场， 直接冲击海外。
想利用中国的供应链去打海外市场， 这个思路 我们现在可能感觉习以为常了， 但放在当时 还是挺大胆的。
而这招专攻海外， 也直接让安克抱上了两条大腿， 这第一条大腿就是苹果。
2011年左右， 正好是智能手机加速普及， 但这个官方的配件吧， 大家都懂， 太贵了。它大部分平替的配件呢， 倒是便宜， 但质量就一般般。
哎，安克他就瞄准了这个市场， 专门给苹果做高质量的 配件。
他很聪明的一点哈， 就是他会盯着iPhone去宣传， 紧跟着苹果蹭流量。
iPhone在哪打广告， 或者有人在哪搜iPhone相关的关键词， 哎，安克就把广告打在哪， 你前脚刚看完iPhone， 后脚安克就弹出来了。
感兴趣iPhone手机， 我这有配件， 还物美价廉。
当然哈，安克这产品确实不错， 颜值也很高， 慢慢呢就拿下了一批苹果用户， 而他的第二条大腿就是亚马逊。
安克在非常早期就入驻了亚马逊， 当时亚马逊的排序机制 主要就是看销量和评价。
安克呢， 就把广告都导到亚马逊去成交， 积累了非常好的销售数据， 同时用户也很满意， 很快就成为了亚马逊 消费电子里的王牌卖家。
同类产品里， 它的市场份额可以达到30%。
而后来到2020年的时候， 又吹来两股风， 让安克直接起飞。
一个就是 疫情，让美国人也开始习惯网购了， 线上购物的需求大大增加， 这就让非常擅长线上营销的安克销量跟着大涨。
而另一股风呢？
哎，还是苹果， 苹果不是从iPhone 12开始 就不送充电器了吗？
这就让他把一部分业务 拱手又让给了安克， 这也让安克即使这两年 还能实现百分之三四十的增长， 成为了 可以说是配件品牌出海的标杆。
所以你看最近这几年 品牌出海已经不光是汽车啊、手机啊、 家电这些大品牌的趋势， 类似安克这种细分领域的自主品牌、 新兴品牌 也掀起了国货出海的一股浪潮。
前两天我去上海，那外滩大会 就看到了非常多新奇的中国 出海好货， 有那种自主设计师设计的鞋呀、 衣服呀、椅子这种日常消费品， 还有很多非常新颖的， 像智能猫砂盆啊， 纸牌屋同款的划船机啊， 超轻钛合金的伊拜克 三防固态硬盘等等， 这些 其实都是比较细分领域的行业冠军， 不管是从技术质量 还是那个设计的精致度， 你看完感觉还真挺震撼。
到现在啊， 在亚马逊的美、英、日、法等等站点， 中国卖家的比例都已经超过了50%。
同时呢， 这些出海的品牌也更注重本土化、 多元化和品牌化。
比如像安克 最开始是靠着亚马逊， 但慢慢也延伸到了阿里express、 ebay等等， 现在也开始有了自己的独立站， 同时在线下拓展渠道。
根据万里汇2024年上半年的数据啊， 在平台上改走品牌化道路的卖家 同比暴涨了138%， 他们也更注重 在本地区设立主体运营， 打通供应链等等。
你像这些品牌卖家， 他在出海的过程当中 经常会遇到一个问题， 其实就是金融上的， 比如说跨境支付啊， 外汇的收付啊等等， 所以就会有一些 这样的跨境金融管理工具， 比如蚂蚁旗下的万里汇， 假设你想把货卖到欧美、 东南亚等等等很多国家， 那你可能会需要，哎， 我亚马逊开一个，户 Lazada开一个， TikTok shop开一个， 然后每个平台都得单独认证， 什么美元、欧元、 印度卢比都得单独管理 是吧？当时就头大， 所以呢， 他们就会用万里汇这样一个账户， 链接130多个 涵盖了几乎所有 主流的跨境电商平台， 就可以在像亚马逊、shein、沃尔玛 TikTok等等的这些平台收付款， 还能一键完成平台的认证啊、 合规啊等等， 包括很多品牌独立站， 它也能支持全球200多个国家地区 30多个币种的收款， 还有近百种币种的付款。
而且哈，这个万里汇账户 它还是一个出海的资金管理中心。
怎么讲呢， 你像理财贷款， 还有一些外汇的避险工具， 包括应急的资金周转等等， 这些金融功能也有。
就好像有一个非常懂出海的CFO 给你提供金融支持， 包括资源对接， 这样卖家就可以专注在把货给做好、 卖好， 让这些出海的国货可以走的更稳。`
  },
  {
    text: `哪个国家 印出了这张100万亿元的钞票？
我跟你说， 他的通货膨胀可以说是世界闻名， 从2000年开始 通胀就没下过三位数， 而伴随着这个恶性通胀的 其实就是金元对美元的急速贬值。
98年的时候， 一美元还能兑24津巴布韦元， 到06年就贬值到1美元兑10万金元。
这津巴布韦政府一看， 对吧？这0也太多了， 干脆咱就抹掉3个0， 定义一个新的津巴布韦元 叫ZWN啊， 他原来那个货币叫ZWD， 这样一美元就兑100金元了， 对吧？你看 多聪明。结果 津巴布韦这边 没止住恶性的通货膨胀， 这金元贬值的速度就越来越快。
一年后，07年4月的时候 又跌到了一美元兑3万津巴布韦元， 年底的时候 又变成一美元兑200万金元， 之后每个月都在狂泻， 半年之后 就出现了那张5000亿金元的钞票。
津巴布韦政府一看， 这0又太多了 对吧？老办法 再抹0，这次直接抹掉10个0， 就是除以100亿， 然后这新的货币呢， 就叫做DWR。
好吧，这个时候啊， 津巴布韦通过膨胀 据估算已经飙升到了 百分之九乘以10的22次方， 那外汇市场可想而知。
到半年之后， 就09年初的时候， 它又印出来那张举世闻名的 100万亿金元的钞票。
不过你看着这么多万亿， 最后其实也就值不到0.4美元， 那央行说好 咱再去要12个0 再除以1万亿啊， 这个新的货币就叫ZWL。
你看，短短三年里， 津巴布韦政府已经砍掉了25个零， 到最后这金元已经完全没有信用了。
你想你这政府整天这么砍零，然 后推出新货币， 到最后可能这26个字母都不够你用。
无奈之下， 政府被迫放弃金鱼，哎， 用欧元美元， 这才止住了国内的恶性膨胀。
不过最近哈，刚缓过来， 1.19年的时候， 津巴布韦又火奋起来， 推出了自己的货币， 通胀又飙到三位数。
然后今年4月份， 他就又又又推出自己新货币， 叫ZWG津巴布韦金， 这回号称是有贵金属倍数， 你就说这津巴布韦它乱不乱？
通过这个极端的例子啊， 你其实非常容易看出来， 通货膨胀跟外汇之间的关系。
物价，它对汇率的影响最底层， 但同时 也可能会非常的缓慢的隐形。
所以你如果一般看 那种比较主流的货币啊， 就比如说美元 过去50年通过膨胀跟汇率的对比， 只有80年代美国高速通胀的时期， 你才能非常明显的看到富相关。
从90年代之后 就没有什么特别明显的相关性， 这为什么啊？
就是因为像美元、欧元、日元， 包括人民币， 他大部分的时间通胀都是在10%以下， 这个区间叫轻微的波动。
你要不是放到像什么津巴布韦、 委内瑞拉、 土耳其这种 通胀一下就飙到超过50%的 这些国家， 一般看起来啊 可能都不会那么明显。`
  },
  {
    text: `国产芯片终于迎来重大突破了。
说两个好消息， 第一， 国产光刻机已经开始量产推广了。
这是工信部公开的数据， 差不多相当于阿斯麦公司的1460K， 可以生产65纳米级别的芯片。
虽然制程不是很先进， 但是它的重要意义 在于核心零部件国产化 被西方卡脖子。
用官方的话术来说， 这是事关综合国力 和国家安全的国之重器。
到今天，全国上下 其实都已经达成了一项共识， 就是 我们不能再对外资抱有任何幻想。
芯片产业链国产化势在必行。
当然，要实现这么宏大的目标， 不仅需要国家支持， 更需要企业参与。
这里就要讲到第二个好消息了， 2024年9月20日， 由长城汽车牵头 联合开发的车规级MCU芯片紫金M100 已经全部完成并成功点亮。
光看这条消息， 很多人可能体会不到 这颗芯片的重要意义。
说几个数据吧， 2023年，中国新能源汽车产量 达到了958.7万辆， 然而 我们的汽车芯片自给率却不到10%。
这其中像IGBT这类功率芯片 国产率大概有35%， 但像紫金M100这种 难度更大的MCU芯片 自给率却只有10%。
这就意味着 中国的汽车芯片市场 绝大部分营收和利润 都被外国企业拿走了。
而且我们的汽车产业发展 也会随时受到外人的限制。
比如2021年 西方国家的供应链危机 引发了一轮芯片荒， 导致中国汽车减产了198.2万辆。
所以长城这颗国产自研的紫荆M100 不仅是国内芯片产业链的重大突破， 也是中国汽车产业打破垄断、 实现芯片自由 的关键一步。
更重要的是， 这颗芯片的国产化程度非常高， 从硅知识产权的获取 到精源制造、封装测试 各个核心环节都在国内完成， 这样就能大幅度降低 被国外卡脖子的风险。
而且这还只是个开始。
这次公布的紫荆M100 会首先应用在X55大灯控制器平台， 计划5年上车量不低于250万辆， 今后 还会拓展到空调抬头显示等等模块。
未来还会推出紫荆M200和M300系列， 主要应用在动力、底盘系统， 甚至 还包括汽车最核心的中央处理器 紫荆S300等。
到长城汽车完成了这套芯片矩阵， 再加上智能驾驶方面 开启全国体验的长城全场景。NOA， 在智能座舱领域相当亮眼 的coffee OS3的全新升级， 这足以让它在智能化时代的竞争中 立于不败之地。
事实上，长城在这些技术上的投入 已经获得了非常不错的回报。
比如说今年9月上旬， 全新魏牌阑珊在6座7座SUV排行榜中 以1741辆的销量拿下周榜。
还有长城汽车 今年的季度盈利和营收 双双超过预期， 直接带动最近的长城股价大幅上涨。
这就告诉我们一个道理， 国内车企必须死磕技术， 为消费者带来好产品， 才能获得更好的业绩 和更长远的发展。
这次推出的芯片和光刻机 可能不是行业里最先进的， 也不能一步到位完全取代西方技术。
我们需要正视差距， 尊重事实。
我们也需要更多的企业像长城一样， 勇于踏出自主研发的第一步。`
  },
  {
    text: `当然了，除了俄罗斯之外，其他国家也在买中国汽车，比如墨西哥。 2013 年，墨西哥所有销售汽车中有 25% 来自中国，而在 6 年前这个数字为0。澳大利亚也在不断买中国汽车，最受澳大利亚欢迎的中国汽车品牌是名爵，去年卖了 5.8 万辆。在新能源车市场，比亚迪则占据了澳大利亚的新能源汽车 14% 份额，位于第二名。当然，这里也不得不提一下第一名，那就是特斯拉市场份额高达53%，在东南亚市场，中国车企业销量在 2013 年同样实现小幅上升，最典型的就是泰国，在泰国的新能源车市场，中国品牌占据了 80% 的份额，比如比亚迪的原 plus 就是泰国的新能源车爆款，那到底是什么原因让中国汽车爆卖呢？基本还可以总结为三方面原因，首先是全球疫情爆发，由于中国汽车的供应链完善，疫情期间仍能维持稳定生产，而日韩这些过去的出口大户受疫情影响，芯片、钢材、橡胶等关键原材料短缺，不仅汽车产能下降，而且成本升高，这就让中国汽车更具性价比。而随着中国国内新能源汽车市场越来越卷出海，成为不少中国车企的选择，比如比亚迪 2023 年进入全球 58 个国家和地区，出口汽车 24 万辆，是上一年度的 3.34 倍。在泰国新能源车市场，比亚迪单独占到了 40% 的市场份额，是名副其实的泰国新能源汽车销冠。而且中国新能源汽车并非只是具备成本优势，汽车与 AI 互联网融合的智能化更是中国车企的拿手好戏。从豪华配置到智能大屏，从外观设计到内饰比拼，这让中国新能源汽车的溢价能力明显变高。2019 年中国新能源汽车平均出口价格每量只有 5, 000 美元， 2022 年涨到了 2.2 万美元。比如比亚迪汉在欧洲发布时价格接近 50 万人民币，是国内售价的两倍多。在泰国、以色列、新西兰等多个国家，比亚迪也已经是新能源汽车的销售冠军。不过，中国汽车征服海外虽然是一部励志爽门，但其实有不少挑战。`
  }
];
