# VMind Open API
For some scenarios that are not suitable for accessing the front-end SDK (such as Python Notebook or backend scenarios) or that are inconvenient to apply for LLM service, we also provide Open API service, users can use VMind through HTTP requests to meet diverse chart visualization needs.

## Open API request example:
```curl
curl --location 'VMind Open API service address' \
--header 'api-key: service secret key' \
--form 'data="[
{
\"Product Name\": \"Cola\",
\"region\": \"south\",
\"sales\": 2350
},
{
\"Product Name\": \"Cola\",
\"region\": \"east\",
\"sales\": 1027
},
{
\"Product Name\": \"Cola\",
\"region\": \"west\",
\"sales\": 1027
}
]"' \
--form 'model="doubao"' \
--form 'userPrompt="Show me the sales of products in the north"' \
```

Return Value:
```json
{
"chart": [
{
"chartType": "BAR CHART", // Chart type
"spec": { // Generated VChart Spec
"type": "bar",
"xField": [
"region",
"Product Name"
],
"yField": "sales",
"seriesField": "Product Name",
//...Omit more spec content
},
"usage": { // LLM token consumption details
"completion_tokens": 19,
"prompt_tokens": 1109,
"total_tokens": 1128
},
"time": { // Chart animation duration
"totalTime": 2000,
"frameArr": []
}
}
]
}
```

The VMind Open API currently supports multiple models for intelligent data aggregation and chart generation, as well as chart-advisor for rule-based chart recommendations. The specific supported models are as follows:
- doubao: Default value, corresponding to the doubao-pro-32k-240828 model (Pro model released on 240828)
- doubao-1.5-pro-32k: Corresponding to the Doubao 1.5 Pro model released on 250115
- doubao-1.5-lite-32k: Corresponding to the Doubao 1.5 Lite model released on 250115
- Others: For example, GPT series models and DeepSeek series models

## Interface Description
### /generateChart
- Generate vchart spec for chart rendering according to the data and user's input natural language.
- If userPrompt and model are empty, the LLM will not be called, and the chart recommendation will only be based on the data to generate a series of chart spec, sorted by recommendation degree.
- If data is empty, a spec template without data will be generated, and the fillSpecWithData interface can be filled with data later.
- VMind ensures that only data field information (field names, field types) are passed to the LLM, and detailed data will not be passed to the LLM.
#### Invocation Method
POST
#### Parameter Description
- data
Description: The dataset used in the chart, with a JSON array structure. It can be empty. If data is empty, a spec template will be generated, and the fillSpecWithData interface can be used to fill in the data later.

- userPrompt
Description: Optional, user's input in natural language, string type. It can specify chart type and field allocation, and further perform data aggregation, filtering, sorting.
Examples:
```
Show me the sales of each product in different regions
Show the sales data of each product using a line chart
Top three products in terms of sales in the north
Which product sold the most
Sales status of products in different regions
Show the sales data of each product, with region as the x-axis and product type as the color
```

- model
Optional values: doubao | doubao-1.5-pro-32k | doubao-1.5-lite-32k
Description: Optional. Specifies the model type, defaults to the doubao model. Also supports GPT series and DeepSeek series models, available upon request.

- mode
Optional value: "accuracyFirst" ， "performanceFirst"
Description: Optional, chart generation mode, whether to prioritize performance or accuracy. AccuracyFirst will improve the accuracy of data aggregation and chart generation, but the generation speed will be affected. PerformanceFirst will improve the speed of chart generation and data aggregation, but accuracy may be affected. The default is performanceFirst

- enableDataQuery
Optional value: true or false
Description: Optional, whether to enable intelligent data aggregation. After opening, it will support data aggregation, filtering, sorting, grouping, etc. in userPrompt, such as:
```
Show me the sales of products in the north
Show the top 3 products sold in the south
Generate a line chart, aggregated by date
Show the top 5 products in terms of sales
```
The default is true, enabling it will increase the interface response time.

- chartTypeList
String array
Description: Optional, chart type list, used to restrict the chart types generated by the chart generation service. Only chart types in this list will be generated. If this parameter is not passed, all chart types will be generated by default.

Optional values:

```
"Bar Chart"
"Line Chart"
"Pie Chart"
"Scatter Plot"
"Word Cloud"
"Rose Chart"
"Radar Chart"
"Sankey Chart"
"Funnel Chart"
"Dual Axis Chart"
"Waterfall Chart"
"Box Plot"
"Dynamic Bar Chart"
```

Example:
```json
[
"Bar Chart",
"Line Chart",
"Pie Chart",
"Scatter Plot"
]//Only generate bar chart, line chart, pie chart, scatter plot
```

#### Return Value
- chart

Description: Chart generation result, json array structure

```typescript
type chartGenerationResult = {
chart:{
chartType : string; //Chart type
spec: Spec; //The vchart spec corresponding to this chart type, which can be used for front-end rendering
score: number; //Chart recommendation score, the higher the score, the more suitable the current data is for displaying with this type of chart
chartSource: string //Chart source, chartAdvisor represents rule-based chart recommendation, does not call the LLM; if the LLM is called to complete the chart generation, it will be the corresponding model name
}[]
}
```

## Contact Information
If you are interested in VMind Open API integration, please join the Lark group to create topics, or follow our WeChat public account to join the WeChat group and contact the relevant personnel.

- Lark:

<img src="https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vmind/tutorials/open_api_lark_group.png" >

- WeChat Public Account (you can join the WeChat group and Lark group through the public account menu):

![](http://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/visactor-site/blog/a39d9483e530417ba9a780f4d079c201.gif)
