# Key Insights and Trends - Amazon Fashion Sales January 2025

## Sales Patterns and Trends

### Weekly Trends
1. **Peak Performance in Week 3**: Week 3 (January 15-21) showed the highest performance with 316 orders, $45,545.99 in gross sales, and $15,827.16 in net profit.
2. **Consistent Growth and Decline**: Sales showed growth from Week 1 to Week 3, followed by a decline in Weeks 4 and 5, suggesting a mid-month peak pattern.
3. **Average Order Value Fluctuation**: AOV peaked in Week 3 at $144.97, while Week 4 had the lowest AOV at $125.07.

### Day of Week Patterns
1. **Tuesday Performance**: Tuesdays show the highest average orders (52.25) and gross sales ($7,152.33).
2. **Weekend vs. Weekday**: Weekend days (Saturday and Sunday) average higher orders (43.88) compared to weekdays (37.48).
3. **AOV Variation by Day**: Mondays have the highest average order value ($146.42), while Saturdays have the lowest ($129.43).
4. **Thursday Underperformance**: Thursdays consistently show the lowest performance across orders, sales, and profit.

### Outlier Analysis
1. **January 14th Anomaly**: Tuesday, January 14th showed exceptional performance:
   - 79 orders (82.31% above average Tuesday)
   - $11,752.01 gross sales (109.14% above average)
   - $4,010.05 net profit (113.58% above average)
   - This single day accounted for approximately 7% of the month's total sales.

## Customer Behavior Insights

### Order Patterns
1. **Conversion Rate Consistency**: Nearly perfect 100% conversion rate across all days, suggesting most visitors are returning customers or highly qualified leads.
2. **Units per Order**: Average of 2.57 units per order, with highest on Tuesdays (2.84) and lowest on weekends (2.35).
3. **One-time Purchasers**: Orders and unique customers are nearly identical, indicating most customers place only one order per day.

## Financial Performance Insights

### Profit Metrics
1. **Profit Margin Variation**: Profit margins range from 26.97% to 42.03%, with an average of 34.11%.
2. **Weekday vs. Weekend Profitability**: Weekdays show higher profit margins (35.47%) compared to weekends (33.38%).
3. **Correlation with AOV**: Profit margin has a moderate positive correlation (0.41) with average order value.

### Cost Structure
1. **Amazon Fee Consistency**: Amazon fees remain relatively consistent at 19-21% of gross sales.
2. **Product Cost Variation**: Product costs range from 38.39% to 50.67% of gross sales, suggesting variable product mix.

## Discount and Shipping Impact

### Discount Analysis
1. **Medium Discount Sweet Spot**: Medium discounts (1-2$ per order) correlate with highest orders (44.17), gross sales ($6,174.53), and net profit ($2,129.66).
2. **Discount-Profit Relationship**: Higher discounts correlate with lower profit margins (32.09% for high discounts vs. 34.60% for low discounts).
3. **Negative Correlation**: Discounts show negative correlation with AOV (-0.10) and profit margin (-0.32).

### Shipping Analysis
1. **Medium Shipping Sweet Spot**: Medium shipping charges ($5-6 per order) correlate with highest profit margins (35.47%).
2. **Minimal Impact**: Shipping charges show minimal correlation with orders (-0.01) and sales (0.01).
3. **Discount-Shipping Relationship**: Negative correlation (-0.39) between shipping and discount, suggesting they may be used as alternative promotional tactics.

## Opportunities for Growth

1. **Tuesday Optimization**: Leverage the success factors from January 14th to replicate performance on other Tuesdays.
2. **Weekend AOV Improvement**: Focus on increasing weekend AOV, which currently lags behind weekday performance.
3. **Thursday Enhancement**: Develop specific strategies to boost underperforming Thursday sales.
4. **Discount Strategy Refinement**: Optimize discount strategy around the 1-2$ per order range that shows best overall performance.
5. **Units per Order Increase**: Potential to increase units per order, particularly on weekends.
6. **Week 4-5 Performance**: Address the sales decline in the last two weeks of the month.
