/* eslint-disable max-len */
export const data = [
  {
    fileName: '1- Does the tooltip support changing the background color.md',
    content:
      "---\ntitle: 64. tooltip是否支持修改背景色</br>\n---\r\n## 问题标题\r\n\r\ntooltip是否支持修改背景色?</br>\r\n\r\n\r\n## 问题描述\r\n\r\n我在使用 VChart 时，想要设置tooltip的背景色，但是在配置文档中没有找到相关字段。我想请问一下，VChart 中的tooltip是否支持设置背景色？如果支持，应该如何配置？</br>\r\n\r\n\r\n## 解决方案\r\n\r\n可以在 VChart spec 中通过 tooltip.style.panel 设置 Tooltip 组件背景的样式，包括边距、背景颜色、边框以及阴影等。同时 tooltip.style 也支持自定义 Tooltip 的标题、文字以及形状的样式：</br>\r\n```\n  tooltip: {\n    style: {\n      panel: {\n        padding: {\n          top: 10,\n          bottom: 15,\n          left: 10,\n          right: 10\n        },\n        backgroundColor: '#eee',\n        border: {\n          color: '#ccc',\n          width: 1,\n          radius: 10\n        },\n        shadow: {\n          x: 0,\n          y: 0,\n          blur: 10,\n          spread: 5,\n          color: '#ddd'\n        }\n      },\n      titleLabel: {\n        fontSize: 20,\n        fontFamily: 'Times New Roman',\n        fill: 'brown',\n        fontWeight: 'bold',\n        textAlign: 'center',\n        lineHeight: 24\n      },\n      keyLabel: {\n        fontSize: 14,\n        fontFamily: 'Times New Roman',\n        fill: 'black',\n        textAlign: 'center',\n        lineHeight: 15,\n        spacing: 10\n      },\n      valueLabel: {\n        fontSize: 14,\n        fill: 'black',\n        textAlign: 'center',\n        lineHeight: 15,\n        spacing: 10\n      },\n      shape: {\n        size: 15,\n        spacing: 10\n      },\n      spaceRow: 10\n    }\n  }</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst markLineValue = 10000;\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  stack: false,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  lineLabel: { visible: true },\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  point: {\n    style: {\n      opacity: 0\n    },\n    state: {\n      dimension_hover: {\n        opacity: 1,\n        size: 10,\n        lineWidth: 2,\n        stroke: {\n          scale: 'color',\n          field: 'country'\n        },\n        fill: 'white'\n      }\n    }\n  },\n  markLine: [\n    {\n      y: markLineValue,\n      endSymbol: {\n        visible: false\n      },\n      line: {\n        style: {\n          stroke: 'orange',\n          lineWidth: 2\n        }\n      }\n    }\n  ],\n  tooltip: {\n    style: {\n      panel: {\n        padding: {\n          top: 10,\n          bottom: 15,\n          left: 10,\n          right: 10\n        },\n        backgroundColor: '#eee',\n        border: {\n          color: '#ccc',\n          width: 1,\n          radius: 10\n        },\n        shadow: {\n          x: 0,\n          y: 0,\n          blur: 10,\n          spread: 5,\n          color: '#ddd'\n        }\n      },\n      titleLabel: {\n        fontSize: 20,\n        fontFamily: 'Times New Roman',\n        fill: 'brown',\n        fontWeight: 'bold',\n        textAlign: 'center',\n        lineHeight: 24\n      },\n      keyLabel: {\n        fontSize: 14,\n        fontFamily: 'Times New Roman',\n        fill: 'black',\n        textAlign: 'center',\n        lineHeight: 15,\n        spacing: 10\n      },\n      valueLabel: {\n        fontSize: 14,\n        fill: 'black',\n        textAlign: 'center',\n        lineHeight: 15,\n        spacing: 10\n      },\n      shape: {\n        size: 15,\n        spacing: 10\n      },\n      spaceRow: 10\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/US2sbSCnIo9GHVxIql7cPH0xnxb.gif' alt='' width='1690' height='1062'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  Github: https://github.com/VisActor/VChart</br>\r\n*  Demo: https://visactor.bytedance.net/vchart/demo/tooltip/custom-tooltip</br>\r\n*  Spec: https://visactor.io/vchart/option/barChart#tooltip.style</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '2-How can I customize the display of fields in data in Tooltip in VChart.md',
    content:
      "# VChart 中 Tooltip 中怎么能自定义展示数据中的字段？\n\n# 问题描述\n\n类似 （https://visactor.io/vchart/demo/bar-chart/group-stack-percentage-column）这样的图表，希望tooltip能自定义展示数据中的字段\n![demo](/vchart/faq/97-0.png)\n\n# 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中可以直接修改 tooltip 的 content 配置来实现\n\n```ts\n{\n  tooltip: {\n    mark: {\n      content: [\n        { key: '类别', value: datum => datum.age },\n        { key: datum => datum.age, value: datum => datum.population }\n      ];\n    }\n  }\n}\n```\n\n# 代码示例\n\n```ts\n{\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'AL',\n          age: 'Under 5 Years',\n          population: 310504,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '5 to 13 Years',\n          population: 552339,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '14 to 17 Years',\n          population: 259034,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '18 to 24 Years',\n          population: 450818,\n          type: 'b'\n        },\n        {\n          State: 'AL',\n          age: '25 to 44 Years',\n          population: 1231572,\n          type: 'c'\n        },\n        {\n          State: 'AL',\n          age: '45 to 64 Years',\n          population: 1215966,\n          type: 'd'\n        },\n        {\n          State: 'AL',\n          age: '65 Years and Over',\n          population: 641667,\n          type: 'd'\n        },\n        {\n          State: 'AK',\n          age: 'Under 5 Years',\n          population: 52083,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '5 to 13 Years',\n          population: 85640,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '14 to 17 Years',\n          population: 42153,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '18 to 24 Years',\n          population: 74257,\n          type: 'b'\n        },\n        {\n          State: 'AK',\n          age: '25 to 44 Years',\n          population: 198724,\n          type: 'c'\n        },\n        {\n          State: 'AK',\n          age: '45 to 64 Years',\n          population: 183159,\n          type: 'd'\n        },\n        {\n          State: 'AK',\n          age: '65 Years and Over',\n          population: 50277,\n          type: 'd'\n        },\n        {\n          State: 'AZ',\n          age: 'Under 5 Years',\n          population: 515910,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '5 to 13 Years',\n          population: 828669,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '14 to 17 Years',\n          population: 362642,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '18 to 24 Years',\n          population: 601943,\n          type: 'b'\n        },\n        {\n          State: 'AZ',\n          age: '25 to 44 Years',\n          population: 1804762,\n          type: 'c'\n        },\n        {\n          State: 'AZ',\n          age: '45 to 64 Years',\n          population: 1523681,\n          type: 'd'\n        },\n        {\n          State: 'AZ',\n          age: '65 Years and Over',\n          population: 862573,\n          type: 'd'\n        },\n        {\n          State: 'AR',\n          age: 'Under 5 Years',\n          population: 202070,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '5 to 13 Years',\n          population: 343207,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '14 to 17 Years',\n          population: 157204,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '18 to 24 Years',\n          population: 264160,\n          type: 'b'\n        },\n        {\n          State: 'AR',\n          age: '25 to 44 Years',\n          population: 754420,\n          type: 'c'\n        },\n        {\n          State: 'AR',\n          age: '45 to 64 Years',\n          population: 727124,\n          type: 'd'\n        },\n        {\n          State: 'AR',\n          age: '65 Years and Over',\n          population: 407205,\n          type: 'd'\n        },\n        {\n          State: 'CA',\n          age: 'Under 5 Years',\n          population: 2704659,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '5 to 13 Years',\n          population: 4499890,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '14 to 17 Years',\n          population: 2159981,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '18 to 24 Years',\n          population: 3853788,\n          type: 'b'\n        },\n        {\n          State: 'CA',\n          age: '25 to 44 Years',\n          population: 10604510,\n          type: 'c'\n        },\n        {\n          State: 'CA',\n          age: '45 to 64 Years',\n          population: 8819342,\n          type: 'd'\n        },\n        {\n          State: 'CA',\n          age: '65 Years and Over',\n          population: 4114496,\n          type: 'd'\n        },\n        {\n          State: 'CO',\n          age: 'Under 5 Years',\n          population: 358280,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '5 to 13 Years',\n          population: 587154,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '14 to 17 Years',\n          population: 261701,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '18 to 24 Years',\n          population: 466194,\n          type: 'b'\n        },\n        {\n          State: 'CO',\n          age: '25 to 44 Years',\n          population: 1464939,\n          type: 'c'\n        },\n        {\n          State: 'CO',\n          age: '45 to 64 Years',\n          population: 1290094,\n          type: 'd'\n        },\n        {\n          State: 'CO',\n          age: '65 Years and Over',\n          population: 511094,\n          type: 'd'\n        },\n        {\n          State: 'CT',\n          age: 'Under 5 Years',\n          population: 211637,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '5 to 13 Years',\n          population: 403658,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '14 to 17 Years',\n          population: 196918,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '18 to 24 Years',\n          population: 325110,\n          type: 'b'\n        },\n        {\n          State: 'CT',\n          age: '25 to 44 Years',\n          population: 916955,\n          type: 'c'\n        },\n        {\n          State: 'CT',\n          age: '45 to 64 Years',\n          population: 968967,\n          type: 'd'\n        },\n        {\n          State: 'CT',\n          age: '65 Years and Over',\n          population: 478007,\n          type: 'd'\n        }\n      ]\n    }\n  ],\n  xField: ['State', 'type'],\n  yField: 'population',\n  seriesField: 'age',\n  stack: true,\n  percent: true,\n  legends: {\n    visible: true,\n    reversed: true\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {key: '类别', value: (datum) => datum.age},\n        {key: (datum) => datum.age, value: (datum) => datum.population}\n      ]\n    }\n  },\n  color: ['#98abc5', '#8a89a6', '#7b6888', '#6b486b', '#a05d56', '#d0743c', '#ff8c00'],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod: val => {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ]\n}\n```\n\n# 结果展示\n\n在线效果参考：https://codesandbox.io/s/tooltip-custom-6czn8z\n![result](/vchart/faq/97-1.png)\n\n# 相关文档\n\nTooltip 教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip\n相关 api：https://visactor.io/vchart/option/barChart#tooltip.mark.content(Object%7CObject%5B%5D).key\ngithub：https://github.com/VisActor/VChart\n"
  },
  {
    fileName:
      '3- How to solve the issue of line chart bifurcation after combining with stacked line and bidirectional bar charts.md',
    content:
      "---\ntitle: 17. 如何解决堆叠折线图和双向柱状图组合后，折线图部分分岔的问题？</br>\n---\r\n# **问题标题**\r\n\r\n如何解决堆叠折线图和双向柱状图组合后，折线图部分分岔的问题？</br>\r\n# **问题描述**\r\n\r\n我在使用堆叠折线图和双向柱状图组合后，发现折线图部分分岔了，如下图所示。请问该如何解决？</br>\r\n# **解决方案**\r\n\r\n这个问题是因为折线图默认不会按照轴的顺序来给数据排序，会按照数据在数组中的顺序来绘制，这里可以打开sortDataByAxis开关，让数据按照轴的顺序排序，绘制就正常了。</br>\r\n\r\n\r\n# **代码示例**\r\n\r\n```\n\nconst barMockData = [\n  { groupName: 'a', name: 'a_修复', type: 'fixedIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'a', name: 'a_新增', type: 'newIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'a', name: 'a_修复', type: 'fixedIssuesObj', time: '2023-09-25', value: 209 },\n  { groupName: 'a', name: 'a_新增', type: 'newIssuesObj', time: '2023-09-25', value: 0 },\n  { groupName: 'a', name: 'a_修复', type: 'fixedIssuesObj', time: '2023-09-26', value: 104 },\n  { groupName: 'a', name: 'a_新增', type: 'newIssuesObj', time: '2023-09-26', value: -3 },\n  { groupName: 'a', name: 'a_修复', type: 'fixedIssuesObj', time: '2023-09-27', value: 61 },\n  { groupName: 'a', name: 'a_新增', type: 'newIssuesObj', time: '2023-09-27', value: -1 },\n  { groupName: 'b', name: 'b_修复', type: 'fixedIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'b', name: 'b_新增', type: 'newIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'b', name: 'b_修复', type: 'fixedIssuesObj', time: '2023-09-25', value: 4 },\n  { groupName: 'b', name: 'b_新增', type: 'newIssuesObj', time: '2023-09-25', value: -4 },\n  { groupName: 'b', name: 'b_修复', type: 'fixedIssuesObj', time: '2023-09-26', value: 3 },\n  { groupName: 'b', name: 'b_新增', type: 'newIssuesObj', time: '2023-09-26', value: -7 },\n  { groupName: 'b', name: 'b_修复', type: 'fixedIssuesObj', time: '2023-09-27', value: 4 },\n  { groupName: 'b', name: 'b_新增', type: 'newIssuesObj', time: '2023-09-27', value: -8 },\n  { groupName: 'c', name: 'c_修复', type: 'fixedIssuesObj', time: '2023-09-24', value: 1 },\n  { groupName: 'c', name: 'c_新增', type: 'newIssuesObj', time: '2023-09-24', value: -1 },\n  { groupName: 'c', name: 'c_修复', type: 'fixedIssuesObj', time: '2023-09-25', value: 1 },\n  { groupName: 'c', name: 'c_新增', type: 'newIssuesObj', time: '2023-09-25', value: -1 },\n  { groupName: 'c', name: 'c_修复', type: 'fixedIssuesObj', time: '2023-09-26', value: 1 },\n  { groupName: 'c', name: 'c_新增', type: 'newIssuesObj', time: '2023-09-26', value: -1 },\n  { groupName: 'c', name: 'c_修复', type: 'fixedIssuesObj', time: '2023-09-27', value: 0 },\n  { groupName: 'c', name: 'c_新增', type: 'newIssuesObj', time: '2023-09-27', value: -5 },\n  { groupName: 'd', name: 'd_修复', type: 'fixedIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'd', name: 'd_新增', type: 'newIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'd', name: 'd_修复', type: 'fixedIssuesObj', time: '2023-09-25', value: 177 },\n  { groupName: 'd', name: 'd_新增', type: 'newIssuesObj', time: '2023-09-25', value: -1 },\n  { groupName: 'd', name: 'd_修复', type: 'fixedIssuesObj', time: '2023-09-26', value: 72 },\n  { groupName: 'd', name: 'd_新增', type: 'newIssuesObj', time: '2023-09-26', value: -30 },\n  { groupName: 'd', name: 'd_修复', type: 'fixedIssuesObj', time: '2023-09-27', value: 127 },\n  { groupName: 'd', name: 'd_新增', type: 'newIssuesObj', time: '2023-09-27', value: -9 },\n  { groupName: 'e', name: 'e_修复', type: 'fixedIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'e', name: 'e_新增', type: 'newIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'e', name: 'e_修复', type: 'fixedIssuesObj', time: '2023-09-25', value: 48 },\n  { groupName: 'e', name: 'e_新增', type: 'newIssuesObj', time: '2023-09-25', value: -4 },\n  { groupName: 'e', name: 'e_修复', type: 'fixedIssuesObj', time: '2023-09-26', value: 333 },\n  { groupName: 'e', name: 'e_新增', type: 'newIssuesObj', time: '2023-09-26', value: -1 },\n  { groupName: 'e', name: 'e_修复', type: 'fixedIssuesObj', time: '2023-09-27', value: 26 },\n  { groupName: 'e', name: 'e_新增', type: 'newIssuesObj', time: '2023-09-27', value: -3 },\n  { groupName: 'f', name: 'f_修复', type: 'fixedIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'f', name: 'f_新增', type: 'newIssuesObj', time: '2023-09-24', value: 0 },\n  { groupName: 'f', name: 'f_修复', type: 'fixedIssuesObj', time: '2023-09-25', value: 57 },\n  { groupName: 'f', name: 'f_新增', type: 'newIssuesObj', time: '2023-09-25', value: -3 },\n  { groupName: 'f', name: 'f_修复', type: 'fixedIssuesObj', time: '2023-09-26', value: 1 },\n  { groupName: 'f', name: 'f_新增', type: 'newIssuesObj', time: '2023-09-26', value: -11 },\n  { groupName: 'f', name: 'f_修复', type: 'fixedIssuesObj', time: '2023-09-27', value: 43 },\n  { groupName: 'f', name: 'f_新增', type: 'newIssuesObj', time: '2023-09-27', value: 0 }\n];\nconst mockData = [\n  { value: 2360, name: 'a', date: '2023-09-23' },\n  { value: 3829, name: 'b', date: '2023-09-23' },\n  { value: 1102, name: 'c', date: '2023-09-23' },\n  { value: 4856, name: 'd', date: '2023-09-23' },\n  { value: 5039, name: 'e', date: '2023-09-23' },\n  { value: 2180, name: 'f', date: '2023-09-23' },\n  { value: 2360, name: 'a', date: '2023-09-24' },\n  { value: 3829, name: 'b', date: '2023-09-24' },\n  { value: 1102, name: 'c', date: '2023-09-24' },\n  { value: 4856, name: 'd', date: '2023-09-24' },\n  { value: 5039, name: 'e', date: '2023-09-24' },\n  { value: 2180, name: 'f', date: '2023-09-24' },\n  { value: 2140, name: 'a', date: '2023-09-25' },\n  { value: 3829, name: 'b', date: '2023-09-25' },\n  { value: 1102, name: 'c', date: '2023-09-25' },\n  { value: 4670, name: 'd', date: '2023-09-25' },\n  { value: 4990, name: 'e', date: '2023-09-25' },\n  { value: 2123, name: 'f', date: '2023-09-25' },\n  { value: 2028, name: 'a', date: '2023-09-26' },\n  { value: 3833, name: 'b', date: '2023-09-26' },\n  { value: 1102, name: 'c', date: '2023-09-26' },\n  { value: 4621, name: 'd', date: '2023-09-26' },\n  { value: 4644, name: 'e', date: '2023-09-26' },\n  { value: 2133, name: 'f', date: '2023-09-26' },\n  { value: 1967, name: 'a', date: '2023-09-27' },\n  { value: 3837, name: 'b', date: '2023-09-27' },\n  { value: 1107, name: 'c', date: '2023-09-27' },\n  { value: 4498, name: 'd', date: '2023-09-27' },\n  { value: 4622, name: 'e', date: '2023-09-27' },\n  { value: 2087, name: 'f', date: '2023-09-27' },\n  { value: 1911, name: 'a', date: '2023-09-28' },\n  { value: 3838, name: 'b', date: '2023-09-28' },\n  { value: 1106, name: 'c', date: '2023-09-28' },\n  { value: 4042, name: 'd', date: '2023-09-28' },\n  { value: 4617, name: 'e', date: '2023-09-28' },\n  { value: 2087, name: 'f', date: '2023-09-28' }\n];\nconst spec = {\n  type: 'common',\n  bar: { state: { hover: { style: { fillOpacity: 0.5 } } }, style: { cursor: 'pointer' } },\n  title: {\n    visible: true,\n    align: 'left',\n    verticalAlign: 'top',\n    orient: 'top',\n    innerPadding: { bottom: 10 },\n    text: '每日问题详情',\n    subtext: '左Y轴正数为修复数，负数为新增数（可点击柱体查看详情）。右轴为每日总问题数'\n  },\n  data: [\n    { id: 'barData', values: barMockData },\n    { id: 'id1', values: mockData }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      seriesField: 'name',\n      xField: ['time', 'groupName'],\n      yField: 'value'\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      xField: 'date',\n      yField: 'value',\n      seriesField: 'name',\n      stack: true,\n      sortDataByAxis: true\n    }\n  ],\n  axes: [\n    { orient: 'left', id: 'bar', seriesId: ['bar'], tick: { tickCount: 6 }, nice: true },\n    {\n      orient: 'right',\n      seriesId: ['line'],\n      sync: { axisId: 'bar', tickAlign: true },\n      gird: { visible: false },\n      nice: true\n    },\n    { orient: 'bottom', domainLine: { onZero: true } }\n  ],\n  legends: { visible: true, padding: { top: '2%', right: '10%' } },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: (datum) => datum?.name,\n          value: (datum) => (datum?.value < 0 ? 0 - datum?.value : datum?.value)\n        }\n      ]\n    },\n    dimension: {\n      content: [\n        {\n          key: (datum) => datum?.name,\n          value: (datum) => (datum?.value < 0 ? 0 - datum?.value : datum?.value)\n        }\n      ]\n    }\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderAsync();\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n</br>\n```\r\n\r\n\r\n# **结果展示**\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QoU7bR9UjoDQkDxwsp4cioNcnSg.gif' alt='' width='1678' height='1036'>\r\n\r\n\r\n\r\n# **相关文档**\r\n\r\n*  相关API：https://www.visactor.io/vchart/option/barChart#sortDataByAxis</br>\r\n*  github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '4-The time interval of the coordinate axis scale is given.md',
    content:
      "# 坐标轴刻度的时间区间长度是给定的（一个季度），我怎么能设定比如只显示三个坐标轴刻度么？或者自适应的均匀些？\n\n## 问题描述\n\n类似 （https://www.visactor.io/vchart/demo/line-chart/multi-line）这样的折线图\n坐标轴时间区间长度给定的情况下，该怎么设置坐标轴刻度的显示数量？例如我想只显示三个坐标轴刻度，或者自适应刻度数量。\n\n## 解决方案\n\n在 VChart 中，共有 linear、band、time、log4 种坐标轴类型。对于每种坐标轴，只需要设置 tick.tickCount=3，或者 tick.forceTickCount=3 即可指定坐标轴刻度的数量。\n\n当未指定 tickCount 时，会采用自适应 tick 数量，自动寻找能够使所有轴标签都不重叠的最大 tick 数量\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  seriesField: 'name',\n  axes: [\n    {\n      orient: 'left',\n      domainLine: { visible: false },\n      tick: { visible: false },\n      label: {\n        style: {\n          fill: 'rgb(162, 162, 162)'\n        }\n      },\n      grid: {\n        style: {\n          lineDash: [0],\n          stroke: 'rgb(231, 231, 231)'\n        }\n      }\n    },\n    {\n      orient: 'bottom',\n      domainLine: { visible: true, style: { stroke: '#000' } },\n      tick: {\n        style: { stroke: '#000' },\n        tickCount: 3\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/line-chart-tick-count-fxh599?file=/src/index.ts)\n\n## 相关文档\n\n- [折线图教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Line)\n- [相关 api](https://www.visactor.io/vchart/option/lineChart#axes-linear.tick.tickCount)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '5- How to position the chart on the far left of the canvas.md',
    content:
      "---\ntitle: 10. 怎么让图在canvas的最左边? </br>\n---\r\n# 问题标题\r\n\r\n在vchart图表库中如何让图表位于canvas的最左边？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我正在使用vchart图表库进行可视化操作，我希望图表能位于canvas的最左边，然而我尝试调整配置的时候出了问题，不知道应该如何设置。</br>\r\n```\n{\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  axes:[\n    {\n      type:'band',\n      orient:'bottom',\n      visible:false,\n    },\n    {\n      orient:'left',\n      visible:false,\n    }\n  ]\n};</br>\n```\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/DPyKbpPRcoH3yfxChmmciWv6nQh.gif' alt='' width='760' height='420'>\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TQGcbgF0xooBWoxDxOIc7lq9nZc.gif' alt='' width='680' height='704'>\r\n\r\n\r\n\r\n# 解决方案\r\n\r\n在vchart的配置项中有一个`trimPadding`属性，该属性用于配置是否去除 band 轴两端的留白，如果为`true`，则两端不会有留白，并且`bandPadding`、`paddingInner` 和 `paddingOuter` 的设置将被忽略。</br>\r\n\r\n\r\n而在这里，我们需要的是将图表放置在canvas的最左边，即没有左边的留白，那么我们需要在`'bottom'`轴上加上`trimPadding`配置。</br>\r\n\r\n\r\n以下是配置的示例：</br>\r\n```\n{\n//...省略spec配置\n  axes:[\n    {\n      type:'band',\n      orient:'bottom',\n      visible:false,\n      trimPadding:true,\n    },\n    {\n      orient:'left',\n      visible:false,\n    }\n  ]\n};</br>\n```\r\n# 结果展示\r\n\r\n通过添加`trimPadding`配置后，图表现在已经可以正常显示在canvas的最左边了。</br>\r\n在线效果参考：https://codesandbox.io/p/sandbox/common-chart-interactive-forked-cn95kp</br>\r\n\r\n\r\n# 相关文档\r\n\r\n相关API：[https://visactor.bytedance.net/vchart/option/barChart-axes-band#trimPadding](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Foption%2FbarChart-axes-band%23trimPadding)</br>\r\ngithub：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '6- How to export charts as images.md',
    content:
      "---\ntitle: 19. 图表如何导出图片？</br>\n---\r\n## 问题标题\r\n\r\n请问是否有图表导出图片的api？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n图表能否直接转成高清度图片保存？是否有相关的api？</br>\r\n\r\n\r\n## 解决方案 \r\n\r\n您有2种方法可以将图表保存成图片：</br>\r\n1. 在图表上直接右键保存或复制</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Mk3Ebs6gOoBE2exUx1XczYDinQ7.gif' alt='' width='1700' height='960'>\r\n\r\n1. 如果您需要在软件项目中获取图片，我们针对不同代码环境有不同的接口</br>\r\n### **getDataURL**\r\n\r\n\r\n\r\n**异步方法**返回一个包含图片展示的 data URI。</br>\r\n\r\n\r\n```\ngetDataURL: () => Promise<any>;</br>\n```\r\n\r\n\r\n### **exportImg**\r\n\r\n\r\n\r\n**异步方法** 导出图表图片，只支持浏览器端，同时参数 `name` 可以为图片进行命名。</br>\r\n\r\n\r\n```\n/**\n * **异步方法** 导出图表图片，只支持浏览器端。\n * @param name 保存的图片名称\n * @returns\n */\nexportImg: (name?: string) => Promise<void>;</br>\n```\r\n\r\n\r\n### **exportCanvas**\r\n\r\n\r\n\r\n导出绘制有图表内容的 canvas ，只支持浏览器端。可以使用这个 canvas 进行二次处理，比如添加水印等。</br>\r\n\r\n\r\n```\n/**\n * 导出绘制了图表内容的 canvas\n * @returns HTMLCanvasElement\n * @since 1.5.2\n */\nexportCanvas: () => HTMLCanvasElement | undefined;</br>\n```\r\n\r\n\r\n### **getImageBuffer**\r\n\r\n\r\n\r\n目前仅支持 node 环境，用于 node 端的图片导出。</br>\r\n\r\n\r\n```\n getImageBuffer: () => void;</br>\n```\r\n\r\n\r\n详情可见: https://www.visactor.io/vchart/api/API/vchart</br>\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// 等待动画执行之后或关闭动画后, exportImg\nsetTimeout(() => {\n  vchart.exportImg('vchart')\n}, 1000)\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/exportimg-2zvg62?file=%2Fsrc%2Findex.ts%3A58%2C26</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/H5l5bt13xoNWwRx9ytQcqxmxnVf.gif' alt='' width='2052' height='1010'>\r\n\r\n\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n相关api：https://www.visactor.io/vchart/api/API/vchart</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '7- How to draw combination charts in React.md',
    content:
      "---\ntitle: 108.react 如何画组合图</br>\n---\r\n## 问题标题\r\n\r\nreact 如何画组合图</br>\r\n## 问题描述\r\n\r\n请教下如何渲染组合图</br>\r\n## 解决方案 \r\n\r\n 可以看一下这个在线的 codesandbox 例子~ https://codesandbox.io/p/sandbox/visactor-vchart-react-demo-forked-h4dyjl?file=%2Fsrc%2FCommonChart.tsx%3A43%2C29</br>\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/PcplbzjSUoD2GsxxIz6ciJE5n8l.gif' alt='' width='3246' height='1728'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  Demo：https://codesandbox.io/p/sandbox/visactor-vchart-react-demo-forked-h4dyjl?file=%2Fsrc%2FCommonChart.tsx%3A43%2C29</br>\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination</br>\r\n*  API：https://visactor.io/vchart/option/commonChart</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '8- Does the tooltip support custom two-line display content.md',
    content:
      "---\ntitle: 59. tooltip是否支持自定义双行显示内容</br>\n---\r\n## 问题标题\r\n\r\ntooltip是否支持自定义双行显示内容？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n请问一下vchart 的饼图，tooltip是否支持自定义双行显示内容？目前看vchart的文档是可以设置tooltip的title和content，但是好像是仅支持展示饼图其中一块的内容，而且在小程序中这块好像并不支持？是需要监听回调？</br>\r\n\r\n\r\n## 解决方案\r\n\r\n VChart Tooltip 可以配置多个 content 内容来展示更多的提示信息：</br>\r\n```\n  tooltip: {\n    dimension: {\n      content: [\n        {\n          key: 'value',\n          value: (datum) => datum.value,\n        },\n        {\n          key: 'country',\n          value: (datum) => datum.country,\n        }\n      ],\n    }\n  }</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst markLineValue = 10000;\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  stack: false,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  lineLabel: { visible: true },\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  point: {\n    style: {\n      opacity: 0\n    },\n    state: {\n      dimension_hover: {\n        opacity: 1,\n        size: 10,\n        lineWidth: 2,\n        stroke: {\n          scale: 'color',\n          field: 'country'\n        },\n        fill: 'white'\n      }\n    }\n  },\n  markLine: [\n    {\n      y: markLineValue,\n      endSymbol: {\n        visible: false\n      },\n      line: {\n        style: {\n          stroke: 'orange',\n          lineWidth: 2\n        }\n      }\n    }\n  ],\n  tooltip: {\n    dimension: {\n      content: [\n        {\n          key: 'value',\n          value: (datum) => datum.value,\n        },\n        {\n          key: 'country',\n          value: (datum) => datum.country,\n        }\n      ],\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QFk1b4LRioOA7LxI5zTcwcbMnLg.gif' alt='' width='1700' height='1038'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  https://visactor.io/vchart/option/barChart#tooltip.dimension.content(Object%7CObject%5B%5D)</br>\r\n\r\n"
  },
  {
    fileName: "9- How to display 'sum' in the tooltip of a line chart.md",
    content:
      "---\ntitle: 18.如何在line chart的tooltip中显示“加和”？</br>\n---\r\n\r\n\r\n# **问题标题**\r\n\r\n如何在line chart的tooltip中显示“加和”？</br>\r\n# **问题描述**\r\n\r\n我在使用line chart时，想要在tooltip中显示“加和”这个项，但是不知道该如何实现。请问该怎么做？</br>\r\n# **解决方案**\r\n\r\n可以使用updateContent来做一个tooltip内容的后处理。</br>\r\n在dimension的content中，可以添加一个key为“加和”的项，value为一个函数，该函数接收一个datumList参数，表示当前tooltip中所有数据的列表，然后计算出所有数据的value的和，返回即可。</br>\r\n在updateContent中，也可以添加一个key为“加和”的项，value为同样的函数，这样就可以在tooltip中显示“加和”这个项了。</br>\r\n\r\n\r\n# **代码示例**\r\n\r\n```\nconst data = [\n  { year: '2012', type: 'Forest', value: 320 },\n  { year: '2012', type: 'Steppe', value: 220 },\n  { year: '2012', type: 'Desert', value: 150 },\n  { year: '2012', type: 'Wetland', value: 98 },\n  { year: '2013', type: 'Forest', value: 332 },\n  { year: '2013', type: 'Steppe', value: 182 },\n  { year: '2013', type: 'Desert', value: 232 },\n  { year: '2013', type: 'Wetland', value: 77 },\n  { year: '2014', type: 'Forest', value: 301 },\n  { year: '2014', type: 'Steppe', value: 191 },\n  { year: '2014', type: 'Desert', value: 201 },\n  { year: '2014', type: 'Wetland', value: 101 },\n  { year: '2015', type: 'Forest', value: 334 },\n  { year: '2015', type: 'Steppe', value: 234 },\n  { year: '2015', type: 'Desert', value: 154 },\n  { year: '2015', type: 'Wetland', value: 99 },\n  { year: '2016', type: 'Forest', value: 390 },\n  { year: '2016', type: 'Steppe', value: 290 },\n  { year: '2016', type: 'Desert', value: 190 },\n  { year: '2016', type: 'Wetland', value: 40 }\n];\nconst aggregation = {};\ndata.forEach(({ year, value }) => {\n  if (!aggregation[year]) {\n    aggregation[year] = 0;\n  }\n  aggregation[year] += value;\n});\nconst spec = {\n  type: 'bar',\n  data: [{ id: 'bar', values: data }],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  bar: { state: { legend_hover_reverse: { fill: '#ccc' } } },\n  legends: { visible: true },\n  tooltip: {\n    mark: {\n      title: { value: (datum) => datum['year'] + '年' },\n      content: [\n        { key: (datum) => datum['type'], value: (datum) => datum['value'] },\n        {\n          hasShape: false,\n          key: 'Proportion',\n          value: (datum) => Math.round((datum['value'] / aggregation[datum['year']]) * 10000) / 100 + '%'\n        }\n      ]\n    },\n    dimension: {\n      title: { value: (datum) => datum['year'] + '年' },\n      content: [{ key: (datum) => datum['type'], value: (datum) => datum['value'] }],\n      updateContent: (prev) => {\n        console.log(prev);\n        const total = prev.reduce((acc, cur) => {\n          return acc + cur.value;\n        }, 0);\n        return (prev ?? []).concat({ key: 'total', value: total });\n      }\n    }\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderAsync(); // Just for the convenience of console debugging, DO NOT COPY! window['vchart'] = vchart;\n</br>\n```\r\n\r\n\r\n# **结果展示**\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/XjzQbcyzLod7QUxNP7UcBVhZn5f.gif' alt='' width='1670' height='1048'>\r\n\r\n\r\n\r\n# **相关文档**\r\n\r\n*  updateContent：https://visactor.bytedance.net/vchart/option/barChart#tooltip.dimension.updateContent</br>\r\n*  github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '10- How to change the color of the legend.md',
    content:
      '---\ntitle: 49. 如何更改图例的颜色？</br>\n---\r\n## 问题标题\r\n\r\n如何更改图例的颜色？</br>\r\n## 问题描述\r\n\r\n期望单独控制图例的颜色， 不与图形保持一致。</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，通常情况下， VChart 的图例会和主要图元的颜色保持一致， 为用户提供颜色说明。 但某些场景下， 可能需要单独优化图例的样式， 例如添加边框或增加透明的颜色。 VChart 的图例配置项， 支持单独控制填充颜色。</br>\r\n方式一： 使用`legends.data`， 在回调函数中处理每个图例的`shape`属性， 从而达到修改图例样式的效果。</br>\r\n方式二： 使用`legends.item.shape`， 可以显示的控制每个图例的样式。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "scatter",\n      xField: "revenues_mm",\n      yField: "profit_mm",\n      seriesField: "category",\n      color: ["#ff0000", "#00ff00", "#0000ff", "#ffff00", "#ff00ff", "#00ffff"],\n      legends: {\n        type: "discrete",\n        visible: true,\n        orient: "top",\n        position: "end",\n        data: (items) =>\n          items.map((item) => {\n            item.shape.outerBorder = {\n              stroke: item.shape.fill,\n              distance: 2,\n              lineWidth: 1,\n            };\n\n            return item;\n          }),\n      },\n      data: [\n        {\n          id: "data",\n          values: [\n            {\n              company: "Johnson & Johnson",\n              revenues_mm: 71890,\n              profit_mm: 18540,\n              profit_as_of_revenues: 0.2578940047294478,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Procter & Gamble",\n              revenues_mm: 71726,\n              profit_mm: 10508,\n              profit_as_of_revenues: 0.14650196581434904,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Abbvie",\n              revenues_mm: 25638,\n              profit_mm: 5953,\n              profit_as_of_revenues: 0.23219439893907481,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Amgen",\n              revenues_mm: 22991,\n              profit_mm: 7722,\n              profit_as_of_revenues: 0.33587055804445215,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Eli Lilly",\n              revenues_mm: 21222,\n              profit_mm: 2738,\n              profit_as_of_revenues: 0.12901705777023842,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Bristol-Myers Squibb",\n              revenues_mm: 19427,\n              profit_mm: 4457,\n              profit_as_of_revenues: 0.22942296803417925,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Altria Group",\n              revenues_mm: 19337,\n              profit_mm: 14239,\n              profit_as_of_revenues: 0.7363603454517247,\n              category: "Tobacco",\n            },\n            {\n              company: "Kimberly-Clark",\n              revenues_mm: 18202,\n              profit_mm: 2166,\n              profit_as_of_revenues: 0.11899791231732777,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "General Mills",\n              revenues_mm: 16563,\n              profit_mm: 1697,\n              profit_as_of_revenues: 0.10245728430839823,\n              category: "Food",\n            },\n            {\n              company: "Colgate-Palmolive",\n              revenues_mm: 15195,\n              profit_mm: 2441,\n              profit_as_of_revenues: 0.16064494899638038,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Conagra Brands",\n              revenues_mm: 14134,\n              profit_mm: -677,\n              profit_as_of_revenues: -0.04789868402433847,\n              category: "Food",\n            },\n            {\n              company: "Land O\'Lakes",\n              revenues_mm: 13233,\n              profit_mm: 245,\n              profit_as_of_revenues: 0.01851432025995617,\n              category: "Food",\n            },\n            {\n              company: "Pepsico",\n              revenues_mm: 62789,\n              profit_mm: 6329,\n              profit_as_of_revenues: 0.1007979104620236,\n              category: "Food",\n            },\n            {\n              company: "Kellogg",\n              revenues_mm: 13014,\n              profit_mm: 694,\n              profit_as_of_revenues: 0.053327186107269095,\n              category: "Food",\n            },\n            {\n              company: "Reynolds American",\n              revenues_mm: 12503,\n              profit_mm: 6073,\n              profit_as_of_revenues: 0.48572342637766935,\n              category: "Tobacco",\n            },\n            {\n              company: "Biogen",\n              revenues_mm: 11449,\n              profit_mm: 3703,\n              profit_as_of_revenues: 0.32343436107957024,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Estee Lauder",\n              revenues_mm: 11262,\n              profit_mm: 1115,\n              profit_as_of_revenues: 0.09900550523885633,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Celgene",\n              revenues_mm: 11229,\n              profit_mm: 1999,\n              profit_as_of_revenues: 0.17802119511977915,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Hormel Foods",\n              revenues_mm: 9523,\n              profit_mm: 890,\n              profit_as_of_revenues: 0.09345794392523364,\n              category: "Food",\n            },\n            {\n              company: "Campbell Soup",\n              revenues_mm: 7961,\n              profit_mm: 563,\n              profit_as_of_revenues: 0.07071975882426831,\n              category: "Food",\n            },\n            {\n              company: "J. M. Smucker",\n              revenues_mm: 7811,\n              profit_mm: 689,\n              profit_as_of_revenues: 0.08820893611573422,\n              category: "Food",\n            },\n            {\n              company: "Dean Foods",\n              revenues_mm: 7710,\n              profit_mm: 120,\n              profit_as_of_revenues: 0.01556420233463035,\n              category: "Food",\n            },\n            {\n              company: "Hershey",\n              revenues_mm: 7440,\n              profit_mm: 720,\n              profit_as_of_revenues: 0.0967741935483871,\n              category: "Food",\n            },\n            {\n              company: "Pfizer",\n              revenues_mm: 52824,\n              profit_mm: 7215,\n              profit_as_of_revenues: 0.13658564288959563,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Constellation Brands",\n              revenues_mm: 6548,\n              profit_mm: 1055,\n              profit_as_of_revenues: 0.16111789859499084,\n              category: "Beverages",\n            },\n            {\n              company: "Dr. Pepper Snapple Group",\n              revenues_mm: 6440,\n              profit_mm: 847,\n              profit_as_of_revenues: 0.13152173913043477,\n              category: "Beverages",\n            },\n            {\n              company: "HRG Group",\n              revenues_mm: 6403,\n              profit_mm: -199,\n              profit_as_of_revenues: -0.031079181633609246,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Treehouse Foods",\n              revenues_mm: 6175,\n              profit_mm: -229,\n              profit_as_of_revenues: -0.03708502024291498,\n              category: "Food",\n            },\n            {\n              company: "Avon Products",\n              revenues_mm: 5853,\n              profit_mm: -108,\n              profit_as_of_revenues: -0.018452075858534086,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Clorox",\n              revenues_mm: 5761,\n              profit_mm: 648,\n              profit_as_of_revenues: 0.11248047214025343,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Coca-Cola",\n              revenues_mm: 41863,\n              profit_mm: 6527,\n              profit_as_of_revenues: 0.15591333635907603,\n              category: "Beverages",\n            },\n            {\n              company: "Merck",\n              revenues_mm: 39807,\n              profit_mm: 3920,\n              profit_as_of_revenues: 0.09847514256286583,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Gilead Sciences",\n              revenues_mm: 30390,\n              profit_mm: 13501,\n              profit_as_of_revenues: 0.4442579795985522,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Philip Morris International",\n              revenues_mm: 26685,\n              profit_mm: 6967,\n              profit_as_of_revenues: 0.2610830054337643,\n              category: "Tobacco",\n            },\n            {\n              company: "Kraft Heinz",\n              revenues_mm: 26487,\n              profit_mm: 3632,\n              profit_as_of_revenues: 0.1371238720881942,\n              category: "Food",\n            },\n            {\n              company: "Mondelez International",\n              revenues_mm: 25923,\n              profit_mm: 1659,\n              profit_as_of_revenues: 0.06399722254368707,\n              category: "Food",\n            },\n          ],\n        },\n      ],\n    };\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart"></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-legend-color-9qjhrw?file=%2Fsrc%2Findex.js%3A1%2C1-314%2C1</br>\r\n## 相关文档\r\n\r\nLegend Custom Style Demo: https://visactor.io/vchart/demo/legend/custom-interaction</br>\r\nLegend API: https://visactor.io/vchart/option/barChart-legends-discrete#data</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '11- How to display a color block area within a specified x-axis range in the chart.md',
    content:
      "---\ntitle: 63. 如何在图表中显示一个色块区域，区域是覆盖在指定的 x 轴范围之内？</br>\n---\r\n## 问题标题\r\n\r\n如何在图表中显示一个色块区域，区域是覆盖在指定的 x 轴范围之内？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n类似下图的效果，希望在图表里指定的 x 轴范围绘制一个颜色色块，在 VChart 该如何配置？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/SOYtb3xBOodWeSx72dpcnWY1n9f.gif' alt='' width='1108' height='488'>\r\n\r\n## 解决方案\r\n\r\n你可以通过 `markArea` 组件实现这个效果，使用 `markArea.coordinates` 属性声明要标注的数据范围。</br>\r\n*  `coordinates`：支持配置数据值，VChart 会自动根据数据映射到画布坐标进行范围绘制。</br>\r\n```\n  markArea: [\n    {\n      coordinates: [\n        {\n          Date: 'Jan-20',\n          Price: 0.18\n        },\n        {\n          Date: 'Mar-23',\n          Price: 0.18\n        },\n        {\n          Date: 'Mar-23',\n          Price: 0.12\n        },\n        {\n          Date: 'Jan-20',\n          Price: 0.12\n        }\n      ],\n      label: {\n        text: 'Electricite prices have surged since 2020',\n        position: 'insideTop'\n      }\n    }\n  ],</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\nhttps://visactor.io/vchart/demo/marker/mark-area-basic</br>\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HO0MbfC8co3vstxnkMccptVUnhg.gif' alt='' width='1671' height='1044'>\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  MarkArea 示例：https://visactor.io/vchart/demo/marker/mark-area-basic</br>\r\n*  MarkArea 教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/marker</br>\r\n\r\n"
  },
  {
    fileName: '12- How to set grid lines on VChart axes to dashed lines.md',
    content:
      "---\ntitle: 38. VChart 坐标轴网格线如何设置为虚线</br>\n---\r\n## 问题标题\r\n\r\nVChart 坐标轴网格线如何设置为虚线？</br>\r\n\r\n\r\n## 问题描述\r\n\r\nVChart 里坐标轴的网格线是直线，如何设置为虚线，以及如何调整虚线的样式？</br>\r\n\r\n\r\n## 解决方案\r\n\r\n在 VChart 里，坐标轴网格线样式的配置项是 `axes[i].grid.style`。你可以通过配置 `lineDash` 属性将实线调整为你想要的虚线效果。</br>\r\n`lineDash`使用一组值来指定描述模式的线和间隙的交替长度。例如：</br>\r\n```\nlineDash: [2, 3]; \n// 切换回至实线模式\nlineDash: [0];</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  axes:[\n    {\n      orient:'left',\n      grid:{\n        style:{\n          stroke:\"black\",\n          lineDash:[5,5]\n        }\n      }\n    },\n    {\n      orient:'bottom',\n      grid:{\n        visible: true,\n        style:{\n          stroke:\"black\",\n          lineDash:[5,5]\n        }\n      }\n    }\n  ],\n  xField: 'time',\n  yField: 'value'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/H8Upbvn30omSSux10LncnhaSnGc.gif' alt='' width='1677' height='1044'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  [lineDash 配置项目](https%3A%2F%2Fvisactor.io%2Fvchart%2Foption%2FbarChart-extensionMark-symbol%23style.lineDash(number%5B%5D))</br>\r\n*  [坐标轴教程](https%3A%2F%2Fvisactor.io%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FAxes)</br>\r\n*  github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '13-How does the label of the auxiliary line automatically change lines.md',
    content:
      "# 辅助线的 label 如何自动换行？\n\n## 问题描述\n\n辅助线的 label 里面的文字如果太长的话可以自动换行吗？\n[markline new line](/vchart/faq/14-0.png)\n\n## 解决方案\n\n你可以通过在`markLine.label.text`中设置数组来实现换行的效果。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'scatter',\n  padding: [12, 20, 12, 12],\n  xField: 'x',\n  yField: 'y',\n  sizeField: 'z',\n  size: {\n    type: 'linear',\n    range: [20, 80]\n  },\n  axes: [\n    { orient: 'bottom', type: 'linear', min: 60, max: 95 },\n    { orient: 'left', type: 'linear', min: 0, max: 200 }\n  ],\n  point: {\n    style: {\n      fillOpacity: 0.25,\n      lineWidth: 1,\n      stroke: '#6690F2',\n      fill: '#6690F2'\n    }\n  },\n  label: {\n    visible: true,\n    position: 'center',\n    overlap: {\n      avoidBaseMark: false\n    },\n    style: {\n      stroke: '#fff',\n      lineWidth: 1\n    }\n  },\n  markLine: [\n    {\n      x: 90,\n      label: {\n        visible: true,\n        position: 'end',\n        text: ['Safe fat intake', '65g/day'],\n        style: {\n          textAlign: 'left',\n          textBaseline: 'top',\n          fill: '#000',\n          dx: 10\n        },\n        labelBackground: {\n          visible: false\n        }\n      },\n      line: {\n        style: {\n          stroke: '#000',\n          lineDash: [0]\n        }\n      }\n    },\n    {\n      y: 50,\n      label: {\n        visible: true,\n        position: 'end',\n        text: ['Safe sugar intake', '50g/day'],\n        style: {\n          textAlign: 'right',\n          textBaseline: 'bottom',\n          fill: '#000'\n        },\n        labelBackground: {\n          visible: false\n        }\n      },\n      line: {\n        style: {\n          stroke: '#000',\n          lineDash: [0]\n        }\n      }\n    }\n  ],\n  tooltip: {\n    mark: {\n      title: {\n        value: datum => datum.country\n      }\n    }\n  },\n  data: {\n    id: 'data',\n    values: [\n      { x: 95, y: 95, z: 13.8, name: 'BE', country: 'Belgium' },\n      { x: 86.5, y: 102.9, z: 14.7, name: 'DE', country: 'Germany' },\n      { x: 80.8, y: 91.5, z: 15.8, name: 'FI', country: 'Finland' },\n      { x: 80.4, y: 102.5, z: 12, name: 'NL', country: 'Netherlands' },\n      { x: 80.3, y: 86.1, z: 11.8, name: 'SE', country: 'Sweden' },\n      { x: 78.4, y: 70.1, z: 16.6, name: 'ES', country: 'Spain' },\n      { x: 74.2, y: 68.5, z: 14.5, name: 'FR', country: 'France' },\n      { x: 73.5, y: 83.1, z: 10, name: 'NO', country: 'Norway' },\n      { x: 71, y: 93.2, z: 24.7, name: 'UK', country: 'United Kingdom' },\n      { x: 69.2, y: 57.6, z: 10.4, name: 'IT', country: 'Italy' },\n      { x: 68.6, y: 20, z: 16, name: 'RU', country: 'Russia' },\n      { x: 65.5, y: 126.4, z: 35.3, name: 'US', country: 'United States' },\n      { x: 65.4, y: 50.8, z: 28.5, name: 'HU', country: 'Hungary' },\n      { x: 63.4, y: 51.8, z: 15.4, name: 'PT', country: 'Portugal' },\n      { x: 64, y: 82.9, z: 31.3, name: 'NZ', country: 'New Zealand' }\n    ]\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [标注 demo](https://www.visactor.io/vchart/demo/marker/mark-line-basic?keyword=marker)\n- [标注教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/marker)\n- [相关 api](https://www.visactor.io/vchart/option/barChart#markLine.label.text)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '14-How to customize the label text content, color, and layout of a pie chart.md',
    content:
      "# 如何自定义饼图的 label 文字内容、颜色、布局\n\n## 问题描述\n\n类似[这样](https://www.visactor.io/vchart/demo/pie-chart/basic-pie)的饼图，label 的文字内容、颜色、布局可以按照自定义的需求调整吗？能够支持到什么粒度？应该怎么配置调整？\n\n![pie chart](/vchart/faq/26-0.png)\n\n## 解决方案\n\n不同图表库对饼图的支持力度不同，对饼图 label 标签支持力度也不同，在 VChart 中：\n\n- label 的文字内容：可以通过`label.formatMethod`回调函数设置自定义的标签内容，[参考配置文档](https://www.visactor.io/vchart/option/pieChart#label.formatMethod)\n- label 的文字颜色：可以通过`label.style`设置文字的样式，包括颜色、字体、大小等等，只要是 VChart 文字图形支持的属性都可以配置，[参考配置文档](https://www.visactor.io/vchart/option/pieChart#label.style.text)\n- label 的布局：如果是想简单的调整标签的位置，可以通过`label.position`设置标签的位置是在内部还是外部；如果想调整布局策略，可以通过`label.layout`进行详细的调整，具体可以[参考配置文档](https://www.visactor.io/vchart/option/pieChart#label.layout.textAlign)\n\n## 代码示例\n\n- 自定义文字内容和文字颜色\n\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  scales: [{\n    id: 'labelScale',\n    type: 'linear',\n    domain: [{\n      dataId: 'id0',\n      fields: ['value']\n    }],\n    range: ['red', 'green'],\n  }],\n  label: {\n    visible: true,\n    formatMethod: (text, datum) => {\n      return `${datum.type}: ${datum.value}`\n    },\n    style: {\n      fill: {\n        scale: 'labelScale',\n        field: 'value'\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n![pie chart](/vchart/faq/26-1.png)\n\n- 自定义布局，将标签设置在饼图内部\n\n![pie chart](/vchart/faq/26-2.png)\n\n![pie chart](/vchart/faq/26-3.png)\n\n## 结果展示\n\n[在线效果参考](https://codesandbox.io/s/pie-chart-label-53s2p9)\n\n```javascript livedemo\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  scales: [\n    {\n      id: 'labelScale',\n      type: 'linear',\n      domain: [\n        {\n          dataId: 'id0',\n          fields: ['value']\n        }\n      ],\n      range: ['red', 'green']\n    }\n  ],\n  label: {\n    visible: true,\n    formatMethod: (text, datum) => {\n      return `${datum.type}: ${datum.value}`;\n    },\n    style: {\n      fill: {\n        scale: 'labelScale',\n        field: 'value'\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n```\n\n## 相关文档\n\n- [Label 文字内容配置](https://www.visactor.io/vchart/option/pieChart#label.formatMethod)\n- [Label 颜色配置](https://www.visactor.io/vchart/option/pieChart#label.style.fill)\n- [Label 布局配置](https://www.visactor.io/vchart/option/pieChart#label.position)\n- [饼图教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Pie)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '15- How to implement line breaks in pie chart labels.md',
    content:
      "---\ntitle: 52. 饼图标签如何实现换行效果</br>\n---\r\n# 问题标题\r\n\r\n饼图标签如何实现换行效果？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如何实现下面的饼图？标签需要支持两行的效果</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/FRrabZnLxoqqIvxzSKacV64En6q.gif' alt='' width='1668' height='998'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n饼图标签支持格式化方法，在格式化方法中，我们可以通过在返回对象中设置`type: rich`将标签切换成富文本；富文本支持常见的换行、icon、image的展示；</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UsSvb1nqnoxVjTxlowxcqJconhe.gif' alt='' width='3356' height='1196'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '26.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  pie: {\n    style: {\n      cornerRadius: 10\n    },\n    state: {\n      hover: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      },\n      selected: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  label: {\n    visible: true,\n    formatMethod: (label, datum) => {\n      return {\n        type: 'rich',\n        text: [{\n          text: `${label}\\n`,\n          fontSize: 12,\n          fill: '#8a8a8a',\n          lineHeight: 20,\n          fontWeight: 400\n        }, {\n          text: `${datum._percent_}%`,\n          fill: '#121212',\n          fontSize: 14,\n          fontWeight: 500,\n          lineHeight: 22,\n        }]\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/D30eb1AococGkaxIXM9cKi2wnwh.gif' alt='' width='1616' height='1062'>\r\n\r\n## 相关文档\r\n\r\n*  [富文本和 Dom 扩展](https%3A%2F%2Fvisactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FRichtext_and_Dom)</br>\r\n*  [VChart github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n\r\n"
  },
  {
    fileName: '16-How to achieve permanent display of chart tooltips.md',
    content:
      "# 如何实现图表 tooltip 常驻显示？\n\n## 问题描述\n\nVChart 如何配置 tooltip 永久显示，如下图：\n\n![tooltip](/vchart/faq/70-0.png)\n\n## 解决方案\n\nVChart 目前无法同时保留两个 tooltip，但是 tooltip 支持常驻显示，通过将 `triggerOff` 配置为 `none`。可以参照以下 demo：\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales',\n  tooltip: {\n    trigger: 'click',\n    triggerOff: 'none',\n    mark: {\n      position: 'top'\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/70-1.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\noption docs: [https://www.visactor.io/vchart/option/barChart#tooltip.visible](https://www.visactor.io/vchart/option/barChart#tooltip.visible)\n"
  },
  {
    fileName: '17- How to use tooltips and the x-axis in the vchart library.md',
    content:
      "---\ntitle: 112. vchart 图表库中的 tooltip 和横坐标如何使用？</br>\n---\r\n# 问题标题\r\n\r\nvchart 图表库中的 tooltip 和横坐标如何使用？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我正在使用 vchart 图表库制作图表，但在设置 tooltip 和横坐标时遇到了困难。我尝试对 tooltip 进行配置，但它并没有显示出来，即使我设置了 visible 也无法显示它。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QVIIbry4sodz3axF4LXcMQxRnYc.gif' alt='' width='674' height='692'>\r\n\r\n此外，我还希望能够自定义 x 轴的内容。我不确定是我的使用方式不对还是有其他的问题。</br>\r\n\r\n\r\n# 解决方案\r\n\r\n首先，对于 tooltip 的配置问题，你的设置方式是正确的。</br>\r\n\r\n\r\n然后，关于 tooltip 没有生效的问题，你需要检查你的 `content` 是否写错了位置。如果你想要自定义 tooltip 的内容，可以参考[vchart 的这个示例](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fdemo%2Ftooltip%2Fcustom-tooltip)。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/OH4BbX2LPoFfLHxtvbhclGS2nrf.gif' alt='' width='3482' height='1592'>\r\n\r\n最后，关于 x 轴的自定义内容，你可以通过在 `axes.label` 中设置样式来实现。你还可以使用 `formatMethod` 来自定义内容。具体实现方法可以参考[vchart 的这个示例](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fdemo%2Faxis%2Fgrid-style)。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/D2cMbBI6wo1ftYxEhbkc0E7Unie.gif' alt='' width='3526' height='1306'>\r\n\r\n\r\n\r\n\r\n\r\n# 相关文档\r\n\r\n*  [vchart Tooltip 使用指南](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FTooltip)</br>\r\n*  [vchart Axis 样式设置示例](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fdemo%2Faxis%2Fstyle)</br>\r\n*  [vchart 自定义 Tooltip 示例](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fdemo%2Ftooltip%2Fcustom-tooltip)</br>\r\n*  [vchart Axis 网格样式示例](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fdemo%2Faxis%2Fgrid-style)</br>"
  },
  {
    fileName: '18-How to truncate, wrap, or perform other formatting effects on axis labels in charts.md',
    content:
      "# 图表的轴标签如何做截断，换行等效果？\n\n## 问题描述\n\n类似[这样](https://www.visactor.io/vchart/demo/bar-chart/basic-bar)这样的条形图，\n\n![bar chart](/vchart/faq/24-0.png)\n\n当轴标签非常长的时候，怎么实现换行？截断相关效果\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中只需要配置 axes 中对应轴的`label`相关配置：\n\n- 通过`formatMethod`返回数组，可以实现自定义换行\n- 通过`style.maxLineWidth`可以实现自动截断\n- 通过`style.ellipsis`可以设置省略符\n\n![code](/vchart/faq/24-1.png)\n\n## 代码示例\n\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          name: 'Apple https://www.apple.com/',\n          value: 214480\n        },\n        {\n          name: 'Google https://www.google.com.hk/',\n          value: 155506\n        },\n        {\n          name: 'Amazon https://www.amazon.com/',\n          value: 100764\n        },\n        {\n          name: 'Microsoft https://www.microsoft.com/',\n          value: 92715\n        }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  xField: 'value',\n  yField: 'name',\n  axes: [\n    {\n      orient: 'bottom',\n      visible: false\n    },\n    {\n      orient: 'left',\n      label: {\n        formatMethod: (text, datum) => {\n          return text.split(' ');\n        },\n        style: {\n          maxLineWidth: 100,\n          ellipsis: '~'\n        }\n      }\n    }\n  ],\n  label: {\n    visible: true\n  }\n};\n```\n\n## 结果展示\n\n[在线效果参考](https://codesandbox.io/s/axis-label-auto-limit-pnsvzl)\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          name: 'Apple https://www.apple.com/',\n          value: 214480\n        },\n        {\n          name: 'Google https://www.google.com.hk/',\n          value: 155506\n        },\n        {\n          name: 'Amazon https://www.amazon.com/',\n          value: 100764\n        },\n        {\n          name: 'Microsoft https://www.microsoft.com/',\n          value: 92715\n        }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  xField: 'value',\n  yField: 'name',\n  axes: [\n    {\n      orient: 'bottom',\n      visible: false\n    },\n    {\n      orient: 'left',\n      label: {\n        formatMethod: (text, datum) => {\n          return text.split(' ');\n        },\n        style: {\n          maxLineWidth: 100,\n          ellipsis: '~'\n        }\n      }\n    }\n  ],\n  label: {\n    visible: true\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n```\n\n## 相关文档\n\n- [坐标轴 demo](https://www.visactor.io/vchart/demo/axis/animation)\n- [坐标轴教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes)\n- [相关配置](https://www.visactor.io/vchart/option/barChart#axes-band.label.style.ellipsis)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '19-How to configure gradient colors for area charts.md',
    content:
      "# 面积图渐变色如何配置，能否支持堆叠面积图配置不同渐变方向的渐变色？\n\n## 问题描述\n\n类似[这样](https://www.visactor.io/vchart/demo/area-chart/percentage-stacked-area)的面积图，\n\n![area chart](/vchart/faq/23-0.png)\n\n想要实现渐变色的效果，应该怎么实现？能够配置不同的渐变方向吗？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中只需要配置 `area.style.fill`为渐变色，通过改变 `x0` 、 `y0` 、 `x1` 、 `y1` 这四个点的值来改变渐变的 方向。\n\n![code](/vchart/faq/23-1.png)\n\n## 代码示例\n\n```\nconst spec = {\n  type: 'area',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: '100% stacked area chart of cosmetic products sales'\n  },\n  percent: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ],\n  area: {\n    style: {\n      fill: {\n        gradient: 'linear',\n        x0: 0.5,\n        y0: 0,\n        x1: 0.5,\n        y1: 1,\n        stops: [\n          {\n            offset: 0,\n            opacity: 1\n          },\n          {\n            color: 'black',\n            offset: 1,\n            opacity: 0.3\n          }\n        ]\n      }\n    }\n  }\n};\n```\n\n## 结果展示\n\n[在线效果参考](https://codesandbox.io/s/area-chart-linear-gradient-xhdmc7)\n\n```javascript livedemo\nconst spec = {\n  type: 'area',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: '100% stacked area chart of cosmetic products sales'\n  },\n  percent: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ],\n  area: {\n    style: {\n      fill: {\n        gradient: 'linear',\n        x0: 0.5,\n        y0: 0,\n        x1: 0.5,\n        y1: 1,\n        stops: [\n          {\n            offset: 0,\n            opacity: 1\n          },\n          {\n            color: 'black',\n            offset: 1,\n            opacity: 0.3\n          }\n        ]\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n```\n\n## 关于渐变色配置\n\n从上方的 api 中，可以看到 VChart 中的渐变色与 canvas 的渐变色 api 一致，能较好的支持各种渐变需求。\n\n可以从下图中了解渐变色的绘制规则。\n\n![gradient](/vchart/faq/23-3.png)\n\n### 起点与终点\n\n参数中有 2 组位置信息，上图中表明了起点与终点在渐变色绘制时的意义。\n\n起点：(**x0**,**y0**)\n\n终点：(**x1**,**y1**)\n\n**注意** 在 VChart 中，**起点，终点** 的配置与 canvas 有少许不同。canvas 中位置是画布中的点位置。在 chartSpace 中，位置是图元 **_左上角_** 至图元 **_右下角_** **【0，1】** 区间的比例位置。具体了请看下图：\n\n![gradient](/vchart/faq/23-4.png)\n\n### 渐变阶段\n\n这一部分与 canvas 的 api 没有区别，每一个阶段都需要配置 **offset** 与 **color**。可以配置多个阶段。\n\n## 相关文档\n\n- [堆积面积图 demo](https://www.visactor.io/vchart/demo/area-chart/percentage-stacked-area)\n- [面积图教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Area)\n- [相关配置](https://www.visactor.io/vchart/option/areaChart#area.style.fill)\n- [github](https://github.com/VisActor/VChart)\n- [Canvas 渐变 api](https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/createLinearGradient)\n"
  },
  {
    fileName: '20- How to add graphics to axis labels.md',
    content:
      "---\ntitle: 88. 如何使轴标签带上图形？</br>\n---\r\n## 问题标题\r\n\r\nVChart  如何使轴标签带上图形？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n想要对x轴的特殊值标签用图形进行标记</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/VHdTboml6oZe2axigfDcLpt8nqd.gif' alt='' width='715' height='206'>\r\n\r\n## 解决方案\r\n\r\n坐标轴的标签目前已经支持配置富文本内容</br>\r\n```\n label: {\n        formatMethod: label => {\n          return {\n            type: 'rich',\n            text: [\n              {\n                text: `${label}`,\n                fontSize: 16,\n                fontWeight: 'bold',\n                fontStyle: 'italic'\n              },\n              { image: `icon address`, width: 40, height: 40 },\n            ]\n          };\n        }\n      }</br>\n```\r\n## 代码示例 \r\n\r\n```\nconst rankIcon = {\n  'Top 1': 'https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/gold-medal.svg',\n  'Top 2': 'https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/silver-medal.svg',\n  'Top 3': 'https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/bronze-medal.svg'\n};\nconst spec = {\n  type: 'bar',\n  height: 300,\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { name: 'Top 1', value: 990 },\n        { name: 'Top 2', value: 680 },\n        { name: 'Top 3', value: 255 }\n      ]\n    }\n  ],\n  barWidth: 20,\n  yField: 'name',\n  xField: 'value',\n  bar: {\n    style: {\n      cornerRadius: [0, 10, 10, 0],\n      fill: {\n        gradient: 'linear',\n        x0: 0,\n        y0: 0.5,\n        x1: 1,\n        y1: 0.5,\n        stops: [\n          { offset: 0, color: 'rgb(255,163,1)' },\n          { offset: 1, color: 'rgb(255,4,0)' }\n        ]\n      }\n    }\n  },\n  barBackground: {\n    visible: true\n  },\n  label: {\n    visible: true,\n    position: 'center',\n    style: {\n      fill: 'white',\n      stroke: false\n    }\n  },\n  direction: 'horizontal',\n  seriesField: 'type',\n  padding: { left: 50 },\n  axes: [\n    {\n      orient: 'left',\n      minWidth: 50,\n      label: {\n        formatMethod: label => {\n          return {\n            type: 'rich',\n            text: [\n              { image: rankIcon[label], width: 40, height: 40 },\n              {\n                text: `${label}`,\n                fontSize: 16,\n                fontWeight: 'bold',\n                fontStyle: 'italic'\n              }\n            ]\n          };\n        }\n      }\n    }\n  ]\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WdJWbe65HoO8xoxpasMcoQTunon.gif' alt='' width='840' height='308'>\r\n\r\n## 相关文档\r\n\r\n*  github：https://www.visactor.io/vchart/option/barChart-axes-band#label.formatMethod</br>\r\n*  相关 demo：https://www.visactor.io/vchart/demo/axis/axis-richtext-label?keyword=axis</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '21- How to adjust the display order of contents in the Tooltip of a VChart stacked bar chart.md',
    content:
      "---\ntitle: 78.VChart堆积柱图如何调整Tooltip中内容的展示顺序？</br>\n---\r\n## 问题标题\r\n\r\nVChart堆积柱图如何调整Tooltip中内容的展示顺序？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n堆叠柱状图中，堆积的顺序好像和数据的顺序相反一样，然后 tooltip 又反过来，要怎么让柱子的颜色顺序和 tooltip 的顺序一致？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/W0e9byEEho1A4hxq8t1cVFsAnSd.gif' alt='' width='1526' height='1104'>\r\n\r\n## 解决方案\r\n\r\n对于堆积柱状图，可以有两个方案，使得tooltip中内容的顺序和柱子的堆积顺序一致：</br>\r\n*  方案一：`stackInverse:true `调整堆积的顺序</br>\r\n```\n{\n  stack: true,\n  stackInverse: true\n}</br>\n```\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/ZKcvb10Y2o6GG6xn5DpcIYO5nlh.gif' alt='' width='1466' height='1024'>\r\n\r\n*  方案二：调整tooltip中元素的顺序</br>\r\n```\ntooltip: {\n    dimension: {\n      updateContent: (items) => {\n        return items.reverse();\n      }\n    }\n  }</br>\n```\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/PgKmbiLsco6GeGxOQKFcJLWbnme.gif' alt='' width='1520' height='1070'>\r\n\r\n## 代码示例 \r\n\r\n*  方案一：</br>\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  stackInverse: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n*  方案二</br>\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  tooltip: {\n    dimension: {\n      updateContent: (items) => {\n        return items.reverse();\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  [`stackInverse`](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FbarChart%23region.stackInverse)[配置项](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FbarChart%23region.stackInverse)</br>\r\n*  [tooltip配置](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FbarChart%23tooltip.dimension.updateContent)</br>\r\n\r\n"
  },
  {
    fileName: '22- How to center the labels in a bar chart.md',
    content:
      '---\ntitle: 15. 如何设置柱状图的标签居中？</br>\n---\r\n## 问题标题\r\n\r\n如何设置柱状图的标签居中？</br>\r\n## 问题描述\r\n\r\n堆叠柱状图中， 期望让每个 label 都居中显示。</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样， VChart 提供`label`配置项， 支持各种`postion`配置。</br>\r\n可选字符串值为：`\'outside\'`、`\'top\'`、`\'bottom\'`、`\'left\'`、`\'right\'`、`\'inside\'`、`\'inside-top\'`、`\'inside-bottom\'`、`\'inside-right\'`·`\'inside-left\'`、`\'top-right\'`、`\'top-left\'`、`\'bottom-right\'`、`\'bottom-left\'`</br>\r\n## 代码示例\r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "bar",\n      label: {\n        visible: true,\n        position: "inside",\n      },\n      data: [\n        {\n          id: "barData",\n          values: [\n            { type: "Autocracies", year: "1930", value: 129 },\n            { type: "Autocracies", year: "1940", value: 133 },\n            { type: "Autocracies", year: "1950", value: 130 },\n            { type: "Autocracies", year: "1960", value: 126 },\n            { type: "Autocracies", year: "1970", value: 117 },\n            { type: "Autocracies", year: "1980", value: 114 },\n            { type: "Autocracies", year: "1990", value: 111 },\n            { type: "Autocracies", year: "2000", value: 89 },\n            { type: "Autocracies", year: "2010", value: 80 },\n            { type: "Autocracies", year: "2018", value: 80 },\n            { type: "Democracies", year: "1930", value: 22 },\n            { type: "Democracies", year: "1940", value: 13 },\n            { type: "Democracies", year: "1950", value: 25 },\n            { type: "Democracies", year: "1960", value: 29 },\n            { type: "Democracies", year: "1970", value: 38 },\n            { type: "Democracies", year: "1980", value: 41 },\n            { type: "Democracies", year: "1990", value: 57 },\n            { type: "Democracies", year: "2000", value: 87 },\n            { type: "Democracies", year: "2010", value: 98 },\n            { type: "Democracies", year: "2018", value: 99 },\n          ],\n        },\n      ],\n      xField: ["year", "type"],\n      yField: "value",\n      seriesField: "type",\n      legends: {\n        visible: true,\n        orient: "top",\n        position: "start",\n      },\n    };\n\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart"></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);</br>\n```\r\n## 结果展示\r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-label-center-cz7wjm?file=%2Fsrc%2Findex.js%3A1%2C1-70%2C1</br>\r\n## 相关文档\r\n\r\nLabel API: https://visactor.io/vchart/option/barChart#label</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '23- How to customize legend shapes.md',
    content:
      "---\ntitle: 76. 如何自定义图例形状？</br>\n---\r\n## 问题标题\r\n\r\n如何自定义图例形状？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n我这里需要绘制一个包含图例的饼图，希望图例项对应的形状是扇形的，请问应该如何实现呢？另外再问一下应该如何设置图例的位置呀？</br>\r\n\r\n\r\n## 解决方案\r\n\r\n图例项对应的形状可以通过 `legends.item.shape.style.symbolType` 进行配置。symbolType 的内容可以是 vchart 内置的形状，例如 'rect'、'circle' 等，同时用户也可以设置自定义的 svg path 以实现任意的形状。</br>\r\n```\n  legends: {\n    visible: true,\n    item: {\n      shape: {\n        style: {\n          symbolType: 'rect'\n          // symbolType: 'M -1 1 L 0 0 L 1 1'\n        }\n      }\n    }\n  }</br>\n```\r\n图例的位置通过 `legends.orient` 进行配置，可选的位置包括：left、right、top、bottom：</br>\r\n```\n  legends: {\n    visible: true,\n    orient: 'right'\n  }</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst data = [\n  { value: 10, category: 'One' },\n  { value: 9, category: 'Two' },\n  { value: 6, category: 'Three' },\n  { value: 5, category: 'Four' },\n  { value: 4, category: 'Five' },\n  { value: 3, category: 'Six' },\n  { value: 1, category: 'Seven' }\n];\nlet totalValue = 0;\ndata.forEach(obj => (totalValue += obj.value));\nconst map = {};\ndata.forEach(obj => {\n  map[obj.category] = `${((obj.value / totalValue) * 100).toFixed(2)}%`;\n});\n\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'pie',\n      values: data\n    }\n  ],\n  categoryField: 'category',\n  valueField: 'value',\n  legends: {\n    visible: true,\n    orient: 'right',\n    item: {\n      shape: {\n        style: {\n          symbolType: 'rect'\n        }\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\n\nvchart.renderSync();\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TWpZbH5oboQV4Yx3mEWcsr2XnOd.gif' alt='' width='1712' height='1086'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  Legend shape：https://visactor.bytedance.net/vchart/option/barChart-legends-discrete#item.shape.style</br>\r\n*  Legend orient：https://visactor.bytedance.net/vchart/option/barChart-legends-discrete#orient</br>\r\n\r\n"
  },
  {
    fileName: '24- How to configure a custom theme in VChart.md',
    content:
      "---\ntitle: 13. 如何在VChart中配置自定义主题？</br>\n---\r\n# **问题标题**\r\n\r\n如何在 VChart 中配置自定义主题？</br>\r\n\r\n\r\n# **问题描述**\r\n\r\n我正在使用VChart进行数据可视化，想要为图表设置自定义主题，但是不知道如何实现。同时，我也想了解如何动态更新图表的主题。希望有经验的人能够指导一下。</br>\r\n\r\n\r\n# **解决方案**\r\n\r\nVChart提供了两种方式配置和更新自定义主题：通过图表spec配置主题以及通过ThemeManager注册主题。接下来，我们将分别介绍这两种方法的使用。</br>\r\n\r\n\r\n## **通过spec配置主题**\r\n\r\n在定义图表时，我们可以直接将符合ITheme类型的主题对象传入图表spec的theme配置项，从而应用这个自定义主题。具体步骤如下：</br>\r\n1. 创建一个符合ITheme类型的主题对象，例如：</br>\r\n```\nconst theme = {*\n*  colorScheme: {*\n*    default: [*\n*      '#5383F4',*\n*      '#7BCF8E',*\n*      '#FF9D2C',*\n*      '#FFDB26',*\n*      '#7568D9',*\n*      '#80D8FB',*\n*      '#1857A3',*\n*      '#CAB0E8',*\n*      '#FF8867',*\n*      '#B9E493',*\n*      '#2CB4A8',*\n*      '#B9E4E3'*\n*    ]*\n*  },*\n*  series: {*\n*    bar: {*\n*      barMaxWidth: 15,*\n*      label: {*\n*        visible: true,*\n*        position: 'top',*\n*        formatMethod: text => text + '%'*\n*      }*\n*    }*\n*  },*\n*  component: {*\n*    axis: {*\n*      label: {*\n*        style: { fontFamily: 'Times New Roman' }*\n*      }*\n*    }*\n*  },*\n*  markByName: {*\n*    bar: {*\n*      style: {*\n*        cornerRadius: 15*\n*      }*\n*    }*\n*  }*\n*};</br>\n```\r\n1. 在定义图表时，将该主题对象传入图表spec的theme配置项，例如：</br>\r\n```\nconst spec = {*\n*  type: 'bar',*\n*  data: [*\n*    {*\n*      id: 'id0',*\n*      values: data*\n*    }*\n*  ],\n  ...*\n*  theme: theme,\n  ...\n}</br>\n```\r\n## **通过ThemeManager注册主题**\r\n\r\nVChart还提供了一个名为ThemeManager的主题管理器，你可以使用它来全局注册自定义主题。同时也可以用ThemeManager.setCurrentTheme通过主题名称来应用已注册的主题。具体步骤如下：</br>\r\n1. 在应用中注册主题对象，例如：</br>\r\n```\nVChart.ThemeManager.registerTheme('userTheme', theme);</br>\n```\r\n1. 在需要使用该主题的图表中，通过ThemeManager.setCurrentTheme来应用该主题，例如：</br>\r\n```\nVChart.ThemeManager.setCurrentTheme('myTheme');</br>\n```\r\n\r\n\r\n# 相关文档\r\n\r\n自定义主题：https://www.visactor.io/vchart/guide/tutorial_docs/Theme/Customize_Theme</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '25- How to listen to DataZoom operations.md',
    content:
      '---\ntitle: 16. 如何监听 DataZoom 的操作？</br>\n---\r\n## 问题标题\r\n\r\n如何监听 DataZoom 的操作？</br>\r\n## 问题描述\r\n\r\n需要获取用户对图表 dataZoom 的交互后的状态信息， 用于下次渲染时， 保留 dataZoom 的状态。</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样， VChart 提供`dataZoomChange`事件， 用于获取图表 DataZoom 改变后的新的`start`与`end`， 以及其它的信息。</br>\r\n获取到新的`start`与`end`后， 用户可以保存这个信息， 在需要的时候重新写回 spec， 从而让 dataZoom 状态持久化。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "scatter",\n      xField: "revenues_mm",\n      yField: "profit_mm",\n      seriesField: "category",\n      dataZoom: [\n        {\n          orient: "bottom",\n          start: 0,\n          end: 0.4,\n          minSpan: 0.2,\n          maxSpan: 0.8,\n          filterMode: "axis",\n        },\n      ],\n      axes: [\n        {\n          title: {\n            visible: true,\n            text: "revenues_mm",\n          },\n          orient: "left",\n          type: "linear",\n        },\n        {\n          title: {\n            visible: true,\n            text: "profit_mm",\n          },\n          orient: "bottom",\n          label: { visible: true },\n          type: "linear",\n        },\n      ],\n      legends: [{}],\n      data: [\n        {\n          id: "data",\n          values: [\n            {\n              company: "Johnson & Johnson",\n              revenues_mm: 71890,\n              profit_mm: 18540,\n              profit_as_of_revenues: 0.2578940047294478,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Procter & Gamble",\n              revenues_mm: 71726,\n              profit_mm: 10508,\n              profit_as_of_revenues: 0.14650196581434904,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Abbvie",\n              revenues_mm: 25638,\n              profit_mm: 5953,\n              profit_as_of_revenues: 0.23219439893907481,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Amgen",\n              revenues_mm: 22991,\n              profit_mm: 7722,\n              profit_as_of_revenues: 0.33587055804445215,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Eli Lilly",\n              revenues_mm: 21222,\n              profit_mm: 2738,\n              profit_as_of_revenues: 0.12901705777023842,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Bristol-Myers Squibb",\n              revenues_mm: 19427,\n              profit_mm: 4457,\n              profit_as_of_revenues: 0.22942296803417925,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Altria Group",\n              revenues_mm: 19337,\n              profit_mm: 14239,\n              profit_as_of_revenues: 0.7363603454517247,\n              category: "Tobacco",\n            },\n            {\n              company: "Kimberly-Clark",\n              revenues_mm: 18202,\n              profit_mm: 2166,\n              profit_as_of_revenues: 0.11899791231732777,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "General Mills",\n              revenues_mm: 16563,\n              profit_mm: 1697,\n              profit_as_of_revenues: 0.10245728430839823,\n              category: "Food",\n            },\n            {\n              company: "Colgate-Palmolive",\n              revenues_mm: 15195,\n              profit_mm: 2441,\n              profit_as_of_revenues: 0.16064494899638038,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Conagra Brands",\n              revenues_mm: 14134,\n              profit_mm: -677,\n              profit_as_of_revenues: -0.04789868402433847,\n              category: "Food",\n            },\n            {\n              company: "Land O\'Lakes",\n              revenues_mm: 13233,\n              profit_mm: 245,\n              profit_as_of_revenues: 0.01851432025995617,\n              category: "Food",\n            },\n            {\n              company: "Pepsico",\n              revenues_mm: 62789,\n              profit_mm: 6329,\n              profit_as_of_revenues: 0.1007979104620236,\n              category: "Food",\n            },\n            {\n              company: "Kellogg",\n              revenues_mm: 13014,\n              profit_mm: 694,\n              profit_as_of_revenues: 0.053327186107269095,\n              category: "Food",\n            },\n            {\n              company: "Reynolds American",\n              revenues_mm: 12503,\n              profit_mm: 6073,\n              profit_as_of_revenues: 0.48572342637766935,\n              category: "Tobacco",\n            },\n            {\n              company: "Biogen",\n              revenues_mm: 11449,\n              profit_mm: 3703,\n              profit_as_of_revenues: 0.32343436107957024,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Estee Lauder",\n              revenues_mm: 11262,\n              profit_mm: 1115,\n              profit_as_of_revenues: 0.09900550523885633,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Celgene",\n              revenues_mm: 11229,\n              profit_mm: 1999,\n              profit_as_of_revenues: 0.17802119511977915,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Hormel Foods",\n              revenues_mm: 9523,\n              profit_mm: 890,\n              profit_as_of_revenues: 0.09345794392523364,\n              category: "Food",\n            },\n            {\n              company: "Campbell Soup",\n              revenues_mm: 7961,\n              profit_mm: 563,\n              profit_as_of_revenues: 0.07071975882426831,\n              category: "Food",\n            },\n            {\n              company: "J. M. Smucker",\n              revenues_mm: 7811,\n              profit_mm: 689,\n              profit_as_of_revenues: 0.08820893611573422,\n              category: "Food",\n            },\n            {\n              company: "Dean Foods",\n              revenues_mm: 7710,\n              profit_mm: 120,\n              profit_as_of_revenues: 0.01556420233463035,\n              category: "Food",\n            },\n            {\n              company: "Hershey",\n              revenues_mm: 7440,\n              profit_mm: 720,\n              profit_as_of_revenues: 0.0967741935483871,\n              category: "Food",\n            },\n            {\n              company: "Pfizer",\n              revenues_mm: 52824,\n              profit_mm: 7215,\n              profit_as_of_revenues: 0.13658564288959563,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Constellation Brands",\n              revenues_mm: 6548,\n              profit_mm: 1055,\n              profit_as_of_revenues: 0.16111789859499084,\n              category: "Beverages",\n            },\n            {\n              company: "Dr. Pepper Snapple Group",\n              revenues_mm: 6440,\n              profit_mm: 847,\n              profit_as_of_revenues: 0.13152173913043477,\n              category: "Beverages",\n            },\n            {\n              company: "HRG Group",\n              revenues_mm: 6403,\n              profit_mm: -199,\n              profit_as_of_revenues: -0.031079181633609246,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Treehouse Foods",\n              revenues_mm: 6175,\n              profit_mm: -229,\n              profit_as_of_revenues: -0.03708502024291498,\n              category: "Food",\n            },\n            {\n              company: "Avon Products",\n              revenues_mm: 5853,\n              profit_mm: -108,\n              profit_as_of_revenues: -0.018452075858534086,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Clorox",\n              revenues_mm: 5761,\n              profit_mm: 648,\n              profit_as_of_revenues: 0.11248047214025343,\n              category: "Household & Personal Products",\n            },\n            {\n              company: "Coca-Cola",\n              revenues_mm: 41863,\n              profit_mm: 6527,\n              profit_as_of_revenues: 0.15591333635907603,\n              category: "Beverages",\n            },\n            {\n              company: "Merck",\n              revenues_mm: 39807,\n              profit_mm: 3920,\n              profit_as_of_revenues: 0.09847514256286583,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Gilead Sciences",\n              revenues_mm: 30390,\n              profit_mm: 13501,\n              profit_as_of_revenues: 0.4442579795985522,\n              category: "Pharmaceuticals",\n            },\n            {\n              company: "Philip Morris International",\n              revenues_mm: 26685,\n              profit_mm: 6967,\n              profit_as_of_revenues: 0.2610830054337643,\n              category: "Tobacco",\n            },\n            {\n              company: "Kraft Heinz",\n              revenues_mm: 26487,\n              profit_mm: 3632,\n              profit_as_of_revenues: 0.1371238720881942,\n              category: "Food",\n            },\n            {\n              company: "Mondelez International",\n              revenues_mm: 25923,\n              profit_mm: 1659,\n              profit_as_of_revenues: 0.06399722254368707,\n              category: "Food",\n            },\n          ],\n        },\n      ],\n    };\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    vchart.on("dataZoomChange", (params) => {\n      const { value } = params;\n      console.log("changed value:", value.start, value.end);\n    });\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart"></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-datazoom-event-kczn5h?file=%2Fsrc%2Findex.js%3A1%2C1-327%2C1</br>\r\n## 相关文档\r\n\r\nDataZoom Event API: https://visactor.io/vchart/api/API/event</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '26- How to render axis labels using HTML.md',
    content:
      "---\ntitle: 81.轴标签如何使用Html渲染？</br>\n---\r\n## 问题标题\r\n\r\n轴标签如何使用Html渲染？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n坐标轴的标签，如何使用自定义html 渲染，另外可以实现自定义的跳转链接吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/KEQxbk7xAontacxrFqAcPP7Pncc.gif' alt='' width='1544' height='1058'>\r\n\r\n## 解决方案\r\n\r\nVChart的轴标签是支持使用`html`绝对定位进行展示的，要实现该功能：</br>\r\n*  第一步： VChart需要通过`enableHtmlAttribute: true`打开相关插件</br>\r\n```\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, enableHtmlAttribute: true });\nvchart.renderSync();</br>\n```\r\n*  第二步：在轴标签配置的时候，通过`formatMethod`返回html类型的标签</br>\r\n*  第三步：通过`<a>`标签实现自定义的url跳转，并设置`pointerEvents: 'auto'`打开标签的鼠标事件</br>\r\n```\naxes: [\n    {\n      orient: 'bottom',\n      sampling: false,\n      label: {\n        style: {\n          forceBoundsWidth: 40\n        },\n        formatMethod: (label, a) => {\n          return {\n            type: 'html',\n            text: {\n              pointerEvents: 'auto',\n              id: `x-label-${label}`,\n              style: {\n                width: '40px',\n                overflow: 'hidden'\n              },\n              dom: `<a href=\"https://visactor.com/vchart/demo/line-chart/dash-line\">${label}</a>`\n            }\n          };\n        }\n      }\n    }\n  ],</br>\n```\r\n## 代码示例\r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        x: '1st',\n        y: 0.012\n      },\n      {\n        x: '2nd',\n        y: -0.01\n      },\n      {\n        x: '3rd',\n        y: 0.005\n      },\n      {\n        x: '4th',\n        y: 0.007\n      },\n      {\n        x: '5th',\n        y: 0.01\n      },\n      {\n        x: '6th',\n        y: 0.017\n      },\n      {\n        x: '7th',\n        y: 0.022\n      },\n      {\n        x: '8th (prediction)',\n        y: 0.033,\n        latest: true\n      }\n    ]\n  },\n  xField: 'x',\n  yField: 'y',\n  axes: [\n    {\n      orient: 'bottom',\n      sampling: false,\n      label: {\n        style: {\n          forceBoundsWidth: 40\n        },\n        formatMethod: (label, a) => {\n          return {\n            type: 'html',\n            text: {\n              pointerEvents: 'auto',\n              id: `x-label-${label}`,\n              style: {\n                width: '40px',\n                overflow: 'hidden'\n              },\n              dom: `<a href=\"https://visactor.com/vchart/demo/line-chart/dash-line\">${label}</a>`\n            }\n          };\n        }\n      }\n    }\n  ],\n  line: {\n    style: {\n      lineDash: data => {\n        if (data.latest) {\n          return [5, 5];\n        }\n        return [0];\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, enableHtmlAttribute: true });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 相关文档\r\n\r\n*  [github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n*  [轴标签](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FlineChart-axes-band%23label.formatMethod)[`formatMethod`](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FlineChart-axes-band%23label.formatMethod)[配置文档](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FlineChart-axes-band%23label.formatMethod)</br>\r\n*  [html扩展插件教程](https%3A%2F%2Fvisactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FRichtext_and_Dom)</br>\r\n\r\n"
  },
  {
    fileName: '27-How to customize the mounting node of the tooltip component in VChart.md',
    content:
      "# 如何自定义 Tooltip 组件的挂载节点？\n\n## 问题描述\n\nVChart 的 tooltip 支持更改挂载节点吗？比如挂在图表容器或者别的地方？\n\n## 解决方案\n\nVChart 的 tooltip spec 中有专门的配置项 `parentElement`，支持传入 HTMLElement 对象或者字符串（表示节点的 id），可以满足需求。下面是一个将 tooltip 挂载到图表容器上的示例：\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  tooltip: {\n    parentElement: CONTAINER_ID\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/71-0.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\noption docs: [https://www.visactor.io/vchart/option/barChart#tooltip.parentElement](https://www.visactor.io/vchart/option/barChart#tooltip.parentElement)\n"
  },
  {
    fileName: '28- How to configure a correlation scatterplot in VChart.md',
    content:
      "---\ntitle: 44. VChart 如何配置出相关性散点图</br>\n---\r\n## 问题标题\r\n\r\n如何配置出相关性散点图</br>\r\n## 问题描述\r\n\r\n期望散点图能配置出下面这样的效果</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/IJGPbi2HYoSTaqxt2KLcUdc7nlf.gif' alt='' width='1202' height='480'>\r\n\r\n## 解决方案 \r\n\r\nVChart 在1.3.0版本之后，支持了散点相关性图：correlation ，它的关键配置如下：</br>\r\n*  `categoryField` 属性声明为节点名称字段配置</br>\r\n*  `valueField` 属性声明为相关性数据字段配置</br>\r\n*  `sizeField` 属性声明为节点尺寸数据字段配置</br>\r\n*  `sizeRange` 属性声明为节点尺寸映射范围</br>\r\n*  `correlationChart.innerRadius`: 节点分布内半径</br>\r\n*  `correlationChart.outerRadius`: 节点分布外半径</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'correlation',\n  data: [\n    {\n      values: [\n        { word: '输入法哪个好用', pv: 15952, ratio: 94, sim: 3932 },\n        { word: '谷歌拼音输入法', pv: 11032, ratio: 97, sim: 2799 },\n        { word: '讯飞输入法', pv: 107908, ratio: 102, sim: 2645 },\n        { word: 'QQ输入法', pv: 74912, ratio: 99, sim: 2189 },\n        { word: '百度输入法', pv: 193624, ratio: 121, sim: 2100 },\n        { word: '搜狗输入法', pv: 835168, ratio: 88, sim: 2050 },\n        { word: '谷歌输入法', pv: 14140, ratio: 96, sim: 1953 },\n        { word: '手心输入法', pv: 19236, ratio: 97, sim: 1870 },\n        { word: '输入法不见了', pv: 1968, ratio: 109, sim: 1705 },\n        { word: '输入法哪个最好用', pv: 812, ratio: 150, sim: 1567 },\n        { word: '必应输入法', pv: 4602, ratio: 91, sim: 1522 },\n        { word: '章鱼输入法', pv: 18262, ratio: 97, sim: 1486 },\n        { word: '输入法下载', pv: 34186, ratio: 91, sim: 1278 },\n        { word: '拼音输入法', pv: 7186, ratio: 86, sim: 1009 },\n        { word: 'SHURUFA', pv: 13418, ratio: 102, sim: 924 },\n        { word: '微软输入法', pv: 4680, ratio: 88, sim: 804 },\n        { word: 'GOOGLE输入法', pv: 2206, ratio: 97, sim: 800 },\n        { word: '输入法切换不出来', pv: 15112, ratio: 85, sim: 764 },\n        { word: '章鱼输入法下载', pv: 8204, ratio: 135, sim: 754 },\n        { word: '讯飞输入法下载', pv: 5590, ratio: 106, sim: 609 },\n        { word: '输入法搜狗', pv: 352, ratio: 132, sim: 593 },\n        { word: '输入法皮肤', pv: 2476, ratio: 103, sim: 540 },\n        { word: '紫光输入法', pv: 1582, ratio: 86, sim: 538 },\n        { word: '输入法设置', pv: 1298, ratio: 75, sim: 527 },\n        { word: '搜狗输入法下载安装', pv: 126182, ratio: 102, sim: 521 },\n        { word: '微软拼音输入法', pv: 3442, ratio: 88, sim: 510 },\n        { word: 'QQ拼音输入法', pv: 24912, ratio: 98, sim: 478 },\n        { word: '输入发', pv: 150, ratio: 125, sim: 465 },\n        { word: 'SOUGOU输入法', pv: 264, ratio: 89, sim: 452 },\n        { word: '微软拼音', pv: 2772, ratio: 93, sim: 443 }\n      ]\n    }\n  ],\n\n  categoryField: 'word',\n  valueField: 'sim',\n\n  sizeField: 'pv',\n  sizeRange: [12, 30],\n\n  innerRadius: '25%',\n  outerRadius: '95%',\n\n  nodePoint: {\n    state: {\n      hover: {\n        lineWidth: 8,\n        strokeOpacity: 0.2\n      }\n    }\n  },\n\n  centerPoint: {\n    state: {\n      hover: {\n        lineWidth: 8,\n        strokeOpacity: 0.2\n      }\n    }\n  },\n\n  centerLabel: {\n    visible: true,\n    position: 'center',\n    style: {\n      fill: 'white',\n      text: '输入法'\n    }\n  },\n\n  label: {\n    visible: true,\n    position: 'bottom',\n    style: {\n      fill: 'black'\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/N6OXbbPwnomLRtxc4A5cUwAUnvc.gif' alt='' width='1207' height='619'>\r\n\r\nDemo: https://www.visactor.io/vchart/demo/correlation-chart/correlation-chart</br>\r\n## 相关文档\r\n\r\nDemo：https://www.visactor.io/vchart/demo/correlation-chart/correlation-chart</br>\r\n教程：</br>\r\n*  初始化VChart： https://visactor.io/vchart/api/API/vchart</br>\r\n*  散点相关性图配置：https://www.visactor.io/vchart/option/correlationChart</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '29- How to control layout spacing of charts and components within the chart.md',
    content:
      "---\ntitle: 26. 如何控制图表以及图表内组件的布局间距</br>\n---\r\n## 问题标题\r\n\r\n如何控制图表以及图表内组件的布局间距</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如何控制图表以及图表内组件的布局间距，如下图想要调整红框标记处的间距，让图表坐标轴和图例在左侧能对齐</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Q53VbI3XvoKqVHxSFfwc3em0nHg.gif' alt='' width='804' height='496'>\r\n\r\n## 解决方案\r\n\r\n可以使用 VChart 上提供的 `padding` 属性，如果想要配置图表的 padding，直接在 spec 的一级配置即可，如下：</br>\r\n\r\n\r\n```\nconst spec = {\n  padding: {\n    left: 0,\n  }\n}</br>\n```\r\n\r\n\r\n如果想要配置组件的 padding，直接在对应组件的属性下配置即可，VChart 为图表上所有的元素否提供了 padding 属性，具体使用可以在配置页面查找。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n下面的代码在 axes、legends 以及图表上配置了 padding，让图表左侧留白为 0。</br>\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          x: '2:00',\n          y: 82,\n          type: 'sales'\n        },\n        {\n          x: '4:00',\n          y: 50,\n          type: 'sales'\n        },\n        {\n          x: '6:00',\n          y: 64,\n          type: 'sales'\n        },\n        {\n          x: '8:00',\n          y: 30,\n          type: 'sales'\n        },\n        {\n          x: '10:00',\n          y: 40,\n          type: 'sales'\n        },\n        {\n          x: '12:00',\n          y: 40,\n          type: 'sales'\n        },\n        {\n          x: '14:00',\n          y: 56,\n          type: 'sales'\n        },\n        {\n          x: '16:00',\n          y: 40,\n          type: 'sales'\n        },\n        {\n          x: '18:00',\n          y: 64,\n          type: 'sales'\n        },\n        {\n          x: '20:00',\n          y: 74,\n          type: 'sales'\n        },\n        {\n          x: '22:00',\n          y: 98,\n          type: 'sales'\n        },\n        {\n          x: '2:00',\n          y: 62,\n          type: 'profit'\n        },\n        {\n          x: '4:00',\n          y: 30,\n          type: 'profit'\n        },\n        {\n          x: '6:00',\n          y: 32,\n          type: 'profit'\n        },\n        {\n          x: '8:00',\n          y: 10,\n          type: 'profit'\n        },\n        {\n          x: '10:00',\n          y: 20,\n          type: 'profit'\n        },\n        {\n          x: '12:00',\n          y: 20,\n          type: 'profit'\n        },\n        {\n          x: '14:00',\n          y: 36,\n          type: 'profit'\n        },\n        {\n          x: '16:00',\n          y: 20,\n          type: 'profit'\n        },\n        {\n          x: '18:00',\n          y: 44,\n          type: 'profit'\n        },\n        {\n          x: '20:00',\n          y: 74,\n          type: 'profit'\n        },\n        {\n          x: '22:00',\n          y: 78,\n          type: 'profit'\n        }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  xField: 'y',\n  yField: ['x', 'type'],\n  seriesField: 'type',\n  legends: {\n    visible: true,\n    orient: 'bottom',\n    position: 'left',\n    padding: {\n      left: 0\n    }\n  },\n  axes: [\n    {\n      orient: 'left',\n      paddingInner: 0,\n      padding: {\n        left: 0\n      }\n    }\n  ],\n  padding: {\n    left: 0\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/G1aIby60LoTsxqxIcibcdGLRnmc.gif' alt='' width='818' height='624'>\r\n\r\n## 相关文档\r\n\r\n*  API：</br>\r\n*  https://visactor.io/vchart/option/barChart#padding</br>\r\n*  https://visactor.io/vchart/option/barChart-axes-linear#padding</br>\r\n*  https://visactor.io/vchart/option/barChart-legends-discrete#padding</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '30-How to add prompt information to the legend.md',
    content:
      "# 如何给图例（legend）添加提示信息？\n\n## 问题描述\n\n如下图所示，图例的文本被省略了，我想要给他们添加提示信息，显示完整的文本，请问要如何操作？\n\n![](/vchart/faq/92-0.png)\n\n## 解决方案\n\n不同的图表库解决方案不同，在[ VChart](https://visactor.io/vchart/) 上默认支持了省略文本的完整文本展示，只需要 hover 上去就可以显示。\n\n当然你也可以通过监听图例的相关事件来创建自己的 tooltip 组件，具体可以参考这个例子: [链接](https://codesandbox.io/s/vchart-legend-custom-interaction-8qsx5z?file=/src/index.ts)\n\n## 结果展示\n\n```javascript livedemo\nconst data = [\n  { value: 10, category: 'One' },\n  { value: 9, category: 'Two' },\n  { value: 6, category: 'Three' },\n  { value: 5, category: 'Four' },\n  { value: 4, category: 'Five' },\n  { value: 3, category: 'Six' },\n  { value: 1, category: 'Seven' }\n];\nlet totalValue = 0;\ndata.forEach(obj => (totalValue += obj.value));\nconst map = {};\ndata.forEach(obj => {\n  map[obj.category] = `${((obj.value / totalValue) * 100).toFixed(2)}%`;\n});\n\nconst spec = {\n  type: 'pie',\n  width: 500,\n  data: [\n    {\n      id: 'pie',\n      values: data\n    }\n  ],\n  categoryField: 'category',\n  valueField: 'value',\n  legends: {\n    visible: true,\n    orient: 'right',\n    data: items => {\n      return items.map(item => {\n        item.value = map[item.label];\n        return item;\n      });\n    },\n    item: {\n      width: '15%',\n      value: {\n        alignRight: true,\n        style: {\n          fill: '#333',\n          fillOpacity: 0.8,\n          fontSize: 10\n        },\n        state: {\n          unselected: {\n            fill: '#d8d8d8'\n          }\n        }\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\n\nvchart.on('legendItemHover', e => {\n  const hoveredName = e?.value?.data?.label;\n  if (hoveredName) {\n    vchart.updateState({\n      legend_hover_reverse: {\n        filter: d => d.type !== hoveredName\n      }\n    });\n  }\n});\nvchart.on('legendItemUnHover', e => {\n  vchart.updateState({\n    legend_hover_reverse: {\n      filter: d => false\n    }\n  });\n});\n\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [图例 demo](https://visactor.io/vchart/demo/legend/custom-data)\n- [图例教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend)\n- [图例配置](https://visactor.io/vchart/option/barChart#legends-discrete.type)\n- [图例事件](https://www.visactor.io/vchart/api/API/event#legend)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '31- Can VChart be server-side rendered.md',
    content:
      "---\ntitle: 45. VChart 可以服务端渲染吗</br>\n---\r\n## 问题标题\r\n\r\n可以服务端渲染吗</br>\r\n## 问题描述\r\n\r\n可以服务端渲染吗？想要在服务端提供获取图表图片的服务。</br>\r\n## 解决方案 \r\n\r\nVChart 支持Node服务端渲染。VChart 使用的绘图库 VRender 支持了Node环境渲染。除了 VChart 外，只需要在服务端安装 [canvas](https%3A%2F%2Fwww.npmjs.com%2Fpackage%2Fcanvas) 包即可。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst fs = require('fs');\n\nconst VChart = require('@visactor/vchart');\nconst Canvas = require('canvas');\n\n// 正常的图表 spec 配置\nconst spec = {\n  type: 'radar',\n  data: [\n    {\n      id: 'Map',\n      values: [\n        { key: 'North', value: 31, category: 'Destroyer' },\n        { key: 'Northeast', value: 32, category: 'Destroyer' },\n        { key: 'East', value: 21, category: 'Destroyer' },\n        { key: 'Southeast', value: 15, category: 'Destroyer' },\n        { key: 'South', value: 50, category: 'Destroyer' },\n        { key: 'Southwest', value: 44, category: 'Destroyer' },\n        { key: 'West', value: 32, category: 'Destroyer' },\n        { key: 'Northwest', value: 32, category: 'Destroyer' },\n        { key: 'North', value: 31, category: 'Destroyer' },\n        { key: 'Northeast', value: 32, category: 'Destroyer' },\n        { key: 'East', value: 21, category: 'Destroyer' },\n        { key: 'Southeast', value: 40, category: 'aircraft carrier' },\n        { key: 'South', value: 25, category: 'aircraft carrier' },\n        { key: 'Southwest', value: 22, category: 'aircraft carrier' },\n        { key: 'West', value: 18, category: 'aircraft carrier' },\n        { key: 'Northwest', value: 7, category: 'aircraft carrier' },\n        { key: 'North', value: 24, category: 'aircraft carrier' },\n        { key: 'Northeast', value: 43, category: 'aircraft carrier' },\n        { key: 'East', value: 42, category: 'aircraft carrier' }\n      ]\n    }\n  ],\n  categoryField: 'key',\n  valueField: 'value',\n  seriesField: 'category',\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\nconst cs = new VChart.default(spec, {\n  // 声明使用的渲染环境以及传染对应的渲染环境参数\n  mode: 'node',\n  modeParams: Canvas,\n  animation: false // 关闭动画\n});\n\ncs.renderSync();\n\n// 导出图片\nconst buffer = cs.getImageBuffer();\nfs.writeFileSync(`./chart.png`, buffer);</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/C1rFbrJnboheEyxQYf6cBYywnkh.gif' alt='' width='500' height='500'>\r\n\r\nDemo: https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/node</br>\r\n## 相关文档\r\n\r\nDemo：https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/node</br>\r\n教程：</br>\r\n*  初始化VChart： https://visactor.io/vchart/api/API/vchart</br>\r\n*  Node服务端渲染教程：https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/node</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '32- How to configure the points in a line chart to be sparser in vchart.md',
    content:
      "---\ntitle: 42. vchart如何配置折线图的点稀疏一点</br>\n---\r\n# 问题标题\r\n\r\nvchart折线图在大数据的情况下点太密集了，如何配置折线图的点稀疏一点</br>\r\n# 问题描述\r\n\r\n在使用vchart的时候，我碰到了一个问题。我正在制作一个折线图，但是数据有很多，导致折线图的点非常密集，我想问一下能够通过采样等形式让点稀疏一点吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/B43zbvhr4o2E2rxxha5cYJUpn3d.gif' alt='' width='1334' height='1058'>\r\n\r\n# 解决方案\r\n\r\n## 方案1\r\n\r\n采样可以实现这个功能。可以通过配置sampling和samplingFactor来实现，通过sampling配置，可以使用不同的采样算法对点进行采样，支持的采样类型有：</br>\r\n*  `'lttb'`: 采用 Largest-Triangle-Three-Bucket 算法，可以最大程度保证采样后线条的趋势，形状和极值。</br>\r\n*  `'min'`: 取过滤点的最小值</br>\r\n*  `'max'`: 取过滤点的最大值</br>\r\n*  `'sum'`: 取过滤点的和</br>\r\n*  `'average'`: 取过滤点的平均值</br>\r\n通过samplingFactor可以配置采样的强度，在[0,1]范围内，samplingFactor越小采样强度越大</br>\r\n可以参考：https://visactor.io/vchart/option/lineChart#sampling</br>\r\n## 方案2\r\n\r\n可以通过markOverlap: true,来仅对点进行隐藏</br>\r\n可以参考：https://visactor.io/vchart/option/lineChart#markOverlap</br>\r\n# 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: new Array(10000).fill(0).map((_, i) => ({ time: i, value: Math.random() * 10000 }))\n  },\n  sampling: 'lttb',\n  samplingFactor: 0.6,\n  point: {\n    style: {\n      stroke: false\n    }\n  },\n  xField: 'time',\n  yField: 'value'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n# 结果展示\r\n\r\n代码运行后，数据点被采样的更加稀疏。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HYy9bINFGoKyZ8xXgiict9zHnDf.gif' alt='' width='1330' height='1048'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/line-chart-single-selected-forked-4px87p?file=%2Fsrc%2Findex.ts%3A18%2C2</br>\r\n# 相关文档\r\n\r\n*  VChart 线段的采样配置：https://visactor.io/vchart/option/lineChart#sampling</br>\r\n*  VChart 点的防重叠配置：https://visactor.io/vchart/option/lineChart#markOverlap</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '33-How to customize the tooltip display content in a dual axis chart.md',
    content:
      "# 双轴图中如何自定义 Tooltip 显示内容？\n\n## 问题描述\n\n我正在使用 VChart，如下图所示，我应该如何在 dimension tooltip 中隐藏柱状图系列的信息，只显示折线图系列的信息？\n\n![tooltip](/vchart/faq/72-0.png)\n\n## 解决方案\n\nVChart 的 tooltip 不仅可以在图表层级配置，在系列层级上也可以。在柱状图对应系列的 spec 中将 dimension tooltip 关掉即可。如以下 demo：\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '周一', type: '早餐', y: 15 },\n        { x: '周一', type: '午餐', y: 25 },\n        { x: '周二', type: '早餐', y: 12 },\n        { x: '周二', type: '午餐', y: 30 },\n        { x: '周三', type: '早餐', y: 15 },\n        { x: '周三', type: '午餐', y: 24 },\n        { x: '周四', type: '早餐', y: 10 },\n        { x: '周四', type: '午餐', y: 25 },\n        { x: '周五', type: '早餐', y: 13 },\n        { x: '周五', type: '午餐', y: 20 },\n        { x: '周六', type: '早餐', y: 10 },\n        { x: '周六', type: '午餐', y: 22 },\n        { x: '周日', type: '早餐', y: 12 },\n        { x: '周日', type: '午餐', y: 19 }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '周一', type: '饮料', y: 22 },\n        { x: '周二', type: '饮料', y: 43 },\n        { x: '周三', type: '饮料', y: 33 },\n        { x: '周四', type: '饮料', y: 22 },\n        { x: '周五', type: '饮料', y: 10 },\n        { x: '周六', type: '饮料', y: 30 },\n        { x: '周日', type: '饮料', y: 50 }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      dataIndex: 0,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: ['x', 'type'],\n      yField: 'y',\n      tooltip: {\n        dimension: {\n          visible: false\n        }\n      }\n    },\n    {\n      type: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: 0 },\n    { orient: 'right', seriesIndex: 1 },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/72-1.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\noption docs: [https://www.visactor.io/vchart/option/barChart#tooltip.dimension.visible](https://www.visactor.io/vchart/option/barChart#tooltip.dimension.visible)\n"
  },
  {
    fileName: '34- How to left-align bar chart labels and keep the style consistent.md',
    content:
      "---\ntitle: 11. 如何实现条形图标签左对齐，标签的样式保持一致</br>\n---\r\n## 问题标题\r\n\r\n如何实现条形图标签左对齐，标签的样式保持一致？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如图，条形图中的标签可以实现左对齐样式吗？另外为什么标签的样式不是完全一样的</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Xi3wb8JMPoAVqKxgA6FcJnGtnxe.gif' alt='' width='656' height='1088'>\r\n\r\n## 解决方案 \r\n\r\n*  标签的位置可以通过`label.position`进行配置，条形图默认标签在图形外侧，所以没有左对齐，通过设置`label.position`为`inside-left`就可以实现左对齐效果了</br>\r\n*  当条形图标签位置为`inside-left`的时候，会开启**智能反色** ，可能会带来样式不一致的问题，可以手动关闭智能翻色</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TDcWbVB3YoIpzaxKmAzceEnknHc.gif' alt='' width='2686' height='1262'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          name: 'Apple',\n          value: 214480\n        },\n        {\n          name: 'Google',\n          value: 155506\n        },\n        {\n          name: 'Amazon',\n          value: 100764\n        },\n        {\n          name: 'Microsoft',\n          value: 92715\n        },\n        {\n          name: 'Coca-Cola',\n          value: 66341\n        },\n        {\n          name: 'Samsung',\n          value: 59890\n        },\n        {\n          name: 'Toyota',\n          value: 53404\n        },\n        {\n          name: 'Mercedes-Benz',\n          value: 48601\n        },\n        {\n          name: 'Facebook',\n          value: 45168\n        },\n        {\n          name: \"McDonald's\",\n          value: 43417\n        },\n        {\n          name: 'Intel',\n          value: 43293\n        },\n        {\n          name: 'IBM',\n          value: 42972\n        },\n        {\n          name: 'BMW',\n          value: 41006\n        },\n        {\n          name: 'Disney',\n          value: 39874\n        },\n        {\n          name: 'Cisco',\n          value: 34575\n        },\n        {\n          name: 'GE',\n          value: 32757\n        },\n        {\n          name: 'Nike',\n          value: 30120\n        },\n        {\n          name: 'Louis Vuitton',\n          value: 28152\n        },\n        {\n          name: 'Oracle',\n          value: 26133\n        },\n        {\n          name: 'Honda',\n          value: 23682\n        }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  xField: 'value',\n  yField: 'name',\n  axes: [\n    {\n      orient: 'bottom',\n      visible: false\n    }\n  ],\n  label: {\n    visible: true,\n    position: 'inside-left',\n    smartInvert: false,\n  }\n};</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/M3yWbPRy9oqHANxbgc6cAckUnLe.gif' alt='' width='532' height='1056'>\r\n\r\n## 相关文档\r\n\r\n智能反色配置：https://visactor.com/vchart/option/barChart#label.smartInvert</br>\r\n标签配置： https://visactor.com/vchart/option/barChart#label.position</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '35- How to disable chart interaction.md',
    content:
      "---\ntitle: 23. 如何禁用图表交互</br>\n---\r\n## 问题标题\r\n\r\n如何禁用图表交互</br>\r\n## 问题描述\r\n\r\n请问使用图表的时候怎么关闭图表的交互事件呢，只希望图表作为图片一样使用？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TYbobJL2aoyR9Mx85PZcEgu1nBd.gif' alt='' width='1712' height='1322'>\r\n\r\n## 解决方案 \r\n\r\nVChart 中可以支持在initOption中直接传入`disableTriggerEvent: true`关闭交互</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, disableTriggerEvent: true });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/SaC3bkrERo02lgx5BaVcGTqdnuO.gif' alt='' width='2434' height='1148'>\r\n\r\nDemo: https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-psxswy?file=%2Fsrc%2Findex.js%3A20%2C46 </br>\r\n## 相关文档\r\n\r\nDemo：https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-psxswy?file=%2Fsrc%2Findex.js%3A20%2C46</br>\r\n教程：</br>\r\n*  初始化VChart： https://visactor.io/vchart/api/API/vchart</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '36-How to configure a DataZoom component in a chart that can be used on a mobile device.md',
    content:
      '# 如何在图表中配置一个能够在移动端响应的 DataZoom 组件？\n\n## 问题描述\n\n类似 [这样](https://www.visactor.io/vchart/demo/line-chart/basic-line)的简单线图，\n\n![line chart](/vchart/faq/25-0.png)\n\n怎么配置 DataZoom 组件？DataZoom 组件可以在移动端设备进行交互吗？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中只需要配置 **dataZoom** ，就会展示组件；为了移动端的交互更加友好，可以开启`roam: true`的配置。\n\n![line chart](/vchart/faq/25-1.png)\n\n## 代码示例\n\n```\nconst spec = {\n  type: "line",\n  data: {\n    values: [\n      {\n        time: "2:00",\n        value: 8\n      },\n      {\n        time: "4:00",\n        value: 9\n      },\n      {\n        time: "6:00",\n        value: 11\n      },\n      {\n        time: "8:00",\n        value: 14\n      },\n      {\n        time: "10:00",\n        value: 16\n      },\n      {\n        time: "12:00",\n        value: 17\n      },\n      {\n        time: "14:00",\n        value: 17\n      },\n      {\n        time: "16:00",\n        value: 16\n      },\n      {\n        time: "18:00",\n        value: 15\n      }\n    ]\n  },\n  xField: "time",\n  yField: "value",\n  dataZoom: [\n    {\n      orient: "bottom",\n      filterMode: "filter",\n      roam: true\n    }\n  ]\n};\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/line-chart-datazoom-wzk8n7)\n\n```javascript livedemo\nconst spec = {\n  type: \'line\',\n  data: {\n    values: [\n      {\n        time: \'2:00\',\n        value: 8\n      },\n      {\n        time: \'4:00\',\n        value: 9\n      },\n      {\n        time: \'6:00\',\n        value: 11\n      },\n      {\n        time: \'8:00\',\n        value: 14\n      },\n      {\n        time: \'10:00\',\n        value: 16\n      },\n      {\n        time: \'12:00\',\n        value: 17\n      },\n      {\n        time: \'14:00\',\n        value: 17\n      },\n      {\n        time: \'16:00\',\n        value: 16\n      },\n      {\n        time: \'18:00\',\n        value: 15\n      }\n    ]\n  },\n  xField: \'time\',\n  yField: \'value\',\n  dataZoom: [\n    {\n      orient: \'bottom\',\n      filterMode: \'filter\',\n      roam: true\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n```\n\n## 相关文档\n\n- [DataZoom demo](https://www.visactor.io/vchart/demo/data-zoom/preview-data?keyword=dataZoom)\n- [DataZoom 教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/DataZoom)\n- [相关配置](https://www.visactor.io/vchart/option/lineChart#dataZoom.valueField)\n- [github](https://github.com/VisActor/VChart)\n'
  },
  {
    fileName: '37-When the data is all 0, how to configure the position of the x-axis.md',
    content:
      "# 数据全 0 时，如何配置 x 轴的位置？\n\n## 问题描述\n\n类似 （https://www.visactor.io/vchart/demo/line-chart/basic-line）这样的数据全为0的折线图，\nx 轴的位置会使折线居中。想要调整 X 轴的位置，使 X 轴与 Y 刻度为 0 对齐，该如何实现？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，只需要将 Y 轴的 axes-linear.zero 设置为 true 即可。\n\n- barChart-axes-linear.zero = true 仅当轴为线性轴时生效，是否包含 0 值。当配置了 min 和 max，该配置项失效。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 0\n      },\n      {\n        time: '4:00',\n        value: 0\n      },\n      {\n        time: '6:00',\n        value: 0\n      },\n      {\n        time: '8:00',\n        value: 0\n      },\n      {\n        time: '10:00',\n        value: 0\n      },\n      {\n        time: '12:00',\n        value: 0\n      },\n      {\n        time: '14:00',\n        value: 0\n      },\n      {\n        time: '16:00',\n        value: 0\n      },\n      {\n        time: '18:00',\n        value: 0\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  axes: [\n    {\n      orient: 'left',\n      zero: true\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/data-is-all-0-smhq6h)\n\n## 相关文档\n\n- [基础折线图 demo](https://www.visactor.io/vchart/demo/line-chart/basic-line)\n- [坐标轴教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes)\n- [相关 api](https://www.visactor.io/vchart/option/lineChart-axes-linear#zero)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '38-How does the label at the center of the ring chart adapt to the size of the ring.md',
    content:
      "# 环形图 label 如何自适应环的大小？\n\n## 问题描述\n\nVChart 如何配置环形图中心 label 的自适应大小？如下图所示，我想让文字保持在环形内：\n\n![description](/vchart/faq/69-0.png)\n\n## 解决方案\n\n可以参照以下 demo，在指标卡中配置 `autoFit: true`。\n\n## 代码示例\n\n```javascript livedemo\nconst data = [\n  { type: 'oxygen', value: '46.60', formula: 'O', texture: 'circle' },\n  { type: 'silicon', value: '27.72', formula: 'Si', texture: 'horizontal-line' },\n  { type: 'aluminum', value: '8.13', formula: 'Al', texture: 'vertical-line' },\n  { type: 'iron', value: '5', formula: 'Fe', texture: 'rect' },\n  { type: 'calcium', value: '3.63', formula: 'Ca', texture: 'grid' },\n  { type: 'sodium', value: '2.83', formula: 'Na', texture: 'bias-rl' },\n  { type: 'potassium', value: '2.59', formula: 'K', texture: 'diamond' },\n  { type: 'others', value: '3.5', formula: 'Others', texture: 'bias-lr' }\n];\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: data\n    }\n  ],\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  pie: {\n    style: {\n      cornerRadius: 10,\n      texture: datum => datum['texture']\n    },\n    state: {\n      hover: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      },\n      selected: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  indicator: {\n    visible: true,\n    trigger: 'hover',\n    limitRatio: 0.4,\n    title: {\n      visible: true,\n      autoFit: true,\n      style: {\n        fontWeight: 'bolder',\n        fontFamily: 'Times New Roman',\n        fill: '#888',\n        text: datum => {\n          const d = datum ?? data[0];\n          return d['formula'];\n        }\n      }\n    },\n    content: [\n      {\n        visible: true,\n        style: {\n          fontSize: 20,\n          fill: 'orange',\n          fontWeight: 'bolder',\n          fontFamily: 'Times New Roman',\n          text: datum => {\n            const d = datum ?? data[0];\n            return d['type'];\n          }\n        }\n      },\n      {\n        visible: true,\n        style: {\n          fontSize: 18,\n          fill: 'orange',\n          fontFamily: 'Times New Roman',\n          text: datum => {\n            const d = datum ?? data[0];\n            return d['value'] + '%';\n          }\n        }\n      }\n    ]\n  },\n  legends: {\n    visible: true,\n    orient: 'left',\n    item: {\n      shape: {\n        style: {\n          symbolType: 'circle',\n          texture: datum => datum['texture']\n        }\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/69-1.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nDemo page: [https://www.visactor.io/vchart/demo/pie-chart/pie-indicator](https://www.visactor.io/vchart/demo/pie-chart/pie-indicator)\n"
  },
  {
    fileName: '39-How to customize the length of the pie chart guide line.md',
    content:
      "# 如何自定义饼图引导线的长度？\n\n## 问题描述\n\n一般的饼图展示标签的时候都会额外绘制一个引导线用来连接扇区和对应的标签（类似 https://echarts.apache.org/examples/zh/editor.html?c=pie-simple），但是几个图表库常见的引导线逻辑都没有提供配置。如果我需要自定义这个引导线的长度应该怎么做呢？\n\n![pie](/vchart/faq/80-0.png)\n\n## 解决方案\n\nVChart 内置提供了饼图标签的布局算法，并且允许开发者自定义布局计算中的一些关键配置项。开发者可以通过饼图标签的 `label.line.line1MinLength` 以及 `label.line.line2MinLength` 配置项设置两段引导线的最小长度。\n\nVChart 饼图标签布局算法可以参考这篇文章：https://zhuanlan.zhihu.com/p/179166155\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  label: {\n    visible: true,\n    line: {\n      line1MinLength: 30,\n      line2MinLength: 10\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [Pie label spec](https://visactor.io/vchart/option/pieChart#label.line.line1MinLength)\n"
  },
  {
    fileName: '41- Does the line chart support setting background colors based on Y-axis segments.md',
    content:
      "---\ntitle: 92.折线图支持按照y轴分段设置背景颜色吗</br>\n---\r\n## 问题标题\r\n\r\n折线图支持按照y轴分段设置背景颜色吗</br>\r\n## 问题描述\r\n\r\n下面的线图中， 支持按照y轴分段设置背景颜色吗</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/MD6lbNVHZoD4sNxBpPPcDcvGn9f.gif' alt='' width='1496' height='1040'>\r\n\r\n## 解决方案\r\n\r\n有两种方案可以实现这里的背景色需求</br>\r\n*  方案一：可以通过配置`axes.grid.alternateColor`来设置网格填充颜色：</br>\r\n```\naxes: [\n    {\n      orient: 'left',\n      grid: {\n        alternateColor: [\n          'rgba(0, 255, 0, 0.3)', \n          'rgba(255, 0, 0, 0.2)',\n          'rgba(0, 0, 255, 0.2)'\n          ]\n      }\n    }\n  ]</br>\n```\r\n方案二： VChart支持多种标注组件，其中`markArea`可以用于配置标注区块，所以我们可以通过下面的方式配置背景色块</br>\r\n```\nmarkArea: [\n    {\n      y: 0,\n      y1: 5,\n      area: {\n        style: {\n          fill: 'red',\n          fillOpacity: 0.2\n        }\n      }\n    },\n\n    {\n      y: 5,\n      y1: 10,\n      area: {\n        style: {\n          fill: 'yellow',\n          fillOpacity: 0.2\n        }\n      }\n    },\n\n    {\n      y: 10,\n      y1: 15,\n      area: {\n        style: {\n          fill: 'pink',\n          fillOpacity: 0.2\n        }\n      }\n    },\n\n    {\n      y: 15,\n      y1: 20,\n      area: {\n        style: {\n          fill: 'green',\n          fillOpacity: 0.2\n        }\n      }\n    },\n   ]</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  markArea: [\n    {\n      y: 0,\n      y1: 5,\n      area: {\n        style: {\n          fill: 'red',\n          fillOpacity: 0.2\n        }\n      }\n    },\n\n    {\n      y: 5,\n      y1: 10,\n      area: {\n        style: {\n          fill: 'yellow',\n          fillOpacity: 0.2\n        }\n      }\n    },\n\n    {\n      y: 10,\n      y1: 15,\n      area: {\n        style: {\n          fill: 'pink',\n          fillOpacity: 0.2\n        }\n      }\n    },\n\n    {\n      y: 15,\n      y1: 20,\n      area: {\n        style: {\n          fill: 'green',\n          fillOpacity: 0.2\n        }\n      }\n    },\n   ]\n};</br>\n```\r\n## 结果展示\r\n\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/O5RjbhBCUoY8c5xH8oTcj7BGnVg.gif' alt='' width='1474' height='1070'>\r\n\r\n## 相关文档\r\n\r\n*  [github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n*  [Marker数据标注教程](https%3A%2F%2Fvisactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2Fmarker)</br>\r\n*  [MarkArea配置文档](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FlineChart%23markArea)</br>"
  },
  {
    fileName:
      '42-How can VChart set the number of display bars for Tooltip, and support effects such as scrolling, pagination, and merged display when there is too much data.md',
    content:
      '# VChart 如何设置 Tooltip 的展示条数，数据过多时支持滚动、分页、合并展示等效果？\n\n# 问题描述\n\n类似 （https://visactor.io/vchart/demo/tooltip/format-method?keyword=tooltip）这样的图表，希望tooltip能多行显示\n![demo](/vchart/faq/98-0.png)\n\n# 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中可以直接修改 HTML tooltip 的样式来实现\n![demo](/vchart/faq/98-1.png)\n\n# 代码示例\n\n```ts\n{\n  type: "area",\n  data: {\n    values: [\n      { type: "Nail polish", country: "Africa", value: 4229 },\n      { type: "Nail polish", country: "EU", value: 4376 },\n      { type: "Nail polish", country: "China", value: 3054 },\n      { type: "Nail polish", country: "USA", value: 12814 },\n      { type: "Eyebrow pencil", country: "Africa", value: 3932 },\n      { type: "Eyebrow pencil", country: "EU", value: 3987 },\n      { type: "Eyebrow pencil", country: "China", value: 5067 },\n      { type: "Eyebrow pencil", country: "USA", value: 13012 },\n      { type: "Rouge", country: "Africa", value: 5221 },\n      { type: "Rouge", country: "EU", value: 3574 },\n      { type: "Rouge", country: "China", value: 7004 },\n      { type: "Rouge", country: "USA", value: 11624 },\n      { type: "Lipstick", country: "Africa", value: 9256 },\n      { type: "Lipstick", country: "EU", value: 4376 },\n      { type: "Lipstick", country: "China", value: 9054 },\n      { type: "Lipstick", country: "USA", value: 8814 },\n      { type: "Eyeshadows", country: "Africa", value: 3308 },\n      { type: "Eyeshadows", country: "EU", value: 4572 },\n      { type: "Eyeshadows", country: "China", value: 12043 },\n      { type: "Eyeshadows", country: "USA", value: 12998 },\n      { type: "Eyeliner", country: "Africa", value: 5432 },\n      { type: "Eyeliner", country: "EU", value: 3417 },\n      { type: "Eyeliner", country: "China", value: 15067 },\n      { type: "Eyeliner", country: "USA", value: 12321 },\n      { type: "Foundation", country: "Africa", value: 13701 },\n      { type: "Foundation", country: "EU", value: 5231 },\n      { type: "Foundation", country: "China", value: 10119 },\n      { type: "Foundation", country: "USA", value: 10342 },\n      { type: "Lip gloss", country: "Africa", value: 4008 },\n      { type: "Lip gloss", country: "EU", value: 4572 },\n      { type: "Lip gloss", country: "China", value: 12043 },\n      { type: "Lip gloss", country: "USA", value: 22998 },\n      { type: "Mascara", country: "Africa", value: 18712 },\n      { type: "Mascara", country: "EU", value: 6134 },\n      { type: "Mascara", country: "China", value: 10419 },\n      { type: "Mascara", country: "USA", value: 11261 }\n    ]\n  },\n  tooltip: {\n    className: "tooltip"\n  },\n  title: {\n    visible: true,\n    text: "100% stacked area chart of cosmetic products sales"\n  },\n  percent: true,\n  xField: "type",\n  yField: "value",\n  seriesField: "country",\n  legends: [{ visible: true, position: "middle", orient: "bottom" }],\n  axes: [\n    {\n      orient: "left",\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ]\n}\n```\n\n# 结果展示\n\n在线效果参考：https://codesandbox.io/s/tooltip-multirow-n3y7d3\n![result](/vchart/faq/98-2.png)\n\n# 相关文档\n\nTooltip 教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip\n相关 api：https://visactor.io/vchart/option/barChart#tooltip.visible\ngithub：https://github.com/VisActor/VChart\n'
  },
  {
    fileName: '43- Does the thumbnail axis handle shape support SVG.md',
    content:
      "---\ntitle: 20. 缩略轴手柄图元形状是否支持svg？</br>\n---\r\n## 问题标题\r\n\r\n图表内的图元形状是否支持自定义svg？</br>\r\n## 问题描述\r\n\r\n请问 datazoom 中如何自定义开始、结束的图标？尝试了一下dataZoom.startHandler.style.symbolType 中的可配置项，没有找到需要的</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/SRaXbGQmLo7knsxFw5pceZAHnRg.gif' alt='' width='996' height='180'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n在图元样式中配置symbolType即可，symbol 的形状类型，支持传入内置的类型，也可以设置为自定义的路径字符串 和 svg图片，并且在VChart中任意symbol类型的图元都可做相同的配置。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/CdbdbRScXoUPmjx62fDcC7oSnye.gif' alt='' width='3254' height='1498'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  color: [\n    '#3855df',\n    '#ffc52b',\n    '#5ecf78',\n    '#fb7a00',\n    '#0acffd',\n    '#217dfd',\n    '#98dd61',\n    '#3150e0',\n    '#714efd',\n    '#0bcfff',\n    '#3d0dde',\n    '#ffc527',\n    '#f5c13f',\n    '#fb7a08',\n    '#95d8fd'\n  ],\n  type: 'rangeColumn',\n  direction: 'horizontal',\n  yField: 'type',\n  minField: 'start_time',\n  maxField: 'end_time',\n  seriesField: 'color',\n  dataZoom: [\n    {\n      orient: 'bottom',\n      height: 20,\n      start: 0.1,\n      endValue: 1681956000,\n      filterMode: 'axis',\n      brushSelect: false,\n      startText: {\n        formatMethod: text => Math.floor(text)\n      },\n      endText: {\n        formatMethod: text => Math.floor(text)\n      },\n      startHandler: {\n        style: {\n          dy: -12,\n          dx: -8,\n          symbolType: '<svg t=\"1714125379383\" class=\"icon\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"20427\" width=\"200\" height=\"200\"><path d=\"M827.505255 195.268312C652.829957 20.593014 369.558335 20.593014 194.883037 195.269335 20.202623 369.94975 20.201599 653.220349 194.876897 827.895647c174.681438 174.681438 457.952037 174.679391 632.632451 0C1002.18567 653.220349 1002.18567 369.94975 827.505255 195.268312zM352.449679 703.530175l-63.700811 0L288.748868 319.832306l63.700811 0L352.449679 703.530175zM543.467177 703.530175l-63.700811 0L479.766366 319.832306l63.700811 0L543.467177 703.530175zM735.848743 703.530175l-63.700811 0L672.147932 319.832306l63.700811 0L735.848743 703.530175z\" fill=\"#272636\" p-id=\"20428\"></path></svg>'\n        }\n      }\n    }\n  ],\n  axes: [\n    { orient: 'left', type: 'band', bandPadding: 0.5, visible: false },\n    {\n      type: 'time',\n      orient: 'bottom',\n      layers: [\n        {\n          tickStep: 28800,\n          timeFormat: '%Y%m%d %H:%M'\n        }\n      ]\n    }\n  ],\n  title: {\n    textStyle: {\n      character: [\n        {\n          text: 'Time-Consuming Distribution',\n          fontWeight: 400,\n          fill: '#222'\n        },\n        {\n          text: 'Show the SQL distribution of TOP 100',\n          fontWeight: 200,\n          fontSize: 10,\n          fill: '#555'\n        }\n      ]\n    }\n  },\n  tooltip: {\n    visible: true,\n    dimension: {\n      visible: false\n    },\n    mark: {\n      title: {\n        key: 'Query ID',\n        value: datum => 'Query ID: ' + datum['id']\n      },\n      content: [\n        {\n          key: 'Time Consuming',\n          value: datum => datum['useTime']\n        },\n        {\n          key: 'start time',\n          value: datum => datum['start_time']\n        },\n        {\n          key: 'end time',\n          value: datum => datum['end_time']\n        }\n      ]\n    }\n  },\n  data: [\n    {\n      id: 'data0',\n      values: [\n        {\n          start_time: 1681926000,\n          end_time: 1681927200,\n          type: 'TOP 1',\n          color: 'A',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681926000,\n          end_time: 1681959600,\n          type: 'TOP 2',\n          color: 'B',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681925400,\n          end_time: 1681974000,\n          type: 'TOP 3',\n          color: 'C',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681924800,\n          end_time: 1681933200,\n          type: 'TOP 4',\n          color: 'D',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681959600,\n          end_time: 1681963200,\n          type: 'TOP 5',\n          color: 'E',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681970400,\n          end_time: 1681971000,\n          type: 'TOP 5',\n          color: 'F',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681992000,\n          end_time: 1681992600,\n          type: 'TOP 5',\n          color: 'G',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681956000,\n          end_time: 1681963200,\n          type: 'TOP 6',\n          color: 'H',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681990200,\n          end_time: 1681993800,\n          type: 'TOP 7',\n          color: 'I',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681948800,\n          end_time: 1681959600,\n          type: 'TOP 8',\n          color: 'J',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681945200,\n          end_time: 1681956000,\n          type: 'TOP 9',\n          color: 'K',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        }\n      ].reverse()\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, animation: false });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/svg-symbol-8k9tdz?file=%2Fsrc%2Findex.ts%3A208%2C29</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/YXl7bjA3WoeG7PxP0sic12gInYg.gif' alt='' width='1492' height='1062'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n缩略轴demo: https://visactor.bytedance.net/vchart/demo/data-zoom/state-with-data</br>\r\n相关api：https://visactor.io/vchart/option/lineChart#dataZoom.startHandler.style.symbolType</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '44-How to customize the image and color of a legend.md',
    content:
      "# 如何自定义图表中的图例的图像和颜色？\n\n## 问题描述\n\n类似[这样的饼图](https://www.visactor.io/vchart/demo/pie-chart/basic-pie)，图例的图像、颜色、内容可以自定义？如何自定义配置？\n\n![pie chart](/vchart/faq/27-0.png)\n\n## 解决方案\n\n图例是图表中常用的组件，很多类型的图表都支持图例的展示和配置，在 VChart 中：\n\n- 通过配置`legend.item`来对所有的图例项设置统一的样式\n- 通过配置`legend.data`回调函数来对每个图例项设置不同的内容以及样式\n\n## 代码示例\n\n- 通过配置`legend.item`来对所有的图例项设置统一的样式\n\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left',\n    item: {\n      width: '15%',\n      shape: {\n        style: {\n          background: 'https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/log.jpeg',\n          symbolType: 'rect',\n          fill: false\n        }\n      },\n      label: {\n        style: {fontSize: 14, fontWeight: 'bold' }\n      },\n      value: {\n        alignRight: true,\n        style: {\n          fill: '#333',\n          fillOpacity: 0.8,\n          fontSize: 10\n        },\n        state: {\n          unselected: {\n            fill: '#d8d8d8'\n          }\n        }\n      }\n    }\n  },\n  label: {\n    visible: true\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n```\n\n![pie chart](/vchart/faq/27-1.png)\n\n- 通过配置`legend.data`回调函数来对每个图例项设置不同的内容\n\n```\nconst values = [\n  { type: 'oxygen', value: '46.60' },\n  { type: 'silicon', value: '27.72' },\n  { type: 'aluminum', value: '8.13' },\n  { type: 'iron', value: '5' },\n  { type: 'calcium', value: '3.63' },\n  { type: 'sodium', value: '2.83' },\n  { type: 'potassium', value: '2.59' },\n  { type: 'others', value: '3.5' }\n];\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values,\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left',\n    data: (items, scale,c, d) => {\n      console.log(items, scale, c, d);\n      return items.map(item => {\n        item.value = values.find(entry => entry.type === item.label).value;\n        item.shape.symbolType = 'rect';\n        item.shape.background = 'https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/log.jpeg';\n        item.shape.fill = false;\n        return item;\n      });\n    },\n    item: {\n      width: '15%',\n      label: {\n        style: {\n          fontSize: 14,\n          fontWeight: 'bold'\n        }\n      },\n      value: {\n        alignRight: true,\n        style: {\n          fill: '#333',\n          fillOpacity: 0.8,\n          fontSize: 10\n        },\n        state: {\n          unselected: {\n            fill: '#d8d8d8'\n          }\n        }\n      }\n    }\n  },\n  label: {\n    visible: true\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n```\n\n## 结果展示\n\n[在线效果参考](https://codesandbox.io/s/pie-chart-legend-2kzv8w)\n\n```javascript livedemo\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  scales: [\n    {\n      id: 'labelScale',\n      type: 'linear',\n      domain: [\n        {\n          dataId: 'id0',\n          fields: ['value']\n        }\n      ],\n      range: ['red', 'green']\n    }\n  ],\n  label: {\n    visible: true,\n    formatMethod: (text, datum) => {\n      return `${datum.type}: ${datum.value}`;\n    },\n    style: {\n      fill: {\n        scale: 'labelScale',\n        field: 'value'\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n```\n\n## 相关文档\n\n- [Legend 配置](https://www.visactor.io/vchart/option/pieChart-legends-discrete#type)\n- [图例教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName:
      '45-How to control the display order of stacking and legends and add display of total information on the tooltip.md',
    content:
      "# 如何控制堆叠以及图例的显示顺序，同时在 tooltip 上添加总计信息的展示？\n\n## 问题描述\n\n![](/vchart/faq/85-0.png)\n\n对于堆叠面积图，我想要控制堆叠的顺序，比如期望面积图从下到上，按照 \"China\", \"USA\", \"EU\", \"Africa\" 的顺序堆叠，然后图例的显示顺序也按照 \"China\", \"USA\", \"EU\", \"Africa\" 的顺序从左到右显示，同时 hover 上去的时候，tooltip 能够展示总计的信息，如下图所示：\n\n![](/vchart/faq/85-1.png)\n\n## 解决方案\n\n这个在 [VChart](https://www.visactor.io/vchart/) 上可以非常简单得配置出来，只需要两步：\n\n1.  通过在 `data.fields` 属性上为分组字段配置 `domain` 和 `sortIndex`来控制堆叠的顺序\n    - `domain` 来声明顺序\n    - `sortIndex` 声明为 0 表示按照 `domain` 顺序进行排序\n\n![](/vchart/faq/85-2.png)\n\n因为图例的顺序默认是按照字段 domain 声明的顺序展示的，所以图例这里不需要进行配置。\n\n2.  通过为 `tooltip.dimension` 配置 `updateContent` 可以动态得为 tooltip 的内容添加需要的信息，而且也可以拿到当前 tooltip 展示的所有信息\n\n![](/vchart/faq/85-3.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'area',\n  data: {\n    fields: {\n      country: {\n        domain: ['China', 'USA', 'EU', 'Africa'],\n        sortIndex: 0\n      }\n    },\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: 'Stacked area chart of cosmetic products sales'\n  },\n  stack: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  tooltip: {\n    dimension: {\n      updateContent: data => {\n        let sum = 0;\n        data.forEach(datum => {\n          sum += +datum.value;\n        });\n        data.push({\n          hasShape: 'false',\n          key: 'Total',\n          value: sum\n        });\n        return data;\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\n\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n在线效果参考：[https://codepen.io/Sima/pen/WNLxdyg](https://codepen.io/Sima/pen/WNLxdyg)\n\n## 相关文档\n\n堆积面积图 demo：[https://www.visactor.io/vchart/demo/area-chart/stacked-area](https://www.visactor.io/vchart/demo/area-chart/stacked-area)\n\n面积图教程： [https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Area](https://www.visactor.io/vchart/demo/area-chart/stacked-area)\n\n数据配置教程：[https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Data/Data_Types_and_Interface](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Data/Data_Types_and_Interface)\n\nTooltip 配置教程：[https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip)\n\n数据字段配置：[https://www.visactor.io/vchart/option/areaChart#data(IDataType%7CIDataType%5B%5D).IDataValues.fields](<https://www.visactor.io/vchart/option/areaChart#data(IDataType%7CIDataType%5B%5D).IDataValues.fields>)\n\nTooltip 配置项：[https://www.visactor.io/vchart/option/areaChart#tooltip.visible](https://www.visactor.io/vchart/option/areaChart#tooltip.visible)\n\ngithub：[https://github.com/VisActor/VChart](https://www.visactor.io/vchart/option/areaChart#tooltip.visible)\n"
  },
  {
    fileName: '46- How to display all words in a word cloud on a small canvas.md',
    content:
      "---\ntitle: 70.词云如何在小画布上显示所有词</br>\n---\r\n# 问题标题\r\n\r\n词云如何在小画布上显示所有词</br>\r\n# 问题描述\r\n\r\nvchart词云在词的数量很多，而画布大小不够大的情况下，只能显示一部分词。如何让所有词都能显示出来呢？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Xhahbic4kolWO7xxGyJck5CZn6e.gif' alt='' width='1108' height='968'>\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/W3QGbVr7eoEYhkxJ9MOcskranUe.gif' alt='' width='578' height='566'>\r\n\r\n# 解决方案\r\n\r\n词云有一个配置`fontSizeRange`可以控制词的大小范围，默认值为`[20,40]`，如果希望文字自动适应画布大小并占满整个画布的话，可以将其配置为`auto`</br>\r\n可以参考：https://visactor.io/vchart/option/wordCloudChart#fontWeightRange</br>\r\n# 代码示例  \r\n\r\n```\nconst spec = {\n  width: 300,\n  height: 300,\n  type: 'wordCloud',\n  nameField: 'name',\n  valueField: 'value',\n  maskShape: 'https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/shape_motuo_mini.png',\n  fontSizeRange: 'auto',\n  data: [\n    {\n      name: 'source',\n      values: [\n        {\n          name: '螺蛳粉',\n          value: 957\n        },\n        {\n          name: '钵钵鸡',\n          value: 942\n        },\n        {\n          name: '板栗',\n          value: 842\n        },\n        {\n          name: '胡辣汤',\n          value: 828\n        },\n        {\n          name: '关东煮',\n          value: 665\n        },\n        {\n          name: '羊肉汤',\n          value: 627\n        },\n        {\n          name: '热干面',\n          value: 574\n        },\n        {\n          name: '肠粉',\n          value: 564\n        },\n        {\n          name: '北京烤鸭',\n          value: 554\n        },\n        {\n          name: '龟苓膏',\n          value: 540\n        },\n        {\n          name: '米粉',\n          value: 513\n        },\n        {\n          name: '灌肠',\n          value: 499\n        },\n        {\n          name: '藕粉',\n          value: 499\n        },\n        {\n          name: '烤冷面',\n          value: 495\n        },\n        {\n          name: '炸酱面',\n          value: 487\n        },\n        {\n          name: '臭豆腐',\n          value: 484\n        },\n        {\n          name: '沙县小吃',\n          value: 482\n        },\n        {\n          name: '重庆小面',\n          value: 482\n        },\n        {\n          name: '冒菜',\n          value: 479\n        },\n        {\n          name: '醪糟',\n          value: 462\n        },\n        {\n          name: '肉夹馍',\n          value: 456\n        },\n        {\n          name: '酸辣粉',\n          value: 456\n        },\n        {\n          name: '驴打滚',\n          value: 456\n        },\n        {\n          name: '煎饼果子',\n          value: 443\n        },\n        {\n          name: '驴肉火烧',\n          value: 443\n        },\n        {\n          name: '小笼包',\n          value: 426\n        },\n        {\n          name: '烧麦',\n          value: 425\n        },\n        {\n          name: '卤煮',\n          value: 422\n        },\n        {\n          name: '油条',\n          value: 414\n        },\n        {\n          name: '桂林米粉',\n          value: 414\n        },\n        {\n          name: '兰州拉面',\n          value: 409\n        },\n        {\n          name: '双皮奶',\n          value: 408\n        },\n        {\n          name: '锅盔',\n          value: 403\n        },\n        {\n          name: '羊肉泡馍',\n          value: 403\n        },\n        {\n          name: '凉皮',\n          value: 402\n        },\n        {\n          name: '糍粑',\n          value: 397\n        },\n        {\n          name: '豆皮',\n          value: 388\n        },\n        {\n          name: '粘豆包',\n          value: 388\n        },\n        {\n          name: '过桥米线',\n          value: 385\n        },\n        {\n          name: '叉烧',\n          value: 375\n        },\n        {\n          name: '豆腐脑',\n          value: 374\n        },\n        {\n          name: '豆汁',\n          value: 363\n        },\n        {\n          name: '麻花',\n          value: 363\n        },\n        {\n          name: '春卷',\n          value: 354\n        },\n        {\n          name: '锅贴',\n          value: 349\n        },\n        {\n          name: '韭菜盒子',\n          value: 349\n        },\n        {\n          name: '面筋',\n          value: 346\n        },\n        {\n          name: '南瓜饼',\n          value: 343\n        },\n        {\n          name: '炒肝',\n          value: 341\n        },\n        {\n          name: '文昌鸡',\n          value: 338\n        }\n      ]\n    }\n  ]\n}; \nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n# 结果展示\r\n\r\n代码运行后，所有文字都显示出来了（当然文字也变小了）</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JGDYbsF7foyvalxousacnXginDg.gif' alt='' width='522' height='520'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/wordcloud-fontsizerange-x4cflw?file=%2Fsrc%2Findex.ts%3A12%2C3-12%2C16</br>\r\n# 相关文档\r\n\r\n*  VChart 词云的`fontSizeRange`配置：https://visactor.io/vchart/option/wordCloudChart#fontWeightRange</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '47- How to configure tooltip and legend shapes as rounded rectangles.md',
    content:
      "---\ntitle: 103.tooltip 和 legend shape如何配置为带圆角的矩形</br>\n---\r\n## 问题标题\r\n\r\nlegend shape如何配置为带圆角的矩形？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如下图：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TopPbZHXFohFuPxKK0Jc2djancg.gif' alt='' width='1378' height='532'>\r\n\r\n\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n支持配置为 'rectRound' 类型</br>\r\n\r\n\r\n1. Tooltip: `shapeType:\"rectRound\"`</br>\r\n```\ntooltip: {\n    mark: {\n      content: [\n        {\n          shapeType: 'rectRound',\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }</br>\n```\r\n1. Legend: </br>\r\n```\nlegends: {\n    visible: true,\n    orient: 'right',\n    \n    item: {\n      width: '15%',\n      shape: {\n        style: {\n          symbolType: 'rectRound'\n        }\n      }\n    }\n  },</br>\n```\r\n## 代码示例  \r\n\r\n```\n\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'pie',\n      values: [\n  { value: 10, category: 'One' },\n  { value: 9, category: 'Two' },\n  { value: 6, category: 'Three' },\n  { value: 5, category: 'Four' },\n  { value: 4, category: 'Five' },\n  { value: 3, category: 'Six' },\n  { value: 1, category: 'Seven' }\n]\n    }\n  ],\n  categoryField: 'category',\n  valueField: 'value',\n  legends: {\n    visible: true,\n    orient: 'right',\n    \n    item: {\n      width: '15%',\n      shape: {\n        style: {\n          symbolType: 'rectRound'\n        }\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          shapeType: 'rectRound',\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\n\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/XS2TbckmToJJMDxo9C1c4zD2njf.gif' alt='' width='996' height='678'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend，https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip</br>\r\n*  API：https://visactor.bytedance.net/vchart/option/barChart#tooltip.dimension.content，https://visactor.bytedance.net/vchart/option/barChart-legends-discrete#item.shape.style.symbolType</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '48-How to customize the position and offset of the tooltip in the chart.md',
    content:
      '# 图表中如何自定义 tooltip 的位置，偏移量？\n\n## 问题描述\n\n我在使用 VChart 图表时，遇到了图表提示框与鼠标指针距离很近的问题，这样一来在高分辨率的大屏幕上鼠标指针放大后可能会遮挡提示框，有没有什么办法能解决这个问题？\n\n![tooltip](/vchart/faq/41-0.png)\n\n## 解决方案\n\nVChart 图表已经提供了对应的功能，你只需要在图表的 spec 里设置 tooltip.offset 即可。官网上有对应的配置文档。\n\n[https://visactor.io/vchart/option/barChart#tooltip.offset](https://visactor.io/vchart/option/barChart#tooltip.offset)\n\n## 代码示例\n\n```javascript\nspec.tooltip.offset = {\n  x: 40,\n  y: 40\n};\n```\n\n## 结果展示\n\n![demo](/vchart/faq/41-1.png)\n\nDemo: [https://codesandbox.io/s/tooltip-offset-mns4gl?file=/src/index.ts](https://codesandbox.io/s/tooltip-offset-mns4gl?file=/src/index.ts)\n\n## 相关文档\n\ntooltip option：[https://visactor.io/vchart/option/barChart#tooltip.offset](https://visactor.io/vchart/option/barChart#tooltip.offset)\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nTooltip tutorials: [https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip)\n\nTooltip demos:[https://www.visactor.io/vchart/demo/tooltip/custom-mark-tooltip](https://www.visactor.io/vchart/demo/tooltip/custom-mark-tooltip)\n'
  },
  {
    fileName: '49- How to configure the hierarchy in a combination chart.md',
    content:
      '---\ntitle: 43. 组合图层级如何配置？</br>\n---\r\n## 问题标题\r\n\r\n组合图层级如何配置？</br>\r\n\r\n\r\n# 问题描述 \r\n\r\n\n组合图层级如何配置，line 和 area 系列组合时，line 的 point图元 被 area 图元遮住了</br>\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/AjNrbADZWoMAPdxPzjtcEkuQnXb.gif\' alt=\'\' width=\'817\' height=\'530\'>\r\n\r\n## 解决方案 \r\n\r\n对于组合图中系列的层叠样式，可以通过series的声明顺序来控制，比如：如果line系列需要在area系列之上，那么则需要先声明area系列，然后声明line系列。</br>\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HjlvbY3wroBzdnxcLAmcc1MMnAd.gif\' alt=\'\' width=\'3268\' height=\'1060\'>\r\n\r\n\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\n  const data = [\n    { date: "2023-12-01", value: "1776", series: "demand" },\n    { date: "2023-12-01", value: 1546, series: "left" },\n    { date: "2023-12-01", value: "3322", series: "total" },\n    { date: "2023-12-02", value: "3555", series: "demand" },\n    { date: "2023-12-02", value: 43638, series: "left" },\n    { date: "2023-12-02", value: "47193", series: "total" },\n    { date: "2023-12-03", value: "52840", series: "demand" },\n    { date: "2023-12-03", value: 6864, series: "left" },\n    { date: "2023-12-03", value: "59704", series: "total" },\n    { date: "2023-12-04", value: "48566", series: "demand" },\n    { date: "2023-12-04", value: 41413, series: "left" },\n    { date: "2023-12-04", value: "89979", series: "total" },\n    { date: "2023-12-05", value: "17711", series: "demand" },\n    { date: "2023-12-05", value: 26783, series: "left" },\n    { date: "2023-12-05", value: "44494", series: "total" },\n    { date: "2023-12-06", value: "4295", series: "demand" },\n    { date: "2023-12-06", value: 363, series: "left" },\n    { date: "2023-12-06", value: "4658", series: "total" },\n    { date: "2023-12-07", value: "16", series: "demand" },\n    { date: "2023-12-07", value: 8757, series: "left" },\n    { date: "2023-12-07", value: "8773", series: "total" },\n    { date: "2023-12-08", value: "29228", series: "demand" },\n    { date: "2023-12-08", value: 29999, series: "left" },\n    { date: "2023-12-08", value: "59227", series: "total" },\n    { date: "2023-12-09", value: "29092", series: "demand" },\n    { date: "2023-12-09", value: 15516, series: "left" },\n    { date: "2023-12-09", value: "44608", series: "total" },\n    { date: "2023-12-010", value: "4098", series: "demand" },\n    { date: "2023-12-010", value: 4946, series: "left" },\n    { date: "2023-12-010", value: "9044", series: "total" },\n    { date: "2023-12-011", value: "11611", series: "demand" },\n    { date: "2023-12-011", value: 64795, series: "left" },\n    { date: "2023-12-011", value: "76406", series: "total" },\n    { date: "2023-12-012", value: "72517", series: "demand" },\n    { date: "2023-12-012", value: 11808, series: "left" },\n    { date: "2023-12-012", value: "84325", series: "total" },\n    { date: "2023-12-013", value: "15421", series: "demand" },\n    { date: "2023-12-013", value: 16839, series: "left" },\n    { date: "2023-12-013", value: "32260", series: "total" },\n    { date: "2023-12-014", value: "5185", series: "demand" },\n    { date: "2023-12-014", value: 18225, series: "left" },\n    { date: "2023-12-014", value: "23410", series: "total" },\n    { date: "2023-12-015", value: "9034", series: "demand" },\n    { date: "2023-12-015", value: 35726, series: "left" },\n    { date: "2023-12-015", value: "44760", series: "total" },\n    { date: "2023-12-016", value: "20138", series: "demand" },\n    { date: "2023-12-016", value: 42747, series: "left" },\n    { date: "2023-12-016", value: "62885", series: "total" },\n    { date: "2023-12-017", value: "1649", series: "demand" },\n    { date: "2023-12-017", value: 6281, series: "left" },\n    { date: "2023-12-017", value: "7930", series: "total" },\n    { date: "2023-12-018", value: "3687", series: "demand" },\n    { date: "2023-12-018", value: 5087, series: "left" },\n    { date: "2023-12-018", value: "8774", series: "total" },\n    { date: "2023-12-019", value: "49861", series: "demand" },\n    { date: "2023-12-019", value: 14074, series: "left" },\n    { date: "2023-12-019", value: "63935", series: "total" },\n    { date: "2023-12-020", value: "4386", series: "demand" },\n    { date: "2023-12-020", value: 33871, series: "left" },\n    { date: "2023-12-020", value: "38257", series: "total" },\n    { date: "2023-12-021", value: "5066", series: "demand" },\n    { date: "2023-12-021", value: 34438, series: "left" },\n    { date: "2023-12-021", value: "39504", series: "total" },\n    { date: "2023-12-022", value: "3070", series: "demand" },\n    { date: "2023-12-022", value: 47549, series: "left" },\n    { date: "2023-12-022", value: "50619", series: "total" },\n    { date: "2023-12-023", value: "7493", series: "demand" },\n    { date: "2023-12-023", value: 83660, series: "left" },\n    { date: "2023-12-023", value: "91153", series: "total" },\n    { date: "2023-12-024", value: "40735", series: "demand" },\n    { date: "2023-12-024", value: 8841, series: "left" },\n    { date: "2023-12-024", value: "49576", series: "total" },\n    { date: "2023-12-025", value: "15730", series: "demand" },\n    { date: "2023-12-025", value: 8965, series: "left" },\n    { date: "2023-12-025", value: "24695", series: "total" },\n    { date: "2023-12-026", value: "64354", series: "demand" },\n    { date: "2023-12-026", value: 31912, series: "left" },\n    { date: "2023-12-026", value: "96266", series: "total" },\n    { date: "2023-12-027", value: "15469", series: "demand" },\n    { date: "2023-12-027", value: 28519, series: "left" },\n    { date: "2023-12-027", value: "43988", series: "total" },\n    { date: "2023-12-028", value: "249", series: "demand" },\n    { date: "2023-12-028", value: 7200, series: "left" },\n    { date: "2023-12-028", value: "7449", series: "total" },\n    { date: "2023-12-029", value: "9296", series: "demand" },\n    { date: "2023-12-029", value: 26689, series: "left" },\n    { date: "2023-12-029", value: "35985", series: "total" },\n    { date: "2023-12-030", value: "4776", series: "demand" },\n    { date: "2023-12-030", value: 368, series: "left" },\n    { date: "2023-12-030", value: "5144", series: "total" },\n    { date: "2023-12-031", value: "50932", series: "demand" },\n    { date: "2023-12-031", value: 2237, series: "left" },\n    { date: "2023-12-031", value: "53169", series: "total" },\n    { date: "2023-12-032", value: "12191", series: "demand" },\n    { date: "2023-12-032", value: 45954, series: "left" },\n    { date: "2023-12-032", value: "58145", series: "total" },\n    { date: "2023-12-033", value: "1615", series: "demand" },\n    { date: "2023-12-033", value: 57757, series: "left" },\n    { date: "2023-12-033", value: "59372", series: "total" },\n    { date: "2023-12-034", value: "16892", series: "demand" },\n    { date: "2023-12-034", value: 23399, series: "left" },\n    { date: "2023-12-034", value: "40291", series: "total" },\n    { date: "2023-12-035", value: "12452", series: "demand" },\n    { date: "2023-12-035", value: 2427, series: "left" },\n    { date: "2023-12-035", value: "14879", series: "total" },\n    { date: "2023-12-036", value: "86059", series: "demand" },\n    { date: "2023-12-036", value: 8673, series: "left" },\n    { date: "2023-12-036", value: "94732", series: "total" },\n    { date: "2023-12-037", value: "1355", series: "demand" },\n    { date: "2023-12-037", value: 23182, series: "left" },\n    { date: "2023-12-037", value: "24537", series: "total" },\n    { date: "2023-12-038", value: "6865", series: "demand" },\n    { date: "2023-12-038", value: 26607, series: "left" },\n    { date: "2023-12-038", value: "33472", series: "total" },\n    { date: "2023-12-039", value: "63665", series: "demand" },\n    { date: "2023-12-039", value: 11211, series: "left" },\n    { date: "2023-12-039", value: "74876", series: "total" },\n    { date: "2023-12-040", value: "14291", series: "demand" },\n    { date: "2023-12-040", value: 62592, series: "left" },\n    { date: "2023-12-040", value: "76883", series: "total" },\n    { date: "2023-12-041", value: "13291", series: "demand" },\n    { date: "2023-12-041", value: 27065, series: "left" },\n    { date: "2023-12-041", value: "40356", series: "total" },\n    { date: "2023-12-042", value: "33858", series: "demand" },\n    { date: "2023-12-042", value: 11867, series: "left" },\n    { date: "2023-12-042", value: "45725", series: "total" },\n  ];\n\n  const spec = {\n    type: "common",\n    seriesField: "color",\n    data: [\n      { id: "id0", values: data.filter((o) => o.series !== "total") },\n      { id: "id1", values: data.filter((o) => o.series === "total") },\n    ],\n    series: [\n      {\n        type: "area",\n        id: "bar",\n        dataIndex: 0,\n        label: { visible: true },\n        dataIndex: 0,\n        xField: "date",\n        yField: "value",\n        seriesField: "series",\n        area: { zIndex: -1 },\n        line: {\n          style: {\n            lineDash: [2, 2],\n            lineWidth: (data) => (data.series === "left" ? 0 : 1),\n          },\n        },\n\n        dataZoom: { zIndex: 500 },\n        point: {\n          style: { size: 0 },\n          state: {\n            dimension_hover: {\n              size: (data) => (data.series === "left" ? 0 : 8),\n            },\n          },\n        },\n        label: { visible: false },\n        area: {\n          style: {\n            fillOpacity: (data) => (data.series === "left" ? 0.7 : 0.3),\n            textureColor: "#fff",\n            fill: (data) => (data.series === "left" ? "#bcc0cd" : "#1AC6FF"),\n            textureSize: 4,\n            texture: (data) => {\n              if (data.series === "left") {\n                return "bias-rl";\n              }\n              return null;\n            },\n          },\n        },\n      },\n      {\n        type: "line",\n        id: "line",\n        dataIndex: 1,\n        label: { visible: true },\n        seriesField: "series",\n        xField: "date",\n        yField: "value",\n        stack: false,\n        label: { visible: false },\n        dataZoom: { zIndex: 1000 },\n        line: {\n          style: {\n            lineDash: [2, 2],\n            lineWidth: 1,\n          },\n        },\n        point: {\n          style: { size: 0 },\n          state: {\n            dimension_hover: { size: 8 },\n          },\n        },\n      },\n    ],\n    axes: [\n      { orient: "left", visible: false },\n      { orient: "right", visible: false },\n      { orient: "bottom", label: { visible: true }, type: "band" },\n    ],\n    legends: { visible: true, orient: "bottom" },\n  };\nconst vchart = new VChart(spec, { dom: CONTAINER_ID }); vchart.renderAsync(); \nwindow[\'vchart\'] = vchart;\n</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：hhttps://codesandbox.io/p/sandbox/zindex-4dtk4g?file=%2Fsrc%2Findex.ts%3A4%2C1-217%2C5</br>\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/RI5Lb23DZoTwOexrUXpc1vA8ntb.gif\' alt=\'\' width=\'1436\' height=\'956\'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n组合图demo：https://www.visactor.io/vchart/demo/combination/single-region</br>\r\n组合图教程：https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n'
  },
  {
    fileName: '50- How to adjust the layer order of lines in a line chart.md',
    content:
      "---\ntitle: 79.如何调整线图中线的层级</br>\n---\r\n## 问题标题\r\n\r\nVChart如何调整线图中线的层级？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如下图的线图中，怎么使蓝色的线置于顶层呢？</br>\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/LF0lb94KLolZl5xYkK3c0kmQnwb.gif' alt='' width='1490' height='1030'>\r\n\r\n## 解决方案\r\n\r\n线图展示的时候，是根据数据中的分组字段进行分组，分组字段的值出现的最后面的那一分组的层级会比最先出现的分组对应的线层级更高；表现就是上图中的，图例项中最后的一项对应的线，它的层级是最高的；所以想要调整线的层级，有两种方案：</br>\r\n*  根据分组字段，对数据进行排序</br>\r\n*  调整线的`zIndex`视觉通道映射</br>\r\n```\nline: {\n    style: {\n      lineWidth: 2,\n      zIndex: (datum) => {\n        switch(datum.type) {\n          case 'Product A':\n            return 3;\n          case 'Product B':\n            return 2;\n          case 'Produce C':\n            return 1;\n        }\n      }\n    }\n  },</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { date: '2023-01-01', type: 'Product A', value: 99.9 },\n      { date: '2023-01-01', type: 'Product B', value: 96.6 },\n      { date: '2023-01-01', type: 'Product C', value: 96.2 },\n      { date: '2023-01-02', type: 'Product A', value: 96.7 },\n      { date: '2023-01-02', type: 'Product B', value: 91.1 },\n      { date: '2023-01-02', type: 'Product C', value: 93.4 },\n      { date: '2023-01-03', type: 'Product A', value: 100.2 },\n      { date: '2023-01-03', type: 'Product B', value: 99.4 },\n      { date: '2023-01-03', type: 'Product C', value: 91.7 },\n      { date: '2023-01-04', type: 'Product A', value: 104.7 },\n      { date: '2023-01-04', type: 'Product B', value: 108.1 },\n      { date: '2023-01-04', type: 'Product C', value: 93.1 },\n      { date: '2023-01-05', type: 'Product A', value: 95.6 },\n      { date: '2023-01-05', type: 'Product B', value: 96 },\n      { date: '2023-01-05', type: 'Product C', value: 92.3 },\n      { date: '2023-01-06', type: 'Product A', value: 95.6 },\n      { date: '2023-01-06', type: 'Product B', value: 89.1 },\n      { date: '2023-01-06', type: 'Product C', value: 92.5 },\n      { date: '2023-01-07', type: 'Product A', value: 95.3 },\n      { date: '2023-01-07', type: 'Product B', value: 89.2 },\n      { date: '2023-01-07', type: 'Product C', value: 95.7 },\n      { date: '2023-01-08', type: 'Product A', value: 96.1 },\n      { date: '2023-01-08', type: 'Product B', value: 97.6 },\n      { date: '2023-01-08', type: 'Product C', value: 99.9 },\n      { date: '2023-01-09', type: 'Product A', value: 96.1 },\n      { date: '2023-01-09', type: 'Product B', value: 100.6 },\n      { date: '2023-01-09', type: 'Product C', value: 103.8 },\n      { date: '2023-01-10', type: 'Product A', value: 101.6 },\n      { date: '2023-01-10', type: 'Product B', value: 108.3 },\n      { date: '2023-01-10', type: 'Product C', value: 108.9 }\n    ]\n  },\n  xField: 'date',\n  yField: 'value',\n  seriesField: 'type',\n  point: {\n    visible: false\n  },\n  line: {\n    style: {\n      lineWidth: 2,\n      zIndex: (datum) => {\n        switch(datum.type) {\n          case 'Product A':\n            return 3;\n          case 'Product B':\n            return 2;\n          case 'Produce C':\n            return 1;\n        }\n      }\n    }\n  },\n  legends: { visible: true }\n};</br>\n```\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/OEEbbyZ1UoUFtnxyEwTcbh6JnVe.gif' alt='' width='1508' height='1054'>\r\n\r\n## 相关文档\r\n\r\n*  [github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n*  [style.zIndex配置文档](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FlineChart%23line.style.zIndex)</br>"
  },
  {
    fileName: '51-How to use charts libraries in React.md',
    content:
      '# 如何在 React 中使用图表库，如 VChart？\n\n## 问题描述\n\n如何在 React 中实现[这样的柱状图](https://www.visactor.io/vchart/demo/bar-chart/basic-column)\n\n![bar chart](/vchart/faq/29-0.png)\n\n有什么需要注意的点吗？\n\n## 解决方案\n\n在 React 中使用 VChart 有多种方案：\n\n1.  通过 VChart 官方提供的 React 封装库`react-vchart`实现，[教程可参考](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/react)\n1.  自己在 React 中基于 VChart 封装\n\n## 代码示例\n\n```\n/* @refresh reset */\nimport { VChart, VChartProps } from "@visactor/react-vchart";\nimport { useMemo } from "react";\n\nexport interface AreaChartProps {\n  colors?: string[];\n}\n\nexport const AreaChart = (props: AreaChartProps) => {\n  const { colors } = props;\n\n  const spec = useMemo(() => {\n    const areaColors = colors ?? [\n      "#6690F2",\n      "#70D6A3",\n      "#B4E6E2",\n      "#63B5FC",\n      "#FF8F62",\n      "#FFDC83",\n      "#BCC5FD",\n      "#A29BFE",\n      "#63C4C7",\n      "#F68484"\n    ];\n    return {\n      type: "area",\n      data: {\n        values: [\n          { type: "Nail polish", country: "Africa", value: 4229 },\n          { type: "Nail polish", country: "EU", value: 4376 },\n          { type: "Nail polish", country: "China", value: 3054 },\n          { type: "Nail polish", country: "USA", value: 12814 },\n          { type: "Eyebrow pencil", country: "Africa", value: 3932 },\n          { type: "Eyebrow pencil", country: "EU", value: 3987 },\n          { type: "Eyebrow pencil", country: "China", value: 5067 },\n          { type: "Eyebrow pencil", country: "USA", value: 13012 },\n          { type: "Rouge", country: "Africa", value: 5221 },\n          { type: "Rouge", country: "EU", value: 3574 },\n          { type: "Rouge", country: "China", value: 7004 },\n          { type: "Rouge", country: "USA", value: 11624 },\n          { type: "Lipstick", country: "Africa", value: 9256 },\n          { type: "Lipstick", country: "EU", value: 4376 },\n          { type: "Lipstick", country: "China", value: 9054 },\n          { type: "Lipstick", country: "USA", value: 8814 },\n          { type: "Eyeshadows", country: "Africa", value: 3308 },\n          { type: "Eyeshadows", country: "EU", value: 4572 },\n          { type: "Eyeshadows", country: "China", value: 12043 },\n          { type: "Eyeshadows", country: "USA", value: 12998 },\n          { type: "Eyeliner", country: "Africa", value: 5432 },\n          { type: "Eyeliner", country: "EU", value: 3417 },\n          { type: "Eyeliner", country: "China", value: 15067 },\n          { type: "Eyeliner", country: "USA", value: 12321 },\n          { type: "Foundation", country: "Africa", value: 13701 },\n          { type: "Foundation", country: "EU", value: 5231 },\n          { type: "Foundation", country: "China", value: 10119 },\n          { type: "Foundation", country: "USA", value: 10342 },\n          { type: "Lip gloss", country: "Africa", value: 4008 },\n          { type: "Lip gloss", country: "EU", value: 4572 },\n          { type: "Lip gloss", country: "China", value: 12043 },\n          { type: "Lip gloss", country: "USA", value: 22998 },\n          { type: "Mascara", country: "Africa", value: 18712 },\n          { type: "Mascara", country: "EU", value: 6134 },\n          { type: "Mascara", country: "China", value: 10419 },\n          { type: "Mascara", country: "USA", value: 11261 }\n        ]\n      },\n      color: {\n        type: "ordinal",\n        domain: [],\n        range: areaColors\n      },\n      title: {\n        visible: true,\n        text: "Stacked line chart"\n      },\n      stack: true,\n      xField: "type",\n      yField: "value",\n      seriesField: "country",\n      legends: [{ visible: true, position: "middle", orient: "bottom" }]\n    } as VChartProps["spec"];\n  }, [colors]);\n\n  return <VChart spec={spec} />;\n};\n```\n\n## 结果展示\n\n[在线效果参考](https://codesandbox.io/s/visactor-vchart-react-demo-forked-jsqqjj)\n\n![result](/vchart/faq/29-1.gif)\n\n## 相关文档\n\n- [react-vchart 教程](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/react)\n- [github](https://github.com/VisActor/VChart)\n'
  },
  {
    fileName: '52- Can the legend shape be set to a rectangle.md',
    content:
      "---\ntitle: 68. 图例形状是否可以设置为长方形？</br>\n---\r\n## 问题标题\r\n\r\n图例形状是否可以设置为长方形？</br>\r\n## 问题描述\r\n\r\n图例默认形状是圆形，想修改成长方形，该怎么配置？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Uu8jbXqseoiUdzxvkoQcHhuGn8e.gif' alt='' width='201' height='75'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n在图例的item.shape.style中分别配置symbolType: 'rect' 和 size: [width: height]即可。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/BK82bht62o9jKFxHrq6c9B99n9u.gif' alt='' width='3252' height='1262'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: '100% stacked line chart of cosmetic products sales'\n  },\n  percent: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [\n    { \n      visible: true, \n      position: 'middle', \n      orient: 'bottom',\n      item: {\n        shape: {\n          style: {\n            symbolType: 'rect',\n            size: [20, 10]\n          }\n        }\n      }\n    }],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/legend-symbol-type-mwsr2d?file=%2Fsrc%2Findex.ts%3A6%2C12</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WcdSbAU9JorEvAxNfB1ce26Cnjh.gif' alt='' width='1594' height='978'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n图例教程: https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend</br>\r\n相关api：https://www.visactor.io/vchart/option/barChart-legends-discrete#item.shape.style.symbolType</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '53- How to configure axis unit display on the axes of a line chart.md',
    content:
      "---\ntitle: 28.如何在折线图的axes上配置轴单位的展示</br>\n---\r\n## 问题标题\r\n\r\n如何在折线图的axes上配置轴单位的展示?</br>\r\n\r\n\r\n## 问题描述\r\n\r\n想配置 Y轴上面这种单位展示，需要用哪个参数配置？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HrJxb6uKiovk0UxbuRSckjOknTg.gif' alt='' width='698' height='818'>\r\n\r\n\r\n\r\n## 解决方案\r\n\r\n可以在轴的配置项中设置 unit 配置来开启轴单位的显示。轴单位显示的文本内容以及轴单位样式均可以通过 unit 配置项进行调整。</br>\r\n```\n    {\n      orient: 'left',\n      unit: {\n        visible: true,\n        text: 'Unit: GB',\n        style: { fontSize: 16, fontWeight: 'bold', fill: '#000' }\n      }\n    }</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  axes: [\n    { orient: 'bottom' },\n    {\n      orient: 'left',\n      unit: {\n        visible: true,\n        text: 'Unit: GB',\n        style: { fontSize: 16, fontWeight: 'bold', fill: '#000' }\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HTOfb0XupoO2q9xgcVdcOB0UnGe.gif' alt='' width='1652' height='1024'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  Axes unit：https://visactor.io/vchart/option/barChart-axes-linear#unit</br>\r\n*  github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '54- How to configure the outer border of graphical elements when hovering on a bar chart.md',
    content:
      "---\ntitle: 44. 柱状图如何配置hover时的图元外边框？</br>\n---\r\n## 问题标题\r\n\r\n柱状图如何配置hover时的图元外边框？</br>\r\n# 问题描述 \r\n\r\n\n柱状图如何配置hover时展示的外边框效果？我希望hover时，会出现与图元有一定间隙的外部边框。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TL3Qb5YFeoV8mAxb2txcChgDnxd.gif' alt='' width='2246' height='996'>\r\n\r\n## 解决方案 \r\n\r\n在`bar.state.hover.outerBorder`中即可配置`lineWidth`边框粗细、`stroke`描边颜色和边框与`distance`图元的间隙。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/O9TtbjnXmoDUP4xoj6McCe8wnrh.gif' alt='' width='2302' height='1190'>\r\n\r\n\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales',\n  bar:{\n    state:{\n      hover:{\n        zIndex:400,\n        outerBorder:{\n          lineWidth:1, // borderSize\n          stroke:'#4e83fd', // borderColor\n          distance: 3 // borderSpacing\n        }\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/hover-border-wq6lsr?file=%2Fsrc%2Findex.ts%3A23%2C23</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/BSQabGRGpofkotx2K1ocqiU3nwh.gif' alt='' width='1476' height='998'>\r\n\r\n## 相关文档\r\n\r\n柱状图demo：https://www.visactor.io/vchart/demo/bar-chart/basic-column</br>\r\n组合图教程：https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Bar</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '55- How to modify the marker graphic of tooltip content items.md',
    content:
      "---\ntitle: 100. 如何修改 tooltip 内容项的标记图形</br>\n---\r\n## 问题标题\r\n\r\n如何修改 tooltip 内容项的标记图形？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n我想针对折线图，将 tooltip 中的 shape 改成线性的，有什么好的实现方式吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/PQm0bkFL1oDWufxgwgqcJc6hnjb.gif' alt='' width='1644' height='548'>\r\n\r\n## 解决方案 \r\n\r\n修改 `shapeType` 为 `'rect'`即可。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n    type: 'bar',\n    data: [\n      {\n        id: 'barData',\n        values: [\n          { month: 'Monday', sales: 22 },\n          { month: 'Tuesday', sales: 13 },\n          { month: 'Wednesday', sales: 25 },\n          { month: 'Thursday', sales: 29 },\n          { month: 'Friday', sales: 38 }\n        ]\n      }\n    ],\n    tooltip: {\n      mark: { \n        content: \n        [{ key: datum => datum['month'], value: datum => datum['sales'], shapeType: 'rect' }] \n      }\n    },\n    xField: 'month',\n    yField: 'sales'\n  };\n  const vchart = new VChart(spec, { dom: CONTAINER_ID });\n  vchart.renderSync();</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/VRDFbbwTZo3jshx8ygCc8f82nmd.gif' alt='' width='1688' height='1040'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip</br>\r\n*  API：https://visactor.io/vchart/option/barChart#tooltip.dimension.content(Object%7CObject%5B%5D).shapeType</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '56- How to set the bar width in a bar chart in VChart.md',
    content:
      "---\ntitle: 37. VChart 如何设置柱状图的柱子宽度</br>\n---\r\n## 问题标题\r\n\r\n如何设置柱状图的柱宽度，期望图表容器变大时，柱子宽度不变</br>\r\n## 问题描述\r\n\r\n请问怎么设置柱状图的柱宽度，期望图表容器变大时，柱子宽度不变，始终是16px</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/W7BMb8TzNoAkE7xr6RjcyTwEntg.gif' alt='' width='844' height='534'>\r\n\r\n## 解决方案 \r\n\r\nVChart 的柱图支持一组柱宽度配置项：</br>\r\n*  barWidth：宽度</br>\r\n*  barMinWidth：最小宽度</br>\r\n*  barMaxWidth: 最大宽度</br>\r\n\r\n\r\nVChart 默认的柱宽度是与图表容器宽度相关的，这样的逻辑能保证图表容器较小时，柱子之间依然不会重叠。</br>\r\n实际使用时，如果有柱子宽度固定大小的需求，可以用 `barWidth` ，如果只是不期望柱子太宽不美观的话，可以使用 `barMaxWidth` 限制它的最大宽度，这样容器比较小时，也能正确展示。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  barWidth: 16,\n  // barMaxWidth: 16,\n  xField: 'month',\n  yField: 'sales'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/H6yCbfiTToX4Vtx5vNKc81pVn9b.gif' alt='' width='1108' height='531'>\r\n\r\nDemo: https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-n5z7cl?file=%2Fsrc%2Findex.js%3A30%2C1</br>\r\n## 相关文档\r\n\r\nDemo：https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-n5z7cl?file=%2Fsrc%2Findex.js%3A30%2C1</br>\r\n教程：</br>\r\n*  初始化VChart： https://visactor.io/vchart/api/API/vchart</br>\r\n*  柱宽度：https://www.visactor.io/vchart/option/barChart#barWidth</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName:
      '57-When listening to events at the Chart level, is it possible to get the type of element that was clicked via the event parameter, similar to the target parameter in dom.md',
    content:
      "# 在 Chart 层面监听事件，是否可以通过 event 参数获取具体点击的元素类型，类似于 dom 的 target 参数？\n\n## 问题描述\n\n能通过监听整个 chart 或 canvas，然后根据返回的参数，比如 type 来判断 点击的是 axis/legend/item 吗？\n\n## 解决方案\n\n可以实现的，VChart 实例上提供了事件的注册和卸载，您可以通过\n`chart.on(event: string, callback: (params: EventParams)=> void): void`监听不同的事件类型，并通过回调函数拿到上下文信息。如果要区分您是在 axis/legend/item 上触发的不同事件，可以事件过滤来实现，并传入`{ level: 'model' | 'mark', type: 'axis' }`，\n其中`'model'`表示图表组成元素模型类型，`'mark'`表示图表 item 元素。\n比如：`vchart.on('pointerdown', { level: 'model', type: 'axis' }, (params) => {})`。\n当我点击了坐标轴，便可以拿到具体的参数。\n\n更多的事件类型及参数可以参考：https://www.visactor.io/vchart/api/event。\n\n[event](/vchart/faq/8-0.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nvchart.on('pointerdown', { level: 'model', type: 'axis' }, params => {\n  console.log('params', params);\n});\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [事件教程](https://www.visactor.io/vchart/guide/event)\n- [相关 api](https://www.visactor.io/vchart/api/event)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '58- How to clear the selection in the onbrushEnd event when using vchart.md',
    content:
      "---\ntitle: 55. 如何在使用vchart时，在onbrushEnd事件最后清除框选？</br>\n---\r\n# 问题标题\r\n\r\n如何在使用vchart时，在onbrushEnd事件最后清除框选？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我正在使用@visactor/vchart图表库进行图表开发，遇到了一个问题，我需要在onbrushEnd事件最后清除brush的框选，但是目前我没有找到合适的api来实现这个需求。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TtJhbirfsoI83Extdf9cQ69Fnud.gif' alt='' width='1876' height='1106'>\r\n\r\n# 解决方案\r\n\r\n目前确实没有直接对应这个需求的api，但是这里有一个较为特殊的实现方式可以求解该问题，具体代码如下：</br>\r\n\r\n\r\n```\ncs.on('brushEnd', (params) => {\ncs.getChart()?.getAllComponents().forEach(c => {\nif(c.name === 'brush') {\nc?._brushComponents?.forEach(c => c._container.incrementalClearChild())\n}\n})\n})</br>\n```\r\n以上解决方案是当触发'brushEnd'事件后，获取所有的组件，并遍历这些组件，如果某个组件名为'brush'，就清除该组件。</br>\r\n\r\n\r\n# 结果展示\r\n\r\n代码运行后，可以实现在onbrushEnd事件结束后清除框选。</br>\r\n在线demo：https://codesandbox.io/p/sandbox/grouped-bar-chart-shows-all-the-group-labels-forked-2t4jf7</br>\r\n\r\n\r\n# 相关文档\r\n\r\n*  VisActor官网：https://www.visactor.io/</br>\r\n*  VChart事件：https://www.visactor.io/vchart/api/API/event</br>"
  },
  {
    fileName: '59- What are the methods for formatting chart labels in VChart.md',
    content:
      "---\ntitle: 19. VChart 图表标签格式化的方法有哪些？</br>\n---\r\n## 问题标题\r\n\r\nVChart 图表标签格式化的方法有哪些？</br>\r\n## 问题描述\r\n\r\nVChart 柱状图中，默认展示的是柱子对应数值的标签，我想展示类似 ``x轴名称: y数值``这样的内容，有哪些办法可以自定义标签展示？</br>\r\n## 解决方案 \r\n\r\n有两种推荐的配置方式：</br>\r\n1. 通过 `label.formatMethod` 配置格式化函数。</br>\r\n1. 函数参数为`(text: string | string[], datum?: any)`，`text` 为默认展示的文本，`datum`为图元数据。</br>\r\n1. 函数返回值可以是一个字符串或字符串数组。其中，字符串数组会默认换行展示。</br>\r\n1. 如果要配置为富文本，那么返回值则为富文本配置对象；</br>\r\n```\nlabel: {\n    formatMethod:(value, data) => `${data.name}: ${value}`\n}</br>\n```\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Lu0IbhIOtoCTHOxlZUAcGF6nn9e.gif' alt='' width='2842' height='894'>\r\n\r\n\r\n\r\n1. 通过 `label.formatter` 配置模板字符串。</br>\r\n```\nlabel: {\n   formatter: `{name} : {value}`\n}</br>\n```\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JgcTblmKqorPmZxREk4chim4nLg.gif' alt='' width='2884' height='848'>\r\n\r\n\r\n\r\n\r\n\r\n## 相关文档\r\n\r\nformatMethod demo: [https://visactor.io/vchart/demo/label/richtext-label](https%3A%2F%2Fvisactor.io%2Fvchart%2Fdemo%2Flabel%2Frichtext-label)</br>\r\nFormatter demo：[https://visactor.io/vchart/demo/label/label-formatter](https%3A%2F%2Fvisactor.io%2Fvchart%2Fdemo%2Flabel%2Flabel-formatter)</br>\r\n相关配置项：https://visactor.io/vchart/option/barChart#label.formatMethod</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '60- How to configure the size of a pie chart in VChart.md',
    content:
      "---\ntitle: 39. VChart 如何配置饼图大小</br>\n---\r\n## 问题标题\r\n\r\n VChart 如何配置饼图大小？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n页面较窄，VChart 如何调整配置，使得饼图尽可能占满屏幕空间</br>\r\n\r\n\r\n## 解决方案\r\n\r\n1. 取消默认的图表边距。</br>\r\nVChart 默认为所有图表设置了一定的边距，你可以配置 `padding: 0` 取消默认边距。</br>\r\n1. 调整饼图扇区外半径。</br>\r\n默认情况下，饼图并不会撑满整个画布，你可以通过配置 `outerRadius: 1` ，将外半径占比设置为最高。</br>\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst data = [\n  { value: 10, category: 'One' },\n  { value: 9, category: 'Two' },\n  { value: 6, category: 'Three' },\n  { value: 5, category: 'Four' },\n  { value: 4, category: 'Five' },\n  { value: 3, category: 'Six' },\n  { value: 1, category: 'Seven' }\n];\n\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'pie',\n      values: data\n    }\n  ],\n  outerRadius:1,\n  padding:0,\n  background:'#eeeeee',\n  categoryField: 'category',\n  valueField: 'value',\n  \n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\n\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/LiJHb2VCzoHABdxL5NvccgYknzg.gif' alt='' width='1677' height='1044'>\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/L3irbGIlfoGvsFxXQ0tcqZyxnqc.gif' alt='' width='1677' height='1044'>\r\n\r\n## 相关文档\r\n\r\n*  [饼图配置项](https%3A%2F%2Fvisactor.io%2Fvchart%2Foption%2FpieChart%23outerRadius)</br>\r\n*  github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '61-How to generate a simplified mini line chart.md',
    content:
      "# 如何生成一个 mini 折线图？\n\n## 问题描述\n\n我想制作一个非常精简的折线图，尽可能的节省空间，快速有效地传达数据的趋势和变化。\n因此我期望这个折线图除了这线段以外，不再需要坐标轴、标签、图例等组件。\n\n## 解决方案\n\nVChart 的各个图表组件提供了丰富的样式配置，在组件中配置 `visible:false` 就能够让组件隐藏，以绘制更加精简的图表。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  // type: 'area',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  padding: 0,\n  margin: 0,\n  point: {\n    visible: false\n  },\n  line: {\n    style: {\n      curveType: 'monotone'\n    }\n  },\n  axes: [\n    {\n      type: 'linear',\n      orient: 'left',\n      nice: true,\n      zero: true,\n      visible: false\n    },\n    {\n      type: 'band',\n      paddingOuter: 0,\n      paddingInner: 0,\n      orient: 'bottom',\n      visible: false\n    }\n  ],\n  legends: [\n    {\n      visible: false\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [VChart 坐标轴教程](https://visactor.io/vchart/guide/concepts/axes)\n- [VChart 折线图教程](https://visactor.io/vchart/guide/chart/line)\n"
  },
  {
    fileName: '62-How to achieve reverse y-axis effect.md',
    content:
      "# 如何实现反向 y 轴效果？\n\n## 问题描述\n\n请问 VChart 上有提供类似 echarts 的 yaxis.inverse 的配置吗？\n\n## 解决方案\n\nVChart 提供了轴反转的配置，对应 `inverse` 属性，只需要在对应方向的轴上进行配置即可，如下：\n\n![](/vchart/faq/93-0.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'area',\n  data: [\n    {\n      id: 'line',\n      values: [\n        { x: 'Monday', y: 12 },\n        { x: 'Tuesday', y: 13 },\n        { x: 'Wednesday', y: 11 },\n        { x: 'Thursday', y: 10 },\n        { x: 'Friday', y: 12 },\n        { x: 'Saturday', y: 14 },\n        { x: 'Sunday', y: 17 }\n      ]\n    }\n  ],\n  xField: 'x',\n  yField: 'y',\n  axes: [\n    {\n      zIndex: 100,\n      orient: 'bottom'\n    },\n    {\n      zIndex: 101,\n      orient: 'left',\n      inverse: true, // inverse the left axis\n      domainLine: {\n        visible: true,\n        // show the endSymbol\n        endSymbol: {\n          visible: true,\n          style: {\n            fill: '#000'\n          }\n        }\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [坐标轴教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes)\n- [坐标轴配置](https://www.visactor.io/vchart/option/lineChart#axes-linear.inverse)\n"
  },
  {
    fileName: '63-How to configure the range of the axis.md',
    content:
      "# 如何配置坐标轴的范围？\n\n## 问题描述\n\n在双轴图里，右边的坐标轴表示的是百分比，这个百分比的范围可以手动配置吗？我用的是 vchart 的，我配置了 min 和 max 但是没有生效。具体配置：\n![demo](/vchart/faq/18-0.png)\n\n```js\n{\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '2021-10-22', type: 'A', y: 10 },\n        { x: '2021-10-23', type: 'B', y: 22 },\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '2021-10-22', type: 'TA', y: 0.5 },\n        { x: '2021-10-22', type: 'TB', y: 1.1 },\n        { x: '2021-10-23', type: 'TA', y: 1 },\n        { x: '2021-10-23', type: 'TB', y: 1.5 },\n\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      label: { visible: true ,position:'inside'},\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      max: 100\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      min: 0,\n      max: 2,\n      stack: false\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: [0] },\n    { orient: 'right', seriesId: ['line'], grid: { visible: false }},\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n}\n```\n\n## 解决方案\n\n轴范围的配置在 `axes` 配置项里，并不是在 `series` 上。你可以根据需要配置最小值（`min`）和最大值（`max`）, 例如：\n\n```js\naxes: [\n  { orient: 'left', max: 100 },\n  { orient: 'right', min:0, max:2 },\n],\n```\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '2021-10-22', type: 'A', y: 10 },\n        { x: '2021-10-23', type: 'B', y: 22 }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '2021-10-22', type: 'TA', y: 0.5 },\n        { x: '2021-10-22', type: 'TB', y: 1.1 },\n        { x: '2021-10-23', type: 'TA', y: 1 },\n        { x: '2021-10-23', type: 'TB', y: 1.6 }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      label: { visible: true, position: 'inside' },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y'\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: [0], max: 100 },\n    { orient: 'right', seriesId: ['line'], grid: { visible: false }, min: 0, max: 2 },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [更多示例](https://visactor.io/vchart/demo/combination/dual-axis)\n- [轴相关教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes)\n- [相关 API](https://visactor.io/vchart/option/lineChart#axes-linear.min)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '64-How to display the center value when selecting an arc in a pie chart.md',
    content:
      "# 环形图中心指标能否设置选中时展示？\n\n## 问题描述\n\n在环形图中，中心区域有大量的空白，我想利用这些区域，在单击某个扇区时，在图表正中间显示该扇形对应的数值。\n\n## 解决方案\n\nVChart 的为饼图了设计了 indicator 组件，支持配置指标的标题与多行文本内容，提供对 fixed 和 hover 两种交互方式与常用的样式配置功能。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'data',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.6,\n  innerRadius: 0.4,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  pie: {\n    style: {\n      cornerRadius: 10\n    },\n    state: {\n      hover: {\n        outerRadius: 0.65\n      },\n      selected: {\n        outerRadius: 0.65\n      }\n    }\n  },\n  label: {\n    visible: true\n  },\n  indicator: {\n    visible: true,\n    trigger: 'fixed',\n    title: {\n      visible: true,\n      style: {\n        fontSize: 18,\n        text: data => {\n          if (data) {\n            const value = data['type'];\n            return value ? value : null;\n          }\n          return null;\n        }\n      }\n    },\n    content: [\n      {\n        visible: true,\n        style: {\n          fontSize: 18,\n          text: ''\n        }\n      },\n      {\n        visible: true,\n        style: {\n          fontSize: 18,\n          text: data => {\n            if (data) {\n              const value = data['value'];\n              return value ? `${value}%` : null;\n            }\n            return null;\n          }\n        }\n      }\n    ]\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [VChart 饼图指标示例](https://visactor.io/vchart/demo/pie-chart/pie-indicator)\n- [VChart 饼图指标配置文档](https://visactor.io/vchart/option/pieChart#indicator.visible)\n"
  },
  {
    fileName: '65- How to prevent displaying abbreviated tooltips when custom tooltips are already set.md',
    content:
      "---\ntitle: 37. 如何禁止被缩略的 tooltip 展示，已经自定义 tooltip 不需要重复展示</br>\n---\r\n## 问题标题\r\n\r\n如何禁止被缩略的 tooltip 展示，已经自定义 tooltip 不需要重复展示</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如何禁止被缩略的 tooltip 展示，已经自定义 tooltip 不需要重复展示，如下所示：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/CTNDb8GJ8o1LgvxYCMgc519ynHg.gif' alt='' width='574' height='742'>\r\n\r\n## 解决方案 \r\n\r\nVChart 内会对超长的文本进行自动省略，同时会默认提供悬浮展示 poptip 显示完整文本的交互，如果想要关闭，可以在图表初始化的时候，在构造函数的参数中设置 poptip: false，如下：</br>\r\n\r\n\r\n```\nconst vchart = new VChart(spec, { \n  // ...\n  poptip: false, // 关闭省略文本的 poptip\n});</br>\n```\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  width: 300,\n  height: 250,\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          name: 'AppleAppleAppleApple',\n          value: 214480\n        },\n        {\n          name: 'Google',\n          value: 155506\n        },\n        {\n          name: 'Amazon',\n          value: 100764\n        },\n        {\n          name: 'Microsoft',\n          value: 92715\n        },\n        {\n          name: 'Coca-Cola',\n          value: 66341\n        },\n        {\n          name: 'Samsung',\n          value: 59890\n        },\n        {\n          name: 'Toyota',\n          value: 53404\n        },\n        {\n          name: 'Mercedes-Benz',\n          value: 48601\n        },\n        {\n          name: 'Facebook',\n          value: 45168\n        },\n        {\n          name: \"McDonald's\",\n          value: 43417\n        },\n        {\n          name: 'Intel',\n          value: 43293\n        },\n        {\n          name: 'IBM',\n          value: 42972\n        },\n        {\n          name: 'BMW',\n          value: 41006\n        },\n        {\n          name: 'Disney',\n          value: 39874\n        },\n        {\n          name: 'Cisco',\n          value: 34575\n        },\n        {\n          name: 'GE',\n          value: 32757\n        },\n        {\n          name: 'Nike',\n          value: 30120\n        },\n        {\n          name: 'Louis Vuitton',\n          value: 28152\n        },\n        {\n          name: 'Oracle',\n          value: 26133\n        },\n        {\n          name: 'Honda',\n          value: 23682\n        }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  xField: 'value',\n  yField: 'name',\n  axes: [\n    {\n      orient: 'bottom',\n      visible: false\n    }\n  ],\n  label: {\n    visible: true\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, poptip: false });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 相关文档\r\n\r\n*  API：https://visactor.io/vchart/api/API/vchart#options</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '66-How do I customize the position of the tooltip to avoid occlusion.md',
    content:
      '# 如何自定义 tooltip 的位置，避免遮挡？\n\n## 问题描述\n\n我在使用 VChart 图表时，图表的 tooltip 会被 dom 的边缘截断。我想了解 VChart 中如何自定义 tooltip 的位置来避免这种情况。\n\n![tooltip](/vchart/faq/43-0.png)\n\n## 解决方案\n\nVChart 中控制 tooltip 的位置有很多方式，例如实现自定义 tooltip，或者指定 tooltip 的 offset 参数。\n但你遇到的情况其实有简单的办法实现，通过指定 Tooltip 挂载的 dom 节点来实现。\n默认情况下，tooltip 会挂载在页面的 body 上，因此是不应该出现截断的。你的情况可能是修改了`spec.tooltip.parentElement`的配置。删除或修改该配置应该就可以了。\n\n## 代码示例\n\n```javascript\nspec.tooltip.parentElement = document.body;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/43-1.png)\n\nDemo: [https://visactor.io/vchart/demo/line-chart/null-value-line](https://visactor.io/vchart/demo/line-chart/null-value-line)\n\n## 相关文档\n\ntooltip: [https://visactor.io/vchart/option/barChart#tooltip.parentElement](https://visactor.io/vchart/option/barChart#tooltip.parentElement)\n\ngithub: [https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nTooltip tutorials: [https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip)\n'
  },
  {
    fileName: '67- How to set the axis width in VChart.md',
    content:
      '---\ntitle: 61. VChart  如何设置坐标轴宽度？</br>\n---\r\n## 问题标题\r\n\r\nVChart  如何设置坐标轴宽度？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n图表中坐标轴文字标签比较长，希望能增加一下坐标轴宽度，让文字显示的更多一点，该怎么配置？</br>\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UgyUbqSdEoAJB2xZrwPcGptAnlb.gif\' alt=\'\' width=\'900\' height=\'500\'>\r\n\r\n## 解决方案\r\n\r\n你可以配置 axes.width 来设置轴组件的宽度：</br>\r\n1. `width: `50%``：配置百分比字符串，代表布局时组件宽度占图表的一半</br>\r\n```\n  axes: [\n    {\n      orient: \'left\',\n      width: `50%`\n    }\n  ],</br>\n```\r\n1. `width: 100`：配置固定数值，代表布局时组件宽度的像素宽度</br>\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: \'bar\',\n  width:450,\n  height: 250,\n  data: [\n    {\n      id: \'barData\',\n      values: [\n    {\n        "name": "Product-Name-:Apple",\n        "value": 214480\n    },\n    {\n        "name": "Product-Name-:Google",\n        "value": 155506\n    },\n    {\n        "name": "Product-Name-:Amazon",\n        "value": 100764\n    },\n    {\n        "name": "Product-Name-:Microsoft",\n        "value": 92715\n    },\n    {\n        "name": "Product-Name-:Coca-Cola",\n        "value": 66341\n    },\n    {\n        "name": "Product-Name-:Samsung",\n        "value": 59890\n    },\n    {\n        "name": "Product-Name-:Toyota",\n        "value": 53404\n    },\n    {\n        "name": "Product-Name-:Mercedes-Benz",\n        "value": 48601\n    },\n    {\n        "name": "Product-Name-:Facebook",\n        "value": 45168\n    },\n    {\n        "name": "Product-Name-:McDonald\'s",\n        "value": 43417\n    },\n    {\n        "name": "Product-Name-:Intel",\n        "value": 43293\n    },\n\n]\n    }\n  ],\n  direction: \'horizontal\',\n  xField: \'value\',\n  yField: \'name\',\n  axes: [\n    {\n      orient: \'bottom\',\n      visible: false\n    },\n    {\n      orient: \'left\',\n      width: `50%`\n    }\n  ],\n  label: {\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow[\'vchart\'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Wa0jbecxxoqEH6xc4OHcha9rnS0.gif\' alt=\'\' width=\'900\' height=\'500\'>\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  轴宽度配置项：https://visactor.io/vchart/option/barChart-axes-linear#width</br>\r\n\r\n'
  },
  {
    fileName:
      '68- Is there a way to deselect all line chart contents currently set to display by default (e.g., a button to hide all).md',
    content:
      "---\ntitle: 101.折线图展示内容目前默认是全部选择展示，是否可以有渠道反选（例如有个按钮一键不展示）</br>\n---\r\n## 问题标题\r\n\r\n折线图展示内容目前默认是全部选择展示，是否可以有渠道反选（例如有个按钮一键不展示）</br>\r\n## 问题描述\r\n\r\n就像图里描述的，图例可以全选或者全不全</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UnCnbLzvhoXbrMxntUkcdpaKnFd.gif' alt='' width='980' height='552'>\r\n\r\n## 解决方案 \r\n\r\n可以配置 `legends.defaultSelected` 参数为一个空数组：`[]`，恢复至全选的话，把这个参数删掉或者复制全量的图例项即可。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'area',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: '100% stacked area chart of cosmetic products sales'\n  },\n  percent: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [\n    { \n      visible: true, \n      position: 'middle', \n      orient: 'bottom',\n      defaultSelected: []\n    }\n    ],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QqvibVFB6oiKj2xC1rSc4HfwnBd.gif' alt='' width='1692' height='1044'>\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend</br>\r\n*  API：https://visactor.io/vchart/option/barChart#legends</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '69- How to select only the current item when clicking a legend.md',
    content:
      "---\ntitle: 86. 如何实现图例点击时仅选中当前项？</br>\n---\r\n## 问题标题\r\n\r\nVChart  如何实现图例点击时仅选中当前项？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n点击图例时，能改为选中当前项，不选中其他项吗？</br>\r\n## 解决方案\r\n\r\nVChart中支持配置图例选中模式，其中有单选模式</br>\r\n```\nlegends: {\n    orient: 'right',\n    selectMode: 'single', // Configure legend selection mode\n    defaultSelected: ['Type D'],\n    title: {\n      visible: true,\n      text: 'Single Select'\n    }\n  }</br>\n```\r\n## 代码示例 \r\n\r\n```\nconst data = [\n  {\n    name: 'Type A',\n    value: 33934,\n    year: 2010\n  },\n  {\n    name: 'Type A',\n    value: 52503,\n    year: 2011\n  },\n  {\n    name: 'Type A',\n    value: 57177,\n    year: 2012\n  },\n  {\n    name: 'Type A',\n    value: 69658,\n    year: 2013\n  },\n  {\n    name: 'Type A',\n    value: 97031,\n    year: 2014\n  },\n  {\n    name: 'Type A',\n    value: 119931,\n    year: 2015\n  },\n  {\n    name: 'Type A',\n    value: 137133,\n    year: 2016\n  },\n  {\n    name: 'Type A',\n    value: 154175,\n    year: 2017\n  },\n  {\n    name: 'Type B',\n    value: 24916,\n    year: 2010\n  },\n  {\n    name: 'Type B',\n    value: 24064,\n    year: 2011\n  },\n  {\n    name: 'Type B',\n    value: 29742,\n    year: 2012\n  },\n  {\n    name: 'Type B',\n    value: 29851,\n    year: 2013\n  },\n  {\n    name: 'Type B',\n    value: 32490,\n    year: 2014\n  },\n  {\n    name: 'Type B',\n    value: 30282,\n    year: 2015\n  },\n  {\n    name: 'Type B',\n    value: 38121,\n    year: 2016\n  },\n  {\n    name: 'Type B',\n    value: 40434,\n    year: 2017\n  },\n  {\n    name: 'Type C',\n    value: 11744,\n    year: 2010\n  },\n  {\n    name: 'Type C',\n    value: 17722,\n    year: 2011\n  },\n  {\n    name: 'Type C',\n    value: 16005,\n    year: 2012\n  },\n  {\n    name: 'Type C',\n    value: 19771,\n    year: 2013\n  },\n  {\n    name: 'Type C',\n    value: 20185,\n    year: 2014\n  },\n  {\n    name: 'Type C',\n    value: 24377,\n    year: 2015\n  },\n  {\n    name: 'Type C',\n    value: 32147,\n    year: 2016\n  },\n  {\n    name: 'Type C',\n    value: 39389,\n    year: 2017\n  },\n  {\n    name: 'Type D',\n    value: null,\n    year: 2010\n  },\n  {\n    name: 'Type D',\n    value: null,\n    year: 2011\n  },\n  {\n    name: 'Type D',\n    value: 7988,\n    year: 2012\n  },\n  {\n    name: 'Type D',\n    value: 12169,\n    year: 2013\n  },\n  {\n    name: 'Type D',\n    value: 15112,\n    year: 2014\n  },\n  {\n    name: 'Type D',\n    value: 22452,\n    year: 2015\n  },\n  {\n    name: 'Type D',\n    value: 34400,\n    year: 2016\n  },\n  {\n    name: 'Type D',\n    value: 34227,\n    year: 2017\n  },\n  {\n    name: 'Other',\n    value: 12908,\n    year: 2010\n  },\n  {\n    name: 'Other',\n    value: 5948,\n    year: 2011\n  },\n  {\n    name: 'Other',\n    value: 8105,\n    year: 2012\n  },\n  {\n    name: 'Other',\n    value: 11248,\n    year: 2013\n  },\n  {\n    name: 'Other',\n    value: 8989,\n    year: 2014\n  },\n  {\n    name: 'Other',\n    value: 11816,\n    year: 2015\n  },\n  {\n    name: 'Other',\n    value: 18274,\n    year: 2016\n  },\n  {\n    name: 'Other',\n    value: 18111,\n    year: 2017\n  }\n];\nconst spec = {\n  type: 'line',\n  data: [\n    {\n      id: 'line',\n      values: data\n    }\n  ],\n  xField: 'year',\n  yField: 'value',\n  seriesField: 'name',\n  legends: {\n    orient: 'right',\n    selectMode: 'single', // Configure legend selection mode\n    defaultSelected: ['Type D'],\n    title: {\n      visible: true,\n      text: 'Single Select'\n    }\n  },\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        inside: true,\n        space: 2,\n        style: {\n          textBaseline: 'bottom',\n          textAlign: 'start',\n          fontWeight: 'bold'\n        }\n      },\n      tick: {\n        visible: false\n      },\n      domainLine: {\n        visible: false\n      },\n      title: {\n        visible: true,\n        text: 'Axis Title'\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Aw1NbRolWoF5IVxQdD0cZmQvnAb.gif' alt='' width='844' height='514'>\r\n\r\n## 相关文档\r\n\r\n*  图例教程：https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend</br>\r\n*  相关 demo：https://www.visactor.io/vchart/demo/legend/single-select</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '70-How can line and bar charts be displayed at the same time.md',
    content:
      "# 折线图和柱状图如何同时展示？\n\n## 问题描述\n\n如图所示，我想在我的产品中添加一个这样的图表，pv 用折线图展示 uv 用柱状图展示，应该如何实现？\n\n![tooltip](/vchart/faq/45-0.png)\n\n## 解决方案\n\n一开始以为你是希望做一个双轴图，仔细看了后发现并不是。双轴图会在图的左右两边各有一个坐标轴，而你真正的需求是组合图，在一个坐标系中渲染多组系列。\n并不是所有的图表库都支持多系列绘图，这里我使用 VChart 为例：\n指定两个系列分别是 bar 和 line，图表类型选择`common`即可。\n\n## 代码示例\n\n```javascript\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        {\n          x: 'Monday',\n          type: 'Breakfast',\n          y: 15\n        },\n        {\n          x: 'Monday',\n          type: 'Lunch',\n          y: 25\n        },\n        {\n          x: 'Tuesday',\n          type: 'Breakfast',\n          y: 12\n        },\n        {\n          x: 'Tuesday',\n          type: 'Lunch',\n          y: 30\n        },\n        {\n          x: 'Wednesday',\n          type: 'Breakfast',\n          y: 15\n        },\n        {\n          x: 'Wednesday',\n          type: 'Lunch',\n          y: 24\n        },\n        {\n          x: 'Thursday',\n          type: 'Breakfast',\n          y: 10\n        },\n        {\n          x: 'Thursday',\n          type: 'Lunch',\n          y: 25\n        },\n        {\n          x: 'Friday',\n          type: 'Breakfast',\n          y: 13\n        },\n        {\n          x: 'Friday',\n          type: 'Lunch',\n          y: 20\n        },\n        {\n          x: 'Saturday',\n          type: 'Breakfast',\n          y: 10\n        },\n        {\n          x: 'Saturday',\n          type: 'Lunch',\n          y: 22\n        },\n        {\n          x: 'Sunday',\n          type: 'Breakfast',\n          y: 12\n        },\n        {\n          x: 'Sunday',\n          type: 'Lunch',\n          y: 19\n        }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        {\n          x: 'Monday',\n          type: 'Drinks',\n          y: 22\n        },\n        {\n          x: 'Tuesday',\n          type: 'Drinks',\n          y: 43\n        },\n        {\n          x: 'Wednesday',\n          type: 'Drinks',\n          y: 33\n        },\n        {\n          x: 'Thursday',\n          type: 'Drinks',\n          y: 22\n        },\n        {\n          x: 'Friday',\n          type: 'Drinks',\n          y: 10\n        },\n        {\n          x: 'Saturday',\n          type: 'Drinks',\n          y: 30\n        },\n        {\n          x: 'Sunday',\n          type: 'Drinks',\n          y: 50\n        }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      dataIndex: 0,\n      label: {\n        visible: true\n      },\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: ['x', 'type'],\n      yField: 'y'\n    },\n    {\n      type: 'line',\n      dataIndex: 1,\n      label: {\n        visible: true\n      },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    {\n      orient: 'left'\n    },\n    {\n      orient: 'bottom',\n      label: {\n        visible: true\n      },\n      type: 'band'\n    }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n```\n\n## 结果展示\n\n![demo](/vchart/faq/45-1.png)\n\nDemo: [https://visactor.io/vchart/demo/combination/single-region?keyword=commonChart](https://visactor.io/vchart/demo/combination/single-region?keyword=commonChart)\n\n## 相关文档\n\nCommon Chart option: [https://visactor.io/vchart/option/commonChart](https://visactor.io/vchart/option/commonChart)\n\ngithub: [https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nSeries tutorials: [https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Composition_and_Effect_of_Series](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Composition_and_Effect_of_Series)\n"
  },
  {
    fileName: '71- Does the tree map support configuring the style when hovering.md',
    content:
      "---\ntitle: 70. 树图支持配置hover时的样式吗？</br>\n---\r\n## 问题标题\r\n\r\n树图支持配置hover时的样式吗？</br>\r\n## 问题描述\r\n\r\n树图能更新选中态的样式吗（放大 加边框）？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/AqjlbkQFQoboHTxn9H9cNbrrnkf.gif' alt='' width='1256' height='1040'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n在vchart中，选中或鼠标悬浮的状态都可以由图元state来配置。对于您的需求，可以通过在leaf图元上的state.selected上配置不同的样式来实现。比如：如果需要修改颜色，则可以配置fill或fillOpacity；如果需要配置边框，则可以配置stroke或lineWidth；如果需要配置放大效果，则可以配置scaleX、scaleY和scaleCenter。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/FFqSbZXJVosOpYxdt0CcMRu3nJb.gif' alt='' width='3242' height='1062'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'treemap',\n  data: [\n    {\n      id: 'data',\n      values: [\n        {\n          name: 'query',\n          children: [\n            {\n              name: 'methods',\n              children: [\n                { name: 'add', value: 593 },\n                { name: 'and', value: 330 },\n                { name: 'average', value: 287 },\n                { name: 'count', value: 277 },\n                { name: 'distinct', value: 292 },\n                { name: 'div', value: 595 },\n                { name: 'eq', value: 594 },\n                { name: 'fn', value: 460 },\n                { name: 'gt', value: 603 },\n                { name: 'gte', value: 625 },\n                { name: 'iff', value: 748 },\n                { name: 'isa', value: 461 },\n                { name: 'lt', value: 597 },\n                { name: 'lte', value: 619 },\n                { name: 'max', value: 283 },\n                { name: 'min', value: 283 },\n                { name: 'mod', value: 591 },\n                { name: 'mul', value: 603 },\n                { name: 'neq', value: 599 },\n                { name: 'not', value: 386 },\n                { name: 'or', value: 323 },\n                { name: 'orderby', value: 307 },\n                { name: 'range', value: 772 },\n                { name: 'select', value: 296 },\n                { name: 'stddev', value: 363 },\n                { name: 'sub', value: 600 },\n                { name: 'sum', value: 280 },\n                { name: 'update', value: 307 },\n                { name: 'variance', value: 335 },\n                { name: 'where', value: 299 },\n                { name: 'xor', value: 354 },\n                { name: '_', value: 264 }\n              ]\n            },\n            { name: 'AggregateExpression', value: 1616 },\n            { name: 'And', value: 1027 },\n            { name: 'Arithmetic', value: 3891 },\n            { name: 'Average', value: 891 },\n            { name: 'BinaryExpression', value: 2893 },\n            { name: 'Comparison', value: 5103 },\n            { name: 'CompositeExpression', value: 3677 },\n            { name: 'Count', value: 781 },\n            { name: 'DateUtil', value: 4141 },\n            { name: 'Distinct', value: 933 },\n            { name: 'Expression', value: 5130 },\n            { name: 'ExpressionIterator', value: 3617 },\n            { name: 'Fn', value: 3240 },\n            { name: 'If', value: 2732 },\n            { name: 'IsA', value: 2039 },\n            { name: 'Literal', value: 1214 },\n            { name: 'Match', value: 3748 },\n            { name: 'Maximum', value: 843 },\n            { name: 'Minimum', value: 843 },\n            { name: 'Not', value: 1554 },\n            { name: 'Or', value: 970 },\n            { name: 'Query', value: 13896 },\n            { name: 'Range', value: 1594 },\n            { name: 'StringUtil', value: 4130 },\n            { name: 'Sum', value: 791 },\n            { name: 'Variable', value: 1124 },\n            { name: 'Variance', value: 1876 },\n            { name: 'Xor', value: 1101 }\n          ]\n        },\n        {\n          name: 'util',\n          children: [\n            {\n              name: 'palette',\n              children: [\n                { name: 'ColorPalette', value: 6367 },\n                { name: 'Palette', value: 1229 },\n                { name: 'ShapePalette', value: 2059 },\n                { name: 'valuePalette', value: 2291 }\n              ]\n            },\n            {\n              name: 'math',\n              children: [\n                { name: 'DenseMatrix', value: 3165 },\n                { name: 'IMatrix', value: 2815 },\n                { name: 'SparseMatrix', value: 3366 }\n              ]\n            },\n            {\n              name: 'heap',\n              children: [\n                { name: 'FibonacciHeap', value: 9354 },\n                { name: 'HeapNode', value: 1233 }\n              ]\n            },\n            { name: 'Arrays', value: 8258 },\n            { name: 'Colors', value: 10001 },\n            { name: 'Dates', value: 8217 },\n            { name: 'Displays', value: 12555 },\n            { name: 'Filter', value: 2324 },\n            { name: 'Geometry', value: 10993 },\n            { name: 'IEvaluable', value: 335 },\n            { name: 'IPredicate', value: 383 },\n            { name: 'IValueProxy', value: 874 },\n            { name: 'Maths', value: 17705 },\n            { name: 'Orientation', value: 1486 },\n            { name: 'Property', value: 5559 },\n            { name: 'Shapes', value: 19118 },\n            { name: 'Sort', value: 6887 },\n            { name: 'Stats', value: 6557 },\n            { name: 'Strings', value: 22026 }\n          ]\n        },\n        {\n          name: 'animate',\n          children: [\n            {\n              name: 'interpolate',\n              children: [\n                { name: 'ArrayInterpolator', value: 1983 },\n                { name: 'ColorInterpolator', value: 2047 },\n                { name: 'DateInterpolator', value: 1375 },\n                { name: 'Interpolator', value: 8746 },\n                { name: 'MatrixInterpolator', value: 2202 },\n                { name: 'NumberInterpolator', value: 1382 },\n                { name: 'ObjectInterpolator', value: 1629 },\n                { name: 'PointInterpolator', value: 1675 },\n                { name: 'RectangleInterpolator', value: 2042 }\n              ]\n            },\n            { name: 'Easing', value: 17010 },\n            { name: 'FunctionSequence', value: 5842 },\n            { name: 'ISchedulable', value: 1041 },\n            { name: 'Parallel', value: 5176 },\n            { name: 'Pause', value: 449 },\n            { name: 'Scheduler', value: 5593 },\n            { name: 'Sequence', value: 5534 },\n            { name: 'Transition', value: 9201 },\n            { name: 'Transitioner', value: 19975 },\n            { name: 'TransitionEvent', value: 1116 },\n            { name: 'Tween', value: 6006 }\n          ]\n        },\n        {\n          name: 'scale',\n          children: [\n            { name: 'IScaleMap', value: 2105 },\n            { name: 'LinearScale', value: 1316 },\n            { name: 'LogScale', value: 3151 },\n            { name: 'OrdinalScale', value: 3770 },\n            { name: 'QuantileScale', value: 2435 },\n            { name: 'QuantitativeScale', value: 4839 },\n            { name: 'RootScale', value: 1756 },\n            { name: 'Scale', value: 4268 },\n            { name: 'ScaleType', value: 1821 },\n            { name: 'TimeScale', value: 5833 }\n          ]\n        },\n        {\n          name: 'physics',\n          children: [\n            { name: 'DragForce', value: 1082 },\n            { name: 'GravityForce', value: 1336 },\n            { name: 'IForce', value: 319 },\n            { name: 'NBodyForce', value: 10498 },\n            { name: 'Particle', value: 2822 },\n            { name: 'Simulation', value: 9983 },\n            { name: 'Spring', value: 2213 },\n            { name: 'SpringForce', value: 1681 }\n          ]\n        },\n        {\n          name: 'data',\n          children: [\n            {\n              name: 'converters',\n              children: [\n                { name: 'Converters', value: 721 },\n                { name: 'DelimitedTextConverter', value: 4294 },\n                { name: 'GraphMLConverter', value: 9800 },\n                { name: 'IDataConverter', value: 1314 },\n                { name: 'JSONConverter', value: 2220 }\n              ]\n            },\n            { name: 'DataField', value: 1759 },\n            { name: 'DataSchema', value: 2165 },\n            { name: 'DataSet', value: 586 },\n            { name: 'DataSource', value: 3331 },\n            { name: 'DataTable', value: 772 },\n            { name: 'DataUtil', value: 3322 }\n          ]\n        },\n        {\n          name: 'vis',\n          children: [\n            {\n              name: 'controls',\n              children: [\n                { name: 'AnchorControl', value: 2138 },\n                { name: 'ClickControl', value: 3824 },\n                { name: 'Control', value: 1353 },\n                { name: 'ControlList', value: 4665 },\n                { name: 'DragControl', value: 2649 },\n                { name: 'ExpandControl', value: 2832 },\n                { name: 'HoverControl', value: 4896 },\n                { name: 'IControl', value: 763 },\n                { name: 'PanZoomControl', value: 5222 },\n                { name: 'SelectionControl', value: 7862 },\n                { name: 'TooltipControl', value: 8435 }\n              ]\n            },\n            {\n              name: 'operator',\n              children: [\n                {\n                  name: 'layout',\n                  children: [\n                    { name: 'AxisLayout', value: 6725 },\n                    { name: 'BundledEdgeRouter', value: 3727 },\n                    { name: 'CircleLayout', value: 9317 },\n                    { name: 'CirclePackingLayout', value: 12003 },\n                    { name: 'DendrogramLayout', value: 4853 },\n                    { name: 'ForceDirectedLayout', value: 8411 },\n                    { name: 'IcicleTreeLayout', value: 4864 },\n                    { name: 'IndentedTreeLayout', value: 3174 },\n                    { name: 'Layout', value: 7881 },\n                    { name: 'NodeLinkTreeLayout', value: 12870 },\n                    { name: 'PieLayout', value: 2728 },\n                    { name: 'RadialTreeLayout', value: 12348 },\n                    { name: 'RandomLayout', value: 870 },\n                    { name: 'StackedAreaLayout', value: 9121 },\n                    { name: 'TreeMapLayout', value: 9191 }\n                  ]\n                },\n                {\n                  name: 'encoder',\n                  children: [\n                    { name: 'ColorEncoder', value: 3179 },\n                    { name: 'Encoder', value: 4060 },\n                    { name: 'PropertyEncoder', value: 4138 },\n                    { name: 'ShapeEncoder', value: 1690 },\n                    { name: 'valueEncoder', value: 1830 }\n                  ]\n                },\n                {\n                  name: 'distortion',\n                  children: [\n                    { name: 'BifocalDistortion', value: 4461 },\n                    { name: 'Distortion', value: 6314 },\n                    { name: 'FisheyeDistortion', value: 3444 }\n                  ]\n                },\n                {\n                  name: 'filter',\n                  children: [\n                    { name: 'FisheyeTreeFilter', value: 5219 },\n                    { name: 'GraphDistanceFilter', value: 3165 },\n                    { name: 'VisibilityFilter', value: 3509 }\n                  ]\n                },\n                {\n                  name: 'label',\n                  children: [\n                    { name: 'Labeler', value: 9956 },\n                    { name: 'RadialLabeler', value: 3899 },\n                    { name: 'StackedAreaLabeler', value: 3202 }\n                  ]\n                },\n                { name: 'IOperator', value: 1286 },\n                { name: 'Operator', value: 2490 },\n                { name: 'OperatorList', value: 5248 },\n                { name: 'OperatorSequence', value: 4190 },\n                { name: 'OperatorSwitch', value: 2581 },\n                { name: 'SortOperator', value: 2023 }\n              ]\n            },\n            {\n              name: 'data',\n              children: [\n                {\n                  name: 'render',\n                  children: [\n                    { name: 'ArrowType', value: 698 },\n                    { name: 'EdgeRenderer', value: 5569 },\n                    { name: 'IRenderer', value: 353 },\n                    { name: 'ShapeRenderer', value: 2247 }\n                  ]\n                },\n                { name: 'Data', value: 20544 },\n                { name: 'DataList', value: 19788 },\n                { name: 'DataSprite', value: 10349 },\n                { name: 'EdgeSprite', value: 3301 },\n                { name: 'NodeSprite', value: 19382 },\n                { name: 'ScaleBinding', value: 11275 },\n                { name: 'Tree', value: 7147 },\n                { name: 'TreeBuilder', value: 9930 }\n              ]\n            },\n            {\n              name: 'axis',\n              children: [\n                { name: 'Axes', value: 1302 },\n                { name: 'Axis', value: 24593 },\n                { name: 'AxisGridLine', value: 652 },\n                { name: 'AxisLabel', value: 636 },\n                { name: 'CartesianAxes', value: 6703 }\n              ]\n            },\n            {\n              name: 'events',\n              children: [\n                { name: 'DataEvent', value: 2313 },\n                { name: 'SelectionEvent', value: 1880 },\n                { name: 'TooltipEvent', value: 1701 },\n                { name: 'VisualizationEvent', value: 1117 }\n              ]\n            },\n            {\n              name: 'legend',\n              children: [\n                { name: 'Legend', value: 20859 },\n                { name: 'LegendItem', value: 4614 },\n                { name: 'LegendRange', value: 10530 }\n              ]\n            },\n            { name: 'Visualization', value: 16540 }\n          ]\n        },\n        {\n          name: 'display',\n          children: [\n            { name: 'DirtySprite', value: 8833 },\n            { name: 'LineSprite', value: 1732 },\n            { name: 'RectSprite', value: 3623 },\n            { name: 'TextSprite', value: 10066 }\n          ]\n        },\n        {\n          name: 'analytics',\n          children: [\n            {\n              name: 'graph',\n              children: [\n                { name: 'BetweennessCentrality', value: 3534 },\n                { name: 'LinkDistance', value: 5731 },\n                { name: 'MaxFlowMinCut', value: 7840 },\n                { name: 'ShortestPaths', value: 5914 },\n                { name: 'SpanningTree', value: 3416 }\n              ]\n            },\n            {\n              name: 'cluster',\n              children: [\n                { name: 'AgglomerativeCluster', value: 3938 },\n                { name: 'CommunityStructure', value: 3812 },\n                { name: 'HierarchicalCluster', value: 6714 },\n                { name: 'MergeEdge', value: 743 }\n              ]\n            },\n            {\n              name: 'optimization',\n              children: [{ name: 'AspectRatioBanker', value: 7074 }]\n            }\n          ]\n        },\n        { name: 'flex', children: [{ name: 'FlareVis', value: 4116 }] }\n      ]\n    }\n  ],\n  categoryField: 'name',\n  valueField: 'value',\n  label: {\n    visible: true,\n    style: {\n      fontSize: 12\n    }\n  },\n  title: {\n    visible: true,\n    text: 'The software class hierarchy of the Flare visualization toolkit'\n  },\n  leaf:{ \n    state: { \n      selected:{ \n        // set fill\n        fill:'red', \n        fillOpacity:0.8, \n\n        // set size\n        scaleX:1.1, \n        scaleY:1.1, \n        scaleCenter:['50%','50%'], \n\n        // set border\n        stroke:'blue', \n        lineWidth:2,\n\n        zIndex:1000, \n      } \n    } \n  },\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/treemap-state-26zg34?file=%2Fsrc%2Findex.ts%3A389%2C13</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/BpogbYL6Cox07Zxqhogcm56ynjf.gif' alt='' width='1504' height='1008'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n树图教程: https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Treemap</br>\r\n图元状态教程：https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Mark</br>\r\n相关api：https://www.visactor.io/vchart/option/treemapChart#leaf.state</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '72-How to set column width in bar chart.md',
    content:
      "# 柱状图如何设置柱子宽度？\n\n## 问题描述\n\n因为数据数量不确定，数据太少时柱状图柱子太宽不符合设计稿，怎么配置可以将柱子的宽度变窄？同时当数据很多的时候，柱子可以保持原本的宽度。\n\n## 解决方案\n\nVChart 的 柱图提供了可以设置柱子的宽度的配置项\n\n1. bandWidth 直接设置柱子的宽度\n2. barMinWidth 柱子的最小宽度\n3. barMaxWidth 柱子的最大宽度\n\n这个需求应该可以用 barMaxWidth 去解决，设置为设计稿中的最大宽度就可以了。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 }\n      ]\n    }\n  ],\n  barMinWidth: 20,\n  xField: 'month',\n  yField: 'sales',\n  barMaxWidth: 50\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [柱状图配置](https://www.visactor.io/vchart/option/barChart#barWidth)\n"
  },
  {
    fileName: "73- In the vchart library, why does the area chart's Y-axis display lower values higher.md",
    content:
      "---\ntitle: 12. vchart图表库中面积图Y轴展示异常，数值低的反而更高</br>\n---\r\n# 问题标题\r\n\r\nvchart图表库中面积图Y轴展示异常的问题</br>\r\n\r\n\r\n#  问题描述\r\n\r\n我在使用vchart图表库中绘制面积图时，发现Y轴展示的数值异常，即数值较低的图形反而在视觉上更高。比如，我有两个数据点，一个为2.8w，一个为3w6，但是在图表上，3w6反而比2.8w看起来更短。这个现象我无法理解，也不知道该如何解决，影响了用户使用。</br>\r\n```\n{\n  type: 'area',\n  data: {\n    fields: {\n      country: {\n        domain: ['China', 'USA', 'EU', 'Africa'],\n        sortIndex: 0\n      }\n    },\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: 'Stacked area chart of cosmetic products sales'\n  },\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  tooltip: {\n    dimension: {\n      updateContent: data => {\n        let sum = 0;\n        data.forEach(datum => {\n          sum += +datum.value;\n        });\n        data.push({\n          hasShape: 'false',\n          key: 'Total',\n          value: sum\n        });\n        return data;\n      }\n    }\n  }\n};</br>\n```\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WfVEblhSioelDgxOrnVcYfCXnkc.gif' alt='' width='1404' height='618'>\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/AaCLb9daJoztjkxEKzlc2kPCn1d.gif' alt='' width='1458' height='594'>\r\n\r\n# 解决方案\r\n\r\n解决这个问题的关键在于vchart图表库面积图中的堆叠功能。原来我误判了，以为是数据点被采样了所导致的显示问题，然后经过仔细观察，才发现是因为面积图开启了堆叠的原因。</br>\r\n\r\n\r\n首先，需要明确堆叠在面积图中的作用。堆叠功能开启后，不同的数据系列的值会累积起来。如果你想要显示的是两个数据系列之间的差异或者对比，那么就不应该开启堆叠。但是如果你想要展示的是一个整体趋势，而这个趋势是由两个或者多个成分组成，那么就需要开启堆叠。所以，该不该开启堆叠，要看你的可视化需求。</br>\r\n\r\n\r\n在面积图中，默认情况下是开启了堆叠的。如果你觉得这会影响到图形的解读，可以选择关闭。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Onwgbd7SsoqKSHxQADhcEb4JnIv.gif' alt='' width='2070' height='592'>\r\n\r\n```\n{\n  type: 'area',\n  //...省略spec其余部分\n  title: {\n    visible: true,\n    text: 'Stacked area chart of cosmetic products sales'\n  },\n  stack: false,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }]\n}; </br>\n```\r\n# 结果展示\r\n\r\n关闭堆叠后，图形的Y轴数值会按照实际的数值大小进行展示，不会再出现数值较低的图形反而在视觉上更高的现象。</br>\r\n在线效果参考：https://codesandbox.io/p/sandbox/line-chart-shows-on-the-left-most-of-canvas-forked-kgj8sj</br>\r\n\r\n\r\n#  相关文档\r\n\r\n相关API：https://visactor.bytedance.net/vchart/option/areaChart#stack</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '74- How to adjust bar spacing in a bar chart.md',
    content:
      "---\ntitle: 7. 如何调整柱状图的柱间距</br>\n---\r\n## 问题标题\r\n\r\n如何调整柱状图的柱间距</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如何调整柱状图的柱间距？</br>\r\n\r\n\r\n## 解决方案 \r\n\r\n在 VChart 上提供了如下配置用于调整柱子间距：</br>\r\n1. `axes` 配置上，为 `type: 'band'` 类型的轴提供了 [`paddingInner`](https%3A%2F%2Fvisactor.io%2Fvchart%2Foption%2FbarChart-axes-band%23paddingInner(number%257Cnumber%255B%255D)) 和 [`paddingOuter`](https%3A%2F%2Fvisactor.io%2Fvchart%2Foption%2FbarChart-axes-band%23paddingOuter(number%257Cnumber%255B%255D)) 属性，用于配置组内和组外间距</br>\r\n1. 对于分组柱图，还可以使用 [`**barGapInGroup**`](https%3A%2F%2Fvisactor.io%2Fvchart%2Foption%2FbarChart%23barGapInGroup)** **属性调整分组柱图中各个分组内的柱子间距，可以设置绝对的像素值，也可以使用百分比（如 '10%'）。</br>\r\n## 代码示例  \r\n\r\n### `barGapInGroup`\r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'Autocracies', year: '1930', value: 129 },\n        { type: 'Autocracies', year: '1940', value: 133 },\n        { type: 'Autocracies', year: '1950', value: 130 },\n        { type: 'Autocracies', year: '1960', value: 126 },\n        { type: 'Autocracies', year: '1970', value: 117 },\n        { type: 'Autocracies', year: '1980', value: 114 },\n        { type: 'Autocracies', year: '1990', value: 111 },\n        { type: 'Autocracies', year: '2000', value: 89 },\n        { type: 'Autocracies', year: '2010', value: 80 },\n        { type: 'Autocracies', year: '2018', value: 80 },\n        { type: 'Democracies', year: '1930', value: 22 },\n        { type: 'Democracies', year: '1940', value: 13 },\n        { type: 'Democracies', year: '1950', value: 25 },\n        { type: 'Democracies', year: '1960', value: 29 },\n        { type: 'Democracies', year: '1970', value: 38 },\n        { type: 'Democracies', year: '1980', value: 41 },\n        { type: 'Democracies', year: '1990', value: 57 },\n        { type: 'Democracies', year: '2000', value: 87 },\n        { type: 'Democracies', year: '2010', value: 98 },\n        { type: 'Democracies', year: '2018', value: 99 }\n      ]\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  legends: {\n    visible: true,\n    orient: 'top',\n    position: 'start'\n  },\n  barWidth: 10,\n  barGapInGroup: 0\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n### `paddingInner`\r\n\r\n```\nconst spec = {\n  type: 'bar',\n  color: ['#becef3', '#6a8edc', '#77caeb', '#52c93b', '#d3f5e8'],\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'A', year: '2000', value: 25 },\n        { type: 'A', year: '2010', value: 28 },\n        { type: 'A', year: '2018', value: 18 },\n        { type: 'B', year: '2000', value: 23 },\n        { type: 'B', year: '2010', value: 32 },\n        { type: 'B', year: '2018', value: 22 },\n        { type: 'C', year: '2000', value: 18 },\n        { type: 'C', year: '2010', value: 18 },\n        { type: 'C', year: '2018', value: 18 },\n        { type: 'D', year: '2000', value: 15 },\n        { type: 'D', year: '2010', value: 22 },\n        { type: 'D', year: '2018', value: 19 },\n        { type: 'E', year: '2000', value: 5 },\n        { type: 'E', year: '2010', value: 12 },\n        { type: 'E', year: '2018', value: 5 }\n      ]\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  axes: [\n    {\n      orient: 'bottom',\n      paddingInner: 0.3\n    }\n  ],\n  bar: {\n    style: {\n      fillOpacity: 0.9\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n*  使用 `barGapInGroup`: https://visactor.io/vchart/demo/bar-chart/group-bar-with-barGapInGroup</br>\r\n*  使用 `paddingInner`: https://visactor.io/vchart/demo/bar-chart/group-bar-with-padding</br>\r\n\r\n\r\n## 相关文档\r\n\r\ndemo：</br>\r\nhttps://visactor.io/vchart/demo/bar-chart/group-bar-with-barGapInGroup , </br>\r\nhttps://visactor.io/vchart/demo/bar-chart/group-bar-with-padding</br>\r\nAPI：</br>\r\nhttps://visactor.io/vchart/option/barChart-axes-band#paddingInner(number%7Cnumber%5B%5D)</br>\r\nhttps://visactor.io/vchart/option/barChart-axes-band#paddingOuter(number%7Cnumber%5B%5D)</br>\r\nhttps://visactor.io/vchart/option/barChart#barGapInGroup</br>\r\ngithub：github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '75-How to display the legend title and legend with left-right separation in the same row.md',
    content:
      "# 如何实现图例的标题和 图例左右分开显示？\n\n## 问题描述\n\n我想给图例新增一些文字描述，期望在图表底部新增一个图例和图例的文字描述。预期的布局效果是，文字左对齐，图例右对齐，并且文字和图例在同一行。\n有什么图表库可以实现这种比较特殊定制的逻辑吗？\n\n## 解决方案\n\nVChart 的图例组件和标题组件提供了绝对定位的布局方式，通过设置 `layoutType:'absolute'`即可开启该布局模式。\n随后为图表设置足够的 padding，将标题组件放在左下角，图例组件放在右下角，即可实现让图例的标题和图例左右分开显示。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'Autocracies', year: '1930', value: 129 },\n        { type: 'Autocracies', year: '1940', value: 133 },\n        { type: 'Autocracies', year: '1950', value: 130 },\n        { type: 'Autocracies', year: '1960', value: 126 },\n        { type: 'Autocracies', year: '1970', value: 117 },\n        { type: 'Autocracies', year: '1980', value: 114 },\n        { type: 'Autocracies', year: '1990', value: 111 },\n        { type: 'Autocracies', year: '2000', value: 89 },\n        { type: 'Autocracies', year: '2010', value: 80 },\n        { type: 'Autocracies', year: '2018', value: 80 },\n        { type: 'Democracies', year: '1930', value: 22 },\n        { type: 'Democracies', year: '1940', value: 13 },\n        { type: 'Democracies', year: '1950', value: 25 },\n        { type: 'Democracies', year: '1960', value: 29 },\n        { type: 'Democracies', year: '1970', value: 38 },\n        { type: 'Democracies', year: '1980', value: 41 },\n        { type: 'Democracies', year: '1990', value: 57 },\n        { type: 'Democracies', year: '2000', value: 87 },\n        { type: 'Democracies', year: '2010', value: 98 },\n        { type: 'Democracies', year: '2018', value: 99 }\n      ]\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  padding: [12, 12, 40, 12],\n  legends: {\n    visible: true,\n    orient: 'top',\n    position: 'start',\n    layoutType: 'absolute',\n    bottom: -40,\n    right: 12,\n    padding: 0\n  },\n  title: {\n    visible: true,\n    text: 'Two Series Category',\n    layoutType: 'absolute',\n    bottom: -40,\n    left: 12,\n    textStyle: {\n      fontSize: 12\n    },\n    padding: 0\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [VChart 标题组件配置文档](https://visactor.io/vchart/option/barChart#title.layoutType)\n- [VChart 图例组件配置文档](https://visactor.io/vchart/option/barChart-legends-discrete#layoutType)\n"
  },
  {
    fileName: '76-How do I set the scrollbars for the common chart.md',
    content:
      "# 组合图滚动条如何设置？\n\n## 问题描述\n\n类似 （https://www.visactor.io/vchart/demo/combination/col-line）这样的组合图，通常有多个轴或多个数据区域，我应该如何配置滚动条从而使其控制指定区域的滚动？\n[common chart scrollbar](/vchart/faq/11-0.png)\n\n## 解决方案\n\n对于简单的组合图而言，您可以像普通图表一样声明滚动条，只需声明表示位置的属性`scrollBar.orient`和表示视口范围的属性`scrollBar.start`和`scrollBar.end`即可，如下图所示：\n[common chart scrollbar](/vchart/faq/11-1.png)\n\n而对于复杂图表而言，您需要两个配置步骤：\n\n1. 为滚动条绑定坐标轴：\n   通过`scrollBar.axisIndex`或`scrollBar.axisId`将滚动条与坐标轴进行关联，方可基于坐标轴进行数据筛选或图元范围滚动操作。\n2. 为滚动条声明布局位置：\n   您图中涉及的图表是基于 grid 布局绘制的，所以需要定义滚动条的布局位置。\n\n- 首先，需要在`grid.row`的行数声明中添加一行用于放置横向滚动。\n- 其次，需要在`grid.elements`中声明滚动条的布局信息\n\n```ts\n  {\n    modelId: 'scrollBar', // id\n    col: 0, // col index\n    row: 6 // row index\n  },\n```\n\n- 最后，需要将 scrollBar.id 与 grid.elements 中的 modelId 对应起来。\n\n```ts\nscrollBar: [\n  {\n    orient: 'bottom',\n    axisIndex: 4,\n    id: 'scrollBar',\n    start: 0,\n    end: 0.4\n  }\n];\n```\n\n## 代码示例\n\n```javascript livedemo\nconst leftAxesCommonSpec = {\n  expand: { max: 0.2 },\n  label: { flush: true, visible: true },\n  tick: { visible: false },\n  forceTickCount: 3\n};\nconst spec = {\n  type: 'common',\n  layout: {\n    type: 'grid',\n    col: 2,\n    row: 7,\n    elements: [\n      {\n        modelId: 'legend',\n        col: 0,\n        colSpan: 2,\n        row: 6\n      },\n      {\n        modelId: 'scrollBar',\n        col: 0,\n        colSpan: 2,\n        row: 5\n      },\n      {\n        modelId: 'Social Penetration',\n        col: 1,\n        row: 0\n      },\n      {\n        modelId: 'Engagement - Socialization',\n        col: 1,\n        row: 1\n      },\n      {\n        modelId: 'Penetration of Private Messages',\n        col: 1,\n        row: 2\n      },\n      {\n        modelId: 'Number of Private Messages per User',\n        col: 1,\n        row: 3\n      },\n      {\n        modelId: 'Social Penetrationleft',\n        col: 0,\n        row: 0\n      },\n      {\n        modelId: 'Engagement - Socialization-left',\n        col: 0,\n        row: 1\n      },\n      {\n        modelId: 'Penetration of Private Messagesleft',\n        col: 0,\n        row: 2\n      },\n      {\n        modelId: 'Number of Private Messages per Userleft',\n        col: 0,\n        row: 3\n      },\n      {\n        modelId: 'Number of Private Messages per User-bottom',\n        col: 1,\n        row: 4\n      }\n    ]\n  },\n  region: [\n    {\n      id: 'Social Penetration'\n    },\n    {\n      id: 'Engagement - Socialization'\n    },\n    {\n      id: 'Penetration of Private Messages'\n    },\n    {\n      id: 'Number of Private Messages per User'\n    }\n  ],\n  scrollBar: [\n    {\n      orient: 'bottom',\n      axisIndex: 4,\n      id: 'scrollBar',\n      start: 0,\n      end: 0.4,\n      filterMode: 'axis'\n    }\n  ],\n  legends: {\n    padding: {\n      top: 10\n    },\n    visible: true,\n    orient: 'bottom',\n    id: 'legend',\n    regionId: [\n      'Social Penetration',\n      'Engagement - Socialization',\n      'Penetration of Private Messages',\n      'Number of Private Messages per User'\n    ]\n  },\n  seriesField: 'type',\n  tooltip: {\n    dimension: {\n      title: {\n        value: datum => {\n          return `第 ${datum.x} 天`;\n        }\n      },\n      content: [\n        {\n          key: datum => datum.type,\n          value: datum => datum.y\n        }\n      ]\n    }\n  },\n  series: [\n    {\n      id: 'Social Penetrationseries0',\n      regionId: 'Social Penetration',\n      type: 'line',\n      data: { id: 'Social Penetration' },\n      xField: 'x',\n      yField: 'y'\n    },\n    {\n      id: 'Engagement - Socialization-series0',\n      regionId: 'Engagement - Socialization',\n      type: 'line',\n      data: { id: 'Engagement - Socialization' },\n      xField: 'x',\n      yField: 'y'\n    },\n    {\n      id: 'Penetration of Private Messagesseries0',\n      regionId: 'Penetration of Private Messages',\n      type: 'line',\n      data: { id: 'Penetration of Private Messages' },\n      xField: 'x',\n      yField: 'y'\n    },\n    {\n      id: 'Number of Private Messages per Userseries0',\n      regionId: 'Number of Private Messages per User',\n      type: 'line',\n      data: { id: 'Number of Private Messages per User' },\n      xField: 'x',\n      yField: 'y'\n    }\n  ],\n  axes: [\n    {\n      id: 'Social Penetrationleft',\n      regionId: 'Social Penetration',\n      orient: 'left',\n      title: { visible: true, text: 'SP' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Engagement - Socialization-left',\n      regionId: 'Engagement - Socialization',\n      orient: 'left',\n      title: { visible: true, text: 'ES' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Penetration of Private Messagesleft',\n      regionId: 'Penetration of Private Messages',\n      orient: 'left',\n      title: { visible: true, text: 'Penetration of PM' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Number of Private Messages per Userleft',\n      regionId: 'Number of Private Messages per User',\n      orient: 'left',\n      title: { visible: true, text: 'PM per User' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Number of Private Messages per User-bottom',\n      regionId: [\n        'Social Penetration',\n        'Engagement - Socialization',\n        'Penetration of Private Messages',\n        'Number of Private Messages per User'\n      ],\n      orient: 'bottom',\n      label: {\n        firstVisible: true,\n        lastVisible: true,\n        visible: true\n      },\n      tick: { visible: false },\n      paddingInner: 0.99,\n      paddingOuter: 0\n    }\n  ]\n};\nconst dataJson = {\n  'Social Penetration': [\n    {\n      x: 0,\n      y: 1.2020804451630671,\n      originXData: '2022-03-08',\n      type: 'Social Penetration'\n    },\n    {\n      x: 1,\n      y: 1.911162758594358,\n      originXData: '2022-03-09',\n      type: 'Social Penetration'\n    },\n    {\n      x: 2,\n      y: 0.919293523406533,\n      originXData: '2022-03-10',\n      type: 'Social Penetration'\n    },\n    {\n      x: 3,\n      y: 1.613617931982911,\n      originXData: '2022-03-11',\n      type: 'Social Penetration'\n    },\n    {\n      x: 4,\n      y: 1.121445896148114,\n      originXData: '2022-03-12',\n      type: 'Social Penetration'\n    },\n    {\n      x: 5,\n      y: 0.527369749651032,\n      originXData: '2022-03-13',\n      type: 'Social Penetration'\n    },\n    {\n      x: 6,\n      y: 0.07991167814791,\n      originXData: '2022-03-14',\n      type: 'Social Penetration'\n    },\n    {\n      x: 7,\n      y: 0.29341332300751205,\n      originXData: '2022-03-15',\n      type: 'Social Penetration'\n    },\n    {\n      x: 8,\n      y: 1.103150404211427,\n      originXData: '2022-03-16',\n      type: 'Social Penetration'\n    },\n    {\n      x: 9,\n      y: 0.38285701953593604,\n      originXData: '2022-03-17',\n      type: 'Social Penetration'\n    },\n    {\n      x: 10,\n      y: 0.8908005339482421,\n      originXData: '2022-03-18',\n      type: 'Social Penetration'\n    },\n    {\n      x: 11,\n      y: 0.8379933951719881,\n      originXData: '2022-03-19',\n      type: 'Social Penetration'\n    },\n    {\n      x: 12,\n      y: 2.913059895355856,\n      originXData: '2022-03-20',\n      type: 'Social Penetration'\n    },\n    {\n      x: 13,\n      y: 1.245523794769467,\n      originXData: '2022-03-21',\n      type: 'Social Penetration'\n    },\n    {\n      x: 14,\n      y: 1.801955367373218,\n      originXData: '2022-03-22',\n      type: 'Social Penetration'\n    },\n    {\n      x: 15,\n      y: 30.25170429439274,\n      originXData: '2022-03-23',\n      type: 'Social Penetration'\n    },\n    {\n      x: 16,\n      y: 2.084831170978463,\n      originXData: '2022-03-24',\n      type: 'Social Penetration'\n    },\n    {\n      x: 17,\n      y: 0.8300684679922911,\n      originXData: '2022-03-25',\n      type: 'Social Penetration'\n    },\n    {\n      x: 18,\n      y: 5.057522939533747,\n      originXData: '2022-03-26',\n      type: 'Social Penetration'\n    },\n    {\n      x: 19,\n      y: 1.364245041731511,\n      originXData: '2022-03-27',\n      type: 'Social Penetration'\n    },\n    {\n      x: 20,\n      y: 0.429699282814745,\n      originXData: '2022-03-28',\n      type: 'Social Penetration'\n    },\n    {\n      x: 21,\n      y: 8.636960050981939,\n      originXData: '2022-03-29',\n      type: 'Social Penetration'\n    },\n    {\n      x: 22,\n      y: 0.31233481070398905,\n      originXData: '2022-03-30',\n      type: 'Social Penetration'\n    },\n    {\n      x: 23,\n      y: 0.8979576483673781,\n      originXData: '2022-03-31',\n      type: 'Social Penetration'\n    },\n    {\n      x: 24,\n      y: 1.187326287404249,\n      originXData: '2022-04-01',\n      type: 'Social Penetration'\n    },\n    {\n      x: 25,\n      y: 0.013251966153457001,\n      originXData: '2022-04-02',\n      type: 'Social Penetration'\n    },\n    {\n      x: 26,\n      y: 0.150440921215681,\n      originXData: '2022-04-03',\n      type: 'Social Penetration'\n    },\n    {\n      x: 27,\n      y: 1.437865757864698,\n      originXData: '2022-04-04',\n      type: 'Social Penetration'\n    },\n    {\n      x: 28,\n      y: 19.70534531285437,\n      originXData: '2022-04-05',\n      type: 'Social Penetration'\n    },\n    {\n      x: 29,\n      y: 1.068708512330189,\n      originXData: '2022-04-06',\n      type: 'Social Penetration'\n    },\n    {\n      x: 30,\n      y: 3.239083103313066,\n      originXData: '2022-04-07',\n      type: 'Social Penetration'\n    },\n    {\n      x: 31,\n      y: 3.609669038457516,\n      originXData: '2022-04-08',\n      type: 'Social Penetration'\n    },\n    {\n      x: 32,\n      y: 0.8581543303200471,\n      originXData: '2022-04-09',\n      type: 'Social Penetration'\n    },\n    {\n      x: 33,\n      y: 1.235338424517758,\n      originXData: '2022-04-10',\n      type: 'Social Penetration'\n    },\n    {\n      x: 34,\n      y: 0.615560300356359,\n      originXData: '2022-04-11',\n      type: 'Social Penetration'\n    },\n    {\n      x: 35,\n      y: 3.5445165395901572,\n      originXData: '2022-04-12',\n      type: 'Social Penetration'\n    },\n    {\n      x: 36,\n      y: 1.037776502324676,\n      originXData: '2022-04-13',\n      type: 'Social Penetration'\n    },\n    {\n      x: 37,\n      y: 0.534866532613768,\n      originXData: '2022-04-14',\n      type: 'Social Penetration'\n    },\n    {\n      x: 38,\n      y: 3.225952049483959,\n      originXData: '2022-04-15',\n      type: 'Social Penetration'\n    },\n    {\n      x: 39,\n      y: 12.278592894400722,\n      originXData: '2022-04-16',\n      type: 'Social Penetration'\n    },\n    {\n      x: 40,\n      y: 0.411460847135642,\n      originXData: '2022-04-17',\n      type: 'Social Penetration'\n    },\n    {\n      x: 41,\n      y: 0.304818623987116,\n      originXData: '2022-04-18',\n      type: 'Social Penetration'\n    },\n    {\n      x: 42,\n      y: 0.8929797309154061,\n      originXData: '2022-04-19',\n      type: 'Social Penetration'\n    },\n    {\n      x: 43,\n      y: 4.074891060179412,\n      originXData: '2022-04-20',\n      type: 'Social Penetration'\n    },\n    {\n      x: 44,\n      y: 0.902423656543305,\n      originXData: '2022-04-21',\n      type: 'Social Penetration'\n    },\n    {\n      x: 45,\n      y: 0.868968791964932,\n      originXData: '2022-04-22',\n      type: 'Social Penetration'\n    },\n    {\n      x: 46,\n      y: 0.598986391584271,\n      originXData: '2022-04-23',\n      type: 'Social Penetration'\n    },\n    {\n      x: 47,\n      y: 0.27570721725353503,\n      originXData: '2022-04-24',\n      type: 'Social Penetration'\n    },\n    {\n      x: 48,\n      y: 0.38518667923696703,\n      originXData: '2022-04-25',\n      type: 'Social Penetration'\n    },\n    {\n      x: 49,\n      y: 0.622049495688147,\n      originXData: '2022-04-26',\n      type: 'Social Penetration'\n    },\n    {\n      x: 50,\n      y: 3.540727101774814,\n      originXData: '2022-04-27',\n      type: 'Social Penetration'\n    },\n    {\n      x: 51,\n      y: 2.742513433824975,\n      originXData: '2022-04-28',\n      type: 'Social Penetration'\n    },\n    {\n      x: 52,\n      y: 1.621566806821747,\n      originXData: '2022-04-29',\n      type: 'Social Penetration'\n    },\n    {\n      x: 53,\n      y: 2.352493741253538,\n      originXData: '2022-04-30',\n      type: 'Social Penetration'\n    },\n    {\n      x: 54,\n      y: 0.023487873849160002,\n      originXData: '2022-05-01',\n      type: 'Social Penetration'\n    },\n    {\n      x: 55,\n      y: 9.85187760463177,\n      originXData: '2022-05-02',\n      type: 'Social Penetration'\n    },\n    {\n      x: 56,\n      y: 6.3835439206943,\n      originXData: '2022-05-03',\n      type: 'Social Penetration'\n    },\n    {\n      x: 57,\n      y: 2.897597920598689,\n      originXData: '2022-05-04',\n      type: 'Social Penetration'\n    },\n    {\n      x: 58,\n      y: 0.147546385656207,\n      originXData: '2022-05-05',\n      type: 'Social Penetration'\n    },\n    {\n      x: 59,\n      y: 4.668438202775402,\n      originXData: '2022-05-06',\n      type: 'Social Penetration'\n    },\n    {\n      x: 60,\n      y: 1.868897716467347,\n      originXData: '2022-05-07',\n      type: 'Social Penetration'\n    },\n    {\n      x: 61,\n      y: 1.356875902669512,\n      originXData: '2022-05-08',\n      type: 'Social Penetration'\n    },\n    {\n      x: 62,\n      y: 1.029882775112869,\n      originXData: '2022-05-09',\n      type: 'Social Penetration'\n    },\n    {\n      x: 63,\n      y: 1.079419585437788,\n      originXData: '2022-05-10',\n      type: 'Social Penetration'\n    },\n    {\n      x: 64,\n      y: 0.43374835866466704,\n      originXData: '2022-05-11',\n      type: 'Social Penetration'\n    },\n    {\n      x: 65,\n      y: 0.6884004244125861,\n      originXData: '2022-05-12',\n      type: 'Social Penetration'\n    },\n    {\n      x: 66,\n      y: 0.5513219132650721,\n      originXData: '2022-05-13',\n      type: 'Social Penetration'\n    },\n    {\n      x: 67,\n      y: 0.26075436773203503,\n      originXData: '2022-05-14',\n      type: 'Social Penetration'\n    },\n    {\n      x: 68,\n      y: 3.534068370760441,\n      originXData: '2022-05-15',\n      type: 'Social Penetration'\n    },\n    {\n      x: 69,\n      y: 1.051684273070894,\n      originXData: '2022-05-16',\n      type: 'Social Penetration'\n    },\n    {\n      x: 70,\n      y: 0.8574030868970931,\n      originXData: '2022-05-17',\n      type: 'Social Penetration'\n    },\n    {\n      x: 71,\n      y: 0.515497463894879,\n      originXData: '2022-05-18',\n      type: 'Social Penetration'\n    },\n    {\n      x: 72,\n      y: 0.9592457438221671,\n      originXData: '2022-05-19',\n      type: 'Social Penetration'\n    },\n    {\n      x: 73,\n      y: 0.069882250377393,\n      originXData: '2022-05-20',\n      type: 'Social Penetration'\n    },\n    {\n      x: 74,\n      y: 10.360352568974609,\n      originXData: '2022-05-21',\n      type: 'Social Penetration'\n    },\n    {\n      x: 75,\n      y: 1.112796751785197,\n      originXData: '2022-05-22',\n      type: 'Social Penetration'\n    },\n    {\n      x: 76,\n      y: 4.891916669440483,\n      originXData: '2022-05-23',\n      type: 'Social Penetration'\n    },\n    {\n      x: 77,\n      y: 0.09534096170855301,\n      originXData: '2022-05-24',\n      type: 'Social Penetration'\n    },\n    {\n      x: 78,\n      y: 17.21160548866725,\n      originXData: '2022-05-25',\n      type: 'Social Penetration'\n    },\n    {\n      x: 79,\n      y: 0.9890377076819251,\n      originXData: '2022-05-26',\n      type: 'Social Penetration'\n    },\n    {\n      x: 80,\n      y: 1.207578684423282,\n      originXData: '2022-05-27',\n      type: 'Social Penetration'\n    },\n    {\n      x: 81,\n      y: 15.265265813052475,\n      originXData: '2022-05-28',\n      type: 'Social Penetration'\n    },\n    {\n      x: 82,\n      y: 1.667919015486645,\n      originXData: '2022-05-29',\n      type: 'Social Penetration'\n    },\n    {\n      x: 83,\n      y: 2.232083847244808,\n      originXData: '2022-05-30',\n      type: 'Social Penetration'\n    },\n    {\n      x: 84,\n      y: 1.113011174076138,\n      originXData: '2022-05-31',\n      type: 'Social Penetration'\n    },\n    {\n      x: 85,\n      y: 0.9839213173080511,\n      originXData: '2022-06-01',\n      type: 'Social Penetration'\n    },\n    {\n      x: 86,\n      y: 3.618368394111176,\n      originXData: '2022-06-02',\n      type: 'Social Penetration'\n    },\n    {\n      x: 87,\n      y: 1.5240830060491182,\n      originXData: '2022-06-03',\n      type: 'Social Penetration'\n    },\n    {\n      x: 88,\n      y: 0.7108355579615261,\n      originXData: '2022-06-04',\n      type: 'Social Penetration'\n    },\n    {\n      x: 89,\n      y: 1.842738679408876,\n      originXData: '2022-06-05',\n      type: 'Social Penetration'\n    },\n    {\n      x: 90,\n      y: 2.968986726243696,\n      originXData: '2022-06-06',\n      type: 'Social Penetration'\n    },\n    {\n      x: 91,\n      y: 0.30957106038382504,\n      originXData: '2022-06-07',\n      type: 'Social Penetration'\n    },\n    {\n      x: 92,\n      y: 3.077870353397237,\n      originXData: '2022-06-08',\n      type: 'Social Penetration'\n    },\n    {\n      x: 93,\n      y: 0.460474051903736,\n      originXData: '2022-06-09',\n      type: 'Social Penetration'\n    },\n    {\n      x: 94,\n      y: 0.9248894668614721,\n      originXData: '2022-06-10',\n      type: 'Social Penetration'\n    },\n    {\n      x: 95,\n      y: 0.5170229174882011,\n      originXData: '2022-06-11',\n      type: 'Social Penetration'\n    },\n    {\n      x: 96,\n      y: 1.343310704782682,\n      originXData: '2022-06-12',\n      type: 'Social Penetration'\n    },\n    {\n      x: 97,\n      y: 4.213284444567541,\n      originXData: '2022-06-13',\n      type: 'Social Penetration'\n    },\n    {\n      x: 98,\n      y: 0.718083714760927,\n      originXData: '2022-06-14',\n      type: 'Social Penetration'\n    },\n    {\n      x: 99,\n      y: 2.443370806389791,\n      originXData: '2022-06-15',\n      type: 'Social Penetration'\n    },\n    {\n      x: 100,\n      y: 3.594231845735735,\n      originXData: '2022-06-16',\n      type: 'Social Penetration'\n    },\n    {\n      x: 101,\n      y: 1.113951398490715,\n      originXData: '2022-06-17',\n      type: 'Social Penetration'\n    },\n    {\n      x: 102,\n      y: 0.5614439322266921,\n      originXData: '2022-06-18',\n      type: 'Social Penetration'\n    },\n    {\n      x: 103,\n      y: 1.243458727745012,\n      originXData: '2022-06-19',\n      type: 'Social Penetration'\n    },\n    {\n      x: 104,\n      y: 1.31005897849395,\n      originXData: '2022-06-20',\n      type: 'Social Penetration'\n    },\n    {\n      x: 105,\n      y: 0.572744269459053,\n      originXData: '2022-06-21',\n      type: 'Social Penetration'\n    },\n    {\n      x: 106,\n      y: 24.581669047338767,\n      originXData: '2022-06-22',\n      type: 'Social Penetration'\n    },\n    {\n      x: 107,\n      y: 0.47413969565051606,\n      originXData: '2022-06-23',\n      type: 'Social Penetration'\n    },\n    {\n      x: 108,\n      y: 0.43416765009011604,\n      originXData: '2022-06-24',\n      type: 'Social Penetration'\n    },\n    {\n      x: 109,\n      y: 0.943163264857342,\n      originXData: '2022-06-25',\n      type: 'Social Penetration'\n    },\n    {\n      x: 110,\n      y: 0.233205152479134,\n      originXData: '2022-06-26',\n      type: 'Social Penetration'\n    },\n    {\n      x: 111,\n      y: 3.9663605369632933,\n      originXData: '2022-06-27',\n      type: 'Social Penetration'\n    },\n    {\n      x: 112,\n      y: 0.016605232459512002,\n      originXData: '2022-06-28',\n      type: 'Social Penetration'\n    },\n    {\n      x: 113,\n      y: 1.374134760412724,\n      originXData: '2022-06-29',\n      type: 'Social Penetration'\n    },\n    {\n      x: 114,\n      y: 0.715486103147415,\n      originXData: '2022-06-30',\n      type: 'Social Penetration'\n    },\n    {\n      x: 115,\n      y: 0.747532331413809,\n      originXData: '2022-07-01',\n      type: 'Social Penetration'\n    },\n    {\n      x: 116,\n      y: 0.8670766655477491,\n      originXData: '2022-07-02',\n      type: 'Social Penetration'\n    },\n    {\n      x: 117,\n      y: 0.392542368674532,\n      originXData: '2022-07-03',\n      type: 'Social Penetration'\n    },\n    {\n      x: 118,\n      y: 2.354765436840968,\n      originXData: '2022-07-04',\n      type: 'Social Penetration'\n    },\n    {\n      x: 119,\n      y: 0.25059554847566,\n      originXData: '2022-07-05',\n      type: 'Social Penetration'\n    },\n    {\n      x: 120,\n      y: 4.720665637767317,\n      originXData: '2022-07-06',\n      type: 'Social Penetration'\n    },\n    {\n      x: 121,\n      y: 0.646476205877439,\n      originXData: '2022-07-07',\n      type: 'Social Penetration'\n    },\n    {\n      x: 122,\n      y: 4.428354777598469,\n      originXData: '2022-07-08',\n      type: 'Social Penetration'\n    },\n    {\n      x: 123,\n      y: 1.502467804494858,\n      originXData: '2022-07-09',\n      type: 'Social Penetration'\n    },\n    {\n      x: 124,\n      y: 11.706734521216822,\n      originXData: '2022-07-10',\n      type: 'Social Penetration'\n    },\n    {\n      x: 125,\n      y: 1.153083534578196,\n      originXData: '2022-07-11',\n      type: 'Social Penetration'\n    },\n    {\n      x: 126,\n      y: 1.4863362021332551,\n      originXData: '2022-07-12',\n      type: 'Social Penetration'\n    },\n    {\n      x: 127,\n      y: 1.61896686341972,\n      originXData: '2022-07-13',\n      type: 'Social Penetration'\n    },\n    {\n      x: 128,\n      y: 49.60818750100216,\n      originXData: '2022-07-14',\n      type: 'Social Penetration'\n    },\n    {\n      x: 129,\n      y: 1.785205883890873,\n      originXData: '2022-07-15',\n      type: 'Social Penetration'\n    },\n    {\n      x: 130,\n      y: 0.715594243310775,\n      originXData: '2022-07-16',\n      type: 'Social Penetration'\n    },\n    {\n      x: 131,\n      y: 0.8147430610328651,\n      originXData: '2022-07-17',\n      type: 'Social Penetration'\n    },\n    {\n      x: 132,\n      y: 1.24545618431753,\n      originXData: '2022-07-18',\n      type: 'Social Penetration'\n    },\n    {\n      x: 133,\n      y: 0.083915091025848,\n      originXData: '2022-07-19',\n      type: 'Social Penetration'\n    },\n    {\n      x: 134,\n      y: 0.32701962372413,\n      originXData: '2022-07-20',\n      type: 'Social Penetration'\n    },\n    {\n      x: 135,\n      y: 0.722041044814348,\n      originXData: '2022-07-21',\n      type: 'Social Penetration'\n    },\n    {\n      x: 136,\n      y: 10.662811760936936,\n      originXData: '2022-07-22',\n      type: 'Social Penetration'\n    },\n    {\n      x: 137,\n      y: 0.364677770561312,\n      originXData: '2022-07-23',\n      type: 'Social Penetration'\n    },\n    {\n      x: 138,\n      y: 0.9157754804402811,\n      originXData: '2022-07-24',\n      type: 'Social Penetration'\n    },\n    {\n      x: 139,\n      y: 0.67849525511577,\n      originXData: '2022-07-25',\n      type: 'Social Penetration'\n    },\n    {\n      x: 140,\n      y: 1.330066578741473,\n      originXData: '2022-07-26',\n      type: 'Social Penetration'\n    },\n    {\n      x: 141,\n      y: 5.686664774275858,\n      originXData: '2022-07-27',\n      type: 'Social Penetration'\n    },\n    {\n      x: 142,\n      y: 0.22324041916141402,\n      originXData: '2022-07-28',\n      type: 'Social Penetration'\n    },\n    {\n      x: 143,\n      y: 2.476037411183793,\n      originXData: '2022-07-29',\n      type: 'Social Penetration'\n    },\n    {\n      x: 144,\n      y: 0.773637653847835,\n      originXData: '2022-07-30',\n      type: 'Social Penetration'\n    },\n    {\n      x: 145,\n      y: 0.169152723468269,\n      originXData: '2022-07-31',\n      type: 'Social Penetration'\n    },\n    {\n      x: 146,\n      y: 1.519627178758216,\n      originXData: '2022-08-01',\n      type: 'Social Penetration'\n    },\n    {\n      x: 147,\n      y: 3.545652606242915,\n      originXData: '2022-08-02',\n      type: 'Social Penetration'\n    },\n    {\n      x: 148,\n      y: 1.3404062798488199,\n      originXData: '2022-08-03',\n      type: 'Social Penetration'\n    },\n    {\n      x: 149,\n      y: 0.6530263834012761,\n      originXData: '2022-08-04',\n      type: 'Social Penetration'\n    },\n    {\n      x: 150,\n      y: 0.708729075421144,\n      originXData: '2022-08-05',\n      type: 'Social Penetration'\n    },\n    {\n      x: 151,\n      y: 11.986631123295103,\n      originXData: '2022-08-06',\n      type: 'Social Penetration'\n    },\n    {\n      x: 152,\n      y: 1.232939713701664,\n      originXData: '2022-08-07',\n      type: 'Social Penetration'\n    },\n    {\n      x: 153,\n      y: 0.530813431405317,\n      originXData: '2022-08-08',\n      type: 'Social Penetration'\n    },\n    {\n      x: 154,\n      y: 2.510188659097596,\n      originXData: '2022-08-09',\n      type: 'Social Penetration'\n    },\n    {\n      x: 155,\n      y: 1.622456744339298,\n      originXData: '2022-08-10',\n      type: 'Social Penetration'\n    },\n    {\n      x: 156,\n      y: 0.25962103068208003,\n      originXData: '2022-08-11',\n      type: 'Social Penetration'\n    },\n    {\n      x: 157,\n      y: 0.884113805589634,\n      originXData: '2022-08-12',\n      type: 'Social Penetration'\n    },\n    {\n      x: 158,\n      y: 8.624685230360152,\n      originXData: '2022-08-13',\n      type: 'Social Penetration'\n    },\n    {\n      x: 159,\n      y: 1.6498217904306332,\n      originXData: '2022-08-14',\n      type: 'Social Penetration'\n    },\n    {\n      x: 160,\n      y: 5.840124155766275,\n      originXData: '2022-08-15',\n      type: 'Social Penetration'\n    },\n    {\n      x: 161,\n      y: 2.405030143824614,\n      originXData: '2022-08-16',\n      type: 'Social Penetration'\n    },\n    {\n      x: 162,\n      y: 1.034391306438299,\n      originXData: '2022-08-17',\n      type: 'Social Penetration'\n    },\n    {\n      x: 163,\n      y: 4.703412413763946,\n      originXData: '2022-08-18',\n      type: 'Social Penetration'\n    },\n    {\n      x: 164,\n      y: 0.22138733877979702,\n      originXData: '2022-08-19',\n      type: 'Social Penetration'\n    },\n    {\n      x: 165,\n      y: 0.14621922149563202,\n      originXData: '2022-08-20',\n      type: 'Social Penetration'\n    },\n    {\n      x: 166,\n      y: 5.702011116768989,\n      originXData: '2022-08-21',\n      type: 'Social Penetration'\n    },\n    {\n      x: 167,\n      y: 2.289251748782675,\n      originXData: '2022-08-22',\n      type: 'Social Penetration'\n    },\n    {\n      x: 168,\n      y: 0.40156922050687605,\n      originXData: '2022-08-23',\n      type: 'Social Penetration'\n    },\n    {\n      x: 169,\n      y: 16.368686321533847,\n      originXData: '2022-08-24',\n      type: 'Social Penetration'\n    },\n    {\n      x: 170,\n      y: 17.325634435909638,\n      originXData: '2022-08-25',\n      type: 'Social Penetration'\n    },\n    {\n      x: 171,\n      y: 2.771994472181008,\n      originXData: '2022-08-26',\n      type: 'Social Penetration'\n    },\n    {\n      x: 172,\n      y: 2.705080627435551,\n      originXData: '2022-08-27',\n      type: 'Social Penetration'\n    },\n    {\n      x: 173,\n      y: 0.366184071525715,\n      originXData: '2022-08-28',\n      type: 'Social Penetration'\n    },\n    {\n      x: 174,\n      y: 0.192969279119436,\n      originXData: '2022-08-29',\n      type: 'Social Penetration'\n    },\n    {\n      x: 175,\n      y: 0.248116517168076,\n      originXData: '2022-08-30',\n      type: 'Social Penetration'\n    },\n    {\n      x: 176,\n      y: 0.7172605174280461,\n      originXData: '2022-08-31',\n      type: 'Social Penetration'\n    },\n    {\n      x: 177,\n      y: 0.259653267575217,\n      originXData: '2022-09-01',\n      type: 'Social Penetration'\n    },\n    {\n      x: 178,\n      y: 1.398428414171018,\n      originXData: '2022-09-02',\n      type: 'Social Penetration'\n    },\n    {\n      x: 179,\n      y: 1.7166677805176591,\n      originXData: '2022-09-03',\n      type: 'Social Penetration'\n    }\n  ],\n  'Engagement - Socialization': [\n    {\n      x: 0,\n      y: 0.7782279444864411,\n      originXData: '2022-03-08',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 1,\n      y: 0.6970763116149991,\n      originXData: '2022-03-09',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 2,\n      y: 0.6754510401577041,\n      originXData: '2022-03-10',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 3,\n      y: 4.391274420824463,\n      originXData: '2022-03-11',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 4,\n      y: 0.5827973501093221,\n      originXData: '2022-03-12',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 5,\n      y: 0.321443063009525,\n      originXData: '2022-03-13',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 6,\n      y: 0.9838146243033221,\n      originXData: '2022-03-14',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 7,\n      y: 0.225492098355163,\n      originXData: '2022-03-15',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 8,\n      y: 0.580792120371675,\n      originXData: '2022-03-16',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 9,\n      y: 0.510579334822959,\n      originXData: '2022-03-17',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 10,\n      y: 1.656998380732747,\n      originXData: '2022-03-18',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 11,\n      y: 1.372238730132033,\n      originXData: '2022-03-19',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 12,\n      y: 3.375041306488803,\n      originXData: '2022-03-20',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 13,\n      y: 0.5770535812918991,\n      originXData: '2022-03-21',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 14,\n      y: 2.562767955961243,\n      originXData: '2022-03-22',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 15,\n      y: 60.10096481599735,\n      originXData: '2022-03-23',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 16,\n      y: 2.824195229461953,\n      originXData: '2022-03-24',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 17,\n      y: 0.37108301055861304,\n      originXData: '2022-03-25',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 18,\n      y: 6.8131452572139555,\n      originXData: '2022-03-26',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 19,\n      y: 0.993289299105189,\n      originXData: '2022-03-27',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 20,\n      y: 0.27225365805664004,\n      originXData: '2022-03-28',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 21,\n      y: 2.663368864789215,\n      originXData: '2022-03-29',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 22,\n      y: 1.136502929086737,\n      originXData: '2022-03-30',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 23,\n      y: 0.8268293005130081,\n      originXData: '2022-03-31',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 24,\n      y: 1.2824253532703072,\n      originXData: '2022-04-01',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 25,\n      y: 1.580091614771022,\n      originXData: '2022-04-02',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 26,\n      y: 0.7793382242254321,\n      originXData: '2022-04-03',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 27,\n      y: 0.34207119701235905,\n      originXData: '2022-04-04',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 28,\n      y: 4.144335050792541,\n      originXData: '2022-04-05',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 29,\n      y: 1.336025709304907,\n      originXData: '2022-04-06',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 30,\n      y: 0.9037359185383671,\n      originXData: '2022-04-07',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 31,\n      y: 13.698767079174356,\n      originXData: '2022-04-08',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 32,\n      y: 1.11771091972957,\n      originXData: '2022-04-09',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 33,\n      y: 0.5546236200208831,\n      originXData: '2022-04-10',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 34,\n      y: 0.133505664394376,\n      originXData: '2022-04-11',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 35,\n      y: 8.458105165611851,\n      originXData: '2022-04-12',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 36,\n      y: 1.412321112593621,\n      originXData: '2022-04-13',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 37,\n      y: 0.577163861285873,\n      originXData: '2022-04-14',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 38,\n      y: 5.112791338669762,\n      originXData: '2022-04-15',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 39,\n      y: 13.301401633991011,\n      originXData: '2022-04-16',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 40,\n      y: 0.8194099242420241,\n      originXData: '2022-04-17',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 41,\n      y: 0.601409275693432,\n      originXData: '2022-04-18',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 42,\n      y: 0.932019259560644,\n      originXData: '2022-04-19',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 43,\n      y: 3.6166710941152713,\n      originXData: '2022-04-20',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 44,\n      y: 2.682237126638688,\n      originXData: '2022-04-21',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 45,\n      y: 0.329339479566271,\n      originXData: '2022-04-22',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 46,\n      y: 0.923756524041317,\n      originXData: '2022-04-23',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 47,\n      y: 0.6601580208066361,\n      originXData: '2022-04-24',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 48,\n      y: 2.037027697748363,\n      originXData: '2022-04-25',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 49,\n      y: 0.803863499657206,\n      originXData: '2022-04-26',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 50,\n      y: 0.651469202290988,\n      originXData: '2022-04-27',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 51,\n      y: 2.6893975459595643,\n      originXData: '2022-04-28',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 52,\n      y: 0.9147556633717211,\n      originXData: '2022-04-29',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 53,\n      y: 3.463127996997362,\n      originXData: '2022-04-30',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 54,\n      y: 0.5573480476128151,\n      originXData: '2022-05-01',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 55,\n      y: 35.95040240058573,\n      originXData: '2022-05-02',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 56,\n      y: 5.577920982650984,\n      originXData: '2022-05-03',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 57,\n      y: 5.106082630695584,\n      originXData: '2022-05-04',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 58,\n      y: 0.040771286126692,\n      originXData: '2022-05-05',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 59,\n      y: 0.23681078820699203,\n      originXData: '2022-05-06',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 60,\n      y: 1.727448921279463,\n      originXData: '2022-05-07',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 61,\n      y: 1.434740383567053,\n      originXData: '2022-05-08',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 62,\n      y: 0.9377192673786531,\n      originXData: '2022-05-09',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 63,\n      y: 0.5840348488590831,\n      originXData: '2022-05-10',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 64,\n      y: 0.01643698693241,\n      originXData: '2022-05-11',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 65,\n      y: 1.538028843999251,\n      originXData: '2022-05-12',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 66,\n      y: 1.063801968030616,\n      originXData: '2022-05-13',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 67,\n      y: 0.16980099784180802,\n      originXData: '2022-05-14',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 68,\n      y: 2.144086432206532,\n      originXData: '2022-05-15',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 69,\n      y: 1.152664833294427,\n      originXData: '2022-05-16',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 70,\n      y: 0.8751363341872681,\n      originXData: '2022-05-17',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 71,\n      y: 0.8615187586650901,\n      originXData: '2022-05-18',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 72,\n      y: 0.126354125202296,\n      originXData: '2022-05-19',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 73,\n      y: 0.7098481312166951,\n      originXData: '2022-05-20',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 74,\n      y: 17.706030110118455,\n      originXData: '2022-05-21',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 75,\n      y: 0.9176470910577301,\n      originXData: '2022-05-22',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 76,\n      y: 16.47452431770853,\n      originXData: '2022-05-23',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 77,\n      y: 0.7854768368577231,\n      originXData: '2022-05-24',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 78,\n      y: 34.373177238596014,\n      originXData: '2022-05-25',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 79,\n      y: 0.789535076533531,\n      originXData: '2022-05-26',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 80,\n      y: 0.5312851260232421,\n      originXData: '2022-05-27',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 81,\n      y: 12.028735185645875,\n      originXData: '2022-05-28',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 82,\n      y: 1.439873268216485,\n      originXData: '2022-05-29',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 83,\n      y: 3.827653889831506,\n      originXData: '2022-05-30',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 84,\n      y: 1.4295696272440521,\n      originXData: '2022-05-31',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 85,\n      y: 1.325995589464272,\n      originXData: '2022-06-01',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 86,\n      y: 0.627748977148721,\n      originXData: '2022-06-02',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 87,\n      y: 0.83151391784571,\n      originXData: '2022-06-03',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 88,\n      y: 0.011530713721830002,\n      originXData: '2022-06-04',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 89,\n      y: 1.130871471288951,\n      originXData: '2022-06-05',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 90,\n      y: 2.9958102236757282,\n      originXData: '2022-06-06',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 91,\n      y: 0.44026116440941004,\n      originXData: '2022-06-07',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 92,\n      y: 4.156128784010092,\n      originXData: '2022-06-08',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 93,\n      y: 1.2828566287818242,\n      originXData: '2022-06-09',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 94,\n      y: 0.23152297348937,\n      originXData: '2022-06-10',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 95,\n      y: 1.344093064443273,\n      originXData: '2022-06-11',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 96,\n      y: 0.42108731154009404,\n      originXData: '2022-06-12',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 97,\n      y: 2.448703044357372,\n      originXData: '2022-06-13',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 98,\n      y: 1.912454128957958,\n      originXData: '2022-06-14',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 99,\n      y: 0.010368540480550002,\n      originXData: '2022-06-15',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 100,\n      y: 0.6677966564200211,\n      originXData: '2022-06-16',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 101,\n      y: 0.11111864432229301,\n      originXData: '2022-06-17',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 102,\n      y: 0.806546956486733,\n      originXData: '2022-06-18',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 103,\n      y: 1.135192118212662,\n      originXData: '2022-06-19',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 104,\n      y: 1.045144309632654,\n      originXData: '2022-06-20',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 105,\n      y: 1.076475248295982,\n      originXData: '2022-06-21',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 106,\n      y: 24.02021682920061,\n      originXData: '2022-06-22',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 107,\n      y: 0.027051327125384002,\n      originXData: '2022-06-23',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 108,\n      y: 2.878601660092219,\n      originXData: '2022-06-24',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 109,\n      y: 0.019465090936308,\n      originXData: '2022-06-25',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 110,\n      y: 1.2557471231721191,\n      originXData: '2022-06-26',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 111,\n      y: 0.5849212901405391,\n      originXData: '2022-06-27',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 112,\n      y: 0.280224773927022,\n      originXData: '2022-06-28',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 113,\n      y: 0.751739223993092,\n      originXData: '2022-06-29',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 114,\n      y: 0.555444809676618,\n      originXData: '2022-06-30',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 115,\n      y: 1.043273887199711,\n      originXData: '2022-07-01',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 116,\n      y: 1.8724388596735242,\n      originXData: '2022-07-02',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 117,\n      y: 1.204834846410795,\n      originXData: '2022-07-03',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 118,\n      y: 0.147183599628016,\n      originXData: '2022-07-04',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 119,\n      y: 0.259954349350673,\n      originXData: '2022-07-05',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 120,\n      y: 2.071271452074246,\n      originXData: '2022-07-06',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 121,\n      y: 0.186466306558064,\n      originXData: '2022-07-07',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 122,\n      y: 7.997827905255312,\n      originXData: '2022-07-08',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 123,\n      y: 0.33362085354833704,\n      originXData: '2022-07-09',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 124,\n      y: 36.550441521853145,\n      originXData: '2022-07-10',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 125,\n      y: 0.337559642243531,\n      originXData: '2022-07-11',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 126,\n      y: 0.48307852351030106,\n      originXData: '2022-07-12',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 127,\n      y: 0.9387594299650791,\n      originXData: '2022-07-13',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 128,\n      y: 22.940238837323303,\n      originXData: '2022-07-14',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 129,\n      y: 0.631304013521069,\n      originXData: '2022-07-15',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 130,\n      y: 0.984028805544615,\n      originXData: '2022-07-16',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 131,\n      y: 0.26284189122074103,\n      originXData: '2022-07-17',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 132,\n      y: 1.082826448671828,\n      originXData: '2022-07-18',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 133,\n      y: 0.5880718113215341,\n      originXData: '2022-07-19',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 134,\n      y: 0.17041520446782002,\n      originXData: '2022-07-20',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 135,\n      y: 0.822598941600809,\n      originXData: '2022-07-21',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 136,\n      y: 0.183634003906628,\n      originXData: '2022-07-22',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 137,\n      y: 0.559247300094862,\n      originXData: '2022-07-23',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 138,\n      y: 1.091835974661574,\n      originXData: '2022-07-24',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 139,\n      y: 3.048531280160542,\n      originXData: '2022-07-25',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 140,\n      y: 1.582638082613582,\n      originXData: '2022-07-26',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 141,\n      y: 6.436173309221049,\n      originXData: '2022-07-27',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 142,\n      y: 1.428578028660132,\n      originXData: '2022-07-28',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 143,\n      y: 0.7249411790805861,\n      originXData: '2022-07-29',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 144,\n      y: 0.9265499876312321,\n      originXData: '2022-07-30',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 145,\n      y: 0.9014047551998651,\n      originXData: '2022-07-31',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 146,\n      y: 1.610068186750942,\n      originXData: '2022-08-01',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 147,\n      y: 2.330031081649702,\n      originXData: '2022-08-02',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 148,\n      y: 0.462815961543229,\n      originXData: '2022-08-03',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 149,\n      y: 0.08597037675761801,\n      originXData: '2022-08-04',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 150,\n      y: 3.581243043200601,\n      originXData: '2022-08-05',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 151,\n      y: 10.930286916614767,\n      originXData: '2022-08-06',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 152,\n      y: 1.8029857915415932,\n      originXData: '2022-08-07',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 153,\n      y: 2.014631665755229,\n      originXData: '2022-08-08',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 154,\n      y: 2.983415297830412,\n      originXData: '2022-08-09',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 155,\n      y: 1.289582374551249,\n      originXData: '2022-08-10',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 156,\n      y: 0.37516694909806303,\n      originXData: '2022-08-11',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 157,\n      y: 1.603259620438238,\n      originXData: '2022-08-12',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 158,\n      y: 3.3791466219930433,\n      originXData: '2022-08-13',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 159,\n      y: 2.627126072551769,\n      originXData: '2022-08-14',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 160,\n      y: 3.354483317899366,\n      originXData: '2022-08-15',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 161,\n      y: 1.444879535922397,\n      originXData: '2022-08-16',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 162,\n      y: 0.6369673400603011,\n      originXData: '2022-08-17',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 163,\n      y: 0.5990722583580821,\n      originXData: '2022-08-18',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 164,\n      y: 0.24079634787311602,\n      originXData: '2022-08-19',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 165,\n      y: 0.096627004274573,\n      originXData: '2022-08-20',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 166,\n      y: 11.782408392531364,\n      originXData: '2022-08-21',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 167,\n      y: 1.846139752930779,\n      originXData: '2022-08-22',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 168,\n      y: 2.44670175499675,\n      originXData: '2022-08-23',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 169,\n      y: 9.285256494681935,\n      originXData: '2022-08-24',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 170,\n      y: 40.63547963350666,\n      originXData: '2022-08-25',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 171,\n      y: 1.432898057334553,\n      originXData: '2022-08-26',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 172,\n      y: 1.140228551443707,\n      originXData: '2022-08-27',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 173,\n      y: 0.37561791103581305,\n      originXData: '2022-08-28',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 174,\n      y: 1.203078886727172,\n      originXData: '2022-08-29',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 175,\n      y: 0.901524977902984,\n      originXData: '2022-08-30',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 176,\n      y: 0.22721632248943202,\n      originXData: '2022-08-31',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 177,\n      y: 2.040817156148029,\n      originXData: '2022-09-01',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 178,\n      y: 0.071469482611002,\n      originXData: '2022-09-02',\n      type: 'Engagement - Socialization \\n\\n'\n    },\n    {\n      x: 179,\n      y: 1.903668070163285,\n      originXData: '2022-09-03',\n      type: 'Engagement - Socialization \\n\\n'\n    }\n  ],\n  'Penetration of Private Messages': [\n    {\n      x: 0,\n      y: 0.21493020207806002,\n      originXData: '2022-03-08',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 1,\n      y: 0.31807068769079905,\n      originXData: '2022-03-09',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 2,\n      y: 0.9774597853017851,\n      originXData: '2022-03-10',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 3,\n      y: 0.662196540154462,\n      originXData: '2022-03-11',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 4,\n      y: 1.547704220622789,\n      originXData: '2022-03-12',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 5,\n      y: 0.52384329811226,\n      originXData: '2022-03-13',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 6,\n      y: 1.242674929077965,\n      originXData: '2022-03-14',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 7,\n      y: 1.133076821811672,\n      originXData: '2022-03-15',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 8,\n      y: 1.261446251860683,\n      originXData: '2022-03-16',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 9,\n      y: 0.908573021920086,\n      originXData: '2022-03-17',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 10,\n      y: 2.003638269088651,\n      originXData: '2022-03-18',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 11,\n      y: 1.285574252451237,\n      originXData: '2022-03-19',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 12,\n      y: 1.683935730207101,\n      originXData: '2022-03-20',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 13,\n      y: 0.518960506573594,\n      originXData: '2022-03-21',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 14,\n      y: 2.076490748024919,\n      originXData: '2022-03-22',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 15,\n      y: 31.918470633985613,\n      originXData: '2022-03-23',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 16,\n      y: 1.735738814795219,\n      originXData: '2022-03-24',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 17,\n      y: 1.072942910906809,\n      originXData: '2022-03-25',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 18,\n      y: 10.31725741409195,\n      originXData: '2022-03-26',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 19,\n      y: 1.288157916081268,\n      originXData: '2022-03-27',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 20,\n      y: 0.24488975421611903,\n      originXData: '2022-03-28',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 21,\n      y: 3.030888929145336,\n      originXData: '2022-03-29',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 22,\n      y: 1.4304534277803231,\n      originXData: '2022-03-30',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 23,\n      y: 1.32475784490384,\n      originXData: '2022-03-31',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 24,\n      y: 0.9289553576582981,\n      originXData: '2022-04-01',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 25,\n      y: 0.8470948142995741,\n      originXData: '2022-04-02',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 26,\n      y: 0.5908683646183901,\n      originXData: '2022-04-03',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 27,\n      y: 1.006103497118929,\n      originXData: '2022-04-04',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 28,\n      y: 13.880860231019398,\n      originXData: '2022-04-05',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 29,\n      y: 7.121018094960213,\n      originXData: '2022-04-06',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 30,\n      y: 2.010136943230478,\n      originXData: '2022-04-07',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 31,\n      y: 14.457401852798982,\n      originXData: '2022-04-08',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 32,\n      y: 0.9593788300193951,\n      originXData: '2022-04-09',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 33,\n      y: 1.138776207683746,\n      originXData: '2022-04-10',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 34,\n      y: 0.575680679073131,\n      originXData: '2022-04-11',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 35,\n      y: 2.90160000840929,\n      originXData: '2022-04-12',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 36,\n      y: 1.416876192652653,\n      originXData: '2022-04-13',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 37,\n      y: 0.034172330313952004,\n      originXData: '2022-04-14',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 38,\n      y: 3.745099757241069,\n      originXData: '2022-04-15',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 39,\n      y: 6.202762040985617,\n      originXData: '2022-04-16',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 40,\n      y: 0.6882380919620981,\n      originXData: '2022-04-17',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 41,\n      y: 0.07904084882979401,\n      originXData: '2022-04-18',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 42,\n      y: 0.013117573233606001,\n      originXData: '2022-04-19',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 43,\n      y: 3.143179675624189,\n      originXData: '2022-04-20',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 44,\n      y: 0.6180860661837431,\n      originXData: '2022-04-21',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 45,\n      y: 0.001536382167654,\n      originXData: '2022-04-22',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 46,\n      y: 0.27081187550692803,\n      originXData: '2022-04-23',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 47,\n      y: 0.7774852739576821,\n      originXData: '2022-04-24',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 48,\n      y: 0.859959904015784,\n      originXData: '2022-04-25',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 49,\n      y: 0.22244045641286703,\n      originXData: '2022-04-26',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 50,\n      y: 0.509144429951741,\n      originXData: '2022-04-27',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 51,\n      y: 0.13894846116144902,\n      originXData: '2022-04-28',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 52,\n      y: 0.19686640023465302,\n      originXData: '2022-04-29',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 53,\n      y: 2.931184732430775,\n      originXData: '2022-04-30',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 54,\n      y: 0.544054544143018,\n      originXData: '2022-05-01',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 55,\n      y: 10.530894431942714,\n      originXData: '2022-05-02',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 56,\n      y: 4.483541728043783,\n      originXData: '2022-05-03',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 57,\n      y: 8.400221891051206,\n      originXData: '2022-05-04',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 58,\n      y: 0.6862921980279431,\n      originXData: '2022-05-05',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 59,\n      y: 4.557825514906153,\n      originXData: '2022-05-06',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 60,\n      y: 0.527497153125138,\n      originXData: '2022-05-07',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 61,\n      y: 1.25226701190186,\n      originXData: '2022-05-08',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 62,\n      y: 0.643077700672811,\n      originXData: '2022-05-09',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 63,\n      y: 0.031193331319320002,\n      originXData: '2022-05-10',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 64,\n      y: 0.39325414355653304,\n      originXData: '2022-05-11',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 65,\n      y: 0.863652647240271,\n      originXData: '2022-05-12',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 66,\n      y: 0.65309749602536,\n      originXData: '2022-05-13',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 67,\n      y: 0.502507081730036,\n      originXData: '2022-05-14',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 68,\n      y: 1.989727381483406,\n      originXData: '2022-05-15',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 69,\n      y: 0.747391405264186,\n      originXData: '2022-05-16',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 70,\n      y: 0.901758308356248,\n      originXData: '2022-05-17',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 71,\n      y: 0.43634054682577406,\n      originXData: '2022-05-18',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 72,\n      y: 2.8539304550226543,\n      originXData: '2022-05-19',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 73,\n      y: 0.5071020864029481,\n      originXData: '2022-05-20',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 74,\n      y: 2.848137759152337,\n      originXData: '2022-05-21',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 75,\n      y: 0.43003615544265306,\n      originXData: '2022-05-22',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 76,\n      y: 2.744192036280677,\n      originXData: '2022-05-23',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 77,\n      y: 0.6263662592501831,\n      originXData: '2022-05-24',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 78,\n      y: 7.564216276703391,\n      originXData: '2022-05-25',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 79,\n      y: 0.8798790088553111,\n      originXData: '2022-05-26',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 80,\n      y: 1.055373428020675,\n      originXData: '2022-05-27',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 81,\n      y: 14.171624745847268,\n      originXData: '2022-05-28',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 82,\n      y: 1.078931580631559,\n      originXData: '2022-05-29',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 83,\n      y: 1.429842282923971,\n      originXData: '2022-05-30',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 84,\n      y: 1.141933003322777,\n      originXData: '2022-05-31',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 85,\n      y: 2.006909504383298,\n      originXData: '2022-06-01',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 86,\n      y: 1.176985400742372,\n      originXData: '2022-06-02',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 87,\n      y: 1.356692075891955,\n      originXData: '2022-06-03',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 88,\n      y: 0.52485737802621,\n      originXData: '2022-06-04',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 89,\n      y: 1.189107233207374,\n      originXData: '2022-06-05',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 90,\n      y: 0.47619309340284505,\n      originXData: '2022-06-06',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 91,\n      y: 0.42982954277120905,\n      originXData: '2022-06-07',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 92,\n      y: 1.021512025143279,\n      originXData: '2022-06-08',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 93,\n      y: 0.22198861960947303,\n      originXData: '2022-06-09',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 94,\n      y: 0.18500236928827601,\n      originXData: '2022-06-10',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 95,\n      y: 0.6923204827335401,\n      originXData: '2022-06-11',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 96,\n      y: 1.547163500435265,\n      originXData: '2022-06-12',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 97,\n      y: 0.13900479867391702,\n      originXData: '2022-06-13',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 98,\n      y: 0.24702549770442003,\n      originXData: '2022-06-14',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 99,\n      y: 0.133167401519793,\n      originXData: '2022-06-15',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 100,\n      y: 4.009094569074379,\n      originXData: '2022-06-16',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 101,\n      y: 0.9730098334869651,\n      originXData: '2022-06-17',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 102,\n      y: 0.32013564834811403,\n      originXData: '2022-06-18',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 103,\n      y: 5.021267051723119,\n      originXData: '2022-06-19',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 104,\n      y: 4.014478741193049,\n      originXData: '2022-06-20',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 105,\n      y: 0.7240389412682761,\n      originXData: '2022-06-21',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 106,\n      y: 37.05462241129788,\n      originXData: '2022-06-22',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 107,\n      y: 0.16824850993617801,\n      originXData: '2022-06-23',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 108,\n      y: 1.9317197675603461,\n      originXData: '2022-06-24',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 109,\n      y: 0.285177476177572,\n      originXData: '2022-06-25',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 110,\n      y: 1.260075716991639,\n      originXData: '2022-06-26',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 111,\n      y: 3.452510757244162,\n      originXData: '2022-06-27',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 112,\n      y: 0.729523367081325,\n      originXData: '2022-06-28',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 113,\n      y: 0.7538963415227941,\n      originXData: '2022-06-29',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 114,\n      y: 0.08646395240381301,\n      originXData: '2022-06-30',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 115,\n      y: 0.49779032149353303,\n      originXData: '2022-07-01',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 116,\n      y: 0.391981409036455,\n      originXData: '2022-07-02',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 117,\n      y: 1.103562611606201,\n      originXData: '2022-07-03',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 118,\n      y: 1.798064276315111,\n      originXData: '2022-07-04',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 119,\n      y: 0.407469349519874,\n      originXData: '2022-07-05',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 120,\n      y: 4.502139668053687,\n      originXData: '2022-07-06',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 121,\n      y: 0.499133613586184,\n      originXData: '2022-07-07',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 122,\n      y: 5.845195208267132,\n      originXData: '2022-07-08',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 123,\n      y: 1.26505092951483,\n      originXData: '2022-07-09',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 124,\n      y: 19.095991246701065,\n      originXData: '2022-07-10',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 125,\n      y: 1.154651513638781,\n      originXData: '2022-07-11',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 126,\n      y: 1.5365158530965122,\n      originXData: '2022-07-12',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 127,\n      y: 1.092431878065284,\n      originXData: '2022-07-13',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 128,\n      y: 13.579325095732914,\n      originXData: '2022-07-14',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 129,\n      y: 0.62869350368483,\n      originXData: '2022-07-15',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 130,\n      y: 0.967817534607272,\n      originXData: '2022-07-16',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 131,\n      y: 2.154865858339681,\n      originXData: '2022-07-17',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 132,\n      y: 0.45266260254768803,\n      originXData: '2022-07-18',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 133,\n      y: 1.007179376918947,\n      originXData: '2022-07-19',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 134,\n      y: 1.773905435681336,\n      originXData: '2022-07-20',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 135,\n      y: 0.9593067917284711,\n      originXData: '2022-07-21',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 136,\n      y: 13.34157103707886,\n      originXData: '2022-07-22',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 137,\n      y: 0.40653075149155804,\n      originXData: '2022-07-23',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 138,\n      y: 0.8199135063617131,\n      originXData: '2022-07-24',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 139,\n      y: 1.471231045142114,\n      originXData: '2022-07-25',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 140,\n      y: 1.789945856913414,\n      originXData: '2022-07-26',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 141,\n      y: 4.7854634352690155,\n      originXData: '2022-07-27',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 142,\n      y: 1.458686942176205,\n      originXData: '2022-07-28',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 143,\n      y: 0.42039676295059203,\n      originXData: '2022-07-29',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 144,\n      y: 0.32494629315872703,\n      originXData: '2022-07-30',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 145,\n      y: 0.46982772647431204,\n      originXData: '2022-07-31',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 146,\n      y: 3.309159861747862,\n      originXData: '2022-08-01',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 147,\n      y: 3.9640154638953513,\n      originXData: '2022-08-02',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 148,\n      y: 0.9670138622828691,\n      originXData: '2022-08-03',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 149,\n      y: 0.9707805498085981,\n      originXData: '2022-08-04',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 150,\n      y: 2.651870015387795,\n      originXData: '2022-08-05',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 151,\n      y: 22.78182877052594,\n      originXData: '2022-08-06',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 152,\n      y: 1.476317514220094,\n      originXData: '2022-08-07',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 153,\n      y: 2.7977280500624433,\n      originXData: '2022-08-08',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 154,\n      y: 0.126105493389976,\n      originXData: '2022-08-09',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 155,\n      y: 2.5475660513369442,\n      originXData: '2022-08-10',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 156,\n      y: 0.5828588359439041,\n      originXData: '2022-08-11',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 157,\n      y: 1.8751590471743,\n      originXData: '2022-08-12',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 158,\n      y: 9.375119750363103,\n      originXData: '2022-08-13',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 159,\n      y: 0.57102589263998,\n      originXData: '2022-08-14',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 160,\n      y: 1.075590808840468,\n      originXData: '2022-08-15',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 161,\n      y: 0.942851527789979,\n      originXData: '2022-08-16',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 162,\n      y: 0.473080126014195,\n      originXData: '2022-08-17',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 163,\n      y: 0.911179769434693,\n      originXData: '2022-08-18',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 164,\n      y: 0.045592515857608006,\n      originXData: '2022-08-19',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 165,\n      y: 0.7910843611370051,\n      originXData: '2022-08-20',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 166,\n      y: 4.022381962144387,\n      originXData: '2022-08-21',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 167,\n      y: 1.302218066447416,\n      originXData: '2022-08-22',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 168,\n      y: 2.701336009126233,\n      originXData: '2022-08-23',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 169,\n      y: 14.17816605948454,\n      originXData: '2022-08-24',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 170,\n      y: 52.36627420733006,\n      originXData: '2022-08-25',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 171,\n      y: 0.500652317272802,\n      originXData: '2022-08-26',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 172,\n      y: 2.535947091285437,\n      originXData: '2022-08-27',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 173,\n      y: 1.087399555743408,\n      originXData: '2022-08-28',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 174,\n      y: 0.8966719923838661,\n      originXData: '2022-08-29',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 175,\n      y: 0.9660257636136701,\n      originXData: '2022-08-30',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 176,\n      y: 0.9247009404760361,\n      originXData: '2022-08-31',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 177,\n      y: 2.19857288799284,\n      originXData: '2022-09-01',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 178,\n      y: 0.9048807067534731,\n      originXData: '2022-09-02',\n      type: 'Penetration of Private Messages'\n    },\n    {\n      x: 179,\n      y: 1.866568462888393,\n      originXData: '2022-09-03',\n      type: 'Penetration of Private Messages'\n    }\n  ],\n  'Number of Private Messages per User': [\n    {\n      x: 0,\n      y: 0.26002007727513005,\n      originXData: '2022-03-08',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 1,\n      y: 1.791161354352144,\n      originXData: '2022-03-09',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 2,\n      y: 1.410289280738493,\n      originXData: '2022-03-10',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 3,\n      y: 2.374084690062705,\n      originXData: '2022-03-11',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 4,\n      y: 0.42545370377775604,\n      originXData: '2022-03-12',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 5,\n      y: 0.45119753243186805,\n      originXData: '2022-03-13',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 6,\n      y: 1.276345431333586,\n      originXData: '2022-03-14',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 7,\n      y: 0.22045142924559902,\n      originXData: '2022-03-15',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 8,\n      y: 0.061775812702848,\n      originXData: '2022-03-16',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 9,\n      y: 0.429194248082692,\n      originXData: '2022-03-17',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 10,\n      y: 1.194511111230195,\n      originXData: '2022-03-18',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 11,\n      y: 0.659056833995271,\n      originXData: '2022-03-19',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 12,\n      y: 0.40361011204949004,\n      originXData: '2022-03-20',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 13,\n      y: 0.8441533797310441,\n      originXData: '2022-03-21',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 14,\n      y: 1.8682050366367142,\n      originXData: '2022-03-22',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 15,\n      y: 70.34237647545662,\n      originXData: '2022-03-23',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 16,\n      y: 3.854924132202267,\n      originXData: '2022-03-24',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 17,\n      y: 0.868965201778456,\n      originXData: '2022-03-25',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 18,\n      y: 0.6724835487477681,\n      originXData: '2022-03-26',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 19,\n      y: 1.290710012048575,\n      originXData: '2022-03-27',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 20,\n      y: 0.944202324553962,\n      originXData: '2022-03-28',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 21,\n      y: 2.191548298261417,\n      originXData: '2022-03-29',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 22,\n      y: 0.9398051933719991,\n      originXData: '2022-03-30',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 23,\n      y: 0.212383798504713,\n      originXData: '2022-03-31',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 24,\n      y: 1.328758303758777,\n      originXData: '2022-04-01',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 25,\n      y: 1.061518688804395,\n      originXData: '2022-04-02',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 26,\n      y: 1.021428732507816,\n      originXData: '2022-04-03',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 27,\n      y: 0.8496566144677861,\n      originXData: '2022-04-04',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 28,\n      y: 19.78289952089912,\n      originXData: '2022-04-05',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 29,\n      y: 0.032847589287524,\n      originXData: '2022-04-06',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 30,\n      y: 2.758258304057329,\n      originXData: '2022-04-07',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 31,\n      y: 11.6964360828172,\n      originXData: '2022-04-08',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 32,\n      y: 1.121066838670219,\n      originXData: '2022-04-09',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 33,\n      y: 0.5694312841615821,\n      originXData: '2022-04-10',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 34,\n      y: 0.502679162912634,\n      originXData: '2022-04-11',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 35,\n      y: 3.084080663501847,\n      originXData: '2022-04-12',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 36,\n      y: 0.270647644667579,\n      originXData: '2022-04-13',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 37,\n      y: 0.268470350264293,\n      originXData: '2022-04-14',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 38,\n      y: 2.612195295941399,\n      originXData: '2022-04-15',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 39,\n      y: 18.098567324029407,\n      originXData: '2022-04-16',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 40,\n      y: 0.645388563624089,\n      originXData: '2022-04-17',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 41,\n      y: 0.16144847919011002,\n      originXData: '2022-04-18',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 42,\n      y: 0.36918835535862005,\n      originXData: '2022-04-19',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 43,\n      y: 5.283666616893828,\n      originXData: '2022-04-20',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 44,\n      y: 1.631115014312209,\n      originXData: '2022-04-21',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 45,\n      y: 0.807551152019862,\n      originXData: '2022-04-22',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 46,\n      y: 0.22998130489182,\n      originXData: '2022-04-23',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 47,\n      y: 1.107108162852159,\n      originXData: '2022-04-24',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 48,\n      y: 0.641738277028276,\n      originXData: '2022-04-25',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 49,\n      y: 1.320954321806144,\n      originXData: '2022-04-26',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 50,\n      y: 0.20073460039620403,\n      originXData: '2022-04-27',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 51,\n      y: 0.7415989059349031,\n      originXData: '2022-04-28',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 52,\n      y: 1.66475441380813,\n      originXData: '2022-04-29',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 53,\n      y: 1.792534569741266,\n      originXData: '2022-04-30',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 54,\n      y: 0.35016352980012605,\n      originXData: '2022-05-01',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 55,\n      y: 4.323328789531124,\n      originXData: '2022-05-02',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 56,\n      y: 3.7796731596206943,\n      originXData: '2022-05-03',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 57,\n      y: 8.018922971992662,\n      originXData: '2022-05-04',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 58,\n      y: 0.44745062012103404,\n      originXData: '2022-05-05',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 59,\n      y: 3.46073691075845,\n      originXData: '2022-05-06',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 60,\n      y: 0.120868915583745,\n      originXData: '2022-05-07',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 61,\n      y: 0.42909048781311704,\n      originXData: '2022-05-08',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 62,\n      y: 0.539461571476962,\n      originXData: '2022-05-09',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 63,\n      y: 0.341612265371036,\n      originXData: '2022-05-10',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 64,\n      y: 0.918926460102595,\n      originXData: '2022-05-11',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 65,\n      y: 1.249717355592488,\n      originXData: '2022-05-12',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 66,\n      y: 1.244646630025216,\n      originXData: '2022-05-13',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 67,\n      y: 0.026734770744615003,\n      originXData: '2022-05-14',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 68,\n      y: 1.510725845099207,\n      originXData: '2022-05-15',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 69,\n      y: 0.283792059973869,\n      originXData: '2022-05-16',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 70,\n      y: 0.41795473321335,\n      originXData: '2022-05-17',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 71,\n      y: 1.895212820019219,\n      originXData: '2022-05-18',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 72,\n      y: 0.77105240170235,\n      originXData: '2022-05-19',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 73,\n      y: 2.543277547025898,\n      originXData: '2022-05-20',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 74,\n      y: 1.260088014509166,\n      originXData: '2022-05-21',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 75,\n      y: 0.910155627802492,\n      originXData: '2022-05-22',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 76,\n      y: 1.124249996351633,\n      originXData: '2022-05-23',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 77,\n      y: 0.19409864063613502,\n      originXData: '2022-05-24',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 78,\n      y: 17.06769270843336,\n      originXData: '2022-05-25',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 79,\n      y: 0.592040366427117,\n      originXData: '2022-05-26',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 80,\n      y: 0.84736634769268,\n      originXData: '2022-05-27',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 81,\n      y: 35.787490090751945,\n      originXData: '2022-05-28',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 82,\n      y: 0.9907508552960291,\n      originXData: '2022-05-29',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 83,\n      y: 3.76351508114206,\n      originXData: '2022-05-30',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 84,\n      y: 1.22202135537901,\n      originXData: '2022-05-31',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 85,\n      y: 1.7803529363753632,\n      originXData: '2022-06-01',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 86,\n      y: 1.267728131617331,\n      originXData: '2022-06-02',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 87,\n      y: 3.227340286052029,\n      originXData: '2022-06-03',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 88,\n      y: 0.661668615725415,\n      originXData: '2022-06-04',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 89,\n      y: 3.246025623322408,\n      originXData: '2022-06-05',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 90,\n      y: 1.3335764819663671,\n      originXData: '2022-06-06',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 91,\n      y: 1.741430660250139,\n      originXData: '2022-06-07',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 92,\n      y: 4.351094223144934,\n      originXData: '2022-06-08',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 93,\n      y: 0.085629074470341,\n      originXData: '2022-06-09',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 94,\n      y: 0.5925681882904861,\n      originXData: '2022-06-10',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 95,\n      y: 1.013151233597585,\n      originXData: '2022-06-11',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 96,\n      y: 0.999128791000602,\n      originXData: '2022-06-12',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 97,\n      y: 1.556248326348268,\n      originXData: '2022-06-13',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 98,\n      y: 2.037101388253879,\n      originXData: '2022-06-14',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 99,\n      y: 2.42241572339565,\n      originXData: '2022-06-15',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 100,\n      y: 5.5253640045926335,\n      originXData: '2022-06-16',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 101,\n      y: 0.9908309309721931,\n      originXData: '2022-06-17',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 102,\n      y: 0.8486918887953661,\n      originXData: '2022-06-18',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 103,\n      y: 4.233329079605447,\n      originXData: '2022-06-19',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 104,\n      y: 2.239616259510069,\n      originXData: '2022-06-20',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 105,\n      y: 0.10908279405984601,\n      originXData: '2022-06-21',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 106,\n      y: 23.51884099646193,\n      originXData: '2022-06-22',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 107,\n      y: 0.41568301223291604,\n      originXData: '2022-06-23',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 108,\n      y: 1.840590020030168,\n      originXData: '2022-06-24',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 109,\n      y: 0.5532414004550751,\n      originXData: '2022-06-25',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 110,\n      y: 2.715172232506665,\n      originXData: '2022-06-26',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 111,\n      y: 2.679757899115613,\n      originXData: '2022-06-27',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 112,\n      y: 1.105137522496868,\n      originXData: '2022-06-28',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 113,\n      y: 1.347929408272255,\n      originXData: '2022-06-29',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 114,\n      y: 0.5491110504617991,\n      originXData: '2022-06-30',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 115,\n      y: 0.885618995495125,\n      originXData: '2022-07-01',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 116,\n      y: 1.040394051716164,\n      originXData: '2022-07-02',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 117,\n      y: 0.387838034146796,\n      originXData: '2022-07-03',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 118,\n      y: 0.33504623462675404,\n      originXData: '2022-07-04',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 119,\n      y: 3.278091213717644,\n      originXData: '2022-07-05',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 120,\n      y: 5.134166854414464,\n      originXData: '2022-07-06',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 121,\n      y: 0.15787863433545202,\n      originXData: '2022-07-07',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 122,\n      y: 3.695856221993309,\n      originXData: '2022-07-08',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 123,\n      y: 0.9204718402028381,\n      originXData: '2022-07-09',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 124,\n      y: 12.292686689327372,\n      originXData: '2022-07-10',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 125,\n      y: 0.22569823789057203,\n      originXData: '2022-07-11',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 126,\n      y: 0.057003071478754004,\n      originXData: '2022-07-12',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 127,\n      y: 1.886305858547745,\n      originXData: '2022-07-13',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 128,\n      y: 38.67416013838181,\n      originXData: '2022-07-14',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 129,\n      y: 0.34417591219448,\n      originXData: '2022-07-15',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 130,\n      y: 0.153576028704162,\n      originXData: '2022-07-16',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 131,\n      y: 1.283391109459497,\n      originXData: '2022-07-17',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 132,\n      y: 0.084950117524903,\n      originXData: '2022-07-18',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 133,\n      y: 0.865719136965563,\n      originXData: '2022-07-19',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 134,\n      y: 1.104677623595627,\n      originXData: '2022-07-20',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 135,\n      y: 0.41221237294221,\n      originXData: '2022-07-21',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 136,\n      y: 12.159275730149757,\n      originXData: '2022-07-22',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 137,\n      y: 0.9694788164354201,\n      originXData: '2022-07-23',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 138,\n      y: 1.062993342271482,\n      originXData: '2022-07-24',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 139,\n      y: 0.591416124923933,\n      originXData: '2022-07-25',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 140,\n      y: 2.192979954983851,\n      originXData: '2022-07-26',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 141,\n      y: 1.63427958962943,\n      originXData: '2022-07-27',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 142,\n      y: 1.311736714260567,\n      originXData: '2022-07-28',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 143,\n      y: 2.995565219170837,\n      originXData: '2022-07-29',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 144,\n      y: 0.324341917122049,\n      originXData: '2022-07-30',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 145,\n      y: 0.5534444716525361,\n      originXData: '2022-07-31',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 146,\n      y: 0.529330910775445,\n      originXData: '2022-08-01',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 147,\n      y: 3.856552869039815,\n      originXData: '2022-08-02',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 148,\n      y: 1.234951845374218,\n      originXData: '2022-08-03',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 149,\n      y: 0.16192153323070702,\n      originXData: '2022-08-04',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 150,\n      y: 2.173110201699371,\n      originXData: '2022-08-05',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 151,\n      y: 11.135752238663327,\n      originXData: '2022-08-06',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 152,\n      y: 0.958792084262276,\n      originXData: '2022-08-07',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 153,\n      y: 2.039075329513739,\n      originXData: '2022-08-08',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 154,\n      y: 2.121594836643942,\n      originXData: '2022-08-09',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 155,\n      y: 3.282862603860423,\n      originXData: '2022-08-10',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 156,\n      y: 0.139231895746797,\n      originXData: '2022-08-11',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 157,\n      y: 0.24122279792940302,\n      originXData: '2022-08-12',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 158,\n      y: 0.7506624109540441,\n      originXData: '2022-08-13',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 159,\n      y: 2.4024472876658223,\n      originXData: '2022-08-14',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 160,\n      y: 2.3650336028113492,\n      originXData: '2022-08-15',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 161,\n      y: 1.423465983705226,\n      originXData: '2022-08-16',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 162,\n      y: 0.8585472144660361,\n      originXData: '2022-08-17',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 163,\n      y: 1.189643421133775,\n      originXData: '2022-08-18',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 164,\n      y: 0.9837464357223601,\n      originXData: '2022-08-19',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 165,\n      y: 0.059870034265504,\n      originXData: '2022-08-20',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 166,\n      y: 12.55656527594101,\n      originXData: '2022-08-21',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 167,\n      y: 1.195140815195466,\n      originXData: '2022-08-22',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 168,\n      y: 2.5846045653914143,\n      originXData: '2022-08-23',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 169,\n      y: 6.813674272547164,\n      originXData: '2022-08-24',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 170,\n      y: 22.12581500864155,\n      originXData: '2022-08-25',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 171,\n      y: 0.29065103217099203,\n      originXData: '2022-08-26',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 172,\n      y: 2.068004826572326,\n      originXData: '2022-08-27',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 173,\n      y: 1.3431857507096732,\n      originXData: '2022-08-28',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 174,\n      y: 1.07779591413233,\n      originXData: '2022-08-29',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 175,\n      y: 0.13247782324235202,\n      originXData: '2022-08-30',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 176,\n      y: 0.28572976740870504,\n      originXData: '2022-08-31',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 177,\n      y: 2.229208371156883,\n      originXData: '2022-09-01',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 178,\n      y: 0.0022491420541680004,\n      originXData: '2022-09-02',\n      type: 'Number of Private Messages per User'\n    },\n    {\n      x: 179,\n      y: 1.8648831840830011,\n      originXData: '2022-09-03',\n      type: 'Number of Private Messages per User'\n    }\n  ]\n};\nspec.series.forEach(s => {\n  s.data.values = dataJson[s.data.id];\n});\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [滚动条 Demo](https://www.visactor.io/vchart/demo/scrollbar/basic-scrollbar-bar-chart)\n- [滚动条教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Scrollbar)\n- [相关 api](https://www.visactor.io/vchart/option/commonChart#scrollbar)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '77-How to customize the display text content of the funnel chart.md',
    content:
      "# 漏斗图如何自定义显示文字内容？\n\n## 问题描述\n\n我正在绘制一个漏斗图，我希望能够每一个漏斗里头的标签能够自定义展示内容，显示两行不同的文字，同时右侧的标签也需要能够自定义内容。我应该怎么来实现这样的效果呢？\n\n类似下图中的效果：\n\n![funnel](/vchart/faq/76-0.png)\n\n## 解决方案\n\n和其他的 VChart 图表一样，VChart 漏斗图同样支持自定义各个标签的样式以及内容，可以在相应的 label 配置项中配置回调函数来自定义文本标签的内容。如果文本内容的回调函数返回值为数组，那么最终展示的标签内容也将以多行进行展示。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'funnel',\n  categoryField: 'name',\n  valueField: 'value',\n  isTransform: true,\n  isCone: false,\n  data: [\n    {\n      id: 'funnel',\n      values: [\n        {\n          value: 5676,\n          name: 'Sent'\n        },\n        {\n          value: 3872,\n          name: 'Viewed'\n        },\n        {\n          value: 1668,\n          name: 'Clicked'\n        },\n        {\n          value: 610,\n          name: 'Add to Cart'\n        },\n        {\n          value: 565,\n          name: 'Purchased'\n        }\n      ]\n    }\n  ],\n  title: {\n    visible: true,\n    text: 'Percentage of the customers have dropped from the sales process'\n  },\n  label: {\n    visible: true,\n    style: {\n      text: datum => {\n        return [datum.name, datum.value];\n      }\n    }\n  },\n  transformLabel: {\n    visible: true\n  },\n  outerLabel: {\n    position: 'right',\n    visible: true,\n    style: {\n      text: datum => {\n        return datum.name;\n      }\n    }\n  },\n  legends: {\n    visible: true,\n    orient: 'top'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [funnelChart style spec](https://www.visactor.io/vchart/option/funnelChart#label.style.text)\n"
  },
  {
    fileName: '78-How do I configure the default scroll position for chart scrollbars.md',
    content:
      "# 图表滚动条如何配置默认滚动的位置？\n\n## 问题描述\n\n当我需要配置滚动条默认滚动的位置的时候我该怎么做？有时我希望滚动条的起点和终点是我所指定的，而并非一个默认范围。\n\n## 解决方案\n\n你需要配置表示范围的参数`scrollBar.start`和`scrollBar.end`，它们表示滚动条的起点和终点，取值为[0, 1]，表示的该位置所在的百分比布局范围。\n除此之外，你还可以通过`scrollBar.startValue`和`scrollBar.endValue`来配置起点和终点，它们分别表示起点和终点的数据值。\n[scrollbar position](/vchart/faq/13-0.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { year: '2000', sales: 22 },\n        { year: '2001', sales: 13 },\n        { year: '2002', sales: 25 },\n        { year: '2003', sales: 29 },\n        { year: '2004', sales: 38 },\n        { year: '2005', sales: 49 },\n        { year: '2006', sales: 58 },\n        { year: '2007', sales: 29 },\n        { year: '2008', sales: 78 },\n        { year: '2009', sales: 19 },\n        { year: '2010', sales: 23 },\n        { year: '2011', sales: 20 },\n        { year: '2012', sales: 98 },\n        { year: '2013', sales: 49 },\n        { year: '2014', sales: 28 }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  yField: 'year',\n  xField: 'sales',\n  scrollBar: [\n    {\n      orient: 'right',\n      startValue: '2011',\n      endValue: '2014',\n      roam: true\n    }\n  ]\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [滚动条 Demo](https://www.visactor.io/vchart/demo/scrollbar/basic-scrollbar-bar-chart)\n- [滚动条教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Scrollbar)\n- [相关 api](https://www.visactor.io/vchart/option/commonChart#scrollbar)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName:
      '79- How to achieve coordinated display of positions in other charts when moving the mouse in the vchart library.md',
    content:
      "---\ntitle: 109. 在vchart图表库中，如何实现鼠标移动时其他图表也显示位置的联动效果？</br>\n---\r\n# 问题标题\r\n\r\n在vchart图表库中，如何实现鼠标移动时其他图表也显示位置的联动效果？</br>\r\n# 问题描述\r\n\r\n我在使用vchart图表库时，遇到了一个问题。我希望在移动鼠标时，其他图表也能同时显示相应的位置，即实现联动效果。我不确定该如何实现这种功能，有相关的文档可以供我参考吗？</br>\r\n# 解决方案 \r\n\r\n确实可以实现这种联动效果。你需要监听一个图表的 dimensionHover 事件，然后对其他图表模拟dimensionHover。</br>\r\n首先，你需要使用`on`方法来监听图表的`dimensionHover`事件，详细的API使用方式可以参考[vchart API](https%3A%2F%2Fvisactor.io%2Fvchart%2Fapi%2FAPI%2Fvchart%23on)。</br>\r\n```\nvChart.on('dimensionHover', function(params) {\n// 处理逻辑\n});</br>\n```\r\n然后，可以通过`setDimensionIndex`方法来对其他图表模拟`dimensionHover`效果，API详情参考[vchart API](https%3A%2F%2Fvisactor.io%2Fvchart%2Fapi%2FAPI%2Fvchart%23setdimensionindex)。</br>\r\n```\nvChart.setDimensionIndex(value, {\n// options\n});</br>\n```\r\n其中，</br>\r\n*  `value`是dimension值，</br>\r\n*  `options`是DimensionIndexOption类型的参数，可以用来筛选要触发dimension效果的轴、配置tooltip和crosshair等。</br>\r\n# 相关文档\r\n\r\n*  [vchart on API](https%3A%2F%2Fvisactor.io%2Fvchart%2Fapi%2FAPI%2Fvchart%23on)</br>\r\n*  [vchart setDimensionIndex API](https%3A%2F%2Fvisactor.io%2Fvchart%2Fapi%2FAPI%2Fvchart%23setdimensionindex)</br>\r\n\r\n"
  },
  {
    fileName: "80-How can the background color of the funnel chart's conversion layers be modified.md",
    content:
      "# 漏斗图转化层的背景颜色如何修改？\n\n## 问题描述\n\n在漏斗图中转化层用于描述不同阶段或步骤之间的转化过程。\n漏斗图的转化层的背景颜色通常默认为单一颜色，如何修改漏斗图转化层的背景颜色，以提高可视化的效果和可读性？\n\n## 解决方案\n\nVChart 的漏斗图已经提供了对应的功能，允许用户在 `transform` 配置中设置转化层的图元样式。\n若要改变漏斗图转化层的背景颜色，可以通过配置 `transform.style.fill` 修改转化层的背景色。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'funnel',\n  maxSize: '75%',\n  minSize: '10%',\n  isTransform: true,\n  shape: 'rect',\n  transform: {\n    style: {\n      fill: '#44b15920',\n      lineWidth: 4,\n      stroke: 'white'\n    }\n  },\n  label: {\n    visible: true\n  },\n  outerLabel: {\n    visible: true,\n    position: 'right',\n    style: {\n      text: datum => {\n        return `${datum.percent * 100}%`;\n      }\n    }\n  },\n  transformLabel: {\n    visible: true,\n    style: {\n      fill: '#000000'\n    }\n  },\n  data: [\n    {\n      name: 'funnel',\n      values: [\n        {\n          value: 100,\n          name: 'Resume Screening',\n          percent: 1\n        },\n        {\n          value: 80,\n          name: 'Resume Evaluation',\n          percent: 0.8\n        },\n        {\n          value: 50,\n          name: 'Evaluation Passed',\n          percent: 0.5\n        },\n        {\n          value: 30,\n          name: 'Interview',\n          percent: 0.3\n        },\n        {\n          value: 10,\n          name: 'Final Pass',\n          percent: 0.1\n        }\n      ]\n    }\n  ],\n  categoryField: 'name',\n  valueField: 'value'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [漏斗图转化层 示例](https://visactor.io/vchart/demo/funnel-chart/rect-funnel?keyword=funnelChart)\n- [漏斗图配置项 文档](https://visactor.io/vchart/option/funnelChart#transform)\n"
  },
  {
    fileName: '81- How to solve the issue of the upper area chart obscuring the lower point chart in a combo chart.md',
    content:
      '---\ntitle: 3. 如何解决在组合图中，上层面积图遮挡下层点图的问题？</br>\n---\r\n# 问题标题\r\n\r\n如何解决在组合图中，上层面积图遮挡下层点图的问题？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我在使用VChart创建了一个组合图，其中包含两个子图，子图类型都是面积图。因为第二个子图绘制在第一个子图的上面，所以它的区域会遮挡住第一个子图的数据点，使得第一个子图的数据点无法触发hover和click事件。我想问一问，有没有什么方法可以解决这个问题？</br>\r\n图表的配置如下：</br>\r\n```\nconst spec = {\n*2*  "data": [...],\n*3*  "series": [\n*4*    {\n*5*      "id": "area",\n*6*      "type": "area",\n*7*      "xField": "time",\n*8*      "yField": "value",\n*9*      "seriesField": "groupName",\n*10*      ...\n*11*    },\n*12*    {\n*13*      "id": "compare",\n*14*      "type": "area",\n*15*      "name": "compare",\n*16*      "xField": "time",\n*17*      "yField": "compareValue",\n*18*      "seriesField": "groupName",\n*19*      ...\n*20*      "interactive": {\n*21*        "line": false,\n*22*        "area": false\n*23*      }\n*24*    }\n*25*  ]\n*26*}\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderAsync();</br>\n```\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Rju6bObFcoMEHmx1N8WcWTTWnxe.gif\' alt=\'\' width=\'2990\' height=\'1132\'>\r\n\r\n# 解决方案\r\n\r\n这个问题可以通过设置第二个面积图series的`line.interactive`和`area.interactive`属性为`false`来解决。配置如下:</br>\r\n```\n{\n"data": [...],\n"series": [\n{\n"id": "area",\n"type": "area",\n"xField": "time",\n"yField": "value",\n"seriesField": "groupName",\n...\n},\n{\n"id": "compare",\n"type": "area",\n"name": "compare",\n"xField": "time",\n"yField": "compareValue",\n"seriesField": "groupName",\n...\n"line":{\n"interactive":false\n},\n"area":{\n"interactive":false\n},\n}\n]\n}</br>\n```\r\n\r\n\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/IFQrb9E9HoyhAWx6y3xcZS3Dn7f.gif\' alt=\'\' width=\'3134\' height=\'1454\'>\r\n\r\n这样，第二个面积子图就不会响应交互事件，用户的hover和click事件可以透过第二个面积子图触发第一个面积子图的数据点。</br>\r\n\r\n\r\n# 结果展示\r\n\r\n使用上述配置，进行图表渲染，你会发现，第二个子图的线和面积图都不会再响应鼠标操作，这样就可以成功触发第一个子图的hover和click了。</br>\r\n在线效果参考：https://codesandbox.io/s/common-chart-interactive-jtmc92?file=/src/index.ts</br>\r\n# 相关文档\r\n\r\n相关api：https://www.visactor.io/vchart/api/API/vchart</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n'
  },
  {
    fileName: '82-How to use chart components in Taro.md',
    content:
      "# 如何在 Taro 框架中使用图表组件？\n\n## 问题描述\n\n我想要在 Taro 框架中使用图表组件，有哪些开箱即用的图表库推荐吗？\n\n## 解决方案\n\n不同的图表库有不同的解决方案，下面介绍下 [VChart](https://www.visactor.io/vchart/) 图表库的使用，为了方便用户快速接入，VChart 封装了对应的图表组件：`@visactor/taro-vchart`，目前该组件支持的环境有：\n\n- `tt` 字节小程序。\n- `lark` 飞书小程序。\n- `h5` 浏览器环境, 与`web`等价。\n- `web` 浏览器环境, 与`h5`等价。\n\n在使用上也非常简单，直接声明组件，传入对应的图表配置即可：\n\n```\n<VChart\n  type=\"tt\"\n  spec={spec}\n  canvasId=\"pie\"\n  style={{ height: '35vh', width: '100%' }}\n  onChartInit={chart => {\n    console.log('init pie');\n  }}\n  onChartReady={chart => {\n    console.log('ready pie');\n  }}\n  onChartUpdate={chart => {\n    console.log('update pie');\n  }}\n/>\n```\n\n## 代码示例\n\n可以直接查看我们的代码仓库：[链接](https://github.com/VisActor/VChart/blob/develop/packages/taro-vchart/gallery/pages/chart/index.tsx)\n\n## 结果展示\n\n下面以飞书小程序为例，看一下 VChart 在飞书小程序上的表现：\n\nClone 下我们的仓库：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)，运行：\n\n```\n# clone\n$ git clone git@github.com:VisActor/VChart.git\n$ cd VChart\n# 安装依赖\n$ rush update\n# 编译\n$ rush run -p @visactor/taro-vchart -s dev:lark\n```\n\n然后用飞书开发者工具打开导入 `packages/taro-vchart/dist`即可。\n\n![](/vchart/faq/90-1.png)\n\n## 相关文档\n\n- [跨端兼容说明](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/mini-app/how)\n- [Taro 使用教程](https://www.visactor.io/vchart/guide/tutorial_docs/cross-terminal_and_developer_ecology/taro)\n"
  },
  {
    fileName: '83-How to Customize Colors for Different Series in Dual-Axis Chart.md',
    content:
      "# 线、柱双轴图中，如何自定义不同系列的颜色？\n\n## 问题描述\n\nI have a dual-axis chart consisting of a line graph and a bar graph. There can be multiple lines in the line graph and multiple bars in the bar graph.\nIn a dual-axis chart consisting of both line and bar graphs, how freely define the colors and other details for each bar and line?\n\n## 解决方案\n\nVChart 图表提供了对应的能力，支持通过配置 scale 来自由控制数据与值的映射关系。在双轴图图，控制颜色就可以使用 scale 来控制各个图形字段使用特定的颜色值。\n更具体的配置规则，可参考：https://visactor.io/vchart/option/barChart#scales.domain\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: 'Monday', type: 'Breakfast', y: 15 },\n        { x: 'Monday', type: 'Lunch', y: 25 },\n        { x: 'Tuesday', type: 'Breakfast', y: 12 },\n        { x: 'Tuesday', type: 'Lunch', y: 30 },\n        { x: 'Wednesday', type: 'Breakfast', y: 15 },\n        { x: 'Wednesday', type: 'Lunch', y: 24 },\n        { x: 'Thursday', type: 'Breakfast', y: 10 },\n        { x: 'Thursday', type: 'Lunch', y: 25 },\n        { x: 'Friday', type: 'Breakfast', y: 13 },\n        { x: 'Friday', type: 'Lunch', y: 20 },\n        { x: 'Saturday', type: 'Breakfast', y: 10 },\n        { x: 'Saturday', type: 'Lunch', y: 22 },\n        { x: 'Sunday', type: 'Breakfast', y: 12 },\n        { x: 'Sunday', type: 'Lunch', y: 19 }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: 'Monday', type: 'Beverage', y: 22 },\n        { x: 'Tuesday', type: 'Beverage', y: 43 },\n        { x: 'Wednesday', type: 'Beverage', y: 33 },\n        { x: 'Thursday', type: 'Beverage', y: 22 },\n        { x: 'Friday', type: 'Beverage', y: 10 },\n        { x: 'Saturday', type: 'Beverage', y: 30 },\n        { x: 'Sunday', type: 'Beverage', y: 50 }\n      ]\n    }\n  ],\n  color: {\n    type: 'ordinal',\n    field: 'type',\n    domain: ['Breakfast', 'Lunch', 'Beverage'],\n    range: ['lightPink', 'lightBlue', 'purple']\n  },\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: ['x', 'type'],\n      yField: 'y'\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: [0] },\n    { orient: 'right', seriesId: ['line'], grid: { visible: false } },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [VChart Scale 教程](https://visactor.io/vchart/option/barChart#scales.domain)\n"
  },
  {
    fileName: '84- How to configure the style of legend pager arrows in VChart.md',
    content:
      "---\ntitle: 40. VChart 中图例翻页器箭头的样式如何配置？</br>\n---\r\n## 问题标题\r\n\r\nVChart 中图例翻页器箭头的样式如何配置？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n我使用了暗色主题，希望把翻页器样式调整的更显眼一些，该如何配置？</br>\r\n\r\n\r\n## 解决方案\r\n\r\n图例翻页器对应的配置为 `pager`。</br>\r\n*  图例文字颜色可以通过 `pager.textStyle.fill`进行配置。</br>\r\n*  翻页器按钮颜色可以通过 `pager.handler.style.fill` 进行配置。</br>\r\n*  翻页按钮不可用状态下的样式，需要通过 `pager.handler.state.disable.fill` 进行配置。</br>\r\n例如：</br>\r\n```\n  legends: {\n    visible: true,\n    pager:{\n      textStyle:{\n        fill:\"rgb(170,170,170)\"\n      },\n      handler:{\n        style:{\n          fill:'rgb(170,170,170)'\n        },\n        state:{\n          disable:{\n            fill:'rgb(47,69,84)'\n          }\n        }\n      }\n    }\n  },</br>\n```\r\n## 代码示例 \r\n\r\n```\n\nconst spec = {\n  type: 'pie',\n  theme:\"dark\",\n  width: 300,\n  height: 300,\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  legends: {\n    visible: true,\n    pager:{\n      textStyle:{\n        fill:\"rgb(170,170,170)\"\n      },\n      handler:{\n        style:{\n          fill:'rgb(170,170,170)'\n        },\n        state:{\n          disable:{\n            fill:'rgb(47,69,84)'\n          }\n        }\n      }\n    }\n  },\n}\n\nconst vchart = new VChart((spec), { dom: CONTAINER_ID });\nvchart.renderSync();\n\nvchart.getCanvas().style.outline = '1px solid orange';\n</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UjPEbcU1so3qHexIPN9cGX1inGf.gif' alt='' width='600' height='600'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  相关配置：https://visactor.io/vchart/option/barChart-legends-discrete#pager</br>\r\n*  github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '85-How to display scales at several points on the x-axis of an area chart.md',
    content:
      "# 面积图 x 轴如何隔几个点显示刻度？\n\n## 问题描述\n\n类似（https://www.visactor.io/vchart/demo/area-chart/null-value-area）这样的面积图里面数据比较多，比如几百条。当某些轴上的标签内容过长时，很容易出现重叠或者视觉过于密集的情况，需要按一定的间隔去展示X轴上的刻度。\n\n这类图表有配置使得坐标轴每隔几个点显示刻度，类似 echarts 的 interval 那种的么？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中只需要开启轴采样就可以避免坐标轴文字遮挡的问题。\n\n- sampling 是否开启轴数据采样，默认开启。轴采样开启之后，会对轴数据进行采样显示，防止轴数据的重叠。\n  如果你还想自定义轴标签之间的间距，通过配置 label.minGap 可以控制轴标签之间的间距。\n- 通过 minGap 可以自定义标签之间的最小间距（单位为像素）。仅当轴采样开始时生效（sampling: true）。 该配置会影响轴采样的结果。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'area',\n  data: {\n    values: [\n      { month: '1980-05', vacancies: 36.7 },\n      { month: '1980-08', vacancies: 37.5 },\n      { month: '1980-11', vacancies: 38.7 },\n      { month: '1981-02', vacancies: 37.4 },\n      { month: '1981-05', vacancies: 44 },\n      { month: '1981-08', vacancies: 44.5 },\n      { month: '1981-11', vacancies: 41.7 },\n      { month: '1982-02', vacancies: 37.3 },\n      { month: '1982-05', vacancies: 30.3 },\n      { month: '1982-08', vacancies: 26.8 },\n      { month: '1982-11', vacancies: 30.3 },\n      { month: '1983-02', vacancies: 29.7 },\n      { month: '1983-05', vacancies: 32.4 },\n      { month: '1983-08', vacancies: 33.6 },\n      { month: '1983-11', vacancies: 36.3 },\n      { month: '1984-02', vacancies: 44.6 },\n      { month: '1984-05', vacancies: 40.3 },\n      { month: '1984-08', vacancies: 48.5 },\n      { month: '1984-11', vacancies: 49.8 },\n      { month: '1985-02', vacancies: 60.4 },\n      { month: '1985-05', vacancies: 68.6 },\n      { month: '1985-08', vacancies: 67.2 },\n      { month: '1985-11', vacancies: 66.2 },\n      { month: '1986-02', vacancies: 64.8 },\n      { month: '1986-05', vacancies: 66.1 },\n      { month: '1986-08', vacancies: 61.1 },\n      { month: '1986-11', vacancies: 66.3 },\n      { month: '1987-02', vacancies: 69.5 },\n      { month: '1987-05', vacancies: 66.9 },\n      { month: '1987-08', vacancies: 70.1 },\n      { month: '1987-11', vacancies: 66.9 },\n      { month: '1988-02', vacancies: 70.2 },\n      { month: '1988-05', vacancies: 74.4 },\n      { month: '1988-08', vacancies: 80.8 },\n      { month: '1988-11', vacancies: 85.1 },\n      { month: '1989-02', vacancies: 84.7 },\n      { month: '1989-05', vacancies: 93.7 },\n      { month: '1989-08', vacancies: 76.6 },\n      { month: '1989-11', vacancies: 79.2 },\n      { month: '1990-02', vacancies: 71.9 },\n      { month: '1990-05', vacancies: 64 },\n      { month: '1990-08', vacancies: 56.7 },\n      { month: '1990-11', vacancies: 41.6 },\n      { month: '1991-02', vacancies: 33.8 },\n      { month: '1991-05', vacancies: 31.6 },\n      { month: '1991-08', vacancies: 29.8 },\n      { month: '1991-11', vacancies: 30.9 },\n      { month: '1992-02', vacancies: 33.3 },\n      { month: '1992-05', vacancies: 31.9 },\n      { month: '1992-08', vacancies: 33 },\n      { month: '1992-11', vacancies: 36.9 },\n      { month: '1993-02', vacancies: 37 },\n      { month: '1993-05', vacancies: 42 },\n      { month: '1993-08', vacancies: 46.2 },\n      { month: '1993-11', vacancies: 48.5 },\n      { month: '1994-02', vacancies: 57.6 },\n      { month: '1994-05', vacancies: 69.5 },\n      { month: '1994-08', vacancies: 82.2 },\n      { month: '1994-11', vacancies: 85.6 },\n      { month: '1995-02', vacancies: 72.7 },\n      { month: '1995-05', vacancies: 77.3 },\n      { month: '1995-08', vacancies: 74.6 },\n      { month: '1995-11', vacancies: 72.5 },\n      { month: '1996-02', vacancies: 81 },\n      { month: '1996-05', vacancies: 76.7 },\n      { month: '1996-08', vacancies: 77.5 },\n      { month: '1996-11', vacancies: 82.5 },\n      { month: '1997-02', vacancies: 81.3 },\n      { month: '1997-05', vacancies: 82.8 },\n      { month: '1997-08', vacancies: 84.9 },\n      { month: '1997-11', vacancies: 90.4 },\n      { month: '1998-02', vacancies: 98.3 },\n      { month: '1998-05', vacancies: 104 },\n      { month: '1998-08', vacancies: 89.8 },\n      { month: '1998-11', vacancies: 102 },\n      { month: '1999-02', vacancies: 87.2 },\n      { month: '1999-05', vacancies: 100.2 },\n      { month: '1999-08', vacancies: 106.9 },\n      { month: '1999-11', vacancies: 109.6 },\n      { month: '2000-02', vacancies: 118.1 },\n      { month: '2000-05', vacancies: 115.9 },\n      { month: '2000-08', vacancies: 114.4 },\n      { month: '2000-11', vacancies: 114.8 },\n      { month: '2001-02', vacancies: 99.7 },\n      { month: '2001-05', vacancies: 94 },\n      { month: '2001-08', vacancies: 90.2 },\n      { month: '2001-11', vacancies: 88.5 },\n      { month: '2002-02', vacancies: 90.5 },\n      { month: '2002-05', vacancies: 96.2 },\n      { month: '2002-08', vacancies: 103 },\n      { month: '2002-11', vacancies: 97.6 },\n      { month: '2003-02', vacancies: 109.7 },\n      { month: '2003-05', vacancies: 104.6 },\n      { month: '2003-08', vacancies: 104.1 },\n      { month: '2003-11', vacancies: 107.5 },\n      { month: '2004-02', vacancies: 103.8 },\n      { month: '2004-05', vacancies: 127.1 },\n      { month: '2004-08', vacancies: 124.6 },\n      { month: '2004-11', vacancies: 139.2 },\n      { month: '2005-02', vacancies: 146.2 },\n      { month: '2005-05', vacancies: 140.9 },\n      { month: '2005-08', vacancies: 139 },\n      { month: '2005-11', vacancies: 134.1 },\n      { month: '2006-02', vacancies: 144.3 },\n      { month: '2006-05', vacancies: 154.1 },\n      { month: '2006-08', vacancies: 154.9 },\n      { month: '2006-11', vacancies: 162.1 },\n      { month: '2007-02', vacancies: 160.8 },\n      { month: '2007-05', vacancies: 168.6 },\n      { month: '2007-08', vacancies: 173.3 },\n      { month: '2007-11', vacancies: 183.3 },\n      { month: '2008-02', vacancies: 178.2 },\n      { month: '2008-05', vacancies: 184.5 },\n      { month: '2008-08', vacancies: null },\n      { month: '2008-11', vacancies: null },\n      { month: '2009-02', vacancies: null },\n      { month: '2009-05', vacancies: null },\n      { month: '2009-08', vacancies: null },\n      { month: '2009-11', vacancies: 148.9 },\n      { month: '2010-02', vacancies: 168.4 },\n      { month: '2010-05', vacancies: 170.3 },\n      { month: '2010-08', vacancies: 178.6 },\n      { month: '2010-11', vacancies: 191.1 },\n      { month: '2011-02', vacancies: 189.4 },\n      { month: '2011-05', vacancies: 187.3 },\n      { month: '2011-08', vacancies: 183.4 },\n      { month: '2011-11', vacancies: 179.3 },\n      { month: '2012-02', vacancies: 181.8 },\n      { month: '2012-05', vacancies: 178.1 },\n      { month: '2012-08', vacancies: 175.3 },\n      { month: '2012-11', vacancies: 164.8 },\n      { month: '2013-02', vacancies: 149.8 },\n      { month: '2013-05', vacancies: 143.5 },\n      { month: '2013-08', vacancies: 140.6 },\n      { month: '2013-11', vacancies: 138.9 },\n      { month: '2014-02', vacancies: 143.2 },\n      { month: '2014-05', vacancies: 147.4 },\n      { month: '2014-08', vacancies: 146.6 },\n      { month: '2014-11', vacancies: 149.7 },\n      { month: '2015-02', vacancies: 151.9 },\n      { month: '2015-05', vacancies: 157.7 },\n      { month: '2015-08', vacancies: 161.7 },\n      { month: '2015-11', vacancies: 167.4 },\n      { month: '2016-02', vacancies: 172.2 },\n      { month: '2016-05', vacancies: 171.1 },\n      { month: '2016-08', vacancies: 177.5 },\n      { month: '2016-11', vacancies: 182.3 },\n      { month: '2017-02', vacancies: 185 },\n      { month: '2017-05', vacancies: 185.6 },\n      { month: '2017-08', vacancies: 200.9 },\n      { month: '2017-11', vacancies: 204.4 },\n      { month: '2018-02', vacancies: 212.8 },\n      { month: '2018-05', vacancies: 223.8 },\n      { month: '2018-08', vacancies: 228.7 },\n      { month: '2018-11', vacancies: 230.2 },\n      { month: '2019-02', vacancies: 232.4 },\n      { month: '2019-05', vacancies: 228.1 },\n      { month: '2019-08', vacancies: 224.3 },\n      { month: '2019-11', vacancies: 226.7 },\n      { month: '2020-02', vacancies: 227.4 },\n      { month: '2020-05', vacancies: 129.2 },\n      { month: '2020-08', vacancies: 206.3 },\n      { month: '2020-11', vacancies: 254.1 },\n      { month: '2021-02', vacancies: 288 },\n      { month: '2021-05', vacancies: 370.2 },\n      { month: '2021-08', vacancies: 333.9 },\n      { month: '2021-11', vacancies: 397.2 },\n      { month: '2022-02', vacancies: 421.9 },\n      { month: '2022-05', vacancies: 480.1 }\n    ]\n  },\n  xField: 'month',\n  yField: 'vacancies',\n  invalidType: 'break',\n  point: {\n    visible: false\n  },\n  title: {\n    text: 'Job vacancies, seasonally adjusted',\n    subtext: 'Source: Australian Bureau of Statistics, 30 June 2022'\n  },\n  axes: [\n    {\n      orient: 'left',\n      title: {\n        visible: true,\n        text: 'thousands'\n      }\n    },\n    {\n      orient: 'bottom',\n      sampling: true,\n      label: {\n        minGap: 100\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/scales-at-several-points-on-the-x-axis-xxnp9r)\n\n## 相关文档\n\n- [存在空值的面积图 demo](https://www.visactor.io/vchart/demo/area-chart/null-value-area)\n- [面积图教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Area)\n- [相关 api](https://www.visactor.io/vchart/option/areaChart#axes-band.sampling)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '86- How to emphasize a specific point in a vchart line chart.md',
    content:
      "---\ntitle: 41. vchart折线图如何支持强调某个点</br>\n---\r\n# 问题标题\r\n\r\nvchart折线图是否支持强调某个点？</br>\r\n# 问题描述\r\n\r\n在使用vchart的时候，我碰到了一个问题。我正在制作一个折线图，我想问一下这个折线图可以支持强调某个点吗？</br>\r\n# 解决方案\r\n\r\n可以实现这个功能。可以通过配置opacity和size来实现，通过函数配置，基于数据匹配需要高亮的点，设置他的透明度和大小，让其更加突出。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Lse1b8ILRo1aP5xTPDLcFP38nIb.gif' alt='' width='1268' height='1054'>\r\n\r\n图元的函数配置可以参考链接：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Mark</br>\r\n# 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  percent: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  animationAppear: {\n    duration: 1500,\n    easing: 'linear'\n  },\n  point: {\n    style: {\n      opacity: (datum) => {\n        return datum.type === 'Eyeliner' && datum.country === 'EU' ? 1 : 0.6\n      },\n      size: (datum) => {\n        return datum.type === 'Eyeliner' && datum.country === 'EU' ? 10 : 6\n      },\n      stroke: false\n    }\n  },\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\n\nvchart.renderSync();</br>\n```\r\n# 结果展示\r\n\r\n代码运行后，EU线段中Eyeliner维度的点被强调出来。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Jrz9bQ0ooogdJdx9YrbcAfq4nOe.gif' alt='' width='1268' height='1054'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/line-chart-single-selected-forked-4px87p?file=%2Fsrc%2Findex.ts%3A3%2C1</br>\r\n# 相关文档\r\n\r\n*  VChart 图元的函数配置：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Mark</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '87- How to handle incomplete label display in VChart pie charts.md',
    content:
      '---\ntitle: 93. VChart 饼图label显示不全, 该如何处理?</br>\n---\r\n## 问题标题\r\n\r\nVChart 饼图label显示不全, 该如何处理?</br>\r\n## 问题描述\r\n\r\n在使用VChart 饼图过程中, 图表比较窄时label会被隐藏，, 我想要其不被隐藏正常展示</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart图表宽度不够导致标签无法布局，这种情况下</br>\r\n1. 通过调整扇区半径`outerRadius`, 预留更多的空间出来.</br>\r\n1. 通过调整文字与连接线的间隔`spaceWidth`</br>\r\n1. 调整一下标签连接线配置`line.line1MinLength` 、`line.line2MinLength`，隐藏连接线或者设置较短的连接线长度.</br>\r\n1. 其它方式: 缩小文字fontSize、使用内部标签等</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "pie",\n      data: [\n        {\n          id: "id0",\n          values: [\n            { type: "oxygen", value: "46.60" },\n            { type: "silicon", value: "27.72" },\n            { type: "aluminum", value: "8.13" },\n            { type: "iron", value: "5" },\n            { type: "calcium", value: "3.63" },\n            { type: "sodium", value: "2.83" },\n            { type: "potassium", value: "2.59" },\n            { type: "others", value: "3.5" },\n          ],\n        },\n      ],\n      outerRadius: 0.8,\n      // Option 1: Set a smaller radius\n      // outerRadius: 0.4,\n      valueField: "value",\n      categoryField: "type",\n      title: {\n        visible: true,\n        text: "Statistics of Surface Element Content",\n      },\n      legends: {\n        visible: true,\n        orient: "bottom",\n      },\n      label: {\n        visible: true,\n        // Option2: Set a smaller space between text and line\n        // spaceWidth: 0,\n\n        // Option3: Set a smaller line1MinLength and line2MinLength for label line.\n        // line: {\n        //   visible: false, // `true` may be better\n        //   line1MinLength: 0,\n        //   line2MinLength: 0,\n        // },\n      },\n      tooltip: {\n        mark: {\n          content: [\n            {\n              key: (datum) => datum["type"],\n              value: (datum) => datum["value"] + "%",\n            },\n          ],\n        },\n      },\n    };\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart" style={{ width: 400 }}></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-large-tooltip-optimize-forked-k9vg2w?file=%2Fsrc%2Findex.js%3A1%2C1-80%2C1</br>\r\n## 相关文档\r\n\r\nPIE API: https://visactor.io/vchart/option/pieChart#label.line.line1MinLength</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '88- How to customize pie chart labels.md',
    content:
      "---\ntitle: 72. 饼图标签如何自定义？</br>\n---\r\n# 问题标题\r\n\r\n饼图标签如何自定义吗？</br>\r\n# 问题描述\r\n\r\nvchart饼图标签能够自定义吗？我希望自定义饼图的标签内容，把数值加上去</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/ImMPbYmeDoYxXRxUaIncYopCn6f.gif' alt='' width='1306' height='930'>\r\n\r\n# 解决方案\r\n\r\n饼图的标签配置在label字段中：https://visactor.io/vchart/option/pieChart#label，该字段有个属性是`formatMethod`，用于格式化label内容：https://visactor.io/vchart/option/pieChart#label.formatMethod，配置函数就可以进行标签的格式化操作，该函数接收的参数包括原始文本，数据等内容，返回一个字符串表示格式化后的标签文本</br>\r\n# 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  label: {\n    visible: true,\n    formatMethod: (text, datum) => {\n      return `${text}: ${datum.value}`\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n# 结果展示\r\n\r\n代码运行后，标签就可以格式化了</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/RfXWbRs8SoXW61xdpDSc1lwbn9d.gif' alt='' width='1266' height='944'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/pie-label-format-9k8wlr?file=%2Fsrc%2Findex.ts%3A48%2C2</br>\r\n# 相关文档\r\n\r\n*  VChart 的官网：https://visactor.io/vchart/</br>\r\n*  formatMethod文档：https://visactor.io/vchart/option/pieChart#label.formatMethod</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '89- How to retrieve all data of the same dimension as the clicked bar in a stacked bar chart.md',
    content:
      "---\ntitle: 36. 当使用堆叠柱状图时，如何在点击事件中获取与被点击柱子同维度的所有数据</br>\n---\r\n## 问题标题\r\n\r\n当使用堆叠柱状图时，如何在点击事件中获取与被点击柱子同维度的所有数据？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n当使用堆叠柱状图时，如何在点击事件中获取与被点击柱子同维度的所有数据？比如点击第一个柱子，返回包含蓝、青、红、绿四种图例所代表的四条数据。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/LzG4bpIHsoGqLlxU15CcfYBWn2d.gif' alt='' width='2260' height='1114'>\r\n\r\n## 解决方案 \r\n\r\n在 VChart 中首先可以先通过监听柱子的点击事件拿到被点击柱子的 x 轴维度信息，然后通过 api 或者直接使用原始数据（如果你能拿到）获取当前图表的数据，然后进行过滤，筛选出同 x 轴维度信息相同的柱子数据即可。如下：</br>\r\n```\n// 监听 bar 图元的 click 事件\nvchart.on('click', { markName: 'bar', level: 'mark' }, (e: any) => {\n  const datum = e.datum as any; // 获取被点击的柱子的信息\n  const chartSpec = e.chart?.getSpec(); // 如果你无法获取当前的 spec，可以通过该方式获取原始 spec\n  const xDimensionValue = datum[chartSpec.xField];\n  const chartData = e.chart.chartData.getSeriesData().latestData; // 如果可以拿到原始数据，也可以直接拿原始数据\n  const filterData = chartData.filter(chartDatum => chartDatum[chartSpec.xField] === xDimensionValue);\n\n  console.log(filterData);\n});\n</br>\n```\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: 'chart' });\nvchart.renderSync();\n\n\n// 监听 bar 图元的 click 事件\nvchart.on('click', { markName: 'bar', level: 'mark' }, (e: any) => {\n  const datum = e.datum as any; // 获取被点击的柱子的信息\n  const chartSpec = e.chart?.getSpec(); // 如果你无法获取当前的 spec，可以通过该方式获取原始 spec\n  const xDimensionValue = datum[chartSpec.xField];\n  const chartData = e.chart.chartData.getSeriesData().latestData; // 如果可以拿到原始数据，也可以直接拿原始数据\n  const filterData = chartData.filter(chartDatum => chartDatum[chartSpec.xField] === xDimensionValue);\n\n  console.log(filterData);\n});</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/DCyEbHQzioOs8Dx8GKhcHYW4n0d.gif' alt='' width='3834' height='1844'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/api/API/event#%E4%BA%8B%E4%BB%B6%E8%BF%87%E6%BB%A4</br>\r\n*  API：https://visactor.io/vchart/api/API/event#%E4%BA%8B%E4%BB%B6%E8%BF%87%E6%BB%A4</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '90-How can VChart achieve a profile effect similar to ECharts.md',
    content:
      "# VChart 如何实现类似 ECharts 的 profile 效果？\n\n# 问题描述\n\n类似 （https://echarts.apache.org/examples/zh/editor.html?c=custom-profile）这样的图表，VChart如何配置支持？\n![demo](/vchart/faq/100-0.png)\n\n# 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中只需要配置区间柱状图(rangeColumn 类型)即可。\n\n# 代码示例\n\n```ts\nconst values = [\n  { type: 'Category One', min: 0, max: 71, group: 0 },\n  { type: 'Category One', min: 83, max: 161, group: 1 },\n  { type: 'Category One', min: 166, max: 253, group: 2 },\n  { type: 'Category One', min: 280, max: 369, group: 3 },\n  { type: 'Category One', min: 388, max: 411, group: 4 },\n  { type: 'Category One', min: 439, max: 488, group: 5 },\n  { type: 'Category One', min: 493, max: 517, group: 6 },\n  { type: 'Category One', min: 539, max: 609, group: 7 },\n  { type: 'Category One', min: 614, max: 678, group: 8 },\n  { type: 'Category One', min: 696, max: 725, group: 9 },\n  { type: 'Category Two', min: 0, max: 75, group: 0 },\n  { type: 'Category Two', min: 90, max: 143, group: 1 },\n  { type: 'Category Two', min: 162, max: 186, group: 2 },\n  { type: 'Category Two', min: 209, max: 244, group: 3 },\n  { type: 'Category Two', min: 266, max: 334, group: 4 },\n  { type: 'Category Two', min: 351, max: 391, group: 5 },\n  { type: 'Category Two', min: 407, max: 435, group: 6 },\n  { type: 'Category Two', min: 460, max: 523, group: 7 },\n  { type: 'Category Two', min: 539, max: 610, group: 8 },\n  { type: 'Category Two', min: 610, max: 612, group: 9 },\n  { type: 'Category Three', min: 0, max: 0, group: 0 },\n  { type: 'Category Three', min: 10, max: 69, group: 1 },\n  { type: 'Category Three', min: 78, max: 123, group: 2 },\n  { type: 'Category Three', min: 128, max: 211, group: 3 },\n  { type: 'Category Three', min: 219, max: 283, group: 4 },\n  { type: 'Category Three', min: 301, max: 375, group: 5 },\n  { type: 'Category Three', min: 393, max: 461, group: 6 },\n  { type: 'Category Three', min: 477, max: 535, group: 7 },\n  { type: 'Category Three', min: 542, max: 584, group: 8 },\n  { type: 'Category Three', min: 600, max: 652, group: 9 }\n];\n\nconst spec = {\n  type: 'rangeColumn',\n  data: [\n    {\n      id: 'data0',\n      values\n    }\n  ],\n  direction: 'horizontal',\n  seriesField: 'group',\n  yField: 'type',\n  xField: ['min', 'max'],\n  label: {\n    visible: false\n  },\n  bar: {\n    style: {\n      height: 60\n    }\n  }\n};\n```\n\n# 结果展示\n\n在线效果参考：https://codesandbox.io/s/vchart-profile-6v2c2l\n![result](/vchart/faq/100-1.png)\n\n# 相关文档\n\nrangeColumn 教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/RangeColumn\n相关 api：https://visactor.io/vchart/option/rangeColumnChart#type\ngithub：https://github.com/VisActor/VChart\n"
  },
  {
    fileName: '91- How to add custom items to a tooltip.md',
    content:
      "---\ntitle: 21. 如何在tooltip中添加自定义项？</br>\n---\r\n\r\n\r\n# **问题标题**\r\n\r\n如何在tooltip中添加自定义项</br>\r\n# **问题描述**\r\n\r\n我在使用line chart时，想要在tooltip中显示“加和”这个项，但是不知道该如何实现。请问该怎么做？</br>\r\n# **解决方案**\r\n\r\n可以使用updateContent来做一个tooltip内容的后处理。</br>\r\n在dimension的content中，可以添加一个key为“加和”的项，value为一个函数，该函数接收一个datumList参数，表示当前tooltip中所有数据的列表，然后计算出所有数据的value的和，返回即可。</br>\r\n在updateContent中，也可以添加一个key为“加和”的项，value为同样的函数，这样就可以在tooltip中显示“加和”这个项了。</br>\r\n\r\n\r\n# **代码示例**\r\n\r\n```\nconst data = [\n  { year: '2012', type: 'Forest', value: 320 },\n  { year: '2012', type: 'Steppe', value: 220 },\n  { year: '2012', type: 'Desert', value: 150 },\n  { year: '2012', type: 'Wetland', value: 98 },\n  { year: '2013', type: 'Forest', value: 332 },\n  { year: '2013', type: 'Steppe', value: 182 },\n  { year: '2013', type: 'Desert', value: 232 },\n  { year: '2013', type: 'Wetland', value: 77 },\n  { year: '2014', type: 'Forest', value: 301 },\n  { year: '2014', type: 'Steppe', value: 191 },\n  { year: '2014', type: 'Desert', value: 201 },\n  { year: '2014', type: 'Wetland', value: 101 },\n  { year: '2015', type: 'Forest', value: 334 },\n  { year: '2015', type: 'Steppe', value: 234 },\n  { year: '2015', type: 'Desert', value: 154 },\n  { year: '2015', type: 'Wetland', value: 99 },\n  { year: '2016', type: 'Forest', value: 390 },\n  { year: '2016', type: 'Steppe', value: 290 },\n  { year: '2016', type: 'Desert', value: 190 },\n  { year: '2016', type: 'Wetland', value: 40 }\n];\nconst aggregation = {};\ndata.forEach(({ year, value }) => {\n  if (!aggregation[year]) {\n    aggregation[year] = 0;\n  }\n  aggregation[year] += value;\n});\nconst spec = {\n  type: 'bar',\n  data: [{ id: 'bar', values: data }],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  bar: { state: { legend_hover_reverse: { fill: '#ccc' } } },\n  legends: { visible: true },\n  tooltip: {\n    mark: {\n      title: { value: (datum) => datum['year'] + '年' },\n      content: [\n        { key: (datum) => datum['type'], value: (datum) => datum['value'] },\n        {\n          hasShape: false,\n          key: 'Proportion',\n          value: (datum) => Math.round((datum['value'] / aggregation[datum['year']]) * 10000) / 100 + '%'\n        }\n      ]\n    },\n    dimension: {\n      title: { value: (datum) => datum['year'] + '年' },\n      content: [{ key: (datum) => datum['type'], value: (datum) => datum['value'] }],\n      updateContent: (prev) => {\n        console.log(prev);\n        const total = prev.reduce((acc, cur) => {\n          return acc + cur.value;\n        }, 0);\n        return (prev ?? []).concat({ key: 'total', value: total });\n      }\n    }\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderAsync(); // Just for the convenience of console debugging, DO NOT COPY! window['vchart'] = vchart;\n</br>\n```\r\n\r\n\r\n# **结果展示**\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/C0vRbB4Vio36lZxApVZcvxLunff.gif' alt='' width='1670' height='1048'>\r\n\r\n\r\n\r\n# **相关文档**\r\n\r\n*  updateContent：https://visactor.bytedance.net/vchart/option/barChart#tooltip.dimension.updateContent</br>\r\n*  github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '92- How to set a segment of a dashed line in a line chart.md',
    content:
      '---\ntitle: 98. 折线图如何设置一段虚线？</br>\n---\r\n## 问题标题\r\n\r\n折线图如何设置一段虚线？</br>\r\n## 问题描述\r\n\r\n在特定场景下， 折线图可能需要表达“总计”， “预测”等信息， 这时候一条折线可能需要用另外一种样式来可视化这些特殊的信息， 将折线图改为虚线样式， 是一个很不错的方案。</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart 折线图提供 lineDash 配置， 允许用户通过设置回调函数控制一截线段的样式为虚线， 也包括其它的一些样式。</br>\r\n\r\n\r\n折线图可以通过配置`line.style.lineDash`来根据控制虚线。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "line",\n      data: {\n        values: [\n          {\n            x: "1st",\n            y: 0.012,\n          },\n          {\n            x: "2nd",\n            y: -0.01,\n          },\n          {\n            x: "3rd",\n            y: 0.005,\n          },\n          {\n            x: "4th",\n            y: 0.007,\n          },\n          {\n            x: "5th",\n            y: 0.01,\n          },\n          {\n            x: "6th",\n            y: 0.017,\n          },\n          {\n            x: "7th",\n            y: 0.022,\n          },\n          {\n            x: "8th (prediction)",\n            y: 0.033,\n            isDash: true,\n          },\n        ],\n      },\n      xField: "x",\n      yField: "y",\n      line: {\n        style: {\n          lineDash: (data) => {\n            if (data.isDash) {\n              return [5, 5];\n            }\n            return [0];\n          },\n        },\n      },\n    };\n\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart" style={{ width: 400 }}></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-single-bar-style-forked-86hvzw</br>\r\n## 相关文档\r\n\r\nLineDash API: https://visactor.io/vchart/option/lineChart#line.style.lineDash(number%5B%5D)</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '93-How to set the style of the line segments in a line chart, such as dashed at the end.md',
    content:
      "# 如何设置折线的分段样式，比如 末尾虚线？\n\n## 问题描述\n\n我有一个折线图的需求，折线的最后一个数据点是预测数据，所以想要折线最后一段能显示成虚线，类似下面这张图。这个要怎么实现更方便？\n![demo](/vchart/faq/19-0.png)\n\n## 解决方案\n\n推荐你使用 VChart，官网 demo 正有你需要的效果：https://visactor.io/vchart/demo/line-chart/dash-line\n可以在 line 的图元样式回调里，根据数据返回不同的样式。\n\n- `lineDash`：虚线模式。它使用一组值来指定描述模式的线和间隙的交替长度。\n\n```js\nline: {\n  style: {\n    stroke: (data) => data.latest ? 'blue': 'green',\n    lineDash: data => data.latest ? [5, 5]: [0]\n  }\n},\npoint: {\n  style: {\n    fill: (data) => data.latest ? 'blue': 'green',\n  }\n}\n```\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        x: '1st',\n        y: 0.012\n      },\n      {\n        x: '2nd',\n        y: -0.01\n      },\n      {\n        x: '3rd',\n        y: 0.005\n      },\n      {\n        x: '4th',\n        y: 0.007\n      },\n      {\n        x: '5th',\n        y: 0.01\n      },\n      {\n        x: '6th',\n        y: 0.017\n      },\n      {\n        x: '7th',\n        y: 0.022\n      },\n      {\n        x: '8th (prediction)',\n        y: 0.033,\n        latest: true\n      }\n    ]\n  },\n  xField: 'x',\n  yField: 'y',\n  line: {\n    style: {\n      stroke: data => (data.latest ? 'blue' : 'green'),\n      lineDash: data => (data.latest ? [5, 5] : [0])\n    }\n  },\n  point: {\n    style: {\n      fill: data => (data.latest ? 'blue' : 'green')\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [更多示例](https://visactor.io/vchart/demo/line-chart/dash-line)\n- [相关 API](https://visactor.io/vchart/option/lineChart#line.style)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '94- How to set the background width during bar chart interaction.md',
    content:
      "---\ntitle: 69. 如何设置柱状图交互时的背景宽度？</br>\n---\r\n## 问题标题\r\n\r\n如何设置柱状图交互时的背景宽度？</br>\r\n## 问题描述\r\n\r\n我想让hover时的柱子背景和柱子之间保留部分padding，我可以如何设置呢？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/RmUgblfEQovGlvxN7JqcmNXZnme.gif' alt='' width='1490' height='1160'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\ncorsshair组件负责交互时的背景柱子显示，如果要让背景和柱子之间留有空隙，可以通过设置宽度百分比来实现，比如：设置corsshair.xField.line.width: '200%'</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/XC4jb64ylo8lxzxgvFec475Zncf.gif' alt='' width='3298' height='1130'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'Autocracies', year: '1960', value: 126 },\n        { type: 'Autocracies', year: '1970', value: 117 },\n        { type: 'Autocracies', year: '1980', value: 114 },\n        { type: 'Autocracies', year: '1990', value: 111 },\n        { type: 'Autocracies', year: '2000', value: 89 },\n        { type: 'Autocracies', year: '2010', value: 80 },\n        { type: 'Autocracies', year: '2018', value: 80 },\n        { type: 'Democracies', year: '1960', value: 29 },\n        { type: 'Democracies', year: '1970', value: 38 },\n        { type: 'Democracies', year: '1980', value: 41 },\n        { type: 'Democracies', year: '1990', value: 57 },\n        { type: 'Democracies', year: '2000', value: 87 },\n        { type: 'Democracies', year: '2010', value: 98 },\n        { type: 'Democracies', year: '2018', value: 99 }\n      ]\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  legends: {\n    visible: true,\n    orient: 'top',\n    position: 'start'\n  },\n  crosshair: {\n    xField: {\n      line: {\n        width: '130%'\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/svg-symbol-8k9tdz?file=%2Fsrc%2Findex.ts%3A208%2C29</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JbyIb4AqRook65xmPrHcdW2bnlN.gif' alt='' width='1616' height='988'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n十字准星教程: https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Crosshair</br>\r\n相关api：https://www.visactor.io/vchart/option/barChart#crosshair.xField.line.width</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '95- How to achieve edge-aligned x-axis labels in a trend chart.md',
    content:
      "---\ntitle: 30. 如何实现趋势图的x轴标签贴边的效果</br>\n---\r\n## 问题标题\r\n\r\n如何实现趋势图的x轴标签贴边的效果？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如图示，趋势图的x轴最左侧的标签能够和图表区域的左边界对齐，最右侧的标签能够和图表区域的右边界对齐吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Sha7bJOumozRPIx1UOlcka6Onzb.gif' alt='' width='2738' height='568'>\r\n\r\n## 解决方案 \r\n\r\n*  当轴的类型为`band`的时候，可以通过配置`trimPadding: true`消除左右两侧的`padding`</br>\r\n*  `label.flush`值为 `true`，表示轴标签往内缩进，不超过轴的范围</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/FZMFbZIvDo3VFax1C45cyOnknlc.gif' alt='' width='3396' height='1196'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: 'Stacked line chart'\n  },\n  stack: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  lineLabel: { visible: true },\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  axes: [{\n    orient: 'bottom',\n    trimPadding: true,\n    label: {\n      flush: true\n    }\n  }],\n};</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/C9SJbmusLozVvUxjGrwcnWGJnnh.gif' alt='' width='1630' height='996'>\r\n\r\n## 相关文档\r\n\r\n*  [坐标轴教程 ](https%3A%2F%2Fvisactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FAxes)</br>\r\n*  [VChart github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n\r\n"
  },
  {
    fileName: '96-How to display the complete information of the legend when hovering.md',
    content:
      "# 如何 hover 时显示图例的完整信息？\n\n## 问题描述\n\n如下图所示，图例的文本被省略了，要怎么配置让 hover 上去显示完整文本？\n\n![](/vchart/faq/84-0.png)\n\n## 解决方案 Solution\n\n不同的图表库解决方案不同，在 [VChart](https://visactor.io/vchart/) 上默认支持了省略文本的完整文本展示，只需要 hover 上去就可以显示。\n\n## 结果展示\n\n在线效果参考：[https://visactor.io/vchart/demo/legend/custom-data](https://visactor.io/vchart/demo/legend/custom-data)\n\n```javascript livedemo\nconst data = [\n  { value: 10, category: 'One' },\n  { value: 9, category: 'Two' },\n  { value: 6, category: 'Three' },\n  { value: 5, category: 'Four' },\n  { value: 4, category: 'Five' },\n  { value: 3, category: 'Six' },\n  { value: 1, category: 'Seven' }\n];\nlet totalValue = 0;\ndata.forEach(obj => (totalValue += obj.value));\nconst map = {};\ndata.forEach(obj => {\n  map[obj.category] = `${((obj.value / totalValue) * 100).toFixed(2)}%`;\n});\n\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'pie',\n      values: data\n    }\n  ],\n  categoryField: 'category',\n  valueField: 'value',\n  legends: {\n    visible: true,\n    orient: 'right',\n    data: items => {\n      return items.map(item => {\n        item.value = map[item.label];\n        return item;\n      });\n    },\n    item: {\n      width: '15%',\n      value: {\n        alignRight: true,\n        style: {\n          fill: '#333',\n          fillOpacity: 0.8,\n          fontSize: 10\n        },\n        state: {\n          unselected: {\n            fill: '#d8d8d8'\n          }\n        }\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\n\nvchart.on('legendItemHover', e => {\n  const hoveredName = e?.value?.data?.label;\n  if (hoveredName) {\n    vchart.updateState({\n      legend_hover_reverse: {\n        filter: d => d.type !== hoveredName\n      }\n    });\n  }\n});\nvchart.on('legendItemUnHover', e => {\n  vchart.updateState({\n    legend_hover_reverse: {\n      filter: d => false\n    }\n  });\n});\n\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n图例 demo：[https://visactor.io/vchart/demo/legend/custom-data](https://visactor.io/vchart/demo/legend/custom-data)\n\n图例教程：[https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend)\n\n图例配置：[https://visactor.io/vchart/option/barChart#legends-discrete.type](https://visactor.io/vchart/option/barChart#legends-discrete.type)\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '97-How to use chart library in mini program.md',
    content:
      '# 如何在小程序中使用图表库？\n\n## 问题描述\n\n我想要在小程序上绘制图表，有哪些开箱即用的图表库推荐吗？\n\n## 解决方案\n\n不同的图表库有不同的解决方案，下面介绍下 [VChart](https://www.visactor.io/vchart/) 图表库的支持情况，目前 VChart 支持了飞书小程序、飞书小组件以及 taro 跨端框架的图表渲染，使用时非常简单，只需要在初始化图表示例的时候声明对应的跨端环境参数即可，图表配置项使用及功能上同 PC 表现一致。\n\n## 代码示例\n\n我们提供了飞书小组件以及飞书小程序的 demo 实例：\n\n- 飞书小程序：https://github.com/VisActor/lark-vchart-example\n- 飞书小组件：https://github.com/VisActor/VChart/tree/develop/packages/block-vchart\n\n## 结果展示\n\n下面是在 飞书小程序上的图表渲染实例：\n\n![](/vchart/faq/83-0.gif)\n\n## 相关文档\n\n- [跨端兼容说明](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/mini-app/how)\n- [飞书小程序使用教程](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/mini-app/block)\n- [飞书小组件使用教程](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/mini-app/block)\n'
  },
  {
    fileName: '98- How to customize legends in React.md',
    content:
      '---\ntitle: 48. 如何以 React 的方式， 自定义图例？</br>\n---\r\n## 问题标题\r\n\r\n如何以 React 的方式， 自定义图例？</br>\r\n## 问题描述\r\n\r\n很多场景下， 需要让图例拥有更丰富的效果， 例如在长图例存在时， 添加...缩略， 并提供 Tooltip， 通常情况下， 图表库默认提供的图例功能， 并不能完美满足用户的需求。</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样， VChart 对图例功能进行了抽象， 提供`getLegendSelectedDataByIndex` 与 `setLegendSelectedDataByIndex` 接口， 让用户通过`html` 自定义图例， 实现预期的效果。</br>\r\n可以迅速使用 react 将自定义 VChart 图表的图例。</br>\r\n步骤一： 将图例配置设置为不可见， 即`visible: false`</br>\r\n步骤二： 通过`getLegendSelectedDataByIndex` 判断图例需要选中或取消选中</br>\r\n步骤三： 通过`setLegendSelectedDataByIndex` 使用 API 操作图例的选中或取消。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect, useRef, useState, useCallback } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  const ref = useRef(null);\n  const data = [\n    { year: "2000", type: "A", sales: 22 },\n    { year: "2000", type: "B", sales: 11 },\n\n    { year: "2001", type: "A", sales: 22 },\n    { year: "2001", type: "B", sales: 11 },\n  ];\n  const spec = {\n    type: "bar",\n    data: [\n      {\n        id: "barData",\n        values: data,\n      },\n    ],\n    legends: {\n      visible: false,\n    },\n    xField: ["year", "type"],\n    yField: "sales",\n    seriesField: "type",\n  };\n\n  useEffect(() => {\n    const vchart = new VChart(spec, { dom: "chart" });\n    ref.current = vchart;\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  const handleSelect = (value) => () => {\n    const selected = ref.current.getLegendSelectedDataByIndex();\n\n    if (selected.includes(value)) {\n      // cancel\n      const newSelected = [...selected];\n      const index = newSelected.indexOf(value);\n      newSelected.splice(index, 1);\n      ref.current.setLegendSelectedDataByIndex(0, newSelected);\n    } else {\n      // select\n      ref.current.setLegendSelectedDataByIndex(0, [...selected, value]);\n    }\n  };\n\n  const customLegend = Array.from(new Set(data.map((d) => d.type))).map(\n    (name) => {\n      return (\n        <div\n          onClick={handleSelect(name)}\n          style={{\n            textAlign: "center",\n            border: "1px solid gray",\n            marginBottom: 8,\n            cursor: "pointer",\n          }}\n        >\n          {/* do any custom thing using html  */}\n          {name + "...................................."}\n        </div>\n      );\n    }\n  );\n\n  return (\n    <div>\n      <div id="chart"></div>\n      {customLegend}\n    </div>\n  );\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-react-tooltip-df558t?file=%2Fsrc%2Findex.js%3A58%2C1</br>\r\n## 相关文档\r\n\r\nLegend Event API: https://visactor.io/vchart/api/API/vchart</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '99- Can a line chart be segmented.md',
    content:
      "---\ntitle: 71. 折线图能分段吗？</br>\n---\r\n# 问题标题\r\n\r\n折线图能分段吗？</br>\r\n# 问题描述\r\n\r\nvchart折线图有个点不想显示，能让折线图分段吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Awlfbudq1o4LVFx7rs3cxBQxnWg.gif' alt='' width='1036' height='726'>\r\n\r\n# 解决方案\r\n\r\n如果某个点的值不合法，VChart会默认屏蔽掉这个点，可以将数据中的这个点对应的value设置为null即可。</br>\r\n比如下面数据10:00对应的点就不会显示了</br>\r\n```\ndata: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: null\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  }</br>\n```\r\n# 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: null\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n# 结果展示\r\n\r\n代码运行后，10:00对应的点就不会显示了，折线就分段了</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/M5IEbg02OoW0yLxYiYxcO1LknUd.gif' alt='' width='1000' height='578'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/line-point-split-fq7wkh?file=%2Fsrc%2Findex.ts%3A49%2C2</br>\r\n# 相关文档\r\n\r\n*  VChart 的官网：https://visactor.io/vchart/</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '100-How can Tooltip achieve multi column display in VChart.md',
    content:
      "# VChart 中 Tooltip 如何实现多列显示？\n\n# 问题描述\n\n类似 （https://visactor.io/vchart/demo/tooltip/format-method?keyword=tooltip）这样的图表，希望tooltip能格式化成多列\n![demo](/vchart/faq/96-0.png)\n\n# 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中需要通过自定义 tooltip 的功能自行实现 tooltip 的多列样式。\n![demo](/vchart/faq/96-1.png)\n\n# 代码示例\n\n```ts\nconst data = [\n  { year: '2012', type: 'Forest', value: 320 },\n  { year: '2012', type: 'Steppe', value: 220 },\n  { year: '2012', type: 'Desert', value: 150 },\n  { year: '2012', type: 'Wetland', value: 98 },\n  { year: '2013', type: 'Forest', value: 332 },\n  { year: '2013', type: 'Steppe', value: 182 },\n  { year: '2013', type: 'Desert', value: 232 },\n  { year: '2013', type: 'Wetland', value: 77 },\n  { year: '2014', type: 'Forest', value: 301 },\n  { year: '2014', type: 'Steppe', value: 191 },\n  { year: '2014', type: 'Desert', value: 201 },\n  { year: '2014', type: 'Wetland', value: 101 },\n  { year: '2015', type: 'Forest', value: 334 },\n  { year: '2015', type: 'Steppe', value: 234 },\n  { year: '2015', type: 'Desert', value: 154 },\n  { year: '2015', type: 'Wetland', value: 99 },\n  { year: '2016', type: 'Forest', value: 390 },\n  { year: '2016', type: 'Steppe', value: 290 },\n  { year: '2016', type: 'Desert', value: 190 },\n  { year: '2016', type: 'Wetland', value: 40 }\n];\nconst aggregation = {};\ndata.forEach(({ year, value }) => {\n  if (!aggregation[year]) {\n    aggregation[year] = 0;\n  }\n  aggregation[year] += value;\n});\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'bar',\n      values: data\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  bar: {\n    state: {\n      legend_hover_reverse: {\n        fill: '#ccc'\n      }\n    }\n  },\n  legends: {\n    visible: true\n  },\n  tooltip: {\n    mark: {\n      title: {\n        value: datum => datum['year'] + '年'\n      },\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value']\n        },\n        {\n          hasShape: false,\n          key: 'Proportion',\n          value: datum => Math.round((datum['value'] / aggregation[datum['year']]) * 10000) / 100 + '%'\n        }\n      ]\n    },\n    dimension: {\n      title: {\n        value: datum => datum['year'] + '年'\n      },\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value']\n        },\n        {\n          hasShape: false,\n          key: datum => datum['type'] + ' Proportion',\n          value: datum => Math.round((datum['value'] / aggregation[datum['year']]) * 10000) / 100 + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nvchart.setTooltipHandler({\n  showTooltip: (activeType, tooltipData, params) => {\n    // some code of custom tooltip\n    let tooltip = document.getElementById('custom-tooltip');\n    console.log(params);\n    if (!tooltip) {\n      tooltip = document.createElement('div');\n      tooltip.id = 'custom-tooltip';\n      document.getElementById(CONTAINER_ID).appendChild(tooltip);\n      const title = document.createElement('p');\n      title.id = 'custom-tooltip-title';\n      title.style['fontWeight'] = 'bolder';\n      tooltip.appendChild(title);\n      const content = document.createElement('div');\n      content.id = 'custom-tooltip-content';\n      content.style.display = 'flex';\n      content.style.flexDirection = 'row';\n      tooltip.appendChild(content);\n      const leftC = document.createElement('div');\n      leftC.style.display = 'flex';\n      leftC.style.flexDirection = 'column';\n      leftC.style.justifyContent = 'center';\n      const s = document.createElement('div');\n      s.id = 'custom-tooltip-symbol';\n      s.style.width = '10px';\n      s.style.height = '10px';\n      leftC.appendChild(s);\n      const rightC = document.createElement('div');\n      rightC.style.width = '200px';\n      rightC.style.display = 'flex';\n      rightC.style.justifyContent = 'space-around';\n      content.appendChild(leftC);\n      content.appendChild(rightC);\n      const r1 = document.createElement('div');\n      r1.id = 'custom-tooltip-r1';\n      const r2 = document.createElement('div');\n      r2.id = 'custom-tooltip-r2';\n      const r3 = document.createElement('div');\n      r3.id = 'custom-tooltip-r3';\n      r3.style.color = 'grey';\n      rightC.appendChild(r1);\n      rightC.appendChild(r2);\n      rightC.appendChild(r3);\n    }\n\n    if (!tooltip || activeType !== 'mark') return;\n    const datum = tooltipData[0].datum[0];\n    const series = tooltipData[0].series;\n    console.log(activeType, tooltipData, params, datum);\n    tooltip.style.visibility = 'visible';\n    tooltip.style.left = params.event.x + 20 + 'px';\n    tooltip.style.top = params.event.y + 20 + 'px';\n    tooltip.style.position = 'absolute';\n    tooltip.style.background = 'white';\n    tooltip.style.padding = '10px';\n    const title = document.getElementById('custom-tooltip-title');\n    title.innerText = datum['year'] + '年';\n    const s = document.getElementById('custom-tooltip-symbol');\n    s.style.background = series.getSeriesStyle(datum)('fill');\n    const r1 = document.getElementById('custom-tooltip-r1');\n    const r2 = document.getElementById('custom-tooltip-r2');\n    const r3 = document.getElementById('custom-tooltip-r3');\n    r1.innerText = datum['type'];\n    r2.innerText = Math.round((datum['value'] / aggregation[datum['year']]) * 10000) / 100 + '%';\n    r3.innerText = datum['value'];\n  },\n  hideTooltip: () => {\n    // hide your custom tooltip\n    const tooltip = document.getElementById('custom-tooltip');\n    if (!tooltip) return;\n    tooltip.style.visibility = 'hidden';\n  }\n});\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n# 结果展示\n\n在线效果参考：https://codesandbox.io/s/tooltip-multicolumn-j9s8x7\n![result](/vchart/faq/96-2.png)\n\n# 相关文档\n\nTooltip 教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip\n相关 api：https://visactor.io/vchart/option/barChart#tooltip.visible\ngithub：https://github.com/VisActor/VChart\n"
  },
  {
    fileName: '101- How to configure nested pie charts in VChart.md',
    content:
      "---\ntitle: 43. VChart 怎么配置嵌套饼图</br>\n---\r\n## 问题标题\r\n\r\n如何配置嵌套饼图</br>\r\n## 问题描述\r\n\r\n如何配置嵌套饼图</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/X5rvbMnx4oUs28xpfGMcSTy3nue.gif' alt='' width='3572' height='2454'>\r\n\r\n## 解决方案 \r\n\r\nVChart 可以配置多个 pie-series 然后将它们的半径配置为：内圈的外半径 = 外圈的内半径，这样就能实现嵌套饼图</br>\r\n还有类似嵌套饼图的玫瑰图，可以选择根据业务场景选择。</br>\r\n*  outerRadius: number // 外半径，百分比数值</br>\r\n*  innerRadius: number // 内半径，百分比数值</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'common',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: '0~29', value: '126.04' },\n        { type: '30~59', value: '128.77' },\n        { type: '60 and over', value: '77.09' }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { type: '0~9', value: '39.12' },\n        { type: '10~19', value: '43.01' },\n        { type: '20~29', value: '43.91' },\n        { type: '30~39', value: '45.4' },\n        { type: '40~49', value: '40.89' },\n        { type: '50~59', value: '42.48' },\n        { type: '60~69', value: '39.63' },\n        { type: '70~79', value: '25.17' },\n        { type: '80 and over', value: '12.29' }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'pie',\n      dataIndex: 0,\n      outerRadius: 0.65,\n      innerRadius: 0,\n      valueField: 'value',\n      categoryField: 'type',\n      label: { position: 'inside', visible: true }\n    },\n    {\n      type: 'pie',\n      dataIndex: 1,\n      outerRadius: 0.8,\n      innerRadius: 0.67,\n      valueField: 'value',\n      categoryField: 'type',\n      label: {\n        visible: true\n      }\n    }\n  ],\n  color: ['#98abc5', '#8a89a6', '#7b6888', '#6b486b', '#a05d56', '#d0743c', '#ff8c00'],\n  legends: {\n    visible: true,\n    orient: 'left'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/V6MPbbC1koZZFVxP1dEc0f5ynHc.gif' alt='' width='1339' height='540'>\r\n\r\nDemo: https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-xkzpxq?file=%2Fsrc%2Findex.js%3A43%2C31</br>\r\n## 相关文档\r\n\r\nDemo：https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-xkzpxq?file=%2Fsrc%2Findex.js%3A43%2C31</br>\r\n教程：</br>\r\n*  初始化VChart： https://visactor.io/vchart/api/API/vchart</br>\r\n*  饼图半径配置：https://www.visactor.io/vchart/option/pieChart#outerRadius</br>\r\n*  玫瑰图：https://www.visactor.io/vchart/demo/rose-chart/rose-stacked?keyword=roseChart</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '102-How to automatically update chart data in React components.md',
    content:
      '# React 组件中如何自动更新图表数据？\n\n## 问题描述\n\n使用 React 封装的图表组件，如何实现自动更新图表数据？\n\n## 解决方案\n\n在 VChart 中，可以调用 updateSpec 或者 updateData 进行图表更新。\n你可以在初始化图表实例时，在 React 组件中使用 ref 保存图表实例。随后使用 useEffect，将 deps 设置为数据更新的依赖项，在回调函数中调用图表实例的 updateData 实现数据更新。\n\nVChart 还提供了 React-VChart 封装：\nhttps://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/react\n你可以参考下面的代码示例，使用 React-VChart 实现图表数据更新。\n\n## 代码示例\n\n点击 Update the data of bar chart 按钮，可以实现更新图表数据。\n\n```javascript\nimport "./styles.css";\nimport { BarChart } from "./BarChart";\nimport { LineChart } from "./LineChart";\nimport { AreaChart } from "./AreaChart";\nimport { getBarData } from "./bar-data";\nimport { useState } from "react";\n\nconst colorMaps = {\n  default: [\n    "#6690F2",\n    "#70D6A3",\n    "#B4E6E2",\n    "#63B5FC",\n    "#FF8F62",\n    "#FFDC83",\n    "#BCC5FD",\n    "#A29BFE",\n    "#63C4C7",\n    "#F68484"\n  ],\n  red: [\n    "#c12e34",\n    "#e6b600",\n    "#0098d9",\n    "#2b821d",\n    "#005eaa",\n    "#339ca8",\n    "#cda819",\n    "#32a487"\n  ]\n};\n\nexport default function App() {\n  const [barData, setBarData] = useState<any[]>(getBarData());\n  const [colors, setColors] = useState<string[]>(colorMaps.default);\n  const handleUpdateBarData = () => {\n    setBarData(getBarData());\n  };\n\n  const handleUpdateColors = () => {\n    if (colors === colorMaps.default) {\n      setColors(colorMaps.red);\n    } else {\n      setColors(colorMaps.default);\n    }\n  };\n\n  return (\n    <div className="App">\n      <div>\n        <img src="https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/logo_500_200_light.png" />\n      </div>\n      <button onClick={handleUpdateBarData}>\n        Update the data of bar chart\n      </button>\n\n      <button onClick={handleUpdateColors}>update colors</button>\n\n      <h2>A Bar Chart</h2>\n\n      <BarChart data={barData} colors={colors} />\n\n      <h2>A Line Chart</h2>\n      <LineChart colors={colors} />\n\n      <h2>A Area Chart</h2>\n      <AreaChart colors={colors} />\n    </div>\n  );\n}\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/visactor-vchart-react-demo-forked-jsqqjj)\n\n## 相关文档\n\n- [react-vchart](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/react)\n- [github](https://github.com/VisActor/VChart)\n'
  },
  {
    fileName: '103-How to change the hover display content when the mouse is moved into the chart area.md',
    content:
      "# 鼠标移入图表区域，hover 显示内容怎么更换？\n\n## 问题描述\n\n我把鼠标移动到一个柱状图里头之后，被 hover 的柱子会显示一个悬浮框展示柱子的数据信息。我想要把这个 hover 之后的显示内容换成其他的数据内容，请问应该怎么实现呢？\n\n![bar](/vchart/faq/79-0.png)\n\n## 解决方案\n\n图表中图元被 hover 之后显示的提示信息一般被称为 tooltip。在 VChart 中，开发者可以通过 tooltip 组件的配置自定义提示信息的标题以及每行显示的内容。Tooltip 的提示信息包含两种交互形式，一种是 hover 在图元上的交互，另一种是 hover 在数据维度上的交互，两者可以分别通过 tooltip.mark 与 tooltip.dimension 来配置。\n\n![tooltip](/vchart/faq/79-1.png)\n\n除了自定义 tooltip 的显示文本，VChart 也允许用户通过 tooltip handler 渲染任意内容，例如在 tooltip 中展示一个额外的图表：\n\n![tooltip-example](/vchart/faq/79-2.png)\n\n[参考示例](https://www.visactor.io/vchart/demo/tooltip/custom-tooltip-handler?keyword=tooltip)\n\n## 代码示例\n\n```javascript livedemo\nconst data = [\n  { year: '2012', type: 'Forest', value: 320 },\n  { year: '2012', type: 'Steppe', value: 220 },\n  { year: '2012', type: 'Desert', value: 150 },\n  { year: '2012', type: 'Wetland', value: 98 },\n  { year: '2013', type: 'Forest', value: 332 },\n  { year: '2013', type: 'Steppe', value: 182 },\n  { year: '2013', type: 'Desert', value: 232 },\n  { year: '2013', type: 'Wetland', value: 77 },\n  { year: '2014', type: 'Forest', value: 301 },\n  { year: '2014', type: 'Steppe', value: 191 },\n  { year: '2014', type: 'Desert', value: 201 },\n  { year: '2014', type: 'Wetland', value: 101 },\n  { year: '2015', type: 'Forest', value: 334 },\n  { year: '2015', type: 'Steppe', value: 234 },\n  { year: '2015', type: 'Desert', value: 154 },\n  { year: '2015', type: 'Wetland', value: 99 },\n  { year: '2016', type: 'Forest', value: 390 },\n  { year: '2016', type: 'Steppe', value: 290 },\n  { year: '2016', type: 'Desert', value: 190 },\n  { year: '2016', type: 'Wetland', value: 40 }\n];\nconst aggregation = {};\ndata.forEach(({ year, value }) => {\n  if (!aggregation[year]) {\n    aggregation[year] = 0;\n  }\n  aggregation[year] += value;\n});\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'bar',\n      values: data\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  bar: {\n    state: {\n      legend_hover_reverse: {\n        fill: '#ccc'\n      }\n    }\n  },\n  legends: {\n    visible: true\n  },\n  tooltip: {\n    mark: {\n      title: {\n        value: datum => datum['year'] + '年'\n      },\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value']\n        },\n        {\n          hasShape: false,\n          key: 'Proportion',\n          value: datum => Math.round((datum['value'] / aggregation[datum['year']]) * 10000) / 100 + '%'\n        }\n      ]\n    },\n    dimension: {\n      title: {\n        value: datum => datum['year'] + '年'\n      },\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value']\n        },\n        {\n          hasShape: false,\n          key: datum => datum['type'] + ' Proportion',\n          value: datum => Math.round((datum['value'] / aggregation[datum['year']]) * 10000) / 100 + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [Tooltip Tutorial](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip)\n- [Related api](https://visactor.io/vchart/option/barChart#tooltip.visible)\n"
  },
  {
    fileName:
      '104- Issues with x-axis data overlapping and y-axis data not displaying when using the vchart library.md',
    content:
      "---\ntitle: 67. 使用vchart图表库时x轴数据重叠和y轴数据不显示的问题</br>\n---\r\n# 问题标题\r\n\r\n使用vchart图表库时x轴数据重叠和y轴数据不显示的问题</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我在使用vchart图表库制作柱状图的时候遇到问题。无论我在模拟器还是真机上测试，x轴（下轴）的数据会出现重叠的情况。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/U31SbU8VPojbmPxZQTrcRdc2n3r.gif' alt='' width='784' height='362'>\r\n\r\n此外，我还注意到有一些柱状图的顶部标签会被挪到柱子内部，这是正常的吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/KJgPbbvTsoz3VixX8j8chWMMnwb.gif' alt='' width='742' height='472'>\r\n\r\n# 解决方案\r\n\r\n有以下解决方案：</br>\r\n对于x轴数据重叠的问题，这是因为关闭了sampling设置。原来是希望x轴的所有数据都能展示出来，结果导致了数据重叠的情况。可以使用滚动条来解决这个问题，为图表添加如下配置：</br>\r\n`scrollBar: [ { orient: 'bottom', start: 0, end: 0.5, roam: true } ]`</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JrHObctlUoUZ4exawCwc1CeOn2b.gif' alt='' width='2410' height='1134'>\r\n\r\n对于柱状图顶部标签被挪到柱子内部的问题，这是因为防止标签相互重叠，系统自动进行了调整。可以通过设置标签配置overlap为false来关闭该功能：</br>\r\n`label: {overlap: false}`</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HTvTbHfV2o2VVwx0tBYcq8CQnge.gif' alt='' width='446' height='232'>\r\n\r\n# 结果展示\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/line-chart-shows-on-the-left-most-of-canvas-forked-ytl8dz</br>\r\n# 相关文档\r\n\r\n*  VChart scrollbar教程文档：https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Scrollbar</br>\r\n*  VChart label overlap文档：https://www.visactor.io/vchart/option/barChart#label.overlap</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '105- How to customize Tooltip shapes.md',
    content:
      "---\ntitle: 75. 如何自定义Tooltip形状</br>\n---\r\n# 问题标题\r\n\r\n如何自定义Tooltip形状？</br>\r\n# 问题描述\r\n\r\nVchart的tooltip前面的形状有办法自定义吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Qna8brigEorxmgxFUelcdSFUnnb.gif' alt='' width='1290' height='970'>\r\n\r\n# 解决方案\r\n\r\nvchart的Spec中有tooltip相关的配置，配置tooltip属性即可。tooltip的mark属性表示hover到图元上的效果https://visactor.io/vchart/option/pieChart#tooltip.mark。mark.content表示内容的配置，在mark.content中配置shapeType字段就可以</br>\r\n# 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  tooltip: { \n    mark: \n    { \n      content: { \n        key: datum => datum['type'],\n        value: datum => datum['value'] + '%',\n        shapeType: 'square' \n      } \n    },\n  },\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  label: {\n    visible: true\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n# 结果展示\r\n\r\n代码运行后，tooltip的symbol就变成了矩形</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Pm2Tbl4q5oPBqBxwkBScXyXEnYe.gif' alt='' width='1272' height='904'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/tooltip-shape-cdzny7?file=%2Fsrc%2Findex.ts%3A44%2C2</br>\r\n# 相关文档\r\n\r\n*  VChart 的官网：https://visactor.io/vchart/</br>\r\n*  VChart的tooltip配置：https://visactor.io/vchart/option/pieChart#tooltip.mark</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '106- How to set a default selection for a sector in a VChart pie chart.md',
    content:
      "---\ntitle: 83. VChart  饼图如何设置默认选中一个区域？</br>\n---\r\n## 问题标题\r\n\r\nVChart  饼图如何设置默认选中一个区域？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n饼图第一次绘制的时候，希望能够突出显示一个区块，该如何配置？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/CQA7bNAUjoNeyQxFKZ2cylYmnNd.gif' alt='' width='336' height='346'>\r\n\r\n## 解决方案\r\n\r\n\r\n\r\n1. 首先，需要在图表 spec 配置中，设置 selected 状态下的图形样式：</br>\r\n```\n pie: {\n    state: {\n      selected: { \n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },</br>\n```\r\n1. 通过 setSelected API 来设置默认选中的数据项</br>\r\n```\nconst vchart = new VChart(spec, { dom });\nvchart.renderSync();\nvchart.setSelected({\n    // one data record\n})</br>\n```\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  pie: {\n    state: {\n      selected: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n \n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nvchart.setSelected({ type: 'oxygen'})\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HOnJbPcH0oVnvtx9Vp8cUQ8xnag.gif' alt='' width='1662' height='1044'>\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  相关 demo：https://visactor.io/vchart/demo/pie-chart/ring</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName:
      '107-How can we still make data points respond to hover events without displaying point graphics in area chart.md',
    content:
      "# 面积图，如何不显示 point 图形 的情况下，仍然能让数据点响应 hover 事件？\n\n## 问题描述\n\n期望在面积图中不显示点，但是依然可以通过 vchart.on('pointerover', ...) 获取到点被 hover 的事件消息\n\n## 解决方案\n\nVChart 的图形配置 visible:false 后确实不会再响应交互事件。但是可以通过设置透明度为 0 的方式，使点不可见，但依然能响应交互事件\n\n```ts\n{\n  point: {\n     style: {\n       fillOpacity: 0,\n       strokeOpacity: 0,\n     }\n  }\n}\n```\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'area',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  point: {\n    style: {\n      fillOpacity: 0,\n      strokeOpacity: 0\n    }\n  },\n  xField: 'time',\n  yField: 'value'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [点的样式配置](https://www.visactor.io/vchart/option/areaChart#point.style.fillOpacity)\n- [事件监听文档](https://www.visactor.io/vchart/api/API/event)\n"
  },
  {
    fileName: '108-How to configure the axis scale alignment of a two-axis graph.md',
    content:
      "# 47.如何配置双轴图的坐标轴刻度对齐？\n\n## 问题描述\n\n我在使用 VChart 图表时，请问下这两条横坐标左右的数据可以配置对齐吗？效果相当于两条坐标轴重叠。\n\n![tooltip](/vchart/faq/47-0.png)\n\n## 解决方案\n\nVChart 中提供了这样的配置，如果你需要同步轴的范围使 0 值对齐，可以参考文档中的配置：[https://visactor.io/vchart/option/barChart#axes-linear.sync.axisId](https://visactor.io/vchart/option/barChart#axes-linear.sync.axisId)\n\n通过 sync 指定右轴向左轴对齐即可。需要注意的是：需要为左轴定义 id，以便能够在其他轴中指定它。\n\n## 代码示例\n\n```javascript\nspec.axes = [\n  {\n    orient: 'left',\n    id: 'left_axis',\n    seriesIndex: [0]\n  },\n  {\n    orient: 'right',\n    seriesId: ['line'],\n    grid: {\n      visible: false\n    },\n    sync: {\n      axisId: 'left_axis',\n      zeroAlign: true\n    }\n  }\n];\n```\n\n## 结果展示\n\n![demo](/vchart/faq/47-1.png)\n\nDemo: [https://codesandbox.io/s/dual-axis-zero-align-9y49w3?file=/src/index.ts](https://codesandbox.io/s/dual-axis-zero-align-9y49w3?file=/src/index.ts)\n\n## 相关文档\n\nAxis option: [https://visactor.io/vchart/option/barChart#axes-linear.sync.axisId](https://visactor.io/vchart/option/barChart#axes-linear.sync.axisId)\n\ngithub: [https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '109-How to implement a combination of line chart and stacked bar chart.md',
    content:
      "## 如何实现折线图和堆积柱状图的组合？\n\n## 问题描述\n\n类似[这样的组合图](https://www.visactor.io/vchart/demo/combination/single-region?keyword=commonChart)\n\n![bar chart](/vchart/faq/31-0.png)\n\n可以实现柱图是堆积的效果吗？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中对 组合图 中的柱系列，设置 `stack: true`\n\n![code](/vchart/faq/31-1.png)\n\n## 代码示例\n\n```\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '周一', type: '早餐', y: 15 },\n        { x: '周一', type: '午餐', y: 25 },\n        { x: '周二', type: '早餐', y: 12 },\n        { x: '周二', type: '午餐', y: 30 },\n        { x: '周三', type: '早餐', y: 15 },\n        { x: '周三', type: '午餐', y: 24 },\n        { x: '周四', type: '早餐', y: 10 },\n        { x: '周四', type: '午餐', y: 25 },\n        { x: '周五', type: '早餐', y: 13 },\n        { x: '周五', type: '午餐', y: 20 },\n        { x: '周六', type: '早餐', y: 10 },\n        { x: '周六', type: '午餐', y: 22 },\n        { x: '周日', type: '早餐', y: 12 },\n        { x: '周日', type: '午餐', y: 19 }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '周一', type: '饮料', y: 22 },\n        { x: '周二', type: '饮料', y: 43 },\n        { x: '周三', type: '饮料', y: 33 },\n        { x: '周四', type: '饮料', y: 22 },\n        { x: '周五', type: '饮料', y: 10 },\n        { x: '周六', type: '饮料', y: 30 },\n        { x: '周日', type: '饮料', y: 50 }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      label: { visible: true },\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: 'x',\n      yField: 'y',\n      stack: true\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { id: 'leftYAxis', orient: 'left', seriesIndex: [0, 1], nice: true },\n    { id: 'rightYAxis', orient: 'right', seriesIndex: [0, 1], grid: { visible: false } },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: { visible: true, orient: 'bottom' }\n};\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/stack-bar-chart-and-line-cz9xv)\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '周一', type: '早餐', y: 15 },\n        { x: '周一', type: '午餐', y: 25 },\n        { x: '周二', type: '早餐', y: 12 },\n        { x: '周二', type: '午餐', y: 30 },\n        { x: '周三', type: '早餐', y: 15 },\n        { x: '周三', type: '午餐', y: 24 },\n        { x: '周四', type: '早餐', y: 10 },\n        { x: '周四', type: '午餐', y: 25 },\n        { x: '周五', type: '早餐', y: 13 },\n        { x: '周五', type: '午餐', y: 20 },\n        { x: '周六', type: '早餐', y: 10 },\n        { x: '周六', type: '午餐', y: 22 },\n        { x: '周日', type: '早餐', y: 12 },\n        { x: '周日', type: '午餐', y: 19 }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '周一', type: '饮料', y: 22 },\n        { x: '周二', type: '饮料', y: 43 },\n        { x: '周三', type: '饮料', y: 33 },\n        { x: '周四', type: '饮料', y: 22 },\n        { x: '周五', type: '饮料', y: 10 },\n        { x: '周六', type: '饮料', y: 30 },\n        { x: '周日', type: '饮料', y: 50 }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      label: { visible: true },\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: 'x',\n      yField: 'y',\n      stack: true\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { id: 'leftYAxis', orient: 'left', seriesIndex: [0, 1], nice: true },\n    {\n      id: 'rightYAxis',\n      orient: 'right',\n      seriesIndex: [0, 1],\n      grid: { visible: false }\n    },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n```\n\n## 相关文档\n\n- [组合图教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination)\n- [组合图配置](https://www.visactor.io/vchart/option/commonChart#type)\n- [轴同步配置](https://www.visactor.io/vchart/option/commonChart#axes-linear.sync.axisId)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '110-How to customize pointer style in a gauge chart.md',
    content:
      "# 如何自定义仪表图指针样式？\n\n## 问题描述\n\n图表库仪表图的指针样式可以自定义吗？哪个图表库可以自定义？应该怎么自定义呢？\n\n就像这个 demo，我应该加什么配置？\n\n[https://www.visactor.io/vchart/demo/example/gauge-chart/gauge-progress](https://www.visactor.io/vchart/demo/example/gauge-chart/gauge-progress)\n\n## 解决方案\n\nVChart 可以。可以参照以下 demo，为仪表图指针设置自定义的 path。要求指针圆心的坐标在(0, 0)点。\n\n## 代码示例\n\n```javascript livedemo\nconst pointerPath =\n  'M-0.020059 -0.978425 C-0.018029 -0.9888053 -0.013378 -1 0 -1 C0.01342 -1 0.01812 -0.989146 0.0201 -0.978425 C0.02161 -0.9702819 0.0692 -0.459505 0.09486 -0.184807 C0.10298 -0.097849 0.1089 -0.034548 0.11047 -0.018339 C0.11698 0.04908 0.07373 0.11111 0.00002 0.11111 C-0.07369 0.11111 -0.117184 0.04991 -0.110423 -0.018339 C-0.103662 -0.086591 -0.022089 -0.9680447 -0.020059 -0.978425Z';\nconst circlePath =\n  'M1 0 C1 0.55228 0.55228 1 0 1 C-0.552285 1 -1 0.55228 -1 0 C-1 -0.552285 -0.552285 -1 0 -1 C0.55228 -1 1 -0.552285 1 0Z';\n\nconst spec = {\n  type: 'gauge',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        {\n          type: '目标A',\n          value: 0.6\n        }\n      ]\n    }\n  ],\n  radiusField: 'type',\n  angleField: 'value',\n  seriesField: 'type',\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  startAngle: -225,\n  endAngle: 45,\n  gauge: {\n    type: 'circularProgress',\n    progress: {\n      style: {\n        fill: {\n          gradient: 'conical',\n          stops: [\n            {\n              offset: 0,\n              color: '#4FC6B4'\n            },\n            {\n              offset: 1,\n              color: '#31679E'\n            }\n          ]\n        }\n      }\n    },\n    track: {\n      style: {\n        fill: '#ccc'\n      }\n    }\n  },\n  pointer: {\n    width: 0.5,\n    height: 0.5,\n    style: {\n      path: pointerPath,\n      fill: '#5A595E'\n    }\n  },\n  pin: {\n    style: {\n      path: circlePath,\n      fill: '#888'\n    }\n  },\n  pinBackground: {\n    width: 0.08,\n    height: 0.08,\n    style: {\n      path: circlePath,\n      fill: '#ddd'\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/66-0.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nDemo page: [https://www.visactor.io/vchart/demo/gauge-chart/gauge-gradient](https://www.visactor.io/vchart/demo/gauge-chart/gauge-gradient)\n"
  },
  {
    fileName: '111- How to sort x-axis labels in a combination chart.md',
    content:
      "---\ntitle: 33.组合图如何实现对x轴的标签进行排序排序？</br>\n---\r\n# 问题标题\r\n\r\n组合图如何实现对x轴的标签进行排序排序？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n下面的组合图中，x轴标签没有按照时间进行排序，可以通过`sortDataByAxis`实现排序效果吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/PCBjbhywNoQ1ykxDRsccBNR1n5b.gif' alt='' width='2568' height='1174'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n`sortDataByAxis` 的功能是，让系列的数据按照轴排序，但是不影响轴本身的排序，如果想要让轴上的内容按照所需顺序展示，有两种解决办法：</br>\r\n1. 配置 data 中的 fields，设定需要展示的数据 domain 顺序：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/MyJcb40GNouRZUxtNjucH9pnncd.gif' alt='' width='3406' height='1252'>\r\n\r\n1. 提前对数据按照展示顺序做排序</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      fields: {\n        x: {\n          domain: ['2024-03-20', '2024-03-21', '2024-03-22', '2024-03-23', '2024-03-24', '2024-03-25', '2024-03-26'],\n          sortIndex: 0\n        }\n      },\n      values: [\n        { x: '2024-03-21', type: '需求建议', y: 14 },\n        { x: '2024-03-21', type: '功能缺陷', y: 27 },\n        { x: '2024-03-21', type: '其他', y: 1 },\n        { x: '2024-03-21', type: '操作咨询', y: 16 },\n        { x: '2024-03-26', type: '功能缺陷', y: 26 },\n        { x: '2024-03-26', type: '需求建议', y: 9 },\n        { x: '2024-03-26', type: '操作咨询', y: 17 },\n        { x: '2024-03-26', type: '其他', y: 1 },\n        { x: '2024-03-25', type: '功能缺陷', y: 23 },\n        { x: '2024-03-25', type: '操作咨询', y: 19 },\n        { x: '2024-03-25', type: '需求建议', y: 11 },\n        { x: '2024-03-22', type: '需求建议', y: 6 },\n        { x: '2024-03-22', type: '功能缺陷', y: 22 },\n        { x: '2024-03-22', type: '操作咨询', y: 14 },\n        { x: '2024-03-22', type: '其他', y: 2 },\n        { x: '2024-03-27', type: '功能缺陷', y: 16 },\n        { x: '2024-03-27', type: '其他', y: 3 },\n        { x: '2024-03-27', type: '需求建议', y: 8 },\n        { x: '2024-03-27', type: '操作咨询', y: 8 },\n        { x: '2024-03-23', type: '需求建议', y: 2 },\n        { x: '2024-03-23', type: '功能缺陷', y: 2 },\n        { x: '2024-03-20', type: '操作咨询', y: 2 },\n        { x: '2024-03-20', type: '功能缺陷', y: 2 },\n        { x: '2024-03-24', type: '需求建议', y: 1 }\n      ]\n    },\n    {\n      id: 'id1',\n      fields: {\n        x: {\n          domain: ['2024-03-20', '2024-03-21', '2024-03-22', '2024-03-23', '2024-03-24', '2024-03-25', '2024-03-26'],\n          sortIndex: 0\n        }\n      },\n      values: [\n        { x: '2024-03-21', type: '负面反馈比例', y: 55 },\n        { x: '2024-03-26', type: '负面反馈比例', y: 57 },\n        { x: '2024-03-25', type: '负面反馈比例', y: 62 },\n        { x: '2024-03-22', type: '负面反馈比例', y: 63 },\n        { x: '2024-03-27', type: '负面反馈比例', y: 57 },\n        { x: '2024-03-23', type: '负面反馈比例', y: 75 },\n        { x: '2024-03-20', type: '负面反馈比例', y: 75 },\n        { x: '2024-03-24', type: '负面反馈比例', y: 100 }\n      ]\n    }\n  ],\n  stackSort: true,\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      label: { visible: true },\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: 'x',\n      yField: 'y',\n      stack: true,\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false,\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: [0] },\n    {\n      orient: 'right',\n      seriesId: ['line'],\n      gird: { visible: false },\n      min: 0,\n      max: 100,\n      title: { visible: true, text: '%', position: 'start' }\n    },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: { visible: true, orient: 'bottom' }\n};</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/GYyobZqIzoySnjxYZbCcmwl6nXU.gif' alt='' width='1602' height='1060'>\r\n\r\n## 相关文档\r\n\r\n*  [数据类型与数据定义教程](https%3A%2F%2Fwww.visactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FData%2FData_Types_and_Interface)</br>\r\n*  [VChart github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n\r\n"
  },
  {
    fileName: '112-How to add transition animations when clicking the legend of a funnel chart.md',
    content:
      "# 漏斗图点击图例怎么添加过渡动画？\n\n## 问题描述\n\n我在开发漏斗图。发现点击图例的时候，没有任何动画效果，切换有点生硬，有什么图表库支持图例点击的动画效果配置？  \n![funnel animation](/vchart/faq/16-0.gif)\n\n## 解决方案\n\n推荐你使用 VChart。VChart 的漏斗图在图例筛选时，是有默认过渡动画的，参考官网 [demo](https://visactor.io/vchart/demo/funnel-chart/basic-funnel)。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'funnel',\n  categoryField: 'name',\n  valueField: 'value',\n  data: [\n    {\n      id: 'funnel',\n      values: [\n        {\n          value: 100,\n          name: 'Step1'\n        },\n        {\n          value: 80,\n          name: 'Step2'\n        },\n        {\n          value: 60,\n          name: 'Step3'\n        },\n        {\n          value: 40,\n          name: 'Step4'\n        },\n        {\n          value: 20,\n          name: 'Step5'\n        }\n      ]\n    }\n  ],\n  label: {\n    visible: true\n  },\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [漏斗图示例](https://visactor.io/vchart/demo/funnel-chart/basic-funnel)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '113- How to change bar width in a bar chart.md',
    content:
      "---\ntitle: 74. 柱状图如何改变柱宽</br>\n---\r\n# **问题标题**\r\n\r\n柱状图如何改变柱宽？</br>\r\n# **问题描述**\r\n\r\n我在使用vchart柱状图时，想要设置柱子宽度，但是在文档中没有找到相应的配置项。我试了一些参数，但是都没有成功。请问应该如何设置？</br>\r\n# **解决方案**\r\n\r\nvchart柱状图的柱状大小的设置，可以通过调整柱状图的宽度来实现。柱状图有一个`barWidth`属性，用于调整柱子宽度。</br>\r\n# **示例代码**\r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  barWidth: '60%',\n  barMinWidth: 20,\n  barMaxWidth: 50,\n  xField: 'time',\n  yField: 'value',\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n# **结果展示**\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/BD6lbObJuorIPHxmG4icvDkZnrd.gif' alt='' width='1236' height='990'>\r\n\r\n# **相关文档**\r\n\r\n*  barWidth配置: https://visactor.bytedance.net/vchart/option/barChart#barWidth</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '114-How to add a title and subtitle to a chart in VChart.md',
    content:
      "# 如何给图表添加标题？\n\n## 问题描述\n\n类似[官网示例](https://visactor.io/vchart/demo/line-chart/basic-line)这样的折线图，我希望给图表上方添加标题描述，该如何配置？\n\n## 解决方案\n\n在 VChart 中，只需要配置 `title.text`（标题文本）和 `title.subtext`（副标题文本）即可。\n另外，你可以通过 `title.textStyle` 和 `title.subtextStyle` 配置来分别调整标题的样式。\n\n```js\ntitle: {\n    text: 'Line chart',\n    subtext:\n      'The line chart is a simple, two-dimensional chart with an X and Y axis, each point representing a single value.',\n    textStyle: {\n      fontSize: 20\n    },\n    subtextStyle: {\n      fontStyle: 'italic'\n    }\n}\n```\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 17\n      },\n      {\n        time: '12:00',\n        value: 19\n      },\n      {\n        time: '14:00',\n        value: 19\n      },\n      {\n        time: '16:00',\n        value: 17\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  title: {\n    text: 'Line chart',\n    subtext:\n      'The line chart is a simple, two-dimensional chart with an X and Y axis, each point representing a single value.',\n    textStyle: {\n      fontSize: 20\n    },\n    subtextStyle: {\n      fontStyle: 'italic'\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [更多标题 demo](https://visactor.io/vchart/demo/title/richText-title)\n- [标题教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Title)\n- [相关 API](https://visactor.io/vchart/option/lineChart#title.text)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '115-How to modify the text color of the percentage of the funnel chart.md',
    content:
      "# 漏斗图百分比文字颜色如何修改？\n\n## 问题描述\n\n我看到有的图表库可以绘制这样的转化漏斗图，我希望能够在自定义这个漏斗图里头的百分比的文字，请问这个可以怎么来实现呢？\n\n![funnel](/vchart/faq/81-0.png)\n\n## 解决方案\n\nVChart 漏斗图中的漏斗层标签、转换层标签以及外部标签均支持自定义的样式以及文本内容的设置。可以在对应的 label 配置项中设置 fill 视觉通道的值来指定需要的文本颜色。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'funnel',\n  categoryField: 'name',\n  valueField: 'value',\n  isTransform: true,\n  isCone: false,\n  data: [\n    {\n      id: 'funnel',\n      values: [\n        {\n          value: 5676,\n          name: 'Sent'\n        },\n        {\n          value: 3872,\n          name: 'Viewed'\n        },\n        {\n          value: 1668,\n          name: 'Clicked'\n        },\n        {\n          value: 610,\n          name: 'Add to Cart'\n        },\n        {\n          value: 565,\n          name: 'Purchased'\n        }\n      ]\n    }\n  ],\n  title: {\n    visible: true,\n    text: 'Percentage of the customers have dropped from the sales process'\n  },\n  label: {\n    visible: true\n  },\n  transformLabel: {\n    visible: true,\n    style: {\n      fill: 'red'\n    }\n  },\n  outerLabel: {\n    position: 'right',\n    visible: true\n  },\n  legends: {\n    visible: true,\n    orient: 'top'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [funnelChart transformLabel style spec](https://www.visactor.io/vchart/option/funnelChart#transformLabel.style.fill)\n"
  },
  {
    fileName: '116-How to add background color to the bottom of ring chart when it is set with gaps.md',
    content:
      "# 当环形图设置有间隔时，环形的底部能否增加背景颜色？\n\n## 问题描述\n\n设计稿中环形图的每一块之间设置了间隔，并且在间隔下方还有一个灰的背景环，请问这个效果如何实现？  \n![design](/vchart/faq/21-0.png)\n![detail](/vchart/faq/21-1.png)\n\n## 解决方案\n\n这个效果可以用 VChart 的组合图实现。组合图可以配置两个饼图系列，第一个只有一条数据，用于模拟背景的环形；第二个系列就是常规的饼图系列。需要注意：\n\n- `padAngle`：配置间隔的角度；\n- `innerRadius`/`outerRadius`：配置内外半径。两个系列需要配置相同的内外半径；\n- 系列之间的顺序不要颠倒，因为后配置的系列层级更高；\n- 背景系列建议关闭动画 和 tooltip 交互；\n\n## Code Example\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: '0~9', value: '39.12' },\n        { type: '10~19', value: '43.01' },\n        { type: '20~29', value: '43.91' },\n        { type: '30~39', value: '45.4' },\n        { type: '40~49', value: '40.89' },\n        { type: '50~59', value: '42.48' },\n        { type: '60~69', value: '39.63' },\n        { type: '70~79', value: '25.17' },\n        { type: '80 and over', value: '12.29' }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [{ type: '0~9', value: '1' }]\n    }\n  ],\n  series: [\n    {\n      type: 'pie',\n      id: 'background',\n      dataIndex: 1,\n      outerRadius: 0.8,\n      innerRadius: 0.67,\n      valueField: 'value',\n      categoryField: 'type',\n      animation: false,\n      tooltip: { visible: false },\n      pie: {\n        style: {\n          fill: 'rgb(237,239,242)'\n        }\n      }\n    },\n    {\n      type: 'pie',\n      dataIndex: 0,\n      outerRadius: 0.8,\n      innerRadius: 0.67,\n      valueField: 'value',\n      padAngle: 2,\n      categoryField: 'type',\n      pie: {\n        style: {\n          cornerRadius: 20\n        },\n        state: {\n          hover: {\n            outerRadius: 0.82,\n            innerRadius: 0.65\n          }\n        }\n      }\n    }\n  ],\n  title: {\n    visible: true,\n    text: 'Population Distribution by Age in the United States, 2021 (in millions)',\n    textStyle: {\n      fontFamily: 'Times New Roman'\n    }\n  },\n  legends: {\n    visible: true,\n    orient: 'left',\n    seriesIndex: [1]\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## Quote\n\n- [相关教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination)\n- [相关 API](https://visactor.io/vchart/demo/pie-chart/nested-pie?keyword=pieChart)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '117-How to modify the style of the legend element when the mouse is hovering over the legend.md',
    content:
      "# 如何实现当鼠标悬浮于图例上时 圆形的图例扩大一圈高亮显示 并且去掉长方形的灰色的背景？\n\n## 问题描述\n\n怎么配置图例在鼠标悬浮时的样式，期望可以用图形变大替换灰色背景。\n\n## 解决方案\n\nVChart 的图例提供了图形在被鼠标悬浮时的样式配置，背景也可以关闭的配置\n\n1. item.background.visible 可以用来关闭或者开启图例项的背景\n2. item.shape.state.selectedHover 可以用来设置选中图形被鼠标悬浮时的样式\n3. item.shape.state.unSelectedHover 可以用来设置选中图形被鼠标悬浮时的样式\n\nVChart 的图形样式配置属性是保持了统一的，在 selectedHover 和 unSelectedHover 里同时配置 size 就可以保证所有的图例项在被鼠标悬浮时点变大。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: [\n    {\n      id: 'line',\n      values: [\n        { x: 'Round 1', y: 21, c: 'Role A' },\n        { x: 'Round 1', y: 38, c: 'Role B' },\n        { x: 'Round 2', y: 28, c: 'Role A' },\n        { x: 'Round 2', y: 45, c: 'Role B' },\n        { x: 'Round 3', y: 22, c: 'Role A' },\n        { x: 'Round 3', y: 56, c: 'Role B' },\n        { x: 'Round 4', y: 34, c: 'Role A' },\n        { x: 'Round 4', y: 48, c: 'Role B' },\n        { x: 'Round 5', y: 34, c: 'Role A' },\n        { x: 'Round 5', y: 64, c: 'Role B' },\n        { x: 'Round 6', y: 44, c: 'Role A' },\n        { x: 'Round 6', y: 72, c: 'Role B' },\n        { x: 'Round 7', y: 38, c: 'Role A' },\n        { x: 'Round 7', y: 65, c: 'Role B' },\n        { x: 'Round 8', y: 24, c: 'Role A' },\n        { x: 'Round 8', y: 70, c: 'Role B' },\n        { x: 'Round 9', y: 28, c: 'Role A' },\n        { x: 'Round 9', y: 62, c: 'Role B' }\n      ]\n    }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom',\n    item: {\n      background: {\n        visible: false\n      },\n      shape: {\n        state: {\n          selectedHover: {\n            size: 15\n          },\n          unSelectedHover: {\n            size: 15\n          }\n        }\n      }\n    }\n  },\n  xField: 'x',\n  yField: 'y',\n  seriesField: 'c'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [图例项背景配置](https://www.visactor.io/vchart/option/barChart#legends-discrete.item.background.visible)\n- [图例项悬浮配置](https://www.visactor.io/vchart/option/barChart#legends-discrete.item.shape.state.selectedHover)\n"
  },
  {
    fileName: '118- How to implement point hover effects in the vchart library.md',
    content:
      "---\ntitle: 32. 如何在vchart图表库中实现点的hover效果？</br>\n---\r\n# 问题标题\r\n\r\n如何在vchart图表库中实现点的hover效果？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我在使用vchart图表库进行可视化开发时遇到了一个问题。在使用lightCharts图表库时，我可以很容易地实现点的hover效果，但是当我切换到vchart图表库时，我发现用相同的配置却无法实现相同的效果。我在`series.point`中设置了点的大小，颜色等属性：</br>\r\n```\npoint: { \ninteractive: true, \nzIndex: 10, \nvisible: true,\nbar: { style: { fill: 'red', size: 10, }, }, \nstate: { \ndimension_hover: { \nsize: (datum: any) => { return 10; }, \nfill: (datum: any) => { return 'red'; } \n} \n} \n}</br>\n```\r\n但是在hover状态下，这些设置似乎没有生效。 我想知道我是不是遗漏了什么重要的配置或者是我的配置方式有问题。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/GT8XbqSQhobg7Ax57D2cUs5QnNZ.gif' alt='' width='1136' height='294'>\r\n\r\n# 解决方案\r\n\r\n以我的经验来看，你可能需要在`point`中添加`state`属性，并在`state`中添加`dimension_hover`属性来实现hover状态下的特效。具体的代码示例如下：</br>\r\n\r\n\r\n```\npoint: {\nstyle: {\nsize: 0\n},\nstate: {\ndimension_hover: {\nsize: 10,\nouterBorder: {\ndistance: 0,\nlineWidth: 6,\nstrokeOpacity: 0.2\n}\n}\n}\n}</br>\n```\r\n\r\n\r\n在这里，`dimension_hover`定义了当鼠标悬停在点上时的效果，你可以根据你的需要调整这些设置。</br>\r\n\r\n\r\n你还可以参考vchart的官方demo学习相关配置： https://visactor.bytedance.net/vchart/demo/area-chart/stacked-dash-area 。如果需要在线演示或者编辑你的代码，vchart官网编辑器和codesandbox都是很好的选择。你可以在这些平台上传你的代码，并将链接发给我们，我们会为你提供进一步的帮助。</br>\r\n\r\n\r\n# 结果展示\r\n\r\n通过以上方法成功实现了在vchart中的点的hover效果，并找出了原先配置不生效的原因——在`series.point`中的配置冲突了。</br>\r\n在线效果参考：https://codesandbox.io/p/sandbox/line-chart-shows-on-the-left-most-of-canvas-forked-fx4ppt</br>\r\n\r\n\r\n# 相关文档\r\n\r\n*  Vchart官方网站：https://visactor.bytedance.net/vchart/</br>\r\n*  Vchart官方demo：https://visactor.bytedance.net/vchart/demo/area-chart/stacked-dash-area</br>"
  },
  {
    fileName: '119- How to bind click events to pie chart labels.md',
    content:
      "---\ntitle: 67.如何绑定饼图label的点击事件</br>\n---\r\n## 问题标题\r\n\r\n如何绑定饼图label的点击事件？</br>\r\n## 问题描述\r\n\r\n如下饼图中，希望能够在点击的标签的时候，实现自定义的回调，应该怎么实现？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/AQh9bZNIcojcdFxsoJ1chubhneb.gif' alt='' width='824' height='502'>\r\n\r\n## 解决方案 \r\n\r\nVChart中，标签组件默认是不响应事件的，主要为了避免标签比较密集的时候，影响图表中主要图元的事件响应，想要实现标签的事件监听，需要两步：</br>\r\n*  开启标签的事件响应，即`label.interactive`设置为`true`</br>\r\n*  通过 `{ level: 'model', type: 'label' }`实现标签组件的事件监听</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WEzVb5ejIoZnffxnB8Xc6bgrnud.gif' alt='' width='3194' height='1090'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  pie: {\n    style: {\n      cornerRadius: 10\n    },\n    state: {\n      hover: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      },\n      selected: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  label: {\n    visible: true,\n    interactive: true\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nvchart.on('click',{ level:'model', type:'label'}, (e) => { \n  console.log('label', e) \n})\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 相关文档\r\n\r\n*  [事件API](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fapi%2FAPI%2Fevent)</br>\r\n*  [VChart github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n\r\n"
  },
  {
    fileName: '120- How to set an adaptive y-axis range in a line chart.md',
    content:
      "---\ntitle: 58. 折线图如何设置自适应y轴区间</br>\n---\r\n## 问题标题\r\n\r\n折线图如何设置自适应y轴区间？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如下图所示，我的折线图数据范围都在 80-100 以内，请问要怎么设置才能让 Y 轴的范围自适应这个数据的区间呢？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WVgAbR5RhoI9d5xONuMckYtUnwc.gif' alt='' width='1666' height='1070'>\r\n\r\n\r\n\r\n## 解决方案\r\n\r\n默认情况下，连续轴的 zero 配置为 true，轴范围将会默认从 0 值开始。如果期望连续轴的范围自适应数据范围，可以关闭这一配置项：</br>\r\n```\n  axes: [\n    { orient: 'left', zero: false },\n  ]</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 80\n      },\n      {\n        time: '4:00',\n        value: 90\n      },\n      {\n        time: '6:00',\n        value: 85\n      },\n      {\n        time: '8:00',\n        value: 84\n      },\n      {\n        time: '10:00',\n        value: 96\n      },\n      {\n        time: '12:00',\n        value: 97\n      },\n      {\n        time: '14:00',\n        value: 97\n      },\n      {\n        time: '16:00',\n        value: 86\n      },\n      {\n        time: '18:00',\n        value: 95\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  axes: [\n    { orient: 'left', zero: false },\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Np5HbPZiZoAl1sxIOwycTGa9nDe.gif' alt='' width='1684' height='1066'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  https://visactor.io/vchart/option/lineChart-axes-linear#zero</br>\r\n\r\n"
  },
  {
    fileName: '121- How to customize the rich text axis label style in radar charts.md',
    content:
      '---\ntitle: 13. 如何自定义雷达图富文本轴标签样式？</br>\n---\r\n## 问题标题\r\n\r\nVChart 能否支持类似富文本样式的轴标签样式？</br>\r\n## 问题描述\r\n\r\n期望在标签中支持自定义 icon 和不同的文本样式，类似于：</br>\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Kz17bMijnoGa7ExryWlcHTDin1d.gif\' alt=\'\' width=\'630\' height=\'590\'>\r\n\r\n## 解决方案 \r\n\r\n首先，分析一下需求，图中是极坐标系下**角度轴**的标签。</br>\r\n1. **添加轴配置**</br>\r\n在 VChart 中可以通过 `axes` 属性来配置轴，`axes` 接收一个数组，添加一项，将 `axes[0].type: \'angle\'` 设置轴类型为角度轴；</br>\r\n1. **配置轴标签**</br>\r\n通过格式化函数 `formatMethod` 配置 `axes[0].label` 为富文本。</br>\r\n`formatMethod` 返回一个富文本内容的配置对象</br>\r\n1. `type: \'rich\'`：定义返回文本类型为富文本</br>\r\n1. `text`: 富文本的详细配置。支持文字和图片两种类型，详细配置可以参考[配置项文档](https%3A%2F%2Fvisactor.io%2Fvchart%2Foption%2FbarChart%23title.textStyle.character)。</br>\r\n```\nformatMethod: (value, data, c, d) => {\n  return {\n    type: "rich",\n    text: [\n      {\n        image:\n          \'<svg t="1714116158819" class="icon" viewBox="0 0 1228 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="19433" width="200" height="200"><path d="M1152 76.8v870.4h-1075.2v-870.4h1075.2M1228.8 0H0v1024h1228.8V0z" fill="#0686E5" p-id="19434"></path><path d="M0 0h1228.8v1024H0z" fill="#0686E5" p-id="19435"></path></svg>\',\n        width: 2,\n        height: 10,\n      },\n      {\n        text: ` ${value} `,\n        fontSize: 16,\n        fill: "black",\n        fontWeight: "bold",\n      },\n      {\n        text: ` ${values.find((v) => v.key === value)?.value} `,\n        fontSize: 16,\n        fill: "rgb(22,100,255)",\n        fontWeight: "bold",\n      },\n    ],\n  };\n},</br>\n```\r\n\r\n\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/BRPUbkayLoUGCWxLXpacSFEbnsg.gif\' alt=\'\' width=\'1470\' height=\'1044\'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst values = [\n        {\n          key: \'Strength\',\n          value: 5\n        },\n        {\n          key: \'Speed\',\n          value: 5\n        },\n        {\n          key: \'Shooting\',\n          value: 3\n        },\n        {\n          key: \'Endurance\',\n          value: 5\n        },\n        {\n          key: \'Precision\',\n          value: 5\n        },\n        {\n          key: \'Growth\',\n          value: 5\n        }\n      ];\n\nconst spec = {\n  type: \'radar\',\n  data: [\n    {\n      id: \'radarData\',\n      values\n    }\n  ],\n  categoryField: \'key\',\n  valueField: \'value\',\n  point: {\n    visible: false // disable point\n  },\n  area: {\n    visible: true, // display area\n    state: {\n      // The style in the hover state of the area\n      hover: {\n        fillOpacity: 0.5\n      }\n    }\n  },\n  line: {\n    style: {\n      lineWidth: 4\n    }\n  },\n  axes: [\n    {\n      orient: \'radius\', // radius axis\n      zIndex: 100,\n      min: 0,\n      max: 8,\n      domainLine: {\n        visible: false\n      },\n      label: {\n        visible: true,\n        space: 0,\n        style: {\n          textAlign: \'center\',\n          stroke: \'#fff\',\n          lineWidth: 4\n        }\n      },\n      grid: {\n        smooth: false,\n        style: {\n          lineDash: [0]\n        }\n      }\n    },\n    {\n      orient: \'angle\', // angle axis\n      zIndex: 50,\n      tick: {\n        visible: false\n      },\n      domainLine: {\n        visible: false\n      },\n      label: {\n        space: 20,\n         formatMethod: (value, data,c,d) => {\n          console.log(value,data,c,d)\n      return {\n        type: \'rich\',\n        text: [\n          {\n            image: \'<svg t="1714116158819" class="icon" viewBox="0 0 1228 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="19433" width="200" height="200"><path d="M1152 76.8v870.4h-1075.2v-870.4h1075.2M1228.8 0H0v1024h1228.8V0z" fill="#0686E5" p-id="19434"></path><path d="M0 0h1228.8v1024H0z" fill="#0686E5" p-id="19435"></path></svg>\',\n            width: 2,\n            height: 10\n          },\n          {\n            text: ` ${value} `,\n            fontSize: 16,\n            fill: \'black\',\n            fontWeight: \'bold\'\n          },\n           {\n            text: ` ${values.find(v => v.key === value)?.value} `,\n            fontSize: 16,\n            fill: \'rgb(22,100,255)\',\n            fontWeight: \'bold\'\n          }\n        ]\n      };\n    }\n      },\n      grid: {\n        style: {\n          lineDash: [0]\n        }\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow[\'vchart\'] = vchart;</br>\n```\r\n\r\n\r\n## 相关文档\r\n\r\n富文本 demo：https://visactor.io/vchart/demo/label/richtext-label</br>\r\n相关api：https://visactor.io/vchart/option/radarChart-axes-band#label.formatMethod</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n'
  },
  {
    fileName: '122-How to customize the theme for a chart.md',
    content:
      "# 如何为图表自定义主题，如在 VChart？\n\n## 问题描述\n\n类似 [这样](https://www.visactor.io/vchart/demo/pie-chart/basic-pie)的图表，如何一键切换主题？成本如何？\n\n![pie chart](/vchart/faq/28-0.png)\n\n## 解决方案\n\n不同图表库，切换主题的方案不一样，VChart 是支持主题切换的，详细配置可以参考官网文档：\n\n- [主题教程](https://www.visactor.io/vchart/guide/tutorial_docs/Theme/Theme)\n- [主题色板教程](https://www.visactor.io/vchart/guide/tutorial_docs/Theme/Color_Theme)\n- [自定义主题教程](https://www.visactor.io/vchart/guide/tutorial_docs/Theme/Customize_Theme)\n\n## 代码示例\n\n```\nconst theme = {\n  colorScheme: {\n    default: [\n      \"#fff5f0\",\n      \"#fee0d2\",\n      \"#fcbba1\",\n      \"#fc9272\",\n      \"#fb6a4a\",\n      \"#ef3b2c\",\n      \"#cb181d\",\n      \"#a50f15\",\n      \"#67000d\"\n    ]\n  },\n  series: {\n    pie: {\n      label: {\n        position: 'inside'\n      }\n    }\n  },\n  component: {\n    discreteLegend: {\n      visible: true,\n      orient: 'top'\n    }\n  }\n};\n\nconst spec = {\n  type: 'pie',\n  theme,\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  label: { visible: true },\n  // legends: { visible: true },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n```\n\n## 结果展示\n\n[在线效果参考](https://codesandbox.io/s/pie-chart-theme-rk8ft5)\n\n```javascript livedemo\nconst values = [\n  { type: 'oxygen', value: '46.60' },\n  { type: 'silicon', value: '27.72' },\n  { type: 'aluminum', value: '8.13' },\n  { type: 'iron', value: '5' },\n  { type: 'calcium', value: '3.63' },\n  { type: 'sodium', value: '2.83' },\n  { type: 'potassium', value: '2.59' },\n  { type: 'others', value: '3.5' }\n];\n\nconst theme = {\n  colorScheme: {\n    default: ['#fff5f0', '#fee0d2', '#fcbba1', '#fc9272', '#fb6a4a', '#ef3b2c', '#cb181d', '#a50f15', '#67000d']\n  },\n  series: {\n    pie: {\n      label: {\n        position: 'inside'\n      }\n    }\n  },\n  component: {\n    discreteLegend: {\n      visible: true,\n      orient: 'top'\n    }\n  }\n};\n\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values\n    }\n  ],\n  theme,\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true\n  },\n  label: {\n    visible: true\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n```\n\n## 相关文档\n\n- [主题教程](https://www.visactor.io/vchart/guide/tutorial_docs/Theme/Theme)\n- [主题色板教程](https://www.visactor.io/vchart/guide/tutorial_docs/Theme/Color_Theme)\n- [自定义主题教程](https://www.visactor.io/vchart/guide/tutorial_docs/Theme/Customize_Theme)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '123-Can we add a horizontal line for the average value to the data.md',
    content:
      "# 能否给数据添加平均值横线？\n\n## 问题描述\n\n在使用 VChart 图表库时，能否做到类似于下图的效果，在图表中添加标注线表示数据的平均值？\n[markline average](/vchart/faq/7-0.png)\n\n## 解决方案\n\nVChart 有着丰富的数据标注能力，对于您描绘的场景，只需要在 markLine 中配置`x: 'average'`即可。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'Autocracies', year: '1930', value: 129 },\n        { type: 'Autocracies', year: '1940', value: 133 },\n        { type: 'Autocracies', year: '1950', value: 130 },\n        { type: 'Autocracies', year: '1960', value: 126 },\n        { type: 'Autocracies', year: '1970', value: 117 },\n        { type: 'Autocracies', year: '1980', value: 114 },\n        { type: 'Autocracies', year: '1990', value: 111 },\n        { type: 'Autocracies', year: '2000', value: 89 },\n        { type: 'Autocracies', year: '2010', value: 80 },\n        { type: 'Autocracies', year: '2018', value: 80 },\n        { type: 'Democracies', year: '1930', value: 22 },\n        { type: 'Democracies', year: '1940', value: 13 },\n        { type: 'Democracies', year: '1950', value: 25 },\n        { type: 'Democracies', year: '1960', value: 29 },\n        { type: 'Democracies', year: '1970', value: 38 },\n        { type: 'Democracies', year: '1980', value: 41 },\n        { type: 'Democracies', year: '1990', value: 57 },\n        { type: 'Democracies', year: '2000', value: 87 },\n        { type: 'Democracies', year: '2010', value: 98 },\n        { type: 'Democracies', year: '2018', value: 99 }\n      ]\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  legends: {\n    visible: true,\n    orient: 'top',\n    position: 'start'\n  },\n  markLine: [\n    {\n      y: 'average',\n      label: {\n        visible: true,\n        position: 'insideEndTop',\n        text: 'Average Country',\n        style: {\n          fill: '#000'\n        },\n        labelBackground: {\n          visible: false\n        }\n      }\n    }\n  ]\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [图表标注线 demo](https://visactor.io/vchart/demo/marker/mark-line-axis)\n- [图表标注教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/marker)\n- [相关 api](https://visactor.io/vchart/option/barChart#markLine.y)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName:
      '124-Is there an API on the mini program that prompts the location of data points when touching the screen with your finger.md',
    content:
      "# 在 pc 端上鼠标悬浮在数据点上出现的 tooltip 这种效果，在小程序上有类似这样手指触碰屏幕提示数据点位置的 api 吗？\n\n## 问题描述\n\n想问一下，在 pc 端上鼠标悬浮在数据点上出现的 tooltip 这种效果，在飞书小程序上有类似这样手指触碰屏幕提示数据点位置的 api 吗？类似下图这样的：\n\n![](/vchart/faq/94-0.png)\n\n补充下，我是使用的 Taro 框架。\n\n## 解决方案\n\n首先这个十字线的效果在图表库中一般叫做 crosshair 十字辅助线，目前 VChart 是直接支持的，只需要在图表上配置 crosshair 就可以。\n\n另外 VChart 也提供了基于 Taro 封装了对应的图表组件，你可以直接使用该组件：`@visactor/taro-vchart`。\n\n下面是配置了 crosshair 之后的图表在飞书小程序上的表现：\n\n![](94-1.gif)\n\n## 代码示例\n\n```ts\n{\n  type: 'line',\n  data: [\n    {\n      id: 'line',\n      values: [\n        { x: 'Round 1', y: 21, c: 'Role A' },\n        { x: 'Round 1', y: 38, c: 'Role B' },\n        { x: 'Round 2', y: 28, c: 'Role A' },\n        { x: 'Round 2', y: 45, c: 'Role B' },\n        { x: 'Round 3', y: 22, c: 'Role A' },\n        { x: 'Round 3', y: 56, c: 'Role B' },\n        { x: 'Round 4', y: 34, c: 'Role A' },\n        { x: 'Round 4', y: 48, c: 'Role B' },\n        { x: 'Round 5', y: 34, c: 'Role A' },\n        { x: 'Round 5', y: 64, c: 'Role B' },\n        { x: 'Round 6', y: 44, c: 'Role A' },\n        { x: 'Round 6', y: 72, c: 'Role B' },\n        { x: 'Round 7', y: 38, c: 'Role A' },\n        { x: 'Round 7', y: 65, c: 'Role B' },\n        { x: 'Round 8', y: 24, c: 'Role A' },\n        { x: 'Round 8', y: 70, c: 'Role B' },\n        { x: 'Round 9', y: 28, c: 'Role A' },\n        { x: 'Round 9', y: 62, c: 'Role B' }\n      ]\n    }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  },\n  axes: [\n    {\n      orient: 'left',\n      max: 100\n    },\n    {\n      orient: 'bottom'\n    },\n    {\n      orient: 'right',\n      max: 100\n    }\n  ],\n  xField: 'x',\n  yField: 'y',\n  seriesField: 'c',\n  point: {\n    style: {\n      size: 5\n    },\n    state: {\n      dimension_hover: {\n        size: 10\n      }\n    }\n  },\n  crosshair: {\n    xField: {\n      visible: true,\n      line: {\n        type: 'line', // Defaults is `rect`\n        style: {\n          lineWidth: 1,\n          opacity: 1,\n          stroke: '#000',\n          lineDash: [2, 2]\n        }\n      },\n      label: {\n        visible: true // label is off by default\n      }\n    },\n    yField: {\n      visible: true,\n      line: {\n        style: {\n          lineWidth: 1,\n          opacity: 1,\n          stroke: '#000',\n          lineDash: [2, 2]\n        }\n      },\n      label: {\n        visible: true // label is off by default\n      }\n    }\n  }\n}\n```\n\n## 相关文档\n\n[Crosshair 教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Crosshair)\n[Crosshair 配置](https://www.visactor.io/vchart/option/barChart#crosshair)\n[Taro 使用教程](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/taro)\n"
  },
  {
    fileName: '125- How to make the word cloud fully fill the outer container.md',
    content:
      '---\ntitle: 99. 词云如何顶满外层容器显示</br>\n---\r\n## 问题标题\r\n\r\n词云如何顶满外层容器显示?</br>\r\n\r\n\r\n## 问题描述\r\n\r\n我们有一个比较小的展示词云的场景，希望能尽量让词云占满整个容器，试了下官方网站好像没法占满容器</br>\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/C5jRbsf2tokKkpx9W8XchaJqnFe.gif\' alt=\'\' width=\'1004\' height=\'444\'>\r\n\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/V6x3bPTXioLTjTxGp6JcXSXmnyg.gif\' alt=\'\' width=\'2426\' height=\'1248\'>\r\n\r\n## 解决方案 \r\n\r\n这个因为在 VChart 中，词云默认是使用 `\'circle\'` 圆形做了 markShape 遮罩图形，如果想要尽可能铺满容器，可以使用 `\'rect\'` 形状。</br>\r\n## 代码示例  \r\n\r\n```\n\nconst spec = {\n  type: \'wordCloud\',\n  nameField: \'Keyword\',\n  valueField: \'Score\',\n  data: {\n    name: \'baseData\',\n    values: [ { "Keyword": "预期寿命", "Score": 0.8571 }, { "Keyword": "心率", "Score": 0.8571 }, { "Keyword": "疾病", "Score": 0.7597 }, { "Keyword": "心跳快慢", "Score": 0.5714 }, { "Keyword": "心跳", "Score": 0.5714 }, { "Keyword": "郭艺芳", "Score": 0.5624 }, { "Keyword": "陈清勇", "Score": 0.5624 }, { "Keyword": "风险因素", "Score": 0.4874 }, { "Keyword": "心动过速", "Score": 0.4874 }, { "Keyword": "寿命", "Score": 0.3849 }, { "Keyword": "快慢", "Score": 0.3844 }, { "Keyword": "生活习惯", "Score": 0.2857 }, { "Keyword": "河北省人民医院", "Score": 0.2857 }, { "Keyword": "四川大学华西医院", "Score": 0.2186 }, { "Keyword": "华西医院", "Score": 0.2121 }, { "Keyword": "阿尔茨海默病", "Score": 0.2067 }, { "Keyword": "人群", "Score": 0.1984 }, { "Keyword": "痴呆", "Score": 0.19 }, { "Keyword": "研究", "Score": 0.1761 }, { "Keyword": "健康", "Score": 0.1754 }, { "Keyword": "习惯", "Score": 0.1709 }, { "Keyword": "医院", "Score": 0.1664 }, { "Keyword": "风险", "Score": 0.1647 }, { "Keyword": "心内科", "Score": 0.16 }, { "Keyword": "生活", "Score": 0.158 }, { "Keyword": "工作", "Score": 0.1554 }, { "Keyword": "心血管疾病", "Score": 0.1299 }, { "Keyword": "咖啡", "Score": 0.0974 }, { "Keyword": "志飞", "Score": 0.0974 }, { "Keyword": "中国妇女报", "Score": 0.0974 }, { "Keyword": "人民医院", "Score": 0.0913 } ]\n  },\n  maskShape: \'rect\',\n  width: 400,\n  height: 300,\n  background: \'#cccc\',\n  padding: 10\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow[\'vchart\'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/EGuQbvlF1oVfi3xt3KccgkYqn6e.gif\' alt=\'\' width=\'800\' height=\'600\'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/WordCloud</br>\r\n*  API：https://visactor.io/vchart/option/wordCloudChart#type</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n'
  },
  {
    fileName: '126- Line chart in combo chart is obscured, preventing tooltip hover.md',
    content:
      "---\ntitle: 107. 组合图折线图被遮住，导致无法hover出tooltip</br>\n---\r\n## 问题标题\r\n\r\n组合图折线图被遮住，导致无法hover出tooltip</br>\r\n## 问题描述\r\n\r\n组合图折线图被柱子遮住了，导致hover无法出tooltip</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/MDeQbH5dEowVloxhWlCcpxOznIf.gif' alt='' width='3820' height='1682'>\r\n\r\n## 解决方案 \r\n\r\n可以调整一下 series 声明的顺序，先申明 bar series 再声明 line series，这样折线会展示在柱子的上面：</br>\r\n\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination</br>\r\n*  API：https://visactor.io/vchart/option/commonChart</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '127- How to set the x and y axis labels and bar size in vchart bar charts.md',
    content:
      "---\ntitle: 22.如何设置vchart柱状图的x，y轴文字和柱状大小</br>\n---\r\n# **问题标题**\r\n\r\n如何设置vchart柱状图的x，y轴文字和柱状大小？</br>\r\n# **问题描述**\r\n\r\n我在使用vchart柱状图时，想要设置x，y轴的文字大小和柱状大小，但是在文档中没有找到相应的配置项。我试了一些参数，但是都没有成功。请问应该如何设置？</br>\r\n# **解决方案**\r\n\r\nvchart柱状图的x，y轴文字大小和柱状大小的设置，都可以通过轴 label 的 style 字段进行配置。同时，柱状大小的设置可以通过调整柱状图的宽度来实现。</br>\r\n\r\n\r\n# **示例代码**\r\n\r\n```\nconst spec = {*\n*  type: 'bar',*\n*  data: {*\n*    values: [*\n*      {*\n*        time: '2:00',*\n*        value: 8*\n*      },*\n*      {*\n*        time: '4:00',*\n*        value: 9*\n*      },*\n*      {*\n*        time: '6:00',*\n*        value: 11*\n*      },*\n*      {*\n*        time: '8:00',*\n*        value: 14*\n*      },*\n*      {*\n*        time: '10:00',*\n*        value: 16*\n*      },*\n*      {*\n*        time: '12:00',*\n*        value: 17*\n*      },*\n*      {*\n*        time: '14:00',*\n*        value: 17*\n*      },*\n*      {*\n*        time: '16:00',*\n*        value: 16*\n*      },*\n*      {*\n*        time: '18:00',*\n*        value: 15*\n*      }*\n*    ]*\n*  },*\n*  barWidth: '50%',*\n*  barMinWidth: 20,*\n*  barMaxWidth: 50,*\n*  xField: 'time',*\n*  yField: 'value',*\n*  axes: [*\n*    {*\n*      orient: 'left',*\n*      label: {*\n*        formatMethod(val) {*\n*          return `${(val * 100).toFixed(2)}%`;*\n*        },*\n*        style: { fontSize: 20 }*\n*      }*\n*    },*\n*    { orient: 'bottom', label: { style: { fontSize: 20 } } }*\n*  ]*\n*};*\n\n*const vchart = new VChart(spec, { dom: CONTAINER_ID });*\n*vchart.renderSync();*\n\n*// Just for the convenience of console debugging, DO NOT COPY!*\n*window['vchart'] = vchart;</br>\n```\r\n\r\n\r\n# **结果展示**\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/GUgkbLif7orLX2xouW2cwCAqnGi.gif' alt='' width='1682' height='1048'>\r\n\r\n\r\n\r\n# **相关文档**\r\n\r\n*  Axis label: https://visactor.bytedance.net/vchart/option/barChart-axes-linear#label.style.fontSize</br>\r\n*  barWidth: https://visactor.bytedance.net/vchart/option/barChart#barWidth</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '128- How to achieve overlap of bar chart data in the same dimension rather than stacking.md',
    content:
      "---\ntitle: 0. 如何实现柱形图同维度数据前后重叠而不是堆叠效果？</br>\n---\r\n## 问题标题\r\n\r\n如何实现柱形图同维度数据前后重叠而不是堆叠效果？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n类似 （https://www.visactor.io/vchart/demo/bar-chart/stack-column）这样的堆积柱状图，</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UgdfbSyQBoQlzdxMBePcRnScnAd.gif' alt='' width='812' height='510'>\r\n\r\n想要实现不同颜色的柱子都从y轴0刻度开始画，前后重叠，而不是上下堆积，该如何实现？</br>\r\n\r\n\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，根据你给的demo，只需要将控制堆叠的字段设置为false 即可。</br>\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/D2ifbCtD5ozyJBxK36ucSzAFnBh.gif' alt='' width='331' height='457'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: false,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    },\n    \n  }\n};</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/s/bar-chart-stack-false-cr6667</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QLSpbJbrfoK3wFx1k5rc3iURnPb.gif' alt='' width='756' height='640'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n堆积柱形图demo：https://www.visactor.io/vchart/demo/bar-chart/stack-column</br>\r\n柱形图教程：https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Bar</br>\r\n相关api：https://www.visactor.io/vchart/option/barChart#stack</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '129-How to customize Tooltip in dual axis chart.md',
    content:
      "# 双轴图中如何自定义 Tooltip？\n\n## 问题描述\n\n我想要在双轴图的 tooltip 中显示一些富文本内容应该如何实现？\n\n![tooltip](/vchart/faq/40-0.png)\n\n## 解决方案\n\n这个问题的前提条件是双轴图，事实上对于大多数具有 Tooltip 自定义功能的图表组件来说，是不是双轴图对于自定义 Tooltip 没有影响。\n接下来我以我最近在用的 VisActor 图表举例，逻辑是这样的：\n\n- 确定你想要自定义的 tooltip 类型\n- 注册对应的事件触发自定义 tooltip 的显示\n- 自行设计 tooltip 的布局\n  在自定义事件中，你可以将 tooltip 渲染成任何你需要的样子。通过回调事件的参数，你可以获取到当前 hover 的元素具体的数据。\n\n## 代码示例\n\n```javascript\nconst vchart = new VChart(spec, { dom: 'container' });\n\nvchart.setTooltipHandler({\n  showTooltip: (activeType, tooltipData, params) => {\n    // some code of custom tooltip\n    const tooltip = document.getElementById('custom-tooltip');\n    if (!tooltip) return;\n    tooltip.style.visibility = 'visible';\n    tooltip.style.left = params.event.x + 20 + 'px';\n    tooltip.style.top = params.event.y + 20 + 'px';\n    tooltip.style.position = 'absolute';\n    tooltip.style.background = 'white';\n    tooltip.style.padding = '10px';\n    tooltip.innerText = 'This is Custom Tooltip';\n  },\n  hideTooltip: () => {\n    // hide your custom tooltip\n    const tooltip = document.getElementById('custom-tooltip');\n    if (!tooltip) return;\n    tooltip.style.visibility = 'hidden';\n  }\n});\n```\n\n## 结果展示\n\n![result](/vchart/faq/40-1.png)\n\n[https://codesandbox.io/s/custom-tooltip-dyvy3z](https://codesandbox.io/s/custom-tooltip-dyvy3z)\n\n## 相关文档\n\n- [https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip)\n- [https://visactor.io/vchart/demo/tooltip/custom-tooltip-handler?keyword=tooltip](https://visactor.io/vchart/demo/tooltip/custom-tooltip-handler?keyword=tooltip)\n"
  },
  {
    fileName: '130-How to configure the colors of different line segments in a line chart.md',
    content:
      "# 折线图如何配置不同线段的颜色？\n\n## 问题描述\n\n我正在处理一个折线图的需求，需要配置折线图中线段为不同颜色，但是我搜到的图表例子和一些库的功能都只能把折线图画成同一种颜色。请问有什么解决办法吗？\n\n## 解决方案\n\n在 VChart 中，折线图中不同的线段可以通过 line.style 配置项设置为不同的样式，同时 VChart 也支持设置回调函数来根据不同的数据内容返回样式结果。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        x: '1st',\n        y: 0.012\n      },\n      {\n        x: '2nd',\n        y: -0.01\n      },\n      {\n        x: '3rd',\n        y: 0.005\n      },\n      {\n        x: '4th',\n        y: 0.007\n      },\n      {\n        x: '5th',\n        y: 0.01\n      },\n      {\n        x: '6th',\n        y: 0.017\n      },\n      {\n        x: '7th',\n        y: 0.022\n      },\n      {\n        x: '8th (prediction)',\n        y: 0.033,\n        latest: true\n      }\n    ]\n  },\n  xField: 'x',\n  yField: 'y',\n  line: {\n    style: {\n      stroke: datum => {\n        if (datum.latest) {\n          return 'red';\n        }\n        return 'blue';\n      },\n      lineDash: datum => {\n        if (datum.latest) {\n          return [5, 5];\n        }\n        return [0];\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, do not copy\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [Dashed line example](https://www.visactor.io/vchart/demo/line-chart/dash-line)\n"
  },
  {
    fileName: '131- Can the tick range of a continuous axis be configured to closely match the data range.md',
    content:
      "---\ntitle: 91. 连续轴的刻度范围可以通过配置尽量的贴近数据范围吗</br>\n---\r\n## 问题标题\r\n\r\n连续轴的刻度范围可以通过配置尽量的贴近数据范围吗</br>\r\n## 问题描述\r\n\r\n下面的线图中，连续轴的刻度范围比实际数据的范围大比较多，可以通过配置，让刻度的范围更加接近数据的范围吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WyuibTs0BoP3LZxSNrdccbrvn5b.gif' alt='' width='1496' height='1040'>\r\n\r\n## 解决方案\r\n\r\n连续轴的刻度算法是根据一些列规则计算而来的，其中轴刻度范围和实际数据的范围也是衡量指标之一，如果还需要进一步优化轴刻度的范围，有两个优化点：</br>\r\n*  刻度可以通过`zero: false`调整为不强制从0开始</br>\r\n*  刻度算法可以考虑切换成d3的算法，d3刻度算法在保证数据范围上更好</br>\r\n```\naxes: [{\n    orient: 'left',\n    tick: {\n      tickMode: 'd3'\n    },\n    zero: false\n  }]</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  axes: [{\n    orient: 'left',\n    tick: {\n      tickMode: 'd3'\n    },\n    zero: false\n  }]\n};</br>\n```\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/G4jMbhVskoZpKAxqQNzcG8etnnC.gif' alt='' width='1486' height='1066'>\r\n\r\n## 相关文档\r\n\r\n*  [github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n*  [轴配置文档](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FlineChart-axes-linear%23tick.tickMode('average'%257C'd3')%2520%3D%2520'average')</br>"
  },
  {
    fileName: '132- How to customize slice colors in VChart pie charts.md',
    content:
      "---\ntitle: 94. VChart 饼图如何自定义扇形颜色</br>\n---\r\n## 问题标题\r\n\r\n饼图如何自定义扇形颜色？</br>\r\n## 问题描述\r\n\r\n我有一个饼图， 不想指定 domain，让颜色从从 range 中遍历，反复使用， 该怎么处理？</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart 提供`ordinal color`功能， 用于自定义颜色。</br>\r\n`color.range`用于定义一个颜色序列， 图表会自动为每一个扇形图元分配颜色， 当颜色数量不足时， 则会循环分配， 在`ordinal color`内， `range`是离散的。 </br>\r\n`color.domain` 用于定义输入数据映射到颜色比例尺的数据值范围。在`ordinal color`内， `domain`是离散的。 </br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from \"react\";\nimport { createRoot } from \"react-dom/client\";\n\nconst rootElement = document.getElementById(\"root\");\nconst root = createRoot(rootElement);\n\nimport VChart from \"@visactor/vchart\";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: 'pie',\n      data: [\n        {\n          id: 'id0',\n          values: [\n            { type: 'oxygen', value: '46.60' },\n            { type: 'silicon', value: '27.72' },\n            { type: 'aluminum', value: '8.13' },\n            { type: 'iron', value: '5' },\n            { type: 'calcium', value: '3.63' },\n            { type: 'sodium', value: '2.83' },\n            { type: 'potassium', value: '2.59' },\n            { type: 'others', value: '3.5' }\n          ]\n        }\n      ],\n      outerRadius: 0.8,\n      innerRadius: 0.5,\n      padAngle: 0.6,\n      valueField: 'value',\n      categoryField: 'type',\n      color: {\n        type: 'ordinal',\n        // optional domain\n        // domain: [\n        //   \"oxygen\",\n        //   \"silicon\",\n        //   \"aluminum\",\n        //   \"iron\",\n        //   \"calcium\",\n        //   \"sodium\",\n        //   \"potassium\",\n        //   \"others\"\n        // ],\n        range: [\n          \"red\",\n          \"green\",\n          \"blue\",\n        ]\n      },\n      pie: {\n        style: {\n          cornerRadius: 10\n        },\n        state: {\n          hover: {\n            outerRadius: 0.85,\n            stroke: '#000',\n            lineWidth: 1\n          },\n          selected: {\n            outerRadius: 0.85,\n            stroke: '#000',\n            lineWidth: 1\n          }\n        }\n      },\n      title: {\n        visible: true,\n        text: 'Statistics of Surface Element Content'\n      },\n      legends: {\n        visible: true,\n        orient: 'left'\n      },\n      label: {\n        visible: true\n      },\n      tooltip: {\n        mark: {\n          content: [\n            {\n              key: datum => datum['type'],\n              value: datum => datum['value'] + '%'\n            }\n          ]\n        }\n      }\n    };\n    const vchart = new VChart(spec, { dom: \"chart\" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id=\"chart\" style={{ width: 400 }}></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-large-tooltip-optimize-forked-q6kr7p</br>\r\n## 相关文档\r\n\r\nOrdinal Color API: https://visactor.io/vchart/option/bar3dChart#color.type.ordinal</br>\r\nGithub: https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '133-How to control the display order of discrete legends.md',
    content:
      "# 如何控制离散图例的显示顺序?\n\n## 问题描述\n\n如下图所示，我该如何控制列表型图例的显示顺序：\n\n![](/vchart/faq/89-0.png)\n\n## 解决方案\n\n对于大部分的图表来说，列表型图例的顺序是由数据中分组字段的顺序决定的，我们可以通过如下几种方法来实现：\n\n1.  直接调整数据的顺序\n1.  设置分组字段对应度量的 domain\n1.  如果图表的图例组件有提供相应配置的话，也可以直接对图例的数据进行操作\n\n下面就介绍下在 VChart 上如何进行配置，VChart 即支持直接配置分组字段的 domain 也支持直接控制图例组件的数据，你可以根据你自己的需要选择哪种方法。\n\n1.  设置分组字段对应度量的 domain\n\n如下图所示，可以在 `data` 属性上配置对应字段的 `domain` 属性，同时配置 `sortIndex` 表示按照声明的 `domain` 属性进行排序，这样就可以控制图例的显示顺序了。\n\n注意通过在数据上配置字段的 `domain` 它不仅会影响图例的显示顺序，也会影响数据的绘制顺序。\n\n![](/vchart/faq/89-1.png)\n\n2.  通过 `legends.data` 属性，自定义显示顺序\n\n另外也可以直接通过修改图例组件的顺序来达到目的，`legends.data` 是一个回调类型，会将图例的绘制顺序作为参数传递给用户，用户可以根据自己的需要进行顺序或者其他操作，但是需要注意返回的数据必须符合图例顺序的格式。\n\n如果你只是简单想让图例顺序反转下，也可以直接开启 `legends.reverse` 属性即可。\n\n![](/vchart/faq/89-2.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'AL',\n          age: 'Under 5 Years',\n          population: 310504,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '5 to 13 Years',\n          population: 552339,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '14 to 17 Years',\n          population: 259034,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '18 to 24 Years',\n          population: 450818,\n          type: 'b'\n        },\n        {\n          State: 'AL',\n          age: '25 to 44 Years',\n          population: 1231572,\n          type: 'c'\n        },\n        {\n          State: 'AL',\n          age: '45 to 64 Years',\n          population: 1215966,\n          type: 'd'\n        },\n        {\n          State: 'AL',\n          age: '65 Years and Over',\n          population: 641667,\n          type: 'd'\n        },\n        {\n          State: 'AK',\n          age: 'Under 5 Years',\n          population: 52083,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '5 to 13 Years',\n          population: 85640,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '14 to 17 Years',\n          population: 42153,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '18 to 24 Years',\n          population: 74257,\n          type: 'b'\n        },\n        {\n          State: 'AK',\n          age: '25 to 44 Years',\n          population: 198724,\n          type: 'c'\n        },\n        {\n          State: 'AK',\n          age: '45 to 64 Years',\n          population: 183159,\n          type: 'd'\n        },\n        {\n          State: 'AK',\n          age: '65 Years and Over',\n          population: 50277,\n          type: 'd'\n        },\n        {\n          State: 'AZ',\n          age: 'Under 5 Years',\n          population: 515910,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '5 to 13 Years',\n          population: 828669,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '14 to 17 Years',\n          population: 362642,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '18 to 24 Years',\n          population: 601943,\n          type: 'b'\n        },\n        {\n          State: 'AZ',\n          age: '25 to 44 Years',\n          population: 1804762,\n          type: 'c'\n        },\n        {\n          State: 'AZ',\n          age: '45 to 64 Years',\n          population: 1523681,\n          type: 'd'\n        },\n        {\n          State: 'AZ',\n          age: '65 Years and Over',\n          population: 862573,\n          type: 'd'\n        },\n        {\n          State: 'AR',\n          age: 'Under 5 Years',\n          population: 202070,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '5 to 13 Years',\n          population: 343207,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '14 to 17 Years',\n          population: 157204,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '18 to 24 Years',\n          population: 264160,\n          type: 'b'\n        },\n        {\n          State: 'AR',\n          age: '25 to 44 Years',\n          population: 754420,\n          type: 'c'\n        },\n        {\n          State: 'AR',\n          age: '45 to 64 Years',\n          population: 727124,\n          type: 'd'\n        },\n        {\n          State: 'AR',\n          age: '65 Years and Over',\n          population: 407205,\n          type: 'd'\n        },\n        {\n          State: 'CA',\n          age: 'Under 5 Years',\n          population: 2704659,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '5 to 13 Years',\n          population: 4499890,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '14 to 17 Years',\n          population: 2159981,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '18 to 24 Years',\n          population: 3853788,\n          type: 'b'\n        },\n        {\n          State: 'CA',\n          age: '25 to 44 Years',\n          population: 10604510,\n          type: 'c'\n        },\n        {\n          State: 'CA',\n          age: '45 to 64 Years',\n          population: 8819342,\n          type: 'd'\n        },\n        {\n          State: 'CA',\n          age: '65 Years and Over',\n          population: 4114496,\n          type: 'd'\n        },\n        {\n          State: 'CO',\n          age: 'Under 5 Years',\n          population: 358280,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '5 to 13 Years',\n          population: 587154,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '14 to 17 Years',\n          population: 261701,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '18 to 24 Years',\n          population: 466194,\n          type: 'b'\n        },\n        {\n          State: 'CO',\n          age: '25 to 44 Years',\n          population: 1464939,\n          type: 'c'\n        },\n        {\n          State: 'CO',\n          age: '45 to 64 Years',\n          population: 1290094,\n          type: 'd'\n        },\n        {\n          State: 'CO',\n          age: '65 Years and Over',\n          population: 511094,\n          type: 'd'\n        },\n        {\n          State: 'CT',\n          age: 'Under 5 Years',\n          population: 211637,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '5 to 13 Years',\n          population: 403658,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '14 to 17 Years',\n          population: 196918,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '18 to 24 Years',\n          population: 325110,\n          type: 'b'\n        },\n        {\n          State: 'CT',\n          age: '25 to 44 Years',\n          population: 916955,\n          type: 'c'\n        },\n        {\n          State: 'CT',\n          age: '45 to 64 Years',\n          population: 968967,\n          type: 'd'\n        },\n        {\n          State: 'CT',\n          age: '65 Years and Over',\n          population: 478007,\n          type: 'd'\n        }\n      ],\n      // 方法一，改变 domain\n      // Method 1, change the domain,\n      fields: {\n        age: {\n          domain: [\n            '65 Years and Over',\n            'Under 5 Years',\n            '5 to 13 Years',\n            '14 to 17 Years',\n            '18 to 24 Years',\n            '25 to 44 Years',\n            '45 to 64 Years'\n          ],\n          sortIndex: 0\n        }\n      }\n    }\n  ],\n  xField: ['State', 'type'],\n  yField: 'population',\n  seriesField: 'age',\n  stack: true,\n  legends: {\n    visible: true,\n    orient: 'right'\n    // 方法二，改变图例组件数据\n    // Method 2, change the legend component data\n    // data: (legendData) => {\n    //   // legendData 为图例组件的绘制数据，你可以打印下 legendData 看下结构\n    //   // legendData is the drawing data of the legend component, you can print legendData to see the structure\n    //   console.log(legendData)\n    //   return legendData.reverse();\n    // }\n  },\n\n  color: ['#98abc5', '#8a89a6', '#7b6888', '#6b486b', '#a05d56', '#d0743c', '#ff8c00'],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod: val => {\n          return val / 1000000 + 'M';\n        }\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [数据教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Data/Data_Types_and_Interface)\n- [数据配置](<https://www.visactor.io/vchart/option/barChart#data(IDataType%7CIDataType%5B%5D).IDataValues.id>)\n- [图例教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend)\n- [图例配置](https://www.visactor.io/vchart/option/barChart#legends-discrete.type)\n"
  },
  {
    fileName: '134-How does the Ring with Indicator Card dynamically update indicator values.md',
    content:
      "# 带指标卡环形图如何动态更新指标值?\n\n## 问题描述\n\n类似 （https://www.visactor.io/vchart/demo/pie-chart/pie-indicator）这样的带指标卡环形图，\n这个指标卡里的数值现在是用户自己定义的，不支持自动变，但是可以计算之后更新这个值。指标卡里这个数字可以根据 hover 的扇区改变吗？该如何实现？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，只需要设置交互触发类型和配置 text 字段内容。\n\n- indicator.trigger 用来设置交互触发类型。可选的交互类型有 hover、select、none。默认设置交互触发类型为 select。根据你的需求，需要将 indicator.trigger 设置为 hover。\n- indicator.title.style.text 用来设置文本内容，且支持回调。可以根据需要的数据字段，在 text 中配置所需字段并可根据需求格式化展现形式。\n\n## 代码示例\n\n```javascript livedemo\nconst data = [\n  { type: 'oxygen', value: '46.60', formula: 'O', texture: 'circle' },\n  { type: 'silicon', value: '27.72', formula: 'Si', texture: 'horizontal-line' },\n  { type: 'aluminum', value: '8.13', formula: 'Al', texture: 'vertical-line' },\n  { type: 'iron', value: '5', formula: 'Fe', texture: 'rect' },\n  { type: 'calcium', value: '3.63', formula: 'Ca', texture: 'grid' },\n  { type: 'sodium', value: '2.83', formula: 'Na', texture: 'bias-rl' },\n  { type: 'potassium', value: '2.59', formula: 'K', texture: 'diamond' },\n  { type: 'others', value: '3.5', formula: 'Others', texture: 'bias-lr' }\n];\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: data\n    }\n  ],\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  pie: {\n    style: {\n      cornerRadius: 10,\n      texture: datum => datum['texture']\n    },\n    state: {\n      hover: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      },\n      selected: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  indicator: {\n    visible: true,\n    trigger: 'hover',\n    limitRatio: 0.4,\n    title: {\n      visible: true,\n      autoFit: true,\n      style: {\n        fontWeight: 'bolder',\n        fontFamily: 'Times New Roman',\n        fill: '#888',\n        text: datum => {\n          const d = datum ?? data[0];\n          return d['formula'];\n        }\n      }\n    },\n    content: [\n      {\n        visible: true,\n        style: {\n          fontSize: 20,\n          fill: 'orange',\n          fontWeight: 'bolder',\n          fontFamily: 'Times New Roman',\n          text: datum => {\n            const d = datum ?? data[0];\n            return d['type'];\n          }\n        }\n      },\n      {\n        visible: true,\n        style: {\n          fontSize: 18,\n          fill: 'orange',\n          fontFamily: 'Times New Roman',\n          text: datum => {\n            const d = datum ?? data[0];\n            return d['value'] + '%';\n          }\n        }\n      }\n    ]\n  },\n  legends: {\n    visible: true,\n    orient: 'left',\n    item: {\n      shape: {\n        style: {\n          symbolType: 'circle',\n          texture: datum => datum['texture']\n        }\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/pie-chart-with-indicator-card-4ypr2k)\n\n## 相关文档\n\n- [带指标卡饼图 demo](https://www.visactor.io/vchart/demo/pie-chart/pie-indicator)\n- [指标卡教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Indicator)\n- [相关 api](https://www.visactor.io/vchart/option/pieChart#indicator)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '135-How to customize the colors of bars based on values in a bar chart.md',
    content:
      "# 柱状图如何根据不同的数值自定义柱子的颜色？\n\n## 问题描述\n\n我需要绘制一个能够根据不同柱子的数值配置不同颜色的柱状图，请问应该如何实现？\n\n## 解决方案\n\n可以使用 VChart 中配置柱子样式的回调来根据数据内容自定义颜色。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales',\n  bar: {\n    style: {\n      fill: datum => {\n        return datum.sales > 25 ? 'red' : 'blue';\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [barChart style spec](https://www.visactor.io/vchart/option/barChart#bar.style.fill)\n"
  },
  {
    fileName: '136- How to prevent the stroke from being obscured when hovering over pie chart sectors.md',
    content:
      "---\ntitle: 87. 如何避免饼图扇区的hover时描边被遮挡？</br>\n---\r\n## 问题标题\r\n\r\nVChart  如何避免饼图扇区的hover时描边被遮挡?</br>\r\n\r\n\r\n## 问题描述\r\n\r\n配置了饼图扇区的hover描边，但是会被其他扇区遮挡</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JGQubRzSPorZD0xqVyzc1jrCnNe.gif' alt='' width='471' height='384'>\r\n\r\n## 解决方案\r\n\r\n\r\n\r\n可以调整元素在hover时的层级，这样hover元素始终展示在其他扇区上面，就可以避免描边被遮挡的问题</br>\r\n```\n pie: {\n    state: {\n      hover: {\n        stroke: 'black',\n        lineWidth: 4,\n        zIndex: 1\n      }\n    }\n  },</br>\n```\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  label: {\n    visible: true\n  },\n  pie: {\n    state: {\n      hover: {\n        stroke: 'black',\n        lineWidth: 4,\n        zIndex: 1\n      }\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/StbLbUAg4otZcRxy3TacH0aRnld.gif' alt='' width='694' height='436'>\r\n\r\n## 相关文档\r\n\r\n*  github：https://www.visactor.io/vchart/option/pieChart#pie.style.zIndex</br>\r\n*  相关 demo：https://www.visactor.io/vchart/demo/pie-chart/basic-pie</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '137- Does the bar chart support setting colors for individual columns.md',
    content:
      '---\ntitle: 97. 柱状图支持对某一列单独设置颜色吗？</br>\n---\r\n## 问题标题\r\n\r\n柱状图支持对某一列单独设置颜色吗？</br>\r\n## 问题描述\r\n\r\n想单独设置某一个柱子的颜色， 该如何实现？</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart 的允许用户通过回调函数的方式控制样式， 包括颜色、描边等多种样式配置。</br>\r\n柱状图可以通过配置`bar.style.fill`来根据控制颜色， `fill`支持配置回调函数， 可以通过 datum 对某一个柱子进行样式修改， 其余数据可以通过`seriesColor`接口， 获取到原始的分组颜色。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "bar",\n      data: [\n        {\n          id: "barData",\n          values: [\n            { type: "Autocracies", year: "1930", value: 129 },\n            { type: "Autocracies", year: "1940", value: 133 },\n            { type: "Autocracies", year: "1950", value: 130 },\n            { type: "Autocracies", year: "1960", value: 126 },\n            { type: "Autocracies", year: "1970", value: 117 },\n            { type: "Autocracies", year: "1980", value: 114 },\n            { type: "Autocracies", year: "1990", value: 111 },\n            { type: "Autocracies", year: "2000", value: 89 },\n            { type: "Autocracies", year: "2010", value: 80 },\n            { type: "Autocracies", year: "2018", value: 80 },\n            { type: "Democracies", year: "1930", value: 22 },\n            { type: "Democracies", year: "1940", value: 13 },\n            { type: "Democracies", year: "1950", value: 25 },\n            { type: "Democracies", year: "1960", value: 29 },\n            { type: "Democracies", year: "1970", value: 38 },\n            { type: "Democracies", year: "1980", value: 41 },\n            { type: "Democracies", year: "1990", value: 57 },\n            { type: "Democracies", year: "2000", value: 87 },\n            { type: "Democracies", year: "2010", value: 98 },\n            { type: "Democracies", year: "2018", value: 99 },\n          ],\n        },\n      ],\n      xField: ["year", "type"],\n      yField: "value",\n      seriesField: "type",\n      bar: {\n        style: {\n          fill: (datum, chart) => {\n            if (datum["year"] === "2000") {\n              return "red";\n            }\n            // origin color\n            return chart.seriesColor(datum["type"]);\n          },\n        },\n      },\n      legends: {\n        visible: true,\n        orient: "top",\n        position: "start",\n      },\n    };\n\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart" style={{ width: 400 }}></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-single-bar-style-n9m6np?file=%2Fsrc%2Findex.js%3A7%2C39</br>\r\n## 相关文档\r\n\r\nBar Style API: https://visactor.io/vchart/option/barChart#bar.style.fill</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '138-How to customize the font size of words in Word Cloud Chart.md',
    content:
      "# 词云图中如何自定义词语的字体大小？\n\n## 问题描述\n\n如何自定义词云中的文字大小，我希望权重较大的文字能显示的更大些，比如下面这个例子中我想让最大的文字大小达到 40px，我该怎么做呢？\n[wordcloud fontsize](/vchart/faq/10-0.png)\n\n## 解决方案\n\n你可以设置`wordCloudChart.fontSizeRange`来配置字体大小范围，它表示数据最小值和最大值分别对应的文字大小，在你给出的例子中，可以配置`wordCloudChart.fontSizeRange: [5, 40]`来达到预期效果。\n\n## 代码示例\n\n```javascript livedemo\nconst response = await fetch('https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/data-wordcloud.json');\nconst dataWordCloud = await response.json();\nconst spec = {\n  type: 'wordCloud',\n  nameField: 'challenge_name',\n  valueField: 'sum_count',\n  seriesField: 'challenge_name',\n  data: {\n    name: 'baseData',\n    values: dataWordCloud\n  },\n  fontSizeRange: [5, 40]\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [词云 demo](https://www.visactor.io/vchart/demo/word-cloud-chart/word-cloud-basic)\n- [词云教程](https://www.visactor.io/vchart/guide/chart/word-cloud)\n- [相关 api](https://www.visactor.io/vchart/option/wordCloudChart#fontSizeRange)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '139-How to configure chart adaptive container width and height.md',
    content:
      "# 如何配置图表自适应容器宽高？\n\n## 问题描述\n\n我在使用 VChart 图表时，希望图表能够自动适应外部容器的大小，应该如何操作？\n\n## 解决方案\n\nVChart 的图表提供 autoFit 属性，在默认情况下就是自适应容器大小的。该配置的优先级高于构造函数中的 autoFit 配置。如果用户配置了 width，则以用户配置的 width 为准，height 同理。\n你这边没有提供更多的背景信息，我猜测一下图表没有自适应的原因：\n\n1. 如果你在 spec 里指定的大小，此时将不会再自适应容器大小\n2. spec 中的 autoFit 开关被关闭了\n3. 外部通过 css 限制了 Dom 的尺寸\n\n一般来说前两种情况是常见的，你可以输出一下你的最终 spec 排查一下你得情况。\n\n## 代码示例\n\n```javascript\nconst spec = {\n  type: 'common',\n  autoFit:true,\n  (...)\n  }\n```\n\n## 相关文档\n\ntooltip option: [https://visactor.io/vchart/option/barChart#autoFit](https://visactor.io/vchart/option/barChart#autoFit)\n\ngithub: [https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '140- How to configure the highlight effect in a Sankey diagram.md',
    content:
      "---\ntitle: 6. 如何配置桑基图的高亮效果</br>\n---\r\n## 问题标题\r\n\r\n如何配置桑基图的高亮效果?</br>\r\n\r\n\r\n## 问题描述\r\n\r\n我在这个 [demo](https%3A%2F%2Fvisactor.io%2Fvchart%2Fdemo%2Fsankey-chart%2Fbasic-sankey) 的基础上添加了如下配置（见 图1），没有实现图 2 的效果，请问要如何配置？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/MpLabX9eQoCwwNxHdk2cyWRjn9g.gif' alt='' width='2246' height='1214'>\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/DYnqbT7RQougzdxzzTfcTzW1nSf.gif' alt='' width='2690' height='1116'>\r\n\r\n## 解决方案 \r\n\r\n如果想要实现上述图 2 的高亮效果，需要在配置 `emphasis` 的前提下，配合配置 node 和 link 的交互状态，上图涉及到两个交互状态：`selected` 和 `blur`，如下：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HaoHbKGMMoSlBxxMJZOcIlvanRd.gif' alt='' width='2574' height='1260'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'sankey',\n  data: [\n    {\n      values: [\n        {\n          nodes: [\n            { nodeName: \"Agricultural 'waste'\" },\n            { nodeName: 'Bio-conversion' },\n            { nodeName: 'Liquid' },\n            { nodeName: 'Losses' },\n            { nodeName: 'Solid' },\n            { nodeName: 'Gas' },\n            { nodeName: 'Biofuel imports' },\n            { nodeName: 'Biomass imports' },\n            { nodeName: 'Coal imports' },\n            { nodeName: 'Coal' },\n            { nodeName: 'Coal reserves' },\n            { nodeName: 'District heating' },\n            { nodeName: 'Industry' },\n            { nodeName: 'Heating and cooling - commercial' },\n            { nodeName: 'Heating and cooling - homes' },\n            { nodeName: 'Electricity grid' },\n            { nodeName: 'Over generation / exports' },\n            { nodeName: 'H2 conversion' },\n            { nodeName: 'Road transport' },\n            { nodeName: 'Agriculture' },\n            { nodeName: 'Rail transport' },\n            { nodeName: 'Lighting & appliances - commercial' },\n            { nodeName: 'Lighting & appliances - homes' },\n            { nodeName: 'Gas imports' },\n            { nodeName: 'Ngas' },\n            { nodeName: 'Gas reserves' },\n            { nodeName: 'Thermal generation' },\n            { nodeName: 'Geothermal' },\n            { nodeName: 'H2' },\n            { nodeName: 'Hydro' },\n            { nodeName: 'International shipping' },\n            { nodeName: 'Domestic aviation' },\n            { nodeName: 'International aviation' },\n            { nodeName: 'National navigation' },\n            { nodeName: 'Marine algae' },\n            { nodeName: 'Nuclear' },\n            { nodeName: 'Oil imports' },\n            { nodeName: 'Oil' },\n            { nodeName: 'Oil reserves' },\n            { nodeName: 'Other waste' },\n            { nodeName: 'Pumped heat' },\n            { nodeName: 'Solar PV' },\n            { nodeName: 'Solar Thermal' },\n            { nodeName: 'Solar' },\n            { nodeName: 'Tidal' },\n            { nodeName: 'UK land based bioenergy' },\n            { nodeName: 'Wave' },\n            { nodeName: 'Wind' }\n          ],\n          links: [\n            { source: 0, target: 1, value: 124.729 },\n            { source: 1, target: 2, value: 0.597 },\n            { source: 1, target: 3, value: 26.862 },\n            { source: 1, target: 4, value: 280.322 },\n            { source: 1, target: 5, value: 81.144 },\n            { source: 6, target: 2, value: 35 },\n            { source: 7, target: 4, value: 35 },\n            { source: 8, target: 9, value: 11.606 },\n            { source: 10, target: 9, value: 63.965 },\n            { source: 9, target: 4, value: 75.571 },\n            { source: 11, target: 12, value: 10.639 },\n            { source: 11, target: 13, value: 22.505 },\n            { source: 11, target: 14, value: 46.184 },\n            { source: 15, target: 16, value: 104.453 },\n            { source: 15, target: 14, value: 113.726 },\n            { source: 15, target: 17, value: 27.14 },\n            { source: 15, target: 12, value: 342.165 },\n            { source: 15, target: 18, value: 37.797 },\n            { source: 15, target: 19, value: 4.412 },\n            { source: 15, target: 13, value: 40.858 },\n            { source: 15, target: 3, value: 56.691 },\n            { source: 15, target: 20, value: 7.863 },\n            { source: 15, target: 21, value: 90.008 },\n            { source: 15, target: 22, value: 93.494 },\n            { source: 23, target: 24, value: 40.719 },\n            { source: 25, target: 24, value: 82.233 },\n            { source: 5, target: 13, value: 0.129 },\n            { source: 5, target: 3, value: 1.401 },\n            { source: 5, target: 26, value: 151.891 },\n            { source: 5, target: 19, value: 2.096 },\n            { source: 5, target: 12, value: 48.58 },\n            { source: 27, target: 15, value: 7.013 },\n            { source: 17, target: 28, value: 20.897 },\n            { source: 17, target: 3, value: 6.242 },\n            { source: 28, target: 18, value: 20.897 },\n            { source: 29, target: 15, value: 6.995 },\n            { source: 2, target: 12, value: 121.066 },\n            { source: 2, target: 30, value: 128.69 },\n            { source: 2, target: 18, value: 135.835 },\n            { source: 2, target: 31, value: 14.458 },\n            { source: 2, target: 32, value: 206.267 },\n            { source: 2, target: 19, value: 3.64 },\n            { source: 2, target: 33, value: 33.218 },\n            { source: 2, target: 20, value: 4.413 },\n            { source: 34, target: 1, value: 4.375 },\n            { source: 24, target: 5, value: 122.952 },\n            { source: 35, target: 26, value: 839.978 },\n            { source: 36, target: 37, value: 504.287 },\n            { source: 38, target: 37, value: 107.703 },\n            { source: 37, target: 2, value: 611.99 },\n            { source: 39, target: 4, value: 56.587 },\n            { source: 39, target: 1, value: 77.81 },\n            { source: 40, target: 14, value: 193.026 },\n            { source: 40, target: 13, value: 70.672 },\n            { source: 41, target: 15, value: 59.901 },\n            { source: 42, target: 14, value: 19.263 },\n            { source: 43, target: 42, value: 19.263 },\n            { source: 43, target: 41, value: 59.901 },\n            { source: 4, target: 19, value: 0.882 },\n            { source: 4, target: 26, value: 400.12 },\n            { source: 4, target: 12, value: 46.477 },\n            { source: 26, target: 15, value: 525.531 },\n            { source: 26, target: 3, value: 787.129 },\n            { source: 26, target: 11, value: 79.329 },\n            { source: 44, target: 15, value: 9.452 },\n            { source: 45, target: 1, value: 182.01 },\n            { source: 46, target: 15, value: 19.013 },\n            { source: 47, target: 15, value: 289.366 }\n          ]\n        }\n      ]\n    }\n  ],\n  categoryField: 'nodeName',\n  valueField: 'value',\n  sourceField: 'source',\n  targetField: 'target',\n\n  nodeAlign: 'justify',\n  nodeGap: 8,\n  nodeWidth: 10,\n  minNodeHeight: 4,\n\n  title: {\n    text: 'How energy is converted or transmitted before being consumed or lost',\n    subtext: 'Data: Department of Energy & Climate Change via Tom Counsell',\n    subtextStyle: {\n      fontSize: 12\n    }\n  },\n\n  label: {\n    visible: true,\n    style: {\n      fontSize: 10\n    }\n  },\n\n  node: {\n    state: {\n      hover: {\n        stroke: '#333333'\n      },\n      selected: {\n        fillOpacity: 1\n      },\n      blur: {\n        fillOpacity: 0.1\n      }\n    }\n  },\n  link: {\n    state: {\n      hover: {\n        fillOpacity: 1\n      },\n      selected: {\n        fillOpacity: 1\n      },\n      blur: {\n        fillOpacity: 0.1\n      }\n    }\n  },\n\n  emphasis: {\n    enable: true,\n    effect: 'adjacency'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://visactor.io/vchart/demo/sankey-chart/nameKey-sankey</br>\r\n\r\n\r\n## 相关文档\r\n\r\ndemo：https://visactor.io/vchart/demo/sankey-chart/nameKey-sankey</br>\r\n教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Sankey</br>\r\n相关api：https://visactor.io/vchart/option/sankeyChart#emphasis，https://visactor.io/vchart/option/sankeyChart#node.state，https://visactor.io/vchart/option/sankeyChart#link.state</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '141- How to draw a multi-row layout line chart.md',
    content:
      "---\ntitle: 8. 如何绘制多行布局的折线图</br>\n---\r\n## 问题标题\r\n\r\n如何绘制多行布局的折线图</br>\r\n\r\n\r\n## 问题描述\r\n\r\n折线图可以实现如下多行布局的分组折线图吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Q0WVbWWQeoH0qVxCfTjcJIobnEb.gif' alt='' width='1732' height='754'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\nVChart 中可以结合组合图和 grid 布局实现，参考 demo: https://visactor.io/vchart/demo/combination/col-line。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst regionStyle = {\n  stroke: 'rgb(201,205,212)',\n  lineWidth: 1,\n  strokeTop: true,\n  strokeBottom: false,\n  strokeLeft: false,\n  strokeRight: false\n};\nconst leftAxesCommonSpec = {\n  expand: { max: 0.2 },\n  label: { flush: true, visible: true },\n  tick: { visible: false },\n  forceTickCount: 3\n};\nconst spec = {\n  type: 'common',\n  layout: {\n    type: 'grid',\n    col: 2,\n    row: 6,\n    elements: [\n      {\n        modelId: 'legend',\n        col: 0,\n        colSpan: 2,\n        row: 5\n      },\n      {\n        modelId: 'Social Penetration',\n        col: 1,\n        row: 0\n      },\n      {\n        modelId: 'Engagement - Socialization',\n        col: 1,\n        row: 1\n      },\n      {\n        modelId: 'Penetration of Private Messages',\n        col: 1,\n        row: 2\n      },\n      {\n        modelId: 'Number of Private Messages per User',\n        col: 1,\n        row: 3\n      },\n      {\n        modelId: 'Social Penetrationleft',\n        col: 0,\n        row: 0\n      },\n      {\n        modelId: 'Engagement - Socialization-left',\n        col: 0,\n        row: 1\n      },\n      {\n        modelId: 'Penetration of Private Messagesleft',\n        col: 0,\n        row: 2\n      },\n      {\n        modelId: 'Number of Private Messages per Userleft',\n        col: 0,\n        row: 3\n      },\n      {\n        modelId: 'Number of Private Messages per User-bottom',\n        col: 1,\n        row: 4\n      }\n    ]\n  },\n  region: [\n    {\n      id: 'Social Penetration',\n      style: {\n        ...regionStyle,\n        strokeTop: false\n      }\n    },\n    {\n      id: 'Engagement - Socialization',\n      style: regionStyle\n    },\n    {\n      id: 'Penetration of Private Messages',\n      style: regionStyle\n    },\n    {\n      id: 'Number of Private Messages per User',\n      style: regionStyle\n    }\n  ],\n  legends: {\n    padding: {\n      top: 10\n    },\n    visible: true,\n    orient: 'bottom',\n    id: 'legend',\n    regionId: [\n      'Social Penetration',\n      'Engagement - Socialization',\n      'Penetration of Private Messages',\n      'Number of Private Messages per User'\n    ]\n  },\n  seriesField: 'type',\n  tooltip: {\n    dimension: {\n      title: {\n        value: datum => {\n          return `第 ${datum.x} 天`;\n        }\n      },\n      content: [\n        {\n          key: datum => datum.type,\n          value: datum => datum.y\n        }\n      ]\n    }\n  },\n  series: [\n    {\n      id: 'Social Penetrationseries0',\n      regionId: 'Social Penetration',\n      type: 'line',\n      data: { id: 'Social Penetration' },\n      xField: 'x',\n      yField: 'y'\n    },\n    {\n      id: 'Engagement - Socialization-series0',\n      regionId: 'Engagement - Socialization',\n      type: 'line',\n      data: { id: 'Engagement - Socialization' },\n      xField: 'x',\n      yField: 'y'\n    },\n    {\n      id: 'Penetration of Private Messagesseries0',\n      regionId: 'Penetration of Private Messages',\n      type: 'line',\n      data: { id: 'Penetration of Private Messages' },\n      xField: 'x',\n      yField: 'y'\n    },\n    {\n      id: 'Number of Private Messages per Userseries0',\n      regionId: 'Number of Private Messages per User',\n      type: 'line',\n      data: { id: 'Number of Private Messages per User' },\n      xField: 'x',\n      yField: 'y'\n    }\n  ],\n  axes: [\n    {\n      id: 'Social Penetrationleft',\n      regionId: 'Social Penetration',\n      orient: 'left',\n      title: { visible: true, text: 'SP' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Engagement - Socialization-left',\n      regionId: 'Engagement - Socialization',\n      orient: 'left',\n      title: { visible: true, text: 'ES' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Penetration of Private Messagesleft',\n      regionId: 'Penetration of Private Messages',\n      orient: 'left',\n      title: { visible: true, text: 'Penetration of PM' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Number of Private Messages per Userleft',\n      regionId: 'Number of Private Messages per User',\n      orient: 'left',\n      title: { visible: true, text: 'PM per User' },\n      ...leftAxesCommonSpec\n    },\n    {\n      id: 'Number of Private Messages per User-bottom',\n      regionId: [\n        'Social Penetration',\n        'Engagement - Socialization',\n        'Penetration of Private Messages',\n        'Number of Private Messages per User'\n      ],\n      orient: 'bottom',\n      label: {\n        firstVisible: true,\n        lastVisible: true,\n        visible: true\n      },\n      tick: { visible: false },\n      paddingInner: 0.99,\n      paddingOuter: 0\n    }\n  ]\n};\n\nfetch('https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vchart/tutorials/col-line-data.json').then(res => {\n  res.json().then(dataJson => {\n    spec.series.forEach(s => {\n      s.data.values = dataJson[s.data.id];\n    });\n    const vchart = new VChart(spec, { dom: CONTAINER_ID });\n    vchart.renderSync();\n\n    // Just for the convenience of console debugging, DO NOT COPY!\n    window['vchart'] = vchart;\n  });\n});</br>\n```\r\n## 结果展示 \r\n\r\nhttps://visactor.io/vchart/demo/combination/col-line</br>\r\n## 相关文档\r\n\r\nDemo：https://visactor.io/vchart/demo/combination/col-line</br>\r\n教程：</br>\r\n*  组合图： https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination</br>\r\n*  Grid 布局：https://visactor.io/vchart/guide/tutorial_docs/Layout/Layout_Cases/example-grid</br>\r\nAPI：</br>\r\n*  组合图：https://visactor.io/vchart/option/commonChart</br>\r\n*  Grid 布局：https://visactor.io/vchart/option/commonChart#layout.type</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '142- How to add tracking points in VChart based on Tooltip behavior.md',
    content:
      "---\ntitle: 14. 如何在 VChart 中根据 Tooltip 行为， 进行埋点</br>\n---\r\n## 问题标题\r\n\r\n如何在 VChart 中根据 Tooltip 行为， 进行埋点</br>\r\n## 问题描述\r\n\r\n用户在查看图表时， 需要得知在什么时候对图表进行了 tooltip 查看操作， 需要将图表的行为埋点上报。</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart 由提供 Tooltip 相关事件， 涉及 触发 tooltip、更新 tooltip、销毁 tooltip 等各个阶段。 可以使用`dimensionHover`， `tooltipShow` 与 `tooltipHide`事件获取到需要的信息。</br>\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'Autocracies', year: '1930', value: 129 },\n        { type: 'Autocracies', year: '1940', value: 133 },\n        { type: 'Autocracies', year: '1950', value: 130 },\n        { type: 'Autocracies', year: '1960', value: 126 },\n        { type: 'Autocracies', year: '1970', value: 117 },\n        { type: 'Autocracies', year: '1980', value: 114 },\n        { type: 'Autocracies', year: '1990', value: 111 },\n        { type: 'Autocracies', year: '2000', value: 89 },\n        { type: 'Autocracies', year: '2010', value: 80 },\n        { type: 'Autocracies', year: '2018', value: 80 },\n        { type: 'Democracies', year: '1930', value: 22 },\n        { type: 'Democracies', year: '1940', value: 13 },\n        { type: 'Democracies', year: '1950', value: 25 },\n        { type: 'Democracies', year: '1960', value: 29 },\n        { type: 'Democracies', year: '1970', value: 38 },\n        { type: 'Democracies', year: '1980', value: 41 },\n        { type: 'Democracies', year: '1990', value: 57 },\n        { type: 'Democracies', year: '2000', value: 87 },\n        { type: 'Democracies', year: '2010', value: 98 },\n        { type: 'Democracies', year: '2018', value: 99 }\n      ]\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  legends: {\n    visible: true,\n    orient: 'top',\n    position: 'start'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nvchart.on('dimensionHover', (params)=>{\n  if(params.action === 'enter'){\n    console.log('Triggered when enter Dimension', )\n  } else if(params.action ==='move'){\n    console.log('Triggered when move Dimension', )\n  } else if(params.action ==='leave'){\n    console.log('Triggered when leave Dimension', )\n  }\n})\n\nvchart.on('tooltipShow', (params) => {\n  console.log('Triggered every rendering')\n  if(params.changePositionOnly === true){\n    console.log('Triggered position change only')\n  } else {\n    console.log('Triggered target mark change')\n  }\n})\n\nvchart.on('tooltipHide', (params) => {\n  console.log('Triggered every hide')\n})\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考： https://codesandbox.io/p/sandbox/vchart-tooltip-event-gmcgqf?file=%2Fsrc%2Findex.js%3A49%2C1</br>\r\n## 相关文档\r\n\r\nTooltip 教程文档： https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip</br>\r\nGithub: https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '143- How to set the maximum number of labels on the X and Y axes.md',
    content:
      "---\ntitle: 66.如何设置X轴和Y轴标签的最大数量？</br>\n---\r\n## 问题标题\r\n\r\n如何设置X轴和Y轴标签的最大数量？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n下面的图表中，x轴的标签展示的比较密集，可以限制标签的最大数量吗？让x轴标签视觉上更好，同时点的线上的点都需要展示</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/US4jb7yuno8WMZxjdXDc9GYwn4f.gif' alt='' width='1362' height='1032'>\r\n\r\n## 解决方案 \r\n\r\nVChart中，轴标签的个数受多种配置的影响，有两种办法限制轴标签的个数：</br>\r\n*  `sampling`设置为`true`，这样会根据标签的宽度，自动抽样</br>\r\n*  `tick.tickCount`设置标签个数</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/AWphbwooco1VBdxWZ7XchRXinrc.gif' alt='' width='3528' height='1268'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        medalType: 'Gold Medals',\n        count: 40,\n        year: '1952'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 32,\n        year: '1956'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 34,\n        year: '1960'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 36,\n        year: '1964'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 45,\n        year: '1968'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 33,\n        year: '1972'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 34,\n        year: '1976'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: null,\n        year: '1980'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 83,\n        year: '1984'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 36,\n        year: '1988'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 37,\n        year: '1992'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 44,\n        year: '1996'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 37,\n        year: '2000'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 35,\n        year: '2004'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 36,\n        year: '2008'\n      },\n      {\n        medalType: 'Gold Medals',\n        count: 46,\n        year: '2012'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 19,\n        year: '1952'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 25,\n        year: '1956'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 21,\n        year: '1960'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 26,\n        year: '1964'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 28,\n        year: '1968'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 31,\n        year: '1972'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 35,\n        year: '1976'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: null,\n        year: '1980'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 60,\n        year: '1984'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 31,\n        year: '1988'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 34,\n        year: '1992'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 32,\n        year: '1996'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 24,\n        year: '2000'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 40,\n        year: '2004'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 38,\n        year: '2008'\n      },\n      {\n        medalType: 'Silver Medals',\n        count: 29,\n        year: '2012'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 17,\n        year: '1952'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 17,\n        year: '1956'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 16,\n        year: '1960'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 28,\n        year: '1964'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 34,\n        year: '1968'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 30,\n        year: '1972'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 25,\n        year: '1976'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: null,\n        year: '1980'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 30,\n        year: '1984'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 27,\n        year: '1988'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 37,\n        year: '1992'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 25,\n        year: '1996'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 33,\n        year: '2000'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 26,\n        year: '2004'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 36,\n        year: '2008'\n      },\n      {\n        medalType: 'Bronze Medals',\n        count: 29,\n        year: '2012'\n      }\n    ]\n  },\n  xField: 'year',\n  yField: 'count',\n  seriesField: 'medalType',\n  invalidType: 'link',\n  axes: [\n    {\n      orient: 'bottom',\n      tick: {\n        tickCount: 5\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/O1TwbmurkogF6Pxrgehc23BJnVe.gif' alt='' width='1384' height='1060'>\r\n\r\n## 相关文档\r\n\r\n*  [Axes  坐标轴教程](https%3A%2F%2Fwww.visactor.io%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FAxes)</br>\r\n*  [VChart github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n\r\n"
  },
  {
    fileName: '144- How does the tooltip layer support the display of total data.md',
    content:
      "---\ntitle: 80.Tooltip浮层如何支持总计数据的展示？</br>\n---\r\n## 问题标题\r\n\r\nTooltip浮层如何支持总计数据的展示？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n在图表中，如果想要展示所有数据的汇总值，可以实现吗</br>\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Kxzeb4SgNohe0sx0U9zcJFDAnqe.gif' alt='' width='1460' height='1036'>\r\n\r\n## 解决方案\r\n\r\nVChart中，tooltip存在三种类型：</br>\r\n*  分组Tooltip (group)</br>\r\n*  维度Tooltip (dimension)</br>\r\n*  图元Tooltip (mark)</br>\r\n针对上面提到的汇总数据的展示，适用于分组tooltip和维度tooltip，那就可以通过`tooltip.dimension.updateContent`来进行自定义的展示</br>\r\n```\ntooltip: {\n    dimension: {\n      updateContent: (items) => {\n        const total = items.reduce((sum, item) => {\n          return +item.value + sum;\n        }, 0)\n        return [\n          {\n            ...items[0],\n            key: '总计',\n            value: total,\n            hasShape: false,\n          },\n          ...items\n        ];\n      }\n    }\n  }</br>\n```\r\n## 代码示例\r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  tooltip: {\n    dimension: {\n      updateContent: (items) => {\n        const total = items.reduce((sum, item) => {\n          return +item.value + sum;\n        }, 0)\n        return [\n          {\n            ...items[0],\n            key: '总计',\n            value: total,\n            hasShape: false,\n          },\n          ...items\n        ];\n      }\n    }\n  }\n};</br>\n```\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/PCdObwWKVo5OWBx1pOoctzM1ndh.gif' alt='' width='1760' height='1042'>\r\n\r\n## 相关文档\r\n\r\n*  [github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n*  [tooltip配置](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FbarChart%23tooltip.dimension.updateContent)</br>\r\n*  [tooltip 格式化内容示例](https%3A%2F%2Fvisactor.com%2Fvchart%2Fdemo%2Ftooltip%2Fformat-method)</br>"
  },
  {
    fileName: '145- How to show the full content of abbreviated text when hovering with the mouse.md',
    content:
      "---\ntitle: 2. 如何实现鼠标悬浮时展示缩略文字的全部内容？</br>\n---\r\n## 问题标题\r\n\r\n如何实现鼠标悬浮时展示缩略文字的全部内容？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n对于下面这个case，可以实现hover标签展示tip全部信息吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/RNFmbxMNLo2QMVxdivfczzuBned.gif' alt='' width='1756' height='1162'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n可以在 new VChart 的时候配置 `poptip: true`，然后设置标签 `style.pickable: true` 开启标签的交互，这样可以在 hover 到**被缩略**的标签上时展示完整内容的 poptip。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/KMiAbWPJZo5uhlxCavccjafan4e.gif' alt='' width='3254' height='1248'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  valueField: 'y',\n  categoryField: 'originXData',\n  label: {\n    visible: true,\n    position: 'outside',\n    style: {\n      pickable: true\n    }\n  },\n  legends: {\n    orient: 'right'\n  },\n  title: {\n    visible: true,\n    text: 'Distribution of Active Device Usage Time',\n    textStyle: {\n      fontFamily: 'Times New Roman'\n    }\n  },\n  data: {\n    id: 'Others',\n    values: [\n      {\n        x: 0,\n        y: 0.14307327905613595,\n        originXData: '2022-03-10',\n        type: 'Others'\n      },\n      {\n        x: 1,\n        y: 0.21429552139096195,\n        originXData: '2022-03-11',\n        type: 'Others'\n      },\n      {\n        x: 2,\n        y: 0.20335734294489136,\n        originXData: '2022-03-12',\n        type: 'Others'\n      },\n      {\n        x: 3,\n        y: 0.2008694831063025,\n        originXData: '2022-03-13',\n        type: 'Others'\n      },\n      {\n        x: 4,\n        y: 0.1971832522288174,\n        originXData: '2022-03-14',\n        type: 'Others'\n      },\n      {\n        x: 5,\n        y: 0.2142196933878632,\n        originXData: '2022-03-15',\n        type: 'Others'\n      },\n      {\n        x: 6,\n        y: 0.2827589869448442,\n        originXData: '2022-03-16',\n        type: 'Others'\n      },\n      {\n        x: 7,\n        y: 0.11448070987270477,\n        originXData: '2022-03-17',\n        type: 'Others'\n      },\n      {\n        x: 8,\n        y: 0.05225580072971028,\n        originXData: '2022-03-18',\n        type: 'Others'\n      },\n      {\n        x: 9,\n        y: 0.14047231243026995,\n        originXData: '2022-03-19',\n        type: 'Others'\n      },\n      {\n        x: 10,\n        y: 0.28277882018816153,\n        originXData: '2022-03-20',\n        type: 'Others'\n      },\n      {\n        x: 11,\n        y: 0.1907366902350664,\n        originXData: '2022-03-21',\n        type: 'Others'\n      },\n      {\n        x: 12,\n        y: 0.09187776153132483,\n        originXData: '2022-03-22',\n        type: 'Others'\n      },\n      {\n        x: 13,\n        y: 0.1865056149692558,\n        originXData: '2022-03-23',\n        type: 'Others'\n      },\n      {\n        x: 14,\n        y: 0.24279307316823684,\n        originXData: '2022-03-24',\n        type: 'Others'\n      },\n      {\n        x: 15,\n        y: 0.021338783251485593,\n        originXData: '2022-03-25',\n        type: 'Others'\n      },\n      {\n        x: 16,\n        y: 0.01933475918339416,\n        originXData: '2022-03-26',\n        type: 'Others'\n      },\n      {\n        x: 17,\n        y: 0.12054221495926994,\n        originXData: '2022-03-27',\n        type: 'Others'\n      },\n      {\n        x: 18,\n        y: 0.21045103303733279,\n        originXData: '2022-03-28',\n        type: 'Others'\n      },\n      {\n        x: 19,\n        y: 0.09510339439959557,\n        originXData: '2022-03-29',\n        type: 'Others'\n      },\n      {\n        x: 20,\n        y: 0.10953268445458815,\n        originXData: '2022-03-30',\n        type: 'Others'\n      },\n      {\n        x: 21,\n        y: 0.033257671235135976,\n        originXData: '2022-03-31',\n        type: 'Others'\n      },\n      {\n        x: 22,\n        y: 0.17596385420505348,\n        originXData: '2022-04-01',\n        type: 'Others'\n      },\n      {\n        x: 23,\n        y: 0.21956883545536887,\n        originXData: '2022-04-02',\n        type: 'Others'\n      },\n      {\n        x: 24,\n        y: 0.10219962878682523,\n        originXData: '2022-04-03',\n        type: 'Others'\n      },\n      {\n        x: 25,\n        y: 0.22559599632037952,\n        originXData: '2022-04-04',\n        type: 'Others'\n      },\n      {\n        x: 26,\n        y: 0.16435385997820343,\n        originXData: '2022-04-05',\n        type: 'Others'\n      },\n      {\n        x: 27,\n        y: 0.1935519088636391,\n        originXData: '2022-04-06',\n        type: 'Others'\n      },\n      {\n        x: 28,\n        y: 0.07335880623323374,\n        originXData: '2022-04-07',\n        type: 'Others'\n      },\n      {\n        x: 29,\n        y: 0.32389684991741824,\n        originXData: '2022-04-08',\n        type: 'Others'\n      },\n      {\n        x: 30,\n        y: 0.10574926398978153,\n        originXData: '2022-04-09',\n        type: 'Others'\n      },\n      {\n        x: 31,\n        y: 0.09551619886403787,\n        originXData: '2022-04-10',\n        type: 'Others'\n      },\n      {\n        x: 32,\n        y: 0.18753913754340706,\n        originXData: '2022-04-11',\n        type: 'Others'\n      },\n      {\n        x: 33,\n        y: 0.07251128093720469,\n        originXData: '2022-04-12',\n        type: 'Others'\n      },\n      {\n        x: 34,\n        y: 0.27187881356101434,\n        originXData: '2022-04-13',\n        type: 'Others'\n      },\n      {\n        x: 35,\n        y: 0.03161092640346868,\n        originXData: '2022-04-14',\n        type: 'Others'\n      },\n      {\n        x: 36,\n        y: 0.08645234316145103,\n        originXData: '2022-04-15',\n        type: 'Others'\n      },\n      {\n        x: 37,\n        y: 0.07186915826544578,\n        originXData: '2022-04-16',\n        type: 'Others'\n      },\n      {\n        x: 38,\n        y: 0.13298789816789602,\n        originXData: '2022-04-17',\n        type: 'Others'\n      },\n      {\n        x: 39,\n        y: 0.002498664507185538,\n        originXData: '2022-04-18',\n        type: 'Others'\n      },\n      {\n        x: 40,\n        y: 0.23047255698181987,\n        originXData: '2022-04-19',\n        type: 'Others'\n      },\n      {\n        x: 41,\n        y: 0.2614287826126477,\n        originXData: '2022-04-20',\n        type: 'Others'\n      },\n      {\n        x: 42,\n        y: 0.1416942415946803,\n        originXData: '2022-04-21',\n        type: 'Others'\n      },\n      {\n        x: 43,\n        y: 0.16875110819471914,\n        originXData: '2022-04-22',\n        type: 'Others'\n      },\n      {\n        x: 44,\n        y: 0.17855071283439228,\n        originXData: '2022-04-23',\n        type: 'Others'\n      },\n      {\n        x: 45,\n        y: 0.19374483996277542,\n        originXData: '2022-04-24',\n        type: 'Others'\n      },\n      {\n        x: 46,\n        y: 0.15310293715544224,\n        originXData: '2022-04-25',\n        type: 'Others'\n      },\n      {\n        x: 47,\n        y: 0.054940671436646556,\n        originXData: '2022-04-26',\n        type: 'Others'\n      },\n      {\n        x: 48,\n        y: 0.15449255983596022,\n        originXData: '2022-04-27',\n        type: 'Others'\n      },\n      {\n        x: 49,\n        y: 0.013363330618058769,\n        originXData: '2022-04-28',\n        type: 'Others'\n      },\n      {\n        x: 50,\n        y: 0.04741482052942758,\n        originXData: '2022-04-29',\n        type: 'Others'\n      },\n      {\n        x: 51,\n        y: 0.20622154823735023,\n        originXData: '2022-04-30',\n        type: 'Others'\n      },\n      {\n        x: 52,\n        y: 0.06582002462369495,\n        originXData: '2022-05-01',\n        type: 'Others'\n      },\n      {\n        x: 53,\n        y: 0.09378151773093113,\n        originXData: '2022-05-02',\n        type: 'Others'\n      },\n      {\n        x: 54,\n        y: 0.020396192047011766,\n        originXData: '2022-05-03',\n        type: 'Others'\n      },\n      {\n        x: 55,\n        y: 0.18516266015947339,\n        originXData: '2022-05-04',\n        type: 'Others'\n      },\n      {\n        x: 56,\n        y: 0.10161741887065481,\n        originXData: '2022-05-05',\n        type: 'Others'\n      },\n      {\n        x: 57,\n        y: 0.1770505715131574,\n        originXData: '2022-05-06',\n        type: 'Others'\n      },\n      {\n        x: 58,\n        y: 0.11339797878184575,\n        originXData: '2022-05-07',\n        type: 'Others'\n      },\n      {\n        x: 59,\n        y: 0.14515252680521537,\n        originXData: '2022-05-08',\n        type: 'Others'\n      },\n      {\n        x: 60,\n        y: 0.26957310267383333,\n        originXData: '2022-05-09',\n        type: 'Others'\n      },\n      {\n        x: 61,\n        y: 0.19599754596225075,\n        originXData: '2022-05-10',\n        type: 'Others'\n      },\n      {\n        x: 62,\n        y: 0.17669944891975334,\n        originXData: '2022-05-11',\n        type: 'Others'\n      },\n      {\n        x: 63,\n        y: 0.1558657621841565,\n        originXData: '2022-05-12',\n        type: 'Others'\n      },\n      {\n        x: 64,\n        y: 0.059105464959508816,\n        originXData: '2022-05-13',\n        type: 'Others'\n      },\n      {\n        x: 65,\n        y: 0.12362337826604534,\n        originXData: '2022-05-14',\n        type: 'Others'\n      },\n      {\n        x: 66,\n        y: 0.15828457651759154,\n        originXData: '2022-05-15',\n        type: 'Others'\n      },\n      {\n        x: 67,\n        y: 0.16477088382957397,\n        originXData: '2022-05-16',\n        type: 'Others'\n      },\n      {\n        x: 68,\n        y: 0.18942277783699418,\n        originXData: '2022-05-17',\n        type: 'Others'\n      },\n      {\n        x: 69,\n        y: 0.09183608563616476,\n        originXData: '2022-05-18',\n        type: 'Others'\n      },\n      {\n        x: 70,\n        y: 0.11050570522075298,\n        originXData: '2022-05-19',\n        type: 'Others'\n      },\n      {\n        x: 71,\n        y: 0.27962609951245393,\n        originXData: '2022-05-20',\n        type: 'Others'\n      },\n      {\n        x: 72,\n        y: 0.03528028179470999,\n        originXData: '2022-05-21',\n        type: 'Others'\n      },\n      {\n        x: 73,\n        y: 0.05384340884433819,\n        originXData: '2022-05-22',\n        type: 'Others'\n      },\n      {\n        x: 74,\n        y: 0.2566109634380092,\n        originXData: '2022-05-23',\n        type: 'Others'\n      },\n      {\n        x: 75,\n        y: 0.04706710842769647,\n        originXData: '2022-05-24',\n        type: 'Others'\n      },\n      {\n        x: 76,\n        y: 0.0690497936642742,\n        originXData: '2022-05-25',\n        type: 'Others'\n      },\n      {\n        x: 77,\n        y: 0.22240850644149432,\n        originXData: '2022-05-26',\n        type: 'Others'\n      },\n      {\n        x: 78,\n        y: 0.25247664377313944,\n        originXData: '2022-05-27',\n        type: 'Others'\n      },\n      {\n        x: 79,\n        y: 0.040225106713192425,\n        originXData: '2022-05-28',\n        type: 'Others'\n      },\n      {\n        x: 80,\n        y: 0.163839716976959,\n        originXData: '2022-05-29',\n        type: 'Others'\n      },\n      {\n        x: 81,\n        y: 0.07390521222877466,\n        originXData: '2022-05-30',\n        type: 'Others'\n      },\n      {\n        x: 82,\n        y: 0.012491096724084544,\n        originXData: '2022-05-31',\n        type: 'Others'\n      },\n      {\n        x: 83,\n        y: 0.10259216712446957,\n        originXData: '2022-06-01',\n        type: 'Others'\n      },\n      {\n        x: 84,\n        y: 0.08823120890048103,\n        originXData: '2022-06-02',\n        type: 'Others'\n      },\n      {\n        x: 85,\n        y: 0.09010761416766332,\n        originXData: '2022-06-03',\n        type: 'Others'\n      },\n      {\n        x: 86,\n        y: 0.04192469399478194,\n        originXData: '2022-06-04',\n        type: 'Others'\n      },\n      {\n        x: 87,\n        y: 0.11732142545122648,\n        originXData: '2022-06-05',\n        type: 'Others'\n      },\n      {\n        x: 88,\n        y: 0.18585780122660603,\n        originXData: '2022-06-06',\n        type: 'Others'\n      },\n      {\n        x: 89,\n        y: 0.0870820363115993,\n        originXData: '2022-06-07',\n        type: 'Others'\n      },\n      {\n        x: 90,\n        y: 0.2826807478126429,\n        originXData: '2022-06-08',\n        type: 'Others'\n      },\n      {\n        x: 91,\n        y: 0.06430150639799394,\n        originXData: '2022-06-09',\n        type: 'Others'\n      },\n      {\n        x: 92,\n        y: 0.16911472425643598,\n        originXData: '2022-06-10',\n        type: 'Others'\n      },\n      {\n        x: 93,\n        y: 0.04418197716587454,\n        originXData: '2022-06-11',\n        type: 'Others'\n      },\n      {\n        x: 94,\n        y: 0.05620634466431073,\n        originXData: '2022-06-12',\n        type: 'Others'\n      },\n      {\n        x: 95,\n        y: 0.09831084516203888,\n        originXData: '2022-06-13',\n        type: 'Others'\n      },\n      {\n        x: 96,\n        y: 0.09479199824809702,\n        originXData: '2022-06-14',\n        type: 'Others'\n      },\n      {\n        x: 97,\n        y: 0.051668527899557275,\n        originXData: '2022-06-15',\n        type: 'Others'\n      },\n      {\n        x: 98,\n        y: 0.058331438549321345,\n        originXData: '2022-06-16',\n        type: 'Others'\n      },\n      {\n        x: 99,\n        y: 0.23034428608925023,\n        originXData: '2022-06-17',\n        type: 'Others'\n      },\n      {\n        x: 100,\n        y: 0.20177663186099093,\n        originXData: '2022-06-18',\n        type: 'Others'\n      },\n      {\n        x: 101,\n        y: 0.18978717005592927,\n        originXData: '2022-06-19',\n        type: 'Others'\n      },\n      {\n        x: 102,\n        y: 0.28782493963004174,\n        originXData: '2022-06-20',\n        type: 'Others'\n      },\n      {\n        x: 103,\n        y: 0.1467829353931672,\n        originXData: '2022-06-21',\n        type: 'Others'\n      },\n      {\n        x: 104,\n        y: 0.128230433126852,\n        originXData: '2022-06-22',\n        type: 'Others'\n      },\n      {\n        x: 105,\n        y: 0.0548449051449372,\n        originXData: '2022-06-23',\n        type: 'Others'\n      },\n      {\n        x: 106,\n        y: 0.13419037997388159,\n        originXData: '2022-06-24',\n        type: 'Others'\n      },\n      {\n        x: 107,\n        y: 0.03650370242329377,\n        originXData: '2022-06-25',\n        type: 'Others'\n      },\n      {\n        x: 108,\n        y: 0.11300795916055194,\n        originXData: '2022-06-26',\n        type: 'Others'\n      },\n      {\n        x: 109,\n        y: 0.2892243111269155,\n        originXData: '2022-06-27',\n        type: 'Others'\n      },\n      {\n        x: 110,\n        y: 0.12881197140544712,\n        originXData: '2022-06-28',\n        type: 'Others'\n      },\n      {\n        x: 111,\n        y: 0.08568882796496745,\n        originXData: '2022-06-29',\n        type: 'Others'\n      },\n      {\n        x: 112,\n        y: 0.1876531712328392,\n        originXData: '2022-06-30',\n        type: 'Others'\n      },\n      {\n        x: 113,\n        y: 0.12802513423936035,\n        originXData: '2022-07-01',\n        type: 'Others'\n      },\n      {\n        x: 114,\n        y: 0.04085275656525246,\n        originXData: '2022-07-02',\n        type: 'Others'\n      },\n      {\n        x: 115,\n        y: 0.11571890266638503,\n        originXData: '2022-07-03',\n        type: 'Others'\n      },\n      {\n        x: 116,\n        y: 0.0506988188387463,\n        originXData: '2022-07-04',\n        type: 'Others'\n      },\n      {\n        x: 117,\n        y: 0.1494689703003086,\n        originXData: '2022-07-05',\n        type: 'Others'\n      },\n      {\n        x: 118,\n        y: 0.27730792196171267,\n        originXData: '2022-07-06',\n        type: 'Others'\n      },\n      {\n        x: 119,\n        y: 0.06055467590069835,\n        originXData: '2022-07-07',\n        type: 'Others'\n      },\n      {\n        x: 120,\n        y: 0.07687827184447993,\n        originXData: '2022-07-08',\n        type: 'Others'\n      },\n      {\n        x: 121,\n        y: 0.2566842936513114,\n        originXData: '2022-07-09',\n        type: 'Others'\n      },\n      {\n        x: 122,\n        y: 0.09887321357707671,\n        originXData: '2022-07-10',\n        type: 'Others'\n      },\n      {\n        x: 123,\n        y: 0.02730324273499053,\n        originXData: '2022-07-11',\n        type: 'Others'\n      },\n      {\n        x: 124,\n        y: 0.06536264665124339,\n        originXData: '2022-07-12',\n        type: 'Others'\n      },\n      {\n        x: 125,\n        y: 0.18847345356749562,\n        originXData: '2022-07-13',\n        type: 'Others'\n      },\n      {\n        x: 126,\n        y: 0.28310751524370814,\n        originXData: '2022-07-14',\n        type: 'Others'\n      },\n      {\n        x: 127,\n        y: 0.04893307176362374,\n        originXData: '2022-07-15',\n        type: 'Others'\n      },\n      {\n        x: 128,\n        y: 0.05023463131640375,\n        originXData: '2022-07-16',\n        type: 'Others'\n      },\n      {\n        x: 129,\n        y: 0.1817991933208958,\n        originXData: '2022-07-17',\n        type: 'Others'\n      },\n      {\n        x: 130,\n        y: 0.041091429149233895,\n        originXData: '2022-07-18',\n        type: 'Others'\n      },\n      {\n        x: 131,\n        y: 0.2152272967544634,\n        originXData: '2022-07-19',\n        type: 'Others'\n      },\n      {\n        x: 132,\n        y: 0.2294092597480583,\n        originXData: '2022-07-20',\n        type: 'Others'\n      },\n      {\n        x: 133,\n        y: 0.04812026594860752,\n        originXData: '2022-07-21',\n        type: 'Others'\n      },\n      {\n        x: 134,\n        y: 0.15062608602077723,\n        originXData: '2022-07-22',\n        type: 'Others'\n      },\n      {\n        x: 135,\n        y: 0.04674341937375404,\n        originXData: '2022-07-23',\n        type: 'Others'\n      },\n      {\n        x: 136,\n        y: 0.004691953334433059,\n        originXData: '2022-07-24',\n        type: 'Others'\n      },\n      {\n        x: 137,\n        y: 0.2347717591286564,\n        originXData: '2022-07-25',\n        type: 'Others'\n      },\n      {\n        x: 138,\n        y: 0.0949449243680592,\n        originXData: '2022-07-26',\n        type: 'Others'\n      },\n      {\n        x: 139,\n        y: 0.0025869855432198155,\n        originXData: '2022-07-27',\n        type: 'Others'\n      },\n      {\n        x: 140,\n        y: 0.16298210425832638,\n        originXData: '2022-07-28',\n        type: 'Others'\n      },\n      {\n        x: 141,\n        y: 0.04294961250823847,\n        originXData: '2022-07-29',\n        type: 'Others'\n      },\n      {\n        x: 142,\n        y: 0.23218888847906793,\n        originXData: '2022-07-30',\n        type: 'Others'\n      },\n      {\n        x: 143,\n        y: 0.13214197196191788,\n        originXData: '2022-07-31',\n        type: 'Others'\n      },\n      {\n        x: 144,\n        y: 0.23639487247464253,\n        originXData: '2022-08-01',\n        type: 'Others'\n      },\n      {\n        x: 145,\n        y: 0.2198732786335028,\n        originXData: '2022-08-02',\n        type: 'Others'\n      },\n      {\n        x: 146,\n        y: 0.09819916842568255,\n        originXData: '2022-08-03',\n        type: 'Others'\n      },\n      {\n        x: 147,\n        y: 0.2115038338762922,\n        originXData: '2022-08-04',\n        type: 'Others'\n      },\n      {\n        x: 148,\n        y: 0.27763124426038616,\n        originXData: '2022-08-05',\n        type: 'Others'\n      },\n      {\n        x: 149,\n        y: 0.2409936721598261,\n        originXData: '2022-08-06',\n        type: 'Others'\n      },\n      {\n        x: 150,\n        y: 0.005052818869306636,\n        originXData: '2022-08-07',\n        type: 'Others'\n      },\n      {\n        x: 151,\n        y: 0.10509982509852842,\n        originXData: '2022-08-08',\n        type: 'Others'\n      },\n      {\n        x: 152,\n        y: 0.14684738504256475,\n        originXData: '2022-08-09',\n        type: 'Others'\n      },\n      {\n        x: 153,\n        y: 0.06986602610353633,\n        originXData: '2022-08-10',\n        type: 'Others'\n      },\n      {\n        x: 154,\n        y: 0.13023043447411542,\n        originXData: '2022-08-11',\n        type: 'Others'\n      },\n      {\n        x: 155,\n        y: 0.12264398311386293,\n        originXData: '2022-08-12',\n        type: 'Others'\n      },\n      {\n        x: 156,\n        y: 0.20382835554590054,\n        originXData: '2022-08-13',\n        type: 'Others'\n      },\n      {\n        x: 157,\n        y: 0.11198492143289837,\n        originXData: '2022-08-14',\n        type: 'Others'\n      },\n      {\n        x: 158,\n        y: 0.07253893276910192,\n        originXData: '2022-08-15',\n        type: 'Others'\n      },\n      {\n        x: 159,\n        y: 0.15861094511518986,\n        originXData: '2022-08-16',\n        type: 'Others'\n      },\n      {\n        x: 160,\n        y: 0.022509784190967996,\n        originXData: '2022-08-17',\n        type: 'Others'\n      },\n      {\n        x: 161,\n        y: 0.07739714475795986,\n        originXData: '2022-08-18',\n        type: 'Others'\n      },\n      {\n        x: 162,\n        y: 0.05940452504975817,\n        originXData: '2022-08-19',\n        type: 'Others'\n      },\n      {\n        x: 163,\n        y: 0.22652737632082653,\n        originXData: '2022-08-20',\n        type: 'Others'\n      },\n      {\n        x: 164,\n        y: 0.09417964564260689,\n        originXData: '2022-08-21',\n        type: 'Others'\n      },\n      {\n        x: 165,\n        y: 0.31222056741049686,\n        originXData: '2022-08-22',\n        type: 'Others'\n      },\n      {\n        x: 166,\n        y: 0.013723402827825214,\n        originXData: '2022-08-23',\n        type: 'Others'\n      },\n      {\n        x: 167,\n        y: 0.1677747137304682,\n        originXData: '2022-08-24',\n        type: 'Others'\n      },\n      {\n        x: 168,\n        y: 0.11204260848132035,\n        originXData: '2022-08-25',\n        type: 'Others'\n      },\n      {\n        x: 169,\n        y: 0.1582346072173578,\n        originXData: '2022-08-26',\n        type: 'Others'\n      },\n      {\n        x: 170,\n        y: 0.1341413906744606,\n        originXData: '2022-08-27',\n        type: 'Others'\n      },\n      {\n        x: 171,\n        y: 0.13629356138973928,\n        originXData: '2022-08-28',\n        type: 'Others'\n      },\n      {\n        x: 172,\n        y: 0.21164869928303595,\n        originXData: '2022-08-29',\n        type: 'Others'\n      },\n      {\n        x: 173,\n        y: 0.013993773801955914,\n        originXData: '2022-08-30',\n        type: 'Others'\n      },\n      {\n        x: 174,\n        y: 0.057582671694496976,\n        originXData: '2022-08-31',\n        type: 'Others'\n      },\n      {\n        x: 175,\n        y: 0.17667401662601473,\n        originXData: '2022-09-01',\n        type: 'Others'\n      },\n      {\n        x: 176,\n        y: 0.1877708486581661,\n        originXData: '2022-09-02',\n        type: 'Others'\n      },\n      {\n        x: 177,\n        y: 0.02921282831170386,\n        originXData: '2022-09-03',\n        type: 'Others'\n      },\n      {\n        x: 178,\n        y: 0.18747152615768573,\n        originXData: '2022-09-04',\n        type: 'Others'\n      },\n      {\n        x: 179,\n        y: 0.03413689752079186,\n        originXData: '2022-09-05',\n        type: 'Others'\n      },\n      {\n        x: 180,\n        y: 0.032656498599706374,\n        originXData: '2022-09-06',\n        type: 'Others'\n      }\n    ]\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, poptip: true });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, do not copy\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/poptip-qjx6sz?file=%2Fsrc%2Findex.ts%3A12%2C15</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Lo4UbJIqcoUDCNx28pqcDRSmn6e.gif' alt='' width='990' height='946'>\r\n\r\n\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n相关api：https://www.visactor.io/vchart/api/API/vchart</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '146-How to configure the transform width of the funnel chart.md',
    content:
      "# 如何配置漏斗图的转化宽度？\n\n## 问题描述\n\n我在绘制漏斗图的时候发现当数据差异比较大的时候（比如最大的数据是 1000，最小的数据只有 10）最后绘制出来的漏斗图底下的图元会非常窄。请问有什么办法能配置漏斗图的转化宽度吗？\n\n## 解决方案\n\nVChart 漏斗图允许开发者通过 `minSize` 配置最小的漏斗宽度，以避免部分漏斗过窄的情况。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'funnel',\n  categoryField: 'name',\n  valueField: 'value',\n  data: [\n    {\n      id: 'funnel',\n      values: [\n        {\n          value: 1000,\n          name: 'Step1'\n        },\n        {\n          value: 80,\n          name: 'Step2'\n        },\n        {\n          value: 60,\n          name: 'Step3'\n        },\n        {\n          value: 40,\n          name: 'Step4'\n        },\n        {\n          value: 10,\n          name: 'Step5'\n        }\n      ]\n    }\n  ],\n  minSize: 20,\n  label: {\n    visible: true\n  },\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [Funnel minSize spec](https://visactor.io/vchart/option/funnelChart#minSize)\n"
  },
  {
    fileName: '147-How to achieve background segmentation and rounded corner effect in a gauge chart.md',
    content:
      "# 如何实现仪表图的分段圆角效果？\n\n## 问题描述\n\n我在 vchart 官网上看到了这个 demo：[https://www.visactor.io/vchart/demo/gauge-chart/clock](https://www.visactor.io/vchart/demo/gauge-chart/clock)\n\n它看起来像是仪表图的变种。现在我需要将常规仪表图的背景更改为类似的样式，将背景分段并设置圆角。我该怎么办？\n\n## 解决方案\n\n可以参照以下 demo，用另一套数据去定义背景分段，并将背景系列（spec 的对应属性名是“gauge”）改为“gauge”系列。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'gauge',\n  data: [\n    {\n      id: 'pointer',\n      values: [\n        {\n          type: 'A',\n          value: 0.6\n        }\n      ]\n    },\n    {\n      id: 'segment',\n      values: [\n        {\n          type: 'level1',\n          value: 0.4\n        },\n        {\n          type: 'level2',\n          value: 0.6\n        },\n        {\n          type: 'level3',\n          value: 0.8\n        }\n      ]\n    }\n  ],\n  gauge: {\n    type: 'gauge',\n    dataIndex: 1,\n    categoryField: 'type',\n    valueField: 'value',\n    seriesField: 'type',\n    segment: {\n      style: {\n        cornerRadius: 10\n      }\n    }\n  },\n  pointer: {\n    style: {\n      fill: '#666666'\n    }\n  },\n  categoryField: 'type',\n  valueField: 'value',\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  startAngle: -180,\n  endAngle: 0,\n  axes: [{ type: 'linear', orient: 'angle', grid: { visible: false } }]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/65-0.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\ngauge series spec: [https://www.visactor.io/vchart/option/gaugeChart#gauge%EF%BC%88gauge%20%E7%B3%BB%E5%88%97%E7%89%88%E6%9C%AC%EF%BC%89.type('gauge')](<https://www.visactor.io/vchart/option/gaugeChart#gauge%EF%BC%88gauge%20%E7%B3%BB%E5%88%97%E7%89%88%E6%9C%AC%EF%BC%89.type('gauge')>)\n"
  },
  {
    fileName: '148-How to configure horizontal scrollbars when there is too much data in a bar chart in an applet.md',
    content:
      "# 在小程序中，柱图数据过多时，如何配置横向滚动条？\n\n## 问题描述\n\n在飞书小程序中使用 VChart 时，柱图数据过多时，如何配置横向滚动条？\n\n## 解决方案\n\n同 PC 端，配置 scrollBar 即可，通常而言，你还需要配置表示 scrollBar 位置的属性`scrollBar.orient`以及表示当前视窗范围的属性`scrollBar.start`和`scrollBar.end`。\n[mini program scrollbar](/vchart/faq/12-0.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { year: '2000', sales: 22 },\n        { year: '2001', sales: 13 },\n        { year: '2002', sales: 25 },\n        { year: '2003', sales: 29 },\n        { year: '2004', sales: 38 },\n        { year: '2005', sales: 49 },\n        { year: '2006', sales: 58 },\n        { year: '2007', sales: 29 },\n        { year: '2008', sales: 78 },\n        { year: '2009', sales: 19 },\n        { year: '2010', sales: 23 },\n        { year: '2011', sales: 20 },\n        { year: '2012', sales: 98 },\n        { year: '2013', sales: 49 },\n        { year: '2014', sales: 28 }\n      ]\n    }\n  ],\n  xField: 'year',\n  yField: 'sales',\n  scrollBar: [\n    {\n      orient: 'bottom',\n      start: 0,\n      end: 0.5,\n      roam: true\n    }\n  ]\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [滚动条 Demo](https://www.visactor.io/vchart/demo/scrollbar/basic-scrollbar-bar-chart)\n- [滚动条教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Scrollbar)\n- [相关 api](https://www.visactor.io/vchart/option/commonChart#scrollbar)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '149- How to obtain the relative position of the brush in the coordinate system in the vchart library.md',
    content:
      "---\ntitle: 66. 如何在vchart图表库中获取brush在坐标系中的相对位置？</br>\n---\r\n# 问题标题\r\n\r\n如何在vchart图表库中获取brush在坐标系中的相对位置？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我在使用vchart图表库时，遇到了一点问题，我监听了onBrushEnd事件，想要获取brush所框选区域在坐标系中的相对位置。即，当我在图表上画框以后，我想获取这个区域在x/y轴上的位置范围。我尝试了所有我能想到的方法，但是却没有找到对应的数据。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WBSxbjQLJoLxldxODj5cfyUBnOg.gif' alt='' width='862' height='832'>\r\n\r\n# 解决方案\r\n\r\n根据vchart的设计和使用，目前vchart的API并没有直接提供这个信息，但是还是可以通过一些其它的方式获取到这个必要的信息。具体如下步骤：</br>\r\n1. 通过`vchart.getAllComponents()`找到brush组件</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UsMmbspO3oEbAkxo4TLcKQQXnyd.gif' alt='' width='688' height='1158'>\r\n\r\n1. 在brush组件里，有一个叫`_brushComponent.AABBBounds`的属性，这个就是选框在region中的相对位置。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/BIjnbBaYyooFuZxveL6cYUMPnFg.gif' alt='' width='624' height='606'>\r\n\r\n3. 同样，通过`vchart.getAllComponents()`方法，我们可以找到x和y轴的组件。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/ADyXbsV3konqXoxYliAcuScOnRe.gif' alt='' width='716' height='1082'>\r\n\r\n4. 在找到的轴组件中，我们可以使用`_scale.invert(position)`方法，把上一步中获取到的AABBBounds的位置，转换到x和y轴的具体数值。</br>\r\n\r\n\r\n为了防止用户单击的时候出现极小的位置偏移，误触发brush绘制，我们还可以为brush设置一个`sizeThreshold`属性。这个属性的意思是选框大小阈值，直译就是你需要画的框的最小大小。只有框的大小大于这个阈值时，才会触发brush的事件。</br>\r\n\r\n\r\n\r\n\r\n# 相关文档\r\n\r\n*  VChart `sizeThreshold`配置项：https://www.visactor.io/vchart/option/barChart#brush.sizeThreshold</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '150- How to format axis labels.md',
    content:
      "---\ntitle: 5. 如何对轴标签进行格式化？</br>\n---\r\n## 问题标题\r\n\r\n如何对轴标签进行格式化？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如图，当轴标签数值精度有问题，非常长的时候，可以进行格式化吗？</br>\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/B6B9bdM7TordLuxQ9W7c2i7pn9f.gif' alt='' width='1516' height='1076'>\r\n\r\n## 解决方案 \r\n\r\n这里产生浮点数精度问题是因为在实现坐标轴刻度对齐的时候，进行浮点数的加法运算带来的。为了提高轴标签的可读性，可以通过`label.formatMethod`对轴标签进行格式化处理。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/P6YGbGl8eoVeBSxZjP0cQEo1nwf.gif' alt='' width='3502' height='1240'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '周一', type: '早餐', y: 0.1633 },\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '周一', type: '饮料', y: -0.3455 },\n       \n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 0,\n      label: { visible: true },\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: ['x', 'type'],\n      yField: 'y'\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: [0], id: 'left' },\n    { \n      orient: 'right', \n      seriesId: ['line'], \n      grid: { visible: false }, \n      label: {\n        formatMethod: (label) => {\n          return Math.round(label * 100) / 100;\n        }\n      },\n      sync: {\n        axisId: 'left',\n        tickAlign: true\n      } \n    },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/NBaibyqbzoWrQYx9XDkce4xUnrh.gif' alt='' width='1552' height='1034'>\r\n\r\n## 相关文档\r\n\r\n相关配置：https://www.visactor.io/vchart/option/barChart-axes-linear#label.formatMethod</br>\r\nAxes坐标轴教程: https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes</br>\r\ngithub：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '151-How does the legend component limit the width of the graph.md',
    content:
      "# 图例组件如何限制图形的宽度?\n\n## 问题描述\n\n使用的 vchart。在图例文字比较长的时候，期望可以限制图例项的宽度，不要出现这种分页\n\n## 解决方案\n\nVChart 的 图例组件提供了图例项最大宽度的配置，可以配置期望的数值，当图例项超出这个最大值时，文本会省略，并且鼠标 hover 上去时会有提示信息\n\n```ts\nlegends: [\n  {\n    type: 'discrete',\n    item: {\n      maxWidth: 200\n    }\n  }\n];\n```\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'Number of users who closed the video in the first 10 seconds', time: '2:00', value: 129 },\n        { type: 'Number of users who closed the video in the first 10 seconds', time: '6:00', value: 133 },\n        { type: 'Number of users who watched the video for more than 10 seconds', time: '2:00', value: 22 },\n        { type: 'Number of users who watched the video for more than 10 seconds', time: '6:00', value: 13 }\n      ]\n    }\n  ],\n  xField: ['time', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  legends: {\n    visible: true,\n    orient: 'top',\n    position: 'start',\n    item: {\n      maxWidth: 200\n    },\n    maxRow: 1\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [图例配置](https://www.visactor.io/vchart/option/barChart#legends-discrete.item.maxWidth)\n"
  },
  {
    fileName: '152- How to display labels on multiple lines.md',
    content:
      "---\ntitle: 73. 标签如何显示多行？</br>\n---\r\n# 问题标题\r\n\r\n标签如何显示多行？</br>\r\n# 问题描述\r\n\r\nvchart标签能够显示多行吗？我希望自定义饼图的标签内容，把数值加上去，第二行显示具体的数值</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WHdWbuk0RoWp81x6EiGcgtgfn2f.gif' alt='' width='1306' height='930'>\r\n\r\n# 解决方案\r\n\r\n饼图的标签配置在label字段中：https://visactor.io/vchart/option/pieChart#label，该字段有个属性是`formatMethod`，用于格式化label内容：https://visactor.io/vchart/option/pieChart#label.formatMethod，配置函数就可以进行标签的格式化操作，该函数接收的参数包括原始文本，数据等内容，返回一个字符串表示格式化后的标签文本，返回一个数组的话，数组的每一项代表一行</br>\r\n# 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  valueField: 'value',\n  categoryField: 'type',\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left'\n  },\n  label: {\n    visible: true,\n    formatMethod: (text, datum) => {\n      return [text, datum.value]\n    }\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n# 结果展示\r\n\r\n代码运行后，标签就可以换行格式化了</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/GMGgb8joSolAsnxVYIHc87HangP.gif' alt='' width='1266' height='896'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/label-multiline-hhqm7j?file=%2Fsrc%2Findex.ts%3A34%2C37</br>\r\n# 相关文档\r\n\r\n*  VChart 的官网：https://visactor.io/vchart/</br>\r\n*  formatMethod文档：https://visactor.io/vchart/option/pieChart#label.formatMethod</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '153- How to sort data by specified fields.md',
    content:
      "---\ntitle: 4. 如何对数据指定字段进行排序</br>\n---\r\n## 问题标题\r\n\r\n如何对数据指定字段进行排序</br>\r\n\r\n\r\n## 问题描述\r\n\r\n## 对于下面这个折线图，时间排序只能在外部排吗？\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QHuIbiPwUoDv09x2RCYc4e3Nneg.gif' alt='' width='1554' height='1098'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n数据配置的时候可以根据字段进行排序，字段类型分为离散类型和连续类型，需要根据字段类型配置排序以及排序顺序</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/VITRbqgDyox6ekxn8jQcjenWnMe.gif' alt='' width='2850' height='1328'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { date: '2023-01-01', type: 'Product A', value: 99.9 },\n      { date: '2023-01-02', type: 'Product C', value: 93.4 },\n      { date: '2023-01-01', type: 'Product B', value: 96.6 },\n      { date: '2023-01-02', type: 'Product A', value: 96.7 },\n      { date: '2023-01-02', type: 'Product B', value: 91.1 },\n      { date: '2023-01-03', type: 'Product A', value: 100.2 },\n      { date: '2023-01-03', type: 'Product B', value: 99.4 },\n      { date: '2023-01-03', type: 'Product C', value: 91.7 },\n      { date: '2023-01-04', type: 'Product A', value: 104.7 },\n      { date: '2023-01-05', type: 'Product B', value: 96 },\n      { date: '2023-01-05', type: 'Product C', value: 92.3 },\n      { date: '2023-01-06', type: 'Product A', value: 95.6 },\n      { date: '2023-01-06', type: 'Product B', value: 89.1 },\n      { date: '2023-01-09', type: 'Product B', value: 100.6},\n      { date: '2023-01-09', type: 'Product C', value: 103.8},\n      { date: '2023-01-04', type: 'Product C', value: 93.1 },\n      { date: '2023-01-04', type: 'Product B', value: 108.1 },\n      { date: '2023-01-07', type: 'Product A', value: 95.3 },\n      { date: '2023-01-07', type: 'Product B', value: 89.2 },\n      { date: '2023-01-07', type: 'Product C', value: 95.7 },\n      { date: '2023-01-08', type: 'Product A', value: 96.1 },\n      { date: '2023-01-08', type: 'Product B', value: 97.6 },\n      { date: '2023-01-09', type: 'Product A', value: 96.1 },\n      { date: '2023-01-10', type: 'Product A', value: 101.6 },\n      { date: '2023-01-10', type: 'Product B', value: 108.3 },\n      { date: '2023-01-10', type: 'Product C', value: 108.9 }\n    ],\n    fields: {\n      date: {\n        type: 'ordinal', // 数据维度 date 的类型是离散类型\n        sortIndex: 1 // 数据会按照 date 进行排序\n      },\n    }\n  },\n  xField: 'date',\n  yField: 'value',\n  seriesField: 'type',\n  point: {\n    visible: false\n  },\n  line: {\n    style: {\n      lineWidth: 2\n    }\n  },\n  legends: { visible: true },\n  axes: [\n    {\n      orient: 'bottom',\n      // paddingInner: 1,\n      // paddingOuter: 0,\n      trimPadding: true\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/FYI1byDssoXjUwxXKfxcsbDdn1f.gif' alt='' width='1450' height='1046'>\r\n\r\n\r\n\r\n## Related documents\r\n\r\n  Related configuration: https://www.visactor.io/vchart/option/barChart*#data(IDataType%7CIDataType%5B%5D).IDataValues.fields*</br>\r\n  GitHub: https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '154- Segmented display of bar progress chart.md',
    content:
      '---\ntitle: 24. 条形进度图分段展示</br>\n---\r\n## 问题标题\r\n\r\n如何将条形进度图分段展示</br>\r\n## 问题描述\r\n\r\n请问如何将条形进度图分段展示，如下图一样呢？</br>\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/C0l5bguDuo5eyVxZHvKcy6icnSh.gif\' alt=\'\' width=\'1052\' height=\'484\'>\r\n\r\n## 解决方案 \r\n\r\nVChart 中可以用扩展图元来显示这每一段中的分割线</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: "linearProgress",\n  data: [\n    {\n      id: "id0",\n      values: [\n        {\n          type: "Tradition Industries",\n          value: 0.85,\n          goal: 0.7,\n          text: "79.5%"\n        }\n      ]\n    }\n  ],\n  direction: "horizontal",\n  xField: "value",\n  yField: "type",\n  seriesField: "type",\n  height: 80,\n  cornerRadius: 20,\n  progress: {\n    style: {\n      cornerRadius: 0\n    }\n  },\n  bandWidth: 30,\n  axes: [\n    {\n      orient: "right",\n      type: "band",\n      domainLine: { visible: false },\n      tick: { visible: false },\n      label: {\n        formatMethod: (val) => "随便写点啥",\n        style: {\n          fontSize: 16\n        }\n      }\n    },\n    {\n      orient: "bottom",\n      type: "linear",\n      visible: true,\n      grid: {\n        visible: false\n      },\n      label: {\n        formatMethod: (val) => `${val * 100}%`,\n        flush: true\n      }\n    }\n  ],\n  extensionMark: [\n    {\n      type: "rule",\n      dataId: "id0",\n      visible: true,\n      style: {\n        x: (datum, ctx, elements, dataView) => {\n          return ctx.valueToX([1 / 3]);\n        },\n        y: (datum, ctx, elements, dataView) => {\n          return ctx.valueToY([datum.type]) - 15;\n        },\n        x1: (datum, ctx, elements, dataView) => {\n          return ctx.valueToX([1 / 3]);\n        },\n        y1: (datum, ctx, elements, dataView) => {\n          return ctx.valueToY([datum.type]) + 15;\n        },\n        stroke: "#fff",\n        lineWidth: 4,\n        zIndex: 1\n      }\n    },\n    {\n      type: "rule",\n      dataId: "id0",\n      visible: true,\n      style: {\n        x: (datum, ctx, elements, dataView) => {\n          return ctx.valueToX([2 / 3]);\n        },\n        y: (datum, ctx, elements, dataView) => {\n          return ctx.valueToY([datum.type]) - 15;\n        },\n        x1: (datum, ctx, elements, dataView) => {\n          return ctx.valueToX([2 / 3]);\n        },\n        y1: (datum, ctx, elements, dataView) => {\n          return ctx.valueToY([datum.type]) + 15;\n        },\n        stroke: "#fff",\n        lineWidth: 4,\n        zIndex: 1\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, disableTriggerEvent: true });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow[\'vchart\'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src=\'https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/VZU8bfgIOo2HLCxhzIEc6fEInRd.gif\' alt=\'\' width=\'1320\' height=\'198\'>\r\n\r\nDemo: https://codesandbox.io/p/sandbox/segment-linear-progress-3v4w5q?file=%2Fsrc%2Findex.ts%3A4%2C14-103%2C2</br>\r\n## 相关文档\r\n\r\nDemo：https://codesandbox.io/p/sandbox/segment-linear-progress-3v4w5q?file=%2Fsrc%2Findex.ts%3A4%2C14-103%2C2</br>\r\nAPI：</br>\r\n*  扩展mark：https://visactor.io/vchart/option/linearProgressChart#extensionMark</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n'
  },
  {
    fileName: '155- How to adjust the spacing between axis labels in vchart.md',
    content:
      "---\ntitle: 65. 如何在vchart中调整轴标签之间的间距？</br>\n---\r\n## 问题标题\r\n\r\n如何在vchart中调整轴标签之间的间距？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n我在使用vchart绘制柱状图时，发现轴标签之间的间距太小，导致标签重叠在一起，不易阅读。请问有什么方法可以调整轴标签之间的间距吗？可以配置 minGap 配置来设置这个标签间距吗？</br>\r\n\r\n\r\n## 解决方案\r\n\r\n配置项 minGap 用于轴标签采样计算中判断标签之间的最小间距。</br>\r\n现在轴标签的位置是和对应的柱子的位置映射相关联的，不能单独来配置标签的位置。如果想要调整轴标签之间的空间，可以通过调整轴对应的scale的paddingOuter属性来影响轴标签之间的间距。paddingOuter表示轴两端所占的空间，减小 paddingOuter 给标签留出更多的布局空间。</br>\r\n```\n  axes: [\n    { orient: 'bottom', paddingOuter: 0 }\n  ]</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales',\n  axes: [\n    { orient: 'bottom', paddingOuter: 0 }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/OBJAbOsw9o36dCxCp0PcC81dnQe.gif' alt='' width='1670' height='1046'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  Github: https://github.com/VisActor/VChart</br>\r\n*  Spec: https://visactor.bytedance.net/vchart/option/barChart-axes-band#paddingOuter(number%7Cnumber%5B%5D)</br>\r\n\r\n"
  },
  {
    fileName: '156- How to assign different colors to multiple lines in a line chart.md',
    content:
      "---\ntitle: 106.在折线图中如何给多条折线指定不同颜色</br>\n---\r\n## 问题标题\r\n\r\n在折线图中如何给多条折线指定不同颜色</br>\r\n\r\n\r\n## 问题描述\r\n\r\nhello，如何给多条折线指定不同的颜色？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/B2OdbZvVVozUcOxkxKkcv8rWner.gif' alt='' width='1162' height='730'>\r\n\r\n## 解决方案 \r\n\r\n1. 在 spec 里配置 color，可以参考下这个 demo [https://visactor.bytedance.net/vchart/demo/area-chart/stream-graph](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fdemo%2Farea-chart%2Fstream-graph)</br>\r\n1. 在图元样式里配置颜色，可以参考 [https://visactor.bytedance.net/vchart/demo/line-chart/multi-line](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fdemo%2Fline-chart%2Fmulti-line)</br>\r\n1. 通过主题设置色板，可以参考 demo [https://visactor.bytedance.net/vchart/demo/theme/theme-switch](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fdemo%2Ftheme%2Ftheme-switch)，文档：[https://visactor.bytedance.net/vchart/guide/tutorial_docs/Theme/Color_Theme](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fguide%2Ftutorial_docs%2FTheme%2FColor_Theme)</br>\r\n## 相关文档\r\n\r\n*  Demo：</br>\r\n*   [https://visactor.bytedance.net/vchart/demo/area-chart/stream-graph](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fdemo%2Farea-chart%2Fstream-graph)</br>\r\n*   [https://visactor.bytedance.net/vchart/demo/line-chart/multi-line](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fdemo%2Fline-chart%2Fmulti-line)</br>\r\n*  [https://visactor.bytedance.net/vchart/demo/theme/theme-switch](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fdemo%2Ftheme%2Ftheme-switch)</br>\r\n*  教程：[https://visactor.bytedance.net/vchart/guide/tutorial_docs/Theme/Color_Theme](https%3A%2F%2Fvisactor.bytedance.net%2Fvchart%2Fguide%2Ftutorial_docs%2FTheme%2FColor_Theme)</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '157- How to individually configure legend styles and change graphic shapes in VChart.md',
    content:
      "---\ntitle: 90. VChart 中如何单独配置图例的样式，改变图形的形状</br>\n---\r\n## 问题标题\r\n\r\nVChart 中如何单独配置图例的样式，改变图形的形状</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如何将柱图一个系列的图例项图形改成圆</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/RmSNb231KobeWxxb3o0cw1hAnte.gif' alt='' width='1488' height='1032'>\r\n\r\n## 解决方案\r\n\r\nVChart 中图例可以通过data配置项自定义，其中图形属性在图例项的 `shape` 属性中</br>\r\n```\n legends: {\n    visible: true,\n    data: items => {\n      return items.map(item => {\n        if(item.label === 'Under 5 Years'){\n          item.shape.symbolType = 'circle';\n        }\n        return item;\n      });\n    },\n  },</br>\n```\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true,\n    data: items => {\n      return items.map(item => {\n        if(item.label === 'Under 5 Years'){\n          item.shape.symbolType = 'circle';\n        }\n        return item;\n      });\n    },\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QCF7boZIgoWzhcxqGJqczNPknnc.gif' alt='' width='1474' height='1038'>\r\n\r\n## 相关文档\r\n\r\n*  配置文档：https://www.visactor.io/vchart/option/barChart-legends-discrete#data</br>\r\n*  相关 demo：https://www.visactor.io/vchart/demo/legend/custom-data</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '158- How to configure the hover state of graphical elements.md',
    content:
      "---\ntitle: 85. 如何配置图元hover状态？</br>\n---\r\n## 问题标题\r\n\r\n如何配置图元hover状态？</br>\r\n## 问题描述\r\n\r\n如何启用图元的hover高亮效果？</br>\r\n\r\n\r\n## 解决方案 \r\n\r\n以柱状图为例，可以通过`bar.state.hover`配置hover后的高亮效果。</br>\r\n不同的图表需要配置在不同的图元上，同理，折线图则通过`line.state.hover`配置。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/XZzmbzVKtoTxyAxy2LecbYNHnNh.gif' alt='' width='3244' height='1052'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales',\n  bar: {\n    state: {\n      hover: {\n        fill: 'red'\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/hover-state-z5djy8?file=%2Fsrc%2Findex.ts%3A12%2C42</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/BhLPbzzuKoJJOCxdeOncbzshnMe.gif' alt='' width='1548' height='984'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n相关api：https://www.visactor.io/vchart/option/barChart#bar.state</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '159-How to configure Tooltip to automatically wrap text.md',
    content:
      "# 如何配置 Tooltip (文字提示) 自动换行？\n\n# 问题描述\n\n类似 （https://visactor.io/vchart/demo/line-chart/null-value-line）这样的图表，tooltip的内容太长了，希望有换行效果\n![demo](/vchart/faq/95-0.png)\n想要实现根据图表宽高和标签长度自动换行，该如何实现？\n\n# 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中只需要配置最大宽度和多行支持即可。\n\n```ts\ntooltip: {\n  style: {\n    keyLabel: {\n      maxWidth: 100,\n      multiLine: true\n    },\n    titleLabel: {\n      maxWidth: 20\n    }\n  }\n}\n```\n\n# 代码示例\n\n```ts\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: '这是一段很长的标题这是一段很长的标题这是一段很长的标题', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: '100% stacked line chart of cosmetic products sales'\n  },\n  percent: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ],\n  tooltip: {\n    style: {\n      keyLabel: {\n        maxWidth: 100,\n        multiLine: true\n      },\n      titleLabel: {\n        maxWidth: 20\n      }\n    }\n  }\n};\n```\n\n# 结果展示\n\n在线效果参考：https://codesandbox.io/s/tooltip-multiline-j9ngvp\n![result](/vchart/faq/95-1.png)\n\n# 相关文档\n\nTooltip 教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip\n相关 api：https://visactor.io/vchart/option/barChart#tooltip.visible\ngithub：https://github.com/VisActor/VChart\n"
  },
  {
    fileName: '160-How to disable the default interactive behavior of legends.md',
    content:
      "# 如何禁用图例的默认交互行为？\n\n## 问题描述\n\n移动端展示图表时，为了方便用户阅读，会将图表的图例扩大。但几乎每个图表库的图例组件都会默认给图例设置默认的交互行为，例如在点击时过滤数据。\n\n在手指滑动时容易误触图例的默认交互，如何将图表的图例交互取消掉？\n\n## 解决方案\n\nVChart 中为可交互的图元或组件提供了 interactive 配置用来控制启用或禁用交互功能，例如图例、图表标注、各种类型的图元等。\n这个配置虽然默认开启的，但用户可以自己控制图表的交互行为。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { type: 'Autocracies', year: '1960', value: 126 },\n        { type: 'Autocracies', year: '1970', value: 117 },\n        { type: 'Autocracies', year: '1980', value: 114 },\n        { type: 'Autocracies', year: '1990', value: 111 },\n        { type: 'Autocracies', year: '2000', value: 89 },\n        { type: 'Autocracies', year: '2010', value: 80 },\n        { type: 'Autocracies', year: '2018', value: 80 },\n        { type: 'Democracies', year: '1960', value: 29 },\n        { type: 'Democracies', year: '1970', value: 38 },\n        { type: 'Democracies', year: '1980', value: 41 },\n        { type: 'Democracies', year: '1990', value: 57 },\n        { type: 'Democracies', year: '2000', value: 87 },\n        { type: 'Democracies', year: '2010', value: 98 },\n        { type: 'Democracies', year: '2018', value: 99 }\n      ]\n    }\n  ],\n  xField: ['year', 'type'],\n  yField: 'value',\n  seriesField: 'type',\n  legends: {\n    visible: true,\n    orient: 'bottom',\n    position: 'middle',\n    interactive: false\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [VChart 图例 教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend)\n- [VChart 图例 配置](https://visactor.io/vchart/option/barChart-legends-discrete#interactive)\n"
  },
  {
    fileName: '161-How to customize the axis label display spacing.md',
    content:
      "# 如何自定义轴 label 显示间距？\n\n## 问题描述\n\n类似 （https://visactor.io/vchart/demo/line-chart/basic-line）这样的折线图，\n想要实现自定义轴 label 的显示间距，该如何实现？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，在 VChart 中只需要配置 axes 中对应轴的 label 相关配置:\n\n- 通过 minGap 可以自定义标签之间的最小间距（单位为像素）。仅当轴采样开始时生效（sampling: true）。 该配置会影响轴采样的结果。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        time: '2:00',\n        value: 8\n      },\n      {\n        time: '4:00',\n        value: 9\n      },\n      {\n        time: '6:00',\n        value: 11\n      },\n      {\n        time: '8:00',\n        value: 14\n      },\n      {\n        time: '10:00',\n        value: 16\n      },\n      {\n        time: '12:00',\n        value: 17\n      },\n      {\n        time: '14:00',\n        value: 17\n      },\n      {\n        time: '16:00',\n        value: 16\n      },\n      {\n        time: '18:00',\n        value: 15\n      }\n    ]\n  },\n  xField: 'time',\n  yField: 'value',\n  axes: [\n    {\n      orient: 'bottom',\n      label: {\n        minGap: 80\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/customize-axis-label-spacing-9ml6nv)\n\n## 相关文档\n\n- [基础折线图 demo](https://www.visactor.io/vchart/demo/line-chart/basic-line)\n- [折线图教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Line)\n- [相关 api](https://www.visactor.io/vchart/option/lineChart#axes-band.label.minGap)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName:
      '162-How to define the mapping relationship of the axes for the combination of line chart and stacked column chart.md',
    content:
      "# 线图和堆积柱状图组合，如何定义轴的映射关系？\n\n## 问题描述\n\n在一个柱线组合图中，有 2 条线，我希望下面的线与柱子都是对应左轴，顶部的线对应右轴。在 vchart 里应该如何配置呢？\n\n## 解决方案\n\n在 VChart 中轴和系列可以灵活的配置对应关系，在轴上有配置 seriesId 可以配置为一个系列 id 的数组或者单个系列 id\n\n1. 将线的数据分成 2 份，如果已经是 2 份可以不处理，假设他们的 id 分别是 line0 和 line1 , 同时柱子的 id 是 bar0\n2. 将左轴的 seriesId 设置为 ['line0','bar0']，将右轴的 seriesId 设置为['line1']。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'data0',\n      values: [\n        { x: '周一', type: '早餐', y: 15 },\n        { x: '周一', type: '午餐', y: 25 },\n        { x: '周二', type: '早餐', y: 12 },\n        { x: '周二', type: '午餐', y: 30 },\n        { x: '周三', type: '早餐', y: 15 },\n        { x: '周三', type: '午餐', y: 24 },\n        { x: '周四', type: '早餐', y: 10 },\n        { x: '周四', type: '午餐', y: 25 },\n        { x: '周五', type: '早餐', y: 13 },\n        { x: '周五', type: '午餐', y: 20 },\n        { x: '周六', type: '早餐', y: 10 },\n        { x: '周六', type: '午餐', y: 22 },\n        { x: '周日', type: '早餐', y: 12 },\n        { x: '周日', type: '午餐', y: 19 }\n      ]\n    },\n    {\n      id: 'data1',\n      values: [\n        { x: '周一', type: '酒水', y: 22 },\n        { x: '周二', type: '酒水', y: 23 },\n        { x: '周三', type: '酒水', y: 13 },\n        { x: '周四', type: '酒水', y: 12 },\n        { x: '周五', type: '酒水', y: 10 },\n        { x: '周六', type: '酒水', y: 20 },\n        { x: '周日', type: '酒水', y: 10 }\n      ]\n    },\n    {\n      id: 'data2',\n      values: [\n        { x: '周一', type: '饮料', y: 132 },\n        { x: '周二', type: '饮料', y: 143 },\n        { x: '周三', type: '饮料', y: 143 },\n        { x: '周四', type: '饮料', y: 132 },\n        { x: '周五', type: '饮料', y: 130 },\n        { x: '周六', type: '饮料', y: 130 },\n        { x: '周日', type: '饮料', y: 150 }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: ['x', 'type'],\n      yField: 'y'\n    },\n    {\n      type: 'line',\n      id: 'line0',\n      dataId: 'data1',\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    },\n    {\n      type: 'line',\n      id: 'line1',\n      dataId: 'data2',\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesId: ['line0', 'bar'] },\n    { orient: 'right', seriesId: 'line1' },\n    ,\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [轴配置](<https://www.visactor.io/vchart/option/barChart-axes-linear#seriesId(string%7Cnumber%7C(string%20%7C%20number)%5B%5D)>)\n"
  },
  {
    fileName: '163- How to limit the number of lines in a Tooltip.md',
    content:
      "---\ntitle: 53. 如何限制Tooltip的行数？</br>\n---\r\n# 问题标题\r\n\r\n如何限制Tooltip的行数？</br>\r\n\r\n\r\n## 问题描述\r\n\r\nTooltip中数据条数非常多的时候，超过20条后会自动归纳为其他，这个数量支持自定义吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/GKz8bdBkPojUa2xfPuBchH22nsh.gif' alt='' width='846' height='778'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\ntooltip支持通过 `maxLineCount`设置最大行数，需要注意的是，vchart的tooltip支持多种类型，现在需要分别设置；</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/T77GbT9YGo6gSKxMMHUcgcGxnRb.gif' alt='' width='3318' height='1212'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: '100% stacked line chart of cosmetic products sales'\n  },\n  percent: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod(val) {\n          return `${(val * 100).toFixed(2)}%`;\n        }\n      }\n    }\n  ],\n  tooltip: {\n    mark: {\n      maxLineCount: 2\n    },\n    dimension: {\n      maxLineCount: 2\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/AiV0b1G0WoV43Kx81g6ciVEenIh.gif' alt='' width='1686' height='1056'>\r\n\r\n## 相关文档\r\n\r\n*  [Tooltip提示信息教程](https%3A%2F%2Fvisactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FTooltip)</br>\r\n*  [Tooltip配置文档](https%3A%2F%2Fvisactor.com%2Fvchart%2Foption%2FbarChart%23tooltip.dimension.maxLineCount)</br>\r\n*  [VChart github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>\r\n\r\n"
  },
  {
    fileName: '164-How to use vchart to display charts in Notebook.md',
    content:
      '# 如何在 notebook 中使用 @visactor/vchart 显示图表？\n\n# 问题描述\n\n希望能在 notebook 中使用 VChart\n\n# 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，VChart 提供了基于 Python 的方案，安装即可\n\n```bash\npip3 install py-vchart==1.0.0\n```\n\n# 代码示例\n\n```py\nfrom pyvchart import render_chart\n# spec\'s definition referenced in the JSON of https://www.visactor.io/vchart/guide/getting-started\nspec = {\n  "type": \'bar\',\n  "data": [\n    {\n      "id": \'barData\',\n      "values": [\n        { "month": \'Monday\', "sales": 22 },\n        { "month": \'Tuesday\', "sales": 13 },\n        { "month": \'Wednesday\', "sales": 25 },\n        { "month": \'Thursday\', "sales": 29 },\n        { "month": \'Friday\', "sales": 38 }\n      ]\n    }\n  ],\n  "xField": \'month\',\n  "yField": \'sales\',\n  "crosshair": {\n    "xField": { "visible": True }\n  }\n};\n\nrender_chart(spec)\n```\n\n# 结果展示\n\n![result](/vchart/faq/99-0.png)\n\n# 相关文档\n\nPython 教程：https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/python\ngithub：https://github.com/VisActor/VChart\n'
  },
  {
    fileName: '165-How to configure the default selection effect of the legend component.md',
    content:
      "# 图例组件如何配置默认选中效果？\n\n## 问题描述\n\n在 vchart 中，图例个数比较多的时候，可以配置默认选中固定个数图例吗？其他图例置灰\n\n## 解决方案\n\nVChart 的 图例组件提供了默认选择项的配置，可以在其中配置想要默认选中的项，其他项会自动置灰\n\n```ts\nlegends: [\n  {\n    type: 'discrete',\n    defaultSelected: ['5 to 13 Years', '14 to 17 Years', '18 to 24 Years', '25 to 44 Years']\n  }\n];\n```\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'AL',\n          age: 'Under 5 Years',\n          population: 310504,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '5 to 13 Years',\n          population: 552339,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '14 to 17 Years',\n          population: 259034,\n          type: 'a'\n        },\n        {\n          State: 'AL',\n          age: '18 to 24 Years',\n          population: 450818,\n          type: 'b'\n        },\n        {\n          State: 'AL',\n          age: '25 to 44 Years',\n          population: 1231572,\n          type: 'c'\n        },\n        {\n          State: 'AL',\n          age: '45 to 64 Years',\n          population: 1215966,\n          type: 'd'\n        },\n        {\n          State: 'AL',\n          age: '65 Years and Over',\n          population: 641667,\n          type: 'd'\n        },\n        {\n          State: 'AK',\n          age: 'Under 5 Years',\n          population: 52083,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '5 to 13 Years',\n          population: 85640,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '14 to 17 Years',\n          population: 42153,\n          type: 'a'\n        },\n        {\n          State: 'AK',\n          age: '18 to 24 Years',\n          population: 74257,\n          type: 'b'\n        },\n        {\n          State: 'AK',\n          age: '25 to 44 Years',\n          population: 198724,\n          type: 'c'\n        },\n        {\n          State: 'AK',\n          age: '45 to 64 Years',\n          population: 183159,\n          type: 'd'\n        },\n        {\n          State: 'AK',\n          age: '65 Years and Over',\n          population: 50277,\n          type: 'd'\n        },\n        {\n          State: 'AZ',\n          age: 'Under 5 Years',\n          population: 515910,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '5 to 13 Years',\n          population: 828669,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '14 to 17 Years',\n          population: 362642,\n          type: 'a'\n        },\n        {\n          State: 'AZ',\n          age: '18 to 24 Years',\n          population: 601943,\n          type: 'b'\n        },\n        {\n          State: 'AZ',\n          age: '25 to 44 Years',\n          population: 1804762,\n          type: 'c'\n        },\n        {\n          State: 'AZ',\n          age: '45 to 64 Years',\n          population: 1523681,\n          type: 'd'\n        },\n        {\n          State: 'AZ',\n          age: '65 Years and Over',\n          population: 862573,\n          type: 'd'\n        },\n        {\n          State: 'AR',\n          age: 'Under 5 Years',\n          population: 202070,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '5 to 13 Years',\n          population: 343207,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '14 to 17 Years',\n          population: 157204,\n          type: 'a'\n        },\n        {\n          State: 'AR',\n          age: '18 to 24 Years',\n          population: 264160,\n          type: 'b'\n        },\n        {\n          State: 'AR',\n          age: '25 to 44 Years',\n          population: 754420,\n          type: 'c'\n        },\n        {\n          State: 'AR',\n          age: '45 to 64 Years',\n          population: 727124,\n          type: 'd'\n        },\n        {\n          State: 'AR',\n          age: '65 Years and Over',\n          population: 407205,\n          type: 'd'\n        },\n        {\n          State: 'CA',\n          age: 'Under 5 Years',\n          population: 2704659,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '5 to 13 Years',\n          population: 4499890,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '14 to 17 Years',\n          population: 2159981,\n          type: 'a'\n        },\n        {\n          State: 'CA',\n          age: '18 to 24 Years',\n          population: 3853788,\n          type: 'b'\n        },\n        {\n          State: 'CA',\n          age: '25 to 44 Years',\n          population: 10604510,\n          type: 'c'\n        },\n        {\n          State: 'CA',\n          age: '45 to 64 Years',\n          population: 8819342,\n          type: 'd'\n        },\n        {\n          State: 'CA',\n          age: '65 Years and Over',\n          population: 4114496,\n          type: 'd'\n        },\n        {\n          State: 'CO',\n          age: 'Under 5 Years',\n          population: 358280,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '5 to 13 Years',\n          population: 587154,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '14 to 17 Years',\n          population: 261701,\n          type: 'a'\n        },\n        {\n          State: 'CO',\n          age: '18 to 24 Years',\n          population: 466194,\n          type: 'b'\n        },\n        {\n          State: 'CO',\n          age: '25 to 44 Years',\n          population: 1464939,\n          type: 'c'\n        },\n        {\n          State: 'CO',\n          age: '45 to 64 Years',\n          population: 1290094,\n          type: 'd'\n        },\n        {\n          State: 'CO',\n          age: '65 Years and Over',\n          population: 511094,\n          type: 'd'\n        },\n        {\n          State: 'CT',\n          age: 'Under 5 Years',\n          population: 211637,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '5 to 13 Years',\n          population: 403658,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '14 to 17 Years',\n          population: 196918,\n          type: 'a'\n        },\n        {\n          State: 'CT',\n          age: '18 to 24 Years',\n          population: 325110,\n          type: 'b'\n        },\n        {\n          State: 'CT',\n          age: '25 to 44 Years',\n          population: 916955,\n          type: 'c'\n        },\n        {\n          State: 'CT',\n          age: '45 to 64 Years',\n          population: 968967,\n          type: 'd'\n        },\n        {\n          State: 'CT',\n          age: '65 Years and Over',\n          population: 478007,\n          type: 'd'\n        }\n      ]\n    }\n  ],\n  xField: ['State', 'type'],\n  yField: 'population',\n  seriesField: 'age',\n  stack: true,\n  legends: {\n    visible: true,\n    reversed: true,\n    defaultSelected: ['5 to 13 Years', '14 to 17 Years', '18 to 24 Years', '25 to 44 Years']\n  },\n\n  color: ['#98abc5', '#8a89a6', '#7b6888', '#6b486b', '#a05d56', '#d0743c', '#ff8c00'],\n  axes: [\n    {\n      orient: 'left',\n      label: {\n        formatMethod: val => {\n          return val / 1000000 + 'M';\n        }\n      }\n    }\n  ]\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [图例配置](https://www.visactor.io/vchart/option/barChart#legends-discrete.defaultSelected)\n"
  },
  {
    fileName: "166- Does VChart's multi-group bar chart support multi-layer axis labels.md",
    content:
      "---\ntitle: 54. VChart的多分组柱状图是否支持多层轴标签？</br>\n---\r\n# 问题标题\r\n\r\nVChart的多分组柱状图是否支持多层轴标签？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我是使用VChart图表库的一位开发者。最近我碰到了一个问题，我想在多分组柱状图中使用多层轴标签，像下图这种效果：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/EBf6bXoNvoqiXgxhenAcqDkhnbf.gif' alt='' width='3048' height='1828'>\r\n\r\n\r\n\r\n# 解决方案\r\n\r\n当spec中的xField有多个字段时，会开启柱状图分组。你可以通过设置axes中x轴的showAllGroupLayers为true开启展示所有的分组轴。</br>\r\n你可以参考下面的示例：</br>\r\n```\nconst spec = {\n    type: 'bar',\n    data: [\n        {\n            values: [\n                { type: 'Category One', min: 76, max: 100, range: 'A', type2: 'p', color: 'A_p' },\n                //... 其他数据项\n            ]\n        }\n    ],\n    xField: ['type', 'range', 'type2'],\n    yField: 'in',\n    seriesField: 'color',\n    paddingInner: [0.6, 0.6, 0.6],\n    bandPadding: [0.6, 0.6, 0.6],\n    label: { position: 'bothEnd' },\n    axes: [\n        { orient: 'bottom', showAllGroupLayers: true, sampling: false, tick: { tickCount: 2 } }\n    ],\n    legends: { visible: true }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderAsync();\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n# 结果展示\r\n\r\n柱状图将按照xField分组，同时展示每个分组的标签：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WOsLbvkCDo17MWxTi6ccAvkPnwc.gif' alt='' width='3270' height='1336'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/line-chart-single-selected-forked-hpvd3j</br>\r\n\r\n\r\n# 相关文档\r\n\r\n*  VChart **showAllGroupLayers**配置项：https://www.visactor.io/vchart/option/barChart-axes-band#showAllGroupLayers</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>"
  },
  {
    fileName: '167-How to combine percentage bar and TGI chart.md',
    content:
      "# 如何实现百分比条形和 tgi 图的组合？\n\n## 问题描述\n\n我想使用前端图表库实现百分比条形图和 tgi 图的组合。tgi 图使用垂直方向的柱子来表示 tgi 数值，并用折线将不同的柱子链接。两个图表使用不同的坐标轴，请问该如何实现呢？\n\n## 解决方案\n\n你可以使用@VisActor/VChart 实现想要的效果。VChart 允许多个 series 组合在一张图表中，仅需要将图表类型设为 common，并在 series 中添加柱状图和折线图的 series，修改折线图的线样式为虚线，点样式为矩形，即可实现图中效果。为了实现柱图与线图使用不同的坐标轴，在 axes 中，需要配置 3 个坐标轴：左侧的 band 轴，底部线图的 linear 轴，除此之外还需要给柱图配置一个 linear 轴。你可以将该轴放置在顶部并将 visible 设为 false，并通过调整 max 属性，指定轴的范围。\n\n## 代码示例\n\n图表 spec 如下：\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  data: [\n    {\n      id: 'data',\n      values: [\n        { x: '2015-09-24', y: 0.6 },\n        { x: '2015-09-25', y: 0.7 },\n        { x: '2015-09-26', y: 0.71 },\n        { x: '2015-09-27', y: 0.65 },\n        { x: '2015-09-28', y: 0.53 },\n        { x: '2015-09-29', y: 0.55 }\n      ]\n    },\n    {\n      id: 'data2',\n      values: [\n        { x: '2015-09-24', y: 40 },\n        { x: '2015-09-25', y: 25 },\n        { x: '2015-09-26', y: 31 },\n        { x: '2015-09-27', y: 37 },\n        { x: '2015-09-28', y: 28 },\n        { x: '2015-09-29', y: 22 }\n      ]\n    }\n  ],\n\n  series: [\n    {\n      type: 'bar',\n      id: 'barSeries',\n      direction: 'horizontal',\n      dataId: 'data',\n      yField: 'x',\n      xField: 'y'\n    },\n    {\n      type: 'line',\n      id: 'lineSeries',\n      direction: 'horizontal',\n      dataId: 'data2',\n      yField: 'x',\n      xField: 'y',\n      line: {\n        style: {\n          lineDash: [2, 5]\n        }\n      },\n\n      point: {\n        style: {\n          symbolType: 'rect',\n          size: 10,\n          scaleX: 1,\n          scaleY: 10\n        }\n      }\n    }\n  ],\n  axes: [\n    {\n      orient: 'left',\n      seriesId: ['barSeries', 'lineSeries'],\n      type: 'band',\n      grid: {\n        visible: true\n      }\n    },\n    {\n      orient: 'top',\n      type: 'linear',\n      max: 1.2,\n      seriesId: ['barSeries'],\n      grid: {\n        visible: true\n      },\n      visible: false\n    },\n    {\n      orient: 'bottom',\n      type: 'linear',\n      seriesId: ['lineSeries'],\n\n      grid: {\n        visible: true\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/bar-chart-and-tgi-chart-8fkprk?file=/src/index.ts)\n\n## 相关文档\n\n- [VChart 组合图教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination)\n- [组合图配置项](https://visactor.io/vchart/option/commonChart#type)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName:
      '168-How do I set up some lines to follow the left axis, while the others follow the right axis in a line chart.md',
    content:
      "# 折线图有多条线，如何设置右侧坐标轴，并且某条线是根据右侧坐标轴绘制的?\n\n## 问题描述\n\n我有一张折线图。如何明确指定线段跟随左轴或右轴？\n这是一个复杂的场景， 因为要让折线图中一些线条遵循左轴， 其他的遵循右轴， 同时，所有线条又都跟随底轴。\n更抽象一些， 就意味着每一轴可以对应多个折线。\n\n## 解决方案\n\nVChart 图表已经提供了对应的功能。VChart 支持：\n\n- 在 series 上配置 dataId 维护 data 与 series 的一对一关系。\n- 在 axis 上配置 seriesId 维护 axis 与 series 的一对多关系。\n\n[折线图系列配置文档](https://visactor.io/vchart/option/commonChart#series-line.type)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'common',\n  data: [\n    {\n      id: 'profit',\n      values: [\n        { time: '2019', value: 100000 },\n        { time: '2020', value: 200000 },\n        { time: '2021', value: 300000 },\n        { time: '2022', value: 400000 },\n        { time: '2023', value: 500000 }\n      ]\n    },\n    {\n      id: 'saleDiscount',\n      values: [\n        { time: '2019', value: 0.2 },\n        { time: '2020', value: 0.35 },\n        { time: '2021', value: 0.25 },\n        { time: '2022', value: 0.2 },\n        { time: '2023', value: 0.1 }\n      ]\n    }\n  ],\n  axes: [\n    {\n      orient: 'left',\n      seriesId: ['profit'],\n      id: 'left'\n    },\n    {\n      sync: {\n        axisId: 'left',\n        tickAlign: true,\n        zeroAlign: true\n      },\n      id: 'right',\n      label: {\n        formatMethod: v => parseFloat(v).toFixed(2)\n      },\n      orient: 'right',\n      seriesId: ['saleDiscount']\n    },\n    {\n      orient: 'bottom',\n      seriesId: ['saleDiscount', 'profit']\n    }\n  ],\n  series: [\n    {\n      id: 'profit',\n      type: 'line',\n      xField: 'time',\n      yField: 'value',\n      dataId: 'profit'\n    },\n    {\n      id: 'saleDiscount',\n      type: 'line',\n      xField: 'time',\n      yField: 'value',\n      dataId: 'saleDiscount'\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [坐标轴 教程](http://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes)\n- [组合图教程](http://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination)\n- [折线图配置文档 ](https://visactor.io/vchart/option/commonChart#series-line.type)\n- [双轴图示例 Demo](http://visactor.io/vchart/demo/combination/dual-axis)\n"
  },
  {
    fileName: '169-How to set the order of the chart tooltip display content.md',
    content:
      "# 如何设置图表 Tooltip 显示内容的顺序？\n\n## 问题描述\n\n我正在使用 VChart，如下图所示，我应该如何给 dimension tooltip 中显示的数据项设置顺序？比如设置为 key 值的降序。\n\n![tooltip](/vchart/faq/73-0.png)\n\n## 解决方案\n\nVChart 的 tooltip 提供 `updateContent` 回调支持对显示内容做任意修改，可以在 tooltip spec 中进行配置。在`updateContent` 回调中，显示内容以数组形式作为参数提供，你只需要进行修改后再返回新数组即可。这其中完全可以包括排序。可参考以下示例：\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  tooltip: {\n    dimension: {\n      updateContent: prev => {\n        prev.sort((a, b) => a.value - b.value); // sort values in ascending order\n        return prev;\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/73-1.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nDemo page: [https://www.visactor.io/vchart/demo/bar-chart/stack-column](https://www.visactor.io/vchart/demo/bar-chart/stack-column)\n"
  },
  {
    fileName: '170- How to set different colors for each bar in a bar chart.md',
    content:
      '---\ntitle: 50. 如何为柱状图每根柱子设置不同颜色？</br>\n---\r\n## 问题标题\r\n\r\n如何为柱状图每根柱子设置不同颜色</br>\r\n## 问题描述\r\n\r\n柱状图需要给每个柱子设置不一样的颜色</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，这本质上是将不同的数据映射到图形的颜色， VChart 提供 seriesField 配置，用户可以指定划分系列的分组字段， 从而对图形进行分组， 分组后的图形， 同组的内容会使用相同的颜色绘制， 不同组的内容， 会使用不同的颜色绘制。 </br>\r\n步骤一： 用户需要在数据准备好需要分组的信息， 通常是给每一项数据增加一个特定的属性</br>\r\n步骤二： 设置`seriesField`</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "bar",\n      data: [\n        {\n          id: "barData",\n          values: [\n            { month: "Monday", sales: 22, index: 0 },\n            { month: "Tuesday", sales: 13, index: 1 },\n            { month: "Wednesday", sales: 25, index: 2 },\n            { month: "Thursday", sales: 29, index: 3 },\n            { month: "Friday", sales: 38, index: 4 },\n          ],\n        },\n      ],\n      seriesField: "index",\n      xField: "month",\n      yField: "sales",\n    };\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart"></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-bar-seriesfield-rqxv2d?file=%2Fsrc%2Findex.js%3A1%2C1-45%2C1</br>\r\n## 相关文档\r\n\r\nSeriesField API: https://visactor.io/vchart/option/barChart#seriesField</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '171- How to achieve multi-group bar charts and highlight interactions based on grouping dimensions.md',
    content:
      "---\ntitle: 1. 如何实现多分组柱状图以及按照分组维度高亮的交互？</br>\n---\r\n## 问题标题\r\n\r\n如何实现多分组柱状图以及按照分组维度高亮的交互？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n类似下图的多分组柱状图如何实现：</br>\r\n1. 期望两个分组通过颜色透明度进行样式上的区分；</br>\r\n1. 当鼠标悬浮在一个柱子区块时，联动高亮相同颜色的所有区块；</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/VDtbb37JAozAYixVQJmcytrqnwb.gif' alt='' width='1030' height='510'>\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/DIoAbGpFQo4L7yxrytccIikCnvh.gif' alt='' width='153' height='353'>\r\n\r\n## 解决方案 \r\n\r\n1. 需要 4 个数据字段：</br>\r\n1. 3 个分组字段：x 轴上有 3 层分组，分别对应字段 `xField: ['type', 'type1', 'type2']`；</br>\r\n1. 1 个系列字段：用于区分颜色系列，` seriesField: 'color'`</br>\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/WT1SbzkDcowKRkxqg22cBCr2n0d.gif' alt='' width='1562' height='778'>\r\n\r\n1. 高亮交互：可以配置 VChart 内置 `element-highlight-by-group`交互，指定交互高亮状态名为 `'highligh'`，从而在图元样式中，为柱子添加描边效果：</br>\r\n```\n  interactions:[\n    {\n       type: 'element-highlight-by-group',\n       highlightState:'highlight'\n    }\n  ],\n  bar:{\n    state:{\n      highlight:{\n        stroke:\"black\",\n        lineWidth:1,\n        zIndex:100\n      }\n    }\n  },</br>\n```\r\n\r\n\r\n## 代码示例  \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/IEGibzWSroj7P5xjA58cFUG1nkY.gif' alt='' width='812' height='410'>\r\n\r\n```\nconst spec = {\n  type: 'bar',\n  height:400,\n  data: [\n    {\n      values: [\n        { type: 'Category One', min: 80,  color: 'A', type1: 'p', type2: 'T' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p', type2: 'T' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p', type2: 'T' },\n        { type: 'Category One', min: 75,  color: 'C', type1: 'p', type2: 'T' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p', type2: 'T' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p', type2: 'T1' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p', type2: 'T1' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p', type2: 'T1' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p', type2: 'T1' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p', type2: 'T1' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p', type2: 'T2' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p', type2: 'T2' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p', type2: 'T2' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p', type2: 'T2' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p', type2: 'T2' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p', type2: 'T3' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p', type2: 'T3' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p', type2: 'T3' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p', type2: 'T3' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p', type2: 'T3' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p', type2: 'T4' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p', type2: 'T4' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p', type2: 'T4' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p', type2: 'T4' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p', type2: 'T4' },\n        \n        { type: 'Category One', min: 80,  color: 'A', type1: 'p1', type2: 'T' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p1', type2: 'T' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p1', type2: 'T' },\n        { type: 'Category One', min: 75,  color: 'C', type1: 'p1', type2: 'T' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p1', type2: 'T' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p1', type2: 'T1' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p1', type2: 'T1' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p1', type2: 'T1' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p1', type2: 'T1' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p1', type2: 'T1' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p1', type2: 'T2' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p1', type2: 'T2' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p1', type2: 'T2' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p1', type2: 'T2' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p1', type2: 'T2' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p1', type2: 'T3' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p1', type2: 'T3' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p1', type2: 'T3' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p1', type2: 'T3' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p1', type2: 'T3' },\n\n        { type: 'Category One', min: 70,  color: 'A', type1: 'p1', type2: 'T4' },\n        { type: 'Category One', min: 40,  color: 'B', type1: 'p1', type2: 'T4' },\n        { type: 'Category One', min: 40,  color: 'D', type1: 'p1', type2: 'T4' },\n        { type: 'Category One', min: 50,  color: 'C', type1: 'p1', type2: 'T4' },\n        { type: 'Category One', min: 30,  color: 'E', type1: 'p1', type2: 'T4' },\n\n        \n\n        { type: 'Category Two', min: 76,  color: 'A', type1: 'p', type2: 'T' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p', type2: 'T' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p', type2: 'T' },\n        { type: 'Category Two', min: 65,  color: 'C', type1: 'p', type2: 'T' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p', type2: 'T' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p', type2: 'T1' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p', type2: 'T1' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p', type2: 'T1' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p', type2: 'T1' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p', type2: 'T1' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p', type2: 'T2' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p', type2: 'T2' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p', type2: 'T2' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p', type2: 'T2' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p', type2: 'T2' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p', type2: 'T3' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p', type2: 'T3' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p', type2: 'T3' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p', type2: 'T3' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p', type2: 'T3' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p', type2: 'T4' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p', type2: 'T4' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p', type2: 'T4' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p', type2: 'T4' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p', type2: 'T4' },\n        \n        { type: 'Category Two', min: 80,  color: 'A', type1: 'p1', type2: 'T' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p1', type2: 'T' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p1', type2: 'T' },\n        { type: 'Category Two', min: 75,  color: 'C', type1: 'p1', type2: 'T' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p1', type2: 'T' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p1', type2: 'T1' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p1', type2: 'T1' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p1', type2: 'T1' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p1', type2: 'T1' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p1', type2: 'T1' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p1', type2: 'T2' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p1', type2: 'T2' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p1', type2: 'T2' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p1', type2: 'T2' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p1', type2: 'T2' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p1', type2: 'T3' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p1', type2: 'T3' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p1', type2: 'T3' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p1', type2: 'T3' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p1', type2: 'T3' },\n\n        { type: 'Category Two', min: 70,  color: 'A', type1: 'p1', type2: 'T4' },\n        { type: 'Category Two', min: 40,  color: 'B', type1: 'p1', type2: 'T4' },\n        { type: 'Category Two', min: 40,  color: 'D', type1: 'p1', type2: 'T4' },\n        { type: 'Category Two', min: 50,  color: 'C', type1: 'p1', type2: 'T4' },\n        { type: 'Category Two', min: 30,  color: 'E', type1: 'p1', type2: 'T4' },\n      ]\n    }\n  ],\n  interactions:[\n    {\n       type: 'element-highlight-by-group',\n       highlightState:'highlight'\n    }\n  ],\n  bar:{\n    style:{\n      fillOpacity:(data) => data.type1 === 'p' ? 1: 0.5\n    },\n    state:{\n      highlight:{\n        stroke:\"black\",\n        lineWidth:1,\n        zIndex:100\n      }\n    }\n  },\n  xField: ['type', 'type1', 'type2'],\n  yField: 'min',\n  seriesField: 'color',\n  axes: [\n    {\n      orient:\"left\",\n      label:{ visible: false},\n      grid:{ style:{ lineDash:[4,4], stroke:'#dddddd'} }\n    },\n    {\n      orient:\"bottom\",\n      paddingInner:[0.1,0.05,0.5]\n    }\n  ],\n  tooltip:{\n      visible:false\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 相关文档\r\n\r\n分组堆积柱形图demo：https://www.visactor.io/vchart/demo/bar-chart/stack-column</br>\r\n交互demo：https://visactor.com/vchart/demo/axis/multiple-layers-of-axis?keyword=axis</br>\r\n相关api：https://visactor.com/vchart/option/barChart#interactions.type.element-highlight-by-group</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '172- Can the bar series listen to event callbacks.md',
    content:
      "---\ntitle: 71. 柱系列是否可以监听事件回调？</br>\n---\r\n## 问题标题\r\n\r\n柱系列是否可以监听事件回调？</br>\r\n## 问题描述\r\n\r\n小程序使用 VChart 柱状图时，在选中柱状图某个柱时，是否有事件可以回调？</br>\r\n\r\n\r\n## 解决方案 \r\n\r\n在vchart中，您可以通过监听pointerdown事件来获取当前点击的图元信息；此外，还可以通过事件过滤获取不同元素上的事件。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/IUGQbR1r7oc2Pdxp3IdcwcCIngg.gif' alt='' width='2628' height='1926'>\r\n\r\n\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Ebb4b1dzBoReqoxfpbPcZL4InCh.gif' alt='' width='1392' height='1488'>\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\nvchart.on('pointerdown', { level: 'mark' }, (...params) => console.log(params))\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/bar-event-listener-dt8pjg?file=%2Fsrc%2Findex.ts%3A26%2C5</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JaQdb5qiao66z6xRd2wcpy0bnZc.gif' alt='' width='1392' height='1488'>\r\n\r\n## 相关文档\r\n\r\n事件教程：https://www.visactor.io/vchart/guide/tutorial_docs/Event</br>\r\n相关api：https://www.visactor.io/vchart/api/API/event</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '173- How to remove axis tick values.md',
    content:
      "---\ntitle: 104.如何去除轴刻度值？</br>\n---\r\n## 问题标题\r\n\r\n如何去除轴刻度值？</br>\r\n## 问题描述\r\n\r\n如何去除红框的内容呢？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UwTRbtwqxoLvLhxSEZocIx2NnXc.gif' alt='' width='1068' height='476'>\r\n\r\n## 解决方案 \r\n\r\n可以配置底部轴的 label.visible 为 false 来关闭轴标签：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JYAhbTutEoA5hfxpNFrc7qptnKh.gif' alt='' width='3280' height='1416'>\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes</br>\r\n*  API：https://visactor.bytedance.net/vchart/option/barChart#axes-linear</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '174-How to achieve a bar chart similar to the stacked column chart.md',
    content:
      "# 如何实现柱形图同维度数据前后重叠而不是堆叠效果？\n\n## 问题描述\n\n类似（[https://www.visactor.io/vchart/demo/bar-chart/stack-column](https://www.visactor.io/vchart/demo/bar-chart/stack-column)）这样的堆积柱状图，\n\n![description](/vchart/faq/64-0.png)\n\n想要实现不同颜色的柱子都从 y 轴 0 刻度开始画，前后重叠，而不是上下堆积，该如何实现？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，只需要将控制堆叠的字段设置为 false 即可。\n\n![solution](/vchart/faq/64-1.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: false,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  }\n};\n```\n\n## 结果展示\n\n在线效果参考：[https://codesandbox.io/s/bar-chart-stack-false-cr6667](https://codesandbox.io/s/bar-chart-stack-false-cr6667)\n\n![demo](/vchart/faq/64-2.gif)\n\n## 相关文档\n\n堆积柱形图 demo：[https://www.visactor.io/vchart/demo/bar-chart/stack-column](https://www.visactor.io/vchart/demo/bar-chart/stack-column)\n\n柱形图教程：[https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Bar](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Bar)\n\n相关 api：[https://www.visactor.io/vchart/option/barChart#stack](https://www.visactor.io/vchart/option/barChart#stack)\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '175-How to define the number of decimal places of a value displayed by a label in VChart.md',
    content:
      "# VChart 中如何定义 label 显示的数值小数位数？\n\n## 问题描述\n\n我使用 VChart 图表时，发现如果数字的小数位比较长时显示效果很不美观，有什么办法能控制标签显示的小数位长度吗？\n\n![tooltip](/vchart/faq/44-0.png)\n\n## 解决方案\n\n通过 VChart 的标签格式化函数可以解决这个问题，此外格式函数还可以支持自定义数字单位等需求\n\n## 代码示例\n\n```javascript\n// two decimal places\nspec.label.formatMethod = (value: number) => (+value).toFixed(2);\n\n// numerical unit\nspec.label.formatMethod = (value: number) => (+value / 1e3).toFixed(2) + 'k';\n```\n\n## 结果展示\n\n![demo](/vchart/faq/44-1.png)\n\nDemo: [https://codesandbox.io/s/label-formatter-d34xrm?file=/src/index.ts](https://codesandbox.io/s/label-formatter-d34xrm?file=/src/index.ts)\n\n## 相关文档\n\nformatMethod option: [https://visactor.io/vchart/option/barChart#label.formatMethod](https://visactor.io/vchart/option/barChart#label.formatMethod)\n\nlabel tutorials: [https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Label](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Label)\n\ngithub: [https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '176-How to listen to the click event of the histogram to customize the style of the column.md',
    content:
      "# 如何监听柱状图的点击事件来自定义柱子的样式？\n\n## 问题描述\n\n我想在一个柱状图里头监听每个柱子的点击事件，如果柱子被点击了就画成不同的颜色，大概像这样：\n\n![bar](/vchart/faq/78-0.png)\n\n但是点击事件触发之后我不希望重新渲染整个图表，最好能够在当前图表的基础上有一个平滑过度的效果，这个应该怎么实现呢？\n\n## 解决方案\n\nVChart 对于每个图表的图元提供了内置的 hover 和 select 状态。开发者不需要自己监听柱子的点击事件，只需要在相应的图元配置中声明 select 状态下的样式就可以实现柱子被选中后渲染为不同颜色的效果。\n\n同时 VChart 柱状图中默认对柱子图元的视觉通道变更开启了更新动画，当颜色发生变更时，柱子的渲染效果将会平滑过渡到最终状态。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales',\n  bar: {\n    state: {\n      selected: {\n        fill: 'red'\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [barChart bar state spec](https://www.visactor.io/vchart/option/barChart#bar.state)\n"
  },
  {
    fileName: '177-How to get the data point information in a click event using react-vchart.md',
    content:
      '# 使用@visactor/react-vchart,如何在点击事件中获取对应数据点信息？\n\n## 问题描述\n\n使用 @visactor/react-vchart 在 React 中实现[这样的柱状图](https://www.visactor.io/vchart/demo/bar-chart/basic-column)\n\n![bar chart](/vchart/faq/32-0.png)\n\n如何绑定点击事件？能够从点击事件中获取对应的数据信息吗\n\n## 解决方案\n\n通过 VChart 官方提供的 React 封装库`react-vchart` [教程可参考](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/react)，react-vchart 支持两种组件：\n\n- 使用`VChart`组件，组件支持 `onAbc`格式来绑定事件，支持的[事件名参考](https://www.visactor.io/vchart/api/API/event)\n- 使用`LineChart`类似的语义化组件实现的时候，在`Line`等子组件上，支持通过`onAbc`格式的 props 来绑定事件，支持的[事件名参考](https://www.visactor.io/vchart/api/API/event)\n\n## 代码示例\n\n```\nimport { VChart, VChartProps } from "@visactor/react-vchart";\nimport { Component } from "react";\n\nexport interface BarChartProps {\n  colors?: string[];\n  data: any[];\n}\n\nexport class BarChart extends Component<BarChartProps> {\n  state: { active: any } = {\n    active: null\n  };\n  parseSpec = () => {\n    const colors = this.props.colors;\n    return {\n      type: "bar",\n      data: [\n        {\n          id: "barData",\n          values: this.props.data\n        }\n      ],\n      xField: "name",\n      yField: "value",\n      color: {\n        type: "ordinal",\n        domain: [],\n        range: colors\n      }\n    } as VChartProps["spec"];\n  };\n\n  handleClick = (e: any) => {\n    this.setState({ active: e.datum });\n  };\n\n  render() {\n    return (\n      <>\n        <p>{`active bar: ${this.state.active?.name ?? ""}`}</p>\n        <VChart spec={this.parseSpec()} onClick={this.handleClick} />\n      </>\n    );\n  }\n}\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/visactor-vchart-react-event-q6jzwv)\n\n![bar chart](/vchart/faq/32-1.png)\n\n## 相关文档\n\n- [react-vchart 教程](https://www.visactor.io/vchart/guide/tutorial_docs/Cross-terminal_and_Developer_Ecology/react)\n- [github](https://github.com/VisActor/VChart)\n'
  },
  {
    fileName: '178- How to set different fill colors based on groups in a radar chart.md',
    content:
      "---\ntitle: 31. 雷达图如何根据分组设置不同的填充颜色</br>\n---\r\n## 问题标题\r\n\r\n雷达图如何根据分组设置不同的填充颜色？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n如图示，雷达图有多个分组，可以给不同分组设置不同的填充颜色吗？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/GBtQbnp8QoUmvdx3chMcVyGnnTc.gif' alt='' width='954' height='936'>\r\n\r\n## 解决方案 \r\n\r\nVChart 图元样式都支持函数写法，可以通过自定义函数在样式中根据数据返回不同的填充颜色：</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/DQDObk1vcoi4NHxCzfvcQmqVnAX.gif' alt='' width='3386' height='1232'>\r\n\r\n\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'radar',\n  data: [\n    {\n      values: [\n        {\n          month: 'Jan.',\n          value: 45,\n          type: 'A'\n        },\n        {\n          month: 'Feb.',\n          value: 61,\n          type: 'A'\n        },\n        {\n          month: 'Mar.',\n          value: 92,\n          type: 'A'\n        },\n        {\n          month: 'Apr.',\n          value: 57,\n          type: 'A'\n        },\n        {\n          month: 'May.',\n          value: 46,\n          type: 'A'\n        },\n        {\n          month: 'Jun.',\n          value: 36,\n          type: 'A'\n        },\n        {\n          month: 'Jul.',\n          value: 33,\n          type: 'A'\n        },\n        {\n          month: 'Aug.',\n          value: 63,\n          type: 'A'\n        },\n        {\n          month: 'Sep.',\n          value: 57,\n          type: 'A'\n        },\n        {\n          month: 'Oct.',\n          value: 53,\n          type: 'A'\n        },\n        {\n          month: 'Nov.',\n          value: 69,\n          type: 'A'\n        },\n        {\n          month: 'Dec.',\n          value: 40,\n          type: 'A'\n        },\n        {\n          month: 'Jan.',\n          value: 31,\n          type: 'B'\n        },\n        {\n          month: 'Feb.',\n          value: 39,\n          type: 'B'\n        },\n        {\n          month: 'Mar.',\n          value: 81,\n          type: 'B'\n        },\n        {\n          month: 'Apr.',\n          value: 39,\n          type: 'B'\n        },\n        {\n          month: 'May.',\n          value: 64,\n          type: 'B'\n        },\n        {\n          month: 'Jun.',\n          value: 21,\n          type: 'B'\n        },\n        {\n          month: 'Jul.',\n          value: 58,\n          type: 'B'\n        },\n        {\n          month: 'Aug.',\n          value: 72,\n          type: 'B'\n        },\n        {\n          month: 'Sep.',\n          value: 47,\n          type: 'B'\n        },\n        {\n          month: 'Oct.',\n          value: 37,\n          type: 'B'\n        },\n        {\n          month: 'Nov.',\n          value: 80,\n          type: 'B'\n        },\n        {\n          month: 'Dec.',\n          value: 74,\n          type: 'B'\n        },\n        {\n          month: 'Jan.',\n          value: 90,\n          type: 'C'\n        },\n        {\n          month: 'Feb.',\n          value: 95,\n          type: 'C'\n        },\n        {\n          month: 'Mar.',\n          value: 62,\n          type: 'C'\n        },\n        {\n          month: 'Apr.',\n          value: 52,\n          type: 'C'\n        },\n        {\n          month: 'May.',\n          value: 74,\n          type: 'C'\n        },\n        {\n          month: 'Jun.',\n          value: 87,\n          type: 'C'\n        },\n        {\n          month: 'Jul.',\n          value: 80,\n          type: 'C'\n        },\n        {\n          month: 'Aug.',\n          value: 69,\n          type: 'C'\n        },\n        {\n          month: 'Sep.',\n          value: 74,\n          type: 'C'\n        },\n        {\n          month: 'Oct.',\n          value: 84,\n          type: 'C'\n        },\n        {\n          month: 'Nov.',\n          value: 94,\n          type: 'C'\n        },\n        {\n          month: 'Dec.',\n          value: 23,\n          type: 'C'\n        }\n      ]\n    }\n  ],\n  categoryField: 'month',\n  valueField: 'value',\n  seriesField: 'type',\n  area: {\n    visible: true,\n    style: {\n      fill: (datum, ctx) => {\n        return datum.type === 'A' ? ctx.seriesColor(datum.type): false;\n      }\n    }\n  },\n  axes: [\n    {\n      orient: 'radius',\n      min: 0,\n      domainLine: {\n        visible: true\n      },\n      label: {\n        visible: true\n      },\n      grid: {\n        smooth: true\n      }\n    },\n    {\n      orient: 'angle',\n      tick: {\n        visible: false\n      },\n      grid: {\n        style: {\n          lineDash: [0]\n        }\n      }\n    }\n  ],\n  legends: {\n    visible: true,\n    orient: 'top'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/XOblbueMVou8l9xceKtcnJ6Ln5I.gif' alt='' width='1438' height='952'>\r\n\r\n## 相关文档\r\n\r\n*  [图元教程](https%3A%2F%2Fwww.visactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FSeries%2FMark)[ ](https%3A%2F%2Fvisactor.com%2Fvchart%2Fguide%2Ftutorial_docs%2FChart_Concepts%2FAxes)</br>\r\n*  [VChart github](https%3A%2F%2Fgithub.com%2FVisActor%2FVChart)</br>"
  },
  {
    fileName: '179- Bar chart value labels aligned to the right display.md',
    content:
      "---\ntitle: 102.条形图数值标签右对齐展示</br>\n---\r\n## 问题标题\r\n\r\n条形图数值标签右对齐展示</br>\r\n## 问题描述\r\n\r\n将标签统一展示在右侧，并右对齐</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/AQV5bYlUjoEJoDxwiO2cghV4ng9.gif' alt='' width='1594' height='1018'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n可以使用 VChart 提供的 `extensionMark` 属性，通过自定义图形实现。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          name: 'Apple',\n          value: 214480\n        },\n        {\n          name: 'Google',\n          value: 155506\n        },\n        {\n          name: 'Amazon',\n          value: 100764\n        },\n        {\n          name: 'Microsoft',\n          value: 92715\n        },\n        {\n          name: 'Coca-Cola',\n          value: 66341\n        },\n        {\n          name: 'Samsung',\n          value: 59890\n        },\n        {\n          name: 'Toyota',\n          value: 53404\n        },\n        {\n          name: 'Mercedes-Benz',\n          value: 48601\n        },\n        {\n          name: 'Facebook',\n          value: 45168\n        },\n        {\n          name: \"McDonald's\",\n          value: 43417\n        },\n        {\n          name: 'Intel',\n          value: 43293\n        },\n        {\n          name: 'IBM',\n          value: 42972\n        },\n        {\n          name: 'BMW',\n          value: 41006\n        },\n        {\n          name: 'Disney',\n          value: 39874\n        },\n        {\n          name: 'Cisco',\n          value: 34575\n        },\n        {\n          name: 'GE',\n          value: 32757\n        },\n        {\n          name: 'Nike',\n          value: 30120\n        },\n        {\n          name: 'Louis Vuitton',\n          value: 28152\n        },\n        {\n          name: 'Oracle',\n          value: 26133\n        },\n        {\n          name: 'Honda',\n          value: 23682\n        }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  xField: 'value',\n  yField: 'name',\n  axes: [\n    {\n      orient: 'bottom',\n      visible: false\n    }\n  ],\n  label: {\n    visible: false\n  },\n  extensionMark: [\n    {\n      type: 'text',\n      dataId: 'barData',\n      visible: true,\n      style: {\n        text: datum => datum.value,\n        fontSize: 12,\n        x: (datum, ctx) => {\n          return ctx.getRegion().getLayoutRect().width + 10;\n        },\n        y: (datum, ctx) => {\n          return ctx.valueToY([datum.name]) + ctx.yBandwidth() / 2;\n        },\n        textBaseline: 'middle',\n        textAlign: 'right',\n        fill: \"#1664FF\",\n        fontSize: 12\n      }\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/HdWgbavX1orgTCxcWdXcrK8rnbh.gif' alt='' width='1100' height='1044'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  教程：https://visactor.io/vchart/guide/tutorial_docs/extend/custom_mark</br>\r\n*  API：https://visactor.io/vchart/option/barChart#extensionMark</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '180-How to use charts libraries in Vue.md',
    content:
      '## 如何在 Vue 中使用图表库，如 VChart？\n\n## 问题描述\n\n如何在 Vue 中实现[这样的柱状图](https://www.visactor.io/vchart/demo/bar-chart/basic-column)\n\n![bar chart](/vchart/faq/30-0.png)\n有什么需要注意的点吗？\n\n## 解决方案\n\n在 Vue 3.x 中使用 VChart，分两种情况\n\n1.  组合式 API，具体可以[参考在线 demo](https://codesandbox.io/s/viscator-vchart-vue-demo-gmcpq6?file=/src/components/LineChart.vue)\n1.  选项式 API，具体可以[参考在线 demo](https://codesandbox.io/s/viscator-vchart-vue-demo-gmcpq6?file=/src/components/BarChart.vue)\n\n不同的图表，封装方式都是类似的\n\n## 代码示例\n\n- 组合式 API\n\n```\n<script setup lang="ts">\nimport { onMounted, onBeforeUnmount, onUpdated } from "vue";\nimport { VChart, IChart, ILineChartSpec } from "@visactor/vchart";\n\ninterface LineChartProps {\n  colors?: string[];\n}\n\nconst props = defineProps<LineChartProps>();\n\nlet chart: IChart;\n\nfunction parseSpec(chartProps: LineChartProps) {\n  const colors = chartProps.colors ?? [\n    "#6690F2",\n    "#70D6A3",\n    "#B4E6E2",\n    "#63B5FC",\n    "#FF8F62",\n    "#FFDC83",\n    "#BCC5FD",\n    "#A29BFE",\n    "#63C4C7",\n    "#F68484",\n  ];\n  return {\n    type: "line",\n    data: {\n      values: [\n        { type: "Nail polish", country: "Africa", value: 4229 },\n        { type: "Nail polish", country: "EU", value: 4376 },\n        { type: "Nail polish", country: "China", value: 3054 },\n        { type: "Nail polish", country: "USA", value: 12814 },\n        { type: "Eyebrow pencil", country: "Africa", value: 3932 },\n        { type: "Eyebrow pencil", country: "EU", value: 3987 },\n        { type: "Eyebrow pencil", country: "China", value: 5067 },\n        { type: "Eyebrow pencil", country: "USA", value: 13012 },\n        { type: "Rouge", country: "Africa", value: 5221 },\n        { type: "Rouge", country: "EU", value: 3574 },\n        { type: "Rouge", country: "China", value: 7004 },\n        { type: "Rouge", country: "USA", value: 11624 },\n        { type: "Lipstick", country: "Africa", value: 9256 },\n        { type: "Lipstick", country: "EU", value: 4376 },\n        { type: "Lipstick", country: "China", value: 9054 },\n        { type: "Lipstick", country: "USA", value: 8814 },\n        { type: "Eyeshadows", country: "Africa", value: 3308 },\n        { type: "Eyeshadows", country: "EU", value: 4572 },\n        { type: "Eyeshadows", country: "China", value: 12043 },\n        { type: "Eyeshadows", country: "USA", value: 12998 },\n        { type: "Eyeliner", country: "Africa", value: 5432 },\n        { type: "Eyeliner", country: "EU", value: 3417 },\n        { type: "Eyeliner", country: "China", value: 15067 },\n        { type: "Eyeliner", country: "USA", value: 12321 },\n        { type: "Foundation", country: "Africa", value: 13701 },\n        { type: "Foundation", country: "EU", value: 5231 },\n        { type: "Foundation", country: "China", value: 10119 },\n        { type: "Foundation", country: "USA", value: 10342 },\n        { type: "Lip gloss", country: "Africa", value: 4008 },\n        { type: "Lip gloss", country: "EU", value: 4572 },\n        { type: "Lip gloss", country: "China", value: 12043 },\n        { type: "Lip gloss", country: "USA", value: 22998 },\n        { type: "Mascara", country: "Africa", value: 18712 },\n        { type: "Mascara", country: "EU", value: 6134 },\n        { type: "Mascara", country: "China", value: 10419 },\n        { type: "Mascara", country: "USA", value: 11261 },\n      ],\n    },\n    color: {\n      type: "ordinal",\n      domain: [],\n      range: colors,\n    },\n    title: {\n      visible: true,\n      text: "Stacked line chart",\n    },\n    stack: true,\n    xField: "type",\n    yField: "value",\n    seriesField: "country",\n    legends: [{ visible: true, position: "middle", orient: "bottom" }],\n  } as ILineChartSpec;\n}\n\nfunction createOrUpdateChart(chartProps: LineChartProps) {\n  const container = document.getElementById("treemap-container");\n  if (container && !chart) {\n    chart = new VChart(parseSpec(chartProps), {\n      dom: container,\n    });\n\n    chart.renderSync();\n    return true;\n  } else if (chart) {\n    chart.updateSpec(parseSpec(chartProps));\n    chart.renderSync();\n\n    return true;\n  }\n  return false;\n}\n\nonMounted(() => {\n  createOrUpdateChart(props);\n});\n\nonUpdated(() => {\n  createOrUpdateChart(props);\n});\n\nonBeforeUnmount(() => {\n  if (chart) {\n    chart.release();\n  }\n});\n</script>\n\n<template>\n  <h1>this is a demo of LineChart</h1>\n\n  <div class="treemap-container" id="treemap-container"></div>\n</template>\n\n<style scoped>\n.treemap-container {\n  width: 100%;\n  height: 400px;\n}\n</style>\n```\n\n- 选项式 API：\n\n```\n<script lang="ts">\nimport { defineComponent } from "vue";\nimport { VChart, IBarChartSpec, IChart } from "@visactor/vchart";\nimport type { PropType } from "vue";\n\ninterface BarChartProps {\n  colors?: string[];\n  data?: any[];\n}\n\nexport default defineComponent({\n  props: {\n    colors: Object as PropType<BarChartProps["colors"]>,\n    data: Object as PropType<BarChartProps["data"]>,\n  },\n\n  setup() {\n    let chart: IChart | null = null;\n    const parseSpec = (chartProps: BarChartProps) => {\n      const colors = chartProps.colors;\n\n      return {\n        type: "bar",\n        data: [\n          {\n            id: "barData",\n            values: chartProps.data,\n          },\n        ],\n        xField: "name",\n        yField: "value",\n        color: {\n          type: "ordinal",\n          domain: [],\n          range: colors,\n        },\n      } as IBarChartSpec;\n    };\n\n    const createOrUpdateChart = (chartProps: BarChartProps) => {\n      const container = document.getElementById("barchart-container");\n      if (container && !chart) {\n        chart = new VChart(parseSpec(chartProps), {\n          dom: container,\n        });\n\n        chart.renderSync();\n        return true;\n      } else if (chart) {\n        chart.updateSpec(parseSpec(chartProps));\n        chart.renderSync();\n\n        return true;\n      }\n      return false;\n    };\n\n    const releaseChart = () => {\n      if (chart) {\n        chart.release();\n        chart = null;\n      }\n    };\n\n    return {\n      createOrUpdateChart,\n      releaseChart,\n    };\n  },\n\n  mounted() {\n    this.createOrUpdateChart({ colors: this.colors, data: this.data });\n  },\n\n  updated() {\n    this.createOrUpdateChart({ colors: this.colors, data: this.data });\n  },\n\n  beforeUnmount() {\n    this.releaseChart();\n  },\n});\n</script>\n\n<template>\n  <h1>this is a demo of barchart</h1>\n\n  <div class="barchart-container" id="barchart-container"></div>\n</template>\n\n<style scoped>\n.barchart-container {\n  width: 100%;\n  height: 400px;\n}\n</style>\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/viscator-vchart-vue-demo-gmcpq6)\n\n![result](/vchart/faq/30-1.gif)\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n'
  },
  {
    fileName: '181- How to format the tooltip in a VChart radar chart.md',
    content:
      '---\ntitle: 95. VChart 雷达图如何格式化Tooltip?</br>\n---\r\n## 问题标题\r\n\r\n雷达图如何格式化Tooltip?</br>\r\n## 问题描述\r\n\r\n图表中的数据存在非常长的字符串， 这种场景下， 默认`tooltip`的展示效果并不好， 需要优化其显示效果</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart 的`tooltip`组件， 提供了对`key`与`value`的自定义配置， 允许用户对图元和维度的提示信息， 进行自定义设置。 </br>\r\n在超长文本场景， 通常情况下只需要使用格式化能力， 对指标进行格式化， 对维度进行缩略显示。</br>\r\n步骤一： 配置`tooltip.mark.content`， 分别对 图元`tooltip`中的`value` 和 `key`进行格式化。</br>\r\n步骤二： 配置`tooltip.dimension.content`， 分别对维度`tooltip`中的`value`和`key`进行格式化。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "radar",\n      data: [\n        {\n          values: [\n            {\n              month: "Jan.",\n              value: 45,\n              type: "A",\n            },\n            {\n              month: "Feb.",\n              value: 61,\n              type: "A",\n            },\n            {\n              month: "Mar.",\n              value: 92,\n              type: "A",\n            },\n            {\n              month: "Apr.",\n              value: 57,\n              type: "A",\n            },\n            {\n              month: "May.",\n              value: 46,\n              type: "A",\n            },\n            {\n              month: "Jun.",\n              value: 36,\n              type: "A",\n            },\n            {\n              month: "Jul.",\n              value: 33,\n              type: "A",\n            },\n            {\n              month: "Aug.",\n              value: 63,\n              type: "A",\n            },\n            {\n              month: "Sep.",\n              value: 57,\n              type: "A",\n            },\n            {\n              month: "Oct.",\n              value: 53,\n              type: "A",\n            },\n            {\n              month: "Nov.",\n              value: 69,\n              type: "A",\n            },\n            {\n              month: "Dec.",\n              value: 40,\n              type: "A",\n            },\n            {\n              month: "Jan.",\n              value: 31,\n              type: "B",\n            },\n            {\n              month: "Feb.",\n              value: 39,\n              type: "B",\n            },\n            {\n              month: "Mar.",\n              value: 81,\n              type: "B",\n            },\n            {\n              month: "Apr.",\n              value: 39,\n              type: "B",\n            },\n            {\n              month: "May.",\n              value: 64,\n              type: "B",\n            },\n            {\n              month: "Jun.",\n              value: 21,\n              type: "B",\n            },\n            {\n              month: "Jul.",\n              value: 58,\n              type: "B",\n            },\n            {\n              month: "Aug.",\n              value: 72,\n              type: "B",\n            },\n            {\n              month: "Sep.",\n              value: 47,\n              type: "B",\n            },\n            {\n              month: "Oct.",\n              value: 37,\n              type: "B",\n            },\n            {\n              month: "Nov.",\n              value: 80,\n              type: "B",\n            },\n            {\n              month: "Dec.",\n              value: 74,\n              type: "B",\n            },\n            {\n              month: "Jan.",\n              value: 90,\n              type: "C",\n            },\n            {\n              month: "Feb.",\n              value: 95,\n              type: "C",\n            },\n            {\n              month: "Mar.",\n              value: 62,\n              type: "C",\n            },\n            {\n              month: "Apr.",\n              value: 52,\n              type: "C",\n            },\n            {\n              month: "May.",\n              value: 74,\n              type: "C",\n            },\n            {\n              month: "Jun.",\n              value: 87,\n              type: "C",\n            },\n            {\n              month: "Jul.",\n              value: 80,\n              type: "C",\n            },\n            {\n              month: "Aug.",\n              value: 69,\n              type: "C",\n            },\n            {\n              month: "Sep.",\n              value: 74,\n              type: "C",\n            },\n            {\n              month: "Oct.",\n              value: 84,\n              type: "C",\n            },\n            {\n              month: "Nov.",\n              value: 94,\n              type: "C",\n            },\n            {\n              month: "Dec.",\n              value: 23,\n              type: "C",\n            },\n          ],\n        },\n      ],\n      categoryField: "month",\n      valueField: "value",\n      seriesField: "type",\n      stack: true,\n      percent: true,\n      area: {\n        visible: true, // show area\n      },\n      axes: [\n        {\n          orient: "radius",\n          min: 0,\n          domainLine: {\n            visible: true,\n          },\n          label: {\n            visible: true,\n            formatMethod: (val) => {\n              return val * 100 + "%";\n            },\n          },\n          grid: {\n            smooth: false,\n            style: {\n              lineDash: [0],\n            },\n          },\n        },\n        {\n          orient: "angle",\n          tick: {\n            visible: false,\n          },\n          domainLine: {\n            visible: false,\n          },\n          grid: {\n            style: {\n              lineDash: [0],\n            },\n          },\n        },\n      ],\n      legends: {\n        visible: true,\n        orient: "top",\n      },\n      tooltip: {\n        mark: {\n          title: {\n            value: "Mark Title",\n          },\n          content: [\n            {\n              key: "key",\n              value: "value",\n            },\n            {\n              key: (datum) => `${datum.type}-${datum.month}`,\n              value: (datum) => `${datum.value.toFixed(2)} k`,\n            },\n          ],\n        },\n        dimension: {\n          title: {\n            value: "Dimension Radar Title",\n          },\n          content: [\n            {\n              key: "key",\n              value: "value",\n            },\n            {\n              key: (datum) => `${datum.type}-${datum.month}`,\n              value: (datum) => `${datum.value.toFixed(2)} k`,\n            },\n          ],\n        },\n      },\n    };\n\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart" style={{ width: 400 }}></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-pie-ordinal-color-forked-xpvnrq</br>\r\n## 相关文档\r\n\r\nTooltip API: https://visactor.io/vchart/option/barChart#tooltip.mark.content(Object%7CObject%5B%5D)</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '182- How to assign different colors to a line in VChart.md',
    content:
      "---\ntitle: 46. VChart 怎么给一根线配置不同的颜色</br>\n---\r\n## 问题标题\r\n\r\n如何给一根线配置不同的颜色</br>\r\n## 问题描述\r\n\r\n线有一部分是预测数据，希望预测数据时虚线并且颜色不一样</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QSjQbbuEOoB8vLxoa9ycE15Nnth.gif' alt='' width='741' height='528'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\nVChart 的线可以通过函数给一根线上的不同数据返回不同的样式。当出现样式不一致的情况，我们会在绘图时，将上一个数据到当前数据的线段绘制为当前数据对应的样式</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      {\n        x: '1st',\n        y: 0.012\n      },\n      {\n        x: '2nd',\n        y: -0.01\n      },\n      {\n        x: '3rd',\n        y: 0.005\n      },\n      {\n        x: '4th',\n        y: 0.007\n      },\n      {\n        x: '5th',\n        y: 0.01\n      },\n      {\n        x: '6th',\n        y: 0.017\n      },\n      {\n        x: '7th',\n        y: 0.022\n      },\n      {\n        x: '8th (prediction)',\n        y: 0.033,\n        latest: true\n      }\n    ]\n  },\n  xField: 'x',\n  yField: 'y',\n  line: {\n    style: {\n      lineDash: data => {\n        if (data.latest) {\n          return [5, 5];\n        }\n        return [0];\n      },\n      stroke: data => {\n        if (data.latest) {\n          return 'green';\n        }\n        return 'blue';\n      }\n    }\n  },\n  point: {\n    style: {\n      fill: data => {\n        if (data.latest) {\n          return 'green';\n        }\n        return 'blue';\n      }\n    }\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/UE3Ab0FIfoYghsxbUlZcCs5Nnxc.gif' alt='' width='1299' height='566'>\r\n\r\nDemo: https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-mxqfr3?file=%2Fsrc%2Findex.js%3A59%2C13</br>\r\n## 相关文档\r\n\r\nDemo：https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-mxqfr3?file=%2Fsrc%2Findex.js%3A59%2C13</br>\r\n教程：</br>\r\n*  初始化VChart： https://visactor.io/vchart/api/API/vchart</br>\r\n*  线的样式配置：https://www.visactor.io/vchart/option/lineChart#line.style.stroke</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '183- Can the unit of the y-axis be configured without a function.md',
    content:
      "---\ntitle: 29.不用函数能配置 y 轴的单位吗</br>\n---\r\n## 问题标题\r\n\r\n不用函数能配置 y 轴的单位吗？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n请问一下不使用函数能支持 y 轴的格式化吗？比如一些默认的千分位，自动加单位这些。因为小程序场景里头里面只能用纯 json 配置，没法配置回调函数。</br>\r\n\r\n\r\n## 解决方案\r\n\r\n从 VChart 1.7.0版本开始，可以通过注册表达式函数的方法对自定义的函数内容进行注册：</br>\r\n```\nfunction labelFormat(key) {\n  return key + 'test';\n}\n\n// Global registration function\nVChart.registerFunction('labelFormat', labelFormat);</br>\n```\r\n对应的图表配置中可以在任意支持自定义回调函数的地方使用这一注册函数的名称：</br>\r\n```\nconst spec = {\n  type: 'bar',\n  data: [...],\n  xField: 'month',\n  yField: 'sales',\n  label: {\n    visible: true,\n    formatMethod: 'labelFormat'\n  }\n};</br>\n```\r\n注册函数的功能在飞书小组件以及微信小程序等环境中均可生效。</br>\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nfunction labelFormat(key) {\n  return key + 'test';\n}\n\n// Global registration function\nVChart.registerFunction('labelFormat', labelFormat);\n\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales',\n  label: {\n    visible: true,\n    formatMethod: 'labelFormat'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/OJd9bVlGAoTGPVxbAYWctU0bn8b.gif' alt='' width='1222' height='984'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  function：https://www.visactor.io/vchart/guide/tutorial_docs/Function</br>\r\n*  github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '184-How to customize the shape and text style of the legend.md',
    content:
      "# 如何自定义图例的形状和文字样式？\n\n## 问题描述\n\n请问如何自定义图例项的形状，同时修改文字的样式，实现类似下图的图例样式：\n\n![](/vchart/faq/88-0.png)\n\n## 解决方案\n\n不同的图表库解决方案不同，下面介绍下使用 VChart 如何进行配置，目前 VChart 要实现上图的显示效果，需要：\n\n1.  自定义数据，主要是为了给图例项数据添加数值字段，这样可以在图例项上显示数值，也可以通过 `item.value` 属性配置数值的样式\n1.  在 VChart 中，饼图的图例形状默认是圆形，但是如果想要配置成其他形状，也是可以直接通过 `item.shape.style.symbolType` 来配置的\n\n![](/vchart/faq/88-1.png)\n\n## 代码示例\n\n```javascript livedemo\nconst pieData = [\n  {\n    value: '159',\n    type: 'Tradition Industries'\n  },\n  {\n    value: '50',\n    type: 'Business Companies'\n  },\n  {\n    value: '13',\n    type: 'Customer-facing Companies'\n  }\n];\n\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      values: pieData\n    }\n  ],\n  categoryField: 'type',\n  valueField: 'value',\n  legends: {\n    visible: true,\n    orient: 'right',\n    data: legendData => {\n      const map = {};\n      pieData.forEach(obj => {\n        map[obj.type] = obj.value;\n      });\n\n      return legendData.map(datum => {\n        datum.value = map[datum.label];\n        return datum;\n      });\n    },\n    item: {\n      shape: {\n        style: {\n          symbolType: 'square'\n        }\n      },\n      label: {\n        style: {\n          fill: '#999'\n        }\n      },\n      value: {\n        style: {\n          fill: '#000',\n          fontWeight: 'bold'\n        },\n        space: 10\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档 Related Documentation\n\n- 图例教程：[https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend)\n- 图例配置：[https://www.visactor.io/vchart/option/lineChart#legends-discrete.type](https://www.visactor.io/vchart/option/lineChart#legends-discrete.type)\n"
  },
  {
    fileName: "185- How to set the title font size to semi's heading-4 in vchart.md",
    content:
      '---\ntitle: 111. 如何在vchart中设置title的字号为semi的heading-4？</br>\n---\r\n# 问题标题\r\n\r\n如何在vchart中设置title的字号为semi的heading-4？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我正在使用@visactor/vchart图表库进行数据可视化。但我遇到了一个问题，我想在vchart中设置title的字号为semi的heading-4字号，但我不知道如何将这个变量传入。</br>\r\n\r\n\r\n# 解决方案\r\n\r\n新版的vchart提供了一个名为vchart-semi-theme的包，它可以自动爬取页面上的 semi css 变量，因此图表的大部分色值都可以使用这个功能。至于字号，虽然目前这个包并未直接提供引入 semi 变量的功能，但你可以手动修改 spec 或者注册主题来达到目标。</br>\r\n\r\n\r\n使用方法如下：</br>\r\n1. 首先安装vchart-semi-theme包</br>\r\n2. 使用文档：https://visactor.bytedance.net/vchart/guide/tutorial_docs/Theme/Theme_Extension</br>\r\n3. 需要看一些示例可以参考：https://vp4y9p.csb.app/</br>\r\n\r\n\r\n注意：由于vchart-semi-theme的使用需要爬取页面的css变量，因此请确保你的页面中包含了需要的semi css变量。</br>\r\n\r\n\r\n# 相关文档\r\n\r\nVChart 官网：https://visactor.bytedance.net/vchart</br>\r\nvchart-semi-theme 使用文档：https://visactor.bytedance.net/vchart/guide/tutorial_docs/Theme/Theme_Extension</br>\r\n在线Demo：https://vp4y9p.csb.app/</br>'
  },
  {
    fileName: '186- How to add custom content to the bottom of a tooltip card in vChart.md',
    content:
      "---\ntitle: 110. 如何在vChart的tooltip卡片底部添加自定义内容？</br>\n---\r\n# 问题描述\r\n\r\n我正在使用vChart进行数据可视化的编程，并遇到了一些问题。我想在tooltip的卡片底部新增一些自定义的内容，尤其是一个按钮。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/KURmbG6nJov1O2xb9HoccdRNnyG.gif' alt='' width='1026' height='844'>\r\n\r\n但是我发现在vChart.renderAsync().then的时候，似乎无法获取我们定义了className的tooltip，必须要等一段时间才能获取到。我并不希望通过自定义tooltip来实现这个功能，因为我希望保持原有的组件样式。所以，我想问一下，有没有更好的解决方案？</br>\r\n# 解决方案\r\n\r\n对于这个问题，可以通过updateElement回调在原有的dom上进行修改。这里有一个示例代码：</br>\r\n```\ntooltip: {\n...\nupdateElement: el => {\nel.style.width = 'auto';\nel.style.height = 'auto';\nel.style.minHeight = 'auto';\nif (el.lastElementChild?.id !== 'test') {\nel.innerHTML = '';\nconst div = document.createElement('div');\ndiv.id = 'test';\ndiv.style.width = '200px';\ndiv.innerText = 'test';\ndiv.style.color = 'red';\nel.appendChild(div);\n}\n}\n}</br>\n```\r\n此段代码将在tooltip的原有dom上进行修改。你可以选择清空tooltip内容或者保留原内容。但需要注意的是tooltip的enterable支持可能还不理想，更新tooltip位置时，每次都会执行回调函数。</br>\r\n升级到vchart1.6.0版本后可以使用updateElement功能。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/C7spbeDn9oUTIRx3RdEcO8Rqnge.gif' alt='' width='1998' height='278'>\r\n\r\nupdateElement第三个参数可以取到params.changePositionOnly，如果为true表示默认tooltip内容没有发生变化。如果自定义的tooltip内容需要和默认tooltip同步更新，可以考虑过滤掉params.changePositionOnly为true的情况。</br>\r\n# 结果展示\r\n\r\n经过以上步骤后，我成功在vChart的tooltip卡片的底部添加了一个按钮。</br>\r\n\r\n\r\n# 相关文档\r\n\r\n*  [updateElement文档](https://visactor.bytedance.net/vchart/option/barChart#tooltip.updateElement)</br>"
  },
  {
    fileName: '187- How to listen to events on data dimensions and retrieve corresponding data.md',
    content:
      "---\ntitle: 77. 如何监听数据维度的事件并拿到对应数据？</br>\n---\r\n## 问题标题\r\n\r\n如何监听数据维度的事件并拿到对应数据？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n你好，我们这里有个需求需要监听柱状图数据维度所在的位置，并且根据用户的点击对应的数据高亮另一个表格中的单元格，请问应该如何实现呢？</br>\r\n\r\n\r\n## 解决方案\r\n\r\n用户可以监听 vchart 实例上的 dimensionClick 事件来自定义数据维度点击后执行的操作，同时对应数据维度的信息可以在回调函数参数中获取：</br>\r\n```\nvchart.on('dimensionClick', (args) => {\n  const datum = args.datum;\n  console.log('Dimension Click!', args, datum);\n});\n</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        { month: 'Monday', sales: 22 },\n        { month: 'Tuesday', sales: 13 },\n        { month: 'Wednesday', sales: 25 },\n        { month: 'Thursday', sales: 29 },\n        { month: 'Friday', sales: 38 }\n      ]\n    }\n  ],\n  xField: 'month',\n  yField: 'sales'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\nvchart.on('dimensionClick', (args) => {\n  const datum = args.datum;\n  console.log('Dimension Click!', args, datum);\n});\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/KTeSbiAFio6H7oxdAbCcNY15nDb.gif' alt='' width='1680' height='1052'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  Event: https://visactor.bytedance.net/vchart/api/API/event</br>\r\n\r\n"
  },
  {
    fileName:
      '188- In vchart, how to set the legend not to follow gradient colors and draw legends with rounded rectangles.md',
    content:
      "---\ntitle: 34. vchart图表中，如何设置legend不跟随渐变色并绘制圆角矩形的图例？</br>\n---\r\n# 问题标题\r\n\r\nvchart图表中，如何设置legend不跟随渐变色并绘制圆角矩形的图例？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n我正在使用vchart进行图表制作，遇到两个问题想要咨询大家。我的面积图的样式已经调整为渐变色，但我不希望图例（legend）颜色跟随面积图的渐变色，应该如何设置呢？</br>\r\n另外，我在资料中没有找到图例形状提供圆角矩形的选项，是否有其他方案可以实现绘制圆角矩形？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TFbYbgHspolkO9x8mfTcuxczn06.gif' alt='' width='454' height='58'>\r\n\r\n# 解决方案\r\n\r\n你好，这两个问题都是可以通过配置来解决的。</br>\r\n1. 如果你不希望图例颜色跟随面积图的渐变色，可以通过配置 `seriesMark` 来改变系列主mark的颜色。</br>\r\n```\nseriesMark:'point',</br>\n```\r\n2. 至于如何绘制圆角矩形的图例，你可以配置图例图形的 `symbolType` 图形属性进行设置。具体的设置内容如下：</br>\r\n```\nitem:{\nshape:{\nstyle:{\nsymbolType:\"M 462 282 c 0 99.405 -80.595 180 -180 180 h -540 c -99.405 0 -180 -80.595 -180 -180 v -540 c 0 -99.405 80.595 -180 180 -180 h 540 c 99.405 0 180 80.595 180 180 v 540 z\"\n}\n}\n}</br>\n```\r\n# 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/M0wpboAgPofnU0xoJo7cQcjansV.gif' alt='' width='1720' height='1552'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/line-chart-hover-forked-t74cvw?file=%2Fsrc%2Findex.ts%3A66%2C13</br>\r\n# 相关文档\r\n\r\n*  VChart文档 symbolType：https://visactor.bytedance.net/vchart/option/barChart-legends-discrete#item.shape.style.symbolType</br>\r\n*  VChart文档 seriesMark：https://visactor.bytedance.net/vchart/option/lineChart#seriesMark('point'|'line')%20=%20'line'</br>\r\n\r\n"
  },
  {
    fileName: '189-How to customize the axis scale value of a gauge chart.md',
    content:
      "# 如何自定义仪表图的刻度值？\n\n## 问题描述\n\nVChart 如何配置仪表图的刻度值？如下图所示，我只想要 0，25，50，75，100。\n\n![description](/vchart/faq/68-0.png)\n\n## 解决方案\n\n可以参照以下 demo，更改仪表图角度轴上的 spec。你可以通过配置轴 tick 的最大最小值和步长来解决问题。\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'gauge',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        {\n          type: 'Target A',\n          value: 60\n        }\n      ]\n    }\n  ],\n  categoryField: 'type',\n  valueField: 'value',\n  outerRadius: 0.8,\n  innerRadius: 0.6,\n  startAngle: -240,\n  endAngle: 60,\n  axes: [\n    {\n      type: 'linear',\n      orient: 'angle',\n      max: 100,\n      min: 0,\n      tick: {\n        visible: true,\n        tickStep: 25\n      },\n      subTick: {\n        visible: true\n      },\n      inside: true\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/68-1.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nDemo page: [https://www.visactor.io/vchart/demo/gauge-chart/basic-gauge](https://www.visactor.io/vchart/demo/gauge-chart/basic-gauge)\n"
  },
  {
    fileName: '190- How to draw a dual-axis chart.md',
    content:
      "---\ntitle: 9. 如何绘制双轴图</br>\n---\r\n## 问题标题\r\n\r\n如何绘制双轴图</br>\r\n## 问题描述\r\n\r\n像这种两个轴的图有什么方法进行绘制？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/NgLhbqTg6opTWpxhvYBcRgE7n0e.gif' alt='' width='1714' height='1322'>\r\n\r\n## 解决方案 \r\n\r\nVChart 中可以添加一个右轴，绑定对应的series实现，参考 demo: https://visactor.io/vchart/demo/combination/dual-axis。</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '周一', type: '早餐', y: 15 },\n        { x: '周一', type: '午餐', y: 25 },\n        { x: '周二', type: '早餐', y: 12 },\n        { x: '周二', type: '午餐', y: 30 },\n        { x: '周三', type: '早餐', y: 15 },\n        { x: '周三', type: '午餐', y: 24 },\n        { x: '周四', type: '早餐', y: 10 },\n        { x: '周四', type: '午餐', y: 25 },\n        { x: '周五', type: '早餐', y: 13 },\n        { x: '周五', type: '午餐', y: 20 },\n        { x: '周六', type: '早餐', y: 10 },\n        { x: '周六', type: '午餐', y: 22 },\n        { x: '周日', type: '早餐', y: 12 },\n        { x: '周日', type: '午餐', y: 19 }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '周一', type: '饮料', y: 22 },\n        { x: '周二', type: '饮料', y: 43 },\n        { x: '周三', type: '饮料', y: 33 },\n        { x: '周四', type: '饮料', y: 22 },\n        { x: '周五', type: '饮料', y: 10 },\n        { x: '周六', type: '饮料', y: 30 },\n        { x: '周日', type: '饮料', y: 50 }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      label: { visible: true },\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: ['x', 'type'],\n      yField: 'y'\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: [0] },\n    { orient: 'right', seriesId: ['line'], grid: { visible: false } },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/CKIlboDljoTXbBx3S1ncaLMpn7e.gif' alt='' width='1260' height='1042'>\r\n\r\nhttps://visactor.io/vchart/demo/combination/dual-axis</br>\r\n## 相关文档\r\n\r\nDemo：https://visactor.io/vchart/demo/combination/dual-axis</br>\r\n教程：</br>\r\n*  组合图： https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination</br>\r\nAPI：</br>\r\n*  组合图：https://visactor.io/vchart/option/commonChart</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '191-How to customize the position of gauge indicator in VChart.md',
    content:
      "# VChart 仪表盘如何自定义标题的显示位置？\n\n## 问题描述\n\n希望标题在仪表盘指针的下方，同时显示两行文字，请问这个怎么配置？  \n![demo](/vchart/faq/20-0.png)\n\n## 解决方案\n\n你可以配置指标卡 `indicator`。指标卡默认显示在图表中间，你可以配置一个 y 方向的偏移量。indicator 也支持多行文本，以及分别设置样式：\n\n```js\nindicator: [\n  {\n    visible: true,\n    title: {\n      style: {\n        text: 'Normal',\n        dy: 100,\n        fill:'rgb(99,110,124)',\n        fontSize: 40,\n        fontWeight: 800\n      }\n    },\n    content: [\n      {\n        visible: true,\n        style: {\n          fontSize: 20,\n          dy: 100,\n          fill:'rgb(193,200,204)',\n          fontWeight: 800,\n          text: 'Quality'\n        }\n      }\n    ]\n  }\n],\n```\n\n## 代码示例\n\n```javascript livedemo\nconst pointerPath =\n  'M-0.020059 -0.978425 C-0.018029 -0.9888053 -0.013378 -1 0 -1 C0.01342 -1 0.01812 -0.989146 0.0201 -0.978425 C0.02161 -0.9702819 0.0692 -0.459505 0.09486 -0.184807 C0.10298 -0.097849 0.1089 -0.034548 0.11047 -0.018339 C0.11698 0.04908 0.07373 0.11111 0.00002 0.11111 C-0.07369 0.11111 -0.117184 0.04991 -0.110423 -0.018339 C-0.103662 -0.086591 -0.022089 -0.9680447 -0.020059 -0.978425Z';\nconst circlePath =\n  'M1 0 C1 0.55228 0.55228 1 0 1 C-0.552285 1 -1 0.55228 -1 0 C-1 -0.552285 -0.552285 -1 0 -1 C0.55228 -1 1 -0.552285 1 0Z';\n\nconst spec = {\n  type: 'gauge',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        {\n          type: '目标A',\n          value: 0.6\n        }\n      ]\n    }\n  ],\n  radiusField: 'type',\n  angleField: 'value',\n  seriesField: 'type',\n  outerRadius: 0.8,\n  innerRadius: 0.7,\n  startAngle: -225,\n  endAngle: 45,\n  indicator: [\n    {\n      visible: true,\n      offsetY: '50%',\n      title: {\n        style: {\n          text: 'Normal',\n          fill: 'rgb(99,110,124)',\n          fontSize: 40,\n          fontWeight: 800\n        }\n      },\n      content: [\n        {\n          visible: true,\n          style: {\n            fontSize: 20,\n            fill: 'rgb(193,200,204)',\n            fontWeight: 800,\n            text: 'Quality'\n          }\n        }\n      ]\n    }\n  ],\n  gauge: {\n    type: 'circularProgress',\n    cornerRadius: 10,\n    progress: {\n      style: {\n        fill: {\n          gradient: 'conical',\n          stops: [\n            {\n              offset: 0,\n              color: '#4FC6B4'\n            },\n            {\n              offset: 1,\n              color: '#31679E'\n            }\n          ]\n        }\n      }\n    },\n    track: {\n      style: {\n        fill: '#ccc'\n      }\n    }\n  },\n  pointer: {\n    width: 0.5,\n    height: 0.5,\n    style: {\n      path: pointerPath,\n      fill: '#5A595E'\n    }\n  },\n  pin: {\n    style: {\n      path: circlePath,\n      fill: '#888'\n    }\n  },\n  pinBackground: {\n    width: 0.08,\n    height: 0.08,\n    style: {\n      path: circlePath,\n      fill: '#ddd'\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [相关教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Indicator)\n- [相关 API](https://visactor.io/vchart/option/gaugeChart#indicator.offsetY)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '192-How can I customize colors based on data values in a map chart.md',
    content:
      "# 地图组件，如何根据数值自定义区块颜色？\n\n## 问题描述\n\n类似 vchart 这样的[填充地图](https://visactor.io/vchart/demo/map-chart/basic-map)，怎么能自定义区块颜色的规则？示例里的配置不太符合我的需求。我希望当值在某个区间，显示一个指定的颜色。\n\n## 解决方案\n\n在 VChart 中，可以通过地图图元样式配置中，填充色（fill）的回调函数来实现你的需求，类似：\n\n```js\nconst colorGroup = [\n  {\n    range: [1, 100],\n    color: 'rgb(252,250,97)'\n  },\n  {\n    range: [101, 200],\n    color: 'rgb(252,150,134)'\n  },\n  {\n    range: [201, 300],\n    color: 'rgb(87,33,15)'\n  }\n];\n\narea: {\n  style: {\n    fill: datum => {\n      const res = colorGroup.find(item => item.range[0] <= +datum.value && item.range[1] >= +datum.value);\n      return res ? res.color : 'WhiteSmoke';\n    };\n  }\n}\n```\n\n## 代码示例\n\n```javascript livedemo\nconst colorGroup = [\n  {\n    range: [1, 100],\n    color: 'rgb(252,250,97)'\n  },\n  {\n    range: [101, 200],\n    color: 'rgb(252,150,134)'\n  },\n  {\n    range: [201, 300],\n    color: 'rgb(87,33,15)'\n  }\n];\nconst spec = {\n  type: 'map',\n  data: [\n    {\n      values: [\n        {\n          name: 'Alabama',\n          value: 0\n        },\n        {\n          name: 'Alaska',\n          value: 140\n        },\n        {\n          name: 'Arizona',\n          value: 39\n        },\n        {\n          name: 'Arkansas',\n          value: 62\n        },\n        {\n          name: 'California',\n          value: 235\n        },\n        {\n          name: 'Colorado',\n          value: 49\n        },\n        {\n          name: 'Connecticut',\n          value: 137\n        },\n        {\n          name: 'Delaware',\n          value: 149\n        },\n        {\n          name: 'District of Columbia',\n          value: 285\n        },\n        {\n          name: 'Florida',\n          value: 198\n        },\n        {\n          name: 'Georgia',\n          value: 53\n        },\n        {\n          name: 'Hawaii',\n          value: 41\n        },\n        {\n          name: 'Idaho',\n          value: 82\n        },\n        {\n          name: 'Illinois',\n          value: 240\n        },\n        {\n          name: 'Indiana',\n          value: 273\n        },\n        {\n          name: 'Iowa',\n          value: 101\n        },\n        {\n          name: 'Kansas',\n          value: 215\n        },\n        {\n          name: 'Kentucky',\n          value: 41\n        },\n        {\n          name: 'Louisiana',\n          value: 37\n        },\n        {\n          name: 'Maine',\n          value: 107\n        },\n        {\n          name: 'Maryland',\n          value: 62\n        },\n        {\n          name: 'Massachusetts',\n          value: 61\n        },\n        {\n          name: 'Michigan',\n          value: 134\n        },\n        {\n          name: 'Minnesota',\n          value: 241\n        },\n        {\n          name: 'Mississippi',\n          value: 259\n        },\n        {\n          name: 'Missouri',\n          value: 144\n        },\n        {\n          name: 'Montana',\n          value: 92\n        },\n        {\n          name: 'Nebraska',\n          value: 117\n        },\n        {\n          name: 'Nevada',\n          value: 24\n        },\n        {\n          name: 'New Hampshire',\n          value: 106\n        },\n        {\n          name: 'New Jersey',\n          value: 147\n        },\n        {\n          name: 'New Mexico',\n          value: 77\n        },\n        {\n          name: 'New York',\n          value: 47\n        },\n        {\n          name: 'North Carolina',\n          value: 260\n        },\n        {\n          name: 'North Dakota',\n          value: 223\n        },\n        {\n          name: 'Ohio',\n          value: 283\n        },\n        {\n          name: 'Oklahoma',\n          value: 85\n        },\n        {\n          name: 'Oregon',\n          value: 31\n        },\n        {\n          name: 'Pennsylvania',\n          value: 65\n        },\n        {\n          name: 'Rhode Island',\n          value: 68\n        },\n        {\n          name: 'South Carolina',\n          value: 216\n        },\n        {\n          name: 'South Dakota',\n          value: 12\n        },\n        {\n          name: 'Tennessee',\n          value: 128\n        },\n        {\n          name: 'Texas',\n          value: 198\n        },\n        {\n          name: 'Utah',\n          value: 93\n        },\n        {\n          name: 'Vermont',\n          value: 66\n        },\n        {\n          name: 'Virginia',\n          value: 167\n        },\n        {\n          name: 'Washington',\n          value: 47\n        },\n        {\n          name: 'West Virginia',\n          value: 170\n        },\n        {\n          name: 'Wisconsin',\n          value: 20\n        },\n        {\n          name: 'Wyoming',\n          value: 203\n        }\n      ]\n    }\n  ],\n  area: {\n    style: {\n      fill: datum => {\n        const res = colorGroup.find(item => item.range[0] <= +datum.value && item.range[1] >= +datum.value);\n        return res ? res.color : 'WhiteSmoke';\n      }\n    }\n  },\n  nameField: 'name',\n  valueField: 'value',\n  nameProperty: 'name',\n  map: 'usa',\n  region: [\n    {\n      roam: true,\n      projection: {\n        type: 'albersUsa'\n      }\n    }\n  ]\n};\n\nconst response = await fetch('https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/geojson/usa.json');\nconst geojson = await response.json();\nVChart.registerMap('usa', geojson);\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [更多 demo](https://visactor.io/vchart/demo/map-chart/basic-map?keyword=map)\n- [地图教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Types/Map)\n- [相关 api](https://visactor.io/vchart/option/mapChart#area.style)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '193-How to clear charts and data.md',
    content:
      "# 如何清空图表和数据？\n\n## 问题描述\n\n请问下有 api 能清空一个已经 render 的图表吗？期望清空图表中的图形，但是保留轴等组件。\n\n## 解决方案\n\n在 VChart 中，如果你想要清空整个图表可以直接调用图表实例的 `release` 方法。如果想要只清空图表的图形，但是保留轴等组件，可以使用 `updateData` 方法将数据设置为空，如下：\n\n```ts\n// 假设你的数据 id 为 'data'\nvchart.updateData('data', []);\n```\n\n## 结果展示\n\n在线效果参考：[https://codesandbox.io/s/clear-mark-4s75yy](https://codesandbox.io/s/clear-mark-4s75yy)\n\n## 相关文档\n\n- [图表 API](https://www.visactor.io/vchart/api/API/vchart)\n\n* [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '194-How to customize the text content of the legend.md',
    content:
      "# 如何自定义图例的文本内容？\n\n## 问题描述\n\n如下如所示，怎么把图中的 “x” 换成商品点击量？\n\n![](/vchart/faq/91-0.png)\n\n## 解决方案\n\n这个对应的是图表中的图例部分，不同的图表库解决方案不同，下面介绍下 VChart 上的配置，在 VChart 上图例对应 `legends` 属性，“x” 对应的是图例项上的 label 文本，对应的属性为 `legends.item.label`，然后我们可以通过该属性提供的 `formatMethod` 属性对显示文本进行格式化。\n\n![](/vchart/faq/91-1.png)\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'line',\n  data: [\n    {\n      id: 'line',\n      fields: { y: { alias: '商品点击量' }, x: { alias: 'shijian' } },\n      values: [\n        { x: '2:00', y: 8 },\n        { x: '4:00', y: 9 },\n        { x: '6:00', y: 11 },\n        { x: '8:00', y: 14 },\n        { x: '10:00', y: 16 },\n        { x: '12:00', y: 17 },\n        { x: '14:00', y: 17 },\n        { x: '16:00', y: 16 },\n        { x: '18:00', y: 15 }\n      ]\n    }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom',\n    item: {\n      label: {\n        formatMethod: text => '商品点击量'\n      }\n    }\n  },\n\n  xField: 'x',\n  yField: 'y'\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [图例教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend)\n- [图例配置](https://www.visactor.io/vchart/option/lineChart#legends-discrete.type)\n"
  },
  {
    fileName: '195- How to display all labels on the x-axis.md',
    content:
      "---\ntitle: 36. 如何令x轴的标签全部展示</br>\n---\r\n## 问题标题\r\n\r\n如何令x轴的标签全部展示</br>\r\n## 问题描述\r\n\r\n请问图表x轴的这些文本为什么会有部分不展示，如果想展示出来的话要怎么做呢？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/B1Jgbos9YoyOZ0xp7fActQL2nlz.gif' alt='' width='471' height='490'>\r\n\r\n## 解决方案 \r\n\r\nVChart 中离散的下轴会默认使用一个基于标签宽度的采样算法。所以当可能出现标签重叠时，按照策略隐藏部分标签。相关的配置项如下：</br>\r\n```\naxes: {\n    sampling: boolean // 是否进行采样\n}</br>\n```\r\n当关闭采样之后，为了展示效果优化，我们还有一组针对图形的防重叠策略。配置项如下</br>\r\n```\nexport interface AxisLabelOverlap {\n    autoRotate?: boolean; // 是否自动旋转。配置为true后，当标签展示空间不够时，会尝试旋转\n    autoRotateAngle?: number[]; // 触发自动旋转后，尝试旋转的角度\n    autoHide?: boolean; // 是否自动隐藏\n    autoHideMethod?: 'parity' | 'greedy' | CustomMethod; // 自动隐藏的策略\n    ...others\n}\n\naxes: {\n    label: {\n        ...AxisLabelOverlap\n    }\n}</br>\n```\r\n所以可以配置以下2个内容：</br>\r\n1. 设置 sampling：false 来强行展示全部标签</br>\r\n1. 设置防重叠策略。比如自动旋转，通过旋转来展示更多的标签，如果不是特别密集的话，能使全部标签都展示出来</br>\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: 'Stacked line chart'\n  },\n  stack: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  axes: [{\n    orient: 'bottom',\n    sampling: false,\n    label: {\n      autoRotate: true,\n      autoRotateAngle: [45,90]\n    }\n  }],\n  lineLabel: { visible: true },\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/QCKobhn5QolLHmxZIdncFjiHnWe.gif' alt='' width='979' height='545'>\r\n\r\nDemo: https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-n5653c?file=%2Fsrc%2Findex.js%3A14%2C18</br>\r\n## 相关文档\r\n\r\nDemo：https://codesandbox.io/p/sandbox/vchart-disabletriggerevent-forked-n5653c?file=%2Fsrc%2Findex.js%3A14%2C18</br>\r\n教程：</br>\r\n*  初始化VChart： https://visactor.io/vchart/api/API/vchart</br>\r\n*  轴采样：https://www.visactor.io/vchart/option/barChart-axes-band#sampling</br>\r\n*  轴标签防重叠：https://www.visactor.io/vchart/option/barChart-axes-band#label.autoRotate</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '196-How to customize legend shapes.md',
    content:
      "---\ntitle: 25. 如何自定义图例形状</br>\n---\r\n## 问题标题\r\n\r\n如何自定义图例形状</br>\r\n## 问题描述\r\n\r\n图例形状默认是圆角矩形，请问如何自定义图例的形状？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/Fl7FbLGe6o8pPNxn6NGcfbOXnxh.gif' alt='' width='1312' height='1106'>\r\n\r\n## 解决方案 \r\n\r\nVChart 中可以用通过配置来设置图例的形状</br>\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.6,\n  valueField: 'value',\n  categoryField: 'type',\n  pie: {\n    style: {\n      cornerRadius: 10\n    },\n    state: {\n      hover: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      },\n      selected: {\n        outerRadius: 0.85,\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  title: {\n    visible: true,\n    text: 'Statistics of Surface Element Content'\n  },\n  legends: {\n    visible: true,\n    orient: 'left',\n    item: {\n      shape: {\n        style: {\n          symbolType: 'star'\n        }\n      }\n    }\n  },\n  label: {\n    visible: true\n  },\n  tooltip: {\n    mark: {\n      content: [\n        {\n          key: datum => datum['type'],\n          value: datum => datum['value'] + '%'\n        }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/DSQFbD4bXom0v1xPDmnc8Spin6T.gif' alt='' width='2332' height='950'>\r\n\r\nDemo: https://codesandbox.io/p/sandbox/pie-legends-shap-6tq5k9?file=%2Fsrc%2Findex.ts%3A69%2C7</br>\r\n## 相关文档\r\n\r\nDemo：https://codesandbox.io/p/sandbox/pie-legends-shap-6tq5k9?file=%2Fsrc%2Findex.ts%3A69%2C7</br>\r\nAPI：</br>\r\n*  图例形状：https://visactor.io/vchart/option/pieChart-legends-discrete#item.shape.style.symbolType</br>\r\nGithub：https://github.com/VisActor/VChart/</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '197- How to configure animations in VChart combination charts.md',
    content:
      "---\ntitle: 85. VChart  组合图中如何配置动画？</br>\n---\r\n## 问题标题\r\n\r\nVChart  的组合图如何配置动画？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n双轴图中，如何让左右轴按照顺序执行动画，左轴的柱执行完之后，右轴的线再播动画？</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JgeObrt6UoM9zPxhrfZcPxbDn0g.gif' alt='' width='823' height='518'>\r\n\r\n## 解决方案\r\n\r\n首先，在 VChart 中可以在每个 series 内配置它的动画。我们可以在柱子和线中分别配置动画。</br>\r\n然后系列中出场动画有一个专门配置：animationAppear </br>\r\n```\nanimationAppear?: {\n  preset?: Preset | false;\n  duration?: number;\n  delay?: number;\n  easing?: EasingType;\n  oneByOne?: boolean;\n};</br>\n```\r\n我们可以在线的动画上配置delay，令它在柱完成动画后再开始播放出场动画</br>\r\n```\nseries: [{\n      type: 'bar',\n      id: 'bar',\n      animationAppear: {\n        duration: 500\n      }\n    },\n    {\n      type: 'line',\n      id: 'line',\n      animationAppear: {\n        delay: 500,\n      }\n    }\n]</br>\n```\r\n另外如果在柱图动画上配置了 `oneByOne`，需要注意这时柱图的动画总时长 = `x轴数量` * `duration`</br>\r\n\r\n\r\n## 代码示例 \r\n\r\n```\nconst spec = {\n  type: 'common',\n  seriesField: 'color',\n  data: [\n    {\n      id: 'id0',\n      values: [\n        { x: '周一', type: '早餐', y: 15 },\n        { x: '周一', type: '午餐', y: 25 },\n        { x: '周二', type: '早餐', y: 12 },\n        { x: '周二', type: '午餐', y: 30 },\n        { x: '周三', type: '早餐', y: 15 },\n        { x: '周三', type: '午餐', y: 24 },\n        { x: '周四', type: '早餐', y: 10 },\n        { x: '周四', type: '午餐', y: 25 },\n        { x: '周五', type: '早餐', y: 13 },\n        { x: '周五', type: '午餐', y: 20 },\n        { x: '周六', type: '早餐', y: 10 },\n        { x: '周六', type: '午餐', y: 22 },\n        { x: '周日', type: '早餐', y: 12 },\n        { x: '周日', type: '午餐', y: 19 }\n      ]\n    },\n    {\n      id: 'id1',\n      values: [\n        { x: '周一', type: '饮料', y: 22 },\n        { x: '周二', type: '饮料', y: 43 },\n        { x: '周三', type: '饮料', y: 33 },\n        { x: '周四', type: '饮料', y: 22 },\n        { x: '周五', type: '饮料', y: 10 },\n        { x: '周六', type: '饮料', y: 30 },\n        { x: '周日', type: '饮料', y: 50 }\n      ]\n    }\n  ],\n  series: [\n    {\n      type: 'bar',\n      id: 'bar',\n      dataIndex: 0,\n      label: { visible: true },\n      seriesField: 'type',\n      dataIndex: 0,\n      xField: ['x', 'type'],\n      yField: 'y',\n      animationAppear: {\n        duration: 500, \n        oneByOne: true\n      }\n    },\n    {\n      type: 'line',\n      id: 'line',\n      dataIndex: 1,\n      label: { visible: true },\n      seriesField: 'type',\n      xField: 'x',\n      yField: 'y',\n      stack: false,\n      animationAppear: {\n        delay: 500 * 7,\n        duration: 500,\n        oneByOne: true\n      }\n    }\n  ],\n  axes: [\n    { orient: 'left', seriesIndex: [0] },\n    { orient: 'right', seriesId: ['line'], grid: { visible: false } },\n    { orient: 'bottom', label: { visible: true }, type: 'band' }\n  ],\n  legends: {\n    visible: true,\n    orient: 'bottom'\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/JAatb6LFyoPMvix2BGocZP73nvh.gif' alt='' width='834' height='478'>\r\n\r\n## 相关文档\r\n\r\n*  动画教程：https://www.visactor.io/vchart/guide/tutorial_docs/Animation/Animation_Types</br>\r\n*  相关 demo：https://www.visactor.io/vchart/demo/storytelling/bar-oneByOne-series</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '198- How to set the shape type of Legend and Tooltip in VChart line charts.md',
    content:
      '---\ntitle: 96. VChart 如何设置折线图的Legend和Tooltip的形状类型?</br>\n---\r\n## 问题标题\r\n\r\n如何设置折线图的Legend和Tooltip的形状类型?</br>\r\n## 问题描述\r\n\r\n折线图默认的图例形状和Tooltip内的默认形状都是圆形, 如何修改其样式?</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart 的`tooltip`组件和`legend`组件提供了控制图标形状的功能.</br>\r\n`legend`的图标是标准图元可以通过`shape.style`配置形状和样式. </br>\r\n`tooltip`提供了类似提供常用的图标样式, 由于`tooltip`存在html、canvas实现, 支持的功能略少.</br>\r\n\r\n\r\n支持的`shape`包括:</br>\r\n`\'circle\'`, `\'cross\'`, `\'diamond\'`, `\'square\'`, `\'arrow\'`, `\'arrow2Left\'`, `\'arrow2Right\'`, `\'wedge\'`, `\'thinTriangle\'`, `\'triangle\'`, `\'triangleUp\'`, `\'triangleDown\'`, `\'triangleRight\'`, `\'triangleLeft\'`, `\'stroke\'`, `\'star\'`, `\'wye\'`, `\'rect\'`, `\'arrowLeft\'`,`\'arrowRight\'`, `\'rectRound\'`, `\'roundLine\'`</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "line",\n      data: {\n        values: [\n          {\n            medalType: "Gold Medals",\n            count: 40,\n            year: "1952",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 32,\n            year: "1956",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 34,\n            year: "1960",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 36,\n            year: "1964",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 45,\n            year: "1968",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 33,\n            year: "1972",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 34,\n            year: "1976",\n          },\n          {\n            medalType: "Gold Medals",\n            count: null,\n            year: "1980",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 83,\n            year: "1984",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 36,\n            year: "1988",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 37,\n            year: "1992",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 44,\n            year: "1996",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 37,\n            year: "2000",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 35,\n            year: "2004",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 36,\n            year: "2008",\n          },\n          {\n            medalType: "Gold Medals",\n            count: 46,\n            year: "2012",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 19,\n            year: "1952",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 25,\n            year: "1956",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 21,\n            year: "1960",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 26,\n            year: "1964",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 28,\n            year: "1968",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 31,\n            year: "1972",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 35,\n            year: "1976",\n          },\n          {\n            medalType: "Silver Medals",\n            count: null,\n            year: "1980",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 60,\n            year: "1984",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 31,\n            year: "1988",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 34,\n            year: "1992",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 32,\n            year: "1996",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 24,\n            year: "2000",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 40,\n            year: "2004",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 38,\n            year: "2008",\n          },\n          {\n            medalType: "Silver Medals",\n            count: 29,\n            year: "2012",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 17,\n            year: "1952",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 17,\n            year: "1956",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 16,\n            year: "1960",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 28,\n            year: "1964",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 34,\n            year: "1968",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 30,\n            year: "1972",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 25,\n            year: "1976",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: null,\n            year: "1980",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 30,\n            year: "1984",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 27,\n            year: "1988",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 37,\n            year: "1992",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 25,\n            year: "1996",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 33,\n            year: "2000",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 26,\n            year: "2004",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 36,\n            year: "2008",\n          },\n          {\n            medalType: "Bronze Medals",\n            count: 29,\n            year: "2012",\n          },\n        ],\n      },\n      xField: "year",\n      yField: "count",\n      seriesField: "medalType",\n      invalidType: "link",\n      tooltip: {\n        dimension: {\n          shapeType: "roundLine",\n        },\n      },\n      legends: {\n        visible: true,\n        type: "discrete",\n        item: {\n          shape: {\n            style: {\n              symbolType: "roundLine",\n            },\n          },\n        },\n      },\n    };\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart" style={{ width: 400 }}></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示\r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-pie-ordinal-color-forked-4qxnzf</br>\r\n## 相关文档\r\n\r\nLegend Shape API: https://visactor.io/vchart/option/lineChart-legends-discrete#item.shape.style.symbolType</br>\r\nTooltip Shape API: https://visactor.io/vchart/option/lineChart#tooltip.dimension.shapeType</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName: '199-Can users click on data points within the VChart to show a list of actions.md',
    content:
      "# VChart 图表点击数据点，展示操作列表？\n\n## 问题描述\n\n类似这个截图里的效果，如何实现点击图表中的一个数据点，能够展示出一个操作的列表？\n\n![tooltip](/vchart/faq/42-0.png)\n\n## 解决方案\n\n通过 VChart 图表的事件交互可以实现这个功能\n\n1. 注册图表元素的点击事件\n2. 通过事件回调参数可以拿到点击事件的信息，例如事件坐标等\n3. 渲染一个菜单，菜单中添加你需要响应的操作\n\n## 代码示例\n\n```javascript\nvchart.on('pointerdown', { level: 'mark' }, ({ event }) => {\n  // show your menu\n  event.preventDefault();\n  menu.style.display = 'block';\n  menu.style.left = `${event.pageX}px`;\n  menu.style.top = `${event.pageY}px`;\n});\n```\n\n## 结果展示\n\n![demo](/vchart/faq/42-1.png)\n\nDemo: [https://codesandbox.io/s/click-menu-m42d9j](https://codesandbox.io/s/click-menu-m42d9j)\n\n## 相关文档\n\nEvent option: [https://visactor.io/vchart/api/API/event](https://visactor.io/vchart/api/API/event)\n\nEvent tutorials: [https://visactor.io/vchart/guide/tutorial_docs/Event](https://visactor.io/vchart/guide/tutorial_docs/Event)\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '200-When hovering over a donut chart, how to configure the style of donut chart.md',
    content:
      "# 环形图 hover 的时候，如何配置边框的样式？\n\n## 问题描述\n\n环形图的交互中，当指针悬停在环形图的扇区上时，如何改变扇区的边框颜色、边框粗细、调整扇区的半径大小以及改变扇区的填充透明度？\n除此之外，如何处理其他扇区，即非悬停状态下的扇区的样式？\n\n## 解决方案\n\nVChart 图表已经提供了对应的功能，VChart 对图元上的各种常用交互抽象为了图元的状态，将图元的状态分为了以下几种：\n\n- `hover` 指针悬浮状态，图元被鼠标指针悬浮时的状态。\n- `hover_reverse` 非指针悬浮状态，当有图元进入了 `hover` 状态时，其他图元的状态。\n- `selected` 选中状态，图元被选中时的状态。\n- `selected_reverse` 非选中状态，当有图元进入了 `selected` 状态时，其他图元的状态。\n- `dimension_hover` 维度悬浮状态，鼠标指针悬浮在某一段 x 轴区域内时的状态。\n- `dimension_hover_reverse` 非维度悬浮状态，当有图元进入了 `dimension_hover` 状态时，其他图元的状态。\n\n如果想要 hover 到环形图时，改变图元的样式，可以在 pie 配置中，设置图元的 hover 状态。\n[参考文档：图元的状态](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Mark)\n\n## 代码示例\n\n在以下示例中，`pie.state` 中设置了 4 个状态\n\n1. `hover`: 指针悬浮到的图元， 显示描边，填充透明度变低，扩展外半径。\n2. `hover_reverse`：其它未悬浮到的图元，缩小外半径。\n3. `selected`：指针选中的图元，扩大内半径和外半径。\n4. `selected_reverse`：其它未选中的图元，填充透明度变低。\n\n```javascript livedemo\nconst spec = {\n  type: 'pie',\n  data: [\n    {\n      id: 'data',\n      values: [\n        { type: 'oxygen', value: '46.60' },\n        { type: 'silicon', value: '27.72' },\n        { type: 'aluminum', value: '8.13' },\n        { type: 'iron', value: '5' },\n        { type: 'calcium', value: '3.63' },\n        { type: 'sodium', value: '2.83' },\n        { type: 'potassium', value: '2.59' },\n        { type: 'others', value: '3.5' }\n      ]\n    }\n  ],\n  valueField: 'value',\n  categoryField: 'type',\n  outerRadius: 0.8,\n  innerRadius: 0.5,\n  padAngle: 0.5,\n  pie: {\n    state: {\n      hover: {\n        stroke: '#0FF',\n        lineWidth: 1,\n\n        fillOpacity: 0.9,\n        outerRadius: 0.85\n      },\n      hover_reverse: {\n        outerRadius: 0.7,\n        innerRadius: 0.5\n      },\n      selected: {\n        outerRadius: 0.85,\n        innerRadius: 0.6\n      },\n      selected_reverse: {\n        fillOpacity: 0.25\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [图元状态教程](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Mark)\n- [图表示例](https://visactor.io/vchart/demo/pie-chart/ring?keyword=pieChart)\n"
  },
  {
    fileName: '201-How to configure the scope of the crosshair auxiliary line.md',
    content:
      "# 组合图中，如何配置十字辅助线的作用范围，在某一个子图内，或者作用于整个组合图表？\n\n## 问题描述\n\n![](/vchart/faq/87-0.png)\n\n请问一下，十字辅助线有办法在透视组合图的所有子表都显示吗？\n\n## 解决方案\n\n在 VChart 上，crosshair 是支持这种能力的，只需要为对应方向的 crosshair 声明其绑定的轴索引，如果没有声明，则会默认绑定所有同 crosshair 位置相对应的轴。\n\n如下图所致，我们期望 y 轴上的 crosshair 作用于整个图，只需要声明如下配置即可\n\n![](/vchart/faq/87-1.png)\n\n如果你想做作用于某个子图内，也只需要配置 `bindingAxesIndex` 为该子图对应的轴索引即可。\n\n![](/vchart/faq/87-2.png)\n\n## 结果展示\n\n```javascript livedemo\nconst data = [\n  { region: 'Central', state: 'North Dakota', sales: 920 },\n  { region: 'Central', state: 'South Dakota', sales: 1317 },\n  { region: 'Central', state: 'Kansas', sales: 2916 },\n  { region: 'Central', state: 'Iowa', sales: 4577 },\n  { region: 'Central', state: 'Nebraska', sales: 7464 },\n  { region: 'Central', state: 'Oklahoma', sales: 19686 },\n  { region: 'Central', state: 'Missouri', sales: 22207 },\n  { region: 'Central', state: 'Minnesota', sales: 29865 },\n  { region: 'Central', state: 'Wisconsin', sales: 32125 },\n  { region: 'Central', state: 'Indiana', sales: 53549 },\n  { region: 'Central', state: 'Michigan', sales: 76281 },\n  { region: 'Central', state: 'Illinois', sales: 80162 },\n  { region: 'Central', state: 'Texas', sales: 170187 },\n  { region: 'East', state: 'West Virginia', sales: 1209 },\n  { region: 'East', state: 'Maine', sales: 1270 },\n  { region: 'East', state: 'District of Columbia', sales: 2866 },\n  { region: 'East', state: 'New Hampshire', sales: 7294 },\n  { region: 'East', state: 'Vermont', sales: 8929 },\n  { region: 'East', state: 'Connecticut', sales: 13386 },\n  { region: 'East', state: 'Rhode Island', sales: 22629 },\n  { region: 'East', state: 'Maryland', sales: 23707 },\n  { region: 'East', state: 'Delaware', sales: 27453 },\n  { region: 'East', state: 'Massachusetts', sales: 28639 },\n  { region: 'East', state: 'New Jersey', sales: 35763 },\n  { region: 'East', state: 'Ohio', sales: 78253 },\n  { region: 'East', state: 'Pennsylvania', sales: 116522 },\n  { region: 'East', state: 'New York', sales: 310914 },\n  { region: 'South', state: 'South Carolina', sales: 8483 },\n  { region: 'South', state: 'Louisiana', sales: 9219 },\n  { region: 'South', state: 'Mississippi', sales: 10772 },\n  { region: 'South', state: 'Arkansas', sales: 11678 },\n  { region: 'South', state: 'Alabama', sales: 19511 },\n  { region: 'South', state: 'Tennessee', sales: 30662 },\n  { region: 'South', state: 'Kentucky', sales: 36598 },\n  { region: 'South', state: 'Georgia', sales: 49103 },\n  { region: 'South', state: 'North Carolina', sales: 55604 },\n  { region: 'South', state: 'Virginia', sales: 70641 },\n  { region: 'South', state: 'Florida', sales: 89479 },\n  { region: 'West', state: 'Wyoming', sales: 1603 },\n  { region: 'West', state: 'Idaho', sales: 4380 },\n  { region: 'West', state: 'New Mexico', sales: 4779 },\n  { region: 'West', state: 'Montana', sales: 5589 },\n  { region: 'West', state: 'Utah', sales: 11223 },\n  { region: 'West', state: 'Nevada', sales: 16729 },\n  { region: 'West', state: 'Oregon', sales: 17431 },\n  { region: 'West', state: 'Colorado', sales: 32110 },\n  { region: 'West', state: 'Arizona', sales: 35283 },\n  { region: 'West', state: 'Washington', sales: 138656 },\n  { region: 'West', state: 'California', sales: 457731 }\n];\n\nconst centralData = data.filter(obj => obj.region === 'Central').sort((a, b) => a.sales - b.sales);\nconst eastData = data.filter(obj => obj.region === 'East').sort((a, b) => a.sales - b.sales);\nconst westData = data.filter(obj => obj.region === 'West').sort((a, b) => a.sales - b.sales);\nconst southData = data.filter(obj => obj.region === 'South').sort((a, b) => a.sales - b.sales);\n\n// Get the default color palette\nconst defaultColorScheme = VChart.ThemeManager.getCurrentTheme().colorScheme?.default?.dataScheme?.[0]?.scheme;\n\nconst spec = {\n  type: 'common',\n  layout: {\n    type: 'grid',\n    col: 3,\n    row: 5,\n    elements: [\n      {\n        modelId: 'legend',\n        col: 2,\n        row: 0,\n        rowSpan: 5\n      },\n      {\n        modelId: 'centralLeftAxis',\n        col: 0,\n        row: 0\n      },\n      {\n        modelId: 'southLeftAxis',\n        col: 0,\n        row: 1\n      },\n      {\n        modelId: 'eastLeftAxis',\n        col: 0,\n        row: 2\n      },\n      {\n        modelId: 'westLeftAxis',\n        col: 0,\n        row: 3\n      },\n      {\n        modelId: 'central',\n        col: 1,\n        row: 0\n      },\n      {\n        modelId: 'south',\n        col: 1,\n        row: 1\n      },\n      {\n        modelId: 'east',\n        col: 1,\n        row: 2\n      },\n      {\n        modelId: 'west',\n        col: 1,\n        row: 3\n      },\n      {\n        modelId: 'bottomAxis',\n        col: 1,\n        row: 4\n      }\n    ]\n  },\n  region: [\n    {\n      id: 'central',\n      style: {\n        stroke: [defaultColorScheme[0], false, false, false],\n        lineWidth: 1\n      }\n    },\n    {\n      id: 'south',\n      style: {\n        stroke: [defaultColorScheme[1], false, false, false],\n        lineWidth: 1\n      }\n    },\n    {\n      id: 'east',\n      style: {\n        stroke: [defaultColorScheme[2], false, false, false],\n        lineWidth: 1\n      }\n    },\n    {\n      id: 'west',\n      style: {\n        stroke: [defaultColorScheme[3], false, false, false],\n        lineWidth: 1\n      }\n    }\n  ],\n  legends: {\n    visible: true,\n    orient: 'right',\n    position: 'top',\n    id: 'legend',\n    regionId: ['central', 'south', 'east', 'west'],\n    item: {\n      background: {\n        visible: false\n      },\n      label: {\n        formatMethod: (label, datum, index) => {\n          return ['central', 'south', 'east', 'west'][index];\n        }\n      }\n    },\n    interactive: false, // Turn off legend interaction\n    padding: {\n      top: 0,\n      left: 20\n    }\n  },\n  series: [\n    {\n      id: 'centralSeriesO',\n      regionId: 'central',\n      type: 'bar',\n      data: {\n        id: 'central',\n        values: centralData\n      },\n      direction: 'horizontal',\n      xField: 'sales',\n      yField: 'state'\n    },\n    {\n      id: 'southSeries0',\n      regionId: 'south',\n      type: 'bar',\n      data: {\n        id: 'south',\n        values: southData\n      },\n      direction: 'horizontal',\n      xField: 'sales',\n      yField: 'state'\n    },\n    {\n      id: 'eastSeries0',\n      regionId: 'east',\n      type: 'bar',\n      data: {\n        id: 'east',\n        values: eastData\n      },\n      direction: 'horizontal',\n      xField: 'sales',\n      yField: 'state'\n    },\n    {\n      id: 'westSeries0',\n      regionId: 'west',\n      type: 'bar',\n      data: {\n        id: 'west',\n        values: westData\n      },\n      direction: 'horizontal',\n      xField: 'sales',\n      yField: 'state'\n    }\n  ],\n  axes: [\n    {\n      grid: {\n        visible: 1,\n        style: {\n          lineDash: [1, 0]\n        }\n      },\n      id: 'centralLeftAxis',\n      regionId: 'central',\n      seriesId: ['centralSeriesO'],\n      orient: 'left',\n      type: 'band'\n    },\n    {\n      grid: {\n        visible: 1,\n        style: {\n          lineDash: [1, 0]\n        }\n      },\n      id: 'southLeftAxis',\n      regionId: 'south',\n      seriesId: ['southSeries0'],\n      orient: 'left',\n      type: 'band'\n    },\n    {\n      grid: {\n        visible: 1,\n        style: {\n          lineDash: [1, 0]\n        }\n      },\n      id: 'eastLeftAxis',\n      regionId: 'east',\n      seriesId: ['eastSeries0'],\n      orient: 'left',\n      type: 'band'\n    },\n    {\n      grid: {\n        visible: 1,\n        style: {\n          lineDash: [1, 0]\n        }\n      },\n      id: 'westLeftAxis',\n      regionId: 'west',\n      seriesId: ['westSeries0'],\n      orient: 'left',\n      type: 'band'\n    },\n    {\n      id: 'bottomAxis',\n      regionId: ['central', 'south', 'east', 'west'],\n      orient: 'bottom',\n      type: 'linear',\n      tick: {\n        visible: false\n      },\n      grid: {\n        visible: true,\n        style: {\n          lineDash: [0]\n        }\n      }\n    }\n  ],\n  crosshair: {\n    xField: {\n      visible: true,\n      bindingAxesIndex: [4],\n      line: {\n        visible: true,\n        type: 'line',\n        style: {\n          opacity: 1,\n          lineDash: [2, 2],\n          lineWidth: 1,\n          stroke: '#000'\n        }\n      },\n      label: {\n        visible: true // Default is false\n      }\n    },\n    yField: {\n      bindingAxesIndex: [0, 1, 2, 3],\n      visible: true,\n      line: {\n        visible: true,\n        type: 'line',\n        style: {\n          opacity: 1,\n          lineDash: [2, 2],\n          lineWidth: 1,\n          stroke: '#000'\n        }\n      },\n      label: {\n        visible: true // Default is false\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [Crosshair 教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Crosshair)\n\n- [Crosshair 配置](https://www.visactor.io/vchart/option/commonChart#crosshair.id)\n\n- [组合图教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/Combination)\n\n- [组合图配置](https://www.visactor.io/vchart/option/commonChart#type)\n\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName: '202- Does VChart support setting graphical elements to the selected state.md',
    content:
      "---\ntitle: 84. VChart是否支持将图元设置为选中状态？</br>\n---\r\n## 问题标题\r\n\r\nVChart是否支持将图元设置为选中状态？</br>\r\n## 问题描述\r\n\r\n可以在spec中设置让某个点在不交互时始终处于选中状态吗？</br>\r\n\r\n\r\n## 解决方案 \r\n\r\n直接接通过 spec 设置，不走 state 接口的话可以直接通过通道的自定义函数来设置样式，参数中包含数据信息，根据不同的数据来区分图元是否需要设置为选中状态即可。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/LrnUbIta1o2NVNxTCwBcPeGfnad.gif' alt='' width='3380' height='1636'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'line',\n  data: {\n    values: [\n      { type: 'Nail polish', country: 'Africa', value: 4229 },\n      { type: 'Nail polish', country: 'EU', value: 4376 },\n      { type: 'Nail polish', country: 'China', value: 3054 },\n      { type: 'Nail polish', country: 'USA', value: 12814 },\n      { type: 'Eyebrow pencil', country: 'Africa', value: 3932 },\n      { type: 'Eyebrow pencil', country: 'EU', value: 3987 },\n      { type: 'Eyebrow pencil', country: 'China', value: 5067 },\n      { type: 'Eyebrow pencil', country: 'USA', value: 13012 },\n      { type: 'Rouge', country: 'Africa', value: 5221 },\n      { type: 'Rouge', country: 'EU', value: 3574 },\n      { type: 'Rouge', country: 'China', value: 7004 },\n      { type: 'Rouge', country: 'USA', value: 11624 },\n      { type: 'Lipstick', country: 'Africa', value: 9256 },\n      { type: 'Lipstick', country: 'EU', value: 4376 },\n      { type: 'Lipstick', country: 'China', value: 9054 },\n      { type: 'Lipstick', country: 'USA', value: 8814 },\n      { type: 'Eyeshadows', country: 'Africa', value: 3308 },\n      { type: 'Eyeshadows', country: 'EU', value: 4572 },\n      { type: 'Eyeshadows', country: 'China', value: 12043 },\n      { type: 'Eyeshadows', country: 'USA', value: 12998 },\n      { type: 'Eyeliner', country: 'Africa', value: 5432 },\n      { type: 'Eyeliner', country: 'EU', value: 3417 },\n      { type: 'Eyeliner', country: 'China', value: 15067 },\n      { type: 'Eyeliner', country: 'USA', value: 12321 },\n      { type: 'Foundation', country: 'Africa', value: 13701 },\n      { type: 'Foundation', country: 'EU', value: 5231 },\n      { type: 'Foundation', country: 'China', value: 10119 },\n      { type: 'Foundation', country: 'USA', value: 10342 },\n      { type: 'Lip gloss', country: 'Africa', value: 4008 },\n      { type: 'Lip gloss', country: 'EU', value: 4572 },\n      { type: 'Lip gloss', country: 'China', value: 12043 },\n      { type: 'Lip gloss', country: 'USA', value: 22998 },\n      { type: 'Mascara', country: 'Africa', value: 18712 },\n      { type: 'Mascara', country: 'EU', value: 6134 },\n      { type: 'Mascara', country: 'China', value: 10419 },\n      { type: 'Mascara', country: 'USA', value: 11261 }\n    ]\n  },\n  title: {\n    visible: true,\n    text: 'Stacked line chart'\n  },\n  stack: true,\n  xField: 'type',\n  yField: 'value',\n  seriesField: 'country',\n  line: {\n    style: {\n      curveType: 'monotone'\n    }\n  },\n  point: {\n    style: {\n      size:(datum)=>{\n        return datum.type === 'Rouge' ? 10 : 0\n      },\n      fill: 'white',\n      stroke: null,\n      lineWidth: 2\n    }\n  },\n  legends: [{ visible: true, position: 'middle', orient: 'bottom' }]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://codesandbox.io/p/sandbox/custom-style-gprk5k?file=%2Fsrc%2Findex.ts%3A8%2C21</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/R3I4bIqzLofV9HxTHe0cfPBUn6b.gif' alt='' width='1470' height='944'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n默认选中维度demo: https://www.visactor.io/vchart/demo/line-chart/line-default-select</br>\r\n相关api：https://www.visactor.io/vchart/option/lineChart#point.style</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '203- How to limit the width of tooltip content.md',
    content:
      '---\ntitle: 51. 如何限制 Tootlip 内容宽度？</br>\n---\r\n## 问题标题\r\n\r\n如何限制 Tootlip 内容宽度</br>\r\n## 问题描述\r\n\r\n图表中的数据存在非常长的字符串， 这种场景下， 默认`tooltip`的展示效果并不好， 需要优化其显示效果</br>\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样，VChart 的`tooltip`组件， 提供了对`key`与`value`的自定义配置， 允许用户对图元和维度的提示信息， 进行自定义设置。 </br>\r\n在超长文本场景， 通常情况下只需要使用格式化能力， 对指标进行格式化， 对维度进行缩略显示。</br>\r\n步骤一： 配置`tooltip.mark.content`， 分别对 图元`tooltip`中的`value` 和 `key`进行格式化。</br>\r\n步骤二： 配置`tooltip.dimension.content`， 分别对维度`tooltip`中的`value`和`key`进行格式化。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "bar",\n      data: [\n        {\n          id: "barData",\n          values: [\n            {\n              month: "Monday",\n              sales: 22,\n              type: "LongLong",\n            },\n            { month: "Tuesday", sales: 13, type: "LongLongLongLong" },\n            { month: "Wednesday", sales: 25, type: "LongLongLongLongLongLong" },\n            {\n              month: "Thursday",\n              sales: 29,\n              type: "LongLongLongLongLongLongLongLong",\n            },\n            {\n              month: "Friday",\n              sales: 38,\n              type: "LongLongLongLongLongLongLongLongLongLong",\n            },\n          ],\n        },\n      ],\n      seriesField: "type",\n      xField: "month",\n      yField: "sales",\n      tooltip: {\n        mark: {\n          position: "bottom",\n          content: [\n            {\n              key: (datum) =>\n                datum.type.length < 20\n                  ? datum.type\n                  : datum.type.slice(0, 20) + "...",\n              value: (datum) => datum.sales,\n            },\n          ],\n        },\n        dimension: {\n          visible: false,\n          content: [\n            {\n              key: (datum) =>\n                datum.type.length < 20\n                  ? datum.type\n                  : datum.type.slice(0, 20) + "...",\n              value: (datum) => datum.sales,\n            },\n          ],\n        },\n      },\n    };\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart"></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-large-tooltip-optimize-z5jpdn?file=%2Fsrc%2Findex.js%3A1%2C1-83%2C1</br>\r\n## 相关文档\r\n\r\nTooltip API: https://visactor.io/vchart/option/barChart#tooltip.mark.content(Object%7CObject%5B%5D)</br>\r\nTooltip Demo: https://visactor.io/vchart/demo/tooltip/format-method</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName:
      '204-How to set the color and transparency of individual words inside the word cloud based on their values.md',
    content:
      "# 如何根据数值设定词云里面单个词语的颜色和透明度？\n\n## 问题描述\n\n我是想按照数值来决定单词 opacity 的范围，比如数值越大，透明度越高；另外，我还想根据数值来设定颜色的色值，请问在 VChart 中可以如何配置？\n\n## 解决方案\n\n你可以通过回调函数的方式构建数据 datum 与文字颜色透明度`word.style.fillOpacity`或文字颜色`word.style.fill`之间的映射。\n[wordcloud fill](/vchart/faq/9-0.png)\n\n## 代码示例\n\n```javascript livedemo\nconst response = await fetch('https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/data-wordcloud.json');\nconst dataWordCloud = await response.json();\nconst spec = {\n  type: 'wordCloud',\n  nameField: 'challenge_name',\n  valueField: 'sum_count',\n  seriesField: 'challenge_name',\n  data: {\n    name: 'baseData',\n    values: dataWordCloud\n  },\n  word: {\n    style: {\n      fill: datum => {\n        if (datum['sum_count'] > 100) {\n          return 'red';\n        } else {\n          return 'blue';\n        }\n      },\n      fillOpacity: datum => {\n        return datum['sum_count'] / 100;\n      }\n    }\n  }\n};\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [词云 demo](https://www.visactor.io/vchart/demo/word-cloud-chart/word-cloud-basic)\n- [词云教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Types/WordCloud)\n- [相关 api](https://www.visactor.io/vchart/option/wordCloudChart#word.style)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName:
      '205-How can chart tooltips be configured to display dimensions and measures as single or multiple rows.md',
    content:
      "# 图表 tooltip 如何配置将维度和指标展现成单行或者多行？\n\n## 问题描述\n\nVChart 如何配置以下两种 tooltip 展示效果？\n\n一个是类别（type）、值（y）分别占一行：\n\n![tooltip](/vchart/faq/67-0.png)\n\n一个是类别（type）、值（y）一一对应占一行：\n\n![tooltip](/vchart/faq/67-1.png)\n\n## 解决方案\n\n可以参照以下 demo，更改 tooltip spec。\n\n## 代码示例\n\n类别（type）、值（y）分别占一行：\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  tooltip: {\n    dimension: {\n      content: [\n        { key: 'Category', value: datum => datum.Age },\n        { key: 'Value', value: datum => datum.Population }\n      ]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n一个是类别（type）、值（y）一一对应占一行：\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          State: 'WY',\n          Age: 'Under 5 Years',\n          Population: 25635\n        },\n        {\n          State: 'WY',\n          Age: '5 to 13 Years',\n          Population: 1890\n        },\n        {\n          State: 'WY',\n          Age: '14 to 17 Years',\n          Population: 9314\n        },\n        {\n          State: 'DC',\n          Age: 'Under 5 Years',\n          Population: 30352\n        },\n        {\n          State: 'DC',\n          Age: '5 to 13 Years',\n          Population: 20439\n        },\n        {\n          State: 'DC',\n          Age: '14 to 17 Years',\n          Population: 10225\n        },\n        {\n          State: 'VT',\n          Age: 'Under 5 Years',\n          Population: 38253\n        },\n        {\n          State: 'VT',\n          Age: '5 to 13 Years',\n          Population: 42538\n        },\n        {\n          State: 'VT',\n          Age: '14 to 17 Years',\n          Population: 15757\n        },\n        {\n          State: 'ND',\n          Age: 'Under 5 Years',\n          Population: 51896\n        },\n        {\n          State: 'ND',\n          Age: '5 to 13 Years',\n          Population: 67358\n        },\n        {\n          State: 'ND',\n          Age: '14 to 17 Years',\n          Population: 18794\n        },\n        {\n          State: 'AK',\n          Age: 'Under 5 Years',\n          Population: 72083\n        },\n        {\n          State: 'AK',\n          Age: '5 to 13 Years',\n          Population: 85640\n        },\n        {\n          State: 'AK',\n          Age: '14 to 17 Years',\n          Population: 22153\n        }\n      ]\n    }\n  ],\n  xField: 'State',\n  yField: 'Population',\n  seriesField: 'Age',\n  stack: true,\n  legends: {\n    visible: true\n  },\n  bar: {\n    // The state style of bar\n    state: {\n      hover: {\n        stroke: '#000',\n        lineWidth: 1\n      }\n    }\n  },\n  tooltip: {\n    dimension: {\n      content: [{ key: datum => datum.Age, value: datum => datum.Population }]\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n![demo](/vchart/faq/67-2.png)\n\n![demo](/vchart/faq/67-3.png)\n\n## 相关文档\n\ngithub：[https://github.com/VisActor/VChart](https://github.com/VisActor/VChart)\n\nDemo page: [https://www.visactor.io/vchart/demo/tooltip/custom-tooltip](https://www.visactor.io/vchart/demo/tooltip/custom-tooltip)\n"
  },
  {
    fileName: '206- Can vchart multi-line charts limit the default rendered lines.md',
    content:
      "---\ntitle: 35. vchart多线图能否限制默认渲染的线条？</br>\n---\r\n# 问题标题\r\n\r\nvchart多线图能否限制默认渲染的线条？</br>\r\n\r\n\r\n# 问题描述\r\n\r\n在使用vchart的时候，我碰到了一个问题。我正在制作一个多线图，我想问一下这个多线图可以限制默认渲染的线条吗？比如我只想让它默认渲染一条线条，这个可以实现吗？</br>\r\n\r\n\r\n# 解决方案\r\n\r\n可以实现这个功能。需要使用配置项`legends.defaultSelected`来设置图例初始化时默认选中的图例项。数组中的元素为图例项的 `name`。比如你可以设置`defaultSelected: ['Type D']`，表示默认渲染图例项名为'Type D' 的线条。以下是一个完整的代码示例：</br>\r\n\r\n\r\n```\nconst spec = {\ntype: 'line',\ndata: [\n{\nid: 'line',\nvalues: data\n}\n],\nxField: 'year',\nyField: 'value',\nseriesField: 'name',\nlegends: {\norient: 'right',\nselectMode: 'single', // Configure legend selection mode\ndefaultSelected: ['Type D'],\ntitle: {\nvisible: true,\ntext: 'Single Select'\n}\n},\naxes: [\n{\norient: 'left',\nlabel: {\ninside: true,\nspace: 2,\nstyle: {\ntextBaseline: 'bottom',\ntextAlign: 'start',\nfontWeight: 'bold'\n}\n},\ntick: {\nvisible: false\n},\ndomainLine: {\nvisible: false\n},\ntitle: {\nvisible: true,\ntext: 'Axis Title'\n}\n}\n]\n};</br>\n```\r\n\r\n\r\n# 结果展示\r\n\r\n代码运行后，多线图将默认只渲染出了'Type D'的线条。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/LFf1b3fRho1B0Yx7SLxc122lnRf.gif' alt='' width='1496' height='1048'>\r\n\r\n在线demo：https://codesandbox.io/p/sandbox/line-chart-legend-shape-and-color-forked-gq3gcv</br>\r\n# 相关文档\r\n\r\n*  VChart defaultSelected配置项：https://visactor.bytedance.net/vchart/option/barChart-legends-discrete#defaultSelected</br>\r\n*  VChart github：https://github.com/VisActor/VChart</br>\r\n\r\n"
  },
  {
    fileName: '207- How to trigger chart tooltips on mobile devices.md',
    content:
      '---\ntitle: 47. 如何在移动端触发图表 tooltip？</br>\n---\r\n## 问题标题\r\n\r\n如何在移动端触发图表 tooltip？</br>\r\n## 问题描述\r\n\r\n移动端用户， 要查看图表的 tooltip， 需要在图元处长按， 才能触发。 这样的交互不利于用户使用图表， 更好的形式应该是点击图元时出现 tooltip。</br>\r\n\r\n\r\n## 解决方案 \r\n\r\n不同图表库的解决方案不一样， VChart 的 `tooltip` 提供** **`**trigger**`**配置，**支持 hover 与 click 的触发形式。</br>\r\n在移动端， 可以设置`trigger:true`， 获得更好的交互体验。</br>\r\n此外， 还有`triggerOff` 配置， 控制如何隐藏 tooltip。</br>\r\n## 代码示例  \r\n\r\n```\nimport { StrictMode, useEffect } from "react";\nimport { createRoot } from "react-dom/client";\n\nconst rootElement = document.getElementById("root");\nconst root = createRoot(rootElement);\n\nimport VChart from "@visactor/vchart";\n\nconst App = () => {\n  useEffect(() => {\n    const spec = {\n      type: "bar",\n      data: [\n        {\n          id: "barData",\n          values: [\n            { month: "Monday", sales: 22 },\n            { month: "Tuesday", sales: 13 },\n            { month: "Wednesday", sales: 25 },\n            { month: "Thursday", sales: 29 },\n            { month: "Friday", sales: 38 },\n          ],\n        },\n      ],\n      tooltip: {\n        // hover | click\n        trigger: "click",\n        // hover | click | none\n        triggerOff: "none",\n      },\n      xField: "month",\n      yField: "sales",\n    };\n    const vchart = new VChart(spec, { dom: "chart" });\n    vchart.renderSync();\n\n    return () => {\n      vchart.release();\n    };\n  }, []);\n\n  return <div id="chart"></div>;\n};\n\nroot.render(\n  <StrictMode>\n    <App />\n  </StrictMode>\n);\n</br>\n```\r\n## 结果展示 \r\n\r\nOnline Demo: https://codesandbox.io/p/sandbox/vchart-tooltip-trigger-s6359y</br>\r\n## 相关文档\r\n\r\nVChart Tooltip API: https://visactor.io/vchart/option/barChart#tooltip</br>\r\nGithub: https://github.com/VisActor/VChart</br>'
  },
  {
    fileName:
      '208-How to configure the position of the markLine text label, can it be configured to display at the starting point, end point or in the middle of the line segment.md',
    content:
      "# 如何配置 MarkLine 文字标签的位置，可以配置显示在线起点、终点或者线段中间？\n\n## 问题描述\n\n类似 （https://www.visactor.io/vchart/demo/marker/mark-line-basic）这样的使用了markLine做轴空间定位的图表，\n想要实现 markLine 中的 label 显示在线的起点、线的终点或者线段中间，该如何实现？\n\n## 解决方案\n\n不同图表库的解决方案不一样，根据你给的 demo，只需要将配置 markLine.label.position 为所需场景。\n\n- markLine.label.position 用来配置标注线的标签位置（标签相对线的相对位置）。\n  - 当文字标签显示在线的起点时，可配置 position 为'start'\n  - 当文字标签显示在线的终点时，可配置 position 为'end'\n  - 当文字标签显示在线段中间时，可配置 position 为'middle'\n\n## 代码示例\n\n```javascript livedemo\nconst spec = {\n  type: 'scatter',\n  padding: [12, 20, 12, 12],\n  xField: 'x',\n  yField: 'y',\n  sizeField: 'z',\n  size: {\n    type: 'linear',\n    range: [20, 80]\n  },\n  axes: [\n    { orient: 'bottom', type: 'linear', min: 60, max: 95 },\n    { orient: 'left', type: 'linear', min: 0, max: 200 }\n  ],\n  point: {\n    style: {\n      fillOpacity: 0.25,\n      lineWidth: 1,\n      stroke: '#6690F2',\n      fill: '#6690F2'\n    }\n  },\n  label: {\n    visible: true,\n    position: 'center',\n    overlap: {\n      avoidBaseMark: false\n    },\n    style: {\n      stroke: '#fff',\n      lineWidth: 1\n    }\n  },\n  markLine: [\n    {\n      x: 65,\n      label: {\n        visible: true,\n        position: 'end',\n        text: 'Safe fat intake 65g/day',\n        style: {\n          textAlign: 'left',\n          textBaseline: 'top',\n          fill: '#000',\n          dx: 10\n        },\n        labelBackground: {\n          visible: false\n        }\n      },\n      line: {\n        style: {\n          stroke: '#000',\n          lineDash: [0]\n        }\n      }\n    },\n    {\n      y: 50,\n      label: {\n        visible: true,\n        position: 'end',\n        text: 'Safe sugar intake 50g/day',\n        style: {\n          textAlign: 'right',\n          textBaseline: 'bottom',\n          fill: '#000'\n        },\n        labelBackground: {\n          visible: false\n        }\n      },\n      line: {\n        style: {\n          stroke: '#000',\n          lineDash: [0]\n        }\n      }\n    }\n  ],\n  tooltip: {\n    mark: {\n      title: {\n        value: datum => datum.country\n      }\n    }\n  },\n  data: {\n    id: 'data',\n    values: [\n      { x: 95, y: 95, z: 13.8, name: 'BE', country: 'Belgium' },\n      { x: 86.5, y: 102.9, z: 14.7, name: 'DE', country: 'Germany' },\n      { x: 80.8, y: 91.5, z: 15.8, name: 'FI', country: 'Finland' },\n      { x: 80.4, y: 102.5, z: 12, name: 'NL', country: 'Netherlands' },\n      { x: 80.3, y: 86.1, z: 11.8, name: 'SE', country: 'Sweden' },\n      { x: 78.4, y: 70.1, z: 16.6, name: 'ES', country: 'Spain' },\n      { x: 74.2, y: 68.5, z: 14.5, name: 'FR', country: 'France' },\n      { x: 73.5, y: 83.1, z: 10, name: 'NO', country: 'Norway' },\n      { x: 71, y: 93.2, z: 24.7, name: 'UK', country: 'United Kingdom' },\n      { x: 69.2, y: 57.6, z: 10.4, name: 'IT', country: 'Italy' },\n      { x: 68.6, y: 20, z: 16, name: 'RU', country: 'Russia' },\n      { x: 65.5, y: 126.4, z: 35.3, name: 'US', country: 'United States' },\n      { x: 65.4, y: 50.8, z: 28.5, name: 'HU', country: 'Hungary' },\n      { x: 63.4, y: 51.8, z: 15.4, name: 'PT', country: 'Portugal' },\n      { x: 64, y: 82.9, z: 31.3, name: 'NZ', country: 'New Zealand' }\n    ]\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 结果展示\n\n- [在线效果参考](https://codesandbox.io/s/mark-line-basic-srhwq3)\n\n## 相关文档\n\n- [markLine demo](https://www.visactor.io/vchart/demo/marker/mark-line-basic)\n- [markLine 教程](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/marker)\n- [相关 api](https://www.visactor.io/vchart/option/barChart#markLine.label.position)\n- [github](https://github.com/VisActor/VChart)\n"
  },
  {
    fileName:
      '209- Can the tip displayed above an overly long label when hovering be configured to change background and text colors.md',
    content:
      "---\ntitle: 105.hover 超长label时候上方显示的这个tip能否配置修改背景颜色和文字颜色</br>\n---\r\n## 问题标题\r\n\r\nhover 超长label时候上方显示的这个tip能否配置修改背景颜色和文字颜色</br>\r\n## 问题描述\r\n\r\nhover 超长label时候上方显示的这个tip能否配置修改背景颜色和文字颜色</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/I9C2bF5wsopxbXxJFRRcg00RnZf.gif' alt='' width='1782' height='590'>\r\n\r\n## 解决方案 \r\n\r\n在主题中配置 poptip 属性即可。</br>\r\n\r\n\r\n```\ntheme:{\n    component: {\n      poptip: {\n        contentStyle: {\n          fill: '#fff',\n        },\n        panel: {\n          fill: '#ccc'\n        }\n      }\n    }\n  }</br>\n```\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  type: 'bar',\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          name: 'AppleAppleAppleAppleAppleAppleAppleAppleAppleAppleApple',\n          value: 214480\n        },\n        {\n          name: 'Google',\n          value: 155506\n        },\n        {\n          name: 'Amazon',\n          value: 100764\n        },\n        {\n          name: 'Microsoft',\n          value: 92715\n        },\n        {\n          name: 'Coca-Cola',\n          value: 66341\n        },\n        {\n          name: 'Samsung',\n          value: 59890\n        },\n        {\n          name: 'Toyota',\n          value: 53404\n        },\n        {\n          name: 'Mercedes-Benz',\n          value: 48601\n        },\n        {\n          name: 'Facebook',\n          value: 45168\n        },\n        {\n          name: \"McDonald's\",\n          value: 43417\n        },\n        {\n          name: 'Intel',\n          value: 43293\n        },\n        {\n          name: 'IBM',\n          value: 42972\n        },\n        {\n          name: 'BMW',\n          value: 41006\n        },\n        {\n          name: 'Disney',\n          value: 39874\n        },\n        {\n          name: 'Cisco',\n          value: 34575\n        },\n        {\n          name: 'GE',\n          value: 32757\n        },\n        {\n          name: 'Nike',\n          value: 30120\n        },\n        {\n          name: 'Louis Vuitton',\n          value: 28152\n        },\n        {\n          name: 'Oracle',\n          value: 26133\n        },\n        {\n          name: 'Honda',\n          value: 23682\n        }\n      ]\n    }\n  ],\n  direction: 'horizontal',\n  xField: 'value',\n  yField: 'name',\n  axes: [\n    {\n      orient: 'bottom',\n      visible: false\n    }\n  ],\n  label: {\n    visible: true\n  },\n  theme:{\n    component: {\n      poptip: {\n        contentStyle: {\n          fill: '#fff',\n        },\n        panel: {\n          fill: '#ccc'\n        }\n      }\n    }\n  }\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TSsmbJnayoS3Zfxmoxqc3MQknPg.gif' alt='' width='1200' height='804'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n*  API：https://visactor.io/vchart/option/barChart#theme.component</br>\r\n*  Github：https://github.com/VisActor/VChart/</br>\r\n\r\n"
  },
  {
    fileName: '210- How to set the time interval in a timeline.md',
    content:
      "---\ntitle: 27. 时间轴如何设置时间间隔？</br>\n---\r\n## 问题标题\r\n\r\n时间轴如何设置时间间隔？</br>\r\n\r\n\r\n## 问题描述\r\n\r\nx轴 type=time时，tick间隔是怎么配置的呢，我希望自定义时间间隔，比如：以“天”为单位间隔</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/FkpjbYGbpoxYWqxVjK2ct48Qn2e.gif' alt='' width='3050' height='732'>\r\n\r\n\r\n\r\n## 解决方案 \r\n\r\n可以通过配置axes.tickStep来控制时间轴的不同tick间的间隔，注意：tickStep需配置秒时间戳。</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/TSxibZbcqoEHGMxDGjhcA9q9nlg.gif' alt='' width='3254' height='1472'>\r\n\r\n\r\n\r\n## 代码示例  \r\n\r\n```\nconst spec = {\n  color: [\n    '#3855df',\n    '#ffc52b',\n    '#5ecf78',\n    '#fb7a00',\n    '#0acffd',\n    '#217dfd',\n    '#98dd61',\n    '#3150e0',\n    '#714efd',\n    '#0bcfff',\n    '#3d0dde',\n    '#ffc527',\n    '#f5c13f',\n    '#fb7a08',\n    '#95d8fd'\n  ],\n  type: 'rangeColumn',\n  direction: 'horizontal',\n  yField: 'type',\n  minField: 'start_time',\n  maxField: 'end_time',\n  seriesField: 'color',\n  dataZoom: [\n    {\n      orient: 'bottom',\n      height: 20,\n      start: 0.1,\n      endValue: 1681956000,\n      filterMode: 'axis',\n      brushSelect: false,\n      startText: {\n        formatMethod: text => Math.floor(text)\n      },\n      endText: {\n        formatMethod: text => Math.floor(text)\n      }\n    }\n  ],\n  axes: [\n    { orient: 'left', type: 'band', bandPadding: 0.5, visible: false },\n    {\n      type: 'time',\n      orient: 'bottom',\n      layers: [\n        {\n          tickStep: 28800,\n          timeFormat: '%Y%m%d %H:%M'\n        }\n      ]\n    }\n  ],\n  title: {\n    textStyle: {\n      character: [\n        {\n          text: 'Time-Consuming Distribution',\n          fontWeight: 400,\n          fill: '#222'\n        },\n        {\n          text: 'Show the SQL distribution of TOP 100',\n          fontWeight: 200,\n          fontSize: 10,\n          fill: '#555'\n        }\n      ]\n    }\n  },\n  tooltip: {\n    visible: true,\n    dimension: {\n      visible: false\n    },\n    mark: {\n      title: {\n        key: 'Query ID',\n        value: datum => 'Query ID: ' + datum['id']\n      },\n      content: [\n        {\n          key: 'Time Consuming',\n          value: datum => datum['useTime']\n        },\n        {\n          key: 'start time',\n          value: datum => datum['start_time']\n        },\n        {\n          key: 'end time',\n          value: datum => datum['end_time']\n        }\n      ]\n    }\n  },\n  data: [\n    {\n      id: 'data0',\n      values: [\n        {\n          start_time: 1681926000,\n          end_time: 1681927200,\n          type: 'TOP 1',\n          color: 'A',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681926000,\n          end_time: 1681959600,\n          type: 'TOP 2',\n          color: 'B',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681925400,\n          end_time: 1681974000,\n          type: 'TOP 3',\n          color: 'C',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681924800,\n          end_time: 1681933200,\n          type: 'TOP 4',\n          color: 'D',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681959600,\n          end_time: 1681963200,\n          type: 'TOP 5',\n          color: 'E',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681970400,\n          end_time: 1681971000,\n          type: 'TOP 5',\n          color: 'F',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681992000,\n          end_time: 1681992600,\n          type: 'TOP 5',\n          color: 'G',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681956000,\n          end_time: 1681963200,\n          type: 'TOP 6',\n          color: 'H',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681990200,\n          end_time: 1681993800,\n          type: 'TOP 7',\n          color: 'I',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681948800,\n          end_time: 1681959600,\n          type: 'TOP 8',\n          color: 'J',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        },\n        {\n          start_time: 1681945200,\n          end_time: 1681956000,\n          type: 'TOP 9',\n          color: 'K',\n          id: 'a90292870-9282',\n          useTime: '100ms'\n        }\n      ].reverse()\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID, animation: false });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;</br>\n```\r\n## 结果展示 \r\n\r\n在线效果参考：https://www.visactor.io/vchart/demo/data-zoom/state-with-data</br>\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/B5KFbg8UZohJVfxehv1cgWm7nKh.gif' alt='' width='1576' height='944'>\r\n\r\n\r\n\r\n## 相关文档\r\n\r\n时间轴demo：https://www.visactor.io/vchart/demo/data-zoom/state-with-data</br>\r\n坐标轴教程：https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Axes</br>\r\n相关api：https://www.visactor.io/vchart/option/barChart-axes-time#layers.tickStep</br>\r\ngithub：https://github.com/VisActor/VChart</br>\r\n\r\n\r\n\r\n"
  },
  {
    fileName: '211-How to configure it to ignore part of the display content.md',
    content:
      "# x 轴数据过于密集，如何配置忽略一部分显示内容？\n\n## 问题描述\n\n我在绘制一个大数据量的折线图表，数据里面包含比较多的维度，如果通过 d3 来绘制的话 axisBottom 会省略一部分内容，只展示几个维度项。我希望能够相对密集的展示较多的标签但是不出现标签的遮挡，请问有什么工具能够实现这样的功能吗？\n\nD3 效果如下：[d3](https://d3-graph-gallery.com/graph/line_basic.html)\n\n![d3](/vchart/faq/75-0.png)\n\n## 解决方案\n\nVChart 允许开发者配置不同的轴标签展示策略，默认情况下，VChart 会对轴标签进行采样以展示合适的标签内容。开发者可以配置 `axes.sampling` 为 false 来关闭这一采样算法，并通过 `axes.label.autoRotate` 应用标签遮挡算法以展示更多的标签同时避免遮挡。开发者也可以通过 `axes.label.autoHide` 开启标签的自动旋转以展示更多的标签内容。\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n\n  xField: 'x',\n  yField: 'y',\n  axes: [\n    {\n      orient: 'bottom',\n      sampling: false,\n      label: {\n        autoRotate: true,\n        autoHide: true\n      }\n    }\n  ],\n  data: [\n    {\n      id: 'event_analysis_stack',\n      values: [\n        { x: '0', y: 28, c: 0 },\n        { x: 0.5, y: 20, c: 1 },\n        { x: 1, y: 43, c: 0 },\n        { x: 1.5, y: 35, c: 1 },\n        { x: 2, y: 81, c: 0 },\n        { x: 2.5, y: 10, c: 1 },\n        { x: 3, y: 19, c: 0 },\n        { x: 3.5, y: 15, c: 1 },\n        { x: 4, y: 52, c: 0 },\n        { x: 4.5, y: 48, c: 1 },\n        { x: 5, y: 24, c: 0 },\n        { x: 5.5, y: 28, c: 1 },\n        { x: 6, y: 87, c: 0 },\n        { x: 6.5, y: 66, c: 1 },\n        { x: 7, y: 17, c: 0 },\n        { x: 7.5, y: 27, c: 1 },\n        { x: 8, y: 68, c: 0 },\n        { x: 8.5, y: 16, c: 1 },\n        { x: 9, y: 49, c: 0 },\n        { x: 9.5, y: 25, c: 1 },\n        { x: 10, y: 28, c: 0 },\n        { x: 10.5, y: 20, c: 1 },\n        { x: 11, y: 43, c: 0 },\n        { x: 11.5, y: 35, c: 1 },\n        { x: 12, y: 81, c: 0 },\n        { x: 12.5, y: 10, c: 1 },\n        { x: 13, y: 19, c: 0 },\n        { x: 13.5, y: 15, c: 1 },\n        { x: 14, y: 52, c: 0 },\n        { x: 14.5, y: 48, c: 1 },\n        { x: 15, y: 24, c: 0 },\n        { x: 15.5, y: 28, c: 1 },\n        { x: 16, y: 87, c: 0 },\n        { x: 16.5, y: 66, c: 1 },\n        { x: 17, y: 17, c: 0 },\n        { x: 17.5, y: 27, c: 1 },\n        { x: 18, y: 68, c: 0 },\n        { x: 18.5, y: 16, c: 1 },\n        { x: 19, y: 49, c: 0 },\n        { x: 19.5, y: 25, c: 1 },\n        { x: 20, y: 28, c: 0 },\n        { x: 20.5, y: 20, c: 1 },\n        { x: 21, y: 43, c: 0 },\n        { x: 21.5, y: 35, c: 1 },\n        { x: 22, y: 81, c: 0 },\n        { x: 22.5, y: 10, c: 1 },\n        { x: 23, y: 19, c: 0 },\n        { x: 23.5, y: 15, c: 1 },\n        { x: 24, y: 52, c: 0 },\n        { x: 24.5, y: 48, c: 1 },\n        { x: 25, y: 24, c: 0 },\n        { x: 25.5, y: 28, c: 1 },\n        { x: 26, y: 87, c: 0 },\n        { x: 26.5, y: 66, c: 1 },\n        { x: 27, y: 17, c: 0 },\n        { x: 27.5, y: 27, c: 1 },\n        { x: 28, y: 68, c: 0 },\n        { x: 28.5, y: 16, c: 1 },\n        { x: 29, y: 49, c: 0 },\n        { x: 29.5, y: 25, c: 1 },\n        { x: 30, y: 28, c: 0 },\n        { x: 30.5, y: 20, c: 1 },\n        { x: 31, y: 43, c: 0 },\n        { x: 31.5, y: 35, c: 1 },\n        { x: 32, y: 81, c: 0 },\n        { x: 32.5, y: 10, c: 1 },\n        { x: 33, y: 19, c: 0 },\n        { x: 33.5, y: 15, c: 1 },\n        { x: 34, y: 52, c: 0 },\n        { x: 34.5, y: 48, c: 1 },\n        { x: 35, y: 24, c: 0 },\n        { x: 35.5, y: 28, c: 1 },\n        { x: 36, y: 87, c: 0 },\n        { x: 36.5, y: 66, c: 1 },\n        { x: 37, y: 17, c: 0 },\n        { x: 37.5, y: 27, c: 1 },\n        { x: 38, y: 68, c: 0 },\n        { x: 38.5, y: 16, c: 1 },\n        { x: 39, y: 49, c: 0 },\n        { x: 39.5, y: 25, c: 1 }\n      ]\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n除此之外，如果开发者对这些内置的标签展示策略仍不满意，那么可以通过 `axes.label.dataFilter` 来自定义标签展示的规则：\n\n```javascript livedemo\nconst spec = {\n  type: 'bar',\n  xField: ['date', 'stack'],\n  yField: 'value',\n  seriesField: 'group',\n  stack: true,\n  axes: [\n    {\n      orient: 'bottom',\n      domainLine: {\n        onZero: true // Axis baseline is at value 0\n      },\n      sampling: false, // close axis label's sampling\n      label: {\n        dataFilter: axisData => {\n          // just show the first and last data\n          return [axisData[0], axisData[axisData.length - 1]];\n        }\n      },\n      tick: {\n        dataFilter: axisData => {\n          // just show the first and last data\n          return [axisData[0], axisData[axisData.length - 1]];\n        }\n      }\n    },\n    {\n      orient: 'left',\n      title: {\n        visible: true,\n        text: 'Week-on-week (sales)'\n      },\n      tick: {\n        tickCount: 10\n      }\n    }\n  ],\n  legends: {\n    visible: true\n  },\n  data: [\n    {\n      id: 'barData',\n      values: [\n        {\n          date: '2019-08-29',\n          group: 'Cake',\n          value: 154,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Bread',\n          value: 378,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Tea',\n          value: 103,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Coffee',\n          value: 310,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Rib',\n          value: 419,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Crayfish',\n          value: 810,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Cake',\n          value: 153,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Bread',\n          value: 398,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Tea',\n          value: 105,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Coffee',\n          value: 298,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Rib',\n          value: 416,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Crayfish',\n          value: 796,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Cake',\n          value: 151,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Bread',\n          value: 408,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Tea',\n          value: 110,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Coffee',\n          value: 302,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Rib',\n          value: 400,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Crayfish',\n          value: 811,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Cake',\n          value: 135,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Bread',\n          value: 407,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Tea',\n          value: 944,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Coffee',\n          value: 298,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Rib',\n          value: 343,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Crayfish',\n          value: 771,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Cake',\n          value: 997,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Bread',\n          value: 363,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Tea',\n          value: 636,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Coffee',\n          value: 239,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Rib',\n          value: 204,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Crayfish',\n          value: 641,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Cake',\n          value: 984,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Bread',\n          value: 356,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Tea',\n          value: 627,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Coffee',\n          value: 241,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Rib',\n          value: 231,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Crayfish',\n          value: 646,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Cake',\n          value: 943,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Bread',\n          value: 355,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Tea',\n          value: 611,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Coffee',\n          value: 259,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Rib',\n          value: 230,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Crayfish',\n          value: 666,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Cake(last week)',\n          value: -365,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Bread(last week)',\n          value: -235,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Tea(last week)',\n          value: -832,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Coffee(last week)',\n          value: -610,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Rib(last week)',\n          value: -305,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-29',\n          group: 'Crayfish(last week)',\n          value: -462,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Cake(last week)',\n          value: -522,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Bread(last week)',\n          value: -258,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Tea(last week)',\n          value: -689,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Coffee(last week)',\n          value: -688,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Rib(last week)',\n          value: -106,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-30',\n          group: 'Crayfish(last week)',\n          value: -159,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Cake(last week)',\n          value: -352,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Bread(last week)',\n          value: -760,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Tea(last week)',\n          value: -332,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Coffee(last week)',\n          value: -368,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Rib(last week)',\n          value: -222,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-08-31',\n          group: 'Crayfish(last week)',\n          value: -205,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Cake(last week)',\n          value: -471,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Bread(last week)',\n          value: -535,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Tea(last week)',\n          value: -319,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Coffee(last week)',\n          value: -363,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Rib(last week)',\n          value: -243,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-01',\n          group: 'Crayfish(last week)',\n          value: -129,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Cake(last week)',\n          value: -319,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Bread(last week)',\n          value: -570,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Tea(last week)',\n          value: -532,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Coffee(last week)',\n          value: -312,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Rib(last week)',\n          value: -583,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-02',\n          group: 'Crayfish(last week)',\n          value: -342,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Cake(last week)',\n          value: -346,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Bread(last week)',\n          value: -373,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Tea(last week)',\n          value: -582,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Coffee(last week)',\n          value: -247,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Rib(last week)',\n          value: -294,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-03',\n          group: 'Crayfish(last week)',\n          value: -165,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Cake(last week)',\n          value: -326,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Bread(last week)',\n          value: -879,\n          stack: 'Dessert'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Tea(last week)',\n          value: -219,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Coffee(last week)',\n          value: -236,\n          stack: 'Drink'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Rib(last week)',\n          value: -153,\n          stack: 'Meat dishes'\n        },\n        {\n          date: '2019-09-04',\n          group: 'Crayfish(last week)',\n          value: -253,\n          stack: 'Meat dishes'\n        }\n      ]\n    }\n  ]\n};\n\nconst vchart = new VChart(spec, { dom: CONTAINER_ID });\nvchart.renderSync();\n\n// Just for the convenience of console debugging, DO NOT COPY!\nwindow['vchart'] = vchart;\n```\n\n## 相关文档\n\n- [github](https://github.com/VisActor/VChart)\n- [Tooltip Tutorial](https://visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip)\n- [Axis label example](https://www.visactor.io/vchart/demo/axis/axis-label-autoHide-and-autoRotate)\n- [Axis label autoHide spec](https://www.visactor.io/vchart/option/barChart-axes-linear#label.autoHide)\n- [Datafilter example](https://www.visactor.io/vchart/demo/axis/disable-sampling)\n- [Datafilter spec](https://www.visactor.io/vchart/option/barChart-axes-linear#label.dataFilter)\n"
  },
  {
    fileName: '212- What are the methods for data sampling in VChart charts.md',
    content:
      "---\ntitle: 60. VChart 图表中数据采样的方法有哪些？</br>\n---\r\n## 问题标题\r\n\r\nVChart 图表中数据采样的方法有哪些？</br>\r\n\r\n\r\n## 问题描述\r\n\r\n请问 vchart 的折线图数据量很大的情况下，有没有一些数据采样的配置提高性能？</br>\r\n\r\n\r\n## 解决方案\r\n\r\nVChart 折线图 自`1.6.0`版本开始支持数据采样方法配置。</br>\r\n折线图在数据量远大于像素点时候的降采样策略，开启后可以有效的优化图表的绘制效率，默认关闭，也就是全部绘制不过滤数据点。`sampling` 配置可选值:</br>\r\n*  `'lttb'`: 采用 Largest-Triangle-Three-Bucket 算法，可以最大程度保证采样后线条的趋势，形状和极值。</br>\r\n*  `'min'`: 取过滤点的最小值</br>\r\n*  `'max'`: 取过滤点的最大值</br>\r\n*  `'sum'`: 取过滤点的和</br>\r\n*  `'average'`: 取过滤点的平均值</br>\r\n可以通过采样系数`samplingFactor`配置调整采样效果。</br>\r\n```\nsampling: 'lttb',\nsamplingFactor: 0.1,</br>\n```\r\n\r\n\r\n## 代码示例 \r\n\r\nhttps://visactor.io/vchart/demo/line-chart/line-sampling</br>\r\n\r\n\r\n## 结果展示\r\n\r\n<img src='https://cdn.jsdelivr.net/gh/xuanhun/articles/visactor/img/H829bRSfDoR1A1xvfD8cL609nTe.gif' alt='' width='1485' height='1044'>\r\n\r\n## 相关文档\r\n\r\n*  github：https://github.com/VisActor/VChart</br>\r\n*  数据采样配置 `smapling`：https://visactor.io/vchart/option/lineChart#sampling</br>\r\n\r\n"
  }
];
