import {
  changePointData,
  groupedBarData,
  lineChartData,
  lineChartData2,
  lineChartData3,
  MultiLineData,
  multiLineData2,
  scatterClusterData,
  scatterPlotData
} from './insightData';

export const SalesLineChart = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['230925203632066'],
    direction: 'vertical',
    sortDataByAxis: true,
    seriesField: '240510184222013',
    padding: 0,
    labelLayout: 'region',
    data: [
      {
        id: 'data',
        values: [
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '25860.24',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '5877.647999999999',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '34271.58',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '6251.420000000001',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '3113.459999999999',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '87717.84',
            '240510184222013': '西北'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '53058.96400000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '14409.919999999998',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '5540.92',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '41802.488000000005',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '9202.2',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '583.2959999999999',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '560.56',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '96269.32',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-04',
            '230925203632066': '106208.47999999997',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-04',
            '230925203632066': '6231.624',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-04',
            '230925203632066': '84454.83199999998',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '312.816',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '5718.888000000001',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '39811.91200000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '244163.47199999995',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '79487.40800000001',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-06',
            '230925203632066': '28648.339999999997',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-06',
            '230925203632066': '18288.760000000002',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '67434.584',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '1176',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '81264.54000000001',
            '240510184222013': '西北'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '87750.964',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-09',
            '230925203632066': '67434.584',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-09',
            '230925203632066': '5902.344',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-09',
            '230925203632066': '22252.271999999997',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-09',
            '230925203632066': '98844.76',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '2677.36',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '1444.52',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '62082.60799999999',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '677.3760000000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-11',
            '230925203632066': '776.16',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-11',
            '230925203632066': '7487.004000000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-11',
            '230925203632066': '57016.399999999994',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-12',
            '230925203632066': '7131.852000000001',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-12',
            '230925203632066': '11837.812',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-12',
            '230925203632066': '207763.13600000003',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-13',
            '230925203632066': '24299.296000000002',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-13',
            '230925203632066': '9847.04',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-13',
            '230925203632066': '15919.119999999999',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '33544.420000000006',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '39935.97999999999',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '60416.804',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '1234.8000000000002',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '36007.159999999996',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-16',
            '230925203632066': '108484.04000000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-16',
            '230925203632066': '2450',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-17',
            '230925203632066': '78099.14000000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-17',
            '230925203632066': '49350.84',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-17',
            '230925203632066': '18480.84',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '48419.840000000004',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '118951.66500000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '10853.892',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '1627.5839999999998',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '32777.276000000005',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '41905.78000000001',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '47942.58000000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '48259.512',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '18021.22',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-22',
            '230925203632066': '58530.50000000001',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-22',
            '230925203632066': '22004.724000000002',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-22',
            '230925203632066': '7729.260000000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-23',
            '230925203632066': '49218.540000000015',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-23',
            '230925203632066': '13944.419999999998',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-23',
            '230925203632066': '3843.56',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '16754.08',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '2343.1800000000003',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '41413.81999999999',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '723.2399999999998',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-25',
            '230925203632066': '10678.08',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-25',
            '230925203632066': '44791.096000000005',
            '240510184222013': '华东'
          }
        ],
        fields: {
          '230925203632021': {
            alias: '订单日期',
            domain: [
              '2023-04-01',
              '2023-04-02',
              '2023-04-03',
              '2023-04-04',
              '2023-04-05',
              '2023-04-06',
              '2023-04-08',
              '2023-04-09',
              '2023-04-10',
              '2023-04-11',
              '2023-04-12',
              '2023-04-13',
              '2023-04-15',
              '2023-04-16',
              '2023-04-17',
              '2023-04-18',
              '2023-04-19',
              '2023-04-22',
              '2023-04-23',
              '2023-04-24',
              '2023-04-25'
            ],
            sortIndex: 0,
            lockStatisticsByDomain: true
          },
          '230925203632066': {
            alias: '销售额'
          },
          '240510184222013': {
            alias: '区域'
          }
        }
      }
    ],
    stackInverse: true,
    axes: [
      {
        type: 'band',
        tick: {
          visible: false
        },
        grid: {
          visible: false,
          style: {
            zIndex: 150,
            stroke: '#425271',
            lineWidth: 1,
            lineDash: [4, 2]
          }
        },
        orient: 'bottom',
        visible: true,
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#4C5C79'
          }
        },
        title: {
          visible: false,
          space: 5,
          text: '订单日期',
          style: {
            fontSize: 12,
            fontWeight: 'normal'
          }
        },
        maxHeight: null,
        autoIndent: false,
        sampling: false,
        zIndex: 200,
        label: {
          visible: true,
          space: 4,
          style: {
            fontSize: 12,
            fill: '#BBC2D0',
            angle: 0,
            fontWeight: 'normal',
            direction: 'horizontal',
            maxLineWidth: 174
          },
          autoHide: true,
          autoHideMethod: 'greedy',
          flush: true,
          lastVisible: true
        },
        hover: true,
        background: {
          visible: true,
          state: {
            hover: {
              fillOpacity: 0.08,
              fill: '#141414'
            },
            hover_reverse: {
              fillOpacity: 0.08,
              fill: '#141414'
            }
          }
        },
        paddingInner: 0.36249999999999993,
        paddingOuter: 0.175
      },
      {
        type: 'linear',
        tick: {
          visible: false,
          tickMode: 'd3',
          style: {
            stroke: '#4C5C79'
          }
        },
        niceType: 'accurateFirst',
        zIndex: 200,
        grid: {
          visible: true,
          style: {
            zIndex: 150,
            stroke: '#425271',
            lineWidth: 1,
            lineDash: [4, 2]
          }
        },
        orient: 'left',
        visible: true,
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#4C5C79'
          }
        },
        title: {
          visible: false,
          text: '销售额',
          space: 8,
          style: {
            fontSize: 12,
            fontWeight: 'normal'
          }
        },
        autoIndent: false,
        sampling: false,
        label: {
          visible: true,
          space: 6,
          flush: true,
          padding: 0,
          style: {
            fontSize: 12,
            maxLineWidth: 174,
            fill: '#BBC2D0',
            angle: 0,
            fontWeight: 'normal',
            dy: 0,
            direction: 'horizontal'
          },
          autoHide: true,
          autoHideMethod: 'greedy'
        },
        background: {
          visible: true,
          state: {
            hover: {
              fillOpacity: 0.08,
              fill: '#141414'
            },
            hover_reverse: {
              fillOpacity: 0.08,
              fill: '#141414'
            }
          }
        },
        innerOffset: {
          top: 4.4311346272637895
        },
        zero: true,
        nice: true
      }
    ],
    color: {
      field: '20001',
      type: 'ordinal',
      range: ['#207BFE', '#00CFFF', '#FC7703', '#5BCF78', '#2F4DE0', '#94D8FF'],
      specified: {},
      domain: ['西南', '东北', '中南', '华北', '华东', '西北']
    },
    legends: [
      {
        type: 'discrete',
        visible: true,
        id: 'legend-discrete',
        orient: 'bottom',
        position: 'middle',
        layoutType: 'normal',
        maxRow: 1,
        title: {
          textStyle: {
            fontSize: 12
          }
        },
        layoutLevel: 30,
        item: {
          focus: true,
          focusIconStyle: {
            size: 14
          },
          maxWidth: 400,
          spaceRow: 0,
          spaceCol: 0,
          padding: {
            top: 1,
            bottom: 1,
            left: 1,
            right: 1
          },
          background: {
            visible: false,
            style: {
              fillOpacity: 0.001
            }
          },
          label: {
            style: {
              fontSize: 12
            }
          },
          shape: {
            style: {
              lineWidth: 0,
              symbolType: 'circle',
              fillOpacity: 1,
              size: 10
            }
          }
        },
        pager: {
          layout: 'horizontal',
          padding: 0,
          textStyle: {
            fill: '#FDFDFE'
          },
          space: 0,
          handler: {
            preShape: 'triangleLeft',
            nextShape: 'triangleRight',
            style: {
              fill: '#BBC2D0'
            },
            state: {
              disable: {
                fill: '#566582'
              }
            }
          }
        },
        alignSelf: 'start',
        padding: {
          top: 16,
          bottom: 0,
          left: 0,
          right: 0
        }
      }
    ],
    label: {
      visible: false,
      offset: 3,
      overlap: {
        hideOnHit: true,
        avoidBaseMark: false,
        strategy: [
          {
            type: 'position',
            position: ['top', 'bottom']
          }
        ],
        clampForce: true
      },
      style: {
        fontSize: 12,
        fontWeight: 'normal',
        zIndex: 400,
        lineHeight: '100%',
        boundsPadding: [1, 0, 0, 0],
        fill: '#FDFDFE',
        strokeOpacity: 0
      },
      position: 'top',
      smartInvert: false
    },
    seriesMark: 'line',
    markOverlap: true,
    region: [
      {
        clip: true
      }
    ],
    background: 'rgba(255, 255, 255, 0)',
    invalidType: 'break',
    animation: false,
    brush: {
      inBrush: {
        fillOpacity: 1,
        strokeOpacity: 1,
        colorAlpha: 1
      },
      outOfBrush: {
        colorAlpha: 0.2,
        fillOpacity: 0.3
      }
    },
    crosshair: {
      xField: {
        visible: true,
        line: {
          type: 'rect',
          style: {
            fillOpacity: 0.2,
            fill: '#b2bacf'
          }
        }
      },
      gridZIndex: 100
    }
  },
  fieldInfo: undefined
};

export const DualAxisChartData = {
  spec: {
    type: 'common',
    seriesField: 'color',
    data: [
      {
        id: 'id0',
        values: [
          { x: '周一', type: '早餐', y: 15 },
          { x: '周一', type: '午餐', y: 25 },
          { x: '周二', type: '早餐', y: 12 },
          { x: '周二', type: '午餐', y: 30 },
          { x: '周三', type: '早餐', y: 15 },
          { x: '周三', type: '午餐', y: 24 },
          { x: '周四', type: '早餐', y: 10 },
          { x: '周四', type: '午餐', y: 25 },
          { x: '周五', type: '早餐', y: 13 },
          { x: '周五', type: '午餐', y: 20 },
          { x: '周六', type: '早餐', y: 10 },
          { x: '周六', type: '午餐', y: 22 },
          { x: '周日', type: '早餐', y: 12 },
          { x: '周日', type: '午餐', y: 19 }
        ]
      },
      {
        id: 'id1',
        values: [
          { x: '周一', type: '饮料', y: 22 },
          { x: '周二', type: '饮料', y: 43 },
          { x: '周三', type: '饮料', y: 33 },
          { x: '周四', type: '饮料', y: 22 },
          { x: '周五', type: '饮料', y: 10 },
          { x: '周六', type: '饮料', y: 30 },
          { x: '周日', type: '饮料', y: 50 }
        ]
      }
    ],
    series: [
      {
        type: 'bar',
        id: 'bar',
        dataIndex: 0,
        label: { visible: true },
        seriesField: 'type',
        xField: ['x', 'type'],
        yField: 'y'
      },
      {
        type: 'line',
        id: 'line',
        dataIndex: 1,
        label: { visible: true },
        seriesField: 'type',
        xField: 'x',
        yField: 'y',
        stack: false
      }
    ],
    axes: [
      { orient: 'left', seriesIndex: [0] },
      { orient: 'right', seriesId: ['line'], grid: { visible: false } },
      { orient: 'bottom', label: { visible: true }, type: 'band' }
    ],
    legends: {
      visible: true,
      orient: 'bottom'
    }
  },
  fieldInfo: undefined
};

export const CollegeEntranceLineChart = {
  spec: {
    type: 'line',
    xField: ['年份'],
    yField: ['高考录取率'],
    data: [
      {
        id: 'data',
        values: lineChartData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const SalesLineChart2 = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['10002'],
    data: [
      {
        id: 'data',
        values: lineChartData2
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const SalesLineChart3 = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['10002'],
    data: [
      {
        id: 'data',
        values: lineChartData3
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const GroupedBarChart = {
  spec: {
    type: 'bar',
    xField: ['State'],
    yField: ['Population'],
    seriesField: 'Age',
    data: [
      {
        id: 'data',
        values: groupedBarData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const MultiLineChart = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['10002'],
    seriesField: '20001',
    data: [
      {
        id: 'data',
        values: MultiLineData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const ChangePointChart = {
  spec: {
    type: 'line',
    xField: ['x'],
    yField: ['y'],
    data: [
      {
        id: 'data',
        values: changePointData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const MultiLineChart2 = {
  spec: {
    type: 'line',
    xField: ['type'],
    yField: ['value'],
    seriesField: 'country',
    data: [
      {
        id: 'data',
        values: multiLineData2
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const ScatterPlotChart = {
  spec: {
    type: 'scatter',
    xField: ['GDP'],
    yField: ['LifeExpectancy'],
    seriesField: 'continent',
    data: [
      {
        id: 'data',
        values: scatterPlotData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const ScatterClusterChart = {
  spec: {
    type: 'scatter',
    xField: ['x'],
    yField: ['horsepower'],
    seriesField: 'cylinders',
    data: [
      {
        id: 'data',
        values: scatterClusterData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const SalesScatterChart = {
  spec: {
    type: 'scatter',
    xField: '241028194022035',
    yField: '241028194022120',
    invalidType: 'ignore',
    region: [
      {
        clip: true
      }
    ],
    padding: 0,
    labelLayout: 'region',
    data: [
      {
        id: 'data',
        values: [
          {
            '30001': '吉林',
            '241028194022035': '2022',
            '241028194022106': '吉林',
            '241028194022120': '977478.5509999993'
          },
          {
            '30001': '山西',
            '241028194022035': '1136',
            '241028194022106': '山西',
            '241028194022120': '523329.3099999991'
          },
          {
            '30001': '四川',
            '241028194022035': '2593',
            '241028194022106': '四川',
            '241028194022120': '726426.7640000003'
          },
          {
            '30001': '福建',
            '241028194022035': '1431',
            '241028194022106': '福建',
            '241028194022120': '816301.2760000001'
          },
          {
            '30001': '新疆',
            '241028194022035': '287',
            '241028194022106': '新疆',
            '241028194022120': '129656.044'
          },
          {
            '30001': '海南',
            '241028194022035': '818',
            '241028194022106': '海南',
            '241028194022120': '469479.42300000036'
          },
          {
            '30001': '辽宁',
            '241028194022035': '4037',
            '241028194022106': '辽宁',
            '241028194022120': '1355669.895999997'
          },
          {
            '30001': '天津',
            '241028194022035': '2127',
            '241028194022106': '天津',
            '241028194022120': '988936.1299999987'
          },
          {
            '30001': '湖南',
            '241028194022035': '2553',
            '241028194022106': '湖南',
            '241028194022120': '1145062.1349999974'
          },
          {
            '30001': '广东',
            '241028194022035': '5438',
            '241028194022106': '广东',
            '241028194022120': '2458362.2490000096'
          },
          {
            '30001': '青海',
            '241028194022035': '181',
            '241028194022106': '青海',
            '241028194022120': '147714.9800000001'
          },
          {
            '30001': '上海',
            '241028194022035': '2672',
            '241028194022106': '上海',
            '241028194022120': '1482621.2239999957'
          },
          {
            '30001': '江西',
            '241028194022035': '683',
            '241028194022106': '江西',
            '241028194022120': '336832.16000000003'
          },
          {
            '30001': '河北',
            '241028194022035': '2095',
            '241028194022106': '河北',
            '241028194022120': '992759.8449999997'
          },
          {
            '30001': '甘肃',
            '241028194022035': '900',
            '241028194022106': '甘肃',
            '241028194022120': '251375.7959999997'
          },
          {
            '30001': '宁夏',
            '241028194022035': '298',
            '241028194022106': '宁夏',
            '241028194022120': '108514.56000000004'
          },
          {
            '30001': '云南',
            '241028194022035': '1342',
            '241028194022106': '云南',
            '241028194022120': '809532.2759999987'
          },
          {
            '30001': '湖北',
            '241028194022035': '3930',
            '241028194022106': '湖北',
            '241028194022120': '1135031.3799999973'
          },
          {
            '30001': '浙江',
            '241028194022035': '2531',
            '241028194022106': '浙江',
            '241028194022120': '862612.6599999986'
          },
          {
            '30001': '重庆',
            '241028194022035': '1783',
            '241028194022106': '重庆',
            '241028194022120': '807109.0719999996'
          },
          {
            '30001': '安徽',
            '241028194022035': '1773',
            '241028194022106': '安徽',
            '241028194022120': '841010.1350000012'
          },
          {
            '30001': '北京',
            '241028194022035': '1741',
            '241028194022106': '北京',
            '241028194022120': '699021.819999998'
          },
          {
            '30001': '陕西',
            '241028194022035': '1884',
            '241028194022106': '陕西',
            '241028194022120': '1053627.8480000005'
          },
          {
            '30001': '贵州',
            '241028194022035': '392',
            '241028194022106': '贵州',
            '241028194022120': '195899.87199999994'
          },
          {
            '30001': '山东',
            '241028194022035': '4927',
            '241028194022106': '山东',
            '241028194022120': '2682392.048'
          },
          {
            '30001': '河南',
            '241028194022035': '2492',
            '241028194022106': '河南',
            '241028194022120': '1262248.9949999999'
          },
          {
            '30001': '江苏',
            '241028194022035': '3023',
            '241028194022106': '江苏',
            '241028194022120': '902723.5840000001'
          },
          {
            '30001': '广西',
            '241028194022035': '1065',
            '241028194022106': '广西',
            '241028194022120': '576179.1350000004'
          },
          {
            '30001': '内蒙古',
            '241028194022035': '1374',
            '241028194022106': '内蒙古',
            '241028194022120': '410020.9119999994'
          },
          {
            '30001': '黑龙江',
            '241028194022035': '3824',
            '241028194022106': '黑龙江',
            '241028194022120': '1741427.1000000006'
          },
          {
            '30001': '西藏自治区',
            '241028194022035': '34',
            '241028194022106': '西藏自治区',
            '241028194022120': '10015.18'
          }
        ],
        fields: {
          '30001': {
            alias: '图例项 '
          },
          '241028194022035': {
            alias: '数量'
          },
          '241028194022106': {
            alias: '省/自治区'
          },
          '241028194022120': {
            alias: '销售额'
          }
        }
      }
    ],
    axes: [
      {
        type: 'linear',
        tick: {
          visible: false,
          style: {
            stroke: '#8D8D8D'
          }
        },
        niceType: 'accurateFirst',
        zIndex: 200,
        grid: {
          visible: true,
          style: {
            zIndex: 150,
            stroke: '#DADCDD',
            lineWidth: 1,
            lineDash: [4, 2]
          }
        },
        orient: 'left',
        visible: true,
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#8D8D8D'
          }
        },
        title: {
          visible: false,
          text: '销售额',
          space: 8,
          style: {
            fontSize: 12,
            fill: '#363839',
            fontWeight: 'normal'
          }
        },
        autoIndent: false,
        sampling: false,
        label: {
          visible: true,
          space: 6,
          flush: true,
          padding: 0,
          style: {
            fontSize: 12,
            maxLineWidth: 174,
            fill: '#6F6F6F',
            angle: 0,
            fontWeight: 'normal',
            dy: 0,
            direction: 'horizontal'
          },
          autoHide: true,
          autoHideMethod: 'greedy'
        },
        background: {
          visible: true,
          state: {
            hover: {
              fillOpacity: 0.08,
              fill: '#141414'
            },
            hover_reverse: {
              fillOpacity: 0.08,
              fill: '#141414'
            }
          }
        },
        innerOffset: {
          top: 15.065857732696886,
          right: 15.065857732696886
        },
        zero: true,
        nice: true
      },
      {
        type: 'linear',
        tick: {
          visible: false,
          style: {
            stroke: '#8D8D8D'
          }
        },
        niceType: 'accurateFirst',
        zIndex: 200,
        grid: {
          visible: true,
          style: {
            zIndex: 150,
            stroke: '#DADCDD',
            lineWidth: 1,
            lineDash: [4, 2]
          }
        },
        orient: 'bottom',
        visible: true,
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#8D8D8D'
          }
        },
        title: {
          visible: false,
          text: '数量',
          space: 8,
          style: {
            fontSize: 12,
            fill: '#363839',
            fontWeight: 'normal'
          }
        },
        autoIndent: false,
        sampling: false,
        label: {
          visible: true,
          space: 4,
          flush: true,
          padding: 0,
          style: {
            fontSize: 12,
            maxLineWidth: 174,
            fill: '#6F6F6F',
            angle: 0,
            fontWeight: 'normal',
            dy: 0,
            direction: 'horizontal'
          },
          autoHide: true,
          autoHideMethod: 'greedy'
        },
        background: {
          visible: true,
          state: {
            hover: {
              fillOpacity: 0.08,
              fill: '#141414'
            },
            hover_reverse: {
              fillOpacity: 0.08,
              fill: '#141414'
            }
          }
        },
        innerOffset: {
          top: 15.065857732696886,
          right: 15.065857732696886
        },
        zero: true,
        nice: true
      }
    ],
    label: {
      visible: false,
      offset: 6,
      overlap: {
        hideOnHit: true,
        avoidBaseMark: false,
        strategy: [
          {
            type: 'position',
            position: ['top', 'bottom']
          }
        ],
        clampForce: true
      },
      style: {
        fontSize: 12,
        fontWeight: 'normal',
        zIndex: 400,
        lineHeight: '100%',
        fill: '#363839',
        stroke: 'rgba(255, 255, 255, 0.8)',
        lineWidth: 2,
        strokeOpacity: 1
      },
      position: 'top'
    },
    color: {
      field: null,
      type: 'ordinal',
      range: ['#2E62F1']
    },
    tooltip: {
      handler: {}
    },
    point: {
      state: {
        hover: {
          cursor: 'pointer',
          fillOpacity: 0.8,
          stroke: '#58595B',
          lineWidth: 1,
          zIndex: 500
        }
      }
    },
    background: 'rgba(255, 255, 255, 0)',
    hover: {
      enable: true
    },
    select: {
      enable: true
    },
    animation: false,
    brush: {
      inBrush: {
        fillOpacity: 1,
        stroke: '#58595B',
        lineWidth: 1,
        strokeOpacity: 1,
        colorAlpha: 1
      },
      outOfBrush: {
        colorAlpha: 0.2,
        fillOpacity: 0.3,
        lineWidth: 0.3
      }
    },
    hash: '9b4d00352028ff77856ec02f4c5745ca'
  }
};

export const ScatterIrisData = {
  spec: {
    direction: 'vertical',
    type: 'common',
    color: ['#00295C', '#2568BD', '#9F9F9F', '#C5C5C5', '#00B0F0', '#4BCFFF', '#C2C2C2', '#D7D7D7'],
    series: [
      {
        point: {
          style: {
            stroke: '#ffffff',
            lineWidth: 0,
            fillOpacity: 0.8,
            symbolType: 'circle'
          }
        },
        label: {
          style: {
            fontSize: 16,
            fontWeight: 'bold',
            fillOpacity: 1,
            lineJoin: 'bevel',
            lineWidth: 2,
            stroke: '#ffffff',
            lineHeight: '100%'
          },
          visible: true,
          offset: 5,
          position: 'top',
          overlap: {
            strategy: []
          },
          smartInvert: true,
          formatConfig: {
            content: 'text'
          },
          interactive: true
        },
        direction: 'vertical',
        type: 'scatter',
        stack: false,
        invalidType: 'ignore',
        _editor_spec_text_field: 'Id',
        xField: 'SepalLengthCm',
        yField: 'SepalWidthCm',
        sizeField: 'PetalLengthCm',
        size: [5, 20],
        dataId: '0',
        id: 'series-0',
        seriesField: 'Species',
        _editor_spec_size_field: 'PetalLengthCm',
        animation: false,
        animationThreshold: 2000
      }
    ],
    legends: {
      orient: 'bottom',
      position: 'start',
      padding: {
        right: 24,
        bottom: 0,
        left: 24,
        top: 16
      },
      title: {
        visible: false,
        padding: 0,
        textStyle: {
          fontSize: 12,
          lineHeight: '130%',
          fill: '#21252c',
          fontWeight: 'normal'
        },
        space: 12
      },
      pager: {
        textStyle: {
          fill: 'rgb(51, 51, 51)'
        },
        handler: {
          style: {
            fill: 'rgb(47, 69, 84)'
          },
          state: {
            disable: {
              fill: 'rgb(170, 170, 170)'
            }
          }
        }
      },
      item: {
        visible: true,
        spaceCol: 10,
        spaceRow: 6,
        padding: 2,
        background: {
          state: {
            selectedHover: {
              fill: '#f1f2f5'
            },
            unSelectedHover: {
              fill: '#f1f2f5'
            }
          }
        },
        shape: {
          space: 6,
          style: {
            lineWidth: 0,
            fillOpacity: 1,
            opacity: 1
          },
          state: {
            unSelected: {
              fillOpacity: 0.2,
              opacity: 1
            }
          }
        },
        label: {
          space: 6,
          style: {
            fill: '#1F2329',
            fontSize: 16,
            lineHeight: '130%',
            opacity: 1
          },
          state: {
            unSelected: {
              fill: '#bcc1cb',
              opacity: 1
            }
          }
        }
      },
      allowAllCanceled: false,
      id: 'legend-discrete',
      visible: true,
      autoPage: false,
      interactive: false,
      _originalVisible: true
    },
    region: [
      {
        id: 'region-0'
      }
    ],
    tooltip: {
      visible: true,
      mark: {
        content: [{}]
      },
      dimension: {
        content: [{}]
      },
      style: {
        offset: {
          x: 10,
          y: 10
        },
        panel: {
          padding: {
            top: 10,
            left: 10,
            right: 10,
            bottom: 10
          },
          backgroundColor: '#ffffff',
          border: {
            color: '#ffffff',
            width: 0,
            radius: 3
          },
          shadow: {
            x: 0,
            y: 4,
            blur: 12,
            spread: 0,
            color: 'rgba(33,37,44,0.1)'
          }
        },
        spaceRow: 6,
        titleLabel: {
          fontSize: 14,
          lineHeight: '150%',
          fontColor: '#21252c',
          fontWeight: 'bold',
          textBaseline: 'middle',
          spacing: 0
        },
        shape: {
          size: 8,
          spacing: 6
        },
        keyLabel: {
          fontSize: 14,
          lineHeight: '150%',
          fontColor: '#606773',
          textBaseline: 'middle',
          spacing: 26
        },
        valueLabel: {
          fontSize: 14,
          lineHeight: '150%',
          fontColor: '#21252c',
          fontWeight: 'bold',
          textBaseline: 'middle',
          spacing: 0
        }
      },
      offset: {
        x: 10,
        y: 10
      },
      transitionDuration: 150,
      activeType: ['mark', 'dimension', 'group'],
      renderMode: 'html',
      trigger: 'hover',
      className: 'vchart-tooltip-element',
      enterable: false,
      confine: false,
      parentElement: {}
    },
    title: {
      padding: {
        top: 4,
        bottom: 20
      },
      textStyle: {
        fontSize: 16,
        lineHeight: '150%',
        fill: '#ccc',
        fontWeight: 'bold',
        fontStyle: 'normal',
        underline: 0,
        stroke: false,
        align: 'left',
        textBaseline: 'middle',
        background: false
      },
      subtextStyle: {
        fontSize: 14,
        lineHeight: '150%',
        fill: '#89909d',
        visible: false
      },
      id: 'chart_title',
      visible: true,
      minWidth: '100%',
      verticalAlign: 'middle',
      _initialize_: true,
      text: '双击添加标题'
    },
    axes: [
      {
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#000000',
            strokeOpacity: 1
          }
        },
        grid: {
          visible: false,
          style: {
            lineWidth: 1,
            stroke: '#bbbfc4',
            strokeOpacity: 1,
            lineDash: [],
            pickStrokeBuffer: 2
          }
        },
        subGrid: {
          visible: false,
          style: {
            lineWidth: 1,
            stroke: '#f1f2f5',
            strokeOpacity: 1,
            lineDash: [4, 4]
          }
        },
        tick: {
          visible: true,
          inside: false,
          tickSize: 4,
          alignWithLabel: true,
          style: {
            lineWidth: 1,
            stroke: '#000000',
            strokeOpacity: 1
          }
        },
        subTick: {
          visible: false,
          tickSize: 2,
          style: {
            lineWidth: 1,
            stroke: '#d9dde4',
            strokeOpacity: 1
          }
        },
        label: {
          visible: true,
          inside: false,
          space: 12,
          style: {
            fontSize: 16,
            fill: '#1F2329',
            fontWeight: 'normal',
            fillOpacity: 1
          },
          autoLimit: false,
          formatConfig: {},
          _originStyle: {
            fill: '#1F2329',
            fontSize: 16
          }
        },
        title: {
          space: 12,
          padding: 0,
          style: {
            fontSize: 12,
            lineHeight: '130%',
            fill: '#606773',
            fontWeight: 'normal',
            fillOpacity: 1
          },
          autoRotate: true
        },
        maxWidth: null,
        unit: {
          visible: false,
          style: {
            fontSize: 12,
            fill: '#89909d',
            fontWeight: 'normal',
            fillOpacity: 1
          }
        },
        autoIndent: false,
        maxHeight: null,
        orient: 'left',
        id: 'axis-left',
        type: 'linear',
        zero: false
      },
      {
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#000000',
            strokeOpacity: 1
          }
        },
        grid: {
          visible: false,
          style: {
            lineWidth: 1,
            stroke: '#bbbfc4',
            strokeOpacity: 1,
            lineDash: [],
            pickStrokeBuffer: 2
          }
        },
        subGrid: {
          visible: false,
          style: {
            lineWidth: 1,
            stroke: '#f1f2f5',
            strokeOpacity: 1,
            lineDash: [4, 4]
          }
        },
        tick: {
          visible: true,
          inside: false,
          tickSize: 4,
          alignWithLabel: true,
          style: {
            lineWidth: 1,
            stroke: '#000000',
            strokeOpacity: 1
          }
        },
        subTick: {
          visible: false,
          tickSize: 2,
          style: {
            lineWidth: 1,
            stroke: '#d9dde4',
            strokeOpacity: 1
          }
        },
        label: {
          visible: true,
          inside: false,
          space: 8,
          style: {
            fontSize: 16,
            fill: '#1F2329',
            fontWeight: 'normal',
            fillOpacity: 1
          },
          autoLimit: false,
          formatConfig: {},
          _originStyle: {
            fill: '#1F2329',
            fontSize: 16
          }
        },
        title: {
          space: 8,
          padding: 0,
          style: {
            fontSize: 12,
            lineHeight: '130%',
            fill: '#606773',
            fontWeight: 'normal',
            fillOpacity: 1
          }
        },
        maxHeight: null,
        unit: {
          visible: false,
          style: {
            fontSize: 12,
            fill: '#89909d',
            fontWeight: 'normal',
            fillOpacity: 1
          }
        },
        autoIndent: false,
        maxWidth: null,
        orient: 'bottom',
        id: 'axis-bottom',
        type: 'linear',
        zero: false
      }
    ],
    data: [
      {
        id: '0',
        values: [
          {
            Id: '1',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.5,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '2',
            SepalLengthCm: 4.9,
            SepalWidthCm: 3,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '3',
            SepalLengthCm: 4.7,
            SepalWidthCm: 3.2,
            PetalLengthCm: 1.3,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '4',
            SepalLengthCm: 4.6,
            SepalWidthCm: 3.1,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '5',
            SepalLengthCm: 5,
            SepalWidthCm: 3.6,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '6',
            SepalLengthCm: 5.4,
            SepalWidthCm: 3.9,
            PetalLengthCm: 1.7,
            PetalWidthCm: 0.4,
            Species: 'Iris-setosa'
          },
          {
            Id: '7',
            SepalLengthCm: 4.6,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.3,
            Species: 'Iris-setosa'
          },
          {
            Id: '8',
            SepalLengthCm: 5,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '9',
            SepalLengthCm: 4.4,
            SepalWidthCm: 2.9,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '10',
            SepalLengthCm: 4.9,
            SepalWidthCm: 3.1,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.1,
            Species: 'Iris-setosa'
          },
          {
            Id: '11',
            SepalLengthCm: 5.4,
            SepalWidthCm: 3.7,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '12',
            SepalLengthCm: 4.8,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.6,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '13',
            SepalLengthCm: 4.8,
            SepalWidthCm: 3,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.1,
            Species: 'Iris-setosa'
          },
          {
            Id: '14',
            SepalLengthCm: 4.3,
            SepalWidthCm: 3,
            PetalLengthCm: 1.1,
            PetalWidthCm: 0.1,
            Species: 'Iris-setosa'
          },
          {
            Id: '15',
            SepalLengthCm: 5.8,
            SepalWidthCm: 4,
            PetalLengthCm: 1.2,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '16',
            SepalLengthCm: 5.7,
            SepalWidthCm: 4.4,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.4,
            Species: 'Iris-setosa'
          },
          {
            Id: '17',
            SepalLengthCm: 5.4,
            SepalWidthCm: 3.9,
            PetalLengthCm: 1.3,
            PetalWidthCm: 0.4,
            Species: 'Iris-setosa'
          },
          {
            Id: '18',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.5,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.3,
            Species: 'Iris-setosa'
          },
          {
            Id: '19',
            SepalLengthCm: 5.7,
            SepalWidthCm: 3.8,
            PetalLengthCm: 1.7,
            PetalWidthCm: 0.3,
            Species: 'Iris-setosa'
          },
          {
            Id: '20',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.8,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.3,
            Species: 'Iris-setosa'
          },
          {
            Id: '21',
            SepalLengthCm: 5.4,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.7,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '22',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.7,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.4,
            Species: 'Iris-setosa'
          },
          {
            Id: '23',
            SepalLengthCm: 4.6,
            SepalWidthCm: 3.6,
            PetalLengthCm: 1,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '24',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.3,
            PetalLengthCm: 1.7,
            PetalWidthCm: 0.5,
            Species: 'Iris-setosa'
          },
          {
            Id: '25',
            SepalLengthCm: 4.8,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.9,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '26',
            SepalLengthCm: 5,
            SepalWidthCm: 3,
            PetalLengthCm: 1.6,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '27',
            SepalLengthCm: 5,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.6,
            PetalWidthCm: 0.4,
            Species: 'Iris-setosa'
          },
          {
            Id: '28',
            SepalLengthCm: 5.2,
            SepalWidthCm: 3.5,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '29',
            SepalLengthCm: 5.2,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '30',
            SepalLengthCm: 4.7,
            SepalWidthCm: 3.2,
            PetalLengthCm: 1.6,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '31',
            SepalLengthCm: 4.8,
            SepalWidthCm: 3.1,
            PetalLengthCm: 1.6,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '32',
            SepalLengthCm: 5.4,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.4,
            Species: 'Iris-setosa'
          },
          {
            Id: '33',
            SepalLengthCm: 5.2,
            SepalWidthCm: 4.1,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.1,
            Species: 'Iris-setosa'
          },
          {
            Id: '34',
            SepalLengthCm: 5.5,
            SepalWidthCm: 4.2,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '35',
            SepalLengthCm: 4.9,
            SepalWidthCm: 3.1,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.1,
            Species: 'Iris-setosa'
          },
          {
            Id: '36',
            SepalLengthCm: 5,
            SepalWidthCm: 3.2,
            PetalLengthCm: 1.2,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '37',
            SepalLengthCm: 5.5,
            SepalWidthCm: 3.5,
            PetalLengthCm: 1.3,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '38',
            SepalLengthCm: 4.9,
            SepalWidthCm: 3.1,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.1,
            Species: 'Iris-setosa'
          },
          {
            Id: '39',
            SepalLengthCm: 4.4,
            SepalWidthCm: 3,
            PetalLengthCm: 1.3,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '40',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.4,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '41',
            SepalLengthCm: 5,
            SepalWidthCm: 3.5,
            PetalLengthCm: 1.3,
            PetalWidthCm: 0.3,
            Species: 'Iris-setosa'
          },
          {
            Id: '42',
            SepalLengthCm: 4.5,
            SepalWidthCm: 2.3,
            PetalLengthCm: 1.3,
            PetalWidthCm: 0.3,
            Species: 'Iris-setosa'
          },
          {
            Id: '43',
            SepalLengthCm: 4.4,
            SepalWidthCm: 3.2,
            PetalLengthCm: 1.3,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '44',
            SepalLengthCm: 5,
            SepalWidthCm: 3.5,
            PetalLengthCm: 1.6,
            PetalWidthCm: 0.6,
            Species: 'Iris-setosa'
          },
          {
            Id: '45',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.8,
            PetalLengthCm: 1.9,
            PetalWidthCm: 0.4,
            Species: 'Iris-setosa'
          },
          {
            Id: '46',
            SepalLengthCm: 4.8,
            SepalWidthCm: 3,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.3,
            Species: 'Iris-setosa'
          },
          {
            Id: '47',
            SepalLengthCm: 5.1,
            SepalWidthCm: 3.8,
            PetalLengthCm: 1.6,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '48',
            SepalLengthCm: 4.6,
            SepalWidthCm: 3.2,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '49',
            SepalLengthCm: 5.3,
            SepalWidthCm: 3.7,
            PetalLengthCm: 1.5,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '50',
            SepalLengthCm: 5,
            SepalWidthCm: 3.3,
            PetalLengthCm: 1.4,
            PetalWidthCm: 0.2,
            Species: 'Iris-setosa'
          },
          {
            Id: '51',
            SepalLengthCm: 7,
            SepalWidthCm: 3.2,
            PetalLengthCm: 4.7,
            PetalWidthCm: 1.4,
            Species: 'Iris-versicolor'
          },
          {
            Id: '52',
            SepalLengthCm: 6.4,
            SepalWidthCm: 3.2,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '53',
            SepalLengthCm: 6.9,
            SepalWidthCm: 3.1,
            PetalLengthCm: 4.9,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '54',
            SepalLengthCm: 5.5,
            SepalWidthCm: 2.3,
            PetalLengthCm: 4,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '55',
            SepalLengthCm: 6.5,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4.6,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '56',
            SepalLengthCm: 5.7,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '57',
            SepalLengthCm: 6.3,
            SepalWidthCm: 3.3,
            PetalLengthCm: 4.7,
            PetalWidthCm: 1.6,
            Species: 'Iris-versicolor'
          },
          {
            Id: '58',
            SepalLengthCm: 4.9,
            SepalWidthCm: 2.4,
            PetalLengthCm: 3.3,
            PetalWidthCm: 1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '59',
            SepalLengthCm: 6.6,
            SepalWidthCm: 2.9,
            PetalLengthCm: 4.6,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '60',
            SepalLengthCm: 5.2,
            SepalWidthCm: 2.7,
            PetalLengthCm: 3.9,
            PetalWidthCm: 1.4,
            Species: 'Iris-versicolor'
          },
          {
            Id: '61',
            SepalLengthCm: 5,
            SepalWidthCm: 2,
            PetalLengthCm: 3.5,
            PetalWidthCm: 1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '62',
            SepalLengthCm: 5.9,
            SepalWidthCm: 3,
            PetalLengthCm: 4.2,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '63',
            SepalLengthCm: 6,
            SepalWidthCm: 2.2,
            PetalLengthCm: 4,
            PetalWidthCm: 1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '64',
            SepalLengthCm: 6.1,
            SepalWidthCm: 2.9,
            PetalLengthCm: 4.7,
            PetalWidthCm: 1.4,
            Species: 'Iris-versicolor'
          },
          {
            Id: '65',
            SepalLengthCm: 5.6,
            SepalWidthCm: 2.9,
            PetalLengthCm: 3.6,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '66',
            SepalLengthCm: 6.7,
            SepalWidthCm: 3.1,
            PetalLengthCm: 4.4,
            PetalWidthCm: 1.4,
            Species: 'Iris-versicolor'
          },
          {
            Id: '67',
            SepalLengthCm: 5.6,
            SepalWidthCm: 3,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '68',
            SepalLengthCm: 5.8,
            SepalWidthCm: 2.7,
            PetalLengthCm: 4.1,
            PetalWidthCm: 1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '69',
            SepalLengthCm: 6.2,
            SepalWidthCm: 2.2,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '70',
            SepalLengthCm: 5.6,
            SepalWidthCm: 2.5,
            PetalLengthCm: 3.9,
            PetalWidthCm: 1.1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '71',
            SepalLengthCm: 5.9,
            SepalWidthCm: 3.2,
            PetalLengthCm: 4.8,
            PetalWidthCm: 1.8,
            Species: 'Iris-versicolor'
          },
          {
            Id: '72',
            SepalLengthCm: 6.1,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '73',
            SepalLengthCm: 6.3,
            SepalWidthCm: 2.5,
            PetalLengthCm: 4.9,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '74',
            SepalLengthCm: 6.1,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4.7,
            PetalWidthCm: 1.2,
            Species: 'Iris-versicolor'
          },
          {
            Id: '75',
            SepalLengthCm: 6.4,
            SepalWidthCm: 2.9,
            PetalLengthCm: 4.3,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '76',
            SepalLengthCm: 6.6,
            SepalWidthCm: 3,
            PetalLengthCm: 4.4,
            PetalWidthCm: 1.4,
            Species: 'Iris-versicolor'
          },
          {
            Id: '77',
            SepalLengthCm: 6.8,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4.8,
            PetalWidthCm: 1.4,
            Species: 'Iris-versicolor'
          },
          {
            Id: '78',
            SepalLengthCm: 6.7,
            SepalWidthCm: 3,
            PetalLengthCm: 5,
            PetalWidthCm: 1.7,
            Species: 'Iris-versicolor'
          },
          {
            Id: '79',
            SepalLengthCm: 6,
            SepalWidthCm: 2.9,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '80',
            SepalLengthCm: 5.7,
            SepalWidthCm: 2.6,
            PetalLengthCm: 3.5,
            PetalWidthCm: 1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '81',
            SepalLengthCm: 5.5,
            SepalWidthCm: 2.4,
            PetalLengthCm: 3.8,
            PetalWidthCm: 1.1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '82',
            SepalLengthCm: 5.5,
            SepalWidthCm: 2.4,
            PetalLengthCm: 3.7,
            PetalWidthCm: 1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '83',
            SepalLengthCm: 5.8,
            SepalWidthCm: 2.7,
            PetalLengthCm: 3.9,
            PetalWidthCm: 1.2,
            Species: 'Iris-versicolor'
          },
          {
            Id: '84',
            SepalLengthCm: 6,
            SepalWidthCm: 2.7,
            PetalLengthCm: 5.1,
            PetalWidthCm: 1.6,
            Species: 'Iris-versicolor'
          },
          {
            Id: '85',
            SepalLengthCm: 5.4,
            SepalWidthCm: 3,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '86',
            SepalLengthCm: 6,
            SepalWidthCm: 3.4,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.6,
            Species: 'Iris-versicolor'
          },
          {
            Id: '87',
            SepalLengthCm: 6.7,
            SepalWidthCm: 3.1,
            PetalLengthCm: 4.7,
            PetalWidthCm: 1.5,
            Species: 'Iris-versicolor'
          },
          {
            Id: '88',
            SepalLengthCm: 6.3,
            SepalWidthCm: 2.3,
            PetalLengthCm: 4.4,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '89',
            SepalLengthCm: 5.6,
            SepalWidthCm: 3,
            PetalLengthCm: 4.1,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '90',
            SepalLengthCm: 5.5,
            SepalWidthCm: 2.5,
            PetalLengthCm: 4,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '91',
            SepalLengthCm: 5.5,
            SepalWidthCm: 2.6,
            PetalLengthCm: 4.4,
            PetalWidthCm: 1.2,
            Species: 'Iris-versicolor'
          },
          {
            Id: '92',
            SepalLengthCm: 6.1,
            SepalWidthCm: 3,
            PetalLengthCm: 4.6,
            PetalWidthCm: 1.4,
            Species: 'Iris-versicolor'
          },
          {
            Id: '93',
            SepalLengthCm: 5.8,
            SepalWidthCm: 2.6,
            PetalLengthCm: 4,
            PetalWidthCm: 1.2,
            Species: 'Iris-versicolor'
          },
          {
            Id: '94',
            SepalLengthCm: 5,
            SepalWidthCm: 2.3,
            PetalLengthCm: 3.3,
            PetalWidthCm: 1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '95',
            SepalLengthCm: 5.6,
            SepalWidthCm: 2.7,
            PetalLengthCm: 4.2,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '96',
            SepalLengthCm: 5.7,
            SepalWidthCm: 3,
            PetalLengthCm: 4.2,
            PetalWidthCm: 1.2,
            Species: 'Iris-versicolor'
          },
          {
            Id: '97',
            SepalLengthCm: 5.7,
            SepalWidthCm: 2.9,
            PetalLengthCm: 4.2,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '98',
            SepalLengthCm: 6.2,
            SepalWidthCm: 2.9,
            PetalLengthCm: 4.3,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '99',
            SepalLengthCm: 5.1,
            SepalWidthCm: 2.5,
            PetalLengthCm: 3,
            PetalWidthCm: 1.1,
            Species: 'Iris-versicolor'
          },
          {
            Id: '100',
            SepalLengthCm: 5.7,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4.1,
            PetalWidthCm: 1.3,
            Species: 'Iris-versicolor'
          },
          {
            Id: '101',
            SepalLengthCm: 6.3,
            SepalWidthCm: 3.3,
            PetalLengthCm: 6,
            PetalWidthCm: 2.5,
            Species: 'Iris-virginica'
          },
          {
            Id: '102',
            SepalLengthCm: 5.8,
            SepalWidthCm: 2.7,
            PetalLengthCm: 5.1,
            PetalWidthCm: 1.9,
            Species: 'Iris-virginica'
          },
          {
            Id: '103',
            SepalLengthCm: 7.1,
            SepalWidthCm: 3,
            PetalLengthCm: 5.9,
            PetalWidthCm: 2.1,
            Species: 'Iris-virginica'
          },
          {
            Id: '104',
            SepalLengthCm: 6.3,
            SepalWidthCm: 2.9,
            PetalLengthCm: 5.6,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '105',
            SepalLengthCm: 6.5,
            SepalWidthCm: 3,
            PetalLengthCm: 5.8,
            PetalWidthCm: 2.2,
            Species: 'Iris-virginica'
          },
          {
            Id: '106',
            SepalLengthCm: 7.6,
            SepalWidthCm: 3,
            PetalLengthCm: 6.6,
            PetalWidthCm: 2.1,
            Species: 'Iris-virginica'
          },
          {
            Id: '107',
            SepalLengthCm: 4.9,
            SepalWidthCm: 2.5,
            PetalLengthCm: 4.5,
            PetalWidthCm: 1.7,
            Species: 'Iris-virginica'
          },
          {
            Id: '108',
            SepalLengthCm: 7.3,
            SepalWidthCm: 2.9,
            PetalLengthCm: 6.3,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '109',
            SepalLengthCm: 6.7,
            SepalWidthCm: 2.5,
            PetalLengthCm: 5.8,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '110',
            SepalLengthCm: 7.2,
            SepalWidthCm: 3.6,
            PetalLengthCm: 6.1,
            PetalWidthCm: 2.5,
            Species: 'Iris-virginica'
          },
          {
            Id: '111',
            SepalLengthCm: 6.5,
            SepalWidthCm: 3.2,
            PetalLengthCm: 5.1,
            PetalWidthCm: 2,
            Species: 'Iris-virginica'
          },
          {
            Id: '112',
            SepalLengthCm: 6.4,
            SepalWidthCm: 2.7,
            PetalLengthCm: 5.3,
            PetalWidthCm: 1.9,
            Species: 'Iris-virginica'
          },
          {
            Id: '113',
            SepalLengthCm: 6.8,
            SepalWidthCm: 3,
            PetalLengthCm: 5.5,
            PetalWidthCm: 2.1,
            Species: 'Iris-virginica'
          },
          {
            Id: '114',
            SepalLengthCm: 5.7,
            SepalWidthCm: 2.5,
            PetalLengthCm: 5,
            PetalWidthCm: 2,
            Species: 'Iris-virginica'
          },
          {
            Id: '115',
            SepalLengthCm: 5.8,
            SepalWidthCm: 2.8,
            PetalLengthCm: 5.1,
            PetalWidthCm: 2.4,
            Species: 'Iris-virginica'
          },
          {
            Id: '116',
            SepalLengthCm: 6.4,
            SepalWidthCm: 3.2,
            PetalLengthCm: 5.3,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '117',
            SepalLengthCm: 6.5,
            SepalWidthCm: 3,
            PetalLengthCm: 5.5,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '118',
            SepalLengthCm: 7.7,
            SepalWidthCm: 3.8,
            PetalLengthCm: 6.7,
            PetalWidthCm: 2.2,
            Species: 'Iris-virginica'
          },
          {
            Id: '119',
            SepalLengthCm: 7.7,
            SepalWidthCm: 2.6,
            PetalLengthCm: 6.9,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '120',
            SepalLengthCm: 6,
            SepalWidthCm: 2.2,
            PetalLengthCm: 5,
            PetalWidthCm: 1.5,
            Species: 'Iris-virginica'
          },
          {
            Id: '121',
            SepalLengthCm: 6.9,
            SepalWidthCm: 3.2,
            PetalLengthCm: 5.7,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '122',
            SepalLengthCm: 5.6,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4.9,
            PetalWidthCm: 2,
            Species: 'Iris-virginica'
          },
          {
            Id: '123',
            SepalLengthCm: 7.7,
            SepalWidthCm: 2.8,
            PetalLengthCm: 6.7,
            PetalWidthCm: 2,
            Species: 'Iris-virginica'
          },
          {
            Id: '124',
            SepalLengthCm: 6.3,
            SepalWidthCm: 2.7,
            PetalLengthCm: 4.9,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '125',
            SepalLengthCm: 6.7,
            SepalWidthCm: 3.3,
            PetalLengthCm: 5.7,
            PetalWidthCm: 2.1,
            Species: 'Iris-virginica'
          },
          {
            Id: '126',
            SepalLengthCm: 7.2,
            SepalWidthCm: 3.2,
            PetalLengthCm: 6,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '127',
            SepalLengthCm: 6.2,
            SepalWidthCm: 2.8,
            PetalLengthCm: 4.8,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '128',
            SepalLengthCm: 6.1,
            SepalWidthCm: 3,
            PetalLengthCm: 4.9,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '129',
            SepalLengthCm: 6.4,
            SepalWidthCm: 2.8,
            PetalLengthCm: 5.6,
            PetalWidthCm: 2.1,
            Species: 'Iris-virginica'
          },
          {
            Id: '130',
            SepalLengthCm: 7.2,
            SepalWidthCm: 3,
            PetalLengthCm: 5.8,
            PetalWidthCm: 1.6,
            Species: 'Iris-virginica'
          },
          {
            Id: '131',
            SepalLengthCm: 7.4,
            SepalWidthCm: 2.8,
            PetalLengthCm: 6.1,
            PetalWidthCm: 1.9,
            Species: 'Iris-virginica'
          },
          {
            Id: '132',
            SepalLengthCm: 7.9,
            SepalWidthCm: 3.8,
            PetalLengthCm: 6.4,
            PetalWidthCm: 2,
            Species: 'Iris-virginica'
          },
          {
            Id: '133',
            SepalLengthCm: 6.4,
            SepalWidthCm: 2.8,
            PetalLengthCm: 5.6,
            PetalWidthCm: 2.2,
            Species: 'Iris-virginica'
          },
          {
            Id: '134',
            SepalLengthCm: 6.3,
            SepalWidthCm: 2.8,
            PetalLengthCm: 5.1,
            PetalWidthCm: 1.5,
            Species: 'Iris-virginica'
          },
          {
            Id: '135',
            SepalLengthCm: 6.1,
            SepalWidthCm: 2.6,
            PetalLengthCm: 5.6,
            PetalWidthCm: 1.4,
            Species: 'Iris-virginica'
          },
          {
            Id: '136',
            SepalLengthCm: 7.7,
            SepalWidthCm: 3,
            PetalLengthCm: 6.1,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '137',
            SepalLengthCm: 6.3,
            SepalWidthCm: 3.4,
            PetalLengthCm: 5.6,
            PetalWidthCm: 2.4,
            Species: 'Iris-virginica'
          },
          {
            Id: '138',
            SepalLengthCm: 6.4,
            SepalWidthCm: 3.1,
            PetalLengthCm: 5.5,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '139',
            SepalLengthCm: 6,
            SepalWidthCm: 3,
            PetalLengthCm: 4.8,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          },
          {
            Id: '140',
            SepalLengthCm: 6.9,
            SepalWidthCm: 3.1,
            PetalLengthCm: 5.4,
            PetalWidthCm: 2.1,
            Species: 'Iris-virginica'
          },
          {
            Id: '141',
            SepalLengthCm: 6.7,
            SepalWidthCm: 3.1,
            PetalLengthCm: 5.6,
            PetalWidthCm: 2.4,
            Species: 'Iris-virginica'
          },
          {
            Id: '142',
            SepalLengthCm: 6.9,
            SepalWidthCm: 3.1,
            PetalLengthCm: 5.1,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '143',
            SepalLengthCm: 5.8,
            SepalWidthCm: 2.7,
            PetalLengthCm: 5.1,
            PetalWidthCm: 1.9,
            Species: 'Iris-virginica'
          },
          {
            Id: '144',
            SepalLengthCm: 6.8,
            SepalWidthCm: 3.2,
            PetalLengthCm: 5.9,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '145',
            SepalLengthCm: 6.7,
            SepalWidthCm: 3.3,
            PetalLengthCm: 5.7,
            PetalWidthCm: 2.5,
            Species: 'Iris-virginica'
          },
          {
            Id: '146',
            SepalLengthCm: 6.7,
            SepalWidthCm: 3,
            PetalLengthCm: 5.2,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '147',
            SepalLengthCm: 6.3,
            SepalWidthCm: 2.5,
            PetalLengthCm: 5,
            PetalWidthCm: 1.9,
            Species: 'Iris-virginica'
          },
          {
            Id: '148',
            SepalLengthCm: 6.5,
            SepalWidthCm: 3,
            PetalLengthCm: 5.2,
            PetalWidthCm: 2,
            Species: 'Iris-virginica'
          },
          {
            Id: '149',
            SepalLengthCm: 6.2,
            SepalWidthCm: 3.4,
            PetalLengthCm: 5.4,
            PetalWidthCm: 2.3,
            Species: 'Iris-virginica'
          },
          {
            Id: '150',
            SepalLengthCm: 5.9,
            SepalWidthCm: 3,
            PetalLengthCm: 5.1,
            PetalWidthCm: 1.8,
            Species: 'Iris-virginica'
          }
        ]
      }
    ],
    scales: [
      {
        id: '_lark_vchart_scatter_size_scale',
        type: 'linear',
        domain: [
          {
            dataId: '0',
            fields: ['PetalLengthCm']
          }
        ],
        range: [5, 50]
      }
    ],
    labelLayout: 'region',
    _editor_update_tag: true
  }
};
