
# VMind Site Guide

The purpose of this article is to help you use the VMind website more effectively and quickly find the information you need.

## Quick Start

### Getting Started

First, you need to read the [Getting Started](./Getting_Started) section of VMind. This section will teach you how to configure and use the environment required by VMind, as well as how to use VMind to build your first intelligent visualization application.

### Learn More About VMind

After you complete [Getting Started](./Getting_Started), you can learn about the functional positioning and related concepts of VMind in [Intro to VMind](./Intro_to_VMind). The [Create VMind Object](./Create_VMind_Object) chapter will teach you how to initialize a VMind object for subsequent operations. You can also learn about the data types supported by VMind in the [Data Input and Process](./Data_Input_and_Process) chapter. In the [Chart Generation](./Chart_Generation) chapter, you can learn more about how to use VMind for intelligent chart generation. The [Data Aggregation](./Data_Aggregation) chapter will teach you how to sort, filter, and aggregate data using VMind.

## Documentation

The VMind documentation provides detailed information on functions and APIs. Depending on your needs, you can view the following sections:

- [Tutorials](./Basic_Tutorial/Create_VMind_Instance): Introduces the basic concepts of VMind and various usage methods.

- [API](../api/VMind_Instance): Provides detailed descriptions of all available interfaces of VMind.

<!--- [Examples](./todo): Provides some functional examples of VMind.

## Examples

The example page provides many practical application cases of VMind. Each example provides a detailed description, key configuration information, and source code.-->

## How to Use the Search Function

This site provides a powerful search function that allows you to quickly find relevant usage information. Click on the search box at the top of the site, enter the keyword, and you will see the matching results in the drop-down list. Select the appropriate result to view the relevant content.

## How to Ask Questions & Suggestions

We are happy to help you! If you encounter any problems while using VMind, you can ask questions in the following ways:

1. Submit an issue in the GitHub repository: Visit [VMind GitHub](https://github.com/VisActor/VMind/issues/new/choose), describe the problem you encountered in detail, and our team will respond and resolve it as soon as possible.

2. Submit a discussion in the GitHub repository: Visit [VMind Discussion](https://github.com/VisActor/VMind/discussions), and we welcome you to share your ideas and suggestions here. Our team will respond and resolve it as soon as possible.

## How to Report Errors

If you find any problems in the document examples or think that some parts can be improved, please let us know. You can provide us with error correction information in the following ways:

1. Submit a pull request in the GitHub repository: Correct the content and submit it, and a team member will review and merge it.

2. Submit an issue: Point out the problems in the document, and a team member will verify and correct it as soon as possible.

Thank you for your help! We will continue to improve the documentation and provide a better learning experience for all VMind users.
