# How to Get VMind

There are several ways to get VMind:

- Get from npm
- Get from cdn
- Get from GitHub repository

## Get from npm

First, you need to install VMind in the root directory of the project using the following command

```bash
# Install with npm
npm install @visactor/vmind

# Install with yarn
yarn add @visactor/vmind
```

VMind needs to be used in conjunction with VChart. In order to draw charts, you also need to introduce VChart into the project. For specific tutorials, please refer to [VChart Quick Start](https://www.visactor.io/vchart/guide/tutorial_docs/Getting_Started)


## Get from cdn

You can get VMind from the following free CDN:

```html
<!-- unpkg -->
<script src="https://unpkg.com/@visactor/vmind/build/index.min.js"></script>

<!-- jsDelivr -->
<script src="https://cdn.jsdelivr.net/npm/@visactor/vmind/build/index.min.js"></script>
```

## Get from GitHub

On GitHub, you can directly get the source code of VMind:

- You can directly clone the source code from GitHub.
- You can also choose the corresponding version from the [release](https://github.com/VisActor/VMind/releases) page of VMind, click on Source code in Assets at the bottom of the page, download it to the local and unzip it for use.
