# Rule-based Chart Generation
VMind can automatically generate charts based on the current dataset in combination with the built-in @visactor/chart-advisor. Chart-advisor is fully dependent on visualization rules and does not need to call large language models. When you use generateChart, and the LLM cannot successfully generate a chart, VMind will use chart-advisor as an alternative to create a chart.

You can also actively choose to use chart-advisor to generate charts, just set the model type to chart-advisor when initializing the VMind object:
```ts
import VMind, { Model } from '@visactor/vmind'

const vmind = new VMind({
model: Model.CHART_ADVISOR,
})
const userPrompt = '';
const advisorResult = await vmind.generateChart(userPrompt, fieldInfo, dataset);
```
Since chart-advisor does not rely on large language models, userPrompt can be set to empty.
You can learn more about fieldInfo and dataset in the [Data Format and Data Processing](./Data_Process) section.

Chart-advisor will generate several available charts based on a series of rules, at which time generateChart will return a list containing chart types, scores, and spec.

## Example
Here is an example of a chart generated by chart-advisor using product sales data:

```ts
const dataset = [
{
"Product name": "Coke",
"Sales": 2350
},
{
"Product name": "Sprite",
"total_sales": 1056
},
{
"Product name": "Fanta",
"total_sales": 4778
},
{
"Product name": "Mirinda",
"total_sales": 3336
}
// ...more data
]

const fieldInfo = [
{
"fieldName": "Product name",
"type": "string",
"role": "dimension"
},
{
"fieldName": "Sales",
"type": "int",
"role": "measure"
}
]

const advisorResult = await vmind.generateChart(userPrompt, fieldInfo, dataset);

```
The advisorResult result is as follows:
```json
[
{
"chartSource": "chartAdvisor", // Chart source
"spec": ..., // Generated chart spec
"chartType": "BAR CHART", // Chart type
"score": 1, // Current chart score
},
{
"chartSource": "chartAdvisor",
"spec": ..., // Generated chart spec
"chartType": "RADAR CHART", // Chart type
"score": 0.16666666666666666 // Current chart score
}
]
```

Here, score represents the degree of fit between the current chart type and the input data, the higher the score means that the chart type is more suitable for displaying the current data.


The generated chart is as follows:

![](https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vmind/tutorials/VMind_advisor.png)

According to the characteristics of the input data and the field information in fieldInfo, chart-advisor will score each type of chart based on a full set of visualization rules and sort each type of chart based on the score. These rules ensure the accuracy and aesthetics of the visualization results and minimize visual confusion and visual errors in the chart.
