# fillSpecWithData

## Interface Description:
fillSpecWithData is used to fill data into a spec template to generate a complete spec. Different filling strategies will be adopted according to different chart types.

## Interface Parameters:

```typescript
fillSpecWithData(
spec: any,
dataset: Array<Record<string, any>>,
totalTime?: number
)
```

- spec (any): spec template, containing all properties except data. It can be generated by [generateChart](./generateChart)
- dataset (Array): The dataset used in the chart, which will be filled into the spec template.
- totalTime (number): Optional, chart animation duration (ms)

## Return Value:
Returns the filled spec, which can be directly used for chart rendering

## Usage Example:
In some cases, we may generate a chart only with data fields, without a specific dataset (for example, generate a chart based on the fields in the dataset before querying, and then complete the related queries based on the generated chart type and the fields in the chart). At this time, you can not pass the dataset when calling the generateChart method, generate the spec template, and then call the fillSpecWithData method to get the final spec for chart rendering:

```typescript
import VMind from '@visactor/vmind';

const vmind = new VMind(options)

const userPrompt = 'Show sales of goods in different regions';
const fieldInfo = [
{
"fieldName": "Product Name",
"type": "string",
"role": "dimension",
"domain": [
"Coca-Cola",
"Sprite",
"Fanta",
"clear up"
]
},
{
"fieldName": "region",
"type": "string",
"role": "dimension",
"domain": [
"south",
"east",
"west",
"north"
]
},
{
"fieldName": "Sales",
"type": "int",
"role": "measure",
"domain": [
28,
2350
]
}
]
// Do not pass in dataset, generate spec template
const { spec } = await vmind.generateChart(userPrompt, fieldInfo);

// Fill data into the template
const dataset = [
{
"Product Name": "Coke",
"region": "south",
"Sales": 2350
},
{
"Product Name": "Coke",
"region": "east",
"Sales": 1027
},
{
"Product Name": "Coke",
"region": "west",
"Sales": 1027
},
{
"Product Name": "Coke",
"region": "north",
"Sales": 1027
},
...
]

const spec = vmind.fillSpecWithData(spec, dataset)
```
## Related Tutorials
- [Intelligent Chart Generation](../guide/Basic_Tutorial/Chart_Generation)
