import type { SimpleFieldInfo } from '../../common/typings';
import type { DataAggregationContext, DataAggregationOutput } from '../types';

export type SQL = string;

export type GetQuerySQLContext = DataAggregationContext;

export type GetQuerySQLOutput = {
  sql: SQL;
  llmFieldInfo: SimpleFieldInfo[]; //fieldInfo generated by LLM; It may has some new fields after sql query.
  usage: any;
};

export type ExecuteQueryContext = DataAggregationContext & GetQuerySQLOutput;

export type ExecuteQueryOutput = DataAggregationOutput;
