import type { RuleBasedTaskNodeMeta } from '../../../../../base/metaTypes';
import { TaskNodeType } from '../../../../../base/taskNode/types';
import type { GetChartSpecContext, GetChartSpecOutput } from '../types';
import type { ChartGenerationOutput } from '../../../../../applications/types';
import type { Transformer } from '../../../../../base/tools/transformer';
import getVChartSpecTaskNodeMeta from '.';
import FormatOutputTaskNodeMeta from '../../formatOutput';
import { uniqBy } from '../../../../../common/utils/utils';

const runPipelines = (pipelines: any, context: any) => {
  const result = pipelines.reduce((pre: any, transformer: any) => {
    const res = transformer(pre);
    return { ...pre, ...res };
  }, context);
  return result;
};

/**
 * get spec list from advised list generated by chart-advisor
 * @param context
 * @returns
 */
const getSpecFromList: Transformer<any, { advisedList: ChartGenerationOutput[] }> = (context: any) => {
  const { advisedList } = context;
  const resultList = uniqBy(advisedList, 'chartType').map((res: any) => {
    const { chartType, cell, dataset, score, chartSource, usage } = res;
    const contextNew = {
      ...context,
      chartType,
      cell,
      dataset,
      chartSource,
      usage
    };
    const pipelines = (getVChartSpecTaskNodeMeta.pipelines as any)(contextNew).concat(
      FormatOutputTaskNodeMeta.pipelines
    );
    const { spec, chartType: chartTypeNew, cell: cellNew, time } = runPipelines(pipelines, contextNew);
    return {
      chartSource: 'chartAdvisor',
      spec,
      cell: cellNew,
      chartType: chartTypeNew,
      score,
      time,
      usage: {
        prompt_tokens: 0,
        completion_tokens: 0,
        total_tokens: 0
      }
    };
  });
  return { advisedList: resultList };
};

const getVChartSpecFromListTaskNodeMeta: RuleBasedTaskNodeMeta<GetChartSpecContext, GetChartSpecOutput> = {
  type: TaskNodeType.RULE_BASED,
  pipelines: [getSpecFromList]
};

export default getVChartSpecFromListTaskNodeMeta;
