import {
  changePointData,
  groupedBarData,
  lineChartData,
  lineChartData2,
  lineChartData3,
  MultiLineData,
  multiLineData2,
  scatterClusterData,
  scatterPlotData
} from './insightData';

export const SalesLineChart = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['230925203632066'],
    direction: 'vertical',
    sortDataByAxis: true,
    seriesField: '240510184222013',
    padding: 0,
    labelLayout: 'region',
    data: [
      {
        id: 'data',
        values: [
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '25860.24',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '5877.647999999999',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '34271.58',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '6251.420000000001',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-01',
            '230925203632066': '3113.459999999999',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '87717.84',
            '240510184222013': '西北'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '53058.96400000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '14409.919999999998',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-02',
            '230925203632066': '5540.92',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '41802.488000000005',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '9202.2',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '583.2959999999999',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '560.56',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-03',
            '230925203632066': '96269.32',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-04',
            '230925203632066': '106208.47999999997',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-04',
            '230925203632066': '6231.624',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-04',
            '230925203632066': '84454.83199999998',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '312.816',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '5718.888000000001',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '39811.91200000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '244163.47199999995',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-05',
            '230925203632066': '79487.40800000001',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-06',
            '230925203632066': '28648.339999999997',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-06',
            '230925203632066': '18288.760000000002',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '67434.584',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '1176',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '81264.54000000001',
            '240510184222013': '西北'
          },
          {
            '230925203632021': '2023-04-08',
            '230925203632066': '87750.964',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-09',
            '230925203632066': '5902.344',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-09',
            '230925203632066': '22252.271999999997',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-09',
            '230925203632066': '98844.76',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '2677.36',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '1444.52',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '62082.60799999999',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-10',
            '230925203632066': '677.3760000000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-11',
            '230925203632066': '776.16',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-11',
            '230925203632066': '7487.004000000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-11',
            '230925203632066': '57016.399999999994',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-12',
            '230925203632066': '7131.852000000001',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-12',
            '230925203632066': '11837.812',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-12',
            '230925203632066': '207763.13600000003',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-13',
            '230925203632066': '24299.296000000002',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-13',
            '230925203632066': '9847.04',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-13',
            '230925203632066': '15919.119999999999',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '33544.420000000006',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '39935.97999999999',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '60416.804',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '1234.8000000000002',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-15',
            '230925203632066': '36007.159999999996',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-16',
            '230925203632066': '108484.04000000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-16',
            '230925203632066': '2450',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-17',
            '230925203632066': '78099.14000000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-17',
            '230925203632066': '49350.84',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-17',
            '230925203632066': '18480.84',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '48419.840000000004',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '118951.66500000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '10853.892',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '1627.5839999999998',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-18',
            '230925203632066': '32777.276000000005',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '41905.78000000001',
            '240510184222013': '华北'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '47942.58000000001',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '48259.512',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-19',
            '230925203632066': '18021.22',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-22',
            '230925203632066': '58530.50000000001',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-22',
            '230925203632066': '22004.724000000002',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-22',
            '230925203632066': '7729.260000000001',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-23',
            '230925203632066': '49218.540000000015',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-23',
            '230925203632066': '13944.419999999998',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-23',
            '230925203632066': '3843.56',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '16754.08',
            '240510184222013': '西南'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '2343.1800000000003',
            '240510184222013': '东北'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '41413.81999999999',
            '240510184222013': '华东'
          },
          {
            '230925203632021': '2023-04-24',
            '230925203632066': '723.2399999999998',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-25',
            '230925203632066': '10678.08',
            '240510184222013': '中南'
          },
          {
            '230925203632021': '2023-04-25',
            '230925203632066': '44791.096000000005',
            '240510184222013': '华东'
          }
        ],
        fields: {
          '230925203632021': {
            alias: '订单日期',
            domain: [
              '2023-04-01',
              '2023-04-02',
              '2023-04-03',
              '2023-04-04',
              '2023-04-05',
              '2023-04-06',
              '2023-04-08',
              '2023-04-09',
              '2023-04-10',
              '2023-04-11',
              '2023-04-12',
              '2023-04-13',
              '2023-04-15',
              '2023-04-16',
              '2023-04-17',
              '2023-04-18',
              '2023-04-19',
              '2023-04-22',
              '2023-04-23',
              '2023-04-24',
              '2023-04-25'
            ],
            sortIndex: 0,
            lockStatisticsByDomain: true
          },
          '230925203632066': {
            alias: '销售额'
          },
          '240510184222013': {
            alias: '区域'
          }
        }
      }
    ],
    stackInverse: true,
    axes: [
      {
        type: 'band',
        tick: {
          visible: false
        },
        grid: {
          visible: false,
          style: {
            zIndex: 150,
            stroke: '#425271',
            lineWidth: 1,
            lineDash: [4, 2]
          }
        },
        orient: 'bottom',
        visible: true,
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#4C5C79'
          }
        },
        title: {
          visible: false,
          space: 5,
          text: '订单日期',
          style: {
            fontSize: 12,
            fontWeight: 'normal'
          }
        },
        maxHeight: null,
        autoIndent: false,
        sampling: false,
        zIndex: 200,
        label: {
          visible: true,
          space: 4,
          style: {
            fontSize: 12,
            fill: '#BBC2D0',
            angle: 0,
            fontWeight: 'normal',
            direction: 'horizontal',
            maxLineWidth: 174
          },
          autoHide: true,
          autoHideMethod: 'greedy',
          flush: true,
          lastVisible: true
        },
        hover: true,
        background: {
          visible: true,
          state: {
            hover: {
              fillOpacity: 0.08,
              fill: '#141414'
            },
            hover_reverse: {
              fillOpacity: 0.08,
              fill: '#141414'
            }
          }
        },
        paddingInner: 0.36249999999999993,
        paddingOuter: 0.175
      },
      {
        type: 'linear',
        tick: {
          visible: false,
          tickMode: 'd3',
          style: {
            stroke: '#4C5C79'
          }
        },
        niceType: 'accurateFirst',
        zIndex: 200,
        grid: {
          visible: true,
          style: {
            zIndex: 150,
            stroke: '#425271',
            lineWidth: 1,
            lineDash: [4, 2]
          }
        },
        orient: 'left',
        visible: true,
        domainLine: {
          visible: true,
          style: {
            lineWidth: 1,
            stroke: '#4C5C79'
          }
        },
        title: {
          visible: false,
          text: '销售额',
          space: 8,
          style: {
            fontSize: 12,
            fontWeight: 'normal'
          }
        },
        autoIndent: false,
        sampling: false,
        label: {
          visible: true,
          space: 6,
          flush: true,
          padding: 0,
          style: {
            fontSize: 12,
            maxLineWidth: 174,
            fill: '#BBC2D0',
            angle: 0,
            fontWeight: 'normal',
            dy: 0,
            direction: 'horizontal'
          },
          autoHide: true,
          autoHideMethod: 'greedy'
        },
        background: {
          visible: true,
          state: {
            hover: {
              fillOpacity: 0.08,
              fill: '#141414'
            },
            hover_reverse: {
              fillOpacity: 0.08,
              fill: '#141414'
            }
          }
        },
        innerOffset: {
          top: 4.4311346272637895
        },
        zero: true,
        nice: true
      }
    ],
    color: {
      field: '20001',
      type: 'ordinal',
      range: ['#207BFE', '#00CFFF', '#FC7703', '#5BCF78', '#2F4DE0', '#94D8FF'],
      specified: {},
      domain: ['西南', '东北', '中南', '华北', '华东', '西北']
    },
    legends: [
      {
        type: 'discrete',
        visible: true,
        id: 'legend-discrete',
        orient: 'bottom',
        position: 'middle',
        layoutType: 'normal',
        maxRow: 1,
        title: {
          textStyle: {
            fontSize: 12
          }
        },
        layoutLevel: 30,
        item: {
          focus: true,
          focusIconStyle: {
            size: 14
          },
          maxWidth: 400,
          spaceRow: 0,
          spaceCol: 0,
          padding: {
            top: 1,
            bottom: 1,
            left: 1,
            right: 1
          },
          background: {
            visible: false,
            style: {
              fillOpacity: 0.001
            }
          },
          label: {
            style: {
              fontSize: 12
            }
          },
          shape: {
            style: {
              lineWidth: 0,
              symbolType: 'circle',
              fillOpacity: 1,
              size: 10
            }
          }
        },
        pager: {
          layout: 'horizontal',
          padding: 0,
          textStyle: {
            fill: '#FDFDFE'
          },
          space: 0,
          handler: {
            preShape: 'triangleLeft',
            nextShape: 'triangleRight',
            style: {
              fill: '#BBC2D0'
            },
            state: {
              disable: {
                fill: '#566582'
              }
            }
          }
        },
        alignSelf: 'start',
        padding: {
          top: 16,
          bottom: 0,
          left: 0,
          right: 0
        }
      }
    ],
    label: {
      visible: false,
      offset: 3,
      overlap: {
        hideOnHit: true,
        avoidBaseMark: false,
        strategy: [
          {
            type: 'position',
            position: ['top', 'bottom']
          }
        ],
        clampForce: true
      },
      style: {
        fontSize: 12,
        fontWeight: 'normal',
        zIndex: 400,
        lineHeight: '100%',
        boundsPadding: [1, 0, 0, 0],
        fill: '#FDFDFE',
        strokeOpacity: 0
      },
      position: 'top',
      smartInvert: false
    },
    seriesMark: 'line',
    markOverlap: true,
    region: [
      {
        clip: true
      }
    ],
    background: 'rgba(255, 255, 255, 0)',
    invalidType: 'break',
    animation: false,
    brush: {
      inBrush: {
        fillOpacity: 1,
        strokeOpacity: 1,
        colorAlpha: 1
      },
      outOfBrush: {
        colorAlpha: 0.2,
        fillOpacity: 0.3
      }
    },
    crosshair: {
      xField: {
        visible: true,
        line: {
          type: 'rect',
          style: {
            fillOpacity: 0.2,
            fill: '#b2bacf'
          }
        }
      },
      gridZIndex: 100
    }
  },
  fieldInfo: undefined
};

export const DualAxisChartData = {
  spec: {
    type: 'common',
    seriesField: 'color',
    data: [
      {
        id: 'id0',
        values: [
          { x: '周一', type: '早餐', y: 15 },
          { x: '周一', type: '午餐', y: 25 },
          { x: '周二', type: '早餐', y: 12 },
          { x: '周二', type: '午餐', y: 30 },
          { x: '周三', type: '早餐', y: 15 },
          { x: '周三', type: '午餐', y: 24 },
          { x: '周四', type: '早餐', y: 10 },
          { x: '周四', type: '午餐', y: 25 },
          { x: '周五', type: '早餐', y: 13 },
          { x: '周五', type: '午餐', y: 20 },
          { x: '周六', type: '早餐', y: 10 },
          { x: '周六', type: '午餐', y: 22 },
          { x: '周日', type: '早餐', y: 12 },
          { x: '周日', type: '午餐', y: 19 }
        ]
      },
      {
        id: 'id1',
        values: [
          { x: '周一', type: '饮料', y: 22 },
          { x: '周二', type: '饮料', y: 43 },
          { x: '周三', type: '饮料', y: 33 },
          { x: '周四', type: '饮料', y: 22 },
          { x: '周五', type: '饮料', y: 10 },
          { x: '周六', type: '饮料', y: 30 },
          { x: '周日', type: '饮料', y: 50 }
        ]
      }
    ],
    series: [
      {
        type: 'bar',
        id: 'bar',
        dataIndex: 0,
        label: { visible: true },
        seriesField: 'type',
        xField: ['x', 'type'],
        yField: 'y'
      },
      {
        type: 'line',
        id: 'line',
        dataIndex: 1,
        label: { visible: true },
        seriesField: 'type',
        xField: 'x',
        yField: 'y',
        stack: false
      }
    ],
    axes: [
      { orient: 'left', seriesIndex: [0] },
      { orient: 'right', seriesId: ['line'], grid: { visible: false } },
      { orient: 'bottom', label: { visible: true }, type: 'band' }
    ],
    legends: {
      visible: true,
      orient: 'bottom'
    }
  },
  fieldInfo: undefined
};

export const CollegeEntranceLineChart = {
  spec: {
    type: 'line',
    xField: ['年份'],
    yField: ['高考录取率'],
    data: [
      {
        id: 'data',
        values: lineChartData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const SalesLineChart2 = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['10002'],
    data: [
      {
        id: 'data',
        values: lineChartData2
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const SalesLineChart3 = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['10002'],
    data: [
      {
        id: 'data',
        values: lineChartData3
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const GroupedBarChart = {
  spec: {
    type: 'bar',
    xField: ['State'],
    yField: ['Population'],
    seriesField: 'Age',
    data: [
      {
        id: 'data',
        values: groupedBarData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const MultiLineChart = {
  spec: {
    type: 'line',
    xField: ['230925203632021'],
    yField: ['10002'],
    seriesField: '20001',
    data: [
      {
        id: 'data',
        values: MultiLineData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const ChangePointChart = {
  spec: {
    type: 'line',
    xField: ['x'],
    yField: ['y'],
    data: [
      {
        id: 'data',
        values: changePointData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const MultiLineChart2 = {
  spec: {
    type: 'line',
    xField: ['type'],
    yField: ['value'],
    seriesField: 'country',
    data: [
      {
        id: 'data',
        values: multiLineData2
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const ScatterPlotChart = {
  spec: {
    type: 'scatter',
    xField: ['GDP'],
    yField: ['LifeExpectancy'],
    seriesField: 'continent',
    data: [
      {
        id: 'data',
        values: scatterPlotData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};

export const ScatterClusterChart = {
  spec: {
    type: 'scatter',
    xField: ['x'],
    yField: ['horsepower'],
    seriesField: 'cylinders',
    data: [
      {
        id: 'data',
        values: scatterClusterData
      }
    ],
    axes: [
      {
        type: 'band',
        orient: 'bottom',
        visible: true
      },
      {
        type: 'linear',

        orient: 'left',
        visible: true
      }
    ],
    legends: [
      {
        type: 'discrete',
        visible: true
      }
    ]
  },
  fieldInfo: undefined
};
