# VMind简介
## 前言
VisActor是一款全流程可视化解决方案，它以“可视化叙事”和“智能化”为核心发展方向。VisActor承载“可视化叙事” 能力的组件主要有VChart、VTable 和 VGrammar，它们都提供了简单易用的接口。然而，我们希望在一些典型场景中，用户能够无需编写代码就能生成图表和叙事作品，以此降低用户的学习成本和使用复杂度。大语言模型的强大生成能力为VisActor可视化体系提供了一个自然语言的交互接口，使我们能够通过自然语言直接调用VChart、VTable等可视化组件的各项功能，从而简单、快速、高质量地完成可视化创作。


![VMind](https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vmind/tutorials/VMind_intro_ch.png)


VMind是在VChart、VTable等可视化组件库的基础能力之上，构建的一个智能可视化组件。我们希望在一些典型场景中，用户能够只需一句话就能生成图表和叙事作品，以此降低用户的学习成本和使用复杂度。

## VMind架构设计
智能化是VisActor的未来核心方向，只有在此基础上，我们才能真正降低开发者的接入和研发成本，让他们能够将注意力集中在可视化之外。VMind是VisActor体系中的智能可视化组件，它基于规则算法、人工智能、机器学习、大语言模型等多种方式提供智能化接口，以最大限度降低开发者使用可视化组件的心智负担。


![VMind架构图](https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vmind/tutorials/VMind_structrure_ch.png)


在VMind组件中，最底层是由VChart图表库提供的图表渲染、动画、标注能力、VChart文档，以及大语言模型提供的自然语言理解、代码生成能力。其中，数据处理与交互层负责处理用户输入的数据和自然语言，包括数据聚合模块进行字段解析、数据转换、聚合等操作，交互通信模块负责处理用户与VMind、VMind与大语言模型之间的通信，包括用户意图识别、Prompt管理，模型通信，结果解析。


## VMind核心能力


![VMind能力图](https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vmind/tutorials/VMind_abilities_ch.png)


VMind的核心能力包括图表智能生成、图表智能编辑和智能配色。
- 图表智能生成，是指从自然语言描述的展示意图+数据直接生成图表的过程
- 图表智能编辑是在原有图表的基础上，通过自然语言描述编辑意图，生成编辑后的图表
- 智能配色是从自然语言生成风格化图表的过程。

进阶能力是对核心能力的进一步应用，包括完整的可视化叙事生成、数据解读与洞察报告。


## VMind图表创作流程


![VMind能力图](https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vmind/tutorials/VMind_progress_ch.png)


基于VMind的图表智能生成、对话式编辑和智能配色模块，我们可以概括出使用VMind进行图表创作的全流程：
首先，用户提供自然语言描述的数据展示意图和图表数据，或者提供自然语言描述的图表编辑意图和数据新闻片段等。这些输入经过意图识别模块的处理，路由到不同模块。图表智能生成模块生成初步的图表；智能配色模块会根据用户的输入生成相应的主题色板，使得图表的颜色搭配更加和谐、美观；对话式编辑模块会反复应用一系列编辑操作，对图表进行微调和优化，直到生成一张满足用户需求的图表。

这些模块之间的协同作用，使得用户可以零门槛创作可视化作品。这种流程不仅大大简化了图表创作的复杂度，也极大地提升了图表创作的效率和质量。

这一流程充分利用了大模型的function call能力。图表生成、图表编辑与智能配色作为function供模型调用，LLM作为与用户交互的接口，根据用户意图选择对应的function并传入参数，执行对应模块的功能。在未来，VMind还将集成洞察提取、数据解读功能，对生成的图表进行解读，生成洞察报告，或者在图表中添加标注展示数据中的洞察信息。与此同时，模型还具有强大的自然语言对话能力，能够与用户进行多轮对话，简单、自然、友好地帮助用户完成从图表创作到数据分析的全过程。开发人员可以轻松地将VMind集成到他们的系统中，作为一个数据可视化助手。



## VMind使用场景
### 数据视频
数据视频是一种将数据内容通过图表、动画、标注、旁白等形式进行展示和解读的视频类型。这种方式能够将原本抽象的数据转化为直观的图形，以更加生动有趣的方式呈现，使观众更容易理解和接受。

制作数据视频的步骤包括：

- 确定数据来源和主题
- 收集和整理数据
- 制作、编辑和导出图表
- 视频编辑
在传统的数据视频制作流程中，创作者需要在收集数据后，使用专业的可视化软件将数据转化为图表；或者使用各种图表库，通过编程绘制图表并导出为视频。在短视频时代，每个人都有可能成为视频的创作者。但是，非专业的视频创作者往往没有将数据可视化为图表并导出为视频的技能，这就大大提高了制作数据视频的门槛。

而使用 VMind 制作数据视频，用户只需要在收集好数据之后，用一句话描述想要展示的内容，就能直接生成图表动画，并支持一键导出为视频和 GIF，这极大地降低了制作数据视频的难度。


![](https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/cut.png)



### 图表智能助手
借助VMind打造的图表智能助手，你可以利用大语言模型的function call能力，判断用户的意图并调用VMind接口，实现图表的生成和数据的解读，从而降低数据可视化的难度。


__你可以在[Cici](https://ciciai.com/bot/fUuxvgvv)体验VMind图表助手。__


![VMind图表智能助手](https://lf9-dp-fe-cms-tos.byteorg.com/obj/bit-cloud/vmind/tutorials/VMind_assistant.png)










