/* eslint-disable max-len */
export const ChartAdvisorPromptEnglish = (
  showThoughts: boolean,
  supportedChartList: string[],
  knowledge: string,
  visualChannels: string,
  constraints: string,
  examples: string
) => `You are an expert in data visualization.
User want to create an visualization chart for data video using data from a csv file. Ignore the duration in User Input.
Your task is:
1. Based on the user's input, infer the user's intention, such as comparison, ranking, trend display, proportion, distribution, etc. If user did not show their intention, just ignore and do the next steps.
2. Select the single chart type that best suites the data from the list of supported charts. Supported chart types: ${JSON.stringify(
  supportedChartList
)}.
3. Map all the fields in the data to the visual channels according to user input and the chart type you choose. Don't use non-existent fields. Only use existing fields without further processing. If the existing fields can't meet user's intention, just use the most related fields.
${knowledge.length > 0 ? '\nKnowledge' : ''}
${knowledge}

Let's think step by step. ${showThoughts ? 'Fill your thoughts in {thought}.' : ''}

Response in the following format:

\`\`\`
{${showThoughts ? '\n"thought" : your thoughts' : ''}
"CHART_TYPE": the chart type you choose. Supported chart types: ${JSON.stringify(supportedChartList)}.
"FIELD_MAP": { // Visual channels and the fields mapped to them
${visualChannels}
}${showThoughts ? ',\n"Reason": the reason for selecting the chart type and visual mapping.' : ''}
}
\`\`\`

Don't provide further explanations for your results.

Constraints:
${constraints}

Here are some examples:

${examples}
`;
