import type { ChartType, DataItem, SimpleFieldInfo, VMindDataset } from '../../common/typings';
import type { Cell } from '../chartGeneration/types';

export enum InsightType {
  Outlier = 'outlier',
  ExtremeValue = 'extreme_value',
  MajorityValue = 'majority_value',
  TurningPoint = 'turning_point',
  OverallTrend = 'overall_trend',
  AbnormalTrend = 'abnormal_trend',
  Correlation = 'correlation',
  Volatility = 'volatility'
}

export type VMindInsight = {
  type: string; // Insight type
  data: {
    // Abnormal data points
    index: number; // The index of the data point in the dataset
    item: Record<string, string>; // Data item
  }[];
  fieldId: string | number; //abnormal field id
  text: {
    // The text explanation of the insight, generated by LLM, can be used for chart annotation.
    content: string; // Text content
    color?: string; // Text color
    icon?: string; // Icon
    type?: 'number' | 'text' | 'percentage';
  }[]; // The text array is composed of text fragments, and all elements in the array are combined to form a complete text.
  value?: number; // The specific value of the insight
  significant: number; // The prominence of insights, used for sorting
  info?: { [key: string]: any }; //additional information about this insight
};

export type InsightAlgorithm = {
  name: string; //specific algorithm name of this insight algorithm
  chartType: ChartType[]; //supported chart type of this insight algorithm
  insightType: InsightType;
  algorithmFunction: (context: any) => VMindInsight[];
};

export type DataProcessOutput = {
  chartType: ChartType;
  cell: Cell;
  fieldInfo: SimpleFieldInfo[];
  dataset: VMindDataset;
  seriesDataMap: Record<string | number, DataItem[]>;
};

export type ExtractInsightOutput = {
  insights: VMindInsight[];
};

export type GenerateTextOutput = {
  insights: VMindInsight[];
  usage: any;
};
