# 如何获取 VMind

获取 VMind 的方式有以下几种：

- 从 npm 获取
- 从 cdn 获取
- 从 GitHub 仓库获取

## npm 获取

首先，你需要在项目根目录下使用以下命令安装 VMind

```bash
# 使用 npm 安装
npm install @visactor/vmind

# 使用 yarn 安装
yarn add @visactor/vmind
```

VMind 需要配合 VChart 一起使用。为了进行图表绘制，你还需要在项目中引入 VChart，具体教程详见[VChart快速上手](https://www.visactor.io/vchart/guide/tutorial_docs/Getting_Started)


## cdn 获取

可以从以下免费的 CDN 中获取 VMind:

```html
<!-- unpkg -->
<script src="https://unpkg.com/@visactor/vmind/build/index.min.js"></script>

<!-- jsDelivr -->
<script src="https://cdn.jsdelivr.net/npm/@visactor/vmind/build/index.min.js"></script>
```

## GitHub 获取

从 GitHub 上你可以直接获取 VMind 的源码：

- 你可以直接从 GitHub clone 源码。
- 你也可以从 VMind 的  [release](https://github.com/VisActor/VMind/releases)  页面选择对应的版本，点击页面下方 Assets 中的 Source code，将其下载至本地解压后使用。
