(function(){var Meteor=Package.meteor.Meteor;var _=Package.underscore._;var Base64=Package.base64.Base64;var EJSON,EJSONTest;(function(){EJSON={};EJSONTest={};var customTypes={};EJSON.addType=function(name,factory){if(_.has(customTypes,name))throw new Error("Type "+name+" already present");customTypes[name]=factory};var isInfOrNan=function(obj){return _.isNaN(obj)||obj===Infinity||obj===-Infinity};var builtinConverters=[{matchJSONValue:function(obj){return _.has(obj,"$date")&&_.size(obj)===1},matchObject:function(obj){return obj instanceof Date},toJSONValue:function(obj){return{$date:obj.getTime()}},fromJSONValue:function(obj){return new Date(obj.$date)}},{matchJSONValue:function(obj){return _.has(obj,"$InfNaN")&&_.size(obj)===1},matchObject:isInfOrNan,toJSONValue:function(obj){var sign;if(_.isNaN(obj))sign=0;else if(obj===Infinity)sign=1;else sign=-1;return{$InfNaN:sign}},fromJSONValue:function(obj){return obj.$InfNaN/0}},{matchJSONValue:function(obj){return _.has(obj,"$binary")&&_.size(obj)===1},matchObject:function(obj){return typeof Uint8Array!=="undefined"&&obj instanceof Uint8Array||obj&&_.has(obj,"$Uint8ArrayPolyfill")},toJSONValue:function(obj){return{$binary:Base64.encode(obj)}},fromJSONValue:function(obj){return Base64.decode(obj.$binary)}},{matchJSONValue:function(obj){return _.has(obj,"$escape")&&_.size(obj)===1},matchObject:function(obj){if(_.isEmpty(obj)||_.size(obj)>2){return false}return _.any(builtinConverters,function(converter){return converter.matchJSONValue(obj)})},toJSONValue:function(obj){var newObj={};_.each(obj,function(value,key){newObj[key]=EJSON.toJSONValue(value)});return{$escape:newObj}},fromJSONValue:function(obj){var newObj={};_.each(obj.$escape,function(value,key){newObj[key]=EJSON.fromJSONValue(value)});return newObj}},{matchJSONValue:function(obj){return _.has(obj,"$type")&&_.has(obj,"$value")&&_.size(obj)===2},matchObject:function(obj){return EJSON._isCustomType(obj)},toJSONValue:function(obj){var jsonValue=Meteor._noYieldsAllowed(function(){return obj.toJSONValue()});return{$type:obj.typeName(),$value:jsonValue}},fromJSONValue:function(obj){var typeName=obj.$type;if(!_.has(customTypes,typeName))throw new Error("Custom EJSON type "+typeName+" is not defined");var converter=customTypes[typeName];return Meteor._noYieldsAllowed(function(){return converter(obj.$value)})}}];EJSON._isCustomType=function(obj){return obj&&typeof obj.toJSONValue==="function"&&typeof obj.typeName==="function"&&_.has(customTypes,obj.typeName())};EJSON._getTypes=function(){return customTypes};EJSON._getConverters=function(){return builtinConverters};var adjustTypesToJSONValue=EJSON._adjustTypesToJSONValue=function(obj){if(obj===null)return null;var maybeChanged=toJSONValueHelper(obj);if(maybeChanged!==undefined)return maybeChanged;if(typeof obj!=="object")return obj;_.each(obj,function(value,key){if(typeof value!=="object"&&value!==undefined&&!isInfOrNan(value))return;var changed=toJSONValueHelper(value);if(changed){obj[key]=changed;return}adjustTypesToJSONValue(value)});return obj};var toJSONValueHelper=function(item){for(var i=0;i<builtinConverters.length;i++){var converter=builtinConverters[i];if(converter.matchObject(item)){return converter.toJSONValue(item)}}return undefined};EJSON.toJSONValue=function(item){var changed=toJSONValueHelper(item);if(changed!==undefined)return changed;if(typeof item==="object"){item=EJSON.clone(item);adjustTypesToJSONValue(item)}return item};var adjustTypesFromJSONValue=EJSON._adjustTypesFromJSONValue=function(obj){if(obj===null)return null;var maybeChanged=fromJSONValueHelper(obj);if(maybeChanged!==obj)return maybeChanged;if(typeof obj!=="object")return obj;_.each(obj,function(value,key){if(typeof value==="object"){var changed=fromJSONValueHelper(value);if(value!==changed){obj[key]=changed;return}adjustTypesFromJSONValue(value)}});return obj};var fromJSONValueHelper=function(value){if(typeof value==="object"&&value!==null){if(_.size(value)<=2&&_.all(value,function(v,k){return typeof k==="string"&&k.substr(0,1)==="$"})){for(var i=0;i<builtinConverters.length;i++){var converter=builtinConverters[i];if(converter.matchJSONValue(value)){return converter.fromJSONValue(value)}}}}return value};EJSON.fromJSONValue=function(item){var changed=fromJSONValueHelper(item);if(changed===item&&typeof item==="object"){item=EJSON.clone(item);adjustTypesFromJSONValue(item);return item}else{return changed}};EJSON.stringify=function(item,options){var json=EJSON.toJSONValue(item);if(options&&(options.canonical||options.indent)){return EJSON._canonicalStringify(json,options)}else{return JSON.stringify(json)}};EJSON.parse=function(item){if(typeof item!=="string")throw new Error("EJSON.parse argument should be a string");return EJSON.fromJSONValue(JSON.parse(item))};EJSON.isBinary=function(obj){return!!(typeof Uint8Array!=="undefined"&&obj instanceof Uint8Array||obj&&obj.$Uint8ArrayPolyfill)};EJSON.equals=function(a,b,options){var i;var keyOrderSensitive=!!(options&&options.keyOrderSensitive);if(a===b)return true;if(_.isNaN(a)&&_.isNaN(b))return true;if(!a||!b)return false;if(!(typeof a==="object"&&typeof b==="object"))return false;if(a instanceof Date&&b instanceof Date)return a.valueOf()===b.valueOf();if(EJSON.isBinary(a)&&EJSON.isBinary(b)){if(a.length!==b.length)return false;for(i=0;i<a.length;i++){if(a[i]!==b[i])return false}return true}if(typeof a.equals==="function")return a.equals(b,options);if(typeof b.equals==="function")return b.equals(a,options);if(a instanceof Array){if(!(b instanceof Array))return false;if(a.length!==b.length)return false;for(i=0;i<a.length;i++){if(!EJSON.equals(a[i],b[i],options))return false}return true}switch(EJSON._isCustomType(a)+EJSON._isCustomType(b)){case 1:return false;case 2:return EJSON.equals(EJSON.toJSONValue(a),EJSON.toJSONValue(b))}var ret;if(keyOrderSensitive){var bKeys=[];_.each(b,function(val,x){bKeys.push(x)});i=0;ret=_.all(a,function(val,x){if(i>=bKeys.length){return false}if(x!==bKeys[i]){return false}if(!EJSON.equals(val,b[bKeys[i]],options)){return false}i++;return true});return ret&&i===bKeys.length}else{i=0;ret=_.all(a,function(val,key){if(!_.has(b,key)){return false}if(!EJSON.equals(val,b[key],options)){return false}i++;return true});return ret&&_.size(b)===i}};EJSON.clone=function(v){var ret;if(typeof v!=="object")return v;if(v===null)return null;if(v instanceof Date)return new Date(v.getTime());if(v instanceof RegExp)return v;if(EJSON.isBinary(v)){ret=EJSON.newBinary(v.length);for(var i=0;i<v.length;i++){ret[i]=v[i]}return ret}if(_.isArray(v)||_.isArguments(v)){ret=[];for(i=0;i<v.length;i++)ret[i]=EJSON.clone(v[i]);return ret}if(typeof v.clone==="function"){return v.clone()}if(EJSON._isCustomType(v)){return EJSON.fromJSONValue(EJSON.clone(EJSON.toJSONValue(v)),true)}ret={};_.each(v,function(value,key){ret[key]=EJSON.clone(value)});return ret};EJSON.newBinary=Base64.newBinary}).call(this);(function(){function quote(string){return JSON.stringify(string)}var str=function(key,holder,singleIndent,outerIndent,canonical){var i;var k;var v;var length;var innerIndent=outerIndent;var partial;var value=holder[key];switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":return String(value);case"object":if(!value){return"null"}innerIndent=outerIndent+singleIndent;partial=[];if(_.isArray(value)||_.isArguments(value)){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value,singleIndent,innerIndent,canonical)||"null"}if(partial.length===0){v="[]"}else if(innerIndent){v="[\n"+innerIndent+partial.join(",\n"+innerIndent)+"\n"+outerIndent+"]"}else{v="["+partial.join(",")+"]"}return v}var keys=_.keys(value);if(canonical)keys=keys.sort();_.each(keys,function(k){v=str(k,value,singleIndent,innerIndent,canonical);if(v){partial.push(quote(k)+(innerIndent?": ":":")+v)}});if(partial.length===0){v="{}"}else if(innerIndent){v="{\n"+innerIndent+partial.join(",\n"+innerIndent)+"\n"+outerIndent+"}"}else{v="{"+partial.join(",")+"}"}return v}};EJSON._canonicalStringify=function(value,options){options=_.extend({indent:"",canonical:false},options);if(options.indent===true){options.indent="  "}else if(typeof options.indent==="number"){var newIndent="";for(var i=0;i<options.indent;i++){newIndent+=" "}options.indent=newIndent}return str("",{"":value},options.indent,"",options.canonical)}}).call(this);if(typeof Package==="undefined")Package={};Package.ejson={EJSON:EJSON,EJSONTest:EJSONTest}})();(function(){var Meteor=Package.meteor.Meteor;var EJSON=Package.ejson.EJSON;var IdMap=Package["id-map"].IdMap;var Random=Package.random.Random;var MongoID;(function(){MongoID={};MongoID._looksLikeObjectID=function(str){return str.length===24&&str.match(/^[0-9a-f]*$/)};MongoID.ObjectID=function(hexString){var self=this;if(hexString){hexString=hexString.toLowerCase();if(!MongoID._looksLikeObjectID(hexString)){throw new Error("Invalid hexadecimal string for creating an ObjectID")}self._str=hexString}else{self._str=Random.hexString(24)}};MongoID.ObjectID.prototype.toString=function(){var self=this;return'ObjectID("'+self._str+'")'};MongoID.ObjectID.prototype.equals=function(other){var self=this;return other instanceof MongoID.ObjectID&&self.valueOf()===other.valueOf()};MongoID.ObjectID.prototype.clone=function(){var self=this;return new MongoID.ObjectID(self._str)};MongoID.ObjectID.prototype.typeName=function(){return"oid"};MongoID.ObjectID.prototype.getTimestamp=function(){var self=this;return parseInt(self._str.substr(0,8),16)};MongoID.ObjectID.prototype.valueOf=MongoID.ObjectID.prototype.toJSONValue=MongoID.ObjectID.prototype.toHexString=function(){return this._str};EJSON.addType("oid",function(str){return new MongoID.ObjectID(str)});MongoID.idStringify=function(id){if(id instanceof MongoID.ObjectID){return id.valueOf()}else if(typeof id==="string"){if(id===""){return id}else if(id.substr(0,1)==="-"||id.substr(0,1)==="~"||MongoID._looksLikeObjectID(id)||id.substr(0,1)==="{"){return"-"+id}else{return id}}else if(id===undefined){return"-"}else if(typeof id==="object"&&id!==null){throw new Error("Meteor does not currently support objects other than ObjectID as ids")}else{return"~"+JSON.stringify(id)}};MongoID.idParse=function(id){if(id===""){return id}else if(id==="-"){return undefined}else if(id.substr(0,1)==="-"){return id.substr(1)}else if(id.substr(0,1)==="~"){return JSON.parse(id.substr(1))}else if(MongoID._looksLikeObjectID(id)){return new MongoID.ObjectID(id)}else{return id}}}).call(this);if(typeof Package==="undefined")Package={};Package["mongo-id"]={MongoID:MongoID}})();(function(){var Meteor=Package.meteor.Meteor;var _=Package.underscore._;var EJSON=Package.ejson.EJSON;var DiffSequence;(function(){DiffSequence={};DiffSequence.diffQueryChanges=function(ordered,oldResults,newResults,observer,options){if(ordered)DiffSequence.diffQueryOrderedChanges(oldResults,newResults,observer,options);else DiffSequence.diffQueryUnorderedChanges(oldResults,newResults,observer,options)};DiffSequence.diffQueryUnorderedChanges=function(oldResults,newResults,observer,options){options=options||{};var projectionFn=options.projectionFn||EJSON.clone;if(observer.movedBefore){throw new Error("_diffQueryUnordered called with a movedBefore observer!")}newResults.forEach(function(newDoc,id){var oldDoc=oldResults.get(id);if(oldDoc){if(observer.changed&&!EJSON.equals(oldDoc,newDoc)){var projectedNew=projectionFn(newDoc);var projectedOld=projectionFn(oldDoc);var changedFields=DiffSequence.makeChangedFields(projectedNew,projectedOld);if(!_.isEmpty(changedFields)){observer.changed(id,changedFields)}}}else if(observer.added){var fields=projectionFn(newDoc);delete fields._id;observer.added(newDoc._id,fields)}});if(observer.removed){oldResults.forEach(function(oldDoc,id){if(!newResults.has(id))observer.removed(id)})}};DiffSequence.diffQueryOrderedChanges=function(old_results,new_results,observer,options){options=options||{};var projectionFn=options.projectionFn||EJSON.clone;var new_presence_of_id={};_.each(new_results,function(doc){if(new_presence_of_id[doc._id])Meteor._debug("Duplicate _id in new_results");new_presence_of_id[doc._id]=true});var old_index_of_id={};_.each(old_results,function(doc,i){if(doc._id in old_index_of_id)Meteor._debug("Duplicate _id in old_results");old_index_of_id[doc._id]=i});var unmoved=[];var max_seq_len=0;var N=new_results.length;var seq_ends=new Array(N);var ptrs=new Array(N);var old_idx_seq=function(i_new){return old_index_of_id[new_results[i_new]._id]};for(var i=0;i<N;i++){if(old_index_of_id[new_results[i]._id]!==undefined){var j=max_seq_len;while(j>0){if(old_idx_seq(seq_ends[j-1])<old_idx_seq(i))break;j--}ptrs[i]=j===0?-1:seq_ends[j-1];seq_ends[j]=i;if(j+1>max_seq_len)max_seq_len=j+1}}var idx=max_seq_len===0?-1:seq_ends[max_seq_len-1];while(idx>=0){unmoved.push(idx);idx=ptrs[idx]}unmoved.reverse();unmoved.push(new_results.length);_.each(old_results,function(doc){if(!new_presence_of_id[doc._id])observer.removed&&observer.removed(doc._id)});var startOfGroup=0;_.each(unmoved,function(endOfGroup){var groupId=new_results[endOfGroup]?new_results[endOfGroup]._id:null;var oldDoc,newDoc,fields,projectedNew,projectedOld;for(var i=startOfGroup;i<endOfGroup;i++){newDoc=new_results[i];if(!_.has(old_index_of_id,newDoc._id)){fields=projectionFn(newDoc);delete fields._id;observer.addedBefore&&observer.addedBefore(newDoc._id,fields,groupId);observer.added&&observer.added(newDoc._id,fields)}else{oldDoc=old_results[old_index_of_id[newDoc._id]];projectedNew=projectionFn(newDoc);projectedOld=projectionFn(oldDoc);fields=DiffSequence.makeChangedFields(projectedNew,projectedOld);if(!_.isEmpty(fields)){observer.changed&&observer.changed(newDoc._id,fields)}observer.movedBefore&&observer.movedBefore(newDoc._id,groupId)}}if(groupId){newDoc=new_results[endOfGroup];oldDoc=old_results[old_index_of_id[newDoc._id]];projectedNew=projectionFn(newDoc);projectedOld=projectionFn(oldDoc);fields=DiffSequence.makeChangedFields(projectedNew,projectedOld);if(!_.isEmpty(fields)){observer.changed&&observer.changed(newDoc._id,fields)}}startOfGroup=endOfGroup+1})};DiffSequence.diffObjects=function(left,right,callbacks){_.each(left,function(leftValue,key){if(_.has(right,key))callbacks.both&&callbacks.both(key,leftValue,right[key]);else callbacks.leftOnly&&callbacks.leftOnly(key,leftValue)});if(callbacks.rightOnly){_.each(right,function(rightValue,key){if(!_.has(left,key))callbacks.rightOnly(key,rightValue)})}};DiffSequence.makeChangedFields=function(newDoc,oldDoc){var fields={};DiffSequence.diffObjects(oldDoc,newDoc,{leftOnly:function(key,value){fields[key]=undefined},rightOnly:function(key,value){fields[key]=value},both:function(key,leftValue,rightValue){if(!EJSON.equals(leftValue,rightValue))fields[key]=rightValue}});return fields};DiffSequence.applyChanges=function(doc,changeFields){_.each(changeFields,function(value,key){if(value===undefined)delete doc[key];else doc[key]=value})}}).call(this);if(typeof Package==="undefined")Package={};Package["diff-sequence"]={DiffSequence:DiffSequence}})();(function(){var Meteor=Package.meteor.Meteor;var Tracker=Package.tracker.Tracker;var Deps=Package.tracker.Deps;var MongoID=Package["mongo-id"].MongoID;var DiffSequence=Package["diff-sequence"].DiffSequence;var _=Package.underscore._;var Random=Package.random.Random;var ObserveSequence,seqChangedToEmpty,seqChangedToArray,seqChangedToCursor;(function(){var warn=function(){if(ObserveSequence._suppressWarnings){ObserveSequence._suppressWarnings--}else{if(typeof console!=="undefined"&&console.warn)console.warn.apply(console,arguments);ObserveSequence._loggedWarnings++}};var idStringify=MongoID.idStringify;var idParse=MongoID.idParse;ObserveSequence={_suppressWarnings:0,_loggedWarnings:0,observe:function(sequenceFunc,callbacks){var lastSeq=null;var activeObserveHandle=null;var lastSeqArray=[];var computation=Tracker.autorun(function(){var seq=sequenceFunc();Tracker.nonreactive(function(){var seqArray;if(activeObserveHandle){lastSeqArray=_.map(lastSeq.fetch(),function(doc){return{_id:doc._id,item:doc}});activeObserveHandle.stop();activeObserveHandle=null}if(!seq){seqArray=seqChangedToEmpty(lastSeqArray,callbacks)}else if(seq instanceof Array){seqArray=seqChangedToArray(lastSeqArray,seq,callbacks)}else if(isStoreCursor(seq)){var result=seqChangedToCursor(lastSeqArray,seq,callbacks);seqArray=result[0];activeObserveHandle=result[1]}else{throw badSequenceError()}diffArray(lastSeqArray,seqArray,callbacks);lastSeq=seq;lastSeqArray=seqArray})});return{stop:function(){computation.stop();if(activeObserveHandle)activeObserveHandle.stop()}}},fetch:function(seq){if(!seq){return[]}else if(seq instanceof Array){return seq}else if(isStoreCursor(seq)){return seq.fetch()}else{throw badSequenceError()}}};var badSequenceError=function(){return new Error("{{#each}} currently only accepts "+"arrays, cursors or falsey values.")};var isStoreCursor=function(cursor){return cursor&&_.isObject(cursor)&&_.isFunction(cursor.observe)&&_.isFunction(cursor.fetch)};var diffArray=function(lastSeqArray,seqArray,callbacks){var diffFn=Package["diff-sequence"].DiffSequence.diffQueryOrderedChanges;var oldIdObjects=[];var newIdObjects=[];var posOld={};var posNew={};var posCur={};var lengthCur=lastSeqArray.length;_.each(seqArray,function(doc,i){newIdObjects.push({_id:doc._id});posNew[idStringify(doc._id)]=i});_.each(lastSeqArray,function(doc,i){oldIdObjects.push({_id:doc._id});posOld[idStringify(doc._id)]=i;posCur[idStringify(doc._id)]=i});diffFn(oldIdObjects,newIdObjects,{addedBefore:function(id,doc,before){var position=before?posCur[idStringify(before)]:lengthCur;if(before){_.each(posCur,function(pos,id){if(pos>=position)posCur[id]++})}lengthCur++;posCur[idStringify(id)]=position;callbacks.addedAt(id,seqArray[posNew[idStringify(id)]].item,position,before)},movedBefore:function(id,before){if(id===before)return;var oldPosition=posCur[idStringify(id)];var newPosition=before?posCur[idStringify(before)]:lengthCur;if(newPosition>oldPosition){newPosition--}_.each(posCur,function(elCurPosition,id){if(oldPosition<elCurPosition&&elCurPosition<newPosition)posCur[id]--;else if(newPosition<=elCurPosition&&elCurPosition<oldPosition)posCur[id]++});posCur[idStringify(id)]=newPosition;callbacks.movedTo(id,seqArray[posNew[idStringify(id)]].item,oldPosition,newPosition,before)},removed:function(id){var prevPosition=posCur[idStringify(id)];_.each(posCur,function(pos,id){if(pos>=prevPosition)posCur[id]--});delete posCur[idStringify(id)];lengthCur--;callbacks.removedAt(id,lastSeqArray[posOld[idStringify(id)]].item,prevPosition)}});_.each(posNew,function(pos,idString){var id=idParse(idString);if(_.has(posOld,idString)){var newItem=seqArray[pos].item;var oldItem=lastSeqArray[posOld[idString]].item;if(typeof newItem==="object"||newItem!==oldItem)callbacks.changedAt(id,newItem,oldItem,pos)}})};seqChangedToEmpty=function(lastSeqArray,callbacks){return[]};seqChangedToArray=function(lastSeqArray,array,callbacks){var idsUsed={};var seqArray=_.map(array,function(item,index){var id;if(typeof item==="string"){id="-"+item}else if(typeof item==="number"||typeof item==="boolean"||item===undefined){id=item}else if(typeof item==="object"){id=item&&_.has(item,"_id")?item._id:index}else{throw new Error("{{#each}} doesn't support arrays with "+"elements of type "+typeof item)}var idString=idStringify(id);if(idsUsed[idString]){if(typeof item==="object"&&"_id"in item)warn("duplicate id "+id+" in",array);id=Random.id()}else{idsUsed[idString]=true}return{_id:id,item:item}});return seqArray};seqChangedToCursor=function(lastSeqArray,cursor,callbacks){var initial=true;var seqArray=[];var observeHandle=cursor.observe({addedAt:function(document,atIndex,before){if(initial){if(before!==null)throw new Error("Expected initial data from observe in order");seqArray.push({_id:document._id,item:document})}else{callbacks.addedAt(document._id,document,atIndex,before)}},changedAt:function(newDocument,oldDocument,atIndex){callbacks.changedAt(newDocument._id,newDocument,oldDocument,atIndex)},removedAt:function(oldDocument,atIndex){callbacks.removedAt(oldDocument._id,oldDocument,atIndex)},movedTo:function(document,fromIndex,toIndex,before){callbacks.movedTo(document._id,document,fromIndex,toIndex,before)}});initial=false;return[seqArray,observeHandle]}}).call(this);if(typeof Package==="undefined")Package={};Package["observe-sequence"]={ObserveSequence:ObserveSequence}})();(function(){var Meteor=Package.meteor.Meteor;var ECMAScript;if(typeof Package==="undefined")Package={};Package.ecmascript={ECMAScript:ECMAScript}})();(function(){var Meteor=Package.meteor.Meteor;var babelHelpers;(function(){var hasOwn=Object.prototype.hasOwnProperty;function canDefineNonEnumerableProperties(){var testObj={};var testPropName="t";try{Object.defineProperty(testObj,testPropName,{enumerable:false,value:testObj});for(var k in testObj){if(k===testPropName){return false}}}catch(e){return false}return testObj[testPropName]===testObj}babelHelpers={sanitizeForInObject:canDefineNonEnumerableProperties()?function(value){return value}:function(obj){if(Array.isArray(obj)){var newObj={};var keys=Object.keys(obj);var keyCount=keys.length;for(var i=0;i<keyCount;++i){var key=keys[i];newObj[key]=obj[key]}return newObj}return obj},taggedTemplateLiteralLoose:function(strings,raw){strings.raw=raw;return strings},classCallCheck:function(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}},inherits:function(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}if(superClass){if(Object.create){subClass.prototype=Object.create(superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}})}else{var F=function(){this.constructor=subClass};F.prototype=superClass.prototype;subClass.prototype=new F}for(var k in superClass){if(hasOwn.call(superClass,k)){subClass[k]=superClass[k]}}}},createClass:function(){var hasDefineProperty=false;try{Object.defineProperty({},"x",{});hasDefineProperty=true}catch(e){}function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(!hasDefineProperty){throw new Error("Your browser does not support this type of class property.  "+"For example, Internet Explorer 8 does not support getters and "+"setters.")}if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}(),_extends:Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(hasOwn.call(source,key)){target[key]=source[key]}}}return target},objectWithoutProperties:function(obj,keys){var target={};outer:for(var i in obj){if(!hasOwn.call(obj,i))continue;for(var j=0;j<keys.length;j++){if(keys[j]===i)continue outer}target[i]=obj[i]}return target},objectDestructuringEmpty:function(obj){if(obj==null)throw new TypeError("Cannot destructure undefined")},bind:Function.prototype.bind||function(){var isCallable=function(value){return typeof value==="function"};var $Object=Object;var to_string=Object.prototype.toString;var array_slice=Array.prototype.slice;var array_concat=Array.prototype.concat;var array_push=Array.prototype.push;var max=Math.max;var Empty=function Empty(){};return function bind(that){var target=this;if(!isCallable(target)){throw new TypeError("Function.prototype.bind called on incompatible "+target)}var args=array_slice.call(arguments,1);var bound;var binder=function(){if(this instanceof bound){var result=target.apply(this,array_concat.call(args,array_slice.call(arguments)));if($Object(result)===result){return result}return this}else{return target.apply(that,array_concat.call(args,array_slice.call(arguments)))}};var boundLength=max(0,target.length-args.length);var boundArgs=[];for(var i=0;i<boundLength;i++){array_push.call(boundArgs,"$"+i)}bound=Function("binder","return function ("+boundArgs.join(",")+"){ return binder.apply(this, arguments); }")(binder);if(target.prototype){Empty.prototype=target.prototype;bound.prototype=new Empty;Empty.prototype=null}return bound}}(),slice:Array.prototype.slice}}).call(this);if(typeof Package==="undefined")Package={};Package["babel-runtime"]={babelHelpers:babelHelpers}})();(function(){var Meteor=Package.meteor.Meteor;var Symbol,Map,Set,__g,__e;(function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:false};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.loaded=true;return module.exports}__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.p="";return __webpack_require__(0)})([function(module,exports,__webpack_require__){__webpack_require__(1);__webpack_require__(50);__webpack_require__(77);__webpack_require__(96);Symbol=exports.Symbol=__webpack_require__(99);Map=exports.Map=__webpack_require__(100);Set=exports.Set=__webpack_require__(108)},function(module,exports,__webpack_require__){__webpack_require__(2);__webpack_require__(28);__webpack_require__(31);__webpack_require__(33);__webpack_require__(37);__webpack_require__(39);__webpack_require__(41);__webpack_require__(42);__webpack_require__(43);__webpack_require__(44);__webpack_require__(45);__webpack_require__(46);__webpack_require__(47);__webpack_require__(48);__webpack_require__(49);module.exports=__webpack_require__(9).Object},function(module,exports,__webpack_require__){"use strict";var $=__webpack_require__(3),global=__webpack_require__(4),has=__webpack_require__(5),SUPPORT_DESC=__webpack_require__(6),$def=__webpack_require__(8),$redef=__webpack_require__(12),$fails=__webpack_require__(7),shared=__webpack_require__(14),setTag=__webpack_require__(15),uid=__webpack_require__(13),wks=__webpack_require__(16),keyOf=__webpack_require__(17),$names=__webpack_require__(22),enumKeys=__webpack_require__(23),isArray=__webpack_require__(24),isObject=__webpack_require__(25),anObject=__webpack_require__(26),toIObject=__webpack_require__(18),createDesc=__webpack_require__(11),getDesc=$.getDesc,setDesc=$.setDesc,_create=$.create,getNames=$names.get,$Symbol=global.Symbol,$JSON=global.JSON,_stringify=$JSON&&$JSON.stringify,setter=false,HIDDEN=wks("_hidden"),isEnum=$.isEnum,SymbolRegistry=shared("symbol-registry"),AllSymbols=shared("symbols"),useNative=typeof $Symbol=="function",ObjectProto=Object.prototype;var setSymbolDesc=SUPPORT_DESC&&$fails(function(){return _create(setDesc({},"a",{get:function(){return setDesc(this,"a",{value:7}).a}})).a!=7})?function(it,key,D){var protoDesc=getDesc(ObjectProto,key);if(protoDesc)delete ObjectProto[key];setDesc(it,key,D);if(protoDesc&&it!==ObjectProto)setDesc(ObjectProto,key,protoDesc)}:setDesc;var wrap=function(tag){var sym=AllSymbols[tag]=_create($Symbol.prototype);sym._k=tag;SUPPORT_DESC&&setter&&setSymbolDesc(ObjectProto,tag,{configurable:true,set:function(value){if(has(this,HIDDEN)&&has(this[HIDDEN],tag))this[HIDDEN][tag]=false;setSymbolDesc(this,tag,createDesc(1,value))}});return sym};var isSymbol=function(it){return typeof it=="symbol"};var $defineProperty=function defineProperty(it,key,D){if(D&&has(AllSymbols,key)){if(!D.enumerable){if(!has(it,HIDDEN))setDesc(it,HIDDEN,createDesc(1,{}));it[HIDDEN][key]=true}else{if(has(it,HIDDEN)&&it[HIDDEN][key])it[HIDDEN][key]=false;D=_create(D,{enumerable:createDesc(0,false)})}return setSymbolDesc(it,key,D)}return setDesc(it,key,D)};var $defineProperties=function defineProperties(it,P){anObject(it);var keys=enumKeys(P=toIObject(P)),i=0,l=keys.length,key;while(l>i)$defineProperty(it,key=keys[i++],P[key]);return it};var $create=function create(it,P){return P===undefined?_create(it):$defineProperties(_create(it),P)};var $propertyIsEnumerable=function propertyIsEnumerable(key){var E=isEnum.call(this,key);return E||!has(this,key)||!has(AllSymbols,key)||has(this,HIDDEN)&&this[HIDDEN][key]?E:true};var $getOwnPropertyDescriptor=function getOwnPropertyDescriptor(it,key){var D=getDesc(it=toIObject(it),key);if(D&&has(AllSymbols,key)&&!(has(it,HIDDEN)&&it[HIDDEN][key]))D.enumerable=true;return D};var $getOwnPropertyNames=function getOwnPropertyNames(it){var names=getNames(toIObject(it)),result=[],i=0,key;while(names.length>i)if(!has(AllSymbols,key=names[i++])&&key!=HIDDEN)result.push(key);return result};var $getOwnPropertySymbols=function getOwnPropertySymbols(it){var names=getNames(toIObject(it)),result=[],i=0,key;while(names.length>i)if(has(AllSymbols,key=names[i++]))result.push(AllSymbols[key]);return result};var $stringify=function stringify(it){var args=[it],i=1,replacer,$replacer;while(arguments.length>i)args.push(arguments[i++]);replacer=args[1];if(typeof replacer=="function")$replacer=replacer;if($replacer||!isArray(replacer))replacer=function(key,value){if($replacer)value=$replacer.call(this,key,value);if(!isSymbol(value))return value};args[1]=replacer;return _stringify.apply($JSON,args)};var buggyJSON=$fails(function(){var S=$Symbol();return _stringify([S])!="[null]"||_stringify({a:S})!="{}"||_stringify(Object(S))!="{}"});if(!useNative){$Symbol=function Symbol(){if(isSymbol(this))throw TypeError("Symbol is not a constructor");return wrap(uid(arguments[0]))};$redef($Symbol.prototype,"toString",function toString(){return this._k});isSymbol=function(it){return it instanceof $Symbol};$.create=$create;$.isEnum=$propertyIsEnumerable;$.getDesc=$getOwnPropertyDescriptor;$.setDesc=$defineProperty;$.setDescs=$defineProperties;$.getNames=$names.get=$getOwnPropertyNames;$.getSymbols=$getOwnPropertySymbols;if(SUPPORT_DESC&&!__webpack_require__(27)){$redef(ObjectProto,"propertyIsEnumerable",$propertyIsEnumerable,true)}}var symbolStatics={"for":function(key){return has(SymbolRegistry,key+="")?SymbolRegistry[key]:SymbolRegistry[key]=$Symbol(key)},keyFor:function keyFor(key){return keyOf(SymbolRegistry,key)},useSetter:function(){setter=true},useSimple:function(){setter=false}};$.each.call(("hasInstance,isConcatSpreadable,iterator,match,replace,search,"+"species,split,toPrimitive,toStringTag,unscopables").split(","),function(it){var sym=wks(it);symbolStatics[it]=useNative?sym:wrap(sym)});setter=true;$def($def.G+$def.W,{Symbol:$Symbol});$def($def.S,"Symbol",symbolStatics);$def($def.S+$def.F*!useNative,"Object",{create:$create,defineProperty:$defineProperty,defineProperties:$defineProperties,getOwnPropertyDescriptor:$getOwnPropertyDescriptor,getOwnPropertyNames:$getOwnPropertyNames,getOwnPropertySymbols:$getOwnPropertySymbols});$JSON&&$def($def.S+$def.F*(!useNative||buggyJSON),"JSON",{stringify:$stringify});setTag($Symbol,"Symbol");setTag(Math,"Math",true);setTag(global.JSON,"JSON",true)},function(module,exports){var $Object=Object;module.exports={create:$Object.create,getProto:$Object.getPrototypeOf,isEnum:{}.propertyIsEnumerable,getDesc:$Object.getOwnPropertyDescriptor,setDesc:$Object.defineProperty,setDescs:$Object.defineProperties,getKeys:$Object.keys,getNames:$Object.getOwnPropertyNames,getSymbols:$Object.getOwnPropertySymbols,each:[].forEach}},function(module,exports){var UNDEFINED="undefined";var global=module.exports=typeof window!=UNDEFINED&&window.Math==Math?window:typeof self!=UNDEFINED&&self.Math==Math?self:Function("return this")();if(typeof __g=="number")__g=global},function(module,exports){var hasOwnProperty={}.hasOwnProperty;module.exports=function(it,key){return hasOwnProperty.call(it,key)}},function(module,exports,__webpack_require__){module.exports=!__webpack_require__(7)(function(){return Object.defineProperty({},"a",{get:function(){return 7}}).a!=7})},function(module,exports){
module.exports=function(exec){try{return!!exec()}catch(e){return true}}},function(module,exports,__webpack_require__){var global=__webpack_require__(4),core=__webpack_require__(9),hide=__webpack_require__(10),$redef=__webpack_require__(12),PROTOTYPE="prototype";var ctx=function(fn,that){return function(){return fn.apply(that,arguments)}};var $def=function(type,name,source){var key,own,out,exp,isGlobal=type&$def.G,isProto=type&$def.P,target=isGlobal?global:type&$def.S?global[name]||(global[name]={}):(global[name]||{})[PROTOTYPE],exports=isGlobal?core:core[name]||(core[name]={});if(isGlobal)source=name;for(key in source){own=!(type&$def.F)&&target&&key in target;out=(own?target:source)[key];if(type&$def.B&&own)exp=ctx(out,global);else exp=isProto&&typeof out=="function"?ctx(Function.call,out):out;if(target&&!own)$redef(target,key,out);if(exports[key]!=out)hide(exports,key,exp);if(isProto)(exports[PROTOTYPE]||(exports[PROTOTYPE]={}))[key]=out}};global.core=core;$def.F=1;$def.G=2;$def.S=4;$def.P=8;$def.B=16;$def.W=32;module.exports=$def},function(module,exports){var core=module.exports={version:"1.2.1"};if(typeof __e=="number")__e=core},function(module,exports,__webpack_require__){var $=__webpack_require__(3),createDesc=__webpack_require__(11);module.exports=__webpack_require__(6)?function(object,key,value){return $.setDesc(object,key,createDesc(1,value))}:function(object,key,value){object[key]=value;return object}},function(module,exports){module.exports=function(bitmap,value){return{enumerable:!(bitmap&1),configurable:!(bitmap&2),writable:!(bitmap&4),value:value}}},function(module,exports,__webpack_require__){var global=__webpack_require__(4),hide=__webpack_require__(10),SRC=__webpack_require__(13)("src"),TO_STRING="toString",$toString=Function[TO_STRING],TPL=(""+$toString).split(TO_STRING);__webpack_require__(9).inspectSource=function(it){return $toString.call(it)};(module.exports=function(O,key,val,safe){if(typeof val=="function"){hide(val,SRC,O[key]?""+O[key]:TPL.join(String(key)));if(!("name"in val))val.name=key}if(O===global){O[key]=val}else{if(!safe)delete O[key];hide(O,key,val)}})(Function.prototype,TO_STRING,function toString(){return typeof this=="function"&&this[SRC]||$toString.call(this)})},function(module,exports){var id=0,px=Math.random();module.exports=function(key){return"Symbol(".concat(key===undefined?"":key,")_",(++id+px).toString(36))}},function(module,exports,__webpack_require__){var global=__webpack_require__(4),SHARED="__core-js_shared__",store=global[SHARED]||(global[SHARED]={});module.exports=function(key){return store[key]||(store[key]={})}},function(module,exports,__webpack_require__){var has=__webpack_require__(5),hide=__webpack_require__(10),TAG=__webpack_require__(16)("toStringTag");module.exports=function(it,tag,stat){if(it&&!has(it=stat?it:it.prototype,TAG))hide(it,TAG,tag)}},function(module,exports,__webpack_require__){var store=__webpack_require__(14)("wks"),Symbol=__webpack_require__(4).Symbol;module.exports=function(name){return store[name]||(store[name]=Symbol&&Symbol[name]||(Symbol||__webpack_require__(13))("Symbol."+name))}},function(module,exports,__webpack_require__){var $=__webpack_require__(3),toIObject=__webpack_require__(18);module.exports=function(object,el){var O=toIObject(object),keys=$.getKeys(O),length=keys.length,index=0,key;while(length>index)if(O[key=keys[index++]]===el)return key}},function(module,exports,__webpack_require__){var IObject=__webpack_require__(19),defined=__webpack_require__(21);module.exports=function(it){return IObject(defined(it))}},function(module,exports,__webpack_require__){var cof=__webpack_require__(20);module.exports=0 in Object("z")?Object:function(it){return cof(it)=="String"?it.split(""):Object(it)}},function(module,exports){var toString={}.toString;module.exports=function(it){return toString.call(it).slice(8,-1)}},function(module,exports){module.exports=function(it){if(it==undefined)throw TypeError("Can't call method on  "+it);return it}},function(module,exports,__webpack_require__){var toString={}.toString,toIObject=__webpack_require__(18),getNames=__webpack_require__(3).getNames;var windowNames=typeof window=="object"&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[];var getWindowNames=function(it){try{return getNames(it)}catch(e){return windowNames.slice()}};module.exports.get=function getOwnPropertyNames(it){if(windowNames&&toString.call(it)=="[object Window]")return getWindowNames(it);return getNames(toIObject(it))}},function(module,exports,__webpack_require__){var $=__webpack_require__(3);module.exports=function(it){var keys=$.getKeys(it),getSymbols=$.getSymbols;if(getSymbols){var symbols=getSymbols(it),isEnum=$.isEnum,i=0,key;while(symbols.length>i)if(isEnum.call(it,key=symbols[i++]))keys.push(key)}return keys}},function(module,exports,__webpack_require__){var cof=__webpack_require__(20);module.exports=Array.isArray||function(arg){return cof(arg)=="Array"}},function(module,exports){module.exports=function(it){return typeof it==="object"?it!==null:typeof it==="function"}},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25);module.exports=function(it){if(!isObject(it))throw TypeError(it+" is not an object!");return it}},function(module,exports){module.exports=false},function(module,exports,__webpack_require__){var $def=__webpack_require__(8);$def($def.S+$def.F,"Object",{assign:__webpack_require__(29)})},function(module,exports,__webpack_require__){var toObject=__webpack_require__(30),IObject=__webpack_require__(19),enumKeys=__webpack_require__(23),has=__webpack_require__(5);module.exports=__webpack_require__(7)(function(){var a=Object.assign,A={},B={},S=Symbol(),K="abcdefghijklmnopqrst";A[S]=7;K.split("").forEach(function(k){B[k]=k});return a({},A)[S]!=7||Object.keys(a({},B)).join("")!=K})?function assign(target,source){var T=toObject(target),l=arguments.length,i=1;while(l>i){var S=IObject(arguments[i++]),keys=enumKeys(S),length=keys.length,j=0,key;while(length>j)if(has(S,key=keys[j++]))T[key]=S[key]}return T}:Object.assign},function(module,exports,__webpack_require__){var defined=__webpack_require__(21);module.exports=function(it){return Object(defined(it))}},function(module,exports,__webpack_require__){var $def=__webpack_require__(8);$def($def.S,"Object",{is:__webpack_require__(32)})},function(module,exports){module.exports=Object.is||function is(x,y){return x===y?x!==0||1/x===1/y:x!=x&&y!=y}},function(module,exports,__webpack_require__){var $def=__webpack_require__(8);$def($def.S,"Object",{setPrototypeOf:__webpack_require__(34).set})},function(module,exports,__webpack_require__){var getDesc=__webpack_require__(3).getDesc,isObject=__webpack_require__(25),anObject=__webpack_require__(26);var check=function(O,proto){anObject(O);if(!isObject(proto)&&proto!==null)throw TypeError(proto+": can't set as prototype!")};module.exports={set:Object.setPrototypeOf||("__proto__"in{}?function(test,buggy,set){try{set=__webpack_require__(35)(Function.call,getDesc(Object.prototype,"__proto__").set,2);set(test,[]);buggy=!(test instanceof Array)}catch(e){buggy=true}return function setPrototypeOf(O,proto){check(O,proto);if(buggy)O.__proto__=proto;else set(O,proto);return O}}({},false):undefined),check:check}},function(module,exports,__webpack_require__){var aFunction=__webpack_require__(36);module.exports=function(fn,that,length){aFunction(fn);if(that===undefined)return fn;switch(length){case 1:return function(a){return fn.call(that,a)};case 2:return function(a,b){return fn.call(that,a,b)};case 3:return function(a,b,c){return fn.call(that,a,b,c)}}return function(){return fn.apply(that,arguments)}}},function(module,exports){module.exports=function(it){if(typeof it!="function")throw TypeError(it+" is not a function!");return it}},function(module,exports,__webpack_require__){"use strict";var classof=__webpack_require__(38),test={};test[__webpack_require__(16)("toStringTag")]="z";if(test+""!="[object z]"){__webpack_require__(12)(Object.prototype,"toString",function toString(){return"[object "+classof(this)+"]"},true)}},function(module,exports,__webpack_require__){var cof=__webpack_require__(20),TAG=__webpack_require__(16)("toStringTag"),ARG=cof(function(){return arguments}())=="Arguments";module.exports=function(it){var O,T,B;return it===undefined?"Undefined":it===null?"Null":typeof(T=(O=Object(it))[TAG])=="string"?T:ARG?cof(O):(B=cof(O))=="Object"&&typeof O.callee=="function"?"Arguments":B}},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25);__webpack_require__(40)("freeze",function($freeze){return function freeze(it){return $freeze&&isObject(it)?$freeze(it):it}})},function(module,exports,__webpack_require__){module.exports=function(KEY,exec){var $def=__webpack_require__(8),fn=(__webpack_require__(9).Object||{})[KEY]||Object[KEY],exp={};exp[KEY]=exec(fn);$def($def.S+$def.F*__webpack_require__(7)(function(){fn(1)}),"Object",exp)}},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25);__webpack_require__(40)("seal",function($seal){return function seal(it){return $seal&&isObject(it)?$seal(it):it}})},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25);__webpack_require__(40)("preventExtensions",function($preventExtensions){return function preventExtensions(it){return $preventExtensions&&isObject(it)?$preventExtensions(it):it}})},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25);__webpack_require__(40)("isFrozen",function($isFrozen){return function isFrozen(it){return isObject(it)?$isFrozen?$isFrozen(it):false:true}})},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25);__webpack_require__(40)("isSealed",function($isSealed){return function isSealed(it){return isObject(it)?$isSealed?$isSealed(it):false:true}})},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25);__webpack_require__(40)("isExtensible",function($isExtensible){return function isExtensible(it){return isObject(it)?$isExtensible?$isExtensible(it):true:false}})},function(module,exports,__webpack_require__){var toIObject=__webpack_require__(18);__webpack_require__(40)("getOwnPropertyDescriptor",function($getOwnPropertyDescriptor){return function getOwnPropertyDescriptor(it,key){return $getOwnPropertyDescriptor(toIObject(it),key)}})},function(module,exports,__webpack_require__){var toObject=__webpack_require__(30);__webpack_require__(40)("getPrototypeOf",function($getPrototypeOf){return function getPrototypeOf(it){return $getPrototypeOf(toObject(it))}})},function(module,exports,__webpack_require__){var toObject=__webpack_require__(30);__webpack_require__(40)("keys",function($keys){return function keys(it){return $keys(toObject(it))}})},function(module,exports,__webpack_require__){__webpack_require__(40)("getOwnPropertyNames",function(){return __webpack_require__(22).get})},function(module,exports,__webpack_require__){__webpack_require__(51);__webpack_require__(57);__webpack_require__(63);__webpack_require__(64);__webpack_require__(66);__webpack_require__(69);__webpack_require__(72);__webpack_require__(74);__webpack_require__(76);module.exports=__webpack_require__(9).Array},function(module,exports,__webpack_require__){"use strict";var $at=__webpack_require__(52)(true);__webpack_require__(54)(String,"String",function(iterated){this._t=String(iterated);this._i=0},function(){var O=this._t,index=this._i,point;if(index>=O.length)return{value:undefined,done:true};point=$at(O,index);this._i+=point.length;return{value:point,done:false}})},function(module,exports,__webpack_require__){var toInteger=__webpack_require__(53),defined=__webpack_require__(21);module.exports=function(TO_STRING){return function(that,pos){var s=String(defined(that)),i=toInteger(pos),l=s.length,a,b;if(i<0||i>=l)return TO_STRING?"":undefined;a=s.charCodeAt(i);return a<55296||a>56319||i+1===l||(b=s.charCodeAt(i+1))<56320||b>57343?TO_STRING?s.charAt(i):a:TO_STRING?s.slice(i,i+2):(a-55296<<10)+(b-56320)+65536}}},function(module,exports){var ceil=Math.ceil,floor=Math.floor;module.exports=function(it){return isNaN(it=+it)?0:(it>0?floor:ceil)(it)}},function(module,exports,__webpack_require__){"use strict";var LIBRARY=__webpack_require__(27),$def=__webpack_require__(8),$redef=__webpack_require__(12),hide=__webpack_require__(10),has=__webpack_require__(5),SYMBOL_ITERATOR=__webpack_require__(16)("iterator"),Iterators=__webpack_require__(55),BUGGY=!([].keys&&"next"in[].keys()),FF_ITERATOR="@@iterator",KEYS="keys",VALUES="values";var returnThis=function(){return this};module.exports=function(Base,NAME,Constructor,next,DEFAULT,IS_SET,FORCE){__webpack_require__(56)(Constructor,NAME,next);var createMethod=function(kind){switch(kind){case KEYS:return function keys(){return new Constructor(this,kind)};case VALUES:return function values(){return new Constructor(this,kind)}}return function entries(){return new Constructor(this,kind)}};var TAG=NAME+" Iterator",proto=Base.prototype,_native=proto[SYMBOL_ITERATOR]||proto[FF_ITERATOR]||DEFAULT&&proto[DEFAULT],_default=_native||createMethod(DEFAULT),methods,key;if(_native){var IteratorPrototype=__webpack_require__(3).getProto(_default.call(new Base));__webpack_require__(15)(IteratorPrototype,TAG,true);if(!LIBRARY&&has(proto,FF_ITERATOR))hide(IteratorPrototype,SYMBOL_ITERATOR,returnThis)}if(!LIBRARY||FORCE)hide(proto,SYMBOL_ITERATOR,_default);Iterators[NAME]=_default;Iterators[TAG]=returnThis;if(DEFAULT){methods={keys:IS_SET?_default:createMethod(KEYS),values:DEFAULT==VALUES?_default:createMethod(VALUES),entries:DEFAULT!=VALUES?_default:createMethod("entries")};if(FORCE)for(key in methods){if(!(key in proto))$redef(proto,key,methods[key])}else $def($def.P+$def.F*BUGGY,NAME,methods)}}},function(module,exports){module.exports={}},function(module,exports,__webpack_require__){"use strict";var $=__webpack_require__(3),IteratorPrototype={};__webpack_require__(10)(IteratorPrototype,__webpack_require__(16)("iterator"),function(){return this});module.exports=function(Constructor,NAME,next){Constructor.prototype=$.create(IteratorPrototype,{next:__webpack_require__(11)(1,next)});__webpack_require__(15)(Constructor,NAME+" Iterator")}},function(module,exports,__webpack_require__){"use strict";var ctx=__webpack_require__(35),$def=__webpack_require__(8),toObject=__webpack_require__(30),call=__webpack_require__(58),isArrayIter=__webpack_require__(59),toLength=__webpack_require__(60),getIterFn=__webpack_require__(61);$def($def.S+$def.F*!__webpack_require__(62)(function(iter){Array.from(iter)}),"Array",{from:function from(arrayLike){var O=toObject(arrayLike),C=typeof this=="function"?this:Array,mapfn=arguments[1],mapping=mapfn!==undefined,index=0,iterFn=getIterFn(O),length,result,step,iterator;if(mapping)mapfn=ctx(mapfn,arguments[2],2);if(iterFn!=undefined&&!(C==Array&&isArrayIter(iterFn))){for(iterator=iterFn.call(O),result=new C;!(step=iterator.next()).done;index++){result[index]=mapping?call(iterator,mapfn,[step.value,index],true):step.value}}else{length=toLength(O.length);for(result=new C(length);length>index;index++){result[index]=mapping?mapfn(O[index],index):O[index]}}result.length=index;return result}})},function(module,exports,__webpack_require__){var anObject=__webpack_require__(26);module.exports=function(iterator,fn,value,entries){try{return entries?fn(anObject(value)[0],value[1]):fn(value)}catch(e){var ret=iterator["return"];if(ret!==undefined)anObject(ret.call(iterator));throw e}}},function(module,exports,__webpack_require__){var Iterators=__webpack_require__(55),ITERATOR=__webpack_require__(16)("iterator");module.exports=function(it){return(Iterators.Array||Array.prototype[ITERATOR])===it}},function(module,exports,__webpack_require__){var toInteger=__webpack_require__(53),min=Math.min;module.exports=function(it){return it>0?min(toInteger(it),9007199254740991):0}},function(module,exports,__webpack_require__){var classof=__webpack_require__(38),ITERATOR=__webpack_require__(16)("iterator"),Iterators=__webpack_require__(55);module.exports=__webpack_require__(9).getIteratorMethod=function(it){if(it!=undefined)return it[ITERATOR]||it["@@iterator"]||Iterators[classof(it)]}},function(module,exports,__webpack_require__){var SYMBOL_ITERATOR=__webpack_require__(16)("iterator"),SAFE_CLOSING=false;try{var riter=[7][SYMBOL_ITERATOR]();riter["return"]=function(){SAFE_CLOSING=true};Array.from(riter,function(){throw 2})}catch(e){}module.exports=function(exec){if(!SAFE_CLOSING)return false;var safe=false;try{var arr=[7],iter=arr[SYMBOL_ITERATOR]();iter.next=function(){safe=true};arr[SYMBOL_ITERATOR]=function(){return iter};exec(arr)}catch(e){}return safe}},function(module,exports,__webpack_require__){"use strict";var $def=__webpack_require__(8);$def($def.S+$def.F*__webpack_require__(7)(function(){function F(){}return!(Array.of.call(F)instanceof F)}),"Array",{of:function of(){var index=0,length=arguments.length,result=new(typeof this=="function"?this:Array)(length);while(length>index)result[index]=arguments[index++];result.length=length;return result}})},function(module,exports,__webpack_require__){__webpack_require__(65)(Array)},function(module,exports,__webpack_require__){"use strict";var $=__webpack_require__(3),SPECIES=__webpack_require__(16)("species");module.exports=function(C){if(__webpack_require__(6)&&!(SPECIES in C))$.setDesc(C,SPECIES,{configurable:true,get:function(){return this}})}},function(module,exports,__webpack_require__){"use strict";var setUnscope=__webpack_require__(67),step=__webpack_require__(68),Iterators=__webpack_require__(55),toIObject=__webpack_require__(18);__webpack_require__(54)(Array,"Array",function(iterated,kind){this._t=toIObject(iterated);this._i=0;this._k=kind},function(){var O=this._t,kind=this._k,index=this._i++;if(!O||index>=O.length){this._t=undefined;return step(1)}if(kind=="keys")return step(0,index);if(kind=="values")return step(0,O[index]);return step(0,[index,O[index]])},"values");Iterators.Arguments=Iterators.Array;setUnscope("keys");setUnscope("values");setUnscope("entries")},function(module,exports,__webpack_require__){var UNSCOPABLES=__webpack_require__(16)("unscopables");if([][UNSCOPABLES]==undefined)__webpack_require__(10)(Array.prototype,UNSCOPABLES,{});module.exports=function(key){[][UNSCOPABLES][key]=true}},function(module,exports){module.exports=function(done,value){return{value:value,done:!!done}}},function(module,exports,__webpack_require__){"use strict";var $def=__webpack_require__(8);$def($def.P,"Array",{copyWithin:__webpack_require__(70)});__webpack_require__(67)("copyWithin")},function(module,exports,__webpack_require__){"use strict";var toObject=__webpack_require__(30),toIndex=__webpack_require__(71),toLength=__webpack_require__(60);module.exports=[].copyWithin||function copyWithin(target,start){var O=toObject(this),len=toLength(O.length),to=toIndex(target,len),from=toIndex(start,len),end=arguments[2],count=Math.min((end===undefined?len:toIndex(end,len))-from,len-to),inc=1;if(from<to&&to<from+count){inc=-1;from+=count-1;to+=count-1}while(count-- >0){if(from in O)O[to]=O[from];else delete O[to];to+=inc;from+=inc}return O}},function(module,exports,__webpack_require__){var toInteger=__webpack_require__(53),max=Math.max,min=Math.min;module.exports=function(index,length){index=toInteger(index);return index<0?max(index+length,0):min(index,length)}},function(module,exports,__webpack_require__){var $def=__webpack_require__(8);$def($def.P,"Array",{fill:__webpack_require__(73)});__webpack_require__(67)("fill")},function(module,exports,__webpack_require__){"use strict";var toObject=__webpack_require__(30),toIndex=__webpack_require__(71),toLength=__webpack_require__(60);module.exports=[].fill||function fill(value){var O=toObject(this,true),length=toLength(O.length),index=toIndex(arguments[1],length),end=arguments[2],endPos=end===undefined?length:toIndex(end,length);while(endPos>index)O[index++]=value;return O}},function(module,exports,__webpack_require__){"use strict";var KEY="find",$def=__webpack_require__(8),forced=true,$find=__webpack_require__(75)(5);if(KEY in[])Array(1)[KEY](function(){forced=false});$def($def.P+$def.F*forced,"Array",{find:function find(callbackfn){return $find(this,callbackfn,arguments[1])}});__webpack_require__(67)(KEY)},function(module,exports,__webpack_require__){var ctx=__webpack_require__(35),isObject=__webpack_require__(25),IObject=__webpack_require__(19),toObject=__webpack_require__(30),toLength=__webpack_require__(60),isArray=__webpack_require__(24),SPECIES=__webpack_require__(16)("species");var ASC=function(original,length){var C;if(isArray(original)&&isObject(C=original.constructor)){C=C[SPECIES];if(C===null)C=undefined}return new(C===undefined?Array:C)(length)};module.exports=function(TYPE){var IS_MAP=TYPE==1,IS_FILTER=TYPE==2,IS_SOME=TYPE==3,IS_EVERY=TYPE==4,IS_FIND_INDEX=TYPE==6,NO_HOLES=TYPE==5||IS_FIND_INDEX;return function($this,callbackfn,that){var O=toObject($this),self=IObject(O),f=ctx(callbackfn,that,3),length=toLength(self.length),index=0,result=IS_MAP?ASC($this,length):IS_FILTER?ASC($this,0):undefined,val,res;for(;length>index;index++)if(NO_HOLES||index in self){val=self[index];res=f(val,index,O);if(TYPE){if(IS_MAP)result[index]=res;else if(res)switch(TYPE){case 3:return true;case 5:return val;case 6:return index;case 2:result.push(val)}else if(IS_EVERY)return false}}return IS_FIND_INDEX?-1:IS_SOME||IS_EVERY?IS_EVERY:result}}},function(module,exports,__webpack_require__){"use strict";var KEY="findIndex",$def=__webpack_require__(8),forced=true,$find=__webpack_require__(75)(6);if(KEY in[])Array(1)[KEY](function(){forced=false});$def($def.P+$def.F*forced,"Array",{findIndex:function findIndex(callbackfn){return $find(this,callbackfn,arguments[1])}});__webpack_require__(67)(KEY)},function(module,exports,__webpack_require__){__webpack_require__(78);__webpack_require__(79);__webpack_require__(80);__webpack_require__(51);__webpack_require__(82);__webpack_require__(83);__webpack_require__(87);__webpack_require__(88);__webpack_require__(90);__webpack_require__(91);__webpack_require__(93);__webpack_require__(94);__webpack_require__(95);module.exports=__webpack_require__(9).String},function(module,exports,__webpack_require__){var $def=__webpack_require__(8),toIndex=__webpack_require__(71),fromCharCode=String.fromCharCode,$fromCodePoint=String.fromCodePoint;$def($def.S+$def.F*(!!$fromCodePoint&&$fromCodePoint.length!=1),"String",{fromCodePoint:function fromCodePoint(x){var res=[],len=arguments.length,i=0,code;while(len>i){code=+arguments[i++];if(toIndex(code,1114111)!==code)throw RangeError(code+" is not a valid code point");res.push(code<65536?fromCharCode(code):fromCharCode(((code-=65536)>>10)+55296,code%1024+56320))}return res.join("")}})},function(module,exports,__webpack_require__){var $def=__webpack_require__(8),toIObject=__webpack_require__(18),toLength=__webpack_require__(60);$def($def.S,"String",{raw:function raw(callSite){var tpl=toIObject(callSite.raw),len=toLength(tpl.length),sln=arguments.length,res=[],i=0;while(len>i){res.push(String(tpl[i++]));if(i<sln)res.push(String(arguments[i]))}return res.join("")}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(81)("trim",function($trim){return function trim(){return $trim(this,3)}})},function(module,exports,__webpack_require__){var trim=function(string,TYPE){string=String(defined(string));if(TYPE&1)string=string.replace(ltrim,"");if(TYPE&2)string=string.replace(rtrim,"");return string};var $def=__webpack_require__(8),defined=__webpack_require__(21),spaces="	\n\x0B\f\r   ᠎    "+"         　\u2028\u2029\ufeff",space="["+spaces+"]",non="​",ltrim=RegExp("^"+space+space+"*"),rtrim=RegExp(space+space+"*$");module.exports=function(KEY,exec){var exp={};exp[KEY]=exec(trim);$def($def.P+$def.F*__webpack_require__(7)(function(){return!!spaces[KEY]()||non[KEY]()!=non}),"String",exp)}},function(module,exports,__webpack_require__){"use strict";var $def=__webpack_require__(8),$at=__webpack_require__(52)(false);$def($def.P,"String",{codePointAt:function codePointAt(pos){return $at(this,pos)}})},function(module,exports,__webpack_require__){"use strict";var $def=__webpack_require__(8),toLength=__webpack_require__(60),context=__webpack_require__(84),ENDS_WITH="endsWith",$endsWith=""[ENDS_WITH];$def($def.P+$def.F*__webpack_require__(86)(ENDS_WITH),"String",{endsWith:function endsWith(searchString){var that=context(this,searchString,ENDS_WITH),endPosition=arguments[1],len=toLength(that.length),end=endPosition===undefined?len:Math.min(toLength(endPosition),len),search=String(searchString);return $endsWith?$endsWith.call(that,search,end):that.slice(end-search.length,end)===search}})},function(module,exports,__webpack_require__){var isRegExp=__webpack_require__(85),defined=__webpack_require__(21);module.exports=function(that,searchString,NAME){if(isRegExp(searchString))throw TypeError("String#"+NAME+" doesn't accept regex!");return String(defined(that))}},function(module,exports,__webpack_require__){var isObject=__webpack_require__(25),cof=__webpack_require__(20),MATCH=__webpack_require__(16)("match");module.exports=function(it){var isRegExp;return isObject(it)&&((isRegExp=it[MATCH])!==undefined?!!isRegExp:cof(it)=="RegExp")}},function(module,exports,__webpack_require__){module.exports=function(KEY){var re=/./;try{"/./"[KEY](re)}catch(e){try{re[__webpack_require__(16)("match")]=false;return!"/./"[KEY](re)}catch(e){}}return true}},function(module,exports,__webpack_require__){"use strict";var $def=__webpack_require__(8),context=__webpack_require__(84),INCLUDES="includes";$def($def.P+$def.F*__webpack_require__(86)(INCLUDES),"String",{includes:function includes(searchString){return!!~context(this,searchString,INCLUDES).indexOf(searchString,arguments[1])}})},function(module,exports,__webpack_require__){var $def=__webpack_require__(8);$def($def.P,"String",{repeat:__webpack_require__(89)})},function(module,exports,__webpack_require__){"use strict";var toInteger=__webpack_require__(53),defined=__webpack_require__(21);module.exports=function repeat(count){var str=String(defined(this)),res="",n=toInteger(count);if(n<0||n==Infinity)throw RangeError("Count can't be negative");for(;n>0;(n>>>=1)&&(str+=str))if(n&1)res+=str;return res}},function(module,exports,__webpack_require__){"use strict";var $def=__webpack_require__(8),toLength=__webpack_require__(60),context=__webpack_require__(84),STARTS_WITH="startsWith",$startsWith=""[STARTS_WITH];$def($def.P+$def.F*__webpack_require__(86)(STARTS_WITH),"String",{startsWith:function startsWith(searchString){var that=context(this,searchString,STARTS_WITH),index=toLength(Math.min(arguments[1],that.length)),search=String(searchString);return $startsWith?$startsWith.call(that,search,index):that.slice(index,index+search.length)===search}})},function(module,exports,__webpack_require__){__webpack_require__(92)("match",1,function(defined,MATCH){return function match(regexp){"use strict";var O=defined(this),fn=regexp==undefined?undefined:regexp[MATCH];return fn!==undefined?fn.call(regexp,O):new RegExp(regexp)[MATCH](String(O))}})},function(module,exports,__webpack_require__){"use strict";module.exports=function(KEY,length,exec){var defined=__webpack_require__(21),SYMBOL=__webpack_require__(16)(KEY),original=""[KEY];if(__webpack_require__(7)(function(){var O={};O[SYMBOL]=function(){return 7};return""[KEY](O)!=7})){__webpack_require__(12)(String.prototype,KEY,exec(defined,SYMBOL,original));__webpack_require__(10)(RegExp.prototype,SYMBOL,length==2?function(string,arg){return original.call(string,this,arg)}:function(string){return original.call(string,this)})}}},function(module,exports,__webpack_require__){__webpack_require__(92)("replace",2,function(defined,REPLACE,$replace){return function replace(searchValue,replaceValue){"use strict";var O=defined(this),fn=searchValue==undefined?undefined:searchValue[REPLACE];return fn!==undefined?fn.call(searchValue,O,replaceValue):$replace.call(String(O),searchValue,replaceValue)}})},function(module,exports,__webpack_require__){__webpack_require__(92)("search",1,function(defined,SEARCH){return function search(regexp){"use strict";var O=defined(this),fn=regexp==undefined?undefined:regexp[SEARCH];return fn!==undefined?fn.call(regexp,O):new RegExp(regexp)[SEARCH](String(O))}})},function(module,exports,__webpack_require__){__webpack_require__(92)("split",2,function(defined,SPLIT,$split){return function split(separator,limit){"use strict";var O=defined(this),fn=separator==undefined?undefined:separator[SPLIT];return fn!==undefined?fn.call(separator,O,limit):$split.call(String(O),separator,limit)}})},function(module,exports,__webpack_require__){__webpack_require__(97);__webpack_require__(98);module.exports=__webpack_require__(9).Function},function(module,exports,__webpack_require__){var setDesc=__webpack_require__(3).setDesc,createDesc=__webpack_require__(11),has=__webpack_require__(5),FProto=Function.prototype,nameRE=/^\s*function ([^ (]*)/,NAME="name";NAME in FProto||__webpack_require__(6)&&setDesc(FProto,NAME,{configurable:true,get:function(){var match=(""+this).match(nameRE),name=match?match[1]:"";has(this,NAME)||setDesc(this,NAME,createDesc(5,name));return name}})},function(module,exports,__webpack_require__){"use strict";var $=__webpack_require__(3),isObject=__webpack_require__(25),HAS_INSTANCE=__webpack_require__(16)("hasInstance"),FunctionProto=Function.prototype;if(!(HAS_INSTANCE in FunctionProto))$.setDesc(FunctionProto,HAS_INSTANCE,{value:function(O){if(typeof this!="function"||!isObject(O))return false;if(!isObject(this.prototype))return O instanceof this;while(O=$.getProto(O))if(this.prototype===O)return true;return false}})},function(module,exports,__webpack_require__){__webpack_require__(2);module.exports=__webpack_require__(9).Symbol},function(module,exports,__webpack_require__){__webpack_require__(37);__webpack_require__(51);__webpack_require__(101);__webpack_require__(102);module.exports=__webpack_require__(9).Map},function(module,exports,__webpack_require__){__webpack_require__(66);var global=__webpack_require__(4),hide=__webpack_require__(10),Iterators=__webpack_require__(55),ITERATOR=__webpack_require__(16)("iterator"),NL=global.NodeList,HTC=global.HTMLCollection,NLProto=NL&&NL.prototype,HTCProto=HTC&&HTC.prototype,ArrayValues=Iterators.NodeList=Iterators.HTMLCollection=Iterators.Array;if(NL&&!(ITERATOR in NLProto))hide(NLProto,ITERATOR,ArrayValues);if(HTC&&!(ITERATOR in HTCProto))hide(HTCProto,ITERATOR,ArrayValues)},function(module,exports,__webpack_require__){"use strict";var strong=__webpack_require__(103);__webpack_require__(107)("Map",function(get){return function Map(){return get(this,arguments[0])}},{get:function get(key){var entry=strong.getEntry(this,key);return entry&&entry.v},set:function set(key,value){return strong.def(this,key===0?0:key,value)}},strong,true)},function(module,exports,__webpack_require__){"use strict";var $=__webpack_require__(3),hide=__webpack_require__(10),ctx=__webpack_require__(35),species=__webpack_require__(65),strictNew=__webpack_require__(104),defined=__webpack_require__(21),forOf=__webpack_require__(105),step=__webpack_require__(68),ID=__webpack_require__(13)("id"),$has=__webpack_require__(5),isObject=__webpack_require__(25),isExtensible=Object.isExtensible||isObject,SUPPORT_DESC=__webpack_require__(6),SIZE=SUPPORT_DESC?"_s":"size",id=0;var fastKey=function(it,create){if(!isObject(it))return typeof it=="symbol"?it:(typeof it=="string"?"S":"P")+it;if(!$has(it,ID)){if(!isExtensible(it))return"F";if(!create)return"E";hide(it,ID,++id)}return"O"+it[ID]};var getEntry=function(that,key){var index=fastKey(key),entry;if(index!=="F")return that._i[index];for(entry=that._f;entry;entry=entry.n){if(entry.k==key)return entry}};module.exports={getConstructor:function(wrapper,NAME,IS_MAP,ADDER){var C=wrapper(function(that,iterable){strictNew(that,C,NAME);that._i=$.create(null);that._f=undefined;that._l=undefined;that[SIZE]=0;if(iterable!=undefined)forOf(iterable,IS_MAP,that[ADDER],that);
});__webpack_require__(106)(C.prototype,{clear:function clear(){for(var that=this,data=that._i,entry=that._f;entry;entry=entry.n){entry.r=true;if(entry.p)entry.p=entry.p.n=undefined;delete data[entry.i]}that._f=that._l=undefined;that[SIZE]=0},"delete":function(key){var that=this,entry=getEntry(that,key);if(entry){var next=entry.n,prev=entry.p;delete that._i[entry.i];entry.r=true;if(prev)prev.n=next;if(next)next.p=prev;if(that._f==entry)that._f=next;if(that._l==entry)that._l=prev;that[SIZE]--}return!!entry},forEach:function forEach(callbackfn){var f=ctx(callbackfn,arguments[1],3),entry;while(entry=entry?entry.n:this._f){f(entry.v,entry.k,this);while(entry&&entry.r)entry=entry.p}},has:function has(key){return!!getEntry(this,key)}});if(SUPPORT_DESC)$.setDesc(C.prototype,"size",{get:function(){return defined(this[SIZE])}});return C},def:function(that,key,value){var entry=getEntry(that,key),prev,index;if(entry){entry.v=value}else{that._l=entry={i:index=fastKey(key,true),k:key,v:value,p:prev=that._l,n:undefined,r:false};if(!that._f)that._f=entry;if(prev)prev.n=entry;that[SIZE]++;if(index!=="F")that._i[index]=entry}return that},getEntry:getEntry,setStrong:function(C,NAME,IS_MAP){__webpack_require__(54)(C,NAME,function(iterated,kind){this._t=iterated;this._k=kind;this._l=undefined},function(){var that=this,kind=that._k,entry=that._l;while(entry&&entry.r)entry=entry.p;if(!that._t||!(that._l=entry=entry?entry.n:that._t._f)){that._t=undefined;return step(1)}if(kind=="keys")return step(0,entry.k);if(kind=="values")return step(0,entry.v);return step(0,[entry.k,entry.v])},IS_MAP?"entries":"values",!IS_MAP,true);species(C);species(__webpack_require__(9)[NAME])}}},function(module,exports){module.exports=function(it,Constructor,name){if(!(it instanceof Constructor))throw TypeError(name+": use the 'new' operator!");return it}},function(module,exports,__webpack_require__){var ctx=__webpack_require__(35),call=__webpack_require__(58),isArrayIter=__webpack_require__(59),anObject=__webpack_require__(26),toLength=__webpack_require__(60),getIterFn=__webpack_require__(61);module.exports=function(iterable,entries,fn,that){var iterFn=getIterFn(iterable),f=ctx(fn,that,entries?2:1),index=0,length,step,iterator;if(typeof iterFn!="function")throw TypeError(iterable+" is not iterable!");if(isArrayIter(iterFn))for(length=toLength(iterable.length);length>index;index++){entries?f(anObject(step=iterable[index])[0],step[1]):f(iterable[index])}else for(iterator=iterFn.call(iterable);!(step=iterator.next()).done;){call(iterator,f,step.value,entries)}}},function(module,exports,__webpack_require__){var $redef=__webpack_require__(12);module.exports=function(target,src){for(var key in src)$redef(target,key,src[key]);return target}},function(module,exports,__webpack_require__){"use strict";var global=__webpack_require__(4),$def=__webpack_require__(8),forOf=__webpack_require__(105),strictNew=__webpack_require__(104);module.exports=function(NAME,wrapper,methods,common,IS_MAP,IS_WEAK){var Base=global[NAME],C=Base,ADDER=IS_MAP?"set":"add",proto=C&&C.prototype,O={};var fixMethod=function(KEY){var fn=proto[KEY];__webpack_require__(12)(proto,KEY,KEY=="delete"?function(a){return fn.call(this,a===0?0:a)}:KEY=="has"?function has(a){return fn.call(this,a===0?0:a)}:KEY=="get"?function get(a){return fn.call(this,a===0?0:a)}:KEY=="add"?function add(a){fn.call(this,a===0?0:a);return this}:function set(a,b){fn.call(this,a===0?0:a,b);return this})};if(typeof C!="function"||!(IS_WEAK||proto.forEach&&!__webpack_require__(7)(function(){(new C).entries().next()}))){C=common.getConstructor(wrapper,NAME,IS_MAP,ADDER);__webpack_require__(106)(C.prototype,methods)}else{var inst=new C,chain=inst[ADDER](IS_WEAK?{}:-0,1),buggyZero;if(!__webpack_require__(62)(function(iter){new C(iter)})){C=wrapper(function(target,iterable){strictNew(target,C,NAME);var that=new Base;if(iterable!=undefined)forOf(iterable,IS_MAP,that[ADDER],that);return that});C.prototype=proto;proto.constructor=C}IS_WEAK||inst.forEach(function(val,key){buggyZero=1/key===-Infinity});if(buggyZero){fixMethod("delete");fixMethod("has");IS_MAP&&fixMethod("get")}if(buggyZero||chain!==inst)fixMethod(ADDER);if(IS_WEAK&&proto.clear)delete proto.clear}__webpack_require__(15)(C,NAME);O[NAME]=C;$def($def.G+$def.W+$def.F*(C!=Base),O);if(!IS_WEAK)common.setStrong(C,NAME,IS_MAP);return C}},function(module,exports,__webpack_require__){__webpack_require__(37);__webpack_require__(51);__webpack_require__(101);__webpack_require__(109);module.exports=__webpack_require__(9).Set},function(module,exports,__webpack_require__){"use strict";var strong=__webpack_require__(103);__webpack_require__(107)("Set",function(get){return function Set(){return get(this,arguments[0])}},{add:function add(value){return strong.def(this,value=value===0?0:value,value)}},strong)}]);if(typeof Package==="undefined")Package={};Package["ecmascript-runtime"]={Symbol:Symbol,Map:Map,Set:Set}})();(function(){var Meteor=Package.meteor.Meteor;var Promise;(function(){(function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:false};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.loaded=true;return module.exports}__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.p="";return __webpack_require__(0)})([function(module,exports,__webpack_require__){var MeteorPromise=__webpack_require__(1);var es6PromiseThen=MeteorPromise.prototype.then;MeteorPromise.prototype.then=function(onResolved,onRejected){if(typeof Meteor==="object"&&typeof Meteor.bindEnvironment==="function"){return es6PromiseThen.call(this,onResolved&&Meteor.bindEnvironment(onResolved,raise),onRejected&&Meteor.bindEnvironment(onRejected,raise))}return es6PromiseThen.call(this,onResolved,onRejected)};function raise(exception){throw exception}Promise=MeteorPromise},function(module,exports,__webpack_require__){(function(global){var hasOwn=Object.prototype.hasOwnProperty;var g=typeof global==="object"?global:typeof window==="object"?window:typeof self==="object"?self:this;var GlobalPromise=g.Promise;var NpmPromise=__webpack_require__(2);function copyMethods(target,source){Object.keys(source).forEach(function(key){var value=source[key];if(typeof value==="function"&&!hasOwn.call(target,key)){target[key]=value}})}if(typeof GlobalPromise==="function"){copyMethods(GlobalPromise,NpmPromise);copyMethods(GlobalPromise.prototype,NpmPromise.prototype);module.exports=GlobalPromise}else{module.exports=NpmPromise}}).call(exports,function(){return this}())},function(module,exports,__webpack_require__){"use strict";module.exports=__webpack_require__(3)},function(module,exports,__webpack_require__){"use strict";module.exports=__webpack_require__(4);__webpack_require__(6);__webpack_require__(7);__webpack_require__(8);__webpack_require__(9)},function(module,exports,__webpack_require__){"use strict";var asap=__webpack_require__(5);function noop(){}var LAST_ERROR=null;var IS_ERROR={};function getThen(obj){try{return obj.then}catch(ex){LAST_ERROR=ex;return IS_ERROR}}function tryCallOne(fn,a){try{return fn(a)}catch(ex){LAST_ERROR=ex;return IS_ERROR}}function tryCallTwo(fn,a,b){try{fn(a,b)}catch(ex){LAST_ERROR=ex;return IS_ERROR}}module.exports=Promise;function Promise(fn){if(typeof this!=="object"){throw new TypeError("Promises must be constructed via new")}if(typeof fn!=="function"){throw new TypeError("not a function")}this._37=0;this._12=null;this._59=[];if(fn===noop)return;doResolve(fn,this)}Promise._99=noop;Promise.prototype.then=function(onFulfilled,onRejected){if(this.constructor!==Promise){return safeThen(this,onFulfilled,onRejected)}var res=new Promise(noop);handle(this,new Handler(onFulfilled,onRejected,res));return res};function safeThen(self,onFulfilled,onRejected){return new self.constructor(function(resolve,reject){var res=new Promise(noop);res.then(resolve,reject);handle(self,new Handler(onFulfilled,onRejected,res))})}function handle(self,deferred){while(self._37===3){self=self._12}if(self._37===0){self._59.push(deferred);return}asap(function(){var cb=self._37===1?deferred.onFulfilled:deferred.onRejected;if(cb===null){if(self._37===1){resolve(deferred.promise,self._12)}else{reject(deferred.promise,self._12)}return}var ret=tryCallOne(cb,self._12);if(ret===IS_ERROR){reject(deferred.promise,LAST_ERROR)}else{resolve(deferred.promise,ret)}})}function resolve(self,newValue){if(newValue===self){return reject(self,new TypeError("A promise cannot be resolved with itself."))}if(newValue&&(typeof newValue==="object"||typeof newValue==="function")){var then=getThen(newValue);if(then===IS_ERROR){return reject(self,LAST_ERROR)}if(then===self.then&&newValue instanceof Promise){self._37=3;self._12=newValue;finale(self);return}else if(typeof then==="function"){doResolve(then.bind(newValue),self);return}}self._37=1;self._12=newValue;finale(self)}function reject(self,newValue){self._37=2;self._12=newValue;finale(self)}function finale(self){for(var i=0;i<self._59.length;i++){handle(self,self._59[i])}self._59=null}function Handler(onFulfilled,onRejected,promise){this.onFulfilled=typeof onFulfilled==="function"?onFulfilled:null;this.onRejected=typeof onRejected==="function"?onRejected:null;this.promise=promise}function doResolve(fn,promise){var done=false;var res=tryCallTwo(fn,function(value){if(done)return;done=true;resolve(promise,value)},function(reason){if(done)return;done=true;reject(promise,reason)});if(!done&&res===IS_ERROR){done=true;reject(promise,LAST_ERROR)}}},function(module,exports){(function(global){"use strict";module.exports=rawAsap;function rawAsap(task){if(!queue.length){requestFlush();flushing=true}queue[queue.length]=task}var queue=[];var flushing=false;var requestFlush;var index=0;var capacity=1024;function flush(){while(index<queue.length){var currentIndex=index;index=index+1;queue[currentIndex].call();if(index>capacity){for(var scan=0,newLength=queue.length-index;scan<newLength;scan++){queue[scan]=queue[scan+index]}queue.length-=index;index=0}}queue.length=0;index=0;flushing=false}var BrowserMutationObserver=global.MutationObserver||global.WebKitMutationObserver;if(typeof BrowserMutationObserver==="function"){requestFlush=makeRequestCallFromMutationObserver(flush)}else{requestFlush=makeRequestCallFromTimer(flush)}rawAsap.requestFlush=requestFlush;function makeRequestCallFromMutationObserver(callback){var toggle=1;var observer=new BrowserMutationObserver(callback);var node=document.createTextNode("");observer.observe(node,{characterData:true});return function requestCall(){toggle=-toggle;node.data=toggle}}function makeRequestCallFromTimer(callback){return function requestCall(){var timeoutHandle=setTimeout(handleTimer,0);var intervalHandle=setInterval(handleTimer,50);function handleTimer(){clearTimeout(timeoutHandle);clearInterval(intervalHandle);callback()}}}rawAsap.makeRequestCallFromTimer=makeRequestCallFromTimer}).call(exports,function(){return this}())},function(module,exports,__webpack_require__){"use strict";var Promise=__webpack_require__(4);module.exports=Promise;Promise.prototype.done=function(onFulfilled,onRejected){var self=arguments.length?this.then.apply(this,arguments):this;self.then(null,function(err){setTimeout(function(){throw err},0)})}},function(module,exports,__webpack_require__){"use strict";var Promise=__webpack_require__(4);module.exports=Promise;Promise.prototype["finally"]=function(f){return this.then(function(value){return Promise.resolve(f()).then(function(){return value})},function(err){return Promise.resolve(f()).then(function(){throw err})})}},function(module,exports,__webpack_require__){"use strict";var Promise=__webpack_require__(4);module.exports=Promise;var TRUE=valuePromise(true);var FALSE=valuePromise(false);var NULL=valuePromise(null);var UNDEFINED=valuePromise(undefined);var ZERO=valuePromise(0);var EMPTYSTRING=valuePromise("");function valuePromise(value){var p=new Promise(Promise._99);p._37=1;p._12=value;return p}Promise.resolve=function(value){if(value instanceof Promise)return value;if(value===null)return NULL;if(value===undefined)return UNDEFINED;if(value===true)return TRUE;if(value===false)return FALSE;if(value===0)return ZERO;if(value==="")return EMPTYSTRING;if(typeof value==="object"||typeof value==="function"){try{var then=value.then;if(typeof then==="function"){return new Promise(then.bind(value))}}catch(ex){return new Promise(function(resolve,reject){reject(ex)})}}return valuePromise(value)};Promise.all=function(arr){var args=Array.prototype.slice.call(arr);return new Promise(function(resolve,reject){if(args.length===0)return resolve([]);var remaining=args.length;function res(i,val){if(val&&(typeof val==="object"||typeof val==="function")){if(val instanceof Promise&&val.then===Promise.prototype.then){while(val._37===3){val=val._12}if(val._37===1)return res(i,val._12);if(val._37===2)reject(val._12);val.then(function(val){res(i,val)},reject);return}else{var then=val.then;if(typeof then==="function"){var p=new Promise(then.bind(val));p.then(function(val){res(i,val)},reject);return}}}args[i]=val;if(--remaining===0){resolve(args)}}for(var i=0;i<args.length;i++){res(i,args[i])}})};Promise.reject=function(value){return new Promise(function(resolve,reject){reject(value)})};Promise.race=function(values){return new Promise(function(resolve,reject){values.forEach(function(value){Promise.resolve(value).then(resolve,reject)})})};Promise.prototype["catch"]=function(onRejected){return this.then(null,onRejected)}},function(module,exports,__webpack_require__){"use strict";var Promise=__webpack_require__(4);var asap=__webpack_require__(10);module.exports=Promise;Promise.denodeify=function(fn,argumentCount){argumentCount=argumentCount||Infinity;return function(){var self=this;var args=Array.prototype.slice.call(arguments,0,argumentCount>0?argumentCount:0);return new Promise(function(resolve,reject){args.push(function(err,res){if(err)reject(err);else resolve(res)});var res=fn.apply(self,args);if(res&&(typeof res==="object"||typeof res==="function")&&typeof res.then==="function"){resolve(res)}})}};Promise.nodeify=function(fn){return function(){var args=Array.prototype.slice.call(arguments);var callback=typeof args[args.length-1]==="function"?args.pop():null;var ctx=this;try{return fn.apply(this,arguments).nodeify(callback,ctx)}catch(ex){if(callback===null||typeof callback=="undefined"){return new Promise(function(resolve,reject){reject(ex)})}else{asap(function(){callback.call(ctx,ex)})}}}};Promise.prototype.nodeify=function(callback,ctx){if(typeof callback!="function")return this;this.then(function(value){asap(function(){callback.call(ctx,null,value)})},function(err){asap(function(){callback.call(ctx,err)})})}},function(module,exports,__webpack_require__){"use strict";var rawAsap=__webpack_require__(5);var freeTasks=[];var pendingErrors=[];var requestErrorThrow=rawAsap.makeRequestCallFromTimer(throwFirstError);function throwFirstError(){if(pendingErrors.length){throw pendingErrors.shift()}}module.exports=asap;function asap(task){var rawTask;if(freeTasks.length){rawTask=freeTasks.pop()}else{rawTask=new RawTask}rawTask.task=task;rawAsap(rawTask)}function RawTask(){this.task=null}RawTask.prototype.call=function(){try{this.task.call()}catch(error){if(asap.onerror){asap.onerror(error)}else{pendingErrors.push(error);requestErrorThrow()}}finally{this.task=null;freeTasks[freeTasks.length]=this}}}])}).call(this);if(typeof Package==="undefined")Package={};Package.promise={Promise:Promise}})();(function(){var Meteor=Package.meteor.Meteor;var _=Package.underscore._;var Tracker=Package.tracker.Tracker;var Deps=Package.tracker.Deps;var EJSON=Package.ejson.EJSON;var ECMAScript=Package.ecmascript.ECMAScript;var babelHelpers=Package["babel-runtime"].babelHelpers;var Symbol=Package["ecmascript-runtime"].Symbol;var Map=Package["ecmascript-runtime"].Map;var Set=Package["ecmascript-runtime"].Set;var Promise=Package.promise.Promise;var ReactiveDict;(function(){var stringify=function(value){if(value===undefined)return"undefined";return EJSON.stringify(value)};var parse=function(serialized){if(serialized===undefined||serialized==="undefined")return undefined;return EJSON.parse(serialized)};var changed=function(v){v&&v.changed()};ReactiveDict=function(dictName){if(dictName){if(typeof dictName==="string"){ReactiveDict._registerDictForMigrate(dictName,this);this.keys=ReactiveDict._loadMigratedDict(dictName)||{};this.name=dictName}else if(typeof dictName==="object"){this.keys=dictName}else{throw new Error("Invalid ReactiveDict argument: "+dictName)}}else{this.keys={}}this.allDeps=new Tracker.Dependency;this.keyDeps={};this.keyValueDeps={}};_.extend(ReactiveDict.prototype,{set:function(keyOrObject,value){var self=this;if(typeof keyOrObject==="object"&&value===undefined){self._setObject(keyOrObject);return}var key=keyOrObject;value=stringify(value);var keyExisted=_.has(self.keys,key);var oldSerializedValue=keyExisted?self.keys[key]:"undefined";var isNewValue=value!==oldSerializedValue;self.keys[key]=value;if(isNewValue||!keyExisted){self.allDeps.changed()}if(isNewValue){changed(self.keyDeps[key]);if(self.keyValueDeps[key]){changed(self.keyValueDeps[key][oldSerializedValue]);changed(self.keyValueDeps[key][value])}}},setDefault:function(key,value){var self=this;if(!_.has(self.keys,key)){self.set(key,value)}},get:function(key){var self=this;self._ensureKey(key);self.keyDeps[key].depend();return parse(self.keys[key])},equals:function(key,value){var self=this;var ObjectID=null;if(Package.mongo){ObjectID=Package.mongo.Mongo.ObjectID}if(typeof value!=="string"&&typeof value!=="number"&&typeof value!=="boolean"&&typeof value!=="undefined"&&!(value instanceof Date)&&!(ObjectID&&value instanceof ObjectID)&&value!==null){throw new Error("ReactiveDict.equals: value must be scalar")}var serializedValue=stringify(value);if(Tracker.active){self._ensureKey(key);if(!_.has(self.keyValueDeps[key],serializedValue))self.keyValueDeps[key][serializedValue]=new Tracker.Dependency;var isNew=self.keyValueDeps[key][serializedValue].depend();if(isNew){Tracker.onInvalidate(function(){if(!self.keyValueDeps[key][serializedValue].hasDependents())delete self.keyValueDeps[key][serializedValue]})}}var oldValue=undefined;if(_.has(self.keys,key))oldValue=parse(self.keys[key]);return EJSON.equals(oldValue,value)},all:function(){this.allDeps.depend();var ret={};_.each(this.keys,function(value,key){ret[key]=parse(value)});return ret},clear:function(){var self=this;var oldKeys=self.keys;self.keys={};self.allDeps.changed();_.each(oldKeys,function(value,key){changed(self.keyDeps[key]);changed(self.keyValueDeps[key][value]);changed(self.keyValueDeps[key]["undefined"])})},"delete":function(key){var self=this;var didRemove=false;if(_.has(self.keys,key)){var oldValue=self.keys[key];delete self.keys[key];changed(self.keyDeps[key]);if(self.keyValueDeps[key]){changed(self.keyValueDeps[key][oldValue]);changed(self.keyValueDeps[key]["undefined"])}self.allDeps.changed();didRemove=true}return didRemove},_setObject:function(object){var self=this;_.each(object,function(value,key){self.set(key,value)})},_ensureKey:function(key){var self=this;if(!(key in self.keyDeps)){self.keyDeps[key]=new Tracker.Dependency;self.keyValueDeps[key]={}}},_getMigrationData:function(){return this.keys}})}).call(this);(function(){ReactiveDict._migratedDictData={};ReactiveDict._dictsToMigrate={};ReactiveDict._loadMigratedDict=function(dictName){if(_.has(ReactiveDict._migratedDictData,dictName))return ReactiveDict._migratedDictData[dictName];return null};ReactiveDict._registerDictForMigrate=function(dictName,dict){if(_.has(ReactiveDict._dictsToMigrate,dictName))throw new Error("Duplicate ReactiveDict name: "+dictName);ReactiveDict._dictsToMigrate[dictName]=dict};if(Meteor.isClient&&Package.reload){var migrationData=Package.reload.Reload._migrationData("reactive-dict");if(migrationData&&migrationData.dicts)ReactiveDict._migratedDictData=migrationData.dicts;Package.reload.Reload._onMigrate("reactive-dict",function(){var dictsToMigrate=ReactiveDict._dictsToMigrate;var dataToMigrate={};for(var dictName in babelHelpers.sanitizeForInObject(dictsToMigrate))dataToMigrate[dictName]=dictsToMigrate[dictName]._getMigrationData();return[true,{dicts:dataToMigrate}]})}}).call(this);if(typeof Package==="undefined")Package={};Package["reactive-dict"]={ReactiveDict:ReactiveDict}})();(function(){var Meteor=Package.meteor.Meteor;var _=Package.underscore._;var ReactiveDict=Package["reactive-dict"].ReactiveDict;var EJSON=Package.ejson.EJSON;var Session;(function(){Session=new ReactiveDict("session")}).call(this);if(typeof Package==="undefined")Package={};Package.session={Session:Session}})();(function(){var Meteor=Package.meteor.Meteor;var Tracker=Package.tracker.Tracker;var Deps=Package.tracker.Deps;var ReactiveVar;(function(){ReactiveVar=function(initialValue,equalsFunc){if(!(this instanceof ReactiveVar))return new ReactiveVar(initialValue,equalsFunc);this.curValue=initialValue;this.equalsFunc=equalsFunc;this.dep=new Tracker.Dependency};ReactiveVar._isEqual=function(oldValue,newValue){var a=oldValue,b=newValue;if(a!==b)return false;else return!a||typeof a==="number"||typeof a==="boolean"||typeof a==="string"};ReactiveVar.prototype.get=function(){if(Tracker.active)this.dep.depend();return this.curValue};ReactiveVar.prototype.set=function(newValue){var oldValue=this.curValue;if((this.equalsFunc||ReactiveVar._isEqual)(oldValue,newValue))return;this.curValue=newValue;this.dep.changed()};ReactiveVar.prototype.toString=function(){return"ReactiveVar{"+this.get()+"}"};ReactiveVar.prototype._numListeners=function(){var count=0;for(var id in this.dep._dependentsById)count++;return count}}).call(this);if(typeof Package==="undefined")Package={};Package["reactive-var"]={ReactiveVar:ReactiveVar}})();(function(){var Meteor=Package.meteor.Meteor;var Mongo=Package.mongo.Mongo;var Tracker=Package.tracker.Tracker;var Deps=Package.tracker.Deps;var LocalCollection=Package.minimongo.LocalCollection;var Minimongo=Package.minimongo.Minimongo;var CollectionExtensions;(function(){(function(){CollectionExtensions={};CollectionExtensions._extensions=[];Meteor.addCollectionExtension=function(customFunction){if(typeof customFunction!=="function"){throw new Meteor.Error("collection-extension-wrong-argument","You must pass a function        into Meteor.addCollectionExtension().")}CollectionExtensions._extensions.push(customFunction);if(typeof Meteor.users!=="undefined"){customFunction.apply(Meteor.users,["users"])}};Meteor.addCollectionPrototype=function(name,customFunction){if(typeof name!=="string"){throw new Meteor.Error("collection-extension-wrong-argument","You must pass a string as the first argument        into Meteor.addCollectionPrototype().")}if(typeof customFunction!=="function"){throw new Meteor.Error("collection-extension-wrong-argument","You must pass a function as the second argument        into Meteor.addCollectionPrototype().")}(typeof Mongo!=="undefined"?Mongo.Collection:Meteor.Collection).prototype[name]=customFunction};CollectionExtensions._reassignCollectionPrototype=function(instance,constr){var hasSetPrototypeOf=typeof Object.setPrototypeOf==="function";if(!constr)constr=typeof Mongo!=="undefined"?Mongo.Collection:Meteor.Collection;if(hasSetPrototypeOf){Object.setPrototypeOf(instance,constr.prototype)}else if(instance.__proto__){instance.__proto__=constr.prototype}};CollectionExtensions._wrapCollection=function(ns,as){if(!as._CollectionPrototype)as._CollectionPrototype=new as.Collection(null);var constructor=as.Collection;var proto=as._CollectionPrototype;ns.Collection=function(){var ret=constructor.apply(this,arguments);CollectionExtensions._processCollectionExtensions(this,arguments);return ret};ns.Collection.prototype=proto;ns.Collection.prototype.constructor=ns.Collection;for(var prop in constructor){if(constructor.hasOwnProperty(prop)){ns.Collection[prop]=constructor[prop]}}};CollectionExtensions._processCollectionExtensions=function(self,args){var args=args?[].slice.call(args,0):undefined;var extensions=CollectionExtensions._extensions;for(var i=0,len=extensions.length;i<len;i++){extensions[i].apply(self,args)}};if(typeof Mongo!=="undefined"){CollectionExtensions._wrapCollection(Meteor,Mongo);CollectionExtensions._wrapCollection(Mongo,Mongo)}else{CollectionExtensions._wrapCollection(Meteor,Meteor)}if(typeof Meteor.users!=="undefined"){CollectionExtensions._reassignCollectionPrototype(Meteor.users)}}).call(this)}).call(this);if(typeof Package==="undefined")Package={};Package["lai:collection-extensions"]={}})();(function(){var Meteor=Package.meteor.Meteor;var Mongo=Package.mongo.Mongo;var _=Package.underscore._;(function(){(function(){var instances=[];Meteor.addCollectionExtension(function(name,options){instances.push({name:name,instance:this,options:options})});Mongo.Collection.get=function(name,options){options=options||{};var collection=_.find(instances,function(instance){if(options.connection)return instance.name===name&&instance.options&&instance.options.connection._lastSessionId===options.connection._lastSessionId;return instance.name===name});return collection&&collection.instance};Mongo.Collection.getAll=function(){return instances};Meteor.Collection=Mongo.Collection}).call(this)}).call(this);if(typeof Package==="undefined")Package={};Package["dburles:mongo-collection-instances"]={}})();(function(){var Meteor=Package.meteor.Meteor;(function(){!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.jsondiffpatch=e()}}(function(){var define,module,exports;return function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s}({1:[function(require,module,exports){var environment=require("./environment");if(environment.isBrowser){window.diff_match_patch=require("../public/external/diff_match_patch_uncompressed")}module.exports=require("./main")},{"../public/external/diff_match_patch_uncompressed":2,"./environment":9,"./main":16}],2:[function(require,module,exports){function diff_match_patch(){this.Diff_Timeout=1;this.Diff_EditCost=4;this.Match_Threshold=.5;this.Match_Distance=1e3;this.Patch_DeleteThreshold=.5;this.Patch_Margin=4;this.Match_MaxBits=32}var DIFF_DELETE=-1;var DIFF_INSERT=1;var DIFF_EQUAL=0;diff_match_patch.Diff;diff_match_patch.prototype.diff_main=function(text1,text2,opt_checklines,opt_deadline){if(typeof opt_deadline=="undefined"){if(this.Diff_Timeout<=0){opt_deadline=Number.MAX_VALUE}else{opt_deadline=(new Date).getTime()+this.Diff_Timeout*1e3}}var deadline=opt_deadline;if(text1==null||text2==null){throw new Error("Null input. (diff_main)")}if(text1==text2){if(text1){return[[DIFF_EQUAL,text1]]}return[]}if(typeof opt_checklines=="undefined"){opt_checklines=true}var checklines=opt_checklines;var commonlength=this.diff_commonPrefix(text1,text2);var commonprefix=text1.substring(0,commonlength);text1=text1.substring(commonlength);text2=text2.substring(commonlength);commonlength=this.diff_commonSuffix(text1,text2);var commonsuffix=text1.substring(text1.length-commonlength);text1=text1.substring(0,text1.length-commonlength);text2=text2.substring(0,text2.length-commonlength);var diffs=this.diff_compute_(text1,text2,checklines,deadline);if(commonprefix){diffs.unshift([DIFF_EQUAL,commonprefix])}if(commonsuffix){diffs.push([DIFF_EQUAL,commonsuffix])}this.diff_cleanupMerge(diffs);return diffs};diff_match_patch.prototype.diff_compute_=function(text1,text2,checklines,deadline){var diffs;if(!text1){return[[DIFF_INSERT,text2]]}if(!text2){return[[DIFF_DELETE,text1]]}var longtext=text1.length>text2.length?text1:text2;var shorttext=text1.length>text2.length?text2:text1;var i=longtext.indexOf(shorttext);if(i!=-1){diffs=[[DIFF_INSERT,longtext.substring(0,i)],[DIFF_EQUAL,shorttext],[DIFF_INSERT,longtext.substring(i+shorttext.length)]];if(text1.length>text2.length){diffs[0][0]=diffs[2][0]=DIFF_DELETE}return diffs}if(shorttext.length==1){return[[DIFF_DELETE,text1],[DIFF_INSERT,text2]]}longtext=shorttext=null;var hm=this.diff_halfMatch_(text1,text2);if(hm){var text1_a=hm[0];var text1_b=hm[1];var text2_a=hm[2];var text2_b=hm[3];var mid_common=hm[4];var diffs_a=this.diff_main(text1_a,text2_a,checklines,deadline);var diffs_b=this.diff_main(text1_b,text2_b,checklines,deadline);return diffs_a.concat([[DIFF_EQUAL,mid_common]],diffs_b)}if(checklines&&text1.length>100&&text2.length>100){return this.diff_lineMode_(text1,text2,deadline)}return this.diff_bisect_(text1,text2,deadline)};diff_match_patch.prototype.diff_lineMode_=function(text1,text2,deadline){var a=this.diff_linesToChars_(text1,text2);text1=a[0];text2=a[1];var linearray=a[2];var diffs=this.diff_bisect_(text1,text2,deadline);this.diff_charsToLines_(diffs,linearray);this.diff_cleanupSemantic(diffs);diffs.push([DIFF_EQUAL,""]);var pointer=0;var count_delete=0;var count_insert=0;var text_delete="";var text_insert="";while(pointer<diffs.length){switch(diffs[pointer][0]){case DIFF_INSERT:count_insert++;text_insert+=diffs[pointer][1];break;case DIFF_DELETE:count_delete++;text_delete+=diffs[pointer][1];break;case DIFF_EQUAL:if(count_delete>=1&&count_insert>=1){var a=this.diff_main(text_delete,text_insert,false,deadline);diffs.splice(pointer-count_delete-count_insert,count_delete+count_insert);pointer=pointer-count_delete-count_insert;for(var j=a.length-1;j>=0;j--){diffs.splice(pointer,0,a[j])}pointer=pointer+a.length}count_insert=0;count_delete=0;text_delete="";text_insert="";break}pointer++}diffs.pop();return diffs};diff_match_patch.prototype.diff_bisect_=function(text1,text2,deadline){var text1_length=text1.length;var text2_length=text2.length;var max_d=Math.ceil((text1_length+text2_length)/2);var v_offset=max_d;var v_length=2*max_d;var v1=new Array(v_length);var v2=new Array(v_length);for(var x=0;x<v_length;x++){v1[x]=-1;v2[x]=-1}v1[v_offset+1]=0;v2[v_offset+1]=0;var delta=text1_length-text2_length;var front=delta%2!=0;var k1start=0;var k1end=0;var k2start=0;var k2end=0;for(var d=0;d<max_d;d++){if((new Date).getTime()>deadline){break}for(var k1=-d+k1start;k1<=d-k1end;k1+=2){var k1_offset=v_offset+k1;var x1;if(k1==-d||k1!=d&&v1[k1_offset-1]<v1[k1_offset+1]){x1=v1[k1_offset+1]}else{x1=v1[k1_offset-1]+1}var y1=x1-k1;while(x1<text1_length&&y1<text2_length&&text1.charAt(x1)==text2.charAt(y1)){x1++;y1++}v1[k1_offset]=x1;if(x1>text1_length){k1end+=2}else if(y1>text2_length){k1start+=2}else if(front){var k2_offset=v_offset+delta-k1;if(k2_offset>=0&&k2_offset<v_length&&v2[k2_offset]!=-1){var x2=text1_length-v2[k2_offset];if(x1>=x2){return this.diff_bisectSplit_(text1,text2,x1,y1,deadline)}}}}for(var k2=-d+k2start;k2<=d-k2end;k2+=2){var k2_offset=v_offset+k2;var x2;if(k2==-d||k2!=d&&v2[k2_offset-1]<v2[k2_offset+1]){x2=v2[k2_offset+1]}else{x2=v2[k2_offset-1]+1}var y2=x2-k2;while(x2<text1_length&&y2<text2_length&&text1.charAt(text1_length-x2-1)==text2.charAt(text2_length-y2-1)){x2++;y2++}v2[k2_offset]=x2;if(x2>text1_length){k2end+=2}else if(y2>text2_length){k2start+=2}else if(!front){var k1_offset=v_offset+delta-k2;if(k1_offset>=0&&k1_offset<v_length&&v1[k1_offset]!=-1){var x1=v1[k1_offset];var y1=v_offset+x1-k1_offset;x2=text1_length-x2;if(x1>=x2){return this.diff_bisectSplit_(text1,text2,x1,y1,deadline)}}}}}return[[DIFF_DELETE,text1],[DIFF_INSERT,text2]]};diff_match_patch.prototype.diff_bisectSplit_=function(text1,text2,x,y,deadline){var text1a=text1.substring(0,x);
var text2a=text2.substring(0,y);var text1b=text1.substring(x);var text2b=text2.substring(y);var diffs=this.diff_main(text1a,text2a,false,deadline);var diffsb=this.diff_main(text1b,text2b,false,deadline);return diffs.concat(diffsb)};diff_match_patch.prototype.diff_linesToChars_=function(text1,text2){var lineArray=[];var lineHash={};lineArray[0]="";function diff_linesToCharsMunge_(text){var chars="";var lineStart=0;var lineEnd=-1;var lineArrayLength=lineArray.length;while(lineEnd<text.length-1){lineEnd=text.indexOf("\n",lineStart);if(lineEnd==-1){lineEnd=text.length-1}var line=text.substring(lineStart,lineEnd+1);lineStart=lineEnd+1;if(lineHash.hasOwnProperty?lineHash.hasOwnProperty(line):lineHash[line]!==undefined){chars+=String.fromCharCode(lineHash[line])}else{chars+=String.fromCharCode(lineArrayLength);lineHash[line]=lineArrayLength;lineArray[lineArrayLength++]=line}}return chars}var chars1=diff_linesToCharsMunge_(text1);var chars2=diff_linesToCharsMunge_(text2);return[chars1,chars2,lineArray]};diff_match_patch.prototype.diff_charsToLines_=function(diffs,lineArray){for(var x=0;x<diffs.length;x++){var chars=diffs[x][1];var text=[];for(var y=0;y<chars.length;y++){text[y]=lineArray[chars.charCodeAt(y)]}diffs[x][1]=text.join("")}};diff_match_patch.prototype.diff_commonPrefix=function(text1,text2){if(!text1||!text2||text1.charAt(0)!=text2.charAt(0)){return 0}var pointermin=0;var pointermax=Math.min(text1.length,text2.length);var pointermid=pointermax;var pointerstart=0;while(pointermin<pointermid){if(text1.substring(pointerstart,pointermid)==text2.substring(pointerstart,pointermid)){pointermin=pointermid;pointerstart=pointermin}else{pointermax=pointermid}pointermid=Math.floor((pointermax-pointermin)/2+pointermin)}return pointermid};diff_match_patch.prototype.diff_commonSuffix=function(text1,text2){if(!text1||!text2||text1.charAt(text1.length-1)!=text2.charAt(text2.length-1)){return 0}var pointermin=0;var pointermax=Math.min(text1.length,text2.length);var pointermid=pointermax;var pointerend=0;while(pointermin<pointermid){if(text1.substring(text1.length-pointermid,text1.length-pointerend)==text2.substring(text2.length-pointermid,text2.length-pointerend)){pointermin=pointermid;pointerend=pointermin}else{pointermax=pointermid}pointermid=Math.floor((pointermax-pointermin)/2+pointermin)}return pointermid};diff_match_patch.prototype.diff_commonOverlap_=function(text1,text2){var text1_length=text1.length;var text2_length=text2.length;if(text1_length==0||text2_length==0){return 0}if(text1_length>text2_length){text1=text1.substring(text1_length-text2_length)}else if(text1_length<text2_length){text2=text2.substring(0,text1_length)}var text_length=Math.min(text1_length,text2_length);if(text1==text2){return text_length}var best=0;var length=1;while(true){var pattern=text1.substring(text_length-length);var found=text2.indexOf(pattern);if(found==-1){return best}length+=found;if(found==0||text1.substring(text_length-length)==text2.substring(0,length)){best=length;length++}}};diff_match_patch.prototype.diff_halfMatch_=function(text1,text2){if(this.Diff_Timeout<=0){return null}var longtext=text1.length>text2.length?text1:text2;var shorttext=text1.length>text2.length?text2:text1;if(longtext.length<4||shorttext.length*2<longtext.length){return null}var dmp=this;function diff_halfMatchI_(longtext,shorttext,i){var seed=longtext.substring(i,i+Math.floor(longtext.length/4));var j=-1;var best_common="";var best_longtext_a,best_longtext_b,best_shorttext_a,best_shorttext_b;while((j=shorttext.indexOf(seed,j+1))!=-1){var prefixLength=dmp.diff_commonPrefix(longtext.substring(i),shorttext.substring(j));var suffixLength=dmp.diff_commonSuffix(longtext.substring(0,i),shorttext.substring(0,j));if(best_common.length<suffixLength+prefixLength){best_common=shorttext.substring(j-suffixLength,j)+shorttext.substring(j,j+prefixLength);best_longtext_a=longtext.substring(0,i-suffixLength);best_longtext_b=longtext.substring(i+prefixLength);best_shorttext_a=shorttext.substring(0,j-suffixLength);best_shorttext_b=shorttext.substring(j+prefixLength)}}if(best_common.length*2>=longtext.length){return[best_longtext_a,best_longtext_b,best_shorttext_a,best_shorttext_b,best_common]}else{return null}}var hm1=diff_halfMatchI_(longtext,shorttext,Math.ceil(longtext.length/4));var hm2=diff_halfMatchI_(longtext,shorttext,Math.ceil(longtext.length/2));var hm;if(!hm1&&!hm2){return null}else if(!hm2){hm=hm1}else if(!hm1){hm=hm2}else{hm=hm1[4].length>hm2[4].length?hm1:hm2}var text1_a,text1_b,text2_a,text2_b;if(text1.length>text2.length){text1_a=hm[0];text1_b=hm[1];text2_a=hm[2];text2_b=hm[3]}else{text2_a=hm[0];text2_b=hm[1];text1_a=hm[2];text1_b=hm[3]}var mid_common=hm[4];return[text1_a,text1_b,text2_a,text2_b,mid_common]};diff_match_patch.prototype.diff_cleanupSemantic=function(diffs){var changes=false;var equalities=[];var equalitiesLength=0;var lastequality=null;var pointer=0;var length_insertions1=0;var length_deletions1=0;var length_insertions2=0;var length_deletions2=0;while(pointer<diffs.length){if(diffs[pointer][0]==DIFF_EQUAL){equalities[equalitiesLength++]=pointer;length_insertions1=length_insertions2;length_deletions1=length_deletions2;length_insertions2=0;length_deletions2=0;lastequality=diffs[pointer][1]}else{if(diffs[pointer][0]==DIFF_INSERT){length_insertions2+=diffs[pointer][1].length}else{length_deletions2+=diffs[pointer][1].length}if(lastequality!==null&&lastequality.length<=Math.max(length_insertions1,length_deletions1)&&lastequality.length<=Math.max(length_insertions2,length_deletions2)){diffs.splice(equalities[equalitiesLength-1],0,[DIFF_DELETE,lastequality]);diffs[equalities[equalitiesLength-1]+1][0]=DIFF_INSERT;equalitiesLength--;equalitiesLength--;pointer=equalitiesLength>0?equalities[equalitiesLength-1]:-1;length_insertions1=0;length_deletions1=0;length_insertions2=0;length_deletions2=0;lastequality=null;changes=true}}pointer++}if(changes){this.diff_cleanupMerge(diffs)}this.diff_cleanupSemanticLossless(diffs);pointer=1;while(pointer<diffs.length){if(diffs[pointer-1][0]==DIFF_DELETE&&diffs[pointer][0]==DIFF_INSERT){var deletion=diffs[pointer-1][1];var insertion=diffs[pointer][1];var overlap_length=this.diff_commonOverlap_(deletion,insertion);if(overlap_length>=deletion.length/2||overlap_length>=insertion.length/2){diffs.splice(pointer,0,[DIFF_EQUAL,insertion.substring(0,overlap_length)]);diffs[pointer-1][1]=deletion.substring(0,deletion.length-overlap_length);diffs[pointer+1][1]=insertion.substring(overlap_length);pointer++}pointer++}pointer++}};diff_match_patch.prototype.diff_cleanupSemanticLossless=function(diffs){var punctuation=/[^a-zA-Z0-9]/;var whitespace=/\s/;var linebreak=/[\r\n]/;var blanklineEnd=/\n\r?\n$/;var blanklineStart=/^\r?\n\r?\n/;function diff_cleanupSemanticScore_(one,two){if(!one||!two){return 5}var score=0;if(one.charAt(one.length-1).match(punctuation)||two.charAt(0).match(punctuation)){score++;if(one.charAt(one.length-1).match(whitespace)||two.charAt(0).match(whitespace)){score++;if(one.charAt(one.length-1).match(linebreak)||two.charAt(0).match(linebreak)){score++;if(one.match(blanklineEnd)||two.match(blanklineStart)){score++}}}}return score}var pointer=1;while(pointer<diffs.length-1){if(diffs[pointer-1][0]==DIFF_EQUAL&&diffs[pointer+1][0]==DIFF_EQUAL){var equality1=diffs[pointer-1][1];var edit=diffs[pointer][1];var equality2=diffs[pointer+1][1];var commonOffset=this.diff_commonSuffix(equality1,edit);if(commonOffset){var commonString=edit.substring(edit.length-commonOffset);equality1=equality1.substring(0,equality1.length-commonOffset);edit=commonString+edit.substring(0,edit.length-commonOffset);equality2=commonString+equality2}var bestEquality1=equality1;var bestEdit=edit;var bestEquality2=equality2;var bestScore=diff_cleanupSemanticScore_(equality1,edit)+diff_cleanupSemanticScore_(edit,equality2);while(edit.charAt(0)===equality2.charAt(0)){equality1+=edit.charAt(0);edit=edit.substring(1)+equality2.charAt(0);equality2=equality2.substring(1);var score=diff_cleanupSemanticScore_(equality1,edit)+diff_cleanupSemanticScore_(edit,equality2);if(score>=bestScore){bestScore=score;bestEquality1=equality1;bestEdit=edit;bestEquality2=equality2}}if(diffs[pointer-1][1]!=bestEquality1){if(bestEquality1){diffs[pointer-1][1]=bestEquality1}else{diffs.splice(pointer-1,1);pointer--}diffs[pointer][1]=bestEdit;if(bestEquality2){diffs[pointer+1][1]=bestEquality2}else{diffs.splice(pointer+1,1);pointer--}}}pointer++}};diff_match_patch.prototype.diff_cleanupEfficiency=function(diffs){var changes=false;var equalities=[];var equalitiesLength=0;var lastequality="";var pointer=0;var pre_ins=false;var pre_del=false;var post_ins=false;var post_del=false;while(pointer<diffs.length){if(diffs[pointer][0]==DIFF_EQUAL){if(diffs[pointer][1].length<this.Diff_EditCost&&(post_ins||post_del)){equalities[equalitiesLength++]=pointer;pre_ins=post_ins;pre_del=post_del;lastequality=diffs[pointer][1]}else{equalitiesLength=0;lastequality=""}post_ins=post_del=false}else{if(diffs[pointer][0]==DIFF_DELETE){post_del=true}else{post_ins=true}if(lastequality&&(pre_ins&&pre_del&&post_ins&&post_del||lastequality.length<this.Diff_EditCost/2&&pre_ins+pre_del+post_ins+post_del==3)){diffs.splice(equalities[equalitiesLength-1],0,[DIFF_DELETE,lastequality]);diffs[equalities[equalitiesLength-1]+1][0]=DIFF_INSERT;equalitiesLength--;lastequality="";if(pre_ins&&pre_del){post_ins=post_del=true;equalitiesLength=0}else{equalitiesLength--;pointer=equalitiesLength>0?equalities[equalitiesLength-1]:-1;post_ins=post_del=false}changes=true}}pointer++}if(changes){this.diff_cleanupMerge(diffs)}};diff_match_patch.prototype.diff_cleanupMerge=function(diffs){diffs.push([DIFF_EQUAL,""]);var pointer=0;var count_delete=0;var count_insert=0;var text_delete="";var text_insert="";var commonlength;while(pointer<diffs.length){switch(diffs[pointer][0]){case DIFF_INSERT:count_insert++;text_insert+=diffs[pointer][1];pointer++;break;case DIFF_DELETE:count_delete++;text_delete+=diffs[pointer][1];pointer++;break;case DIFF_EQUAL:if(count_delete+count_insert>1){if(count_delete!==0&&count_insert!==0){commonlength=this.diff_commonPrefix(text_insert,text_delete);if(commonlength!==0){if(pointer-count_delete-count_insert>0&&diffs[pointer-count_delete-count_insert-1][0]==DIFF_EQUAL){diffs[pointer-count_delete-count_insert-1][1]+=text_insert.substring(0,commonlength)}else{diffs.splice(0,0,[DIFF_EQUAL,text_insert.substring(0,commonlength)]);pointer++}text_insert=text_insert.substring(commonlength);text_delete=text_delete.substring(commonlength)}commonlength=this.diff_commonSuffix(text_insert,text_delete);if(commonlength!==0){diffs[pointer][1]=text_insert.substring(text_insert.length-commonlength)+diffs[pointer][1];text_insert=text_insert.substring(0,text_insert.length-commonlength);text_delete=text_delete.substring(0,text_delete.length-commonlength)}}if(count_delete===0){diffs.splice(pointer-count_delete-count_insert,count_delete+count_insert,[DIFF_INSERT,text_insert])}else if(count_insert===0){diffs.splice(pointer-count_delete-count_insert,count_delete+count_insert,[DIFF_DELETE,text_delete])}else{diffs.splice(pointer-count_delete-count_insert,count_delete+count_insert,[DIFF_DELETE,text_delete],[DIFF_INSERT,text_insert])}pointer=pointer-count_delete-count_insert+(count_delete?1:0)+(count_insert?1:0)+1}else if(pointer!==0&&diffs[pointer-1][0]==DIFF_EQUAL){diffs[pointer-1][1]+=diffs[pointer][1];diffs.splice(pointer,1)}else{pointer++}count_insert=0;count_delete=0;text_delete="";text_insert="";break}}if(diffs[diffs.length-1][1]===""){diffs.pop()}var changes=false;pointer=1;while(pointer<diffs.length-1){if(diffs[pointer-1][0]==DIFF_EQUAL&&diffs[pointer+1][0]==DIFF_EQUAL){if(diffs[pointer][1].substring(diffs[pointer][1].length-diffs[pointer-1][1].length)==diffs[pointer-1][1]){diffs[pointer][1]=diffs[pointer-1][1]+diffs[pointer][1].substring(0,diffs[pointer][1].length-diffs[pointer-1][1].length);diffs[pointer+1][1]=diffs[pointer-1][1]+diffs[pointer+1][1];diffs.splice(pointer-1,1);changes=true}else if(diffs[pointer][1].substring(0,diffs[pointer+1][1].length)==diffs[pointer+1][1]){diffs[pointer-1][1]+=diffs[pointer+1][1];diffs[pointer][1]=diffs[pointer][1].substring(diffs[pointer+1][1].length)+diffs[pointer+1][1];diffs.splice(pointer+1,1);changes=true}}pointer++}if(changes){this.diff_cleanupMerge(diffs)}};diff_match_patch.prototype.diff_xIndex=function(diffs,loc){var chars1=0;var chars2=0;var last_chars1=0;var last_chars2=0;var x;for(x=0;x<diffs.length;x++){if(diffs[x][0]!==DIFF_INSERT){chars1+=diffs[x][1].length}if(diffs[x][0]!==DIFF_DELETE){chars2+=diffs[x][1].length}if(chars1>loc){break}last_chars1=chars1;last_chars2=chars2}if(diffs.length!=x&&diffs[x][0]===DIFF_DELETE){return last_chars2}return last_chars2+(loc-last_chars1)};diff_match_patch.prototype.diff_prettyHtml=function(diffs){var html=[];var i=0;var pattern_amp=/&/g;var pattern_lt=/</g;var pattern_gt=/>/g;var pattern_para=/\n/g;for(var x=0;x<diffs.length;x++){var op=diffs[x][0];var data=diffs[x][1];var text=data.replace(pattern_amp,"&amp;").replace(pattern_lt,"&lt;").replace(pattern_gt,"&gt;").replace(pattern_para,"&para;<br>");switch(op){case DIFF_INSERT:html[x]='<ins style="background:#e6ffe6;">'+text+"</ins>";break;case DIFF_DELETE:html[x]='<del style="background:#ffe6e6;">'+text+"</del>";break;case DIFF_EQUAL:html[x]="<span>"+text+"</span>";break}if(op!==DIFF_DELETE){i+=data.length}}return html.join("")};diff_match_patch.prototype.diff_text1=function(diffs){var text=[];for(var x=0;x<diffs.length;x++){if(diffs[x][0]!==DIFF_INSERT){text[x]=diffs[x][1]}}return text.join("")};diff_match_patch.prototype.diff_text2=function(diffs){var text=[];for(var x=0;x<diffs.length;x++){if(diffs[x][0]!==DIFF_DELETE){text[x]=diffs[x][1]}}return text.join("")};diff_match_patch.prototype.diff_levenshtein=function(diffs){var levenshtein=0;var insertions=0;var deletions=0;for(var x=0;x<diffs.length;x++){var op=diffs[x][0];var data=diffs[x][1];switch(op){case DIFF_INSERT:insertions+=data.length;break;case DIFF_DELETE:deletions+=data.length;break;case DIFF_EQUAL:levenshtein+=Math.max(insertions,deletions);insertions=0;deletions=0;break}}levenshtein+=Math.max(insertions,deletions);return levenshtein};diff_match_patch.prototype.diff_toDelta=function(diffs){var text=[];for(var x=0;x<diffs.length;x++){switch(diffs[x][0]){case DIFF_INSERT:text[x]="+"+encodeURI(diffs[x][1]);break;case DIFF_DELETE:text[x]="-"+diffs[x][1].length;break;case DIFF_EQUAL:text[x]="="+diffs[x][1].length;break}}return text.join("	").replace(/%20/g," ")};diff_match_patch.prototype.diff_fromDelta=function(text1,delta){var diffs=[];var diffsLength=0;var pointer=0;var tokens=delta.split(/\t/g);for(var x=0;x<tokens.length;x++){var param=tokens[x].substring(1);switch(tokens[x].charAt(0)){case"+":try{diffs[diffsLength++]=[DIFF_INSERT,decodeURI(param)]}catch(ex){throw new Error("Illegal escape in diff_fromDelta: "+param)}break;case"-":case"=":var n=parseInt(param,10);if(isNaN(n)||n<0){throw new Error("Invalid number in diff_fromDelta: "+param)}var text=text1.substring(pointer,pointer+=n);if(tokens[x].charAt(0)=="="){diffs[diffsLength++]=[DIFF_EQUAL,text]}else{diffs[diffsLength++]=[DIFF_DELETE,text]}break;default:if(tokens[x]){throw new Error("Invalid diff operation in diff_fromDelta: "+tokens[x])}}}if(pointer!=text1.length){throw new Error("Delta length ("+pointer+") does not equal source text length ("+text1.length+").")}return diffs};diff_match_patch.prototype.match_main=function(text,pattern,loc){if(text==null||pattern==null||loc==null){throw new Error("Null input. (match_main)")}loc=Math.max(0,Math.min(loc,text.length));if(text==pattern){return 0}else if(!text.length){return-1}else if(text.substring(loc,loc+pattern.length)==pattern){return loc}else{return this.match_bitap_(text,pattern,loc)}};diff_match_patch.prototype.match_bitap_=function(text,pattern,loc){if(pattern.length>this.Match_MaxBits){throw new Error("Pattern too long for this browser.")}var s=this.match_alphabet_(pattern);var dmp=this;function match_bitapScore_(e,x){var accuracy=e/pattern.length;var proximity=Math.abs(loc-x);if(!dmp.Match_Distance){return proximity?1:accuracy}return accuracy+proximity/dmp.Match_Distance}var score_threshold=this.Match_Threshold;var best_loc=text.indexOf(pattern,loc);if(best_loc!=-1){score_threshold=Math.min(match_bitapScore_(0,best_loc),score_threshold);best_loc=text.lastIndexOf(pattern,loc+pattern.length);if(best_loc!=-1){score_threshold=Math.min(match_bitapScore_(0,best_loc),score_threshold)}}var matchmask=1<<pattern.length-1;best_loc=-1;var bin_min,bin_mid;var bin_max=pattern.length+text.length;var last_rd;for(var d=0;d<pattern.length;d++){bin_min=0;bin_mid=bin_max;while(bin_min<bin_mid){if(match_bitapScore_(d,loc+bin_mid)<=score_threshold){bin_min=bin_mid}else{bin_max=bin_mid}bin_mid=Math.floor((bin_max-bin_min)/2+bin_min)}bin_max=bin_mid;var start=Math.max(1,loc-bin_mid+1);var finish=Math.min(loc+bin_mid,text.length)+pattern.length;var rd=Array(finish+2);rd[finish+1]=(1<<d)-1;for(var j=finish;j>=start;j--){var charMatch=s[text.charAt(j-1)];if(d===0){rd[j]=(rd[j+1]<<1|1)&charMatch}else{rd[j]=(rd[j+1]<<1|1)&charMatch|((last_rd[j+1]|last_rd[j])<<1|1)|last_rd[j+1]}if(rd[j]&matchmask){var score=match_bitapScore_(d,j-1);if(score<=score_threshold){score_threshold=score;best_loc=j-1;if(best_loc>loc){start=Math.max(1,2*loc-best_loc)}else{break}}}}if(match_bitapScore_(d+1,loc)>score_threshold){break}last_rd=rd}return best_loc};diff_match_patch.prototype.match_alphabet_=function(pattern){var s={};for(var i=0;i<pattern.length;i++){s[pattern.charAt(i)]=0}for(var i=0;i<pattern.length;i++){s[pattern.charAt(i)]|=1<<pattern.length-i-1}return s};diff_match_patch.prototype.patch_addContext_=function(patch,text){if(text.length==0){return}var pattern=text.substring(patch.start2,patch.start2+patch.length1);var padding=0;while(text.indexOf(pattern)!=text.lastIndexOf(pattern)&&pattern.length<this.Match_MaxBits-this.Patch_Margin-this.Patch_Margin){padding+=this.Patch_Margin;pattern=text.substring(patch.start2-padding,patch.start2+patch.length1+padding)}padding+=this.Patch_Margin;var prefix=text.substring(patch.start2-padding,patch.start2);if(prefix){patch.diffs.unshift([DIFF_EQUAL,prefix])}var suffix=text.substring(patch.start2+patch.length1,patch.start2+patch.length1+padding);if(suffix){patch.diffs.push([DIFF_EQUAL,suffix])}patch.start1-=prefix.length;patch.start2-=prefix.length;patch.length1+=prefix.length+suffix.length;patch.length2+=prefix.length+suffix.length};diff_match_patch.prototype.patch_make=function(a,opt_b,opt_c){var text1,diffs;if(typeof a=="string"&&typeof opt_b=="string"&&typeof opt_c=="undefined"){text1=a;diffs=this.diff_main(text1,opt_b,true);if(diffs.length>2){this.diff_cleanupSemantic(diffs);this.diff_cleanupEfficiency(diffs)}}else if(a&&typeof a=="object"&&typeof opt_b=="undefined"&&typeof opt_c=="undefined"){diffs=a;text1=this.diff_text1(diffs)}else if(typeof a=="string"&&opt_b&&typeof opt_b=="object"&&typeof opt_c=="undefined"){text1=a;diffs=opt_b}else if(typeof a=="string"&&typeof opt_b=="string"&&opt_c&&typeof opt_c=="object"){text1=a;diffs=opt_c}else{throw new Error("Unknown call format to patch_make.")}if(diffs.length===0){return[]}var patches=[];var patch=new diff_match_patch.patch_obj;var patchDiffLength=0;var char_count1=0;var char_count2=0;var prepatch_text=text1;var postpatch_text=text1;for(var x=0;x<diffs.length;x++){var diff_type=diffs[x][0];var diff_text=diffs[x][1];if(!patchDiffLength&&diff_type!==DIFF_EQUAL){patch.start1=char_count1;patch.start2=char_count2}switch(diff_type){case DIFF_INSERT:patch.diffs[patchDiffLength++]=diffs[x];patch.length2+=diff_text.length;postpatch_text=postpatch_text.substring(0,char_count2)+diff_text+postpatch_text.substring(char_count2);break;case DIFF_DELETE:patch.length1+=diff_text.length;patch.diffs[patchDiffLength++]=diffs[x];postpatch_text=postpatch_text.substring(0,char_count2)+postpatch_text.substring(char_count2+diff_text.length);break;case DIFF_EQUAL:if(diff_text.length<=2*this.Patch_Margin&&patchDiffLength&&diffs.length!=x+1){patch.diffs[patchDiffLength++]=diffs[x];patch.length1+=diff_text.length;patch.length2+=diff_text.length}else if(diff_text.length>=2*this.Patch_Margin){if(patchDiffLength){this.patch_addContext_(patch,prepatch_text);patches.push(patch);patch=new diff_match_patch.patch_obj;patchDiffLength=0;prepatch_text=postpatch_text;char_count1=char_count2}}break}if(diff_type!==DIFF_INSERT){char_count1+=diff_text.length}if(diff_type!==DIFF_DELETE){char_count2+=diff_text.length}}if(patchDiffLength){this.patch_addContext_(patch,prepatch_text);patches.push(patch)}return patches};diff_match_patch.prototype.patch_deepCopy=function(patches){var patchesCopy=[];for(var x=0;x<patches.length;x++){var patch=patches[x];var patchCopy=new diff_match_patch.patch_obj;patchCopy.diffs=[];for(var y=0;y<patch.diffs.length;y++){patchCopy.diffs[y]=patch.diffs[y].slice()}patchCopy.start1=patch.start1;patchCopy.start2=patch.start2;patchCopy.length1=patch.length1;patchCopy.length2=patch.length2;patchesCopy[x]=patchCopy}return patchesCopy};diff_match_patch.prototype.patch_apply=function(patches,text){if(patches.length==0){return[text,[]]}patches=this.patch_deepCopy(patches);var nullPadding=this.patch_addPadding(patches);text=nullPadding+text+nullPadding;this.patch_splitMax(patches);var delta=0;var results=[];for(var x=0;x<patches.length;x++){var expected_loc=patches[x].start2+delta;var text1=this.diff_text1(patches[x].diffs);var start_loc;var end_loc=-1;if(text1.length>this.Match_MaxBits){start_loc=this.match_main(text,text1.substring(0,this.Match_MaxBits),expected_loc);if(start_loc!=-1){end_loc=this.match_main(text,text1.substring(text1.length-this.Match_MaxBits),expected_loc+text1.length-this.Match_MaxBits);if(end_loc==-1||start_loc>=end_loc){start_loc=-1}}}else{start_loc=this.match_main(text,text1,expected_loc)}if(start_loc==-1){results[x]=false;delta-=patches[x].length2-patches[x].length1}else{results[x]=true;delta=start_loc-expected_loc;var text2;if(end_loc==-1){text2=text.substring(start_loc,start_loc+text1.length)}else{text2=text.substring(start_loc,end_loc+this.Match_MaxBits)}if(text1==text2){text=text.substring(0,start_loc)+this.diff_text2(patches[x].diffs)+text.substring(start_loc+text1.length)}else{var diffs=this.diff_main(text1,text2,false);if(text1.length>this.Match_MaxBits&&this.diff_levenshtein(diffs)/text1.length>this.Patch_DeleteThreshold){results[x]=false}else{this.diff_cleanupSemanticLossless(diffs);var index1=0;var index2;for(var y=0;y<patches[x].diffs.length;y++){var mod=patches[x].diffs[y];if(mod[0]!==DIFF_EQUAL){index2=this.diff_xIndex(diffs,index1)}if(mod[0]===DIFF_INSERT){text=text.substring(0,start_loc+index2)+mod[1]+text.substring(start_loc+index2)}else if(mod[0]===DIFF_DELETE){text=text.substring(0,start_loc+index2)+text.substring(start_loc+this.diff_xIndex(diffs,index1+mod[1].length))}if(mod[0]!==DIFF_DELETE){index1+=mod[1].length}}}}}}text=text.substring(nullPadding.length,text.length-nullPadding.length);return[text,results]};diff_match_patch.prototype.patch_addPadding=function(patches){var paddingLength=this.Patch_Margin;var nullPadding="";for(var x=1;x<=paddingLength;x++){nullPadding+=String.fromCharCode(x)}for(var x=0;x<patches.length;x++){patches[x].start1+=paddingLength;patches[x].start2+=paddingLength}var patch=patches[0];var diffs=patch.diffs;if(diffs.length==0||diffs[0][0]!=DIFF_EQUAL){diffs.unshift([DIFF_EQUAL,nullPadding]);patch.start1-=paddingLength;patch.start2-=paddingLength;patch.length1+=paddingLength;patch.length2+=paddingLength}else if(paddingLength>diffs[0][1].length){var extraLength=paddingLength-diffs[0][1].length;diffs[0][1]=nullPadding.substring(diffs[0][1].length)+diffs[0][1];patch.start1-=extraLength;patch.start2-=extraLength;patch.length1+=extraLength;patch.length2+=extraLength}patch=patches[patches.length-1];diffs=patch.diffs;if(diffs.length==0||diffs[diffs.length-1][0]!=DIFF_EQUAL){diffs.push([DIFF_EQUAL,nullPadding]);patch.length1+=paddingLength;patch.length2+=paddingLength}else if(paddingLength>diffs[diffs.length-1][1].length){var extraLength=paddingLength-diffs[diffs.length-1][1].length;diffs[diffs.length-1][1]+=nullPadding.substring(0,extraLength);patch.length1+=extraLength;patch.length2+=extraLength}return nullPadding};diff_match_patch.prototype.patch_splitMax=function(patches){var patch_size=this.Match_MaxBits;for(var x=0;x<patches.length;x++){if(patches[x].length1>patch_size){var bigpatch=patches[x];patches.splice(x--,1);var start1=bigpatch.start1;var start2=bigpatch.start2;var precontext="";while(bigpatch.diffs.length!==0){var patch=new diff_match_patch.patch_obj;var empty=true;patch.start1=start1-precontext.length;patch.start2=start2-precontext.length;if(precontext!==""){patch.length1=patch.length2=precontext.length;patch.diffs.push([DIFF_EQUAL,precontext])}while(bigpatch.diffs.length!==0&&patch.length1<patch_size-this.Patch_Margin){var diff_type=bigpatch.diffs[0][0];var diff_text=bigpatch.diffs[0][1];if(diff_type===DIFF_INSERT){patch.length2+=diff_text.length;start2+=diff_text.length;patch.diffs.push(bigpatch.diffs.shift());empty=false}else if(diff_type===DIFF_DELETE&&patch.diffs.length==1&&patch.diffs[0][0]==DIFF_EQUAL&&diff_text.length>2*patch_size){patch.length1+=diff_text.length;start1+=diff_text.length;empty=false;patch.diffs.push([diff_type,diff_text]);bigpatch.diffs.shift()}else{diff_text=diff_text.substring(0,patch_size-patch.length1-this.Patch_Margin);patch.length1+=diff_text.length;start1+=diff_text.length;if(diff_type===DIFF_EQUAL){patch.length2+=diff_text.length;start2+=diff_text.length}else{empty=false}patch.diffs.push([diff_type,diff_text]);if(diff_text==bigpatch.diffs[0][1]){bigpatch.diffs.shift()}else{bigpatch.diffs[0][1]=bigpatch.diffs[0][1].substring(diff_text.length)}}}precontext=this.diff_text2(patch.diffs);precontext=precontext.substring(precontext.length-this.Patch_Margin);var postcontext=this.diff_text1(bigpatch.diffs).substring(0,this.Patch_Margin);if(postcontext!==""){patch.length1+=postcontext.length;patch.length2+=postcontext.length;if(patch.diffs.length!==0&&patch.diffs[patch.diffs.length-1][0]===DIFF_EQUAL){patch.diffs[patch.diffs.length-1][1]+=postcontext}else{patch.diffs.push([DIFF_EQUAL,postcontext])}}if(!empty){patches.splice(++x,0,patch)}}}}};diff_match_patch.prototype.patch_toText=function(patches){var text=[];for(var x=0;x<patches.length;x++){text[x]=patches[x]}return text.join("")};diff_match_patch.prototype.patch_fromText=function(textline){var patches=[];if(!textline){return patches}var text=textline.split("\n");var textPointer=0;var patchHeader=/^@@ -(\d+),?(\d*) \+(\d+),?(\d*) @@$/;while(textPointer<text.length){var m=text[textPointer].match(patchHeader);if(!m){throw new Error("Invalid patch string: "+text[textPointer])}var patch=new diff_match_patch.patch_obj;patches.push(patch);patch.start1=parseInt(m[1],10);if(m[2]===""){patch.start1--;patch.length1=1}else if(m[2]=="0"){patch.length1=0}else{patch.start1--;patch.length1=parseInt(m[2],10)}patch.start2=parseInt(m[3],10);if(m[4]===""){patch.start2--;patch.length2=1}else if(m[4]=="0"){patch.length2=0}else{patch.start2--;patch.length2=parseInt(m[4],10)}textPointer++;while(textPointer<text.length){var sign=text[textPointer].charAt(0);try{var line=decodeURI(text[textPointer].substring(1))}catch(ex){throw new Error("Illegal escape in patch_fromText: "+line)}if(sign=="-"){patch.diffs.push([DIFF_DELETE,line])}else if(sign=="+"){patch.diffs.push([DIFF_INSERT,line])}else if(sign==" "){patch.diffs.push([DIFF_EQUAL,line])}else if(sign=="@"){break}else if(sign===""){}else{throw new Error('Invalid patch mode "'+sign+'" in: '+line)}textPointer++}}return patches};diff_match_patch.patch_obj=function(){this.diffs=[];this.start1=null;this.start2=null;this.length1=0;this.length2=0};diff_match_patch.patch_obj.prototype.toString=function(){var coords1,coords2;if(this.length1===0){coords1=this.start1+",0"}else if(this.length1==1){coords1=this.start1+1}else{coords1=this.start1+1+","+this.length1}if(this.length2===0){coords2=this.start2+",0"}else if(this.length2==1){coords2=this.start2+1}else{coords2=this.start2+1+","+this.length2}var text=["@@ -"+coords1+" +"+coords2+" @@\n"];var op;for(var x=0;x<this.diffs.length;x++){switch(this.diffs[x][0]){case DIFF_INSERT:op="+";break;case DIFF_DELETE:op="-";break;case DIFF_EQUAL:op=" ";break}text[x+1]=op+encodeURI(this.diffs[x][1])+"\n"}return text.join("").replace(/%20/g," ")};this["diff_match_patch"]=diff_match_patch;this["DIFF_DELETE"]=DIFF_DELETE;this["DIFF_INSERT"]=DIFF_INSERT;this["DIFF_EQUAL"]=DIFF_EQUAL},{}],3:[function(require,module,exports){var Pipe=require("../pipe").Pipe;var Context=function Context(){};Context.prototype.setResult=function(result){this.result=result;this.hasResult=true;return this};Context.prototype.exit=function(){this.exiting=true;return this};Context.prototype.switchTo=function(next,pipe){if(typeof next==="string"||next instanceof Pipe){this.nextPipe=next}else{this.next=next;if(pipe){this.nextPipe=pipe}}return this};Context.prototype.push=function(child,name){child.parent=this;if(typeof name!=="undefined"){child.childName=name}child.root=this.root||this;child.options=child.options||this.options;if(!this.children){this.children=[child];this.nextAfterChildren=this.next||null;this.next=child}else{this.children[this.children.length-1].next=child;this.children.push(child)}child.next=this;return this};exports.Context=Context},{"../pipe":17}],4:[function(require,module,exports){var Context=require("./context").Context;var DiffContext=function DiffContext(left,right){this.left=left;this.right=right;this.pipe="diff"};DiffContext.prototype=new Context;exports.DiffContext=DiffContext},{"./context":3}],5:[function(require,module,exports){var Context=require("./context").Context;var PatchContext=function PatchContext(left,delta){this.left=left;this.delta=delta;this.pipe="patch"};PatchContext.prototype=new Context;exports.PatchContext=PatchContext},{"./context":3}],6:[function(require,module,exports){var Context=require("./context").Context;var ReverseContext=function ReverseContext(delta){this.delta=delta;this.pipe="reverse"};ReverseContext.prototype=new Context;exports.ReverseContext=ReverseContext},{"./context":3}],7:[function(require,module,exports){module.exports=function dateReviver(key,value){var parts;if(typeof value==="string"){parts=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})(?:\.(\d*))?(Z|([+\-])(\d{2}):(\d{2}))$/.exec(value);if(parts){return new Date(Date.UTC(+parts[1],+parts[2]-1,+parts[3],+parts[4],+parts[5],+parts[6],+(parts[7]||0)))}}return value}},{}],8:[function(require,module,exports){var Processor=require("./processor").Processor;var Pipe=require("./pipe").Pipe;var DiffContext=require("./contexts/diff").DiffContext;var PatchContext=require("./contexts/patch").PatchContext;var ReverseContext=require("./contexts/reverse").ReverseContext;var trivial=require("./filters/trivial");var nested=require("./filters/nested");var arrays=require("./filters/arrays");var dates=require("./filters/dates");var texts=require("./filters/texts");var DiffPatcher=function DiffPatcher(options){this.processor=new Processor(options);this.processor.pipe(new Pipe("diff").append(nested.collectChildrenDiffFilter,trivial.diffFilter,dates.diffFilter,texts.diffFilter,nested.objectsDiffFilter,arrays.diffFilter).shouldHaveResult());this.processor.pipe(new Pipe("patch").append(nested.collectChildrenPatchFilter,arrays.collectChildrenPatchFilter,trivial.patchFilter,texts.patchFilter,nested.patchFilter,arrays.patchFilter).shouldHaveResult());this.processor.pipe(new Pipe("reverse").append(nested.collectChildrenReverseFilter,arrays.collectChildrenReverseFilter,trivial.reverseFilter,texts.reverseFilter,nested.reverseFilter,arrays.reverseFilter).shouldHaveResult())};DiffPatcher.prototype.options=function(){return this.processor.options.apply(this.processor,arguments)};DiffPatcher.prototype.diff=function(left,right){return this.processor.process(new DiffContext(left,right))};DiffPatcher.prototype.patch=function(left,delta){
return this.processor.process(new PatchContext(left,delta))};DiffPatcher.prototype.reverse=function(delta){return this.processor.process(new ReverseContext(delta))};DiffPatcher.prototype.unpatch=function(right,delta){return this.patch(right,this.reverse(delta))};exports.DiffPatcher=DiffPatcher},{"./contexts/diff":4,"./contexts/patch":5,"./contexts/reverse":6,"./filters/arrays":10,"./filters/dates":11,"./filters/nested":13,"./filters/texts":14,"./filters/trivial":15,"./pipe":17,"./processor":18}],9:[function(require,module,exports){exports.isBrowser=typeof window!=="undefined"},{}],10:[function(require,module,exports){var DiffContext=require("../contexts/diff").DiffContext;var PatchContext=require("../contexts/patch").PatchContext;var ReverseContext=require("../contexts/reverse").ReverseContext;var lcs=require("./lcs");var ARRAY_MOVE=3;var isArray=typeof Array.isArray==="function"?Array.isArray:function(a){return a instanceof Array};var arrayIndexOf=typeof Array.prototype.indexOf==="function"?function(array,item){return array.indexOf(item)}:function(array,item){var length=array.length;for(var i=0;i<length;i++){if(array[i]===item){return i}}return-1};function arraysHaveMatchByRef(array1,array2,len1,len2){for(var index1=0;index1<len1;index1++){var val1=array1[index1];for(var index2=0;index2<len2;index2++){var val2=array2[index2];if(val1===val2){return true}}}}function matchItems(array1,array2,index1,index2,context){var value1=array1[index1];var value2=array2[index2];if(value1===value2){return true}if(typeof value1!=="object"||typeof value2!=="object"){return false}var objectHash=context.objectHash;if(!objectHash){return context.matchByPosition&&index1===index2}var hash1;var hash2;if(typeof index1==="number"){context.hashCache1=context.hashCache1||[];hash1=context.hashCache1[index1];if(typeof hash1==="undefined"){context.hashCache1[index1]=hash1=objectHash(value1,index1)}}else{hash1=objectHash(value1)}if(typeof hash1==="undefined"){return false}if(typeof index2==="number"){context.hashCache2=context.hashCache2||[];hash2=context.hashCache2[index2];if(typeof hash2==="undefined"){context.hashCache2[index2]=hash2=objectHash(value2,index2)}}else{hash2=objectHash(value2)}if(typeof hash2==="undefined"){return false}return hash1===hash2}var diffFilter=function arraysDiffFilter(context){if(!context.leftIsArray){return}var matchContext={objectHash:context.options&&context.options.objectHash,matchByPosition:context.options&&context.options.matchByPosition};var commonHead=0;var commonTail=0;var index;var index1;var index2;var array1=context.left;var array2=context.right;var len1=array1.length;var len2=array2.length;var child;if(len1>0&&len2>0&&!matchContext.objectHash&&typeof matchContext.matchByPosition!=="boolean"){matchContext.matchByPosition=!arraysHaveMatchByRef(array1,array2,len1,len2)}while(commonHead<len1&&commonHead<len2&&matchItems(array1,array2,commonHead,commonHead,matchContext)){index=commonHead;child=new DiffContext(context.left[index],context.right[index]);context.push(child,index);commonHead++}while(commonTail+commonHead<len1&&commonTail+commonHead<len2&&matchItems(array1,array2,len1-1-commonTail,len2-1-commonTail,matchContext)){index1=len1-1-commonTail;index2=len2-1-commonTail;child=new DiffContext(context.left[index1],context.right[index2]);context.push(child,index2);commonTail++}var result;if(commonHead+commonTail===len1){if(len1===len2){context.setResult(undefined).exit();return}result=result||{_t:"a"};for(index=commonHead;index<len2-commonTail;index++){result[index]=[array2[index]]}context.setResult(result).exit();return}if(commonHead+commonTail===len2){result=result||{_t:"a"};for(index=commonHead;index<len1-commonTail;index++){result["_"+index]=[array1[index],0,0]}context.setResult(result).exit();return}delete matchContext.hashCache1;delete matchContext.hashCache2;var trimmed1=array1.slice(commonHead,len1-commonTail);var trimmed2=array2.slice(commonHead,len2-commonTail);var seq=lcs.get(trimmed1,trimmed2,matchItems,matchContext);var removedItems=[];result=result||{_t:"a"};for(index=commonHead;index<len1-commonTail;index++){if(arrayIndexOf(seq.indices1,index-commonHead)<0){result["_"+index]=[array1[index],0,0];removedItems.push(index)}}var detectMove=true;if(context.options&&context.options.arrays&&context.options.arrays.detectMove===false){detectMove=false}var includeValueOnMove=false;if(context.options&&context.options.arrays&&context.options.arrays.includeValueOnMove){includeValueOnMove=true}var removedItemsLength=removedItems.length;for(index=commonHead;index<len2-commonTail;index++){var indexOnArray2=arrayIndexOf(seq.indices2,index-commonHead);if(indexOnArray2<0){var isMove=false;if(detectMove&&removedItemsLength>0){for(var removeItemIndex1=0;removeItemIndex1<removedItemsLength;removeItemIndex1++){index1=removedItems[removeItemIndex1];if(matchItems(trimmed1,trimmed2,index1-commonHead,index-commonHead,matchContext)){result["_"+index1].splice(1,2,index,ARRAY_MOVE);if(!includeValueOnMove){result["_"+index1][0]=""}index2=index;child=new DiffContext(context.left[index1],context.right[index2]);context.push(child,index2);removedItems.splice(removeItemIndex1,1);isMove=true;break}}}if(!isMove){result[index]=[array2[index]]}}else{index1=seq.indices1[indexOnArray2]+commonHead;index2=seq.indices2[indexOnArray2]+commonHead;child=new DiffContext(context.left[index1],context.right[index2]);context.push(child,index2)}}context.setResult(result).exit()};diffFilter.filterName="arrays";var compare={numerically:function(a,b){return a-b},numericallyBy:function(name){return function(a,b){return a[name]-b[name]}}};var patchFilter=function nestedPatchFilter(context){if(!context.nested){return}if(context.delta._t!=="a"){return}var index,index1;var delta=context.delta;var array=context.left;var toRemove=[];var toInsert=[];var toModify=[];for(index in delta){if(index!=="_t"){if(index[0]==="_"){if(delta[index][2]===0||delta[index][2]===ARRAY_MOVE){toRemove.push(parseInt(index.slice(1),10))}else{throw new Error("only removal or move can be applied at original array indices"+", invalid diff type: "+delta[index][2])}}else{if(delta[index].length===1){toInsert.push({index:parseInt(index,10),value:delta[index][0]})}else{toModify.push({index:parseInt(index,10),delta:delta[index]})}}}}toRemove=toRemove.sort(compare.numerically);for(index=toRemove.length-1;index>=0;index--){index1=toRemove[index];var indexDiff=delta["_"+index1];var removedValue=array.splice(index1,1)[0];if(indexDiff[2]===ARRAY_MOVE){toInsert.push({index:indexDiff[1],value:removedValue})}}toInsert=toInsert.sort(compare.numericallyBy("index"));var toInsertLength=toInsert.length;for(index=0;index<toInsertLength;index++){var insertion=toInsert[index];array.splice(insertion.index,0,insertion.value)}var toModifyLength=toModify.length;var child;if(toModifyLength>0){for(index=0;index<toModifyLength;index++){var modification=toModify[index];child=new PatchContext(context.left[modification.index],modification.delta);context.push(child,modification.index)}}if(!context.children){context.setResult(context.left).exit();return}context.exit()};patchFilter.filterName="arrays";var collectChildrenPatchFilter=function collectChildrenPatchFilter(context){if(!context||!context.children){return}if(context.delta._t!=="a"){return}var length=context.children.length;var child;for(var index=0;index<length;index++){child=context.children[index];context.left[child.childName]=child.result}context.setResult(context.left).exit()};collectChildrenPatchFilter.filterName="arraysCollectChildren";var reverseFilter=function arraysReverseFilter(context){if(!context.nested){if(context.delta[2]===ARRAY_MOVE){context.newName="_"+context.delta[1];context.setResult([context.delta[0],parseInt(context.childName.substr(1),10),ARRAY_MOVE]).exit()}return}if(context.delta._t!=="a"){return}var name,child;for(name in context.delta){if(name==="_t"){continue}child=new ReverseContext(context.delta[name]);context.push(child,name)}context.exit()};reverseFilter.filterName="arrays";var reverseArrayDeltaIndex=function(delta,index,itemDelta){if(typeof index==="string"&&index[0]==="_"){return parseInt(index.substr(1),10)}else if(isArray(itemDelta)&&itemDelta[2]===0){return"_"+index}var reverseIndex=+index;for(var deltaIndex in delta){var deltaItem=delta[deltaIndex];if(isArray(deltaItem)){if(deltaItem[2]===ARRAY_MOVE){var moveFromIndex=parseInt(deltaIndex.substr(1),10);var moveToIndex=deltaItem[1];if(moveToIndex===+index){return moveFromIndex}if(moveFromIndex<=reverseIndex&&moveToIndex>reverseIndex){reverseIndex++}else if(moveFromIndex>=reverseIndex&&moveToIndex<reverseIndex){reverseIndex--}}else if(deltaItem[2]===0){var deleteIndex=parseInt(deltaIndex.substr(1),10);if(deleteIndex<=reverseIndex){reverseIndex++}}else if(deltaItem.length===1&&deltaIndex<=reverseIndex){reverseIndex--}}}return reverseIndex};var collectChildrenReverseFilter=function collectChildrenReverseFilter(context){if(!context||!context.children){return}if(context.delta._t!=="a"){return}var length=context.children.length;var child;var delta={_t:"a"};for(var index=0;index<length;index++){child=context.children[index];var name=child.newName;if(typeof name==="undefined"){name=reverseArrayDeltaIndex(context.delta,child.childName,child.result)}if(delta[name]!==child.result){delta[name]=child.result}}context.setResult(delta).exit()};collectChildrenReverseFilter.filterName="arraysCollectChildren";exports.diffFilter=diffFilter;exports.patchFilter=patchFilter;exports.collectChildrenPatchFilter=collectChildrenPatchFilter;exports.reverseFilter=reverseFilter;exports.collectChildrenReverseFilter=collectChildrenReverseFilter},{"../contexts/diff":4,"../contexts/patch":5,"../contexts/reverse":6,"./lcs":12}],11:[function(require,module,exports){var diffFilter=function datesDiffFilter(context){if(context.left instanceof Date){if(context.right instanceof Date){if(context.left.getTime()!==context.right.getTime()){context.setResult([context.left,context.right])}else{context.setResult(undefined)}}else{context.setResult([context.left,context.right])}context.exit()}else if(context.right instanceof Date){context.setResult([context.left,context.right]).exit()}};diffFilter.filterName="dates";exports.diffFilter=diffFilter},{}],12:[function(require,module,exports){var defaultMatch=function(array1,array2,index1,index2){return array1[index1]===array2[index2]};var lengthMatrix=function(array1,array2,match,context){var len1=array1.length;var len2=array2.length;var x,y;var matrix=[len1+1];for(x=0;x<len1+1;x++){matrix[x]=[len2+1];for(y=0;y<len2+1;y++){matrix[x][y]=0}}matrix.match=match;for(x=1;x<len1+1;x++){for(y=1;y<len2+1;y++){if(match(array1,array2,x-1,y-1,context)){matrix[x][y]=matrix[x-1][y-1]+1}else{matrix[x][y]=Math.max(matrix[x-1][y],matrix[x][y-1])}}}return matrix};var backtrack=function(matrix,array1,array2,index1,index2,context){if(index1===0||index2===0){return{sequence:[],indices1:[],indices2:[]}}if(matrix.match(array1,array2,index1-1,index2-1,context)){var subsequence=backtrack(matrix,array1,array2,index1-1,index2-1,context);subsequence.sequence.push(array1[index1-1]);subsequence.indices1.push(index1-1);subsequence.indices2.push(index2-1);return subsequence}if(matrix[index1][index2-1]>matrix[index1-1][index2]){return backtrack(matrix,array1,array2,index1,index2-1,context)}else{return backtrack(matrix,array1,array2,index1-1,index2,context)}};var get=function(array1,array2,match,context){context=context||{};var matrix=lengthMatrix(array1,array2,match||defaultMatch,context);var result=backtrack(matrix,array1,array2,array1.length,array2.length,context);if(typeof array1==="string"&&typeof array2==="string"){result.sequence=result.sequence.join("")}return result};exports.get=get},{}],13:[function(require,module,exports){var DiffContext=require("../contexts/diff").DiffContext;var PatchContext=require("../contexts/patch").PatchContext;var ReverseContext=require("../contexts/reverse").ReverseContext;var collectChildrenDiffFilter=function collectChildrenDiffFilter(context){if(!context||!context.children){return}var length=context.children.length;var child;var result=context.result;for(var index=0;index<length;index++){child=context.children[index];if(typeof child.result==="undefined"){continue}result=result||{};result[child.childName]=child.result}if(result&&context.leftIsArray){result._t="a"}context.setResult(result).exit()};collectChildrenDiffFilter.filterName="collectChildren";var objectsDiffFilter=function objectsDiffFilter(context){if(context.leftIsArray||context.leftType!=="object"){return}var name,child;for(name in context.left){child=new DiffContext(context.left[name],context.right[name]);context.push(child,name)}for(name in context.right){if(typeof context.left[name]==="undefined"){child=new DiffContext(undefined,context.right[name]);context.push(child,name)}}if(!context.children||context.children.length===0){context.setResult(undefined).exit();return}context.exit()};objectsDiffFilter.filterName="objects";var patchFilter=function nestedPatchFilter(context){if(!context.nested){return}if(context.delta._t){return}var name,child;for(name in context.delta){child=new PatchContext(context.left[name],context.delta[name]);context.push(child,name)}context.exit()};patchFilter.filterName="objects";var collectChildrenPatchFilter=function collectChildrenPatchFilter(context){if(!context||!context.children){return}if(context.delta._t){return}var length=context.children.length;var child;for(var index=0;index<length;index++){child=context.children[index];if(context.left.hasOwnProperty(child.childName)&&child.result===undefined){delete context.left[child.childName]}else if(context.left[child.childName]!==child.result){context.left[child.childName]=child.result}}context.setResult(context.left).exit()};collectChildrenPatchFilter.filterName="collectChildren";var reverseFilter=function nestedReverseFilter(context){if(!context.nested){return}if(context.delta._t){return}var name,child;for(name in context.delta){child=new ReverseContext(context.delta[name]);context.push(child,name)}context.exit()};reverseFilter.filterName="objects";var collectChildrenReverseFilter=function collectChildrenReverseFilter(context){if(!context||!context.children){return}if(context.delta._t){return}var length=context.children.length;var child;var delta={};for(var index=0;index<length;index++){child=context.children[index];if(delta[child.childName]!==child.result){delta[child.childName]=child.result}}context.setResult(delta).exit()};collectChildrenReverseFilter.filterName="collectChildren";exports.collectChildrenDiffFilter=collectChildrenDiffFilter;exports.objectsDiffFilter=objectsDiffFilter;exports.patchFilter=patchFilter;exports.collectChildrenPatchFilter=collectChildrenPatchFilter;exports.reverseFilter=reverseFilter;exports.collectChildrenReverseFilter=collectChildrenReverseFilter},{"../contexts/diff":4,"../contexts/patch":5,"../contexts/reverse":6}],14:[function(require,module,exports){var TEXT_DIFF=2;var DEFAULT_MIN_LENGTH=60;var cachedDiffPatch=null;var getDiffMatchPatch=function(required){if(!cachedDiffPatch){var instance;if(typeof diff_match_patch!=="undefined"){instance=typeof diff_match_patch==="function"?new diff_match_patch:new diff_match_patch.diff_match_patch}else if(typeof require==="function"){try{var dmpModuleName="diff_match_patch_uncompressed";var dmp=require("../../public/external/"+dmpModuleName);instance=new dmp.diff_match_patch}catch(err){instance=null}}if(!instance){if(!required){return null}var error=new Error("text diff_match_patch library not found");error.diff_match_patch_not_found=true;throw error}cachedDiffPatch={diff:function(txt1,txt2){return instance.patch_toText(instance.patch_make(txt1,txt2))},patch:function(txt1,patch){var results=instance.patch_apply(instance.patch_fromText(patch),txt1);for(var i=0;i<results[1].length;i++){if(!results[1][i]){var error=new Error("text patch failed");error.textPatchFailed=true}}return results[0]}}}return cachedDiffPatch};var diffFilter=function textsDiffFilter(context){if(context.leftType!=="string"){return}var minLength=context.options&&context.options.textDiff&&context.options.textDiff.minLength||DEFAULT_MIN_LENGTH;if(context.left.length<minLength||context.right.length<minLength){context.setResult([context.left,context.right]).exit();return}var diffMatchPatch=getDiffMatchPatch();if(!diffMatchPatch){context.setResult([context.left,context.right]).exit();return}var diff=diffMatchPatch.diff;context.setResult([diff(context.left,context.right),0,TEXT_DIFF]).exit()};diffFilter.filterName="texts";var patchFilter=function textsPatchFilter(context){if(context.nested){return}if(context.delta[2]!==TEXT_DIFF){return}var patch=getDiffMatchPatch(true).patch;context.setResult(patch(context.left,context.delta[0])).exit()};patchFilter.filterName="texts";var textDeltaReverse=function(delta){var i,l,lines,line,lineTmp,header=null,headerRegex=/^@@ +\-(\d+),(\d+) +\+(\d+),(\d+) +@@$/,lineHeader,lineAdd,lineRemove;lines=delta.split("\n");for(i=0,l=lines.length;i<l;i++){line=lines[i];var lineStart=line.slice(0,1);if(lineStart==="@"){header=headerRegex.exec(line);lineHeader=i;lineAdd=null;lineRemove=null;lines[lineHeader]="@@ -"+header[3]+","+header[4]+" +"+header[1]+","+header[2]+" @@"}else if(lineStart==="+"){lineAdd=i;lines[i]="-"+lines[i].slice(1);if(lines[i-1].slice(0,1)==="+"){lineTmp=lines[i];lines[i]=lines[i-1];lines[i-1]=lineTmp}}else if(lineStart==="-"){lineRemove=i;lines[i]="+"+lines[i].slice(1)}}return lines.join("\n")};var reverseFilter=function textsReverseFilter(context){if(context.nested){return}if(context.delta[2]!==TEXT_DIFF){return}context.setResult([textDeltaReverse(context.delta[0]),0,TEXT_DIFF]).exit()};reverseFilter.filterName="texts";exports.diffFilter=diffFilter;exports.patchFilter=patchFilter;exports.reverseFilter=reverseFilter},{}],15:[function(require,module,exports){var isArray=typeof Array.isArray==="function"?Array.isArray:function(a){return a instanceof Array};var diffFilter=function trivialMatchesDiffFilter(context){if(context.left===context.right){context.setResult(undefined).exit();return}if(typeof context.left==="undefined"){if(typeof context.right==="function"){throw new Error("functions are not supported")}context.setResult([context.right]).exit();return}if(typeof context.right==="undefined"){context.setResult([context.left,0,0]).exit();return}if(typeof context.left==="function"||typeof context.right==="function"){throw new Error("functions are not supported")}context.leftType=context.left===null?"null":typeof context.left;context.rightType=context.right===null?"null":typeof context.right;if(context.leftType!==context.rightType){context.setResult([context.left,context.right]).exit();return}if(context.leftType==="boolean"||context.leftType==="number"){context.setResult([context.left,context.right]).exit();return}if(context.leftType==="object"){context.leftIsArray=isArray(context.left)}if(context.rightType==="object"){context.rightIsArray=isArray(context.right)}if(context.leftIsArray!==context.rightIsArray){context.setResult([context.left,context.right]).exit();return}};diffFilter.filterName="trivial";var patchFilter=function trivialMatchesPatchFilter(context){if(typeof context.delta==="undefined"){context.setResult(context.left).exit();return}context.nested=!isArray(context.delta);if(context.nested){return}if(context.delta.length===1){context.setResult(context.delta[0]).exit();return}if(context.delta.length===2){context.setResult(context.delta[1]).exit();return}if(context.delta.length===3&&context.delta[2]===0){context.setResult(undefined).exit();return}};patchFilter.filterName="trivial";var reverseFilter=function trivialReferseFilter(context){if(typeof context.delta==="undefined"){context.setResult(context.delta).exit();return}context.nested=!isArray(context.delta);if(context.nested){return}if(context.delta.length===1){context.setResult([context.delta[0],0,0]).exit();return}if(context.delta.length===2){context.setResult([context.delta[1],context.delta[0]]).exit();return}if(context.delta.length===3&&context.delta[2]===0){context.setResult([context.delta[0]]).exit();return}};reverseFilter.filterName="trivial";exports.diffFilter=diffFilter;exports.patchFilter=patchFilter;exports.reverseFilter=reverseFilter},{}],16:[function(require,module,exports){var environment=require("./environment");var DiffPatcher=require("./diffpatcher").DiffPatcher;exports.DiffPatcher=DiffPatcher;exports.create=function(options){return new DiffPatcher(options)};exports.dateReviver=require("./date-reviver");var defaultInstance;exports.diff=function(){if(!defaultInstance){defaultInstance=new DiffPatcher}return defaultInstance.diff.apply(defaultInstance,arguments)};exports.patch=function(){if(!defaultInstance){defaultInstance=new DiffPatcher}return defaultInstance.patch.apply(defaultInstance,arguments)};exports.unpatch=function(){if(!defaultInstance){defaultInstance=new DiffPatcher}return defaultInstance.unpatch.apply(defaultInstance,arguments)};exports.reverse=function(){if(!defaultInstance){defaultInstance=new DiffPatcher}return defaultInstance.reverse.apply(defaultInstance,arguments)};if(environment.isBrowser){exports.homepage="https://github.com/benjamine/jsondiffpatch";exports.version="0.1.37"}else{var packageInfoModuleName="../package.json";var packageInfo=require(packageInfoModuleName);exports.homepage=packageInfo.homepage;exports.version=packageInfo.version;var formatterModuleName="./formatters";var formatters=require(formatterModuleName);exports.formatters=formatters;exports.console=formatters.console}},{"./date-reviver":7,"./diffpatcher":8,"./environment":9}],17:[function(require,module,exports){var Pipe=function Pipe(name){this.name=name;this.filters=[]};Pipe.prototype.process=function(input){if(!this.processor){throw new Error("add this pipe to a processor before using it")}var debug=this.debug;var length=this.filters.length;var context=input;for(var index=0;index<length;index++){var filter=this.filters[index];if(debug){this.log("filter: "+filter.filterName)}filter(context);if(typeof context==="object"&&context.exiting){context.exiting=false;break}}if(!context.next&&this.resultCheck){this.resultCheck(context)}};Pipe.prototype.log=function(msg){console.log("[jsondiffpatch] "+this.name+" pipe, "+msg)};Pipe.prototype.append=function(){this.filters.push.apply(this.filters,arguments);return this};Pipe.prototype.prepend=function(){this.filters.unshift.apply(this.filters,arguments);return this};Pipe.prototype.indexOf=function(filterName){if(!filterName){throw new Error("a filter name is required")}for(var index=0;index<this.filters.length;index++){var filter=this.filters[index];if(filter.filterName===filterName){return index}}throw new Error("filter not found: "+filterName)};Pipe.prototype.list=function(){var names=[];for(var index=0;index<this.filters.length;index++){var filter=this.filters[index];names.push(filter.filterName)}return names};Pipe.prototype.after=function(filterName){var index=this.indexOf(filterName);var params=Array.prototype.slice.call(arguments,1);if(!params.length){throw new Error("a filter is required")}params.unshift(index+1,0);Array.prototype.splice.apply(this.filters,params);return this};Pipe.prototype.before=function(filterName){var index=this.indexOf(filterName);var params=Array.prototype.slice.call(arguments,1);if(!params.length){throw new Error("a filter is required")}params.unshift(index,0);Array.prototype.splice.apply(this.filters,params);return this};Pipe.prototype.clear=function(){this.filters.length=0;return this};Pipe.prototype.shouldHaveResult=function(should){if(should===false){this.resultCheck=null;return}if(this.resultCheck){return}var pipe=this;this.resultCheck=function(context){if(!context.hasResult){console.log(context);var error=new Error(pipe.name+" failed");error.noResult=true;throw error}};return this};exports.Pipe=Pipe},{}],18:[function(require,module,exports){var Processor=function Processor(options){this.selfOptions=options;this.pipes={}};Processor.prototype.options=function(options){if(options){this.selfOptions=options}return this.selfOptions};Processor.prototype.pipe=function(name,pipe){if(typeof name==="string"){if(typeof pipe==="undefined"){return this.pipes[name]}else{this.pipes[name]=pipe}}if(name&&name.name){pipe=name;if(pipe.processor===this){return pipe}this.pipes[pipe.name]=pipe}pipe.processor=this;return pipe};Processor.prototype.process=function(input,pipe){var context=input;context.options=this.options();var nextPipe=pipe||input.pipe||"default";var lastPipe,lastContext;while(nextPipe){if(typeof context.nextAfterChildren!=="undefined"){context.next=context.nextAfterChildren;context.nextAfterChildren=null}if(typeof nextPipe==="string"){nextPipe=this.pipe(nextPipe)}nextPipe.process(context);lastContext=context;lastPipe=nextPipe;nextPipe=null;if(context){if(context.next){context=context.next;nextPipe=lastContext.nextPipe||context.pipe||lastPipe}}}return context.hasResult?context.result:undefined};exports.Processor=Processor},{}]},{},[1])(1)})}).call(this);if(typeof Package==="undefined")Package={};Package["benjamine:jsondiffpatch"]={}})();(function(){var Meteor=Package.meteor.Meteor;var Session=Package.session.Session;var EJSON=Package.ejson.EJSON;var check=Package.check.check;var Match=Package.check.Match;var DiffSequence=Package["diff-sequence"].DiffSequence;var MongoID=Package["mongo-id"].MongoID;var _=Package.underscore._;var Tracker=Package.tracker.Tracker;var Deps=Package.tracker.Deps;var Mongo=Package.mongo.Mongo;var LocalCollection=Package.minimongo.LocalCollection;var Minimongo=Package.minimongo.Minimongo;var ObserveSequence=Package["observe-sequence"].ObserveSequence;var ECMAScript=Package.ecmascript.ECMAScript;var ReactiveVar=Package["reactive-var"].ReactiveVar;var babelHelpers=Package["babel-runtime"].babelHelpers;var Symbol=Package["ecmascript-runtime"].Symbol;var Map=Package["ecmascript-runtime"].Map;var Set=Package["ecmascript-runtime"].Set;var Promise=Package.promise.Promise;(function(){(function webpackUniversalModuleDefinition(root,factory){if(typeof exports==="object"&&typeof module==="object")module.exports=factory(require("underscore"),require("jsondiffpatch"));else if(typeof define==="function"&&define.amd)define(["underscore","jsondiffpatch"],factory);else if(typeof exports==="object")exports["angularMeteor"]=factory(require("underscore"),require("jsondiffpatch"));else root["angularMeteor"]=factory(root["_"],root["jsondiffpatch"])})(this,function(__WEBPACK_EXTERNAL_MODULE_3__,__WEBPACK_EXTERNAL_MODULE_22__){return function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:false};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.loaded=true;return module.exports}__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.p="";return __webpack_require__(0)}([function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});__webpack_require__(1);__webpack_require__(4);__webpack_require__(5);__webpack_require__(6);__webpack_require__(7);__webpack_require__(8);__webpack_require__(9);__webpack_require__(10);__webpack_require__(11);__webpack_require__(12);__webpack_require__(13);__webpack_require__(14);__webpack_require__(15);var _utils=__webpack_require__(16);var _mixer=__webpack_require__(17);var _scope=__webpack_require__(18);var _core=__webpack_require__(19);var _viewModel=__webpack_require__(20);var _reactive=__webpack_require__(21);var _templates=__webpack_require__(23);var name="angular-meteor";exports.default=name;angular.module(name,[_utils.name,_mixer.name,_scope.name,_core.name,_viewModel.name,_reactive.name,_templates.name,"angular-meteor.ironrouter","angular-meteor.utils","angular-meteor.subscribe","angular-meteor.collection","angular-meteor.object","angular-meteor.user","angular-meteor.methods","angular-meteor.session","angular-meteor.camera"]).run([_mixer.Mixer,_core.Core,_viewModel.ViewModel,_reactive.Reactive,function($Mixer,$$Core,$$ViewModel,$$Reactive){$Mixer.mixin($$Core).mixin($$ViewModel).mixin($$Reactive)}]).service("$meteor",["$meteorCollection","$meteorCollectionFS","$meteorObject","$meteorMethods","$meteorSession","$meteorSubscribe","$meteorUtils","$meteorCamera","$meteorUser",function($meteorCollection,$meteorCollectionFS,$meteorObject,$meteorMethods,$meteorSession,$meteorSubscribe,$meteorUtils,$meteorCamera,$meteorUser){var _this=this;this.collection=$meteorCollection;this.collectionFS=$meteorCollectionFS;this.object=$meteorObject;this.subscribe=$meteorSubscribe.subscribe;this.call=$meteorMethods.call;this.session=$meteorSession;this.autorun=$meteorUtils.autorun;this.getCollectionByName=$meteorUtils.getCollectionByName;this.getPicture=$meteorCamera.getPicture;["loginWithPassword","requireUser","requireValidUser","waitForUser","createUser","changePassword","forgotPassword","resetPassword","verifyEmail","loginWithMeteorDeveloperAccount","loginWithFacebook","loginWithGithub","loginWithGoogle","loginWithMeetup","loginWithTwitter","loginWithWeibo","logout","logoutOtherClients"].forEach(function(method){_this[method]=$meteorUser[method]})}]);module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}"use strict";(function(){var module=angular.module("getUpdates",[]);var utils=function(){var rip=function rip(obj,level){if(level<1)return{};return _underscore2.default.reduce(obj,function(clone,v,k){v=_underscore2.default.isObject(v)?rip(v,--level):v;clone[k]=v;return clone},{})};var toPaths=function toPaths(obj){var keys=getKeyPaths(obj);var values=getDeepValues(obj);return _underscore2.default.object(keys,values)};var getKeyPaths=function getKeyPaths(obj){var keys=_underscore2.default.keys(obj).map(function(k){var v=obj[k];if(!_underscore2.default.isObject(v)||_underscore2.default.isEmpty(v)||_underscore2.default.isArray(v))return k;return getKeyPaths(v).map(function(subKey){return k+"."+subKey})});return _underscore2.default.flatten(keys)};var getDeepValues=function getDeepValues(obj,arr){arr=arr||[];_underscore2.default.values(obj).forEach(function(v){if(!_underscore2.default.isObject(v)||_underscore2.default.isEmpty(v)||_underscore2.default.isArray(v))arr.push(v);else getDeepValues(v,arr)});return arr};var flatten=function flatten(arr){return arr.reduce(function(flattened,v,i){if(_underscore2.default.isArray(v)&&!_underscore2.default.isEmpty(v))flattened.push.apply(flattened,flatten(v));else flattened.push(v);return flattened},[])};var setFilled=function setFilled(obj,k,v){if(!_underscore2.default.isEmpty(v))obj[k]=v};var assert=function assert(result,msg){if(!result)throwErr(msg)};var throwErr=function throwErr(msg){throw Error("get-updates error - "+msg)};return{rip:rip,toPaths:toPaths,getKeyPaths:getKeyPaths,getDeepValues:getDeepValues,setFilled:setFilled,assert:assert,throwErr:throwErr}}();var getDifference=function(){var getDifference=function getDifference(src,dst,isShallow){var level;if(isShallow>1)level=isShallow;else if(isShallow)level=1;if(level){src=utils.rip(src,level);dst=utils.rip(dst,level)}return compare(src,dst)};var compare=function compare(src,dst){var srcKeys=_underscore2.default.keys(src);var dstKeys=_underscore2.default.keys(dst);var keys=_underscore2.default.chain([]).concat(srcKeys).concat(dstKeys).uniq().without("$$hashKey").value();return keys.reduce(function(diff,k){var srcValue=src[k];var dstValue=dst[k];if(_underscore2.default.isDate(srcValue)&&_underscore2.default.isDate(dstValue)){if(srcValue.getTime()!=dstValue.getTime())diff[k]=dstValue}if(_underscore2.default.isObject(srcValue)&&_underscore2.default.isObject(dstValue)){var valueDiff=getDifference(srcValue,dstValue);
utils.setFilled(diff,k,valueDiff)}else if(srcValue!==dstValue){diff[k]=dstValue}return diff},{})};return getDifference}();var getUpdates=function(){var getUpdates=function getUpdates(src,dst,isShallow){utils.assert(_underscore2.default.isObject(src),"first argument must be an object");utils.assert(_underscore2.default.isObject(dst),"second argument must be an object");var diff=getDifference(src,dst,isShallow);var paths=utils.toPaths(diff);var set=createSet(paths);var unset=createUnset(paths);var pull=createPull(unset);var updates={};utils.setFilled(updates,"$set",set);utils.setFilled(updates,"$unset",unset);utils.setFilled(updates,"$pull",pull);return updates};var createSet=function createSet(paths){var undefinedKeys=getUndefinedKeys(paths);return _underscore2.default.omit(paths,undefinedKeys)};var createUnset=function createUnset(paths){var undefinedKeys=getUndefinedKeys(paths);var unset=_underscore2.default.pick(paths,undefinedKeys);return _underscore2.default.reduce(unset,function(result,v,k){result[k]=true;return result},{})};var createPull=function createPull(unset){var arrKeyPaths=_underscore2.default.keys(unset).map(function(k){var split=k.match(/(.*)\.\d+$/);return split&&split[1]});return _underscore2.default.compact(arrKeyPaths).reduce(function(pull,k){pull[k]=null;return pull},{})};var getUndefinedKeys=function getUndefinedKeys(obj){return _underscore2.default.keys(obj).filter(function(k){var v=obj[k];return _underscore2.default.isUndefined(v)})};return getUpdates}();module.value("getUpdates",getUpdates)})()},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _underscore=__webpack_require__(3);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}if(typeof _underscore2.default==="undefined"){if(typeof Package.underscore==="undefined"){throw new Error("underscore is missing")}}exports.default=_underscore2.default||Package.underscore._;module.exports=exports["default"]},function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE_3__},function(module,exports,__webpack_require__){"use strict";var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}"use strict";var _module=angular.module("diffArray",["getUpdates"]);_module.factory("diffArray",["getUpdates",function(getUpdates){var LocalCollection=Package.minimongo.LocalCollection;var idStringify=LocalCollection._idStringify||Package["mongo-id"].MongoID.idStringify;var idParse=LocalCollection._idParse||Package["mongo-id"].MongoID.idParse;function diffArray(lastSeqArray,seqArray,callbacks,preventNestedDiff){preventNestedDiff=!!preventNestedDiff;var diffFn=Package.minimongo.LocalCollection._diffQueryOrderedChanges||Package["diff-sequence"].DiffSequence.diffQueryOrderedChanges;var oldObjIds=[];var newObjIds=[];var posOld={};var posNew={};var posCur={};var lengthCur=lastSeqArray.length;_underscore2.default.each(seqArray,function(doc,i){newObjIds.push({_id:doc._id});posNew[idStringify(doc._id)]=i});_underscore2.default.each(lastSeqArray,function(doc,i){oldObjIds.push({_id:doc._id});posOld[idStringify(doc._id)]=i;posCur[idStringify(doc._id)]=i});diffFn(oldObjIds,newObjIds,{addedBefore:function addedBefore(id,doc,before){var position=before?posCur[idStringify(before)]:lengthCur;_underscore2.default.each(posCur,function(pos,id){if(pos>=position)posCur[id]++});lengthCur++;posCur[idStringify(id)]=position;callbacks.addedAt(id,seqArray[posNew[idStringify(id)]],position,before)},movedBefore:function movedBefore(id,before){var prevPosition=posCur[idStringify(id)];var position=before?posCur[idStringify(before)]:lengthCur-1;_underscore2.default.each(posCur,function(pos,id){if(pos>=prevPosition&&pos<=position)posCur[id]--;else if(pos<=prevPosition&&pos>=position)posCur[id]++});posCur[idStringify(id)]=position;callbacks.movedTo(id,seqArray[posNew[idStringify(id)]],prevPosition,position,before)},removed:function removed(id){var prevPosition=posCur[idStringify(id)];_underscore2.default.each(posCur,function(pos,id){if(pos>=prevPosition)posCur[id]--});delete posCur[idStringify(id)];lengthCur--;callbacks.removedAt(id,lastSeqArray[posOld[idStringify(id)]],prevPosition)}});_underscore2.default.each(posNew,function(pos,idString){if(!_underscore2.default.has(posOld,idString))return;var id=idParse(idString);var newItem=seqArray[pos]||{};var oldItem=lastSeqArray[posOld[idString]];var updates=getUpdates(oldItem,newItem,preventNestedDiff);if(!_underscore2.default.isEmpty(updates))callbacks.changedAt(id,updates,pos,oldItem)})}diffArray.shallow=function(lastSeqArray,seqArray,callbacks){return diffArray(lastSeqArray,seqArray,callbacks,true)};diffArray.deepCopyChanges=function(oldItem,newItem){var setDiff=getUpdates(oldItem,newItem).$set;_underscore2.default.each(setDiff,function(v,deepKey){setDeep(oldItem,deepKey,v)})};diffArray.deepCopyRemovals=function(oldItem,newItem){var unsetDiff=getUpdates(oldItem,newItem).$unset;_underscore2.default.each(unsetDiff,function(v,deepKey){unsetDeep(oldItem,deepKey)})};diffArray.getChanges=function(newCollection,oldCollection,diffMethod){var changes={added:[],removed:[],changed:[]};diffMethod(oldCollection,newCollection,{addedAt:function addedAt(id,item,index){changes.added.push({item:item,index:index})},removedAt:function removedAt(id,item,index){changes.removed.push({item:item,index:index})},changedAt:function changedAt(id,updates,index,oldItem){changes.changed.push({selector:id,modifier:updates})},movedTo:function movedTo(id,item,fromIndex,toIndex){}});return changes};var setDeep=function setDeep(obj,deepKey,v){var split=deepKey.split(".");var initialKeys=_underscore2.default.initial(split);var lastKey=_underscore2.default.last(split);initialKeys.reduce(function(subObj,k,i){var nextKey=split[i+1];if(isNumStr(nextKey)){if(subObj[k]===null)subObj[k]=[];if(subObj[k].length==parseInt(nextKey))subObj[k].push(null)}else if(subObj[k]===null||!isHash(subObj[k])){subObj[k]={}}return subObj[k]},obj);var deepObj=getDeep(obj,initialKeys);deepObj[lastKey]=v;return v};var unsetDeep=function unsetDeep(obj,deepKey){var split=deepKey.split(".");var initialKeys=_underscore2.default.initial(split);var lastKey=_underscore2.default.last(split);var deepObj=getDeep(obj,initialKeys);if(_underscore2.default.isArray(deepObj)&&isNumStr(lastKey))return!!deepObj.splice(lastKey,1);else return delete deepObj[lastKey]};var getDeep=function getDeep(obj,keys){return keys.reduce(function(subObj,k){return subObj[k]},obj)};var isHash=function isHash(obj){return _underscore2.default.isObject(obj)&&Object.getPrototypeOf(obj)===Object.prototype};var isNumStr=function isNumStr(str){return str.match(/^\d+$/)};return diffArray}])},function(module,exports){"use strict";angular.module("angular-meteor.settings",[]).constant("$angularMeteorSettings",{suppressWarnings:true})},function(module,exports){"use strict";angular.module("angular-meteor.ironrouter",[]).run(["$compile","$document","$rootScope",function($compile,$document,$rootScope){var Router=(Package["iron:router"]||{}).Router;if(!Router)return;var isLoaded=false;Router.onAfterAction(function(req,res,next){Tracker.afterFlush(function(){if(isLoaded)return;$compile($document)($rootScope);if(!$rootScope.$$phase)$rootScope.$apply();isLoaded=true})})}])},function(module,exports,__webpack_require__){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol?"symbol":typeof obj};var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}"use strict";var angularMeteorUtils=angular.module("angular-meteor.utils",["angular-meteor.settings"]);angularMeteorUtils.service("$meteorUtils",["$q","$timeout","$angularMeteorSettings",function($q,$timeout,$angularMeteorSettings){var self=this;this.autorun=function(scope,fn){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.utils.autorun] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! For more info: http://www.angular-meteor.com/api/1.3.6/autorun. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var comp=Tracker.autorun(function(c){fn(c);if(!c.firstRun)$timeout(angular.noop,0)});scope.$on("$destroy",function(){comp.stop()});return comp};this.stripDollarPrefixedKeys=function(data){if(!_underscore2.default.isObject(data)||data instanceof Date||data instanceof File||EJSON.toJSONValue(data).$type==="oid"||(typeof FS==="undefined"?"undefined":_typeof(FS))==="object"&&data instanceof FS.File)return data;var out=_underscore2.default.isArray(data)?[]:{};_underscore2.default.each(data,function(v,k){if(typeof k!=="string"||k.charAt(0)!=="$")out[k]=self.stripDollarPrefixedKeys(v)});return out};this.fulfill=function(deferred,boundError,boundResult){return function(err,result){if(err)deferred.reject(boundError==null?err:boundError);else if(typeof boundResult=="function")deferred.resolve(boundResult==null?result:boundResult(result));else deferred.resolve(boundResult==null?result:boundResult)}};this.promissor=function(obj,method){return function(){var deferred=$q.defer();var fulfill=self.fulfill(deferred);var args=_underscore2.default.toArray(arguments).concat(fulfill);obj[method].apply(obj,args);return deferred.promise}};this.promiseAll=function(promises){var allPromise=$q.all(promises);allPromise.finally(function(){$timeout(angular.noop)});return allPromise};this.getCollectionByName=function(string){return Mongo.Collection.get(string)};this.findIndexById=function(collection,doc){var foundDoc=_underscore2.default.find(collection,function(colDoc){return EJSON.equals(colDoc._id,doc._id)});return _underscore2.default.indexOf(collection,foundDoc)}}]);angularMeteorUtils.run(["$rootScope","$meteorUtils",function($rootScope,$meteorUtils){Object.getPrototypeOf($rootScope).$meteorAutorun=function(fn){return $meteorUtils.autorun(this,fn)}}])},function(module,exports){"use strict";var angularMeteorSubscribe=angular.module("angular-meteor.subscribe",["angular-meteor.settings"]);angularMeteorSubscribe.service("$meteorSubscribe",["$q","$angularMeteorSettings",function($q,$angularMeteorSettings){var self=this;this._subscribe=function(scope,deferred,args){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.subscribe] Please note that this module is deprecated since 1.3.0 and will be removed in 1.4.0! Replace it with the new syntax described here: http://www.angular-meteor.com/api/1.3.6/subscribe. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var subscription=null;var lastArg=args[args.length-1];if(angular.isObject(lastArg)&&angular.isFunction(lastArg.onStop)){var _onStop=lastArg.onStop;args.pop()}args.push({onReady:function onReady(){deferred.resolve(subscription)},onStop:function onStop(err){if(!deferred.promise.$$state.status){if(err)deferred.reject(err);else deferred.reject(new Meteor.Error("Subscription Stopped","Subscription stopped by a call to stop method. Either by the client or by the server."))}else if(_onStop)_onStop.apply(this,Array.prototype.slice.call(arguments))}});subscription=Meteor.subscribe.apply(scope,args);return subscription};this.subscribe=function(){var deferred=$q.defer();var args=Array.prototype.slice.call(arguments);var subscription=null;self._subscribe(this,deferred,args);return deferred.promise}}]);angularMeteorSubscribe.run(["$rootScope","$q","$meteorSubscribe",function($rootScope,$q,$meteorSubscribe){Object.getPrototypeOf($rootScope).$meteorSubscribe=function(){var deferred=$q.defer();var args=Array.prototype.slice.call(arguments);var subscription=$meteorSubscribe._subscribe(this,deferred,args);this.$on("$destroy",function(){subscription.stop()});return deferred.promise}}])},function(module,exports,__webpack_require__){"use strict";var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}"use strict";var angularMeteorCollection=angular.module("angular-meteor.collection",["angular-meteor.stopper","angular-meteor.subscribe","angular-meteor.utils","diffArray","angular-meteor.settings"]);angularMeteorCollection.factory("AngularMeteorCollection",["$q","$meteorSubscribe","$meteorUtils","$rootScope","$timeout","diffArray","$angularMeteorSettings",function($q,$meteorSubscribe,$meteorUtils,$rootScope,$timeout,diffArray,$angularMeteorSettings){function AngularMeteorCollection(curDefFunc,collection,diffArrayFunc,autoClientSave){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.$meteorCollection] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! For more info: http://www.angular-meteor.com/api/1.3.0/meteorCollection. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var data=[];data._serverBackup=[];data._diffArrayFunc=diffArrayFunc;data._hObserve=null;data._hNewCurAutorun=null;data._hDataAutorun=null;if(angular.isDefined(collection)){data.$$collection=collection}else{var cursor=curDefFunc();data.$$collection=$meteorUtils.getCollectionByName(cursor.collection.name)}_underscore2.default.extend(data,AngularMeteorCollection);data._startCurAutorun(curDefFunc,autoClientSave);return data}AngularMeteorCollection._startCurAutorun=function(curDefFunc,autoClientSave){var self=this;self._hNewCurAutorun=Tracker.autorun(function(){Tracker.onInvalidate(function(){self._stopCursor()});if(autoClientSave)self._setAutoClientSave();self._updateCursor(curDefFunc(),autoClientSave)})};AngularMeteorCollection.subscribe=function(){$meteorSubscribe.subscribe.apply(this,arguments);return this};AngularMeteorCollection.save=function(docs,useUnsetModifier){if(!docs)docs=this;docs=[].concat(docs);var promises=docs.map(function(doc){return this._upsertDoc(doc,useUnsetModifier)},this);return $meteorUtils.promiseAll(promises)};AngularMeteorCollection._upsertDoc=function(doc,useUnsetModifier){var deferred=$q.defer();var collection=this.$$collection;var createFulfill=_underscore2.default.partial($meteorUtils.fulfill,deferred,null);doc=$meteorUtils.stripDollarPrefixedKeys(doc);var docId=doc._id;var isExist=collection.findOne(docId);if(isExist){delete doc._id;var modifier=useUnsetModifier?{$unset:doc}:{$set:doc};collection.update(docId,modifier,createFulfill(function(){return{_id:docId,action:"updated"}}))}else{collection.insert(doc,createFulfill(function(id){return{_id:id,action:"inserted"}}))}return deferred.promise};AngularMeteorCollection._updateDiff=function(selector,update,callback){callback=callback||angular.noop;var setters=_underscore2.default.omit(update,"$pull");var updates=[setters];_underscore2.default.each(update.$pull,function(pull,prop){var puller={};puller[prop]=pull;updates.push({$pull:puller})});this._updateParallel(selector,updates,callback)};AngularMeteorCollection._updateParallel=function(selector,updates,callback){var self=this;var done=_underscore2.default.after(updates.length,callback);var next=function next(err,affectedDocsNum){if(err)return callback(err);done(null,affectedDocsNum)};_underscore2.default.each(updates,function(update){self.$$collection.update(selector,update,next)})};AngularMeteorCollection.remove=function(keyOrDocs){var keys;if(!keyOrDocs){keys=_underscore2.default.pluck(this,"_id")}else{keyOrDocs=[].concat(keyOrDocs);keys=_underscore2.default.map(keyOrDocs,function(keyOrDoc){return keyOrDoc._id||keyOrDoc})}check(keys,[Match.OneOf(String,Mongo.ObjectID)]);var promises=keys.map(function(key){return this._removeDoc(key)},this);return $meteorUtils.promiseAll(promises)};AngularMeteorCollection._removeDoc=function(id){var deferred=$q.defer();var collection=this.$$collection;var fulfill=$meteorUtils.fulfill(deferred,null,{_id:id,action:"removed"});collection.remove(id,fulfill);return deferred.promise};AngularMeteorCollection._updateCursor=function(cursor,autoClientSave){var self=this;if(self._hObserve)self._stopObserving();self._hObserve=cursor.observe({addedAt:function addedAt(doc,atIndex){self.splice(atIndex,0,doc);self._serverBackup.splice(atIndex,0,doc);self._setServerUpdateMode()},changedAt:function changedAt(doc,oldDoc,atIndex){diffArray.deepCopyChanges(self[atIndex],doc);diffArray.deepCopyRemovals(self[atIndex],doc);self._serverBackup[atIndex]=self[atIndex];self._setServerUpdateMode()},movedTo:function movedTo(doc,fromIndex,toIndex){self.splice(fromIndex,1);self.splice(toIndex,0,doc);self._serverBackup.splice(fromIndex,1);self._serverBackup.splice(toIndex,0,doc);self._setServerUpdateMode()},removedAt:function removedAt(oldDoc){var removedIndex=$meteorUtils.findIndexById(self,oldDoc);if(removedIndex!=-1){self.splice(removedIndex,1);self._serverBackup.splice(removedIndex,1);self._setServerUpdateMode()}else{removedIndex=$meteorUtils.findIndexById(self._serverBackup,oldDoc);if(removedIndex!=-1){self._serverBackup.splice(removedIndex,1)}}}});self._hDataAutorun=Tracker.autorun(function(){cursor.fetch();if(self._serverMode)self._unsetServerUpdateMode(autoClientSave)})};AngularMeteorCollection._stopObserving=function(){this._hObserve.stop();this._hDataAutorun.stop();delete this._serverMode;delete this._hUnsetTimeout};AngularMeteorCollection._setServerUpdateMode=function(name){this._serverMode=true;this._unsetAutoClientSave()};AngularMeteorCollection._unsetServerUpdateMode=function(autoClientSave){var self=this;if(self._hUnsetTimeout){$timeout.cancel(self._hUnsetTimeout);self._hUnsetTimeout=null}self._hUnsetTimeout=$timeout(function(){self._serverMode=false;var changes=diffArray.getChanges(self,self._serverBackup,self._diffArrayFunc);self._saveChanges(changes);if(autoClientSave)self._setAutoClientSave()},0)};AngularMeteorCollection.stop=function(){this._stopCursor();this._hNewCurAutorun.stop()};AngularMeteorCollection._stopCursor=function(){this._unsetAutoClientSave();if(this._hObserve){this._hObserve.stop();this._hDataAutorun.stop()}this.splice(0);this._serverBackup.splice(0)};AngularMeteorCollection._unsetAutoClientSave=function(name){if(this._hRegAutoBind){this._hRegAutoBind();this._hRegAutoBind=null}};AngularMeteorCollection._setAutoClientSave=function(){var self=this;self._unsetAutoClientSave();self._hRegAutoBind=$rootScope.$watch(function(){return self},function(nItems,oItems){if(nItems===oItems)return;var changes=diffArray.getChanges(self,oItems,self._diffArrayFunc);self._unsetAutoClientSave();self._saveChanges(changes);self._setAutoClientSave()},true)};AngularMeteorCollection._saveChanges=function(changes){var self=this;var addedDocs=changes.added.reverse().map(function(descriptor){self.splice(descriptor.index,1);return descriptor.item});if(addedDocs.length)self.save(addedDocs);var removedDocs=changes.removed.map(function(descriptor){return descriptor.item});if(removedDocs.length)self.remove(removedDocs);changes.changed.forEach(function(descriptor){self._updateDiff(descriptor.selector,descriptor.modifier)})};return AngularMeteorCollection}]);angularMeteorCollection.factory("$meteorCollectionFS",["$meteorCollection","diffArray","$angularMeteorSettings",function($meteorCollection,diffArray,$angularMeteorSettings){function $meteorCollectionFS(reactiveFunc,autoClientSave,collection){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.$meteorCollectionFS] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! For more info: http://www.angular-meteor.com/api/1.3.0/files. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");return new $meteorCollection(reactiveFunc,autoClientSave,collection,diffArray.shallow)}return $meteorCollectionFS}]);angularMeteorCollection.factory("$meteorCollection",["AngularMeteorCollection","$rootScope","diffArray",function(AngularMeteorCollection,$rootScope,diffArray){function $meteorCollection(reactiveFunc,autoClientSave,collection,diffFn){if(!reactiveFunc){throw new TypeError("The first argument of $meteorCollection is undefined.")}if(!(angular.isFunction(reactiveFunc)||angular.isFunction(reactiveFunc.find))){throw new TypeError("The first argument of $meteorCollection must be a function or "+"a have a find function property.")}if(!angular.isFunction(reactiveFunc)){collection=angular.isDefined(collection)?collection:reactiveFunc;reactiveFunc=_underscore2.default.bind(reactiveFunc.find,reactiveFunc)}autoClientSave=angular.isDefined(autoClientSave)?autoClientSave:true;diffFn=diffFn||diffArray;return new AngularMeteorCollection(reactiveFunc,collection,diffFn,autoClientSave)}return $meteorCollection}]);angularMeteorCollection.run(["$rootScope","$meteorCollection","$meteorCollectionFS","$meteorStopper",function($rootScope,$meteorCollection,$meteorCollectionFS,$meteorStopper){var scopeProto=Object.getPrototypeOf($rootScope);scopeProto.$meteorCollection=$meteorStopper($meteorCollection);scopeProto.$meteorCollectionFS=$meteorStopper($meteorCollectionFS)}])},function(module,exports,__webpack_require__){"use strict";var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}"use strict";var angularMeteorObject=angular.module("angular-meteor.object",["angular-meteor.utils","angular-meteor.subscribe","angular-meteor.collection","getUpdates","diffArray","angular-meteor.settings"]);angularMeteorObject.factory("AngularMeteorObject",["$q","$meteorSubscribe","$meteorUtils","diffArray","getUpdates","AngularMeteorCollection","$angularMeteorSettings",function($q,$meteorSubscribe,$meteorUtils,diffArray,getUpdates,AngularMeteorCollection,$angularMeteorSettings){AngularMeteorObject.$$internalProps=["$$collection","$$options","$$id","$$hashkey","$$internalProps","$$scope","bind","save","reset","subscribe","stop","autorunComputation","unregisterAutoBind","unregisterAutoDestroy","getRawObject","_auto","_setAutos","_eventEmitter","_serverBackup","_updateDiff","_updateParallel","_getId"];function AngularMeteorObject(collection,selector,options){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.$meteorObject] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! For more info: http://www.angular-meteor.com/api/1.3.0/meteorObject. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var helpers=collection._helpers;var data=_underscore2.default.isFunction(helpers)?Object.create(helpers.prototype):{};var doc=collection.findOne(selector,options);var collectionExtension=_underscore2.default.pick(AngularMeteorCollection,"_updateParallel");_underscore2.default.extend(data,doc);_underscore2.default.extend(data,AngularMeteorObject);_underscore2.default.extend(data,collectionExtension);data.$$options=_underscore2.default.omit(options,"skip","limit");data.$$collection=collection;data.$$id=data._getId(selector);data._serverBackup=doc||{};return data}AngularMeteorObject.getRawObject=function(){return angular.copy(_underscore2.default.omit(this,this.$$internalProps))};AngularMeteorObject.subscribe=function(){$meteorSubscribe.subscribe.apply(this,arguments);return this};AngularMeteorObject.save=function(custom){var deferred=$q.defer();var collection=this.$$collection;var createFulfill=_underscore2.default.partial($meteorUtils.fulfill,deferred,null);var oldDoc=collection.findOne(this.$$id);var mods;if(oldDoc){if(custom)mods={$set:custom};else{mods=getUpdates(oldDoc,this.getRawObject());if(_underscore2.default.isEmpty(mods)){return $q.when({action:"updated"})}}this._updateDiff(mods,createFulfill({action:"updated"}))}else{if(custom)mods=_underscore2.default.clone(custom);else mods=this.getRawObject();mods._id=mods._id||this.$$id;collection.insert(mods,createFulfill({action:"inserted"}))}return deferred.promise};AngularMeteorObject._updateDiff=function(update,callback){var selector=this.$$id;AngularMeteorCollection._updateDiff.call(this,selector,update,callback)};AngularMeteorObject.reset=function(keepClientProps){var self=this;var options=this.$$options;var id=this.$$id;var doc=this.$$collection.findOne(id,options);if(doc){var docKeys=_underscore2.default.keys(doc);var docExtension=_underscore2.default.pick(doc,docKeys);var clientProps;_underscore2.default.extend(self,docExtension);_underscore2.default.extend(self._serverBackup,docExtension);if(keepClientProps){clientProps=_underscore2.default.intersection(_underscore2.default.keys(self),_underscore2.default.keys(self._serverBackup))}else{clientProps=_underscore2.default.keys(self)}var serverProps=_underscore2.default.keys(doc);var removedKeys=_underscore2.default.difference(clientProps,serverProps,self.$$internalProps);removedKeys.forEach(function(prop){delete self[prop];delete self._serverBackup[prop]})}else{_underscore2.default.keys(this.getRawObject()).forEach(function(prop){delete self[prop]});self._serverBackup={}}};AngularMeteorObject.stop=function(){if(this.unregisterAutoDestroy)this.unregisterAutoDestroy();if(this.unregisterAutoBind)this.unregisterAutoBind();if(this.autorunComputation&&this.autorunComputation.stop)this.autorunComputation.stop()};AngularMeteorObject._getId=function(selector){var options=_underscore2.default.extend({},this.$$options,{fields:{_id:1},reactive:false,transform:null});var doc=this.$$collection.findOne(selector,options);if(doc)return doc._id;if(selector instanceof Mongo.ObjectID)return selector;if(_underscore2.default.isString(selector))return selector;return new Mongo.ObjectID};return AngularMeteorObject}]);angularMeteorObject.factory("$meteorObject",["$rootScope","$meteorUtils","getUpdates","AngularMeteorObject",function($rootScope,$meteorUtils,getUpdates,AngularMeteorObject){function $meteorObject(collection,id,auto,options){if(!collection){throw new TypeError("The first argument of $meteorObject is undefined.")}if(!angular.isFunction(collection.findOne)){throw new TypeError("The first argument of $meteorObject must be a function or a have a findOne function property.")}var data=new AngularMeteorObject(collection,id,options);data._auto=auto!==false;_underscore2.default.extend(data,$meteorObject);data._setAutos();return data}$meteorObject._setAutos=function(){var self=this;this.autorunComputation=$meteorUtils.autorun($rootScope,function(){self.reset(true)});this.unregisterAutoBind=this._auto&&$rootScope.$watch(function(){return self.getRawObject()},function(item,oldItem){if(item!==oldItem)self.save()},true);this.unregisterAutoDestroy=$rootScope.$on("$destroy",function(){if(self&&self.stop)self.pop()})};return $meteorObject}]);angularMeteorObject.run(["$rootScope","$meteorObject","$meteorStopper",function($rootScope,$meteorObject,$meteorStopper){var scopeProto=Object.getPrototypeOf($rootScope);scopeProto.$meteorObject=$meteorStopper($meteorObject)}])},function(module,exports,__webpack_require__){"use strict";var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}"use strict";var angularMeteorUser=angular.module("angular-meteor.user",["angular-meteor.utils","angular-meteor.core","angular-meteor.settings"]);angularMeteorUser.service("$meteorUser",["$rootScope","$meteorUtils","$q","$angularMeteorSettings",function($rootScope,$meteorUtils,$q,$angularMeteorSettings){var pack=Package["accounts-base"];if(!pack)return;var self=this;var Accounts=pack.Accounts;this.waitForUser=function(){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.waitForUser] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! http://info.meteor.com/blog/angular-meteor-1.3. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var deferred=$q.defer();$meteorUtils.autorun($rootScope,function(){if(!Meteor.loggingIn())deferred.resolve(Meteor.user())},true);return deferred.promise};this.requireUser=function(){if(!$angularMeteorSettings.suppressWarnings){console.warn("[angular-meteor.requireUser] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! http://info.meteor.com/blog/angular-meteor-1.3. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings")}var deferred=$q.defer();$meteorUtils.autorun($rootScope,function(){if(!Meteor.loggingIn()){if(Meteor.user()===null)deferred.reject("AUTH_REQUIRED");else deferred.resolve(Meteor.user())}},true);return deferred.promise};this.requireValidUser=function(validatorFn){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.requireValidUser] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! http://info.meteor.com/blog/angular-meteor-1.3. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");return self.requireUser(true).then(function(user){var valid=validatorFn(user);if(valid===true)return user;else if(typeof valid==="string")return $q.reject(valid);else return $q.reject("FORBIDDEN")})};this.loginWithPassword=$meteorUtils.promissor(Meteor,"loginWithPassword");this.createUser=$meteorUtils.promissor(Accounts,"createUser");this.changePassword=$meteorUtils.promissor(Accounts,"changePassword");this.forgotPassword=$meteorUtils.promissor(Accounts,"forgotPassword");this.resetPassword=$meteorUtils.promissor(Accounts,"resetPassword");this.verifyEmail=$meteorUtils.promissor(Accounts,"verifyEmail");this.logout=$meteorUtils.promissor(Meteor,"logout");this.logoutOtherClients=$meteorUtils.promissor(Meteor,"logoutOtherClients");this.loginWithFacebook=$meteorUtils.promissor(Meteor,"loginWithFacebook");this.loginWithTwitter=$meteorUtils.promissor(Meteor,"loginWithTwitter");this.loginWithGoogle=$meteorUtils.promissor(Meteor,"loginWithGoogle");this.loginWithGithub=$meteorUtils.promissor(Meteor,"loginWithGithub");this.loginWithMeteorDeveloperAccount=$meteorUtils.promissor(Meteor,"loginWithMeteorDeveloperAccount");this.loginWithMeetup=$meteorUtils.promissor(Meteor,"loginWithMeetup");this.loginWithWeibo=$meteorUtils.promissor(Meteor,"loginWithWeibo")}]);angularMeteorUser.run(["$rootScope","$angularMeteorSettings","$$Core",function($rootScope,$angularMeteorSettings,$$Core){var ScopeProto=Object.getPrototypeOf($rootScope);_underscore2.default.extend(ScopeProto,$$Core);$rootScope.autorun(function(){if(!Meteor.user)return;$rootScope.currentUser=Meteor.user();$rootScope.loggingIn=Meteor.loggingIn()})}])},function(module,exports,__webpack_require__){"use strict";var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}"use strict";var angularMeteorMethods=angular.module("angular-meteor.methods",["angular-meteor.utils","angular-meteor.settings"]);angularMeteorMethods.service("$meteorMethods",["$q","$meteorUtils","$angularMeteorSettings",function($q,$meteorUtils,$angularMeteorSettings){this.call=function(){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.$meteor.call] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! For more info: http://www.angular-meteor.com/api/1.3.0/methods. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var deferred=$q.defer();var fulfill=$meteorUtils.fulfill(deferred);var args=_underscore2.default.toArray(arguments).concat(fulfill);Meteor.call.apply(this,args);return deferred.promise}}])},function(module,exports){"use strict";var angularMeteorSession=angular.module("angular-meteor.session",["angular-meteor.utils","angular-meteor.settings"]);
angularMeteorSession.factory("$meteorSession",["$meteorUtils","$parse","$angularMeteorSettings",function($meteorUtils,$parse,$angularMeteorSettings){return function(session){return{bind:function bind(scope,model){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.session.bind] Please note that this method is deprecated since 1.3.0 and will be removed in 1.4.0! http://www.angular-meteor.com/api/1.3.0/session. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var getter=$parse(model);var setter=getter.assign;$meteorUtils.autorun(scope,function(){setter(scope,Session.get(session))});scope.$watch(model,function(newItem,oldItem){Session.set(session,getter(scope))},true)}}}}])},function(module,exports){"use strict";var angularMeteorCamera=angular.module("angular-meteor.camera",["angular-meteor.utils","angular-meteor.settings"]);angularMeteorCamera.service("$meteorCamera",["$q","$meteorUtils","$angularMeteorSettings",function($q,$meteorUtils,$angularMeteorSettings){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.camera] Please note that this module has moved to a separate package and is deprecated since 1.3.0 and will be removed in 1.4.0! For more info: http://www.angular-meteor.com/api/1.3.0/camera. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");var pack=Package["mdg:camera"];if(!pack)return;var MeteorCamera=pack.MeteorCamera;this.getPicture=function(options){if(!$angularMeteorSettings.suppressWarnings)console.warn("[angular-meteor.camera] Please note that this module has moved to a separate package and is deprecated since 1.3.0 and will be removed in 1.4.0! For more info: http://www.angular-meteor.com/api/1.3.0/camera. You can disable this warning by following this guide http://www.angular-meteor.com/api/1.3.6/settings");options=options||{};var deferred=$q.defer();MeteorCamera.getPicture(options,$meteorUtils.fulfill(deferred));return deferred.promise}}])},function(module,exports){"use strict";var angularMeteorStopper=angular.module("angular-meteor.stopper",["angular-meteor.subscribe"]);angularMeteorStopper.factory("$meteorStopper",["$q","$meteorSubscribe",function($q,$meteorSubscribe){function $meteorStopper($meteorEntity){return function(){var args=Array.prototype.slice.call(arguments);var meteorEntity=$meteorEntity.apply(this,args);angular.extend(meteorEntity,$meteorStopper);meteorEntity.$$scope=this;this.$on("$destroy",function(){meteorEntity.stop();if(meteorEntity.subscription)meteorEntity.subscription.stop()});return meteorEntity}}$meteorStopper.subscribe=function(){var args=Array.prototype.slice.call(arguments);this.subscription=$meteorSubscribe._subscribe(this.$$scope,$q.defer(),args);return this};return $meteorStopper}])},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.utils=exports.name=undefined;var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}var name=exports.name="angular-meteor.utilities";var utils=exports.utils="$$utils";angular.module(name,[]).service(utils,["$rootScope",function($rootScope){var self=this;this.isCursor=function(obj){return obj instanceof Meteor.Collection.Cursor};this.isScope=function(obj){return obj instanceof $rootScope.constructor};this.isViewModel=function(obj){return _underscore2.default.isObject(obj)&&obj.$$dependencies};this.areSiblings=function(obj1,obj2){return _underscore2.default.isObject(obj1)&&_underscore2.default.isObject(obj2)&&Object.getPrototypeOf(obj1)===Object.getPrototypeOf(obj2)};this.bind=function(fn,context,tap){tap=_underscore2.default.isFunction(tap)?tap:angular.noop;if(_underscore2.default.isFunction(fn))return bindFn(fn,context,tap);if(_underscore2.default.isObject(fn))return bindObj(fn,context,tap);return fn};function bindFn(fn,context,tap){return function(){for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}var result=fn.apply(context,args);tap.call(context,{result:result,args:args});return result}}function bindObj(obj,context,tap){return _underscore2.default.keys(obj).reduce(function(bound,k){bound[k]=self.bind(obj[k],context,tap);return bound},{})}}])},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Mixer=exports.name=undefined;var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}var name=exports.name="angular-meteor.mixer";var Mixer=exports.Mixer="$Mixer";angular.module(name,[]).service(Mixer,function(){var _this=this;var caller=undefined;this._mixins=[];this._autoExtend=[];this._autoConstruct=[];this.mixin=function(mixin){if(!_underscore2.default.isObject(mixin)){throw Error("argument 1 must be an object")}_this._mixins=_underscore2.default.union(_this._mixins,[mixin]);_this._autoExtend.forEach(function(context){return _this._extend(context)});_this._autoConstruct.forEach(function(context){return _this._construct(context)});return _this};this._mixout=function(mixin){_this._mixins=_underscore2.default.without(_this._mixins,mixin);return _this};this._construct=function(context){for(var _len=arguments.length,args=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}_this._mixins.filter(_underscore2.default.isFunction).forEach(function(mixin){mixin.call.apply(mixin,[context].concat(args))});return context};this._extend=function(obj,options){var _$defaults=_underscore2.default.defaults({},options,{pattern:/.*/});var pattern=_$defaults.pattern;var context=_$defaults.context;var mixins=_this._mixins.map(function(mixin){var keys=_underscore2.default.keys(mixin).filter(function(k){return k.match(pattern)}).filter(function(k){return _underscore2.default.isFunction(mixin[k])});return keys.reduce(function(boundMixin,methodName){var methodHandler=mixin[methodName];boundMixin[methodName]=function(){var methodContext=context||this;var recentCaller=caller;caller=this;try{for(var _len2=arguments.length,args=Array(_len2),_key2=0;_key2<_len2;_key2++){args[_key2]=arguments[_key2]}return methodHandler.apply(methodContext,args)}finally{caller=recentCaller}};return boundMixin},{})});return _underscore2.default.extend.apply(_underscore2.default,[obj].concat(_toConsumableArray(mixins)))};Object.defineProperty(this,"caller",{configurable:true,enumerable:true,get:function get(){return caller}})})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.name=undefined;var _mixer=__webpack_require__(17);var name=exports.name="angular-meteor.scope";angular.module(name,[_mixer.name]).run(["$rootScope",_mixer.Mixer,function($rootScope,$Mixer){var Scope=$rootScope.constructor;var $new=$rootScope.$new;$Mixer._autoExtend.push(Scope.prototype);$Mixer._autoConstruct.push($rootScope);Scope.prototype.$new=function(){var scope=$new.apply(this,arguments);return $Mixer._construct(scope)}}])},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Core=exports.name=undefined;var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);var _utils=__webpack_require__(16);var _mixer=__webpack_require__(17);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}var name=exports.name="angular-meteor.core";var Core=exports.Core="$$Core";angular.module(name,[_utils.name,_mixer.name]).factory(Core,["$q",_utils.utils,_mixer.Mixer,function($q,$$utils,$Mixer){function $$Core(){}$$Core.autorun=function(fn){var options=arguments.length<=1||arguments[1]===undefined?{}:arguments[1];fn=this.$bindToContext($Mixer.caller,fn);if(!_underscore2.default.isFunction(fn)){throw Error("argument 1 must be a function")}if(!_underscore2.default.isObject(options)){throw Error("argument 2 must be an object")}var computation=Tracker.autorun(fn,options);this.$$autoStop(computation);return computation};$$Core.subscribe=function(subName,fn,cb){fn=this.$bindToContext($Mixer.caller,fn||angular.noop);cb=cb?this.$bindToContext($Mixer.caller,cb):angular.noop;if(!_underscore2.default.isString(subName)){throw Error("argument 1 must be a string")}if(!_underscore2.default.isFunction(fn)){throw Error("argument 2 must be a function")}if(!_underscore2.default.isFunction(cb)&&!_underscore2.default.isObject(cb)){throw Error("argument 3 must be a function or an object")}var result={};var computation=this.autorun(function(){var _Meteor;var args=fn();if(angular.isUndefined(args))args=[];if(!_underscore2.default.isArray(args)){throw Error("reactive function's return value must be an array")}var subscription=(_Meteor=Meteor).subscribe.apply(_Meteor,[subName].concat(_toConsumableArray(args),[cb]));result.ready=subscription.ready.bind(subscription);result.subscriptionId=subscription.subscriptionId});result.stop=computation.stop.bind(computation);return result};$$Core.callMethod=function(){var _Meteor2;for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}var fn=args.pop();if(_underscore2.default.isFunction(fn))fn=this.$bindToContext($Mixer.caller,fn);return(_Meteor2=Meteor).call.apply(_Meteor2,args.concat([fn]))};$$Core.applyMethod=function(){var _Meteor3;for(var _len2=arguments.length,args=Array(_len2),_key2=0;_key2<_len2;_key2++){args[_key2]=arguments[_key2]}var fn=args.pop();if(_underscore2.default.isFunction(fn))fn=this.$bindToContext($Mixer.caller,fn);return(_Meteor3=Meteor).apply.apply(_Meteor3,args.concat([fn]))};$$Core.$$autoStop=function(stoppable){this.$on("$destroy",stoppable.stop.bind(stoppable))};$$Core.$$throttledDigest=function(){var isDigestable=!this.$$destroyed&&!this.$$phase&&!this.$root.$$phase;if(isDigestable)this.$digest()};$$Core.$$defer=function(){var deferred=$q.defer();deferred.promise=deferred.promise.finally(this.$$throttledDigest.bind(this));return deferred};$$Core.$bindToContext=function(context,fn){return $$utils.bind(fn,context,this.$$throttledDigest.bind(this))};return $$Core}])},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.reactive=exports.ViewModel=exports.name=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);var _utils=__webpack_require__(16);var _mixer=__webpack_require__(17);var _core=__webpack_require__(19);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var name=exports.name="angular-meteor.view-model";var ViewModel=exports.ViewModel="$$ViewModel";var reactive=exports.reactive="$reactive";angular.module(name,[_utils.name,_mixer.name,_core.name]).factory(ViewModel,[_utils.utils,_mixer.Mixer,function($$utils,$Mixer){function $$ViewModel(){}$$ViewModel.viewModel=function(vm){if(!_underscore2.default.isObject(vm)){throw Error("argument 1 must be an object")}$Mixer._extend(vm,{pattern:/^(?!\$\$).*$/,context:this});$Mixer._construct(this,vm);return vm};return $$ViewModel}]).service(reactive,[_utils.utils,function($$utils){var Reactive=function(){function Reactive(vm){var _this=this;_classCallCheck(this,Reactive);if(!_underscore2.default.isObject(vm)){throw Error("argument 1 must be an object")}_underscore2.default.defer(function(){if(!_this._attached){console.warn("view model was not attached to any scope")}});this._vm=vm}_createClass(Reactive,[{key:"attach",value:function attach(scope){this._attached=true;if(!$$utils.isScope(scope)){throw Error("argument 1 must be a scope")}var viewModel=scope.viewModel(this._vm);viewModel.call=viewModel.callMethod;viewModel.apply=viewModel.applyMethod;return viewModel}}]);return Reactive}();return function(vm){return new Reactive(vm)}}])},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Reactive=exports.name=undefined;var _jsondiffpatch=__webpack_require__(22);var _jsondiffpatch2=_interopRequireDefault(_jsondiffpatch);var _underscore=__webpack_require__(2);var _underscore2=_interopRequireDefault(_underscore);var _utils=__webpack_require__(16);var _mixer=__webpack_require__(17);var _core=__webpack_require__(19);var _viewModel=__webpack_require__(20);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}var name=exports.name="angular-meteor.reactive";var Reactive=exports.Reactive="$$Reactive";angular.module(name,[_utils.name,_mixer.name,_core.name,_viewModel.name]).factory(Reactive,["$parse",_utils.utils,_mixer.Mixer,function($parse,$$utils,$Mixer){function $$Reactive(){var vm=arguments.length<=0||arguments[0]===undefined?this:arguments[0];vm.$$dependencies={}}$$Reactive.helpers=function(vm,props){var _this=this;if($$utils.isViewModel(vm)){if(!_underscore2.default.isObject(props)){throw Error("argument 2 must be an object")}}else{props=vm;vm=$Mixer.caller;if(!_underscore2.default.isObject(props)){throw Error("argument 1 must be an object")}}_underscore2.default.each(props,function(v,k){if(!_underscore2.default.isFunction(v)){throw Error("helper '"+k+"' must be a function")}});_underscore2.default.each(props,function(v,k){if(!vm.$$dependencies[k]){vm.$$dependencies[k]=new Tracker.Dependency}_this.$$setFnHelper(vm,k,v)})};$$Reactive.getReactively=function(vm,k,isDeep){if($$utils.isViewModel(vm)){if(angular.isUndefined(isDeep))isDeep=false;if(!_underscore2.default.isString(k)){throw Error("argument 2 must be a string")}if(!_underscore2.default.isBoolean(isDeep)){throw Error("argument 3 must be a boolean")}}else{isDeep=angular.isDefined(k)?k:false;k=vm;vm=$Mixer.caller;if(!_underscore2.default.isString(k)){throw Error("argument 1 must be a string")}if(!_underscore2.default.isBoolean(isDeep)){throw Error("argument 2 must be a boolean")}}return this.$$reactivateEntity(vm,k,this.$watch,isDeep)};$$Reactive.getCollectionReactively=function(vm,k){if($$utils.isViewModel(vm)){if(!_underscore2.default.isString(k)){throw Error("argument 2 must be a string")}}else{k=vm;vm=$Mixer.caller;if(!_underscore2.default.isString(k)){throw Error("argument 1 must be a string")}}return this.$$reactivateEntity(vm,k,this.$watchCollection)};$$Reactive.$$reactivateEntity=function(vm,k,watcher){if(!vm.$$dependencies[k]){vm.$$dependencies[k]=new Tracker.Dependency;for(var _len=arguments.length,watcherArgs=Array(_len>3?_len-3:0),_key=3;_key<_len;_key++){watcherArgs[_key-3]=arguments[_key]}this.$$watchEntity.apply(this,[vm,k,watcher].concat(watcherArgs))}vm.$$dependencies[k].depend();return $parse(k)(vm)};$$Reactive.$$watchEntity=function(vm,k,watcher){var _this2=this;var getVal=_underscore2.default.partial($parse(k),vm);var initialVal=getVal();for(var _len2=arguments.length,watcherArgs=Array(_len2>3?_len2-3:0),_key2=3;_key2<_len2;_key2++){watcherArgs[_key2-3]=arguments[_key2]}watcher.call.apply(watcher,[this,getVal,function(val,oldVal){var hasChanged=val!==initialVal||val!==oldVal;if(hasChanged)_this2.$$changed(vm,k)}].concat(watcherArgs))};$$Reactive.$$setFnHelper=function(vm,k,fn){var _this3=this;var activeObservation=null;var lastModel=null;var lastModelData=[];this.autorun(function(){var model=fn.apply(vm);Tracker.nonreactive(function(){if($$utils.isCursor(model)){var modelData=undefined;if(angular.isUndefined(vm[k])){_this3.$$setValHelper(vm,k,[],false)}if(activeObservation){lastModelData=lastModel.fetch();activeObservation.stop();activeObservation=null}var handle=_this3.$$handleCursor(vm,k,model);activeObservation=handle.observation;modelData=handle.data;if(lastModelData.length!==0){var diff=_jsondiffpatch2.default.diff(lastModelData,modelData);vm[k]=_jsondiffpatch2.default.patch(lastModelData,diff)}else{vm[k]=modelData}lastModel=model;lastModelData=modelData}else{_this3.$$handleNonCursor(vm,k,model)}_this3.$$changed(vm,k)})})};$$Reactive.$$setValHelper=function(vm,k,v){var _this4=this;var watch=arguments.length<=3||arguments[3]===undefined?true:arguments[3];if(watch){var isDeep=_underscore2.default.isObject(v);this.getReactively(vm,k,isDeep)}Object.defineProperty(vm,k,{configurable:true,enumerable:true,get:function get(){return v},set:function set(newVal){v=newVal;_this4.$$changed(vm,k)}})};$$Reactive.$$handleCursor=function(vm,k,cursor){var _this5=this;var data=[];var observation=cursor.observe({addedAt:function addedAt(doc,atIndex){if(!observation){data.push(doc);return}vm[k].splice(atIndex,0,doc);_this5.$$changed(vm,k)},changedAt:function changedAt(doc,oldDoc,atIndex){var diff=_jsondiffpatch2.default.diff(vm[k][atIndex],doc);_jsondiffpatch2.default.patch(vm[k][atIndex],diff);_this5.$$changed(vm,k)},movedTo:function movedTo(doc,fromIndex,toIndex){vm[k].splice(fromIndex,1);vm[k].splice(toIndex,0,doc);_this5.$$changed(vm,k)},removedAt:function removedAt(oldDoc,atIndex){vm[k].splice(atIndex,1);_this5.$$changed(vm,k)}});return{observation:observation,data:data}};$$Reactive.$$handleNonCursor=function(vm,k,data){var v=vm[k];if(angular.isDefined(v)){delete vm[k];v=null}if(angular.isUndefined(v)){this.$$setValHelper(vm,k,data)}else if($$utils.areSiblings(v,data)){var diff=_jsondiffpatch2.default.diff(v,data);_jsondiffpatch2.default.patch(v,diff);this.$$changed(vm,k)}else{vm[k]=data}};$$Reactive.$$depend=function(vm,k){vm.$$dependencies[k].depend()};$$Reactive.$$changed=function(vm,k){this.$$throttledDigest();vm.$$dependencies[k].changed()};return $$Reactive}])},function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE_22__},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var name=exports.name="angular-templates";try{angular.module(name)}catch(e){angular.module(name,[])}}])})}).call(this);if(typeof Package==="undefined")Package={};Package["angular-meteor-data"]={}})();