//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var _ = Package.underscore._;
var Base64 = Package.base64.Base64;

/* Package-scope variables */
var EJSON, EJSONTest;

(function(){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/ejson/ejson.js                                                                                           //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
/**                                                                                                                  // 1
 * @namespace                                                                                                        // 2
 * @summary Namespace for EJSON functions                                                                            // 3
 */                                                                                                                  // 4
EJSON = {};                                                                                                          // 5
EJSONTest = {};                                                                                                      // 6
                                                                                                                     // 7
                                                                                                                     // 8
                                                                                                                     // 9
// Custom type interface definition                                                                                  // 10
/**                                                                                                                  // 11
 * @class CustomType                                                                                                 // 12
 * @instanceName customType                                                                                          // 13
 * @memberOf EJSON                                                                                                   // 14
 * @summary The interface that a class must satisfy to be able to become an                                          // 15
 * EJSON custom type via EJSON.addType.                                                                              // 16
 */                                                                                                                  // 17
                                                                                                                     // 18
/**                                                                                                                  // 19
 * @function typeName                                                                                                // 20
 * @memberOf EJSON.CustomType                                                                                        // 21
 * @summary Return the tag used to identify this type.  This must match the tag used to register this type with [`EJSON.addType`](#ejson_add_type).
 * @locus Anywhere                                                                                                   // 23
 * @instance                                                                                                         // 24
 */                                                                                                                  // 25
                                                                                                                     // 26
/**                                                                                                                  // 27
 * @function toJSONValue                                                                                             // 28
 * @memberOf EJSON.CustomType                                                                                        // 29
 * @summary Serialize this instance into a JSON-compatible value.                                                    // 30
 * @locus Anywhere                                                                                                   // 31
 * @instance                                                                                                         // 32
 */                                                                                                                  // 33
                                                                                                                     // 34
/**                                                                                                                  // 35
 * @function clone                                                                                                   // 36
 * @memberOf EJSON.CustomType                                                                                        // 37
 * @summary Return a value `r` such that `this.equals(r)` is true, and modifications to `r` do not affect `this` and vice versa.
 * @locus Anywhere                                                                                                   // 39
 * @instance                                                                                                         // 40
 */                                                                                                                  // 41
                                                                                                                     // 42
/**                                                                                                                  // 43
 * @function equals                                                                                                  // 44
 * @memberOf EJSON.CustomType                                                                                        // 45
 * @summary Return `true` if `other` has a value equal to `this`; `false` otherwise.                                 // 46
 * @locus Anywhere                                                                                                   // 47
 * @param {Object} other Another object to compare this to.                                                          // 48
 * @instance                                                                                                         // 49
 */                                                                                                                  // 50
                                                                                                                     // 51
                                                                                                                     // 52
var customTypes = {};                                                                                                // 53
// Add a custom type, using a method of your choice to get to and                                                    // 54
// from a basic JSON-able representation.  The factory argument                                                      // 55
// is a function of JSON-able --> your object                                                                        // 56
// The type you add must have:                                                                                       // 57
// - A toJSONValue() method, so that Meteor can serialize it                                                         // 58
// - a typeName() method, to show how to look it up in our type table.                                               // 59
// It is okay if these methods are monkey-patched on.                                                                // 60
// EJSON.clone will use toJSONValue and the given factory to produce                                                 // 61
// a clone, but you may specify a method clone() that will be                                                        // 62
// used instead.                                                                                                     // 63
// Similarly, EJSON.equals will use toJSONValue to make comparisons,                                                 // 64
// but you may provide a method equals() instead.                                                                    // 65
/**                                                                                                                  // 66
 * @summary Add a custom datatype to EJSON.                                                                          // 67
 * @locus Anywhere                                                                                                   // 68
 * @param {String} name A tag for your custom type; must be unique among custom data types defined in your project, and must match the result of your type's `typeName` method.
 * @param {Function} factory A function that deserializes a JSON-compatible value into an instance of your type.  This should match the serialization performed by your type's `toJSONValue` method.
 */                                                                                                                  // 71
EJSON.addType = function (name, factory) {                                                                           // 72
  if (_.has(customTypes, name))                                                                                      // 73
    throw new Error("Type " + name + " already present");                                                            // 74
  customTypes[name] = factory;                                                                                       // 75
};                                                                                                                   // 76
                                                                                                                     // 77
var isInfOrNan = function (obj) {                                                                                    // 78
  return _.isNaN(obj) || obj === Infinity || obj === -Infinity;                                                      // 79
};                                                                                                                   // 80
                                                                                                                     // 81
var builtinConverters = [                                                                                            // 82
  { // Date                                                                                                          // 83
    matchJSONValue: function (obj) {                                                                                 // 84
      return _.has(obj, '$date') && _.size(obj) === 1;                                                               // 85
    },                                                                                                               // 86
    matchObject: function (obj) {                                                                                    // 87
      return obj instanceof Date;                                                                                    // 88
    },                                                                                                               // 89
    toJSONValue: function (obj) {                                                                                    // 90
      return {$date: obj.getTime()};                                                                                 // 91
    },                                                                                                               // 92
    fromJSONValue: function (obj) {                                                                                  // 93
      return new Date(obj.$date);                                                                                    // 94
    }                                                                                                                // 95
  },                                                                                                                 // 96
  { // NaN, Inf, -Inf. (These are the only objects with typeof !== 'object'                                          // 97
    // which we match.)                                                                                              // 98
    matchJSONValue: function (obj) {                                                                                 // 99
      return _.has(obj, '$InfNaN') && _.size(obj) === 1;                                                             // 100
    },                                                                                                               // 101
    matchObject: isInfOrNan,                                                                                         // 102
    toJSONValue: function (obj) {                                                                                    // 103
      var sign;                                                                                                      // 104
      if (_.isNaN(obj))                                                                                              // 105
        sign = 0;                                                                                                    // 106
      else if (obj === Infinity)                                                                                     // 107
        sign = 1;                                                                                                    // 108
      else                                                                                                           // 109
        sign = -1;                                                                                                   // 110
      return {$InfNaN: sign};                                                                                        // 111
    },                                                                                                               // 112
    fromJSONValue: function (obj) {                                                                                  // 113
      return obj.$InfNaN/0;                                                                                          // 114
    }                                                                                                                // 115
  },                                                                                                                 // 116
  { // Binary                                                                                                        // 117
    matchJSONValue: function (obj) {                                                                                 // 118
      return _.has(obj, '$binary') && _.size(obj) === 1;                                                             // 119
    },                                                                                                               // 120
    matchObject: function (obj) {                                                                                    // 121
      return typeof Uint8Array !== 'undefined' && obj instanceof Uint8Array                                          // 122
        || (obj && _.has(obj, '$Uint8ArrayPolyfill'));                                                               // 123
    },                                                                                                               // 124
    toJSONValue: function (obj) {                                                                                    // 125
      return {$binary: Base64.encode(obj)};                                                                          // 126
    },                                                                                                               // 127
    fromJSONValue: function (obj) {                                                                                  // 128
      return Base64.decode(obj.$binary);                                                                             // 129
    }                                                                                                                // 130
  },                                                                                                                 // 131
  { // Escaping one level                                                                                            // 132
    matchJSONValue: function (obj) {                                                                                 // 133
      return _.has(obj, '$escape') && _.size(obj) === 1;                                                             // 134
    },                                                                                                               // 135
    matchObject: function (obj) {                                                                                    // 136
      if (_.isEmpty(obj) || _.size(obj) > 2) {                                                                       // 137
        return false;                                                                                                // 138
      }                                                                                                              // 139
      return _.any(builtinConverters, function (converter) {                                                         // 140
        return converter.matchJSONValue(obj);                                                                        // 141
      });                                                                                                            // 142
    },                                                                                                               // 143
    toJSONValue: function (obj) {                                                                                    // 144
      var newObj = {};                                                                                               // 145
      _.each(obj, function (value, key) {                                                                            // 146
        newObj[key] = EJSON.toJSONValue(value);                                                                      // 147
      });                                                                                                            // 148
      return {$escape: newObj};                                                                                      // 149
    },                                                                                                               // 150
    fromJSONValue: function (obj) {                                                                                  // 151
      var newObj = {};                                                                                               // 152
      _.each(obj.$escape, function (value, key) {                                                                    // 153
        newObj[key] = EJSON.fromJSONValue(value);                                                                    // 154
      });                                                                                                            // 155
      return newObj;                                                                                                 // 156
    }                                                                                                                // 157
  },                                                                                                                 // 158
  { // Custom                                                                                                        // 159
    matchJSONValue: function (obj) {                                                                                 // 160
      return _.has(obj, '$type') && _.has(obj, '$value') && _.size(obj) === 2;                                       // 161
    },                                                                                                               // 162
    matchObject: function (obj) {                                                                                    // 163
      return EJSON._isCustomType(obj);                                                                               // 164
    },                                                                                                               // 165
    toJSONValue: function (obj) {                                                                                    // 166
      var jsonValue = Meteor._noYieldsAllowed(function () {                                                          // 167
        return obj.toJSONValue();                                                                                    // 168
      });                                                                                                            // 169
      return {$type: obj.typeName(), $value: jsonValue};                                                             // 170
    },                                                                                                               // 171
    fromJSONValue: function (obj) {                                                                                  // 172
      var typeName = obj.$type;                                                                                      // 173
      if (!_.has(customTypes, typeName))                                                                             // 174
        throw new Error("Custom EJSON type " + typeName + " is not defined");                                        // 175
      var converter = customTypes[typeName];                                                                         // 176
      return Meteor._noYieldsAllowed(function () {                                                                   // 177
        return converter(obj.$value);                                                                                // 178
      });                                                                                                            // 179
    }                                                                                                                // 180
  }                                                                                                                  // 181
];                                                                                                                   // 182
                                                                                                                     // 183
EJSON._isCustomType = function (obj) {                                                                               // 184
  return obj &&                                                                                                      // 185
    typeof obj.toJSONValue === 'function' &&                                                                         // 186
    typeof obj.typeName === 'function' &&                                                                            // 187
    _.has(customTypes, obj.typeName());                                                                              // 188
};                                                                                                                   // 189
                                                                                                                     // 190
EJSON._getTypes = function () {                                                                                      // 191
  return customTypes;                                                                                                // 192
};                                                                                                                   // 193
                                                                                                                     // 194
EJSON._getConverters = function () {                                                                                 // 195
  return builtinConverters;                                                                                          // 196
};                                                                                                                   // 197
                                                                                                                     // 198
// for both arrays and objects, in-place modification.                                                               // 199
var adjustTypesToJSONValue =                                                                                         // 200
EJSON._adjustTypesToJSONValue = function (obj) {                                                                     // 201
  // Is it an atom that we need to adjust?                                                                           // 202
  if (obj === null)                                                                                                  // 203
    return null;                                                                                                     // 204
  var maybeChanged = toJSONValueHelper(obj);                                                                         // 205
  if (maybeChanged !== undefined)                                                                                    // 206
    return maybeChanged;                                                                                             // 207
                                                                                                                     // 208
  // Other atoms are unchanged.                                                                                      // 209
  if (typeof obj !== 'object')                                                                                       // 210
    return obj;                                                                                                      // 211
                                                                                                                     // 212
  // Iterate over array or object structure.                                                                         // 213
  _.each(obj, function (value, key) {                                                                                // 214
    if (typeof value !== 'object' && value !== undefined &&                                                          // 215
        !isInfOrNan(value))                                                                                          // 216
      return; // continue                                                                                            // 217
                                                                                                                     // 218
    var changed = toJSONValueHelper(value);                                                                          // 219
    if (changed) {                                                                                                   // 220
      obj[key] = changed;                                                                                            // 221
      return; // on to the next key                                                                                  // 222
    }                                                                                                                // 223
    // if we get here, value is an object but not adjustable                                                         // 224
    // at this level.  recurse.                                                                                      // 225
    adjustTypesToJSONValue(value);                                                                                   // 226
  });                                                                                                                // 227
  return obj;                                                                                                        // 228
};                                                                                                                   // 229
                                                                                                                     // 230
// Either return the JSON-compatible version of the argument, or undefined (if                                       // 231
// the item isn't itself replaceable, but maybe some fields in it are)                                               // 232
var toJSONValueHelper = function (item) {                                                                            // 233
  for (var i = 0; i < builtinConverters.length; i++) {                                                               // 234
    var converter = builtinConverters[i];                                                                            // 235
    if (converter.matchObject(item)) {                                                                               // 236
      return converter.toJSONValue(item);                                                                            // 237
    }                                                                                                                // 238
  }                                                                                                                  // 239
  return undefined;                                                                                                  // 240
};                                                                                                                   // 241
                                                                                                                     // 242
/**                                                                                                                  // 243
 * @summary Serialize an EJSON-compatible value into its plain JSON representation.                                  // 244
 * @locus Anywhere                                                                                                   // 245
 * @param {EJSON} val A value to serialize to plain JSON.                                                            // 246
 */                                                                                                                  // 247
EJSON.toJSONValue = function (item) {                                                                                // 248
  var changed = toJSONValueHelper(item);                                                                             // 249
  if (changed !== undefined)                                                                                         // 250
    return changed;                                                                                                  // 251
  if (typeof item === 'object') {                                                                                    // 252
    item = EJSON.clone(item);                                                                                        // 253
    adjustTypesToJSONValue(item);                                                                                    // 254
  }                                                                                                                  // 255
  return item;                                                                                                       // 256
};                                                                                                                   // 257
                                                                                                                     // 258
// for both arrays and objects. Tries its best to just                                                               // 259
// use the object you hand it, but may return something                                                              // 260
// different if the object you hand it itself needs changing.                                                        // 261
//                                                                                                                   // 262
var adjustTypesFromJSONValue =                                                                                       // 263
EJSON._adjustTypesFromJSONValue = function (obj) {                                                                   // 264
  if (obj === null)                                                                                                  // 265
    return null;                                                                                                     // 266
  var maybeChanged = fromJSONValueHelper(obj);                                                                       // 267
  if (maybeChanged !== obj)                                                                                          // 268
    return maybeChanged;                                                                                             // 269
                                                                                                                     // 270
  // Other atoms are unchanged.                                                                                      // 271
  if (typeof obj !== 'object')                                                                                       // 272
    return obj;                                                                                                      // 273
                                                                                                                     // 274
  _.each(obj, function (value, key) {                                                                                // 275
    if (typeof value === 'object') {                                                                                 // 276
      var changed = fromJSONValueHelper(value);                                                                      // 277
      if (value !== changed) {                                                                                       // 278
        obj[key] = changed;                                                                                          // 279
        return;                                                                                                      // 280
      }                                                                                                              // 281
      // if we get here, value is an object but not adjustable                                                       // 282
      // at this level.  recurse.                                                                                    // 283
      adjustTypesFromJSONValue(value);                                                                               // 284
    }                                                                                                                // 285
  });                                                                                                                // 286
  return obj;                                                                                                        // 287
};                                                                                                                   // 288
                                                                                                                     // 289
// Either return the argument changed to have the non-json                                                           // 290
// rep of itself (the Object version) or the argument itself.                                                        // 291
                                                                                                                     // 292
// DOES NOT RECURSE.  For actually getting the fully-changed value, use                                              // 293
// EJSON.fromJSONValue                                                                                               // 294
var fromJSONValueHelper = function (value) {                                                                         // 295
  if (typeof value === 'object' && value !== null) {                                                                 // 296
    if (_.size(value) <= 2                                                                                           // 297
        && _.all(value, function (v, k) {                                                                            // 298
          return typeof k === 'string' && k.substr(0, 1) === '$';                                                    // 299
        })) {                                                                                                        // 300
      for (var i = 0; i < builtinConverters.length; i++) {                                                           // 301
        var converter = builtinConverters[i];                                                                        // 302
        if (converter.matchJSONValue(value)) {                                                                       // 303
          return converter.fromJSONValue(value);                                                                     // 304
        }                                                                                                            // 305
      }                                                                                                              // 306
    }                                                                                                                // 307
  }                                                                                                                  // 308
  return value;                                                                                                      // 309
};                                                                                                                   // 310
                                                                                                                     // 311
/**                                                                                                                  // 312
 * @summary Deserialize an EJSON value from its plain JSON representation.                                           // 313
 * @locus Anywhere                                                                                                   // 314
 * @param {JSONCompatible} val A value to deserialize into EJSON.                                                    // 315
 */                                                                                                                  // 316
EJSON.fromJSONValue = function (item) {                                                                              // 317
  var changed = fromJSONValueHelper(item);                                                                           // 318
  if (changed === item && typeof item === 'object') {                                                                // 319
    item = EJSON.clone(item);                                                                                        // 320
    adjustTypesFromJSONValue(item);                                                                                  // 321
    return item;                                                                                                     // 322
  } else {                                                                                                           // 323
    return changed;                                                                                                  // 324
  }                                                                                                                  // 325
};                                                                                                                   // 326
                                                                                                                     // 327
/**                                                                                                                  // 328
 * @summary Serialize a value to a string.                                                                           // 329
                                                                                                                     // 330
For EJSON values, the serialization fully represents the value. For non-EJSON values, serializes the same way as `JSON.stringify`.
 * @locus Anywhere                                                                                                   // 332
 * @param {EJSON} val A value to stringify.                                                                          // 333
 * @param {Object} [options]                                                                                         // 334
 * @param {Boolean | Integer | String} options.indent Indents objects and arrays for easy readability.  When `true`, indents by 2 spaces; when an integer, indents by that number of spaces; and when a string, uses the string as the indentation pattern.
 * @param {Boolean} options.canonical When `true`, stringifies keys in an object in sorted order.                    // 336
 */                                                                                                                  // 337
EJSON.stringify = function (item, options) {                                                                         // 338
  var json = EJSON.toJSONValue(item);                                                                                // 339
  if (options && (options.canonical || options.indent)) {                                                            // 340
    return EJSON._canonicalStringify(json, options);                                                                 // 341
  } else {                                                                                                           // 342
    return JSON.stringify(json);                                                                                     // 343
  }                                                                                                                  // 344
};                                                                                                                   // 345
                                                                                                                     // 346
/**                                                                                                                  // 347
 * @summary Parse a string into an EJSON value. Throws an error if the string is not valid EJSON.                    // 348
 * @locus Anywhere                                                                                                   // 349
 * @param {String} str A string to parse into an EJSON value.                                                        // 350
 */                                                                                                                  // 351
EJSON.parse = function (item) {                                                                                      // 352
  if (typeof item !== 'string')                                                                                      // 353
    throw new Error("EJSON.parse argument should be a string");                                                      // 354
  return EJSON.fromJSONValue(JSON.parse(item));                                                                      // 355
};                                                                                                                   // 356
                                                                                                                     // 357
/**                                                                                                                  // 358
 * @summary Returns true if `x` is a buffer of binary data, as returned from [`EJSON.newBinary`](#ejson_new_binary).
 * @param {Object} x The variable to check.                                                                          // 360
 * @locus Anywhere                                                                                                   // 361
 */                                                                                                                  // 362
EJSON.isBinary = function (obj) {                                                                                    // 363
  return !!((typeof Uint8Array !== 'undefined' && obj instanceof Uint8Array) ||                                      // 364
    (obj && obj.$Uint8ArrayPolyfill));                                                                               // 365
};                                                                                                                   // 366
                                                                                                                     // 367
/**                                                                                                                  // 368
 * @summary Return true if `a` and `b` are equal to each other.  Return false otherwise.  Uses the `equals` method on `a` if present, otherwise performs a deep comparison.
 * @locus Anywhere                                                                                                   // 370
 * @param {EJSON} a                                                                                                  // 371
 * @param {EJSON} b                                                                                                  // 372
 * @param {Object} [options]                                                                                         // 373
 * @param {Boolean} options.keyOrderSensitive Compare in key sensitive order, if supported by the JavaScript implementation.  For example, `{a: 1, b: 2}` is equal to `{b: 2, a: 1}` only when `keyOrderSensitive` is `false`.  The default is `false`.
 */                                                                                                                  // 375
EJSON.equals = function (a, b, options) {                                                                            // 376
  var i;                                                                                                             // 377
  var keyOrderSensitive = !!(options && options.keyOrderSensitive);                                                  // 378
  if (a === b)                                                                                                       // 379
    return true;                                                                                                     // 380
  if (_.isNaN(a) && _.isNaN(b))                                                                                      // 381
    return true; // This differs from the IEEE spec for NaN equality, b/c we don't want                              // 382
                 // anything ever with a NaN to be poisoned from becoming equal to anything.                         // 383
  if (!a || !b) // if either one is falsy, they'd have to be === to be equal                                         // 384
    return false;                                                                                                    // 385
  if (!(typeof a === 'object' && typeof b === 'object'))                                                             // 386
    return false;                                                                                                    // 387
  if (a instanceof Date && b instanceof Date)                                                                        // 388
    return a.valueOf() === b.valueOf();                                                                              // 389
  if (EJSON.isBinary(a) && EJSON.isBinary(b)) {                                                                      // 390
    if (a.length !== b.length)                                                                                       // 391
      return false;                                                                                                  // 392
    for (i = 0; i < a.length; i++) {                                                                                 // 393
      if (a[i] !== b[i])                                                                                             // 394
        return false;                                                                                                // 395
    }                                                                                                                // 396
    return true;                                                                                                     // 397
  }                                                                                                                  // 398
  if (typeof (a.equals) === 'function')                                                                              // 399
    return a.equals(b, options);                                                                                     // 400
  if (typeof (b.equals) === 'function')                                                                              // 401
    return b.equals(a, options);                                                                                     // 402
  if (a instanceof Array) {                                                                                          // 403
    if (!(b instanceof Array))                                                                                       // 404
      return false;                                                                                                  // 405
    if (a.length !== b.length)                                                                                       // 406
      return false;                                                                                                  // 407
    for (i = 0; i < a.length; i++) {                                                                                 // 408
      if (!EJSON.equals(a[i], b[i], options))                                                                        // 409
        return false;                                                                                                // 410
    }                                                                                                                // 411
    return true;                                                                                                     // 412
  }                                                                                                                  // 413
  // fallback for custom types that don't implement their own equals                                                 // 414
  switch (EJSON._isCustomType(a) + EJSON._isCustomType(b)) {                                                         // 415
    case 1: return false;                                                                                            // 416
    case 2: return EJSON.equals(EJSON.toJSONValue(a), EJSON.toJSONValue(b));                                         // 417
  }                                                                                                                  // 418
  // fall back to structural equality of objects                                                                     // 419
  var ret;                                                                                                           // 420
  if (keyOrderSensitive) {                                                                                           // 421
    var bKeys = [];                                                                                                  // 422
    _.each(b, function (val, x) {                                                                                    // 423
        bKeys.push(x);                                                                                               // 424
    });                                                                                                              // 425
    i = 0;                                                                                                           // 426
    ret = _.all(a, function (val, x) {                                                                               // 427
      if (i >= bKeys.length) {                                                                                       // 428
        return false;                                                                                                // 429
      }                                                                                                              // 430
      if (x !== bKeys[i]) {                                                                                          // 431
        return false;                                                                                                // 432
      }                                                                                                              // 433
      if (!EJSON.equals(val, b[bKeys[i]], options)) {                                                                // 434
        return false;                                                                                                // 435
      }                                                                                                              // 436
      i++;                                                                                                           // 437
      return true;                                                                                                   // 438
    });                                                                                                              // 439
    return ret && i === bKeys.length;                                                                                // 440
  } else {                                                                                                           // 441
    i = 0;                                                                                                           // 442
    ret = _.all(a, function (val, key) {                                                                             // 443
      if (!_.has(b, key)) {                                                                                          // 444
        return false;                                                                                                // 445
      }                                                                                                              // 446
      if (!EJSON.equals(val, b[key], options)) {                                                                     // 447
        return false;                                                                                                // 448
      }                                                                                                              // 449
      i++;                                                                                                           // 450
      return true;                                                                                                   // 451
    });                                                                                                              // 452
    return ret && _.size(b) === i;                                                                                   // 453
  }                                                                                                                  // 454
};                                                                                                                   // 455
                                                                                                                     // 456
/**                                                                                                                  // 457
 * @summary Return a deep copy of `val`.                                                                             // 458
 * @locus Anywhere                                                                                                   // 459
 * @param {EJSON} val A value to copy.                                                                               // 460
 */                                                                                                                  // 461
EJSON.clone = function (v) {                                                                                         // 462
  var ret;                                                                                                           // 463
  if (typeof v !== "object")                                                                                         // 464
    return v;                                                                                                        // 465
  if (v === null)                                                                                                    // 466
    return null; // null has typeof "object"                                                                         // 467
  if (v instanceof Date)                                                                                             // 468
    return new Date(v.getTime());                                                                                    // 469
  // RegExps are not really EJSON elements (eg we don't define a serialization                                       // 470
  // for them), but they're immutable anyway, so we can support them in clone.                                       // 471
  if (v instanceof RegExp)                                                                                           // 472
    return v;                                                                                                        // 473
  if (EJSON.isBinary(v)) {                                                                                           // 474
    ret = EJSON.newBinary(v.length);                                                                                 // 475
    for (var i = 0; i < v.length; i++) {                                                                             // 476
      ret[i] = v[i];                                                                                                 // 477
    }                                                                                                                // 478
    return ret;                                                                                                      // 479
  }                                                                                                                  // 480
  // XXX: Use something better than underscore's isArray                                                             // 481
  if (_.isArray(v) || _.isArguments(v)) {                                                                            // 482
    // For some reason, _.map doesn't work in this context on Opera (weird test                                      // 483
    // failures).                                                                                                    // 484
    ret = [];                                                                                                        // 485
    for (i = 0; i < v.length; i++)                                                                                   // 486
      ret[i] = EJSON.clone(v[i]);                                                                                    // 487
    return ret;                                                                                                      // 488
  }                                                                                                                  // 489
  // handle general user-defined typed Objects if they have a clone method                                           // 490
  if (typeof v.clone === 'function') {                                                                               // 491
    return v.clone();                                                                                                // 492
  }                                                                                                                  // 493
  // handle other custom types                                                                                       // 494
  if (EJSON._isCustomType(v)) {                                                                                      // 495
    return EJSON.fromJSONValue(EJSON.clone(EJSON.toJSONValue(v)), true);                                             // 496
  }                                                                                                                  // 497
  // handle other objects                                                                                            // 498
  ret = {};                                                                                                          // 499
  _.each(v, function (value, key) {                                                                                  // 500
    ret[key] = EJSON.clone(value);                                                                                   // 501
  });                                                                                                                // 502
  return ret;                                                                                                        // 503
};                                                                                                                   // 504
                                                                                                                     // 505
/**                                                                                                                  // 506
 * @summary Allocate a new buffer of binary data that EJSON can serialize.                                           // 507
 * @locus Anywhere                                                                                                   // 508
 * @param {Number} size The number of bytes of binary data to allocate.                                              // 509
 */                                                                                                                  // 510
// EJSON.newBinary is the public documented API for this functionality,                                              // 511
// but the implementation is in the 'base64' package to avoid                                                        // 512
// introducing a circular dependency. (If the implementation were here,                                              // 513
// then 'base64' would have to use EJSON.newBinary, and 'ejson' would                                                // 514
// also have to use 'base64'.)                                                                                       // 515
EJSON.newBinary = Base64.newBinary;                                                                                  // 516
                                                                                                                     // 517
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function(){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/ejson/stringify.js                                                                                       //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
// Based on json2.js from https://github.com/douglascrockford/JSON-js                                                // 1
//                                                                                                                   // 2
//    json2.js                                                                                                       // 3
//    2012-10-08                                                                                                     // 4
//                                                                                                                   // 5
//    Public Domain.                                                                                                 // 6
//                                                                                                                   // 7
//    NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.                                                        // 8
                                                                                                                     // 9
function quote(string) {                                                                                             // 10
  return JSON.stringify(string);                                                                                     // 11
}                                                                                                                    // 12
                                                                                                                     // 13
var str = function (key, holder, singleIndent, outerIndent, canonical) {                                             // 14
                                                                                                                     // 15
  // Produce a string from holder[key].                                                                              // 16
                                                                                                                     // 17
  var i;          // The loop counter.                                                                               // 18
  var k;          // The member key.                                                                                 // 19
  var v;          // The member value.                                                                               // 20
  var length;                                                                                                        // 21
  var innerIndent = outerIndent;                                                                                     // 22
  var partial;                                                                                                       // 23
  var value = holder[key];                                                                                           // 24
                                                                                                                     // 25
  // What happens next depends on the value's type.                                                                  // 26
                                                                                                                     // 27
  switch (typeof value) {                                                                                            // 28
  case 'string':                                                                                                     // 29
    return quote(value);                                                                                             // 30
  case 'number':                                                                                                     // 31
    // JSON numbers must be finite. Encode non-finite numbers as null.                                               // 32
    return isFinite(value) ? String(value) : 'null';                                                                 // 33
  case 'boolean':                                                                                                    // 34
    return String(value);                                                                                            // 35
  // If the type is 'object', we might be dealing with an object or an array or                                      // 36
  // null.                                                                                                           // 37
  case 'object':                                                                                                     // 38
    // Due to a specification blunder in ECMAScript, typeof null is 'object',                                        // 39
    // so watch out for that case.                                                                                   // 40
    if (!value) {                                                                                                    // 41
      return 'null';                                                                                                 // 42
    }                                                                                                                // 43
    // Make an array to hold the partial results of stringifying this object value.                                  // 44
    innerIndent = outerIndent + singleIndent;                                                                        // 45
    partial = [];                                                                                                    // 46
                                                                                                                     // 47
    // Is the value an array?                                                                                        // 48
    if (_.isArray(value) || _.isArguments(value)) {                                                                  // 49
                                                                                                                     // 50
      // The value is an array. Stringify every element. Use null as a placeholder                                   // 51
      // for non-JSON values.                                                                                        // 52
                                                                                                                     // 53
      length = value.length;                                                                                         // 54
      for (i = 0; i < length; i += 1) {                                                                              // 55
        partial[i] = str(i, value, singleIndent, innerIndent, canonical) || 'null';                                  // 56
      }                                                                                                              // 57
                                                                                                                     // 58
      // Join all of the elements together, separated with commas, and wrap them in                                  // 59
      // brackets.                                                                                                   // 60
                                                                                                                     // 61
      if (partial.length === 0) {                                                                                    // 62
        v = '[]';                                                                                                    // 63
      } else if (innerIndent) {                                                                                      // 64
        v = '[\n' + innerIndent + partial.join(',\n' + innerIndent) + '\n' + outerIndent + ']';                      // 65
      } else {                                                                                                       // 66
        v = '[' + partial.join(',') + ']';                                                                           // 67
      }                                                                                                              // 68
      return v;                                                                                                      // 69
    }                                                                                                                // 70
                                                                                                                     // 71
                                                                                                                     // 72
    // Iterate through all of the keys in the object.                                                                // 73
    var keys = _.keys(value);                                                                                        // 74
    if (canonical)                                                                                                   // 75
      keys = keys.sort();                                                                                            // 76
    _.each(keys, function (k) {                                                                                      // 77
      v = str(k, value, singleIndent, innerIndent, canonical);                                                       // 78
      if (v) {                                                                                                       // 79
        partial.push(quote(k) + (innerIndent ? ': ' : ':') + v);                                                     // 80
      }                                                                                                              // 81
    });                                                                                                              // 82
                                                                                                                     // 83
                                                                                                                     // 84
    // Join all of the member texts together, separated with commas,                                                 // 85
    // and wrap them in braces.                                                                                      // 86
                                                                                                                     // 87
    if (partial.length === 0) {                                                                                      // 88
      v = '{}';                                                                                                      // 89
    } else if (innerIndent) {                                                                                        // 90
      v = '{\n' + innerIndent + partial.join(',\n' + innerIndent) + '\n' + outerIndent + '}';                        // 91
    } else {                                                                                                         // 92
      v = '{' + partial.join(',') + '}';                                                                             // 93
    }                                                                                                                // 94
    return v;                                                                                                        // 95
  }                                                                                                                  // 96
}                                                                                                                    // 97
                                                                                                                     // 98
// If the JSON object does not yet have a stringify method, give it one.                                             // 99
                                                                                                                     // 100
EJSON._canonicalStringify = function (value, options) {                                                              // 101
  // Make a fake root object containing our value under the key of ''.                                               // 102
  // Return the result of stringifying the value.                                                                    // 103
  options = _.extend({                                                                                               // 104
    indent: "",                                                                                                      // 105
    canonical: false                                                                                                 // 106
  }, options);                                                                                                       // 107
  if (options.indent === true) {                                                                                     // 108
    options.indent = "  ";                                                                                           // 109
  } else if (typeof options.indent === 'number') {                                                                   // 110
    var newIndent = "";                                                                                              // 111
    for (var i = 0; i < options.indent; i++) {                                                                       // 112
      newIndent += ' ';                                                                                              // 113
    }                                                                                                                // 114
    options.indent = newIndent;                                                                                      // 115
  }                                                                                                                  // 116
  return str('', {'': value}, options.indent, "", options.canonical);                                                // 117
};                                                                                                                   // 118
                                                                                                                     // 119
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package.ejson = {
  EJSON: EJSON,
  EJSONTest: EJSONTest
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var EJSON = Package.ejson.EJSON;
var IdMap = Package['id-map'].IdMap;
var Random = Package.random.Random;

/* Package-scope variables */
var MongoID;

(function(){

////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                    //
// packages/mongo-id/id.js                                                                            //
//                                                                                                    //
////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                      //
MongoID = {};                                                                                         // 1
                                                                                                      // 2
MongoID._looksLikeObjectID = function (str) {                                                         // 3
  return str.length === 24 && str.match(/^[0-9a-f]*$/);                                               // 4
};                                                                                                    // 5
                                                                                                      // 6
MongoID.ObjectID = function (hexString) {                                                             // 7
  //random-based impl of Mongo ObjectID                                                               // 8
  var self = this;                                                                                    // 9
  if (hexString) {                                                                                    // 10
    hexString = hexString.toLowerCase();                                                              // 11
    if (!MongoID._looksLikeObjectID(hexString)) {                                                     // 12
      throw new Error("Invalid hexadecimal string for creating an ObjectID");                         // 13
    }                                                                                                 // 14
    // meant to work with _.isEqual(), which relies on structural equality                            // 15
    self._str = hexString;                                                                            // 16
  } else {                                                                                            // 17
    self._str = Random.hexString(24);                                                                 // 18
  }                                                                                                   // 19
};                                                                                                    // 20
                                                                                                      // 21
MongoID.ObjectID.prototype.toString = function () {                                                   // 22
  var self = this;                                                                                    // 23
  return "ObjectID(\"" + self._str + "\")";                                                           // 24
};                                                                                                    // 25
                                                                                                      // 26
MongoID.ObjectID.prototype.equals = function (other) {                                                // 27
  var self = this;                                                                                    // 28
  return other instanceof MongoID.ObjectID &&                                                         // 29
    self.valueOf() === other.valueOf();                                                               // 30
};                                                                                                    // 31
                                                                                                      // 32
MongoID.ObjectID.prototype.clone = function () {                                                      // 33
  var self = this;                                                                                    // 34
  return new MongoID.ObjectID(self._str);                                                             // 35
};                                                                                                    // 36
                                                                                                      // 37
MongoID.ObjectID.prototype.typeName = function() {                                                    // 38
  return "oid";                                                                                       // 39
};                                                                                                    // 40
                                                                                                      // 41
MongoID.ObjectID.prototype.getTimestamp = function() {                                                // 42
  var self = this;                                                                                    // 43
  return parseInt(self._str.substr(0, 8), 16);                                                        // 44
};                                                                                                    // 45
                                                                                                      // 46
MongoID.ObjectID.prototype.valueOf =                                                                  // 47
    MongoID.ObjectID.prototype.toJSONValue =                                                          // 48
    MongoID.ObjectID.prototype.toHexString =                                                          // 49
    function () { return this._str; };                                                                // 50
                                                                                                      // 51
EJSON.addType("oid",  function (str) {                                                                // 52
  return new MongoID.ObjectID(str);                                                                   // 53
});                                                                                                   // 54
                                                                                                      // 55
MongoID.idStringify = function (id) {                                                                 // 56
  if (id instanceof MongoID.ObjectID) {                                                               // 57
    return id.valueOf();                                                                              // 58
  } else if (typeof id === 'string') {                                                                // 59
    if (id === "") {                                                                                  // 60
      return id;                                                                                      // 61
    } else if (id.substr(0, 1) === "-" || // escape previously dashed strings                         // 62
               id.substr(0, 1) === "~" || // escape escaped numbers, true, false                      // 63
               MongoID._looksLikeObjectID(id) || // escape object-id-form strings                     // 64
               id.substr(0, 1) === '{') { // escape object-form strings, for maybe implementing later
      return "-" + id;                                                                                // 66
    } else {                                                                                          // 67
      return id; // other strings go through unchanged.                                               // 68
    }                                                                                                 // 69
  } else if (id === undefined) {                                                                      // 70
    return '-';                                                                                       // 71
  } else if (typeof id === 'object' && id !== null) {                                                 // 72
    throw new Error("Meteor does not currently support objects other than ObjectID as ids");          // 73
  } else { // Numbers, true, false, null                                                              // 74
    return "~" + JSON.stringify(id);                                                                  // 75
  }                                                                                                   // 76
};                                                                                                    // 77
                                                                                                      // 78
                                                                                                      // 79
MongoID.idParse = function (id) {                                                                     // 80
  if (id === "") {                                                                                    // 81
    return id;                                                                                        // 82
  } else if (id === '-') {                                                                            // 83
    return undefined;                                                                                 // 84
  } else if (id.substr(0, 1) === '-') {                                                               // 85
    return id.substr(1);                                                                              // 86
  } else if (id.substr(0, 1) === '~') {                                                               // 87
    return JSON.parse(id.substr(1));                                                                  // 88
  } else if (MongoID._looksLikeObjectID(id)) {                                                        // 89
    return new MongoID.ObjectID(id);                                                                  // 90
  } else {                                                                                            // 91
    return id;                                                                                        // 92
  }                                                                                                   // 93
};                                                                                                    // 94
                                                                                                      // 95
                                                                                                      // 96
////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['mongo-id'] = {
  MongoID: MongoID
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var _ = Package.underscore._;
var EJSON = Package.ejson.EJSON;

/* Package-scope variables */
var DiffSequence;

(function(){

/////////////////////////////////////////////////////////////////////////////////////
//                                                                                 //
// packages/diff-sequence/diff.js                                                  //
//                                                                                 //
/////////////////////////////////////////////////////////////////////////////////////
                                                                                   //
DiffSequence = {};                                                                 // 1
                                                                                   // 2
// ordered: bool.                                                                  // 3
// old_results and new_results: collections of documents.                          // 4
//    if ordered, they are arrays.                                                 // 5
//    if unordered, they are IdMaps                                                // 6
DiffSequence.diffQueryChanges = function (ordered, oldResults, newResults,         // 7
                                              observer, options) {                 // 8
  if (ordered)                                                                     // 9
    DiffSequence.diffQueryOrderedChanges(                                          // 10
      oldResults, newResults, observer, options);                                  // 11
  else                                                                             // 12
    DiffSequence.diffQueryUnorderedChanges(                                        // 13
      oldResults, newResults, observer, options);                                  // 14
};                                                                                 // 15
                                                                                   // 16
DiffSequence.diffQueryUnorderedChanges = function (oldResults, newResults,         // 17
                                                       observer, options) {        // 18
  options = options || {};                                                         // 19
  var projectionFn = options.projectionFn || EJSON.clone;                          // 20
                                                                                   // 21
  if (observer.movedBefore) {                                                      // 22
    throw new Error("_diffQueryUnordered called with a movedBefore observer!");    // 23
  }                                                                                // 24
                                                                                   // 25
  newResults.forEach(function (newDoc, id) {                                       // 26
    var oldDoc = oldResults.get(id);                                               // 27
    if (oldDoc) {                                                                  // 28
      if (observer.changed && !EJSON.equals(oldDoc, newDoc)) {                     // 29
        var projectedNew = projectionFn(newDoc);                                   // 30
        var projectedOld = projectionFn(oldDoc);                                   // 31
        var changedFields =                                                        // 32
              DiffSequence.makeChangedFields(projectedNew, projectedOld);          // 33
        if (! _.isEmpty(changedFields)) {                                          // 34
          observer.changed(id, changedFields);                                     // 35
        }                                                                          // 36
      }                                                                            // 37
    } else if (observer.added) {                                                   // 38
      var fields = projectionFn(newDoc);                                           // 39
      delete fields._id;                                                           // 40
      observer.added(newDoc._id, fields);                                          // 41
    }                                                                              // 42
  });                                                                              // 43
                                                                                   // 44
  if (observer.removed) {                                                          // 45
    oldResults.forEach(function (oldDoc, id) {                                     // 46
      if (!newResults.has(id))                                                     // 47
        observer.removed(id);                                                      // 48
    });                                                                            // 49
  }                                                                                // 50
};                                                                                 // 51
                                                                                   // 52
                                                                                   // 53
DiffSequence.diffQueryOrderedChanges = function (old_results, new_results,         // 54
                                                     observer, options) {          // 55
  options = options || {};                                                         // 56
  var projectionFn = options.projectionFn || EJSON.clone;                          // 57
                                                                                   // 58
  var new_presence_of_id = {};                                                     // 59
  _.each(new_results, function (doc) {                                             // 60
    if (new_presence_of_id[doc._id])                                               // 61
      Meteor._debug("Duplicate _id in new_results");                               // 62
    new_presence_of_id[doc._id] = true;                                            // 63
  });                                                                              // 64
                                                                                   // 65
  var old_index_of_id = {};                                                        // 66
  _.each(old_results, function (doc, i) {                                          // 67
    if (doc._id in old_index_of_id)                                                // 68
      Meteor._debug("Duplicate _id in old_results");                               // 69
    old_index_of_id[doc._id] = i;                                                  // 70
  });                                                                              // 71
                                                                                   // 72
  // ALGORITHM:                                                                    // 73
  //                                                                               // 74
  // To determine which docs should be considered "moved" (and which               // 75
  // merely change position because of other docs moving) we run                   // 76
  // a "longest common subsequence" (LCS) algorithm.  The LCS of the               // 77
  // old doc IDs and the new doc IDs gives the docs that should NOT be             // 78
  // considered moved.                                                             // 79
                                                                                   // 80
  // To actually call the appropriate callbacks to get from the old state to the   // 81
  // new state:                                                                    // 82
                                                                                   // 83
  // First, we call removed() on all the items that only appear in the old         // 84
  // state.                                                                        // 85
                                                                                   // 86
  // Then, once we have the items that should not move, we walk through the new    // 87
  // results array group-by-group, where a "group" is a set of items that have     // 88
  // moved, anchored on the end by an item that should not move.  One by one, we   // 89
  // move each of those elements into place "before" the anchoring end-of-group    // 90
  // item, and fire changed events on them if necessary.  Then we fire a changed   // 91
  // event on the anchor, and move on to the next group.  There is always at       // 92
  // least one group; the last group is anchored by a virtual "null" id at the     // 93
  // end.                                                                          // 94
                                                                                   // 95
  // Asymptotically: O(N k) where k is number of ops, or potentially               // 96
  // O(N log N) if inner loop of LCS were made to be binary search.                // 97
                                                                                   // 98
                                                                                   // 99
  //////// LCS (longest common sequence, with respect to _id)                      // 100
  // (see Wikipedia article on Longest Increasing Subsequence,                     // 101
  // where the LIS is taken of the sequence of old indices of the                  // 102
  // docs in new_results)                                                          // 103
  //                                                                               // 104
  // unmoved: the output of the algorithm; members of the LCS,                     // 105
  // in the form of indices into new_results                                       // 106
  var unmoved = [];                                                                // 107
  // max_seq_len: length of LCS found so far                                       // 108
  var max_seq_len = 0;                                                             // 109
  // seq_ends[i]: the index into new_results of the last doc in a                  // 110
  // common subsequence of length of i+1 <= max_seq_len                            // 111
  var N = new_results.length;                                                      // 112
  var seq_ends = new Array(N);                                                     // 113
  // ptrs:  the common subsequence ending with new_results[n] extends              // 114
  // a common subsequence ending with new_results[ptr[n]], unless                  // 115
  // ptr[n] is -1.                                                                 // 116
  var ptrs = new Array(N);                                                         // 117
  // virtual sequence of old indices of new results                                // 118
  var old_idx_seq = function(i_new) {                                              // 119
    return old_index_of_id[new_results[i_new]._id];                                // 120
  };                                                                               // 121
  // for each item in new_results, use it to extend a common subsequence           // 122
  // of length j <= max_seq_len                                                    // 123
  for(var i=0; i<N; i++) {                                                         // 124
    if (old_index_of_id[new_results[i]._id] !== undefined) {                       // 125
      var j = max_seq_len;                                                         // 126
      // this inner loop would traditionally be a binary search,                   // 127
      // but scanning backwards we will likely find a subseq to extend             // 128
      // pretty soon, bounded for example by the total number of ops.              // 129
      // If this were to be changed to a binary search, we'd still want            // 130
      // to scan backwards a bit as an optimization.                               // 131
      while (j > 0) {                                                              // 132
        if (old_idx_seq(seq_ends[j-1]) < old_idx_seq(i))                           // 133
          break;                                                                   // 134
        j--;                                                                       // 135
      }                                                                            // 136
                                                                                   // 137
      ptrs[i] = (j === 0 ? -1 : seq_ends[j-1]);                                    // 138
      seq_ends[j] = i;                                                             // 139
      if (j+1 > max_seq_len)                                                       // 140
        max_seq_len = j+1;                                                         // 141
    }                                                                              // 142
  }                                                                                // 143
                                                                                   // 144
  // pull out the LCS/LIS into unmoved                                             // 145
  var idx = (max_seq_len === 0 ? -1 : seq_ends[max_seq_len-1]);                    // 146
  while (idx >= 0) {                                                               // 147
    unmoved.push(idx);                                                             // 148
    idx = ptrs[idx];                                                               // 149
  }                                                                                // 150
  // the unmoved item list is built backwards, so fix that                         // 151
  unmoved.reverse();                                                               // 152
                                                                                   // 153
  // the last group is always anchored by the end of the result list, which is     // 154
  // an id of "null"                                                               // 155
  unmoved.push(new_results.length);                                                // 156
                                                                                   // 157
  _.each(old_results, function (doc) {                                             // 158
    if (!new_presence_of_id[doc._id])                                              // 159
      observer.removed && observer.removed(doc._id);                               // 160
  });                                                                              // 161
  // for each group of things in the new_results that is anchored by an unmoved    // 162
  // element, iterate through the things before it.                                // 163
  var startOfGroup = 0;                                                            // 164
  _.each(unmoved, function (endOfGroup) {                                          // 165
    var groupId = new_results[endOfGroup] ? new_results[endOfGroup]._id : null;    // 166
    var oldDoc, newDoc, fields, projectedNew, projectedOld;                        // 167
    for (var i = startOfGroup; i < endOfGroup; i++) {                              // 168
      newDoc = new_results[i];                                                     // 169
      if (!_.has(old_index_of_id, newDoc._id)) {                                   // 170
        fields = projectionFn(newDoc);                                             // 171
        delete fields._id;                                                         // 172
        observer.addedBefore && observer.addedBefore(newDoc._id, fields, groupId);
        observer.added && observer.added(newDoc._id, fields);                      // 174
      } else {                                                                     // 175
        // moved                                                                   // 176
        oldDoc = old_results[old_index_of_id[newDoc._id]];                         // 177
        projectedNew = projectionFn(newDoc);                                       // 178
        projectedOld = projectionFn(oldDoc);                                       // 179
        fields = DiffSequence.makeChangedFields(projectedNew, projectedOld);       // 180
        if (!_.isEmpty(fields)) {                                                  // 181
          observer.changed && observer.changed(newDoc._id, fields);                // 182
        }                                                                          // 183
        observer.movedBefore && observer.movedBefore(newDoc._id, groupId);         // 184
      }                                                                            // 185
    }                                                                              // 186
    if (groupId) {                                                                 // 187
      newDoc = new_results[endOfGroup];                                            // 188
      oldDoc = old_results[old_index_of_id[newDoc._id]];                           // 189
      projectedNew = projectionFn(newDoc);                                         // 190
      projectedOld = projectionFn(oldDoc);                                         // 191
      fields = DiffSequence.makeChangedFields(projectedNew, projectedOld);         // 192
      if (!_.isEmpty(fields)) {                                                    // 193
        observer.changed && observer.changed(newDoc._id, fields);                  // 194
      }                                                                            // 195
    }                                                                              // 196
    startOfGroup = endOfGroup+1;                                                   // 197
  });                                                                              // 198
                                                                                   // 199
                                                                                   // 200
};                                                                                 // 201
                                                                                   // 202
                                                                                   // 203
// General helper for diff-ing two objects.                                        // 204
// callbacks is an object like so:                                                 // 205
// { leftOnly: function (key, leftValue) {...},                                    // 206
//   rightOnly: function (key, rightValue) {...},                                  // 207
//   both: function (key, leftValue, rightValue) {...},                            // 208
// }                                                                               // 209
DiffSequence.diffObjects = function (left, right, callbacks) {                     // 210
  _.each(left, function (leftValue, key) {                                         // 211
    if (_.has(right, key))                                                         // 212
      callbacks.both && callbacks.both(key, leftValue, right[key]);                // 213
    else                                                                           // 214
      callbacks.leftOnly && callbacks.leftOnly(key, leftValue);                    // 215
  });                                                                              // 216
  if (callbacks.rightOnly) {                                                       // 217
    _.each(right, function(rightValue, key) {                                      // 218
      if (!_.has(left, key))                                                       // 219
        callbacks.rightOnly(key, rightValue);                                      // 220
    });                                                                            // 221
  }                                                                                // 222
};                                                                                 // 223
                                                                                   // 224
                                                                                   // 225
DiffSequence.makeChangedFields = function (newDoc, oldDoc) {                       // 226
  var fields = {};                                                                 // 227
  DiffSequence.diffObjects(oldDoc, newDoc, {                                       // 228
    leftOnly: function (key, value) {                                              // 229
      fields[key] = undefined;                                                     // 230
    },                                                                             // 231
    rightOnly: function (key, value) {                                             // 232
      fields[key] = value;                                                         // 233
    },                                                                             // 234
    both: function (key, leftValue, rightValue) {                                  // 235
      if (!EJSON.equals(leftValue, rightValue))                                    // 236
        fields[key] = rightValue;                                                  // 237
    }                                                                              // 238
  });                                                                              // 239
  return fields;                                                                   // 240
};                                                                                 // 241
                                                                                   // 242
DiffSequence.applyChanges = function (doc, changeFields) {                         // 243
  _.each(changeFields, function (value, key) {                                     // 244
    if (value === undefined)                                                       // 245
      delete doc[key];                                                             // 246
    else                                                                           // 247
      doc[key] = value;                                                            // 248
  });                                                                              // 249
};                                                                                 // 250
                                                                                   // 251
                                                                                   // 252
/////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['diff-sequence'] = {
  DiffSequence: DiffSequence
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var Tracker = Package.tracker.Tracker;
var Deps = Package.tracker.Deps;
var MongoID = Package['mongo-id'].MongoID;
var DiffSequence = Package['diff-sequence'].DiffSequence;
var _ = Package.underscore._;
var Random = Package.random.Random;

/* Package-scope variables */
var ObserveSequence, seqChangedToEmpty, seqChangedToArray, seqChangedToCursor;

(function(){

///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
// packages/observe-sequence/observe_sequence.js                                 //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////
                                                                                 //
var warn = function () {                                                         // 1
  if (ObserveSequence._suppressWarnings) {                                       // 2
    ObserveSequence._suppressWarnings--;                                         // 3
  } else {                                                                       // 4
    if (typeof console !== 'undefined' && console.warn)                          // 5
      console.warn.apply(console, arguments);                                    // 6
                                                                                 // 7
    ObserveSequence._loggedWarnings++;                                           // 8
  }                                                                              // 9
};                                                                               // 10
                                                                                 // 11
var idStringify = MongoID.idStringify;                                           // 12
var idParse = MongoID.idParse;                                                   // 13
                                                                                 // 14
ObserveSequence = {                                                              // 15
  _suppressWarnings: 0,                                                          // 16
  _loggedWarnings: 0,                                                            // 17
                                                                                 // 18
  // A mechanism similar to cursor.observe which receives a reactive             // 19
  // function returning a sequence type and firing appropriate callbacks         // 20
  // when the value changes.                                                     // 21
  //                                                                             // 22
  // @param sequenceFunc {Function} a reactive function returning a              // 23
  //     sequence type. The currently supported sequence types are:              // 24
  //     Array, Cursor, and null.                                                // 25
  //                                                                             // 26
  // @param callbacks {Object} similar to a specific subset of                   // 27
  //     callbacks passed to `cursor.observe`                                    // 28
  //     (http://docs.meteor.com/#observe), with minor variations to             // 29
  //     support the fact that not all sequences contain objects with            // 30
  //     _id fields.  Specifically:                                              // 31
  //                                                                             // 32
  //     * addedAt(id, item, atIndex, beforeId)                                  // 33
  //     * changedAt(id, newItem, oldItem, atIndex)                              // 34
  //     * removedAt(id, oldItem, atIndex)                                       // 35
  //     * movedTo(id, item, fromIndex, toIndex, beforeId)                       // 36
  //                                                                             // 37
  // @returns {Object(stop: Function)} call 'stop' on the return value           // 38
  //     to stop observing this sequence function.                               // 39
  //                                                                             // 40
  // We don't make any assumptions about our ability to compare sequence         // 41
  // elements (ie, we don't assume EJSON.equals works; maybe there is extra      // 42
  // state/random methods on the objects) so unlike cursor.observe, we may       // 43
  // sometimes call changedAt() when nothing actually changed.                   // 44
  // XXX consider if we *can* make the stronger assumption and avoid             // 45
  //     no-op changedAt calls (in some cases?)                                  // 46
  //                                                                             // 47
  // XXX currently only supports the callbacks used by our                       // 48
  // implementation of {{#each}}, but this can be expanded.                      // 49
  //                                                                             // 50
  // XXX #each doesn't use the indices (though we'll eventually need             // 51
  // a way to get them when we support `@index`), but calling                    // 52
  // `cursor.observe` causes the index to be calculated on every                 // 53
  // callback using a linear scan (unless you turn it off by passing             // 54
  // `_no_indices`).  Any way to avoid calculating indices on a pure             // 55
  // cursor observe like we used to?                                             // 56
  observe: function (sequenceFunc, callbacks) {                                  // 57
    var lastSeq = null;                                                          // 58
    var activeObserveHandle = null;                                              // 59
                                                                                 // 60
    // 'lastSeqArray' contains the previous value of the sequence                // 61
    // we're observing. It is an array of objects with '_id' and                 // 62
    // 'item' fields.  'item' is the element in the array, or the                // 63
    // document in the cursor.                                                   // 64
    //                                                                           // 65
    // '_id' is whichever of the following is relevant, unless it has            // 66
    // already appeared -- in which case it's randomly generated.                // 67
    //                                                                           // 68
    // * if 'item' is an object:                                                 // 69
    //   * an '_id' field, if present                                            // 70
    //   * otherwise, the index in the array                                     // 71
    //                                                                           // 72
    // * if 'item' is a number or string, use that value                         // 73
    //                                                                           // 74
    // XXX this can be generalized by allowing {{#each}} to accept a             // 75
    // general 'key' argument which could be a function, a dotted                // 76
    // field name, or the special @index value.                                  // 77
    var lastSeqArray = []; // elements are objects of form {_id, item}           // 78
    var computation = Tracker.autorun(function () {                              // 79
      var seq = sequenceFunc();                                                  // 80
                                                                                 // 81
      Tracker.nonreactive(function () {                                          // 82
        var seqArray; // same structure as `lastSeqArray` above.                 // 83
                                                                                 // 84
        if (activeObserveHandle) {                                               // 85
          // If we were previously observing a cursor, replace lastSeqArray with
          // more up-to-date information.  Then stop the old observe.            // 87
          lastSeqArray = _.map(lastSeq.fetch(), function (doc) {                 // 88
            return {_id: doc._id, item: doc};                                    // 89
          });                                                                    // 90
          activeObserveHandle.stop();                                            // 91
          activeObserveHandle = null;                                            // 92
        }                                                                        // 93
                                                                                 // 94
        if (!seq) {                                                              // 95
          seqArray = seqChangedToEmpty(lastSeqArray, callbacks);                 // 96
        } else if (seq instanceof Array) {                                       // 97
          seqArray = seqChangedToArray(lastSeqArray, seq, callbacks);            // 98
        } else if (isStoreCursor(seq)) {                                         // 99
          var result /* [seqArray, activeObserveHandle] */ =                     // 100
                seqChangedToCursor(lastSeqArray, seq, callbacks);                // 101
          seqArray = result[0];                                                  // 102
          activeObserveHandle = result[1];                                       // 103
        } else {                                                                 // 104
          throw badSequenceError();                                              // 105
        }                                                                        // 106
                                                                                 // 107
        diffArray(lastSeqArray, seqArray, callbacks);                            // 108
        lastSeq = seq;                                                           // 109
        lastSeqArray = seqArray;                                                 // 110
      });                                                                        // 111
    });                                                                          // 112
                                                                                 // 113
    return {                                                                     // 114
      stop: function () {                                                        // 115
        computation.stop();                                                      // 116
        if (activeObserveHandle)                                                 // 117
          activeObserveHandle.stop();                                            // 118
      }                                                                          // 119
    };                                                                           // 120
  },                                                                             // 121
                                                                                 // 122
  // Fetch the items of `seq` into an array, where `seq` is of one of the        // 123
  // sequence types accepted by `observe`.  If `seq` is a cursor, a              // 124
  // dependency is established.                                                  // 125
  fetch: function (seq) {                                                        // 126
    if (!seq) {                                                                  // 127
      return [];                                                                 // 128
    } else if (seq instanceof Array) {                                           // 129
      return seq;                                                                // 130
    } else if (isStoreCursor(seq)) {                                             // 131
      return seq.fetch();                                                        // 132
    } else {                                                                     // 133
      throw badSequenceError();                                                  // 134
    }                                                                            // 135
  }                                                                              // 136
};                                                                               // 137
                                                                                 // 138
var badSequenceError = function () {                                             // 139
  return new Error("{{#each}} currently only accepts " +                         // 140
                   "arrays, cursors or falsey values.");                         // 141
};                                                                               // 142
                                                                                 // 143
var isStoreCursor = function (cursor) {                                          // 144
  return cursor && _.isObject(cursor) &&                                         // 145
    _.isFunction(cursor.observe) && _.isFunction(cursor.fetch);                  // 146
};                                                                               // 147
                                                                                 // 148
// Calculates the differences between `lastSeqArray` and                         // 149
// `seqArray` and calls appropriate functions from `callbacks`.                  // 150
// Reuses Minimongo's diff algorithm implementation.                             // 151
var diffArray = function (lastSeqArray, seqArray, callbacks) {                   // 152
  var diffFn = Package['diff-sequence'].DiffSequence.diffQueryOrderedChanges;    // 153
  var oldIdObjects = [];                                                         // 154
  var newIdObjects = [];                                                         // 155
  var posOld = {}; // maps from idStringify'd ids                                // 156
  var posNew = {}; // ditto                                                      // 157
  var posCur = {};                                                               // 158
  var lengthCur = lastSeqArray.length;                                           // 159
                                                                                 // 160
  _.each(seqArray, function (doc, i) {                                           // 161
    newIdObjects.push({_id: doc._id});                                           // 162
    posNew[idStringify(doc._id)] = i;                                            // 163
  });                                                                            // 164
  _.each(lastSeqArray, function (doc, i) {                                       // 165
    oldIdObjects.push({_id: doc._id});                                           // 166
    posOld[idStringify(doc._id)] = i;                                            // 167
    posCur[idStringify(doc._id)] = i;                                            // 168
  });                                                                            // 169
                                                                                 // 170
  // Arrays can contain arbitrary objects. We don't diff the                     // 171
  // objects. Instead we always fire 'changedAt' callback on every               // 172
  // object. The consumer of `observe-sequence` should deal with                 // 173
  // it appropriately.                                                           // 174
  diffFn(oldIdObjects, newIdObjects, {                                           // 175
    addedBefore: function (id, doc, before) {                                    // 176
      var position = before ? posCur[idStringify(before)] : lengthCur;           // 177
                                                                                 // 178
      if (before) {                                                              // 179
        // If not adding at the end, we need to update indexes.                  // 180
        // XXX this can still be improved greatly!                               // 181
        _.each(posCur, function (pos, id) {                                      // 182
          if (pos >= position)                                                   // 183
            posCur[id]++;                                                        // 184
        });                                                                      // 185
      }                                                                          // 186
                                                                                 // 187
      lengthCur++;                                                               // 188
      posCur[idStringify(id)] = position;                                        // 189
                                                                                 // 190
      callbacks.addedAt(                                                         // 191
        id,                                                                      // 192
        seqArray[posNew[idStringify(id)]].item,                                  // 193
        position,                                                                // 194
        before);                                                                 // 195
    },                                                                           // 196
    movedBefore: function (id, before) {                                         // 197
      if (id === before)                                                         // 198
        return;                                                                  // 199
                                                                                 // 200
      var oldPosition = posCur[idStringify(id)];                                 // 201
      var newPosition = before ? posCur[idStringify(before)] : lengthCur;        // 202
                                                                                 // 203
      // Moving the item forward. The new element is losing one position as it   // 204
      // was removed from the old position before being inserted at the new      // 205
      // position.                                                               // 206
      // Ex.:   0  *1*  2   3   4                                                // 207
      //        0   2   3  *1*  4                                                // 208
      // The original issued callback is "1" before "4".                         // 209
      // The position of "1" is 1, the position of "4" is 4.                     // 210
      // The generated move is (1) -> (3)                                        // 211
      if (newPosition > oldPosition) {                                           // 212
        newPosition--;                                                           // 213
      }                                                                          // 214
                                                                                 // 215
      // Fix up the positions of elements between the old and the new positions  // 216
      // of the moved element.                                                   // 217
      //                                                                         // 218
      // There are two cases:                                                    // 219
      //   1. The element is moved forward. Then all the positions in between    // 220
      //   are moved back.                                                       // 221
      //   2. The element is moved back. Then the positions in between *and* the
      //   element that is currently standing on the moved element's future      // 223
      //   position are moved forward.                                           // 224
      _.each(posCur, function (elCurPosition, id) {                              // 225
        if (oldPosition < elCurPosition && elCurPosition < newPosition)          // 226
          posCur[id]--;                                                          // 227
        else if (newPosition <= elCurPosition && elCurPosition < oldPosition)    // 228
          posCur[id]++;                                                          // 229
      });                                                                        // 230
                                                                                 // 231
      // Finally, update the position of the moved element.                      // 232
      posCur[idStringify(id)] = newPosition;                                     // 233
                                                                                 // 234
      callbacks.movedTo(                                                         // 235
        id,                                                                      // 236
        seqArray[posNew[idStringify(id)]].item,                                  // 237
        oldPosition,                                                             // 238
        newPosition,                                                             // 239
        before);                                                                 // 240
    },                                                                           // 241
    removed: function (id) {                                                     // 242
      var prevPosition = posCur[idStringify(id)];                                // 243
                                                                                 // 244
      _.each(posCur, function (pos, id) {                                        // 245
        if (pos >= prevPosition)                                                 // 246
          posCur[id]--;                                                          // 247
      });                                                                        // 248
                                                                                 // 249
      delete posCur[idStringify(id)];                                            // 250
      lengthCur--;                                                               // 251
                                                                                 // 252
      callbacks.removedAt(                                                       // 253
        id,                                                                      // 254
        lastSeqArray[posOld[idStringify(id)]].item,                              // 255
        prevPosition);                                                           // 256
    }                                                                            // 257
  });                                                                            // 258
                                                                                 // 259
  _.each(posNew, function (pos, idString) {                                      // 260
    var id = idParse(idString);                                                  // 261
    if (_.has(posOld, idString)) {                                               // 262
      // specifically for primitive types, compare equality before               // 263
      // firing the 'changedAt' callback. otherwise, always fire it              // 264
      // because doing a deep EJSON comparison is not guaranteed to              // 265
      // work (an array can contain arbitrary objects, and 'transform'           // 266
      // can be used on cursors). also, deep diffing is not                      // 267
      // necessarily the most efficient (if only a specific subfield             // 268
      // of the object is later accessed).                                       // 269
      var newItem = seqArray[pos].item;                                          // 270
      var oldItem = lastSeqArray[posOld[idString]].item;                         // 271
                                                                                 // 272
      if (typeof newItem === 'object' || newItem !== oldItem)                    // 273
          callbacks.changedAt(id, newItem, oldItem, pos);                        // 274
      }                                                                          // 275
  });                                                                            // 276
};                                                                               // 277
                                                                                 // 278
seqChangedToEmpty = function (lastSeqArray, callbacks) {                         // 279
  return [];                                                                     // 280
};                                                                               // 281
                                                                                 // 282
seqChangedToArray = function (lastSeqArray, array, callbacks) {                  // 283
  var idsUsed = {};                                                              // 284
  var seqArray = _.map(array, function (item, index) {                           // 285
    var id;                                                                      // 286
    if (typeof item === 'string') {                                              // 287
      // ensure not empty, since other layers (eg DomRange) assume this as well  // 288
      id = "-" + item;                                                           // 289
    } else if (typeof item === 'number' ||                                       // 290
               typeof item === 'boolean' ||                                      // 291
               item === undefined) {                                             // 292
      id = item;                                                                 // 293
    } else if (typeof item === 'object') {                                       // 294
      id = (item && _.has(item, '_id')) ? item._id : index;                      // 295
    } else {                                                                     // 296
      throw new Error("{{#each}} doesn't support arrays with " +                 // 297
                      "elements of type " + typeof item);                        // 298
    }                                                                            // 299
                                                                                 // 300
    var idString = idStringify(id);                                              // 301
    if (idsUsed[idString]) {                                                     // 302
      if (typeof item === 'object' && '_id' in item)                             // 303
        warn("duplicate id " + id + " in", array);                               // 304
      id = Random.id();                                                          // 305
    } else {                                                                     // 306
      idsUsed[idString] = true;                                                  // 307
    }                                                                            // 308
                                                                                 // 309
    return { _id: id, item: item };                                              // 310
  });                                                                            // 311
                                                                                 // 312
  return seqArray;                                                               // 313
};                                                                               // 314
                                                                                 // 315
seqChangedToCursor = function (lastSeqArray, cursor, callbacks) {                // 316
  var initial = true; // are we observing initial data from cursor?              // 317
  var seqArray = [];                                                             // 318
                                                                                 // 319
  var observeHandle = cursor.observe({                                           // 320
    addedAt: function (document, atIndex, before) {                              // 321
      if (initial) {                                                             // 322
        // keep track of initial data so that we can diff once                   // 323
        // we exit `observe`.                                                    // 324
        if (before !== null)                                                     // 325
          throw new Error("Expected initial data from observe in order");        // 326
        seqArray.push({ _id: document._id, item: document });                    // 327
      } else {                                                                   // 328
        callbacks.addedAt(document._id, document, atIndex, before);              // 329
      }                                                                          // 330
    },                                                                           // 331
    changedAt: function (newDocument, oldDocument, atIndex) {                    // 332
      callbacks.changedAt(newDocument._id, newDocument, oldDocument,             // 333
                          atIndex);                                              // 334
    },                                                                           // 335
    removedAt: function (oldDocument, atIndex) {                                 // 336
      callbacks.removedAt(oldDocument._id, oldDocument, atIndex);                // 337
    },                                                                           // 338
    movedTo: function (document, fromIndex, toIndex, before) {                   // 339
      callbacks.movedTo(                                                         // 340
        document._id, document, fromIndex, toIndex, before);                     // 341
    }                                                                            // 342
  });                                                                            // 343
  initial = false;                                                               // 344
                                                                                 // 345
  return [seqArray, observeHandle];                                              // 346
};                                                                               // 347
                                                                                 // 348
///////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['observe-sequence'] = {
  ObserveSequence: ObserveSequence
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;

/* Package-scope variables */
var ECMAScript;



/* Exports */
if (typeof Package === 'undefined') Package = {};
Package.ecmascript = {
  ECMAScript: ECMAScript
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;

/* Package-scope variables */
var babelHelpers;

(function(){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                         //
// packages/babel-runtime/babel-runtime.js                                                                 //
//                                                                                                         //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                           //
var hasOwn = Object.prototype.hasOwnProperty;                                                              // 1
                                                                                                           // 2
function canDefineNonEnumerableProperties() {                                                              // 3
  var testObj = {};                                                                                        // 4
  var testPropName = "t";                                                                                  // 5
                                                                                                           // 6
  try {                                                                                                    // 7
    Object.defineProperty(testObj, testPropName, {                                                         // 8
      enumerable: false,                                                                                   // 9
      value: testObj                                                                                       // 10
    });                                                                                                    // 11
                                                                                                           // 12
    for (var k in testObj) {                                                                               // 13
      if (k === testPropName) {                                                                            // 14
        return false;                                                                                      // 15
      }                                                                                                    // 16
    }                                                                                                      // 17
  } catch (e) {                                                                                            // 18
    return false;                                                                                          // 19
  }                                                                                                        // 20
                                                                                                           // 21
  return testObj[testPropName] === testObj;                                                                // 22
}                                                                                                          // 23
                                                                                                           // 24
// The name `babelHelpers` is hard-coded in Babel.  Otherwise we would make it                             // 25
// something capitalized and more descriptive, like `BabelRuntime`.                                        // 26
babelHelpers = {                                                                                           // 27
  // Meteor-specific runtime helper for wrapping the object of for-in                                      // 28
  // loops, so that inherited Array methods defined by es5-shim can be                                     // 29
  // ignored in browsers where they cannot be defined as non-enumerable.                                   // 30
  sanitizeForInObject: canDefineNonEnumerableProperties()                                                  // 31
    ? function (value) { return value; }                                                                   // 32
    : function (obj) {                                                                                     // 33
      if (Array.isArray(obj)) {                                                                            // 34
        var newObj = {};                                                                                   // 35
        var keys = Object.keys(obj);                                                                       // 36
        var keyCount = keys.length;                                                                        // 37
        for (var i = 0; i < keyCount; ++i) {                                                               // 38
          var key = keys[i];                                                                               // 39
          newObj[key] = obj[key];                                                                          // 40
        }                                                                                                  // 41
        return newObj;                                                                                     // 42
      }                                                                                                    // 43
                                                                                                           // 44
      return obj;                                                                                          // 45
    },                                                                                                     // 46
                                                                                                           // 47
  // es6.templateLiterals                                                                                  // 48
  // Constructs the object passed to the tag function in a tagged                                          // 49
  // template literal.                                                                                     // 50
  taggedTemplateLiteralLoose: function (strings, raw) {                                                    // 51
    // Babel's own version of this calls Object.freeze on `strings` and                                    // 52
    // `strings.raw`, but it doesn't seem worth the compatibility and                                      // 53
    // performance concerns.  If you're writing code against this helper,                                  // 54
    // don't add properties to these objects.                                                              // 55
    strings.raw = raw;                                                                                     // 56
    return strings;                                                                                        // 57
  },                                                                                                       // 58
                                                                                                           // 59
  // es6.classes                                                                                           // 60
  // Checks that a class constructor is being called with `new`, and throws                                // 61
  // an error if it is not.                                                                                // 62
  classCallCheck: function (instance, Constructor) {                                                       // 63
    if (!(instance instanceof Constructor)) {                                                              // 64
      throw new TypeError("Cannot call a class as a function");                                            // 65
    }                                                                                                      // 66
  },                                                                                                       // 67
                                                                                                           // 68
  // es6.classes                                                                                           // 69
  inherits: function (subClass, superClass) {                                                              // 70
    if (typeof superClass !== "function" && superClass !== null) {                                         // 71
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }                                                                                                      // 73
                                                                                                           // 74
    if (superClass) {                                                                                      // 75
      if (Object.create) {                                                                                 // 76
        // All but IE 8                                                                                    // 77
        subClass.prototype = Object.create(superClass.prototype, {                                         // 78
          constructor: {                                                                                   // 79
            value: subClass,                                                                               // 80
            enumerable: false,                                                                             // 81
            writable: true,                                                                                // 82
            configurable: true                                                                             // 83
          }                                                                                                // 84
        });                                                                                                // 85
      } else {                                                                                             // 86
        // IE 8 path.  Slightly worse for modern browsers, because `constructor`                           // 87
        // is enumerable and shows up in the inspector unnecessarily.                                      // 88
        // It's not an "own" property of any instance though.                                              // 89
        //                                                                                                 // 90
        // For correctness when writing code,                                                              // 91
        // don't enumerate all the own-and-inherited properties of an instance                             // 92
        // of a class and expect not to find `constructor` (but who does that?).                           // 93
        var F = function () {                                                                              // 94
          this.constructor = subClass;                                                                     // 95
        };                                                                                                 // 96
        F.prototype = superClass.prototype;                                                                // 97
        subClass.prototype = new F();                                                                      // 98
      }                                                                                                    // 99
                                                                                                           // 100
      // For modern browsers, this would be `subClass.__proto__ = superClass`,                             // 101
      // but IE <=10 don't support `__proto__`, and in this case the difference                            // 102
      // would be detectable; code that works in modern browsers could easily                              // 103
      // fail on IE 8 if we ever used the `__proto__` trick.                                               // 104
      //                                                                                                   // 105
      // There's no perfect way to make static methods inherited if they are                               // 106
      // assigned after declaration of the classes.  The best we can do is                                 // 107
      // to copy them.  In other words, when you write `class Foo                                          // 108
      // extends Bar`, we copy the static methods from Bar onto Foo, but future                            // 109
      // ones are not copied.                                                                              // 110
      //                                                                                                   // 111
      // For correctness when writing code, don't add static methods to a class                            // 112
      // after you subclass it.                                                                            // 113
      for (var k in superClass) {                                                                          // 114
        if (hasOwn.call(superClass, k)) {                                                                  // 115
          subClass[k] = superClass[k];                                                                     // 116
        }                                                                                                  // 117
      }                                                                                                    // 118
    }                                                                                                      // 119
  },                                                                                                       // 120
                                                                                                           // 121
  createClass: (function () {                                                                              // 122
    var hasDefineProperty = false;                                                                         // 123
    try {                                                                                                  // 124
      // IE 8 has a broken Object.defineProperty, so feature-test by                                       // 125
      // trying to call it.                                                                                // 126
      Object.defineProperty({}, 'x', {});                                                                  // 127
      hasDefineProperty = true;                                                                            // 128
    } catch (e) {}                                                                                         // 129
                                                                                                           // 130
    function defineProperties(target, props) {                                                             // 131
      for (var i = 0; i < props.length; i++) {                                                             // 132
        var descriptor = props[i];                                                                         // 133
        descriptor.enumerable = descriptor.enumerable || false;                                            // 134
        descriptor.configurable = true;                                                                    // 135
        if ("value" in descriptor) descriptor.writable = true;                                             // 136
        Object.defineProperty(target, descriptor.key, descriptor);                                         // 137
      }                                                                                                    // 138
    }                                                                                                      // 139
                                                                                                           // 140
    return function (Constructor, protoProps, staticProps) {                                               // 141
      if (! hasDefineProperty) {                                                                           // 142
        // e.g. `class Foo { get bar() {} }`.  If you try to use getters and                               // 143
        // setters in IE 8, you will get a big nasty error, with or without                                // 144
        // Babel.  I don't know of any other syntax features besides getters                               // 145
        // and setters that will trigger this error.                                                       // 146
        throw new Error(                                                                                   // 147
          "Your browser does not support this type of class property.  " +                                 // 148
            "For example, Internet Explorer 8 does not support getters and " +                             // 149
            "setters.");                                                                                   // 150
      }                                                                                                    // 151
                                                                                                           // 152
      if (protoProps) defineProperties(Constructor.prototype, protoProps);                                 // 153
      if (staticProps) defineProperties(Constructor, staticProps);                                         // 154
      return Constructor;                                                                                  // 155
    };                                                                                                     // 156
  })(),                                                                                                    // 157
                                                                                                           // 158
  // es7.objectRestSpread and react (JSX)                                                                  // 159
  _extends: Object.assign || (function (target) {                                                          // 160
    for (var i = 1; i < arguments.length; i++) {                                                           // 161
      var source = arguments[i];                                                                           // 162
      for (var key in source) {                                                                            // 163
        if (hasOwn.call(source, key)) {                                                                    // 164
          target[key] = source[key];                                                                       // 165
        }                                                                                                  // 166
      }                                                                                                    // 167
    }                                                                                                      // 168
    return target;                                                                                         // 169
  }),                                                                                                      // 170
                                                                                                           // 171
  // es6.destructuring                                                                                     // 172
  objectWithoutProperties: function (obj, keys) {                                                          // 173
    var target = {};                                                                                       // 174
    outer: for (var i in obj) {                                                                            // 175
      if (! hasOwn.call(obj, i)) continue;                                                                 // 176
      for (var j = 0; j < keys.length; j++) {                                                              // 177
        if (keys[j] === i) continue outer;                                                                 // 178
      }                                                                                                    // 179
      target[i] = obj[i];                                                                                  // 180
    }                                                                                                      // 181
    return target;                                                                                         // 182
  },                                                                                                       // 183
                                                                                                           // 184
  // es6.destructuring                                                                                     // 185
  objectDestructuringEmpty: function (obj) {                                                               // 186
    if (obj == null) throw new TypeError("Cannot destructure undefined");                                  // 187
  },                                                                                                       // 188
                                                                                                           // 189
  // es6.spread                                                                                            // 190
  bind: Function.prototype.bind || (function () {                                                          // 191
    var isCallable = function (value) { return typeof value === 'function'; };                             // 192
    var $Object = Object;                                                                                  // 193
    var to_string = Object.prototype.toString;                                                             // 194
    var array_slice = Array.prototype.slice;                                                               // 195
    var array_concat = Array.prototype.concat;                                                             // 196
    var array_push = Array.prototype.push;                                                                 // 197
    var max = Math.max;                                                                                    // 198
    var Empty = function Empty() {};                                                                       // 199
                                                                                                           // 200
    // Copied from es5-shim.js (3ac7942).  See original for more comments.                                 // 201
    return function bind(that) {                                                                           // 202
      var target = this;                                                                                   // 203
      if (!isCallable(target)) {                                                                           // 204
        throw new TypeError('Function.prototype.bind called on incompatible ' + target);                   // 205
      }                                                                                                    // 206
                                                                                                           // 207
      var args = array_slice.call(arguments, 1);                                                           // 208
                                                                                                           // 209
      var bound;                                                                                           // 210
      var binder = function () {                                                                           // 211
                                                                                                           // 212
        if (this instanceof bound) {                                                                       // 213
          var result = target.apply(                                                                       // 214
            this,                                                                                          // 215
            array_concat.call(args, array_slice.call(arguments))                                           // 216
          );                                                                                               // 217
          if ($Object(result) === result) {                                                                // 218
            return result;                                                                                 // 219
          }                                                                                                // 220
          return this;                                                                                     // 221
        } else {                                                                                           // 222
          return target.apply(                                                                             // 223
            that,                                                                                          // 224
            array_concat.call(args, array_slice.call(arguments))                                           // 225
          );                                                                                               // 226
        }                                                                                                  // 227
      };                                                                                                   // 228
                                                                                                           // 229
      var boundLength = max(0, target.length - args.length);                                               // 230
                                                                                                           // 231
      var boundArgs = [];                                                                                  // 232
      for (var i = 0; i < boundLength; i++) {                                                              // 233
        array_push.call(boundArgs, '$' + i);                                                               // 234
      }                                                                                                    // 235
                                                                                                           // 236
      // Create a Function from source code so that it has the right `.length`.                            // 237
      // Probably not important for Babel.  This code violates CSPs that ban                               // 238
      // `eval`, but the browsers that need this polyfill don't have CSP!                                  // 239
      bound = Function('binder', 'return function (' + boundArgs.join(',') + '){ return binder.apply(this, arguments); }')(binder);
                                                                                                           // 241
      if (target.prototype) {                                                                              // 242
        Empty.prototype = target.prototype;                                                                // 243
        bound.prototype = new Empty();                                                                     // 244
        Empty.prototype = null;                                                                            // 245
      }                                                                                                    // 246
                                                                                                           // 247
      return bound;                                                                                        // 248
    };                                                                                                     // 249
                                                                                                           // 250
  })(),                                                                                                    // 251
                                                                                                           // 252
  slice: Array.prototype.slice                                                                             // 253
};                                                                                                         // 254
                                                                                                           // 255
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['babel-runtime'] = {
  babelHelpers: babelHelpers
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;

/* Package-scope variables */
var Symbol, Map, Set, __g, __e;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                            //
// packages/ecmascript-runtime/.npm/package/node_modules/meteor-ecmascript-runtime/client.js                  //
// This file is in bare mode and is not in its own closure.                                                   //
//                                                                                                            //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                              //
/******/ (function(modules) { // webpackBootstrap                                                             // 1
/******/ 	// The module cache                                                                                 // 2
/******/ 	var installedModules = {};                                                                          // 3
                                                                                                              // 4
/******/ 	// The require function                                                                             // 5
/******/ 	function __webpack_require__(moduleId) {                                                            // 6
                                                                                                              // 7
/******/ 		// Check if module is in cache                                                                     // 8
/******/ 		if(installedModules[moduleId])                                                                     // 9
/******/ 			return installedModules[moduleId].exports;                                                        // 10
                                                                                                              // 11
/******/ 		// Create a new module (and put it into the cache)                                                 // 12
/******/ 		var module = installedModules[moduleId] = {                                                        // 13
/******/ 			exports: {},                                                                                      // 14
/******/ 			id: moduleId,                                                                                     // 15
/******/ 			loaded: false                                                                                     // 16
/******/ 		};                                                                                                 // 17
                                                                                                              // 18
/******/ 		// Execute the module function                                                                     // 19
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);               // 20
                                                                                                              // 21
/******/ 		// Flag the module as loaded                                                                       // 22
/******/ 		module.loaded = true;                                                                              // 23
                                                                                                              // 24
/******/ 		// Return the exports of the module                                                                // 25
/******/ 		return module.exports;                                                                             // 26
/******/ 	}                                                                                                   // 27
                                                                                                              // 28
                                                                                                              // 29
/******/ 	// expose the modules object (__webpack_modules__)                                                  // 30
/******/ 	__webpack_require__.m = modules;                                                                    // 31
                                                                                                              // 32
/******/ 	// expose the module cache                                                                          // 33
/******/ 	__webpack_require__.c = installedModules;                                                           // 34
                                                                                                              // 35
/******/ 	// __webpack_public_path__                                                                          // 36
/******/ 	__webpack_require__.p = "";                                                                         // 37
                                                                                                              // 38
/******/ 	// Load entry module and return exports                                                             // 39
/******/ 	return __webpack_require__(0);                                                                      // 40
/******/ })                                                                                                   // 41
/************************************************************************/                                    // 42
/******/ ([                                                                                                   // 43
/* 0 */                                                                                                       // 44
/***/ function(module, exports, __webpack_require__) {                                                        // 45
                                                                                                              // 46
	__webpack_require__(1);                                                                                      // 47
	__webpack_require__(50);                                                                                     // 48
	__webpack_require__(77);                                                                                     // 49
	__webpack_require__(96);                                                                                     // 50
                                                                                                              // 51
	Symbol = exports.Symbol = __webpack_require__(99);                                                           // 52
	Map = exports.Map = __webpack_require__(100);                                                                // 53
	Set = exports.Set = __webpack_require__(108);                                                                // 54
                                                                                                              // 55
                                                                                                              // 56
/***/ },                                                                                                      // 57
/* 1 */                                                                                                       // 58
/***/ function(module, exports, __webpack_require__) {                                                        // 59
                                                                                                              // 60
	__webpack_require__(2);                                                                                      // 61
	__webpack_require__(28);                                                                                     // 62
	__webpack_require__(31);                                                                                     // 63
	__webpack_require__(33);                                                                                     // 64
	__webpack_require__(37);                                                                                     // 65
	__webpack_require__(39);                                                                                     // 66
	__webpack_require__(41);                                                                                     // 67
	__webpack_require__(42);                                                                                     // 68
	__webpack_require__(43);                                                                                     // 69
	__webpack_require__(44);                                                                                     // 70
	__webpack_require__(45);                                                                                     // 71
	__webpack_require__(46);                                                                                     // 72
	__webpack_require__(47);                                                                                     // 73
	__webpack_require__(48);                                                                                     // 74
	__webpack_require__(49);                                                                                     // 75
                                                                                                              // 76
	module.exports = __webpack_require__(9).Object;                                                              // 77
                                                                                                              // 78
/***/ },                                                                                                      // 79
/* 2 */                                                                                                       // 80
/***/ function(module, exports, __webpack_require__) {                                                        // 81
                                                                                                              // 82
	'use strict';                                                                                                // 83
	// ECMAScript 6 symbols shim                                                                                 // 84
	var $              = __webpack_require__(3)                                                                  // 85
	  , global         = __webpack_require__(4)                                                                  // 86
	  , has            = __webpack_require__(5)                                                                  // 87
	  , SUPPORT_DESC   = __webpack_require__(6)                                                                  // 88
	  , $def           = __webpack_require__(8)                                                                  // 89
	  , $redef         = __webpack_require__(12)                                                                 // 90
	  , $fails         = __webpack_require__(7)                                                                  // 91
	  , shared         = __webpack_require__(14)                                                                 // 92
	  , setTag         = __webpack_require__(15)                                                                 // 93
	  , uid            = __webpack_require__(13)                                                                 // 94
	  , wks            = __webpack_require__(16)                                                                 // 95
	  , keyOf          = __webpack_require__(17)                                                                 // 96
	  , $names         = __webpack_require__(22)                                                                 // 97
	  , enumKeys       = __webpack_require__(23)                                                                 // 98
	  , isArray        = __webpack_require__(24)                                                                 // 99
	  , isObject       = __webpack_require__(25)                                                                 // 100
	  , anObject       = __webpack_require__(26)                                                                 // 101
	  , toIObject      = __webpack_require__(18)                                                                 // 102
	  , createDesc     = __webpack_require__(11)                                                                 // 103
	  , getDesc        = $.getDesc                                                                               // 104
	  , setDesc        = $.setDesc                                                                               // 105
	  , _create        = $.create                                                                                // 106
	  , getNames       = $names.get                                                                              // 107
	  , $Symbol        = global.Symbol                                                                           // 108
	  , $JSON          = global.JSON                                                                             // 109
	  , _stringify     = $JSON && $JSON.stringify                                                                // 110
	  , setter         = false                                                                                   // 111
	  , HIDDEN         = wks('_hidden')                                                                          // 112
	  , isEnum         = $.isEnum                                                                                // 113
	  , SymbolRegistry = shared('symbol-registry')                                                               // 114
	  , AllSymbols     = shared('symbols')                                                                       // 115
	  , useNative      = typeof $Symbol == 'function'                                                            // 116
	  , ObjectProto    = Object.prototype;                                                                       // 117
                                                                                                              // 118
	// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687                               // 119
	var setSymbolDesc = SUPPORT_DESC && $fails(function(){                                                       // 120
	  return _create(setDesc({}, 'a', {                                                                          // 121
	    get: function(){ return setDesc(this, 'a', {value: 7}).a; }                                              // 122
	  })).a != 7;                                                                                                // 123
	}) ? function(it, key, D){                                                                                   // 124
	  var protoDesc = getDesc(ObjectProto, key);                                                                 // 125
	  if(protoDesc)delete ObjectProto[key];                                                                      // 126
	  setDesc(it, key, D);                                                                                       // 127
	  if(protoDesc && it !== ObjectProto)setDesc(ObjectProto, key, protoDesc);                                   // 128
	} : setDesc;                                                                                                 // 129
                                                                                                              // 130
	var wrap = function(tag){                                                                                    // 131
	  var sym = AllSymbols[tag] = _create($Symbol.prototype);                                                    // 132
	  sym._k = tag;                                                                                              // 133
	  SUPPORT_DESC && setter && setSymbolDesc(ObjectProto, tag, {                                                // 134
	    configurable: true,                                                                                      // 135
	    set: function(value){                                                                                    // 136
	      if(has(this, HIDDEN) && has(this[HIDDEN], tag))this[HIDDEN][tag] = false;                              // 137
	      setSymbolDesc(this, tag, createDesc(1, value));                                                        // 138
	    }                                                                                                        // 139
	  });                                                                                                        // 140
	  return sym;                                                                                                // 141
	};                                                                                                           // 142
                                                                                                              // 143
	var isSymbol = function(it){                                                                                 // 144
	  return typeof it == 'symbol';                                                                              // 145
	};                                                                                                           // 146
                                                                                                              // 147
	var $defineProperty = function defineProperty(it, key, D){                                                   // 148
	  if(D && has(AllSymbols, key)){                                                                             // 149
	    if(!D.enumerable){                                                                                       // 150
	      if(!has(it, HIDDEN))setDesc(it, HIDDEN, createDesc(1, {}));                                            // 151
	      it[HIDDEN][key] = true;                                                                                // 152
	    } else {                                                                                                 // 153
	      if(has(it, HIDDEN) && it[HIDDEN][key])it[HIDDEN][key] = false;                                         // 154
	      D = _create(D, {enumerable: createDesc(0, false)});                                                    // 155
	    } return setSymbolDesc(it, key, D);                                                                      // 156
	  } return setDesc(it, key, D);                                                                              // 157
	};                                                                                                           // 158
	var $defineProperties = function defineProperties(it, P){                                                    // 159
	  anObject(it);                                                                                              // 160
	  var keys = enumKeys(P = toIObject(P))                                                                      // 161
	    , i    = 0                                                                                               // 162
	    , l = keys.length                                                                                        // 163
	    , key;                                                                                                   // 164
	  while(l > i)$defineProperty(it, key = keys[i++], P[key]);                                                  // 165
	  return it;                                                                                                 // 166
	};                                                                                                           // 167
	var $create = function create(it, P){                                                                        // 168
	  return P === undefined ? _create(it) : $defineProperties(_create(it), P);                                  // 169
	};                                                                                                           // 170
	var $propertyIsEnumerable = function propertyIsEnumerable(key){                                              // 171
	  var E = isEnum.call(this, key);                                                                            // 172
	  return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key]             // 173
	    ? E : true;                                                                                              // 174
	};                                                                                                           // 175
	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key){                                  // 176
	  var D = getDesc(it = toIObject(it), key);                                                                  // 177
	  if(D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key]))D.enumerable = true;                 // 178
	  return D;                                                                                                  // 179
	};                                                                                                           // 180
	var $getOwnPropertyNames = function getOwnPropertyNames(it){                                                 // 181
	  var names  = getNames(toIObject(it))                                                                       // 182
	    , result = []                                                                                            // 183
	    , i      = 0                                                                                             // 184
	    , key;                                                                                                   // 185
	  while(names.length > i)if(!has(AllSymbols, key = names[i++]) && key != HIDDEN)result.push(key);            // 186
	  return result;                                                                                             // 187
	};                                                                                                           // 188
	var $getOwnPropertySymbols = function getOwnPropertySymbols(it){                                             // 189
	  var names  = getNames(toIObject(it))                                                                       // 190
	    , result = []                                                                                            // 191
	    , i      = 0                                                                                             // 192
	    , key;                                                                                                   // 193
	  while(names.length > i)if(has(AllSymbols, key = names[i++]))result.push(AllSymbols[key]);                  // 194
	  return result;                                                                                             // 195
	};                                                                                                           // 196
	var $stringify = function stringify(it){                                                                     // 197
	  var args = [it]                                                                                            // 198
	    , i    = 1                                                                                               // 199
	    , replacer, $replacer;                                                                                   // 200
	  while(arguments.length > i)args.push(arguments[i++]);                                                      // 201
	  replacer = args[1];                                                                                        // 202
	  if(typeof replacer == 'function')$replacer = replacer;                                                     // 203
	  if($replacer || !isArray(replacer))replacer = function(key, value){                                        // 204
	    if($replacer)value = $replacer.call(this, key, value);                                                   // 205
	    if(!isSymbol(value))return value;                                                                        // 206
	  };                                                                                                         // 207
	  args[1] = replacer;                                                                                        // 208
	  return _stringify.apply($JSON, args);                                                                      // 209
	};                                                                                                           // 210
	var buggyJSON = $fails(function(){                                                                           // 211
	  var S = $Symbol();                                                                                         // 212
	  // MS Edge converts symbol values to JSON as {}                                                            // 213
	  // WebKit converts symbol values to JSON as null                                                           // 214
	  // V8 throws on boxed symbols                                                                              // 215
	  return _stringify([S]) != '[null]' || _stringify({a: S}) != '{}' || _stringify(Object(S)) != '{}';         // 216
	});                                                                                                          // 217
                                                                                                              // 218
	// 19.4.1.1 Symbol([description])                                                                            // 219
	if(!useNative){                                                                                              // 220
	  $Symbol = function Symbol(){                                                                               // 221
	    if(isSymbol(this))throw TypeError('Symbol is not a constructor');                                        // 222
	    return wrap(uid(arguments[0]));                                                                          // 223
	  };                                                                                                         // 224
	  $redef($Symbol.prototype, 'toString', function toString(){                                                 // 225
	    return this._k;                                                                                          // 226
	  });                                                                                                        // 227
                                                                                                              // 228
	  isSymbol = function(it){                                                                                   // 229
	    return it instanceof $Symbol;                                                                            // 230
	  };                                                                                                         // 231
                                                                                                              // 232
	  $.create     = $create;                                                                                    // 233
	  $.isEnum     = $propertyIsEnumerable;                                                                      // 234
	  $.getDesc    = $getOwnPropertyDescriptor;                                                                  // 235
	  $.setDesc    = $defineProperty;                                                                            // 236
	  $.setDescs   = $defineProperties;                                                                          // 237
	  $.getNames   = $names.get = $getOwnPropertyNames;                                                          // 238
	  $.getSymbols = $getOwnPropertySymbols;                                                                     // 239
                                                                                                              // 240
	  if(SUPPORT_DESC && !__webpack_require__(27)){                                                              // 241
	    $redef(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);                                // 242
	  }                                                                                                          // 243
	}                                                                                                            // 244
                                                                                                              // 245
	var symbolStatics = {                                                                                        // 246
	  // 19.4.2.1 Symbol.for(key)                                                                                // 247
	  'for': function(key){                                                                                      // 248
	    return has(SymbolRegistry, key += '')                                                                    // 249
	      ? SymbolRegistry[key]                                                                                  // 250
	      : SymbolRegistry[key] = $Symbol(key);                                                                  // 251
	  },                                                                                                         // 252
	  // 19.4.2.5 Symbol.keyFor(sym)                                                                             // 253
	  keyFor: function keyFor(key){                                                                              // 254
	    return keyOf(SymbolRegistry, key);                                                                       // 255
	  },                                                                                                         // 256
	  useSetter: function(){ setter = true; },                                                                   // 257
	  useSimple: function(){ setter = false; }                                                                   // 258
	};                                                                                                           // 259
	// 19.4.2.2 Symbol.hasInstance                                                                               // 260
	// 19.4.2.3 Symbol.isConcatSpreadable                                                                        // 261
	// 19.4.2.4 Symbol.iterator                                                                                  // 262
	// 19.4.2.6 Symbol.match                                                                                     // 263
	// 19.4.2.8 Symbol.replace                                                                                   // 264
	// 19.4.2.9 Symbol.search                                                                                    // 265
	// 19.4.2.10 Symbol.species                                                                                  // 266
	// 19.4.2.11 Symbol.split                                                                                    // 267
	// 19.4.2.12 Symbol.toPrimitive                                                                              // 268
	// 19.4.2.13 Symbol.toStringTag                                                                              // 269
	// 19.4.2.14 Symbol.unscopables                                                                              // 270
	$.each.call((                                                                                                // 271
	    'hasInstance,isConcatSpreadable,iterator,match,replace,search,' +                                        // 272
	    'species,split,toPrimitive,toStringTag,unscopables'                                                      // 273
	  ).split(','), function(it){                                                                                // 274
	    var sym = wks(it);                                                                                       // 275
	    symbolStatics[it] = useNative ? sym : wrap(sym);                                                         // 276
	  }                                                                                                          // 277
	);                                                                                                           // 278
                                                                                                              // 279
	setter = true;                                                                                               // 280
                                                                                                              // 281
	$def($def.G + $def.W, {Symbol: $Symbol});                                                                    // 282
                                                                                                              // 283
	$def($def.S, 'Symbol', symbolStatics);                                                                       // 284
                                                                                                              // 285
	$def($def.S + $def.F * !useNative, 'Object', {                                                               // 286
	  // 19.1.2.2 Object.create(O [, Properties])                                                                // 287
	  create: $create,                                                                                           // 288
	  // 19.1.2.4 Object.defineProperty(O, P, Attributes)                                                        // 289
	  defineProperty: $defineProperty,                                                                           // 290
	  // 19.1.2.3 Object.defineProperties(O, Properties)                                                         // 291
	  defineProperties: $defineProperties,                                                                       // 292
	  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)                                                          // 293
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor,                                                       // 294
	  // 19.1.2.7 Object.getOwnPropertyNames(O)                                                                  // 295
	  getOwnPropertyNames: $getOwnPropertyNames,                                                                 // 296
	  // 19.1.2.8 Object.getOwnPropertySymbols(O)                                                                // 297
	  getOwnPropertySymbols: $getOwnPropertySymbols                                                              // 298
	});                                                                                                          // 299
                                                                                                              // 300
	// 24.3.2 JSON.stringify(value [, replacer [, space]])                                                       // 301
	$JSON && $def($def.S + $def.F * (!useNative || buggyJSON), 'JSON', {stringify: $stringify});                 // 302
                                                                                                              // 303
	// 19.4.3.5 Symbol.prototype[@@toStringTag]                                                                  // 304
	setTag($Symbol, 'Symbol');                                                                                   // 305
	// 20.2.1.9 Math[@@toStringTag]                                                                              // 306
	setTag(Math, 'Math', true);                                                                                  // 307
	// 24.3.3 JSON[@@toStringTag]                                                                                // 308
	setTag(global.JSON, 'JSON', true);                                                                           // 309
                                                                                                              // 310
/***/ },                                                                                                      // 311
/* 3 */                                                                                                       // 312
/***/ function(module, exports) {                                                                             // 313
                                                                                                              // 314
	var $Object = Object;                                                                                        // 315
	module.exports = {                                                                                           // 316
	  create:     $Object.create,                                                                                // 317
	  getProto:   $Object.getPrototypeOf,                                                                        // 318
	  isEnum:     {}.propertyIsEnumerable,                                                                       // 319
	  getDesc:    $Object.getOwnPropertyDescriptor,                                                              // 320
	  setDesc:    $Object.defineProperty,                                                                        // 321
	  setDescs:   $Object.defineProperties,                                                                      // 322
	  getKeys:    $Object.keys,                                                                                  // 323
	  getNames:   $Object.getOwnPropertyNames,                                                                   // 324
	  getSymbols: $Object.getOwnPropertySymbols,                                                                 // 325
	  each:       [].forEach                                                                                     // 326
	};                                                                                                           // 327
                                                                                                              // 328
/***/ },                                                                                                      // 329
/* 4 */                                                                                                       // 330
/***/ function(module, exports) {                                                                             // 331
                                                                                                              // 332
	// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028                                      // 333
	var UNDEFINED = 'undefined';                                                                                 // 334
	var global = module.exports = typeof window != UNDEFINED && window.Math == Math                              // 335
	  ? window : typeof self != UNDEFINED && self.Math == Math ? self : Function('return this')();               // 336
	if(typeof __g == 'number')__g = global; // eslint-disable-line no-undef                                      // 337
                                                                                                              // 338
/***/ },                                                                                                      // 339
/* 5 */                                                                                                       // 340
/***/ function(module, exports) {                                                                             // 341
                                                                                                              // 342
	var hasOwnProperty = {}.hasOwnProperty;                                                                      // 343
	module.exports = function(it, key){                                                                          // 344
	  return hasOwnProperty.call(it, key);                                                                       // 345
	};                                                                                                           // 346
                                                                                                              // 347
/***/ },                                                                                                      // 348
/* 6 */                                                                                                       // 349
/***/ function(module, exports, __webpack_require__) {                                                        // 350
                                                                                                              // 351
	// Thank's IE8 for his funny defineProperty                                                                  // 352
	module.exports = !__webpack_require__(7)(function(){                                                         // 353
	  return Object.defineProperty({}, 'a', {get: function(){ return 7; }}).a != 7;                              // 354
	});                                                                                                          // 355
                                                                                                              // 356
/***/ },                                                                                                      // 357
/* 7 */                                                                                                       // 358
/***/ function(module, exports) {                                                                             // 359
                                                                                                              // 360
	module.exports = function(exec){                                                                             // 361
	  try {                                                                                                      // 362
	    return !!exec();                                                                                         // 363
	  } catch(e){                                                                                                // 364
	    return true;                                                                                             // 365
	  }                                                                                                          // 366
	};                                                                                                           // 367
                                                                                                              // 368
/***/ },                                                                                                      // 369
/* 8 */                                                                                                       // 370
/***/ function(module, exports, __webpack_require__) {                                                        // 371
                                                                                                              // 372
	var global     = __webpack_require__(4)                                                                      // 373
	  , core       = __webpack_require__(9)                                                                      // 374
	  , hide       = __webpack_require__(10)                                                                     // 375
	  , $redef     = __webpack_require__(12)                                                                     // 376
	  , PROTOTYPE  = 'prototype';                                                                                // 377
	var ctx = function(fn, that){                                                                                // 378
	  return function(){                                                                                         // 379
	    return fn.apply(that, arguments);                                                                        // 380
	  };                                                                                                         // 381
	};                                                                                                           // 382
	var $def = function(type, name, source){                                                                     // 383
	  var key, own, out, exp                                                                                     // 384
	    , isGlobal = type & $def.G                                                                               // 385
	    , isProto  = type & $def.P                                                                               // 386
	    , target   = isGlobal ? global : type & $def.S                                                           // 387
	        ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE]                              // 388
	    , exports  = isGlobal ? core : core[name] || (core[name] = {});                                          // 389
	  if(isGlobal)source = name;                                                                                 // 390
	  for(key in source){                                                                                        // 391
	    // contains in native                                                                                    // 392
	    own = !(type & $def.F) && target && key in target;                                                       // 393
	    // export native or passed                                                                               // 394
	    out = (own ? target : source)[key];                                                                      // 395
	    // bind timers to global for call from export context                                                    // 396
	    if(type & $def.B && own)exp = ctx(out, global);                                                          // 397
	    else exp = isProto && typeof out == 'function' ? ctx(Function.call, out) : out;                          // 398
	    // extend global                                                                                         // 399
	    if(target && !own)$redef(target, key, out);                                                              // 400
	    // export                                                                                                // 401
	    if(exports[key] != out)hide(exports, key, exp);                                                          // 402
	    if(isProto)(exports[PROTOTYPE] || (exports[PROTOTYPE] = {}))[key] = out;                                 // 403
	  }                                                                                                          // 404
	};                                                                                                           // 405
	global.core = core;                                                                                          // 406
	// type bitmap                                                                                               // 407
	$def.F = 1;  // forced                                                                                       // 408
	$def.G = 2;  // global                                                                                       // 409
	$def.S = 4;  // static                                                                                       // 410
	$def.P = 8;  // proto                                                                                        // 411
	$def.B = 16; // bind                                                                                         // 412
	$def.W = 32; // wrap                                                                                         // 413
	module.exports = $def;                                                                                       // 414
                                                                                                              // 415
/***/ },                                                                                                      // 416
/* 9 */                                                                                                       // 417
/***/ function(module, exports) {                                                                             // 418
                                                                                                              // 419
	var core = module.exports = {version: '1.2.1'};                                                              // 420
	if(typeof __e == 'number')__e = core; // eslint-disable-line no-undef                                        // 421
                                                                                                              // 422
/***/ },                                                                                                      // 423
/* 10 */                                                                                                      // 424
/***/ function(module, exports, __webpack_require__) {                                                        // 425
                                                                                                              // 426
	var $          = __webpack_require__(3)                                                                      // 427
	  , createDesc = __webpack_require__(11);                                                                    // 428
	module.exports = __webpack_require__(6) ? function(object, key, value){                                      // 429
	  return $.setDesc(object, key, createDesc(1, value));                                                       // 430
	} : function(object, key, value){                                                                            // 431
	  object[key] = value;                                                                                       // 432
	  return object;                                                                                             // 433
	};                                                                                                           // 434
                                                                                                              // 435
/***/ },                                                                                                      // 436
/* 11 */                                                                                                      // 437
/***/ function(module, exports) {                                                                             // 438
                                                                                                              // 439
	module.exports = function(bitmap, value){                                                                    // 440
	  return {                                                                                                   // 441
	    enumerable  : !(bitmap & 1),                                                                             // 442
	    configurable: !(bitmap & 2),                                                                             // 443
	    writable    : !(bitmap & 4),                                                                             // 444
	    value       : value                                                                                      // 445
	  };                                                                                                         // 446
	};                                                                                                           // 447
                                                                                                              // 448
/***/ },                                                                                                      // 449
/* 12 */                                                                                                      // 450
/***/ function(module, exports, __webpack_require__) {                                                        // 451
                                                                                                              // 452
	// add fake Function#toString                                                                                // 453
	// for correct work wrapped methods / constructors with methods like LoDash isNative                         // 454
	var global    = __webpack_require__(4)                                                                       // 455
	  , hide      = __webpack_require__(10)                                                                      // 456
	  , SRC       = __webpack_require__(13)('src')                                                               // 457
	  , TO_STRING = 'toString'                                                                                   // 458
	  , $toString = Function[TO_STRING]                                                                          // 459
	  , TPL       = ('' + $toString).split(TO_STRING);                                                           // 460
                                                                                                              // 461
	__webpack_require__(9).inspectSource = function(it){                                                         // 462
	  return $toString.call(it);                                                                                 // 463
	};                                                                                                           // 464
                                                                                                              // 465
	(module.exports = function(O, key, val, safe){                                                               // 466
	  if(typeof val == 'function'){                                                                              // 467
	    hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));                                            // 468
	    if(!('name' in val))val.name = key;                                                                      // 469
	  }                                                                                                          // 470
	  if(O === global){                                                                                          // 471
	    O[key] = val;                                                                                            // 472
	  } else {                                                                                                   // 473
	    if(!safe)delete O[key];                                                                                  // 474
	    hide(O, key, val);                                                                                       // 475
	  }                                                                                                          // 476
	})(Function.prototype, TO_STRING, function toString(){                                                       // 477
	  return typeof this == 'function' && this[SRC] || $toString.call(this);                                     // 478
	});                                                                                                          // 479
                                                                                                              // 480
/***/ },                                                                                                      // 481
/* 13 */                                                                                                      // 482
/***/ function(module, exports) {                                                                             // 483
                                                                                                              // 484
	var id = 0                                                                                                   // 485
	  , px = Math.random();                                                                                      // 486
	module.exports = function(key){                                                                              // 487
	  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));                     // 488
	};                                                                                                           // 489
                                                                                                              // 490
/***/ },                                                                                                      // 491
/* 14 */                                                                                                      // 492
/***/ function(module, exports, __webpack_require__) {                                                        // 493
                                                                                                              // 494
	var global = __webpack_require__(4)                                                                          // 495
	  , SHARED = '__core-js_shared__'                                                                            // 496
	  , store  = global[SHARED] || (global[SHARED] = {});                                                        // 497
	module.exports = function(key){                                                                              // 498
	  return store[key] || (store[key] = {});                                                                    // 499
	};                                                                                                           // 500
                                                                                                              // 501
/***/ },                                                                                                      // 502
/* 15 */                                                                                                      // 503
/***/ function(module, exports, __webpack_require__) {                                                        // 504
                                                                                                              // 505
	var has  = __webpack_require__(5)                                                                            // 506
	  , hide = __webpack_require__(10)                                                                           // 507
	  , TAG  = __webpack_require__(16)('toStringTag');                                                           // 508
                                                                                                              // 509
	module.exports = function(it, tag, stat){                                                                    // 510
	  if(it && !has(it = stat ? it : it.prototype, TAG))hide(it, TAG, tag);                                      // 511
	};                                                                                                           // 512
                                                                                                              // 513
/***/ },                                                                                                      // 514
/* 16 */                                                                                                      // 515
/***/ function(module, exports, __webpack_require__) {                                                        // 516
                                                                                                              // 517
	var store  = __webpack_require__(14)('wks')                                                                  // 518
	  , Symbol = __webpack_require__(4).Symbol;                                                                  // 519
	module.exports = function(name){                                                                             // 520
	  return store[name] || (store[name] =                                                                       // 521
	    Symbol && Symbol[name] || (Symbol || __webpack_require__(13))('Symbol.' + name));                        // 522
	};                                                                                                           // 523
                                                                                                              // 524
/***/ },                                                                                                      // 525
/* 17 */                                                                                                      // 526
/***/ function(module, exports, __webpack_require__) {                                                        // 527
                                                                                                              // 528
	var $         = __webpack_require__(3)                                                                       // 529
	  , toIObject = __webpack_require__(18);                                                                     // 530
	module.exports = function(object, el){                                                                       // 531
	  var O      = toIObject(object)                                                                             // 532
	    , keys   = $.getKeys(O)                                                                                  // 533
	    , length = keys.length                                                                                   // 534
	    , index  = 0                                                                                             // 535
	    , key;                                                                                                   // 536
	  while(length > index)if(O[key = keys[index++]] === el)return key;                                          // 537
	};                                                                                                           // 538
                                                                                                              // 539
/***/ },                                                                                                      // 540
/* 18 */                                                                                                      // 541
/***/ function(module, exports, __webpack_require__) {                                                        // 542
                                                                                                              // 543
	// to indexed object, toObject with fallback for non-array-like ES3 strings                                  // 544
	var IObject = __webpack_require__(19)                                                                        // 545
	  , defined = __webpack_require__(21);                                                                       // 546
	module.exports = function(it){                                                                               // 547
	  return IObject(defined(it));                                                                               // 548
	};                                                                                                           // 549
                                                                                                              // 550
/***/ },                                                                                                      // 551
/* 19 */                                                                                                      // 552
/***/ function(module, exports, __webpack_require__) {                                                        // 553
                                                                                                              // 554
	// indexed object, fallback for non-array-like ES3 strings                                                   // 555
	var cof = __webpack_require__(20);                                                                           // 556
	module.exports = 0 in Object('z') ? Object : function(it){                                                   // 557
	  return cof(it) == 'String' ? it.split('') : Object(it);                                                    // 558
	};                                                                                                           // 559
                                                                                                              // 560
/***/ },                                                                                                      // 561
/* 20 */                                                                                                      // 562
/***/ function(module, exports) {                                                                             // 563
                                                                                                              // 564
	var toString = {}.toString;                                                                                  // 565
                                                                                                              // 566
	module.exports = function(it){                                                                               // 567
	  return toString.call(it).slice(8, -1);                                                                     // 568
	};                                                                                                           // 569
                                                                                                              // 570
/***/ },                                                                                                      // 571
/* 21 */                                                                                                      // 572
/***/ function(module, exports) {                                                                             // 573
                                                                                                              // 574
	// 7.2.1 RequireObjectCoercible(argument)                                                                    // 575
	module.exports = function(it){                                                                               // 576
	  if(it == undefined)throw TypeError("Can't call method on  " + it);                                         // 577
	  return it;                                                                                                 // 578
	};                                                                                                           // 579
                                                                                                              // 580
/***/ },                                                                                                      // 581
/* 22 */                                                                                                      // 582
/***/ function(module, exports, __webpack_require__) {                                                        // 583
                                                                                                              // 584
	// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window                                 // 585
	var toString  = {}.toString                                                                                  // 586
	  , toIObject = __webpack_require__(18)                                                                      // 587
	  , getNames  = __webpack_require__(3).getNames;                                                             // 588
                                                                                                              // 589
	var windowNames = typeof window == 'object' && Object.getOwnPropertyNames                                    // 590
	  ? Object.getOwnPropertyNames(window) : [];                                                                 // 591
                                                                                                              // 592
	var getWindowNames = function(it){                                                                           // 593
	  try {                                                                                                      // 594
	    return getNames(it);                                                                                     // 595
	  } catch(e){                                                                                                // 596
	    return windowNames.slice();                                                                              // 597
	  }                                                                                                          // 598
	};                                                                                                           // 599
                                                                                                              // 600
	module.exports.get = function getOwnPropertyNames(it){                                                       // 601
	  if(windowNames && toString.call(it) == '[object Window]')return getWindowNames(it);                        // 602
	  return getNames(toIObject(it));                                                                            // 603
	};                                                                                                           // 604
                                                                                                              // 605
/***/ },                                                                                                      // 606
/* 23 */                                                                                                      // 607
/***/ function(module, exports, __webpack_require__) {                                                        // 608
                                                                                                              // 609
	// all enumerable object keys, includes symbols                                                              // 610
	var $ = __webpack_require__(3);                                                                              // 611
	module.exports = function(it){                                                                               // 612
	  var keys       = $.getKeys(it)                                                                             // 613
	    , getSymbols = $.getSymbols;                                                                             // 614
	  if(getSymbols){                                                                                            // 615
	    var symbols = getSymbols(it)                                                                             // 616
	      , isEnum  = $.isEnum                                                                                   // 617
	      , i       = 0                                                                                          // 618
	      , key;                                                                                                 // 619
	    while(symbols.length > i)if(isEnum.call(it, key = symbols[i++]))keys.push(key);                          // 620
	  }                                                                                                          // 621
	  return keys;                                                                                               // 622
	};                                                                                                           // 623
                                                                                                              // 624
/***/ },                                                                                                      // 625
/* 24 */                                                                                                      // 626
/***/ function(module, exports, __webpack_require__) {                                                        // 627
                                                                                                              // 628
	// 7.2.2 IsArray(argument)                                                                                   // 629
	var cof = __webpack_require__(20);                                                                           // 630
	module.exports = Array.isArray || function(arg){                                                             // 631
	  return cof(arg) == 'Array';                                                                                // 632
	};                                                                                                           // 633
                                                                                                              // 634
/***/ },                                                                                                      // 635
/* 25 */                                                                                                      // 636
/***/ function(module, exports) {                                                                             // 637
                                                                                                              // 638
	module.exports = function(it){                                                                               // 639
	  return typeof it === 'object' ? it !== null : typeof it === 'function';                                    // 640
	};                                                                                                           // 641
                                                                                                              // 642
/***/ },                                                                                                      // 643
/* 26 */                                                                                                      // 644
/***/ function(module, exports, __webpack_require__) {                                                        // 645
                                                                                                              // 646
	var isObject = __webpack_require__(25);                                                                      // 647
	module.exports = function(it){                                                                               // 648
	  if(!isObject(it))throw TypeError(it + ' is not an object!');                                               // 649
	  return it;                                                                                                 // 650
	};                                                                                                           // 651
                                                                                                              // 652
/***/ },                                                                                                      // 653
/* 27 */                                                                                                      // 654
/***/ function(module, exports) {                                                                             // 655
                                                                                                              // 656
	module.exports = false;                                                                                      // 657
                                                                                                              // 658
/***/ },                                                                                                      // 659
/* 28 */                                                                                                      // 660
/***/ function(module, exports, __webpack_require__) {                                                        // 661
                                                                                                              // 662
	// 19.1.3.1 Object.assign(target, source)                                                                    // 663
	var $def = __webpack_require__(8);                                                                           // 664
                                                                                                              // 665
	$def($def.S + $def.F, 'Object', {assign: __webpack_require__(29)});                                          // 666
                                                                                                              // 667
/***/ },                                                                                                      // 668
/* 29 */                                                                                                      // 669
/***/ function(module, exports, __webpack_require__) {                                                        // 670
                                                                                                              // 671
	// 19.1.2.1 Object.assign(target, source, ...)                                                               // 672
	var toObject = __webpack_require__(30)                                                                       // 673
	  , IObject  = __webpack_require__(19)                                                                       // 674
	  , enumKeys = __webpack_require__(23)                                                                       // 675
	  , has      = __webpack_require__(5);                                                                       // 676
                                                                                                              // 677
	// should work with symbols and should have deterministic property order (V8 bug)                            // 678
	module.exports = __webpack_require__(7)(function(){                                                          // 679
	  var a = Object.assign                                                                                      // 680
	    , A = {}                                                                                                 // 681
	    , B = {}                                                                                                 // 682
	    , S = Symbol()                                                                                           // 683
	    , K = 'abcdefghijklmnopqrst';                                                                            // 684
	  A[S] = 7;                                                                                                  // 685
	  K.split('').forEach(function(k){ B[k] = k; });                                                             // 686
	  return a({}, A)[S] != 7 || Object.keys(a({}, B)).join('') != K;                                            // 687
	}) ? function assign(target, source){   // eslint-disable-line no-unused-vars                                // 688
	  var T = toObject(target)                                                                                   // 689
	    , l = arguments.length                                                                                   // 690
	    , i = 1;                                                                                                 // 691
	  while(l > i){                                                                                              // 692
	    var S      = IObject(arguments[i++])                                                                     // 693
	      , keys   = enumKeys(S)                                                                                 // 694
	      , length = keys.length                                                                                 // 695
	      , j      = 0                                                                                           // 696
	      , key;                                                                                                 // 697
	    while(length > j)if(has(S, key = keys[j++]))T[key] = S[key];                                             // 698
	  }                                                                                                          // 699
	  return T;                                                                                                  // 700
	} : Object.assign;                                                                                           // 701
                                                                                                              // 702
/***/ },                                                                                                      // 703
/* 30 */                                                                                                      // 704
/***/ function(module, exports, __webpack_require__) {                                                        // 705
                                                                                                              // 706
	// 7.1.13 ToObject(argument)                                                                                 // 707
	var defined = __webpack_require__(21);                                                                       // 708
	module.exports = function(it){                                                                               // 709
	  return Object(defined(it));                                                                                // 710
	};                                                                                                           // 711
                                                                                                              // 712
/***/ },                                                                                                      // 713
/* 31 */                                                                                                      // 714
/***/ function(module, exports, __webpack_require__) {                                                        // 715
                                                                                                              // 716
	// 19.1.3.10 Object.is(value1, value2)                                                                       // 717
	var $def = __webpack_require__(8);                                                                           // 718
	$def($def.S, 'Object', {                                                                                     // 719
	  is: __webpack_require__(32)                                                                                // 720
	});                                                                                                          // 721
                                                                                                              // 722
/***/ },                                                                                                      // 723
/* 32 */                                                                                                      // 724
/***/ function(module, exports) {                                                                             // 725
                                                                                                              // 726
	module.exports = Object.is || function is(x, y){                                                             // 727
	  return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;                                            // 728
	};                                                                                                           // 729
                                                                                                              // 730
/***/ },                                                                                                      // 731
/* 33 */                                                                                                      // 732
/***/ function(module, exports, __webpack_require__) {                                                        // 733
                                                                                                              // 734
	// 19.1.3.19 Object.setPrototypeOf(O, proto)                                                                 // 735
	var $def = __webpack_require__(8);                                                                           // 736
	$def($def.S, 'Object', {setPrototypeOf: __webpack_require__(34).set});                                       // 737
                                                                                                              // 738
/***/ },                                                                                                      // 739
/* 34 */                                                                                                      // 740
/***/ function(module, exports, __webpack_require__) {                                                        // 741
                                                                                                              // 742
	// Works with __proto__ only. Old v8 can't work with null proto objects.                                     // 743
	/* eslint-disable no-proto */                                                                                // 744
	var getDesc  = __webpack_require__(3).getDesc                                                                // 745
	  , isObject = __webpack_require__(25)                                                                       // 746
	  , anObject = __webpack_require__(26);                                                                      // 747
	var check = function(O, proto){                                                                              // 748
	  anObject(O);                                                                                               // 749
	  if(!isObject(proto) && proto !== null)throw TypeError(proto + ": can't set as prototype!");                // 750
	};                                                                                                           // 751
	module.exports = {                                                                                           // 752
	  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line no-proto                         // 753
	    function(test, buggy, set){                                                                              // 754
	      try {                                                                                                  // 755
	        set = __webpack_require__(35)(Function.call, getDesc(Object.prototype, '__proto__').set, 2);         // 756
	        set(test, []);                                                                                       // 757
	        buggy = !(test instanceof Array);                                                                    // 758
	      } catch(e){ buggy = true; }                                                                            // 759
	      return function setPrototypeOf(O, proto){                                                              // 760
	        check(O, proto);                                                                                     // 761
	        if(buggy)O.__proto__ = proto;                                                                        // 762
	        else set(O, proto);                                                                                  // 763
	        return O;                                                                                            // 764
	      };                                                                                                     // 765
	    }({}, false) : undefined),                                                                               // 766
	  check: check                                                                                               // 767
	};                                                                                                           // 768
                                                                                                              // 769
/***/ },                                                                                                      // 770
/* 35 */                                                                                                      // 771
/***/ function(module, exports, __webpack_require__) {                                                        // 772
                                                                                                              // 773
	// optional / simple context binding                                                                         // 774
	var aFunction = __webpack_require__(36);                                                                     // 775
	module.exports = function(fn, that, length){                                                                 // 776
	  aFunction(fn);                                                                                             // 777
	  if(that === undefined)return fn;                                                                           // 778
	  switch(length){                                                                                            // 779
	    case 1: return function(a){                                                                              // 780
	      return fn.call(that, a);                                                                               // 781
	    };                                                                                                       // 782
	    case 2: return function(a, b){                                                                           // 783
	      return fn.call(that, a, b);                                                                            // 784
	    };                                                                                                       // 785
	    case 3: return function(a, b, c){                                                                        // 786
	      return fn.call(that, a, b, c);                                                                         // 787
	    };                                                                                                       // 788
	  }                                                                                                          // 789
	  return function(/* ...args */){                                                                            // 790
	    return fn.apply(that, arguments);                                                                        // 791
	  };                                                                                                         // 792
	};                                                                                                           // 793
                                                                                                              // 794
/***/ },                                                                                                      // 795
/* 36 */                                                                                                      // 796
/***/ function(module, exports) {                                                                             // 797
                                                                                                              // 798
	module.exports = function(it){                                                                               // 799
	  if(typeof it != 'function')throw TypeError(it + ' is not a function!');                                    // 800
	  return it;                                                                                                 // 801
	};                                                                                                           // 802
                                                                                                              // 803
/***/ },                                                                                                      // 804
/* 37 */                                                                                                      // 805
/***/ function(module, exports, __webpack_require__) {                                                        // 806
                                                                                                              // 807
	'use strict';                                                                                                // 808
	// 19.1.3.6 Object.prototype.toString()                                                                      // 809
	var classof = __webpack_require__(38)                                                                        // 810
	  , test    = {};                                                                                            // 811
	test[__webpack_require__(16)('toStringTag')] = 'z';                                                          // 812
	if(test + '' != '[object z]'){                                                                               // 813
	  __webpack_require__(12)(Object.prototype, 'toString', function toString(){                                 // 814
	    return '[object ' + classof(this) + ']';                                                                 // 815
	  }, true);                                                                                                  // 816
	}                                                                                                            // 817
                                                                                                              // 818
/***/ },                                                                                                      // 819
/* 38 */                                                                                                      // 820
/***/ function(module, exports, __webpack_require__) {                                                        // 821
                                                                                                              // 822
	// getting tag from 19.1.3.6 Object.prototype.toString()                                                     // 823
	var cof = __webpack_require__(20)                                                                            // 824
	  , TAG = __webpack_require__(16)('toStringTag')                                                             // 825
	  // ES3 wrong here                                                                                          // 826
	  , ARG = cof(function(){ return arguments; }()) == 'Arguments';                                             // 827
                                                                                                              // 828
	module.exports = function(it){                                                                               // 829
	  var O, T, B;                                                                                               // 830
	  return it === undefined ? 'Undefined' : it === null ? 'Null'                                               // 831
	    // @@toStringTag case                                                                                    // 832
	    : typeof (T = (O = Object(it))[TAG]) == 'string' ? T                                                     // 833
	    // builtinTag case                                                                                       // 834
	    : ARG ? cof(O)                                                                                           // 835
	    // ES3 arguments fallback                                                                                // 836
	    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;                           // 837
	};                                                                                                           // 838
                                                                                                              // 839
/***/ },                                                                                                      // 840
/* 39 */                                                                                                      // 841
/***/ function(module, exports, __webpack_require__) {                                                        // 842
                                                                                                              // 843
	// 19.1.2.5 Object.freeze(O)                                                                                 // 844
	var isObject = __webpack_require__(25);                                                                      // 845
                                                                                                              // 846
	__webpack_require__(40)('freeze', function($freeze){                                                         // 847
	  return function freeze(it){                                                                                // 848
	    return $freeze && isObject(it) ? $freeze(it) : it;                                                       // 849
	  };                                                                                                         // 850
	});                                                                                                          // 851
                                                                                                              // 852
/***/ },                                                                                                      // 853
/* 40 */                                                                                                      // 854
/***/ function(module, exports, __webpack_require__) {                                                        // 855
                                                                                                              // 856
	// most Object methods by ES6 should accept primitives                                                       // 857
	module.exports = function(KEY, exec){                                                                        // 858
	  var $def = __webpack_require__(8)                                                                          // 859
	    , fn   = (__webpack_require__(9).Object || {})[KEY] || Object[KEY]                                       // 860
	    , exp  = {};                                                                                             // 861
	  exp[KEY] = exec(fn);                                                                                       // 862
	  $def($def.S + $def.F * __webpack_require__(7)(function(){ fn(1); }), 'Object', exp);                       // 863
	};                                                                                                           // 864
                                                                                                              // 865
/***/ },                                                                                                      // 866
/* 41 */                                                                                                      // 867
/***/ function(module, exports, __webpack_require__) {                                                        // 868
                                                                                                              // 869
	// 19.1.2.17 Object.seal(O)                                                                                  // 870
	var isObject = __webpack_require__(25);                                                                      // 871
                                                                                                              // 872
	__webpack_require__(40)('seal', function($seal){                                                             // 873
	  return function seal(it){                                                                                  // 874
	    return $seal && isObject(it) ? $seal(it) : it;                                                           // 875
	  };                                                                                                         // 876
	});                                                                                                          // 877
                                                                                                              // 878
/***/ },                                                                                                      // 879
/* 42 */                                                                                                      // 880
/***/ function(module, exports, __webpack_require__) {                                                        // 881
                                                                                                              // 882
	// 19.1.2.15 Object.preventExtensions(O)                                                                     // 883
	var isObject = __webpack_require__(25);                                                                      // 884
                                                                                                              // 885
	__webpack_require__(40)('preventExtensions', function($preventExtensions){                                   // 886
	  return function preventExtensions(it){                                                                     // 887
	    return $preventExtensions && isObject(it) ? $preventExtensions(it) : it;                                 // 888
	  };                                                                                                         // 889
	});                                                                                                          // 890
                                                                                                              // 891
/***/ },                                                                                                      // 892
/* 43 */                                                                                                      // 893
/***/ function(module, exports, __webpack_require__) {                                                        // 894
                                                                                                              // 895
	// 19.1.2.12 Object.isFrozen(O)                                                                              // 896
	var isObject = __webpack_require__(25);                                                                      // 897
                                                                                                              // 898
	__webpack_require__(40)('isFrozen', function($isFrozen){                                                     // 899
	  return function isFrozen(it){                                                                              // 900
	    return isObject(it) ? $isFrozen ? $isFrozen(it) : false : true;                                          // 901
	  };                                                                                                         // 902
	});                                                                                                          // 903
                                                                                                              // 904
/***/ },                                                                                                      // 905
/* 44 */                                                                                                      // 906
/***/ function(module, exports, __webpack_require__) {                                                        // 907
                                                                                                              // 908
	// 19.1.2.13 Object.isSealed(O)                                                                              // 909
	var isObject = __webpack_require__(25);                                                                      // 910
                                                                                                              // 911
	__webpack_require__(40)('isSealed', function($isSealed){                                                     // 912
	  return function isSealed(it){                                                                              // 913
	    return isObject(it) ? $isSealed ? $isSealed(it) : false : true;                                          // 914
	  };                                                                                                         // 915
	});                                                                                                          // 916
                                                                                                              // 917
/***/ },                                                                                                      // 918
/* 45 */                                                                                                      // 919
/***/ function(module, exports, __webpack_require__) {                                                        // 920
                                                                                                              // 921
	// 19.1.2.11 Object.isExtensible(O)                                                                          // 922
	var isObject = __webpack_require__(25);                                                                      // 923
                                                                                                              // 924
	__webpack_require__(40)('isExtensible', function($isExtensible){                                             // 925
	  return function isExtensible(it){                                                                          // 926
	    return isObject(it) ? $isExtensible ? $isExtensible(it) : true : false;                                  // 927
	  };                                                                                                         // 928
	});                                                                                                          // 929
                                                                                                              // 930
/***/ },                                                                                                      // 931
/* 46 */                                                                                                      // 932
/***/ function(module, exports, __webpack_require__) {                                                        // 933
                                                                                                              // 934
	// 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)                                                            // 935
	var toIObject = __webpack_require__(18);                                                                     // 936
                                                                                                              // 937
	__webpack_require__(40)('getOwnPropertyDescriptor', function($getOwnPropertyDescriptor){                     // 938
	  return function getOwnPropertyDescriptor(it, key){                                                         // 939
	    return $getOwnPropertyDescriptor(toIObject(it), key);                                                    // 940
	  };                                                                                                         // 941
	});                                                                                                          // 942
                                                                                                              // 943
/***/ },                                                                                                      // 944
/* 47 */                                                                                                      // 945
/***/ function(module, exports, __webpack_require__) {                                                        // 946
                                                                                                              // 947
	// 19.1.2.9 Object.getPrototypeOf(O)                                                                         // 948
	var toObject = __webpack_require__(30);                                                                      // 949
                                                                                                              // 950
	__webpack_require__(40)('getPrototypeOf', function($getPrototypeOf){                                         // 951
	  return function getPrototypeOf(it){                                                                        // 952
	    return $getPrototypeOf(toObject(it));                                                                    // 953
	  };                                                                                                         // 954
	});                                                                                                          // 955
                                                                                                              // 956
/***/ },                                                                                                      // 957
/* 48 */                                                                                                      // 958
/***/ function(module, exports, __webpack_require__) {                                                        // 959
                                                                                                              // 960
	// 19.1.2.14 Object.keys(O)                                                                                  // 961
	var toObject = __webpack_require__(30);                                                                      // 962
                                                                                                              // 963
	__webpack_require__(40)('keys', function($keys){                                                             // 964
	  return function keys(it){                                                                                  // 965
	    return $keys(toObject(it));                                                                              // 966
	  };                                                                                                         // 967
	});                                                                                                          // 968
                                                                                                              // 969
/***/ },                                                                                                      // 970
/* 49 */                                                                                                      // 971
/***/ function(module, exports, __webpack_require__) {                                                        // 972
                                                                                                              // 973
	// 19.1.2.7 Object.getOwnPropertyNames(O)                                                                    // 974
	__webpack_require__(40)('getOwnPropertyNames', function(){                                                   // 975
	  return __webpack_require__(22).get;                                                                        // 976
	});                                                                                                          // 977
                                                                                                              // 978
/***/ },                                                                                                      // 979
/* 50 */                                                                                                      // 980
/***/ function(module, exports, __webpack_require__) {                                                        // 981
                                                                                                              // 982
	__webpack_require__(51);                                                                                     // 983
	__webpack_require__(57);                                                                                     // 984
	__webpack_require__(63);                                                                                     // 985
	__webpack_require__(64);                                                                                     // 986
	__webpack_require__(66);                                                                                     // 987
	__webpack_require__(69);                                                                                     // 988
	__webpack_require__(72);                                                                                     // 989
	__webpack_require__(74);                                                                                     // 990
	__webpack_require__(76);                                                                                     // 991
	module.exports = __webpack_require__(9).Array;                                                               // 992
                                                                                                              // 993
/***/ },                                                                                                      // 994
/* 51 */                                                                                                      // 995
/***/ function(module, exports, __webpack_require__) {                                                        // 996
                                                                                                              // 997
	'use strict';                                                                                                // 998
	var $at  = __webpack_require__(52)(true);                                                                    // 999
                                                                                                              // 1000
	// 21.1.3.27 String.prototype[@@iterator]()                                                                  // 1001
	__webpack_require__(54)(String, 'String', function(iterated){                                                // 1002
	  this._t = String(iterated); // target                                                                      // 1003
	  this._i = 0;                // next index                                                                  // 1004
	// 21.1.5.2.1 %StringIteratorPrototype%.next()                                                               // 1005
	}, function(){                                                                                               // 1006
	  var O     = this._t                                                                                        // 1007
	    , index = this._i                                                                                        // 1008
	    , point;                                                                                                 // 1009
	  if(index >= O.length)return {value: undefined, done: true};                                                // 1010
	  point = $at(O, index);                                                                                     // 1011
	  this._i += point.length;                                                                                   // 1012
	  return {value: point, done: false};                                                                        // 1013
	});                                                                                                          // 1014
                                                                                                              // 1015
/***/ },                                                                                                      // 1016
/* 52 */                                                                                                      // 1017
/***/ function(module, exports, __webpack_require__) {                                                        // 1018
                                                                                                              // 1019
	// true  -> String#at                                                                                        // 1020
	// false -> String#codePointAt                                                                               // 1021
	var toInteger = __webpack_require__(53)                                                                      // 1022
	  , defined   = __webpack_require__(21);                                                                     // 1023
	module.exports = function(TO_STRING){                                                                        // 1024
	  return function(that, pos){                                                                                // 1025
	    var s = String(defined(that))                                                                            // 1026
	      , i = toInteger(pos)                                                                                   // 1027
	      , l = s.length                                                                                         // 1028
	      , a, b;                                                                                                // 1029
	    if(i < 0 || i >= l)return TO_STRING ? '' : undefined;                                                    // 1030
	    a = s.charCodeAt(i);                                                                                     // 1031
	    return a < 0xd800 || a > 0xdbff || i + 1 === l                                                           // 1032
	      || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff                                                    // 1033
	        ? TO_STRING ? s.charAt(i) : a                                                                        // 1034
	        : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;                       // 1035
	  };                                                                                                         // 1036
	};                                                                                                           // 1037
                                                                                                              // 1038
/***/ },                                                                                                      // 1039
/* 53 */                                                                                                      // 1040
/***/ function(module, exports) {                                                                             // 1041
                                                                                                              // 1042
	// 7.1.4 ToInteger                                                                                           // 1043
	var ceil  = Math.ceil                                                                                        // 1044
	  , floor = Math.floor;                                                                                      // 1045
	module.exports = function(it){                                                                               // 1046
	  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);                                                  // 1047
	};                                                                                                           // 1048
                                                                                                              // 1049
/***/ },                                                                                                      // 1050
/* 54 */                                                                                                      // 1051
/***/ function(module, exports, __webpack_require__) {                                                        // 1052
                                                                                                              // 1053
	'use strict';                                                                                                // 1054
	var LIBRARY         = __webpack_require__(27)                                                                // 1055
	  , $def            = __webpack_require__(8)                                                                 // 1056
	  , $redef          = __webpack_require__(12)                                                                // 1057
	  , hide            = __webpack_require__(10)                                                                // 1058
	  , has             = __webpack_require__(5)                                                                 // 1059
	  , SYMBOL_ITERATOR = __webpack_require__(16)('iterator')                                                    // 1060
	  , Iterators       = __webpack_require__(55)                                                                // 1061
	  , BUGGY           = !([].keys && 'next' in [].keys()) // Safari has buggy iterators w/o `next`             // 1062
	  , FF_ITERATOR     = '@@iterator'                                                                           // 1063
	  , KEYS            = 'keys'                                                                                 // 1064
	  , VALUES          = 'values';                                                                              // 1065
	var returnThis = function(){ return this; };                                                                 // 1066
	module.exports = function(Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCE){                            // 1067
	  __webpack_require__(56)(Constructor, NAME, next);                                                          // 1068
	  var createMethod = function(kind){                                                                         // 1069
	    switch(kind){                                                                                            // 1070
	      case KEYS: return function keys(){ return new Constructor(this, kind); };                              // 1071
	      case VALUES: return function values(){ return new Constructor(this, kind); };                          // 1072
	    } return function entries(){ return new Constructor(this, kind); };                                      // 1073
	  };                                                                                                         // 1074
	  var TAG      = NAME + ' Iterator'                                                                          // 1075
	    , proto    = Base.prototype                                                                              // 1076
	    , _native  = proto[SYMBOL_ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT]                   // 1077
	    , _default = _native || createMethod(DEFAULT)                                                            // 1078
	    , methods, key;                                                                                          // 1079
	  // Fix native                                                                                              // 1080
	  if(_native){                                                                                               // 1081
	    var IteratorPrototype = __webpack_require__(3).getProto(_default.call(new Base));                        // 1082
	    // Set @@toStringTag to native iterators                                                                 // 1083
	    __webpack_require__(15)(IteratorPrototype, TAG, true);                                                   // 1084
	    // FF fix                                                                                                // 1085
	    if(!LIBRARY && has(proto, FF_ITERATOR))hide(IteratorPrototype, SYMBOL_ITERATOR, returnThis);             // 1086
	  }                                                                                                          // 1087
	  // Define iterator                                                                                         // 1088
	  if(!LIBRARY || FORCE)hide(proto, SYMBOL_ITERATOR, _default);                                               // 1089
	  // Plug for library                                                                                        // 1090
	  Iterators[NAME] = _default;                                                                                // 1091
	  Iterators[TAG]  = returnThis;                                                                              // 1092
	  if(DEFAULT){                                                                                               // 1093
	    methods = {                                                                                              // 1094
	      keys:    IS_SET            ? _default : createMethod(KEYS),                                            // 1095
	      values:  DEFAULT == VALUES ? _default : createMethod(VALUES),                                          // 1096
	      entries: DEFAULT != VALUES ? _default : createMethod('entries')                                        // 1097
	    };                                                                                                       // 1098
	    if(FORCE)for(key in methods){                                                                            // 1099
	      if(!(key in proto))$redef(proto, key, methods[key]);                                                   // 1100
	    } else $def($def.P + $def.F * BUGGY, NAME, methods);                                                     // 1101
	  }                                                                                                          // 1102
	};                                                                                                           // 1103
                                                                                                              // 1104
/***/ },                                                                                                      // 1105
/* 55 */                                                                                                      // 1106
/***/ function(module, exports) {                                                                             // 1107
                                                                                                              // 1108
	module.exports = {};                                                                                         // 1109
                                                                                                              // 1110
/***/ },                                                                                                      // 1111
/* 56 */                                                                                                      // 1112
/***/ function(module, exports, __webpack_require__) {                                                        // 1113
                                                                                                              // 1114
	'use strict';                                                                                                // 1115
	var $ = __webpack_require__(3)                                                                               // 1116
	  , IteratorPrototype = {};                                                                                  // 1117
                                                                                                              // 1118
	// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()                                                              // 1119
	__webpack_require__(10)(IteratorPrototype, __webpack_require__(16)('iterator'), function(){ return this; });
                                                                                                              // 1121
	module.exports = function(Constructor, NAME, next){                                                          // 1122
	  Constructor.prototype = $.create(IteratorPrototype, {next: __webpack_require__(11)(1,next)});              // 1123
	  __webpack_require__(15)(Constructor, NAME + ' Iterator');                                                  // 1124
	};                                                                                                           // 1125
                                                                                                              // 1126
/***/ },                                                                                                      // 1127
/* 57 */                                                                                                      // 1128
/***/ function(module, exports, __webpack_require__) {                                                        // 1129
                                                                                                              // 1130
	'use strict';                                                                                                // 1131
	var ctx         = __webpack_require__(35)                                                                    // 1132
	  , $def        = __webpack_require__(8)                                                                     // 1133
	  , toObject    = __webpack_require__(30)                                                                    // 1134
	  , call        = __webpack_require__(58)                                                                    // 1135
	  , isArrayIter = __webpack_require__(59)                                                                    // 1136
	  , toLength    = __webpack_require__(60)                                                                    // 1137
	  , getIterFn   = __webpack_require__(61);                                                                   // 1138
	$def($def.S + $def.F * !__webpack_require__(62)(function(iter){ Array.from(iter); }), 'Array', {             // 1139
	  // 22.1.2.1 Array.from(arrayLike, mapfn = undefined, thisArg = undefined)                                  // 1140
	  from: function from(arrayLike/*, mapfn = undefined, thisArg = undefined*/){                                // 1141
	    var O       = toObject(arrayLike)                                                                        // 1142
	      , C       = typeof this == 'function' ? this : Array                                                   // 1143
	      , mapfn   = arguments[1]                                                                               // 1144
	      , mapping = mapfn !== undefined                                                                        // 1145
	      , index   = 0                                                                                          // 1146
	      , iterFn  = getIterFn(O)                                                                               // 1147
	      , length, result, step, iterator;                                                                      // 1148
	    if(mapping)mapfn = ctx(mapfn, arguments[2], 2);                                                          // 1149
	    // if object isn't iterable or it's array with default iterator - use simple case                        // 1150
	    if(iterFn != undefined && !(C == Array && isArrayIter(iterFn))){                                         // 1151
	      for(iterator = iterFn.call(O), result = new C; !(step = iterator.next()).done; index++){               // 1152
	        result[index] = mapping ? call(iterator, mapfn, [step.value, index], true) : step.value;             // 1153
	      }                                                                                                      // 1154
	    } else {                                                                                                 // 1155
	      length = toLength(O.length);                                                                           // 1156
	      for(result = new C(length); length > index; index++){                                                  // 1157
	        result[index] = mapping ? mapfn(O[index], index) : O[index];                                         // 1158
	      }                                                                                                      // 1159
	    }                                                                                                        // 1160
	    result.length = index;                                                                                   // 1161
	    return result;                                                                                           // 1162
	  }                                                                                                          // 1163
	});                                                                                                          // 1164
                                                                                                              // 1165
                                                                                                              // 1166
/***/ },                                                                                                      // 1167
/* 58 */                                                                                                      // 1168
/***/ function(module, exports, __webpack_require__) {                                                        // 1169
                                                                                                              // 1170
	// call something on iterator step with safe closing on error                                                // 1171
	var anObject = __webpack_require__(26);                                                                      // 1172
	module.exports = function(iterator, fn, value, entries){                                                     // 1173
	  try {                                                                                                      // 1174
	    return entries ? fn(anObject(value)[0], value[1]) : fn(value);                                           // 1175
	  // 7.4.6 IteratorClose(iterator, completion)                                                               // 1176
	  } catch(e){                                                                                                // 1177
	    var ret = iterator['return'];                                                                            // 1178
	    if(ret !== undefined)anObject(ret.call(iterator));                                                       // 1179
	    throw e;                                                                                                 // 1180
	  }                                                                                                          // 1181
	};                                                                                                           // 1182
                                                                                                              // 1183
/***/ },                                                                                                      // 1184
/* 59 */                                                                                                      // 1185
/***/ function(module, exports, __webpack_require__) {                                                        // 1186
                                                                                                              // 1187
	// check on default Array iterator                                                                           // 1188
	var Iterators = __webpack_require__(55)                                                                      // 1189
	  , ITERATOR  = __webpack_require__(16)('iterator');                                                         // 1190
	module.exports = function(it){                                                                               // 1191
	  return (Iterators.Array || Array.prototype[ITERATOR]) === it;                                              // 1192
	};                                                                                                           // 1193
                                                                                                              // 1194
/***/ },                                                                                                      // 1195
/* 60 */                                                                                                      // 1196
/***/ function(module, exports, __webpack_require__) {                                                        // 1197
                                                                                                              // 1198
	// 7.1.15 ToLength                                                                                           // 1199
	var toInteger = __webpack_require__(53)                                                                      // 1200
	  , min       = Math.min;                                                                                    // 1201
	module.exports = function(it){                                                                               // 1202
	  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991            // 1203
	};                                                                                                           // 1204
                                                                                                              // 1205
/***/ },                                                                                                      // 1206
/* 61 */                                                                                                      // 1207
/***/ function(module, exports, __webpack_require__) {                                                        // 1208
                                                                                                              // 1209
	var classof   = __webpack_require__(38)                                                                      // 1210
	  , ITERATOR  = __webpack_require__(16)('iterator')                                                          // 1211
	  , Iterators = __webpack_require__(55);                                                                     // 1212
	module.exports = __webpack_require__(9).getIteratorMethod = function(it){                                    // 1213
	  if(it != undefined)return it[ITERATOR] || it['@@iterator'] || Iterators[classof(it)];                      // 1214
	};                                                                                                           // 1215
                                                                                                              // 1216
/***/ },                                                                                                      // 1217
/* 62 */                                                                                                      // 1218
/***/ function(module, exports, __webpack_require__) {                                                        // 1219
                                                                                                              // 1220
	var SYMBOL_ITERATOR = __webpack_require__(16)('iterator')                                                    // 1221
	  , SAFE_CLOSING    = false;                                                                                 // 1222
	try {                                                                                                        // 1223
	  var riter = [7][SYMBOL_ITERATOR]();                                                                        // 1224
	  riter['return'] = function(){ SAFE_CLOSING = true; };                                                      // 1225
	  Array.from(riter, function(){ throw 2; });                                                                 // 1226
	} catch(e){ /* empty */ }                                                                                    // 1227
	module.exports = function(exec){                                                                             // 1228
	  if(!SAFE_CLOSING)return false;                                                                             // 1229
	  var safe = false;                                                                                          // 1230
	  try {                                                                                                      // 1231
	    var arr  = [7]                                                                                           // 1232
	      , iter = arr[SYMBOL_ITERATOR]();                                                                       // 1233
	    iter.next = function(){ safe = true; };                                                                  // 1234
	    arr[SYMBOL_ITERATOR] = function(){ return iter; };                                                       // 1235
	    exec(arr);                                                                                               // 1236
	  } catch(e){ /* empty */ }                                                                                  // 1237
	  return safe;                                                                                               // 1238
	};                                                                                                           // 1239
                                                                                                              // 1240
/***/ },                                                                                                      // 1241
/* 63 */                                                                                                      // 1242
/***/ function(module, exports, __webpack_require__) {                                                        // 1243
                                                                                                              // 1244
	'use strict';                                                                                                // 1245
	var $def = __webpack_require__(8);                                                                           // 1246
                                                                                                              // 1247
	// WebKit Array.of isn't generic                                                                             // 1248
	$def($def.S + $def.F * __webpack_require__(7)(function(){                                                    // 1249
	  function F(){}                                                                                             // 1250
	  return !(Array.of.call(F) instanceof F);                                                                   // 1251
	}), 'Array', {                                                                                               // 1252
	  // 22.1.2.3 Array.of( ...items)                                                                            // 1253
	  of: function of(/* ...args */){                                                                            // 1254
	    var index  = 0                                                                                           // 1255
	      , length = arguments.length                                                                            // 1256
	      , result = new (typeof this == 'function' ? this : Array)(length);                                     // 1257
	    while(length > index)result[index] = arguments[index++];                                                 // 1258
	    result.length = length;                                                                                  // 1259
	    return result;                                                                                           // 1260
	  }                                                                                                          // 1261
	});                                                                                                          // 1262
                                                                                                              // 1263
/***/ },                                                                                                      // 1264
/* 64 */                                                                                                      // 1265
/***/ function(module, exports, __webpack_require__) {                                                        // 1266
                                                                                                              // 1267
	__webpack_require__(65)(Array);                                                                              // 1268
                                                                                                              // 1269
/***/ },                                                                                                      // 1270
/* 65 */                                                                                                      // 1271
/***/ function(module, exports, __webpack_require__) {                                                        // 1272
                                                                                                              // 1273
	'use strict';                                                                                                // 1274
	var $       = __webpack_require__(3)                                                                         // 1275
	  , SPECIES = __webpack_require__(16)('species');                                                            // 1276
	module.exports = function(C){                                                                                // 1277
	  if(__webpack_require__(6) && !(SPECIES in C))$.setDesc(C, SPECIES, {                                       // 1278
	    configurable: true,                                                                                      // 1279
	    get: function(){ return this; }                                                                          // 1280
	  });                                                                                                        // 1281
	};                                                                                                           // 1282
                                                                                                              // 1283
/***/ },                                                                                                      // 1284
/* 66 */                                                                                                      // 1285
/***/ function(module, exports, __webpack_require__) {                                                        // 1286
                                                                                                              // 1287
	'use strict';                                                                                                // 1288
	var setUnscope = __webpack_require__(67)                                                                     // 1289
	  , step       = __webpack_require__(68)                                                                     // 1290
	  , Iterators  = __webpack_require__(55)                                                                     // 1291
	  , toIObject  = __webpack_require__(18);                                                                    // 1292
                                                                                                              // 1293
	// 22.1.3.4 Array.prototype.entries()                                                                        // 1294
	// 22.1.3.13 Array.prototype.keys()                                                                          // 1295
	// 22.1.3.29 Array.prototype.values()                                                                        // 1296
	// 22.1.3.30 Array.prototype[@@iterator]()                                                                   // 1297
	__webpack_require__(54)(Array, 'Array', function(iterated, kind){                                            // 1298
	  this._t = toIObject(iterated); // target                                                                   // 1299
	  this._i = 0;                   // next index                                                               // 1300
	  this._k = kind;                // kind                                                                     // 1301
	// 22.1.5.2.1 %ArrayIteratorPrototype%.next()                                                                // 1302
	}, function(){                                                                                               // 1303
	  var O     = this._t                                                                                        // 1304
	    , kind  = this._k                                                                                        // 1305
	    , index = this._i++;                                                                                     // 1306
	  if(!O || index >= O.length){                                                                               // 1307
	    this._t = undefined;                                                                                     // 1308
	    return step(1);                                                                                          // 1309
	  }                                                                                                          // 1310
	  if(kind == 'keys'  )return step(0, index);                                                                 // 1311
	  if(kind == 'values')return step(0, O[index]);                                                              // 1312
	  return step(0, [index, O[index]]);                                                                         // 1313
	}, 'values');                                                                                                // 1314
                                                                                                              // 1315
	// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)                                       // 1316
	Iterators.Arguments = Iterators.Array;                                                                       // 1317
                                                                                                              // 1318
	setUnscope('keys');                                                                                          // 1319
	setUnscope('values');                                                                                        // 1320
	setUnscope('entries');                                                                                       // 1321
                                                                                                              // 1322
/***/ },                                                                                                      // 1323
/* 67 */                                                                                                      // 1324
/***/ function(module, exports, __webpack_require__) {                                                        // 1325
                                                                                                              // 1326
	// 22.1.3.31 Array.prototype[@@unscopables]                                                                  // 1327
	var UNSCOPABLES = __webpack_require__(16)('unscopables');                                                    // 1328
	if([][UNSCOPABLES] == undefined)__webpack_require__(10)(Array.prototype, UNSCOPABLES, {});                   // 1329
	module.exports = function(key){                                                                              // 1330
	  [][UNSCOPABLES][key] = true;                                                                               // 1331
	};                                                                                                           // 1332
                                                                                                              // 1333
/***/ },                                                                                                      // 1334
/* 68 */                                                                                                      // 1335
/***/ function(module, exports) {                                                                             // 1336
                                                                                                              // 1337
	module.exports = function(done, value){                                                                      // 1338
	  return {value: value, done: !!done};                                                                       // 1339
	};                                                                                                           // 1340
                                                                                                              // 1341
/***/ },                                                                                                      // 1342
/* 69 */                                                                                                      // 1343
/***/ function(module, exports, __webpack_require__) {                                                        // 1344
                                                                                                              // 1345
	// 22.1.3.3 Array.prototype.copyWithin(target, start, end = this.length)                                     // 1346
	'use strict';                                                                                                // 1347
	var $def = __webpack_require__(8);                                                                           // 1348
                                                                                                              // 1349
	$def($def.P, 'Array', {copyWithin: __webpack_require__(70)});                                                // 1350
                                                                                                              // 1351
	__webpack_require__(67)('copyWithin');                                                                       // 1352
                                                                                                              // 1353
/***/ },                                                                                                      // 1354
/* 70 */                                                                                                      // 1355
/***/ function(module, exports, __webpack_require__) {                                                        // 1356
                                                                                                              // 1357
	// 22.1.3.3 Array.prototype.copyWithin(target, start, end = this.length)                                     // 1358
	'use strict';                                                                                                // 1359
	var toObject = __webpack_require__(30)                                                                       // 1360
	  , toIndex  = __webpack_require__(71)                                                                       // 1361
	  , toLength = __webpack_require__(60);                                                                      // 1362
                                                                                                              // 1363
	module.exports = [].copyWithin || function copyWithin(target/*= 0*/, start/*= 0, end = @length*/){           // 1364
	  var O     = toObject(this)                                                                                 // 1365
	    , len   = toLength(O.length)                                                                             // 1366
	    , to    = toIndex(target, len)                                                                           // 1367
	    , from  = toIndex(start, len)                                                                            // 1368
	    , end   = arguments[2]                                                                                   // 1369
	    , count = Math.min((end === undefined ? len : toIndex(end, len)) - from, len - to)                       // 1370
	    , inc   = 1;                                                                                             // 1371
	  if(from < to && to < from + count){                                                                        // 1372
	    inc  = -1;                                                                                               // 1373
	    from += count - 1;                                                                                       // 1374
	    to   += count - 1;                                                                                       // 1375
	  }                                                                                                          // 1376
	  while(count-- > 0){                                                                                        // 1377
	    if(from in O)O[to] = O[from];                                                                            // 1378
	    else delete O[to];                                                                                       // 1379
	    to   += inc;                                                                                             // 1380
	    from += inc;                                                                                             // 1381
	  } return O;                                                                                                // 1382
	};                                                                                                           // 1383
                                                                                                              // 1384
/***/ },                                                                                                      // 1385
/* 71 */                                                                                                      // 1386
/***/ function(module, exports, __webpack_require__) {                                                        // 1387
                                                                                                              // 1388
	var toInteger = __webpack_require__(53)                                                                      // 1389
	  , max       = Math.max                                                                                     // 1390
	  , min       = Math.min;                                                                                    // 1391
	module.exports = function(index, length){                                                                    // 1392
	  index = toInteger(index);                                                                                  // 1393
	  return index < 0 ? max(index + length, 0) : min(index, length);                                            // 1394
	};                                                                                                           // 1395
                                                                                                              // 1396
/***/ },                                                                                                      // 1397
/* 72 */                                                                                                      // 1398
/***/ function(module, exports, __webpack_require__) {                                                        // 1399
                                                                                                              // 1400
	// 22.1.3.6 Array.prototype.fill(value, start = 0, end = this.length)                                        // 1401
	var $def = __webpack_require__(8);                                                                           // 1402
                                                                                                              // 1403
	$def($def.P, 'Array', {fill: __webpack_require__(73)});                                                      // 1404
                                                                                                              // 1405
	__webpack_require__(67)('fill');                                                                             // 1406
                                                                                                              // 1407
/***/ },                                                                                                      // 1408
/* 73 */                                                                                                      // 1409
/***/ function(module, exports, __webpack_require__) {                                                        // 1410
                                                                                                              // 1411
	// 22.1.3.6 Array.prototype.fill(value, start = 0, end = this.length)                                        // 1412
	'use strict';                                                                                                // 1413
	var toObject = __webpack_require__(30)                                                                       // 1414
	  , toIndex  = __webpack_require__(71)                                                                       // 1415
	  , toLength = __webpack_require__(60);                                                                      // 1416
	module.exports = [].fill || function fill(value /*, start = 0, end = @length */){                            // 1417
	  var O      = toObject(this, true)                                                                          // 1418
	    , length = toLength(O.length)                                                                            // 1419
	    , index  = toIndex(arguments[1], length)                                                                 // 1420
	    , end    = arguments[2]                                                                                  // 1421
	    , endPos = end === undefined ? length : toIndex(end, length);                                            // 1422
	  while(endPos > index)O[index++] = value;                                                                   // 1423
	  return O;                                                                                                  // 1424
	};                                                                                                           // 1425
                                                                                                              // 1426
/***/ },                                                                                                      // 1427
/* 74 */                                                                                                      // 1428
/***/ function(module, exports, __webpack_require__) {                                                        // 1429
                                                                                                              // 1430
	'use strict';                                                                                                // 1431
	// 22.1.3.8 Array.prototype.find(predicate, thisArg = undefined)                                             // 1432
	var KEY    = 'find'                                                                                          // 1433
	  , $def   = __webpack_require__(8)                                                                          // 1434
	  , forced = true                                                                                            // 1435
	  , $find  = __webpack_require__(75)(5);                                                                     // 1436
	// Shouldn't skip holes                                                                                      // 1437
	if(KEY in [])Array(1)[KEY](function(){ forced = false; });                                                   // 1438
	$def($def.P + $def.F * forced, 'Array', {                                                                    // 1439
	  find: function find(callbackfn/*, that = undefined */){                                                    // 1440
	    return $find(this, callbackfn, arguments[1]);                                                            // 1441
	  }                                                                                                          // 1442
	});                                                                                                          // 1443
	__webpack_require__(67)(KEY);                                                                                // 1444
                                                                                                              // 1445
/***/ },                                                                                                      // 1446
/* 75 */                                                                                                      // 1447
/***/ function(module, exports, __webpack_require__) {                                                        // 1448
                                                                                                              // 1449
	// 0 -> Array#forEach                                                                                        // 1450
	// 1 -> Array#map                                                                                            // 1451
	// 2 -> Array#filter                                                                                         // 1452
	// 3 -> Array#some                                                                                           // 1453
	// 4 -> Array#every                                                                                          // 1454
	// 5 -> Array#find                                                                                           // 1455
	// 6 -> Array#findIndex                                                                                      // 1456
	var ctx      = __webpack_require__(35)                                                                       // 1457
	  , isObject = __webpack_require__(25)                                                                       // 1458
	  , IObject  = __webpack_require__(19)                                                                       // 1459
	  , toObject = __webpack_require__(30)                                                                       // 1460
	  , toLength = __webpack_require__(60)                                                                       // 1461
	  , isArray  = __webpack_require__(24)                                                                       // 1462
	  , SPECIES  = __webpack_require__(16)('species');                                                           // 1463
	// 9.4.2.3 ArraySpeciesCreate(originalArray, length)                                                         // 1464
	var ASC = function(original, length){                                                                        // 1465
	  var C;                                                                                                     // 1466
	  if(isArray(original) && isObject(C = original.constructor)){                                               // 1467
	    C = C[SPECIES];                                                                                          // 1468
	    if(C === null)C = undefined;                                                                             // 1469
	  } return new(C === undefined ? Array : C)(length);                                                         // 1470
	};                                                                                                           // 1471
	module.exports = function(TYPE){                                                                             // 1472
	  var IS_MAP        = TYPE == 1                                                                              // 1473
	    , IS_FILTER     = TYPE == 2                                                                              // 1474
	    , IS_SOME       = TYPE == 3                                                                              // 1475
	    , IS_EVERY      = TYPE == 4                                                                              // 1476
	    , IS_FIND_INDEX = TYPE == 6                                                                              // 1477
	    , NO_HOLES      = TYPE == 5 || IS_FIND_INDEX;                                                            // 1478
	  return function($this, callbackfn, that){                                                                  // 1479
	    var O      = toObject($this)                                                                             // 1480
	      , self   = IObject(O)                                                                                  // 1481
	      , f      = ctx(callbackfn, that, 3)                                                                    // 1482
	      , length = toLength(self.length)                                                                       // 1483
	      , index  = 0                                                                                           // 1484
	      , result = IS_MAP ? ASC($this, length) : IS_FILTER ? ASC($this, 0) : undefined                         // 1485
	      , val, res;                                                                                            // 1486
	    for(;length > index; index++)if(NO_HOLES || index in self){                                              // 1487
	      val = self[index];                                                                                     // 1488
	      res = f(val, index, O);                                                                                // 1489
	      if(TYPE){                                                                                              // 1490
	        if(IS_MAP)result[index] = res;            // map                                                     // 1491
	        else if(res)switch(TYPE){                                                                            // 1492
	          case 3: return true;                    // some                                                    // 1493
	          case 5: return val;                     // find                                                    // 1494
	          case 6: return index;                   // findIndex                                               // 1495
	          case 2: result.push(val);               // filter                                                  // 1496
	        } else if(IS_EVERY)return false;          // every                                                   // 1497
	      }                                                                                                      // 1498
	    }                                                                                                        // 1499
	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;                                     // 1500
	  };                                                                                                         // 1501
	};                                                                                                           // 1502
                                                                                                              // 1503
/***/ },                                                                                                      // 1504
/* 76 */                                                                                                      // 1505
/***/ function(module, exports, __webpack_require__) {                                                        // 1506
                                                                                                              // 1507
	'use strict';                                                                                                // 1508
	// 22.1.3.9 Array.prototype.findIndex(predicate, thisArg = undefined)                                        // 1509
	var KEY    = 'findIndex'                                                                                     // 1510
	  , $def   = __webpack_require__(8)                                                                          // 1511
	  , forced = true                                                                                            // 1512
	  , $find  = __webpack_require__(75)(6);                                                                     // 1513
	// Shouldn't skip holes                                                                                      // 1514
	if(KEY in [])Array(1)[KEY](function(){ forced = false; });                                                   // 1515
	$def($def.P + $def.F * forced, 'Array', {                                                                    // 1516
	  findIndex: function findIndex(callbackfn/*, that = undefined */){                                          // 1517
	    return $find(this, callbackfn, arguments[1]);                                                            // 1518
	  }                                                                                                          // 1519
	});                                                                                                          // 1520
	__webpack_require__(67)(KEY);                                                                                // 1521
                                                                                                              // 1522
/***/ },                                                                                                      // 1523
/* 77 */                                                                                                      // 1524
/***/ function(module, exports, __webpack_require__) {                                                        // 1525
                                                                                                              // 1526
	__webpack_require__(78);                                                                                     // 1527
	__webpack_require__(79);                                                                                     // 1528
	__webpack_require__(80);                                                                                     // 1529
	__webpack_require__(51);                                                                                     // 1530
	__webpack_require__(82);                                                                                     // 1531
	__webpack_require__(83);                                                                                     // 1532
	__webpack_require__(87);                                                                                     // 1533
	__webpack_require__(88);                                                                                     // 1534
	__webpack_require__(90);                                                                                     // 1535
	__webpack_require__(91);                                                                                     // 1536
	__webpack_require__(93);                                                                                     // 1537
	__webpack_require__(94);                                                                                     // 1538
	__webpack_require__(95);                                                                                     // 1539
	module.exports = __webpack_require__(9).String;                                                              // 1540
                                                                                                              // 1541
/***/ },                                                                                                      // 1542
/* 78 */                                                                                                      // 1543
/***/ function(module, exports, __webpack_require__) {                                                        // 1544
                                                                                                              // 1545
	var $def    = __webpack_require__(8)                                                                         // 1546
	  , toIndex = __webpack_require__(71)                                                                        // 1547
	  , fromCharCode = String.fromCharCode                                                                       // 1548
	  , $fromCodePoint = String.fromCodePoint;                                                                   // 1549
                                                                                                              // 1550
	// length should be 1, old FF problem                                                                        // 1551
	$def($def.S + $def.F * (!!$fromCodePoint && $fromCodePoint.length != 1), 'String', {                         // 1552
	  // 21.1.2.2 String.fromCodePoint(...codePoints)                                                            // 1553
	  fromCodePoint: function fromCodePoint(x){ // eslint-disable-line no-unused-vars                            // 1554
	    var res = []                                                                                             // 1555
	      , len = arguments.length                                                                               // 1556
	      , i   = 0                                                                                              // 1557
	      , code;                                                                                                // 1558
	    while(len > i){                                                                                          // 1559
	      code = +arguments[i++];                                                                                // 1560
	      if(toIndex(code, 0x10ffff) !== code)throw RangeError(code + ' is not a valid code point');             // 1561
	      res.push(code < 0x10000                                                                                // 1562
	        ? fromCharCode(code)                                                                                 // 1563
	        : fromCharCode(((code -= 0x10000) >> 10) + 0xd800, code % 0x400 + 0xdc00)                            // 1564
	      );                                                                                                     // 1565
	    } return res.join('');                                                                                   // 1566
	  }                                                                                                          // 1567
	});                                                                                                          // 1568
                                                                                                              // 1569
/***/ },                                                                                                      // 1570
/* 79 */                                                                                                      // 1571
/***/ function(module, exports, __webpack_require__) {                                                        // 1572
                                                                                                              // 1573
	var $def      = __webpack_require__(8)                                                                       // 1574
	  , toIObject = __webpack_require__(18)                                                                      // 1575
	  , toLength  = __webpack_require__(60);                                                                     // 1576
                                                                                                              // 1577
	$def($def.S, 'String', {                                                                                     // 1578
	  // 21.1.2.4 String.raw(callSite, ...substitutions)                                                         // 1579
	  raw: function raw(callSite){                                                                               // 1580
	    var tpl = toIObject(callSite.raw)                                                                        // 1581
	      , len = toLength(tpl.length)                                                                           // 1582
	      , sln = arguments.length                                                                               // 1583
	      , res = []                                                                                             // 1584
	      , i   = 0;                                                                                             // 1585
	    while(len > i){                                                                                          // 1586
	      res.push(String(tpl[i++]));                                                                            // 1587
	      if(i < sln)res.push(String(arguments[i]));                                                             // 1588
	    } return res.join('');                                                                                   // 1589
	  }                                                                                                          // 1590
	});                                                                                                          // 1591
                                                                                                              // 1592
/***/ },                                                                                                      // 1593
/* 80 */                                                                                                      // 1594
/***/ function(module, exports, __webpack_require__) {                                                        // 1595
                                                                                                              // 1596
	'use strict';                                                                                                // 1597
	// 21.1.3.25 String.prototype.trim()                                                                         // 1598
	__webpack_require__(81)('trim', function($trim){                                                             // 1599
	  return function trim(){                                                                                    // 1600
	    return $trim(this, 3);                                                                                   // 1601
	  };                                                                                                         // 1602
	});                                                                                                          // 1603
                                                                                                              // 1604
/***/ },                                                                                                      // 1605
/* 81 */                                                                                                      // 1606
/***/ function(module, exports, __webpack_require__) {                                                        // 1607
                                                                                                              // 1608
	// 1 -> String#trimLeft                                                                                      // 1609
	// 2 -> String#trimRight                                                                                     // 1610
	// 3 -> String#trim                                                                                          // 1611
	var trim = function(string, TYPE){                                                                           // 1612
	  string = String(defined(string));                                                                          // 1613
	  if(TYPE & 1)string = string.replace(ltrim, '');                                                            // 1614
	  if(TYPE & 2)string = string.replace(rtrim, '');                                                            // 1615
	  return string;                                                                                             // 1616
	};                                                                                                           // 1617
                                                                                                              // 1618
	var $def    = __webpack_require__(8)                                                                         // 1619
	  , defined = __webpack_require__(21)                                                                        // 1620
	  , spaces  = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003' +                           // 1621
	      '\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'                       // 1622
	  , space   = '[' + spaces + ']'                                                                             // 1623
	  , non     = '\u200b\u0085'                                                                                 // 1624
	  , ltrim   = RegExp('^' + space + space + '*')                                                              // 1625
	  , rtrim   = RegExp(space + space + '*$');                                                                  // 1626
                                                                                                              // 1627
	module.exports = function(KEY, exec){                                                                        // 1628
	  var exp  = {};                                                                                             // 1629
	  exp[KEY] = exec(trim);                                                                                     // 1630
	  $def($def.P + $def.F * __webpack_require__(7)(function(){                                                  // 1631
	    return !!spaces[KEY]() || non[KEY]() != non;                                                             // 1632
	  }), 'String', exp);                                                                                        // 1633
	};                                                                                                           // 1634
                                                                                                              // 1635
/***/ },                                                                                                      // 1636
/* 82 */                                                                                                      // 1637
/***/ function(module, exports, __webpack_require__) {                                                        // 1638
                                                                                                              // 1639
	'use strict';                                                                                                // 1640
	var $def = __webpack_require__(8)                                                                            // 1641
	  , $at  = __webpack_require__(52)(false);                                                                   // 1642
	$def($def.P, 'String', {                                                                                     // 1643
	  // 21.1.3.3 String.prototype.codePointAt(pos)                                                              // 1644
	  codePointAt: function codePointAt(pos){                                                                    // 1645
	    return $at(this, pos);                                                                                   // 1646
	  }                                                                                                          // 1647
	});                                                                                                          // 1648
                                                                                                              // 1649
/***/ },                                                                                                      // 1650
/* 83 */                                                                                                      // 1651
/***/ function(module, exports, __webpack_require__) {                                                        // 1652
                                                                                                              // 1653
	// 21.1.3.6 String.prototype.endsWith(searchString [, endPosition])                                          // 1654
	'use strict';                                                                                                // 1655
	var $def      = __webpack_require__(8)                                                                       // 1656
	  , toLength  = __webpack_require__(60)                                                                      // 1657
	  , context   = __webpack_require__(84)                                                                      // 1658
	  , ENDS_WITH = 'endsWith'                                                                                   // 1659
	  , $endsWith = ''[ENDS_WITH];                                                                               // 1660
                                                                                                              // 1661
	$def($def.P + $def.F * __webpack_require__(86)(ENDS_WITH), 'String', {                                       // 1662
	  endsWith: function endsWith(searchString /*, endPosition = @length */){                                    // 1663
	    var that = context(this, searchString, ENDS_WITH)                                                        // 1664
	      , endPosition = arguments[1]                                                                           // 1665
	      , len    = toLength(that.length)                                                                       // 1666
	      , end    = endPosition === undefined ? len : Math.min(toLength(endPosition), len)                      // 1667
	      , search = String(searchString);                                                                       // 1668
	    return $endsWith                                                                                         // 1669
	      ? $endsWith.call(that, search, end)                                                                    // 1670
	      : that.slice(end - search.length, end) === search;                                                     // 1671
	  }                                                                                                          // 1672
	});                                                                                                          // 1673
                                                                                                              // 1674
/***/ },                                                                                                      // 1675
/* 84 */                                                                                                      // 1676
/***/ function(module, exports, __webpack_require__) {                                                        // 1677
                                                                                                              // 1678
	// helper for String#{startsWith, endsWith, includes}                                                        // 1679
	var isRegExp = __webpack_require__(85)                                                                       // 1680
	  , defined  = __webpack_require__(21);                                                                      // 1681
                                                                                                              // 1682
	module.exports = function(that, searchString, NAME){                                                         // 1683
	  if(isRegExp(searchString))throw TypeError('String#' + NAME + " doesn't accept regex!");                    // 1684
	  return String(defined(that));                                                                              // 1685
	};                                                                                                           // 1686
                                                                                                              // 1687
/***/ },                                                                                                      // 1688
/* 85 */                                                                                                      // 1689
/***/ function(module, exports, __webpack_require__) {                                                        // 1690
                                                                                                              // 1691
	// 7.2.8 IsRegExp(argument)                                                                                  // 1692
	var isObject = __webpack_require__(25)                                                                       // 1693
	  , cof      = __webpack_require__(20)                                                                       // 1694
	  , MATCH    = __webpack_require__(16)('match');                                                             // 1695
	module.exports = function(it){                                                                               // 1696
	  var isRegExp;                                                                                              // 1697
	  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == 'RegExp');          // 1698
	};                                                                                                           // 1699
                                                                                                              // 1700
/***/ },                                                                                                      // 1701
/* 86 */                                                                                                      // 1702
/***/ function(module, exports, __webpack_require__) {                                                        // 1703
                                                                                                              // 1704
	module.exports = function(KEY){                                                                              // 1705
	  var re = /./;                                                                                              // 1706
	  try {                                                                                                      // 1707
	    '/./'[KEY](re);                                                                                          // 1708
	  } catch(e){                                                                                                // 1709
	    try {                                                                                                    // 1710
	      re[__webpack_require__(16)('match')] = false;                                                          // 1711
	      return !'/./'[KEY](re);                                                                                // 1712
	    } catch(e){ /* empty */ }                                                                                // 1713
	  } return true;                                                                                             // 1714
	};                                                                                                           // 1715
                                                                                                              // 1716
/***/ },                                                                                                      // 1717
/* 87 */                                                                                                      // 1718
/***/ function(module, exports, __webpack_require__) {                                                        // 1719
                                                                                                              // 1720
	// 21.1.3.7 String.prototype.includes(searchString, position = 0)                                            // 1721
	'use strict';                                                                                                // 1722
	var $def     = __webpack_require__(8)                                                                        // 1723
	  , context  = __webpack_require__(84)                                                                       // 1724
	  , INCLUDES = 'includes';                                                                                   // 1725
                                                                                                              // 1726
	$def($def.P + $def.F * __webpack_require__(86)(INCLUDES), 'String', {                                        // 1727
	  includes: function includes(searchString /*, position = 0 */){                                             // 1728
	    return !!~context(this, searchString, INCLUDES).indexOf(searchString, arguments[1]);                     // 1729
	  }                                                                                                          // 1730
	});                                                                                                          // 1731
                                                                                                              // 1732
/***/ },                                                                                                      // 1733
/* 88 */                                                                                                      // 1734
/***/ function(module, exports, __webpack_require__) {                                                        // 1735
                                                                                                              // 1736
	var $def = __webpack_require__(8);                                                                           // 1737
                                                                                                              // 1738
	$def($def.P, 'String', {                                                                                     // 1739
	  // 21.1.3.13 String.prototype.repeat(count)                                                                // 1740
	  repeat: __webpack_require__(89)                                                                            // 1741
	});                                                                                                          // 1742
                                                                                                              // 1743
/***/ },                                                                                                      // 1744
/* 89 */                                                                                                      // 1745
/***/ function(module, exports, __webpack_require__) {                                                        // 1746
                                                                                                              // 1747
	'use strict';                                                                                                // 1748
	var toInteger = __webpack_require__(53)                                                                      // 1749
	  , defined   = __webpack_require__(21);                                                                     // 1750
                                                                                                              // 1751
	module.exports = function repeat(count){                                                                     // 1752
	  var str = String(defined(this))                                                                            // 1753
	    , res = ''                                                                                               // 1754
	    , n   = toInteger(count);                                                                                // 1755
	  if(n < 0 || n == Infinity)throw RangeError("Count can't be negative");                                     // 1756
	  for(;n > 0; (n >>>= 1) && (str += str))if(n & 1)res += str;                                                // 1757
	  return res;                                                                                                // 1758
	};                                                                                                           // 1759
                                                                                                              // 1760
/***/ },                                                                                                      // 1761
/* 90 */                                                                                                      // 1762
/***/ function(module, exports, __webpack_require__) {                                                        // 1763
                                                                                                              // 1764
	// 21.1.3.18 String.prototype.startsWith(searchString [, position ])                                         // 1765
	'use strict';                                                                                                // 1766
	var $def        = __webpack_require__(8)                                                                     // 1767
	  , toLength    = __webpack_require__(60)                                                                    // 1768
	  , context     = __webpack_require__(84)                                                                    // 1769
	  , STARTS_WITH = 'startsWith'                                                                               // 1770
	  , $startsWith = ''[STARTS_WITH];                                                                           // 1771
                                                                                                              // 1772
	$def($def.P + $def.F * __webpack_require__(86)(STARTS_WITH), 'String', {                                     // 1773
	  startsWith: function startsWith(searchString /*, position = 0 */){                                         // 1774
	    var that   = context(this, searchString, STARTS_WITH)                                                    // 1775
	      , index  = toLength(Math.min(arguments[1], that.length))                                               // 1776
	      , search = String(searchString);                                                                       // 1777
	    return $startsWith                                                                                       // 1778
	      ? $startsWith.call(that, search, index)                                                                // 1779
	      : that.slice(index, index + search.length) === search;                                                 // 1780
	  }                                                                                                          // 1781
	});                                                                                                          // 1782
                                                                                                              // 1783
/***/ },                                                                                                      // 1784
/* 91 */                                                                                                      // 1785
/***/ function(module, exports, __webpack_require__) {                                                        // 1786
                                                                                                              // 1787
	// @@match logic                                                                                             // 1788
	__webpack_require__(92)('match', 1, function(defined, MATCH){                                                // 1789
	  // 21.1.3.11 String.prototype.match(regexp)                                                                // 1790
	  return function match(regexp){                                                                             // 1791
	    'use strict';                                                                                            // 1792
	    var O  = defined(this)                                                                                   // 1793
	      , fn = regexp == undefined ? undefined : regexp[MATCH];                                                // 1794
	    return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));                     // 1795
	  };                                                                                                         // 1796
	});                                                                                                          // 1797
                                                                                                              // 1798
/***/ },                                                                                                      // 1799
/* 92 */                                                                                                      // 1800
/***/ function(module, exports, __webpack_require__) {                                                        // 1801
                                                                                                              // 1802
	'use strict';                                                                                                // 1803
	module.exports = function(KEY, length, exec){                                                                // 1804
	  var defined  = __webpack_require__(21)                                                                     // 1805
	    , SYMBOL   = __webpack_require__(16)(KEY)                                                                // 1806
	    , original = ''[KEY];                                                                                    // 1807
	  if(__webpack_require__(7)(function(){                                                                      // 1808
	    var O = {};                                                                                              // 1809
	    O[SYMBOL] = function(){ return 7; };                                                                     // 1810
	    return ''[KEY](O) != 7;                                                                                  // 1811
	  })){                                                                                                       // 1812
	    __webpack_require__(12)(String.prototype, KEY, exec(defined, SYMBOL, original));                         // 1813
	    __webpack_require__(10)(RegExp.prototype, SYMBOL, length == 2                                            // 1814
	      // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)                                          // 1815
	      // 21.2.5.11 RegExp.prototype[@@split](string, limit)                                                  // 1816
	      ? function(string, arg){ return original.call(string, this, arg); }                                    // 1817
	      // 21.2.5.6 RegExp.prototype[@@match](string)                                                          // 1818
	      // 21.2.5.9 RegExp.prototype[@@search](string)                                                         // 1819
	      : function(string){ return original.call(string, this); }                                              // 1820
	    );                                                                                                       // 1821
	  }                                                                                                          // 1822
	};                                                                                                           // 1823
                                                                                                              // 1824
/***/ },                                                                                                      // 1825
/* 93 */                                                                                                      // 1826
/***/ function(module, exports, __webpack_require__) {                                                        // 1827
                                                                                                              // 1828
	// @@replace logic                                                                                           // 1829
	__webpack_require__(92)('replace', 2, function(defined, REPLACE, $replace){                                  // 1830
	  // 21.1.3.14 String.prototype.replace(searchValue, replaceValue)                                           // 1831
	  return function replace(searchValue, replaceValue){                                                        // 1832
	    'use strict';                                                                                            // 1833
	    var O  = defined(this)                                                                                   // 1834
	      , fn = searchValue == undefined ? undefined : searchValue[REPLACE];                                    // 1835
	    return fn !== undefined                                                                                  // 1836
	      ? fn.call(searchValue, O, replaceValue)                                                                // 1837
	      : $replace.call(String(O), searchValue, replaceValue);                                                 // 1838
	  };                                                                                                         // 1839
	});                                                                                                          // 1840
                                                                                                              // 1841
/***/ },                                                                                                      // 1842
/* 94 */                                                                                                      // 1843
/***/ function(module, exports, __webpack_require__) {                                                        // 1844
                                                                                                              // 1845
	// @@search logic                                                                                            // 1846
	__webpack_require__(92)('search', 1, function(defined, SEARCH){                                              // 1847
	  // 21.1.3.15 String.prototype.search(regexp)                                                               // 1848
	  return function search(regexp){                                                                            // 1849
	    'use strict';                                                                                            // 1850
	    var O  = defined(this)                                                                                   // 1851
	      , fn = regexp == undefined ? undefined : regexp[SEARCH];                                               // 1852
	    return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[SEARCH](String(O));                    // 1853
	  };                                                                                                         // 1854
	});                                                                                                          // 1855
                                                                                                              // 1856
/***/ },                                                                                                      // 1857
/* 95 */                                                                                                      // 1858
/***/ function(module, exports, __webpack_require__) {                                                        // 1859
                                                                                                              // 1860
	// @@split logic                                                                                             // 1861
	__webpack_require__(92)('split', 2, function(defined, SPLIT, $split){                                        // 1862
	  // 21.1.3.17 String.prototype.split(separator, limit)                                                      // 1863
	  return function split(separator, limit){                                                                   // 1864
	    'use strict';                                                                                            // 1865
	    var O  = defined(this)                                                                                   // 1866
	      , fn = separator == undefined ? undefined : separator[SPLIT];                                          // 1867
	    return fn !== undefined                                                                                  // 1868
	      ? fn.call(separator, O, limit)                                                                         // 1869
	      : $split.call(String(O), separator, limit);                                                            // 1870
	  };                                                                                                         // 1871
	});                                                                                                          // 1872
                                                                                                              // 1873
/***/ },                                                                                                      // 1874
/* 96 */                                                                                                      // 1875
/***/ function(module, exports, __webpack_require__) {                                                        // 1876
                                                                                                              // 1877
	__webpack_require__(97);                                                                                     // 1878
	__webpack_require__(98);                                                                                     // 1879
	module.exports = __webpack_require__(9).Function;                                                            // 1880
                                                                                                              // 1881
/***/ },                                                                                                      // 1882
/* 97 */                                                                                                      // 1883
/***/ function(module, exports, __webpack_require__) {                                                        // 1884
                                                                                                              // 1885
	var setDesc    = __webpack_require__(3).setDesc                                                              // 1886
	  , createDesc = __webpack_require__(11)                                                                     // 1887
	  , has        = __webpack_require__(5)                                                                      // 1888
	  , FProto     = Function.prototype                                                                          // 1889
	  , nameRE     = /^\s*function ([^ (]*)/                                                                     // 1890
	  , NAME       = 'name';                                                                                     // 1891
	// 19.2.4.2 name                                                                                             // 1892
	NAME in FProto || __webpack_require__(6) && setDesc(FProto, NAME, {                                          // 1893
	  configurable: true,                                                                                        // 1894
	  get: function(){                                                                                           // 1895
	    var match = ('' + this).match(nameRE)                                                                    // 1896
	      , name  = match ? match[1] : '';                                                                       // 1897
	    has(this, NAME) || setDesc(this, NAME, createDesc(5, name));                                             // 1898
	    return name;                                                                                             // 1899
	  }                                                                                                          // 1900
	});                                                                                                          // 1901
                                                                                                              // 1902
/***/ },                                                                                                      // 1903
/* 98 */                                                                                                      // 1904
/***/ function(module, exports, __webpack_require__) {                                                        // 1905
                                                                                                              // 1906
	'use strict';                                                                                                // 1907
	var $             = __webpack_require__(3)                                                                   // 1908
	  , isObject      = __webpack_require__(25)                                                                  // 1909
	  , HAS_INSTANCE  = __webpack_require__(16)('hasInstance')                                                   // 1910
	  , FunctionProto = Function.prototype;                                                                      // 1911
	// 19.2.3.6 Function.prototype[@@hasInstance](V)                                                             // 1912
	if(!(HAS_INSTANCE in FunctionProto))$.setDesc(FunctionProto, HAS_INSTANCE, {value: function(O){              // 1913
	  if(typeof this != 'function' || !isObject(O))return false;                                                 // 1914
	  if(!isObject(this.prototype))return O instanceof this;                                                     // 1915
	  // for environment w/o native `@@hasInstance` logic enough `instanceof`, but add this:                     // 1916
	  while(O = $.getProto(O))if(this.prototype === O)return true;                                               // 1917
	  return false;                                                                                              // 1918
	}});                                                                                                         // 1919
                                                                                                              // 1920
/***/ },                                                                                                      // 1921
/* 99 */                                                                                                      // 1922
/***/ function(module, exports, __webpack_require__) {                                                        // 1923
                                                                                                              // 1924
	__webpack_require__(2);                                                                                      // 1925
	module.exports = __webpack_require__(9).Symbol;                                                              // 1926
                                                                                                              // 1927
/***/ },                                                                                                      // 1928
/* 100 */                                                                                                     // 1929
/***/ function(module, exports, __webpack_require__) {                                                        // 1930
                                                                                                              // 1931
	__webpack_require__(37);                                                                                     // 1932
	__webpack_require__(51);                                                                                     // 1933
	__webpack_require__(101);                                                                                    // 1934
	__webpack_require__(102);                                                                                    // 1935
	module.exports = __webpack_require__(9).Map;                                                                 // 1936
                                                                                                              // 1937
/***/ },                                                                                                      // 1938
/* 101 */                                                                                                     // 1939
/***/ function(module, exports, __webpack_require__) {                                                        // 1940
                                                                                                              // 1941
	__webpack_require__(66);                                                                                     // 1942
	var global      = __webpack_require__(4)                                                                     // 1943
	  , hide        = __webpack_require__(10)                                                                    // 1944
	  , Iterators   = __webpack_require__(55)                                                                    // 1945
	  , ITERATOR    = __webpack_require__(16)('iterator')                                                        // 1946
	  , NL          = global.NodeList                                                                            // 1947
	  , HTC         = global.HTMLCollection                                                                      // 1948
	  , NLProto     = NL && NL.prototype                                                                         // 1949
	  , HTCProto    = HTC && HTC.prototype                                                                       // 1950
	  , ArrayValues = Iterators.NodeList = Iterators.HTMLCollection = Iterators.Array;                           // 1951
	if(NL && !(ITERATOR in NLProto))hide(NLProto, ITERATOR, ArrayValues);                                        // 1952
	if(HTC && !(ITERATOR in HTCProto))hide(HTCProto, ITERATOR, ArrayValues);                                     // 1953
                                                                                                              // 1954
/***/ },                                                                                                      // 1955
/* 102 */                                                                                                     // 1956
/***/ function(module, exports, __webpack_require__) {                                                        // 1957
                                                                                                              // 1958
	'use strict';                                                                                                // 1959
	var strong = __webpack_require__(103);                                                                       // 1960
                                                                                                              // 1961
	// 23.1 Map Objects                                                                                          // 1962
	__webpack_require__(107)('Map', function(get){                                                               // 1963
	  return function Map(){ return get(this, arguments[0]); };                                                  // 1964
	}, {                                                                                                         // 1965
	  // 23.1.3.6 Map.prototype.get(key)                                                                         // 1966
	  get: function get(key){                                                                                    // 1967
	    var entry = strong.getEntry(this, key);                                                                  // 1968
	    return entry && entry.v;                                                                                 // 1969
	  },                                                                                                         // 1970
	  // 23.1.3.9 Map.prototype.set(key, value)                                                                  // 1971
	  set: function set(key, value){                                                                             // 1972
	    return strong.def(this, key === 0 ? 0 : key, value);                                                     // 1973
	  }                                                                                                          // 1974
	}, strong, true);                                                                                            // 1975
                                                                                                              // 1976
/***/ },                                                                                                      // 1977
/* 103 */                                                                                                     // 1978
/***/ function(module, exports, __webpack_require__) {                                                        // 1979
                                                                                                              // 1980
	'use strict';                                                                                                // 1981
	var $            = __webpack_require__(3)                                                                    // 1982
	  , hide         = __webpack_require__(10)                                                                   // 1983
	  , ctx          = __webpack_require__(35)                                                                   // 1984
	  , species      = __webpack_require__(65)                                                                   // 1985
	  , strictNew    = __webpack_require__(104)                                                                  // 1986
	  , defined      = __webpack_require__(21)                                                                   // 1987
	  , forOf        = __webpack_require__(105)                                                                  // 1988
	  , step         = __webpack_require__(68)                                                                   // 1989
	  , ID           = __webpack_require__(13)('id')                                                             // 1990
	  , $has         = __webpack_require__(5)                                                                    // 1991
	  , isObject     = __webpack_require__(25)                                                                   // 1992
	  , isExtensible = Object.isExtensible || isObject                                                           // 1993
	  , SUPPORT_DESC = __webpack_require__(6)                                                                    // 1994
	  , SIZE         = SUPPORT_DESC ? '_s' : 'size'                                                              // 1995
	  , id           = 0;                                                                                        // 1996
                                                                                                              // 1997
	var fastKey = function(it, create){                                                                          // 1998
	  // return primitive with prefix                                                                            // 1999
	  if(!isObject(it))return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;             // 2000
	  if(!$has(it, ID)){                                                                                         // 2001
	    // can't set id to frozen object                                                                         // 2002
	    if(!isExtensible(it))return 'F';                                                                         // 2003
	    // not necessary to add id                                                                               // 2004
	    if(!create)return 'E';                                                                                   // 2005
	    // add missing object id                                                                                 // 2006
	    hide(it, ID, ++id);                                                                                      // 2007
	  // return object id with prefix                                                                            // 2008
	  } return 'O' + it[ID];                                                                                     // 2009
	};                                                                                                           // 2010
                                                                                                              // 2011
	var getEntry = function(that, key){                                                                          // 2012
	  // fast case                                                                                               // 2013
	  var index = fastKey(key), entry;                                                                           // 2014
	  if(index !== 'F')return that._i[index];                                                                    // 2015
	  // frozen object case                                                                                      // 2016
	  for(entry = that._f; entry; entry = entry.n){                                                              // 2017
	    if(entry.k == key)return entry;                                                                          // 2018
	  }                                                                                                          // 2019
	};                                                                                                           // 2020
                                                                                                              // 2021
	module.exports = {                                                                                           // 2022
	  getConstructor: function(wrapper, NAME, IS_MAP, ADDER){                                                    // 2023
	    var C = wrapper(function(that, iterable){                                                                // 2024
	      strictNew(that, C, NAME);                                                                              // 2025
	      that._i = $.create(null); // index                                                                     // 2026
	      that._f = undefined;      // first entry                                                               // 2027
	      that._l = undefined;      // last entry                                                                // 2028
	      that[SIZE] = 0;           // size                                                                      // 2029
	      if(iterable != undefined)forOf(iterable, IS_MAP, that[ADDER], that);                                   // 2030
	    });                                                                                                      // 2031
	    __webpack_require__(106)(C.prototype, {                                                                  // 2032
	      // 23.1.3.1 Map.prototype.clear()                                                                      // 2033
	      // 23.2.3.2 Set.prototype.clear()                                                                      // 2034
	      clear: function clear(){                                                                               // 2035
	        for(var that = this, data = that._i, entry = that._f; entry; entry = entry.n){                       // 2036
	          entry.r = true;                                                                                    // 2037
	          if(entry.p)entry.p = entry.p.n = undefined;                                                        // 2038
	          delete data[entry.i];                                                                              // 2039
	        }                                                                                                    // 2040
	        that._f = that._l = undefined;                                                                       // 2041
	        that[SIZE] = 0;                                                                                      // 2042
	      },                                                                                                     // 2043
	      // 23.1.3.3 Map.prototype.delete(key)                                                                  // 2044
	      // 23.2.3.4 Set.prototype.delete(value)                                                                // 2045
	      'delete': function(key){                                                                               // 2046
	        var that  = this                                                                                     // 2047
	          , entry = getEntry(that, key);                                                                     // 2048
	        if(entry){                                                                                           // 2049
	          var next = entry.n                                                                                 // 2050
	            , prev = entry.p;                                                                                // 2051
	          delete that._i[entry.i];                                                                           // 2052
	          entry.r = true;                                                                                    // 2053
	          if(prev)prev.n = next;                                                                             // 2054
	          if(next)next.p = prev;                                                                             // 2055
	          if(that._f == entry)that._f = next;                                                                // 2056
	          if(that._l == entry)that._l = prev;                                                                // 2057
	          that[SIZE]--;                                                                                      // 2058
	        } return !!entry;                                                                                    // 2059
	      },                                                                                                     // 2060
	      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)                                     // 2061
	      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)                                     // 2062
	      forEach: function forEach(callbackfn /*, that = undefined */){                                         // 2063
	        var f = ctx(callbackfn, arguments[1], 3)                                                             // 2064
	          , entry;                                                                                           // 2065
	        while(entry = entry ? entry.n : this._f){                                                            // 2066
	          f(entry.v, entry.k, this);                                                                         // 2067
	          // revert to the last existing entry                                                               // 2068
	          while(entry && entry.r)entry = entry.p;                                                            // 2069
	        }                                                                                                    // 2070
	      },                                                                                                     // 2071
	      // 23.1.3.7 Map.prototype.has(key)                                                                     // 2072
	      // 23.2.3.7 Set.prototype.has(value)                                                                   // 2073
	      has: function has(key){                                                                                // 2074
	        return !!getEntry(this, key);                                                                        // 2075
	      }                                                                                                      // 2076
	    });                                                                                                      // 2077
	    if(SUPPORT_DESC)$.setDesc(C.prototype, 'size', {                                                         // 2078
	      get: function(){                                                                                       // 2079
	        return defined(this[SIZE]);                                                                          // 2080
	      }                                                                                                      // 2081
	    });                                                                                                      // 2082
	    return C;                                                                                                // 2083
	  },                                                                                                         // 2084
	  def: function(that, key, value){                                                                           // 2085
	    var entry = getEntry(that, key)                                                                          // 2086
	      , prev, index;                                                                                         // 2087
	    // change existing entry                                                                                 // 2088
	    if(entry){                                                                                               // 2089
	      entry.v = value;                                                                                       // 2090
	    // create new entry                                                                                      // 2091
	    } else {                                                                                                 // 2092
	      that._l = entry = {                                                                                    // 2093
	        i: index = fastKey(key, true), // <- index                                                           // 2094
	        k: key,                        // <- key                                                             // 2095
	        v: value,                      // <- value                                                           // 2096
	        p: prev = that._l,             // <- previous entry                                                  // 2097
	        n: undefined,                  // <- next entry                                                      // 2098
	        r: false                       // <- removed                                                         // 2099
	      };                                                                                                     // 2100
	      if(!that._f)that._f = entry;                                                                           // 2101
	      if(prev)prev.n = entry;                                                                                // 2102
	      that[SIZE]++;                                                                                          // 2103
	      // add to index                                                                                        // 2104
	      if(index !== 'F')that._i[index] = entry;                                                               // 2105
	    } return that;                                                                                           // 2106
	  },                                                                                                         // 2107
	  getEntry: getEntry,                                                                                        // 2108
	  setStrong: function(C, NAME, IS_MAP){                                                                      // 2109
	    // add .keys, .values, .entries, [@@iterator]                                                            // 2110
	    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11                    // 2111
	    __webpack_require__(54)(C, NAME, function(iterated, kind){                                               // 2112
	      this._t = iterated;  // target                                                                         // 2113
	      this._k = kind;      // kind                                                                           // 2114
	      this._l = undefined; // previous                                                                       // 2115
	    }, function(){                                                                                           // 2116
	      var that  = this                                                                                       // 2117
	        , kind  = that._k                                                                                    // 2118
	        , entry = that._l;                                                                                   // 2119
	      // revert to the last existing entry                                                                   // 2120
	      while(entry && entry.r)entry = entry.p;                                                                // 2121
	      // get next entry                                                                                      // 2122
	      if(!that._t || !(that._l = entry = entry ? entry.n : that._t._f)){                                     // 2123
	        // or finish the iteration                                                                           // 2124
	        that._t = undefined;                                                                                 // 2125
	        return step(1);                                                                                      // 2126
	      }                                                                                                      // 2127
	      // return step by kind                                                                                 // 2128
	      if(kind == 'keys'  )return step(0, entry.k);                                                           // 2129
	      if(kind == 'values')return step(0, entry.v);                                                           // 2130
	      return step(0, [entry.k, entry.v]);                                                                    // 2131
	    }, IS_MAP ? 'entries' : 'values' , !IS_MAP, true);                                                       // 2132
                                                                                                              // 2133
	    // add [@@species], 23.1.2.2, 23.2.2.2                                                                   // 2134
	    species(C);                                                                                              // 2135
	    species(__webpack_require__(9)[NAME]); // for wrapper                                                    // 2136
	  }                                                                                                          // 2137
	};                                                                                                           // 2138
                                                                                                              // 2139
/***/ },                                                                                                      // 2140
/* 104 */                                                                                                     // 2141
/***/ function(module, exports) {                                                                             // 2142
                                                                                                              // 2143
	module.exports = function(it, Constructor, name){                                                            // 2144
	  if(!(it instanceof Constructor))throw TypeError(name + ": use the 'new' operator!");                       // 2145
	  return it;                                                                                                 // 2146
	};                                                                                                           // 2147
                                                                                                              // 2148
/***/ },                                                                                                      // 2149
/* 105 */                                                                                                     // 2150
/***/ function(module, exports, __webpack_require__) {                                                        // 2151
                                                                                                              // 2152
	var ctx         = __webpack_require__(35)                                                                    // 2153
	  , call        = __webpack_require__(58)                                                                    // 2154
	  , isArrayIter = __webpack_require__(59)                                                                    // 2155
	  , anObject    = __webpack_require__(26)                                                                    // 2156
	  , toLength    = __webpack_require__(60)                                                                    // 2157
	  , getIterFn   = __webpack_require__(61);                                                                   // 2158
	module.exports = function(iterable, entries, fn, that){                                                      // 2159
	  var iterFn = getIterFn(iterable)                                                                           // 2160
	    , f      = ctx(fn, that, entries ? 2 : 1)                                                                // 2161
	    , index  = 0                                                                                             // 2162
	    , length, step, iterator;                                                                                // 2163
	  if(typeof iterFn != 'function')throw TypeError(iterable + ' is not iterable!');                            // 2164
	  // fast case for arrays with default iterator                                                              // 2165
	  if(isArrayIter(iterFn))for(length = toLength(iterable.length); length > index; index++){                   // 2166
	    entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);                          // 2167
	  } else for(iterator = iterFn.call(iterable); !(step = iterator.next()).done; ){                            // 2168
	    call(iterator, f, step.value, entries);                                                                  // 2169
	  }                                                                                                          // 2170
	};                                                                                                           // 2171
                                                                                                              // 2172
/***/ },                                                                                                      // 2173
/* 106 */                                                                                                     // 2174
/***/ function(module, exports, __webpack_require__) {                                                        // 2175
                                                                                                              // 2176
	var $redef = __webpack_require__(12);                                                                        // 2177
	module.exports = function(target, src){                                                                      // 2178
	  for(var key in src)$redef(target, key, src[key]);                                                          // 2179
	  return target;                                                                                             // 2180
	};                                                                                                           // 2181
                                                                                                              // 2182
/***/ },                                                                                                      // 2183
/* 107 */                                                                                                     // 2184
/***/ function(module, exports, __webpack_require__) {                                                        // 2185
                                                                                                              // 2186
	'use strict';                                                                                                // 2187
	var global     = __webpack_require__(4)                                                                      // 2188
	  , $def       = __webpack_require__(8)                                                                      // 2189
	  , forOf      = __webpack_require__(105)                                                                    // 2190
	  , strictNew  = __webpack_require__(104);                                                                   // 2191
                                                                                                              // 2192
	module.exports = function(NAME, wrapper, methods, common, IS_MAP, IS_WEAK){                                  // 2193
	  var Base  = global[NAME]                                                                                   // 2194
	    , C     = Base                                                                                           // 2195
	    , ADDER = IS_MAP ? 'set' : 'add'                                                                         // 2196
	    , proto = C && C.prototype                                                                               // 2197
	    , O     = {};                                                                                            // 2198
	  var fixMethod = function(KEY){                                                                             // 2199
	    var fn = proto[KEY];                                                                                     // 2200
	    __webpack_require__(12)(proto, KEY,                                                                      // 2201
	      KEY == 'delete' ? function(a){ return fn.call(this, a === 0 ? 0 : a); }                                // 2202
	      : KEY == 'has' ? function has(a){ return fn.call(this, a === 0 ? 0 : a); }                             // 2203
	      : KEY == 'get' ? function get(a){ return fn.call(this, a === 0 ? 0 : a); }                             // 2204
	      : KEY == 'add' ? function add(a){ fn.call(this, a === 0 ? 0 : a); return this; }                       // 2205
	      : function set(a, b){ fn.call(this, a === 0 ? 0 : a, b); return this; }                                // 2206
	    );                                                                                                       // 2207
	  };                                                                                                         // 2208
	  if(typeof C != 'function' || !(IS_WEAK || proto.forEach && !__webpack_require__(7)(function(){             // 2209
	    new C().entries().next();                                                                                // 2210
	  }))){                                                                                                      // 2211
	    // create collection constructor                                                                         // 2212
	    C = common.getConstructor(wrapper, NAME, IS_MAP, ADDER);                                                 // 2213
	    __webpack_require__(106)(C.prototype, methods);                                                          // 2214
	  } else {                                                                                                   // 2215
	    var inst  = new C                                                                                        // 2216
	      , chain = inst[ADDER](IS_WEAK ? {} : -0, 1)                                                            // 2217
	      , buggyZero;                                                                                           // 2218
	    // wrap for init collections from iterable                                                               // 2219
	    if(!__webpack_require__(62)(function(iter){ new C(iter); })){ // eslint-disable-line no-new              // 2220
	      C = wrapper(function(target, iterable){                                                                // 2221
	        strictNew(target, C, NAME);                                                                          // 2222
	        var that = new Base;                                                                                 // 2223
	        if(iterable != undefined)forOf(iterable, IS_MAP, that[ADDER], that);                                 // 2224
	        return that;                                                                                         // 2225
	      });                                                                                                    // 2226
	      C.prototype = proto;                                                                                   // 2227
	      proto.constructor = C;                                                                                 // 2228
	    }                                                                                                        // 2229
	    IS_WEAK || inst.forEach(function(val, key){                                                              // 2230
	      buggyZero = 1 / key === -Infinity;                                                                     // 2231
	    });                                                                                                      // 2232
	    // fix converting -0 key to +0                                                                           // 2233
	    if(buggyZero){                                                                                           // 2234
	      fixMethod('delete');                                                                                   // 2235
	      fixMethod('has');                                                                                      // 2236
	      IS_MAP && fixMethod('get');                                                                            // 2237
	    }                                                                                                        // 2238
	    // + fix .add & .set for chaining                                                                        // 2239
	    if(buggyZero || chain !== inst)fixMethod(ADDER);                                                         // 2240
	    // weak collections should not contains .clear method                                                    // 2241
	    if(IS_WEAK && proto.clear)delete proto.clear;                                                            // 2242
	  }                                                                                                          // 2243
                                                                                                              // 2244
	  __webpack_require__(15)(C, NAME);                                                                          // 2245
                                                                                                              // 2246
	  O[NAME] = C;                                                                                               // 2247
	  $def($def.G + $def.W + $def.F * (C != Base), O);                                                           // 2248
                                                                                                              // 2249
	  if(!IS_WEAK)common.setStrong(C, NAME, IS_MAP);                                                             // 2250
                                                                                                              // 2251
	  return C;                                                                                                  // 2252
	};                                                                                                           // 2253
                                                                                                              // 2254
/***/ },                                                                                                      // 2255
/* 108 */                                                                                                     // 2256
/***/ function(module, exports, __webpack_require__) {                                                        // 2257
                                                                                                              // 2258
	__webpack_require__(37);                                                                                     // 2259
	__webpack_require__(51);                                                                                     // 2260
	__webpack_require__(101);                                                                                    // 2261
	__webpack_require__(109);                                                                                    // 2262
	module.exports = __webpack_require__(9).Set;                                                                 // 2263
                                                                                                              // 2264
/***/ },                                                                                                      // 2265
/* 109 */                                                                                                     // 2266
/***/ function(module, exports, __webpack_require__) {                                                        // 2267
                                                                                                              // 2268
	'use strict';                                                                                                // 2269
	var strong = __webpack_require__(103);                                                                       // 2270
                                                                                                              // 2271
	// 23.2 Set Objects                                                                                          // 2272
	__webpack_require__(107)('Set', function(get){                                                               // 2273
	  return function Set(){ return get(this, arguments[0]); };                                                  // 2274
	}, {                                                                                                         // 2275
	  // 23.2.3.1 Set.prototype.add(value)                                                                       // 2276
	  add: function add(value){                                                                                  // 2277
	    return strong.def(this, value = value === 0 ? 0 : value, value);                                         // 2278
	  }                                                                                                          // 2279
	}, strong);                                                                                                  // 2280
                                                                                                              // 2281
/***/ }                                                                                                       // 2282
/******/ ]);                                                                                                  // 2283


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['ecmascript-runtime'] = {
  Symbol: Symbol,
  Map: Map,
  Set: Set
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;

/* Package-scope variables */
var Promise;

(function(){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/promise/.npm/package/node_modules/meteor-promise/promise.bundle.js                                       //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
/******/ (function(modules) { // webpackBootstrap                                                                    // 1
/******/ 	// The module cache                                                                                        // 2
/******/ 	var installedModules = {};                                                                                 // 3
                                                                                                                     // 4
/******/ 	// The require function                                                                                    // 5
/******/ 	function __webpack_require__(moduleId) {                                                                   // 6
                                                                                                                     // 7
/******/ 		// Check if module is in cache                                                                            // 8
/******/ 		if(installedModules[moduleId])                                                                            // 9
/******/ 			return installedModules[moduleId].exports;                                                               // 10
                                                                                                                     // 11
/******/ 		// Create a new module (and put it into the cache)                                                        // 12
/******/ 		var module = installedModules[moduleId] = {                                                               // 13
/******/ 			exports: {},                                                                                             // 14
/******/ 			id: moduleId,                                                                                            // 15
/******/ 			loaded: false                                                                                            // 16
/******/ 		};                                                                                                        // 17
                                                                                                                     // 18
/******/ 		// Execute the module function                                                                            // 19
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);                      // 20
                                                                                                                     // 21
/******/ 		// Flag the module as loaded                                                                              // 22
/******/ 		module.loaded = true;                                                                                     // 23
                                                                                                                     // 24
/******/ 		// Return the exports of the module                                                                       // 25
/******/ 		return module.exports;                                                                                    // 26
/******/ 	}                                                                                                          // 27
                                                                                                                     // 28
                                                                                                                     // 29
/******/ 	// expose the modules object (__webpack_modules__)                                                         // 30
/******/ 	__webpack_require__.m = modules;                                                                           // 31
                                                                                                                     // 32
/******/ 	// expose the module cache                                                                                 // 33
/******/ 	__webpack_require__.c = installedModules;                                                                  // 34
                                                                                                                     // 35
/******/ 	// __webpack_public_path__                                                                                 // 36
/******/ 	__webpack_require__.p = "";                                                                                // 37
                                                                                                                     // 38
/******/ 	// Load entry module and return exports                                                                    // 39
/******/ 	return __webpack_require__(0);                                                                             // 40
/******/ })                                                                                                          // 41
/************************************************************************/                                           // 42
/******/ ([                                                                                                          // 43
/* 0 */                                                                                                              // 44
/***/ function(module, exports, __webpack_require__) {                                                               // 45
                                                                                                                     // 46
	var MeteorPromise = __webpack_require__(1);                                                                         // 47
                                                                                                                     // 48
	var es6PromiseThen = MeteorPromise.prototype.then;                                                                  // 49
	MeteorPromise.prototype.then = function (onResolved, onRejected) {                                                  // 50
	  if (typeof Meteor === "object" &&                                                                                 // 51
	      typeof Meteor.bindEnvironment === "function") {                                                               // 52
	    return es6PromiseThen.call(                                                                                     // 53
	      this,                                                                                                         // 54
	      onResolved && Meteor.bindEnvironment(onResolved, raise),                                                      // 55
	      onRejected && Meteor.bindEnvironment(onRejected, raise)                                                       // 56
	    );                                                                                                              // 57
	  }                                                                                                                 // 58
	  return es6PromiseThen.call(this, onResolved, onRejected);                                                         // 59
	};                                                                                                                  // 60
                                                                                                                     // 61
	function raise(exception) {                                                                                         // 62
	  throw exception;                                                                                                  // 63
	}                                                                                                                   // 64
                                                                                                                     // 65
	Promise = MeteorPromise;                                                                                            // 66
                                                                                                                     // 67
                                                                                                                     // 68
/***/ },                                                                                                             // 69
/* 1 */                                                                                                              // 70
/***/ function(module, exports, __webpack_require__) {                                                               // 71
                                                                                                                     // 72
	/* WEBPACK VAR INJECTION */(function(global) {var hasOwn = Object.prototype.hasOwnProperty;                         // 73
                                                                                                                     // 74
	var g =                                                                                                             // 75
	  typeof global === "object" ? global :                                                                             // 76
	  typeof window === "object" ? window :                                                                             // 77
	  typeof self === "object" ? self : this;                                                                           // 78
                                                                                                                     // 79
	var GlobalPromise = g.Promise;                                                                                      // 80
	var NpmPromise = __webpack_require__(2);                                                                            // 81
                                                                                                                     // 82
	function copyMethods(target, source) {                                                                              // 83
	  Object.keys(source).forEach(function (key) {                                                                      // 84
	    var value = source[key];                                                                                        // 85
	    if (typeof value === "function" &&                                                                              // 86
	        ! hasOwn.call(target, key)) {                                                                               // 87
	      target[key] = value;                                                                                          // 88
	    }                                                                                                               // 89
	  });                                                                                                               // 90
	}                                                                                                                   // 91
                                                                                                                     // 92
	if (typeof GlobalPromise === "function") {                                                                          // 93
	  copyMethods(GlobalPromise, NpmPromise);                                                                           // 94
	  copyMethods(GlobalPromise.prototype, NpmPromise.prototype);                                                       // 95
	  module.exports = GlobalPromise;                                                                                   // 96
	} else {                                                                                                            // 97
	  module.exports = NpmPromise;                                                                                      // 98
	}                                                                                                                   // 99
                                                                                                                     // 100
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))                                        // 101
                                                                                                                     // 102
/***/ },                                                                                                             // 103
/* 2 */                                                                                                              // 104
/***/ function(module, exports, __webpack_require__) {                                                               // 105
                                                                                                                     // 106
	'use strict';                                                                                                       // 107
                                                                                                                     // 108
	module.exports = __webpack_require__(3)                                                                             // 109
                                                                                                                     // 110
                                                                                                                     // 111
/***/ },                                                                                                             // 112
/* 3 */                                                                                                              // 113
/***/ function(module, exports, __webpack_require__) {                                                               // 114
                                                                                                                     // 115
	'use strict';                                                                                                       // 116
                                                                                                                     // 117
	module.exports = __webpack_require__(4);                                                                            // 118
	__webpack_require__(6);                                                                                             // 119
	__webpack_require__(7);                                                                                             // 120
	__webpack_require__(8);                                                                                             // 121
	__webpack_require__(9);                                                                                             // 122
                                                                                                                     // 123
                                                                                                                     // 124
/***/ },                                                                                                             // 125
/* 4 */                                                                                                              // 126
/***/ function(module, exports, __webpack_require__) {                                                               // 127
                                                                                                                     // 128
	'use strict';                                                                                                       // 129
                                                                                                                     // 130
	var asap = __webpack_require__(5);                                                                                  // 131
                                                                                                                     // 132
	function noop() {}                                                                                                  // 133
                                                                                                                     // 134
	// States:                                                                                                          // 135
	//                                                                                                                  // 136
	// 0 - pending                                                                                                      // 137
	// 1 - fulfilled with _value                                                                                        // 138
	// 2 - rejected with _value                                                                                         // 139
	// 3 - adopted the state of another promise, _value                                                                 // 140
	//                                                                                                                  // 141
	// once the state is no longer pending (0) it is immutable                                                          // 142
                                                                                                                     // 143
	// All `_` prefixed properties will be reduced to `_{random number}`                                                // 144
	// at build time to obfuscate them and discourage their use.                                                        // 145
	// We don't use symbols or Object.defineProperty to fully hide them                                                 // 146
	// because the performance isn't good enough.                                                                       // 147
                                                                                                                     // 148
                                                                                                                     // 149
	// to avoid using try/catch inside critical functions, we                                                           // 150
	// extract them to here.                                                                                            // 151
	var LAST_ERROR = null;                                                                                              // 152
	var IS_ERROR = {};                                                                                                  // 153
	function getThen(obj) {                                                                                             // 154
	  try {                                                                                                             // 155
	    return obj.then;                                                                                                // 156
	  } catch (ex) {                                                                                                    // 157
	    LAST_ERROR = ex;                                                                                                // 158
	    return IS_ERROR;                                                                                                // 159
	  }                                                                                                                 // 160
	}                                                                                                                   // 161
                                                                                                                     // 162
	function tryCallOne(fn, a) {                                                                                        // 163
	  try {                                                                                                             // 164
	    return fn(a);                                                                                                   // 165
	  } catch (ex) {                                                                                                    // 166
	    LAST_ERROR = ex;                                                                                                // 167
	    return IS_ERROR;                                                                                                // 168
	  }                                                                                                                 // 169
	}                                                                                                                   // 170
	function tryCallTwo(fn, a, b) {                                                                                     // 171
	  try {                                                                                                             // 172
	    fn(a, b);                                                                                                       // 173
	  } catch (ex) {                                                                                                    // 174
	    LAST_ERROR = ex;                                                                                                // 175
	    return IS_ERROR;                                                                                                // 176
	  }                                                                                                                 // 177
	}                                                                                                                   // 178
                                                                                                                     // 179
	module.exports = Promise;                                                                                           // 180
                                                                                                                     // 181
	function Promise(fn) {                                                                                              // 182
	  if (typeof this !== 'object') {                                                                                   // 183
	    throw new TypeError('Promises must be constructed via new');                                                    // 184
	  }                                                                                                                 // 185
	  if (typeof fn !== 'function') {                                                                                   // 186
	    throw new TypeError('not a function');                                                                          // 187
	  }                                                                                                                 // 188
	  this._37 = 0;                                                                                                     // 189
	  this._12 = null;                                                                                                  // 190
	  this._59 = [];                                                                                                    // 191
	  if (fn === noop) return;                                                                                          // 192
	  doResolve(fn, this);                                                                                              // 193
	}                                                                                                                   // 194
	Promise._99 = noop;                                                                                                 // 195
                                                                                                                     // 196
	Promise.prototype.then = function(onFulfilled, onRejected) {                                                        // 197
	  if (this.constructor !== Promise) {                                                                               // 198
	    return safeThen(this, onFulfilled, onRejected);                                                                 // 199
	  }                                                                                                                 // 200
	  var res = new Promise(noop);                                                                                      // 201
	  handle(this, new Handler(onFulfilled, onRejected, res));                                                          // 202
	  return res;                                                                                                       // 203
	};                                                                                                                  // 204
                                                                                                                     // 205
	function safeThen(self, onFulfilled, onRejected) {                                                                  // 206
	  return new self.constructor(function (resolve, reject) {                                                          // 207
	    var res = new Promise(noop);                                                                                    // 208
	    res.then(resolve, reject);                                                                                      // 209
	    handle(self, new Handler(onFulfilled, onRejected, res));                                                        // 210
	  });                                                                                                               // 211
	};                                                                                                                  // 212
	function handle(self, deferred) {                                                                                   // 213
	  while (self._37 === 3) {                                                                                          // 214
	    self = self._12;                                                                                                // 215
	  }                                                                                                                 // 216
	  if (self._37 === 0) {                                                                                             // 217
	    self._59.push(deferred);                                                                                        // 218
	    return;                                                                                                         // 219
	  }                                                                                                                 // 220
	  asap(function() {                                                                                                 // 221
	    var cb = self._37 === 1 ? deferred.onFulfilled : deferred.onRejected;                                           // 222
	    if (cb === null) {                                                                                              // 223
	      if (self._37 === 1) {                                                                                         // 224
	        resolve(deferred.promise, self._12);                                                                        // 225
	      } else {                                                                                                      // 226
	        reject(deferred.promise, self._12);                                                                         // 227
	      }                                                                                                             // 228
	      return;                                                                                                       // 229
	    }                                                                                                               // 230
	    var ret = tryCallOne(cb, self._12);                                                                             // 231
	    if (ret === IS_ERROR) {                                                                                         // 232
	      reject(deferred.promise, LAST_ERROR);                                                                         // 233
	    } else {                                                                                                        // 234
	      resolve(deferred.promise, ret);                                                                               // 235
	    }                                                                                                               // 236
	  });                                                                                                               // 237
	}                                                                                                                   // 238
	function resolve(self, newValue) {                                                                                  // 239
	  // Promise Resolution Procedure: https://github.com/promises-aplus/promises-spec#the-promise-resolution-procedure
	  if (newValue === self) {                                                                                          // 241
	    return reject(                                                                                                  // 242
	      self,                                                                                                         // 243
	      new TypeError('A promise cannot be resolved with itself.')                                                    // 244
	    );                                                                                                              // 245
	  }                                                                                                                 // 246
	  if (                                                                                                              // 247
	    newValue &&                                                                                                     // 248
	    (typeof newValue === 'object' || typeof newValue === 'function')                                                // 249
	  ) {                                                                                                               // 250
	    var then = getThen(newValue);                                                                                   // 251
	    if (then === IS_ERROR) {                                                                                        // 252
	      return reject(self, LAST_ERROR);                                                                              // 253
	    }                                                                                                               // 254
	    if (                                                                                                            // 255
	      then === self.then &&                                                                                         // 256
	      newValue instanceof Promise                                                                                   // 257
	    ) {                                                                                                             // 258
	      self._37 = 3;                                                                                                 // 259
	      self._12 = newValue;                                                                                          // 260
	      finale(self);                                                                                                 // 261
	      return;                                                                                                       // 262
	    } else if (typeof then === 'function') {                                                                        // 263
	      doResolve(then.bind(newValue), self);                                                                         // 264
	      return;                                                                                                       // 265
	    }                                                                                                               // 266
	  }                                                                                                                 // 267
	  self._37 = 1;                                                                                                     // 268
	  self._12 = newValue;                                                                                              // 269
	  finale(self);                                                                                                     // 270
	}                                                                                                                   // 271
                                                                                                                     // 272
	function reject(self, newValue) {                                                                                   // 273
	  self._37 = 2;                                                                                                     // 274
	  self._12 = newValue;                                                                                              // 275
	  finale(self);                                                                                                     // 276
	}                                                                                                                   // 277
	function finale(self) {                                                                                             // 278
	  for (var i = 0; i < self._59.length; i++) {                                                                       // 279
	    handle(self, self._59[i]);                                                                                      // 280
	  }                                                                                                                 // 281
	  self._59 = null;                                                                                                  // 282
	}                                                                                                                   // 283
                                                                                                                     // 284
	function Handler(onFulfilled, onRejected, promise){                                                                 // 285
	  this.onFulfilled = typeof onFulfilled === 'function' ? onFulfilled : null;                                        // 286
	  this.onRejected = typeof onRejected === 'function' ? onRejected : null;                                           // 287
	  this.promise = promise;                                                                                           // 288
	}                                                                                                                   // 289
                                                                                                                     // 290
	/**                                                                                                                 // 291
	 * Take a potentially misbehaving resolver function and make sure                                                   // 292
	 * onFulfilled and onRejected are only called once.                                                                 // 293
	 *                                                                                                                  // 294
	 * Makes no guarantees about asynchrony.                                                                            // 295
	 */                                                                                                                 // 296
	function doResolve(fn, promise) {                                                                                   // 297
	  var done = false;                                                                                                 // 298
	  var res = tryCallTwo(fn, function (value) {                                                                       // 299
	    if (done) return;                                                                                               // 300
	    done = true;                                                                                                    // 301
	    resolve(promise, value);                                                                                        // 302
	  }, function (reason) {                                                                                            // 303
	    if (done) return;                                                                                               // 304
	    done = true;                                                                                                    // 305
	    reject(promise, reason);                                                                                        // 306
	  })                                                                                                                // 307
	  if (!done && res === IS_ERROR) {                                                                                  // 308
	    done = true;                                                                                                    // 309
	    reject(promise, LAST_ERROR);                                                                                    // 310
	  }                                                                                                                 // 311
	}                                                                                                                   // 312
                                                                                                                     // 313
                                                                                                                     // 314
/***/ },                                                                                                             // 315
/* 5 */                                                                                                              // 316
/***/ function(module, exports) {                                                                                    // 317
                                                                                                                     // 318
	/* WEBPACK VAR INJECTION */(function(global) {"use strict";                                                         // 319
                                                                                                                     // 320
	// Use the fastest means possible to execute a task in its own turn, with                                           // 321
	// priority over other events including IO, animation, reflow, and redraw                                           // 322
	// events in browsers.                                                                                              // 323
	//                                                                                                                  // 324
	// An exception thrown by a task will permanently interrupt the processing of                                       // 325
	// subsequent tasks. The higher level `asap` function ensures that if an                                            // 326
	// exception is thrown by a task, that the task queue will continue flushing as                                     // 327
	// soon as possible, but if you use `rawAsap` directly, you are responsible to                                      // 328
	// either ensure that no exceptions are thrown from your task, or to manually                                       // 329
	// call `rawAsap.requestFlush` if an exception is thrown.                                                           // 330
	module.exports = rawAsap;                                                                                           // 331
	function rawAsap(task) {                                                                                            // 332
	    if (!queue.length) {                                                                                            // 333
	        requestFlush();                                                                                             // 334
	        flushing = true;                                                                                            // 335
	    }                                                                                                               // 336
	    // Equivalent to push, but avoids a function call.                                                              // 337
	    queue[queue.length] = task;                                                                                     // 338
	}                                                                                                                   // 339
                                                                                                                     // 340
	var queue = [];                                                                                                     // 341
	// Once a flush has been requested, no further calls to `requestFlush` are                                          // 342
	// necessary until the next `flush` completes.                                                                      // 343
	var flushing = false;                                                                                               // 344
	// `requestFlush` is an implementation-specific method that attempts to kick                                        // 345
	// off a `flush` event as quickly as possible. `flush` will attempt to exhaust                                      // 346
	// the event queue before yielding to the browser's own event loop.                                                 // 347
	var requestFlush;                                                                                                   // 348
	// The position of the next task to execute in the task queue. This is                                              // 349
	// preserved between calls to `flush` so that it can be resumed if                                                  // 350
	// a task throws an exception.                                                                                      // 351
	var index = 0;                                                                                                      // 352
	// If a task schedules additional tasks recursively, the task queue can grow                                        // 353
	// unbounded. To prevent memory exhaustion, the task queue will periodically                                        // 354
	// truncate already-completed tasks.                                                                                // 355
	var capacity = 1024;                                                                                                // 356
                                                                                                                     // 357
	// The flush function processes all tasks that have been scheduled with                                             // 358
	// `rawAsap` unless and until one of those tasks throws an exception.                                               // 359
	// If a task throws an exception, `flush` ensures that its state will remain                                        // 360
	// consistent and will resume where it left off when called again.                                                  // 361
	// However, `flush` does not make any arrangements to be called again if an                                         // 362
	// exception is thrown.                                                                                             // 363
	function flush() {                                                                                                  // 364
	    while (index < queue.length) {                                                                                  // 365
	        var currentIndex = index;                                                                                   // 366
	        // Advance the index before calling the task. This ensures that we will                                     // 367
	        // begin flushing on the next task the task throws an error.                                                // 368
	        index = index + 1;                                                                                          // 369
	        queue[currentIndex].call();                                                                                 // 370
	        // Prevent leaking memory for long chains of recursive calls to `asap`.                                     // 371
	        // If we call `asap` within tasks scheduled by `asap`, the queue will                                       // 372
	        // grow, but to avoid an O(n) walk for every task we execute, we don't                                      // 373
	        // shift tasks off the queue after they have been executed.                                                 // 374
	        // Instead, we periodically shift 1024 tasks off the queue.                                                 // 375
	        if (index > capacity) {                                                                                     // 376
	            // Manually shift all values starting at the index back to the                                          // 377
	            // beginning of the queue.                                                                              // 378
	            for (var scan = 0, newLength = queue.length - index; scan < newLength; scan++) {                        // 379
	                queue[scan] = queue[scan + index];                                                                  // 380
	            }                                                                                                       // 381
	            queue.length -= index;                                                                                  // 382
	            index = 0;                                                                                              // 383
	        }                                                                                                           // 384
	    }                                                                                                               // 385
	    queue.length = 0;                                                                                               // 386
	    index = 0;                                                                                                      // 387
	    flushing = false;                                                                                               // 388
	}                                                                                                                   // 389
                                                                                                                     // 390
	// `requestFlush` is implemented using a strategy based on data collected from                                      // 391
	// every available SauceLabs Selenium web driver worker at time of writing.                                         // 392
	// https://docs.google.com/spreadsheets/d/1mG-5UYGup5qxGdEMWkhP6BWCz053NUb2E1QoUTU16uA/edit#gid=783724593           // 393
                                                                                                                     // 394
	// Safari 6 and 6.1 for desktop, iPad, and iPhone are the only browsers that                                        // 395
	// have WebKitMutationObserver but not un-prefixed MutationObserver.                                                // 396
	// Must use `global` instead of `window` to work in both frames and web                                             // 397
	// workers. `global` is a provision of Browserify, Mr, Mrs, or Mop.                                                 // 398
	var BrowserMutationObserver = global.MutationObserver || global.WebKitMutationObserver;                             // 399
                                                                                                                     // 400
	// MutationObservers are desirable because they have high priority and work                                         // 401
	// reliably everywhere they are implemented.                                                                        // 402
	// They are implemented in all modern browsers.                                                                     // 403
	//                                                                                                                  // 404
	// - Android 4-4.3                                                                                                  // 405
	// - Chrome 26-34                                                                                                   // 406
	// - Firefox 14-29                                                                                                  // 407
	// - Internet Explorer 11                                                                                           // 408
	// - iPad Safari 6-7.1                                                                                              // 409
	// - iPhone Safari 7-7.1                                                                                            // 410
	// - Safari 6-7                                                                                                     // 411
	if (typeof BrowserMutationObserver === "function") {                                                                // 412
	    requestFlush = makeRequestCallFromMutationObserver(flush);                                                      // 413
                                                                                                                     // 414
	// MessageChannels are desirable because they give direct access to the HTML                                        // 415
	// task queue, are implemented in Internet Explorer 10, Safari 5.0-1, and Opera                                     // 416
	// 11-12, and in web workers in many engines.                                                                       // 417
	// Although message channels yield to any queued rendering and IO tasks, they                                       // 418
	// would be better than imposing the 4ms delay of timers.                                                           // 419
	// However, they do not work reliably in Internet Explorer or Safari.                                               // 420
                                                                                                                     // 421
	// Internet Explorer 10 is the only browser that has setImmediate but does                                          // 422
	// not have MutationObservers.                                                                                      // 423
	// Although setImmediate yields to the browser's renderer, it would be                                              // 424
	// preferrable to falling back to setTimeout since it does not have                                                 // 425
	// the minimum 4ms penalty.                                                                                         // 426
	// Unfortunately there appears to be a bug in Internet Explorer 10 Mobile (and                                      // 427
	// Desktop to a lesser extent) that renders both setImmediate and                                                   // 428
	// MessageChannel useless for the purposes of ASAP.                                                                 // 429
	// https://github.com/kriskowal/q/issues/396                                                                        // 430
                                                                                                                     // 431
	// Timers are implemented universally.                                                                              // 432
	// We fall back to timers in workers in most engines, and in foreground                                             // 433
	// contexts in the following browsers.                                                                              // 434
	// However, note that even this simple case requires nuances to operate in a                                        // 435
	// broad spectrum of browsers.                                                                                      // 436
	//                                                                                                                  // 437
	// - Firefox 3-13                                                                                                   // 438
	// - Internet Explorer 6-9                                                                                          // 439
	// - iPad Safari 4.3                                                                                                // 440
	// - Lynx 2.8.7                                                                                                     // 441
	} else {                                                                                                            // 442
	    requestFlush = makeRequestCallFromTimer(flush);                                                                 // 443
	}                                                                                                                   // 444
                                                                                                                     // 445
	// `requestFlush` requests that the high priority event queue be flushed as                                         // 446
	// soon as possible.                                                                                                // 447
	// This is useful to prevent an error thrown in a task from stalling the event                                      // 448
	// queue if the exception handled by Node.js’s                                                                      // 449
	// `process.on("uncaughtException")` or by a domain.                                                                // 450
	rawAsap.requestFlush = requestFlush;                                                                                // 451
                                                                                                                     // 452
	// To request a high priority event, we induce a mutation observer by toggling                                      // 453
	// the text of a text node between "1" and "-1".                                                                    // 454
	function makeRequestCallFromMutationObserver(callback) {                                                            // 455
	    var toggle = 1;                                                                                                 // 456
	    var observer = new BrowserMutationObserver(callback);                                                           // 457
	    var node = document.createTextNode("");                                                                         // 458
	    observer.observe(node, {characterData: true});                                                                  // 459
	    return function requestCall() {                                                                                 // 460
	        toggle = -toggle;                                                                                           // 461
	        node.data = toggle;                                                                                         // 462
	    };                                                                                                              // 463
	}                                                                                                                   // 464
                                                                                                                     // 465
	// The message channel technique was discovered by Malte Ubl and was the                                            // 466
	// original foundation for this library.                                                                            // 467
	// http://www.nonblocking.io/2011/06/windownexttick.html                                                            // 468
                                                                                                                     // 469
	// Safari 6.0.5 (at least) intermittently fails to create message ports on a                                        // 470
	// page's first load. Thankfully, this version of Safari supports                                                   // 471
	// MutationObservers, so we don't need to fall back in that case.                                                   // 472
                                                                                                                     // 473
	// function makeRequestCallFromMessageChannel(callback) {                                                           // 474
	//     var channel = new MessageChannel();                                                                          // 475
	//     channel.port1.onmessage = callback;                                                                          // 476
	//     return function requestCall() {                                                                              // 477
	//         channel.port2.postMessage(0);                                                                            // 478
	//     };                                                                                                           // 479
	// }                                                                                                                // 480
                                                                                                                     // 481
	// For reasons explained above, we are also unable to use `setImmediate`                                            // 482
	// under any circumstances.                                                                                         // 483
	// Even if we were, there is another bug in Internet Explorer 10.                                                   // 484
	// It is not sufficient to assign `setImmediate` to `requestFlush` because                                          // 485
	// `setImmediate` must be called *by name* and therefore must be wrapped in a                                       // 486
	// closure.                                                                                                         // 487
	// Never forget.                                                                                                    // 488
                                                                                                                     // 489
	// function makeRequestCallFromSetImmediate(callback) {                                                             // 490
	//     return function requestCall() {                                                                              // 491
	//         setImmediate(callback);                                                                                  // 492
	//     };                                                                                                           // 493
	// }                                                                                                                // 494
                                                                                                                     // 495
	// Safari 6.0 has a problem where timers will get lost while the user is                                            // 496
	// scrolling. This problem does not impact ASAP because Safari 6.0 supports                                         // 497
	// mutation observers, so that implementation is used instead.                                                      // 498
	// However, if we ever elect to use timers in Safari, the prevalent work-around                                     // 499
	// is to add a scroll event listener that calls for a flush.                                                        // 500
                                                                                                                     // 501
	// `setTimeout` does not call the passed callback if the delay is less than                                         // 502
	// approximately 7 in web workers in Firefox 8 through 18, and sometimes not                                        // 503
	// even then.                                                                                                       // 504
                                                                                                                     // 505
	function makeRequestCallFromTimer(callback) {                                                                       // 506
	    return function requestCall() {                                                                                 // 507
	        // We dispatch a timeout with a specified delay of 0 for engines that                                       // 508
	        // can reliably accommodate that request. This will usually be snapped                                      // 509
	        // to a 4 milisecond delay, but once we're flushing, there's no delay                                       // 510
	        // between events.                                                                                          // 511
	        var timeoutHandle = setTimeout(handleTimer, 0);                                                             // 512
	        // However, since this timer gets frequently dropped in Firefox                                             // 513
	        // workers, we enlist an interval handle that will try to fire                                              // 514
	        // an event 20 times per second until it succeeds.                                                          // 515
	        var intervalHandle = setInterval(handleTimer, 50);                                                          // 516
                                                                                                                     // 517
	        function handleTimer() {                                                                                    // 518
	            // Whichever timer succeeds will cancel both timers and                                                 // 519
	            // execute the callback.                                                                                // 520
	            clearTimeout(timeoutHandle);                                                                            // 521
	            clearInterval(intervalHandle);                                                                          // 522
	            callback();                                                                                             // 523
	        }                                                                                                           // 524
	    };                                                                                                              // 525
	}                                                                                                                   // 526
                                                                                                                     // 527
	// This is for `asap.js` only.                                                                                      // 528
	// Its name will be periodically randomized to break any code that depends on                                       // 529
	// its existence.                                                                                                   // 530
	rawAsap.makeRequestCallFromTimer = makeRequestCallFromTimer;                                                        // 531
                                                                                                                     // 532
	// ASAP was originally a nextTick shim included in Q. This was factored out                                         // 533
	// into this ASAP package. It was later adapted to RSVP which made further                                          // 534
	// amendments. These decisions, particularly to marginalize MessageChannel and                                      // 535
	// to capture the MutationObserver implementation in a closure, were integrated                                     // 536
	// back into ASAP proper.                                                                                           // 537
	// https://github.com/tildeio/rsvp.js/blob/cddf7232546a9cf858524b75cde6f9edf72620a7/lib/rsvp/asap.js                // 538
                                                                                                                     // 539
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))                                        // 540
                                                                                                                     // 541
/***/ },                                                                                                             // 542
/* 6 */                                                                                                              // 543
/***/ function(module, exports, __webpack_require__) {                                                               // 544
                                                                                                                     // 545
	'use strict';                                                                                                       // 546
                                                                                                                     // 547
	var Promise = __webpack_require__(4);                                                                               // 548
                                                                                                                     // 549
	module.exports = Promise;                                                                                           // 550
	Promise.prototype.done = function (onFulfilled, onRejected) {                                                       // 551
	  var self = arguments.length ? this.then.apply(this, arguments) : this;                                            // 552
	  self.then(null, function (err) {                                                                                  // 553
	    setTimeout(function () {                                                                                        // 554
	      throw err;                                                                                                    // 555
	    }, 0);                                                                                                          // 556
	  });                                                                                                               // 557
	};                                                                                                                  // 558
                                                                                                                     // 559
                                                                                                                     // 560
/***/ },                                                                                                             // 561
/* 7 */                                                                                                              // 562
/***/ function(module, exports, __webpack_require__) {                                                               // 563
                                                                                                                     // 564
	'use strict';                                                                                                       // 565
                                                                                                                     // 566
	var Promise = __webpack_require__(4);                                                                               // 567
                                                                                                                     // 568
	module.exports = Promise;                                                                                           // 569
	Promise.prototype['finally'] = function (f) {                                                                       // 570
	  return this.then(function (value) {                                                                               // 571
	    return Promise.resolve(f()).then(function () {                                                                  // 572
	      return value;                                                                                                 // 573
	    });                                                                                                             // 574
	  }, function (err) {                                                                                               // 575
	    return Promise.resolve(f()).then(function () {                                                                  // 576
	      throw err;                                                                                                    // 577
	    });                                                                                                             // 578
	  });                                                                                                               // 579
	};                                                                                                                  // 580
                                                                                                                     // 581
                                                                                                                     // 582
/***/ },                                                                                                             // 583
/* 8 */                                                                                                              // 584
/***/ function(module, exports, __webpack_require__) {                                                               // 585
                                                                                                                     // 586
	'use strict';                                                                                                       // 587
                                                                                                                     // 588
	//This file contains the ES6 extensions to the core Promises/A+ API                                                 // 589
                                                                                                                     // 590
	var Promise = __webpack_require__(4);                                                                               // 591
                                                                                                                     // 592
	module.exports = Promise;                                                                                           // 593
                                                                                                                     // 594
	/* Static Functions */                                                                                              // 595
                                                                                                                     // 596
	var TRUE = valuePromise(true);                                                                                      // 597
	var FALSE = valuePromise(false);                                                                                    // 598
	var NULL = valuePromise(null);                                                                                      // 599
	var UNDEFINED = valuePromise(undefined);                                                                            // 600
	var ZERO = valuePromise(0);                                                                                         // 601
	var EMPTYSTRING = valuePromise('');                                                                                 // 602
                                                                                                                     // 603
	function valuePromise(value) {                                                                                      // 604
	  var p = new Promise(Promise._99);                                                                                 // 605
	  p._37 = 1;                                                                                                        // 606
	  p._12 = value;                                                                                                    // 607
	  return p;                                                                                                         // 608
	}                                                                                                                   // 609
	Promise.resolve = function (value) {                                                                                // 610
	  if (value instanceof Promise) return value;                                                                       // 611
                                                                                                                     // 612
	  if (value === null) return NULL;                                                                                  // 613
	  if (value === undefined) return UNDEFINED;                                                                        // 614
	  if (value === true) return TRUE;                                                                                  // 615
	  if (value === false) return FALSE;                                                                                // 616
	  if (value === 0) return ZERO;                                                                                     // 617
	  if (value === '') return EMPTYSTRING;                                                                             // 618
                                                                                                                     // 619
	  if (typeof value === 'object' || typeof value === 'function') {                                                   // 620
	    try {                                                                                                           // 621
	      var then = value.then;                                                                                        // 622
	      if (typeof then === 'function') {                                                                             // 623
	        return new Promise(then.bind(value));                                                                       // 624
	      }                                                                                                             // 625
	    } catch (ex) {                                                                                                  // 626
	      return new Promise(function (resolve, reject) {                                                               // 627
	        reject(ex);                                                                                                 // 628
	      });                                                                                                           // 629
	    }                                                                                                               // 630
	  }                                                                                                                 // 631
	  return valuePromise(value);                                                                                       // 632
	};                                                                                                                  // 633
                                                                                                                     // 634
	Promise.all = function (arr) {                                                                                      // 635
	  var args = Array.prototype.slice.call(arr);                                                                       // 636
                                                                                                                     // 637
	  return new Promise(function (resolve, reject) {                                                                   // 638
	    if (args.length === 0) return resolve([]);                                                                      // 639
	    var remaining = args.length;                                                                                    // 640
	    function res(i, val) {                                                                                          // 641
	      if (val && (typeof val === 'object' || typeof val === 'function')) {                                          // 642
	        if (val instanceof Promise && val.then === Promise.prototype.then) {                                        // 643
	          while (val._37 === 3) {                                                                                   // 644
	            val = val._12;                                                                                          // 645
	          }                                                                                                         // 646
	          if (val._37 === 1) return res(i, val._12);                                                                // 647
	          if (val._37 === 2) reject(val._12);                                                                       // 648
	          val.then(function (val) {                                                                                 // 649
	            res(i, val);                                                                                            // 650
	          }, reject);                                                                                               // 651
	          return;                                                                                                   // 652
	        } else {                                                                                                    // 653
	          var then = val.then;                                                                                      // 654
	          if (typeof then === 'function') {                                                                         // 655
	            var p = new Promise(then.bind(val));                                                                    // 656
	            p.then(function (val) {                                                                                 // 657
	              res(i, val);                                                                                          // 658
	            }, reject);                                                                                             // 659
	            return;                                                                                                 // 660
	          }                                                                                                         // 661
	        }                                                                                                           // 662
	      }                                                                                                             // 663
	      args[i] = val;                                                                                                // 664
	      if (--remaining === 0) {                                                                                      // 665
	        resolve(args);                                                                                              // 666
	      }                                                                                                             // 667
	    }                                                                                                               // 668
	    for (var i = 0; i < args.length; i++) {                                                                         // 669
	      res(i, args[i]);                                                                                              // 670
	    }                                                                                                               // 671
	  });                                                                                                               // 672
	};                                                                                                                  // 673
                                                                                                                     // 674
	Promise.reject = function (value) {                                                                                 // 675
	  return new Promise(function (resolve, reject) {                                                                   // 676
	    reject(value);                                                                                                  // 677
	  });                                                                                                               // 678
	};                                                                                                                  // 679
                                                                                                                     // 680
	Promise.race = function (values) {                                                                                  // 681
	  return new Promise(function (resolve, reject) {                                                                   // 682
	    values.forEach(function(value){                                                                                 // 683
	      Promise.resolve(value).then(resolve, reject);                                                                 // 684
	    });                                                                                                             // 685
	  });                                                                                                               // 686
	};                                                                                                                  // 687
                                                                                                                     // 688
	/* Prototype Methods */                                                                                             // 689
                                                                                                                     // 690
	Promise.prototype['catch'] = function (onRejected) {                                                                // 691
	  return this.then(null, onRejected);                                                                               // 692
	};                                                                                                                  // 693
                                                                                                                     // 694
                                                                                                                     // 695
/***/ },                                                                                                             // 696
/* 9 */                                                                                                              // 697
/***/ function(module, exports, __webpack_require__) {                                                               // 698
                                                                                                                     // 699
	'use strict';                                                                                                       // 700
                                                                                                                     // 701
	// This file contains then/promise specific extensions that are only useful                                         // 702
	// for node.js interop                                                                                              // 703
                                                                                                                     // 704
	var Promise = __webpack_require__(4);                                                                               // 705
	var asap = __webpack_require__(10);                                                                                 // 706
                                                                                                                     // 707
	module.exports = Promise;                                                                                           // 708
                                                                                                                     // 709
	/* Static Functions */                                                                                              // 710
                                                                                                                     // 711
	Promise.denodeify = function (fn, argumentCount) {                                                                  // 712
	  argumentCount = argumentCount || Infinity;                                                                        // 713
	  return function () {                                                                                              // 714
	    var self = this;                                                                                                // 715
	    var args = Array.prototype.slice.call(arguments, 0,                                                             // 716
	        argumentCount > 0 ? argumentCount : 0);                                                                     // 717
	    return new Promise(function (resolve, reject) {                                                                 // 718
	      args.push(function (err, res) {                                                                               // 719
	        if (err) reject(err);                                                                                       // 720
	        else resolve(res);                                                                                          // 721
	      })                                                                                                            // 722
	      var res = fn.apply(self, args);                                                                               // 723
	      if (res &&                                                                                                    // 724
	        (                                                                                                           // 725
	          typeof res === 'object' ||                                                                                // 726
	          typeof res === 'function'                                                                                 // 727
	        ) &&                                                                                                        // 728
	        typeof res.then === 'function'                                                                              // 729
	      ) {                                                                                                           // 730
	        resolve(res);                                                                                               // 731
	      }                                                                                                             // 732
	    })                                                                                                              // 733
	  }                                                                                                                 // 734
	}                                                                                                                   // 735
	Promise.nodeify = function (fn) {                                                                                   // 736
	  return function () {                                                                                              // 737
	    var args = Array.prototype.slice.call(arguments);                                                               // 738
	    var callback =                                                                                                  // 739
	      typeof args[args.length - 1] === 'function' ? args.pop() : null;                                              // 740
	    var ctx = this;                                                                                                 // 741
	    try {                                                                                                           // 742
	      return fn.apply(this, arguments).nodeify(callback, ctx);                                                      // 743
	    } catch (ex) {                                                                                                  // 744
	      if (callback === null || typeof callback == 'undefined') {                                                    // 745
	        return new Promise(function (resolve, reject) {                                                             // 746
	          reject(ex);                                                                                               // 747
	        });                                                                                                         // 748
	      } else {                                                                                                      // 749
	        asap(function () {                                                                                          // 750
	          callback.call(ctx, ex);                                                                                   // 751
	        })                                                                                                          // 752
	      }                                                                                                             // 753
	    }                                                                                                               // 754
	  }                                                                                                                 // 755
	}                                                                                                                   // 756
                                                                                                                     // 757
	Promise.prototype.nodeify = function (callback, ctx) {                                                              // 758
	  if (typeof callback != 'function') return this;                                                                   // 759
                                                                                                                     // 760
	  this.then(function (value) {                                                                                      // 761
	    asap(function () {                                                                                              // 762
	      callback.call(ctx, null, value);                                                                              // 763
	    });                                                                                                             // 764
	  }, function (err) {                                                                                               // 765
	    asap(function () {                                                                                              // 766
	      callback.call(ctx, err);                                                                                      // 767
	    });                                                                                                             // 768
	  });                                                                                                               // 769
	}                                                                                                                   // 770
                                                                                                                     // 771
                                                                                                                     // 772
/***/ },                                                                                                             // 773
/* 10 */                                                                                                             // 774
/***/ function(module, exports, __webpack_require__) {                                                               // 775
                                                                                                                     // 776
	"use strict";                                                                                                       // 777
                                                                                                                     // 778
	// rawAsap provides everything we need except exception management.                                                 // 779
	var rawAsap = __webpack_require__(5);                                                                               // 780
	// RawTasks are recycled to reduce GC churn.                                                                        // 781
	var freeTasks = [];                                                                                                 // 782
	// We queue errors to ensure they are thrown in right order (FIFO).                                                 // 783
	// Array-as-queue is good enough here, since we are just dealing with exceptions.                                   // 784
	var pendingErrors = [];                                                                                             // 785
	var requestErrorThrow = rawAsap.makeRequestCallFromTimer(throwFirstError);                                          // 786
                                                                                                                     // 787
	function throwFirstError() {                                                                                        // 788
	    if (pendingErrors.length) {                                                                                     // 789
	        throw pendingErrors.shift();                                                                                // 790
	    }                                                                                                               // 791
	}                                                                                                                   // 792
                                                                                                                     // 793
	/**                                                                                                                 // 794
	 * Calls a task as soon as possible after returning, in its own event, with priority                                // 795
	 * over other events like animation, reflow, and repaint. An error thrown from an                                   // 796
	 * event will not interrupt, nor even substantially slow down the processing of                                     // 797
	 * other events, but will be rather postponed to a lower priority event.                                            // 798
	 * @param {{call}} task A callable object, typically a function that takes no                                       // 799
	 * arguments.                                                                                                       // 800
	 */                                                                                                                 // 801
	module.exports = asap;                                                                                              // 802
	function asap(task) {                                                                                               // 803
	    var rawTask;                                                                                                    // 804
	    if (freeTasks.length) {                                                                                         // 805
	        rawTask = freeTasks.pop();                                                                                  // 806
	    } else {                                                                                                        // 807
	        rawTask = new RawTask();                                                                                    // 808
	    }                                                                                                               // 809
	    rawTask.task = task;                                                                                            // 810
	    rawAsap(rawTask);                                                                                               // 811
	}                                                                                                                   // 812
                                                                                                                     // 813
	// We wrap tasks with recyclable task objects.  A task object implements                                            // 814
	// `call`, just like a function.                                                                                    // 815
	function RawTask() {                                                                                                // 816
	    this.task = null;                                                                                               // 817
	}                                                                                                                   // 818
                                                                                                                     // 819
	// The sole purpose of wrapping the task is to catch the exception and recycle                                      // 820
	// the task object after its single use.                                                                            // 821
	RawTask.prototype.call = function () {                                                                              // 822
	    try {                                                                                                           // 823
	        this.task.call();                                                                                           // 824
	    } catch (error) {                                                                                               // 825
	        if (asap.onerror) {                                                                                         // 826
	            // This hook exists purely for testing purposes.                                                        // 827
	            // Its name will be periodically randomized to break any code that                                      // 828
	            // depends on its existence.                                                                            // 829
	            asap.onerror(error);                                                                                    // 830
	        } else {                                                                                                    // 831
	            // In a web browser, exceptions are not fatal. However, to avoid                                        // 832
	            // slowing down the queue of pending tasks, we rethrow the error in a                                   // 833
	            // lower priority turn.                                                                                 // 834
	            pendingErrors.push(error);                                                                              // 835
	            requestErrorThrow();                                                                                    // 836
	        }                                                                                                           // 837
	    } finally {                                                                                                     // 838
	        this.task = null;                                                                                           // 839
	        freeTasks[freeTasks.length] = this;                                                                         // 840
	    }                                                                                                               // 841
	};                                                                                                                  // 842
                                                                                                                     // 843
                                                                                                                     // 844
/***/ }                                                                                                              // 845
/******/ ]);                                                                                                         // 846
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package.promise = {
  Promise: Promise
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var _ = Package.underscore._;
var Tracker = Package.tracker.Tracker;
var Deps = Package.tracker.Deps;
var EJSON = Package.ejson.EJSON;
var ECMAScript = Package.ecmascript.ECMAScript;
var babelHelpers = Package['babel-runtime'].babelHelpers;
var Symbol = Package['ecmascript-runtime'].Symbol;
var Map = Package['ecmascript-runtime'].Map;
var Set = Package['ecmascript-runtime'].Set;
var Promise = Package.promise.Promise;

/* Package-scope variables */
var ReactiveDict;

(function(){

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                //
// packages/reactive-dict/reactive-dict.js                                                                        //
//                                                                                                                //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                  //
// XXX come up with a serialization method which canonicalizes object key                                         //
// order, which would allow us to use objects as values for equals.                                               //
var stringify = function (value) {                                                                                // 3
  if (value === undefined) return 'undefined';                                                                    // 4
  return EJSON.stringify(value);                                                                                  // 6
};                                                                                                                //
var parse = function (serialized) {                                                                               // 8
  if (serialized === undefined || serialized === 'undefined') return undefined;                                   // 9
  return EJSON.parse(serialized);                                                                                 // 11
};                                                                                                                //
                                                                                                                  //
var changed = function (v) {                                                                                      // 14
  v && v.changed();                                                                                               // 15
};                                                                                                                //
                                                                                                                  //
// XXX COMPAT WITH 0.9.1 : accept migrationData instead of dictName                                               //
ReactiveDict = function (dictName) {                                                                              // 19
  // this.keys: key -> value                                                                                      //
  if (dictName) {                                                                                                 // 21
    if (typeof dictName === 'string') {                                                                           // 22
      // the normal case, argument is a string name.                                                              //
      // _registerDictForMigrate will throw an error on duplicate name.                                           //
      ReactiveDict._registerDictForMigrate(dictName, this);                                                       // 25
      this.keys = ReactiveDict._loadMigratedDict(dictName) || {};                                                 // 26
      this.name = dictName;                                                                                       // 27
    } else if (typeof dictName === 'object') {                                                                    //
      // back-compat case: dictName is actually migrationData                                                     //
      this.keys = dictName;                                                                                       // 30
    } else {                                                                                                      //
      throw new Error("Invalid ReactiveDict argument: " + dictName);                                              // 32
    }                                                                                                             //
  } else {                                                                                                        //
    // no name given; no migration will be performed                                                              //
    this.keys = {};                                                                                               // 36
  }                                                                                                               //
                                                                                                                  //
  this.allDeps = new Tracker.Dependency();                                                                        // 39
  this.keyDeps = {}; // key -> Dependency                                                                         // 40
  this.keyValueDeps = {}; // key -> Dependency                                                                    // 41
};                                                                                                                //
                                                                                                                  //
_.extend(ReactiveDict.prototype, {                                                                                // 44
  // set() began as a key/value method, but we are now overloading it                                             //
  // to take an object of key/value pairs, similar to backbone                                                    //
  // http://backbonejs.org/#Model-set                                                                             //
                                                                                                                  //
  set: function (keyOrObject, value) {                                                                            // 49
    var self = this;                                                                                              // 50
                                                                                                                  //
    if (typeof keyOrObject === 'object' && value === undefined) {                                                 // 52
      // Called as `dict.set({...})`                                                                              //
      self._setObject(keyOrObject);                                                                               // 54
      return;                                                                                                     // 55
    }                                                                                                             //
    // the input isn't an object, so it must be a key                                                             //
    // and we resume with the rest of the function                                                                //
    var key = keyOrObject;                                                                                        // 59
                                                                                                                  //
    value = stringify(value);                                                                                     // 61
                                                                                                                  //
    var keyExisted = _.has(self.keys, key);                                                                       // 63
    var oldSerializedValue = keyExisted ? self.keys[key] : 'undefined';                                           // 64
    var isNewValue = value !== oldSerializedValue;                                                                // 65
                                                                                                                  //
    self.keys[key] = value;                                                                                       // 67
                                                                                                                  //
    if (isNewValue || !keyExisted) {                                                                              // 69
      self.allDeps.changed();                                                                                     // 70
    }                                                                                                             //
                                                                                                                  //
    if (isNewValue) {                                                                                             // 73
      changed(self.keyDeps[key]);                                                                                 // 74
      if (self.keyValueDeps[key]) {                                                                               // 75
        changed(self.keyValueDeps[key][oldSerializedValue]);                                                      // 76
        changed(self.keyValueDeps[key][value]);                                                                   // 77
      }                                                                                                           //
    }                                                                                                             //
  },                                                                                                              //
                                                                                                                  //
  setDefault: function (key, value) {                                                                             // 82
    var self = this;                                                                                              // 83
    if (!_.has(self.keys, key)) {                                                                                 // 84
      self.set(key, value);                                                                                       // 85
    }                                                                                                             //
  },                                                                                                              //
                                                                                                                  //
  get: function (key) {                                                                                           // 89
    var self = this;                                                                                              // 90
    self._ensureKey(key);                                                                                         // 91
    self.keyDeps[key].depend();                                                                                   // 92
    return parse(self.keys[key]);                                                                                 // 93
  },                                                                                                              //
                                                                                                                  //
  equals: function (key, value) {                                                                                 // 96
    var self = this;                                                                                              // 97
                                                                                                                  //
    // Mongo.ObjectID is in the 'mongo' package                                                                   //
    var ObjectID = null;                                                                                          // 100
    if (Package.mongo) {                                                                                          // 101
      ObjectID = Package.mongo.Mongo.ObjectID;                                                                    // 102
    }                                                                                                             //
                                                                                                                  //
    // We don't allow objects (or arrays that might include objects) for                                          //
    // .equals, because JSON.stringify doesn't canonicalize object key                                            //
    // order. (We can make equals have the right return value by parsing the                                      //
    // current value and using EJSON.equals, but we won't have a canonical                                        //
    // element of keyValueDeps[key] to store the dependency.) You can still use                                   //
    // "EJSON.equals(reactiveDict.get(key), value)".                                                              //
    //                                                                                                            //
    // XXX we could allow arrays as long as we recursively check that there                                       //
    // are no objects                                                                                             //
    if (typeof value !== 'string' && typeof value !== 'number' && typeof value !== 'boolean' && typeof value !== 'undefined' && !(value instanceof Date) && !(ObjectID && value instanceof ObjectID) && value !== null) {
      throw new Error("ReactiveDict.equals: value must be scalar");                                               // 121
    }                                                                                                             //
    var serializedValue = stringify(value);                                                                       // 123
                                                                                                                  //
    if (Tracker.active) {                                                                                         // 125
      self._ensureKey(key);                                                                                       // 126
                                                                                                                  //
      if (!_.has(self.keyValueDeps[key], serializedValue)) self.keyValueDeps[key][serializedValue] = new Tracker.Dependency();
                                                                                                                  //
      var isNew = self.keyValueDeps[key][serializedValue].depend();                                               // 131
      if (isNew) {                                                                                                // 132
        Tracker.onInvalidate(function () {                                                                        // 133
          // clean up [key][serializedValue] if it's now empty, so we don't                                       //
          // use O(n) memory for n = values seen ever                                                             //
          if (!self.keyValueDeps[key][serializedValue].hasDependents()) delete self.keyValueDeps[key][serializedValue];
        });                                                                                                       //
      }                                                                                                           //
    }                                                                                                             //
                                                                                                                  //
    var oldValue = undefined;                                                                                     // 142
    if (_.has(self.keys, key)) oldValue = parse(self.keys[key]);                                                  // 143
    return EJSON.equals(oldValue, value);                                                                         // 144
  },                                                                                                              //
                                                                                                                  //
  all: function () {                                                                                              // 147
    this.allDeps.depend();                                                                                        // 148
    var ret = {};                                                                                                 // 149
    _.each(this.keys, function (value, key) {                                                                     // 150
      ret[key] = parse(value);                                                                                    // 151
    });                                                                                                           //
    return ret;                                                                                                   // 153
  },                                                                                                              //
                                                                                                                  //
  clear: function () {                                                                                            // 156
    var self = this;                                                                                              // 157
                                                                                                                  //
    var oldKeys = self.keys;                                                                                      // 159
    self.keys = {};                                                                                               // 160
                                                                                                                  //
    self.allDeps.changed();                                                                                       // 162
                                                                                                                  //
    _.each(oldKeys, function (value, key) {                                                                       // 164
      changed(self.keyDeps[key]);                                                                                 // 165
      changed(self.keyValueDeps[key][value]);                                                                     // 166
      changed(self.keyValueDeps[key]['undefined']);                                                               // 167
    });                                                                                                           //
  },                                                                                                              //
                                                                                                                  //
  'delete': function (key) {                                                                                      // 172
    var self = this;                                                                                              // 173
    var didRemove = false;                                                                                        // 174
                                                                                                                  //
    if (_.has(self.keys, key)) {                                                                                  // 176
      var oldValue = self.keys[key];                                                                              // 177
      delete self.keys[key];                                                                                      // 178
      changed(self.keyDeps[key]);                                                                                 // 179
      if (self.keyValueDeps[key]) {                                                                               // 180
        changed(self.keyValueDeps[key][oldValue]);                                                                // 181
        changed(self.keyValueDeps[key]['undefined']);                                                             // 182
      }                                                                                                           //
      self.allDeps.changed();                                                                                     // 184
      didRemove = true;                                                                                           // 185
    }                                                                                                             //
                                                                                                                  //
    return didRemove;                                                                                             // 188
  },                                                                                                              //
                                                                                                                  //
  _setObject: function (object) {                                                                                 // 191
    var self = this;                                                                                              // 192
                                                                                                                  //
    _.each(object, function (value, key) {                                                                        // 194
      self.set(key, value);                                                                                       // 195
    });                                                                                                           //
  },                                                                                                              //
                                                                                                                  //
  _ensureKey: function (key) {                                                                                    // 199
    var self = this;                                                                                              // 200
    if (!(key in self.keyDeps)) {                                                                                 // 201
      self.keyDeps[key] = new Tracker.Dependency();                                                               // 202
      self.keyValueDeps[key] = {};                                                                                // 203
    }                                                                                                             //
  },                                                                                                              //
                                                                                                                  //
  // Get a JSON value that can be passed to the constructor to                                                    //
  // create a new ReactiveDict with the same contents as this one                                                 //
  _getMigrationData: function () {                                                                                // 209
    // XXX sanitize and make sure it's JSONible?                                                                  //
    return this.keys;                                                                                             // 211
  }                                                                                                               //
});                                                                                                               //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);






(function(){

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                //
// packages/reactive-dict/migration.js                                                                            //
//                                                                                                                //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                  //
ReactiveDict._migratedDictData = {}; // name -> data                                                              // 1
ReactiveDict._dictsToMigrate = {}; // name -> ReactiveDict                                                        // 2
                                                                                                                  //
ReactiveDict._loadMigratedDict = function (dictName) {                                                            // 4
  if (_.has(ReactiveDict._migratedDictData, dictName)) return ReactiveDict._migratedDictData[dictName];           // 5
                                                                                                                  //
  return null;                                                                                                    // 8
};                                                                                                                //
                                                                                                                  //
ReactiveDict._registerDictForMigrate = function (dictName, dict) {                                                // 11
  if (_.has(ReactiveDict._dictsToMigrate, dictName)) throw new Error("Duplicate ReactiveDict name: " + dictName);
                                                                                                                  //
  ReactiveDict._dictsToMigrate[dictName] = dict;                                                                  // 15
};                                                                                                                //
                                                                                                                  //
if (Meteor.isClient && Package.reload) {                                                                          // 18
  // Put old migrated data into ReactiveDict._migratedDictData,                                                   //
  // where it can be accessed by ReactiveDict._loadMigratedDict.                                                  //
  var migrationData = Package.reload.Reload._migrationData('reactive-dict');                                      // 21
  if (migrationData && migrationData.dicts) ReactiveDict._migratedDictData = migrationData.dicts;                 // 22
                                                                                                                  //
  // On migration, assemble the data from all the dicts that have been                                            //
  // registered.                                                                                                  //
  Package.reload.Reload._onMigrate('reactive-dict', function () {                                                 // 27
    var dictsToMigrate = ReactiveDict._dictsToMigrate;                                                            // 28
    var dataToMigrate = {};                                                                                       // 29
                                                                                                                  //
    for (var dictName in babelHelpers.sanitizeForInObject(dictsToMigrate)) dataToMigrate[dictName] = dictsToMigrate[dictName]._getMigrationData();
                                                                                                                  //
    return [true, { dicts: dataToMigrate }];                                                                      // 34
  });                                                                                                             //
}                                                                                                                 //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['reactive-dict'] = {
  ReactiveDict: ReactiveDict
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var _ = Package.underscore._;
var ReactiveDict = Package['reactive-dict'].ReactiveDict;
var EJSON = Package.ejson.EJSON;

/* Package-scope variables */
var Session;

(function(){

/////////////////////////////////////////////////////////////////////////////////
//                                                                             //
// packages/session/session.js                                                 //
//                                                                             //
/////////////////////////////////////////////////////////////////////////////////
                                                                               //
Session = new ReactiveDict('session');                                         // 1
                                                                               // 2
// Documentation here is really awkward because the methods are defined        // 3
// elsewhere                                                                   // 4
                                                                               // 5
/**                                                                            // 6
 * @memberOf Session                                                           // 7
 * @method set                                                                 // 8
 * @summary Set a variable in the session. Notify any listeners that the value
 * has changed (eg: redraw templates, and rerun any                            // 10
 * [`Tracker.autorun`](#tracker_autorun) computations, that called             // 11
 * [`Session.get`](#session_get) on this `key`.)                               // 12
 * @locus Client                                                               // 13
 * @param {String} key The key to set, eg, `selectedItem`                      // 14
 * @param {EJSONable | undefined} value The new value for `key`                // 15
 */                                                                            // 16
                                                                               // 17
/**                                                                            // 18
 * @memberOf Session                                                           // 19
 * @method setDefault                                                          // 20
 * @summary Set a variable in the session if it hasn't been set before.        // 21
 * Otherwise works exactly the same as [`Session.set`](#session_set).          // 22
 * @locus Client                                                               // 23
 * @param {String} key The key to set, eg, `selectedItem`                      // 24
 * @param {EJSONable | undefined} value The new value for `key`                // 25
 */                                                                            // 26
                                                                               // 27
/**                                                                            // 28
 * @memberOf Session                                                           // 29
 * @method get                                                                 // 30
 * @summary Get the value of a session variable. If inside a [reactive         // 31
 * computation](#reactivity), invalidate the computation the next time the     // 32
 * value of the variable is changed by [`Session.set`](#session_set). This     // 33
 * returns a clone of the session value, so if it's an object or an array,     // 34
 * mutating the returned value has no effect on the value stored in the        // 35
 * session.                                                                    // 36
 * @locus Client                                                               // 37
 * @param {String} key The name of the session variable to return              // 38
 */                                                                            // 39
                                                                               // 40
/**                                                                            // 41
 * @memberOf Session                                                           // 42
 * @method equals                                                              // 43
 * @summary Test if a session variable is equal to a value. If inside a        // 44
 * [reactive computation](#reactivity), invalidate the computation the next    // 45
 * time the variable changes to or from the value.                             // 46
 * @locus Client                                                               // 47
 * @param {String} key The name of the session variable to test                // 48
 * @param {String | Number | Boolean | null | undefined} value The value to    // 49
 * test against                                                                // 50
 */                                                                            // 51
                                                                               // 52
/////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package.session = {
  Session: Session
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var Tracker = Package.tracker.Tracker;
var Deps = Package.tracker.Deps;

/* Package-scope variables */
var ReactiveVar;

(function(){

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                              //
// packages/reactive-var/reactive-var.js                                                                        //
//                                                                                                              //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                //
/*                                                                                                              // 1
 * ## [new] ReactiveVar(initialValue, [equalsFunc])                                                             // 2
 *                                                                                                              // 3
 * A ReactiveVar holds a single value that can be get and set,                                                  // 4
 * such that calling `set` will invalidate any Computations that                                                // 5
 * called `get`, according to the usual contract for reactive                                                   // 6
 * data sources.                                                                                                // 7
 *                                                                                                              // 8
 * A ReactiveVar is much like a Session variable -- compare `foo.get()`                                         // 9
 * to `Session.get("foo")` -- but it doesn't have a global name and isn't                                       // 10
 * automatically migrated across hot code pushes.  Also, while Session                                          // 11
 * variables can only hold JSON or EJSON, ReactiveVars can hold any value.                                      // 12
 *                                                                                                              // 13
 * An important property of ReactiveVars, which is sometimes the reason                                         // 14
 * to use one, is that setting the value to the same value as before has                                        // 15
 * no effect, meaning ReactiveVars can be used to absorb extra                                                  // 16
 * invalidations that wouldn't serve a purpose.  However, by default,                                           // 17
 * ReactiveVars are extremely conservative about what changes they                                              // 18
 * absorb.  Calling `set` with an object argument will *always* trigger                                         // 19
 * invalidations, because even if the new value is `===` the old value,                                         // 20
 * the object may have been mutated.  You can change the default behavior                                       // 21
 * by passing a function of two arguments, `oldValue` and `newValue`,                                           // 22
 * to the constructor as `equalsFunc`.                                                                          // 23
 *                                                                                                              // 24
 * This class is extremely basic right now, but the idea is to evolve                                           // 25
 * it into the ReactiveVar of Geoff's Lickable Forms proposal.                                                  // 26
 */                                                                                                             // 27
                                                                                                                // 28
/**                                                                                                             // 29
 * @class                                                                                                       // 30
 * @instanceName reactiveVar                                                                                    // 31
 * @summary Constructor for a ReactiveVar, which represents a single reactive variable.                         // 32
 * @locus Client                                                                                                // 33
 * @param {Any} initialValue The initial value to set.  `equalsFunc` is ignored when setting the initial value.
 * @param {Function} [equalsFunc] Optional.  A function of two arguments, called on the old value and the new value whenever the ReactiveVar is set.  If it returns true, no set is performed.  If omitted, the default `equalsFunc` returns true if its arguments are `===` and are of type number, boolean, string, undefined, or null.
 */                                                                                                             // 36
ReactiveVar = function (initialValue, equalsFunc) {                                                             // 37
  if (! (this instanceof ReactiveVar))                                                                          // 38
    // called without `new`                                                                                     // 39
    return new ReactiveVar(initialValue, equalsFunc);                                                           // 40
                                                                                                                // 41
  this.curValue = initialValue;                                                                                 // 42
  this.equalsFunc = equalsFunc;                                                                                 // 43
  this.dep = new Tracker.Dependency;                                                                            // 44
};                                                                                                              // 45
                                                                                                                // 46
ReactiveVar._isEqual = function (oldValue, newValue) {                                                          // 47
  var a = oldValue, b = newValue;                                                                               // 48
  // Two values are "equal" here if they are `===` and are                                                      // 49
  // number, boolean, string, undefined, or null.                                                               // 50
  if (a !== b)                                                                                                  // 51
    return false;                                                                                               // 52
  else                                                                                                          // 53
    return ((!a) || (typeof a === 'number') || (typeof a === 'boolean') ||                                      // 54
            (typeof a === 'string'));                                                                           // 55
};                                                                                                              // 56
                                                                                                                // 57
/**                                                                                                             // 58
 * @summary Returns the current value of the ReactiveVar, establishing a reactive dependency.                   // 59
 * @locus Client                                                                                                // 60
 */                                                                                                             // 61
ReactiveVar.prototype.get = function () {                                                                       // 62
  if (Tracker.active)                                                                                           // 63
    this.dep.depend();                                                                                          // 64
                                                                                                                // 65
  return this.curValue;                                                                                         // 66
};                                                                                                              // 67
                                                                                                                // 68
/**                                                                                                             // 69
 * @summary Sets the current value of the ReactiveVar, invalidating the Computations that called `get` if `newValue` is different from the old value.
 * @locus Client                                                                                                // 71
 * @param {Any} newValue                                                                                        // 72
 */                                                                                                             // 73
ReactiveVar.prototype.set = function (newValue) {                                                               // 74
  var oldValue = this.curValue;                                                                                 // 75
                                                                                                                // 76
  if ((this.equalsFunc || ReactiveVar._isEqual)(oldValue, newValue))                                            // 77
    // value is same as last time                                                                               // 78
    return;                                                                                                     // 79
                                                                                                                // 80
  this.curValue = newValue;                                                                                     // 81
  this.dep.changed();                                                                                           // 82
};                                                                                                              // 83
                                                                                                                // 84
ReactiveVar.prototype.toString = function () {                                                                  // 85
  return 'ReactiveVar{' + this.get() + '}';                                                                     // 86
};                                                                                                              // 87
                                                                                                                // 88
ReactiveVar.prototype._numListeners = function() {                                                              // 89
  // Tests want to know.                                                                                        // 90
  // Accesses a private field of Tracker.Dependency.                                                            // 91
  var count = 0;                                                                                                // 92
  for (var id in this.dep._dependentsById)                                                                      // 93
    count++;                                                                                                    // 94
  return count;                                                                                                 // 95
};                                                                                                              // 96
                                                                                                                // 97
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['reactive-var'] = {
  ReactiveVar: ReactiveVar
};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var Mongo = Package.mongo.Mongo;
var Tracker = Package.tracker.Tracker;
var Deps = Package.tracker.Deps;
var LocalCollection = Package.minimongo.LocalCollection;
var Minimongo = Package.minimongo.Minimongo;

/* Package-scope variables */
var CollectionExtensions;

(function(){

//////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                  //
// packages/lai_collection-extensions/packages/lai_collection-extensions.js                         //
//                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                    //
(function () {                                                                                      // 1
                                                                                                    // 2
///////////////////////////////////////////////////////////////////////////////////////////////     // 3
//                                                                                           //     // 4
// packages/lai:collection-extensions/collection-extensions.js                               //     // 5
//                                                                                           //     // 6
///////////////////////////////////////////////////////////////////////////////////////////////     // 7
                                                                                             //     // 8
// The collection extensions namespace                                                       // 1   // 9
CollectionExtensions = {};                                                                   // 2   // 10
                                                                                             // 3   // 11
// Stores all the collection extensions                                                      // 4   // 12
CollectionExtensions._extensions = [];                                                       // 5   // 13
                                                                                             // 6   // 14
// This is where you would add custom functionality to                                       // 7   // 15
// Mongo.Collection/Meteor.Collection                                                        // 8   // 16
Meteor.addCollectionExtension = function (customFunction) {                                  // 9   // 17
  if (typeof customFunction !== 'function') {                                                // 10  // 18
    throw new Meteor.Error(                                                                  // 11  // 19
      'collection-extension-wrong-argument',                                                 // 12  // 20
      'You must pass a function \
       into Meteor.addCollectionExtension().');                                              // 14  // 22
  }                                                                                          // 15  // 23
  CollectionExtensions._extensions.push(customFunction);                                     // 16  // 24
  // If Meteor.users exists, apply the extension right away                                  // 17  // 25
  if (typeof Meteor.users !== 'undefined') {                                                 // 18  // 26
    customFunction.apply(Meteor.users, ['users']);                                           // 19  // 27
  }                                                                                          // 20  // 28
};                                                                                           // 21  // 29
                                                                                             // 22  // 30
// Utility function to add a prototype function to your                                      // 23  // 31
// Meteor/Mongo.Collection object                                                            // 24  // 32
Meteor.addCollectionPrototype = function (name, customFunction) {                            // 25  // 33
  if (typeof name !== 'string') {                                                            // 26  // 34
    throw new Meteor.Error(                                                                  // 27  // 35
      'collection-extension-wrong-argument',                                                 // 28  // 36
      'You must pass a string as the first argument \
       into Meteor.addCollectionPrototype().');                                              // 30  // 38
  }                                                                                          // 31  // 39
  if (typeof customFunction !== 'function') {                                                // 32  // 40
    throw new Meteor.Error(                                                                  // 33  // 41
      'collection-extension-wrong-argument',                                                 // 34  // 42
      'You must pass a function as the second argument \
       into Meteor.addCollectionPrototype().');                                              // 36  // 44
  }                                                                                          // 37  // 45
  (typeof Mongo !== 'undefined' ?                                                            // 38  // 46
    Mongo.Collection :                                                                       // 39  // 47
    Meteor.Collection).prototype[name] = customFunction;                                     // 40  // 48
};                                                                                           // 41  // 49
                                                                                             // 42  // 50
// This is used to reassign the prototype of unfortunately                                   // 43  // 51
// and unstoppably already instantiated Mongo instances                                      // 44  // 52
// i.e. Meteor.users                                                                         // 45  // 53
CollectionExtensions._reassignCollectionPrototype = function (instance, constr) {            // 46  // 54
  var hasSetPrototypeOf = typeof Object.setPrototypeOf === 'function';                       // 47  // 55
                                                                                             // 48  // 56
  if (!constr) constr = typeof Mongo !== 'undefined' ? Mongo.Collection : Meteor.Collection; // 49  // 57
                                                                                             // 50  // 58
  // __proto__ is not available in < IE11                                                    // 51  // 59
  // Note: Assigning a prototype dynamically has performance implications                    // 52  // 60
  if (hasSetPrototypeOf) {                                                                   // 53  // 61
    Object.setPrototypeOf(instance, constr.prototype);                                       // 54  // 62
  } else if (instance.__proto__) {                                                           // 55  // 63
    instance.__proto__ = constr.prototype;                                                   // 56  // 64
  }                                                                                          // 57  // 65
};                                                                                           // 58  // 66
                                                                                             // 59  // 67
// This monkey-patches the Collection constructor                                            // 60  // 68
// This code is the same monkey-patching code                                                // 61  // 69
// that matb33:collection-hooks uses, which works pretty nicely                              // 62  // 70
CollectionExtensions._wrapCollection = function (ns, as) {                                   // 63  // 71
  // Save the original prototype                                                             // 64  // 72
  if (!as._CollectionPrototype) as._CollectionPrototype = new as.Collection(null);           // 65  // 73
                                                                                             // 66  // 74
  var constructor = as.Collection;                                                           // 67  // 75
  var proto = as._CollectionPrototype;                                                       // 68  // 76
                                                                                             // 69  // 77
  ns.Collection = function () {                                                              // 70  // 78
    var ret = constructor.apply(this, arguments);                                            // 71  // 79
    // This is where all the collection extensions get processed                             // 72  // 80
    CollectionExtensions._processCollectionExtensions(this, arguments);                      // 73  // 81
    return ret;                                                                              // 74  // 82
  };                                                                                         // 75  // 83
                                                                                             // 76  // 84
  ns.Collection.prototype = proto;                                                           // 77  // 85
  ns.Collection.prototype.constructor = ns.Collection;                                       // 78  // 86
                                                                                             // 79  // 87
  for (var prop in constructor) {                                                            // 80  // 88
    if (constructor.hasOwnProperty(prop)) {                                                  // 81  // 89
      ns.Collection[prop] = constructor[prop];                                               // 82  // 90
    }                                                                                        // 83  // 91
  }                                                                                          // 84  // 92
};                                                                                           // 85  // 93
                                                                                             // 86  // 94
CollectionExtensions._processCollectionExtensions = function (self, args) {                  // 87  // 95
  // Using old-school operations for better performance                                      // 88  // 96
  // Please don't judge me ;P                                                                // 89  // 97
  var args = args ? [].slice.call(args, 0) : undefined;                                      // 90  // 98
  var extensions = CollectionExtensions._extensions;                                         // 91  // 99
  for (var i = 0, len = extensions.length; i < len; i++) {                                   // 92  // 100
    extensions[i].apply(self, args);                                                         // 93  // 101
  }                                                                                          // 94  // 102
};                                                                                           // 95  // 103
                                                                                             // 96  // 104
if (typeof Mongo !== 'undefined') {                                                          // 97  // 105
  CollectionExtensions._wrapCollection(Meteor, Mongo);                                       // 98  // 106
  CollectionExtensions._wrapCollection(Mongo, Mongo);                                        // 99  // 107
} else {                                                                                     // 100
  CollectionExtensions._wrapCollection(Meteor, Meteor);                                      // 101
}                                                                                            // 102
                                                                                             // 103
if (typeof Meteor.users !== 'undefined') {                                                   // 104
  // Ensures that Meteor.users instanceof Mongo.Collection                                   // 105
  CollectionExtensions._reassignCollectionPrototype(Meteor.users);                           // 106
}                                                                                            // 107
///////////////////////////////////////////////////////////////////////////////////////////////     // 116
                                                                                                    // 117
}).call(this);                                                                                      // 118
                                                                                                    // 119
//////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['lai:collection-extensions'] = {};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var Mongo = Package.mongo.Mongo;
var _ = Package.underscore._;

(function(){

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                  //
// packages/dburles_mongo-collection-instances/packages/dburles_mongo-collection-instances.js                       //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                    //
(function () {                                                                                                      // 1
                                                                                                                    // 2
////////////////////////////////////////////////////////////////////////////////////////////////////////////////    // 3
//                                                                                                            //    // 4
// packages/dburles:mongo-collection-instances/mongo-instances.js                                             //    // 5
//                                                                                                            //    // 6
////////////////////////////////////////////////////////////////////////////////////////////////////////////////    // 7
                                                                                                              //    // 8
var instances = [];                                                                                           // 1  // 9
                                                                                                              // 2  // 10
Meteor.addCollectionExtension(function (name, options) {                                                      // 3  // 11
  instances.push({                                                                                            // 4  // 12
    name: name,                                                                                               // 5  // 13
    instance: this,                                                                                           // 6  // 14
    options: options                                                                                          // 7  // 15
  });                                                                                                         // 8  // 16
});                                                                                                           // 9  // 17
                                                                                                              // 10
Mongo.Collection.get = function(name, options) {                                                              // 11
  options = options || {};                                                                                    // 12
  var collection = _.find(instances, function(instance) {                                                     // 13
    if (options.connection)                                                                                   // 14
      return instance.name === name &&                                                                        // 15
        instance.options && instance.options.connection._lastSessionId === options.connection._lastSessionId; // 16
    return instance.name === name;                                                                            // 17
  });                                                                                                         // 18
                                                                                                              // 19
  return collection && collection.instance;                                                                   // 20
};                                                                                                            // 21
                                                                                                              // 22
Mongo.Collection.getAll = function() {                                                                        // 23
  return instances;                                                                                           // 24
};                                                                                                            // 25
                                                                                                              // 26
// Meteor.Collection will lack ownProperties that are added back to Mongo.Collection                          // 27
Meteor.Collection = Mongo.Collection;                                                                         // 28
////////////////////////////////////////////////////////////////////////////////////////////////////////////////    // 37
                                                                                                                    // 38
}).call(this);                                                                                                      // 39
                                                                                                                    // 40
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['dburles:mongo-collection-instances'] = {};

})();
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;

(function(){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                 //
// packages/benjamine_jsondiffpatch/public/build/jsondiffpatch-full.js                                             //
//                                                                                                                 //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                   //
!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.jsondiffpatch=e()}}(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
var environment = require('./environment');                                                                        // 2
                                                                                                                   // 3
if (environment.isBrowser) {                                                                                       // 4
  /* global window */                                                                                              // 5
  /* jshint camelcase: false */                                                                                    // 6
  window.diff_match_patch = require('../public/external/diff_match_patch_uncompressed');                           // 7
  /* jshint camelcase: true */                                                                                     // 8
}                                                                                                                  // 9
                                                                                                                   // 10
module.exports = require('./main');                                                                                // 11
                                                                                                                   // 12
},{"../public/external/diff_match_patch_uncompressed":2,"./environment":9,"./main":16}],2:[function(require,module,exports){
/**                                                                                                                // 14
 * Diff Match and Patch                                                                                            // 15
 *                                                                                                                 // 16
 * Copyright 2006 Google Inc.                                                                                      // 17
 * http://code.google.com/p/google-diff-match-patch/                                                               // 18
 *                                                                                                                 // 19
 * Licensed under the Apache License, Version 2.0 (the "License");                                                 // 20
 * you may not use this file except in compliance with the License.                                                // 21
 * You may obtain a copy of the License at                                                                         // 22
 *                                                                                                                 // 23
 *   http://www.apache.org/licenses/LICENSE-2.0                                                                    // 24
 *                                                                                                                 // 25
 * Unless required by applicable law or agreed to in writing, software                                             // 26
 * distributed under the License is distributed on an "AS IS" BASIS,                                               // 27
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.                                        // 28
 * See the License for the specific language governing permissions and                                             // 29
 * limitations under the License.                                                                                  // 30
 */                                                                                                                // 31
                                                                                                                   // 32
/**                                                                                                                // 33
 * @fileoverview Computes the difference between two texts to create a patch.                                      // 34
 * Applies the patch onto another text, allowing for errors.                                                       // 35
 * @author fraser@google.com (Neil Fraser)                                                                         // 36
 */                                                                                                                // 37
                                                                                                                   // 38
/**                                                                                                                // 39
 * Class containing the diff, match and patch methods.                                                             // 40
 * @constructor                                                                                                    // 41
 */                                                                                                                // 42
function diff_match_patch() {                                                                                      // 43
                                                                                                                   // 44
  // Defaults.                                                                                                     // 45
  // Redefine these in your program to override the defaults.                                                      // 46
                                                                                                                   // 47
  // Number of seconds to map a diff before giving up (0 for infinity).                                            // 48
  this.Diff_Timeout = 1.0;                                                                                         // 49
  // Cost of an empty edit operation in terms of edit characters.                                                  // 50
  this.Diff_EditCost = 4;                                                                                          // 51
  // At what point is no match declared (0.0 = perfection, 1.0 = very loose).                                      // 52
  this.Match_Threshold = 0.5;                                                                                      // 53
  // How far to search for a match (0 = exact location, 1000+ = broad match).                                      // 54
  // A match this many characters away from the expected location will add                                         // 55
  // 1.0 to the score (0.0 is a perfect match).                                                                    // 56
  this.Match_Distance = 1000;                                                                                      // 57
  // When deleting a large block of text (over ~64 characters), how close does                                     // 58
  // the contents have to match the expected contents. (0.0 = perfection,                                          // 59
  // 1.0 = very loose).  Note that Match_Threshold controls how closely the                                        // 60
  // end points of a delete need to match.                                                                         // 61
  this.Patch_DeleteThreshold = 0.5;                                                                                // 62
  // Chunk size for context length.                                                                                // 63
  this.Patch_Margin = 4;                                                                                           // 64
                                                                                                                   // 65
  // The number of bits in an int.                                                                                 // 66
  this.Match_MaxBits = 32;                                                                                         // 67
}                                                                                                                  // 68
                                                                                                                   // 69
                                                                                                                   // 70
//  DIFF FUNCTIONS                                                                                                 // 71
                                                                                                                   // 72
                                                                                                                   // 73
/**                                                                                                                // 74
 * The data structure representing a diff is an array of tuples:                                                   // 75
 * [[DIFF_DELETE, 'Hello'], [DIFF_INSERT, 'Goodbye'], [DIFF_EQUAL, ' world.']]                                     // 76
 * which means: delete 'Hello', add 'Goodbye' and keep ' world.'                                                   // 77
 */                                                                                                                // 78
var DIFF_DELETE = -1;                                                                                              // 79
var DIFF_INSERT = 1;                                                                                               // 80
var DIFF_EQUAL = 0;                                                                                                // 81
                                                                                                                   // 82
/** @typedef {!Array.<number|string>} */                                                                           // 83
diff_match_patch.Diff;                                                                                             // 84
                                                                                                                   // 85
                                                                                                                   // 86
/**                                                                                                                // 87
 * Find the differences between two texts.  Simplifies the problem by stripping                                    // 88
 * any common prefix or suffix off the texts before diffing.                                                       // 89
 * @param {string} text1 Old string to be diffed.                                                                  // 90
 * @param {string} text2 New string to be diffed.                                                                  // 91
 * @param {boolean=} opt_checklines Optional speedup flag. If present and false,                                   // 92
 *     then don't run a line-level diff first to identify the changed areas.                                       // 93
 *     Defaults to true, which does a faster, slightly less optimal diff.                                          // 94
 * @param {number} opt_deadline Optional time when the diff should be complete                                     // 95
 *     by.  Used internally for recursive calls.  Users should set DiffTimeout                                     // 96
 *     instead.                                                                                                    // 97
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.                                                 // 98
 */                                                                                                                // 99
diff_match_patch.prototype.diff_main = function(text1, text2, opt_checklines,                                      // 100
    opt_deadline) {                                                                                                // 101
  // Set a deadline by which time the diff must be complete.                                                       // 102
  if (typeof opt_deadline == 'undefined') {                                                                        // 103
    if (this.Diff_Timeout <= 0) {                                                                                  // 104
      opt_deadline = Number.MAX_VALUE;                                                                             // 105
    } else {                                                                                                       // 106
      opt_deadline = (new Date).getTime() + this.Diff_Timeout * 1000;                                              // 107
    }                                                                                                              // 108
  }                                                                                                                // 109
  var deadline = opt_deadline;                                                                                     // 110
                                                                                                                   // 111
  // Check for null inputs.                                                                                        // 112
  if (text1 == null || text2 == null) {                                                                            // 113
    throw new Error('Null input. (diff_main)');                                                                    // 114
  }                                                                                                                // 115
                                                                                                                   // 116
  // Check for equality (speedup).                                                                                 // 117
  if (text1 == text2) {                                                                                            // 118
    if (text1) {                                                                                                   // 119
      return [[DIFF_EQUAL, text1]];                                                                                // 120
    }                                                                                                              // 121
    return [];                                                                                                     // 122
  }                                                                                                                // 123
                                                                                                                   // 124
  if (typeof opt_checklines == 'undefined') {                                                                      // 125
    opt_checklines = true;                                                                                         // 126
  }                                                                                                                // 127
  var checklines = opt_checklines;                                                                                 // 128
                                                                                                                   // 129
  // Trim off common prefix (speedup).                                                                             // 130
  var commonlength = this.diff_commonPrefix(text1, text2);                                                         // 131
  var commonprefix = text1.substring(0, commonlength);                                                             // 132
  text1 = text1.substring(commonlength);                                                                           // 133
  text2 = text2.substring(commonlength);                                                                           // 134
                                                                                                                   // 135
  // Trim off common suffix (speedup).                                                                             // 136
  commonlength = this.diff_commonSuffix(text1, text2);                                                             // 137
  var commonsuffix = text1.substring(text1.length - commonlength);                                                 // 138
  text1 = text1.substring(0, text1.length - commonlength);                                                         // 139
  text2 = text2.substring(0, text2.length - commonlength);                                                         // 140
                                                                                                                   // 141
  // Compute the diff on the middle block.                                                                         // 142
  var diffs = this.diff_compute_(text1, text2, checklines, deadline);                                              // 143
                                                                                                                   // 144
  // Restore the prefix and suffix.                                                                                // 145
  if (commonprefix) {                                                                                              // 146
    diffs.unshift([DIFF_EQUAL, commonprefix]);                                                                     // 147
  }                                                                                                                // 148
  if (commonsuffix) {                                                                                              // 149
    diffs.push([DIFF_EQUAL, commonsuffix]);                                                                        // 150
  }                                                                                                                // 151
  this.diff_cleanupMerge(diffs);                                                                                   // 152
  return diffs;                                                                                                    // 153
};                                                                                                                 // 154
                                                                                                                   // 155
                                                                                                                   // 156
/**                                                                                                                // 157
 * Find the differences between two texts.  Assumes that the texts do not                                          // 158
 * have any common prefix or suffix.                                                                               // 159
 * @param {string} text1 Old string to be diffed.                                                                  // 160
 * @param {string} text2 New string to be diffed.                                                                  // 161
 * @param {boolean} checklines Speedup flag.  If false, then don't run a                                           // 162
 *     line-level diff first to identify the changed areas.                                                        // 163
 *     If true, then run a faster, slightly less optimal diff.                                                     // 164
 * @param {number} deadline Time when the diff should be complete by.                                              // 165
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.                                                 // 166
 * @private                                                                                                        // 167
 */                                                                                                                // 168
diff_match_patch.prototype.diff_compute_ = function(text1, text2, checklines,                                      // 169
    deadline) {                                                                                                    // 170
  var diffs;                                                                                                       // 171
                                                                                                                   // 172
  if (!text1) {                                                                                                    // 173
    // Just add some text (speedup).                                                                               // 174
    return [[DIFF_INSERT, text2]];                                                                                 // 175
  }                                                                                                                // 176
                                                                                                                   // 177
  if (!text2) {                                                                                                    // 178
    // Just delete some text (speedup).                                                                            // 179
    return [[DIFF_DELETE, text1]];                                                                                 // 180
  }                                                                                                                // 181
                                                                                                                   // 182
  var longtext = text1.length > text2.length ? text1 : text2;                                                      // 183
  var shorttext = text1.length > text2.length ? text2 : text1;                                                     // 184
  var i = longtext.indexOf(shorttext);                                                                             // 185
  if (i != -1) {                                                                                                   // 186
    // Shorter text is inside the longer text (speedup).                                                           // 187
    diffs = [[DIFF_INSERT, longtext.substring(0, i)],                                                              // 188
             [DIFF_EQUAL, shorttext],                                                                              // 189
             [DIFF_INSERT, longtext.substring(i + shorttext.length)]];                                             // 190
    // Swap insertions for deletions if diff is reversed.                                                          // 191
    if (text1.length > text2.length) {                                                                             // 192
      diffs[0][0] = diffs[2][0] = DIFF_DELETE;                                                                     // 193
    }                                                                                                              // 194
    return diffs;                                                                                                  // 195
  }                                                                                                                // 196
                                                                                                                   // 197
  if (shorttext.length == 1) {                                                                                     // 198
    // Single character string.                                                                                    // 199
    // After the previous speedup, the character can't be an equality.                                             // 200
    return [[DIFF_DELETE, text1], [DIFF_INSERT, text2]];                                                           // 201
  }                                                                                                                // 202
  longtext = shorttext = null;  // Garbage collect.                                                                // 203
                                                                                                                   // 204
  // Check to see if the problem can be split in two.                                                              // 205
  var hm = this.diff_halfMatch_(text1, text2);                                                                     // 206
  if (hm) {                                                                                                        // 207
    // A half-match was found, sort out the return data.                                                           // 208
    var text1_a = hm[0];                                                                                           // 209
    var text1_b = hm[1];                                                                                           // 210
    var text2_a = hm[2];                                                                                           // 211
    var text2_b = hm[3];                                                                                           // 212
    var mid_common = hm[4];                                                                                        // 213
    // Send both pairs off for separate processing.                                                                // 214
    var diffs_a = this.diff_main(text1_a, text2_a, checklines, deadline);                                          // 215
    var diffs_b = this.diff_main(text1_b, text2_b, checklines, deadline);                                          // 216
    // Merge the results.                                                                                          // 217
    return diffs_a.concat([[DIFF_EQUAL, mid_common]], diffs_b);                                                    // 218
  }                                                                                                                // 219
                                                                                                                   // 220
  if (checklines && text1.length > 100 && text2.length > 100) {                                                    // 221
    return this.diff_lineMode_(text1, text2, deadline);                                                            // 222
  }                                                                                                                // 223
                                                                                                                   // 224
  return this.diff_bisect_(text1, text2, deadline);                                                                // 225
};                                                                                                                 // 226
                                                                                                                   // 227
                                                                                                                   // 228
/**                                                                                                                // 229
 * Do a quick line-level diff on both strings, then rediff the parts for                                           // 230
 * greater accuracy.                                                                                               // 231
 * This speedup can produce non-minimal diffs.                                                                     // 232
 * @param {string} text1 Old string to be diffed.                                                                  // 233
 * @param {string} text2 New string to be diffed.                                                                  // 234
 * @param {number} deadline Time when the diff should be complete by.                                              // 235
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.                                                 // 236
 * @private                                                                                                        // 237
 */                                                                                                                // 238
diff_match_patch.prototype.diff_lineMode_ = function(text1, text2, deadline) {                                     // 239
  // Scan the text on a line-by-line basis first.                                                                  // 240
  var a = this.diff_linesToChars_(text1, text2);                                                                   // 241
  text1 = /** @type {string} */(a[0]);                                                                             // 242
  text2 = /** @type {string} */(a[1]);                                                                             // 243
  var linearray = /** @type {!Array.<string>} */(a[2]);                                                            // 244
                                                                                                                   // 245
  var diffs = this.diff_bisect_(text1, text2, deadline);                                                           // 246
                                                                                                                   // 247
  // Convert the diff back to original text.                                                                       // 248
  this.diff_charsToLines_(diffs, linearray);                                                                       // 249
  // Eliminate freak matches (e.g. blank lines)                                                                    // 250
  this.diff_cleanupSemantic(diffs);                                                                                // 251
                                                                                                                   // 252
  // Rediff any replacement blocks, this time character-by-character.                                              // 253
  // Add a dummy entry at the end.                                                                                 // 254
  diffs.push([DIFF_EQUAL, '']);                                                                                    // 255
  var pointer = 0;                                                                                                 // 256
  var count_delete = 0;                                                                                            // 257
  var count_insert = 0;                                                                                            // 258
  var text_delete = '';                                                                                            // 259
  var text_insert = '';                                                                                            // 260
  while (pointer < diffs.length) {                                                                                 // 261
    switch (diffs[pointer][0]) {                                                                                   // 262
      case DIFF_INSERT:                                                                                            // 263
        count_insert++;                                                                                            // 264
        text_insert += diffs[pointer][1];                                                                          // 265
        break;                                                                                                     // 266
      case DIFF_DELETE:                                                                                            // 267
        count_delete++;                                                                                            // 268
        text_delete += diffs[pointer][1];                                                                          // 269
        break;                                                                                                     // 270
      case DIFF_EQUAL:                                                                                             // 271
        // Upon reaching an equality, check for prior redundancies.                                                // 272
        if (count_delete >= 1 && count_insert >= 1) {                                                              // 273
          // Delete the offending records and add the merged ones.                                                 // 274
          var a = this.diff_main(text_delete, text_insert, false, deadline);                                       // 275
          diffs.splice(pointer - count_delete - count_insert,                                                      // 276
                       count_delete + count_insert);                                                               // 277
          pointer = pointer - count_delete - count_insert;                                                         // 278
          for (var j = a.length - 1; j >= 0; j--) {                                                                // 279
            diffs.splice(pointer, 0, a[j]);                                                                        // 280
          }                                                                                                        // 281
          pointer = pointer + a.length;                                                                            // 282
        }                                                                                                          // 283
        count_insert = 0;                                                                                          // 284
        count_delete = 0;                                                                                          // 285
        text_delete = '';                                                                                          // 286
        text_insert = '';                                                                                          // 287
        break;                                                                                                     // 288
    }                                                                                                              // 289
    pointer++;                                                                                                     // 290
  }                                                                                                                // 291
  diffs.pop();  // Remove the dummy entry at the end.                                                              // 292
                                                                                                                   // 293
  return diffs;                                                                                                    // 294
};                                                                                                                 // 295
                                                                                                                   // 296
                                                                                                                   // 297
/**                                                                                                                // 298
 * Find the 'middle snake' of a diff, split the problem in two                                                     // 299
 * and return the recursively constructed diff.                                                                    // 300
 * See Myers 1986 paper: An O(ND) Difference Algorithm and Its Variations.                                         // 301
 * @param {string} text1 Old string to be diffed.                                                                  // 302
 * @param {string} text2 New string to be diffed.                                                                  // 303
 * @param {number} deadline Time at which to bail if not yet complete.                                             // 304
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.                                                 // 305
 * @private                                                                                                        // 306
 */                                                                                                                // 307
diff_match_patch.prototype.diff_bisect_ = function(text1, text2, deadline) {                                       // 308
  // Cache the text lengths to prevent multiple calls.                                                             // 309
  var text1_length = text1.length;                                                                                 // 310
  var text2_length = text2.length;                                                                                 // 311
  var max_d = Math.ceil((text1_length + text2_length) / 2);                                                        // 312
  var v_offset = max_d;                                                                                            // 313
  var v_length = 2 * max_d;                                                                                        // 314
  var v1 = new Array(v_length);                                                                                    // 315
  var v2 = new Array(v_length);                                                                                    // 316
  // Setting all elements to -1 is faster in Chrome & Firefox than mixing                                          // 317
  // integers and undefined.                                                                                       // 318
  for (var x = 0; x < v_length; x++) {                                                                             // 319
    v1[x] = -1;                                                                                                    // 320
    v2[x] = -1;                                                                                                    // 321
  }                                                                                                                // 322
  v1[v_offset + 1] = 0;                                                                                            // 323
  v2[v_offset + 1] = 0;                                                                                            // 324
  var delta = text1_length - text2_length;                                                                         // 325
  // If the total number of characters is odd, then the front path will collide                                    // 326
  // with the reverse path.                                                                                        // 327
  var front = (delta % 2 != 0);                                                                                    // 328
  // Offsets for start and end of k loop.                                                                          // 329
  // Prevents mapping of space beyond the grid.                                                                    // 330
  var k1start = 0;                                                                                                 // 331
  var k1end = 0;                                                                                                   // 332
  var k2start = 0;                                                                                                 // 333
  var k2end = 0;                                                                                                   // 334
  for (var d = 0; d < max_d; d++) {                                                                                // 335
    // Bail out if deadline is reached.                                                                            // 336
    if ((new Date()).getTime() > deadline) {                                                                       // 337
      break;                                                                                                       // 338
    }                                                                                                              // 339
                                                                                                                   // 340
    // Walk the front path one step.                                                                               // 341
    for (var k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {                                                        // 342
      var k1_offset = v_offset + k1;                                                                               // 343
      var x1;                                                                                                      // 344
      if (k1 == -d || k1 != d && v1[k1_offset - 1] < v1[k1_offset + 1]) {                                          // 345
        x1 = v1[k1_offset + 1];                                                                                    // 346
      } else {                                                                                                     // 347
        x1 = v1[k1_offset - 1] + 1;                                                                                // 348
      }                                                                                                            // 349
      var y1 = x1 - k1;                                                                                            // 350
      while (x1 < text1_length && y1 < text2_length &&                                                             // 351
             text1.charAt(x1) == text2.charAt(y1)) {                                                               // 352
        x1++;                                                                                                      // 353
        y1++;                                                                                                      // 354
      }                                                                                                            // 355
      v1[k1_offset] = x1;                                                                                          // 356
      if (x1 > text1_length) {                                                                                     // 357
        // Ran off the right of the graph.                                                                         // 358
        k1end += 2;                                                                                                // 359
      } else if (y1 > text2_length) {                                                                              // 360
        // Ran off the bottom of the graph.                                                                        // 361
        k1start += 2;                                                                                              // 362
      } else if (front) {                                                                                          // 363
        var k2_offset = v_offset + delta - k1;                                                                     // 364
        if (k2_offset >= 0 && k2_offset < v_length && v2[k2_offset] != -1) {                                       // 365
          // Mirror x2 onto top-left coordinate system.                                                            // 366
          var x2 = text1_length - v2[k2_offset];                                                                   // 367
          if (x1 >= x2) {                                                                                          // 368
            // Overlap detected.                                                                                   // 369
            return this.diff_bisectSplit_(text1, text2, x1, y1, deadline);                                         // 370
          }                                                                                                        // 371
        }                                                                                                          // 372
      }                                                                                                            // 373
    }                                                                                                              // 374
                                                                                                                   // 375
    // Walk the reverse path one step.                                                                             // 376
    for (var k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {                                                        // 377
      var k2_offset = v_offset + k2;                                                                               // 378
      var x2;                                                                                                      // 379
      if (k2 == -d || k2 != d && v2[k2_offset - 1] < v2[k2_offset + 1]) {                                          // 380
        x2 = v2[k2_offset + 1];                                                                                    // 381
      } else {                                                                                                     // 382
        x2 = v2[k2_offset - 1] + 1;                                                                                // 383
      }                                                                                                            // 384
      var y2 = x2 - k2;                                                                                            // 385
      while (x2 < text1_length && y2 < text2_length &&                                                             // 386
             text1.charAt(text1_length - x2 - 1) ==                                                                // 387
             text2.charAt(text2_length - y2 - 1)) {                                                                // 388
        x2++;                                                                                                      // 389
        y2++;                                                                                                      // 390
      }                                                                                                            // 391
      v2[k2_offset] = x2;                                                                                          // 392
      if (x2 > text1_length) {                                                                                     // 393
        // Ran off the left of the graph.                                                                          // 394
        k2end += 2;                                                                                                // 395
      } else if (y2 > text2_length) {                                                                              // 396
        // Ran off the top of the graph.                                                                           // 397
        k2start += 2;                                                                                              // 398
      } else if (!front) {                                                                                         // 399
        var k1_offset = v_offset + delta - k2;                                                                     // 400
        if (k1_offset >= 0 && k1_offset < v_length && v1[k1_offset] != -1) {                                       // 401
          var x1 = v1[k1_offset];                                                                                  // 402
          var y1 = v_offset + x1 - k1_offset;                                                                      // 403
          // Mirror x2 onto top-left coordinate system.                                                            // 404
          x2 = text1_length - x2;                                                                                  // 405
          if (x1 >= x2) {                                                                                          // 406
            // Overlap detected.                                                                                   // 407
            return this.diff_bisectSplit_(text1, text2, x1, y1, deadline);                                         // 408
          }                                                                                                        // 409
        }                                                                                                          // 410
      }                                                                                                            // 411
    }                                                                                                              // 412
  }                                                                                                                // 413
  // Diff took too long and hit the deadline or                                                                    // 414
  // number of diffs equals number of characters, no commonality at all.                                           // 415
  return [[DIFF_DELETE, text1], [DIFF_INSERT, text2]];                                                             // 416
};                                                                                                                 // 417
                                                                                                                   // 418
                                                                                                                   // 419
/**                                                                                                                // 420
 * Given the location of the 'middle snake', split the diff in two parts                                           // 421
 * and recurse.                                                                                                    // 422
 * @param {string} text1 Old string to be diffed.                                                                  // 423
 * @param {string} text2 New string to be diffed.                                                                  // 424
 * @param {number} x Index of split point in text1.                                                                // 425
 * @param {number} y Index of split point in text2.                                                                // 426
 * @param {number} deadline Time at which to bail if not yet complete.                                             // 427
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.                                                 // 428
 * @private                                                                                                        // 429
 */                                                                                                                // 430
diff_match_patch.prototype.diff_bisectSplit_ = function(text1, text2, x, y,                                        // 431
    deadline) {                                                                                                    // 432
  var text1a = text1.substring(0, x);                                                                              // 433
  var text2a = text2.substring(0, y);                                                                              // 434
  var text1b = text1.substring(x);                                                                                 // 435
  var text2b = text2.substring(y);                                                                                 // 436
                                                                                                                   // 437
  // Compute both diffs serially.                                                                                  // 438
  var diffs = this.diff_main(text1a, text2a, false, deadline);                                                     // 439
  var diffsb = this.diff_main(text1b, text2b, false, deadline);                                                    // 440
                                                                                                                   // 441
  return diffs.concat(diffsb);                                                                                     // 442
};                                                                                                                 // 443
                                                                                                                   // 444
                                                                                                                   // 445
/**                                                                                                                // 446
 * Split two texts into an array of strings.  Reduce the texts to a string of                                      // 447
 * hashes where each Unicode character represents one line.                                                        // 448
 * @param {string} text1 First string.                                                                             // 449
 * @param {string} text2 Second string.                                                                            // 450
 * @return {!Array.<string|!Array.<string>>} Three element Array, containing the                                   // 451
 *     encoded text1, the encoded text2 and the array of unique strings.  The                                      // 452
 *     zeroth element of the array of unique strings is intentionally blank.                                       // 453
 * @private                                                                                                        // 454
 */                                                                                                                // 455
diff_match_patch.prototype.diff_linesToChars_ = function(text1, text2) {                                           // 456
  var lineArray = [];  // e.g. lineArray[4] == 'Hello\n'                                                           // 457
  var lineHash = {};   // e.g. lineHash['Hello\n'] == 4                                                            // 458
                                                                                                                   // 459
  // '\x00' is a valid character, but various debuggers don't like it.                                             // 460
  // So we'll insert a junk entry to avoid generating a null character.                                            // 461
  lineArray[0] = '';                                                                                               // 462
                                                                                                                   // 463
  /**                                                                                                              // 464
   * Split a text into an array of strings.  Reduce the texts to a string of                                       // 465
   * hashes where each Unicode character represents one line.                                                      // 466
   * Modifies linearray and linehash through being a closure.                                                      // 467
   * @param {string} text String to encode.                                                                        // 468
   * @return {string} Encoded string.                                                                              // 469
   * @private                                                                                                      // 470
   */                                                                                                              // 471
  function diff_linesToCharsMunge_(text) {                                                                         // 472
    var chars = '';                                                                                                // 473
    // Walk the text, pulling out a substring for each line.                                                       // 474
    // text.split('\n') would would temporarily double our memory footprint.                                       // 475
    // Modifying text would create many large strings to garbage collect.                                          // 476
    var lineStart = 0;                                                                                             // 477
    var lineEnd = -1;                                                                                              // 478
    // Keeping our own length variable is faster than looking it up.                                               // 479
    var lineArrayLength = lineArray.length;                                                                        // 480
    while (lineEnd < text.length - 1) {                                                                            // 481
      lineEnd = text.indexOf('\n', lineStart);                                                                     // 482
      if (lineEnd == -1) {                                                                                         // 483
        lineEnd = text.length - 1;                                                                                 // 484
      }                                                                                                            // 485
      var line = text.substring(lineStart, lineEnd + 1);                                                           // 486
      lineStart = lineEnd + 1;                                                                                     // 487
                                                                                                                   // 488
      if (lineHash.hasOwnProperty ? lineHash.hasOwnProperty(line) :                                                // 489
          (lineHash[line] !== undefined)) {                                                                        // 490
        chars += String.fromCharCode(lineHash[line]);                                                              // 491
      } else {                                                                                                     // 492
        chars += String.fromCharCode(lineArrayLength);                                                             // 493
        lineHash[line] = lineArrayLength;                                                                          // 494
        lineArray[lineArrayLength++] = line;                                                                       // 495
      }                                                                                                            // 496
    }                                                                                                              // 497
    return chars;                                                                                                  // 498
  }                                                                                                                // 499
                                                                                                                   // 500
  var chars1 = diff_linesToCharsMunge_(text1);                                                                     // 501
  var chars2 = diff_linesToCharsMunge_(text2);                                                                     // 502
  return [chars1, chars2, lineArray];                                                                              // 503
};                                                                                                                 // 504
                                                                                                                   // 505
                                                                                                                   // 506
/**                                                                                                                // 507
 * Rehydrate the text in a diff from a string of line hashes to real lines of                                      // 508
 * text.                                                                                                           // 509
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 510
 * @param {!Array.<string>} lineArray Array of unique strings.                                                     // 511
 * @private                                                                                                        // 512
 */                                                                                                                // 513
diff_match_patch.prototype.diff_charsToLines_ = function(diffs, lineArray) {                                       // 514
  for (var x = 0; x < diffs.length; x++) {                                                                         // 515
    var chars = diffs[x][1];                                                                                       // 516
    var text = [];                                                                                                 // 517
    for (var y = 0; y < chars.length; y++) {                                                                       // 518
      text[y] = lineArray[chars.charCodeAt(y)];                                                                    // 519
    }                                                                                                              // 520
    diffs[x][1] = text.join('');                                                                                   // 521
  }                                                                                                                // 522
};                                                                                                                 // 523
                                                                                                                   // 524
                                                                                                                   // 525
/**                                                                                                                // 526
 * Determine the common prefix of two strings.                                                                     // 527
 * @param {string} text1 First string.                                                                             // 528
 * @param {string} text2 Second string.                                                                            // 529
 * @return {number} The number of characters common to the start of each                                           // 530
 *     string.                                                                                                     // 531
 */                                                                                                                // 532
diff_match_patch.prototype.diff_commonPrefix = function(text1, text2) {                                            // 533
  // Quick check for common null cases.                                                                            // 534
  if (!text1 || !text2 || text1.charAt(0) != text2.charAt(0)) {                                                    // 535
    return 0;                                                                                                      // 536
  }                                                                                                                // 537
  // Binary search.                                                                                                // 538
  // Performance analysis: http://neil.fraser.name/news/2007/10/09/                                                // 539
  var pointermin = 0;                                                                                              // 540
  var pointermax = Math.min(text1.length, text2.length);                                                           // 541
  var pointermid = pointermax;                                                                                     // 542
  var pointerstart = 0;                                                                                            // 543
  while (pointermin < pointermid) {                                                                                // 544
    if (text1.substring(pointerstart, pointermid) ==                                                               // 545
        text2.substring(pointerstart, pointermid)) {                                                               // 546
      pointermin = pointermid;                                                                                     // 547
      pointerstart = pointermin;                                                                                   // 548
    } else {                                                                                                       // 549
      pointermax = pointermid;                                                                                     // 550
    }                                                                                                              // 551
    pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);                                           // 552
  }                                                                                                                // 553
  return pointermid;                                                                                               // 554
};                                                                                                                 // 555
                                                                                                                   // 556
                                                                                                                   // 557
/**                                                                                                                // 558
 * Determine the common suffix of two strings.                                                                     // 559
 * @param {string} text1 First string.                                                                             // 560
 * @param {string} text2 Second string.                                                                            // 561
 * @return {number} The number of characters common to the end of each string.                                     // 562
 */                                                                                                                // 563
diff_match_patch.prototype.diff_commonSuffix = function(text1, text2) {                                            // 564
  // Quick check for common null cases.                                                                            // 565
  if (!text1 || !text2 ||                                                                                          // 566
      text1.charAt(text1.length - 1) != text2.charAt(text2.length - 1)) {                                          // 567
    return 0;                                                                                                      // 568
  }                                                                                                                // 569
  // Binary search.                                                                                                // 570
  // Performance analysis: http://neil.fraser.name/news/2007/10/09/                                                // 571
  var pointermin = 0;                                                                                              // 572
  var pointermax = Math.min(text1.length, text2.length);                                                           // 573
  var pointermid = pointermax;                                                                                     // 574
  var pointerend = 0;                                                                                              // 575
  while (pointermin < pointermid) {                                                                                // 576
    if (text1.substring(text1.length - pointermid, text1.length - pointerend) ==                                   // 577
        text2.substring(text2.length - pointermid, text2.length - pointerend)) {                                   // 578
      pointermin = pointermid;                                                                                     // 579
      pointerend = pointermin;                                                                                     // 580
    } else {                                                                                                       // 581
      pointermax = pointermid;                                                                                     // 582
    }                                                                                                              // 583
    pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);                                           // 584
  }                                                                                                                // 585
  return pointermid;                                                                                               // 586
};                                                                                                                 // 587
                                                                                                                   // 588
                                                                                                                   // 589
/**                                                                                                                // 590
 * Determine if the suffix of one string is the prefix of another.                                                 // 591
 * @param {string} text1 First string.                                                                             // 592
 * @param {string} text2 Second string.                                                                            // 593
 * @return {number} The number of characters common to the end of the first                                        // 594
 *     string and the start of the second string.                                                                  // 595
 * @private                                                                                                        // 596
 */                                                                                                                // 597
diff_match_patch.prototype.diff_commonOverlap_ = function(text1, text2) {                                          // 598
  // Cache the text lengths to prevent multiple calls.                                                             // 599
  var text1_length = text1.length;                                                                                 // 600
  var text2_length = text2.length;                                                                                 // 601
  // Eliminate the null case.                                                                                      // 602
  if (text1_length == 0 || text2_length == 0) {                                                                    // 603
    return 0;                                                                                                      // 604
  }                                                                                                                // 605
  // Truncate the longer string.                                                                                   // 606
  if (text1_length > text2_length) {                                                                               // 607
    text1 = text1.substring(text1_length - text2_length);                                                          // 608
  } else if (text1_length < text2_length) {                                                                        // 609
    text2 = text2.substring(0, text1_length);                                                                      // 610
  }                                                                                                                // 611
  var text_length = Math.min(text1_length, text2_length);                                                          // 612
  // Quick check for the worst case.                                                                               // 613
  if (text1 == text2) {                                                                                            // 614
    return text_length;                                                                                            // 615
  }                                                                                                                // 616
                                                                                                                   // 617
  // Start by looking for a single character match                                                                 // 618
  // and increase length until no match is found.                                                                  // 619
  // Performance analysis: http://neil.fraser.name/news/2010/11/04/                                                // 620
  var best = 0;                                                                                                    // 621
  var length = 1;                                                                                                  // 622
  while (true) {                                                                                                   // 623
    var pattern = text1.substring(text_length - length);                                                           // 624
    var found = text2.indexOf(pattern);                                                                            // 625
    if (found == -1) {                                                                                             // 626
      return best;                                                                                                 // 627
    }                                                                                                              // 628
    length += found;                                                                                               // 629
    if (found == 0 || text1.substring(text_length - length) ==                                                     // 630
        text2.substring(0, length)) {                                                                              // 631
      best = length;                                                                                               // 632
      length++;                                                                                                    // 633
    }                                                                                                              // 634
  }                                                                                                                // 635
};                                                                                                                 // 636
                                                                                                                   // 637
                                                                                                                   // 638
/**                                                                                                                // 639
 * Do the two texts share a substring which is at least half the length of the                                     // 640
 * longer text?                                                                                                    // 641
 * This speedup can produce non-minimal diffs.                                                                     // 642
 * @param {string} text1 First string.                                                                             // 643
 * @param {string} text2 Second string.                                                                            // 644
 * @return {Array.<string>} Five element Array, containing the prefix of                                           // 645
 *     text1, the suffix of text1, the prefix of text2, the suffix of                                              // 646
 *     text2 and the common middle.  Or null if there was no match.                                                // 647
 * @private                                                                                                        // 648
 */                                                                                                                // 649
diff_match_patch.prototype.diff_halfMatch_ = function(text1, text2) {                                              // 650
  if (this.Diff_Timeout <= 0) {                                                                                    // 651
    // Don't risk returning a non-optimal diff if we have unlimited time.                                          // 652
    return null;                                                                                                   // 653
  }                                                                                                                // 654
  var longtext = text1.length > text2.length ? text1 : text2;                                                      // 655
  var shorttext = text1.length > text2.length ? text2 : text1;                                                     // 656
  if (longtext.length < 4 || shorttext.length * 2 < longtext.length) {                                             // 657
    return null;  // Pointless.                                                                                    // 658
  }                                                                                                                // 659
  var dmp = this;  // 'this' becomes 'window' in a closure.                                                        // 660
                                                                                                                   // 661
  /**                                                                                                              // 662
   * Does a substring of shorttext exist within longtext such that the substring                                   // 663
   * is at least half the length of longtext?                                                                      // 664
   * Closure, but does not reference any external variables.                                                       // 665
   * @param {string} longtext Longer string.                                                                       // 666
   * @param {string} shorttext Shorter string.                                                                     // 667
   * @param {number} i Start index of quarter length substring within longtext.                                    // 668
   * @return {Array.<string>} Five element Array, containing the prefix of                                         // 669
   *     longtext, the suffix of longtext, the prefix of shorttext, the suffix                                     // 670
   *     of shorttext and the common middle.  Or null if there was no match.                                       // 671
   * @private                                                                                                      // 672
   */                                                                                                              // 673
  function diff_halfMatchI_(longtext, shorttext, i) {                                                              // 674
    // Start with a 1/4 length substring at position i as a seed.                                                  // 675
    var seed = longtext.substring(i, i + Math.floor(longtext.length / 4));                                         // 676
    var j = -1;                                                                                                    // 677
    var best_common = '';                                                                                          // 678
    var best_longtext_a, best_longtext_b, best_shorttext_a, best_shorttext_b;                                      // 679
    while ((j = shorttext.indexOf(seed, j + 1)) != -1) {                                                           // 680
      var prefixLength = dmp.diff_commonPrefix(longtext.substring(i),                                              // 681
                                               shorttext.substring(j));                                            // 682
      var suffixLength = dmp.diff_commonSuffix(longtext.substring(0, i),                                           // 683
                                               shorttext.substring(0, j));                                         // 684
      if (best_common.length < suffixLength + prefixLength) {                                                      // 685
        best_common = shorttext.substring(j - suffixLength, j) +                                                   // 686
            shorttext.substring(j, j + prefixLength);                                                              // 687
        best_longtext_a = longtext.substring(0, i - suffixLength);                                                 // 688
        best_longtext_b = longtext.substring(i + prefixLength);                                                    // 689
        best_shorttext_a = shorttext.substring(0, j - suffixLength);                                               // 690
        best_shorttext_b = shorttext.substring(j + prefixLength);                                                  // 691
      }                                                                                                            // 692
    }                                                                                                              // 693
    if (best_common.length * 2 >= longtext.length) {                                                               // 694
      return [best_longtext_a, best_longtext_b,                                                                    // 695
              best_shorttext_a, best_shorttext_b, best_common];                                                    // 696
    } else {                                                                                                       // 697
      return null;                                                                                                 // 698
    }                                                                                                              // 699
  }                                                                                                                // 700
                                                                                                                   // 701
  // First check if the second quarter is the seed for a half-match.                                               // 702
  var hm1 = diff_halfMatchI_(longtext, shorttext,                                                                  // 703
                             Math.ceil(longtext.length / 4));                                                      // 704
  // Check again based on the third quarter.                                                                       // 705
  var hm2 = diff_halfMatchI_(longtext, shorttext,                                                                  // 706
                             Math.ceil(longtext.length / 2));                                                      // 707
  var hm;                                                                                                          // 708
  if (!hm1 && !hm2) {                                                                                              // 709
    return null;                                                                                                   // 710
  } else if (!hm2) {                                                                                               // 711
    hm = hm1;                                                                                                      // 712
  } else if (!hm1) {                                                                                               // 713
    hm = hm2;                                                                                                      // 714
  } else {                                                                                                         // 715
    // Both matched.  Select the longest.                                                                          // 716
    hm = hm1[4].length > hm2[4].length ? hm1 : hm2;                                                                // 717
  }                                                                                                                // 718
                                                                                                                   // 719
  // A half-match was found, sort out the return data.                                                             // 720
  var text1_a, text1_b, text2_a, text2_b;                                                                          // 721
  if (text1.length > text2.length) {                                                                               // 722
    text1_a = hm[0];                                                                                               // 723
    text1_b = hm[1];                                                                                               // 724
    text2_a = hm[2];                                                                                               // 725
    text2_b = hm[3];                                                                                               // 726
  } else {                                                                                                         // 727
    text2_a = hm[0];                                                                                               // 728
    text2_b = hm[1];                                                                                               // 729
    text1_a = hm[2];                                                                                               // 730
    text1_b = hm[3];                                                                                               // 731
  }                                                                                                                // 732
  var mid_common = hm[4];                                                                                          // 733
  return [text1_a, text1_b, text2_a, text2_b, mid_common];                                                         // 734
};                                                                                                                 // 735
                                                                                                                   // 736
                                                                                                                   // 737
/**                                                                                                                // 738
 * Reduce the number of edits by eliminating semantically trivial equalities.                                      // 739
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 740
 */                                                                                                                // 741
diff_match_patch.prototype.diff_cleanupSemantic = function(diffs) {                                                // 742
  var changes = false;                                                                                             // 743
  var equalities = [];  // Stack of indices where equalities are found.                                            // 744
  var equalitiesLength = 0;  // Keeping our own length var is faster in JS.                                        // 745
  /** @type {?string} */                                                                                           // 746
  var lastequality = null;  // Always equal to equalities[equalitiesLength-1][1]                                   // 747
  var pointer = 0;  // Index of current position.                                                                  // 748
  // Number of characters that changed prior to the equality.                                                      // 749
  var length_insertions1 = 0;                                                                                      // 750
  var length_deletions1 = 0;                                                                                       // 751
  // Number of characters that changed after the equality.                                                         // 752
  var length_insertions2 = 0;                                                                                      // 753
  var length_deletions2 = 0;                                                                                       // 754
  while (pointer < diffs.length) {                                                                                 // 755
    if (diffs[pointer][0] == DIFF_EQUAL) {  // Equality found.                                                     // 756
      equalities[equalitiesLength++] = pointer;                                                                    // 757
      length_insertions1 = length_insertions2;                                                                     // 758
      length_deletions1 = length_deletions2;                                                                       // 759
      length_insertions2 = 0;                                                                                      // 760
      length_deletions2 = 0;                                                                                       // 761
      lastequality = /** @type {string} */(diffs[pointer][1]);                                                     // 762
    } else {  // An insertion or deletion.                                                                         // 763
      if (diffs[pointer][0] == DIFF_INSERT) {                                                                      // 764
        length_insertions2 += diffs[pointer][1].length;                                                            // 765
      } else {                                                                                                     // 766
        length_deletions2 += diffs[pointer][1].length;                                                             // 767
      }                                                                                                            // 768
      // Eliminate an equality that is smaller or equal to the edits on both                                       // 769
      // sides of it.                                                                                              // 770
      if (lastequality !== null && (lastequality.length <=                                                         // 771
          Math.max(length_insertions1, length_deletions1)) &&                                                      // 772
          (lastequality.length <= Math.max(length_insertions2,                                                     // 773
                                           length_deletions2))) {                                                  // 774
        // Duplicate record.                                                                                       // 775
        diffs.splice(equalities[equalitiesLength - 1], 0,                                                          // 776
                     [DIFF_DELETE, lastequality]);                                                                 // 777
        // Change second copy to insert.                                                                           // 778
        diffs[equalities[equalitiesLength - 1] + 1][0] = DIFF_INSERT;                                              // 779
        // Throw away the equality we just deleted.                                                                // 780
        equalitiesLength--;                                                                                        // 781
        // Throw away the previous equality (it needs to be reevaluated).                                          // 782
        equalitiesLength--;                                                                                        // 783
        pointer = equalitiesLength > 0 ? equalities[equalitiesLength - 1] : -1;                                    // 784
        length_insertions1 = 0;  // Reset the counters.                                                            // 785
        length_deletions1 = 0;                                                                                     // 786
        length_insertions2 = 0;                                                                                    // 787
        length_deletions2 = 0;                                                                                     // 788
        lastequality = null;                                                                                       // 789
        changes = true;                                                                                            // 790
      }                                                                                                            // 791
    }                                                                                                              // 792
    pointer++;                                                                                                     // 793
  }                                                                                                                // 794
                                                                                                                   // 795
  // Normalize the diff.                                                                                           // 796
  if (changes) {                                                                                                   // 797
    this.diff_cleanupMerge(diffs);                                                                                 // 798
  }                                                                                                                // 799
  this.diff_cleanupSemanticLossless(diffs);                                                                        // 800
                                                                                                                   // 801
  // Find any overlaps between deletions and insertions.                                                           // 802
  // e.g: <del>abcxxx</del><ins>xxxdef</ins>                                                                       // 803
  //   -> <del>abc</del>xxx<ins>def</ins>                                                                          // 804
  // Only extract an overlap if it is as big as the edit ahead or behind it.                                       // 805
  pointer = 1;                                                                                                     // 806
  while (pointer < diffs.length) {                                                                                 // 807
    if (diffs[pointer - 1][0] == DIFF_DELETE &&                                                                    // 808
        diffs[pointer][0] == DIFF_INSERT) {                                                                        // 809
      var deletion = /** @type {string} */(diffs[pointer - 1][1]);                                                 // 810
      var insertion = /** @type {string} */(diffs[pointer][1]);                                                    // 811
      var overlap_length = this.diff_commonOverlap_(deletion, insertion);                                          // 812
      if (overlap_length >= deletion.length / 2 ||                                                                 // 813
          overlap_length >= insertion.length / 2) {                                                                // 814
        // Overlap found.  Insert an equality and trim the surrounding edits.                                      // 815
        diffs.splice(pointer, 0,                                                                                   // 816
            [DIFF_EQUAL, insertion.substring(0, overlap_length)]);                                                 // 817
        diffs[pointer - 1][1] =                                                                                    // 818
            deletion.substring(0, deletion.length - overlap_length);                                               // 819
        diffs[pointer + 1][1] = insertion.substring(overlap_length);                                               // 820
        pointer++;                                                                                                 // 821
      }                                                                                                            // 822
      pointer++;                                                                                                   // 823
    }                                                                                                              // 824
    pointer++;                                                                                                     // 825
  }                                                                                                                // 826
};                                                                                                                 // 827
                                                                                                                   // 828
                                                                                                                   // 829
/**                                                                                                                // 830
 * Look for single edits surrounded on both sides by equalities                                                    // 831
 * which can be shifted sideways to align the edit to a word boundary.                                             // 832
 * e.g: The c<ins>at c</ins>ame. -> The <ins>cat </ins>came.                                                       // 833
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 834
 */                                                                                                                // 835
diff_match_patch.prototype.diff_cleanupSemanticLossless = function(diffs) {                                        // 836
  // Define some regex patterns for matching boundaries.                                                           // 837
  var punctuation = /[^a-zA-Z0-9]/;                                                                                // 838
  var whitespace = /\s/;                                                                                           // 839
  var linebreak = /[\r\n]/;                                                                                        // 840
  var blanklineEnd = /\n\r?\n$/;                                                                                   // 841
  var blanklineStart = /^\r?\n\r?\n/;                                                                              // 842
                                                                                                                   // 843
  /**                                                                                                              // 844
   * Given two strings, compute a score representing whether the internal                                          // 845
   * boundary falls on logical boundaries.                                                                         // 846
   * Scores range from 5 (best) to 0 (worst).                                                                      // 847
   * Closure, makes reference to regex patterns defined above.                                                     // 848
   * @param {string} one First string.                                                                             // 849
   * @param {string} two Second string.                                                                            // 850
   * @return {number} The score.                                                                                   // 851
   * @private                                                                                                      // 852
   */                                                                                                              // 853
  function diff_cleanupSemanticScore_(one, two) {                                                                  // 854
    if (!one || !two) {                                                                                            // 855
      // Edges are the best.                                                                                       // 856
      return 5;                                                                                                    // 857
    }                                                                                                              // 858
                                                                                                                   // 859
    // Each port of this function behaves slightly differently due to                                              // 860
    // subtle differences in each language's definition of things like                                             // 861
    // 'whitespace'.  Since this function's purpose is largely cosmetic,                                           // 862
    // the choice has been made to use each language's native features                                             // 863
    // rather than force total conformity.                                                                         // 864
    var score = 0;                                                                                                 // 865
    // One point for non-alphanumeric.                                                                             // 866
    if (one.charAt(one.length - 1).match(punctuation) ||                                                           // 867
        two.charAt(0).match(punctuation)) {                                                                        // 868
      score++;                                                                                                     // 869
      // Two points for whitespace.                                                                                // 870
      if (one.charAt(one.length - 1).match(whitespace) ||                                                          // 871
          two.charAt(0).match(whitespace)) {                                                                       // 872
        score++;                                                                                                   // 873
        // Three points for line breaks.                                                                           // 874
        if (one.charAt(one.length - 1).match(linebreak) ||                                                         // 875
            two.charAt(0).match(linebreak)) {                                                                      // 876
          score++;                                                                                                 // 877
          // Four points for blank lines.                                                                          // 878
          if (one.match(blanklineEnd) || two.match(blanklineStart)) {                                              // 879
            score++;                                                                                               // 880
          }                                                                                                        // 881
        }                                                                                                          // 882
      }                                                                                                            // 883
    }                                                                                                              // 884
    return score;                                                                                                  // 885
  }                                                                                                                // 886
                                                                                                                   // 887
  var pointer = 1;                                                                                                 // 888
  // Intentionally ignore the first and last element (don't need checking).                                        // 889
  while (pointer < diffs.length - 1) {                                                                             // 890
    if (diffs[pointer - 1][0] == DIFF_EQUAL &&                                                                     // 891
        diffs[pointer + 1][0] == DIFF_EQUAL) {                                                                     // 892
      // This is a single edit surrounded by equalities.                                                           // 893
      var equality1 = /** @type {string} */(diffs[pointer - 1][1]);                                                // 894
      var edit = /** @type {string} */(diffs[pointer][1]);                                                         // 895
      var equality2 = /** @type {string} */(diffs[pointer + 1][1]);                                                // 896
                                                                                                                   // 897
      // First, shift the edit as far left as possible.                                                            // 898
      var commonOffset = this.diff_commonSuffix(equality1, edit);                                                  // 899
      if (commonOffset) {                                                                                          // 900
        var commonString = edit.substring(edit.length - commonOffset);                                             // 901
        equality1 = equality1.substring(0, equality1.length - commonOffset);                                       // 902
        edit = commonString + edit.substring(0, edit.length - commonOffset);                                       // 903
        equality2 = commonString + equality2;                                                                      // 904
      }                                                                                                            // 905
                                                                                                                   // 906
      // Second, step character by character right, looking for the best fit.                                      // 907
      var bestEquality1 = equality1;                                                                               // 908
      var bestEdit = edit;                                                                                         // 909
      var bestEquality2 = equality2;                                                                               // 910
      var bestScore = diff_cleanupSemanticScore_(equality1, edit) +                                                // 911
          diff_cleanupSemanticScore_(edit, equality2);                                                             // 912
      while (edit.charAt(0) === equality2.charAt(0)) {                                                             // 913
        equality1 += edit.charAt(0);                                                                               // 914
        edit = edit.substring(1) + equality2.charAt(0);                                                            // 915
        equality2 = equality2.substring(1);                                                                        // 916
        var score = diff_cleanupSemanticScore_(equality1, edit) +                                                  // 917
            diff_cleanupSemanticScore_(edit, equality2);                                                           // 918
        // The >= encourages trailing rather than leading whitespace on edits.                                     // 919
        if (score >= bestScore) {                                                                                  // 920
          bestScore = score;                                                                                       // 921
          bestEquality1 = equality1;                                                                               // 922
          bestEdit = edit;                                                                                         // 923
          bestEquality2 = equality2;                                                                               // 924
        }                                                                                                          // 925
      }                                                                                                            // 926
                                                                                                                   // 927
      if (diffs[pointer - 1][1] != bestEquality1) {                                                                // 928
        // We have an improvement, save it back to the diff.                                                       // 929
        if (bestEquality1) {                                                                                       // 930
          diffs[pointer - 1][1] = bestEquality1;                                                                   // 931
        } else {                                                                                                   // 932
          diffs.splice(pointer - 1, 1);                                                                            // 933
          pointer--;                                                                                               // 934
        }                                                                                                          // 935
        diffs[pointer][1] = bestEdit;                                                                              // 936
        if (bestEquality2) {                                                                                       // 937
          diffs[pointer + 1][1] = bestEquality2;                                                                   // 938
        } else {                                                                                                   // 939
          diffs.splice(pointer + 1, 1);                                                                            // 940
          pointer--;                                                                                               // 941
        }                                                                                                          // 942
      }                                                                                                            // 943
    }                                                                                                              // 944
    pointer++;                                                                                                     // 945
  }                                                                                                                // 946
};                                                                                                                 // 947
                                                                                                                   // 948
                                                                                                                   // 949
/**                                                                                                                // 950
 * Reduce the number of edits by eliminating operationally trivial equalities.                                     // 951
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 952
 */                                                                                                                // 953
diff_match_patch.prototype.diff_cleanupEfficiency = function(diffs) {                                              // 954
  var changes = false;                                                                                             // 955
  var equalities = [];  // Stack of indices where equalities are found.                                            // 956
  var equalitiesLength = 0;  // Keeping our own length var is faster in JS.                                        // 957
  var lastequality = '';  // Always equal to equalities[equalitiesLength-1][1]                                     // 958
  var pointer = 0;  // Index of current position.                                                                  // 959
  // Is there an insertion operation before the last equality.                                                     // 960
  var pre_ins = false;                                                                                             // 961
  // Is there a deletion operation before the last equality.                                                       // 962
  var pre_del = false;                                                                                             // 963
  // Is there an insertion operation after the last equality.                                                      // 964
  var post_ins = false;                                                                                            // 965
  // Is there a deletion operation after the last equality.                                                        // 966
  var post_del = false;                                                                                            // 967
  while (pointer < diffs.length) {                                                                                 // 968
    if (diffs[pointer][0] == DIFF_EQUAL) {  // Equality found.                                                     // 969
      if (diffs[pointer][1].length < this.Diff_EditCost &&                                                         // 970
          (post_ins || post_del)) {                                                                                // 971
        // Candidate found.                                                                                        // 972
        equalities[equalitiesLength++] = pointer;                                                                  // 973
        pre_ins = post_ins;                                                                                        // 974
        pre_del = post_del;                                                                                        // 975
        lastequality = diffs[pointer][1];                                                                          // 976
      } else {                                                                                                     // 977
        // Not a candidate, and can never become one.                                                              // 978
        equalitiesLength = 0;                                                                                      // 979
        lastequality = '';                                                                                         // 980
      }                                                                                                            // 981
      post_ins = post_del = false;                                                                                 // 982
    } else {  // An insertion or deletion.                                                                         // 983
      if (diffs[pointer][0] == DIFF_DELETE) {                                                                      // 984
        post_del = true;                                                                                           // 985
      } else {                                                                                                     // 986
        post_ins = true;                                                                                           // 987
      }                                                                                                            // 988
      /*                                                                                                           // 989
       * Five types to be split:                                                                                   // 990
       * <ins>A</ins><del>B</del>XY<ins>C</ins><del>D</del>                                                        // 991
       * <ins>A</ins>X<ins>C</ins><del>D</del>                                                                     // 992
       * <ins>A</ins><del>B</del>X<ins>C</ins>                                                                     // 993
       * <ins>A</del>X<ins>C</ins><del>D</del>                                                                     // 994
       * <ins>A</ins><del>B</del>X<del>C</del>                                                                     // 995
       */                                                                                                          // 996
      if (lastequality && ((pre_ins && pre_del && post_ins && post_del) ||                                         // 997
                           ((lastequality.length < this.Diff_EditCost / 2) &&                                      // 998
                            (pre_ins + pre_del + post_ins + post_del) == 3))) {                                    // 999
        // Duplicate record.                                                                                       // 1000
        diffs.splice(equalities[equalitiesLength - 1], 0,                                                          // 1001
                     [DIFF_DELETE, lastequality]);                                                                 // 1002
        // Change second copy to insert.                                                                           // 1003
        diffs[equalities[equalitiesLength - 1] + 1][0] = DIFF_INSERT;                                              // 1004
        equalitiesLength--;  // Throw away the equality we just deleted;                                           // 1005
        lastequality = '';                                                                                         // 1006
        if (pre_ins && pre_del) {                                                                                  // 1007
          // No changes made which could affect previous entry, keep going.                                        // 1008
          post_ins = post_del = true;                                                                              // 1009
          equalitiesLength = 0;                                                                                    // 1010
        } else {                                                                                                   // 1011
          equalitiesLength--;  // Throw away the previous equality.                                                // 1012
          pointer = equalitiesLength > 0 ?                                                                         // 1013
              equalities[equalitiesLength - 1] : -1;                                                               // 1014
          post_ins = post_del = false;                                                                             // 1015
        }                                                                                                          // 1016
        changes = true;                                                                                            // 1017
      }                                                                                                            // 1018
    }                                                                                                              // 1019
    pointer++;                                                                                                     // 1020
  }                                                                                                                // 1021
                                                                                                                   // 1022
  if (changes) {                                                                                                   // 1023
    this.diff_cleanupMerge(diffs);                                                                                 // 1024
  }                                                                                                                // 1025
};                                                                                                                 // 1026
                                                                                                                   // 1027
                                                                                                                   // 1028
/**                                                                                                                // 1029
 * Reorder and merge like edit sections.  Merge equalities.                                                        // 1030
 * Any edit section can move as long as it doesn't cross an equality.                                              // 1031
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 1032
 */                                                                                                                // 1033
diff_match_patch.prototype.diff_cleanupMerge = function(diffs) {                                                   // 1034
  diffs.push([DIFF_EQUAL, '']);  // Add a dummy entry at the end.                                                  // 1035
  var pointer = 0;                                                                                                 // 1036
  var count_delete = 0;                                                                                            // 1037
  var count_insert = 0;                                                                                            // 1038
  var text_delete = '';                                                                                            // 1039
  var text_insert = '';                                                                                            // 1040
  var commonlength;                                                                                                // 1041
  while (pointer < diffs.length) {                                                                                 // 1042
    switch (diffs[pointer][0]) {                                                                                   // 1043
      case DIFF_INSERT:                                                                                            // 1044
        count_insert++;                                                                                            // 1045
        text_insert += diffs[pointer][1];                                                                          // 1046
        pointer++;                                                                                                 // 1047
        break;                                                                                                     // 1048
      case DIFF_DELETE:                                                                                            // 1049
        count_delete++;                                                                                            // 1050
        text_delete += diffs[pointer][1];                                                                          // 1051
        pointer++;                                                                                                 // 1052
        break;                                                                                                     // 1053
      case DIFF_EQUAL:                                                                                             // 1054
        // Upon reaching an equality, check for prior redundancies.                                                // 1055
        if (count_delete + count_insert > 1) {                                                                     // 1056
          if (count_delete !== 0 && count_insert !== 0) {                                                          // 1057
            // Factor out any common prefixies.                                                                    // 1058
            commonlength = this.diff_commonPrefix(text_insert, text_delete);                                       // 1059
            if (commonlength !== 0) {                                                                              // 1060
              if ((pointer - count_delete - count_insert) > 0 &&                                                   // 1061
                  diffs[pointer - count_delete - count_insert - 1][0] ==                                           // 1062
                  DIFF_EQUAL) {                                                                                    // 1063
                diffs[pointer - count_delete - count_insert - 1][1] +=                                             // 1064
                    text_insert.substring(0, commonlength);                                                        // 1065
              } else {                                                                                             // 1066
                diffs.splice(0, 0, [DIFF_EQUAL,                                                                    // 1067
                                    text_insert.substring(0, commonlength)]);                                      // 1068
                pointer++;                                                                                         // 1069
              }                                                                                                    // 1070
              text_insert = text_insert.substring(commonlength);                                                   // 1071
              text_delete = text_delete.substring(commonlength);                                                   // 1072
            }                                                                                                      // 1073
            // Factor out any common suffixies.                                                                    // 1074
            commonlength = this.diff_commonSuffix(text_insert, text_delete);                                       // 1075
            if (commonlength !== 0) {                                                                              // 1076
              diffs[pointer][1] = text_insert.substring(text_insert.length -                                       // 1077
                  commonlength) + diffs[pointer][1];                                                               // 1078
              text_insert = text_insert.substring(0, text_insert.length -                                          // 1079
                  commonlength);                                                                                   // 1080
              text_delete = text_delete.substring(0, text_delete.length -                                          // 1081
                  commonlength);                                                                                   // 1082
            }                                                                                                      // 1083
          }                                                                                                        // 1084
          // Delete the offending records and add the merged ones.                                                 // 1085
          if (count_delete === 0) {                                                                                // 1086
            diffs.splice(pointer - count_delete - count_insert,                                                    // 1087
                count_delete + count_insert, [DIFF_INSERT, text_insert]);                                          // 1088
          } else if (count_insert === 0) {                                                                         // 1089
            diffs.splice(pointer - count_delete - count_insert,                                                    // 1090
                count_delete + count_insert, [DIFF_DELETE, text_delete]);                                          // 1091
          } else {                                                                                                 // 1092
            diffs.splice(pointer - count_delete - count_insert,                                                    // 1093
                count_delete + count_insert, [DIFF_DELETE, text_delete],                                           // 1094
                [DIFF_INSERT, text_insert]);                                                                       // 1095
          }                                                                                                        // 1096
          pointer = pointer - count_delete - count_insert +                                                        // 1097
                    (count_delete ? 1 : 0) + (count_insert ? 1 : 0) + 1;                                           // 1098
        } else if (pointer !== 0 && diffs[pointer - 1][0] == DIFF_EQUAL) {                                         // 1099
          // Merge this equality with the previous one.                                                            // 1100
          diffs[pointer - 1][1] += diffs[pointer][1];                                                              // 1101
          diffs.splice(pointer, 1);                                                                                // 1102
        } else {                                                                                                   // 1103
          pointer++;                                                                                               // 1104
        }                                                                                                          // 1105
        count_insert = 0;                                                                                          // 1106
        count_delete = 0;                                                                                          // 1107
        text_delete = '';                                                                                          // 1108
        text_insert = '';                                                                                          // 1109
        break;                                                                                                     // 1110
    }                                                                                                              // 1111
  }                                                                                                                // 1112
  if (diffs[diffs.length - 1][1] === '') {                                                                         // 1113
    diffs.pop();  // Remove the dummy entry at the end.                                                            // 1114
  }                                                                                                                // 1115
                                                                                                                   // 1116
  // Second pass: look for single edits surrounded on both sides by equalities                                     // 1117
  // which can be shifted sideways to eliminate an equality.                                                       // 1118
  // e.g: A<ins>BA</ins>C -> <ins>AB</ins>AC                                                                       // 1119
  var changes = false;                                                                                             // 1120
  pointer = 1;                                                                                                     // 1121
  // Intentionally ignore the first and last element (don't need checking).                                        // 1122
  while (pointer < diffs.length - 1) {                                                                             // 1123
    if (diffs[pointer - 1][0] == DIFF_EQUAL &&                                                                     // 1124
        diffs[pointer + 1][0] == DIFF_EQUAL) {                                                                     // 1125
      // This is a single edit surrounded by equalities.                                                           // 1126
      if (diffs[pointer][1].substring(diffs[pointer][1].length -                                                   // 1127
          diffs[pointer - 1][1].length) == diffs[pointer - 1][1]) {                                                // 1128
        // Shift the edit over the previous equality.                                                              // 1129
        diffs[pointer][1] = diffs[pointer - 1][1] +                                                                // 1130
            diffs[pointer][1].substring(0, diffs[pointer][1].length -                                              // 1131
                                        diffs[pointer - 1][1].length);                                             // 1132
        diffs[pointer + 1][1] = diffs[pointer - 1][1] + diffs[pointer + 1][1];                                     // 1133
        diffs.splice(pointer - 1, 1);                                                                              // 1134
        changes = true;                                                                                            // 1135
      } else if (diffs[pointer][1].substring(0, diffs[pointer + 1][1].length) ==                                   // 1136
          diffs[pointer + 1][1]) {                                                                                 // 1137
        // Shift the edit over the next equality.                                                                  // 1138
        diffs[pointer - 1][1] += diffs[pointer + 1][1];                                                            // 1139
        diffs[pointer][1] =                                                                                        // 1140
            diffs[pointer][1].substring(diffs[pointer + 1][1].length) +                                            // 1141
            diffs[pointer + 1][1];                                                                                 // 1142
        diffs.splice(pointer + 1, 1);                                                                              // 1143
        changes = true;                                                                                            // 1144
      }                                                                                                            // 1145
    }                                                                                                              // 1146
    pointer++;                                                                                                     // 1147
  }                                                                                                                // 1148
  // If shifts were made, the diff needs reordering and another shift sweep.                                       // 1149
  if (changes) {                                                                                                   // 1150
    this.diff_cleanupMerge(diffs);                                                                                 // 1151
  }                                                                                                                // 1152
};                                                                                                                 // 1153
                                                                                                                   // 1154
                                                                                                                   // 1155
/**                                                                                                                // 1156
 * loc is a location in text1, compute and return the equivalent location in                                       // 1157
 * text2.                                                                                                          // 1158
 * e.g. 'The cat' vs 'The big cat', 1->1, 5->8                                                                     // 1159
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 1160
 * @param {number} loc Location within text1.                                                                      // 1161
 * @return {number} Location within text2.                                                                         // 1162
 */                                                                                                                // 1163
diff_match_patch.prototype.diff_xIndex = function(diffs, loc) {                                                    // 1164
  var chars1 = 0;                                                                                                  // 1165
  var chars2 = 0;                                                                                                  // 1166
  var last_chars1 = 0;                                                                                             // 1167
  var last_chars2 = 0;                                                                                             // 1168
  var x;                                                                                                           // 1169
  for (x = 0; x < diffs.length; x++) {                                                                             // 1170
    if (diffs[x][0] !== DIFF_INSERT) {  // Equality or deletion.                                                   // 1171
      chars1 += diffs[x][1].length;                                                                                // 1172
    }                                                                                                              // 1173
    if (diffs[x][0] !== DIFF_DELETE) {  // Equality or insertion.                                                  // 1174
      chars2 += diffs[x][1].length;                                                                                // 1175
    }                                                                                                              // 1176
    if (chars1 > loc) {  // Overshot the location.                                                                 // 1177
      break;                                                                                                       // 1178
    }                                                                                                              // 1179
    last_chars1 = chars1;                                                                                          // 1180
    last_chars2 = chars2;                                                                                          // 1181
  }                                                                                                                // 1182
  // Was the location was deleted?                                                                                 // 1183
  if (diffs.length != x && diffs[x][0] === DIFF_DELETE) {                                                          // 1184
    return last_chars2;                                                                                            // 1185
  }                                                                                                                // 1186
  // Add the remaining character length.                                                                           // 1187
  return last_chars2 + (loc - last_chars1);                                                                        // 1188
};                                                                                                                 // 1189
                                                                                                                   // 1190
                                                                                                                   // 1191
/**                                                                                                                // 1192
 * Convert a diff array into a pretty HTML report.                                                                 // 1193
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 1194
 * @return {string} HTML representation.                                                                           // 1195
 */                                                                                                                // 1196
diff_match_patch.prototype.diff_prettyHtml = function(diffs) {                                                     // 1197
  var html = [];                                                                                                   // 1198
  var i = 0;                                                                                                       // 1199
  var pattern_amp = /&/g;                                                                                          // 1200
  var pattern_lt = /</g;                                                                                           // 1201
  var pattern_gt = />/g;                                                                                           // 1202
  var pattern_para = /\n/g;                                                                                        // 1203
  for (var x = 0; x < diffs.length; x++) {                                                                         // 1204
    var op = diffs[x][0];    // Operation (insert, delete, equal)                                                  // 1205
    var data = diffs[x][1];  // Text of change.                                                                    // 1206
    var text = data.replace(pattern_amp, '&amp;').replace(pattern_lt, '&lt;')                                      // 1207
        .replace(pattern_gt, '&gt;').replace(pattern_para, '&para;<br>');                                          // 1208
    switch (op) {                                                                                                  // 1209
      case DIFF_INSERT:                                                                                            // 1210
        html[x] = '<ins style="background:#e6ffe6;">' + text + '</ins>';                                           // 1211
        break;                                                                                                     // 1212
      case DIFF_DELETE:                                                                                            // 1213
        html[x] = '<del style="background:#ffe6e6;">' + text + '</del>';                                           // 1214
        break;                                                                                                     // 1215
      case DIFF_EQUAL:                                                                                             // 1216
        html[x] = '<span>' + text + '</span>';                                                                     // 1217
        break;                                                                                                     // 1218
    }                                                                                                              // 1219
    if (op !== DIFF_DELETE) {                                                                                      // 1220
      i += data.length;                                                                                            // 1221
    }                                                                                                              // 1222
  }                                                                                                                // 1223
  return html.join('');                                                                                            // 1224
};                                                                                                                 // 1225
                                                                                                                   // 1226
                                                                                                                   // 1227
/**                                                                                                                // 1228
 * Compute and return the source text (all equalities and deletions).                                              // 1229
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 1230
 * @return {string} Source text.                                                                                   // 1231
 */                                                                                                                // 1232
diff_match_patch.prototype.diff_text1 = function(diffs) {                                                          // 1233
  var text = [];                                                                                                   // 1234
  for (var x = 0; x < diffs.length; x++) {                                                                         // 1235
    if (diffs[x][0] !== DIFF_INSERT) {                                                                             // 1236
      text[x] = diffs[x][1];                                                                                       // 1237
    }                                                                                                              // 1238
  }                                                                                                                // 1239
  return text.join('');                                                                                            // 1240
};                                                                                                                 // 1241
                                                                                                                   // 1242
                                                                                                                   // 1243
/**                                                                                                                // 1244
 * Compute and return the destination text (all equalities and insertions).                                        // 1245
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 1246
 * @return {string} Destination text.                                                                              // 1247
 */                                                                                                                // 1248
diff_match_patch.prototype.diff_text2 = function(diffs) {                                                          // 1249
  var text = [];                                                                                                   // 1250
  for (var x = 0; x < diffs.length; x++) {                                                                         // 1251
    if (diffs[x][0] !== DIFF_DELETE) {                                                                             // 1252
      text[x] = diffs[x][1];                                                                                       // 1253
    }                                                                                                              // 1254
  }                                                                                                                // 1255
  return text.join('');                                                                                            // 1256
};                                                                                                                 // 1257
                                                                                                                   // 1258
                                                                                                                   // 1259
/**                                                                                                                // 1260
 * Compute the Levenshtein distance; the number of inserted, deleted or                                            // 1261
 * substituted characters.                                                                                         // 1262
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 1263
 * @return {number} Number of changes.                                                                             // 1264
 */                                                                                                                // 1265
diff_match_patch.prototype.diff_levenshtein = function(diffs) {                                                    // 1266
  var levenshtein = 0;                                                                                             // 1267
  var insertions = 0;                                                                                              // 1268
  var deletions = 0;                                                                                               // 1269
  for (var x = 0; x < diffs.length; x++) {                                                                         // 1270
    var op = diffs[x][0];                                                                                          // 1271
    var data = diffs[x][1];                                                                                        // 1272
    switch (op) {                                                                                                  // 1273
      case DIFF_INSERT:                                                                                            // 1274
        insertions += data.length;                                                                                 // 1275
        break;                                                                                                     // 1276
      case DIFF_DELETE:                                                                                            // 1277
        deletions += data.length;                                                                                  // 1278
        break;                                                                                                     // 1279
      case DIFF_EQUAL:                                                                                             // 1280
        // A deletion and an insertion is one substitution.                                                        // 1281
        levenshtein += Math.max(insertions, deletions);                                                            // 1282
        insertions = 0;                                                                                            // 1283
        deletions = 0;                                                                                             // 1284
        break;                                                                                                     // 1285
    }                                                                                                              // 1286
  }                                                                                                                // 1287
  levenshtein += Math.max(insertions, deletions);                                                                  // 1288
  return levenshtein;                                                                                              // 1289
};                                                                                                                 // 1290
                                                                                                                   // 1291
                                                                                                                   // 1292
/**                                                                                                                // 1293
 * Crush the diff into an encoded string which describes the operations                                            // 1294
 * required to transform text1 into text2.                                                                         // 1295
 * E.g. =3\t-2\t+ing  -> Keep 3 chars, delete 2 chars, insert 'ing'.                                               // 1296
 * Operations are tab-separated.  Inserted text is escaped using %xx notation.                                     // 1297
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.                                            // 1298
 * @return {string} Delta text.                                                                                    // 1299
 */                                                                                                                // 1300
diff_match_patch.prototype.diff_toDelta = function(diffs) {                                                        // 1301
  var text = [];                                                                                                   // 1302
  for (var x = 0; x < diffs.length; x++) {                                                                         // 1303
    switch (diffs[x][0]) {                                                                                         // 1304
      case DIFF_INSERT:                                                                                            // 1305
        text[x] = '+' + encodeURI(diffs[x][1]);                                                                    // 1306
        break;                                                                                                     // 1307
      case DIFF_DELETE:                                                                                            // 1308
        text[x] = '-' + diffs[x][1].length;                                                                        // 1309
        break;                                                                                                     // 1310
      case DIFF_EQUAL:                                                                                             // 1311
        text[x] = '=' + diffs[x][1].length;                                                                        // 1312
        break;                                                                                                     // 1313
    }                                                                                                              // 1314
  }                                                                                                                // 1315
  return text.join('\t').replace(/%20/g, ' ');                                                                     // 1316
};                                                                                                                 // 1317
                                                                                                                   // 1318
                                                                                                                   // 1319
/**                                                                                                                // 1320
 * Given the original text1, and an encoded string which describes the                                             // 1321
 * operations required to transform text1 into text2, compute the full diff.                                       // 1322
 * @param {string} text1 Source string for the diff.                                                               // 1323
 * @param {string} delta Delta text.                                                                               // 1324
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.                                                 // 1325
 * @throws {!Error} If invalid input.                                                                              // 1326
 */                                                                                                                // 1327
diff_match_patch.prototype.diff_fromDelta = function(text1, delta) {                                               // 1328
  var diffs = [];                                                                                                  // 1329
  var diffsLength = 0;  // Keeping our own length var is faster in JS.                                             // 1330
  var pointer = 0;  // Cursor in text1                                                                             // 1331
  var tokens = delta.split(/\t/g);                                                                                 // 1332
  for (var x = 0; x < tokens.length; x++) {                                                                        // 1333
    // Each token begins with a one character parameter which specifies the                                        // 1334
    // operation of this token (delete, insert, equality).                                                         // 1335
    var param = tokens[x].substring(1);                                                                            // 1336
    switch (tokens[x].charAt(0)) {                                                                                 // 1337
      case '+':                                                                                                    // 1338
        try {                                                                                                      // 1339
          diffs[diffsLength++] = [DIFF_INSERT, decodeURI(param)];                                                  // 1340
        } catch (ex) {                                                                                             // 1341
          // Malformed URI sequence.                                                                               // 1342
          throw new Error('Illegal escape in diff_fromDelta: ' + param);                                           // 1343
        }                                                                                                          // 1344
        break;                                                                                                     // 1345
      case '-':                                                                                                    // 1346
        // Fall through.                                                                                           // 1347
      case '=':                                                                                                    // 1348
        var n = parseInt(param, 10);                                                                               // 1349
        if (isNaN(n) || n < 0) {                                                                                   // 1350
          throw new Error('Invalid number in diff_fromDelta: ' + param);                                           // 1351
        }                                                                                                          // 1352
        var text = text1.substring(pointer, pointer += n);                                                         // 1353
        if (tokens[x].charAt(0) == '=') {                                                                          // 1354
          diffs[diffsLength++] = [DIFF_EQUAL, text];                                                               // 1355
        } else {                                                                                                   // 1356
          diffs[diffsLength++] = [DIFF_DELETE, text];                                                              // 1357
        }                                                                                                          // 1358
        break;                                                                                                     // 1359
      default:                                                                                                     // 1360
        // Blank tokens are ok (from a trailing \t).                                                               // 1361
        // Anything else is an error.                                                                              // 1362
        if (tokens[x]) {                                                                                           // 1363
          throw new Error('Invalid diff operation in diff_fromDelta: ' +                                           // 1364
                          tokens[x]);                                                                              // 1365
        }                                                                                                          // 1366
    }                                                                                                              // 1367
  }                                                                                                                // 1368
  if (pointer != text1.length) {                                                                                   // 1369
    throw new Error('Delta length (' + pointer +                                                                   // 1370
        ') does not equal source text length (' + text1.length + ').');                                            // 1371
  }                                                                                                                // 1372
  return diffs;                                                                                                    // 1373
};                                                                                                                 // 1374
                                                                                                                   // 1375
                                                                                                                   // 1376
//  MATCH FUNCTIONS                                                                                                // 1377
                                                                                                                   // 1378
                                                                                                                   // 1379
/**                                                                                                                // 1380
 * Locate the best instance of 'pattern' in 'text' near 'loc'.                                                     // 1381
 * @param {string} text The text to search.                                                                        // 1382
 * @param {string} pattern The pattern to search for.                                                              // 1383
 * @param {number} loc The location to search around.                                                              // 1384
 * @return {number} Best match index or -1.                                                                        // 1385
 */                                                                                                                // 1386
diff_match_patch.prototype.match_main = function(text, pattern, loc) {                                             // 1387
  // Check for null inputs.                                                                                        // 1388
  if (text == null || pattern == null || loc == null) {                                                            // 1389
    throw new Error('Null input. (match_main)');                                                                   // 1390
  }                                                                                                                // 1391
                                                                                                                   // 1392
  loc = Math.max(0, Math.min(loc, text.length));                                                                   // 1393
  if (text == pattern) {                                                                                           // 1394
    // Shortcut (potentially not guaranteed by the algorithm)                                                      // 1395
    return 0;                                                                                                      // 1396
  } else if (!text.length) {                                                                                       // 1397
    // Nothing to match.                                                                                           // 1398
    return -1;                                                                                                     // 1399
  } else if (text.substring(loc, loc + pattern.length) == pattern) {                                               // 1400
    // Perfect match at the perfect spot!  (Includes case of null pattern)                                         // 1401
    return loc;                                                                                                    // 1402
  } else {                                                                                                         // 1403
    // Do a fuzzy compare.                                                                                         // 1404
    return this.match_bitap_(text, pattern, loc);                                                                  // 1405
  }                                                                                                                // 1406
};                                                                                                                 // 1407
                                                                                                                   // 1408
                                                                                                                   // 1409
/**                                                                                                                // 1410
 * Locate the best instance of 'pattern' in 'text' near 'loc' using the                                            // 1411
 * Bitap algorithm.                                                                                                // 1412
 * @param {string} text The text to search.                                                                        // 1413
 * @param {string} pattern The pattern to search for.                                                              // 1414
 * @param {number} loc The location to search around.                                                              // 1415
 * @return {number} Best match index or -1.                                                                        // 1416
 * @private                                                                                                        // 1417
 */                                                                                                                // 1418
diff_match_patch.prototype.match_bitap_ = function(text, pattern, loc) {                                           // 1419
  if (pattern.length > this.Match_MaxBits) {                                                                       // 1420
    throw new Error('Pattern too long for this browser.');                                                         // 1421
  }                                                                                                                // 1422
                                                                                                                   // 1423
  // Initialise the alphabet.                                                                                      // 1424
  var s = this.match_alphabet_(pattern);                                                                           // 1425
                                                                                                                   // 1426
  var dmp = this;  // 'this' becomes 'window' in a closure.                                                        // 1427
                                                                                                                   // 1428
  /**                                                                                                              // 1429
   * Compute and return the score for a match with e errors and x location.                                        // 1430
   * Accesses loc and pattern through being a closure.                                                             // 1431
   * @param {number} e Number of errors in match.                                                                  // 1432
   * @param {number} x Location of match.                                                                          // 1433
   * @return {number} Overall score for match (0.0 = good, 1.0 = bad).                                             // 1434
   * @private                                                                                                      // 1435
   */                                                                                                              // 1436
  function match_bitapScore_(e, x) {                                                                               // 1437
    var accuracy = e / pattern.length;                                                                             // 1438
    var proximity = Math.abs(loc - x);                                                                             // 1439
    if (!dmp.Match_Distance) {                                                                                     // 1440
      // Dodge divide by zero error.                                                                               // 1441
      return proximity ? 1.0 : accuracy;                                                                           // 1442
    }                                                                                                              // 1443
    return accuracy + (proximity / dmp.Match_Distance);                                                            // 1444
  }                                                                                                                // 1445
                                                                                                                   // 1446
  // Highest score beyond which we give up.                                                                        // 1447
  var score_threshold = this.Match_Threshold;                                                                      // 1448
  // Is there a nearby exact match? (speedup)                                                                      // 1449
  var best_loc = text.indexOf(pattern, loc);                                                                       // 1450
  if (best_loc != -1) {                                                                                            // 1451
    score_threshold = Math.min(match_bitapScore_(0, best_loc), score_threshold);                                   // 1452
    // What about in the other direction? (speedup)                                                                // 1453
    best_loc = text.lastIndexOf(pattern, loc + pattern.length);                                                    // 1454
    if (best_loc != -1) {                                                                                          // 1455
      score_threshold =                                                                                            // 1456
          Math.min(match_bitapScore_(0, best_loc), score_threshold);                                               // 1457
    }                                                                                                              // 1458
  }                                                                                                                // 1459
                                                                                                                   // 1460
  // Initialise the bit arrays.                                                                                    // 1461
  var matchmask = 1 << (pattern.length - 1);                                                                       // 1462
  best_loc = -1;                                                                                                   // 1463
                                                                                                                   // 1464
  var bin_min, bin_mid;                                                                                            // 1465
  var bin_max = pattern.length + text.length;                                                                      // 1466
  var last_rd;                                                                                                     // 1467
  for (var d = 0; d < pattern.length; d++) {                                                                       // 1468
    // Scan for the best match; each iteration allows for one more error.                                          // 1469
    // Run a binary search to determine how far from 'loc' we can stray at this                                    // 1470
    // error level.                                                                                                // 1471
    bin_min = 0;                                                                                                   // 1472
    bin_mid = bin_max;                                                                                             // 1473
    while (bin_min < bin_mid) {                                                                                    // 1474
      if (match_bitapScore_(d, loc + bin_mid) <= score_threshold) {                                                // 1475
        bin_min = bin_mid;                                                                                         // 1476
      } else {                                                                                                     // 1477
        bin_max = bin_mid;                                                                                         // 1478
      }                                                                                                            // 1479
      bin_mid = Math.floor((bin_max - bin_min) / 2 + bin_min);                                                     // 1480
    }                                                                                                              // 1481
    // Use the result from this iteration as the maximum for the next.                                             // 1482
    bin_max = bin_mid;                                                                                             // 1483
    var start = Math.max(1, loc - bin_mid + 1);                                                                    // 1484
    var finish = Math.min(loc + bin_mid, text.length) + pattern.length;                                            // 1485
                                                                                                                   // 1486
    var rd = Array(finish + 2);                                                                                    // 1487
    rd[finish + 1] = (1 << d) - 1;                                                                                 // 1488
    for (var j = finish; j >= start; j--) {                                                                        // 1489
      // The alphabet (s) is a sparse hash, so the following line generates                                        // 1490
      // warnings.                                                                                                 // 1491
      var charMatch = s[text.charAt(j - 1)];                                                                       // 1492
      if (d === 0) {  // First pass: exact match.                                                                  // 1493
        rd[j] = ((rd[j + 1] << 1) | 1) & charMatch;                                                                // 1494
      } else {  // Subsequent passes: fuzzy match.                                                                 // 1495
        rd[j] = ((rd[j + 1] << 1) | 1) & charMatch |                                                               // 1496
                (((last_rd[j + 1] | last_rd[j]) << 1) | 1) |                                                       // 1497
                last_rd[j + 1];                                                                                    // 1498
      }                                                                                                            // 1499
      if (rd[j] & matchmask) {                                                                                     // 1500
        var score = match_bitapScore_(d, j - 1);                                                                   // 1501
        // This match will almost certainly be better than any existing match.                                     // 1502
        // But check anyway.                                                                                       // 1503
        if (score <= score_threshold) {                                                                            // 1504
          // Told you so.                                                                                          // 1505
          score_threshold = score;                                                                                 // 1506
          best_loc = j - 1;                                                                                        // 1507
          if (best_loc > loc) {                                                                                    // 1508
            // When passing loc, don't exceed our current distance from loc.                                       // 1509
            start = Math.max(1, 2 * loc - best_loc);                                                               // 1510
          } else {                                                                                                 // 1511
            // Already passed loc, downhill from here on in.                                                       // 1512
            break;                                                                                                 // 1513
          }                                                                                                        // 1514
        }                                                                                                          // 1515
      }                                                                                                            // 1516
    }                                                                                                              // 1517
    // No hope for a (better) match at greater error levels.                                                       // 1518
    if (match_bitapScore_(d + 1, loc) > score_threshold) {                                                         // 1519
      break;                                                                                                       // 1520
    }                                                                                                              // 1521
    last_rd = rd;                                                                                                  // 1522
  }                                                                                                                // 1523
  return best_loc;                                                                                                 // 1524
};                                                                                                                 // 1525
                                                                                                                   // 1526
                                                                                                                   // 1527
/**                                                                                                                // 1528
 * Initialise the alphabet for the Bitap algorithm.                                                                // 1529
 * @param {string} pattern The text to encode.                                                                     // 1530
 * @return {!Object} Hash of character locations.                                                                  // 1531
 * @private                                                                                                        // 1532
 */                                                                                                                // 1533
diff_match_patch.prototype.match_alphabet_ = function(pattern) {                                                   // 1534
  var s = {};                                                                                                      // 1535
  for (var i = 0; i < pattern.length; i++) {                                                                       // 1536
    s[pattern.charAt(i)] = 0;                                                                                      // 1537
  }                                                                                                                // 1538
  for (var i = 0; i < pattern.length; i++) {                                                                       // 1539
    s[pattern.charAt(i)] |= 1 << (pattern.length - i - 1);                                                         // 1540
  }                                                                                                                // 1541
  return s;                                                                                                        // 1542
};                                                                                                                 // 1543
                                                                                                                   // 1544
                                                                                                                   // 1545
//  PATCH FUNCTIONS                                                                                                // 1546
                                                                                                                   // 1547
                                                                                                                   // 1548
/**                                                                                                                // 1549
 * Increase the context until it is unique,                                                                        // 1550
 * but don't let the pattern expand beyond Match_MaxBits.                                                          // 1551
 * @param {!diff_match_patch.patch_obj} patch The patch to grow.                                                   // 1552
 * @param {string} text Source text.                                                                               // 1553
 * @private                                                                                                        // 1554
 */                                                                                                                // 1555
diff_match_patch.prototype.patch_addContext_ = function(patch, text) {                                             // 1556
  if (text.length == 0) {                                                                                          // 1557
    return;                                                                                                        // 1558
  }                                                                                                                // 1559
  var pattern = text.substring(patch.start2, patch.start2 + patch.length1);                                        // 1560
  var padding = 0;                                                                                                 // 1561
                                                                                                                   // 1562
  // Look for the first and last matches of pattern in text.  If two different                                     // 1563
  // matches are found, increase the pattern length.                                                               // 1564
  while (text.indexOf(pattern) != text.lastIndexOf(pattern) &&                                                     // 1565
         pattern.length < this.Match_MaxBits - this.Patch_Margin -                                                 // 1566
         this.Patch_Margin) {                                                                                      // 1567
    padding += this.Patch_Margin;                                                                                  // 1568
    pattern = text.substring(patch.start2 - padding,                                                               // 1569
                             patch.start2 + patch.length1 + padding);                                              // 1570
  }                                                                                                                // 1571
  // Add one chunk for good luck.                                                                                  // 1572
  padding += this.Patch_Margin;                                                                                    // 1573
                                                                                                                   // 1574
  // Add the prefix.                                                                                               // 1575
  var prefix = text.substring(patch.start2 - padding, patch.start2);                                               // 1576
  if (prefix) {                                                                                                    // 1577
    patch.diffs.unshift([DIFF_EQUAL, prefix]);                                                                     // 1578
  }                                                                                                                // 1579
  // Add the suffix.                                                                                               // 1580
  var suffix = text.substring(patch.start2 + patch.length1,                                                        // 1581
                              patch.start2 + patch.length1 + padding);                                             // 1582
  if (suffix) {                                                                                                    // 1583
    patch.diffs.push([DIFF_EQUAL, suffix]);                                                                        // 1584
  }                                                                                                                // 1585
                                                                                                                   // 1586
  // Roll back the start points.                                                                                   // 1587
  patch.start1 -= prefix.length;                                                                                   // 1588
  patch.start2 -= prefix.length;                                                                                   // 1589
  // Extend the lengths.                                                                                           // 1590
  patch.length1 += prefix.length + suffix.length;                                                                  // 1591
  patch.length2 += prefix.length + suffix.length;                                                                  // 1592
};                                                                                                                 // 1593
                                                                                                                   // 1594
                                                                                                                   // 1595
/**                                                                                                                // 1596
 * Compute a list of patches to turn text1 into text2.                                                             // 1597
 * Use diffs if provided, otherwise compute it ourselves.                                                          // 1598
 * There are four ways to call this function, depending on what data is                                            // 1599
 * available to the caller:                                                                                        // 1600
 * Method 1:                                                                                                       // 1601
 * a = text1, b = text2                                                                                            // 1602
 * Method 2:                                                                                                       // 1603
 * a = diffs                                                                                                       // 1604
 * Method 3 (optimal):                                                                                             // 1605
 * a = text1, b = diffs                                                                                            // 1606
 * Method 4 (deprecated, use method 3):                                                                            // 1607
 * a = text1, b = text2, c = diffs                                                                                 // 1608
 *                                                                                                                 // 1609
 * @param {string|!Array.<!diff_match_patch.Diff>} a text1 (methods 1,3,4) or                                      // 1610
 * Array of diff tuples for text1 to text2 (method 2).                                                             // 1611
 * @param {string|!Array.<!diff_match_patch.Diff>} opt_b text2 (methods 1,4) or                                    // 1612
 * Array of diff tuples for text1 to text2 (method 3) or undefined (method 2).                                     // 1613
 * @param {string|!Array.<!diff_match_patch.Diff>} opt_c Array of diff tuples                                      // 1614
 * for text1 to text2 (method 4) or undefined (methods 1,2,3).                                                     // 1615
 * @return {!Array.<!diff_match_patch.patch_obj>} Array of patch objects.                                          // 1616
 */                                                                                                                // 1617
diff_match_patch.prototype.patch_make = function(a, opt_b, opt_c) {                                                // 1618
  var text1, diffs;                                                                                                // 1619
  if (typeof a == 'string' && typeof opt_b == 'string' &&                                                          // 1620
      typeof opt_c == 'undefined') {                                                                               // 1621
    // Method 1: text1, text2                                                                                      // 1622
    // Compute diffs from text1 and text2.                                                                         // 1623
    text1 = /** @type {string} */(a);                                                                              // 1624
    diffs = this.diff_main(text1, /** @type {string} */(opt_b), true);                                             // 1625
    if (diffs.length > 2) {                                                                                        // 1626
      this.diff_cleanupSemantic(diffs);                                                                            // 1627
      this.diff_cleanupEfficiency(diffs);                                                                          // 1628
    }                                                                                                              // 1629
  } else if (a && typeof a == 'object' && typeof opt_b == 'undefined' &&                                           // 1630
      typeof opt_c == 'undefined') {                                                                               // 1631
    // Method 2: diffs                                                                                             // 1632
    // Compute text1 from diffs.                                                                                   // 1633
    diffs = /** @type {!Array.<!diff_match_patch.Diff>} */(a);                                                     // 1634
    text1 = this.diff_text1(diffs);                                                                                // 1635
  } else if (typeof a == 'string' && opt_b && typeof opt_b == 'object' &&                                          // 1636
      typeof opt_c == 'undefined') {                                                                               // 1637
    // Method 3: text1, diffs                                                                                      // 1638
    text1 = /** @type {string} */(a);                                                                              // 1639
    diffs = /** @type {!Array.<!diff_match_patch.Diff>} */(opt_b);                                                 // 1640
  } else if (typeof a == 'string' && typeof opt_b == 'string' &&                                                   // 1641
      opt_c && typeof opt_c == 'object') {                                                                         // 1642
    // Method 4: text1, text2, diffs                                                                               // 1643
    // text2 is not used.                                                                                          // 1644
    text1 = /** @type {string} */(a);                                                                              // 1645
    diffs = /** @type {!Array.<!diff_match_patch.Diff>} */(opt_c);                                                 // 1646
  } else {                                                                                                         // 1647
    throw new Error('Unknown call format to patch_make.');                                                         // 1648
  }                                                                                                                // 1649
                                                                                                                   // 1650
  if (diffs.length === 0) {                                                                                        // 1651
    return [];  // Get rid of the null case.                                                                       // 1652
  }                                                                                                                // 1653
  var patches = [];                                                                                                // 1654
  var patch = new diff_match_patch.patch_obj();                                                                    // 1655
  var patchDiffLength = 0;  // Keeping our own length var is faster in JS.                                         // 1656
  var char_count1 = 0;  // Number of characters into the text1 string.                                             // 1657
  var char_count2 = 0;  // Number of characters into the text2 string.                                             // 1658
  // Start with text1 (prepatch_text) and apply the diffs until we arrive at                                       // 1659
  // text2 (postpatch_text).  We recreate the patches one by one to determine                                      // 1660
  // context info.                                                                                                 // 1661
  var prepatch_text = text1;                                                                                       // 1662
  var postpatch_text = text1;                                                                                      // 1663
  for (var x = 0; x < diffs.length; x++) {                                                                         // 1664
    var diff_type = diffs[x][0];                                                                                   // 1665
    var diff_text = diffs[x][1];                                                                                   // 1666
                                                                                                                   // 1667
    if (!patchDiffLength && diff_type !== DIFF_EQUAL) {                                                            // 1668
      // A new patch starts here.                                                                                  // 1669
      patch.start1 = char_count1;                                                                                  // 1670
      patch.start2 = char_count2;                                                                                  // 1671
    }                                                                                                              // 1672
                                                                                                                   // 1673
    switch (diff_type) {                                                                                           // 1674
      case DIFF_INSERT:                                                                                            // 1675
        patch.diffs[patchDiffLength++] = diffs[x];                                                                 // 1676
        patch.length2 += diff_text.length;                                                                         // 1677
        postpatch_text = postpatch_text.substring(0, char_count2) + diff_text +                                    // 1678
                         postpatch_text.substring(char_count2);                                                    // 1679
        break;                                                                                                     // 1680
      case DIFF_DELETE:                                                                                            // 1681
        patch.length1 += diff_text.length;                                                                         // 1682
        patch.diffs[patchDiffLength++] = diffs[x];                                                                 // 1683
        postpatch_text = postpatch_text.substring(0, char_count2) +                                                // 1684
                         postpatch_text.substring(char_count2 +                                                    // 1685
                             diff_text.length);                                                                    // 1686
        break;                                                                                                     // 1687
      case DIFF_EQUAL:                                                                                             // 1688
        if (diff_text.length <= 2 * this.Patch_Margin &&                                                           // 1689
            patchDiffLength && diffs.length != x + 1) {                                                            // 1690
          // Small equality inside a patch.                                                                        // 1691
          patch.diffs[patchDiffLength++] = diffs[x];                                                               // 1692
          patch.length1 += diff_text.length;                                                                       // 1693
          patch.length2 += diff_text.length;                                                                       // 1694
        } else if (diff_text.length >= 2 * this.Patch_Margin) {                                                    // 1695
          // Time for a new patch.                                                                                 // 1696
          if (patchDiffLength) {                                                                                   // 1697
            this.patch_addContext_(patch, prepatch_text);                                                          // 1698
            patches.push(patch);                                                                                   // 1699
            patch = new diff_match_patch.patch_obj();                                                              // 1700
            patchDiffLength = 0;                                                                                   // 1701
            // Unlike Unidiff, our patch lists have a rolling context.                                             // 1702
            // http://code.google.com/p/google-diff-match-patch/wiki/Unidiff                                       // 1703
            // Update prepatch text & pos to reflect the application of the                                        // 1704
            // just completed patch.                                                                               // 1705
            prepatch_text = postpatch_text;                                                                        // 1706
            char_count1 = char_count2;                                                                             // 1707
          }                                                                                                        // 1708
        }                                                                                                          // 1709
        break;                                                                                                     // 1710
    }                                                                                                              // 1711
                                                                                                                   // 1712
    // Update the current character count.                                                                         // 1713
    if (diff_type !== DIFF_INSERT) {                                                                               // 1714
      char_count1 += diff_text.length;                                                                             // 1715
    }                                                                                                              // 1716
    if (diff_type !== DIFF_DELETE) {                                                                               // 1717
      char_count2 += diff_text.length;                                                                             // 1718
    }                                                                                                              // 1719
  }                                                                                                                // 1720
  // Pick up the leftover patch if not empty.                                                                      // 1721
  if (patchDiffLength) {                                                                                           // 1722
    this.patch_addContext_(patch, prepatch_text);                                                                  // 1723
    patches.push(patch);                                                                                           // 1724
  }                                                                                                                // 1725
                                                                                                                   // 1726
  return patches;                                                                                                  // 1727
};                                                                                                                 // 1728
                                                                                                                   // 1729
                                                                                                                   // 1730
/**                                                                                                                // 1731
 * Given an array of patches, return another array that is identical.                                              // 1732
 * @param {!Array.<!diff_match_patch.patch_obj>} patches Array of patch objects.                                   // 1733
 * @return {!Array.<!diff_match_patch.patch_obj>} Array of patch objects.                                          // 1734
 */                                                                                                                // 1735
diff_match_patch.prototype.patch_deepCopy = function(patches) {                                                    // 1736
  // Making deep copies is hard in JavaScript.                                                                     // 1737
  var patchesCopy = [];                                                                                            // 1738
  for (var x = 0; x < patches.length; x++) {                                                                       // 1739
    var patch = patches[x];                                                                                        // 1740
    var patchCopy = new diff_match_patch.patch_obj();                                                              // 1741
    patchCopy.diffs = [];                                                                                          // 1742
    for (var y = 0; y < patch.diffs.length; y++) {                                                                 // 1743
      patchCopy.diffs[y] = patch.diffs[y].slice();                                                                 // 1744
    }                                                                                                              // 1745
    patchCopy.start1 = patch.start1;                                                                               // 1746
    patchCopy.start2 = patch.start2;                                                                               // 1747
    patchCopy.length1 = patch.length1;                                                                             // 1748
    patchCopy.length2 = patch.length2;                                                                             // 1749
    patchesCopy[x] = patchCopy;                                                                                    // 1750
  }                                                                                                                // 1751
  return patchesCopy;                                                                                              // 1752
};                                                                                                                 // 1753
                                                                                                                   // 1754
                                                                                                                   // 1755
/**                                                                                                                // 1756
 * Merge a set of patches onto the text.  Return a patched text, as well                                           // 1757
 * as a list of true/false values indicating which patches were applied.                                           // 1758
 * @param {!Array.<!diff_match_patch.patch_obj>} patches Array of patch objects.                                   // 1759
 * @param {string} text Old text.                                                                                  // 1760
 * @return {!Array.<string|!Array.<boolean>>} Two element Array, containing the                                    // 1761
 *      new text and an array of boolean values.                                                                   // 1762
 */                                                                                                                // 1763
diff_match_patch.prototype.patch_apply = function(patches, text) {                                                 // 1764
  if (patches.length == 0) {                                                                                       // 1765
    return [text, []];                                                                                             // 1766
  }                                                                                                                // 1767
                                                                                                                   // 1768
  // Deep copy the patches so that no changes are made to originals.                                               // 1769
  patches = this.patch_deepCopy(patches);                                                                          // 1770
                                                                                                                   // 1771
  var nullPadding = this.patch_addPadding(patches);                                                                // 1772
  text = nullPadding + text + nullPadding;                                                                         // 1773
                                                                                                                   // 1774
  this.patch_splitMax(patches);                                                                                    // 1775
  // delta keeps track of the offset between the expected and actual location                                      // 1776
  // of the previous patch.  If there are patches expected at positions 10 and                                     // 1777
  // 20, but the first patch was found at 12, delta is 2 and the second patch                                      // 1778
  // has an effective expected position of 22.                                                                     // 1779
  var delta = 0;                                                                                                   // 1780
  var results = [];                                                                                                // 1781
  for (var x = 0; x < patches.length; x++) {                                                                       // 1782
    var expected_loc = patches[x].start2 + delta;                                                                  // 1783
    var text1 = this.diff_text1(patches[x].diffs);                                                                 // 1784
    var start_loc;                                                                                                 // 1785
    var end_loc = -1;                                                                                              // 1786
    if (text1.length > this.Match_MaxBits) {                                                                       // 1787
      // patch_splitMax will only provide an oversized pattern in the case of                                      // 1788
      // a monster delete.                                                                                         // 1789
      start_loc = this.match_main(text, text1.substring(0, this.Match_MaxBits),                                    // 1790
                                  expected_loc);                                                                   // 1791
      if (start_loc != -1) {                                                                                       // 1792
        end_loc = this.match_main(text,                                                                            // 1793
            text1.substring(text1.length - this.Match_MaxBits),                                                    // 1794
            expected_loc + text1.length - this.Match_MaxBits);                                                     // 1795
        if (end_loc == -1 || start_loc >= end_loc) {                                                               // 1796
          // Can't find valid trailing context.  Drop this patch.                                                  // 1797
          start_loc = -1;                                                                                          // 1798
        }                                                                                                          // 1799
      }                                                                                                            // 1800
    } else {                                                                                                       // 1801
      start_loc = this.match_main(text, text1, expected_loc);                                                      // 1802
    }                                                                                                              // 1803
    if (start_loc == -1) {                                                                                         // 1804
      // No match found.  :(                                                                                       // 1805
      results[x] = false;                                                                                          // 1806
      // Subtract the delta for this failed patch from subsequent patches.                                         // 1807
      delta -= patches[x].length2 - patches[x].length1;                                                            // 1808
    } else {                                                                                                       // 1809
      // Found a match.  :)                                                                                        // 1810
      results[x] = true;                                                                                           // 1811
      delta = start_loc - expected_loc;                                                                            // 1812
      var text2;                                                                                                   // 1813
      if (end_loc == -1) {                                                                                         // 1814
        text2 = text.substring(start_loc, start_loc + text1.length);                                               // 1815
      } else {                                                                                                     // 1816
        text2 = text.substring(start_loc, end_loc + this.Match_MaxBits);                                           // 1817
      }                                                                                                            // 1818
      if (text1 == text2) {                                                                                        // 1819
        // Perfect match, just shove the replacement text in.                                                      // 1820
        text = text.substring(0, start_loc) +                                                                      // 1821
               this.diff_text2(patches[x].diffs) +                                                                 // 1822
               text.substring(start_loc + text1.length);                                                           // 1823
      } else {                                                                                                     // 1824
        // Imperfect match.  Run a diff to get a framework of equivalent                                           // 1825
        // indices.                                                                                                // 1826
        var diffs = this.diff_main(text1, text2, false);                                                           // 1827
        if (text1.length > this.Match_MaxBits &&                                                                   // 1828
            this.diff_levenshtein(diffs) / text1.length >                                                          // 1829
            this.Patch_DeleteThreshold) {                                                                          // 1830
          // The end points match, but the content is unacceptably bad.                                            // 1831
          results[x] = false;                                                                                      // 1832
        } else {                                                                                                   // 1833
          this.diff_cleanupSemanticLossless(diffs);                                                                // 1834
          var index1 = 0;                                                                                          // 1835
          var index2;                                                                                              // 1836
          for (var y = 0; y < patches[x].diffs.length; y++) {                                                      // 1837
            var mod = patches[x].diffs[y];                                                                         // 1838
            if (mod[0] !== DIFF_EQUAL) {                                                                           // 1839
              index2 = this.diff_xIndex(diffs, index1);                                                            // 1840
            }                                                                                                      // 1841
            if (mod[0] === DIFF_INSERT) {  // Insertion                                                            // 1842
              text = text.substring(0, start_loc + index2) + mod[1] +                                              // 1843
                     text.substring(start_loc + index2);                                                           // 1844
            } else if (mod[0] === DIFF_DELETE) {  // Deletion                                                      // 1845
              text = text.substring(0, start_loc + index2) +                                                       // 1846
                     text.substring(start_loc + this.diff_xIndex(diffs,                                            // 1847
                         index1 + mod[1].length));                                                                 // 1848
            }                                                                                                      // 1849
            if (mod[0] !== DIFF_DELETE) {                                                                          // 1850
              index1 += mod[1].length;                                                                             // 1851
            }                                                                                                      // 1852
          }                                                                                                        // 1853
        }                                                                                                          // 1854
      }                                                                                                            // 1855
    }                                                                                                              // 1856
  }                                                                                                                // 1857
  // Strip the padding off.                                                                                        // 1858
  text = text.substring(nullPadding.length, text.length - nullPadding.length);                                     // 1859
  return [text, results];                                                                                          // 1860
};                                                                                                                 // 1861
                                                                                                                   // 1862
                                                                                                                   // 1863
/**                                                                                                                // 1864
 * Add some padding on text start and end so that edges can match something.                                       // 1865
 * Intended to be called only from within patch_apply.                                                             // 1866
 * @param {!Array.<!diff_match_patch.patch_obj>} patches Array of patch objects.                                   // 1867
 * @return {string} The padding string added to each side.                                                         // 1868
 */                                                                                                                // 1869
diff_match_patch.prototype.patch_addPadding = function(patches) {                                                  // 1870
  var paddingLength = this.Patch_Margin;                                                                           // 1871
  var nullPadding = '';                                                                                            // 1872
  for (var x = 1; x <= paddingLength; x++) {                                                                       // 1873
    nullPadding += String.fromCharCode(x);                                                                         // 1874
  }                                                                                                                // 1875
                                                                                                                   // 1876
  // Bump all the patches forward.                                                                                 // 1877
  for (var x = 0; x < patches.length; x++) {                                                                       // 1878
    patches[x].start1 += paddingLength;                                                                            // 1879
    patches[x].start2 += paddingLength;                                                                            // 1880
  }                                                                                                                // 1881
                                                                                                                   // 1882
  // Add some padding on start of first diff.                                                                      // 1883
  var patch = patches[0];                                                                                          // 1884
  var diffs = patch.diffs;                                                                                         // 1885
  if (diffs.length == 0 || diffs[0][0] != DIFF_EQUAL) {                                                            // 1886
    // Add nullPadding equality.                                                                                   // 1887
    diffs.unshift([DIFF_EQUAL, nullPadding]);                                                                      // 1888
    patch.start1 -= paddingLength;  // Should be 0.                                                                // 1889
    patch.start2 -= paddingLength;  // Should be 0.                                                                // 1890
    patch.length1 += paddingLength;                                                                                // 1891
    patch.length2 += paddingLength;                                                                                // 1892
  } else if (paddingLength > diffs[0][1].length) {                                                                 // 1893
    // Grow first equality.                                                                                        // 1894
    var extraLength = paddingLength - diffs[0][1].length;                                                          // 1895
    diffs[0][1] = nullPadding.substring(diffs[0][1].length) + diffs[0][1];                                         // 1896
    patch.start1 -= extraLength;                                                                                   // 1897
    patch.start2 -= extraLength;                                                                                   // 1898
    patch.length1 += extraLength;                                                                                  // 1899
    patch.length2 += extraLength;                                                                                  // 1900
  }                                                                                                                // 1901
                                                                                                                   // 1902
  // Add some padding on end of last diff.                                                                         // 1903
  patch = patches[patches.length - 1];                                                                             // 1904
  diffs = patch.diffs;                                                                                             // 1905
  if (diffs.length == 0 || diffs[diffs.length - 1][0] != DIFF_EQUAL) {                                             // 1906
    // Add nullPadding equality.                                                                                   // 1907
    diffs.push([DIFF_EQUAL, nullPadding]);                                                                         // 1908
    patch.length1 += paddingLength;                                                                                // 1909
    patch.length2 += paddingLength;                                                                                // 1910
  } else if (paddingLength > diffs[diffs.length - 1][1].length) {                                                  // 1911
    // Grow last equality.                                                                                         // 1912
    var extraLength = paddingLength - diffs[diffs.length - 1][1].length;                                           // 1913
    diffs[diffs.length - 1][1] += nullPadding.substring(0, extraLength);                                           // 1914
    patch.length1 += extraLength;                                                                                  // 1915
    patch.length2 += extraLength;                                                                                  // 1916
  }                                                                                                                // 1917
                                                                                                                   // 1918
  return nullPadding;                                                                                              // 1919
};                                                                                                                 // 1920
                                                                                                                   // 1921
                                                                                                                   // 1922
/**                                                                                                                // 1923
 * Look through the patches and break up any which are longer than the maximum                                     // 1924
 * limit of the match algorithm.                                                                                   // 1925
 * Intended to be called only from within patch_apply.                                                             // 1926
 * @param {!Array.<!diff_match_patch.patch_obj>} patches Array of patch objects.                                   // 1927
 */                                                                                                                // 1928
diff_match_patch.prototype.patch_splitMax = function(patches) {                                                    // 1929
  var patch_size = this.Match_MaxBits;                                                                             // 1930
  for (var x = 0; x < patches.length; x++) {                                                                       // 1931
    if (patches[x].length1 > patch_size) {                                                                         // 1932
      var bigpatch = patches[x];                                                                                   // 1933
      // Remove the big old patch.                                                                                 // 1934
      patches.splice(x--, 1);                                                                                      // 1935
      var start1 = bigpatch.start1;                                                                                // 1936
      var start2 = bigpatch.start2;                                                                                // 1937
      var precontext = '';                                                                                         // 1938
      while (bigpatch.diffs.length !== 0) {                                                                        // 1939
        // Create one of several smaller patches.                                                                  // 1940
        var patch = new diff_match_patch.patch_obj();                                                              // 1941
        var empty = true;                                                                                          // 1942
        patch.start1 = start1 - precontext.length;                                                                 // 1943
        patch.start2 = start2 - precontext.length;                                                                 // 1944
        if (precontext !== '') {                                                                                   // 1945
          patch.length1 = patch.length2 = precontext.length;                                                       // 1946
          patch.diffs.push([DIFF_EQUAL, precontext]);                                                              // 1947
        }                                                                                                          // 1948
        while (bigpatch.diffs.length !== 0 &&                                                                      // 1949
               patch.length1 < patch_size - this.Patch_Margin) {                                                   // 1950
          var diff_type = bigpatch.diffs[0][0];                                                                    // 1951
          var diff_text = bigpatch.diffs[0][1];                                                                    // 1952
          if (diff_type === DIFF_INSERT) {                                                                         // 1953
            // Insertions are harmless.                                                                            // 1954
            patch.length2 += diff_text.length;                                                                     // 1955
            start2 += diff_text.length;                                                                            // 1956
            patch.diffs.push(bigpatch.diffs.shift());                                                              // 1957
            empty = false;                                                                                         // 1958
          } else if (diff_type === DIFF_DELETE && patch.diffs.length == 1 &&                                       // 1959
                     patch.diffs[0][0] == DIFF_EQUAL &&                                                            // 1960
                     diff_text.length > 2 * patch_size) {                                                          // 1961
            // This is a large deletion.  Let it pass in one chunk.                                                // 1962
            patch.length1 += diff_text.length;                                                                     // 1963
            start1 += diff_text.length;                                                                            // 1964
            empty = false;                                                                                         // 1965
            patch.diffs.push([diff_type, diff_text]);                                                              // 1966
            bigpatch.diffs.shift();                                                                                // 1967
          } else {                                                                                                 // 1968
            // Deletion or equality.  Only take as much as we can stomach.                                         // 1969
            diff_text = diff_text.substring(0,                                                                     // 1970
                patch_size - patch.length1 - this.Patch_Margin);                                                   // 1971
            patch.length1 += diff_text.length;                                                                     // 1972
            start1 += diff_text.length;                                                                            // 1973
            if (diff_type === DIFF_EQUAL) {                                                                        // 1974
              patch.length2 += diff_text.length;                                                                   // 1975
              start2 += diff_text.length;                                                                          // 1976
            } else {                                                                                               // 1977
              empty = false;                                                                                       // 1978
            }                                                                                                      // 1979
            patch.diffs.push([diff_type, diff_text]);                                                              // 1980
            if (diff_text == bigpatch.diffs[0][1]) {                                                               // 1981
              bigpatch.diffs.shift();                                                                              // 1982
            } else {                                                                                               // 1983
              bigpatch.diffs[0][1] =                                                                               // 1984
                  bigpatch.diffs[0][1].substring(diff_text.length);                                                // 1985
            }                                                                                                      // 1986
          }                                                                                                        // 1987
        }                                                                                                          // 1988
        // Compute the head context for the next patch.                                                            // 1989
        precontext = this.diff_text2(patch.diffs);                                                                 // 1990
        precontext =                                                                                               // 1991
            precontext.substring(precontext.length - this.Patch_Margin);                                           // 1992
        // Append the end context for this patch.                                                                  // 1993
        var postcontext = this.diff_text1(bigpatch.diffs)                                                          // 1994
                              .substring(0, this.Patch_Margin);                                                    // 1995
        if (postcontext !== '') {                                                                                  // 1996
          patch.length1 += postcontext.length;                                                                     // 1997
          patch.length2 += postcontext.length;                                                                     // 1998
          if (patch.diffs.length !== 0 &&                                                                          // 1999
              patch.diffs[patch.diffs.length - 1][0] === DIFF_EQUAL) {                                             // 2000
            patch.diffs[patch.diffs.length - 1][1] += postcontext;                                                 // 2001
          } else {                                                                                                 // 2002
            patch.diffs.push([DIFF_EQUAL, postcontext]);                                                           // 2003
          }                                                                                                        // 2004
        }                                                                                                          // 2005
        if (!empty) {                                                                                              // 2006
          patches.splice(++x, 0, patch);                                                                           // 2007
        }                                                                                                          // 2008
      }                                                                                                            // 2009
    }                                                                                                              // 2010
  }                                                                                                                // 2011
};                                                                                                                 // 2012
                                                                                                                   // 2013
                                                                                                                   // 2014
/**                                                                                                                // 2015
 * Take a list of patches and return a textual representation.                                                     // 2016
 * @param {!Array.<!diff_match_patch.patch_obj>} patches Array of patch objects.                                   // 2017
 * @return {string} Text representation of patches.                                                                // 2018
 */                                                                                                                // 2019
diff_match_patch.prototype.patch_toText = function(patches) {                                                      // 2020
  var text = [];                                                                                                   // 2021
  for (var x = 0; x < patches.length; x++) {                                                                       // 2022
    text[x] = patches[x];                                                                                          // 2023
  }                                                                                                                // 2024
  return text.join('');                                                                                            // 2025
};                                                                                                                 // 2026
                                                                                                                   // 2027
                                                                                                                   // 2028
/**                                                                                                                // 2029
 * Parse a textual representation of patches and return a list of patch objects.                                   // 2030
 * @param {string} textline Text representation of patches.                                                        // 2031
 * @return {!Array.<!diff_match_patch.patch_obj>} Array of patch objects.                                          // 2032
 * @throws {!Error} If invalid input.                                                                              // 2033
 */                                                                                                                // 2034
diff_match_patch.prototype.patch_fromText = function(textline) {                                                   // 2035
  var patches = [];                                                                                                // 2036
  if (!textline) {                                                                                                 // 2037
    return patches;                                                                                                // 2038
  }                                                                                                                // 2039
  var text = textline.split('\n');                                                                                 // 2040
  var textPointer = 0;                                                                                             // 2041
  var patchHeader = /^@@ -(\d+),?(\d*) \+(\d+),?(\d*) @@$/;                                                        // 2042
  while (textPointer < text.length) {                                                                              // 2043
    var m = text[textPointer].match(patchHeader);                                                                  // 2044
    if (!m) {                                                                                                      // 2045
      throw new Error('Invalid patch string: ' + text[textPointer]);                                               // 2046
    }                                                                                                              // 2047
    var patch = new diff_match_patch.patch_obj();                                                                  // 2048
    patches.push(patch);                                                                                           // 2049
    patch.start1 = parseInt(m[1], 10);                                                                             // 2050
    if (m[2] === '') {                                                                                             // 2051
      patch.start1--;                                                                                              // 2052
      patch.length1 = 1;                                                                                           // 2053
    } else if (m[2] == '0') {                                                                                      // 2054
      patch.length1 = 0;                                                                                           // 2055
    } else {                                                                                                       // 2056
      patch.start1--;                                                                                              // 2057
      patch.length1 = parseInt(m[2], 10);                                                                          // 2058
    }                                                                                                              // 2059
                                                                                                                   // 2060
    patch.start2 = parseInt(m[3], 10);                                                                             // 2061
    if (m[4] === '') {                                                                                             // 2062
      patch.start2--;                                                                                              // 2063
      patch.length2 = 1;                                                                                           // 2064
    } else if (m[4] == '0') {                                                                                      // 2065
      patch.length2 = 0;                                                                                           // 2066
    } else {                                                                                                       // 2067
      patch.start2--;                                                                                              // 2068
      patch.length2 = parseInt(m[4], 10);                                                                          // 2069
    }                                                                                                              // 2070
    textPointer++;                                                                                                 // 2071
                                                                                                                   // 2072
    while (textPointer < text.length) {                                                                            // 2073
      var sign = text[textPointer].charAt(0);                                                                      // 2074
      try {                                                                                                        // 2075
        var line = decodeURI(text[textPointer].substring(1));                                                      // 2076
      } catch (ex) {                                                                                               // 2077
        // Malformed URI sequence.                                                                                 // 2078
        throw new Error('Illegal escape in patch_fromText: ' + line);                                              // 2079
      }                                                                                                            // 2080
      if (sign == '-') {                                                                                           // 2081
        // Deletion.                                                                                               // 2082
        patch.diffs.push([DIFF_DELETE, line]);                                                                     // 2083
      } else if (sign == '+') {                                                                                    // 2084
        // Insertion.                                                                                              // 2085
        patch.diffs.push([DIFF_INSERT, line]);                                                                     // 2086
      } else if (sign == ' ') {                                                                                    // 2087
        // Minor equality.                                                                                         // 2088
        patch.diffs.push([DIFF_EQUAL, line]);                                                                      // 2089
      } else if (sign == '@') {                                                                                    // 2090
        // Start of next patch.                                                                                    // 2091
        break;                                                                                                     // 2092
      } else if (sign === '') {                                                                                    // 2093
        // Blank line?  Whatever.                                                                                  // 2094
      } else {                                                                                                     // 2095
        // WTF?                                                                                                    // 2096
        throw new Error('Invalid patch mode "' + sign + '" in: ' + line);                                          // 2097
      }                                                                                                            // 2098
      textPointer++;                                                                                               // 2099
    }                                                                                                              // 2100
  }                                                                                                                // 2101
  return patches;                                                                                                  // 2102
};                                                                                                                 // 2103
                                                                                                                   // 2104
                                                                                                                   // 2105
/**                                                                                                                // 2106
 * Class representing one patch operation.                                                                         // 2107
 * @constructor                                                                                                    // 2108
 */                                                                                                                // 2109
diff_match_patch.patch_obj = function() {                                                                          // 2110
  /** @type {!Array.<!diff_match_patch.Diff>} */                                                                   // 2111
  this.diffs = [];                                                                                                 // 2112
  /** @type {?number} */                                                                                           // 2113
  this.start1 = null;                                                                                              // 2114
  /** @type {?number} */                                                                                           // 2115
  this.start2 = null;                                                                                              // 2116
  /** @type {number} */                                                                                            // 2117
  this.length1 = 0;                                                                                                // 2118
  /** @type {number} */                                                                                            // 2119
  this.length2 = 0;                                                                                                // 2120
};                                                                                                                 // 2121
                                                                                                                   // 2122
                                                                                                                   // 2123
/**                                                                                                                // 2124
 * Emmulate GNU diff's format.                                                                                     // 2125
 * Header: @@ -382,8 +481,9 @@                                                                                     // 2126
 * Indicies are printed as 1-based, not 0-based.                                                                   // 2127
 * @return {string} The GNU diff string.                                                                           // 2128
 */                                                                                                                // 2129
diff_match_patch.patch_obj.prototype.toString = function() {                                                       // 2130
  var coords1, coords2;                                                                                            // 2131
  if (this.length1 === 0) {                                                                                        // 2132
    coords1 = this.start1 + ',0';                                                                                  // 2133
  } else if (this.length1 == 1) {                                                                                  // 2134
    coords1 = this.start1 + 1;                                                                                     // 2135
  } else {                                                                                                         // 2136
    coords1 = (this.start1 + 1) + ',' + this.length1;                                                              // 2137
  }                                                                                                                // 2138
  if (this.length2 === 0) {                                                                                        // 2139
    coords2 = this.start2 + ',0';                                                                                  // 2140
  } else if (this.length2 == 1) {                                                                                  // 2141
    coords2 = this.start2 + 1;                                                                                     // 2142
  } else {                                                                                                         // 2143
    coords2 = (this.start2 + 1) + ',' + this.length2;                                                              // 2144
  }                                                                                                                // 2145
  var text = ['@@ -' + coords1 + ' +' + coords2 + ' @@\n'];                                                        // 2146
  var op;                                                                                                          // 2147
  // Escape the body of the patch with %xx notation.                                                               // 2148
  for (var x = 0; x < this.diffs.length; x++) {                                                                    // 2149
    switch (this.diffs[x][0]) {                                                                                    // 2150
      case DIFF_INSERT:                                                                                            // 2151
        op = '+';                                                                                                  // 2152
        break;                                                                                                     // 2153
      case DIFF_DELETE:                                                                                            // 2154
        op = '-';                                                                                                  // 2155
        break;                                                                                                     // 2156
      case DIFF_EQUAL:                                                                                             // 2157
        op = ' ';                                                                                                  // 2158
        break;                                                                                                     // 2159
    }                                                                                                              // 2160
    text[x + 1] = op + encodeURI(this.diffs[x][1]) + '\n';                                                         // 2161
  }                                                                                                                // 2162
  return text.join('').replace(/%20/g, ' ');                                                                       // 2163
};                                                                                                                 // 2164
                                                                                                                   // 2165
                                                                                                                   // 2166
// Export these global variables so that they survive Google's JS compiler.                                        // 2167
// In a browser, 'this' will be 'window'.                                                                          // 2168
// In node.js 'this' will be a global object.                                                                      // 2169
this['diff_match_patch'] = diff_match_patch;                                                                       // 2170
this['DIFF_DELETE'] = DIFF_DELETE;                                                                                 // 2171
this['DIFF_INSERT'] = DIFF_INSERT;                                                                                 // 2172
this['DIFF_EQUAL'] = DIFF_EQUAL;                                                                                   // 2173
                                                                                                                   // 2174
                                                                                                                   // 2175
},{}],3:[function(require,module,exports){                                                                         // 2176
                                                                                                                   // 2177
var Pipe = require('../pipe').Pipe;                                                                                // 2178
                                                                                                                   // 2179
var Context = function Context(){                                                                                  // 2180
};                                                                                                                 // 2181
                                                                                                                   // 2182
Context.prototype.setResult = function(result) {                                                                   // 2183
	this.result = result;                                                                                             // 2184
	this.hasResult = true;                                                                                            // 2185
	return this;                                                                                                      // 2186
};                                                                                                                 // 2187
                                                                                                                   // 2188
Context.prototype.exit = function() {                                                                              // 2189
	this.exiting = true;                                                                                              // 2190
	return this;                                                                                                      // 2191
};                                                                                                                 // 2192
                                                                                                                   // 2193
Context.prototype.switchTo = function(next, pipe) {                                                                // 2194
	if (typeof next === 'string' || next instanceof Pipe) {                                                           // 2195
		this.nextPipe = next;                                                                                            // 2196
	} else {                                                                                                          // 2197
		this.next = next;                                                                                                // 2198
		if (pipe) {                                                                                                      // 2199
			this.nextPipe = pipe;                                                                                           // 2200
		}                                                                                                                // 2201
	}                                                                                                                 // 2202
	return this;                                                                                                      // 2203
};                                                                                                                 // 2204
                                                                                                                   // 2205
Context.prototype.push = function(child, name) {                                                                   // 2206
	child.parent = this;                                                                                              // 2207
	if (typeof name !== 'undefined') {                                                                                // 2208
		child.childName = name;                                                                                          // 2209
	}                                                                                                                 // 2210
	child.root = this.root || this;                                                                                   // 2211
	child.options = child.options || this.options;                                                                    // 2212
	if (!this.children) {                                                                                             // 2213
		this.children = [child];                                                                                         // 2214
		this.nextAfterChildren = this.next || null;                                                                      // 2215
		this.next = child;                                                                                               // 2216
	} else {                                                                                                          // 2217
		this.children[this.children.length - 1].next = child;                                                            // 2218
		this.children.push(child);                                                                                       // 2219
	}                                                                                                                 // 2220
	child.next = this;                                                                                                // 2221
	return this;                                                                                                      // 2222
};                                                                                                                 // 2223
                                                                                                                   // 2224
exports.Context = Context;                                                                                         // 2225
                                                                                                                   // 2226
},{"../pipe":17}],4:[function(require,module,exports){                                                             // 2227
var Context = require('./context').Context;                                                                        // 2228
                                                                                                                   // 2229
var DiffContext = function DiffContext(left, right) {                                                              // 2230
  this.left = left;                                                                                                // 2231
  this.right = right;                                                                                              // 2232
  this.pipe = 'diff';                                                                                              // 2233
};                                                                                                                 // 2234
                                                                                                                   // 2235
DiffContext.prototype = new Context();                                                                             // 2236
                                                                                                                   // 2237
exports.DiffContext = DiffContext;                                                                                 // 2238
                                                                                                                   // 2239
},{"./context":3}],5:[function(require,module,exports){                                                            // 2240
var Context = require('./context').Context;                                                                        // 2241
                                                                                                                   // 2242
var PatchContext = function PatchContext(left, delta) {                                                            // 2243
  this.left = left;                                                                                                // 2244
  this.delta = delta;                                                                                              // 2245
  this.pipe = 'patch';                                                                                             // 2246
};                                                                                                                 // 2247
                                                                                                                   // 2248
PatchContext.prototype = new Context();                                                                            // 2249
                                                                                                                   // 2250
exports.PatchContext = PatchContext;                                                                               // 2251
                                                                                                                   // 2252
},{"./context":3}],6:[function(require,module,exports){                                                            // 2253
var Context = require('./context').Context;                                                                        // 2254
                                                                                                                   // 2255
var ReverseContext = function ReverseContext(delta) {                                                              // 2256
  this.delta = delta;                                                                                              // 2257
  this.pipe = 'reverse';                                                                                           // 2258
};                                                                                                                 // 2259
                                                                                                                   // 2260
ReverseContext.prototype = new Context();                                                                          // 2261
                                                                                                                   // 2262
exports.ReverseContext = ReverseContext;                                                                           // 2263
                                                                                                                   // 2264
},{"./context":3}],7:[function(require,module,exports){                                                            // 2265
// use as 2nd parameter for JSON.parse to revive Date instances                                                    // 2266
module.exports = function dateReviver(key, value) {                                                                // 2267
  var parts;                                                                                                       // 2268
  if (typeof value === 'string') {                                                                                 // 2269
    parts = /^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})(?:\.(\d*))?(Z|([+\-])(\d{2}):(\d{2}))$/.exec(value);
    if (parts) {                                                                                                   // 2271
      return new Date(Date.UTC(+parts[1], +parts[2] - 1, +parts[3], +parts[4], +parts[5], +parts[6], +(parts[7] || 0)));
    }                                                                                                              // 2273
  }                                                                                                                // 2274
  return value;                                                                                                    // 2275
};                                                                                                                 // 2276
                                                                                                                   // 2277
},{}],8:[function(require,module,exports){                                                                         // 2278
var Processor = require('./processor').Processor;                                                                  // 2279
var Pipe = require('./pipe').Pipe;                                                                                 // 2280
var DiffContext = require('./contexts/diff').DiffContext;                                                          // 2281
var PatchContext = require('./contexts/patch').PatchContext;                                                       // 2282
var ReverseContext = require('./contexts/reverse').ReverseContext;                                                 // 2283
                                                                                                                   // 2284
var trivial = require('./filters/trivial');                                                                        // 2285
var nested = require('./filters/nested');                                                                          // 2286
var arrays = require('./filters/arrays');                                                                          // 2287
var dates = require('./filters/dates');                                                                            // 2288
var texts = require('./filters/texts');                                                                            // 2289
                                                                                                                   // 2290
var DiffPatcher = function DiffPatcher(options) {                                                                  // 2291
  this.processor = new Processor(options);                                                                         // 2292
  this.processor.pipe(new Pipe('diff').append(                                                                     // 2293
    nested.collectChildrenDiffFilter,                                                                              // 2294
    trivial.diffFilter,                                                                                            // 2295
    dates.diffFilter,                                                                                              // 2296
    texts.diffFilter,                                                                                              // 2297
    nested.objectsDiffFilter,                                                                                      // 2298
    arrays.diffFilter                                                                                              // 2299
  ).shouldHaveResult());                                                                                           // 2300
  this.processor.pipe(new Pipe('patch').append(                                                                    // 2301
    nested.collectChildrenPatchFilter,                                                                             // 2302
    arrays.collectChildrenPatchFilter,                                                                             // 2303
    trivial.patchFilter,                                                                                           // 2304
    texts.patchFilter,                                                                                             // 2305
    nested.patchFilter,                                                                                            // 2306
    arrays.patchFilter                                                                                             // 2307
  ).shouldHaveResult());                                                                                           // 2308
  this.processor.pipe(new Pipe('reverse').append(                                                                  // 2309
    nested.collectChildrenReverseFilter,                                                                           // 2310
    arrays.collectChildrenReverseFilter,                                                                           // 2311
    trivial.reverseFilter,                                                                                         // 2312
    texts.reverseFilter,                                                                                           // 2313
    nested.reverseFilter,                                                                                          // 2314
    arrays.reverseFilter                                                                                           // 2315
  ).shouldHaveResult());                                                                                           // 2316
};                                                                                                                 // 2317
                                                                                                                   // 2318
DiffPatcher.prototype.options = function() {                                                                       // 2319
  return this.processor.options.apply(this.processor, arguments);                                                  // 2320
};                                                                                                                 // 2321
                                                                                                                   // 2322
DiffPatcher.prototype.diff = function(left, right) {                                                               // 2323
  return this.processor.process(new DiffContext(left, right));                                                     // 2324
};                                                                                                                 // 2325
                                                                                                                   // 2326
DiffPatcher.prototype.patch = function(left, delta) {                                                              // 2327
  return this.processor.process(new PatchContext(left, delta));                                                    // 2328
};                                                                                                                 // 2329
                                                                                                                   // 2330
DiffPatcher.prototype.reverse = function(delta) {                                                                  // 2331
  return this.processor.process(new ReverseContext(delta));                                                        // 2332
};                                                                                                                 // 2333
                                                                                                                   // 2334
DiffPatcher.prototype.unpatch = function(right, delta) {                                                           // 2335
  return this.patch(right, this.reverse(delta));                                                                   // 2336
};                                                                                                                 // 2337
                                                                                                                   // 2338
exports.DiffPatcher = DiffPatcher;                                                                                 // 2339
                                                                                                                   // 2340
},{"./contexts/diff":4,"./contexts/patch":5,"./contexts/reverse":6,"./filters/arrays":10,"./filters/dates":11,"./filters/nested":13,"./filters/texts":14,"./filters/trivial":15,"./pipe":17,"./processor":18}],9:[function(require,module,exports){
                                                                                                                   // 2342
exports.isBrowser = typeof window !== 'undefined';                                                                 // 2343
                                                                                                                   // 2344
},{}],10:[function(require,module,exports){                                                                        // 2345
var DiffContext = require('../contexts/diff').DiffContext;                                                         // 2346
var PatchContext = require('../contexts/patch').PatchContext;                                                      // 2347
var ReverseContext = require('../contexts/reverse').ReverseContext;                                                // 2348
                                                                                                                   // 2349
var lcs = require('./lcs');                                                                                        // 2350
                                                                                                                   // 2351
var ARRAY_MOVE = 3;                                                                                                // 2352
                                                                                                                   // 2353
var isArray = (typeof Array.isArray === 'function') ?                                                              // 2354
  // use native function                                                                                           // 2355
  Array.isArray :                                                                                                  // 2356
  // use instanceof operator                                                                                       // 2357
  function(a) {                                                                                                    // 2358
    return a instanceof Array;                                                                                     // 2359
  };                                                                                                               // 2360
                                                                                                                   // 2361
var arrayIndexOf = typeof Array.prototype.indexOf === 'function' ?                                                 // 2362
  function(array, item) {                                                                                          // 2363
    return array.indexOf(item);                                                                                    // 2364
  } : function(array, item) {                                                                                      // 2365
    var length = array.length;                                                                                     // 2366
    for (var i = 0; i < length; i++) {                                                                             // 2367
      if (array[i] === item) {                                                                                     // 2368
        return i;                                                                                                  // 2369
      }                                                                                                            // 2370
    }                                                                                                              // 2371
    return -1;                                                                                                     // 2372
  };                                                                                                               // 2373
                                                                                                                   // 2374
function arraysHaveMatchByRef(array1, array2, len1, len2) {                                                        // 2375
  for (var index1 = 0; index1 < len1; index1++) {                                                                  // 2376
    var val1 = array1[index1];                                                                                     // 2377
    for (var index2 = 0; index2 < len2; index2++) {                                                                // 2378
      var val2 = array2[index2];                                                                                   // 2379
      if (val1 === val2) {                                                                                         // 2380
        return true;                                                                                               // 2381
      }                                                                                                            // 2382
    }                                                                                                              // 2383
  }                                                                                                                // 2384
}                                                                                                                  // 2385
                                                                                                                   // 2386
function matchItems(array1, array2, index1, index2, context) {                                                     // 2387
  var value1 = array1[index1];                                                                                     // 2388
  var value2 = array2[index2];                                                                                     // 2389
  if (value1 === value2) {                                                                                         // 2390
    return true;                                                                                                   // 2391
  }                                                                                                                // 2392
  if (typeof value1 !== 'object' || typeof value2 !== 'object') {                                                  // 2393
    return false;                                                                                                  // 2394
  }                                                                                                                // 2395
  var objectHash = context.objectHash;                                                                             // 2396
  if (!objectHash) {                                                                                               // 2397
    // no way to match objects was provided, try match by position                                                 // 2398
    return context.matchByPosition && index1 === index2;                                                           // 2399
  }                                                                                                                // 2400
  var hash1;                                                                                                       // 2401
  var hash2;                                                                                                       // 2402
  if (typeof index1 === 'number') {                                                                                // 2403
    context.hashCache1 = context.hashCache1 || [];                                                                 // 2404
    hash1 = context.hashCache1[index1];                                                                            // 2405
    if (typeof hash1 === 'undefined') {                                                                            // 2406
      context.hashCache1[index1] = hash1 = objectHash(value1, index1);                                             // 2407
    }                                                                                                              // 2408
  } else {                                                                                                         // 2409
    hash1 = objectHash(value1);                                                                                    // 2410
  }                                                                                                                // 2411
  if (typeof hash1 === 'undefined') {                                                                              // 2412
    return false;                                                                                                  // 2413
  }                                                                                                                // 2414
  if (typeof index2 === 'number') {                                                                                // 2415
    context.hashCache2 = context.hashCache2 || [];                                                                 // 2416
    hash2 = context.hashCache2[index2];                                                                            // 2417
    if (typeof hash2 === 'undefined') {                                                                            // 2418
      context.hashCache2[index2] = hash2 = objectHash(value2, index2);                                             // 2419
    }                                                                                                              // 2420
  } else {                                                                                                         // 2421
    hash2 = objectHash(value2);                                                                                    // 2422
  }                                                                                                                // 2423
  if (typeof hash2 === 'undefined') {                                                                              // 2424
    return false;                                                                                                  // 2425
  }                                                                                                                // 2426
  return hash1 === hash2;                                                                                          // 2427
}                                                                                                                  // 2428
                                                                                                                   // 2429
var diffFilter = function arraysDiffFilter(context) {                                                              // 2430
  if (!context.leftIsArray) {                                                                                      // 2431
    return;                                                                                                        // 2432
  }                                                                                                                // 2433
                                                                                                                   // 2434
  var matchContext = {                                                                                             // 2435
    objectHash: context.options && context.options.objectHash,                                                     // 2436
    matchByPosition: context.options && context.options.matchByPosition                                            // 2437
  };                                                                                                               // 2438
  var commonHead = 0;                                                                                              // 2439
  var commonTail = 0;                                                                                              // 2440
  var index;                                                                                                       // 2441
  var index1;                                                                                                      // 2442
  var index2;                                                                                                      // 2443
  var array1 = context.left;                                                                                       // 2444
  var array2 = context.right;                                                                                      // 2445
  var len1 = array1.length;                                                                                        // 2446
  var len2 = array2.length;                                                                                        // 2447
                                                                                                                   // 2448
  var child;                                                                                                       // 2449
                                                                                                                   // 2450
  if (len1 > 0 && len2 > 0 && !matchContext.objectHash &&                                                          // 2451
    typeof matchContext.matchByPosition !== 'boolean') {                                                           // 2452
    matchContext.matchByPosition = !arraysHaveMatchByRef(array1, array2, len1, len2);                              // 2453
  }                                                                                                                // 2454
                                                                                                                   // 2455
  // separate common head                                                                                          // 2456
  while (commonHead < len1 && commonHead < len2 &&                                                                 // 2457
    matchItems(array1, array2, commonHead, commonHead, matchContext)) {                                            // 2458
    index = commonHead;                                                                                            // 2459
    child = new DiffContext(context.left[index], context.right[index]);                                            // 2460
    context.push(child, index);                                                                                    // 2461
    commonHead++;                                                                                                  // 2462
  }                                                                                                                // 2463
  // separate common tail                                                                                          // 2464
  while (commonTail + commonHead < len1 && commonTail + commonHead < len2 &&                                       // 2465
    matchItems(array1, array2, len1 - 1 - commonTail, len2 - 1 - commonTail, matchContext)) {                      // 2466
    index1 = len1 - 1 - commonTail;                                                                                // 2467
    index2 = len2 - 1 - commonTail;                                                                                // 2468
    child = new DiffContext(context.left[index1], context.right[index2]);                                          // 2469
    context.push(child, index2);                                                                                   // 2470
    commonTail++;                                                                                                  // 2471
  }                                                                                                                // 2472
  var result;                                                                                                      // 2473
  if (commonHead + commonTail === len1) {                                                                          // 2474
    if (len1 === len2) {                                                                                           // 2475
      // arrays are identical                                                                                      // 2476
      context.setResult(undefined).exit();                                                                         // 2477
      return;                                                                                                      // 2478
    }                                                                                                              // 2479
    // trivial case, a block (1 or more consecutive items) was added                                               // 2480
    result = result || {                                                                                           // 2481
      _t: 'a'                                                                                                      // 2482
    };                                                                                                             // 2483
    for (index = commonHead; index < len2 - commonTail; index++) {                                                 // 2484
      result[index] = [array2[index]];                                                                             // 2485
    }                                                                                                              // 2486
    context.setResult(result).exit();                                                                              // 2487
    return;                                                                                                        // 2488
  }                                                                                                                // 2489
  if (commonHead + commonTail === len2) {                                                                          // 2490
    // trivial case, a block (1 or more consecutive items) was removed                                             // 2491
    result = result || {                                                                                           // 2492
      _t: 'a'                                                                                                      // 2493
    };                                                                                                             // 2494
    for (index = commonHead; index < len1 - commonTail; index++) {                                                 // 2495
      result['_' + index] = [array1[index], 0, 0];                                                                 // 2496
    }                                                                                                              // 2497
    context.setResult(result).exit();                                                                              // 2498
    return;                                                                                                        // 2499
  }                                                                                                                // 2500
  // reset hash cache                                                                                              // 2501
  delete matchContext.hashCache1;                                                                                  // 2502
  delete matchContext.hashCache2;                                                                                  // 2503
                                                                                                                   // 2504
  // diff is not trivial, find the LCS (Longest Common Subsequence)                                                // 2505
  var trimmed1 = array1.slice(commonHead, len1 - commonTail);                                                      // 2506
  var trimmed2 = array2.slice(commonHead, len2 - commonTail);                                                      // 2507
  var seq = lcs.get(                                                                                               // 2508
    trimmed1, trimmed2,                                                                                            // 2509
    matchItems,                                                                                                    // 2510
    matchContext                                                                                                   // 2511
  );                                                                                                               // 2512
  var removedItems = [];                                                                                           // 2513
  result = result || {                                                                                             // 2514
    _t: 'a'                                                                                                        // 2515
  };                                                                                                               // 2516
  for (index = commonHead; index < len1 - commonTail; index++) {                                                   // 2517
    if (arrayIndexOf(seq.indices1, index - commonHead) < 0) {                                                      // 2518
      // removed                                                                                                   // 2519
      result['_' + index] = [array1[index], 0, 0];                                                                 // 2520
      removedItems.push(index);                                                                                    // 2521
    }                                                                                                              // 2522
  }                                                                                                                // 2523
                                                                                                                   // 2524
  var detectMove = true;                                                                                           // 2525
  if (context.options && context.options.arrays && context.options.arrays.detectMove === false) {                  // 2526
    detectMove = false;                                                                                            // 2527
  }                                                                                                                // 2528
  var includeValueOnMove = false;                                                                                  // 2529
  if (context.options && context.options.arrays && context.options.arrays.includeValueOnMove) {                    // 2530
    includeValueOnMove = true;                                                                                     // 2531
  }                                                                                                                // 2532
                                                                                                                   // 2533
  var removedItemsLength = removedItems.length;                                                                    // 2534
  for (index = commonHead; index < len2 - commonTail; index++) {                                                   // 2535
    var indexOnArray2 = arrayIndexOf(seq.indices2, index - commonHead);                                            // 2536
    if (indexOnArray2 < 0) {                                                                                       // 2537
      // added, try to match with a removed item and register as position move                                     // 2538
      var isMove = false;                                                                                          // 2539
      if (detectMove && removedItemsLength > 0) {                                                                  // 2540
        for (var removeItemIndex1 = 0; removeItemIndex1 < removedItemsLength; removeItemIndex1++) {                // 2541
          index1 = removedItems[removeItemIndex1];                                                                 // 2542
          if (matchItems(trimmed1, trimmed2, index1 - commonHead,                                                  // 2543
            index - commonHead, matchContext)) {                                                                   // 2544
            // store position move as: [originalValue, newPosition, ARRAY_MOVE]                                    // 2545
            result['_' + index1].splice(1, 2, index, ARRAY_MOVE);                                                  // 2546
            if (!includeValueOnMove) {                                                                             // 2547
              // don't include moved value on diff, to save bytes                                                  // 2548
              result['_' + index1][0] = '';                                                                        // 2549
            }                                                                                                      // 2550
                                                                                                                   // 2551
            index2 = index;                                                                                        // 2552
            child = new DiffContext(context.left[index1], context.right[index2]);                                  // 2553
            context.push(child, index2);                                                                           // 2554
            removedItems.splice(removeItemIndex1, 1);                                                              // 2555
            isMove = true;                                                                                         // 2556
            break;                                                                                                 // 2557
          }                                                                                                        // 2558
        }                                                                                                          // 2559
      }                                                                                                            // 2560
      if (!isMove) {                                                                                               // 2561
        // added                                                                                                   // 2562
        result[index] = [array2[index]];                                                                           // 2563
      }                                                                                                            // 2564
    } else {                                                                                                       // 2565
      // match, do inner diff                                                                                      // 2566
      index1 = seq.indices1[indexOnArray2] + commonHead;                                                           // 2567
      index2 = seq.indices2[indexOnArray2] + commonHead;                                                           // 2568
      child = new DiffContext(context.left[index1], context.right[index2]);                                        // 2569
      context.push(child, index2);                                                                                 // 2570
    }                                                                                                              // 2571
  }                                                                                                                // 2572
                                                                                                                   // 2573
  context.setResult(result).exit();                                                                                // 2574
                                                                                                                   // 2575
};                                                                                                                 // 2576
diffFilter.filterName = 'arrays';                                                                                  // 2577
                                                                                                                   // 2578
var compare = {                                                                                                    // 2579
  numerically: function(a, b) {                                                                                    // 2580
    return a - b;                                                                                                  // 2581
  },                                                                                                               // 2582
  numericallyBy: function(name) {                                                                                  // 2583
    return function(a, b) {                                                                                        // 2584
      return a[name] - b[name];                                                                                    // 2585
    };                                                                                                             // 2586
  }                                                                                                                // 2587
};                                                                                                                 // 2588
                                                                                                                   // 2589
var patchFilter = function nestedPatchFilter(context) {                                                            // 2590
  if (!context.nested) {                                                                                           // 2591
    return;                                                                                                        // 2592
  }                                                                                                                // 2593
  if (context.delta._t !== 'a') {                                                                                  // 2594
    return;                                                                                                        // 2595
  }                                                                                                                // 2596
  var index, index1;                                                                                               // 2597
                                                                                                                   // 2598
  var delta = context.delta;                                                                                       // 2599
  var array = context.left;                                                                                        // 2600
                                                                                                                   // 2601
  // first, separate removals, insertions and modifications                                                        // 2602
  var toRemove = [];                                                                                               // 2603
  var toInsert = [];                                                                                               // 2604
  var toModify = [];                                                                                               // 2605
  for (index in delta) {                                                                                           // 2606
    if (index !== '_t') {                                                                                          // 2607
      if (index[0] === '_') {                                                                                      // 2608
        // removed item from original array                                                                        // 2609
        if (delta[index][2] === 0 || delta[index][2] === ARRAY_MOVE) {                                             // 2610
          toRemove.push(parseInt(index.slice(1), 10));                                                             // 2611
        } else {                                                                                                   // 2612
          throw new Error('only removal or move can be applied at original array indices' +                        // 2613
            ', invalid diff type: ' + delta[index][2]);                                                            // 2614
        }                                                                                                          // 2615
      } else {                                                                                                     // 2616
        if (delta[index].length === 1) {                                                                           // 2617
          // added item at new array                                                                               // 2618
          toInsert.push({                                                                                          // 2619
            index: parseInt(index, 10),                                                                            // 2620
            value: delta[index][0]                                                                                 // 2621
          });                                                                                                      // 2622
        } else {                                                                                                   // 2623
          // modified item at new array                                                                            // 2624
          toModify.push({                                                                                          // 2625
            index: parseInt(index, 10),                                                                            // 2626
            delta: delta[index]                                                                                    // 2627
          });                                                                                                      // 2628
        }                                                                                                          // 2629
      }                                                                                                            // 2630
    }                                                                                                              // 2631
  }                                                                                                                // 2632
                                                                                                                   // 2633
  // remove items, in reverse order to avoid sawing our own floor                                                  // 2634
  toRemove = toRemove.sort(compare.numerically);                                                                   // 2635
  for (index = toRemove.length - 1; index >= 0; index--) {                                                         // 2636
    index1 = toRemove[index];                                                                                      // 2637
    var indexDiff = delta['_' + index1];                                                                           // 2638
    var removedValue = array.splice(index1, 1)[0];                                                                 // 2639
    if (indexDiff[2] === ARRAY_MOVE) {                                                                             // 2640
      // reinsert later                                                                                            // 2641
      toInsert.push({                                                                                              // 2642
        index: indexDiff[1],                                                                                       // 2643
        value: removedValue                                                                                        // 2644
      });                                                                                                          // 2645
    }                                                                                                              // 2646
  }                                                                                                                // 2647
                                                                                                                   // 2648
  // insert items, in reverse order to avoid moving our own floor                                                  // 2649
  toInsert = toInsert.sort(compare.numericallyBy('index'));                                                        // 2650
  var toInsertLength = toInsert.length;                                                                            // 2651
  for (index = 0; index < toInsertLength; index++) {                                                               // 2652
    var insertion = toInsert[index];                                                                               // 2653
    array.splice(insertion.index, 0, insertion.value);                                                             // 2654
  }                                                                                                                // 2655
                                                                                                                   // 2656
  // apply modifications                                                                                           // 2657
  var toModifyLength = toModify.length;                                                                            // 2658
  var child;                                                                                                       // 2659
  if (toModifyLength > 0) {                                                                                        // 2660
    for (index = 0; index < toModifyLength; index++) {                                                             // 2661
      var modification = toModify[index];                                                                          // 2662
      child = new PatchContext(context.left[modification.index], modification.delta);                              // 2663
      context.push(child, modification.index);                                                                     // 2664
    }                                                                                                              // 2665
  }                                                                                                                // 2666
                                                                                                                   // 2667
  if (!context.children) {                                                                                         // 2668
    context.setResult(context.left).exit();                                                                        // 2669
    return;                                                                                                        // 2670
  }                                                                                                                // 2671
  context.exit();                                                                                                  // 2672
};                                                                                                                 // 2673
patchFilter.filterName = 'arrays';                                                                                 // 2674
                                                                                                                   // 2675
var collectChildrenPatchFilter = function collectChildrenPatchFilter(context) {                                    // 2676
  if (!context || !context.children) {                                                                             // 2677
    return;                                                                                                        // 2678
  }                                                                                                                // 2679
  if (context.delta._t !== 'a') {                                                                                  // 2680
    return;                                                                                                        // 2681
  }                                                                                                                // 2682
  var length = context.children.length;                                                                            // 2683
  var child;                                                                                                       // 2684
  for (var index = 0; index < length; index++) {                                                                   // 2685
    child = context.children[index];                                                                               // 2686
    context.left[child.childName] = child.result;                                                                  // 2687
  }                                                                                                                // 2688
  context.setResult(context.left).exit();                                                                          // 2689
};                                                                                                                 // 2690
collectChildrenPatchFilter.filterName = 'arraysCollectChildren';                                                   // 2691
                                                                                                                   // 2692
var reverseFilter = function arraysReverseFilter(context) {                                                        // 2693
  if (!context.nested) {                                                                                           // 2694
    if (context.delta[2] === ARRAY_MOVE) {                                                                         // 2695
      context.newName = '_' + context.delta[1];                                                                    // 2696
      context.setResult([context.delta[0], parseInt(context.childName.substr(1), 10), ARRAY_MOVE]).exit();         // 2697
    }                                                                                                              // 2698
    return;                                                                                                        // 2699
  }                                                                                                                // 2700
  if (context.delta._t !== 'a') {                                                                                  // 2701
    return;                                                                                                        // 2702
  }                                                                                                                // 2703
  var name, child;                                                                                                 // 2704
  for (name in context.delta) {                                                                                    // 2705
    if (name === '_t') {                                                                                           // 2706
      continue;                                                                                                    // 2707
    }                                                                                                              // 2708
    child = new ReverseContext(context.delta[name]);                                                               // 2709
    context.push(child, name);                                                                                     // 2710
  }                                                                                                                // 2711
  context.exit();                                                                                                  // 2712
};                                                                                                                 // 2713
reverseFilter.filterName = 'arrays';                                                                               // 2714
                                                                                                                   // 2715
var reverseArrayDeltaIndex = function(delta, index, itemDelta) {                                                   // 2716
  if (typeof index === 'string' && index[0] === '_') {                                                             // 2717
    return parseInt(index.substr(1), 10);                                                                          // 2718
  } else if (isArray(itemDelta) && itemDelta[2] === 0) {                                                           // 2719
    return '_' + index;                                                                                            // 2720
  }                                                                                                                // 2721
                                                                                                                   // 2722
  var reverseIndex = +index;                                                                                       // 2723
  for (var deltaIndex in delta) {                                                                                  // 2724
    var deltaItem = delta[deltaIndex];                                                                             // 2725
    if (isArray(deltaItem)) {                                                                                      // 2726
      if (deltaItem[2] === ARRAY_MOVE) {                                                                           // 2727
        var moveFromIndex = parseInt(deltaIndex.substr(1), 10);                                                    // 2728
        var moveToIndex = deltaItem[1];                                                                            // 2729
        if (moveToIndex === +index) {                                                                              // 2730
          return moveFromIndex;                                                                                    // 2731
        }                                                                                                          // 2732
        if (moveFromIndex <= reverseIndex && moveToIndex > reverseIndex) {                                         // 2733
          reverseIndex++;                                                                                          // 2734
        } else if (moveFromIndex >= reverseIndex && moveToIndex < reverseIndex) {                                  // 2735
          reverseIndex--;                                                                                          // 2736
        }                                                                                                          // 2737
      } else if (deltaItem[2] === 0) {                                                                             // 2738
        var deleteIndex = parseInt(deltaIndex.substr(1), 10);                                                      // 2739
        if (deleteIndex <= reverseIndex) {                                                                         // 2740
          reverseIndex++;                                                                                          // 2741
        }                                                                                                          // 2742
      } else if (deltaItem.length === 1 && deltaIndex <= reverseIndex) {                                           // 2743
        reverseIndex--;                                                                                            // 2744
      }                                                                                                            // 2745
    }                                                                                                              // 2746
  }                                                                                                                // 2747
                                                                                                                   // 2748
  return reverseIndex;                                                                                             // 2749
};                                                                                                                 // 2750
                                                                                                                   // 2751
var collectChildrenReverseFilter = function collectChildrenReverseFilter(context) {                                // 2752
  if (!context || !context.children) {                                                                             // 2753
    return;                                                                                                        // 2754
  }                                                                                                                // 2755
  if (context.delta._t !== 'a') {                                                                                  // 2756
    return;                                                                                                        // 2757
  }                                                                                                                // 2758
  var length = context.children.length;                                                                            // 2759
  var child;                                                                                                       // 2760
  var delta = {                                                                                                    // 2761
    _t: 'a'                                                                                                        // 2762
  };                                                                                                               // 2763
                                                                                                                   // 2764
  for (var index = 0; index < length; index++) {                                                                   // 2765
    child = context.children[index];                                                                               // 2766
    var name = child.newName;                                                                                      // 2767
    if (typeof name === 'undefined') {                                                                             // 2768
      name = reverseArrayDeltaIndex(context.delta, child.childName, child.result);                                 // 2769
    }                                                                                                              // 2770
    if (delta[name] !== child.result) {                                                                            // 2771
      delta[name] = child.result;                                                                                  // 2772
    }                                                                                                              // 2773
  }                                                                                                                // 2774
  context.setResult(delta).exit();                                                                                 // 2775
};                                                                                                                 // 2776
collectChildrenReverseFilter.filterName = 'arraysCollectChildren';                                                 // 2777
                                                                                                                   // 2778
exports.diffFilter = diffFilter;                                                                                   // 2779
exports.patchFilter = patchFilter;                                                                                 // 2780
exports.collectChildrenPatchFilter = collectChildrenPatchFilter;                                                   // 2781
exports.reverseFilter = reverseFilter;                                                                             // 2782
exports.collectChildrenReverseFilter = collectChildrenReverseFilter;                                               // 2783
                                                                                                                   // 2784
},{"../contexts/diff":4,"../contexts/patch":5,"../contexts/reverse":6,"./lcs":12}],11:[function(require,module,exports){
var diffFilter = function datesDiffFilter(context) {                                                               // 2786
  if (context.left instanceof Date) {                                                                              // 2787
    if (context.right instanceof Date) {                                                                           // 2788
      if (context.left.getTime() !== context.right.getTime()) {                                                    // 2789
        context.setResult([context.left, context.right]);                                                          // 2790
      } else {                                                                                                     // 2791
        context.setResult(undefined);                                                                              // 2792
      }                                                                                                            // 2793
    } else {                                                                                                       // 2794
      context.setResult([context.left, context.right]);                                                            // 2795
    }                                                                                                              // 2796
    context.exit();                                                                                                // 2797
  } else if (context.right instanceof Date) {                                                                      // 2798
    context.setResult([context.left, context.right]).exit();                                                       // 2799
  }                                                                                                                // 2800
};                                                                                                                 // 2801
diffFilter.filterName = 'dates';                                                                                   // 2802
                                                                                                                   // 2803
exports.diffFilter = diffFilter;                                                                                   // 2804
                                                                                                                   // 2805
},{}],12:[function(require,module,exports){                                                                        // 2806
/*                                                                                                                 // 2807
                                                                                                                   // 2808
LCS implementation that supports arrays or strings                                                                 // 2809
                                                                                                                   // 2810
reference: http://en.wikipedia.org/wiki/Longest_common_subsequence_problem                                         // 2811
                                                                                                                   // 2812
*/                                                                                                                 // 2813
                                                                                                                   // 2814
var defaultMatch = function(array1, array2, index1, index2) {                                                      // 2815
  return array1[index1] === array2[index2];                                                                        // 2816
};                                                                                                                 // 2817
                                                                                                                   // 2818
var lengthMatrix = function(array1, array2, match, context) {                                                      // 2819
  var len1 = array1.length;                                                                                        // 2820
  var len2 = array2.length;                                                                                        // 2821
  var x, y;                                                                                                        // 2822
                                                                                                                   // 2823
  // initialize empty matrix of len1+1 x len2+1                                                                    // 2824
  var matrix = [len1 + 1];                                                                                         // 2825
  for (x = 0; x < len1 + 1; x++) {                                                                                 // 2826
    matrix[x] = [len2 + 1];                                                                                        // 2827
    for (y = 0; y < len2 + 1; y++) {                                                                               // 2828
      matrix[x][y] = 0;                                                                                            // 2829
    }                                                                                                              // 2830
  }                                                                                                                // 2831
  matrix.match = match;                                                                                            // 2832
  // save sequence lengths for each coordinate                                                                     // 2833
  for (x = 1; x < len1 + 1; x++) {                                                                                 // 2834
    for (y = 1; y < len2 + 1; y++) {                                                                               // 2835
      if (match(array1, array2, x - 1, y - 1, context)) {                                                          // 2836
        matrix[x][y] = matrix[x - 1][y - 1] + 1;                                                                   // 2837
      } else {                                                                                                     // 2838
        matrix[x][y] = Math.max(matrix[x - 1][y], matrix[x][y - 1]);                                               // 2839
      }                                                                                                            // 2840
    }                                                                                                              // 2841
  }                                                                                                                // 2842
  return matrix;                                                                                                   // 2843
};                                                                                                                 // 2844
                                                                                                                   // 2845
var backtrack = function(matrix, array1, array2, index1, index2, context) {                                        // 2846
  if (index1 === 0 || index2 === 0) {                                                                              // 2847
    return {                                                                                                       // 2848
      sequence: [],                                                                                                // 2849
      indices1: [],                                                                                                // 2850
      indices2: []                                                                                                 // 2851
    };                                                                                                             // 2852
  }                                                                                                                // 2853
                                                                                                                   // 2854
  if (matrix.match(array1, array2, index1 - 1, index2 - 1, context)) {                                             // 2855
    var subsequence = backtrack(matrix, array1, array2, index1 - 1, index2 - 1, context);                          // 2856
    subsequence.sequence.push(array1[index1 - 1]);                                                                 // 2857
    subsequence.indices1.push(index1 - 1);                                                                         // 2858
    subsequence.indices2.push(index2 - 1);                                                                         // 2859
    return subsequence;                                                                                            // 2860
  }                                                                                                                // 2861
                                                                                                                   // 2862
  if (matrix[index1][index2 - 1] > matrix[index1 - 1][index2]) {                                                   // 2863
    return backtrack(matrix, array1, array2, index1, index2 - 1, context);                                         // 2864
  } else {                                                                                                         // 2865
    return backtrack(matrix, array1, array2, index1 - 1, index2, context);                                         // 2866
  }                                                                                                                // 2867
};                                                                                                                 // 2868
                                                                                                                   // 2869
var get = function(array1, array2, match, context) {                                                               // 2870
  context = context || {};                                                                                         // 2871
  var matrix = lengthMatrix(array1, array2, match || defaultMatch, context);                                       // 2872
  var result = backtrack(matrix, array1, array2, array1.length, array2.length, context);                           // 2873
  if (typeof array1 === 'string' && typeof array2 === 'string') {                                                  // 2874
    result.sequence = result.sequence.join('');                                                                    // 2875
  }                                                                                                                // 2876
  return result;                                                                                                   // 2877
};                                                                                                                 // 2878
                                                                                                                   // 2879
exports.get = get;                                                                                                 // 2880
                                                                                                                   // 2881
},{}],13:[function(require,module,exports){                                                                        // 2882
var DiffContext = require('../contexts/diff').DiffContext;                                                         // 2883
var PatchContext = require('../contexts/patch').PatchContext;                                                      // 2884
var ReverseContext = require('../contexts/reverse').ReverseContext;                                                // 2885
                                                                                                                   // 2886
var collectChildrenDiffFilter = function collectChildrenDiffFilter(context) {                                      // 2887
  if (!context || !context.children) {                                                                             // 2888
    return;                                                                                                        // 2889
  }                                                                                                                // 2890
  var length = context.children.length;                                                                            // 2891
  var child;                                                                                                       // 2892
  var result = context.result;                                                                                     // 2893
  for (var index = 0; index < length; index++) {                                                                   // 2894
    child = context.children[index];                                                                               // 2895
    if (typeof child.result === 'undefined') {                                                                     // 2896
      continue;                                                                                                    // 2897
    }                                                                                                              // 2898
    result = result || {};                                                                                         // 2899
    result[child.childName] = child.result;                                                                        // 2900
  }                                                                                                                // 2901
  if (result && context.leftIsArray) {                                                                             // 2902
    result._t = 'a';                                                                                               // 2903
  }                                                                                                                // 2904
  context.setResult(result).exit();                                                                                // 2905
};                                                                                                                 // 2906
collectChildrenDiffFilter.filterName = 'collectChildren';                                                          // 2907
                                                                                                                   // 2908
var objectsDiffFilter = function objectsDiffFilter(context) {                                                      // 2909
  if (context.leftIsArray || context.leftType !== 'object') {                                                      // 2910
    return;                                                                                                        // 2911
  }                                                                                                                // 2912
                                                                                                                   // 2913
  var name, child;                                                                                                 // 2914
  for (name in context.left) {                                                                                     // 2915
    child = new DiffContext(context.left[name], context.right[name]);                                              // 2916
    context.push(child, name);                                                                                     // 2917
  }                                                                                                                // 2918
  for (name in context.right) {                                                                                    // 2919
    if (typeof context.left[name] === 'undefined') {                                                               // 2920
      child = new DiffContext(undefined, context.right[name]);                                                     // 2921
      context.push(child, name);                                                                                   // 2922
    }                                                                                                              // 2923
  }                                                                                                                // 2924
                                                                                                                   // 2925
  if (!context.children || context.children.length === 0) {                                                        // 2926
    context.setResult(undefined).exit();                                                                           // 2927
    return;                                                                                                        // 2928
  }                                                                                                                // 2929
  context.exit();                                                                                                  // 2930
};                                                                                                                 // 2931
objectsDiffFilter.filterName = 'objects';                                                                          // 2932
                                                                                                                   // 2933
var patchFilter = function nestedPatchFilter(context) {                                                            // 2934
  if (!context.nested) {                                                                                           // 2935
    return;                                                                                                        // 2936
  }                                                                                                                // 2937
  if (context.delta._t) {                                                                                          // 2938
    return;                                                                                                        // 2939
  }                                                                                                                // 2940
  var name, child;                                                                                                 // 2941
  for (name in context.delta) {                                                                                    // 2942
    child = new PatchContext(context.left[name], context.delta[name]);                                             // 2943
    context.push(child, name);                                                                                     // 2944
  }                                                                                                                // 2945
  context.exit();                                                                                                  // 2946
};                                                                                                                 // 2947
patchFilter.filterName = 'objects';                                                                                // 2948
                                                                                                                   // 2949
var collectChildrenPatchFilter = function collectChildrenPatchFilter(context) {                                    // 2950
  if (!context || !context.children) {                                                                             // 2951
    return;                                                                                                        // 2952
  }                                                                                                                // 2953
  if (context.delta._t) {                                                                                          // 2954
    return;                                                                                                        // 2955
  }                                                                                                                // 2956
  var length = context.children.length;                                                                            // 2957
  var child;                                                                                                       // 2958
  for (var index = 0; index < length; index++) {                                                                   // 2959
    child = context.children[index];                                                                               // 2960
    if (context.left.hasOwnProperty(child.childName) && child.result === undefined) {                              // 2961
      delete context.left[child.childName];                                                                        // 2962
    } else if (context.left[child.childName] !== child.result) {                                                   // 2963
      context.left[child.childName] = child.result;                                                                // 2964
    }                                                                                                              // 2965
  }                                                                                                                // 2966
  context.setResult(context.left).exit();                                                                          // 2967
};                                                                                                                 // 2968
collectChildrenPatchFilter.filterName = 'collectChildren';                                                         // 2969
                                                                                                                   // 2970
var reverseFilter = function nestedReverseFilter(context) {                                                        // 2971
  if (!context.nested) {                                                                                           // 2972
    return;                                                                                                        // 2973
  }                                                                                                                // 2974
  if (context.delta._t) {                                                                                          // 2975
    return;                                                                                                        // 2976
  }                                                                                                                // 2977
  var name, child;                                                                                                 // 2978
  for (name in context.delta) {                                                                                    // 2979
    child = new ReverseContext(context.delta[name]);                                                               // 2980
    context.push(child, name);                                                                                     // 2981
  }                                                                                                                // 2982
  context.exit();                                                                                                  // 2983
};                                                                                                                 // 2984
reverseFilter.filterName = 'objects';                                                                              // 2985
                                                                                                                   // 2986
var collectChildrenReverseFilter = function collectChildrenReverseFilter(context) {                                // 2987
  if (!context || !context.children) {                                                                             // 2988
    return;                                                                                                        // 2989
  }                                                                                                                // 2990
  if (context.delta._t) {                                                                                          // 2991
    return;                                                                                                        // 2992
  }                                                                                                                // 2993
  var length = context.children.length;                                                                            // 2994
  var child;                                                                                                       // 2995
  var delta = {};                                                                                                  // 2996
  for (var index = 0; index < length; index++) {                                                                   // 2997
    child = context.children[index];                                                                               // 2998
    if (delta[child.childName] !== child.result) {                                                                 // 2999
      delta[child.childName] = child.result;                                                                       // 3000
    }                                                                                                              // 3001
  }                                                                                                                // 3002
  context.setResult(delta).exit();                                                                                 // 3003
};                                                                                                                 // 3004
collectChildrenReverseFilter.filterName = 'collectChildren';                                                       // 3005
                                                                                                                   // 3006
exports.collectChildrenDiffFilter = collectChildrenDiffFilter;                                  