<?php

use Utopia\Database\Database;
use Utopia\Database\Helpers\ID;

return [
    'databases' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('databases'),
        'name' => 'Databases',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'size' => 256,
                'required' => true,
                'signed' => true,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => false,
                'default' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('originalId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'default' => null,
                'array' => false,
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'attributes' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('attributes'),
        'name' => 'Attributes',
        'attributes' => [
            [
                '$id' => ID::custom('databaseInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('databaseId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('key'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('error'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('size'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('required'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('default'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['casting'],
            ],
            [
                '$id' => ID::custom('signed'),
                'type' => Database::VAR_BOOLEAN,
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('array'),
                'type' => Database::VAR_BOOLEAN,
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('format'),
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('formatOptions'),
                'type' => Database::VAR_STRING,
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => new stdClass(),
                'array' => false,
                'filters' => ['json', 'range', 'enum'],
            ],
            [
                '$id' => ID::custom('filters'),
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('options'),
                'type' => Database::VAR_STRING,
                'size' => 16384,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_db_collection'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['databaseInternalId', 'collectionInternalId'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
        ],
    ],

    'indexes' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('indexes'),
        'name' => 'Indexes',
        'attributes' => [
            [
                '$id' => ID::custom('databaseInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('databaseId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('key'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('error'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('attributes'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('lengths'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('orders'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 4,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_db_collection'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['databaseInternalId', 'collectionInternalId'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
        ],
    ],

    'functions' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('functions'),
        'name' => 'Functions',
        'attributes' => [
            [
                '$id' => ID::custom('execute'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('live'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('installationId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('installationInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerRepositoryId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('repositoryId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('repositoryInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerBranch'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerRootDirectory'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerSilentMode'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => false,
                'default' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('logging'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('runtime'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deployment'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('vars'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryVariables'],
            ],
            [
                '$id' => ID::custom('varsProject'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryProjectVariables'],
            ],
            [
                '$id' => ID::custom('events'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scheduleInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scheduleId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('schedule'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('timeout'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('version'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 8,
                'signed' => true,
                'required' => false,
                'default' => 'v4',
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('entrypoint'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('commands'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('specification'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => false,
                'required' => false,
                'default' => APP_FUNCTION_SPECIFICATION_DEFAULT,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scopes'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_enabled'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['enabled'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_installationId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['installationId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_installationInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['installationInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerRepositoryId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerRepositoryId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_repositoryId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['repositoryId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_repositoryInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['repositoryInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_runtime'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['runtime'],
                'lengths' => [64],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_deployment'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['deployment'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'deployments' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('deployments'),
        'name' => 'Deployments',
        'attributes' => [
            [
                '$id' => ID::custom('resourceInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('buildInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('buildId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('entrypoint'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('commands'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('path'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('installationId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('installationInternalId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerRepositoryId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('repositoryId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('repositoryInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerRepositoryName'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerRepositoryOwner'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerRepositoryUrl'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerCommitHash'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerCommitAuthorUrl'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerCommitAuthor'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerCommitMessage'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerCommitUrl'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerBranch'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerBranchUrl'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerRootDirectory'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('providerCommentId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 2048,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('size'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('metadata'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('chunksTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('chunksUploaded'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('activate'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => false,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_resource'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceId'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_resource_type'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceType'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_size'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['size'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_buildId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['buildId'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_activate'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['activate'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'builds' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('builds'),
        'name' => 'Builds',
        'attributes' => [
            [
                '$id' => ID::custom('startTime'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('endTime'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('duration'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('size'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('runtime'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => 'processing',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('path'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('logs'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('sourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => 'local',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('source'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => '',
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_deployment'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'executions' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('executions'),
        'name' => 'Executions',
        'attributes' => [
            [
                '$id' => ID::custom('functionInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('functionId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('trigger'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('duration'),
                'type' => Database::VAR_FLOAT,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('errors'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('logs'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('requestMethod'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('requestPath'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('requestHeaders'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('responseStatusCode'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('responseHeaders'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scheduledAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('scheduleInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scheduleId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_function'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['functionId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_trigger'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['trigger'],
                'lengths' => [32],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_status'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['status'],
                'lengths' => [32],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_requestMethod'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['requestMethod'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_requestPath'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['requestPath'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_deployment'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_responseStatusCode'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['responseStatusCode'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_duration'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['duration'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'variables' => [
        '$collection' => Database::METADATA,
        '$id' => 'variables',
        'name' => 'variables',
        'attributes' => [
            [
                '$id' => ID::custom('resourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 100,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'key',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'value',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 8192,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt']
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_resourceInternalId',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [],
            ],
            [
                '$id' => '_key_resourceType',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceType'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_resourceId_resourceType',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceId', 'resourceType'],
                'lengths' => [Database::LENGTH_KEY, 100],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_uniqueKey',
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['resourceId', 'key', 'resourceType'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY, 100],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_key',
                'type' => Database::INDEX_KEY,
                'attributes' => ['key'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'migrations' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('migrations'),
        'name' => 'Migrations',
        'attributes' => [
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('stage'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('source'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 8192, // reduce size
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('destination'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false, // make true after patch script
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('credentials'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65536,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => ID::custom('resources'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => [],
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('statusCounters'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 3000,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('resourceData'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 131070,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('errors'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => '_key_status',
                'type' => Database::INDEX_KEY,
                'attributes' => ['status'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_stage',
                'type' => Database::INDEX_KEY,
                'attributes' => ['stage'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_source',
                'type' => Database::INDEX_KEY,
                'attributes' => ['source'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ]
        ],
    ],
];
