<?php

use Utopia\Database\Database;
use Utopia\Database\Helpers\ID;

return [
    'collections' => [
        '$collection' => ID::custom('databases'),
        '$id' => ID::custom('collections'),
        'name' => 'Collections',
        'attributes' => [
            [
                '$id' => ID::custom('databaseInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('databaseId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'size' => 256,
                'required' => true,
                'signed' => true,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('documentSecurity'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('attributes'),
                'type' => Database::VAR_STRING,
                'size' => 1000000,
                'required' => false,
                'signed' => true,
                'array' => false,
                'filters' => ['subQueryAttributes'],
            ],
            [
                '$id' => ID::custom('indexes'),
                'type' => Database::VAR_STRING,
                'size' => 1000000,
                'required' => false,
                'signed' => true,
                'array' => false,
                'filters' => ['subQueryIndexes'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_enabled'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['enabled'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_documentSecurity'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['documentSecurity'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ]
];
