//
//
/*
    Copyright (C) 2002-2009, Hammersmith Imanet Ltd
    Copyright (C) 2018 - , Univeristy College London
    This file is part of STIR.

    SPDX-License-Identifier: Apache-2.0

    See STIR/LICENSE.txt for details
*/
/*!

  \file
  \ingroup InterfileIO
  \brief Implementation of class stir::InterfileParametricDiscretisedDensityOutputFileFormat

  \author Kris Thielemans
  \author Richard Brown

*/

#include "stir/IO/InterfileParametricDiscretisedDensityOutputFileFormat.h"
#include "stir/modelling/KineticParameters.h"
#include "stir/modelling/ParametricDiscretisedDensity.h"
#include "stir/NumericType.h"
#include "stir/Succeeded.h"
#include "stir/IO/interfile.h"
#include "stir/warning.h"

START_NAMESPACE_STIR

//#define TEMPLATE template <int num_dimensions, typename elemT>
#define TEMPLATE template <typename DiscDensityT>
//#define InterfileParamDiscDensity InterfileParametricDiscretisedDensityOutputFileFormat<num_dimensions,elemT>
#define InterfileParamDiscDensity InterfileParametricDiscretisedDensityOutputFileFormat<DiscDensityT>

TEMPLATE
const char* const InterfileParamDiscDensity::registered_name = "Interfile";

TEMPLATE
InterfileParamDiscDensity::InterfileParametricDiscretisedDensityOutputFileFormat(const NumericType& type,
                                                                                 const ByteOrder& byte_order)
{
  base_type::set_defaults();
  this->set_type_of_numbers(type);
  this->set_byte_order(byte_order);
}

TEMPLATE
void
InterfileParamDiscDensity::set_defaults()
{
  base_type::set_defaults();
}

TEMPLATE
void
InterfileParamDiscDensity::initialise_keymap()
{
  this->parser.add_start_key("Interfile Output File Format Parameters");
  this->parser.add_stop_key("End Interfile Output File Format Parameters");
  base_type::initialise_keymap();
}

TEMPLATE
bool
InterfileParamDiscDensity::post_processing()
{
  if (base_type::post_processing())
    return true;
  return false;
}

TEMPLATE
ByteOrder
InterfileParamDiscDensity::set_byte_order(const ByteOrder& new_byte_order, const bool warn)
{
  if (!new_byte_order.is_native_order())
    {
      if (warn)
        warning("InterfileParametricDiscretisedDensityOutputFileFormat: byte_order is currently fixed to the native format\n");
      this->file_byte_order = ByteOrder::native;
    }
  else
    this->file_byte_order = new_byte_order;
  return this->file_byte_order;
}

TEMPLATE
Succeeded
InterfileParamDiscDensity::actual_write_to_file(std::string& filename,
                                                const ParametricDiscretisedDensity<DiscDensityT>& density) const
{
  // TODO modify write_basic_interfile to return filename
  Succeeded success
      = write_basic_interfile(filename, density, this->type_of_numbers, this->scale_to_write_data, this->file_byte_order);
  if (success == Succeeded::yes)
    replace_extension(filename, ".hv");
  return success;
}

#undef ParamDiscDensity
#undef TEMPLATE

template class InterfileParametricDiscretisedDensityOutputFileFormat<ParametricVoxelsOnCartesianGridBaseType>;

END_NAMESPACE_STIR
