---
title: Home
hide:
  - navigation
---

# Welcome

Welcome to the documentation of [KitchenOwl](https://kitchenowl.org). 
If you want to contribute or set up a self-hosted instance of KitchenOwl you're at the right place. 
Otherwise, you can find general information and features on the [main website](https://kitchenowl.org).

<div class="grid cards" markdown>

-   :material-rocket-launch: &nbsp;
    __Getting Started__

    ---

    Looking to set up your own a KitchenOwl instance?
    
    ---

    [:octicons-arrow-right-24: Self hosting guide](./self-hosting/index.md)

-   :material-chat-question: &nbsp;
    __FAQ__

    ---

    Get answers to frequently asked questions.

    ---

    [:octicons-arrow-right-24: Read more](./Tips-&-Tricks/index.md)

-   :material-folder: &nbsp;
    __Reference__

    ---

    Learn more about the API and how to manage your instance<br/><br/>

    ---

    [:octicons-arrow-right-24: Read more](./reference/API.md)

-   :material-license: &nbsp;
    __AGPL-3.0 License__

    ---

    KitchenOwl is Free Software: You can use, study share and improve it at your will.

    ---

    [:octicons-arrow-right-24: Read the License](https://github.com/TomBursch/kitchenowl/blob/main/LICENSE)

</div>

## Future Features

For a list of planned features check out the [Project Board](https://github.com/users/TomBursch/projects/1).

---

## Found an issue?

KitchenOwl is actively maintained.

There are multiple ways in which you can improve KitchenOwl to help you and others who might encounter the same issues in the future.

<div class="grid cards" markdown>

-   :material-bug-outline: &nbsp;
    __Something is not working?__

    ---

    Report a bug by creating an issue with information on how to reproduce it
    
    ---

    [:octicons-arrow-right-24: Report a bug](https://github.com/TomBursch/kitchenowl/issues/new?template=bug.yml)

-   :material-file-document-remove-outline: &nbsp;
    __Missing information in our docs?__

    ---

    Report missing information or potential inconsistencies in our
    documentation

    ---

    [:octicons-arrow-right-24: Report a docs issue](https://github.com/TomBursch/kitchenowl/issues/new?template=wiki_issue.yml)

-   :material-lightbulb-on-20: &nbsp;
    __Want to submit an idea?__

    ---

    Propose a change, feature request, or suggest an improvement

    ---

    [:octicons-arrow-right-24: Request a change](https://github.com/TomBursch/kitchenowl/issues/new/choose)

-   :material-source-pull: &nbsp;
    __Want to create a pull request?__

    ---

    Open an issue first and then create a comprehensive and useful pull request

    ---

    [:octicons-arrow-right-24: Set up your development environment](./reference/contributing.md)<br/>
    [:octicons-arrow-right-24: Create a pull request](https://github.com/TomBursch/kitchenowl/pulls)

</div>

!!! info "Hint"
    Before submitting an issue, make sure to:

    - Check that no similar issue already exists [here](https://github.com/TomBursch/kitchenowl/issues)
    - You provided all information needed to understand the issue

---
